/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SuggestFuzziness
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SuggestFuzziness> {
    @Nonnull
    private final String fuzziness;
    private final int minLength;
    private final int prefixLength;
    private final boolean transpositions;
    private final boolean unicodeAware;
    public static final JsonpDeserializer<SuggestFuzziness> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SuggestFuzziness::setupSuggestFuzzinessDeserializer);

    private SuggestFuzziness(Builder builder) {
        this.fuzziness = ApiTypeHelper.requireNonNull(builder.fuzziness, this, "fuzziness");
        this.minLength = ApiTypeHelper.requireNonNull(builder.minLength, this, "minLength");
        this.prefixLength = ApiTypeHelper.requireNonNull(builder.prefixLength, this, "prefixLength");
        this.transpositions = ApiTypeHelper.requireNonNull(builder.transpositions, this, "transpositions");
        this.unicodeAware = ApiTypeHelper.requireNonNull(builder.unicodeAware, this, "unicodeAware");
    }

    public static SuggestFuzziness of(Function<Builder, ObjectBuilder<SuggestFuzziness>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String fuzziness() {
        return this.fuzziness;
    }

    public final int minLength() {
        return this.minLength;
    }

    public final int prefixLength() {
        return this.prefixLength;
    }

    public final boolean transpositions() {
        return this.transpositions;
    }

    public final boolean unicodeAware() {
        return this.unicodeAware;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fuzziness");
        generator.write(this.fuzziness);
        generator.writeKey("min_length");
        generator.write(this.minLength);
        generator.writeKey("prefix_length");
        generator.write(this.prefixLength);
        generator.writeKey("transpositions");
        generator.write(this.transpositions);
        generator.writeKey("unicode_aware");
        generator.write(this.unicodeAware);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSuggestFuzzinessDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness");
        op.add(Builder::minLength, JsonpDeserializer.integerDeserializer(), "min_length");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::transpositions, JsonpDeserializer.booleanDeserializer(), "transpositions");
        op.add(Builder::unicodeAware, JsonpDeserializer.booleanDeserializer(), "unicode_aware");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.fuzziness.hashCode();
        result = 31 * result + Integer.hashCode(this.minLength);
        result = 31 * result + Integer.hashCode(this.prefixLength);
        result = 31 * result + Boolean.hashCode(this.transpositions);
        result = 31 * result + Boolean.hashCode(this.unicodeAware);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggestFuzziness other = (SuggestFuzziness)o;
        return this.fuzziness.equals(other.fuzziness) && this.minLength == other.minLength && this.prefixLength == other.prefixLength && this.transpositions == other.transpositions && this.unicodeAware == other.unicodeAware;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SuggestFuzziness> {
        private String fuzziness;
        private Integer minLength;
        private Integer prefixLength;
        private Boolean transpositions;
        private Boolean unicodeAware;

        public Builder() {
        }

        private Builder(SuggestFuzziness o) {
            this.fuzziness = o.fuzziness;
            this.minLength = o.minLength;
            this.prefixLength = o.prefixLength;
            this.transpositions = o.transpositions;
            this.unicodeAware = o.unicodeAware;
        }

        private Builder(Builder o) {
            this.fuzziness = o.fuzziness;
            this.minLength = o.minLength;
            this.prefixLength = o.prefixLength;
            this.transpositions = o.transpositions;
            this.unicodeAware = o.unicodeAware;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder fuzziness(String value) {
            this.fuzziness = value;
            return this;
        }

        @Nonnull
        public final Builder minLength(int value) {
            this.minLength = value;
            return this;
        }

        @Nonnull
        public final Builder prefixLength(int value) {
            this.prefixLength = value;
            return this;
        }

        @Nonnull
        public final Builder transpositions(boolean value) {
            this.transpositions = value;
            return this;
        }

        @Nonnull
        public final Builder unicodeAware(boolean value) {
            this.unicodeAware = value;
            return this;
        }

        @Override
        @Nonnull
        public SuggestFuzziness build() {
            this._checkSingleUse();
            return new SuggestFuzziness(this);
        }
    }
}

