/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitterFactory;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitter;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.InternalConstants;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ManifestCommitterFactory
extends PathOutputCommitterFactory {
    public static final String NAME = ManifestCommitterFactory.class.getName();

    @Override
    public ManifestCommitter createOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        String scheme = outputPath.toUri().getScheme();
        if (InternalConstants.UNSUPPORTED_FS_SCHEMAS.contains(scheme)) {
            throw new PathIOException(outputPath.toString(), "This committer does not work with the filesystem of type " + scheme);
        }
        return new ManifestCommitter(outputPath, context);
    }
}

