/**
 * ./src/classes/keyboards.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti (modified)
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IXkbLayout, IXkbModel, IXkbOption, IXkbVariant } from '../interfaces/i-xkb-model.js';
/**
 * Keyboard class - reads and manages X11 keyboard configuration
 */
export default class Keyboard {
    layouts: IXkbLayout[];
    models: IXkbModel[];
    options: IXkbOption[];
    variants: IXkbVariant[];
    private defaultKeyboardFile;
    private xorgLstFile;
    constructor();
    private parseXorgLst;
    private setDefaults;
    private readKeyboardConfig;
    getLayout(): Promise<string>;
    getLayouts(): IXkbLayout[];
    getModel(): Promise<string>;
    getModels(): IXkbModel[];
    getOption(): Promise<string>;
    getOptions(): IXkbOption[];
    getVariant(): Promise<string>;
    getVariants(layout: string): IXkbVariant[];
}
