// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from esp32p4.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Espressif

//go:build esp && esp32p4

/*
// 32-bit RISC-V MCU
*/
//     Copyright 2024 Espressif Systems (Shanghai) PTE LTD Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
package esp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ESP32-P4"
	CPU          = "RV32IMAFC"
	FPUPresent   = true
	NVICPrioBits = 0
)

// Interrupt numbers.
const (
	// Low-power Watchdog Timer
	IRQ_LP_WDT = 1

	// Low-power Timer
	IRQ_LP_TIMER0 = 2

	// Low-power Timer
	IRQ_LP_TIMER1 = 3

	// PMU Peripheral
	IRQ_PMU0 = 6

	// PMU Peripheral
	IRQ_PMU1 = 7

	// LP_ANA_PERI Peripheral
	IRQ_LP_ANA = 8

	// Low-power Analog to Digital Converter
	IRQ_LP_ADC = 9

	// Low-power General Purpose Input/Output
	IRQ_LP_GPIO = 10

	// Low-power I2C (Inter-Integrated Circuit) Controller 0
	IRQ_LP_I2C0 = 11

	// Low-power I2S (Inter-IC Sound) Controller 0
	IRQ_LP_I2S0 = 12

	// LP_TOUCH Peripheral
	IRQ_LP_TOUCH = 14

	// Low-power Temperature Sensor
	IRQ_LP_TSENS = 15

	// Low-power UART (Universal Asynchronous Receiver-Transmitter) Controller
	IRQ_LP_UART = 16

	// LP_SYS Peripheral
	IRQ_LP_SYS = 19

	// LP_HUK Peripheral
	IRQ_LP_HUK = 20

	// Full-speed USB Serial/JTAG Controller
	IRQ_USB_DEVICE = 22

	// DMA (Direct Memory Access) Controller
	IRQ_DMA = 24

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_SPI2 = 25

	// SPI (Serial Peripheral Interface) Controller 3
	IRQ_SPI3 = 26

	// I2S (Inter-IC Sound) Controller 0
	IRQ_I2S0 = 27

	// I2S (Inter-IC Sound) Controller 1
	IRQ_I2S1 = 28

	// I2S (Inter-IC Sound) Controller 2
	IRQ_I2S2 = 29

	// Universal Host Controller Interface 0
	IRQ_UHCI0 = 30

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	IRQ_UART0 = 31

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	IRQ_UART1 = 32

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 2
	IRQ_UART2 = 33

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 3
	IRQ_UART3 = 34

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 4
	IRQ_UART4 = 35

	// Motor Control Pulse-Width Modulation 0
	IRQ_PWM0 = 38

	// Motor Control Pulse-Width Modulation 1
	IRQ_PWM1 = 39

	// Two-Wire Automotive Interface
	IRQ_TWAI0 = 40

	// Two-Wire Automotive Interface
	IRQ_TWAI1 = 41

	// Two-Wire Automotive Interface
	IRQ_TWAI2 = 42

	// Remote Control
	IRQ_RMT = 43

	// I2C (Inter-Integrated Circuit) Controller 0
	IRQ_I2C0 = 44

	// I2C (Inter-Integrated Circuit) Controller 1
	IRQ_I2C1 = 45

	// Timer Group 0
	IRQ_TG0_T0 = 46

	// Timer Group 0
	IRQ_TG0_T1 = 47

	// Timer Group 0
	IRQ_TG0_WDT = 48

	// Timer Group 1
	IRQ_TG1_T0 = 49

	// Timer Group 1
	IRQ_TG1_T1 = 50

	// Timer Group 1
	IRQ_TG1_WDT = 51

	// LED Control PWM (Pulse Width Modulation)
	IRQ_LEDC = 52

	// System Timer
	IRQ_SYSTIMER_TARGET0 = 53

	// System Timer
	IRQ_SYSTIMER_TARGET1 = 54

	// System Timer
	IRQ_SYSTIMER_TARGET2 = 55

	// AHB_DMA Peripheral
	IRQ_AHB_PDMA_IN_CH0 = 56

	// AHB_DMA Peripheral
	IRQ_AHB_PDMA_IN_CH1 = 57

	// AHB_DMA Peripheral
	IRQ_AHB_PDMA_IN_CH2 = 58

	// AHB_DMA Peripheral
	IRQ_AHB_PDMA_OUT_CH0 = 59

	// AHB_DMA Peripheral
	IRQ_AHB_PDMA_OUT_CH1 = 60

	// AHB_DMA Peripheral
	IRQ_AHB_PDMA_OUT_CH2 = 61

	// AHB_DMA Peripheral
	IRQ_AXI_PDMA_IN_CH0 = 62

	// AHB_DMA Peripheral
	IRQ_AXI_PDMA_IN_CH1 = 63

	// AHB_DMA Peripheral
	IRQ_AXI_PDMA_IN_CH2 = 64

	// AHB_DMA Peripheral
	IRQ_AXI_PDMA_OUT_CH0 = 65

	// AHB_DMA Peripheral
	IRQ_AXI_PDMA_OUT_CH1 = 66

	// AHB_DMA Peripheral
	IRQ_AXI_PDMA_OUT_CH2 = 67

	// RSA (Rivest Shamir Adleman) Accelerator
	IRQ_RSA = 68

	// AES (Advanced Encryption Standard) Accelerator
	IRQ_AES = 69

	// SHA (Secure Hash Algorithm) Accelerator
	IRQ_SHA = 70

	// ECC (ECC Hardware Accelerator)
	IRQ_ECC = 71

	// General Purpose Input/Output
	IRQ_GPIO_INT0 = 74

	// General Purpose Input/Output
	IRQ_GPIO_INT1 = 75

	// General Purpose Input/Output
	IRQ_GPIO_INT2 = 76

	// General Purpose Input/Output
	IRQ_GPIO_INT3 = 77

	// General Purpose Input/Output
	IRQ_GPIO_PAD_COMP = 78

	// CACHE Peripheral
	IRQ_CACHE = 83

	// MIPI Camera Interface Bridge
	IRQ_CSI_BRIDGE = 85

	// MIPI Camera Interface Bridge
	IRQ_DSI_BRIDGE = 86

	// MIPI Camera Interface Host
	IRQ_CSI = 87

	// MIPI Display Interface Host
	IRQ_DSI = 88

	// JPEG Codec
	IRQ_JPEG = 95

	// PPA Peripheral
	IRQ_PPA = 96

	// ISP Peripheral
	IRQ_ISP = 100

	// I3C Controller (Master)
	IRQ_I3C = 101

	// I3C Controller (Slave)
	IRQ_I3C_SLV = 102

	// High-Power System
	IRQ_HP_SYS = 110

	// Pulse Count Controller
	IRQ_PCNT = 111

	// PAU Peripheral
	IRQ_PAU = 112

	// Parallel IO Controller
	IRQ_PARLIO_RX = 113

	// Parallel IO Controller
	IRQ_PARLIO_TX = 114

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_OUT_CH0 = 115

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_OUT_CH1 = 116

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_OUT_CH2 = 117

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_OUT_CH3 = 118

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_OUT_CH4 = 119

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_IN_CH0 = 120

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_IN_CH1 = 121

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_IN_CH2 = 122

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_IN_CH3 = 123

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_IN_CH4 = 124

	// H264 Encoder (DMA)
	IRQ_H264_DMA2D_IN_CH5 = 125

	// H264 Encoder (Core)
	IRQ_H264_REG = 126

	// Debug Assist
	IRQ_ASSIST_DEBUG = 127

	// Highest interrupt number on this device.
	IRQ_max = 127
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	case IRQ_LP_WDT:
		callHandlers(IRQ_LP_WDT)
	case IRQ_LP_TIMER0:
		callHandlers(IRQ_LP_TIMER0)
	case IRQ_LP_TIMER1:
		callHandlers(IRQ_LP_TIMER1)
	case IRQ_PMU0:
		callHandlers(IRQ_PMU0)
	case IRQ_PMU1:
		callHandlers(IRQ_PMU1)
	case IRQ_LP_ANA:
		callHandlers(IRQ_LP_ANA)
	case IRQ_LP_ADC:
		callHandlers(IRQ_LP_ADC)
	case IRQ_LP_GPIO:
		callHandlers(IRQ_LP_GPIO)
	case IRQ_LP_I2C0:
		callHandlers(IRQ_LP_I2C0)
	case IRQ_LP_I2S0:
		callHandlers(IRQ_LP_I2S0)
	case IRQ_LP_TOUCH:
		callHandlers(IRQ_LP_TOUCH)
	case IRQ_LP_TSENS:
		callHandlers(IRQ_LP_TSENS)
	case IRQ_LP_UART:
		callHandlers(IRQ_LP_UART)
	case IRQ_LP_SYS:
		callHandlers(IRQ_LP_SYS)
	case IRQ_LP_HUK:
		callHandlers(IRQ_LP_HUK)
	case IRQ_USB_DEVICE:
		callHandlers(IRQ_USB_DEVICE)
	case IRQ_DMA:
		callHandlers(IRQ_DMA)
	case IRQ_SPI2:
		callHandlers(IRQ_SPI2)
	case IRQ_SPI3:
		callHandlers(IRQ_SPI3)
	case IRQ_I2S0:
		callHandlers(IRQ_I2S0)
	case IRQ_I2S1:
		callHandlers(IRQ_I2S1)
	case IRQ_I2S2:
		callHandlers(IRQ_I2S2)
	case IRQ_UHCI0:
		callHandlers(IRQ_UHCI0)
	case IRQ_UART0:
		callHandlers(IRQ_UART0)
	case IRQ_UART1:
		callHandlers(IRQ_UART1)
	case IRQ_UART2:
		callHandlers(IRQ_UART2)
	case IRQ_UART3:
		callHandlers(IRQ_UART3)
	case IRQ_UART4:
		callHandlers(IRQ_UART4)
	case IRQ_PWM0:
		callHandlers(IRQ_PWM0)
	case IRQ_PWM1:
		callHandlers(IRQ_PWM1)
	case IRQ_TWAI0:
		callHandlers(IRQ_TWAI0)
	case IRQ_TWAI1:
		callHandlers(IRQ_TWAI1)
	case IRQ_TWAI2:
		callHandlers(IRQ_TWAI2)
	case IRQ_RMT:
		callHandlers(IRQ_RMT)
	case IRQ_I2C0:
		callHandlers(IRQ_I2C0)
	case IRQ_I2C1:
		callHandlers(IRQ_I2C1)
	case IRQ_TG0_T0:
		callHandlers(IRQ_TG0_T0)
	case IRQ_TG0_T1:
		callHandlers(IRQ_TG0_T1)
	case IRQ_TG0_WDT:
		callHandlers(IRQ_TG0_WDT)
	case IRQ_TG1_T0:
		callHandlers(IRQ_TG1_T0)
	case IRQ_TG1_T1:
		callHandlers(IRQ_TG1_T1)
	case IRQ_TG1_WDT:
		callHandlers(IRQ_TG1_WDT)
	case IRQ_LEDC:
		callHandlers(IRQ_LEDC)
	case IRQ_SYSTIMER_TARGET0:
		callHandlers(IRQ_SYSTIMER_TARGET0)
	case IRQ_SYSTIMER_TARGET1:
		callHandlers(IRQ_SYSTIMER_TARGET1)
	case IRQ_SYSTIMER_TARGET2:
		callHandlers(IRQ_SYSTIMER_TARGET2)
	case IRQ_AHB_PDMA_IN_CH0:
		callHandlers(IRQ_AHB_PDMA_IN_CH0)
	case IRQ_AHB_PDMA_IN_CH1:
		callHandlers(IRQ_AHB_PDMA_IN_CH1)
	case IRQ_AHB_PDMA_IN_CH2:
		callHandlers(IRQ_AHB_PDMA_IN_CH2)
	case IRQ_AHB_PDMA_OUT_CH0:
		callHandlers(IRQ_AHB_PDMA_OUT_CH0)
	case IRQ_AHB_PDMA_OUT_CH1:
		callHandlers(IRQ_AHB_PDMA_OUT_CH1)
	case IRQ_AHB_PDMA_OUT_CH2:
		callHandlers(IRQ_AHB_PDMA_OUT_CH2)
	case IRQ_AXI_PDMA_IN_CH0:
		callHandlers(IRQ_AXI_PDMA_IN_CH0)
	case IRQ_AXI_PDMA_IN_CH1:
		callHandlers(IRQ_AXI_PDMA_IN_CH1)
	case IRQ_AXI_PDMA_IN_CH2:
		callHandlers(IRQ_AXI_PDMA_IN_CH2)
	case IRQ_AXI_PDMA_OUT_CH0:
		callHandlers(IRQ_AXI_PDMA_OUT_CH0)
	case IRQ_AXI_PDMA_OUT_CH1:
		callHandlers(IRQ_AXI_PDMA_OUT_CH1)
	case IRQ_AXI_PDMA_OUT_CH2:
		callHandlers(IRQ_AXI_PDMA_OUT_CH2)
	case IRQ_RSA:
		callHandlers(IRQ_RSA)
	case IRQ_AES:
		callHandlers(IRQ_AES)
	case IRQ_SHA:
		callHandlers(IRQ_SHA)
	case IRQ_ECC:
		callHandlers(IRQ_ECC)
	case IRQ_GPIO_INT0:
		callHandlers(IRQ_GPIO_INT0)
	case IRQ_GPIO_INT1:
		callHandlers(IRQ_GPIO_INT1)
	case IRQ_GPIO_INT2:
		callHandlers(IRQ_GPIO_INT2)
	case IRQ_GPIO_INT3:
		callHandlers(IRQ_GPIO_INT3)
	case IRQ_GPIO_PAD_COMP:
		callHandlers(IRQ_GPIO_PAD_COMP)
	case IRQ_CACHE:
		callHandlers(IRQ_CACHE)
	case IRQ_CSI_BRIDGE:
		callHandlers(IRQ_CSI_BRIDGE)
	case IRQ_DSI_BRIDGE:
		callHandlers(IRQ_DSI_BRIDGE)
	case IRQ_CSI:
		callHandlers(IRQ_CSI)
	case IRQ_DSI:
		callHandlers(IRQ_DSI)
	case IRQ_JPEG:
		callHandlers(IRQ_JPEG)
	case IRQ_PPA:
		callHandlers(IRQ_PPA)
	case IRQ_ISP:
		callHandlers(IRQ_ISP)
	case IRQ_I3C:
		callHandlers(IRQ_I3C)
	case IRQ_I3C_SLV:
		callHandlers(IRQ_I3C_SLV)
	case IRQ_HP_SYS:
		callHandlers(IRQ_HP_SYS)
	case IRQ_PCNT:
		callHandlers(IRQ_PCNT)
	case IRQ_PAU:
		callHandlers(IRQ_PAU)
	case IRQ_PARLIO_RX:
		callHandlers(IRQ_PARLIO_RX)
	case IRQ_PARLIO_TX:
		callHandlers(IRQ_PARLIO_TX)
	case IRQ_H264_DMA2D_OUT_CH0:
		callHandlers(IRQ_H264_DMA2D_OUT_CH0)
	case IRQ_H264_DMA2D_OUT_CH1:
		callHandlers(IRQ_H264_DMA2D_OUT_CH1)
	case IRQ_H264_DMA2D_OUT_CH2:
		callHandlers(IRQ_H264_DMA2D_OUT_CH2)
	case IRQ_H264_DMA2D_OUT_CH3:
		callHandlers(IRQ_H264_DMA2D_OUT_CH3)
	case IRQ_H264_DMA2D_OUT_CH4:
		callHandlers(IRQ_H264_DMA2D_OUT_CH4)
	case IRQ_H264_DMA2D_IN_CH0:
		callHandlers(IRQ_H264_DMA2D_IN_CH0)
	case IRQ_H264_DMA2D_IN_CH1:
		callHandlers(IRQ_H264_DMA2D_IN_CH1)
	case IRQ_H264_DMA2D_IN_CH2:
		callHandlers(IRQ_H264_DMA2D_IN_CH2)
	case IRQ_H264_DMA2D_IN_CH3:
		callHandlers(IRQ_H264_DMA2D_IN_CH3)
	case IRQ_H264_DMA2D_IN_CH4:
		callHandlers(IRQ_H264_DMA2D_IN_CH4)
	case IRQ_H264_DMA2D_IN_CH5:
		callHandlers(IRQ_H264_DMA2D_IN_CH5)
	case IRQ_H264_REG:
		callHandlers(IRQ_H264_REG)
	case IRQ_ASSIST_DEBUG:
		callHandlers(IRQ_ASSIST_DEBUG)
	}
}

// Peripherals.
var (
	// ADC (Analog to Digital Converter)
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x500de000)))

	// AES (Advanced Encryption Standard) Accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x50090000)))

	// AHB_DMA Peripheral
	AHB_DMA = (*AHB_DMA_Type)(unsafe.Pointer(uintptr(0x50085000)))

	// LP_I2C_ANA_MST Peripheral
	LP_I2C_ANA_MST = (*ANA_I2C_MST_Type)(unsafe.Pointer(uintptr(0x50124000)))

	// Debug Assist
	ASSIST_DEBUG = (*ASSIST_DEBUG_Type)(unsafe.Pointer(uintptr(0x3ff06000)))

	// AXI_DMA Peripheral
	AXI_DMA = (*AXI_DMA_Type)(unsafe.Pointer(uintptr(0x5008a000)))

	// BITSCRAMBLER Peripheral
	BITSCRAMBLER = (*BITSCRAMBLER_Type)(unsafe.Pointer(uintptr(0x500a3000)))

	// CACHE Peripheral
	CACHE = (*CACHE_Type)(unsafe.Pointer(uintptr(0x3ff10000)))

	// Interrupt Controller (Core 0)
	INTERRUPT_CORE0 = (*CORE0_Type)(unsafe.Pointer(uintptr(0x500d6000)))

	// Interrupt Controller (Core 1)
	INTERRUPT_CORE1 = (*CORE1_Type)(unsafe.Pointer(uintptr(0x500d6800)))

	// MIPI Camera Interface Bridge
	MIPI_CSI_BRIDGE = (*CSI_BRIG_Type)(unsafe.Pointer(uintptr(0x5009f800)))

	// MIPI Camera Interface Host
	MIPI_CSI_HOST = (*CSI_HOST_Type)(unsafe.Pointer(uintptr(0x5009f000)))

	// DMA (Direct Memory Access) Controller
	DMA = (*DMAC_Type)(unsafe.Pointer(uintptr(0x50081000)))

	// Digital Signature
	DS = (*DS_Type)(unsafe.Pointer(uintptr(0x50094000)))

	// MIPI Camera Interface Bridge
	MIPI_DSI_BRIDGE = (*DSI_BRG_Type)(unsafe.Pointer(uintptr(0x500a0800)))

	// MIPI Display Interface Host
	MIPI_DSI_HOST = (*DSI_HOST_Type)(unsafe.Pointer(uintptr(0x500a0000)))

	// ECC (ECC Hardware Accelerator)
	ECC = (*ECC_Type)(unsafe.Pointer(uintptr(0x50093000)))

	// ECDSA (Elliptic Curve Digital Signature Algorithm) Accelerator
	ECDSA = (*ECDSA_Type)(unsafe.Pointer(uintptr(0x50096000)))

	// eFuse Controller
	EFUSE = (*EFUSE_Type)(unsafe.Pointer(uintptr(0x5012d000)))

	// General Purpose Input/Output
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x500e0000)))

	// Sigma-Delta Modulation
	GPIO_SD = (*GPIOSD_Type)(unsafe.Pointer(uintptr(0x500e0f00)))

	// H264 Encoder (Core)
	H264 = (*H264_Type)(unsafe.Pointer(uintptr(0x50084000)))

	// H264 Encoder (DMA)
	H264_DMA = (*H264_DMA_Type)(unsafe.Pointer(uintptr(0x500a7000)))

	// HMAC (Hash-based Message Authentication Code) Accelerator
	HMAC = (*HMAC_Type)(unsafe.Pointer(uintptr(0x50095000)))

	// High-Power System
	HP_SYS = (*HP_SYS_Type)(unsafe.Pointer(uintptr(0x500e5000)))

	// HP_SYS_CLKRST Peripheral
	HP_SYS_CLKRST = (*HP_SYS_CLKRST_Type)(unsafe.Pointer(uintptr(0x500e6000)))

	// LP_HUK Peripheral
	LP_HUK = (*HUK_Type)(unsafe.Pointer(uintptr(0x50114000)))

	// I2C (Inter-Integrated Circuit) Controller 0
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x500c4000)))

	// I2S (Inter-IC Sound) Controller 0
	I2S0 = (*I2S_Type)(unsafe.Pointer(uintptr(0x500c6000)))

	// I3C Controller (Master)
	I3C_MST = (*I3C_MST_Type)(unsafe.Pointer(uintptr(0x500da000)))

	// I3C_MST_MEM Peripheral
	I3C_MST_MEM = (*I3C_MST_MEM_Type)(unsafe.Pointer(uintptr(0x500da000)))

	// I3C Controller (Slave)
	I3C_SLV = (*I3C_SLV_Type)(unsafe.Pointer(uintptr(0x500db000)))

	// AXI_ICM Peripheral
	AXI_ICM = (*ICM_AXI_Type)(unsafe.Pointer(uintptr(0x500a4000)))

	// Input/Output Multiplexer
	IO_MUX = (*IO_MUX_Type)(unsafe.Pointer(uintptr(0x500e1000)))

	// ISP Peripheral
	ISP = (*ISP_Type)(unsafe.Pointer(uintptr(0x500a1000)))

	// JPEG Codec
	JPEG = (*JPEG_Type)(unsafe.Pointer(uintptr(0x50086000)))

	// Camera/LCD Controller
	LCD_CAM = (*LCDCAM_Type)(unsafe.Pointer(uintptr(0x500dc000)))

	// LED Control PWM (Pulse Width Modulation)
	LEDC = (*LEDC_Type)(unsafe.Pointer(uintptr(0x500d3000)))

	// Low-power Interrupt Controller
	LP_INTR = (*LPINTR_Type)(unsafe.Pointer(uintptr(0x5012c000)))

	// LP_PERI Peripheral
	LP_PERI = (*LPPERI_Type)(unsafe.Pointer(uintptr(0x50120000)))

	// LP_SYS Peripheral
	LP_SYS = (*LPSYSREG_Type)(unsafe.Pointer(uintptr(0x50110000)))

	// LP_ANA_PERI Peripheral
	LP_ANA_PERI = (*LP_ANA_PERI_Type)(unsafe.Pointer(uintptr(0x50113000)))

	// LP_AON_CLKRST Peripheral
	LP_AON_CLKRST = (*LP_AON_CLKRST_Type)(unsafe.Pointer(uintptr(0x50111000)))

	// Low-power General Purpose Input/Output
	LP_GPIO = (*LP_GPIO_Type)(unsafe.Pointer(uintptr(0x5012a000)))

	// Low-power I2C (Inter-Integrated Circuit) Controller 0
	LP_I2C0 = (*LP_I2C_Type)(unsafe.Pointer(uintptr(0x50122000)))

	// Low-power I2S (Inter-IC Sound) Controller 0
	LP_I2S0 = (*LP_I2S_Type)(unsafe.Pointer(uintptr(0x50125000)))

	// Low-power Input/Output Multiplexer
	LP_IO_MUX = (*LP_IOMUX_Type)(unsafe.Pointer(uintptr(0x5012b000)))

	// Low-power UART (Universal Asynchronous Receiver-Transmitter) Controller
	LP_UART = (*LP_UART_Type)(unsafe.Pointer(uintptr(0x50121000)))

	// Motor Control Pulse-Width Modulation 0
	MCPWM0 = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x500c0000)))

	// Parallel IO Controller
	PARL_IO = (*PARL_IO_Type)(unsafe.Pointer(uintptr(0x500cf000)))

	// PAU Peripheral
	PAU = (*PAU_Type)(unsafe.Pointer(uintptr(0x60093000)))

	// Pulse Count Controller
	PCNT = (*PCNT_Type)(unsafe.Pointer(uintptr(0x500c9000)))

	// PMU Peripheral
	PMU = (*PMU_Type)(unsafe.Pointer(uintptr(0x50115000)))

	// PPA Peripheral
	PPA = (*PPA_Type)(unsafe.Pointer(uintptr(0x50087000)))

	// PVT Peripheral
	PVT = (*PVT_Type)(unsafe.Pointer(uintptr(0x5009e000)))

	// Remote Control
	RMT = (*RMT_Type)(unsafe.Pointer(uintptr(0x500d4000)))

	// RSA (Rivest Shamir Adleman) Accelerator
	RSA = (*RSA_Type)(unsafe.Pointer(uintptr(0x50092000)))

	// Low-power Analog to Digital Converter
	LP_ADC = (*RTCADC_Type)(unsafe.Pointer(uintptr(0x50127000)))

	// Low-power Timer
	LP_TIMER = (*RTC_TIMER_Type)(unsafe.Pointer(uintptr(0x50112000)))

	// LP_TOUCH Peripheral
	LP_TOUCH = (*RTC_TOUCH_Type)(unsafe.Pointer(uintptr(0x50128000)))

	// Low-power Watchdog Timer
	LP_WDT = (*RTC_WDT_Type)(unsafe.Pointer(uintptr(0x50116000)))

	// SD/MMC Host Controller
	SDHOST = (*SDHOST_Type)(unsafe.Pointer(uintptr(0x50083000)))

	// SHA (Secure Hash Algorithm) Accelerator
	SHA = (*SHA_Type)(unsafe.Pointer(uintptr(0x50091000)))

	// Event Task Matrix
	SOC_ETM = (*SOC_ETM_Type)(unsafe.Pointer(uintptr(0x500d5000)))

	// SPI (Serial Peripheral Interface) Controller 0
	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x5008c000)))

	// SPI (Serial Peripheral Interface) Controller 1
	SPI1 = (*SPI1_Type)(unsafe.Pointer(uintptr(0x5008d000)))

	// SPI (Serial Peripheral Interface) Controller 2
	SPI2 = (*SPI2_Type)(unsafe.Pointer(uintptr(0x500d0000)))

	// SPI (Serial Peripheral Interface) Controller 3
	SPI3 = (*SPI3_Type)(unsafe.Pointer(uintptr(0x500d1000)))

	// System Timer
	SYSTIMER = (*SYSTIMER_Type)(unsafe.Pointer(uintptr(0x500e2000)))

	// Timer Group 0
	TIMG0 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x500c2000)))

	// TRACE0 Peripheral
	TRACE0 = (*TRACE_Type)(unsafe.Pointer(uintptr(0x3ff04000)))

	// Low-power Temperature Sensor
	LP_TSENS = (*TSENS_Type)(unsafe.Pointer(uintptr(0x5012f000)))

	// Two-Wire Automotive Interface
	TWAI0 = (*TWAI_Type)(unsafe.Pointer(uintptr(0x500d7000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x500ca000)))

	// Universal Host Controller Interface 0
	UHCI0 = (*UHCI_Type)(unsafe.Pointer(uintptr(0x500df000)))

	// Full-speed USB Serial/JTAG Controller
	USB_DEVICE = (*USB_DEVICE_Type)(unsafe.Pointer(uintptr(0x500d2000)))

	// USB_WRAP Peripheral
	USB_WRAP = (*USB_WRAP_Type)(unsafe.Pointer(uintptr(0x50080000)))

	// I2C (Inter-Integrated Circuit) Controller 1
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x500c5000)))

	// I2S (Inter-IC Sound) Controller 1
	I2S1 = (*I2S_Type)(unsafe.Pointer(uintptr(0x500c7000)))

	// I2S (Inter-IC Sound) Controller 2
	I2S2 = (*I2S_Type)(unsafe.Pointer(uintptr(0x500c8000)))

	// Motor Control Pulse-Width Modulation 1
	MCPWM1 = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x500c1000)))

	// Timer Group 1
	TIMG1 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x500c3000)))

	// TRACE1 Peripheral
	TRACE1 = (*TRACE_Type)(unsafe.Pointer(uintptr(0x3ff05000)))

	// Two-Wire Automotive Interface
	TWAI1 = (*TWAI_Type)(unsafe.Pointer(uintptr(0x500d8000)))

	// Two-Wire Automotive Interface
	TWAI2 = (*TWAI_Type)(unsafe.Pointer(uintptr(0x500d9000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x500cb000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 2
	UART2 = (*UART_Type)(unsafe.Pointer(uintptr(0x500cc000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 3
	UART3 = (*UART_Type)(unsafe.Pointer(uintptr(0x500cd000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 4
	UART4 = (*UART_Type)(unsafe.Pointer(uintptr(0x500ce000)))
)

// ADC (Analog to Digital Converter)
type ADC_Type struct {
	CTRL             volatile.Register32 // 0x0
	CTRL2            volatile.Register32 // 0x4
	FILTER_CTRL1     volatile.Register32 // 0x8
	FSM_WAIT         volatile.Register32 // 0xC
	SAR1_STATUS      volatile.Register32 // 0x10
	SAR2_STATUS      volatile.Register32 // 0x14
	SAR1_PATT_TAB1   volatile.Register32 // 0x18
	SAR1_PATT_TAB2   volatile.Register32 // 0x1C
	SAR1_PATT_TAB3   volatile.Register32 // 0x20
	SAR1_PATT_TAB4   volatile.Register32 // 0x24
	SAR2_PATT_TAB1   volatile.Register32 // 0x28
	SAR2_PATT_TAB2   volatile.Register32 // 0x2C
	SAR2_PATT_TAB3   volatile.Register32 // 0x30
	SAR2_PATT_TAB4   volatile.Register32 // 0x34
	ARB_CTRL         volatile.Register32 // 0x38
	FILTER_CTRL0     volatile.Register32 // 0x3C
	SAR1_DATA_STATUS volatile.Register32 // 0x40
	THRES0_CTRL      volatile.Register32 // 0x44
	THRES1_CTRL      volatile.Register32 // 0x48
	THRES_CTRL       volatile.Register32 // 0x4C
	INT_ENA          volatile.Register32 // 0x50
	INT_RAW          volatile.Register32 // 0x54
	INT_ST           volatile.Register32 // 0x58
	INT_CLR          volatile.Register32 // 0x5C
	DMA_CONF         volatile.Register32 // 0x60
	SAR2_DATA_STATUS volatile.Register32 // 0x64
	CALI             volatile.Register32 // 0x68
	RND_ECO_LOW      volatile.Register32 // 0x6C
	RND_ECO_HIGH     volatile.Register32 // 0x70
	RND_ECO_CS       volatile.Register32 // 0x74
	_                [900]byte
	CTRL_DATE        volatile.Register32 // 0x3FC
}

// ADC.CTRL: Register
func (o *ADC_Type) SetCTRL_START_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCTRL_START_FORCE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *ADC_Type) SetCTRL_START(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCTRL_START() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCTRL_WORK_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc)|value<<2)
}
func (o *ADC_Type) GetCTRL_WORK_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc) >> 2
}
func (o *ADC_Type) SetCTRL_SAR_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCTRL_SAR_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCTRL_SAR_CLK_GATED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCTRL_SAR_CLK_GATED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCTRL_SAR_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3fc0)|value<<6)
}
func (o *ADC_Type) GetCTRL_SAR_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x3fc0) >> 6
}
func (o *ADC_Type) SetCTRL_SAR1_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3c000)|value<<14)
}
func (o *ADC_Type) GetCTRL_SAR1_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x3c000) >> 14
}
func (o *ADC_Type) SetCTRL_SAR2_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3c0000)|value<<18)
}
func (o *ADC_Type) GetCTRL_SAR2_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x3c0000) >> 18
}
func (o *ADC_Type) SetCTRL_SAR1_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCTRL_SAR1_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCTRL_SAR2_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCTRL_SAR2_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCTRL_DATA_SAR_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCTRL_DATA_SAR_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCTRL_DATA_TO_I2S(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCTRL_DATA_TO_I2S() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCTRL_XPD_SAR1_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc000000)|value<<26)
}
func (o *ADC_Type) GetCTRL_XPD_SAR1_FORCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc000000) >> 26
}
func (o *ADC_Type) SetCTRL_XPD_SAR2_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetCTRL_XPD_SAR2_FORCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetCTRL_WAIT_ARB_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc0000000)|value<<30)
}
func (o *ADC_Type) GetCTRL_WAIT_ARB_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc0000000) >> 30
}

// ADC.CTRL2: Register
func (o *ADC_Type) SetCTRL2_MEAS_NUM_LIMIT(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCTRL2_MEAS_NUM_LIMIT() uint32 {
	return volatile.LoadUint32(&o.CTRL2.Reg) & 0x1
}
func (o *ADC_Type) SetCTRL2_MAX_MEAS_NUM(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1fe)|value<<1)
}
func (o *ADC_Type) GetCTRL2_MAX_MEAS_NUM() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1fe) >> 1
}
func (o *ADC_Type) SetCTRL2_SAR1_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCTRL2_SAR1_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCTRL2_SAR2_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCTRL2_SAR2_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCTRL2_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCTRL2_TIMER_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCTRL2_TIMER_TARGET(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0xfff000)|value<<12)
}
func (o *ADC_Type) GetCTRL2_TIMER_TARGET() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0xfff000) >> 12
}
func (o *ADC_Type) SetCTRL2_TIMER_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCTRL2_TIMER_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1000000) >> 24
}

// ADC.FILTER_CTRL1: Register
func (o *ADC_Type) SetFILTER_CTRL1_FILTER_FACTOR1(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL1.Reg, volatile.LoadUint32(&o.FILTER_CTRL1.Reg)&^(0x1c000000)|value<<26)
}
func (o *ADC_Type) GetFILTER_CTRL1_FILTER_FACTOR1() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL1.Reg) & 0x1c000000) >> 26
}
func (o *ADC_Type) SetFILTER_CTRL1_FILTER_FACTOR0(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL1.Reg, volatile.LoadUint32(&o.FILTER_CTRL1.Reg)&^(0xe0000000)|value<<29)
}
func (o *ADC_Type) GetFILTER_CTRL1_FILTER_FACTOR0() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL1.Reg) & 0xe0000000) >> 29
}

// ADC.FSM_WAIT: Register
func (o *ADC_Type) SetFSM_WAIT_XPD_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetFSM_WAIT_XPD_WAIT() uint32 {
	return volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff
}
func (o *ADC_Type) SetFSM_WAIT_RSTB_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetFSM_WAIT_RSTB_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetFSM_WAIT_STANDBY_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetFSM_WAIT_STANDBY_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff0000) >> 16
}

// ADC.SAR1_STATUS: Register
func (o *ADC_Type) SetSAR1_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR1_STATUS.Reg, value)
}
func (o *ADC_Type) GetSAR1_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR1_STATUS.Reg)
}

// ADC.SAR2_STATUS: Register
func (o *ADC_Type) SetSAR2_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR2_STATUS.Reg, value)
}
func (o *ADC_Type) GetSAR2_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR2_STATUS.Reg)
}

// ADC.SAR1_PATT_TAB1: Register
func (o *ADC_Type) SetSAR1_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB1.Reg, volatile.LoadUint32(&o.SAR1_PATT_TAB1.Reg)&^(0xffffff)|value)
}
func (o *ADC_Type) GetSAR1_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB1.Reg) & 0xffffff
}

// ADC.SAR1_PATT_TAB2: Register
func (o *ADC_Type) SetSAR1_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB2.Reg, volatile.LoadUint32(&o.SAR1_PATT_TAB2.Reg)&^(0xffffff)|value)
}
func (o *ADC_Type) GetSAR1_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB2.Reg) & 0xffffff
}

// ADC.SAR1_PATT_TAB3: Register
func (o *ADC_Type) SetSAR1_PATT_TAB3(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB3.Reg, volatile.LoadUint32(&o.SAR1_PATT_TAB3.Reg)&^(0xffffff)|value)
}
func (o *ADC_Type) GetSAR1_PATT_TAB3() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB3.Reg) & 0xffffff
}

// ADC.SAR1_PATT_TAB4: Register
func (o *ADC_Type) SetSAR1_PATT_TAB4(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB4.Reg, volatile.LoadUint32(&o.SAR1_PATT_TAB4.Reg)&^(0xffffff)|value)
}
func (o *ADC_Type) GetSAR1_PATT_TAB4() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB4.Reg) & 0xffffff
}

// ADC.SAR2_PATT_TAB1: Register
func (o *ADC_Type) SetSAR2_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB1.Reg, volatile.LoadUint32(&o.SAR2_PATT_TAB1.Reg)&^(0xffffff)|value)
}
func (o *ADC_Type) GetSAR2_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB1.Reg) & 0xffffff
}

// ADC.SAR2_PATT_TAB2: Register
func (o *ADC_Type) SetSAR2_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB2.Reg, volatile.LoadUint32(&o.SAR2_PATT_TAB2.Reg)&^(0xffffff)|value)
}
func (o *ADC_Type) GetSAR2_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB2.Reg) & 0xffffff
}

// ADC.SAR2_PATT_TAB3: Register
func (o *ADC_Type) SetSAR2_PATT_TAB3(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB3.Reg, volatile.LoadUint32(&o.SAR2_PATT_TAB3.Reg)&^(0xffffff)|value)
}
func (o *ADC_Type) GetSAR2_PATT_TAB3() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB3.Reg) & 0xffffff
}

// ADC.SAR2_PATT_TAB4: Register
func (o *ADC_Type) SetSAR2_PATT_TAB4(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB4.Reg, volatile.LoadUint32(&o.SAR2_PATT_TAB4.Reg)&^(0xffffff)|value)
}
func (o *ADC_Type) GetSAR2_PATT_TAB4() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB4.Reg) & 0xffffff
}

// ADC.ARB_CTRL: Register
func (o *ADC_Type) SetARB_CTRL_ARB_APB_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetARB_CTRL_ARB_APB_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetARB_CTRL_ARB_RTC_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetARB_CTRL_ARB_RTC_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetARB_CTRL_ARB_WIFI_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetARB_CTRL_ARB_WIFI_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetARB_CTRL_ARB_GRANT_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetARB_CTRL_ARB_GRANT_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetARB_CTRL_ARB_APB_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0xc0)|value<<6)
}
func (o *ADC_Type) GetARB_CTRL_ARB_APB_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0xc0) >> 6
}
func (o *ADC_Type) SetARB_CTRL_ARB_RTC_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *ADC_Type) GetARB_CTRL_ARB_RTC_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x300) >> 8
}
func (o *ADC_Type) SetARB_CTRL_ARB_WIFI_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetARB_CTRL_ARB_WIFI_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetARB_CTRL_ARB_FIX_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetARB_CTRL_ARB_FIX_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x1000) >> 12
}

// ADC.FILTER_CTRL0: Register
func (o *ADC_Type) SetFILTER_CTRL0_FILTER_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x7c000)|value<<14)
}
func (o *ADC_Type) GetFILTER_CTRL0_FILTER_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x7c000) >> 14
}
func (o *ADC_Type) SetFILTER_CTRL0_FILTER_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0xf80000)|value<<19)
}
func (o *ADC_Type) GetFILTER_CTRL0_FILTER_CHANNEL0() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0xf80000) >> 19
}
func (o *ADC_Type) SetFILTER_CTRL0_FILTER_RESET(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetFILTER_CTRL0_FILTER_RESET() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x80000000) >> 31
}

// ADC.SAR1_DATA_STATUS: Register
func (o *ADC_Type) SetSAR1_DATA_STATUS_APB_SARADC1_DATA(value uint32) {
	volatile.StoreUint32(&o.SAR1_DATA_STATUS.Reg, volatile.LoadUint32(&o.SAR1_DATA_STATUS.Reg)&^(0x1ffff)|value)
}
func (o *ADC_Type) GetSAR1_DATA_STATUS_APB_SARADC1_DATA() uint32 {
	return volatile.LoadUint32(&o.SAR1_DATA_STATUS.Reg) & 0x1ffff
}

// ADC.THRES0_CTRL: Register
func (o *ADC_Type) SetTHRES0_CTRL_THRES0_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetTHRES0_CTRL_THRES0_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x1f
}
func (o *ADC_Type) SetTHRES0_CTRL_THRES0_HIGH(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x3ffe0)|value<<5)
}
func (o *ADC_Type) GetTHRES0_CTRL_THRES0_HIGH() uint32 {
	return (volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x3ffe0) >> 5
}
func (o *ADC_Type) SetTHRES0_CTRL_THRES0_LOW(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x7ffc0000)|value<<18)
}
func (o *ADC_Type) GetTHRES0_CTRL_THRES0_LOW() uint32 {
	return (volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x7ffc0000) >> 18
}

// ADC.THRES1_CTRL: Register
func (o *ADC_Type) SetTHRES1_CTRL_THRES1_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetTHRES1_CTRL_THRES1_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x1f
}
func (o *ADC_Type) SetTHRES1_CTRL_THRES1_HIGH(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x3ffe0)|value<<5)
}
func (o *ADC_Type) GetTHRES1_CTRL_THRES1_HIGH() uint32 {
	return (volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x3ffe0) >> 5
}
func (o *ADC_Type) SetTHRES1_CTRL_THRES1_LOW(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x7ffc0000)|value<<18)
}
func (o *ADC_Type) GetTHRES1_CTRL_THRES1_LOW() uint32 {
	return (volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x7ffc0000) >> 18
}

// ADC.THRES_CTRL: Register
func (o *ADC_Type) SetTHRES_CTRL_THRES_ALL_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetTHRES_CTRL_THRES_ALL_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetTHRES_CTRL_THRES3_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetTHRES_CTRL_THRES3_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetTHRES_CTRL_THRES2_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetTHRES_CTRL_THRES2_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetTHRES_CTRL_THRES1_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetTHRES_CTRL_THRES1_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetTHRES_CTRL_THRES0_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetTHRES_CTRL_THRES0_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x80000000) >> 31
}

// ADC.INT_ENA: Register
func (o *ADC_Type) SetINT_ENA_THRES1_LOW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetINT_ENA_THRES1_LOW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetINT_ENA_THRES0_LOW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetINT_ENA_THRES0_LOW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetINT_ENA_THRES1_HIGH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetINT_ENA_THRES1_HIGH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetINT_ENA_THRES0_HIGH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetINT_ENA_THRES0_HIGH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetINT_ENA_SAR2_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetINT_ENA_SAR2_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetINT_ENA_SAR1_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetINT_ENA_SAR1_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000000) >> 31
}

// ADC.INT_RAW: Register
func (o *ADC_Type) SetINT_RAW_THRES1_LOW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetINT_RAW_THRES1_LOW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetINT_RAW_THRES0_LOW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetINT_RAW_THRES0_LOW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetINT_RAW_THRES1_HIGH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetINT_RAW_THRES1_HIGH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetINT_RAW_THRES0_HIGH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetINT_RAW_THRES0_HIGH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetINT_RAW_SAR2_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetINT_RAW_SAR2_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetINT_RAW_SAR1_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetINT_RAW_SAR1_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000000) >> 31
}

// ADC.INT_ST: Register
func (o *ADC_Type) SetINT_ST_THRES1_LOW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetINT_ST_THRES1_LOW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetINT_ST_THRES0_LOW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetINT_ST_THRES0_LOW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetINT_ST_THRES1_HIGH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetINT_ST_THRES1_HIGH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetINT_ST_THRES0_HIGH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetINT_ST_THRES0_HIGH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetINT_ST_APB_SARADC2_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetINT_ST_APB_SARADC2_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetINT_ST_APB_SARADC1_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetINT_ST_APB_SARADC1_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000000) >> 31
}

// ADC.INT_CLR: Register
func (o *ADC_Type) SetINT_CLR_THRES1_LOW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetINT_CLR_THRES1_LOW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetINT_CLR_THRES0_LOW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetINT_CLR_THRES0_LOW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetINT_CLR_THRES1_HIGH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetINT_CLR_THRES1_HIGH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000000) >> 28
}
func (o *ADC_Type) SetINT_CLR_THRES0_HIGH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20000000)|value<<29)
}
func (o *ADC_Type) GetINT_CLR_THRES0_HIGH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20000000) >> 29
}
func (o *ADC_Type) SetINT_CLR_APB_SARADC2_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetINT_CLR_APB_SARADC2_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetINT_CLR_APB_SARADC1_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetINT_CLR_APB_SARADC1_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000000) >> 31
}

// ADC.DMA_CONF: Register
func (o *ADC_Type) SetDMA_CONF_APB_ADC_EOF_NUM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDMA_CONF_APB_ADC_EOF_NUM() uint32 {
	return volatile.LoadUint32(&o.DMA_CONF.Reg) & 0xffff
}
func (o *ADC_Type) SetDMA_CONF_APB_ADC_RESET_FSM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDMA_CONF_APB_ADC_RESET_FSM() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDMA_CONF_APB_ADC_TRANS(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDMA_CONF_APB_ADC_TRANS() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x80000000) >> 31
}

// ADC.SAR2_DATA_STATUS: Register
func (o *ADC_Type) SetSAR2_DATA_STATUS_APB_SARADC2_DATA(value uint32) {
	volatile.StoreUint32(&o.SAR2_DATA_STATUS.Reg, volatile.LoadUint32(&o.SAR2_DATA_STATUS.Reg)&^(0x1ffff)|value)
}
func (o *ADC_Type) GetSAR2_DATA_STATUS_APB_SARADC2_DATA() uint32 {
	return volatile.LoadUint32(&o.SAR2_DATA_STATUS.Reg) & 0x1ffff
}

// ADC.CALI: Register
func (o *ADC_Type) SetCALI_CFG(value uint32) {
	volatile.StoreUint32(&o.CALI.Reg, volatile.LoadUint32(&o.CALI.Reg)&^(0x1ffff)|value)
}
func (o *ADC_Type) GetCALI_CFG() uint32 {
	return volatile.LoadUint32(&o.CALI.Reg) & 0x1ffff
}

// ADC.RND_ECO_LOW: Register
func (o *ADC_Type) SetRND_ECO_LOW(value uint32) {
	volatile.StoreUint32(&o.RND_ECO_LOW.Reg, value)
}
func (o *ADC_Type) GetRND_ECO_LOW() uint32 {
	return volatile.LoadUint32(&o.RND_ECO_LOW.Reg)
}

// ADC.RND_ECO_HIGH: Register
func (o *ADC_Type) SetRND_ECO_HIGH(value uint32) {
	volatile.StoreUint32(&o.RND_ECO_HIGH.Reg, value)
}
func (o *ADC_Type) GetRND_ECO_HIGH() uint32 {
	return volatile.LoadUint32(&o.RND_ECO_HIGH.Reg)
}

// ADC.RND_ECO_CS: Register
func (o *ADC_Type) SetRND_ECO_CS_RND_ECO_EN(value uint32) {
	volatile.StoreUint32(&o.RND_ECO_CS.Reg, volatile.LoadUint32(&o.RND_ECO_CS.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetRND_ECO_CS_RND_ECO_EN() uint32 {
	return volatile.LoadUint32(&o.RND_ECO_CS.Reg) & 0x1
}
func (o *ADC_Type) SetRND_ECO_CS_RND_ECO_RESULT(value uint32) {
	volatile.StoreUint32(&o.RND_ECO_CS.Reg, volatile.LoadUint32(&o.RND_ECO_CS.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetRND_ECO_CS_RND_ECO_RESULT() uint32 {
	return (volatile.LoadUint32(&o.RND_ECO_CS.Reg) & 0x2) >> 1
}

// ADC.CTRL_DATE: Register
func (o *ADC_Type) SetCTRL_DATE(value uint32) {
	volatile.StoreUint32(&o.CTRL_DATE.Reg, volatile.LoadUint32(&o.CTRL_DATE.Reg)&^(0x7fffffff)|value)
}
func (o *ADC_Type) GetCTRL_DATE() uint32 {
	return volatile.LoadUint32(&o.CTRL_DATE.Reg) & 0x7fffffff
}
func (o *ADC_Type) SetCTRL_DATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL_DATE.Reg, volatile.LoadUint32(&o.CTRL_DATE.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCTRL_DATE_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL_DATE.Reg) & 0x80000000) >> 31
}

// AES (Advanced Encryption Standard) Accelerator
type AES_Type struct {
	KEY_0             volatile.Register32    // 0x0
	KEY_1             volatile.Register32    // 0x4
	KEY_2             volatile.Register32    // 0x8
	KEY_3             volatile.Register32    // 0xC
	KEY_4             volatile.Register32    // 0x10
	KEY_5             volatile.Register32    // 0x14
	KEY_6             volatile.Register32    // 0x18
	KEY_7             volatile.Register32    // 0x1C
	TEXT_IN_0         volatile.Register32    // 0x20
	TEXT_IN_1         volatile.Register32    // 0x24
	TEXT_IN_2         volatile.Register32    // 0x28
	TEXT_IN_3         volatile.Register32    // 0x2C
	TEXT_OUT_0        volatile.Register32    // 0x30
	TEXT_OUT_1        volatile.Register32    // 0x34
	TEXT_OUT_2        volatile.Register32    // 0x38
	TEXT_OUT_3        volatile.Register32    // 0x3C
	MODE              volatile.Register32    // 0x40
	ENDIAN            volatile.Register32    // 0x44
	TRIGGER           volatile.Register32    // 0x48
	STATE             volatile.Register32    // 0x4C
	IV_MEM            [4]volatile.Register32 // 0x50
	H_MEM             [4]volatile.Register32 // 0x60
	J0_MEM            [4]volatile.Register32 // 0x70
	T0_MEM            [4]volatile.Register32 // 0x80
	DMA_ENABLE        volatile.Register32    // 0x90
	BLOCK_MODE        volatile.Register32    // 0x94
	BLOCK_NUM         volatile.Register32    // 0x98
	INC_SEL           volatile.Register32    // 0x9C
	AAD_BLOCK_NUM     volatile.Register32    // 0xA0
	REMAINDER_BIT_NUM volatile.Register32    // 0xA4
	CONTINUE          volatile.Register32    // 0xA8
	INT_CLEAR         volatile.Register32    // 0xAC
	INT_ENA           volatile.Register32    // 0xB0
	DATE              volatile.Register32    // 0xB4
	DMA_EXIT          volatile.Register32    // 0xB8
}

// AES.KEY_0: Key material key_0 configure register
func (o *AES_Type) SetKEY_0(value uint32) {
	volatile.StoreUint32(&o.KEY_0.Reg, value)
}
func (o *AES_Type) GetKEY_0() uint32 {
	return volatile.LoadUint32(&o.KEY_0.Reg)
}

// AES.KEY_1: Key material key_1 configure register
func (o *AES_Type) SetKEY_1(value uint32) {
	volatile.StoreUint32(&o.KEY_1.Reg, value)
}
func (o *AES_Type) GetKEY_1() uint32 {
	return volatile.LoadUint32(&o.KEY_1.Reg)
}

// AES.KEY_2: Key material key_2 configure register
func (o *AES_Type) SetKEY_2(value uint32) {
	volatile.StoreUint32(&o.KEY_2.Reg, value)
}
func (o *AES_Type) GetKEY_2() uint32 {
	return volatile.LoadUint32(&o.KEY_2.Reg)
}

// AES.KEY_3: Key material key_3 configure register
func (o *AES_Type) SetKEY_3(value uint32) {
	volatile.StoreUint32(&o.KEY_3.Reg, value)
}
func (o *AES_Type) GetKEY_3() uint32 {
	return volatile.LoadUint32(&o.KEY_3.Reg)
}

// AES.KEY_4: Key material key_4 configure register
func (o *AES_Type) SetKEY_4(value uint32) {
	volatile.StoreUint32(&o.KEY_4.Reg, value)
}
func (o *AES_Type) GetKEY_4() uint32 {
	return volatile.LoadUint32(&o.KEY_4.Reg)
}

// AES.KEY_5: Key material key_5 configure register
func (o *AES_Type) SetKEY_5(value uint32) {
	volatile.StoreUint32(&o.KEY_5.Reg, value)
}
func (o *AES_Type) GetKEY_5() uint32 {
	return volatile.LoadUint32(&o.KEY_5.Reg)
}

// AES.KEY_6: Key material key_6 configure register
func (o *AES_Type) SetKEY_6(value uint32) {
	volatile.StoreUint32(&o.KEY_6.Reg, value)
}
func (o *AES_Type) GetKEY_6() uint32 {
	return volatile.LoadUint32(&o.KEY_6.Reg)
}

// AES.KEY_7: Key material key_7 configure register
func (o *AES_Type) SetKEY_7(value uint32) {
	volatile.StoreUint32(&o.KEY_7.Reg, value)
}
func (o *AES_Type) GetKEY_7() uint32 {
	return volatile.LoadUint32(&o.KEY_7.Reg)
}

// AES.TEXT_IN_0: source text material text_in_0 configure register
func (o *AES_Type) SetTEXT_IN_0(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_0.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_0() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_0.Reg)
}

// AES.TEXT_IN_1: source text material text_in_1 configure register
func (o *AES_Type) SetTEXT_IN_1(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_1.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_1() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_1.Reg)
}

// AES.TEXT_IN_2: source text material text_in_2 configure register
func (o *AES_Type) SetTEXT_IN_2(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_2.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_2() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_2.Reg)
}

// AES.TEXT_IN_3: source text material text_in_3 configure register
func (o *AES_Type) SetTEXT_IN_3(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_3.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_3() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_3.Reg)
}

// AES.TEXT_OUT_0: result text material text_out_0 configure register
func (o *AES_Type) SetTEXT_OUT_0(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_0.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_0() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_0.Reg)
}

// AES.TEXT_OUT_1: result text material text_out_1 configure register
func (o *AES_Type) SetTEXT_OUT_1(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_1.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_1() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_1.Reg)
}

// AES.TEXT_OUT_2: result text material text_out_2 configure register
func (o *AES_Type) SetTEXT_OUT_2(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_2.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_2() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_2.Reg)
}

// AES.TEXT_OUT_3: result text material text_out_3 configure register
func (o *AES_Type) SetTEXT_OUT_3(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_3.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_3() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_3.Reg)
}

// AES.MODE: AES Mode register
func (o *AES_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x7
}

// AES.ENDIAN: AES Endian configure register
func (o *AES_Type) SetENDIAN(value uint32) {
	volatile.StoreUint32(&o.ENDIAN.Reg, volatile.LoadUint32(&o.ENDIAN.Reg)&^(0x3f)|value)
}
func (o *AES_Type) GetENDIAN() uint32 {
	return volatile.LoadUint32(&o.ENDIAN.Reg) & 0x3f
}

// AES.TRIGGER: AES trigger register
func (o *AES_Type) SetTRIGGER(value uint32) {
	volatile.StoreUint32(&o.TRIGGER.Reg, volatile.LoadUint32(&o.TRIGGER.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetTRIGGER() uint32 {
	return volatile.LoadUint32(&o.TRIGGER.Reg) & 0x1
}

// AES.STATE: AES state register
func (o *AES_Type) SetSTATE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x3)|value)
}
func (o *AES_Type) GetSTATE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x3
}

// AES.DMA_ENABLE: DMA-AES working mode register
func (o *AES_Type) SetDMA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DMA_ENABLE.Reg, volatile.LoadUint32(&o.DMA_ENABLE.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_ENABLE() uint32 {
	return volatile.LoadUint32(&o.DMA_ENABLE.Reg) & 0x1
}

// AES.BLOCK_MODE: AES cipher block mode register
func (o *AES_Type) SetBLOCK_MODE(value uint32) {
	volatile.StoreUint32(&o.BLOCK_MODE.Reg, volatile.LoadUint32(&o.BLOCK_MODE.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetBLOCK_MODE() uint32 {
	return volatile.LoadUint32(&o.BLOCK_MODE.Reg) & 0x7
}

// AES.BLOCK_NUM: AES block number register
func (o *AES_Type) SetBLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.BLOCK_NUM.Reg, value)
}
func (o *AES_Type) GetBLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.BLOCK_NUM.Reg)
}

// AES.INC_SEL: Standard incrementing function configure register
func (o *AES_Type) SetINC_SEL(value uint32) {
	volatile.StoreUint32(&o.INC_SEL.Reg, volatile.LoadUint32(&o.INC_SEL.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINC_SEL() uint32 {
	return volatile.LoadUint32(&o.INC_SEL.Reg) & 0x1
}

// AES.AAD_BLOCK_NUM: Additional Authential Data block number register
func (o *AES_Type) SetAAD_BLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.AAD_BLOCK_NUM.Reg, value)
}
func (o *AES_Type) GetAAD_BLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.AAD_BLOCK_NUM.Reg)
}

// AES.REMAINDER_BIT_NUM: AES remainder bit number register
func (o *AES_Type) SetREMAINDER_BIT_NUM(value uint32) {
	volatile.StoreUint32(&o.REMAINDER_BIT_NUM.Reg, volatile.LoadUint32(&o.REMAINDER_BIT_NUM.Reg)&^(0x7f)|value)
}
func (o *AES_Type) GetREMAINDER_BIT_NUM() uint32 {
	return volatile.LoadUint32(&o.REMAINDER_BIT_NUM.Reg) & 0x7f
}

// AES.CONTINUE: AES continue register
func (o *AES_Type) SetCONTINUE(value uint32) {
	volatile.StoreUint32(&o.CONTINUE.Reg, volatile.LoadUint32(&o.CONTINUE.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCONTINUE() uint32 {
	return volatile.LoadUint32(&o.CONTINUE.Reg) & 0x1
}

// AES.INT_CLEAR: AES Interrupt clear register
func (o *AES_Type) SetINT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.INT_CLEAR.Reg, volatile.LoadUint32(&o.INT_CLEAR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINT_CLEAR() uint32 {
	return volatile.LoadUint32(&o.INT_CLEAR.Reg) & 0x1
}

// AES.INT_ENA: AES Interrupt enable register
func (o *AES_Type) SetINT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}

// AES.DATE: AES version control register
func (o *AES_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *AES_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// AES.DMA_EXIT: AES-DMA exit config
func (o *AES_Type) SetDMA_EXIT(value uint32) {
	volatile.StoreUint32(&o.DMA_EXIT.Reg, volatile.LoadUint32(&o.DMA_EXIT.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_EXIT() uint32 {
	return volatile.LoadUint32(&o.DMA_EXIT.Reg) & 0x1
}

// AHB_DMA Peripheral
type AHB_DMA_Type struct {
	IN_INT_RAW_CH0             volatile.Register32 // 0x0
	IN_INT_ST_CH0              volatile.Register32 // 0x4
	IN_INT_ENA_CH0             volatile.Register32 // 0x8
	IN_INT_CLR_CH0             volatile.Register32 // 0xC
	IN_INT_RAW_CH1             volatile.Register32 // 0x10
	IN_INT_ST_CH1              volatile.Register32 // 0x14
	IN_INT_ENA_CH1             volatile.Register32 // 0x18
	IN_INT_CLR_CH1             volatile.Register32 // 0x1C
	IN_INT_RAW_CH2             volatile.Register32 // 0x20
	IN_INT_ST_CH2              volatile.Register32 // 0x24
	IN_INT_ENA_CH2             volatile.Register32 // 0x28
	IN_INT_CLR_CH2             volatile.Register32 // 0x2C
	OUT_INT_RAW_CH0            volatile.Register32 // 0x30
	OUT_INT_ST_CH0             volatile.Register32 // 0x34
	OUT_INT_ENA_CH0            volatile.Register32 // 0x38
	OUT_INT_CLR_CH0            volatile.Register32 // 0x3C
	OUT_INT_RAW_CH1            volatile.Register32 // 0x40
	OUT_INT_ST_CH1             volatile.Register32 // 0x44
	OUT_INT_ENA_CH1            volatile.Register32 // 0x48
	OUT_INT_CLR_CH1            volatile.Register32 // 0x4C
	OUT_INT_RAW_CH2            volatile.Register32 // 0x50
	OUT_INT_ST_CH2             volatile.Register32 // 0x54
	OUT_INT_ENA_CH2            volatile.Register32 // 0x58
	OUT_INT_CLR_CH2            volatile.Register32 // 0x5C
	AHB_TEST                   volatile.Register32 // 0x60
	MISC_CONF                  volatile.Register32 // 0x64
	DATE                       volatile.Register32 // 0x68
	_                          [4]byte
	IN_CONF0_CH0               volatile.Register32 // 0x70
	IN_CONF1_CH0               volatile.Register32 // 0x74
	INFIFO_STATUS_CH0          volatile.Register32 // 0x78
	IN_POP_CH0                 volatile.Register32 // 0x7C
	IN_LINK_CH0                volatile.Register32 // 0x80
	IN_STATE_CH0               volatile.Register32 // 0x84
	IN_SUC_EOF_DES_ADDR_CH0    volatile.Register32 // 0x88
	IN_ERR_EOF_DES_ADDR_CH0    volatile.Register32 // 0x8C
	IN_DSCR_CH0                volatile.Register32 // 0x90
	IN_DSCR_BF0_CH0            volatile.Register32 // 0x94
	IN_DSCR_BF1_CH0            volatile.Register32 // 0x98
	IN_PRI_CH0                 volatile.Register32 // 0x9C
	IN_PERI_SEL_CH0            volatile.Register32 // 0xA0
	_                          [44]byte
	OUT_CONF0_CH0              volatile.Register32 // 0xD0
	OUT_CONF1_CH0              volatile.Register32 // 0xD4
	OUTFIFO_STATUS_CH0         volatile.Register32 // 0xD8
	OUT_PUSH_CH0               volatile.Register32 // 0xDC
	OUT_LINK_CH0               volatile.Register32 // 0xE0
	OUT_STATE_CH0              volatile.Register32 // 0xE4
	OUT_EOF_DES_ADDR_CH0       volatile.Register32 // 0xE8
	OUT_EOF_BFR_DES_ADDR_CH0   volatile.Register32 // 0xEC
	OUT_DSCR_CH0               volatile.Register32 // 0xF0
	OUT_DSCR_BF0_CH0           volatile.Register32 // 0xF4
	OUT_DSCR_BF1_CH0           volatile.Register32 // 0xF8
	OUT_PRI_CH0                volatile.Register32 // 0xFC
	OUT_PERI_SEL_CH0           volatile.Register32 // 0x100
	_                          [44]byte
	IN_CONF0_CH1               volatile.Register32 // 0x130
	IN_CONF1_CH1               volatile.Register32 // 0x134
	INFIFO_STATUS_CH1          volatile.Register32 // 0x138
	IN_POP_CH1                 volatile.Register32 // 0x13C
	IN_LINK_CH1                volatile.Register32 // 0x140
	IN_STATE_CH1               volatile.Register32 // 0x144
	IN_SUC_EOF_DES_ADDR_CH1    volatile.Register32 // 0x148
	IN_ERR_EOF_DES_ADDR_CH1    volatile.Register32 // 0x14C
	IN_DSCR_CH1                volatile.Register32 // 0x150
	IN_DSCR_BF0_CH1            volatile.Register32 // 0x154
	IN_DSCR_BF1_CH1            volatile.Register32 // 0x158
	IN_PRI_CH1                 volatile.Register32 // 0x15C
	IN_PERI_SEL_CH1            volatile.Register32 // 0x160
	_                          [44]byte
	OUT_CONF0_CH0              volatile.Register32 // 0x190
	OUT_CONF1_CH1              volatile.Register32 // 0x194
	OUTFIFO_STATUS_CH1         volatile.Register32 // 0x198
	OUT_PUSH_CH1               volatile.Register32 // 0x19C
	OUT_LINK_CH1               volatile.Register32 // 0x1A0
	OUT_STATE_CH1              volatile.Register32 // 0x1A4
	OUT_EOF_DES_ADDR_CH1       volatile.Register32 // 0x1A8
	OUT_EOF_BFR_DES_ADDR_CH1   volatile.Register32 // 0x1AC
	OUT_DSCR_CH1               volatile.Register32 // 0x1B0
	OUT_DSCR_BF0_CH1           volatile.Register32 // 0x1B4
	OUT_DSCR_BF1_CH1           volatile.Register32 // 0x1B8
	OUT_PRI_CH1                volatile.Register32 // 0x1BC
	OUT_PERI_SEL_CH1           volatile.Register32 // 0x1C0
	_                          [44]byte
	IN_CONF0_CH2               volatile.Register32 // 0x1F0
	IN_CONF1_CH2               volatile.Register32 // 0x1F4
	INFIFO_STATUS_CH2          volatile.Register32 // 0x1F8
	IN_POP_CH2                 volatile.Register32 // 0x1FC
	IN_LINK_CH2                volatile.Register32 // 0x200
	IN_STATE_CH2               volatile.Register32 // 0x204
	IN_SUC_EOF_DES_ADDR_CH2    volatile.Register32 // 0x208
	IN_ERR_EOF_DES_ADDR_CH2    volatile.Register32 // 0x20C
	IN_DSCR_CH2                volatile.Register32 // 0x210
	IN_DSCR_BF0_CH2            volatile.Register32 // 0x214
	IN_DSCR_BF1_CH2            volatile.Register32 // 0x218
	IN_PRI_CH2                 volatile.Register32 // 0x21C
	IN_PERI_SEL_CH2            volatile.Register32 // 0x220
	_                          [44]byte
	OUT_CONF0_CH1              volatile.Register32 // 0x250
	OUT_CONF1_CH2              volatile.Register32 // 0x254
	OUTFIFO_STATUS_CH2         volatile.Register32 // 0x258
	OUT_PUSH_CH2               volatile.Register32 // 0x25C
	OUT_LINK_CH2               volatile.Register32 // 0x260
	OUT_STATE_CH2              volatile.Register32 // 0x264
	OUT_EOF_DES_ADDR_CH2       volatile.Register32 // 0x268
	OUT_EOF_BFR_DES_ADDR_CH2   volatile.Register32 // 0x26C
	OUT_DSCR_CH2               volatile.Register32 // 0x270
	OUT_DSCR_BF0_CH2           volatile.Register32 // 0x274
	OUT_DSCR_BF1_CH2           volatile.Register32 // 0x278
	OUT_PRI_CH2                volatile.Register32 // 0x27C
	OUT_PERI_SEL_CH2           volatile.Register32 // 0x280
	_                          [56]byte
	OUT_CRC_INIT_DATA_CH0      volatile.Register32 // 0x2BC
	TX_CRC_WIDTH_CH0           volatile.Register32 // 0x2C0
	OUT_CRC_CLEAR_CH0          volatile.Register32 // 0x2C4
	OUT_CRC_FINAL_RESULT_CH0   volatile.Register32 // 0x2C8
	TX_CRC_EN_WR_DATA_CH0      volatile.Register32 // 0x2CC
	TX_CRC_EN_ADDR_CH0         volatile.Register32 // 0x2D0
	TX_CRC_DATA_EN_WR_DATA_CH0 volatile.Register32 // 0x2D4
	TX_CRC_DATA_EN_ADDR_CH0    volatile.Register32 // 0x2D8
	TX_CH_ARB_WEIGH_CH0        volatile.Register32 // 0x2DC
	TX_ARB_WEIGH_OPT_DIR_CH0   volatile.Register32 // 0x2E0
	OUT_CRC_INIT_DATA_CH1      volatile.Register32 // 0x2E4
	TX_CRC_WIDTH_CH1           volatile.Register32 // 0x2E8
	OUT_CRC_CLEAR_CH1          volatile.Register32 // 0x2EC
	OUT_CRC_FINAL_RESULT_CH1   volatile.Register32 // 0x2F0
	TX_CRC_EN_WR_DATA_CH1      volatile.Register32 // 0x2F4
	TX_CRC_EN_ADDR_CH1         volatile.Register32 // 0x2F8
	TX_CRC_DATA_EN_WR_DATA_CH1 volatile.Register32 // 0x2FC
	TX_CRC_DATA_EN_ADDR_CH1    volatile.Register32 // 0x300
	TX_CH_ARB_WEIGH_CH1        volatile.Register32 // 0x304
	TX_ARB_WEIGH_OPT_DIR_CH1   volatile.Register32 // 0x308
	OUT_CRC_INIT_DATA_CH2      volatile.Register32 // 0x30C
	TX_CRC_WIDTH_CH2           volatile.Register32 // 0x310
	OUT_CRC_CLEAR_CH2          volatile.Register32 // 0x314
	OUT_CRC_FINAL_RESULT_CH2   volatile.Register32 // 0x318
	TX_CRC_EN_WR_DATA_CH2      volatile.Register32 // 0x31C
	TX_CRC_EN_ADDR_CH2         volatile.Register32 // 0x320
	TX_CRC_DATA_EN_WR_DATA_CH2 volatile.Register32 // 0x324
	TX_CRC_DATA_EN_ADDR_CH2    volatile.Register32 // 0x328
	TX_CH_ARB_WEIGH_CH2        volatile.Register32 // 0x32C
	TX_ARB_WEIGH_OPT_DIR_CH2   volatile.Register32 // 0x330
	IN_CRC_INIT_DATA_CH0       volatile.Register32 // 0x334
	RX_CRC_WIDTH_CH0           volatile.Register32 // 0x338
	IN_CRC_CLEAR_CH0           volatile.Register32 // 0x33C
	IN_CRC_FINAL_RESULT_CH0    volatile.Register32 // 0x340
	RX_CRC_EN_WR_DATA_CH0      volatile.Register32 // 0x344
	RX_CRC_EN_ADDR_CH0         volatile.Register32 // 0x348
	RX_CRC_DATA_EN_WR_DATA_CH0 volatile.Register32 // 0x34C
	RX_CRC_DATA_EN_ADDR_CH0    volatile.Register32 // 0x350
	RX_CH_ARB_WEIGH_CH0        volatile.Register32 // 0x354
	RX_ARB_WEIGH_OPT_DIR_CH0   volatile.Register32 // 0x358
	IN_CRC_INIT_DATA_CH1       volatile.Register32 // 0x35C
	RX_CRC_WIDTH_CH1           volatile.Register32 // 0x360
	IN_CRC_CLEAR_CH1           volatile.Register32 // 0x364
	IN_CRC_FINAL_RESULT_CH1    volatile.Register32 // 0x368
	RX_CRC_EN_WR_DATA_CH1      volatile.Register32 // 0x36C
	RX_CRC_EN_ADDR_CH1         volatile.Register32 // 0x370
	RX_CRC_DATA_EN_WR_DATA_CH1 volatile.Register32 // 0x374
	RX_CRC_DATA_EN_ADDR_CH1    volatile.Register32 // 0x378
	RX_CH_ARB_WEIGH_CH1        volatile.Register32 // 0x37C
	RX_ARB_WEIGH_OPT_DIR_CH1   volatile.Register32 // 0x380
	IN_CRC_INIT_DATA_CH2       volatile.Register32 // 0x384
	RX_CRC_WIDTH_CH2           volatile.Register32 // 0x388
	IN_CRC_CLEAR_CH2           volatile.Register32 // 0x38C
	IN_CRC_FINAL_RESULT_CH2    volatile.Register32 // 0x390
	RX_CRC_EN_WR_DATA_CH2      volatile.Register32 // 0x394
	RX_CRC_EN_ADDR_CH2         volatile.Register32 // 0x398
	RX_CRC_DATA_EN_WR_DATA_CH2 volatile.Register32 // 0x39C
	RX_CRC_DATA_EN_ADDR_CH2    volatile.Register32 // 0x3A0
	RX_CH_ARB_WEIGH_CH2        volatile.Register32 // 0x3A4
	RX_ARB_WEIGH_OPT_DIR_CH2   volatile.Register32 // 0x3A8
	IN_LINK_ADDR_CH0           volatile.Register32 // 0x3AC
	IN_LINK_ADDR_CH1           volatile.Register32 // 0x3B0
	IN_LINK_ADDR_CH2           volatile.Register32 // 0x3B4
	OUT_LINK_ADDR_CH0          volatile.Register32 // 0x3B8
	OUT_LINK_ADDR_CH1          volatile.Register32 // 0x3BC
	OUT_LINK_ADDR_CH2          volatile.Register32 // 0x3C0
	INTR_MEM_START_ADDR        volatile.Register32 // 0x3C4
	INTR_MEM_END_ADDR          volatile.Register32 // 0x3C8
	ARB_TIMEOUT_TX             volatile.Register32 // 0x3CC
	ARB_TIMEOUT_RX             volatile.Register32 // 0x3D0
	WEIGHT_EN_TX               volatile.Register32 // 0x3D4
	WEIGHT_EN_RX               volatile.Register32 // 0x3D8
}

// AHB_DMA.IN_INT_RAW_CH0: Raw status interrupt of channel 0
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH0_IN_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH0_IN_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH0_IN_SUC_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH0_IN_SUC_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH0_IN_ERR_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH0_IN_ERR_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH0_IN_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH0_IN_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH0_IN_DSCR_EMPTY_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH0_IN_DSCR_EMPTY_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH0_INFIFO_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH0_INFIFO_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH0_INFIFO_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH0_INFIFO_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_ST_CH0: Masked interrupt of channel 0
func (o *AHB_DMA_Type) SetIN_INT_ST_CH0_IN_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH0_IN_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH0_IN_SUC_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH0_IN_SUC_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH0_IN_ERR_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH0_IN_ERR_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH0_IN_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH0_IN_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH0_IN_DSCR_EMPTY_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH0_IN_DSCR_EMPTY_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH0_INFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH0_INFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH0_INFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH0_INFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_ENA_CH0: Interrupt enable bits of channel 0
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH0_IN_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH0_IN_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH0_IN_SUC_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH0_IN_SUC_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH0_IN_ERR_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH0_IN_ERR_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH0_IN_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH0_IN_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH0_IN_DSCR_EMPTY_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH0_IN_DSCR_EMPTY_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH0_INFIFO_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH0_INFIFO_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH0_INFIFO_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH0_INFIFO_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_CLR_CH0: Interrupt clear bits of channel 0
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH0_IN_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH0_IN_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH0_IN_SUC_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH0_IN_SUC_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH0_IN_ERR_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH0_IN_ERR_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH0_IN_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH0_IN_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH0_IN_DSCR_EMPTY_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH0_IN_DSCR_EMPTY_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH0_INFIFO_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH0_INFIFO_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH0_INFIFO_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH0_INFIFO_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_RAW_CH1: Raw status interrupt of channel 0
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH1_IN_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH1_IN_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH1_IN_SUC_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH1_IN_SUC_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH1_IN_ERR_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH1_IN_ERR_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH1_IN_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH1_IN_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH1_IN_DSCR_EMPTY_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH1_IN_DSCR_EMPTY_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH1_INFIFO_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH1_INFIFO_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH1_INFIFO_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH1_INFIFO_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_ST_CH1: Masked interrupt of channel 0
func (o *AHB_DMA_Type) SetIN_INT_ST_CH1_IN_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH1_IN_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH1_IN_SUC_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH1_IN_SUC_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH1_IN_ERR_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH1_IN_ERR_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH1_IN_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH1_IN_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH1_IN_DSCR_EMPTY_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH1_IN_DSCR_EMPTY_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH1_INFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH1_INFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH1_INFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH1_INFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_ENA_CH1: Interrupt enable bits of channel 0
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH1_IN_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH1_IN_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH1_IN_SUC_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH1_IN_SUC_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH1_IN_ERR_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH1_IN_ERR_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH1_IN_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH1_IN_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH1_IN_DSCR_EMPTY_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH1_IN_DSCR_EMPTY_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH1_INFIFO_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH1_INFIFO_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH1_INFIFO_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH1_INFIFO_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_CLR_CH1: Interrupt clear bits of channel 0
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH1_IN_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH1_IN_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH1_IN_SUC_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH1_IN_SUC_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH1_IN_ERR_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH1_IN_ERR_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH1_IN_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH1_IN_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH1_IN_DSCR_EMPTY_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH1_IN_DSCR_EMPTY_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH1_INFIFO_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH1_INFIFO_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH1_INFIFO_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH1_INFIFO_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_RAW_CH2: Raw status interrupt of channel 0
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH2_IN_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH2_IN_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH2_IN_SUC_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH2_IN_SUC_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH2_IN_ERR_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH2_IN_ERR_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH2_IN_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH2_IN_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH2_IN_DSCR_EMPTY_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH2_IN_DSCR_EMPTY_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH2_INFIFO_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH2_INFIFO_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_RAW_CH2_INFIFO_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_RAW_CH2_INFIFO_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_ST_CH2: Masked interrupt of channel 0
func (o *AHB_DMA_Type) SetIN_INT_ST_CH2_IN_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH2_IN_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH2_IN_SUC_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH2_IN_SUC_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH2_IN_ERR_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH2_IN_ERR_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH2_IN_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH2_IN_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH2_IN_DSCR_EMPTY_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH2_IN_DSCR_EMPTY_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH2_INFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH2_INFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_ST_CH2_INFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_ST_CH2_INFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_ENA_CH2: Interrupt enable bits of channel 0
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH2_IN_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH2_IN_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH2_IN_SUC_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH2_IN_SUC_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH2_IN_ERR_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH2_IN_ERR_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH2_IN_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH2_IN_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH2_IN_DSCR_EMPTY_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH2_IN_DSCR_EMPTY_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH2_INFIFO_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH2_INFIFO_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_ENA_CH2_INFIFO_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_ENA_CH2_INFIFO_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x40) >> 6
}

// AHB_DMA.IN_INT_CLR_CH2: Interrupt clear bits of channel 0
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH2_IN_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH2_IN_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH2_IN_SUC_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH2_IN_SUC_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH2_IN_ERR_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH2_IN_ERR_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH2_IN_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH2_IN_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH2_IN_DSCR_EMPTY_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH2_IN_DSCR_EMPTY_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH2_INFIFO_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH2_INFIFO_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetIN_INT_CLR_CH2_INFIFO_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetIN_INT_CLR_CH2_INFIFO_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x40) >> 6
}

// AHB_DMA.OUT_INT_RAW_CH0: Raw status interrupt of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH0_OUT_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH0_OUT_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH0_OUT_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH0_OUT_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH0_OUT_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH0_OUT_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH0_OUT_TOTAL_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH0_OUT_TOTAL_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_ST_CH0: Masked interrupt of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH0_OUT_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH0_OUT_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH0_OUT_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH0_OUT_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH0_OUT_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH0_OUT_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH0_OUT_TOTAL_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH0_OUT_TOTAL_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_ENA_CH0: Interrupt enable bits of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH0_OUT_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH0_OUT_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH0_OUT_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH0_OUT_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH0_OUT_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH0_OUT_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH0_OUT_TOTAL_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH0_OUT_TOTAL_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_CLR_CH0: Interrupt clear bits of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH0_OUT_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH0_OUT_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH0_OUT_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH0_OUT_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH0_OUT_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH0_OUT_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH0_OUT_TOTAL_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH0_OUT_TOTAL_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_RAW_CH1: Raw status interrupt of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH1_OUT_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH1_OUT_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH1_OUT_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH1_OUT_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH1_OUT_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH1_OUT_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH1_OUT_TOTAL_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH1_OUT_TOTAL_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_ST_CH1: Masked interrupt of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH1_OUT_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH1_OUT_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH1_OUT_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH1_OUT_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH1_OUT_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH1_OUT_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH1_OUT_TOTAL_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH1_OUT_TOTAL_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_ENA_CH1: Interrupt enable bits of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH1_OUT_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH1_OUT_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH1_OUT_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH1_OUT_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH1_OUT_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH1_OUT_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH1_OUT_TOTAL_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH1_OUT_TOTAL_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_CLR_CH1: Interrupt clear bits of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH1_OUT_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH1_OUT_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH1_OUT_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH1_OUT_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH1_OUT_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH1_OUT_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH1_OUT_TOTAL_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH1_OUT_TOTAL_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_RAW_CH2: Raw status interrupt of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH2_OUT_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH2_OUT_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH2_OUT_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH2_OUT_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH2_OUT_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH2_OUT_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH2_OUT_TOTAL_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH2_OUT_TOTAL_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_ST_CH2: Masked interrupt of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH2_OUT_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH2_OUT_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH2_OUT_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH2_OUT_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH2_OUT_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH2_OUT_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH2_OUT_TOTAL_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH2_OUT_TOTAL_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_ENA_CH2: Interrupt enable bits of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH2_OUT_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH2_OUT_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH2_OUT_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH2_OUT_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH2_OUT_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH2_OUT_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH2_OUT_TOTAL_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH2_OUT_TOTAL_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x20) >> 5
}

// AHB_DMA.OUT_INT_CLR_CH2: Interrupt clear bits of channel 0
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH2_OUT_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH2_OUT_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH2_OUT_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH2_OUT_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH2_OUT_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH2_OUT_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH2_OUT_TOTAL_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH2_OUT_TOTAL_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x20) >> 5
}

// AHB_DMA.AHB_TEST: reserved
func (o *AHB_DMA_Type) SetAHB_TEST_AHB_TESTMODE(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x7)|value)
}
func (o *AHB_DMA_Type) GetAHB_TEST_AHB_TESTMODE() uint32 {
	return volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x7
}
func (o *AHB_DMA_Type) SetAHB_TEST_AHB_TESTADDR(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x30)|value<<4)
}
func (o *AHB_DMA_Type) GetAHB_TEST_AHB_TESTADDR() uint32 {
	return (volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x30) >> 4
}

// AHB_DMA.MISC_CONF: MISC register
func (o *AHB_DMA_Type) SetMISC_CONF_AHBM_RST_INTER(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetMISC_CONF_AHBM_RST_INTER() uint32 {
	return volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetMISC_CONF_ARB_PRI_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetMISC_CONF_ARB_PRI_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetMISC_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetMISC_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x8) >> 3
}

// AHB_DMA.DATE: Version control register
func (o *AHB_DMA_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *AHB_DMA_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// AHB_DMA.IN_CONF0_CH0: Configure 0 register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_CONF0_CH0_IN_RST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH0_IN_RST_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH0_IN_LOOP_TEST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH0_IN_LOOP_TEST_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH0_INDSCR_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH0_INDSCR_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH0_IN_DATA_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH0_IN_DATA_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH0_MEM_TRANS_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH0_MEM_TRANS_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH0_IN_ETM_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH0_IN_ETM_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x20) >> 5
}

// AHB_DMA.IN_CONF1_CH0: Configure 1 register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_CONF1_CH0_IN_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH0.Reg, volatile.LoadUint32(&o.IN_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *AHB_DMA_Type) GetIN_CONF1_CH0_IN_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH0.Reg) & 0x1000) >> 12
}

// AHB_DMA.INFIFO_STATUS_CH0: Receive FIFO status of Rx channel 0
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0xfc)|value<<2)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0xfc) >> 2
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH0_IN_BUF_HUNGRY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x8000000)|value<<27)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH0_IN_BUF_HUNGRY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x8000000) >> 27
}

// AHB_DMA.IN_POP_CH0: Pop control register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_POP_CH0_INFIFO_RDATA_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0xfff)|value)
}
func (o *AHB_DMA_Type) GetIN_POP_CH0_INFIFO_RDATA_CH() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0xfff
}
func (o *AHB_DMA_Type) SetIN_POP_CH0_INFIFO_POP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *AHB_DMA_Type) GetIN_POP_CH0_INFIFO_POP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0x1000) >> 12
}

// AHB_DMA.IN_LINK_CH0: Link descriptor configure and control register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_LINK_CH0_INLINK_AUTO_RET_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH0_INLINK_AUTO_RET_CH() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_LINK_CH0_INLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH0_INLINK_STOP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_LINK_CH0_INLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH0_INLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_LINK_CH0_INLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH0_INLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_LINK_CH0_INLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH0_INLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x10) >> 4
}

// AHB_DMA.IN_STATE_CH0: Receive status of Rx channel 0
func (o *AHB_DMA_Type) SetIN_STATE_CH0_INLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *AHB_DMA_Type) GetIN_STATE_CH0_INLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x3ffff
}
func (o *AHB_DMA_Type) SetIN_STATE_CH0_IN_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *AHB_DMA_Type) GetIN_STATE_CH0_IN_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *AHB_DMA_Type) SetIN_STATE_CH0_IN_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *AHB_DMA_Type) GetIN_STATE_CH0_IN_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x700000) >> 20
}

// AHB_DMA.IN_SUC_EOF_DES_ADDR_CH0: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *AHB_DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg)
}

// AHB_DMA.IN_ERR_EOF_DES_ADDR_CH0: Inlink descriptor address when errors occur of Rx channel 0
func (o *AHB_DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg)
}

// AHB_DMA.IN_DSCR_CH0: Current inlink descriptor address of Rx channel 0
func (o *AHB_DMA_Type) SetIN_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH0.Reg)
}

// AHB_DMA.IN_DSCR_BF0_CH0: The last inlink descriptor address of Rx channel 0
func (o *AHB_DMA_Type) SetIN_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH0.Reg)
}

// AHB_DMA.IN_DSCR_BF1_CH0: The second-to-last inlink descriptor address of Rx channel 0
func (o *AHB_DMA_Type) SetIN_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH0.Reg)
}

// AHB_DMA.IN_PRI_CH0: Priority register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_PRI_CH0_RX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH0.Reg, volatile.LoadUint32(&o.IN_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetIN_PRI_CH0_RX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH0.Reg) & 0xf
}

// AHB_DMA.IN_PERI_SEL_CH0: Peripheral selection of Rx channel 0
func (o *AHB_DMA_Type) SetIN_PERI_SEL_CH0_PERI_IN_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *AHB_DMA_Type) GetIN_PERI_SEL_CH0_PERI_IN_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg) & 0x3f
}

// AHB_DMA.OUT_CONF0_CH0: Configure 0 register of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_RST_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_RST_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_LOOP_TEST_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_LOOP_TEST_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_AUTO_WRBACK_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_AUTO_WRBACK_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_EOF_MODE_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_EOF_MODE_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUTDSCR_BURST_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUTDSCR_BURST_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_DATA_BURST_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_DATA_BURST_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_ETM_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_ETM_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x40) >> 6
}

// AHB_DMA.OUT_CONF1_CH0: Configure 1 register of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_CONF1_CH0_OUT_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *AHB_DMA_Type) GetOUT_CONF1_CH0_OUT_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg) & 0x1000) >> 12
}

// AHB_DMA.OUTFIFO_STATUS_CH0: Transmit FIFO status of Tx channel 0
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0xfc)|value<<2)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0xfc) >> 2
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}

// AHB_DMA.OUT_PUSH_CH0: Push control register of Rx channel 0
func (o *AHB_DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_WDATA_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x1ff)|value)
}
func (o *AHB_DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_WDATA_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x1ff
}
func (o *AHB_DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_PUSH_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AHB_DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_PUSH_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x200) >> 9
}

// AHB_DMA.OUT_LINK_CH0: Link descriptor configure and control register of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_LINK_CH0_OUTLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH0_OUTLINK_STOP_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_LINK_CH0_OUTLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH0_OUTLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_LINK_CH0_OUTLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH0_OUTLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_LINK_CH0_OUTLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH0_OUTLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x8) >> 3
}

// AHB_DMA.OUT_STATE_CH0: Transmit status of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_STATE_CH0_OUTLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *AHB_DMA_Type) GetOUT_STATE_CH0_OUTLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x3ffff
}
func (o *AHB_DMA_Type) SetOUT_STATE_CH0_OUT_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *AHB_DMA_Type) GetOUT_STATE_CH0_OUT_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *AHB_DMA_Type) SetOUT_STATE_CH0_OUT_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *AHB_DMA_Type) GetOUT_STATE_CH0_OUT_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x700000) >> 20
}

// AHB_DMA.OUT_EOF_DES_ADDR_CH0: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg)
}

// AHB_DMA.OUT_EOF_BFR_DES_ADDR_CH0: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg)
}

// AHB_DMA.OUT_DSCR_CH0: Current inlink descriptor address of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH0.Reg)
}

// AHB_DMA.OUT_DSCR_BF0_CH0: The last inlink descriptor address of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH0.Reg)
}

// AHB_DMA.OUT_DSCR_BF1_CH0: The second-to-last inlink descriptor address of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH0.Reg)
}

// AHB_DMA.OUT_PRI_CH0: Priority register of Tx channel 0.
func (o *AHB_DMA_Type) SetOUT_PRI_CH0_TX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH0.Reg, volatile.LoadUint32(&o.OUT_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetOUT_PRI_CH0_TX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH0.Reg) & 0xf
}

// AHB_DMA.OUT_PERI_SEL_CH0: Peripheral selection of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_PERI_SEL_CH0_PERI_OUT_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *AHB_DMA_Type) GetOUT_PERI_SEL_CH0_PERI_OUT_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg) & 0x3f
}

// AHB_DMA.IN_CONF0_CH1: Configure 0 register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_CONF0_CH1_IN_RST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH1_IN_RST_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH1_IN_LOOP_TEST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH1_IN_LOOP_TEST_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH1_INDSCR_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH1_INDSCR_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH1_IN_DATA_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH1_IN_DATA_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH1_MEM_TRANS_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH1_MEM_TRANS_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH1_IN_ETM_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH1_IN_ETM_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x20) >> 5
}

// AHB_DMA.IN_CONF1_CH1: Configure 1 register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_CONF1_CH1_IN_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH1.Reg, volatile.LoadUint32(&o.IN_CONF1_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *AHB_DMA_Type) GetIN_CONF1_CH1_IN_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH1.Reg) & 0x1000) >> 12
}

// AHB_DMA.INFIFO_STATUS_CH1: Receive FIFO status of Rx channel 0
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0xfc)|value<<2)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0xfc) >> 2
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x800000) >> 23
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1000000) >> 24
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2000000)|value<<25)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2000000) >> 25
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x4000000)|value<<26)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x4000000) >> 26
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH1_IN_BUF_HUNGRY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x8000000)|value<<27)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH1_IN_BUF_HUNGRY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x8000000) >> 27
}

// AHB_DMA.IN_POP_CH1: Pop control register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_POP_CH1_INFIFO_RDATA_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH1.Reg, volatile.LoadUint32(&o.IN_POP_CH1.Reg)&^(0xfff)|value)
}
func (o *AHB_DMA_Type) GetIN_POP_CH1_INFIFO_RDATA_CH() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH1.Reg) & 0xfff
}
func (o *AHB_DMA_Type) SetIN_POP_CH1_INFIFO_POP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH1.Reg, volatile.LoadUint32(&o.IN_POP_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *AHB_DMA_Type) GetIN_POP_CH1_INFIFO_POP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH1.Reg) & 0x1000) >> 12
}

// AHB_DMA.IN_LINK_CH1: Link descriptor configure and control register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_LINK_CH1_INLINK_AUTO_RET_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH1_INLINK_AUTO_RET_CH() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_LINK_CH1_INLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH1_INLINK_STOP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_LINK_CH1_INLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH1_INLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_LINK_CH1_INLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH1_INLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_LINK_CH1_INLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH1_INLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x10) >> 4
}

// AHB_DMA.IN_STATE_CH1: Receive status of Rx channel 0
func (o *AHB_DMA_Type) SetIN_STATE_CH1_INLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0x3ffff)|value)
}
func (o *AHB_DMA_Type) GetIN_STATE_CH1_INLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0x3ffff
}
func (o *AHB_DMA_Type) SetIN_STATE_CH1_IN_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0xc0000)|value<<18)
}
func (o *AHB_DMA_Type) GetIN_STATE_CH1_IN_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0xc0000) >> 18
}
func (o *AHB_DMA_Type) SetIN_STATE_CH1_IN_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0x700000)|value<<20)
}
func (o *AHB_DMA_Type) GetIN_STATE_CH1_IN_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0x700000) >> 20
}

// AHB_DMA.IN_SUC_EOF_DES_ADDR_CH1: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *AHB_DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH1.Reg)
}

// AHB_DMA.IN_ERR_EOF_DES_ADDR_CH1: Inlink descriptor address when errors occur of Rx channel 0
func (o *AHB_DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH1.Reg)
}

// AHB_DMA.IN_DSCR_CH1: Current inlink descriptor address of Rx channel 0
func (o *AHB_DMA_Type) SetIN_DSCR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_DSCR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH1.Reg)
}

// AHB_DMA.IN_DSCR_BF0_CH1: The last inlink descriptor address of Rx channel 0
func (o *AHB_DMA_Type) SetIN_DSCR_BF0_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_DSCR_BF0_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH1.Reg)
}

// AHB_DMA.IN_DSCR_BF1_CH1: The second-to-last inlink descriptor address of Rx channel 0
func (o *AHB_DMA_Type) SetIN_DSCR_BF1_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_DSCR_BF1_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH1.Reg)
}

// AHB_DMA.IN_PRI_CH1: Priority register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_PRI_CH1_RX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH1.Reg, volatile.LoadUint32(&o.IN_PRI_CH1.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetIN_PRI_CH1_RX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH1.Reg) & 0xf
}

// AHB_DMA.IN_PERI_SEL_CH1: Peripheral selection of Rx channel 0
func (o *AHB_DMA_Type) SetIN_PERI_SEL_CH1_PERI_IN_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH1.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH1.Reg)&^(0x3f)|value)
}
func (o *AHB_DMA_Type) GetIN_PERI_SEL_CH1_PERI_IN_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH1.Reg) & 0x3f
}

// AHB_DMA.OUT_CONF0_CH0: Configure 0 register of Tx channel 1
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_RST_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_RST_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_LOOP_TEST_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_LOOP_TEST_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_AUTO_WRBACK_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_AUTO_WRBACK_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_EOF_MODE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_EOF_MODE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUTDSCR_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUTDSCR_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_DATA_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_DATA_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH0_OUT_ETM_EN_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH0_OUT_ETM_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x40) >> 6
}

// AHB_DMA.OUT_CONF1_CH1: Configure 1 register of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_CONF1_CH1_OUT_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *AHB_DMA_Type) GetOUT_CONF1_CH1_OUT_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg) & 0x1000) >> 12
}

// AHB_DMA.OUTFIFO_STATUS_CH1: Transmit FIFO status of Tx channel 0
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0xfc)|value<<2)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0xfc) >> 2
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x800000) >> 23
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1000000) >> 24
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2000000)|value<<25)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2000000) >> 25
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x4000000)|value<<26)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x4000000) >> 26
}

// AHB_DMA.OUT_PUSH_CH1: Push control register of Rx channel 0
func (o *AHB_DMA_Type) SetOUT_PUSH_CH1_OUTFIFO_WDATA_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH1.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg)&^(0x1ff)|value)
}
func (o *AHB_DMA_Type) GetOUT_PUSH_CH1_OUTFIFO_WDATA_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg) & 0x1ff
}
func (o *AHB_DMA_Type) SetOUT_PUSH_CH1_OUTFIFO_PUSH_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH1.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AHB_DMA_Type) GetOUT_PUSH_CH1_OUTFIFO_PUSH_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg) & 0x200) >> 9
}

// AHB_DMA.OUT_LINK_CH1: Link descriptor configure and control register of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_LINK_CH1_OUTLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH1_OUTLINK_STOP_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_LINK_CH1_OUTLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH1_OUTLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_LINK_CH1_OUTLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH1_OUTLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_LINK_CH1_OUTLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH1_OUTLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x8) >> 3
}

// AHB_DMA.OUT_STATE_CH1: Transmit status of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_STATE_CH1_OUTLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0x3ffff)|value)
}
func (o *AHB_DMA_Type) GetOUT_STATE_CH1_OUTLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0x3ffff
}
func (o *AHB_DMA_Type) SetOUT_STATE_CH1_OUT_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0xc0000)|value<<18)
}
func (o *AHB_DMA_Type) GetOUT_STATE_CH1_OUT_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0xc0000) >> 18
}
func (o *AHB_DMA_Type) SetOUT_STATE_CH1_OUT_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0x700000)|value<<20)
}
func (o *AHB_DMA_Type) GetOUT_STATE_CH1_OUT_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0x700000) >> 20
}

// AHB_DMA.OUT_EOF_DES_ADDR_CH1: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH1.Reg)
}

// AHB_DMA.OUT_EOF_BFR_DES_ADDR_CH1: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH1.Reg)
}

// AHB_DMA.OUT_DSCR_CH1: Current inlink descriptor address of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_DSCR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_DSCR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH1.Reg)
}

// AHB_DMA.OUT_DSCR_BF0_CH1: The last inlink descriptor address of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_DSCR_BF0_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_DSCR_BF0_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH1.Reg)
}

// AHB_DMA.OUT_DSCR_BF1_CH1: The second-to-last inlink descriptor address of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_DSCR_BF1_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_DSCR_BF1_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH1.Reg)
}

// AHB_DMA.OUT_PRI_CH1: Priority register of Tx channel 0.
func (o *AHB_DMA_Type) SetOUT_PRI_CH1_TX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH1.Reg, volatile.LoadUint32(&o.OUT_PRI_CH1.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetOUT_PRI_CH1_TX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH1.Reg) & 0xf
}

// AHB_DMA.OUT_PERI_SEL_CH1: Peripheral selection of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_PERI_SEL_CH1_PERI_OUT_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH1.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH1.Reg)&^(0x3f)|value)
}
func (o *AHB_DMA_Type) GetOUT_PERI_SEL_CH1_PERI_OUT_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH1.Reg) & 0x3f
}

// AHB_DMA.IN_CONF0_CH2: Configure 0 register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_CONF0_CH2_IN_RST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH2_IN_RST_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH2_IN_LOOP_TEST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH2_IN_LOOP_TEST_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH2_INDSCR_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH2_INDSCR_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH2_IN_DATA_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH2_IN_DATA_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH2_MEM_TRANS_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH2_MEM_TRANS_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetIN_CONF0_CH2_IN_ETM_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetIN_CONF0_CH2_IN_ETM_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x20) >> 5
}

// AHB_DMA.IN_CONF1_CH2: Configure 1 register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_CONF1_CH2_IN_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH2.Reg, volatile.LoadUint32(&o.IN_CONF1_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *AHB_DMA_Type) GetIN_CONF1_CH2_IN_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH2.Reg) & 0x1000) >> 12
}

// AHB_DMA.INFIFO_STATUS_CH2: Receive FIFO status of Rx channel 0
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0xfc)|value<<2)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0xfc) >> 2
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x800000) >> 23
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1000000) >> 24
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2000000)|value<<25)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2000000) >> 25
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x4000000)|value<<26)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x4000000) >> 26
}
func (o *AHB_DMA_Type) SetINFIFO_STATUS_CH2_IN_BUF_HUNGRY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x8000000)|value<<27)
}
func (o *AHB_DMA_Type) GetINFIFO_STATUS_CH2_IN_BUF_HUNGRY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x8000000) >> 27
}

// AHB_DMA.IN_POP_CH2: Pop control register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_POP_CH2_INFIFO_RDATA_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH2.Reg, volatile.LoadUint32(&o.IN_POP_CH2.Reg)&^(0xfff)|value)
}
func (o *AHB_DMA_Type) GetIN_POP_CH2_INFIFO_RDATA_CH() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH2.Reg) & 0xfff
}
func (o *AHB_DMA_Type) SetIN_POP_CH2_INFIFO_POP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH2.Reg, volatile.LoadUint32(&o.IN_POP_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *AHB_DMA_Type) GetIN_POP_CH2_INFIFO_POP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH2.Reg) & 0x1000) >> 12
}

// AHB_DMA.IN_LINK_CH2: Link descriptor configure and control register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_LINK_CH2_INLINK_AUTO_RET_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH2_INLINK_AUTO_RET_CH() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetIN_LINK_CH2_INLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH2_INLINK_STOP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetIN_LINK_CH2_INLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH2_INLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetIN_LINK_CH2_INLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH2_INLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetIN_LINK_CH2_INLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetIN_LINK_CH2_INLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x10) >> 4
}

// AHB_DMA.IN_STATE_CH2: Receive status of Rx channel 0
func (o *AHB_DMA_Type) SetIN_STATE_CH2_INLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0x3ffff)|value)
}
func (o *AHB_DMA_Type) GetIN_STATE_CH2_INLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0x3ffff
}
func (o *AHB_DMA_Type) SetIN_STATE_CH2_IN_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0xc0000)|value<<18)
}
func (o *AHB_DMA_Type) GetIN_STATE_CH2_IN_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0xc0000) >> 18
}
func (o *AHB_DMA_Type) SetIN_STATE_CH2_IN_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0x700000)|value<<20)
}
func (o *AHB_DMA_Type) GetIN_STATE_CH2_IN_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0x700000) >> 20
}

// AHB_DMA.IN_SUC_EOF_DES_ADDR_CH2: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *AHB_DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH2.Reg)
}

// AHB_DMA.IN_ERR_EOF_DES_ADDR_CH2: Inlink descriptor address when errors occur of Rx channel 0
func (o *AHB_DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH2.Reg)
}

// AHB_DMA.IN_DSCR_CH2: Current inlink descriptor address of Rx channel 0
func (o *AHB_DMA_Type) SetIN_DSCR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_DSCR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH2.Reg)
}

// AHB_DMA.IN_DSCR_BF0_CH2: The last inlink descriptor address of Rx channel 0
func (o *AHB_DMA_Type) SetIN_DSCR_BF0_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_DSCR_BF0_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH2.Reg)
}

// AHB_DMA.IN_DSCR_BF1_CH2: The second-to-last inlink descriptor address of Rx channel 0
func (o *AHB_DMA_Type) SetIN_DSCR_BF1_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_DSCR_BF1_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH2.Reg)
}

// AHB_DMA.IN_PRI_CH2: Priority register of Rx channel 0
func (o *AHB_DMA_Type) SetIN_PRI_CH2_RX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH2.Reg, volatile.LoadUint32(&o.IN_PRI_CH2.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetIN_PRI_CH2_RX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH2.Reg) & 0xf
}

// AHB_DMA.IN_PERI_SEL_CH2: Peripheral selection of Rx channel 0
func (o *AHB_DMA_Type) SetIN_PERI_SEL_CH2_PERI_IN_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH2.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH2.Reg)&^(0x3f)|value)
}
func (o *AHB_DMA_Type) GetIN_PERI_SEL_CH2_PERI_IN_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH2.Reg) & 0x3f
}

// AHB_DMA.OUT_CONF0_CH1: Configure 0 register of Tx channel 1
func (o *AHB_DMA_Type) SetOUT_CONF0_CH1_OUT_RST_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH1_OUT_RST_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH1_OUT_LOOP_TEST_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH1_OUT_LOOP_TEST_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH1_OUT_AUTO_WRBACK_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH1_OUT_AUTO_WRBACK_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH1_OUT_EOF_MODE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH1_OUT_EOF_MODE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x8) >> 3
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH1_OUTDSCR_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH1_OUTDSCR_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x10) >> 4
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH1_OUT_DATA_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH1_OUT_DATA_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x20) >> 5
}
func (o *AHB_DMA_Type) SetOUT_CONF0_CH1_OUT_ETM_EN_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AHB_DMA_Type) GetOUT_CONF0_CH1_OUT_ETM_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x40) >> 6
}

// AHB_DMA.OUT_CONF1_CH2: Configure 1 register of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_CONF1_CH2_OUT_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *AHB_DMA_Type) GetOUT_CONF1_CH2_OUT_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg) & 0x1000) >> 12
}

// AHB_DMA.OUTFIFO_STATUS_CH2: Transmit FIFO status of Tx channel 0
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0xfc)|value<<2)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0xfc) >> 2
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x800000) >> 23
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1000000) >> 24
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2000000)|value<<25)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2000000) >> 25
}
func (o *AHB_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x4000000)|value<<26)
}
func (o *AHB_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x4000000) >> 26
}

// AHB_DMA.OUT_PUSH_CH2: Push control register of Rx channel 0
func (o *AHB_DMA_Type) SetOUT_PUSH_CH2_OUTFIFO_WDATA_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH2.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg)&^(0x1ff)|value)
}
func (o *AHB_DMA_Type) GetOUT_PUSH_CH2_OUTFIFO_WDATA_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg) & 0x1ff
}
func (o *AHB_DMA_Type) SetOUT_PUSH_CH2_OUTFIFO_PUSH_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH2.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AHB_DMA_Type) GetOUT_PUSH_CH2_OUTFIFO_PUSH_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg) & 0x200) >> 9
}

// AHB_DMA.OUT_LINK_CH2: Link descriptor configure and control register of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_LINK_CH2_OUTLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH2_OUTLINK_STOP_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x1
}
func (o *AHB_DMA_Type) SetOUT_LINK_CH2_OUTLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH2_OUTLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x2) >> 1
}
func (o *AHB_DMA_Type) SetOUT_LINK_CH2_OUTLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH2_OUTLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x4) >> 2
}
func (o *AHB_DMA_Type) SetOUT_LINK_CH2_OUTLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AHB_DMA_Type) GetOUT_LINK_CH2_OUTLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x8) >> 3
}

// AHB_DMA.OUT_STATE_CH2: Transmit status of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_STATE_CH2_OUTLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0x3ffff)|value)
}
func (o *AHB_DMA_Type) GetOUT_STATE_CH2_OUTLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0x3ffff
}
func (o *AHB_DMA_Type) SetOUT_STATE_CH2_OUT_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0xc0000)|value<<18)
}
func (o *AHB_DMA_Type) GetOUT_STATE_CH2_OUT_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0xc0000) >> 18
}
func (o *AHB_DMA_Type) SetOUT_STATE_CH2_OUT_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0x700000)|value<<20)
}
func (o *AHB_DMA_Type) GetOUT_STATE_CH2_OUT_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0x700000) >> 20
}

// AHB_DMA.OUT_EOF_DES_ADDR_CH2: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH2.Reg)
}

// AHB_DMA.OUT_EOF_BFR_DES_ADDR_CH2: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH2.Reg)
}

// AHB_DMA.OUT_DSCR_CH2: Current inlink descriptor address of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_DSCR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_DSCR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH2.Reg)
}

// AHB_DMA.OUT_DSCR_BF0_CH2: The last inlink descriptor address of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_DSCR_BF0_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_DSCR_BF0_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH2.Reg)
}

// AHB_DMA.OUT_DSCR_BF1_CH2: The second-to-last inlink descriptor address of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_DSCR_BF1_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_DSCR_BF1_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH2.Reg)
}

// AHB_DMA.OUT_PRI_CH2: Priority register of Tx channel 0.
func (o *AHB_DMA_Type) SetOUT_PRI_CH2_TX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH2.Reg, volatile.LoadUint32(&o.OUT_PRI_CH2.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetOUT_PRI_CH2_TX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH2.Reg) & 0xf
}

// AHB_DMA.OUT_PERI_SEL_CH2: Peripheral selection of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_PERI_SEL_CH2_PERI_OUT_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH2.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH2.Reg)&^(0x3f)|value)
}
func (o *AHB_DMA_Type) GetOUT_PERI_SEL_CH2_PERI_OUT_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH2.Reg) & 0x3f
}

// AHB_DMA.OUT_CRC_INIT_DATA_CH0: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AHB_DMA_Type) SetOUT_CRC_INIT_DATA_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_INIT_DATA_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_CRC_INIT_DATA_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_INIT_DATA_CH0.Reg)
}

// AHB_DMA.TX_CRC_WIDTH_CH0: This register is used to confiig tx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AHB_DMA_Type) SetTX_CRC_WIDTH_CH0_TX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH0.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH0.Reg)&^(0x3)|value)
}
func (o *AHB_DMA_Type) GetTX_CRC_WIDTH_CH0_TX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_WIDTH_CH0.Reg) & 0x3
}
func (o *AHB_DMA_Type) SetTX_CRC_WIDTH_CH0_TX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH0.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetTX_CRC_WIDTH_CH0_TX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.TX_CRC_WIDTH_CH0.Reg) & 0x4) >> 2
}

// AHB_DMA.OUT_CRC_CLEAR_CH0: This register is used to clear ch0 crc result
func (o *AHB_DMA_Type) SetOUT_CRC_CLEAR_CH0_OUT_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_CLEAR_CH0.Reg, volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_CRC_CLEAR_CH0_OUT_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH0.Reg) & 0x1
}

// AHB_DMA.OUT_CRC_FINAL_RESULT_CH0: This register is used to store ch0 crc result
func (o *AHB_DMA_Type) SetOUT_CRC_FINAL_RESULT_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_FINAL_RESULT_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_CRC_FINAL_RESULT_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_FINAL_RESULT_CH0.Reg)
}

// AHB_DMA.TX_CRC_EN_WR_DATA_CH0: This resister is used to config ch0 crc en for every bit
func (o *AHB_DMA_Type) SetTX_CRC_EN_WR_DATA_CH0(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_WR_DATA_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetTX_CRC_EN_WR_DATA_CH0() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_WR_DATA_CH0.Reg)
}

// AHB_DMA.TX_CRC_EN_ADDR_CH0: This register is used to config ch0 crc en addr
func (o *AHB_DMA_Type) SetTX_CRC_EN_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_ADDR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetTX_CRC_EN_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_ADDR_CH0.Reg)
}

// AHB_DMA.TX_CRC_DATA_EN_WR_DATA_CH0: This register is used to config crc data_8bit en
func (o *AHB_DMA_Type) SetTX_CRC_DATA_EN_WR_DATA_CH0_TX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH0.Reg, volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH0.Reg)&^(0xff)|value)
}
func (o *AHB_DMA_Type) GetTX_CRC_DATA_EN_WR_DATA_CH0_TX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH0.Reg) & 0xff
}

// AHB_DMA.TX_CRC_DATA_EN_ADDR_CH0: This register is used to config addr of crc data_8bit en
func (o *AHB_DMA_Type) SetTX_CRC_DATA_EN_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_ADDR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetTX_CRC_DATA_EN_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_ADDR_CH0.Reg)
}

// AHB_DMA.TX_CH_ARB_WEIGH_CH0: This register is used to config ch0 arbiter weigh
func (o *AHB_DMA_Type) SetTX_CH_ARB_WEIGH_CH0_TX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CH_ARB_WEIGH_CH0.Reg, volatile.LoadUint32(&o.TX_CH_ARB_WEIGH_CH0.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetTX_CH_ARB_WEIGH_CH0_TX_CH_ARB_WEIGH_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CH_ARB_WEIGH_CH0.Reg) & 0xf
}

// AHB_DMA.TX_ARB_WEIGH_OPT_DIR_CH0: This register is used to config off or on weigh optimization
func (o *AHB_DMA_Type) SetTX_ARB_WEIGH_OPT_DIR_CH0_TX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.TX_ARB_WEIGH_OPT_DIR_CH0.Reg, volatile.LoadUint32(&o.TX_ARB_WEIGH_OPT_DIR_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetTX_ARB_WEIGH_OPT_DIR_CH0_TX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return volatile.LoadUint32(&o.TX_ARB_WEIGH_OPT_DIR_CH0.Reg) & 0x1
}

// AHB_DMA.OUT_CRC_INIT_DATA_CH1: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AHB_DMA_Type) SetOUT_CRC_INIT_DATA_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_INIT_DATA_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_CRC_INIT_DATA_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_INIT_DATA_CH1.Reg)
}

// AHB_DMA.TX_CRC_WIDTH_CH1: This register is used to confiig tx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AHB_DMA_Type) SetTX_CRC_WIDTH_CH1_TX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH1.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH1.Reg)&^(0x3)|value)
}
func (o *AHB_DMA_Type) GetTX_CRC_WIDTH_CH1_TX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_WIDTH_CH1.Reg) & 0x3
}
func (o *AHB_DMA_Type) SetTX_CRC_WIDTH_CH1_TX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH1.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetTX_CRC_WIDTH_CH1_TX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.TX_CRC_WIDTH_CH1.Reg) & 0x4) >> 2
}

// AHB_DMA.OUT_CRC_CLEAR_CH1: This register is used to clear ch0 crc result
func (o *AHB_DMA_Type) SetOUT_CRC_CLEAR_CH1_OUT_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_CLEAR_CH1.Reg, volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_CRC_CLEAR_CH1_OUT_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH1.Reg) & 0x1
}

// AHB_DMA.OUT_CRC_FINAL_RESULT_CH1: This register is used to store ch0 crc result
func (o *AHB_DMA_Type) SetOUT_CRC_FINAL_RESULT_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_FINAL_RESULT_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_CRC_FINAL_RESULT_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_FINAL_RESULT_CH1.Reg)
}

// AHB_DMA.TX_CRC_EN_WR_DATA_CH1: This resister is used to config ch0 crc en for every bit
func (o *AHB_DMA_Type) SetTX_CRC_EN_WR_DATA_CH1(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_WR_DATA_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetTX_CRC_EN_WR_DATA_CH1() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_WR_DATA_CH1.Reg)
}

// AHB_DMA.TX_CRC_EN_ADDR_CH1: This register is used to config ch0 crc en addr
func (o *AHB_DMA_Type) SetTX_CRC_EN_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_ADDR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetTX_CRC_EN_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_ADDR_CH1.Reg)
}

// AHB_DMA.TX_CRC_DATA_EN_WR_DATA_CH1: This register is used to config crc data_8bit en
func (o *AHB_DMA_Type) SetTX_CRC_DATA_EN_WR_DATA_CH1_TX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH1.Reg, volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH1.Reg)&^(0xff)|value)
}
func (o *AHB_DMA_Type) GetTX_CRC_DATA_EN_WR_DATA_CH1_TX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH1.Reg) & 0xff
}

// AHB_DMA.TX_CRC_DATA_EN_ADDR_CH1: This register is used to config addr of crc data_8bit en
func (o *AHB_DMA_Type) SetTX_CRC_DATA_EN_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_ADDR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetTX_CRC_DATA_EN_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_ADDR_CH1.Reg)
}

// AHB_DMA.TX_CH_ARB_WEIGH_CH1: This register is used to config ch0 arbiter weigh
func (o *AHB_DMA_Type) SetTX_CH_ARB_WEIGH_CH1_TX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CH_ARB_WEIGH_CH1.Reg, volatile.LoadUint32(&o.TX_CH_ARB_WEIGH_CH1.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetTX_CH_ARB_WEIGH_CH1_TX_CH_ARB_WEIGH_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CH_ARB_WEIGH_CH1.Reg) & 0xf
}

// AHB_DMA.TX_ARB_WEIGH_OPT_DIR_CH1: This register is used to config off or on weigh optimization
func (o *AHB_DMA_Type) SetTX_ARB_WEIGH_OPT_DIR_CH1_TX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.TX_ARB_WEIGH_OPT_DIR_CH1.Reg, volatile.LoadUint32(&o.TX_ARB_WEIGH_OPT_DIR_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetTX_ARB_WEIGH_OPT_DIR_CH1_TX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return volatile.LoadUint32(&o.TX_ARB_WEIGH_OPT_DIR_CH1.Reg) & 0x1
}

// AHB_DMA.OUT_CRC_INIT_DATA_CH2: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AHB_DMA_Type) SetOUT_CRC_INIT_DATA_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_INIT_DATA_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_CRC_INIT_DATA_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_INIT_DATA_CH2.Reg)
}

// AHB_DMA.TX_CRC_WIDTH_CH2: This register is used to confiig tx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AHB_DMA_Type) SetTX_CRC_WIDTH_CH2_TX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH2.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH2.Reg)&^(0x3)|value)
}
func (o *AHB_DMA_Type) GetTX_CRC_WIDTH_CH2_TX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_WIDTH_CH2.Reg) & 0x3
}
func (o *AHB_DMA_Type) SetTX_CRC_WIDTH_CH2_TX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH2.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetTX_CRC_WIDTH_CH2_TX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.TX_CRC_WIDTH_CH2.Reg) & 0x4) >> 2
}

// AHB_DMA.OUT_CRC_CLEAR_CH2: This register is used to clear ch0 crc result
func (o *AHB_DMA_Type) SetOUT_CRC_CLEAR_CH2_OUT_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_CLEAR_CH2.Reg, volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetOUT_CRC_CLEAR_CH2_OUT_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH2.Reg) & 0x1
}

// AHB_DMA.OUT_CRC_FINAL_RESULT_CH2: This register is used to store ch0 crc result
func (o *AHB_DMA_Type) SetOUT_CRC_FINAL_RESULT_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_FINAL_RESULT_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_CRC_FINAL_RESULT_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_FINAL_RESULT_CH2.Reg)
}

// AHB_DMA.TX_CRC_EN_WR_DATA_CH2: This resister is used to config ch0 crc en for every bit
func (o *AHB_DMA_Type) SetTX_CRC_EN_WR_DATA_CH2(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_WR_DATA_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetTX_CRC_EN_WR_DATA_CH2() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_WR_DATA_CH2.Reg)
}

// AHB_DMA.TX_CRC_EN_ADDR_CH2: This register is used to config ch0 crc en addr
func (o *AHB_DMA_Type) SetTX_CRC_EN_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_ADDR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetTX_CRC_EN_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_ADDR_CH2.Reg)
}

// AHB_DMA.TX_CRC_DATA_EN_WR_DATA_CH2: This register is used to config crc data_8bit en
func (o *AHB_DMA_Type) SetTX_CRC_DATA_EN_WR_DATA_CH2_TX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH2.Reg, volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH2.Reg)&^(0xff)|value)
}
func (o *AHB_DMA_Type) GetTX_CRC_DATA_EN_WR_DATA_CH2_TX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH2.Reg) & 0xff
}

// AHB_DMA.TX_CRC_DATA_EN_ADDR_CH2: This register is used to config addr of crc data_8bit en
func (o *AHB_DMA_Type) SetTX_CRC_DATA_EN_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_ADDR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetTX_CRC_DATA_EN_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_ADDR_CH2.Reg)
}

// AHB_DMA.TX_CH_ARB_WEIGH_CH2: This register is used to config ch0 arbiter weigh
func (o *AHB_DMA_Type) SetTX_CH_ARB_WEIGH_CH2_TX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CH_ARB_WEIGH_CH2.Reg, volatile.LoadUint32(&o.TX_CH_ARB_WEIGH_CH2.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetTX_CH_ARB_WEIGH_CH2_TX_CH_ARB_WEIGH_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CH_ARB_WEIGH_CH2.Reg) & 0xf
}

// AHB_DMA.TX_ARB_WEIGH_OPT_DIR_CH2: This register is used to config off or on weigh optimization
func (o *AHB_DMA_Type) SetTX_ARB_WEIGH_OPT_DIR_CH2_TX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.TX_ARB_WEIGH_OPT_DIR_CH2.Reg, volatile.LoadUint32(&o.TX_ARB_WEIGH_OPT_DIR_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetTX_ARB_WEIGH_OPT_DIR_CH2_TX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return volatile.LoadUint32(&o.TX_ARB_WEIGH_OPT_DIR_CH2.Reg) & 0x1
}

// AHB_DMA.IN_CRC_INIT_DATA_CH0: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AHB_DMA_Type) SetIN_CRC_INIT_DATA_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_INIT_DATA_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_CRC_INIT_DATA_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_INIT_DATA_CH0.Reg)
}

// AHB_DMA.RX_CRC_WIDTH_CH0: This register is used to confiig rx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AHB_DMA_Type) SetRX_CRC_WIDTH_CH0_RX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH0.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH0.Reg)&^(0x3)|value)
}
func (o *AHB_DMA_Type) GetRX_CRC_WIDTH_CH0_RX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_WIDTH_CH0.Reg) & 0x3
}
func (o *AHB_DMA_Type) SetRX_CRC_WIDTH_CH0_RX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH0.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetRX_CRC_WIDTH_CH0_RX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.RX_CRC_WIDTH_CH0.Reg) & 0x4) >> 2
}

// AHB_DMA.IN_CRC_CLEAR_CH0: This register is used to clear ch0 crc result
func (o *AHB_DMA_Type) SetIN_CRC_CLEAR_CH0_IN_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_CLEAR_CH0.Reg, volatile.LoadUint32(&o.IN_CRC_CLEAR_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_CRC_CLEAR_CH0_IN_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_CLEAR_CH0.Reg) & 0x1
}

// AHB_DMA.IN_CRC_FINAL_RESULT_CH0: This register is used to store ch0 crc result
func (o *AHB_DMA_Type) SetIN_CRC_FINAL_RESULT_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_FINAL_RESULT_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_CRC_FINAL_RESULT_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_FINAL_RESULT_CH0.Reg)
}

// AHB_DMA.RX_CRC_EN_WR_DATA_CH0: This resister is used to config ch0 crc en for every bit
func (o *AHB_DMA_Type) SetRX_CRC_EN_WR_DATA_CH0(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_WR_DATA_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetRX_CRC_EN_WR_DATA_CH0() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_WR_DATA_CH0.Reg)
}

// AHB_DMA.RX_CRC_EN_ADDR_CH0: This register is used to config ch0 crc en addr
func (o *AHB_DMA_Type) SetRX_CRC_EN_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_ADDR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetRX_CRC_EN_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_ADDR_CH0.Reg)
}

// AHB_DMA.RX_CRC_DATA_EN_WR_DATA_CH0: This register is used to config crc data_8bit en
func (o *AHB_DMA_Type) SetRX_CRC_DATA_EN_WR_DATA_CH0_RX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH0.Reg, volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH0.Reg)&^(0xff)|value)
}
func (o *AHB_DMA_Type) GetRX_CRC_DATA_EN_WR_DATA_CH0_RX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH0.Reg) & 0xff
}

// AHB_DMA.RX_CRC_DATA_EN_ADDR_CH0: This register is used to config addr of crc data_8bit en
func (o *AHB_DMA_Type) SetRX_CRC_DATA_EN_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_ADDR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetRX_CRC_DATA_EN_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_ADDR_CH0.Reg)
}

// AHB_DMA.RX_CH_ARB_WEIGH_CH0: This register is used to config ch0 arbiter weigh
func (o *AHB_DMA_Type) SetRX_CH_ARB_WEIGH_CH0_RX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CH_ARB_WEIGH_CH0.Reg, volatile.LoadUint32(&o.RX_CH_ARB_WEIGH_CH0.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetRX_CH_ARB_WEIGH_CH0_RX_CH_ARB_WEIGH_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CH_ARB_WEIGH_CH0.Reg) & 0xf
}

// AHB_DMA.RX_ARB_WEIGH_OPT_DIR_CH0: This register is used to config off or on weigh optimization
func (o *AHB_DMA_Type) SetRX_ARB_WEIGH_OPT_DIR_CH0_RX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.RX_ARB_WEIGH_OPT_DIR_CH0.Reg, volatile.LoadUint32(&o.RX_ARB_WEIGH_OPT_DIR_CH0.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetRX_ARB_WEIGH_OPT_DIR_CH0_RX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return volatile.LoadUint32(&o.RX_ARB_WEIGH_OPT_DIR_CH0.Reg) & 0x1
}

// AHB_DMA.IN_CRC_INIT_DATA_CH1: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AHB_DMA_Type) SetIN_CRC_INIT_DATA_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_INIT_DATA_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_CRC_INIT_DATA_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_INIT_DATA_CH1.Reg)
}

// AHB_DMA.RX_CRC_WIDTH_CH1: This register is used to confiig rx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AHB_DMA_Type) SetRX_CRC_WIDTH_CH1_RX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH1.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH1.Reg)&^(0x3)|value)
}
func (o *AHB_DMA_Type) GetRX_CRC_WIDTH_CH1_RX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_WIDTH_CH1.Reg) & 0x3
}
func (o *AHB_DMA_Type) SetRX_CRC_WIDTH_CH1_RX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH1.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetRX_CRC_WIDTH_CH1_RX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.RX_CRC_WIDTH_CH1.Reg) & 0x4) >> 2
}

// AHB_DMA.IN_CRC_CLEAR_CH1: This register is used to clear ch0 crc result
func (o *AHB_DMA_Type) SetIN_CRC_CLEAR_CH1_IN_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_CLEAR_CH1.Reg, volatile.LoadUint32(&o.IN_CRC_CLEAR_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_CRC_CLEAR_CH1_IN_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_CLEAR_CH1.Reg) & 0x1
}

// AHB_DMA.IN_CRC_FINAL_RESULT_CH1: This register is used to store ch0 crc result
func (o *AHB_DMA_Type) SetIN_CRC_FINAL_RESULT_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_FINAL_RESULT_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_CRC_FINAL_RESULT_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_FINAL_RESULT_CH1.Reg)
}

// AHB_DMA.RX_CRC_EN_WR_DATA_CH1: This resister is used to config ch0 crc en for every bit
func (o *AHB_DMA_Type) SetRX_CRC_EN_WR_DATA_CH1(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_WR_DATA_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetRX_CRC_EN_WR_DATA_CH1() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_WR_DATA_CH1.Reg)
}

// AHB_DMA.RX_CRC_EN_ADDR_CH1: This register is used to config ch0 crc en addr
func (o *AHB_DMA_Type) SetRX_CRC_EN_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_ADDR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetRX_CRC_EN_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_ADDR_CH1.Reg)
}

// AHB_DMA.RX_CRC_DATA_EN_WR_DATA_CH1: This register is used to config crc data_8bit en
func (o *AHB_DMA_Type) SetRX_CRC_DATA_EN_WR_DATA_CH1_RX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH1.Reg, volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH1.Reg)&^(0xff)|value)
}
func (o *AHB_DMA_Type) GetRX_CRC_DATA_EN_WR_DATA_CH1_RX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH1.Reg) & 0xff
}

// AHB_DMA.RX_CRC_DATA_EN_ADDR_CH1: This register is used to config addr of crc data_8bit en
func (o *AHB_DMA_Type) SetRX_CRC_DATA_EN_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_ADDR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetRX_CRC_DATA_EN_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_ADDR_CH1.Reg)
}

// AHB_DMA.RX_CH_ARB_WEIGH_CH1: This register is used to config ch0 arbiter weigh
func (o *AHB_DMA_Type) SetRX_CH_ARB_WEIGH_CH1_RX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CH_ARB_WEIGH_CH1.Reg, volatile.LoadUint32(&o.RX_CH_ARB_WEIGH_CH1.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetRX_CH_ARB_WEIGH_CH1_RX_CH_ARB_WEIGH_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CH_ARB_WEIGH_CH1.Reg) & 0xf
}

// AHB_DMA.RX_ARB_WEIGH_OPT_DIR_CH1: This register is used to config off or on weigh optimization
func (o *AHB_DMA_Type) SetRX_ARB_WEIGH_OPT_DIR_CH1_RX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.RX_ARB_WEIGH_OPT_DIR_CH1.Reg, volatile.LoadUint32(&o.RX_ARB_WEIGH_OPT_DIR_CH1.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetRX_ARB_WEIGH_OPT_DIR_CH1_RX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return volatile.LoadUint32(&o.RX_ARB_WEIGH_OPT_DIR_CH1.Reg) & 0x1
}

// AHB_DMA.IN_CRC_INIT_DATA_CH2: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AHB_DMA_Type) SetIN_CRC_INIT_DATA_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_INIT_DATA_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_CRC_INIT_DATA_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_INIT_DATA_CH2.Reg)
}

// AHB_DMA.RX_CRC_WIDTH_CH2: This register is used to confiig rx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AHB_DMA_Type) SetRX_CRC_WIDTH_CH2_RX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH2.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH2.Reg)&^(0x3)|value)
}
func (o *AHB_DMA_Type) GetRX_CRC_WIDTH_CH2_RX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_WIDTH_CH2.Reg) & 0x3
}
func (o *AHB_DMA_Type) SetRX_CRC_WIDTH_CH2_RX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH2.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AHB_DMA_Type) GetRX_CRC_WIDTH_CH2_RX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.RX_CRC_WIDTH_CH2.Reg) & 0x4) >> 2
}

// AHB_DMA.IN_CRC_CLEAR_CH2: This register is used to clear ch0 crc result
func (o *AHB_DMA_Type) SetIN_CRC_CLEAR_CH2_IN_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_CLEAR_CH2.Reg, volatile.LoadUint32(&o.IN_CRC_CLEAR_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetIN_CRC_CLEAR_CH2_IN_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_CLEAR_CH2.Reg) & 0x1
}

// AHB_DMA.IN_CRC_FINAL_RESULT_CH2: This register is used to store ch0 crc result
func (o *AHB_DMA_Type) SetIN_CRC_FINAL_RESULT_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_FINAL_RESULT_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_CRC_FINAL_RESULT_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_FINAL_RESULT_CH2.Reg)
}

// AHB_DMA.RX_CRC_EN_WR_DATA_CH2: This resister is used to config ch0 crc en for every bit
func (o *AHB_DMA_Type) SetRX_CRC_EN_WR_DATA_CH2(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_WR_DATA_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetRX_CRC_EN_WR_DATA_CH2() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_WR_DATA_CH2.Reg)
}

// AHB_DMA.RX_CRC_EN_ADDR_CH2: This register is used to config ch0 crc en addr
func (o *AHB_DMA_Type) SetRX_CRC_EN_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_ADDR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetRX_CRC_EN_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_ADDR_CH2.Reg)
}

// AHB_DMA.RX_CRC_DATA_EN_WR_DATA_CH2: This register is used to config crc data_8bit en
func (o *AHB_DMA_Type) SetRX_CRC_DATA_EN_WR_DATA_CH2_RX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH2.Reg, volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH2.Reg)&^(0xff)|value)
}
func (o *AHB_DMA_Type) GetRX_CRC_DATA_EN_WR_DATA_CH2_RX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH2.Reg) & 0xff
}

// AHB_DMA.RX_CRC_DATA_EN_ADDR_CH2: This register is used to config addr of crc data_8bit en
func (o *AHB_DMA_Type) SetRX_CRC_DATA_EN_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_ADDR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetRX_CRC_DATA_EN_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_ADDR_CH2.Reg)
}

// AHB_DMA.RX_CH_ARB_WEIGH_CH2: This register is used to config ch0 arbiter weigh
func (o *AHB_DMA_Type) SetRX_CH_ARB_WEIGH_CH2_RX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CH_ARB_WEIGH_CH2.Reg, volatile.LoadUint32(&o.RX_CH_ARB_WEIGH_CH2.Reg)&^(0xf)|value)
}
func (o *AHB_DMA_Type) GetRX_CH_ARB_WEIGH_CH2_RX_CH_ARB_WEIGH_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CH_ARB_WEIGH_CH2.Reg) & 0xf
}

// AHB_DMA.RX_ARB_WEIGH_OPT_DIR_CH2: This register is used to config off or on weigh optimization
func (o *AHB_DMA_Type) SetRX_ARB_WEIGH_OPT_DIR_CH2_RX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.RX_ARB_WEIGH_OPT_DIR_CH2.Reg, volatile.LoadUint32(&o.RX_ARB_WEIGH_OPT_DIR_CH2.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetRX_ARB_WEIGH_OPT_DIR_CH2_RX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return volatile.LoadUint32(&o.RX_ARB_WEIGH_OPT_DIR_CH2.Reg) & 0x1
}

// AHB_DMA.IN_LINK_ADDR_CH0: Link descriptor configure of Rx channel 0
func (o *AHB_DMA_Type) SetIN_LINK_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_ADDR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_LINK_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_ADDR_CH0.Reg)
}

// AHB_DMA.IN_LINK_ADDR_CH1: Link descriptor configure of Rx channel 0
func (o *AHB_DMA_Type) SetIN_LINK_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_ADDR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_LINK_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_ADDR_CH1.Reg)
}

// AHB_DMA.IN_LINK_ADDR_CH2: Link descriptor configure of Rx channel 0
func (o *AHB_DMA_Type) SetIN_LINK_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_ADDR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetIN_LINK_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_ADDR_CH2.Reg)
}

// AHB_DMA.OUT_LINK_ADDR_CH0: Link descriptor configure of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_LINK_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_ADDR_CH0.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_LINK_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_ADDR_CH0.Reg)
}

// AHB_DMA.OUT_LINK_ADDR_CH1: Link descriptor configure of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_LINK_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_ADDR_CH1.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_LINK_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_ADDR_CH1.Reg)
}

// AHB_DMA.OUT_LINK_ADDR_CH2: Link descriptor configure of Tx channel 0
func (o *AHB_DMA_Type) SetOUT_LINK_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_ADDR_CH2.Reg, value)
}
func (o *AHB_DMA_Type) GetOUT_LINK_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_ADDR_CH2.Reg)
}

// AHB_DMA.INTR_MEM_START_ADDR: The start address of accessible address space.
func (o *AHB_DMA_Type) SetINTR_MEM_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.INTR_MEM_START_ADDR.Reg, value)
}
func (o *AHB_DMA_Type) GetINTR_MEM_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.INTR_MEM_START_ADDR.Reg)
}

// AHB_DMA.INTR_MEM_END_ADDR: The end address of accessible address space. The access address beyond this range would lead to descriptor error.
func (o *AHB_DMA_Type) SetINTR_MEM_END_ADDR(value uint32) {
	volatile.StoreUint32(&o.INTR_MEM_END_ADDR.Reg, value)
}
func (o *AHB_DMA_Type) GetINTR_MEM_END_ADDR() uint32 {
	return volatile.LoadUint32(&o.INTR_MEM_END_ADDR.Reg)
}

// AHB_DMA.ARB_TIMEOUT_TX: This retister is used to config arbiter time slice for tx dir
func (o *AHB_DMA_Type) SetARB_TIMEOUT_TX(value uint32) {
	volatile.StoreUint32(&o.ARB_TIMEOUT_TX.Reg, volatile.LoadUint32(&o.ARB_TIMEOUT_TX.Reg)&^(0xffff)|value)
}
func (o *AHB_DMA_Type) GetARB_TIMEOUT_TX() uint32 {
	return volatile.LoadUint32(&o.ARB_TIMEOUT_TX.Reg) & 0xffff
}

// AHB_DMA.ARB_TIMEOUT_RX: This retister is used to config arbiter time slice for rx dir
func (o *AHB_DMA_Type) SetARB_TIMEOUT_RX(value uint32) {
	volatile.StoreUint32(&o.ARB_TIMEOUT_RX.Reg, volatile.LoadUint32(&o.ARB_TIMEOUT_RX.Reg)&^(0xffff)|value)
}
func (o *AHB_DMA_Type) GetARB_TIMEOUT_RX() uint32 {
	return volatile.LoadUint32(&o.ARB_TIMEOUT_RX.Reg) & 0xffff
}

// AHB_DMA.WEIGHT_EN_TX: This register is used to config arbiter weigh function to on or off for tx dir
func (o *AHB_DMA_Type) SetWEIGHT_EN_TX(value uint32) {
	volatile.StoreUint32(&o.WEIGHT_EN_TX.Reg, volatile.LoadUint32(&o.WEIGHT_EN_TX.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetWEIGHT_EN_TX() uint32 {
	return volatile.LoadUint32(&o.WEIGHT_EN_TX.Reg) & 0x1
}

// AHB_DMA.WEIGHT_EN_RX: This register is used to config arbiter weigh function to on or off for rx dir
func (o *AHB_DMA_Type) SetWEIGHT_EN_RX(value uint32) {
	volatile.StoreUint32(&o.WEIGHT_EN_RX.Reg, volatile.LoadUint32(&o.WEIGHT_EN_RX.Reg)&^(0x1)|value)
}
func (o *AHB_DMA_Type) GetWEIGHT_EN_RX() uint32 {
	return volatile.LoadUint32(&o.WEIGHT_EN_RX.Reg) & 0x1
}

// LP_I2C_ANA_MST Peripheral
type ANA_I2C_MST_Type struct {
	I2C0_CTRL        volatile.Register32 // 0x0
	I2C1_CTRL        volatile.Register32 // 0x4
	I2C0_CONF        volatile.Register32 // 0x8
	I2C1_CONF        volatile.Register32 // 0xC
	I2C_BURST_CONF   volatile.Register32 // 0x10
	I2C_BURST_STATUS volatile.Register32 // 0x14
	ANA_CONF0        volatile.Register32 // 0x18
	ANA_CONF1        volatile.Register32 // 0x1C
	ANA_CONF2        volatile.Register32 // 0x20
	I2C0_CTRL1       volatile.Register32 // 0x24
	I2C1_CTRL1       volatile.Register32 // 0x28
	HW_I2C_CTRL      volatile.Register32 // 0x2C
	NOUSE            volatile.Register32 // 0x30
	CLK160M          volatile.Register32 // 0x34
	DATE             volatile.Register32 // 0x38
}

// ANA_I2C_MST.I2C0_CTRL: need des
func (o *ANA_I2C_MST_Type) SetI2C0_CTRL(value uint32) {
	volatile.StoreUint32(&o.I2C0_CTRL.Reg, volatile.LoadUint32(&o.I2C0_CTRL.Reg)&^(0x1ffffff)|value)
}
func (o *ANA_I2C_MST_Type) GetI2C0_CTRL() uint32 {
	return volatile.LoadUint32(&o.I2C0_CTRL.Reg) & 0x1ffffff
}
func (o *ANA_I2C_MST_Type) SetI2C0_CTRL_I2C0_BUSY(value uint32) {
	volatile.StoreUint32(&o.I2C0_CTRL.Reg, volatile.LoadUint32(&o.I2C0_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *ANA_I2C_MST_Type) GetI2C0_CTRL_I2C0_BUSY() uint32 {
	return (volatile.LoadUint32(&o.I2C0_CTRL.Reg) & 0x2000000) >> 25
}

// ANA_I2C_MST.I2C1_CTRL: need des
func (o *ANA_I2C_MST_Type) SetI2C1_CTRL(value uint32) {
	volatile.StoreUint32(&o.I2C1_CTRL.Reg, volatile.LoadUint32(&o.I2C1_CTRL.Reg)&^(0x1ffffff)|value)
}
func (o *ANA_I2C_MST_Type) GetI2C1_CTRL() uint32 {
	return volatile.LoadUint32(&o.I2C1_CTRL.Reg) & 0x1ffffff
}
func (o *ANA_I2C_MST_Type) SetI2C1_CTRL_I2C1_BUSY(value uint32) {
	volatile.StoreUint32(&o.I2C1_CTRL.Reg, volatile.LoadUint32(&o.I2C1_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *ANA_I2C_MST_Type) GetI2C1_CTRL_I2C1_BUSY() uint32 {
	return (volatile.LoadUint32(&o.I2C1_CTRL.Reg) & 0x2000000) >> 25
}

// ANA_I2C_MST.I2C0_CONF: need des
func (o *ANA_I2C_MST_Type) SetI2C0_CONF(value uint32) {
	volatile.StoreUint32(&o.I2C0_CONF.Reg, volatile.LoadUint32(&o.I2C0_CONF.Reg)&^(0xffffff)|value)
}
func (o *ANA_I2C_MST_Type) GetI2C0_CONF() uint32 {
	return volatile.LoadUint32(&o.I2C0_CONF.Reg) & 0xffffff
}
func (o *ANA_I2C_MST_Type) SetI2C0_CONF_I2C0_STATUS(value uint32) {
	volatile.StoreUint32(&o.I2C0_CONF.Reg, volatile.LoadUint32(&o.I2C0_CONF.Reg)&^(0xff000000)|value<<24)
}
func (o *ANA_I2C_MST_Type) GetI2C0_CONF_I2C0_STATUS() uint32 {
	return (volatile.LoadUint32(&o.I2C0_CONF.Reg) & 0xff000000) >> 24
}

// ANA_I2C_MST.I2C1_CONF: need des
func (o *ANA_I2C_MST_Type) SetI2C1_CONF(value uint32) {
	volatile.StoreUint32(&o.I2C1_CONF.Reg, volatile.LoadUint32(&o.I2C1_CONF.Reg)&^(0xffffff)|value)
}
func (o *ANA_I2C_MST_Type) GetI2C1_CONF() uint32 {
	return volatile.LoadUint32(&o.I2C1_CONF.Reg) & 0xffffff
}
func (o *ANA_I2C_MST_Type) SetI2C1_CONF_I2C1_STATUS(value uint32) {
	volatile.StoreUint32(&o.I2C1_CONF.Reg, volatile.LoadUint32(&o.I2C1_CONF.Reg)&^(0xff000000)|value<<24)
}
func (o *ANA_I2C_MST_Type) GetI2C1_CONF_I2C1_STATUS() uint32 {
	return (volatile.LoadUint32(&o.I2C1_CONF.Reg) & 0xff000000) >> 24
}

// ANA_I2C_MST.I2C_BURST_CONF: need des
func (o *ANA_I2C_MST_Type) SetI2C_BURST_CONF(value uint32) {
	volatile.StoreUint32(&o.I2C_BURST_CONF.Reg, value)
}
func (o *ANA_I2C_MST_Type) GetI2C_BURST_CONF() uint32 {
	return volatile.LoadUint32(&o.I2C_BURST_CONF.Reg)
}

// ANA_I2C_MST.I2C_BURST_STATUS: need des
func (o *ANA_I2C_MST_Type) SetI2C_BURST_STATUS_I2C_MST_BURST_DONE(value uint32) {
	volatile.StoreUint32(&o.I2C_BURST_STATUS.Reg, volatile.LoadUint32(&o.I2C_BURST_STATUS.Reg)&^(0x1)|value)
}
func (o *ANA_I2C_MST_Type) GetI2C_BURST_STATUS_I2C_MST_BURST_DONE() uint32 {
	return volatile.LoadUint32(&o.I2C_BURST_STATUS.Reg) & 0x1
}
func (o *ANA_I2C_MST_Type) SetI2C_BURST_STATUS_I2C_MST0_BURST_ERR_FLAG(value uint32) {
	volatile.StoreUint32(&o.I2C_BURST_STATUS.Reg, volatile.LoadUint32(&o.I2C_BURST_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *ANA_I2C_MST_Type) GetI2C_BURST_STATUS_I2C_MST0_BURST_ERR_FLAG() uint32 {
	return (volatile.LoadUint32(&o.I2C_BURST_STATUS.Reg) & 0x2) >> 1
}
func (o *ANA_I2C_MST_Type) SetI2C_BURST_STATUS_I2C_MST1_BURST_ERR_FLAG(value uint32) {
	volatile.StoreUint32(&o.I2C_BURST_STATUS.Reg, volatile.LoadUint32(&o.I2C_BURST_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *ANA_I2C_MST_Type) GetI2C_BURST_STATUS_I2C_MST1_BURST_ERR_FLAG() uint32 {
	return (volatile.LoadUint32(&o.I2C_BURST_STATUS.Reg) & 0x4) >> 2
}
func (o *ANA_I2C_MST_Type) SetI2C_BURST_STATUS_I2C_MST_BURST_TIMEOUT_CNT(value uint32) {
	volatile.StoreUint32(&o.I2C_BURST_STATUS.Reg, volatile.LoadUint32(&o.I2C_BURST_STATUS.Reg)&^(0xfff00000)|value<<20)
}
func (o *ANA_I2C_MST_Type) GetI2C_BURST_STATUS_I2C_MST_BURST_TIMEOUT_CNT() uint32 {
	return (volatile.LoadUint32(&o.I2C_BURST_STATUS.Reg) & 0xfff00000) >> 20
}

// ANA_I2C_MST.ANA_CONF0: need des
func (o *ANA_I2C_MST_Type) SetANA_CONF0(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF0.Reg, volatile.LoadUint32(&o.ANA_CONF0.Reg)&^(0xffffff)|value)
}
func (o *ANA_I2C_MST_Type) GetANA_CONF0() uint32 {
	return volatile.LoadUint32(&o.ANA_CONF0.Reg) & 0xffffff
}
func (o *ANA_I2C_MST_Type) SetANA_CONF0_ANA_STATUS0(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF0.Reg, volatile.LoadUint32(&o.ANA_CONF0.Reg)&^(0xff000000)|value<<24)
}
func (o *ANA_I2C_MST_Type) GetANA_CONF0_ANA_STATUS0() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF0.Reg) & 0xff000000) >> 24
}

// ANA_I2C_MST.ANA_CONF1: need des
func (o *ANA_I2C_MST_Type) SetANA_CONF1(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF1.Reg, volatile.LoadUint32(&o.ANA_CONF1.Reg)&^(0xffffff)|value)
}
func (o *ANA_I2C_MST_Type) GetANA_CONF1() uint32 {
	return volatile.LoadUint32(&o.ANA_CONF1.Reg) & 0xffffff
}
func (o *ANA_I2C_MST_Type) SetANA_CONF1_ANA_STATUS1(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF1.Reg, volatile.LoadUint32(&o.ANA_CONF1.Reg)&^(0xff000000)|value<<24)
}
func (o *ANA_I2C_MST_Type) GetANA_CONF1_ANA_STATUS1() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF1.Reg) & 0xff000000) >> 24
}

// ANA_I2C_MST.ANA_CONF2: need des
func (o *ANA_I2C_MST_Type) SetANA_CONF2(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF2.Reg, volatile.LoadUint32(&o.ANA_CONF2.Reg)&^(0xffffff)|value)
}
func (o *ANA_I2C_MST_Type) GetANA_CONF2() uint32 {
	return volatile.LoadUint32(&o.ANA_CONF2.Reg) & 0xffffff
}
func (o *ANA_I2C_MST_Type) SetANA_CONF2_ANA_STATUS2(value uint32) {
	volatile.StoreUint32(&o.ANA_CONF2.Reg, volatile.LoadUint32(&o.ANA_CONF2.Reg)&^(0xff000000)|value<<24)
}
func (o *ANA_I2C_MST_Type) GetANA_CONF2_ANA_STATUS2() uint32 {
	return (volatile.LoadUint32(&o.ANA_CONF2.Reg) & 0xff000000) >> 24
}

// ANA_I2C_MST.I2C0_CTRL1: need des
func (o *ANA_I2C_MST_Type) SetI2C0_CTRL1_I2C0_SCL_PULSE_DUR(value uint32) {
	volatile.StoreUint32(&o.I2C0_CTRL1.Reg, volatile.LoadUint32(&o.I2C0_CTRL1.Reg)&^(0x3f)|value)
}
func (o *ANA_I2C_MST_Type) GetI2C0_CTRL1_I2C0_SCL_PULSE_DUR() uint32 {
	return volatile.LoadUint32(&o.I2C0_CTRL1.Reg) & 0x3f
}
func (o *ANA_I2C_MST_Type) SetI2C0_CTRL1_I2C0_SDA_SIDE_GUARD(value uint32) {
	volatile.StoreUint32(&o.I2C0_CTRL1.Reg, volatile.LoadUint32(&o.I2C0_CTRL1.Reg)&^(0x7c0)|value<<6)
}
func (o *ANA_I2C_MST_Type) GetI2C0_CTRL1_I2C0_SDA_SIDE_GUARD() uint32 {
	return (volatile.LoadUint32(&o.I2C0_CTRL1.Reg) & 0x7c0) >> 6
}

// ANA_I2C_MST.I2C1_CTRL1: need des
func (o *ANA_I2C_MST_Type) SetI2C1_CTRL1_I2C1_SCL_PULSE_DUR(value uint32) {
	volatile.StoreUint32(&o.I2C1_CTRL1.Reg, volatile.LoadUint32(&o.I2C1_CTRL1.Reg)&^(0x3f)|value)
}
func (o *ANA_I2C_MST_Type) GetI2C1_CTRL1_I2C1_SCL_PULSE_DUR() uint32 {
	return volatile.LoadUint32(&o.I2C1_CTRL1.Reg) & 0x3f
}
func (o *ANA_I2C_MST_Type) SetI2C1_CTRL1_I2C1_SDA_SIDE_GUARD(value uint32) {
	volatile.StoreUint32(&o.I2C1_CTRL1.Reg, volatile.LoadUint32(&o.I2C1_CTRL1.Reg)&^(0x7c0)|value<<6)
}
func (o *ANA_I2C_MST_Type) GetI2C1_CTRL1_I2C1_SDA_SIDE_GUARD() uint32 {
	return (volatile.LoadUint32(&o.I2C1_CTRL1.Reg) & 0x7c0) >> 6
}

// ANA_I2C_MST.HW_I2C_CTRL: need des
func (o *ANA_I2C_MST_Type) SetHW_I2C_CTRL_HW_I2C_SCL_PULSE_DUR(value uint32) {
	volatile.StoreUint32(&o.HW_I2C_CTRL.Reg, volatile.LoadUint32(&o.HW_I2C_CTRL.Reg)&^(0x3f)|value)
}
func (o *ANA_I2C_MST_Type) GetHW_I2C_CTRL_HW_I2C_SCL_PULSE_DUR() uint32 {
	return volatile.LoadUint32(&o.HW_I2C_CTRL.Reg) & 0x3f
}
func (o *ANA_I2C_MST_Type) SetHW_I2C_CTRL_HW_I2C_SDA_SIDE_GUARD(value uint32) {
	volatile.StoreUint32(&o.HW_I2C_CTRL.Reg, volatile.LoadUint32(&o.HW_I2C_CTRL.Reg)&^(0x7c0)|value<<6)
}
func (o *ANA_I2C_MST_Type) GetHW_I2C_CTRL_HW_I2C_SDA_SIDE_GUARD() uint32 {
	return (volatile.LoadUint32(&o.HW_I2C_CTRL.Reg) & 0x7c0) >> 6
}
func (o *ANA_I2C_MST_Type) SetHW_I2C_CTRL_ARBITER_DIS(value uint32) {
	volatile.StoreUint32(&o.HW_I2C_CTRL.Reg, volatile.LoadUint32(&o.HW_I2C_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *ANA_I2C_MST_Type) GetHW_I2C_CTRL_ARBITER_DIS() uint32 {
	return (volatile.LoadUint32(&o.HW_I2C_CTRL.Reg) & 0x800) >> 11
}

// ANA_I2C_MST.NOUSE: need des
func (o *ANA_I2C_MST_Type) SetNOUSE(value uint32) {
	volatile.StoreUint32(&o.NOUSE.Reg, value)
}
func (o *ANA_I2C_MST_Type) GetNOUSE() uint32 {
	return volatile.LoadUint32(&o.NOUSE.Reg)
}

// ANA_I2C_MST.CLK160M: need des
func (o *ANA_I2C_MST_Type) SetCLK160M_CLK_I2C_MST_SEL_160M(value uint32) {
	volatile.StoreUint32(&o.CLK160M.Reg, volatile.LoadUint32(&o.CLK160M.Reg)&^(0x1)|value)
}
func (o *ANA_I2C_MST_Type) GetCLK160M_CLK_I2C_MST_SEL_160M() uint32 {
	return volatile.LoadUint32(&o.CLK160M.Reg) & 0x1
}

// ANA_I2C_MST.DATE: need des
func (o *ANA_I2C_MST_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *ANA_I2C_MST_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}
func (o *ANA_I2C_MST_Type) SetDATE_I2C_MST_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x10000000)|value<<28)
}
func (o *ANA_I2C_MST_Type) GetDATE_I2C_MST_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.DATE.Reg) & 0x10000000) >> 28
}

// Debug Assist
type ASSIST_DEBUG_Type struct {
	CORE_0_INTR_ENA                        volatile.Register32 // 0x0
	CORE_0_INTR_RAW                        volatile.Register32 // 0x4
	CORE_0_INTR_RLS                        volatile.Register32 // 0x8
	CORE_0_INTR_CLR                        volatile.Register32 // 0xC
	CORE_0_AREA_DRAM0_0_MIN                volatile.Register32 // 0x10
	CORE_0_AREA_DRAM0_0_MAX                volatile.Register32 // 0x14
	CORE_0_AREA_DRAM0_1_MIN                volatile.Register32 // 0x18
	CORE_0_AREA_DRAM0_1_MAX                volatile.Register32 // 0x1C
	CORE_0_AREA_PIF_0_MIN                  volatile.Register32 // 0x20
	CORE_0_AREA_PIF_0_MAX                  volatile.Register32 // 0x24
	CORE_0_AREA_PIF_1_MIN                  volatile.Register32 // 0x28
	CORE_0_AREA_PIF_1_MAX                  volatile.Register32 // 0x2C
	CORE_0_AREA_PC                         volatile.Register32 // 0x30
	CORE_0_AREA_SP                         volatile.Register32 // 0x34
	CORE_0_SP_MIN                          volatile.Register32 // 0x38
	CORE_0_SP_MAX                          volatile.Register32 // 0x3C
	CORE_0_SP_PC                           volatile.Register32 // 0x40
	CORE_0_RCD_EN                          volatile.Register32 // 0x44
	CORE_0_RCD_PDEBUGPC                    volatile.Register32 // 0x48
	CORE_0_RCD_PDEBUGSP                    volatile.Register32 // 0x4C
	CORE_0_IRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0x50
	CORE_0_IRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0x54
	CORE_0_DRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0x58
	CORE_0_DRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0x5C
	CORE_0_DRAM0_EXCEPTION_MONITOR_2       volatile.Register32 // 0x60
	CORE_0_DRAM0_EXCEPTION_MONITOR_3       volatile.Register32 // 0x64
	CORE_0_DRAM0_EXCEPTION_MONITOR_4       volatile.Register32 // 0x68
	CORE_0_DRAM0_EXCEPTION_MONITOR_5       volatile.Register32 // 0x6C
	CORE_0_LASTPC_BEFORE_EXCEPTION         volatile.Register32 // 0x70
	CORE_0_DEBUG_MODE                      volatile.Register32 // 0x74
	_                                      [8]byte
	CORE_1_INTR_ENA                        volatile.Register32 // 0x80
	CORE_1_INTR_RAW                        volatile.Register32 // 0x84
	CORE_1_INTR_RLS                        volatile.Register32 // 0x88
	CORE_1_INTR_CLR                        volatile.Register32 // 0x8C
	CORE_1_AREA_DRAM0_0_MIN                volatile.Register32 // 0x90
	CORE_1_AREA_DRAM0_0_MAX                volatile.Register32 // 0x94
	CORE_1_AREA_DRAM0_1_MIN                volatile.Register32 // 0x98
	CORE_1_AREA_DRAM0_1_MAX                volatile.Register32 // 0x9C
	CORE_1_AREA_PIF_0_MIN                  volatile.Register32 // 0xA0
	CORE_1_AREA_PIF_0_MAX                  volatile.Register32 // 0xA4
	CORE_1_AREA_PIF_1_MIN                  volatile.Register32 // 0xA8
	CORE_1_AREA_PIF_1_MAX                  volatile.Register32 // 0xAC
	CORE_1_AREA_PC                         volatile.Register32 // 0xB0
	CORE_1_AREA_SP                         volatile.Register32 // 0xB4
	CORE_1_SP_MIN                          volatile.Register32 // 0xB8
	CORE_1_SP_MAX                          volatile.Register32 // 0xBC
	CORE_1_SP_PC                           volatile.Register32 // 0xC0
	CORE_1_RCD_EN                          volatile.Register32 // 0xC4
	CORE_1_RCD_PDEBUGPC                    volatile.Register32 // 0xC8
	CORE_1_RCD_PDEBUGSP                    volatile.Register32 // 0xCC
	CORE_1_IRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0xD0
	CORE_1_IRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0xD4
	CORE_1_DRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0xD8
	CORE_1_DRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0xDC
	CORE_1_DRAM0_EXCEPTION_MONITOR_2       volatile.Register32 // 0xE0
	CORE_1_DRAM0_EXCEPTION_MONITOR_3       volatile.Register32 // 0xE4
	CORE_1_DRAM0_EXCEPTION_MONITOR_4       volatile.Register32 // 0xE8
	CORE_1_DRAM0_EXCEPTION_MONITOR_5       volatile.Register32 // 0xEC
	CORE_1_LASTPC_BEFORE_EXCEPTION         volatile.Register32 // 0xF0
	CORE_1_DEBUG_MODE                      volatile.Register32 // 0xF4
	_                                      [8]byte
	CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0 volatile.Register32 // 0x100
	CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1 volatile.Register32 // 0x104
	CLOCK_GATE                             volatile.Register32 // 0x108
	_                                      [752]byte
	DATE                                   volatile.Register32 // 0x3FC
}

// ASSIST_DEBUG.CORE_0_INTR_ENA: core0 monitor enable configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_RD_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MIN_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MIN_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MAX_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MAX_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_INTR_RAW: core0 monitor interrupt status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_RD_RAW() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MIN_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MIN_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MAX_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MAX_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_IRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_IRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_DRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_DRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_INTR_RLS: core0 monitor interrupt enable register
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_AREA_DRAM0_0_RD_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_AREA_DRAM0_0_RD_RLS() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_AREA_DRAM0_0_WR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_AREA_DRAM0_0_WR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_AREA_DRAM0_1_RD_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_AREA_DRAM0_1_RD_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_AREA_DRAM0_1_WR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_AREA_DRAM0_1_WR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_AREA_PIF_0_RD_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_AREA_PIF_0_RD_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_AREA_PIF_0_WR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_AREA_PIF_0_WR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_AREA_PIF_1_RD_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_AREA_PIF_1_RD_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_AREA_PIF_1_WR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_AREA_PIF_1_WR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_SP_SPILL_MIN_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_SP_SPILL_MIN_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_SP_SPILL_MAX_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_SP_SPILL_MAX_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_IRAM0_EXCEPTION_MONITOR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_IRAM0_EXCEPTION_MONITOR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RLS_CORE_0_DRAM0_EXCEPTION_MONITOR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RLS_CORE_0_DRAM0_EXCEPTION_MONITOR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RLS.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_INTR_CLR: core0 monitor interrupt clr register
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_RD_CLR() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MIN_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MIN_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MAX_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MAX_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_IRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_IRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_DRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_DRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_0_MIN: core0 dram0 region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_0_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_0_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_0_MAX: core0 dram0 region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_0_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_0_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_1_MIN: core0 dram0 region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_1_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_1_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_1_MAX: core0 dram0 region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_1_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_1_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_0_MIN: core0 PIF region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_0_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_0_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_0_MAX: core0 PIF region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_0_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_0_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_1_MIN: core0 PIF region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_1_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_1_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_1_MAX: core0 PIF region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_1_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_1_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PC: core0 area pc status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PC.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_SP: core0 area sp status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_SP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_SP.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_SP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_SP.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_MIN: stack min value
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_MAX: stack max value
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_PC: stack monitor pc status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_PC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_PC.Reg)
}

// ASSIST_DEBUG.CORE_0_RCD_EN: record enable configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_EN_CORE_0_RCD_RECORDEN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_EN.Reg, volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_EN_CORE_0_RCD_RECORDEN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_EN_CORE_0_RCD_PDEBUGEN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_EN.Reg, volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_EN_CORE_0_RCD_PDEBUGEN() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_0_RCD_PDEBUGPC: record status regsiter
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_PDEBUGPC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGPC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_PDEBUGPC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGPC.Reg)
}

// ASSIST_DEBUG.CORE_0_RCD_PDEBUGSP: record status regsiter
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_PDEBUGSP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGSP.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_PDEBUGSP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGSP.Reg)
}

// ASSIST_DEBUG.CORE_0_IRAM0_EXCEPTION_MONITOR_0: exception monitor status register0
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_WR_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_LOADSTORE_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x2000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_LOADSTORE_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x2000000) >> 25
}

// ASSIST_DEBUG.CORE_0_IRAM0_EXCEPTION_MONITOR_1: exception monitor status register1
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_WR_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_LOADSTORE_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x2000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_LOADSTORE_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x2000000) >> 25
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_0: exception monitor status register2
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_WR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_BYTEEN_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1fffe)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_BYTEEN_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1fffe) >> 1
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_1: exception monitor status register3
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_1_CORE_0_DRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_1_CORE_0_DRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_1.Reg) & 0xffffff
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_2: exception monitor status register4
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_2(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_2() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg)
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_3: exception monitor status register5
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_3_CORE_0_DRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_3_CORE_0_DRAM0_RECORDING_WR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_3_CORE_0_DRAM0_RECORDING_BYTEEN_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg)&^(0x1fffe)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_3_CORE_0_DRAM0_RECORDING_BYTEEN_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg) & 0x1fffe) >> 1
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_4: exception monitor status register6
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_4_CORE_0_DRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_4.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_4.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_4_CORE_0_DRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_4.Reg) & 0xffffff
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_5: exception monitor status register7
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_5(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_5.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_5() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_5.Reg)
}

// ASSIST_DEBUG.CORE_0_LASTPC_BEFORE_EXCEPTION: cpu status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_LASTPC_BEFORE_EXCEPTION(value uint32) {
	volatile.StoreUint32(&o.CORE_0_LASTPC_BEFORE_EXCEPTION.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_LASTPC_BEFORE_EXCEPTION() uint32 {
	return volatile.LoadUint32(&o.CORE_0_LASTPC_BEFORE_EXCEPTION.Reg)
}

// ASSIST_DEBUG.CORE_0_DEBUG_MODE: cpu status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_DEBUG_MODE(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DEBUG_MODE.Reg, volatile.LoadUint32(&o.CORE_0_DEBUG_MODE.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DEBUG_MODE() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DEBUG_MODE.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DEBUG_MODE_CORE_0_DEBUG_MODULE_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DEBUG_MODE.Reg, volatile.LoadUint32(&o.CORE_0_DEBUG_MODE.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DEBUG_MODE_CORE_0_DEBUG_MODULE_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DEBUG_MODE.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_1_INTR_ENA: core1 monitor enable configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_0_RD_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_DRAM0_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_PIF_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_PIF_0_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_PIF_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_PIF_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_PIF_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_PIF_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_AREA_PIF_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_AREA_PIF_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_SP_SPILL_MIN_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_SP_SPILL_MIN_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_SP_SPILL_MAX_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_SP_SPILL_MAX_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_IRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_IRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_ENA_CORE_1_DRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_ENA_CORE_1_DRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_ENA.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_1_INTR_RAW: core1 monitor interrupt status register
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_0_RD_RAW() uint32 {
	return volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_DRAM0_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_PIF_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_PIF_0_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_PIF_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_PIF_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_PIF_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_PIF_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_AREA_PIF_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_AREA_PIF_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_SP_SPILL_MIN_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_SP_SPILL_MIN_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_SP_SPILL_MAX_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_SP_SPILL_MAX_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_IRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_IRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RAW_CORE_1_DRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RAW_CORE_1_DRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RAW.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_1_INTR_RLS: core1 monitor interrupt enable register
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_AREA_DRAM0_0_RD_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_AREA_DRAM0_0_RD_RLS() uint32 {
	return volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_AREA_DRAM0_0_WR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_AREA_DRAM0_0_WR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_AREA_DRAM0_1_RD_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_AREA_DRAM0_1_RD_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_AREA_DRAM0_1_WR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_AREA_DRAM0_1_WR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_AREA_PIF_0_RD_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_AREA_PIF_0_RD_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_AREA_PIF_0_WR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_AREA_PIF_0_WR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_AREA_PIF_1_RD_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_AREA_PIF_1_RD_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_AREA_PIF_1_WR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_AREA_PIF_1_WR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_SP_SPILL_MIN_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_SP_SPILL_MIN_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_SP_SPILL_MAX_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_SP_SPILL_MAX_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_IRAM0_EXCEPTION_MONITOR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_IRAM0_EXCEPTION_MONITOR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_RLS_CORE_1_DRAM0_EXCEPTION_MONITOR_RLS(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_RLS.Reg, volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_RLS_CORE_1_DRAM0_EXCEPTION_MONITOR_RLS() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_RLS.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_1_INTR_CLR: core1 monitor interrupt clr register
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_0_RD_CLR() uint32 {
	return volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_DRAM0_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_PIF_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_PIF_0_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_PIF_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_PIF_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_PIF_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_PIF_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_AREA_PIF_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_AREA_PIF_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_SP_SPILL_MIN_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_SP_SPILL_MIN_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_SP_SPILL_MAX_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_SP_SPILL_MAX_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_IRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_IRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_INTR_CLR_CORE_1_DRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_1_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_INTR_CLR_CORE_1_DRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_INTR_CLR.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_1_AREA_DRAM0_0_MIN: core1 dram0 region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_1_AREA_DRAM0_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_DRAM0_0_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_AREA_DRAM0_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_DRAM0_0_MIN.Reg)
}

// ASSIST_DEBUG.CORE_1_AREA_DRAM0_0_MAX: core1 dram0 region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_1_AREA_DRAM0_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_DRAM0_0_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_AREA_DRAM0_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_DRAM0_0_MAX.Reg)
}

// ASSIST_DEBUG.CORE_1_AREA_DRAM0_1_MIN: core1 dram0 region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_1_AREA_DRAM0_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_DRAM0_1_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_AREA_DRAM0_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_DRAM0_1_MIN.Reg)
}

// ASSIST_DEBUG.CORE_1_AREA_DRAM0_1_MAX: core1 dram0 region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_1_AREA_DRAM0_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_DRAM0_1_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_AREA_DRAM0_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_DRAM0_1_MAX.Reg)
}

// ASSIST_DEBUG.CORE_1_AREA_PIF_0_MIN: core1 PIF region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_1_AREA_PIF_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_PIF_0_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_AREA_PIF_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_PIF_0_MIN.Reg)
}

// ASSIST_DEBUG.CORE_1_AREA_PIF_0_MAX: core1 PIF region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_1_AREA_PIF_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_PIF_0_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_AREA_PIF_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_PIF_0_MAX.Reg)
}

// ASSIST_DEBUG.CORE_1_AREA_PIF_1_MIN: core1 PIF region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_1_AREA_PIF_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_PIF_1_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_AREA_PIF_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_PIF_1_MIN.Reg)
}

// ASSIST_DEBUG.CORE_1_AREA_PIF_1_MAX: core1 PIF region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_1_AREA_PIF_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_PIF_1_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_AREA_PIF_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_PIF_1_MAX.Reg)
}

// ASSIST_DEBUG.CORE_1_AREA_PC: core1 area pc status register
func (o *ASSIST_DEBUG_Type) SetCORE_1_AREA_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_PC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_AREA_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_PC.Reg)
}

// ASSIST_DEBUG.CORE_1_AREA_SP: core1 area sp status register
func (o *ASSIST_DEBUG_Type) SetCORE_1_AREA_SP(value uint32) {
	volatile.StoreUint32(&o.CORE_1_AREA_SP.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_AREA_SP() uint32 {
	return volatile.LoadUint32(&o.CORE_1_AREA_SP.Reg)
}

// ASSIST_DEBUG.CORE_1_SP_MIN: stack min value
func (o *ASSIST_DEBUG_Type) SetCORE_1_SP_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_SP_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_SP_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_SP_MIN.Reg)
}

// ASSIST_DEBUG.CORE_1_SP_MAX: stack max value
func (o *ASSIST_DEBUG_Type) SetCORE_1_SP_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_1_SP_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_SP_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_1_SP_MAX.Reg)
}

// ASSIST_DEBUG.CORE_1_SP_PC: stack monitor pc status register
func (o *ASSIST_DEBUG_Type) SetCORE_1_SP_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_1_SP_PC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_SP_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_1_SP_PC.Reg)
}

// ASSIST_DEBUG.CORE_1_RCD_EN: record enable configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_1_RCD_EN_CORE_1_RCD_RECORDEN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_EN.Reg, volatile.LoadUint32(&o.CORE_1_RCD_EN.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_RCD_EN_CORE_1_RCD_RECORDEN() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_EN.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_RCD_EN_CORE_1_RCD_PDEBUGEN(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_EN.Reg, volatile.LoadUint32(&o.CORE_1_RCD_EN.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_RCD_EN_CORE_1_RCD_PDEBUGEN() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_RCD_EN.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_1_RCD_PDEBUGPC: record status regsiter
func (o *ASSIST_DEBUG_Type) SetCORE_1_RCD_PDEBUGPC(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_PDEBUGPC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_RCD_PDEBUGPC() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGPC.Reg)
}

// ASSIST_DEBUG.CORE_1_RCD_PDEBUGSP: record status regsiter
func (o *ASSIST_DEBUG_Type) SetCORE_1_RCD_PDEBUGSP(value uint32) {
	volatile.StoreUint32(&o.CORE_1_RCD_PDEBUGSP.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_RCD_PDEBUGSP() uint32 {
	return volatile.LoadUint32(&o.CORE_1_RCD_PDEBUGSP.Reg)
}

// ASSIST_DEBUG.CORE_1_IRAM0_EXCEPTION_MONITOR_0: exception monitor status register0
func (o *ASSIST_DEBUG_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_WR_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_LOADSTORE_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x2000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_0_CORE_1_IRAM0_RECORDING_LOADSTORE_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x2000000) >> 25
}

// ASSIST_DEBUG.CORE_1_IRAM0_EXCEPTION_MONITOR_1: exception monitor status register1
func (o *ASSIST_DEBUG_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_WR_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_LOADSTORE_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x2000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_IRAM0_EXCEPTION_MONITOR_1_CORE_1_IRAM0_RECORDING_LOADSTORE_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x2000000) >> 25
}

// ASSIST_DEBUG.CORE_1_DRAM0_EXCEPTION_MONITOR_0: exception monitor status register2
func (o *ASSIST_DEBUG_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_0_CORE_1_DRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_0_CORE_1_DRAM0_RECORDING_WR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_0_CORE_1_DRAM0_RECORDING_BYTEEN_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1fffe)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_0_CORE_1_DRAM0_RECORDING_BYTEEN_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1fffe) >> 1
}

// ASSIST_DEBUG.CORE_1_DRAM0_EXCEPTION_MONITOR_1: exception monitor status register3
func (o *ASSIST_DEBUG_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_1_CORE_1_DRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_1_CORE_1_DRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_1.Reg) & 0xffffff
}

// ASSIST_DEBUG.CORE_1_DRAM0_EXCEPTION_MONITOR_2: exception monitor status register4
func (o *ASSIST_DEBUG_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_2(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_2.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_2() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_2.Reg)
}

// ASSIST_DEBUG.CORE_1_DRAM0_EXCEPTION_MONITOR_3: exception monitor status register5
func (o *ASSIST_DEBUG_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_3_CORE_1_DRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_3_CORE_1_DRAM0_RECORDING_WR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_3_CORE_1_DRAM0_RECORDING_BYTEEN_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg)&^(0x1fffe)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_3_CORE_1_DRAM0_RECORDING_BYTEEN_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_3.Reg) & 0x1fffe) >> 1
}

// ASSIST_DEBUG.CORE_1_DRAM0_EXCEPTION_MONITOR_4: exception monitor status register6
func (o *ASSIST_DEBUG_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_4_CORE_1_DRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_4.Reg, volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_4.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_4_CORE_1_DRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_4.Reg) & 0xffffff
}

// ASSIST_DEBUG.CORE_1_DRAM0_EXCEPTION_MONITOR_5: exception monitor status register7
func (o *ASSIST_DEBUG_Type) SetCORE_1_DRAM0_EXCEPTION_MONITOR_5(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_5.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_DRAM0_EXCEPTION_MONITOR_5() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DRAM0_EXCEPTION_MONITOR_5.Reg)
}

// ASSIST_DEBUG.CORE_1_LASTPC_BEFORE_EXCEPTION: cpu status register
func (o *ASSIST_DEBUG_Type) SetCORE_1_LASTPC_BEFORE_EXCEPTION(value uint32) {
	volatile.StoreUint32(&o.CORE_1_LASTPC_BEFORE_EXCEPTION.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_LASTPC_BEFORE_EXCEPTION() uint32 {
	return volatile.LoadUint32(&o.CORE_1_LASTPC_BEFORE_EXCEPTION.Reg)
}

// ASSIST_DEBUG.CORE_1_DEBUG_MODE: cpu status register
func (o *ASSIST_DEBUG_Type) SetCORE_1_DEBUG_MODE(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DEBUG_MODE.Reg, volatile.LoadUint32(&o.CORE_1_DEBUG_MODE.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_DEBUG_MODE() uint32 {
	return volatile.LoadUint32(&o.CORE_1_DEBUG_MODE.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_1_DEBUG_MODE_CORE_1_DEBUG_MODULE_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.CORE_1_DEBUG_MODE.Reg, volatile.LoadUint32(&o.CORE_1_DEBUG_MODE.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_1_DEBUG_MODE_CORE_1_DEBUG_MODULE_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.CORE_1_DEBUG_MODE.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0: exception monitor status register6
func (o *ASSIST_DEBUG_Type) SetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_0(value uint32) {
	volatile.StoreUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xfffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_0() uint32 {
	return volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0xfffff
}

// ASSIST_DEBUG.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1: exception monitor status register7
func (o *ASSIST_DEBUG_Type) SetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_1(value uint32) {
	volatile.StoreUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xfffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_1() uint32 {
	return volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg) & 0xfffff
}

// ASSIST_DEBUG.CLOCK_GATE: clock register
func (o *ASSIST_DEBUG_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// ASSIST_DEBUG.DATE: version register
func (o *ASSIST_DEBUG_Type) SetDATE_ASSIST_DEBUG_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetDATE_ASSIST_DEBUG_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// AXI_DMA Peripheral
type AXI_DMA_Type struct {
	IN_INT_RAW_CH0             volatile.Register32 // 0x0
	IN_INT_ST_CH0              volatile.Register32 // 0x4
	IN_INT_ENA_CH0             volatile.Register32 // 0x8
	IN_INT_CLR_CH0             volatile.Register32 // 0xC
	IN_CONF0_CH0               volatile.Register32 // 0x10
	IN_CONF1_CH0               volatile.Register32 // 0x14
	INFIFO_STATUS_CH0          volatile.Register32 // 0x18
	IN_POP_CH0                 volatile.Register32 // 0x1C
	IN_LINK1_CH0               volatile.Register32 // 0x20
	IN_LINK2_CH0               volatile.Register32 // 0x24
	IN_STATE_CH0               volatile.Register32 // 0x28
	IN_SUC_EOF_DES_ADDR_CH0    volatile.Register32 // 0x2C
	IN_ERR_EOF_DES_ADDR_CH0    volatile.Register32 // 0x30
	IN_DSCR_CH0                volatile.Register32 // 0x34
	IN_DSCR_BF0_CH0            volatile.Register32 // 0x38
	IN_DSCR_BF1_CH0            volatile.Register32 // 0x3C
	IN_PRI_CH0                 volatile.Register32 // 0x40
	IN_PERI_SEL_CH0            volatile.Register32 // 0x44
	IN_CRC_INIT_DATA_CH0       volatile.Register32 // 0x48
	RX_CRC_WIDTH_CH0           volatile.Register32 // 0x4C
	IN_CRC_CLEAR_CH0           volatile.Register32 // 0x50
	IN_CRC_FINAL_RESULT_CH0    volatile.Register32 // 0x54
	RX_CRC_EN_WR_DATA_CH0      volatile.Register32 // 0x58
	RX_CRC_EN_ADDR_CH0         volatile.Register32 // 0x5C
	RX_CRC_DATA_EN_WR_DATA_CH0 volatile.Register32 // 0x60
	RX_CRC_DATA_EN_ADDR_CH0    volatile.Register32 // 0x64
	IN_INT_RAW_CH1             volatile.Register32 // 0x68
	IN_INT_ST_CH1              volatile.Register32 // 0x6C
	IN_INT_ENA_CH1             volatile.Register32 // 0x70
	IN_INT_CLR_CH1             volatile.Register32 // 0x74
	IN_CONF0_CH1               volatile.Register32 // 0x78
	IN_CONF1_CH1               volatile.Register32 // 0x7C
	INFIFO_STATUS_CH1          volatile.Register32 // 0x80
	IN_POP_CH1                 volatile.Register32 // 0x84
	IN_LINK1_CH1               volatile.Register32 // 0x88
	IN_LINK2_CH1               volatile.Register32 // 0x8C
	IN_STATE_CH1               volatile.Register32 // 0x90
	IN_SUC_EOF_DES_ADDR_CH1    volatile.Register32 // 0x94
	IN_ERR_EOF_DES_ADDR_CH1    volatile.Register32 // 0x98
	IN_DSCR_CH1                volatile.Register32 // 0x9C
	IN_DSCR_BF0_CH1            volatile.Register32 // 0xA0
	IN_DSCR_BF1_CH1            volatile.Register32 // 0xA4
	IN_PRI_CH1                 volatile.Register32 // 0xA8
	IN_PERI_SEL_CH1            volatile.Register32 // 0xAC
	IN_CRC_INIT_DATA_CH1       volatile.Register32 // 0xB0
	RX_CRC_WIDTH_CH1           volatile.Register32 // 0xB4
	IN_CRC_CLEAR_CH1           volatile.Register32 // 0xB8
	IN_CRC_FINAL_RESULT_CH1    volatile.Register32 // 0xBC
	RX_CRC_EN_WR_DATA_CH1      volatile.Register32 // 0xC0
	RX_CRC_EN_ADDR_CH1         volatile.Register32 // 0xC4
	RX_CRC_DATA_EN_WR_DATA_CH1 volatile.Register32 // 0xC8
	RX_CRC_DATA_EN_ADDR_CH1    volatile.Register32 // 0xCC
	IN_INT_RAW_CH2             volatile.Register32 // 0xD0
	IN_INT_ST_CH2              volatile.Register32 // 0xD4
	IN_INT_ENA_CH2             volatile.Register32 // 0xD8
	IN_INT_CLR_CH2             volatile.Register32 // 0xDC
	IN_CONF0_CH2               volatile.Register32 // 0xE0
	IN_CONF1_CH2               volatile.Register32 // 0xE4
	INFIFO_STATUS_CH2          volatile.Register32 // 0xE8
	IN_POP_CH2                 volatile.Register32 // 0xEC
	IN_LINK1_CH2               volatile.Register32 // 0xF0
	IN_LINK2_CH2               volatile.Register32 // 0xF4
	IN_STATE_CH2               volatile.Register32 // 0xF8
	IN_SUC_EOF_DES_ADDR_CH2    volatile.Register32 // 0xFC
	IN_ERR_EOF_DES_ADDR_CH2    volatile.Register32 // 0x100
	IN_DSCR_CH2                volatile.Register32 // 0x104
	IN_DSCR_BF0_CH2            volatile.Register32 // 0x108
	IN_DSCR_BF1_CH2            volatile.Register32 // 0x10C
	IN_PRI_CH2                 volatile.Register32 // 0x110
	IN_PERI_SEL_CH2            volatile.Register32 // 0x114
	IN_CRC_INIT_DATA_CH2       volatile.Register32 // 0x118
	RX_CRC_WIDTH_CH2           volatile.Register32 // 0x11C
	IN_CRC_CLEAR_CH2           volatile.Register32 // 0x120
	IN_CRC_FINAL_RESULT_CH2    volatile.Register32 // 0x124
	RX_CRC_EN_WR_DATA_CH2      volatile.Register32 // 0x128
	RX_CRC_EN_ADDR_CH2         volatile.Register32 // 0x12C
	RX_CRC_DATA_EN_WR_DATA_CH2 volatile.Register32 // 0x130
	RX_CRC_DATA_EN_ADDR_CH2    volatile.Register32 // 0x134
	OUT_INT_RAW_CH0            volatile.Register32 // 0x138
	OUT_INT_ST_CH0             volatile.Register32 // 0x13C
	OUT_INT_ENA_CH0            volatile.Register32 // 0x140
	OUT_INT_CLR_CH0            volatile.Register32 // 0x144
	OUT_CONF0_CH0              volatile.Register32 // 0x148
	OUT_CONF1_CH0              volatile.Register32 // 0x14C
	OUTFIFO_STATUS_CH0         volatile.Register32 // 0x150
	OUT_PUSH_CH0               volatile.Register32 // 0x154
	OUT_LINK1_CH0              volatile.Register32 // 0x158
	OUT_LINK2_CH0              volatile.Register32 // 0x15C
	OUT_STATE_CH0              volatile.Register32 // 0x160
	OUT_EOF_DES_ADDR_CH0       volatile.Register32 // 0x164
	OUT_EOF_BFR_DES_ADDR_CH0   volatile.Register32 // 0x168
	OUT_DSCR_CH0               volatile.Register32 // 0x16C
	OUT_DSCR_BF0_CH0           volatile.Register32 // 0x170
	OUT_DSCR_BF1_CH0           volatile.Register32 // 0x174
	OUT_PRI_CH0                volatile.Register32 // 0x178
	OUT_PERI_SEL_CH0           volatile.Register32 // 0x17C
	OUT_CRC_INIT_DATA_CH0      volatile.Register32 // 0x180
	TX_CRC_WIDTH_CH0           volatile.Register32 // 0x184
	OUT_CRC_CLEAR_CH0          volatile.Register32 // 0x188
	OUT_CRC_FINAL_RESULT_CH0   volatile.Register32 // 0x18C
	TX_CRC_EN_WR_DATA_CH0      volatile.Register32 // 0x190
	TX_CRC_EN_ADDR_CH0         volatile.Register32 // 0x194
	TX_CRC_DATA_EN_WR_DATA_CH0 volatile.Register32 // 0x198
	TX_CRC_DATA_EN_ADDR_CH0    volatile.Register32 // 0x19C
	OUT_INT_RAW_CH1            volatile.Register32 // 0x1A0
	OUT_INT_ST_CH1             volatile.Register32 // 0x1A4
	OUT_INT_ENA_CH1            volatile.Register32 // 0x1A8
	OUT_INT_CLR_CH1            volatile.Register32 // 0x1AC
	OUT_CONF0_CH1              volatile.Register32 // 0x1B0
	OUT_CONF1_CH1              volatile.Register32 // 0x1B4
	OUTFIFO_STATUS_CH1         volatile.Register32 // 0x1B8
	OUT_PUSH_CH1               volatile.Register32 // 0x1BC
	OUT_LINK1_CH1              volatile.Register32 // 0x1C0
	OUT_LINK2_CH1              volatile.Register32 // 0x1C4
	OUT_STATE_CH1              volatile.Register32 // 0x1C8
	OUT_EOF_DES_ADDR_CH1       volatile.Register32 // 0x1CC
	OUT_EOF_BFR_DES_ADDR_CH1   volatile.Register32 // 0x1D0
	OUT_DSCR_CH1               volatile.Register32 // 0x1D4
	OUT_DSCR_BF0_CH1           volatile.Register32 // 0x1D8
	OUT_DSCR_BF1_CH1           volatile.Register32 // 0x1DC
	OUT_PRI_CH1                volatile.Register32 // 0x1E0
	OUT_PERI_SEL_CH1           volatile.Register32 // 0x1E4
	OUT_CRC_INIT_DATA_CH1      volatile.Register32 // 0x1E8
	TX_CRC_WIDTH_CH1           volatile.Register32 // 0x1EC
	OUT_CRC_CLEAR_CH1          volatile.Register32 // 0x1F0
	OUT_CRC_FINAL_RESULT_CH1   volatile.Register32 // 0x1F4
	TX_CRC_EN_WR_DATA_CH1      volatile.Register32 // 0x1F8
	TX_CRC_EN_ADDR_CH1         volatile.Register32 // 0x1FC
	TX_CRC_DATA_EN_WR_DATA_CH1 volatile.Register32 // 0x200
	TX_CRC_DATA_EN_ADDR_CH1    volatile.Register32 // 0x204
	OUT_INT_RAW_CH2            volatile.Register32 // 0x208
	OUT_INT_ST_CH2             volatile.Register32 // 0x20C
	OUT_INT_ENA_CH2            volatile.Register32 // 0x210
	OUT_INT_CLR_CH2            volatile.Register32 // 0x214
	OUT_CONF0_CH2              volatile.Register32 // 0x218
	OUT_CONF1_CH2              volatile.Register32 // 0x21C
	OUTFIFO_STATUS_CH2         volatile.Register32 // 0x220
	OUT_PUSH_CH2               volatile.Register32 // 0x224
	OUT_LINK1_CH2              volatile.Register32 // 0x228
	OUT_LINK2_CH2              volatile.Register32 // 0x22C
	OUT_STATE_CH2              volatile.Register32 // 0x230
	OUT_EOF_DES_ADDR_CH2       volatile.Register32 // 0x234
	OUT_EOF_BFR_DES_ADDR_CH2   volatile.Register32 // 0x238
	OUT_DSCR_CH2               volatile.Register32 // 0x23C
	OUT_DSCR_BF0_CH2           volatile.Register32 // 0x240
	OUT_DSCR_BF1_CH2           volatile.Register32 // 0x244
	OUT_PRI_CH2                volatile.Register32 // 0x248
	OUT_PERI_SEL_CH2           volatile.Register32 // 0x24C
	OUT_CRC_INIT_DATA_CH2      volatile.Register32 // 0x250
	TX_CRC_WIDTH_CH2           volatile.Register32 // 0x254
	OUT_CRC_CLEAR_CH2          volatile.Register32 // 0x258
	OUT_CRC_FINAL_RESULT_CH2   volatile.Register32 // 0x25C
	TX_CRC_EN_WR_DATA_CH2      volatile.Register32 // 0x260
	TX_CRC_EN_ADDR_CH2         volatile.Register32 // 0x264
	TX_CRC_DATA_EN_WR_DATA_CH2 volatile.Register32 // 0x268
	TX_CRC_DATA_EN_ADDR_CH2    volatile.Register32 // 0x26C
	ARB_TIMEOUT                volatile.Register32 // 0x270
	WEIGHT_EN                  volatile.Register32 // 0x274
	IN_MEM_CONF                volatile.Register32 // 0x278
	INTR_MEM_START_ADDR        volatile.Register32 // 0x27C
	INTR_MEM_END_ADDR          volatile.Register32 // 0x280
	EXTR_MEM_START_ADDR        volatile.Register32 // 0x284
	EXTR_MEM_END_ADDR          volatile.Register32 // 0x288
	IN_RESET_AVAIL_CH0         volatile.Register32 // 0x28C
	IN_RESET_AVAIL_CH1         volatile.Register32 // 0x290
	IN_RESET_AVAIL_CH2         volatile.Register32 // 0x294
	OUT_RESET_AVAIL_CH0        volatile.Register32 // 0x298
	OUT_RESET_AVAIL_CH1        volatile.Register32 // 0x29C
	OUT_RESET_AVAIL_CH2        volatile.Register32 // 0x2A0
	_                          [4]byte
	MISC_CONF                  volatile.Register32 // 0x2A8
	RDN_RESULT                 volatile.Register32 // 0x2AC
	RDN_ECO_HIGH               volatile.Register32 // 0x2B0
	RDN_ECO_LOW                volatile.Register32 // 0x2B4
	WRESP_CNT                  volatile.Register32 // 0x2B8
	RRESP_CNT                  volatile.Register32 // 0x2BC
	INFIFO_STATUS1_CH0         volatile.Register32 // 0x2C0
	INFIFO_STATUS1_CH1         volatile.Register32 // 0x2C4
	INFIFO_STATUS1_CH2         volatile.Register32 // 0x2C8
	OUTFIFO_STATUS1_CH0        volatile.Register32 // 0x2CC
	OUTFIFO_STATUS1_CH1        volatile.Register32 // 0x2D0
	OUTFIFO_STATUS1_CH2        volatile.Register32 // 0x2D4
	DATE                       volatile.Register32 // 0x2D8
}

// AXI_DMA.IN_INT_RAW_CH0: Raw status interrupt of channel 0
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_IN_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_IN_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_IN_SUC_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_IN_SUC_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_IN_ERR_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_IN_ERR_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_IN_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_IN_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_IN_DSCR_EMPTY_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_IN_DSCR_EMPTY_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_INFIFO_L1_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_INFIFO_L1_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_INFIFO_L1_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_INFIFO_L1_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_INFIFO_L2_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_INFIFO_L2_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_INFIFO_L2_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_INFIFO_L2_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_INFIFO_L3_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_INFIFO_L3_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH0_INFIFO_L3_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH0_INFIFO_L3_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_INT_ST_CH0: Masked interrupt of channel 0
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_IN_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_IN_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_IN_SUC_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_IN_SUC_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_IN_ERR_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_IN_ERR_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_IN_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_IN_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_IN_DSCR_EMPTY_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_IN_DSCR_EMPTY_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_INFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_INFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_INFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_INFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_INFIFO_L1_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_INFIFO_L1_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_INFIFO_L1_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_INFIFO_L1_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_INFIFO_L3_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_INFIFO_L3_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH0_INFIFO_L3_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH0_INFIFO_L3_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_INT_ENA_CH0: Interrupt enable bits of channel 0
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_IN_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_IN_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_IN_SUC_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_IN_SUC_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_IN_ERR_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_IN_ERR_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_IN_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_IN_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_IN_DSCR_EMPTY_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_IN_DSCR_EMPTY_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_INFIFO_L1_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_INFIFO_L1_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_INFIFO_L1_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_INFIFO_L1_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_INFIFO_L2_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_INFIFO_L2_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_INFIFO_L2_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_INFIFO_L2_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_INFIFO_L3_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_INFIFO_L3_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH0_INFIFO_L3_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH0_INFIFO_L3_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_INT_CLR_CH0: Interrupt clear bits of channel 0
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_IN_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_IN_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_IN_SUC_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_IN_SUC_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_IN_ERR_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_IN_ERR_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_IN_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_IN_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_IN_DSCR_EMPTY_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_IN_DSCR_EMPTY_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_INFIFO_L1_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_INFIFO_L1_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_INFIFO_L1_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_INFIFO_L1_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_INFIFO_L2_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_INFIFO_L2_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_INFIFO_L2_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_INFIFO_L2_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_INFIFO_L3_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_INFIFO_L3_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH0_INFIFO_L3_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH0_INFIFO_L3_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_CONF0_CH0: Configure 0 register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_CONF0_CH0_IN_RST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH0_IN_RST_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH0_IN_LOOP_TEST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH0_IN_LOOP_TEST_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH0_MEM_TRANS_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH0_MEM_TRANS_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH0_IN_ETM_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH0_IN_ETM_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH0_IN_BURST_SIZE_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x70)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH0_IN_BURST_SIZE_SEL_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x70) >> 4
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH0_IN_CMD_DISABLE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH0_IN_CMD_DISABLE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH0_IN_ECC_AEC_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH0_IN_ECC_AEC_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH0_INDSCR_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH0_INDSCR_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x200) >> 9
}

// AXI_DMA.IN_CONF1_CH0: Configure 1 register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_CONF1_CH0_IN_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH0.Reg, volatile.LoadUint32(&o.IN_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetIN_CONF1_CH0_IN_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH0.Reg) & 0x1000) >> 12
}

// AXI_DMA.INFIFO_STATUS_CH0: Receive FIFO status of Rx channel 0
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L3_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L3_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L3_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L3_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L3_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0xfc)|value<<2)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L3_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0xfc) >> 2
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L3_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L3_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L3_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L3_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L1_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L1_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x400) >> 10
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L1_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x800)|value<<11)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L1_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x800) >> 11
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L1_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L1_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1000) >> 12
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L1_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2000)|value<<13)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L1_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2000) >> 13
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L2_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x4000)|value<<14)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L2_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x4000) >> 14
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L2_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x8000)|value<<15)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L2_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x8000) >> 15
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L2_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x10000)|value<<16)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L2_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x10000) >> 16
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_L2_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x20000)|value<<17)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_L2_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x20000) >> 17
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_5B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x8000000)|value<<27)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_5B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x8000000) >> 27
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_6B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x10000000)|value<<28)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_6B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x10000000) >> 28
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_7B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x20000000)|value<<29)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_7B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x20000000) >> 29
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_8B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x40000000)|value<<30)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_8B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x40000000) >> 30
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH0_IN_BUF_HUNGRY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x80000000)|value<<31)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH0_IN_BUF_HUNGRY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x80000000) >> 31
}

// AXI_DMA.IN_POP_CH0: Pop control register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_POP_CH0_INFIFO_RDATA_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0xfff)|value)
}
func (o *AXI_DMA_Type) GetIN_POP_CH0_INFIFO_RDATA_CH() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0xfff
}
func (o *AXI_DMA_Type) SetIN_POP_CH0_INFIFO_POP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetIN_POP_CH0_INFIFO_POP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0x1000) >> 12
}

// AXI_DMA.IN_LINK1_CH0: Link descriptor configure and control register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_LINK1_CH0_INLINK_AUTO_RET_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH0.Reg, volatile.LoadUint32(&o.IN_LINK1_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH0_INLINK_AUTO_RET_CH() uint32 {
	return volatile.LoadUint32(&o.IN_LINK1_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH0_INLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH0.Reg, volatile.LoadUint32(&o.IN_LINK1_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH0_INLINK_STOP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH0_INLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH0.Reg, volatile.LoadUint32(&o.IN_LINK1_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH0_INLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH0_INLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH0.Reg, volatile.LoadUint32(&o.IN_LINK1_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH0_INLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH0_INLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH0.Reg, volatile.LoadUint32(&o.IN_LINK1_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH0_INLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH0.Reg) & 0x10) >> 4
}

// AXI_DMA.IN_LINK2_CH0: Link descriptor configure and control register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_LINK2_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_LINK2_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_LINK2_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_LINK2_CH0.Reg)
}

// AXI_DMA.IN_STATE_CH0: Receive status of Rx channel 0
func (o *AXI_DMA_Type) SetIN_STATE_CH0_INLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *AXI_DMA_Type) GetIN_STATE_CH0_INLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x3ffff
}
func (o *AXI_DMA_Type) SetIN_STATE_CH0_IN_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *AXI_DMA_Type) GetIN_STATE_CH0_IN_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *AXI_DMA_Type) SetIN_STATE_CH0_IN_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *AXI_DMA_Type) GetIN_STATE_CH0_IN_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x700000) >> 20
}

// AXI_DMA.IN_SUC_EOF_DES_ADDR_CH0: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *AXI_DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg)
}

// AXI_DMA.IN_ERR_EOF_DES_ADDR_CH0: Inlink descriptor address when errors occur of Rx channel 0
func (o *AXI_DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg)
}

// AXI_DMA.IN_DSCR_CH0: Current inlink descriptor address of Rx channel 0
func (o *AXI_DMA_Type) SetIN_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH0.Reg)
}

// AXI_DMA.IN_DSCR_BF0_CH0: The last inlink descriptor address of Rx channel 0
func (o *AXI_DMA_Type) SetIN_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH0.Reg)
}

// AXI_DMA.IN_DSCR_BF1_CH0: The second-to-last inlink descriptor address of Rx channel 0
func (o *AXI_DMA_Type) SetIN_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH0.Reg)
}

// AXI_DMA.IN_PRI_CH0: Priority register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_PRI_CH0_RX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH0.Reg, volatile.LoadUint32(&o.IN_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *AXI_DMA_Type) GetIN_PRI_CH0_RX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH0.Reg) & 0xf
}
func (o *AXI_DMA_Type) SetIN_PRI_CH0_RX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH0.Reg, volatile.LoadUint32(&o.IN_PRI_CH0.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_PRI_CH0_RX_CH_ARB_WEIGH_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_PRI_CH0.Reg) & 0xf0) >> 4
}
func (o *AXI_DMA_Type) SetIN_PRI_CH0_RX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH0.Reg, volatile.LoadUint32(&o.IN_PRI_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_PRI_CH0_RX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_PRI_CH0.Reg) & 0x100) >> 8
}

// AXI_DMA.IN_PERI_SEL_CH0: Peripheral selection of Rx channel 0
func (o *AXI_DMA_Type) SetIN_PERI_SEL_CH0_PERI_IN_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetIN_PERI_SEL_CH0_PERI_IN_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg) & 0x3f
}

// AXI_DMA.IN_CRC_INIT_DATA_CH0: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AXI_DMA_Type) SetIN_CRC_INIT_DATA_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_INIT_DATA_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_CRC_INIT_DATA_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_INIT_DATA_CH0.Reg)
}

// AXI_DMA.RX_CRC_WIDTH_CH0: This register is used to confiig rx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AXI_DMA_Type) SetRX_CRC_WIDTH_CH0_RX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH0.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH0.Reg)&^(0x3)|value)
}
func (o *AXI_DMA_Type) GetRX_CRC_WIDTH_CH0_RX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_WIDTH_CH0.Reg) & 0x3
}
func (o *AXI_DMA_Type) SetRX_CRC_WIDTH_CH0_RX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH0.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetRX_CRC_WIDTH_CH0_RX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.RX_CRC_WIDTH_CH0.Reg) & 0x4) >> 2
}

// AXI_DMA.IN_CRC_CLEAR_CH0: This register is used to clear ch0 crc result
func (o *AXI_DMA_Type) SetIN_CRC_CLEAR_CH0_IN_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_CLEAR_CH0.Reg, volatile.LoadUint32(&o.IN_CRC_CLEAR_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_CRC_CLEAR_CH0_IN_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_CLEAR_CH0.Reg) & 0x1
}

// AXI_DMA.IN_CRC_FINAL_RESULT_CH0: This register is used to store ch0 crc result
func (o *AXI_DMA_Type) SetIN_CRC_FINAL_RESULT_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_FINAL_RESULT_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_CRC_FINAL_RESULT_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_FINAL_RESULT_CH0.Reg)
}

// AXI_DMA.RX_CRC_EN_WR_DATA_CH0: This resister is used to config ch0 crc en for every bit
func (o *AXI_DMA_Type) SetRX_CRC_EN_WR_DATA_CH0(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_WR_DATA_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetRX_CRC_EN_WR_DATA_CH0() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_WR_DATA_CH0.Reg)
}

// AXI_DMA.RX_CRC_EN_ADDR_CH0: This register is used to config ch0 crc en addr
func (o *AXI_DMA_Type) SetRX_CRC_EN_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_ADDR_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetRX_CRC_EN_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_ADDR_CH0.Reg)
}

// AXI_DMA.RX_CRC_DATA_EN_WR_DATA_CH0: This register is used to config crc data_8bit en
func (o *AXI_DMA_Type) SetRX_CRC_DATA_EN_WR_DATA_CH0_RX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH0.Reg, volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH0.Reg)&^(0xffff)|value)
}
func (o *AXI_DMA_Type) GetRX_CRC_DATA_EN_WR_DATA_CH0_RX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH0.Reg) & 0xffff
}

// AXI_DMA.RX_CRC_DATA_EN_ADDR_CH0: This register is used to config addr of crc data_8bit en
func (o *AXI_DMA_Type) SetRX_CRC_DATA_EN_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_ADDR_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetRX_CRC_DATA_EN_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_ADDR_CH0.Reg)
}

// AXI_DMA.IN_INT_RAW_CH1: Raw status interrupt of channel 0
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_IN_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_IN_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_IN_SUC_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_IN_SUC_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_IN_ERR_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_IN_ERR_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_IN_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_IN_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_IN_DSCR_EMPTY_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_IN_DSCR_EMPTY_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_INFIFO_L1_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_INFIFO_L1_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_INFIFO_L1_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_INFIFO_L1_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_INFIFO_L2_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_INFIFO_L2_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_INFIFO_L2_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_INFIFO_L2_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_INFIFO_L3_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_INFIFO_L3_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH1_INFIFO_L3_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH1_INFIFO_L3_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_INT_ST_CH1: Masked interrupt of channel 0
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_IN_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_IN_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_IN_SUC_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_IN_SUC_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_IN_ERR_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_IN_ERR_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_IN_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_IN_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_IN_DSCR_EMPTY_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_IN_DSCR_EMPTY_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_INFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_INFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_INFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_INFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_INFIFO_L1_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_INFIFO_L1_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_INFIFO_L1_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_INFIFO_L1_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_INFIFO_L3_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_INFIFO_L3_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH1_INFIFO_L3_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH1_INFIFO_L3_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_INT_ENA_CH1: Interrupt enable bits of channel 0
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_IN_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_IN_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_IN_SUC_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_IN_SUC_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_IN_ERR_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_IN_ERR_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_IN_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_IN_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_IN_DSCR_EMPTY_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_IN_DSCR_EMPTY_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_INFIFO_L1_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_INFIFO_L1_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_INFIFO_L1_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_INFIFO_L1_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_INFIFO_L2_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_INFIFO_L2_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_INFIFO_L2_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_INFIFO_L2_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_INFIFO_L3_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_INFIFO_L3_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH1_INFIFO_L3_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH1_INFIFO_L3_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_INT_CLR_CH1: Interrupt clear bits of channel 0
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_IN_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_IN_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_IN_SUC_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_IN_SUC_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_IN_ERR_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_IN_ERR_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_IN_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_IN_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_IN_DSCR_EMPTY_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_IN_DSCR_EMPTY_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_INFIFO_L1_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_INFIFO_L1_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_INFIFO_L1_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_INFIFO_L1_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_INFIFO_L2_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_INFIFO_L2_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_INFIFO_L2_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_INFIFO_L2_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_INFIFO_L3_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_INFIFO_L3_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH1_INFIFO_L3_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH1_INFIFO_L3_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_CONF0_CH1: Configure 0 register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_CONF0_CH1_IN_RST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH1_IN_RST_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH1_IN_LOOP_TEST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH1_IN_LOOP_TEST_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH1_MEM_TRANS_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH1_MEM_TRANS_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH1_IN_ETM_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH1_IN_ETM_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH1_IN_BURST_SIZE_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x70)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH1_IN_BURST_SIZE_SEL_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x70) >> 4
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH1_IN_CMD_DISABLE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH1_IN_CMD_DISABLE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH1_IN_ECC_AEC_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH1_IN_ECC_AEC_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH1_INDSCR_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH1_INDSCR_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x200) >> 9
}

// AXI_DMA.IN_CONF1_CH1: Configure 1 register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_CONF1_CH1_IN_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH1.Reg, volatile.LoadUint32(&o.IN_CONF1_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetIN_CONF1_CH1_IN_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH1.Reg) & 0x1000) >> 12
}

// AXI_DMA.INFIFO_STATUS_CH1: Receive FIFO status of Rx channel 0
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L3_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L3_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L3_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L3_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L3_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0xfc)|value<<2)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L3_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0xfc) >> 2
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L3_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L3_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L3_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L3_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L1_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L1_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x400) >> 10
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L1_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x800)|value<<11)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L1_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x800) >> 11
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L1_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L1_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1000) >> 12
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L1_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2000)|value<<13)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L1_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2000) >> 13
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L2_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x4000)|value<<14)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L2_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x4000) >> 14
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L2_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x8000)|value<<15)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L2_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x8000) >> 15
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L2_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x10000)|value<<16)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L2_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x10000) >> 16
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_L2_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x20000)|value<<17)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_L2_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x20000) >> 17
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x800000) >> 23
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1000000) >> 24
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2000000)|value<<25)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2000000) >> 25
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x4000000)|value<<26)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x4000000) >> 26
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_5B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x8000000)|value<<27)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_5B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x8000000) >> 27
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_6B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x10000000)|value<<28)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_6B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x10000000) >> 28
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_7B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x20000000)|value<<29)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_7B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x20000000) >> 29
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_8B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x40000000)|value<<30)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_8B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x40000000) >> 30
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH1_IN_BUF_HUNGRY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x80000000)|value<<31)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH1_IN_BUF_HUNGRY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x80000000) >> 31
}

// AXI_DMA.IN_POP_CH1: Pop control register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_POP_CH1_INFIFO_RDATA_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH1.Reg, volatile.LoadUint32(&o.IN_POP_CH1.Reg)&^(0xfff)|value)
}
func (o *AXI_DMA_Type) GetIN_POP_CH1_INFIFO_RDATA_CH() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH1.Reg) & 0xfff
}
func (o *AXI_DMA_Type) SetIN_POP_CH1_INFIFO_POP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH1.Reg, volatile.LoadUint32(&o.IN_POP_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetIN_POP_CH1_INFIFO_POP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH1.Reg) & 0x1000) >> 12
}

// AXI_DMA.IN_LINK1_CH1: Link descriptor configure and control register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_LINK1_CH1_INLINK_AUTO_RET_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH1.Reg, volatile.LoadUint32(&o.IN_LINK1_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH1_INLINK_AUTO_RET_CH() uint32 {
	return volatile.LoadUint32(&o.IN_LINK1_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH1_INLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH1.Reg, volatile.LoadUint32(&o.IN_LINK1_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH1_INLINK_STOP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH1_INLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH1.Reg, volatile.LoadUint32(&o.IN_LINK1_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH1_INLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH1_INLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH1.Reg, volatile.LoadUint32(&o.IN_LINK1_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH1_INLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH1_INLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH1.Reg, volatile.LoadUint32(&o.IN_LINK1_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH1_INLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH1.Reg) & 0x10) >> 4
}

// AXI_DMA.IN_LINK2_CH1: Link descriptor configure and control register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_LINK2_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_LINK2_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_LINK2_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_LINK2_CH1.Reg)
}

// AXI_DMA.IN_STATE_CH1: Receive status of Rx channel 0
func (o *AXI_DMA_Type) SetIN_STATE_CH1_INLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0x3ffff)|value)
}
func (o *AXI_DMA_Type) GetIN_STATE_CH1_INLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0x3ffff
}
func (o *AXI_DMA_Type) SetIN_STATE_CH1_IN_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0xc0000)|value<<18)
}
func (o *AXI_DMA_Type) GetIN_STATE_CH1_IN_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0xc0000) >> 18
}
func (o *AXI_DMA_Type) SetIN_STATE_CH1_IN_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0x700000)|value<<20)
}
func (o *AXI_DMA_Type) GetIN_STATE_CH1_IN_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0x700000) >> 20
}

// AXI_DMA.IN_SUC_EOF_DES_ADDR_CH1: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *AXI_DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH1.Reg)
}

// AXI_DMA.IN_ERR_EOF_DES_ADDR_CH1: Inlink descriptor address when errors occur of Rx channel 0
func (o *AXI_DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH1.Reg)
}

// AXI_DMA.IN_DSCR_CH1: Current inlink descriptor address of Rx channel 0
func (o *AXI_DMA_Type) SetIN_DSCR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_DSCR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH1.Reg)
}

// AXI_DMA.IN_DSCR_BF0_CH1: The last inlink descriptor address of Rx channel 0
func (o *AXI_DMA_Type) SetIN_DSCR_BF0_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_DSCR_BF0_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH1.Reg)
}

// AXI_DMA.IN_DSCR_BF1_CH1: The second-to-last inlink descriptor address of Rx channel 0
func (o *AXI_DMA_Type) SetIN_DSCR_BF1_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_DSCR_BF1_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH1.Reg)
}

// AXI_DMA.IN_PRI_CH1: Priority register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_PRI_CH1_RX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH1.Reg, volatile.LoadUint32(&o.IN_PRI_CH1.Reg)&^(0xf)|value)
}
func (o *AXI_DMA_Type) GetIN_PRI_CH1_RX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH1.Reg) & 0xf
}
func (o *AXI_DMA_Type) SetIN_PRI_CH1_RX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH1.Reg, volatile.LoadUint32(&o.IN_PRI_CH1.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_PRI_CH1_RX_CH_ARB_WEIGH_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_PRI_CH1.Reg) & 0xf0) >> 4
}
func (o *AXI_DMA_Type) SetIN_PRI_CH1_RX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH1.Reg, volatile.LoadUint32(&o.IN_PRI_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_PRI_CH1_RX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_PRI_CH1.Reg) & 0x100) >> 8
}

// AXI_DMA.IN_PERI_SEL_CH1: Peripheral selection of Rx channel 0
func (o *AXI_DMA_Type) SetIN_PERI_SEL_CH1_PERI_IN_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH1.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH1.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetIN_PERI_SEL_CH1_PERI_IN_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH1.Reg) & 0x3f
}

// AXI_DMA.IN_CRC_INIT_DATA_CH1: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AXI_DMA_Type) SetIN_CRC_INIT_DATA_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_INIT_DATA_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_CRC_INIT_DATA_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_INIT_DATA_CH1.Reg)
}

// AXI_DMA.RX_CRC_WIDTH_CH1: This register is used to confiig rx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AXI_DMA_Type) SetRX_CRC_WIDTH_CH1_RX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH1.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH1.Reg)&^(0x3)|value)
}
func (o *AXI_DMA_Type) GetRX_CRC_WIDTH_CH1_RX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_WIDTH_CH1.Reg) & 0x3
}
func (o *AXI_DMA_Type) SetRX_CRC_WIDTH_CH1_RX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH1.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetRX_CRC_WIDTH_CH1_RX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.RX_CRC_WIDTH_CH1.Reg) & 0x4) >> 2
}

// AXI_DMA.IN_CRC_CLEAR_CH1: This register is used to clear ch0 crc result
func (o *AXI_DMA_Type) SetIN_CRC_CLEAR_CH1_IN_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_CLEAR_CH1.Reg, volatile.LoadUint32(&o.IN_CRC_CLEAR_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_CRC_CLEAR_CH1_IN_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_CLEAR_CH1.Reg) & 0x1
}

// AXI_DMA.IN_CRC_FINAL_RESULT_CH1: This register is used to store ch0 crc result
func (o *AXI_DMA_Type) SetIN_CRC_FINAL_RESULT_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_FINAL_RESULT_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_CRC_FINAL_RESULT_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_FINAL_RESULT_CH1.Reg)
}

// AXI_DMA.RX_CRC_EN_WR_DATA_CH1: This resister is used to config ch0 crc en for every bit
func (o *AXI_DMA_Type) SetRX_CRC_EN_WR_DATA_CH1(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_WR_DATA_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetRX_CRC_EN_WR_DATA_CH1() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_WR_DATA_CH1.Reg)
}

// AXI_DMA.RX_CRC_EN_ADDR_CH1: This register is used to config ch0 crc en addr
func (o *AXI_DMA_Type) SetRX_CRC_EN_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_ADDR_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetRX_CRC_EN_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_ADDR_CH1.Reg)
}

// AXI_DMA.RX_CRC_DATA_EN_WR_DATA_CH1: This register is used to config crc data_8bit en
func (o *AXI_DMA_Type) SetRX_CRC_DATA_EN_WR_DATA_CH1_RX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH1.Reg, volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH1.Reg)&^(0xffff)|value)
}
func (o *AXI_DMA_Type) GetRX_CRC_DATA_EN_WR_DATA_CH1_RX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH1.Reg) & 0xffff
}

// AXI_DMA.RX_CRC_DATA_EN_ADDR_CH1: This register is used to config addr of crc data_8bit en
func (o *AXI_DMA_Type) SetRX_CRC_DATA_EN_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_ADDR_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetRX_CRC_DATA_EN_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_ADDR_CH1.Reg)
}

// AXI_DMA.IN_INT_RAW_CH2: Raw status interrupt of channel 0
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_IN_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_IN_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_IN_SUC_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_IN_SUC_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_IN_ERR_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_IN_ERR_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_IN_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_IN_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_IN_DSCR_EMPTY_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_IN_DSCR_EMPTY_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_INFIFO_L1_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_INFIFO_L1_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_INFIFO_L1_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_INFIFO_L1_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_INFIFO_L2_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_INFIFO_L2_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_INFIFO_L2_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_INFIFO_L2_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_INFIFO_L3_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_INFIFO_L3_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_RAW_CH2_INFIFO_L3_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_RAW_CH2_INFIFO_L3_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_INT_ST_CH2: Masked interrupt of channel 0
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_IN_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_IN_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_IN_SUC_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_IN_SUC_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_IN_ERR_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_IN_ERR_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_IN_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_IN_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_IN_DSCR_EMPTY_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_IN_DSCR_EMPTY_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_INFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_INFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_INFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_INFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_INFIFO_L1_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_INFIFO_L1_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_INFIFO_L1_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_INFIFO_L1_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_INFIFO_L3_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_INFIFO_L3_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_ST_CH2_INFIFO_L3_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_ST_CH2_INFIFO_L3_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_INT_ENA_CH2: Interrupt enable bits of channel 0
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_IN_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_IN_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_IN_SUC_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_IN_SUC_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_IN_ERR_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_IN_ERR_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_IN_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_IN_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_IN_DSCR_EMPTY_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_IN_DSCR_EMPTY_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_INFIFO_L1_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_INFIFO_L1_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_INFIFO_L1_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_INFIFO_L1_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_INFIFO_L2_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_INFIFO_L2_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_INFIFO_L2_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_INFIFO_L2_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_INFIFO_L3_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_INFIFO_L3_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_ENA_CH2_INFIFO_L3_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_ENA_CH2_INFIFO_L3_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_INT_CLR_CH2: Interrupt clear bits of channel 0
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_IN_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_IN_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_IN_SUC_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_IN_SUC_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_IN_ERR_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_IN_ERR_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_IN_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_IN_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_IN_DSCR_EMPTY_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_IN_DSCR_EMPTY_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_INFIFO_L1_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_INFIFO_L1_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_INFIFO_L1_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_INFIFO_L1_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_INFIFO_L2_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_INFIFO_L2_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_INFIFO_L2_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_INFIFO_L2_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_INFIFO_L3_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_INFIFO_L3_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetIN_INT_CLR_CH2_INFIFO_L3_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetIN_INT_CLR_CH2_INFIFO_L3_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x400) >> 10
}

// AXI_DMA.IN_CONF0_CH2: Configure 0 register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_CONF0_CH2_IN_RST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH2_IN_RST_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH2_IN_LOOP_TEST_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH2_IN_LOOP_TEST_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH2_MEM_TRANS_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH2_MEM_TRANS_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH2_IN_ETM_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH2_IN_ETM_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH2_IN_BURST_SIZE_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x70)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH2_IN_BURST_SIZE_SEL_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x70) >> 4
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH2_IN_CMD_DISABLE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH2_IN_CMD_DISABLE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH2_IN_ECC_AEC_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH2_IN_ECC_AEC_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetIN_CONF0_CH2_INDSCR_BURST_EN_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetIN_CONF0_CH2_INDSCR_BURST_EN_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x200) >> 9
}

// AXI_DMA.IN_CONF1_CH2: Configure 1 register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_CONF1_CH2_IN_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH2.Reg, volatile.LoadUint32(&o.IN_CONF1_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetIN_CONF1_CH2_IN_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH2.Reg) & 0x1000) >> 12
}

// AXI_DMA.INFIFO_STATUS_CH2: Receive FIFO status of Rx channel 0
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L3_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L3_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L3_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L3_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L3_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0xfc)|value<<2)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L3_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0xfc) >> 2
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L3_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L3_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L3_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L3_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L1_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L1_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x400) >> 10
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L1_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x800)|value<<11)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L1_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x800) >> 11
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L1_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L1_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1000) >> 12
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L1_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2000)|value<<13)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L1_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2000) >> 13
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L2_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x4000)|value<<14)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L2_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x4000) >> 14
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L2_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x8000)|value<<15)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L2_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x8000) >> 15
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L2_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x10000)|value<<16)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L2_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x10000) >> 16
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_L2_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x20000)|value<<17)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_L2_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x20000) >> 17
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x800000) >> 23
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1000000) >> 24
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2000000)|value<<25)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2000000) >> 25
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x4000000)|value<<26)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x4000000) >> 26
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_5B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x8000000)|value<<27)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_5B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x8000000) >> 27
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_6B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x10000000)|value<<28)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_6B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x10000000) >> 28
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_7B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x20000000)|value<<29)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_7B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x20000000) >> 29
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_8B_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x40000000)|value<<30)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_8B_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x40000000) >> 30
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS_CH2_IN_BUF_HUNGRY_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x80000000)|value<<31)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS_CH2_IN_BUF_HUNGRY_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x80000000) >> 31
}

// AXI_DMA.IN_POP_CH2: Pop control register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_POP_CH2_INFIFO_RDATA_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH2.Reg, volatile.LoadUint32(&o.IN_POP_CH2.Reg)&^(0xfff)|value)
}
func (o *AXI_DMA_Type) GetIN_POP_CH2_INFIFO_RDATA_CH() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH2.Reg) & 0xfff
}
func (o *AXI_DMA_Type) SetIN_POP_CH2_INFIFO_POP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH2.Reg, volatile.LoadUint32(&o.IN_POP_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetIN_POP_CH2_INFIFO_POP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH2.Reg) & 0x1000) >> 12
}

// AXI_DMA.IN_LINK1_CH2: Link descriptor configure and control register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_LINK1_CH2_INLINK_AUTO_RET_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH2.Reg, volatile.LoadUint32(&o.IN_LINK1_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH2_INLINK_AUTO_RET_CH() uint32 {
	return volatile.LoadUint32(&o.IN_LINK1_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH2_INLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH2.Reg, volatile.LoadUint32(&o.IN_LINK1_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH2_INLINK_STOP_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH2_INLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH2.Reg, volatile.LoadUint32(&o.IN_LINK1_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH2_INLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH2_INLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH2.Reg, volatile.LoadUint32(&o.IN_LINK1_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH2_INLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_LINK1_CH2_INLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.IN_LINK1_CH2.Reg, volatile.LoadUint32(&o.IN_LINK1_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_LINK1_CH2_INLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK1_CH2.Reg) & 0x10) >> 4
}

// AXI_DMA.IN_LINK2_CH2: Link descriptor configure and control register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_LINK2_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_LINK2_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_LINK2_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_LINK2_CH2.Reg)
}

// AXI_DMA.IN_STATE_CH2: Receive status of Rx channel 0
func (o *AXI_DMA_Type) SetIN_STATE_CH2_INLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0x3ffff)|value)
}
func (o *AXI_DMA_Type) GetIN_STATE_CH2_INLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0x3ffff
}
func (o *AXI_DMA_Type) SetIN_STATE_CH2_IN_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0xc0000)|value<<18)
}
func (o *AXI_DMA_Type) GetIN_STATE_CH2_IN_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0xc0000) >> 18
}
func (o *AXI_DMA_Type) SetIN_STATE_CH2_IN_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0x700000)|value<<20)
}
func (o *AXI_DMA_Type) GetIN_STATE_CH2_IN_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0x700000) >> 20
}

// AXI_DMA.IN_SUC_EOF_DES_ADDR_CH2: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *AXI_DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH2.Reg)
}

// AXI_DMA.IN_ERR_EOF_DES_ADDR_CH2: Inlink descriptor address when errors occur of Rx channel 0
func (o *AXI_DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH2.Reg)
}

// AXI_DMA.IN_DSCR_CH2: Current inlink descriptor address of Rx channel 0
func (o *AXI_DMA_Type) SetIN_DSCR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_DSCR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH2.Reg)
}

// AXI_DMA.IN_DSCR_BF0_CH2: The last inlink descriptor address of Rx channel 0
func (o *AXI_DMA_Type) SetIN_DSCR_BF0_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_DSCR_BF0_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH2.Reg)
}

// AXI_DMA.IN_DSCR_BF1_CH2: The second-to-last inlink descriptor address of Rx channel 0
func (o *AXI_DMA_Type) SetIN_DSCR_BF1_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_DSCR_BF1_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH2.Reg)
}

// AXI_DMA.IN_PRI_CH2: Priority register of Rx channel 0
func (o *AXI_DMA_Type) SetIN_PRI_CH2_RX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH2.Reg, volatile.LoadUint32(&o.IN_PRI_CH2.Reg)&^(0xf)|value)
}
func (o *AXI_DMA_Type) GetIN_PRI_CH2_RX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH2.Reg) & 0xf
}
func (o *AXI_DMA_Type) SetIN_PRI_CH2_RX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH2.Reg, volatile.LoadUint32(&o.IN_PRI_CH2.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_PRI_CH2_RX_CH_ARB_WEIGH_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_PRI_CH2.Reg) & 0xf0) >> 4
}
func (o *AXI_DMA_Type) SetIN_PRI_CH2_RX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH2.Reg, volatile.LoadUint32(&o.IN_PRI_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetIN_PRI_CH2_RX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return (volatile.LoadUint32(&o.IN_PRI_CH2.Reg) & 0x100) >> 8
}

// AXI_DMA.IN_PERI_SEL_CH2: Peripheral selection of Rx channel 0
func (o *AXI_DMA_Type) SetIN_PERI_SEL_CH2_PERI_IN_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH2.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH2.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetIN_PERI_SEL_CH2_PERI_IN_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH2.Reg) & 0x3f
}

// AXI_DMA.IN_CRC_INIT_DATA_CH2: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AXI_DMA_Type) SetIN_CRC_INIT_DATA_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_INIT_DATA_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_CRC_INIT_DATA_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_INIT_DATA_CH2.Reg)
}

// AXI_DMA.RX_CRC_WIDTH_CH2: This register is used to confiig rx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AXI_DMA_Type) SetRX_CRC_WIDTH_CH2_RX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH2.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH2.Reg)&^(0x3)|value)
}
func (o *AXI_DMA_Type) GetRX_CRC_WIDTH_CH2_RX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_WIDTH_CH2.Reg) & 0x3
}
func (o *AXI_DMA_Type) SetRX_CRC_WIDTH_CH2_RX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_WIDTH_CH2.Reg, volatile.LoadUint32(&o.RX_CRC_WIDTH_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetRX_CRC_WIDTH_CH2_RX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.RX_CRC_WIDTH_CH2.Reg) & 0x4) >> 2
}

// AXI_DMA.IN_CRC_CLEAR_CH2: This register is used to clear ch0 crc result
func (o *AXI_DMA_Type) SetIN_CRC_CLEAR_CH2_IN_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_CLEAR_CH2.Reg, volatile.LoadUint32(&o.IN_CRC_CLEAR_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_CRC_CLEAR_CH2_IN_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_CLEAR_CH2.Reg) & 0x1
}

// AXI_DMA.IN_CRC_FINAL_RESULT_CH2: This register is used to store ch0 crc result
func (o *AXI_DMA_Type) SetIN_CRC_FINAL_RESULT_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_CRC_FINAL_RESULT_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetIN_CRC_FINAL_RESULT_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_CRC_FINAL_RESULT_CH2.Reg)
}

// AXI_DMA.RX_CRC_EN_WR_DATA_CH2: This resister is used to config ch0 crc en for every bit
func (o *AXI_DMA_Type) SetRX_CRC_EN_WR_DATA_CH2(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_WR_DATA_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetRX_CRC_EN_WR_DATA_CH2() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_WR_DATA_CH2.Reg)
}

// AXI_DMA.RX_CRC_EN_ADDR_CH2: This register is used to config ch0 crc en addr
func (o *AXI_DMA_Type) SetRX_CRC_EN_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_EN_ADDR_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetRX_CRC_EN_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_EN_ADDR_CH2.Reg)
}

// AXI_DMA.RX_CRC_DATA_EN_WR_DATA_CH2: This register is used to config crc data_8bit en
func (o *AXI_DMA_Type) SetRX_CRC_DATA_EN_WR_DATA_CH2_RX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH2.Reg, volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH2.Reg)&^(0xffff)|value)
}
func (o *AXI_DMA_Type) GetRX_CRC_DATA_EN_WR_DATA_CH2_RX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_WR_DATA_CH2.Reg) & 0xffff
}

// AXI_DMA.RX_CRC_DATA_EN_ADDR_CH2: This register is used to config addr of crc data_8bit en
func (o *AXI_DMA_Type) SetRX_CRC_DATA_EN_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.RX_CRC_DATA_EN_ADDR_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetRX_CRC_DATA_EN_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.RX_CRC_DATA_EN_ADDR_CH2.Reg)
}

// AXI_DMA.OUT_INT_RAW_CH0: Raw status interrupt of channel0
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH0_OUT_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH0_OUT_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH0_OUT_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH0_OUT_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH0_OUT_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH0_OUT_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH0_OUT_TOTAL_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH0_OUT_TOTAL_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_L1_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_L1_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_L1_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_L1_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_L2_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_L2_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_L2_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_L2_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_L3_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_L3_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_L3_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_L3_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_INT_ST_CH0: Masked interrupt of channel0
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH0_OUT_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH0_OUT_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH0_OUT_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH0_OUT_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH0_OUT_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH0_OUT_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH0_OUT_TOTAL_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH0_OUT_TOTAL_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_L1_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_L1_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_L1_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_L1_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_L3_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_L3_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_L3_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_L3_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_INT_ENA_CH0: Interrupt enable bits of channel0
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH0_OUT_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH0_OUT_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH0_OUT_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH0_OUT_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH0_OUT_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH0_OUT_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH0_OUT_TOTAL_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH0_OUT_TOTAL_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_L1_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_L1_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_L1_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_L1_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_L2_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_L2_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_L2_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_L2_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_L3_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_L3_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_L3_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_L3_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_INT_CLR_CH0: Interrupt clear bits of channel0
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH0_OUT_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH0_OUT_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH0_OUT_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH0_OUT_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH0_OUT_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH0_OUT_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH0_OUT_TOTAL_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH0_OUT_TOTAL_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_L1_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_L1_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_L1_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_L1_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_L2_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_L2_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_L2_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_L2_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_L3_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_L3_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_L3_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_L3_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_CONF0_CH0: Configure 0 register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_CONF0_CH0_OUT_RST_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH0_OUT_RST_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH0_OUT_LOOP_TEST_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH0_OUT_LOOP_TEST_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH0_OUT_AUTO_WRBACK_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH0_OUT_AUTO_WRBACK_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH0_OUT_EOF_MODE_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH0_OUT_EOF_MODE_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH0_OUT_ETM_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH0_OUT_ETM_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH0_OUT_BURST_SIZE_SEL_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0xe0)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH0_OUT_BURST_SIZE_SEL_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0xe0) >> 5
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH0_OUT_CMD_DISABLE_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH0_OUT_CMD_DISABLE_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH0_OUT_ECC_AEC_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH0_OUT_ECC_AEC_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH0_OUTDSCR_BURST_EN_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH0_OUTDSCR_BURST_EN_CH0() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x400) >> 10
}

// AXI_DMA.OUT_CONF1_CH0: Configure 1 register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_CONF1_CH0_OUT_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetOUT_CONF1_CH0_OUT_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg) & 0x1000) >> 12
}

// AXI_DMA.OUTFIFO_STATUS_CH0: Transmit FIFO status of Tx channel0
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L3_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L3_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L3_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L3_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L3_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0xfc)|value<<2)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L3_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0xfc) >> 2
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L3_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L3_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L3_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L3_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L1_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L1_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x400) >> 10
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L1_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x800)|value<<11)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L1_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x800) >> 11
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L1_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L1_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1000) >> 12
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L1_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2000)|value<<13)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L1_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2000) >> 13
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L2_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x4000)|value<<14)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L2_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x4000) >> 14
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L2_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x8000)|value<<15)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L2_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x8000) >> 15
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L2_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x10000)|value<<16)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L2_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x10000) >> 16
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_L2_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x20000)|value<<17)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_L2_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x20000) >> 17
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_5B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x8000000)|value<<27)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_5B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x8000000) >> 27
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_6B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x10000000)|value<<28)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_6B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x10000000) >> 28
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_7B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x20000000)|value<<29)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_7B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x20000000) >> 29
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_8B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x40000000)|value<<30)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_8B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x40000000) >> 30
}

// AXI_DMA.OUT_PUSH_CH0: Push control register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_WDATA_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x1ff)|value)
}
func (o *AXI_DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_WDATA_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x1ff
}
func (o *AXI_DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_PUSH_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_PUSH_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_LINK1_CH0: Link descriptor configure and control register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_LINK1_CH0_OUTLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH0_OUTLINK_STOP_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK1_CH0.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_LINK1_CH0_OUTLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH0.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH0_OUTLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK1_CH0.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_LINK1_CH0_OUTLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH0_OUTLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK1_CH0.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_LINK1_CH0_OUTLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH0.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH0_OUTLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK1_CH0.Reg) & 0x8) >> 3
}

// AXI_DMA.OUT_LINK2_CH0: Link descriptor configure and control register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_LINK2_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK2_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_LINK2_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK2_CH0.Reg)
}

// AXI_DMA.OUT_STATE_CH0: Transmit status of Tx channel0
func (o *AXI_DMA_Type) SetOUT_STATE_CH0_OUTLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *AXI_DMA_Type) GetOUT_STATE_CH0_OUTLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x3ffff
}
func (o *AXI_DMA_Type) SetOUT_STATE_CH0_OUT_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *AXI_DMA_Type) GetOUT_STATE_CH0_OUT_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *AXI_DMA_Type) SetOUT_STATE_CH0_OUT_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *AXI_DMA_Type) GetOUT_STATE_CH0_OUT_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x700000) >> 20
}

// AXI_DMA.OUT_EOF_DES_ADDR_CH0: Outlink descriptor address when EOF occurs of Tx channel0
func (o *AXI_DMA_Type) SetOUT_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg)
}

// AXI_DMA.OUT_EOF_BFR_DES_ADDR_CH0: The last outlink descriptor address when EOF occurs of Tx channel0
func (o *AXI_DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg)
}

// AXI_DMA.OUT_DSCR_CH0: Current outlink descriptor address of Tx channel0
func (o *AXI_DMA_Type) SetOUT_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH0.Reg)
}

// AXI_DMA.OUT_DSCR_BF0_CH0: The last outlink descriptor address of Tx channel0
func (o *AXI_DMA_Type) SetOUT_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH0.Reg)
}

// AXI_DMA.OUT_DSCR_BF1_CH0: The second-to-last outlink descriptor address of Tx channel0
func (o *AXI_DMA_Type) SetOUT_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH0.Reg)
}

// AXI_DMA.OUT_PRI_CH0: Priority register of Tx channel0.
func (o *AXI_DMA_Type) SetOUT_PRI_CH0_TX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH0.Reg, volatile.LoadUint32(&o.OUT_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *AXI_DMA_Type) GetOUT_PRI_CH0_TX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH0.Reg) & 0xf
}
func (o *AXI_DMA_Type) SetOUT_PRI_CH0_TX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH0.Reg, volatile.LoadUint32(&o.OUT_PRI_CH0.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_PRI_CH0_TX_CH_ARB_WEIGH_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PRI_CH0.Reg) & 0xf0) >> 4
}
func (o *AXI_DMA_Type) SetOUT_PRI_CH0_TX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH0.Reg, volatile.LoadUint32(&o.OUT_PRI_CH0.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_PRI_CH0_TX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PRI_CH0.Reg) & 0x100) >> 8
}

// AXI_DMA.OUT_PERI_SEL_CH0: Peripheral selection of Tx channel0
func (o *AXI_DMA_Type) SetOUT_PERI_SEL_CH0_PERI_OUT_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetOUT_PERI_SEL_CH0_PERI_OUT_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg) & 0x3f
}

// AXI_DMA.OUT_CRC_INIT_DATA_CH0: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AXI_DMA_Type) SetOUT_CRC_INIT_DATA_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_INIT_DATA_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_CRC_INIT_DATA_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_INIT_DATA_CH0.Reg)
}

// AXI_DMA.TX_CRC_WIDTH_CH0: This register is used to confiig tx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AXI_DMA_Type) SetTX_CRC_WIDTH_CH0_TX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH0.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH0.Reg)&^(0x3)|value)
}
func (o *AXI_DMA_Type) GetTX_CRC_WIDTH_CH0_TX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_WIDTH_CH0.Reg) & 0x3
}
func (o *AXI_DMA_Type) SetTX_CRC_WIDTH_CH0_TX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH0.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH0.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetTX_CRC_WIDTH_CH0_TX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.TX_CRC_WIDTH_CH0.Reg) & 0x4) >> 2
}

// AXI_DMA.OUT_CRC_CLEAR_CH0: This register is used to clear ch0 crc result
func (o *AXI_DMA_Type) SetOUT_CRC_CLEAR_CH0_OUT_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_CLEAR_CH0.Reg, volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_CRC_CLEAR_CH0_OUT_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH0.Reg) & 0x1
}

// AXI_DMA.OUT_CRC_FINAL_RESULT_CH0: This register is used to store ch0 crc result
func (o *AXI_DMA_Type) SetOUT_CRC_FINAL_RESULT_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_FINAL_RESULT_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_CRC_FINAL_RESULT_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_FINAL_RESULT_CH0.Reg)
}

// AXI_DMA.TX_CRC_EN_WR_DATA_CH0: This resister is used to config ch0 crc en for every bit
func (o *AXI_DMA_Type) SetTX_CRC_EN_WR_DATA_CH0(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_WR_DATA_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetTX_CRC_EN_WR_DATA_CH0() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_WR_DATA_CH0.Reg)
}

// AXI_DMA.TX_CRC_EN_ADDR_CH0: This register is used to config ch0 crc en addr
func (o *AXI_DMA_Type) SetTX_CRC_EN_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_ADDR_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetTX_CRC_EN_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_ADDR_CH0.Reg)
}

// AXI_DMA.TX_CRC_DATA_EN_WR_DATA_CH0: This register is used to config crc data_8bit en
func (o *AXI_DMA_Type) SetTX_CRC_DATA_EN_WR_DATA_CH0_TX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH0.Reg, volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH0.Reg)&^(0xffff)|value)
}
func (o *AXI_DMA_Type) GetTX_CRC_DATA_EN_WR_DATA_CH0_TX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH0.Reg) & 0xffff
}

// AXI_DMA.TX_CRC_DATA_EN_ADDR_CH0: This register is used to config addr of crc data_8bit en
func (o *AXI_DMA_Type) SetTX_CRC_DATA_EN_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_ADDR_CH0.Reg, value)
}
func (o *AXI_DMA_Type) GetTX_CRC_DATA_EN_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_ADDR_CH0.Reg)
}

// AXI_DMA.OUT_INT_RAW_CH1: Raw status interrupt of channel0
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH1_OUT_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH1_OUT_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH1_OUT_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH1_OUT_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH1_OUT_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH1_OUT_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH1_OUT_TOTAL_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH1_OUT_TOTAL_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_L1_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_L1_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_L1_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_L1_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_L2_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_L2_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_L2_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_L2_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_L3_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_L3_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_L3_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_L3_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_INT_ST_CH1: Masked interrupt of channel0
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH1_OUT_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH1_OUT_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH1_OUT_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH1_OUT_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH1_OUT_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH1_OUT_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH1_OUT_TOTAL_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH1_OUT_TOTAL_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_L1_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_L1_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_L1_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_L1_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_L3_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_L3_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_L3_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_L3_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_INT_ENA_CH1: Interrupt enable bits of channel0
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH1_OUT_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH1_OUT_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH1_OUT_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH1_OUT_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH1_OUT_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH1_OUT_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH1_OUT_TOTAL_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH1_OUT_TOTAL_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_L1_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_L1_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_L1_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_L1_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_L2_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_L2_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_L2_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_L2_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_L3_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_L3_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_L3_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_L3_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_INT_CLR_CH1: Interrupt clear bits of channel0
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH1_OUT_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH1_OUT_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH1_OUT_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH1_OUT_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH1_OUT_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH1_OUT_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH1_OUT_TOTAL_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH1_OUT_TOTAL_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_L1_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_L1_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_L1_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_L1_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_L2_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_L2_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_L2_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_L2_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_L3_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_L3_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_L3_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_L3_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_CONF0_CH1: Configure 0 register of Tx channel1
func (o *AXI_DMA_Type) SetOUT_CONF0_CH1_OUT_RST_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH1_OUT_RST_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH1_OUT_LOOP_TEST_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH1_OUT_LOOP_TEST_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH1_OUT_AUTO_WRBACK_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH1_OUT_AUTO_WRBACK_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH1_OUT_EOF_MODE_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH1_OUT_EOF_MODE_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH1_OUT_ETM_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH1_OUT_ETM_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH1_OUT_BURST_SIZE_SEL_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0xe0)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH1_OUT_BURST_SIZE_SEL_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0xe0) >> 5
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH1_OUT_CMD_DISABLE_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH1_OUT_CMD_DISABLE_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH1_OUT_ECC_AEC_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH1_OUT_ECC_AEC_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH1_OUTDSCR_BURST_EN_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH1_OUTDSCR_BURST_EN_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x400) >> 10
}

// AXI_DMA.OUT_CONF1_CH1: Configure 1 register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_CONF1_CH1_OUT_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetOUT_CONF1_CH1_OUT_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg) & 0x1000) >> 12
}

// AXI_DMA.OUTFIFO_STATUS_CH1: Transmit FIFO status of Tx channel0
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L3_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L3_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L3_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L3_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L3_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0xfc)|value<<2)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L3_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0xfc) >> 2
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L3_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L3_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L3_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L3_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L1_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L1_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x400) >> 10
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L1_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x800)|value<<11)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L1_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x800) >> 11
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L1_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L1_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1000) >> 12
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L1_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2000)|value<<13)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L1_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2000) >> 13
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L2_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x4000)|value<<14)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L2_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x4000) >> 14
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L2_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x8000)|value<<15)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L2_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x8000) >> 15
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L2_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x10000)|value<<16)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L2_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x10000) >> 16
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_L2_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x20000)|value<<17)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_L2_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x20000) >> 17
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x800000) >> 23
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1000000) >> 24
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2000000)|value<<25)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2000000) >> 25
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x4000000)|value<<26)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x4000000) >> 26
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_5B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x8000000)|value<<27)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_5B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x8000000) >> 27
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_6B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x10000000)|value<<28)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_6B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x10000000) >> 28
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_7B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x20000000)|value<<29)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_7B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x20000000) >> 29
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_8B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x40000000)|value<<30)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_8B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x40000000) >> 30
}

// AXI_DMA.OUT_PUSH_CH1: Push control register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_PUSH_CH1_OUTFIFO_WDATA_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH1.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg)&^(0x1ff)|value)
}
func (o *AXI_DMA_Type) GetOUT_PUSH_CH1_OUTFIFO_WDATA_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg) & 0x1ff
}
func (o *AXI_DMA_Type) SetOUT_PUSH_CH1_OUTFIFO_PUSH_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH1.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_PUSH_CH1_OUTFIFO_PUSH_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_LINK1_CH1: Link descriptor configure and control register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_LINK1_CH1_OUTLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH1_OUTLINK_STOP_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK1_CH1.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_LINK1_CH1_OUTLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH1.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH1_OUTLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK1_CH1.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_LINK1_CH1_OUTLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH1_OUTLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK1_CH1.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_LINK1_CH1_OUTLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH1.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH1_OUTLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK1_CH1.Reg) & 0x8) >> 3
}

// AXI_DMA.OUT_LINK2_CH1: Link descriptor configure and control register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_LINK2_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK2_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_LINK2_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK2_CH1.Reg)
}

// AXI_DMA.OUT_STATE_CH1: Transmit status of Tx channel0
func (o *AXI_DMA_Type) SetOUT_STATE_CH1_OUTLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0x3ffff)|value)
}
func (o *AXI_DMA_Type) GetOUT_STATE_CH1_OUTLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0x3ffff
}
func (o *AXI_DMA_Type) SetOUT_STATE_CH1_OUT_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0xc0000)|value<<18)
}
func (o *AXI_DMA_Type) GetOUT_STATE_CH1_OUT_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0xc0000) >> 18
}
func (o *AXI_DMA_Type) SetOUT_STATE_CH1_OUT_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0x700000)|value<<20)
}
func (o *AXI_DMA_Type) GetOUT_STATE_CH1_OUT_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0x700000) >> 20
}

// AXI_DMA.OUT_EOF_DES_ADDR_CH1: Outlink descriptor address when EOF occurs of Tx channel0
func (o *AXI_DMA_Type) SetOUT_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH1.Reg)
}

// AXI_DMA.OUT_EOF_BFR_DES_ADDR_CH1: The last outlink descriptor address when EOF occurs of Tx channel0
func (o *AXI_DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH1.Reg)
}

// AXI_DMA.OUT_DSCR_CH1: Current outlink descriptor address of Tx channel0
func (o *AXI_DMA_Type) SetOUT_DSCR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_DSCR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH1.Reg)
}

// AXI_DMA.OUT_DSCR_BF0_CH1: The last outlink descriptor address of Tx channel0
func (o *AXI_DMA_Type) SetOUT_DSCR_BF0_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_DSCR_BF0_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH1.Reg)
}

// AXI_DMA.OUT_DSCR_BF1_CH1: The second-to-last outlink descriptor address of Tx channel0
func (o *AXI_DMA_Type) SetOUT_DSCR_BF1_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_DSCR_BF1_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH1.Reg)
}

// AXI_DMA.OUT_PRI_CH1: Priority register of Tx channel0.
func (o *AXI_DMA_Type) SetOUT_PRI_CH1_TX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH1.Reg, volatile.LoadUint32(&o.OUT_PRI_CH1.Reg)&^(0xf)|value)
}
func (o *AXI_DMA_Type) GetOUT_PRI_CH1_TX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH1.Reg) & 0xf
}
func (o *AXI_DMA_Type) SetOUT_PRI_CH1_TX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH1.Reg, volatile.LoadUint32(&o.OUT_PRI_CH1.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_PRI_CH1_TX_CH_ARB_WEIGH_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PRI_CH1.Reg) & 0xf0) >> 4
}
func (o *AXI_DMA_Type) SetOUT_PRI_CH1_TX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH1.Reg, volatile.LoadUint32(&o.OUT_PRI_CH1.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_PRI_CH1_TX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PRI_CH1.Reg) & 0x100) >> 8
}

// AXI_DMA.OUT_PERI_SEL_CH1: Peripheral selection of Tx channel0
func (o *AXI_DMA_Type) SetOUT_PERI_SEL_CH1_PERI_OUT_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH1.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH1.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetOUT_PERI_SEL_CH1_PERI_OUT_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH1.Reg) & 0x3f
}

// AXI_DMA.OUT_CRC_INIT_DATA_CH1: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AXI_DMA_Type) SetOUT_CRC_INIT_DATA_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_INIT_DATA_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_CRC_INIT_DATA_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_INIT_DATA_CH1.Reg)
}

// AXI_DMA.TX_CRC_WIDTH_CH1: This register is used to confiig tx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AXI_DMA_Type) SetTX_CRC_WIDTH_CH1_TX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH1.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH1.Reg)&^(0x3)|value)
}
func (o *AXI_DMA_Type) GetTX_CRC_WIDTH_CH1_TX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_WIDTH_CH1.Reg) & 0x3
}
func (o *AXI_DMA_Type) SetTX_CRC_WIDTH_CH1_TX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH1.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH1.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetTX_CRC_WIDTH_CH1_TX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.TX_CRC_WIDTH_CH1.Reg) & 0x4) >> 2
}

// AXI_DMA.OUT_CRC_CLEAR_CH1: This register is used to clear ch0 crc result
func (o *AXI_DMA_Type) SetOUT_CRC_CLEAR_CH1_OUT_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_CLEAR_CH1.Reg, volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_CRC_CLEAR_CH1_OUT_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH1.Reg) & 0x1
}

// AXI_DMA.OUT_CRC_FINAL_RESULT_CH1: This register is used to store ch0 crc result
func (o *AXI_DMA_Type) SetOUT_CRC_FINAL_RESULT_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_FINAL_RESULT_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_CRC_FINAL_RESULT_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_FINAL_RESULT_CH1.Reg)
}

// AXI_DMA.TX_CRC_EN_WR_DATA_CH1: This resister is used to config ch0 crc en for every bit
func (o *AXI_DMA_Type) SetTX_CRC_EN_WR_DATA_CH1(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_WR_DATA_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetTX_CRC_EN_WR_DATA_CH1() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_WR_DATA_CH1.Reg)
}

// AXI_DMA.TX_CRC_EN_ADDR_CH1: This register is used to config ch0 crc en addr
func (o *AXI_DMA_Type) SetTX_CRC_EN_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_ADDR_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetTX_CRC_EN_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_ADDR_CH1.Reg)
}

// AXI_DMA.TX_CRC_DATA_EN_WR_DATA_CH1: This register is used to config crc data_8bit en
func (o *AXI_DMA_Type) SetTX_CRC_DATA_EN_WR_DATA_CH1_TX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH1.Reg, volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH1.Reg)&^(0xffff)|value)
}
func (o *AXI_DMA_Type) GetTX_CRC_DATA_EN_WR_DATA_CH1_TX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH1.Reg) & 0xffff
}

// AXI_DMA.TX_CRC_DATA_EN_ADDR_CH1: This register is used to config addr of crc data_8bit en
func (o *AXI_DMA_Type) SetTX_CRC_DATA_EN_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_ADDR_CH1.Reg, value)
}
func (o *AXI_DMA_Type) GetTX_CRC_DATA_EN_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_ADDR_CH1.Reg)
}

// AXI_DMA.OUT_INT_RAW_CH2: Raw status interrupt of channel0
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH2_OUT_DONE_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH2_OUT_DONE_CH_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH2_OUT_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH2_OUT_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH2_OUT_DSCR_ERR_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH2_OUT_DSCR_ERR_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH2_OUT_TOTAL_EOF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH2_OUT_TOTAL_EOF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_L1_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_L1_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_L1_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_L1_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_L2_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_L2_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_L2_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_L2_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_L3_OVF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_L3_OVF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_L3_UDF_CH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_L3_UDF_CH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_INT_ST_CH2: Masked interrupt of channel0
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH2_OUT_DONE_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH2_OUT_DONE_CH_INT_ST() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH2_OUT_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH2_OUT_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH2_OUT_DSCR_ERR_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH2_OUT_DSCR_ERR_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH2_OUT_TOTAL_EOF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH2_OUT_TOTAL_EOF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_L1_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_L1_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_L1_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_L1_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_L3_OVF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_L3_OVF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_L3_UDF_CH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_L3_UDF_CH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_INT_ENA_CH2: Interrupt enable bits of channel0
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH2_OUT_DONE_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH2_OUT_DONE_CH_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH2_OUT_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH2_OUT_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH2_OUT_DSCR_ERR_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH2_OUT_DSCR_ERR_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH2_OUT_TOTAL_EOF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH2_OUT_TOTAL_EOF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_L1_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_L1_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_L1_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_L1_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_L2_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_L2_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_L2_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_L2_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_L3_OVF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_L3_OVF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_L3_UDF_CH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_L3_UDF_CH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_INT_CLR_CH2: Interrupt clear bits of channel0
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH2_OUT_DONE_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH2_OUT_DONE_CH_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH2_OUT_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH2_OUT_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH2_OUT_DSCR_ERR_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH2_OUT_DSCR_ERR_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH2_OUT_TOTAL_EOF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH2_OUT_TOTAL_EOF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_L1_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_L1_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_L1_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_L1_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x20) >> 5
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_L2_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x40)|value<<6)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_L2_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x40) >> 6
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_L2_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x80)|value<<7)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_L2_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x80) >> 7
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_L3_OVF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_L3_OVF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_L3_UDF_CH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_L3_UDF_CH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_CONF0_CH2: Configure 0 register of Tx channel2
func (o *AXI_DMA_Type) SetOUT_CONF0_CH2_OUT_RST_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH2_OUT_RST_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH2_OUT_LOOP_TEST_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH2_OUT_LOOP_TEST_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH2_OUT_AUTO_WRBACK_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH2_OUT_AUTO_WRBACK_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH2_OUT_EOF_MODE_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH2_OUT_EOF_MODE_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH2_OUT_ETM_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH2_OUT_ETM_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH2_OUT_BURST_SIZE_SEL_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0xe0)|value<<5)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH2_OUT_BURST_SIZE_SEL_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0xe0) >> 5
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH2_OUT_CMD_DISABLE_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH2_OUT_CMD_DISABLE_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH2_OUT_ECC_AEC_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH2_OUT_ECC_AEC_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetOUT_CONF0_CH2_OUTDSCR_BURST_EN_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetOUT_CONF0_CH2_OUTDSCR_BURST_EN_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x400) >> 10
}

// AXI_DMA.OUT_CONF1_CH2: Configure 1 register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_CONF1_CH2_OUT_CHECK_OWNER_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetOUT_CONF1_CH2_OUT_CHECK_OWNER_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg) & 0x1000) >> 12
}

// AXI_DMA.OUTFIFO_STATUS_CH2: Transmit FIFO status of Tx channel0
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L3_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L3_FULL_CH() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L3_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L3_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L3_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0xfc)|value<<2)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L3_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0xfc) >> 2
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L3_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L3_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x100) >> 8
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L3_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L3_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x200) >> 9
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L1_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x400)|value<<10)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L1_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x400) >> 10
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L1_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x800)|value<<11)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L1_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x800) >> 11
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L1_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L1_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1000) >> 12
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L1_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2000)|value<<13)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L1_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2000) >> 13
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L2_FULL_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x4000)|value<<14)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L2_FULL_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x4000) >> 14
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L2_EMPTY_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x8000)|value<<15)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L2_EMPTY_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x8000) >> 15
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L2_UDF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x10000)|value<<16)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L2_UDF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x10000) >> 16
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_L2_OVF_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x20000)|value<<17)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_L2_OVF_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x20000) >> 17
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_1B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_1B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x800000) >> 23
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_2B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_2B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1000000) >> 24
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_3B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2000000)|value<<25)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_3B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2000000) >> 25
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_4B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x4000000)|value<<26)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_4B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x4000000) >> 26
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_5B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x8000000)|value<<27)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_5B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x8000000) >> 27
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_6B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x10000000)|value<<28)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_6B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x10000000) >> 28
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_7B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x20000000)|value<<29)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_7B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x20000000) >> 29
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_8B_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x40000000)|value<<30)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_8B_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x40000000) >> 30
}

// AXI_DMA.OUT_PUSH_CH2: Push control register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_PUSH_CH2_OUTFIFO_WDATA_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH2.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg)&^(0x1ff)|value)
}
func (o *AXI_DMA_Type) GetOUT_PUSH_CH2_OUTFIFO_WDATA_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg) & 0x1ff
}
func (o *AXI_DMA_Type) SetOUT_PUSH_CH2_OUTFIFO_PUSH_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH2.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg)&^(0x200)|value<<9)
}
func (o *AXI_DMA_Type) GetOUT_PUSH_CH2_OUTFIFO_PUSH_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg) & 0x200) >> 9
}

// AXI_DMA.OUT_LINK1_CH2: Link descriptor configure and control register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_LINK1_CH2_OUTLINK_STOP_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH2_OUTLINK_STOP_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK1_CH2.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetOUT_LINK1_CH2_OUTLINK_START_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH2.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH2_OUTLINK_START_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK1_CH2.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetOUT_LINK1_CH2_OUTLINK_RESTART_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH2_OUTLINK_RESTART_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK1_CH2.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetOUT_LINK1_CH2_OUTLINK_PARK_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK1_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK1_CH2.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetOUT_LINK1_CH2_OUTLINK_PARK_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK1_CH2.Reg) & 0x8) >> 3
}

// AXI_DMA.OUT_LINK2_CH2: Link descriptor configure and control register of Tx channel0
func (o *AXI_DMA_Type) SetOUT_LINK2_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK2_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_LINK2_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK2_CH2.Reg)
}

// AXI_DMA.OUT_STATE_CH2: Transmit status of Tx channel0
func (o *AXI_DMA_Type) SetOUT_STATE_CH2_OUTLINK_DSCR_ADDR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0x3ffff)|value)
}
func (o *AXI_DMA_Type) GetOUT_STATE_CH2_OUTLINK_DSCR_ADDR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0x3ffff
}
func (o *AXI_DMA_Type) SetOUT_STATE_CH2_OUT_DSCR_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0xc0000)|value<<18)
}
func (o *AXI_DMA_Type) GetOUT_STATE_CH2_OUT_DSCR_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0xc0000) >> 18
}
func (o *AXI_DMA_Type) SetOUT_STATE_CH2_OUT_STATE_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0x700000)|value<<20)
}
func (o *AXI_DMA_Type) GetOUT_STATE_CH2_OUT_STATE_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0x700000) >> 20
}

// AXI_DMA.OUT_EOF_DES_ADDR_CH2: Outlink descriptor address when EOF occurs of Tx channel0
func (o *AXI_DMA_Type) SetOUT_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH2.Reg)
}

// AXI_DMA.OUT_EOF_BFR_DES_ADDR_CH2: The last outlink descriptor address when EOF occurs of Tx channel0
func (o *AXI_DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH2.Reg)
}

// AXI_DMA.OUT_DSCR_CH2: Current outlink descriptor address of Tx channel0
func (o *AXI_DMA_Type) SetOUT_DSCR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_DSCR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH2.Reg)
}

// AXI_DMA.OUT_DSCR_BF0_CH2: The last outlink descriptor address of Tx channel0
func (o *AXI_DMA_Type) SetOUT_DSCR_BF0_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_DSCR_BF0_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH2.Reg)
}

// AXI_DMA.OUT_DSCR_BF1_CH2: The second-to-last outlink descriptor address of Tx channel0
func (o *AXI_DMA_Type) SetOUT_DSCR_BF1_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_DSCR_BF1_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH2.Reg)
}

// AXI_DMA.OUT_PRI_CH2: Priority register of Tx channel0.
func (o *AXI_DMA_Type) SetOUT_PRI_CH2_TX_PRI_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH2.Reg, volatile.LoadUint32(&o.OUT_PRI_CH2.Reg)&^(0xf)|value)
}
func (o *AXI_DMA_Type) GetOUT_PRI_CH2_TX_PRI_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH2.Reg) & 0xf
}
func (o *AXI_DMA_Type) SetOUT_PRI_CH2_TX_CH_ARB_WEIGH_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH2.Reg, volatile.LoadUint32(&o.OUT_PRI_CH2.Reg)&^(0xf0)|value<<4)
}
func (o *AXI_DMA_Type) GetOUT_PRI_CH2_TX_CH_ARB_WEIGH_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PRI_CH2.Reg) & 0xf0) >> 4
}
func (o *AXI_DMA_Type) SetOUT_PRI_CH2_TX_ARB_WEIGH_OPT_DIR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH2.Reg, volatile.LoadUint32(&o.OUT_PRI_CH2.Reg)&^(0x100)|value<<8)
}
func (o *AXI_DMA_Type) GetOUT_PRI_CH2_TX_ARB_WEIGH_OPT_DIR_CH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PRI_CH2.Reg) & 0x100) >> 8
}

// AXI_DMA.OUT_PERI_SEL_CH2: Peripheral selection of Tx channel0
func (o *AXI_DMA_Type) SetOUT_PERI_SEL_CH2_PERI_OUT_SEL_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH2.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH2.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetOUT_PERI_SEL_CH2_PERI_OUT_SEL_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH2.Reg) & 0x3f
}

// AXI_DMA.OUT_CRC_INIT_DATA_CH2: This register is used to config ch0 crc initial data(max 32 bit)
func (o *AXI_DMA_Type) SetOUT_CRC_INIT_DATA_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_INIT_DATA_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_CRC_INIT_DATA_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_INIT_DATA_CH2.Reg)
}

// AXI_DMA.TX_CRC_WIDTH_CH2: This register is used to confiig tx ch0 crc result width,2'b00 mean crc_width <=8bit,2'b01 8<crc_width<=16 ,2'b10 mean 16<crc_width <=24,2'b11 mean 24<crc_width<=32
func (o *AXI_DMA_Type) SetTX_CRC_WIDTH_CH2_TX_CRC_WIDTH_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH2.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH2.Reg)&^(0x3)|value)
}
func (o *AXI_DMA_Type) GetTX_CRC_WIDTH_CH2_TX_CRC_WIDTH_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_WIDTH_CH2.Reg) & 0x3
}
func (o *AXI_DMA_Type) SetTX_CRC_WIDTH_CH2_TX_CRC_LAUTCH_FLGA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_WIDTH_CH2.Reg, volatile.LoadUint32(&o.TX_CRC_WIDTH_CH2.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetTX_CRC_WIDTH_CH2_TX_CRC_LAUTCH_FLGA_CH() uint32 {
	return (volatile.LoadUint32(&o.TX_CRC_WIDTH_CH2.Reg) & 0x4) >> 2
}

// AXI_DMA.OUT_CRC_CLEAR_CH2: This register is used to clear ch0 crc result
func (o *AXI_DMA_Type) SetOUT_CRC_CLEAR_CH2_OUT_CRC_CLEAR_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_CLEAR_CH2.Reg, volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_CRC_CLEAR_CH2_OUT_CRC_CLEAR_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_CLEAR_CH2.Reg) & 0x1
}

// AXI_DMA.OUT_CRC_FINAL_RESULT_CH2: This register is used to store ch0 crc result
func (o *AXI_DMA_Type) SetOUT_CRC_FINAL_RESULT_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_CRC_FINAL_RESULT_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetOUT_CRC_FINAL_RESULT_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_CRC_FINAL_RESULT_CH2.Reg)
}

// AXI_DMA.TX_CRC_EN_WR_DATA_CH2: This resister is used to config ch0 crc en for every bit
func (o *AXI_DMA_Type) SetTX_CRC_EN_WR_DATA_CH2(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_WR_DATA_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetTX_CRC_EN_WR_DATA_CH2() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_WR_DATA_CH2.Reg)
}

// AXI_DMA.TX_CRC_EN_ADDR_CH2: This register is used to config ch0 crc en addr
func (o *AXI_DMA_Type) SetTX_CRC_EN_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_EN_ADDR_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetTX_CRC_EN_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_EN_ADDR_CH2.Reg)
}

// AXI_DMA.TX_CRC_DATA_EN_WR_DATA_CH2: This register is used to config crc data_8bit en
func (o *AXI_DMA_Type) SetTX_CRC_DATA_EN_WR_DATA_CH2_TX_CRC_DATA_EN_WR_DATA_CH(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH2.Reg, volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH2.Reg)&^(0xffff)|value)
}
func (o *AXI_DMA_Type) GetTX_CRC_DATA_EN_WR_DATA_CH2_TX_CRC_DATA_EN_WR_DATA_CH() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_WR_DATA_CH2.Reg) & 0xffff
}

// AXI_DMA.TX_CRC_DATA_EN_ADDR_CH2: This register is used to config addr of crc data_8bit en
func (o *AXI_DMA_Type) SetTX_CRC_DATA_EN_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.TX_CRC_DATA_EN_ADDR_CH2.Reg, value)
}
func (o *AXI_DMA_Type) GetTX_CRC_DATA_EN_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.TX_CRC_DATA_EN_ADDR_CH2.Reg)
}

// AXI_DMA.ARB_TIMEOUT: This retister is used to config arbiter time slice
func (o *AXI_DMA_Type) SetARB_TIMEOUT_TX(value uint32) {
	volatile.StoreUint32(&o.ARB_TIMEOUT.Reg, volatile.LoadUint32(&o.ARB_TIMEOUT.Reg)&^(0xffff)|value)
}
func (o *AXI_DMA_Type) GetARB_TIMEOUT_TX() uint32 {
	return volatile.LoadUint32(&o.ARB_TIMEOUT.Reg) & 0xffff
}
func (o *AXI_DMA_Type) SetARB_TIMEOUT_RX(value uint32) {
	volatile.StoreUint32(&o.ARB_TIMEOUT.Reg, volatile.LoadUint32(&o.ARB_TIMEOUT.Reg)&^(0xffff0000)|value<<16)
}
func (o *AXI_DMA_Type) GetARB_TIMEOUT_RX() uint32 {
	return (volatile.LoadUint32(&o.ARB_TIMEOUT.Reg) & 0xffff0000) >> 16
}

// AXI_DMA.WEIGHT_EN: This register is used to config arbiter weight function to on or off
func (o *AXI_DMA_Type) SetWEIGHT_EN_TX(value uint32) {
	volatile.StoreUint32(&o.WEIGHT_EN.Reg, volatile.LoadUint32(&o.WEIGHT_EN.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetWEIGHT_EN_TX() uint32 {
	return volatile.LoadUint32(&o.WEIGHT_EN.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetWEIGHT_EN_RX(value uint32) {
	volatile.StoreUint32(&o.WEIGHT_EN.Reg, volatile.LoadUint32(&o.WEIGHT_EN.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetWEIGHT_EN_RX() uint32 {
	return (volatile.LoadUint32(&o.WEIGHT_EN.Reg) & 0x2) >> 1
}

// AXI_DMA.IN_MEM_CONF: Mem power configure register of Rx channel
func (o *AXI_DMA_Type) SetIN_MEM_CONF_IN_MEM_CLK_FORCE_EN(value uint32) {
	volatile.StoreUint32(&o.IN_MEM_CONF.Reg, volatile.LoadUint32(&o.IN_MEM_CONF.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_MEM_CONF_IN_MEM_CLK_FORCE_EN() uint32 {
	return volatile.LoadUint32(&o.IN_MEM_CONF.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetIN_MEM_CONF_IN_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.IN_MEM_CONF.Reg, volatile.LoadUint32(&o.IN_MEM_CONF.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetIN_MEM_CONF_IN_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.IN_MEM_CONF.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetIN_MEM_CONF_IN_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.IN_MEM_CONF.Reg, volatile.LoadUint32(&o.IN_MEM_CONF.Reg)&^(0x4)|value<<2)
}
func (o *AXI_DMA_Type) GetIN_MEM_CONF_IN_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.IN_MEM_CONF.Reg) & 0x4) >> 2
}
func (o *AXI_DMA_Type) SetIN_MEM_CONF_OUT_MEM_CLK_FORCE_EN(value uint32) {
	volatile.StoreUint32(&o.IN_MEM_CONF.Reg, volatile.LoadUint32(&o.IN_MEM_CONF.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetIN_MEM_CONF_OUT_MEM_CLK_FORCE_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_MEM_CONF.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetIN_MEM_CONF_OUT_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.IN_MEM_CONF.Reg, volatile.LoadUint32(&o.IN_MEM_CONF.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetIN_MEM_CONF_OUT_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.IN_MEM_CONF.Reg) & 0x10) >> 4
}
func (o *AXI_DMA_Type) SetIN_MEM_CONF_OUT_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.IN_MEM_CONF.Reg, volatile.LoadUint32(&o.IN_MEM_CONF.Reg)&^(0x20)|value<<5)
}
func (o *AXI_DMA_Type) GetIN_MEM_CONF_OUT_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.IN_MEM_CONF.Reg) & 0x20) >> 5
}

// AXI_DMA.INTR_MEM_START_ADDR: The start address of accessible address space.
func (o *AXI_DMA_Type) SetINTR_MEM_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.INTR_MEM_START_ADDR.Reg, value)
}
func (o *AXI_DMA_Type) GetINTR_MEM_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.INTR_MEM_START_ADDR.Reg)
}

// AXI_DMA.INTR_MEM_END_ADDR: The end address of accessible address space. The access address beyond this range would lead to descriptor error.
func (o *AXI_DMA_Type) SetINTR_MEM_END_ADDR(value uint32) {
	volatile.StoreUint32(&o.INTR_MEM_END_ADDR.Reg, value)
}
func (o *AXI_DMA_Type) GetINTR_MEM_END_ADDR() uint32 {
	return volatile.LoadUint32(&o.INTR_MEM_END_ADDR.Reg)
}

// AXI_DMA.EXTR_MEM_START_ADDR: The start address of accessible address space.
func (o *AXI_DMA_Type) SetEXTR_MEM_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.EXTR_MEM_START_ADDR.Reg, value)
}
func (o *AXI_DMA_Type) GetEXTR_MEM_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.EXTR_MEM_START_ADDR.Reg)
}

// AXI_DMA.EXTR_MEM_END_ADDR: The end address of accessible address space. The access address beyond this range would lead to descriptor error.
func (o *AXI_DMA_Type) SetEXTR_MEM_END_ADDR(value uint32) {
	volatile.StoreUint32(&o.EXTR_MEM_END_ADDR.Reg, value)
}
func (o *AXI_DMA_Type) GetEXTR_MEM_END_ADDR() uint32 {
	return volatile.LoadUint32(&o.EXTR_MEM_END_ADDR.Reg)
}

// AXI_DMA.IN_RESET_AVAIL_CH0: The rx channel 0 reset valid_flag register.
func (o *AXI_DMA_Type) SetIN_RESET_AVAIL_CH0_IN_RESET_AVAIL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_RESET_AVAIL_CH0.Reg, volatile.LoadUint32(&o.IN_RESET_AVAIL_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_RESET_AVAIL_CH0_IN_RESET_AVAIL_CH() uint32 {
	return volatile.LoadUint32(&o.IN_RESET_AVAIL_CH0.Reg) & 0x1
}

// AXI_DMA.IN_RESET_AVAIL_CH1: The rx channel 0 reset valid_flag register.
func (o *AXI_DMA_Type) SetIN_RESET_AVAIL_CH1_IN_RESET_AVAIL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_RESET_AVAIL_CH1.Reg, volatile.LoadUint32(&o.IN_RESET_AVAIL_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_RESET_AVAIL_CH1_IN_RESET_AVAIL_CH() uint32 {
	return volatile.LoadUint32(&o.IN_RESET_AVAIL_CH1.Reg) & 0x1
}

// AXI_DMA.IN_RESET_AVAIL_CH2: The rx channel 0 reset valid_flag register.
func (o *AXI_DMA_Type) SetIN_RESET_AVAIL_CH2_IN_RESET_AVAIL_CH(value uint32) {
	volatile.StoreUint32(&o.IN_RESET_AVAIL_CH2.Reg, volatile.LoadUint32(&o.IN_RESET_AVAIL_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetIN_RESET_AVAIL_CH2_IN_RESET_AVAIL_CH() uint32 {
	return volatile.LoadUint32(&o.IN_RESET_AVAIL_CH2.Reg) & 0x1
}

// AXI_DMA.OUT_RESET_AVAIL_CH0: The tx channel 0 reset valid_flag register.
func (o *AXI_DMA_Type) SetOUT_RESET_AVAIL_CH0_OUT_RESET_AVAIL_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_RESET_AVAIL_CH0.Reg, volatile.LoadUint32(&o.OUT_RESET_AVAIL_CH0.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_RESET_AVAIL_CH0_OUT_RESET_AVAIL_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_RESET_AVAIL_CH0.Reg) & 0x1
}

// AXI_DMA.OUT_RESET_AVAIL_CH1: The tx channel 0 reset valid_flag register.
func (o *AXI_DMA_Type) SetOUT_RESET_AVAIL_CH1_OUT_RESET_AVAIL_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_RESET_AVAIL_CH1.Reg, volatile.LoadUint32(&o.OUT_RESET_AVAIL_CH1.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_RESET_AVAIL_CH1_OUT_RESET_AVAIL_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_RESET_AVAIL_CH1.Reg) & 0x1
}

// AXI_DMA.OUT_RESET_AVAIL_CH2: The tx channel 0 reset valid_flag register.
func (o *AXI_DMA_Type) SetOUT_RESET_AVAIL_CH2_OUT_RESET_AVAIL_CH(value uint32) {
	volatile.StoreUint32(&o.OUT_RESET_AVAIL_CH2.Reg, volatile.LoadUint32(&o.OUT_RESET_AVAIL_CH2.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetOUT_RESET_AVAIL_CH2_OUT_RESET_AVAIL_CH() uint32 {
	return volatile.LoadUint32(&o.OUT_RESET_AVAIL_CH2.Reg) & 0x1
}

// AXI_DMA.MISC_CONF: MISC register
func (o *AXI_DMA_Type) SetMISC_CONF_AXIM_RST_WR_INTER(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetMISC_CONF_AXIM_RST_WR_INTER() uint32 {
	return volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetMISC_CONF_AXIM_RST_RD_INTER(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetMISC_CONF_AXIM_RST_RD_INTER() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x2) >> 1
}
func (o *AXI_DMA_Type) SetMISC_CONF_ARB_PRI_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x8)|value<<3)
}
func (o *AXI_DMA_Type) GetMISC_CONF_ARB_PRI_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x8) >> 3
}
func (o *AXI_DMA_Type) SetMISC_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x10)|value<<4)
}
func (o *AXI_DMA_Type) GetMISC_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x10) >> 4
}

// AXI_DMA.RDN_RESULT: reserved
func (o *AXI_DMA_Type) SetRDN_RESULT_RDN_ENA(value uint32) {
	volatile.StoreUint32(&o.RDN_RESULT.Reg, volatile.LoadUint32(&o.RDN_RESULT.Reg)&^(0x1)|value)
}
func (o *AXI_DMA_Type) GetRDN_RESULT_RDN_ENA() uint32 {
	return volatile.LoadUint32(&o.RDN_RESULT.Reg) & 0x1
}
func (o *AXI_DMA_Type) SetRDN_RESULT(value uint32) {
	volatile.StoreUint32(&o.RDN_RESULT.Reg, volatile.LoadUint32(&o.RDN_RESULT.Reg)&^(0x2)|value<<1)
}
func (o *AXI_DMA_Type) GetRDN_RESULT() uint32 {
	return (volatile.LoadUint32(&o.RDN_RESULT.Reg) & 0x2) >> 1
}

// AXI_DMA.RDN_ECO_HIGH: reserved
func (o *AXI_DMA_Type) SetRDN_ECO_HIGH(value uint32) {
	volatile.StoreUint32(&o.RDN_ECO_HIGH.Reg, value)
}
func (o *AXI_DMA_Type) GetRDN_ECO_HIGH() uint32 {
	return volatile.LoadUint32(&o.RDN_ECO_HIGH.Reg)
}

// AXI_DMA.RDN_ECO_LOW: reserved
func (o *AXI_DMA_Type) SetRDN_ECO_LOW(value uint32) {
	volatile.StoreUint32(&o.RDN_ECO_LOW.Reg, value)
}
func (o *AXI_DMA_Type) GetRDN_ECO_LOW() uint32 {
	return volatile.LoadUint32(&o.RDN_ECO_LOW.Reg)
}

// AXI_DMA.WRESP_CNT: AXI wr responce cnt register.
func (o *AXI_DMA_Type) SetWRESP_CNT(value uint32) {
	volatile.StoreUint32(&o.WRESP_CNT.Reg, volatile.LoadUint32(&o.WRESP_CNT.Reg)&^(0xf)|value)
}
func (o *AXI_DMA_Type) GetWRESP_CNT() uint32 {
	return volatile.LoadUint32(&o.WRESP_CNT.Reg) & 0xf
}

// AXI_DMA.RRESP_CNT: AXI wr responce cnt register.
func (o *AXI_DMA_Type) SetRRESP_CNT(value uint32) {
	volatile.StoreUint32(&o.RRESP_CNT.Reg, volatile.LoadUint32(&o.RRESP_CNT.Reg)&^(0xf)|value)
}
func (o *AXI_DMA_Type) GetRRESP_CNT() uint32 {
	return volatile.LoadUint32(&o.RRESP_CNT.Reg) & 0xf
}

// AXI_DMA.INFIFO_STATUS1_CH0: Receive FIFO status of Rx channel 0
func (o *AXI_DMA_Type) SetINFIFO_STATUS1_CH0_L1INFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS1_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS1_CH0.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS1_CH0_L1INFIFO_CNT_CH() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS1_CH0.Reg) & 0x3f
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS1_CH0_L2INFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS1_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS1_CH0.Reg)&^(0x3c0)|value<<6)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS1_CH0_L2INFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS1_CH0.Reg) & 0x3c0) >> 6
}

// AXI_DMA.INFIFO_STATUS1_CH1: Receive FIFO status of Rx channel 0
func (o *AXI_DMA_Type) SetINFIFO_STATUS1_CH1_L1INFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS1_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS1_CH1.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS1_CH1_L1INFIFO_CNT_CH() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS1_CH1.Reg) & 0x3f
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS1_CH1_L2INFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS1_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS1_CH1.Reg)&^(0x3c0)|value<<6)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS1_CH1_L2INFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS1_CH1.Reg) & 0x3c0) >> 6
}

// AXI_DMA.INFIFO_STATUS1_CH2: Receive FIFO status of Rx channel 0
func (o *AXI_DMA_Type) SetINFIFO_STATUS1_CH2_L1INFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS1_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS1_CH2.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS1_CH2_L1INFIFO_CNT_CH() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS1_CH2.Reg) & 0x3f
}
func (o *AXI_DMA_Type) SetINFIFO_STATUS1_CH2_L2INFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS1_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS1_CH2.Reg)&^(0x3c0)|value<<6)
}
func (o *AXI_DMA_Type) GetINFIFO_STATUS1_CH2_L2INFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS1_CH2.Reg) & 0x3c0) >> 6
}

// AXI_DMA.OUTFIFO_STATUS1_CH0: Receive FIFO status of Tx channel 0
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS1_CH0_L1OUTFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS1_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH0.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS1_CH0_L1OUTFIFO_CNT_CH() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH0.Reg) & 0x3f
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS1_CH0_L2OUTFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS1_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH0.Reg)&^(0x3c0)|value<<6)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS1_CH0_L2OUTFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH0.Reg) & 0x3c0) >> 6
}

// AXI_DMA.OUTFIFO_STATUS1_CH1: Receive FIFO status of Tx channel 0
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS1_CH1_L1OUTFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS1_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH1.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS1_CH1_L1OUTFIFO_CNT_CH() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH1.Reg) & 0x3f
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS1_CH1_L2OUTFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS1_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH1.Reg)&^(0x3c0)|value<<6)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS1_CH1_L2OUTFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH1.Reg) & 0x3c0) >> 6
}

// AXI_DMA.OUTFIFO_STATUS1_CH2: Receive FIFO status of Tx channel 0
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS1_CH2_L1OUTFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS1_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH2.Reg)&^(0x3f)|value)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS1_CH2_L1OUTFIFO_CNT_CH() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH2.Reg) & 0x3f
}
func (o *AXI_DMA_Type) SetOUTFIFO_STATUS1_CH2_L2OUTFIFO_CNT_CH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS1_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH2.Reg)&^(0x3c0)|value<<6)
}
func (o *AXI_DMA_Type) GetOUTFIFO_STATUS1_CH2_L2OUTFIFO_CNT_CH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS1_CH2.Reg) & 0x3c0) >> 6
}

// AXI_DMA.DATE: Version control register
func (o *AXI_DMA_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *AXI_DMA_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// BITSCRAMBLER Peripheral
type BITSCRAMBLER_Type struct {
	TX_INST_CFG0    volatile.Register32 // 0x0
	TX_INST_CFG1    volatile.Register32 // 0x4
	RX_INST_CFG0    volatile.Register32 // 0x8
	RX_INST_CFG1    volatile.Register32 // 0xC
	TX_LUT_CFG0     volatile.Register32 // 0x10
	TX_LUT_CFG1     volatile.Register32 // 0x14
	RX_LUT_CFG0     volatile.Register32 // 0x18
	RX_LUT_CFG1     volatile.Register32 // 0x1C
	TX_TAILING_BITS volatile.Register32 // 0x20
	RX_TAILING_BITS volatile.Register32 // 0x24
	TX_CTRL         volatile.Register32 // 0x28
	RX_CTRL         volatile.Register32 // 0x2C
	TX_STATE        volatile.Register32 // 0x30
	RX_STATE        volatile.Register32 // 0x34
	_               [192]byte
	SYS             volatile.Register32 // 0xF8
	VERSION         volatile.Register32 // 0xFC
}

// BITSCRAMBLER.TX_INST_CFG0: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetTX_INST_CFG0_TX_INST_IDX(value uint32) {
	volatile.StoreUint32(&o.TX_INST_CFG0.Reg, volatile.LoadUint32(&o.TX_INST_CFG0.Reg)&^(0x7)|value)
}
func (o *BITSCRAMBLER_Type) GetTX_INST_CFG0_TX_INST_IDX() uint32 {
	return volatile.LoadUint32(&o.TX_INST_CFG0.Reg) & 0x7
}
func (o *BITSCRAMBLER_Type) SetTX_INST_CFG0_TX_INST_POS(value uint32) {
	volatile.StoreUint32(&o.TX_INST_CFG0.Reg, volatile.LoadUint32(&o.TX_INST_CFG0.Reg)&^(0x78)|value<<3)
}
func (o *BITSCRAMBLER_Type) GetTX_INST_CFG0_TX_INST_POS() uint32 {
	return (volatile.LoadUint32(&o.TX_INST_CFG0.Reg) & 0x78) >> 3
}

// BITSCRAMBLER.TX_INST_CFG1: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetTX_INST_CFG1(value uint32) {
	volatile.StoreUint32(&o.TX_INST_CFG1.Reg, value)
}
func (o *BITSCRAMBLER_Type) GetTX_INST_CFG1() uint32 {
	return volatile.LoadUint32(&o.TX_INST_CFG1.Reg)
}

// BITSCRAMBLER.RX_INST_CFG0: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetRX_INST_CFG0_RX_INST_IDX(value uint32) {
	volatile.StoreUint32(&o.RX_INST_CFG0.Reg, volatile.LoadUint32(&o.RX_INST_CFG0.Reg)&^(0x7)|value)
}
func (o *BITSCRAMBLER_Type) GetRX_INST_CFG0_RX_INST_IDX() uint32 {
	return volatile.LoadUint32(&o.RX_INST_CFG0.Reg) & 0x7
}
func (o *BITSCRAMBLER_Type) SetRX_INST_CFG0_RX_INST_POS(value uint32) {
	volatile.StoreUint32(&o.RX_INST_CFG0.Reg, volatile.LoadUint32(&o.RX_INST_CFG0.Reg)&^(0x78)|value<<3)
}
func (o *BITSCRAMBLER_Type) GetRX_INST_CFG0_RX_INST_POS() uint32 {
	return (volatile.LoadUint32(&o.RX_INST_CFG0.Reg) & 0x78) >> 3
}

// BITSCRAMBLER.RX_INST_CFG1: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetRX_INST_CFG1(value uint32) {
	volatile.StoreUint32(&o.RX_INST_CFG1.Reg, value)
}
func (o *BITSCRAMBLER_Type) GetRX_INST_CFG1() uint32 {
	return volatile.LoadUint32(&o.RX_INST_CFG1.Reg)
}

// BITSCRAMBLER.TX_LUT_CFG0: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetTX_LUT_CFG0_TX_LUT_IDX(value uint32) {
	volatile.StoreUint32(&o.TX_LUT_CFG0.Reg, volatile.LoadUint32(&o.TX_LUT_CFG0.Reg)&^(0x7ff)|value)
}
func (o *BITSCRAMBLER_Type) GetTX_LUT_CFG0_TX_LUT_IDX() uint32 {
	return volatile.LoadUint32(&o.TX_LUT_CFG0.Reg) & 0x7ff
}
func (o *BITSCRAMBLER_Type) SetTX_LUT_CFG0_TX_LUT_MODE(value uint32) {
	volatile.StoreUint32(&o.TX_LUT_CFG0.Reg, volatile.LoadUint32(&o.TX_LUT_CFG0.Reg)&^(0x1800)|value<<11)
}
func (o *BITSCRAMBLER_Type) GetTX_LUT_CFG0_TX_LUT_MODE() uint32 {
	return (volatile.LoadUint32(&o.TX_LUT_CFG0.Reg) & 0x1800) >> 11
}

// BITSCRAMBLER.TX_LUT_CFG1: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetTX_LUT_CFG1(value uint32) {
	volatile.StoreUint32(&o.TX_LUT_CFG1.Reg, value)
}
func (o *BITSCRAMBLER_Type) GetTX_LUT_CFG1() uint32 {
	return volatile.LoadUint32(&o.TX_LUT_CFG1.Reg)
}

// BITSCRAMBLER.RX_LUT_CFG0: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetRX_LUT_CFG0_RX_LUT_IDX(value uint32) {
	volatile.StoreUint32(&o.RX_LUT_CFG0.Reg, volatile.LoadUint32(&o.RX_LUT_CFG0.Reg)&^(0x7ff)|value)
}
func (o *BITSCRAMBLER_Type) GetRX_LUT_CFG0_RX_LUT_IDX() uint32 {
	return volatile.LoadUint32(&o.RX_LUT_CFG0.Reg) & 0x7ff
}
func (o *BITSCRAMBLER_Type) SetRX_LUT_CFG0_RX_LUT_MODE(value uint32) {
	volatile.StoreUint32(&o.RX_LUT_CFG0.Reg, volatile.LoadUint32(&o.RX_LUT_CFG0.Reg)&^(0x1800)|value<<11)
}
func (o *BITSCRAMBLER_Type) GetRX_LUT_CFG0_RX_LUT_MODE() uint32 {
	return (volatile.LoadUint32(&o.RX_LUT_CFG0.Reg) & 0x1800) >> 11
}

// BITSCRAMBLER.RX_LUT_CFG1: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetRX_LUT_CFG1(value uint32) {
	volatile.StoreUint32(&o.RX_LUT_CFG1.Reg, value)
}
func (o *BITSCRAMBLER_Type) GetRX_LUT_CFG1() uint32 {
	return volatile.LoadUint32(&o.RX_LUT_CFG1.Reg)
}

// BITSCRAMBLER.TX_TAILING_BITS: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetTX_TAILING_BITS(value uint32) {
	volatile.StoreUint32(&o.TX_TAILING_BITS.Reg, volatile.LoadUint32(&o.TX_TAILING_BITS.Reg)&^(0xffff)|value)
}
func (o *BITSCRAMBLER_Type) GetTX_TAILING_BITS() uint32 {
	return volatile.LoadUint32(&o.TX_TAILING_BITS.Reg) & 0xffff
}

// BITSCRAMBLER.RX_TAILING_BITS: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetRX_TAILING_BITS(value uint32) {
	volatile.StoreUint32(&o.RX_TAILING_BITS.Reg, volatile.LoadUint32(&o.RX_TAILING_BITS.Reg)&^(0xffff)|value)
}
func (o *BITSCRAMBLER_Type) GetRX_TAILING_BITS() uint32 {
	return volatile.LoadUint32(&o.RX_TAILING_BITS.Reg) & 0xffff
}

// BITSCRAMBLER.TX_CTRL: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetTX_CTRL_TX_ENA(value uint32) {
	volatile.StoreUint32(&o.TX_CTRL.Reg, volatile.LoadUint32(&o.TX_CTRL.Reg)&^(0x1)|value)
}
func (o *BITSCRAMBLER_Type) GetTX_CTRL_TX_ENA() uint32 {
	return volatile.LoadUint32(&o.TX_CTRL.Reg) & 0x1
}
func (o *BITSCRAMBLER_Type) SetTX_CTRL_TX_PAUSE(value uint32) {
	volatile.StoreUint32(&o.TX_CTRL.Reg, volatile.LoadUint32(&o.TX_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *BITSCRAMBLER_Type) GetTX_CTRL_TX_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.TX_CTRL.Reg) & 0x2) >> 1
}
func (o *BITSCRAMBLER_Type) SetTX_CTRL_TX_HALT(value uint32) {
	volatile.StoreUint32(&o.TX_CTRL.Reg, volatile.LoadUint32(&o.TX_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *BITSCRAMBLER_Type) GetTX_CTRL_TX_HALT() uint32 {
	return (volatile.LoadUint32(&o.TX_CTRL.Reg) & 0x4) >> 2
}
func (o *BITSCRAMBLER_Type) SetTX_CTRL_TX_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.TX_CTRL.Reg, volatile.LoadUint32(&o.TX_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *BITSCRAMBLER_Type) GetTX_CTRL_TX_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.TX_CTRL.Reg) & 0x8) >> 3
}
func (o *BITSCRAMBLER_Type) SetTX_CTRL_TX_COND_MODE(value uint32) {
	volatile.StoreUint32(&o.TX_CTRL.Reg, volatile.LoadUint32(&o.TX_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *BITSCRAMBLER_Type) GetTX_CTRL_TX_COND_MODE() uint32 {
	return (volatile.LoadUint32(&o.TX_CTRL.Reg) & 0x10) >> 4
}
func (o *BITSCRAMBLER_Type) SetTX_CTRL_TX_FETCH_MODE(value uint32) {
	volatile.StoreUint32(&o.TX_CTRL.Reg, volatile.LoadUint32(&o.TX_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *BITSCRAMBLER_Type) GetTX_CTRL_TX_FETCH_MODE() uint32 {
	return (volatile.LoadUint32(&o.TX_CTRL.Reg) & 0x20) >> 5
}
func (o *BITSCRAMBLER_Type) SetTX_CTRL_TX_HALT_MODE(value uint32) {
	volatile.StoreUint32(&o.TX_CTRL.Reg, volatile.LoadUint32(&o.TX_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *BITSCRAMBLER_Type) GetTX_CTRL_TX_HALT_MODE() uint32 {
	return (volatile.LoadUint32(&o.TX_CTRL.Reg) & 0x40) >> 6
}
func (o *BITSCRAMBLER_Type) SetTX_CTRL_TX_RD_DUMMY(value uint32) {
	volatile.StoreUint32(&o.TX_CTRL.Reg, volatile.LoadUint32(&o.TX_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *BITSCRAMBLER_Type) GetTX_CTRL_TX_RD_DUMMY() uint32 {
	return (volatile.LoadUint32(&o.TX_CTRL.Reg) & 0x80) >> 7
}
func (o *BITSCRAMBLER_Type) SetTX_CTRL_TX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.TX_CTRL.Reg, volatile.LoadUint32(&o.TX_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *BITSCRAMBLER_Type) GetTX_CTRL_TX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.TX_CTRL.Reg) & 0x100) >> 8
}

// BITSCRAMBLER.RX_CTRL: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetRX_CTRL_RX_ENA(value uint32) {
	volatile.StoreUint32(&o.RX_CTRL.Reg, volatile.LoadUint32(&o.RX_CTRL.Reg)&^(0x1)|value)
}
func (o *BITSCRAMBLER_Type) GetRX_CTRL_RX_ENA() uint32 {
	return volatile.LoadUint32(&o.RX_CTRL.Reg) & 0x1
}
func (o *BITSCRAMBLER_Type) SetRX_CTRL_RX_PAUSE(value uint32) {
	volatile.StoreUint32(&o.RX_CTRL.Reg, volatile.LoadUint32(&o.RX_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *BITSCRAMBLER_Type) GetRX_CTRL_RX_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.RX_CTRL.Reg) & 0x2) >> 1
}
func (o *BITSCRAMBLER_Type) SetRX_CTRL_RX_HALT(value uint32) {
	volatile.StoreUint32(&o.RX_CTRL.Reg, volatile.LoadUint32(&o.RX_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *BITSCRAMBLER_Type) GetRX_CTRL_RX_HALT() uint32 {
	return (volatile.LoadUint32(&o.RX_CTRL.Reg) & 0x4) >> 2
}
func (o *BITSCRAMBLER_Type) SetRX_CTRL_RX_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.RX_CTRL.Reg, volatile.LoadUint32(&o.RX_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *BITSCRAMBLER_Type) GetRX_CTRL_RX_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.RX_CTRL.Reg) & 0x8) >> 3
}
func (o *BITSCRAMBLER_Type) SetRX_CTRL_RX_COND_MODE(value uint32) {
	volatile.StoreUint32(&o.RX_CTRL.Reg, volatile.LoadUint32(&o.RX_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *BITSCRAMBLER_Type) GetRX_CTRL_RX_COND_MODE() uint32 {
	return (volatile.LoadUint32(&o.RX_CTRL.Reg) & 0x10) >> 4
}
func (o *BITSCRAMBLER_Type) SetRX_CTRL_RX_FETCH_MODE(value uint32) {
	volatile.StoreUint32(&o.RX_CTRL.Reg, volatile.LoadUint32(&o.RX_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *BITSCRAMBLER_Type) GetRX_CTRL_RX_FETCH_MODE() uint32 {
	return (volatile.LoadUint32(&o.RX_CTRL.Reg) & 0x20) >> 5
}
func (o *BITSCRAMBLER_Type) SetRX_CTRL_RX_HALT_MODE(value uint32) {
	volatile.StoreUint32(&o.RX_CTRL.Reg, volatile.LoadUint32(&o.RX_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *BITSCRAMBLER_Type) GetRX_CTRL_RX_HALT_MODE() uint32 {
	return (volatile.LoadUint32(&o.RX_CTRL.Reg) & 0x40) >> 6
}
func (o *BITSCRAMBLER_Type) SetRX_CTRL_RX_RD_DUMMY(value uint32) {
	volatile.StoreUint32(&o.RX_CTRL.Reg, volatile.LoadUint32(&o.RX_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *BITSCRAMBLER_Type) GetRX_CTRL_RX_RD_DUMMY() uint32 {
	return (volatile.LoadUint32(&o.RX_CTRL.Reg) & 0x80) >> 7
}
func (o *BITSCRAMBLER_Type) SetRX_CTRL_RX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.RX_CTRL.Reg, volatile.LoadUint32(&o.RX_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *BITSCRAMBLER_Type) GetRX_CTRL_RX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.RX_CTRL.Reg) & 0x100) >> 8
}

// BITSCRAMBLER.TX_STATE: Status registers
func (o *BITSCRAMBLER_Type) SetTX_STATE_TX_IN_IDLE(value uint32) {
	volatile.StoreUint32(&o.TX_STATE.Reg, volatile.LoadUint32(&o.TX_STATE.Reg)&^(0x1)|value)
}
func (o *BITSCRAMBLER_Type) GetTX_STATE_TX_IN_IDLE() uint32 {
	return volatile.LoadUint32(&o.TX_STATE.Reg) & 0x1
}
func (o *BITSCRAMBLER_Type) SetTX_STATE_TX_IN_RUN(value uint32) {
	volatile.StoreUint32(&o.TX_STATE.Reg, volatile.LoadUint32(&o.TX_STATE.Reg)&^(0x2)|value<<1)
}
func (o *BITSCRAMBLER_Type) GetTX_STATE_TX_IN_RUN() uint32 {
	return (volatile.LoadUint32(&o.TX_STATE.Reg) & 0x2) >> 1
}
func (o *BITSCRAMBLER_Type) SetTX_STATE_TX_IN_WAIT(value uint32) {
	volatile.StoreUint32(&o.TX_STATE.Reg, volatile.LoadUint32(&o.TX_STATE.Reg)&^(0x4)|value<<2)
}
func (o *BITSCRAMBLER_Type) GetTX_STATE_TX_IN_WAIT() uint32 {
	return (volatile.LoadUint32(&o.TX_STATE.Reg) & 0x4) >> 2
}
func (o *BITSCRAMBLER_Type) SetTX_STATE_TX_IN_PAUSE(value uint32) {
	volatile.StoreUint32(&o.TX_STATE.Reg, volatile.LoadUint32(&o.TX_STATE.Reg)&^(0x8)|value<<3)
}
func (o *BITSCRAMBLER_Type) GetTX_STATE_TX_IN_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.TX_STATE.Reg) & 0x8) >> 3
}
func (o *BITSCRAMBLER_Type) SetTX_STATE_TX_FIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.TX_STATE.Reg, volatile.LoadUint32(&o.TX_STATE.Reg)&^(0x10)|value<<4)
}
func (o *BITSCRAMBLER_Type) GetTX_STATE_TX_FIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.TX_STATE.Reg) & 0x10) >> 4
}
func (o *BITSCRAMBLER_Type) SetTX_STATE_TX_EOF_GET_CNT(value uint32) {
	volatile.StoreUint32(&o.TX_STATE.Reg, volatile.LoadUint32(&o.TX_STATE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *BITSCRAMBLER_Type) GetTX_STATE_TX_EOF_GET_CNT() uint32 {
	return (volatile.LoadUint32(&o.TX_STATE.Reg) & 0x3fff0000) >> 16
}
func (o *BITSCRAMBLER_Type) SetTX_STATE_TX_EOF_OVERLOAD(value uint32) {
	volatile.StoreUint32(&o.TX_STATE.Reg, volatile.LoadUint32(&o.TX_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *BITSCRAMBLER_Type) GetTX_STATE_TX_EOF_OVERLOAD() uint32 {
	return (volatile.LoadUint32(&o.TX_STATE.Reg) & 0x40000000) >> 30
}
func (o *BITSCRAMBLER_Type) SetTX_STATE_TX_EOF_TRACE_CLR(value uint32) {
	volatile.StoreUint32(&o.TX_STATE.Reg, volatile.LoadUint32(&o.TX_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *BITSCRAMBLER_Type) GetTX_STATE_TX_EOF_TRACE_CLR() uint32 {
	return (volatile.LoadUint32(&o.TX_STATE.Reg) & 0x80000000) >> 31
}

// BITSCRAMBLER.RX_STATE: Status registers
func (o *BITSCRAMBLER_Type) SetRX_STATE_RX_IN_IDLE(value uint32) {
	volatile.StoreUint32(&o.RX_STATE.Reg, volatile.LoadUint32(&o.RX_STATE.Reg)&^(0x1)|value)
}
func (o *BITSCRAMBLER_Type) GetRX_STATE_RX_IN_IDLE() uint32 {
	return volatile.LoadUint32(&o.RX_STATE.Reg) & 0x1
}
func (o *BITSCRAMBLER_Type) SetRX_STATE_RX_IN_RUN(value uint32) {
	volatile.StoreUint32(&o.RX_STATE.Reg, volatile.LoadUint32(&o.RX_STATE.Reg)&^(0x2)|value<<1)
}
func (o *BITSCRAMBLER_Type) GetRX_STATE_RX_IN_RUN() uint32 {
	return (volatile.LoadUint32(&o.RX_STATE.Reg) & 0x2) >> 1
}
func (o *BITSCRAMBLER_Type) SetRX_STATE_RX_IN_WAIT(value uint32) {
	volatile.StoreUint32(&o.RX_STATE.Reg, volatile.LoadUint32(&o.RX_STATE.Reg)&^(0x4)|value<<2)
}
func (o *BITSCRAMBLER_Type) GetRX_STATE_RX_IN_WAIT() uint32 {
	return (volatile.LoadUint32(&o.RX_STATE.Reg) & 0x4) >> 2
}
func (o *BITSCRAMBLER_Type) SetRX_STATE_RX_IN_PAUSE(value uint32) {
	volatile.StoreUint32(&o.RX_STATE.Reg, volatile.LoadUint32(&o.RX_STATE.Reg)&^(0x8)|value<<3)
}
func (o *BITSCRAMBLER_Type) GetRX_STATE_RX_IN_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.RX_STATE.Reg) & 0x8) >> 3
}
func (o *BITSCRAMBLER_Type) SetRX_STATE_RX_FIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.RX_STATE.Reg, volatile.LoadUint32(&o.RX_STATE.Reg)&^(0x10)|value<<4)
}
func (o *BITSCRAMBLER_Type) GetRX_STATE_RX_FIFO_FULL() uint32 {
	return (volatile.LoadUint32(&o.RX_STATE.Reg) & 0x10) >> 4
}
func (o *BITSCRAMBLER_Type) SetRX_STATE_RX_EOF_GET_CNT(value uint32) {
	volatile.StoreUint32(&o.RX_STATE.Reg, volatile.LoadUint32(&o.RX_STATE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *BITSCRAMBLER_Type) GetRX_STATE_RX_EOF_GET_CNT() uint32 {
	return (volatile.LoadUint32(&o.RX_STATE.Reg) & 0x3fff0000) >> 16
}
func (o *BITSCRAMBLER_Type) SetRX_STATE_RX_EOF_OVERLOAD(value uint32) {
	volatile.StoreUint32(&o.RX_STATE.Reg, volatile.LoadUint32(&o.RX_STATE.Reg)&^(0x40000000)|value<<30)
}
func (o *BITSCRAMBLER_Type) GetRX_STATE_RX_EOF_OVERLOAD() uint32 {
	return (volatile.LoadUint32(&o.RX_STATE.Reg) & 0x40000000) >> 30
}
func (o *BITSCRAMBLER_Type) SetRX_STATE_RX_EOF_TRACE_CLR(value uint32) {
	volatile.StoreUint32(&o.RX_STATE.Reg, volatile.LoadUint32(&o.RX_STATE.Reg)&^(0x80000000)|value<<31)
}
func (o *BITSCRAMBLER_Type) GetRX_STATE_RX_EOF_TRACE_CLR() uint32 {
	return (volatile.LoadUint32(&o.RX_STATE.Reg) & 0x80000000) >> 31
}

// BITSCRAMBLER.SYS: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetSYS_LOOP_MODE(value uint32) {
	volatile.StoreUint32(&o.SYS.Reg, volatile.LoadUint32(&o.SYS.Reg)&^(0x1)|value)
}
func (o *BITSCRAMBLER_Type) GetSYS_LOOP_MODE() uint32 {
	return volatile.LoadUint32(&o.SYS.Reg) & 0x1
}
func (o *BITSCRAMBLER_Type) SetSYS_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SYS.Reg, volatile.LoadUint32(&o.SYS.Reg)&^(0x80000000)|value<<31)
}
func (o *BITSCRAMBLER_Type) GetSYS_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SYS.Reg) & 0x80000000) >> 31
}

// BITSCRAMBLER.VERSION: Control and configuration registers
func (o *BITSCRAMBLER_Type) SetVERSION_BITSCRAMBLER_VER(value uint32) {
	volatile.StoreUint32(&o.VERSION.Reg, volatile.LoadUint32(&o.VERSION.Reg)&^(0xfffffff)|value)
}
func (o *BITSCRAMBLER_Type) GetVERSION_BITSCRAMBLER_VER() uint32 {
	return volatile.LoadUint32(&o.VERSION.Reg) & 0xfffffff
}

// CACHE Peripheral
type CACHE_Type struct {
	L1_ICACHE_CTRL                  volatile.Register32 // 0x0
	L1_DCACHE_CTRL                  volatile.Register32 // 0x4
	L1_BYPASS_CACHE_CONF            volatile.Register32 // 0x8
	L1_CACHE_ATOMIC_CONF            volatile.Register32 // 0xC
	L1_ICACHE_CACHESIZE_CONF        volatile.Register32 // 0x10
	L1_ICACHE_BLOCKSIZE_CONF        volatile.Register32 // 0x14
	L1_DCACHE_CACHESIZE_CONF        volatile.Register32 // 0x18
	L1_DCACHE_BLOCKSIZE_CONF        volatile.Register32 // 0x1C
	L1_CACHE_WRAP_AROUND_CTRL       volatile.Register32 // 0x20
	L1_CACHE_TAG_MEM_POWER_CTRL     volatile.Register32 // 0x24
	L1_CACHE_DATA_MEM_POWER_CTRL    volatile.Register32 // 0x28
	L1_CACHE_FREEZE_CTRL            volatile.Register32 // 0x2C
	L1_CACHE_DATA_MEM_ACS_CONF      volatile.Register32 // 0x30
	L1_CACHE_TAG_MEM_ACS_CONF       volatile.Register32 // 0x34
	L1_ICACHE0_PRELOCK_CONF         volatile.Register32 // 0x38
	L1_ICACHE0_PRELOCK_SCT0_ADDR    volatile.Register32 // 0x3C
	L1_ICACHE0_PRELOCK_SCT1_ADDR    volatile.Register32 // 0x40
	L1_ICACHE0_PRELOCK_SCT_SIZE     volatile.Register32 // 0x44
	L1_ICACHE1_PRELOCK_CONF         volatile.Register32 // 0x48
	L1_ICACHE1_PRELOCK_SCT0_ADDR    volatile.Register32 // 0x4C
	L1_ICACHE1_PRELOCK_SCT1_ADDR    volatile.Register32 // 0x50
	L1_ICACHE1_PRELOCK_SCT_SIZE     volatile.Register32 // 0x54
	L1_ICACHE2_PRELOCK_CONF         volatile.Register32 // 0x58
	L1_ICACHE2_PRELOCK_SCT0_ADDR    volatile.Register32 // 0x5C
	L1_ICACHE2_PRELOCK_SCT1_ADDR    volatile.Register32 // 0x60
	L1_ICACHE2_PRELOCK_SCT_SIZE     volatile.Register32 // 0x64
	L1_ICACHE3_PRELOCK_CONF         volatile.Register32 // 0x68
	L1_ICACHE3_PRELOCK_SCT0_ADDR    volatile.Register32 // 0x6C
	L1_ICACHE3_PRELOCK_SCT1_ADDR    volatile.Register32 // 0x70
	L1_ICACHE3_PRELOCK_SCT_SIZE     volatile.Register32 // 0x74
	L1_DCACHE_PRELOCK_CONF          volatile.Register32 // 0x78
	L1_DCACHE_PRELOCK_SCT0_ADDR     volatile.Register32 // 0x7C
	L1_DCACHE_PRELOCK_SCT1_ADDR     volatile.Register32 // 0x80
	L1_DCACHE_PRELOCK_SCT_SIZE      volatile.Register32 // 0x84
	LOCK_CTRL                       volatile.Register32 // 0x88
	LOCK_MAP                        volatile.Register32 // 0x8C
	LOCK_ADDR                       volatile.Register32 // 0x90
	LOCK_SIZE                       volatile.Register32 // 0x94
	SYNC_CTRL                       volatile.Register32 // 0x98
	SYNC_MAP                        volatile.Register32 // 0x9C
	SYNC_ADDR                       volatile.Register32 // 0xA0
	SYNC_SIZE                       volatile.Register32 // 0xA4
	L1_ICACHE0_PRELOAD_CTRL         volatile.Register32 // 0xA8
	L1_ICACHE0_PRELOAD_ADDR         volatile.Register32 // 0xAC
	L1_ICACHE0_PRELOAD_SIZE         volatile.Register32 // 0xB0
	L1_ICACHE1_PRELOAD_CTRL         volatile.Register32 // 0xB4
	L1_ICACHE1_PRELOAD_ADDR         volatile.Register32 // 0xB8
	L1_ICACHE1_PRELOAD_SIZE         volatile.Register32 // 0xBC
	L1_ICACHE2_PRELOAD_CTRL         volatile.Register32 // 0xC0
	L1_ICACHE2_PRELOAD_ADDR         volatile.Register32 // 0xC4
	L1_ICACHE2_PRELOAD_SIZE         volatile.Register32 // 0xC8
	L1_ICACHE3_PRELOAD_CTRL         volatile.Register32 // 0xCC
	L1_ICACHE3_PRELOAD_ADDR         volatile.Register32 // 0xD0
	L1_ICACHE3_PRELOAD_SIZE         volatile.Register32 // 0xD4
	L1_DCACHE_PRELOAD_CTRL          volatile.Register32 // 0xD8
	L1_DCACHE_PRELOAD_ADDR          volatile.Register32 // 0xDC
	L1_DCACHE_PRELOAD_SIZE          volatile.Register32 // 0xE0
	L1_ICACHE0_AUTOLOAD_CTRL        volatile.Register32 // 0xE4
	L1_ICACHE0_AUTOLOAD_SCT0_ADDR   volatile.Register32 // 0xE8
	L1_ICACHE0_AUTOLOAD_SCT0_SIZE   volatile.Register32 // 0xEC
	L1_ICACHE0_AUTOLOAD_SCT1_ADDR   volatile.Register32 // 0xF0
	L1_ICACHE0_AUTOLOAD_SCT1_SIZE   volatile.Register32 // 0xF4
	L1_ICACHE1_AUTOLOAD_CTRL        volatile.Register32 // 0xF8
	L1_ICACHE1_AUTOLOAD_SCT0_ADDR   volatile.Register32 // 0xFC
	L1_ICACHE1_AUTOLOAD_SCT0_SIZE   volatile.Register32 // 0x100
	L1_ICACHE1_AUTOLOAD_SCT1_ADDR   volatile.Register32 // 0x104
	L1_ICACHE1_AUTOLOAD_SCT1_SIZE   volatile.Register32 // 0x108
	L1_ICACHE2_AUTOLOAD_CTRL        volatile.Register32 // 0x10C
	L1_ICACHE2_AUTOLOAD_SCT0_ADDR   volatile.Register32 // 0x110
	L1_ICACHE2_AUTOLOAD_SCT0_SIZE   volatile.Register32 // 0x114
	L1_ICACHE2_AUTOLOAD_SCT1_ADDR   volatile.Register32 // 0x118
	L1_ICACHE2_AUTOLOAD_SCT1_SIZE   volatile.Register32 // 0x11C
	L1_ICACHE3_AUTOLOAD_CTRL        volatile.Register32 // 0x120
	L1_ICACHE3_AUTOLOAD_SCT0_ADDR   volatile.Register32 // 0x124
	L1_ICACHE3_AUTOLOAD_SCT0_SIZE   volatile.Register32 // 0x128
	L1_ICACHE3_AUTOLOAD_SCT1_ADDR   volatile.Register32 // 0x12C
	L1_ICACHE3_AUTOLOAD_SCT1_SIZE   volatile.Register32 // 0x130
	L1_DCACHE_AUTOLOAD_CTRL         volatile.Register32 // 0x134
	L1_DCACHE_AUTOLOAD_SCT0_ADDR    volatile.Register32 // 0x138
	L1_DCACHE_AUTOLOAD_SCT0_SIZE    volatile.Register32 // 0x13C
	L1_DCACHE_AUTOLOAD_SCT1_ADDR    volatile.Register32 // 0x140
	L1_DCACHE_AUTOLOAD_SCT1_SIZE    volatile.Register32 // 0x144
	L1_DCACHE_AUTOLOAD_SCT2_ADDR    volatile.Register32 // 0x148
	L1_DCACHE_AUTOLOAD_SCT2_SIZE    volatile.Register32 // 0x14C
	L1_DCACHE_AUTOLOAD_SCT3_ADDR    volatile.Register32 // 0x150
	L1_DCACHE_AUTOLOAD_SCT3_SIZE    volatile.Register32 // 0x154
	L1_CACHE_ACS_CNT_INT_ENA        volatile.Register32 // 0x158
	L1_CACHE_ACS_CNT_INT_CLR        volatile.Register32 // 0x15C
	L1_CACHE_ACS_CNT_INT_RAW        volatile.Register32 // 0x160
	L1_CACHE_ACS_CNT_INT_ST         volatile.Register32 // 0x164
	L1_CACHE_ACS_FAIL_CTRL          volatile.Register32 // 0x168
	L1_CACHE_ACS_FAIL_INT_ENA       volatile.Register32 // 0x16C
	L1_CACHE_ACS_FAIL_INT_CLR       volatile.Register32 // 0x170
	L1_CACHE_ACS_FAIL_INT_RAW       volatile.Register32 // 0x174
	L1_CACHE_ACS_FAIL_INT_ST        volatile.Register32 // 0x178
	L1_CACHE_ACS_CNT_CTRL           volatile.Register32 // 0x17C
	L1_IBUS0_ACS_HIT_CNT            volatile.Register32 // 0x180
	L1_IBUS0_ACS_MISS_CNT           volatile.Register32 // 0x184
	L1_IBUS0_ACS_CONFLICT_CNT       volatile.Register32 // 0x188
	L1_IBUS0_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x18C
	L1_IBUS1_ACS_HIT_CNT            volatile.Register32 // 0x190
	L1_IBUS1_ACS_MISS_CNT           volatile.Register32 // 0x194
	L1_IBUS1_ACS_CONFLICT_CNT       volatile.Register32 // 0x198
	L1_IBUS1_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x19C
	L1_IBUS2_ACS_HIT_CNT            volatile.Register32 // 0x1A0
	L1_IBUS2_ACS_MISS_CNT           volatile.Register32 // 0x1A4
	L1_IBUS2_ACS_CONFLICT_CNT       volatile.Register32 // 0x1A8
	L1_IBUS2_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x1AC
	L1_IBUS3_ACS_HIT_CNT            volatile.Register32 // 0x1B0
	L1_IBUS3_ACS_MISS_CNT           volatile.Register32 // 0x1B4
	L1_IBUS3_ACS_CONFLICT_CNT       volatile.Register32 // 0x1B8
	L1_IBUS3_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x1BC
	L1_DBUS0_ACS_HIT_CNT            volatile.Register32 // 0x1C0
	L1_DBUS0_ACS_MISS_CNT           volatile.Register32 // 0x1C4
	L1_DBUS0_ACS_CONFLICT_CNT       volatile.Register32 // 0x1C8
	L1_DBUS0_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x1CC
	L1_DBUS0_ACS_NXTLVL_WR_CNT      volatile.Register32 // 0x1D0
	L1_DBUS1_ACS_HIT_CNT            volatile.Register32 // 0x1D4
	L1_DBUS1_ACS_MISS_CNT           volatile.Register32 // 0x1D8
	L1_DBUS1_ACS_CONFLICT_CNT       volatile.Register32 // 0x1DC
	L1_DBUS1_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x1E0
	L1_DBUS1_ACS_NXTLVL_WR_CNT      volatile.Register32 // 0x1E4
	L1_DBUS2_ACS_HIT_CNT            volatile.Register32 // 0x1E8
	L1_DBUS2_ACS_MISS_CNT           volatile.Register32 // 0x1EC
	L1_DBUS2_ACS_CONFLICT_CNT       volatile.Register32 // 0x1F0
	L1_DBUS2_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x1F4
	L1_DBUS2_ACS_NXTLVL_WR_CNT      volatile.Register32 // 0x1F8
	L1_DBUS3_ACS_HIT_CNT            volatile.Register32 // 0x1FC
	L1_DBUS3_ACS_MISS_CNT           volatile.Register32 // 0x200
	L1_DBUS3_ACS_CONFLICT_CNT       volatile.Register32 // 0x204
	L1_DBUS3_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x208
	L1_DBUS3_ACS_NXTLVL_WR_CNT      volatile.Register32 // 0x20C
	L1_ICACHE0_ACS_FAIL_ID_ATTR     volatile.Register32 // 0x210
	L1_ICACHE0_ACS_FAIL_ADDR        volatile.Register32 // 0x214
	L1_ICACHE1_ACS_FAIL_ID_ATTR     volatile.Register32 // 0x218
	L1_ICACHE1_ACS_FAIL_ADDR        volatile.Register32 // 0x21C
	L1_ICACHE2_ACS_FAIL_ID_ATTR     volatile.Register32 // 0x220
	L1_ICACHE2_ACS_FAIL_ADDR        volatile.Register32 // 0x224
	L1_ICACHE3_ACS_FAIL_ID_ATTR     volatile.Register32 // 0x228
	L1_ICACHE3_ACS_FAIL_ADDR        volatile.Register32 // 0x22C
	L1_DCACHE_ACS_FAIL_ID_ATTR      volatile.Register32 // 0x230
	L1_DCACHE_ACS_FAIL_ADDR         volatile.Register32 // 0x234
	SYNC_L1_CACHE_PRELOAD_INT_ENA   volatile.Register32 // 0x238
	SYNC_L1_CACHE_PRELOAD_INT_CLR   volatile.Register32 // 0x23C
	SYNC_L1_CACHE_PRELOAD_INT_RAW   volatile.Register32 // 0x240
	SYNC_L1_CACHE_PRELOAD_INT_ST    volatile.Register32 // 0x244
	SYNC_L1_CACHE_PRELOAD_EXCEPTION volatile.Register32 // 0x248
	L1_CACHE_SYNC_RST_CTRL          volatile.Register32 // 0x24C
	L1_CACHE_PRELOAD_RST_CTRL       volatile.Register32 // 0x250
	L1_CACHE_AUTOLOAD_BUF_CLR_CTRL  volatile.Register32 // 0x254
	L1_UNALLOCATE_BUFFER_CLEAR      volatile.Register32 // 0x258
	L1_CACHE_OBJECT_CTRL            volatile.Register32 // 0x25C
	L1_CACHE_WAY_OBJECT             volatile.Register32 // 0x260
	L1_CACHE_VADDR                  volatile.Register32 // 0x264
	L1_CACHE_DEBUG_BUS              volatile.Register32 // 0x268
	LEVEL_SPLIT0                    volatile.Register32 // 0x26C
	L2_CACHE_CTRL                   volatile.Register32 // 0x270
	L2_BYPASS_CACHE_CONF            volatile.Register32 // 0x274
	L2_CACHE_CACHESIZE_CONF         volatile.Register32 // 0x278
	L2_CACHE_BLOCKSIZE_CONF         volatile.Register32 // 0x27C
	L2_CACHE_WRAP_AROUND_CTRL       volatile.Register32 // 0x280
	L2_CACHE_TAG_MEM_POWER_CTRL     volatile.Register32 // 0x284
	L2_CACHE_DATA_MEM_POWER_CTRL    volatile.Register32 // 0x288
	L2_CACHE_FREEZE_CTRL            volatile.Register32 // 0x28C
	L2_CACHE_DATA_MEM_ACS_CONF      volatile.Register32 // 0x290
	L2_CACHE_TAG_MEM_ACS_CONF       volatile.Register32 // 0x294
	L2_CACHE_PRELOCK_CONF           volatile.Register32 // 0x298
	L2_CACHE_PRELOCK_SCT0_ADDR      volatile.Register32 // 0x29C
	L2_CACHE_PRELOCK_SCT1_ADDR      volatile.Register32 // 0x2A0
	L2_CACHE_PRELOCK_SCT_SIZE       volatile.Register32 // 0x2A4
	L2_CACHE_PRELOAD_CTRL           volatile.Register32 // 0x2A8
	L2_CACHE_PRELOAD_ADDR           volatile.Register32 // 0x2AC
	L2_CACHE_PRELOAD_SIZE           volatile.Register32 // 0x2B0
	L2_CACHE_AUTOLOAD_CTRL          volatile.Register32 // 0x2B4
	L2_CACHE_AUTOLOAD_SCT0_ADDR     volatile.Register32 // 0x2B8
	L2_CACHE_AUTOLOAD_SCT0_SIZE     volatile.Register32 // 0x2BC
	L2_CACHE_AUTOLOAD_SCT1_ADDR     volatile.Register32 // 0x2C0
	L2_CACHE_AUTOLOAD_SCT1_SIZE     volatile.Register32 // 0x2C4
	L2_CACHE_AUTOLOAD_SCT2_ADDR     volatile.Register32 // 0x2C8
	L2_CACHE_AUTOLOAD_SCT2_SIZE     volatile.Register32 // 0x2CC
	L2_CACHE_AUTOLOAD_SCT3_ADDR     volatile.Register32 // 0x2D0
	L2_CACHE_AUTOLOAD_SCT3_SIZE     volatile.Register32 // 0x2D4
	L2_CACHE_ACS_CNT_INT_ENA        volatile.Register32 // 0x2D8
	L2_CACHE_ACS_CNT_INT_CLR        volatile.Register32 // 0x2DC
	L2_CACHE_ACS_CNT_INT_RAW        volatile.Register32 // 0x2E0
	L2_CACHE_ACS_CNT_INT_ST         volatile.Register32 // 0x2E4
	L2_CACHE_ACS_FAIL_CTRL          volatile.Register32 // 0x2E8
	L2_CACHE_ACS_FAIL_INT_ENA       volatile.Register32 // 0x2EC
	L2_CACHE_ACS_FAIL_INT_CLR       volatile.Register32 // 0x2F0
	L2_CACHE_ACS_FAIL_INT_RAW       volatile.Register32 // 0x2F4
	L2_CACHE_ACS_FAIL_INT_ST        volatile.Register32 // 0x2F8
	L2_CACHE_ACS_CNT_CTRL           volatile.Register32 // 0x2FC
	L2_IBUS0_ACS_HIT_CNT            volatile.Register32 // 0x300
	L2_IBUS0_ACS_MISS_CNT           volatile.Register32 // 0x304
	L2_IBUS0_ACS_CONFLICT_CNT       volatile.Register32 // 0x308
	L2_IBUS0_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x30C
	L2_IBUS1_ACS_HIT_CNT            volatile.Register32 // 0x310
	L2_IBUS1_ACS_MISS_CNT           volatile.Register32 // 0x314
	L2_IBUS1_ACS_CONFLICT_CNT       volatile.Register32 // 0x318
	L2_IBUS1_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x31C
	L2_IBUS2_ACS_HIT_CNT            volatile.Register32 // 0x320
	L2_IBUS2_ACS_MISS_CNT           volatile.Register32 // 0x324
	L2_IBUS2_ACS_CONFLICT_CNT       volatile.Register32 // 0x328
	L2_IBUS2_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x32C
	L2_IBUS3_ACS_HIT_CNT            volatile.Register32 // 0x330
	L2_IBUS3_ACS_MISS_CNT           volatile.Register32 // 0x334
	L2_IBUS3_ACS_CONFLICT_CNT       volatile.Register32 // 0x338
	L2_IBUS3_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x33C
	L2_DBUS0_ACS_HIT_CNT            volatile.Register32 // 0x340
	L2_DBUS0_ACS_MISS_CNT           volatile.Register32 // 0x344
	L2_DBUS0_ACS_CONFLICT_CNT       volatile.Register32 // 0x348
	L2_DBUS0_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x34C
	L2_DBUS0_ACS_NXTLVL_WR_CNT      volatile.Register32 // 0x350
	L2_DBUS1_ACS_HIT_CNT            volatile.Register32 // 0x354
	L2_DBUS1_ACS_MISS_CNT           volatile.Register32 // 0x358
	L2_DBUS1_ACS_CONFLICT_CNT       volatile.Register32 // 0x35C
	L2_DBUS1_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x360
	L2_DBUS1_ACS_NXTLVL_WR_CNT      volatile.Register32 // 0x364
	L2_DBUS2_ACS_HIT_CNT            volatile.Register32 // 0x368
	L2_DBUS2_ACS_MISS_CNT           volatile.Register32 // 0x36C
	L2_DBUS2_ACS_CONFLICT_CNT       volatile.Register32 // 0x370
	L2_DBUS2_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x374
	L2_DBUS2_ACS_NXTLVL_WR_CNT      volatile.Register32 // 0x378
	L2_DBUS3_ACS_HIT_CNT            volatile.Register32 // 0x37C
	L2_DBUS3_ACS_MISS_CNT           volatile.Register32 // 0x380
	L2_DBUS3_ACS_CONFLICT_CNT       volatile.Register32 // 0x384
	L2_DBUS3_ACS_NXTLVL_RD_CNT      volatile.Register32 // 0x388
	L2_DBUS3_ACS_NXTLVL_WR_CNT      volatile.Register32 // 0x38C
	L2_CACHE_ACS_FAIL_ID_ATTR       volatile.Register32 // 0x390
	L2_CACHE_ACS_FAIL_ADDR          volatile.Register32 // 0x394
	L2_CACHE_SYNC_PRELOAD_INT_ENA   volatile.Register32 // 0x398
	L2_CACHE_SYNC_PRELOAD_INT_CLR   volatile.Register32 // 0x39C
	L2_CACHE_SYNC_PRELOAD_INT_RAW   volatile.Register32 // 0x3A0
	L2_CACHE_SYNC_PRELOAD_INT_ST    volatile.Register32 // 0x3A4
	L2_CACHE_SYNC_PRELOAD_EXCEPTION volatile.Register32 // 0x3A8
	L2_CACHE_SYNC_RST_CTRL          volatile.Register32 // 0x3AC
	L2_CACHE_PRELOAD_RST_CTRL       volatile.Register32 // 0x3B0
	L2_CACHE_AUTOLOAD_BUF_CLR_CTRL  volatile.Register32 // 0x3B4
	L2_UNALLOCATE_BUFFER_CLEAR      volatile.Register32 // 0x3B8
	L2_CACHE_ACCESS_ATTR_CTRL       volatile.Register32 // 0x3BC
	L2_CACHE_OBJECT_CTRL            volatile.Register32 // 0x3C0
	L2_CACHE_WAY_OBJECT             volatile.Register32 // 0x3C4
	L2_CACHE_VADDR                  volatile.Register32 // 0x3C8
	L2_CACHE_DEBUG_BUS              volatile.Register32 // 0x3CC
	LEVEL_SPLIT1                    volatile.Register32 // 0x3D0
	CLOCK_GATE                      volatile.Register32 // 0x3D4
	REDUNDANCY_SIG0                 volatile.Register32 // 0x3D8
	REDUNDANCY_SIG1                 volatile.Register32 // 0x3DC
	REDUNDANCY_SIG2                 volatile.Register32 // 0x3E0
	REDUNDANCY_SIG3                 volatile.Register32 // 0x3E4
	REDUNDANCY_SIG4                 volatile.Register32 // 0x3E8
	_                               [16]byte
	DATE                            volatile.Register32 // 0x3FC
}

// CACHE.L1_ICACHE_CTRL: L1 instruction Cache(L1-ICache) control register
func (o *CACHE_Type) SetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS0(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS0() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS1(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS1() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS2(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS2() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS3(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS3() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_ICACHE_CTRL_L1_ICACHE_UNDEF_OP(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg)&^(0xff00)|value<<8)
}
func (o *CACHE_Type) GetL1_ICACHE_CTRL_L1_ICACHE_UNDEF_OP() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg) & 0xff00) >> 8
}

// CACHE.L1_DCACHE_CTRL: L1 data Cache(L1-DCache) control register
func (o *CACHE_Type) SetL1_DCACHE_CTRL_L1_DCACHE_SHUT_DBUS0(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_CTRL_L1_DCACHE_SHUT_DBUS0() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_DCACHE_CTRL_L1_DCACHE_SHUT_DBUS1(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_DCACHE_CTRL_L1_DCACHE_SHUT_DBUS1() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_DCACHE_CTRL_L1_DCACHE_SHUT_DBUS2(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_DCACHE_CTRL_L1_DCACHE_SHUT_DBUS2() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_DCACHE_CTRL_L1_DCACHE_SHUT_DBUS3(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_DCACHE_CTRL_L1_DCACHE_SHUT_DBUS3() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_DCACHE_CTRL_L1_DCACHE_SHUT_DMA(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_DCACHE_CTRL_L1_DCACHE_SHUT_DMA() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_DCACHE_CTRL_L1_DCACHE_UNDEF_OP(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg)&^(0xff00)|value<<8)
}
func (o *CACHE_Type) GetL1_DCACHE_CTRL_L1_DCACHE_UNDEF_OP() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CTRL.Reg) & 0xff00) >> 8
}

// CACHE.L1_BYPASS_CACHE_CONF: Bypass Cache configure register
func (o *CACHE_Type) SetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE2_EN(value uint32) {
	volatile.StoreUint32(&o.L1_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE2_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE3_EN(value uint32) {
	volatile.StoreUint32(&o.L1_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE3_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_BYPASS_CACHE_CONF_BYPASS_L1_DCACHE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_BYPASS_CACHE_CONF_BYPASS_L1_DCACHE_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg) & 0x10) >> 4
}

// CACHE.L1_CACHE_ATOMIC_CONF: L1 Cache atomic feature configure register
func (o *CACHE_Type) SetL1_CACHE_ATOMIC_CONF_L1_DCACHE_ATOMIC_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ATOMIC_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_ATOMIC_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ATOMIC_CONF_L1_DCACHE_ATOMIC_EN() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ATOMIC_CONF.Reg) & 0x1
}

// CACHE.L1_ICACHE_CACHESIZE_CONF: L1 instruction Cache CacheSize mode configure register
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_256(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_256() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_512(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_512() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_1K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_1K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_2K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_2K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_4K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_4K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_8K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_8K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_16K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_16K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_32K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_32K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x80) >> 7
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_64K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_64K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_128K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_128K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_256K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_256K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_512K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_512K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_1024K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_1024K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x1000) >> 12
}

// CACHE.L1_ICACHE_BLOCKSIZE_CONF: L1 instruction Cache BlockSize mode configure register
func (o *CACHE_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_8(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_8() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_16(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_16() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_32(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_32() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_64(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_64() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_128(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_128() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_256(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_256() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x20) >> 5
}

// CACHE.L1_DCACHE_CACHESIZE_CONF: L1 data Cache CacheSize mode configure register
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_256(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_256() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_512(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_512() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_1K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_1K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_2K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_2K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_4K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_4K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_8K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_8K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_16K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_16K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_32K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_32K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x80) >> 7
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_64K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_64K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_128K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_128K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_256K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_256K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_512K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_512K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_1024K(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL1_DCACHE_CACHESIZE_CONF_L1_DCACHE_CACHESIZE_1024K() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_CACHESIZE_CONF.Reg) & 0x1000) >> 12
}

// CACHE.L1_DCACHE_BLOCKSIZE_CONF: L1 data Cache BlockSize mode configure register
func (o *CACHE_Type) SetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_8(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_8() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_16(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_16() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_32(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_32() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_64(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_64() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_128(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_128() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_256(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_DCACHE_BLOCKSIZE_CONF_L1_DCACHE_BLOCKSIZE_256() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_BLOCKSIZE_CONF.Reg) & 0x20) >> 5
}

// CACHE.L1_CACHE_WRAP_AROUND_CTRL: Cache wrap around control register
func (o *CACHE_Type) SetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE0_WRAP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE0_WRAP() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE1_WRAP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE1_WRAP() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE2_WRAP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE2_WRAP() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE3_WRAP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE3_WRAP() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_WRAP_AROUND_CTRL_L1_DCACHE_WRAP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_WRAP_AROUND_CTRL_L1_DCACHE_WRAP() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg) & 0x10) >> 4
}

// CACHE.L1_CACHE_TAG_MEM_POWER_CTRL: Cache tag memory power control register
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x1000) >> 12
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x2000) >> 13
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x4000) >> 14
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_DCACHE_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_DCACHE_TAG_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x10000) >> 16
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_DCACHE_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_DCACHE_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x20000) >> 17
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_DCACHE_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_DCACHE_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x40000) >> 18
}

// CACHE.L1_CACHE_DATA_MEM_POWER_CTRL: Cache data memory power control register
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x1000) >> 12
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x2000) >> 13
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x4000) >> 14
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_DCACHE_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_DCACHE_DATA_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x10000) >> 16
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_DCACHE_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_DCACHE_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x20000) >> 17
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_DCACHE_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_DCACHE_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x40000) >> 18
}

// CACHE.L1_CACHE_FREEZE_CTRL: Cache Freeze control register
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_EN() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x1000) >> 12
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x2000) >> 13
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x4000) >> 14
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_DCACHE_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_DCACHE_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x10000) >> 16
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_DCACHE_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_DCACHE_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x20000) >> 17
}
func (o *CACHE_Type) SetL1_CACHE_FREEZE_CTRL_L1_DCACHE_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *CACHE_Type) GetL1_CACHE_FREEZE_CTRL_L1_DCACHE_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x40000) >> 18
}

// CACHE.L1_CACHE_DATA_MEM_ACS_CONF: Cache data memory access configure register
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE0_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE0_DATA_MEM_RD_EN() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE0_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE0_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE1_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE1_DATA_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE1_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE1_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE2_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE2_DATA_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE2_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE2_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE3_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE3_DATA_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x1000) >> 12
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE3_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE3_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x2000) >> 13
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_DCACHE_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_DCACHE_DATA_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x10000) >> 16
}
func (o *CACHE_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_DCACHE_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *CACHE_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_DCACHE_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x20000) >> 17
}

// CACHE.L1_CACHE_TAG_MEM_ACS_CONF: Cache tag memory access configure register
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE0_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE0_TAG_MEM_RD_EN() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE0_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE0_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE1_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE1_TAG_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE1_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE1_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE2_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE2_TAG_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE2_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE2_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE3_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE3_TAG_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x1000) >> 12
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE3_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE3_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x2000) >> 13
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_DCACHE_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_DCACHE_TAG_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x10000) >> 16
}
func (o *CACHE_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_DCACHE_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *CACHE_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_DCACHE_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x20000) >> 17
}

// CACHE.L1_ICACHE0_PRELOCK_CONF: L1 instruction Cache 0 prelock configure register
func (o *CACHE_Type) SetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// CACHE.L1_ICACHE0_PRELOCK_SCT0_ADDR: L1 instruction Cache 0 prelock section0 address configure register
func (o *CACHE_Type) SetL1_ICACHE0_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT0_ADDR.Reg)
}

// CACHE.L1_ICACHE0_PRELOCK_SCT1_ADDR: L1 instruction Cache 0 prelock section1 address configure register
func (o *CACHE_Type) SetL1_ICACHE0_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT1_ADDR.Reg)
}

// CACHE.L1_ICACHE0_PRELOCK_SCT_SIZE: L1 instruction Cache 0 prelock section size configure register
func (o *CACHE_Type) SetL1_ICACHE0_PRELOCK_SCT_SIZE_L1_ICACHE0_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg)&^(0x3fff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOCK_SCT_SIZE_L1_ICACHE0_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg) & 0x3fff
}
func (o *CACHE_Type) SetL1_ICACHE0_PRELOCK_SCT_SIZE_L1_ICACHE0_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOCK_SCT_SIZE_L1_ICACHE0_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg) & 0x3fff0000) >> 16
}

// CACHE.L1_ICACHE1_PRELOCK_CONF: L1 instruction Cache 1 prelock configure register
func (o *CACHE_Type) SetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// CACHE.L1_ICACHE1_PRELOCK_SCT0_ADDR: L1 instruction Cache 1 prelock section0 address configure register
func (o *CACHE_Type) SetL1_ICACHE1_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT0_ADDR.Reg)
}

// CACHE.L1_ICACHE1_PRELOCK_SCT1_ADDR: L1 instruction Cache 1 prelock section1 address configure register
func (o *CACHE_Type) SetL1_ICACHE1_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT1_ADDR.Reg)
}

// CACHE.L1_ICACHE1_PRELOCK_SCT_SIZE: L1 instruction Cache 1 prelock section size configure register
func (o *CACHE_Type) SetL1_ICACHE1_PRELOCK_SCT_SIZE_L1_ICACHE1_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg)&^(0x3fff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOCK_SCT_SIZE_L1_ICACHE1_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg) & 0x3fff
}
func (o *CACHE_Type) SetL1_ICACHE1_PRELOCK_SCT_SIZE_L1_ICACHE1_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOCK_SCT_SIZE_L1_ICACHE1_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg) & 0x3fff0000) >> 16
}

// CACHE.L1_ICACHE2_PRELOCK_CONF: L1 instruction Cache 2 prelock configure register
func (o *CACHE_Type) SetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// CACHE.L1_ICACHE2_PRELOCK_SCT0_ADDR: L1 instruction Cache 2 prelock section0 address configure register
func (o *CACHE_Type) SetL1_ICACHE2_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT0_ADDR.Reg)
}

// CACHE.L1_ICACHE2_PRELOCK_SCT1_ADDR: L1 instruction Cache 2 prelock section1 address configure register
func (o *CACHE_Type) SetL1_ICACHE2_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT1_ADDR.Reg)
}

// CACHE.L1_ICACHE2_PRELOCK_SCT_SIZE: L1 instruction Cache 2 prelock section size configure register
func (o *CACHE_Type) SetL1_ICACHE2_PRELOCK_SCT_SIZE_L1_ICACHE2_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg)&^(0x3fff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOCK_SCT_SIZE_L1_ICACHE2_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg) & 0x3fff
}
func (o *CACHE_Type) SetL1_ICACHE2_PRELOCK_SCT_SIZE_L1_ICACHE2_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOCK_SCT_SIZE_L1_ICACHE2_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg) & 0x3fff0000) >> 16
}

// CACHE.L1_ICACHE3_PRELOCK_CONF: L1 instruction Cache 3 prelock configure register
func (o *CACHE_Type) SetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// CACHE.L1_ICACHE3_PRELOCK_SCT0_ADDR: L1 instruction Cache 3 prelock section0 address configure register
func (o *CACHE_Type) SetL1_ICACHE3_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT0_ADDR.Reg)
}

// CACHE.L1_ICACHE3_PRELOCK_SCT1_ADDR: L1 instruction Cache 3 prelock section1 address configure register
func (o *CACHE_Type) SetL1_ICACHE3_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT1_ADDR.Reg)
}

// CACHE.L1_ICACHE3_PRELOCK_SCT_SIZE: L1 instruction Cache 3 prelock section size configure register
func (o *CACHE_Type) SetL1_ICACHE3_PRELOCK_SCT_SIZE_L1_ICACHE3_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg)&^(0x3fff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOCK_SCT_SIZE_L1_ICACHE3_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg) & 0x3fff
}
func (o *CACHE_Type) SetL1_ICACHE3_PRELOCK_SCT_SIZE_L1_ICACHE3_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOCK_SCT_SIZE_L1_ICACHE3_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg) & 0x3fff0000) >> 16
}

// CACHE.L1_DCACHE_PRELOCK_CONF: L1 data Cache prelock configure register
func (o *CACHE_Type) SetL1_DCACHE_PRELOCK_CONF_L1_DCACHE_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOCK_CONF_L1_DCACHE_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_DCACHE_PRELOCK_CONF_L1_DCACHE_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOCK_CONF_L1_DCACHE_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_DCACHE_PRELOCK_CONF_L1_DCACHE_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOCK_CONF_L1_DCACHE_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// CACHE.L1_DCACHE_PRELOCK_SCT0_ADDR: L1 data Cache prelock section0 address configure register
func (o *CACHE_Type) SetL1_DCACHE_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT0_ADDR.Reg)
}

// CACHE.L1_DCACHE_PRELOCK_SCT1_ADDR: L1 data Cache prelock section1 address configure register
func (o *CACHE_Type) SetL1_DCACHE_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT1_ADDR.Reg)
}

// CACHE.L1_DCACHE_PRELOCK_SCT_SIZE: L1 data Cache prelock section size configure register
func (o *CACHE_Type) SetL1_DCACHE_PRELOCK_SCT_SIZE_L1_DCACHE_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg)&^(0x3fff)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOCK_SCT_SIZE_L1_DCACHE_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg) & 0x3fff
}
func (o *CACHE_Type) SetL1_DCACHE_PRELOCK_SCT_SIZE_L1_DCACHE_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOCK_SCT_SIZE_L1_DCACHE_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg) & 0x3fff0000) >> 16
}

// CACHE.LOCK_CTRL: Lock-class (manual lock) operation control register
func (o *CACHE_Type) SetLOCK_CTRL_LOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.LOCK_CTRL.Reg, volatile.LoadUint32(&o.LOCK_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetLOCK_CTRL_LOCK_ENA() uint32 {
	return volatile.LoadUint32(&o.LOCK_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetLOCK_CTRL_UNLOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.LOCK_CTRL.Reg, volatile.LoadUint32(&o.LOCK_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetLOCK_CTRL_UNLOCK_ENA() uint32 {
	return (volatile.LoadUint32(&o.LOCK_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetLOCK_CTRL_LOCK_DONE(value uint32) {
	volatile.StoreUint32(&o.LOCK_CTRL.Reg, volatile.LoadUint32(&o.LOCK_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetLOCK_CTRL_LOCK_DONE() uint32 {
	return (volatile.LoadUint32(&o.LOCK_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetLOCK_CTRL_LOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.LOCK_CTRL.Reg, volatile.LoadUint32(&o.LOCK_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *CACHE_Type) GetLOCK_CTRL_LOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.LOCK_CTRL.Reg) & 0x78) >> 3
}

// CACHE.LOCK_MAP: Lock (manual lock) map configure register
func (o *CACHE_Type) SetLOCK_MAP(value uint32) {
	volatile.StoreUint32(&o.LOCK_MAP.Reg, volatile.LoadUint32(&o.LOCK_MAP.Reg)&^(0x3f)|value)
}
func (o *CACHE_Type) GetLOCK_MAP() uint32 {
	return volatile.LoadUint32(&o.LOCK_MAP.Reg) & 0x3f
}

// CACHE.LOCK_ADDR: Lock (manual lock) address configure register
func (o *CACHE_Type) SetLOCK_ADDR(value uint32) {
	volatile.StoreUint32(&o.LOCK_ADDR.Reg, value)
}
func (o *CACHE_Type) GetLOCK_ADDR() uint32 {
	return volatile.LoadUint32(&o.LOCK_ADDR.Reg)
}

// CACHE.LOCK_SIZE: Lock (manual lock) size configure register
func (o *CACHE_Type) SetLOCK_SIZE(value uint32) {
	volatile.StoreUint32(&o.LOCK_SIZE.Reg, volatile.LoadUint32(&o.LOCK_SIZE.Reg)&^(0xffff)|value)
}
func (o *CACHE_Type) GetLOCK_SIZE() uint32 {
	return volatile.LoadUint32(&o.LOCK_SIZE.Reg) & 0xffff
}

// CACHE.SYNC_CTRL: Sync-class operation control register
func (o *CACHE_Type) SetSYNC_CTRL_INVALIDATE_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_CTRL.Reg, volatile.LoadUint32(&o.SYNC_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetSYNC_CTRL_INVALIDATE_ENA() uint32 {
	return volatile.LoadUint32(&o.SYNC_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetSYNC_CTRL_CLEAN_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_CTRL.Reg, volatile.LoadUint32(&o.SYNC_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetSYNC_CTRL_CLEAN_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetSYNC_CTRL_WRITEBACK_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_CTRL.Reg, volatile.LoadUint32(&o.SYNC_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetSYNC_CTRL_WRITEBACK_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetSYNC_CTRL_WRITEBACK_INVALIDATE_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_CTRL.Reg, volatile.LoadUint32(&o.SYNC_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetSYNC_CTRL_WRITEBACK_INVALIDATE_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_CTRL.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetSYNC_CTRL_SYNC_DONE(value uint32) {
	volatile.StoreUint32(&o.SYNC_CTRL.Reg, volatile.LoadUint32(&o.SYNC_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetSYNC_CTRL_SYNC_DONE() uint32 {
	return (volatile.LoadUint32(&o.SYNC_CTRL.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetSYNC_CTRL_SYNC_RGID(value uint32) {
	volatile.StoreUint32(&o.SYNC_CTRL.Reg, volatile.LoadUint32(&o.SYNC_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *CACHE_Type) GetSYNC_CTRL_SYNC_RGID() uint32 {
	return (volatile.LoadUint32(&o.SYNC_CTRL.Reg) & 0x1e0) >> 5
}

// CACHE.SYNC_MAP: Sync map configure register
func (o *CACHE_Type) SetSYNC_MAP(value uint32) {
	volatile.StoreUint32(&o.SYNC_MAP.Reg, volatile.LoadUint32(&o.SYNC_MAP.Reg)&^(0x3f)|value)
}
func (o *CACHE_Type) GetSYNC_MAP() uint32 {
	return volatile.LoadUint32(&o.SYNC_MAP.Reg) & 0x3f
}

// CACHE.SYNC_ADDR: Sync address configure register
func (o *CACHE_Type) SetSYNC_ADDR(value uint32) {
	volatile.StoreUint32(&o.SYNC_ADDR.Reg, value)
}
func (o *CACHE_Type) GetSYNC_ADDR() uint32 {
	return volatile.LoadUint32(&o.SYNC_ADDR.Reg)
}

// CACHE.SYNC_SIZE: Sync size configure register
func (o *CACHE_Type) SetSYNC_SIZE(value uint32) {
	volatile.StoreUint32(&o.SYNC_SIZE.Reg, volatile.LoadUint32(&o.SYNC_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetSYNC_SIZE() uint32 {
	return volatile.LoadUint32(&o.SYNC_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_ICACHE0_PRELOAD_CTRL: L1 instruction Cache 0 preload-operation control register
func (o *CACHE_Type) SetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// CACHE.L1_ICACHE0_PRELOAD_ADDR: L1 instruction Cache 0 preload address configure register
func (o *CACHE_Type) SetL1_ICACHE0_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_ADDR.Reg)
}

// CACHE.L1_ICACHE0_PRELOAD_SIZE: L1 instruction Cache 0 preload size configure register
func (o *CACHE_Type) SetL1_ICACHE0_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_SIZE.Reg)&^(0x3fff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE0_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_SIZE.Reg) & 0x3fff
}

// CACHE.L1_ICACHE1_PRELOAD_CTRL: L1 instruction Cache 1 preload-operation control register
func (o *CACHE_Type) SetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// CACHE.L1_ICACHE1_PRELOAD_ADDR: L1 instruction Cache 1 preload address configure register
func (o *CACHE_Type) SetL1_ICACHE1_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_ADDR.Reg)
}

// CACHE.L1_ICACHE1_PRELOAD_SIZE: L1 instruction Cache 1 preload size configure register
func (o *CACHE_Type) SetL1_ICACHE1_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_SIZE.Reg)&^(0x3fff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE1_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_SIZE.Reg) & 0x3fff
}

// CACHE.L1_ICACHE2_PRELOAD_CTRL: L1 instruction Cache 2 preload-operation control register
func (o *CACHE_Type) SetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// CACHE.L1_ICACHE2_PRELOAD_ADDR: L1 instruction Cache 2 preload address configure register
func (o *CACHE_Type) SetL1_ICACHE2_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_ADDR.Reg)
}

// CACHE.L1_ICACHE2_PRELOAD_SIZE: L1 instruction Cache 2 preload size configure register
func (o *CACHE_Type) SetL1_ICACHE2_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_SIZE.Reg)&^(0x3fff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE2_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_SIZE.Reg) & 0x3fff
}

// CACHE.L1_ICACHE3_PRELOAD_CTRL: L1 instruction Cache 3 preload-operation control register
func (o *CACHE_Type) SetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// CACHE.L1_ICACHE3_PRELOAD_ADDR: L1 instruction Cache 3 preload address configure register
func (o *CACHE_Type) SetL1_ICACHE3_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_ADDR.Reg)
}

// CACHE.L1_ICACHE3_PRELOAD_SIZE: L1 instruction Cache 3 preload size configure register
func (o *CACHE_Type) SetL1_ICACHE3_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_SIZE.Reg)&^(0x3fff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE3_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_SIZE.Reg) & 0x3fff
}

// CACHE.L1_DCACHE_PRELOAD_CTRL: L1 data Cache preload-operation control register
func (o *CACHE_Type) SetL1_DCACHE_PRELOAD_CTRL_L1_DCACHE_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOAD_CTRL_L1_DCACHE_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_DCACHE_PRELOAD_CTRL_L1_DCACHE_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOAD_CTRL_L1_DCACHE_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_DCACHE_PRELOAD_CTRL_L1_DCACHE_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOAD_CTRL_L1_DCACHE_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_DCACHE_PRELOAD_CTRL_L1_DCACHE_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOAD_CTRL_L1_DCACHE_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// CACHE.L1_DCACHE_PRELOAD_ADDR: L1 data Cache preload address configure register
func (o *CACHE_Type) SetL1_DCACHE_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOAD_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_ADDR.Reg)
}

// CACHE.L1_DCACHE_PRELOAD_SIZE: L1 data Cache preload size configure register
func (o *CACHE_Type) SetL1_DCACHE_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_SIZE.Reg)&^(0x3fff)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_SIZE.Reg) & 0x3fff
}

// CACHE.L1_ICACHE0_AUTOLOAD_CTRL: L1 instruction Cache 0 autoload-operation control register
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x3c00)|value<<10)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x3c00) >> 10
}

// CACHE.L1_ICACHE0_AUTOLOAD_SCT0_ADDR: L1 instruction Cache 0 autoload section 0 address configure register
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT0_ADDR.Reg)
}

// CACHE.L1_ICACHE0_AUTOLOAD_SCT0_SIZE: L1 instruction Cache 0 autoload section 0 size configure register
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_ICACHE0_AUTOLOAD_SCT1_ADDR: L1 instruction Cache 0 autoload section 1 address configure register
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT1_ADDR.Reg)
}

// CACHE.L1_ICACHE0_AUTOLOAD_SCT1_SIZE: L1 instruction Cache 0 autoload section 1 size configure register
func (o *CACHE_Type) SetL1_ICACHE0_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE0_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_ICACHE1_AUTOLOAD_CTRL: L1 instruction Cache 1 autoload-operation control register
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x3c00)|value<<10)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x3c00) >> 10
}

// CACHE.L1_ICACHE1_AUTOLOAD_SCT0_ADDR: L1 instruction Cache 1 autoload section 0 address configure register
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT0_ADDR.Reg)
}

// CACHE.L1_ICACHE1_AUTOLOAD_SCT0_SIZE: L1 instruction Cache 1 autoload section 0 size configure register
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_ICACHE1_AUTOLOAD_SCT1_ADDR: L1 instruction Cache 1 autoload section 1 address configure register
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT1_ADDR.Reg)
}

// CACHE.L1_ICACHE1_AUTOLOAD_SCT1_SIZE: L1 instruction Cache 1 autoload section 1 size configure register
func (o *CACHE_Type) SetL1_ICACHE1_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE1_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_ICACHE2_AUTOLOAD_CTRL: L1 instruction Cache 2 autoload-operation control register
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x3c00)|value<<10)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x3c00) >> 10
}

// CACHE.L1_ICACHE2_AUTOLOAD_SCT0_ADDR: L1 instruction Cache 2 autoload section 0 address configure register
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT0_ADDR.Reg)
}

// CACHE.L1_ICACHE2_AUTOLOAD_SCT0_SIZE: L1 instruction Cache 2 autoload section 0 size configure register
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_ICACHE2_AUTOLOAD_SCT1_ADDR: L1 instruction Cache 2 autoload section 1 address configure register
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT1_ADDR.Reg)
}

// CACHE.L1_ICACHE2_AUTOLOAD_SCT1_SIZE: L1 instruction Cache 2 autoload section 1 size configure register
func (o *CACHE_Type) SetL1_ICACHE2_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE2_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_ICACHE3_AUTOLOAD_CTRL: L1 instruction Cache 3 autoload-operation control register
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x3c00)|value<<10)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x3c00) >> 10
}

// CACHE.L1_ICACHE3_AUTOLOAD_SCT0_ADDR: L1 instruction Cache 3 autoload section 0 address configure register
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT0_ADDR.Reg)
}

// CACHE.L1_ICACHE3_AUTOLOAD_SCT0_SIZE: L1 instruction Cache 3 autoload section 0 size configure register
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_ICACHE3_AUTOLOAD_SCT1_ADDR: L1 instruction Cache 3 autoload section 1 address configure register
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT1_ADDR.Reg)
}

// CACHE.L1_ICACHE3_AUTOLOAD_SCT1_SIZE: L1 instruction Cache 3 autoload section 1 size configure register
func (o *CACHE_Type) SetL1_ICACHE3_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE3_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_DCACHE_AUTOLOAD_CTRL: L1 data Cache autoload-operation control register
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_SCT2_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_SCT2_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_SCT3_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_SCT3_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_CTRL_L1_DCACHE_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_CTRL.Reg) & 0xf000) >> 12
}

// CACHE.L1_DCACHE_AUTOLOAD_SCT0_ADDR: L1 data Cache autoload section 0 address configure register
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT0_ADDR.Reg)
}

// CACHE.L1_DCACHE_AUTOLOAD_SCT0_SIZE: L1 data Cache autoload section 0 size configure register
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_DCACHE_AUTOLOAD_SCT1_ADDR: L1 data Cache autoload section 1 address configure register
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT1_ADDR.Reg)
}

// CACHE.L1_DCACHE_AUTOLOAD_SCT1_SIZE: L1 data Cache autoload section 1 size configure register
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_DCACHE_AUTOLOAD_SCT2_ADDR: L1 data Cache autoload section 2 address configure register
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_SCT2_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_SCT2_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_SCT2_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT2_ADDR.Reg)
}

// CACHE.L1_DCACHE_AUTOLOAD_SCT2_SIZE: L1 data Cache autoload section 2 size configure register
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_SCT2_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_SCT2_SIZE.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT2_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_SCT2_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT2_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_DCACHE_AUTOLOAD_SCT3_ADDR: L1 data Cache autoload section 1 address configure register
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_SCT3_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_SCT3_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_SCT3_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT3_ADDR.Reg)
}

// CACHE.L1_DCACHE_AUTOLOAD_SCT3_SIZE: L1 data Cache autoload section 1 size configure register
func (o *CACHE_Type) SetL1_DCACHE_AUTOLOAD_SCT3_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_AUTOLOAD_SCT3_SIZE.Reg, volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT3_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_AUTOLOAD_SCT3_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_AUTOLOAD_SCT3_SIZE.Reg) & 0xfffffff
}

// CACHE.L1_CACHE_ACS_CNT_INT_ENA: Cache Access Counter Interrupt enable register
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS0_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS0_OVF_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS1_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS1_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS2_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS2_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS3_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS3_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS0_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS0_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS1_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS1_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS2_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS2_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS3_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS3_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x80) >> 7
}

// CACHE.L1_CACHE_ACS_CNT_INT_CLR: Cache Access Counter Interrupt clear register
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS0_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS0_OVF_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS1_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS1_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS2_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS2_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS3_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS3_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS0_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS0_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS1_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS1_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS2_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS2_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS3_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS3_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x80) >> 7
}

// CACHE.L1_CACHE_ACS_CNT_INT_RAW: Cache Access Counter Interrupt raw register
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS0_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS0_OVF_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS1_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS1_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS2_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS2_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS3_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS3_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS0_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS0_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS1_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS1_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS2_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS2_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS3_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS3_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x80) >> 7
}

// CACHE.L1_CACHE_ACS_CNT_INT_ST: Cache Access Counter Interrupt status register
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS0_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS0_OVF_INT_ST() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS1_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS1_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS2_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS2_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS3_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS3_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS0_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS0_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS1_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS1_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS2_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS2_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS3_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS3_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x80) >> 7
}

// CACHE.L1_CACHE_ACS_FAIL_CTRL: Cache Access Fail Configuration register
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_CTRL_L1_ICACHE0_ACS_FAIL_CHECK_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_CTRL_L1_ICACHE0_ACS_FAIL_CHECK_MODE() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_CTRL_L1_ICACHE1_ACS_FAIL_CHECK_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_CTRL_L1_ICACHE1_ACS_FAIL_CHECK_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_CTRL_L1_ICACHE2_ACS_FAIL_CHECK_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_CTRL_L1_ICACHE2_ACS_FAIL_CHECK_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_CTRL_L1_ICACHE3_ACS_FAIL_CHECK_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_CTRL_L1_ICACHE3_ACS_FAIL_CHECK_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_CTRL_L1_DCACHE_ACS_FAIL_CHECK_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_CTRL_L1_DCACHE_ACS_FAIL_CHECK_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_CTRL.Reg) & 0x10) >> 4
}

// CACHE.L1_CACHE_ACS_FAIL_INT_ENA: Cache Access Fail Interrupt enable register
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE0_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE0_FAIL_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE1_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE1_FAIL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE2_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE2_FAIL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE3_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE3_FAIL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_ENA_L1_DCACHE_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_ENA_L1_DCACHE_FAIL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x10) >> 4
}

// CACHE.L1_CACHE_ACS_FAIL_INT_CLR: L1-Cache Access Fail Interrupt clear register
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE0_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE0_FAIL_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE1_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE1_FAIL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE2_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE2_FAIL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE3_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE3_FAIL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_CLR_L1_DCACHE_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_CLR_L1_DCACHE_FAIL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x10) >> 4
}

// CACHE.L1_CACHE_ACS_FAIL_INT_RAW: Cache Access Fail Interrupt raw register
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE0_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE0_FAIL_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE1_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE1_FAIL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE2_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE2_FAIL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE3_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE3_FAIL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_RAW_L1_DCACHE_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_RAW_L1_DCACHE_FAIL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x10) >> 4
}

// CACHE.L1_CACHE_ACS_FAIL_INT_ST: Cache Access Fail Interrupt status register
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE0_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE0_FAIL_INT_ST() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE1_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE1_FAIL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE2_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE2_FAIL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE3_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE3_FAIL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_ACS_FAIL_INT_ST_L1_DCACHE_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_FAIL_INT_ST_L1_DCACHE_FAIL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg) & 0x10) >> 4
}

// CACHE.L1_CACHE_ACS_CNT_CTRL: Cache Access Counter enable and clear register
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS0_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS0_CNT_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS1_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS1_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS2_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS2_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS3_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS3_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS0_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS0_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS1_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS1_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS2_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS2_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS3_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS3_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x80) >> 7
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS0_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS0_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x10000) >> 16
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS1_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS1_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x20000) >> 17
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS2_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS2_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x40000) >> 18
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS3_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS3_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x80000) >> 19
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS0_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS0_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x100000) >> 20
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS1_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS1_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x200000) >> 21
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS2_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS2_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x400000) >> 22
}
func (o *CACHE_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS3_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *CACHE_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS3_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x800000) >> 23
}

// CACHE.L1_IBUS0_ACS_HIT_CNT: L1-ICache bus0 Hit-Access Counter register
func (o *CACHE_Type) SetL1_IBUS0_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS0_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS0_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS0_ACS_HIT_CNT.Reg)
}

// CACHE.L1_IBUS0_ACS_MISS_CNT: L1-ICache bus0 Miss-Access Counter register
func (o *CACHE_Type) SetL1_IBUS0_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS0_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS0_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS0_ACS_MISS_CNT.Reg)
}

// CACHE.L1_IBUS0_ACS_CONFLICT_CNT: L1-ICache bus0 Conflict-Access Counter register
func (o *CACHE_Type) SetL1_IBUS0_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS0_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS0_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS0_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L1_IBUS0_ACS_NXTLVL_RD_CNT: L1-ICache bus0 Next-Level-Access Counter register
func (o *CACHE_Type) SetL1_IBUS0_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS0_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS0_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS0_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L1_IBUS1_ACS_HIT_CNT: L1-ICache bus1 Hit-Access Counter register
func (o *CACHE_Type) SetL1_IBUS1_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS1_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS1_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS1_ACS_HIT_CNT.Reg)
}

// CACHE.L1_IBUS1_ACS_MISS_CNT: L1-ICache bus1 Miss-Access Counter register
func (o *CACHE_Type) SetL1_IBUS1_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS1_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS1_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS1_ACS_MISS_CNT.Reg)
}

// CACHE.L1_IBUS1_ACS_CONFLICT_CNT: L1-ICache bus1 Conflict-Access Counter register
func (o *CACHE_Type) SetL1_IBUS1_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS1_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS1_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS1_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L1_IBUS1_ACS_NXTLVL_RD_CNT: L1-ICache bus1 Next-Level-Access Counter register
func (o *CACHE_Type) SetL1_IBUS1_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS1_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS1_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS1_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L1_IBUS2_ACS_HIT_CNT: L1-ICache bus2 Hit-Access Counter register
func (o *CACHE_Type) SetL1_IBUS2_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS2_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS2_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS2_ACS_HIT_CNT.Reg)
}

// CACHE.L1_IBUS2_ACS_MISS_CNT: L1-ICache bus2 Miss-Access Counter register
func (o *CACHE_Type) SetL1_IBUS2_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS2_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS2_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS2_ACS_MISS_CNT.Reg)
}

// CACHE.L1_IBUS2_ACS_CONFLICT_CNT: L1-ICache bus2 Conflict-Access Counter register
func (o *CACHE_Type) SetL1_IBUS2_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS2_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS2_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS2_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L1_IBUS2_ACS_NXTLVL_RD_CNT: L1-ICache bus2 Next-Level-Access Counter register
func (o *CACHE_Type) SetL1_IBUS2_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS2_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS2_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS2_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L1_IBUS3_ACS_HIT_CNT: L1-ICache bus3 Hit-Access Counter register
func (o *CACHE_Type) SetL1_IBUS3_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS3_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS3_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS3_ACS_HIT_CNT.Reg)
}

// CACHE.L1_IBUS3_ACS_MISS_CNT: L1-ICache bus3 Miss-Access Counter register
func (o *CACHE_Type) SetL1_IBUS3_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS3_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS3_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS3_ACS_MISS_CNT.Reg)
}

// CACHE.L1_IBUS3_ACS_CONFLICT_CNT: L1-ICache bus3 Conflict-Access Counter register
func (o *CACHE_Type) SetL1_IBUS3_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS3_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS3_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS3_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L1_IBUS3_ACS_NXTLVL_RD_CNT: L1-ICache bus3 Next-Level-Access Counter register
func (o *CACHE_Type) SetL1_IBUS3_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS3_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_IBUS3_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS3_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L1_DBUS0_ACS_HIT_CNT: L1-DCache bus0 Hit-Access Counter register
func (o *CACHE_Type) SetL1_DBUS0_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS0_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS0_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS0_ACS_HIT_CNT.Reg)
}

// CACHE.L1_DBUS0_ACS_MISS_CNT: L1-DCache bus0 Miss-Access Counter register
func (o *CACHE_Type) SetL1_DBUS0_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS0_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS0_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS0_ACS_MISS_CNT.Reg)
}

// CACHE.L1_DBUS0_ACS_CONFLICT_CNT: L1-DCache bus0 Conflict-Access Counter register
func (o *CACHE_Type) SetL1_DBUS0_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS0_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS0_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS0_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L1_DBUS0_ACS_NXTLVL_RD_CNT: L1-DCache bus0 Next-Level-Access Counter register
func (o *CACHE_Type) SetL1_DBUS0_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS0_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS0_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS0_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L1_DBUS0_ACS_NXTLVL_WR_CNT: L1-DCache bus0 WB-Access Counter register
func (o *CACHE_Type) SetL1_DBUS0_ACS_NXTLVL_WR_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS0_ACS_NXTLVL_WR_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS0_ACS_NXTLVL_WR_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS0_ACS_NXTLVL_WR_CNT.Reg)
}

// CACHE.L1_DBUS1_ACS_HIT_CNT: L1-DCache bus1 Hit-Access Counter register
func (o *CACHE_Type) SetL1_DBUS1_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS1_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS1_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS1_ACS_HIT_CNT.Reg)
}

// CACHE.L1_DBUS1_ACS_MISS_CNT: L1-DCache bus1 Miss-Access Counter register
func (o *CACHE_Type) SetL1_DBUS1_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS1_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS1_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS1_ACS_MISS_CNT.Reg)
}

// CACHE.L1_DBUS1_ACS_CONFLICT_CNT: L1-DCache bus1 Conflict-Access Counter register
func (o *CACHE_Type) SetL1_DBUS1_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS1_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS1_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS1_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L1_DBUS1_ACS_NXTLVL_RD_CNT: L1-DCache bus1 Next-Level-Access Counter register
func (o *CACHE_Type) SetL1_DBUS1_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS1_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS1_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS1_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L1_DBUS1_ACS_NXTLVL_WR_CNT: L1-DCache bus1 WB-Access Counter register
func (o *CACHE_Type) SetL1_DBUS1_ACS_NXTLVL_WR_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS1_ACS_NXTLVL_WR_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS1_ACS_NXTLVL_WR_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS1_ACS_NXTLVL_WR_CNT.Reg)
}

// CACHE.L1_DBUS2_ACS_HIT_CNT: L1-DCache bus2 Hit-Access Counter register
func (o *CACHE_Type) SetL1_DBUS2_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS2_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS2_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS2_ACS_HIT_CNT.Reg)
}

// CACHE.L1_DBUS2_ACS_MISS_CNT: L1-DCache bus2 Miss-Access Counter register
func (o *CACHE_Type) SetL1_DBUS2_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS2_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS2_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS2_ACS_MISS_CNT.Reg)
}

// CACHE.L1_DBUS2_ACS_CONFLICT_CNT: L1-DCache bus2 Conflict-Access Counter register
func (o *CACHE_Type) SetL1_DBUS2_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS2_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS2_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS2_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L1_DBUS2_ACS_NXTLVL_RD_CNT: L1-DCache bus2 Next-Level-Access Counter register
func (o *CACHE_Type) SetL1_DBUS2_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS2_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS2_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS2_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L1_DBUS2_ACS_NXTLVL_WR_CNT: L1-DCache bus2 WB-Access Counter register
func (o *CACHE_Type) SetL1_DBUS2_ACS_NXTLVL_WR_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS2_ACS_NXTLVL_WR_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS2_ACS_NXTLVL_WR_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS2_ACS_NXTLVL_WR_CNT.Reg)
}

// CACHE.L1_DBUS3_ACS_HIT_CNT: L1-DCache bus3 Hit-Access Counter register
func (o *CACHE_Type) SetL1_DBUS3_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS3_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS3_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS3_ACS_HIT_CNT.Reg)
}

// CACHE.L1_DBUS3_ACS_MISS_CNT: L1-DCache bus3 Miss-Access Counter register
func (o *CACHE_Type) SetL1_DBUS3_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS3_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS3_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS3_ACS_MISS_CNT.Reg)
}

// CACHE.L1_DBUS3_ACS_CONFLICT_CNT: L1-DCache bus3 Conflict-Access Counter register
func (o *CACHE_Type) SetL1_DBUS3_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS3_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS3_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS3_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L1_DBUS3_ACS_NXTLVL_RD_CNT: L1-DCache bus3 Next-Level-Access Counter register
func (o *CACHE_Type) SetL1_DBUS3_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS3_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS3_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS3_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L1_DBUS3_ACS_NXTLVL_WR_CNT: L1-DCache bus3 WB-Access Counter register
func (o *CACHE_Type) SetL1_DBUS3_ACS_NXTLVL_WR_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS3_ACS_NXTLVL_WR_CNT.Reg, value)
}
func (o *CACHE_Type) GetL1_DBUS3_ACS_NXTLVL_WR_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS3_ACS_NXTLVL_WR_CNT.Reg)
}

// CACHE.L1_ICACHE0_ACS_FAIL_ID_ATTR: L1-ICache0 Access Fail ID/attribution information register
func (o *CACHE_Type) SetL1_ICACHE0_ACS_FAIL_ID_ATTR_L1_ICACHE0_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE0_ACS_FAIL_ID_ATTR_L1_ICACHE0_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *CACHE_Type) SetL1_ICACHE0_ACS_FAIL_ID_ATTR_L1_ICACHE0_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CACHE_Type) GetL1_ICACHE0_ACS_FAIL_ID_ATTR_L1_ICACHE0_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// CACHE.L1_ICACHE0_ACS_FAIL_ADDR: L1-ICache0 Access Fail Address information register
func (o *CACHE_Type) SetL1_ICACHE0_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_ACS_FAIL_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE0_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_ACS_FAIL_ADDR.Reg)
}

// CACHE.L1_ICACHE1_ACS_FAIL_ID_ATTR: L1-ICache0 Access Fail ID/attribution information register
func (o *CACHE_Type) SetL1_ICACHE1_ACS_FAIL_ID_ATTR_L1_ICACHE1_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE1_ACS_FAIL_ID_ATTR_L1_ICACHE1_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *CACHE_Type) SetL1_ICACHE1_ACS_FAIL_ID_ATTR_L1_ICACHE1_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CACHE_Type) GetL1_ICACHE1_ACS_FAIL_ID_ATTR_L1_ICACHE1_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// CACHE.L1_ICACHE1_ACS_FAIL_ADDR: L1-ICache0 Access Fail Address information register
func (o *CACHE_Type) SetL1_ICACHE1_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_ACS_FAIL_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE1_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_ACS_FAIL_ADDR.Reg)
}

// CACHE.L1_ICACHE2_ACS_FAIL_ID_ATTR: L1-ICache0 Access Fail ID/attribution information register
func (o *CACHE_Type) SetL1_ICACHE2_ACS_FAIL_ID_ATTR_L1_ICACHE2_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE2_ACS_FAIL_ID_ATTR_L1_ICACHE2_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *CACHE_Type) SetL1_ICACHE2_ACS_FAIL_ID_ATTR_L1_ICACHE2_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CACHE_Type) GetL1_ICACHE2_ACS_FAIL_ID_ATTR_L1_ICACHE2_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// CACHE.L1_ICACHE2_ACS_FAIL_ADDR: L1-ICache0 Access Fail Address information register
func (o *CACHE_Type) SetL1_ICACHE2_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_ACS_FAIL_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE2_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_ACS_FAIL_ADDR.Reg)
}

// CACHE.L1_ICACHE3_ACS_FAIL_ID_ATTR: L1-ICache0 Access Fail ID/attribution information register
func (o *CACHE_Type) SetL1_ICACHE3_ACS_FAIL_ID_ATTR_L1_ICACHE3_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *CACHE_Type) GetL1_ICACHE3_ACS_FAIL_ID_ATTR_L1_ICACHE3_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *CACHE_Type) SetL1_ICACHE3_ACS_FAIL_ID_ATTR_L1_ICACHE3_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CACHE_Type) GetL1_ICACHE3_ACS_FAIL_ID_ATTR_L1_ICACHE3_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// CACHE.L1_ICACHE3_ACS_FAIL_ADDR: L1-ICache0 Access Fail Address information register
func (o *CACHE_Type) SetL1_ICACHE3_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_ACS_FAIL_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_ICACHE3_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_ACS_FAIL_ADDR.Reg)
}

// CACHE.L1_DCACHE_ACS_FAIL_ID_ATTR: L1-DCache Access Fail ID/attribution information register
func (o *CACHE_Type) SetL1_DCACHE_ACS_FAIL_ID_ATTR_L1_DCACHE_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_DCACHE_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *CACHE_Type) GetL1_DCACHE_ACS_FAIL_ID_ATTR_L1_DCACHE_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *CACHE_Type) SetL1_DCACHE_ACS_FAIL_ID_ATTR_L1_DCACHE_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_DCACHE_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CACHE_Type) GetL1_DCACHE_ACS_FAIL_ID_ATTR_L1_DCACHE_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// CACHE.L1_DCACHE_ACS_FAIL_ADDR: L1-DCache Access Fail Address information register
func (o *CACHE_Type) SetL1_DCACHE_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_ACS_FAIL_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_DCACHE_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_ACS_FAIL_ADDR.Reg)
}

// CACHE.SYNC_L1_CACHE_PRELOAD_INT_ENA: L1-Cache Access Fail Interrupt enable register
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE0_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE0_PLD_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x1
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE1_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE1_PLD_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE2_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE2_PLD_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE3_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE3_PLD_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_DCACHE_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_DCACHE_PLD_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_SYNC_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_SYNC_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE0_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE0_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x80) >> 7
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE1_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE1_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE2_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE2_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE3_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_ICACHE3_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_DCACHE_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_L1_DCACHE_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ENA_SYNC_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ENA_SYNC_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ENA.Reg) & 0x2000) >> 13
}

// CACHE.SYNC_L1_CACHE_PRELOAD_INT_CLR: Sync Preload operation Interrupt clear register
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE0_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE0_PLD_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x1
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE1_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE1_PLD_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE2_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE2_PLD_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE3_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE3_PLD_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_DCACHE_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_DCACHE_PLD_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_SYNC_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_SYNC_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE0_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE0_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x80) >> 7
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE1_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE1_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE2_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE2_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE3_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_ICACHE3_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_DCACHE_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_L1_DCACHE_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_CLR_SYNC_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_CLR_SYNC_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_CLR.Reg) & 0x2000) >> 13
}

// CACHE.SYNC_L1_CACHE_PRELOAD_INT_RAW: Sync Preload operation Interrupt raw register
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE0_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE0_PLD_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x1
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE1_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE1_PLD_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE2_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE2_PLD_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE3_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE3_PLD_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_DCACHE_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_DCACHE_PLD_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_SYNC_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_SYNC_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE0_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE0_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x80) >> 7
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE1_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE1_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE2_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE2_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE3_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_ICACHE3_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_DCACHE_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_L1_DCACHE_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_RAW_SYNC_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_RAW_SYNC_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_RAW.Reg) & 0x2000) >> 13
}

// CACHE.SYNC_L1_CACHE_PRELOAD_INT_ST: L1-Cache Access Fail Interrupt status register
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE0_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE0_PLD_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x1
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE1_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE1_PLD_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE2_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE2_PLD_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE3_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE3_PLD_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_DCACHE_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_DCACHE_PLD_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_SYNC_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_SYNC_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE0_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE0_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x80) >> 7
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE1_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE1_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE2_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE2_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE3_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_ICACHE3_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_DCACHE_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_L1_DCACHE_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_INT_ST_SYNC_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_INT_ST_SYNC_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_INT_ST.Reg) & 0x2000) >> 13
}

// CACHE.SYNC_L1_CACHE_PRELOAD_EXCEPTION: Cache Sync/Preload Operation exception register
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_EXCEPTION_L1_ICACHE0_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg)&^(0x3)|value)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_EXCEPTION_L1_ICACHE0_PLD_ERR_CODE() uint32 {
	return volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg) & 0x3
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_EXCEPTION_L1_ICACHE1_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg)&^(0xc)|value<<2)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_EXCEPTION_L1_ICACHE1_PLD_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg) & 0xc) >> 2
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_EXCEPTION_L1_ICACHE2_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg)&^(0x30)|value<<4)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_EXCEPTION_L1_ICACHE2_PLD_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg) & 0x30) >> 4
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_EXCEPTION_L1_ICACHE3_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg)&^(0xc0)|value<<6)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_EXCEPTION_L1_ICACHE3_PLD_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg) & 0xc0) >> 6
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_EXCEPTION_L1_DCACHE_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg)&^(0x300)|value<<8)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_EXCEPTION_L1_DCACHE_PLD_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg) & 0x300) >> 8
}
func (o *CACHE_Type) SetSYNC_L1_CACHE_PRELOAD_EXCEPTION_SYNC_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg)&^(0x3000)|value<<12)
}
func (o *CACHE_Type) GetSYNC_L1_CACHE_PRELOAD_EXCEPTION_SYNC_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.SYNC_L1_CACHE_PRELOAD_EXCEPTION.Reg) & 0x3000) >> 12
}

// CACHE.L1_CACHE_SYNC_RST_CTRL: Cache Sync Reset control register
func (o *CACHE_Type) SetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE0_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE0_SYNC_RST() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE1_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE1_SYNC_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE2_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE2_SYNC_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE3_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE3_SYNC_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_SYNC_RST_CTRL_L1_DCACHE_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_SYNC_RST_CTRL_L1_DCACHE_SYNC_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg) & 0x10) >> 4
}

// CACHE.L1_CACHE_PRELOAD_RST_CTRL: Cache Preload Reset control register
func (o *CACHE_Type) SetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE0_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE0_PLD_RST() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE1_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE1_PLD_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE2_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE2_PLD_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE3_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE3_PLD_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_PRELOAD_RST_CTRL_L1_DCACHE_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_PRELOAD_RST_CTRL_L1_DCACHE_PLD_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg) & 0x10) >> 4
}

// CACHE.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL: Cache Autoload buffer clear control register
func (o *CACHE_Type) SetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE0_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE0_ALD_BUF_CLR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE1_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE1_ALD_BUF_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE2_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE2_ALD_BUF_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE3_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE3_ALD_BUF_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_DCACHE_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_DCACHE_ALD_BUF_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x10) >> 4
}

// CACHE.L1_UNALLOCATE_BUFFER_CLEAR: Unallocate request buffer clear registers
func (o *CACHE_Type) SetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE0_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE0_UNALLOC_CLR() uint32 {
	return volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE1_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE1_UNALLOC_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE2_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE2_UNALLOC_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE3_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE3_UNALLOC_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_UNALLOCATE_BUFFER_CLEAR_L1_DCACHE_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_UNALLOCATE_BUFFER_CLEAR_L1_DCACHE_UNALLOC_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x10) >> 4
}

// CACHE.L1_CACHE_OBJECT_CTRL: Cache Tag and Data memory Object control register
func (o *CACHE_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE0_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE0_TAG_OBJECT() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE1_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE1_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE2_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE2_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE3_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE3_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL1_CACHE_OBJECT_CTRL_L1_DCACHE_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL1_CACHE_OBJECT_CTRL_L1_DCACHE_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE0_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE0_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE1_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE1_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x80) >> 7
}
func (o *CACHE_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE2_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE2_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE3_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE3_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL1_CACHE_OBJECT_CTRL_L1_DCACHE_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL1_CACHE_OBJECT_CTRL_L1_DCACHE_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x400) >> 10
}

// CACHE.L1_CACHE_WAY_OBJECT: Cache Tag and Data memory way register
func (o *CACHE_Type) SetL1_CACHE_WAY_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WAY_OBJECT.Reg, volatile.LoadUint32(&o.L1_CACHE_WAY_OBJECT.Reg)&^(0x7)|value)
}
func (o *CACHE_Type) GetL1_CACHE_WAY_OBJECT() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_WAY_OBJECT.Reg) & 0x7
}

// CACHE.L1_CACHE_VADDR: Cache Vaddr register
func (o *CACHE_Type) SetL1_CACHE_VADDR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_VADDR.Reg, value)
}
func (o *CACHE_Type) GetL1_CACHE_VADDR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_VADDR.Reg)
}

// CACHE.L1_CACHE_DEBUG_BUS: Cache Tag/data memory content register
func (o *CACHE_Type) SetL1_CACHE_DEBUG_BUS(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DEBUG_BUS.Reg, value)
}
func (o *CACHE_Type) GetL1_CACHE_DEBUG_BUS() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_DEBUG_BUS.Reg)
}

// CACHE.LEVEL_SPLIT0: USED TO SPLIT L1 CACHE AND L2 CACHE
func (o *CACHE_Type) SetLEVEL_SPLIT0(value uint32) {
	volatile.StoreUint32(&o.LEVEL_SPLIT0.Reg, value)
}
func (o *CACHE_Type) GetLEVEL_SPLIT0() uint32 {
	return volatile.LoadUint32(&o.LEVEL_SPLIT0.Reg)
}

// CACHE.L2_CACHE_CTRL: L2 Cache(L2-Cache) control register
func (o *CACHE_Type) SetL2_CACHE_CTRL_L2_CACHE_SHUT_DMA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL2_CACHE_CTRL_L2_CACHE_SHUT_DMA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CTRL.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL2_CACHE_CTRL_L2_CACHE_UNDEF_OP(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_CTRL.Reg)&^(0xff00)|value<<8)
}
func (o *CACHE_Type) GetL2_CACHE_CTRL_L2_CACHE_UNDEF_OP() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CTRL.Reg) & 0xff00) >> 8
}

// CACHE.L2_BYPASS_CACHE_CONF: Bypass Cache configure register
func (o *CACHE_Type) SetL2_BYPASS_CACHE_CONF_BYPASS_L2_CACHE_EN(value uint32) {
	volatile.StoreUint32(&o.L2_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L2_BYPASS_CACHE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_BYPASS_CACHE_CONF_BYPASS_L2_CACHE_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_BYPASS_CACHE_CONF.Reg) & 0x20) >> 5
}

// CACHE.L2_CACHE_CACHESIZE_CONF: L2 Cache CacheSize mode configure register
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_256(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_256() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_512(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_512() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_1K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_1K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_2K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_2K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_4K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_4K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_8K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_8K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_16K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x40)|value<<6)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_16K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x40) >> 6
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_32K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x80)|value<<7)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_32K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x80) >> 7
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_64K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_64K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_128K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_128K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_256K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_256K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_512K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_512K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_1024K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_1024K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x1000) >> 12
}

// CACHE.L2_CACHE_BLOCKSIZE_CONF: L2 Cache BlockSize mode configure register
func (o *CACHE_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_8(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_8() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_16(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_16() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_32(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_32() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_64(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_64() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x8) >> 3
}
func (o *CACHE_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_128(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *CACHE_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_128() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x10) >> 4
}
func (o *CACHE_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_256(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_256() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x20) >> 5
}

// CACHE.L2_CACHE_WRAP_AROUND_CTRL: Cache wrap around control register
func (o *CACHE_Type) SetL2_CACHE_WRAP_AROUND_CTRL_L2_CACHE_WRAP(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_WRAP_AROUND_CTRL_L2_CACHE_WRAP() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_WRAP_AROUND_CTRL.Reg) & 0x20) >> 5
}

// CACHE.L2_CACHE_TAG_MEM_POWER_CTRL: Cache tag memory power control register
func (o *CACHE_Type) SetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CACHE_Type) GetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x100000) >> 20
}
func (o *CACHE_Type) SetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *CACHE_Type) GetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x200000) >> 21
}
func (o *CACHE_Type) SetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *CACHE_Type) GetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x400000) >> 22
}

// CACHE.L2_CACHE_DATA_MEM_POWER_CTRL: Cache data memory power control register
func (o *CACHE_Type) SetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CACHE_Type) GetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x100000) >> 20
}
func (o *CACHE_Type) SetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *CACHE_Type) GetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x200000) >> 21
}
func (o *CACHE_Type) SetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *CACHE_Type) GetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x400000) >> 22
}

// CACHE.L2_CACHE_FREEZE_CTRL: Cache Freeze control register
func (o *CACHE_Type) SetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CACHE_Type) GetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg) & 0x100000) >> 20
}
func (o *CACHE_Type) SetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *CACHE_Type) GetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg) & 0x200000) >> 21
}
func (o *CACHE_Type) SetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *CACHE_Type) GetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg) & 0x400000) >> 22
}

// CACHE.L2_CACHE_DATA_MEM_ACS_CONF: Cache data memory access configure register
func (o *CACHE_Type) SetL2_CACHE_DATA_MEM_ACS_CONF_L2_CACHE_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *CACHE_Type) GetL2_CACHE_DATA_MEM_ACS_CONF_L2_CACHE_DATA_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x100000) >> 20
}
func (o *CACHE_Type) SetL2_CACHE_DATA_MEM_ACS_CONF_L2_CACHE_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *CACHE_Type) GetL2_CACHE_DATA_MEM_ACS_CONF_L2_CACHE_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x200000) >> 21
}

// CACHE.L2_CACHE_TAG_MEM_ACS_CONF: Cache tag memory access configure register
func (o *CACHE_Type) SetL2_CACHE_TAG_MEM_ACS_CONF_L2_CACHE_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *CACHE_Type) GetL2_CACHE_TAG_MEM_ACS_CONF_L2_CACHE_TAG_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x100000) >> 20
}
func (o *CACHE_Type) SetL2_CACHE_TAG_MEM_ACS_CONF_L2_CACHE_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *CACHE_Type) GetL2_CACHE_TAG_MEM_ACS_CONF_L2_CACHE_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x200000) >> 21
}

// CACHE.L2_CACHE_PRELOCK_CONF: L2 Cache prelock configure register
func (o *CACHE_Type) SetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg) & 0x1
}
func (o *CACHE_Type) SetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// CACHE.L2_CACHE_PRELOCK_SCT0_ADDR: L2 Cache prelock section0 address configure register
func (o *CACHE_Type) SetL2_CACHE_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT0_ADDR.Reg)
}

// CACHE.L2_CACHE_PRELOCK_SCT1_ADDR: L2 Cache prelock section1 address configure register
func (o *CACHE_Type) SetL2_CACHE_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT1_ADDR.Reg)
}

// CACHE.L2_CACHE_PRELOCK_SCT_SIZE: L2 Cache prelock section size configure register
func (o *CACHE_Type) SetL2_CACHE_PRELOCK_SCT_SIZE_L2_CACHE_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg)&^(0xffff)|value)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOCK_SCT_SIZE_L2_CACHE_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg) & 0xffff
}
func (o *CACHE_Type) SetL2_CACHE_PRELOCK_SCT_SIZE_L2_CACHE_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg)&^(0xffff0000)|value<<16)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOCK_SCT_SIZE_L2_CACHE_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg) & 0xffff0000) >> 16
}

// CACHE.L2_CACHE_PRELOAD_CTRL: L2 Cache preload-operation control register
func (o *CACHE_Type) SetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// CACHE.L2_CACHE_PRELOAD_ADDR: L2 Cache preload address configure register
func (o *CACHE_Type) SetL2_CACHE_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOAD_ADDR.Reg)
}

// CACHE.L2_CACHE_PRELOAD_SIZE: L2 Cache preload size configure register
func (o *CACHE_Type) SetL2_CACHE_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_SIZE.Reg)&^(0xffff)|value)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOAD_SIZE.Reg) & 0xffff
}

// CACHE.L2_CACHE_AUTOLOAD_CTRL: L2 Cache autoload-operation control register
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT2_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT2_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT3_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT3_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0xf000) >> 12
}

// CACHE.L2_CACHE_AUTOLOAD_SCT0_ADDR: L2 Cache autoload section 0 address configure register
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT0_ADDR.Reg)
}

// CACHE.L2_CACHE_AUTOLOAD_SCT0_SIZE: L2 Cache autoload section 0 size configure register
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// CACHE.L2_CACHE_AUTOLOAD_SCT1_ADDR: L2 Cache autoload section 1 address configure register
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT1_ADDR.Reg)
}

// CACHE.L2_CACHE_AUTOLOAD_SCT1_SIZE: L2 Cache autoload section 1 size configure register
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// CACHE.L2_CACHE_AUTOLOAD_SCT2_ADDR: L2 Cache autoload section 2 address configure register
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_SCT2_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT2_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_SCT2_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT2_ADDR.Reg)
}

// CACHE.L2_CACHE_AUTOLOAD_SCT2_SIZE: L2 Cache autoload section 2 size configure register
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_SCT2_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT2_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT2_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_SCT2_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT2_SIZE.Reg) & 0xfffffff
}

// CACHE.L2_CACHE_AUTOLOAD_SCT3_ADDR: L2 Cache autoload section 3 address configure register
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_SCT3_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT3_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_SCT3_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT3_ADDR.Reg)
}

// CACHE.L2_CACHE_AUTOLOAD_SCT3_SIZE: L2 Cache autoload section 3 size configure register
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_SCT3_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT3_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT3_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_SCT3_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT3_SIZE.Reg) & 0xfffffff
}

// CACHE.L2_CACHE_ACS_CNT_INT_ENA: Cache Access Counter Interrupt enable register
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS0_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS0_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS1_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS1_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS2_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS2_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS3_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS3_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS0_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS0_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x1000) >> 12
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS1_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS1_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x2000) >> 13
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS2_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS2_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x4000) >> 14
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS3_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS3_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x8000) >> 15
}

// CACHE.L2_CACHE_ACS_CNT_INT_CLR: Cache Access Counter Interrupt clear register
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS0_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS0_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS1_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS1_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS2_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS2_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS3_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS3_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS0_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS0_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x1000) >> 12
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS1_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS1_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x2000) >> 13
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS2_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS2_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x4000) >> 14
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS3_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS3_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x8000) >> 15
}

// CACHE.L2_CACHE_ACS_CNT_INT_RAW: Cache Access Counter Interrupt raw register
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS0_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS0_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS1_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS1_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS2_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS2_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS3_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS3_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS0_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS0_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x1000) >> 12
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS1_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS1_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x2000) >> 13
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS2_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS2_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x4000) >> 14
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS3_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS3_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x8000) >> 15
}

// CACHE.L2_CACHE_ACS_CNT_INT_ST: Cache Access Counter Interrupt status register
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS0_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS0_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS1_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS1_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS2_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS2_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS3_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS3_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS0_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS0_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x1000) >> 12
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS1_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS1_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x2000) >> 13
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS2_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x4000)|value<<14)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS2_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x4000) >> 14
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS3_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x8000)|value<<15)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS3_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x8000) >> 15
}

// CACHE.L2_CACHE_ACS_FAIL_CTRL: Cache Access Fail Configuration register
func (o *CACHE_Type) SetL2_CACHE_ACS_FAIL_CTRL_L2_CACHE_ACS_FAIL_CHECK_MODE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_FAIL_CTRL_L2_CACHE_ACS_FAIL_CHECK_MODE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_CTRL.Reg) & 0x1
}

// CACHE.L2_CACHE_ACS_FAIL_INT_ENA: Cache Access Fail Interrupt enable register
func (o *CACHE_Type) SetL2_CACHE_ACS_FAIL_INT_ENA_L2_CACHE_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_FAIL_INT_ENA_L2_CACHE_FAIL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x20) >> 5
}

// CACHE.L2_CACHE_ACS_FAIL_INT_CLR: L1-Cache Access Fail Interrupt clear register
func (o *CACHE_Type) SetL2_CACHE_ACS_FAIL_INT_CLR_L2_CACHE_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_FAIL_INT_CLR_L2_CACHE_FAIL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x20) >> 5
}

// CACHE.L2_CACHE_ACS_FAIL_INT_RAW: Cache Access Fail Interrupt raw register
func (o *CACHE_Type) SetL2_CACHE_ACS_FAIL_INT_RAW_L2_CACHE_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_FAIL_INT_RAW_L2_CACHE_FAIL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x20) >> 5
}

// CACHE.L2_CACHE_ACS_FAIL_INT_ST: Cache Access Fail Interrupt status register
func (o *CACHE_Type) SetL2_CACHE_ACS_FAIL_INT_ST_L2_CACHE_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_FAIL_INT_ST_L2_CACHE_FAIL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_ST.Reg) & 0x20) >> 5
}

// CACHE.L2_CACHE_ACS_CNT_CTRL: Cache Access Counter enable and clear register
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS0_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS0_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x100) >> 8
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS1_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS1_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x200) >> 9
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS2_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS2_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x400) >> 10
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS3_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS3_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x800) >> 11
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS0_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS0_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x1000) >> 12
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS1_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS1_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x2000) >> 13
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS2_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS2_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x4000) >> 14
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS3_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS3_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x8000) >> 15
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS0_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS0_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x1000000) >> 24
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS1_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS1_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x2000000) >> 25
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS2_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS2_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x4000000) >> 26
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS3_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS3_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x8000000) >> 27
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS0_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS0_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x10000000) >> 28
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS1_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS1_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x20000000) >> 29
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS2_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS2_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x40000000) >> 30
}
func (o *CACHE_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS3_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS3_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x80000000) >> 31
}

// CACHE.L2_IBUS0_ACS_HIT_CNT: L2-Cache bus0 Hit-Access Counter register
func (o *CACHE_Type) SetL2_IBUS0_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS0_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS0_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS0_ACS_HIT_CNT.Reg)
}

// CACHE.L2_IBUS0_ACS_MISS_CNT: L2-Cache bus0 Miss-Access Counter register
func (o *CACHE_Type) SetL2_IBUS0_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS0_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS0_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS0_ACS_MISS_CNT.Reg)
}

// CACHE.L2_IBUS0_ACS_CONFLICT_CNT: L2-Cache bus0 Conflict-Access Counter register
func (o *CACHE_Type) SetL2_IBUS0_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS0_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS0_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS0_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L2_IBUS0_ACS_NXTLVL_RD_CNT: L2-Cache bus0 Next-Level-Access Counter register
func (o *CACHE_Type) SetL2_IBUS0_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS0_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS0_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS0_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L2_IBUS1_ACS_HIT_CNT: L2-Cache bus1 Hit-Access Counter register
func (o *CACHE_Type) SetL2_IBUS1_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS1_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS1_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS1_ACS_HIT_CNT.Reg)
}

// CACHE.L2_IBUS1_ACS_MISS_CNT: L2-Cache bus1 Miss-Access Counter register
func (o *CACHE_Type) SetL2_IBUS1_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS1_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS1_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS1_ACS_MISS_CNT.Reg)
}

// CACHE.L2_IBUS1_ACS_CONFLICT_CNT: L2-Cache bus1 Conflict-Access Counter register
func (o *CACHE_Type) SetL2_IBUS1_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS1_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS1_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS1_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L2_IBUS1_ACS_NXTLVL_RD_CNT: L2-Cache bus1 Next-Level-Access Counter register
func (o *CACHE_Type) SetL2_IBUS1_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS1_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS1_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS1_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L2_IBUS2_ACS_HIT_CNT: L2-Cache bus2 Hit-Access Counter register
func (o *CACHE_Type) SetL2_IBUS2_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS2_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS2_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS2_ACS_HIT_CNT.Reg)
}

// CACHE.L2_IBUS2_ACS_MISS_CNT: L2-Cache bus2 Miss-Access Counter register
func (o *CACHE_Type) SetL2_IBUS2_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS2_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS2_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS2_ACS_MISS_CNT.Reg)
}

// CACHE.L2_IBUS2_ACS_CONFLICT_CNT: L2-Cache bus2 Conflict-Access Counter register
func (o *CACHE_Type) SetL2_IBUS2_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS2_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS2_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS2_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L2_IBUS2_ACS_NXTLVL_RD_CNT: L2-Cache bus2 Next-Level-Access Counter register
func (o *CACHE_Type) SetL2_IBUS2_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS2_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS2_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS2_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L2_IBUS3_ACS_HIT_CNT: L2-Cache bus3 Hit-Access Counter register
func (o *CACHE_Type) SetL2_IBUS3_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS3_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS3_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS3_ACS_HIT_CNT.Reg)
}

// CACHE.L2_IBUS3_ACS_MISS_CNT: L2-Cache bus3 Miss-Access Counter register
func (o *CACHE_Type) SetL2_IBUS3_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS3_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS3_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS3_ACS_MISS_CNT.Reg)
}

// CACHE.L2_IBUS3_ACS_CONFLICT_CNT: L2-Cache bus3 Conflict-Access Counter register
func (o *CACHE_Type) SetL2_IBUS3_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS3_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS3_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS3_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L2_IBUS3_ACS_NXTLVL_RD_CNT: L2-Cache bus3 Next-Level-Access Counter register
func (o *CACHE_Type) SetL2_IBUS3_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS3_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_IBUS3_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS3_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L2_DBUS0_ACS_HIT_CNT: L2-Cache bus0 Hit-Access Counter register
func (o *CACHE_Type) SetL2_DBUS0_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS0_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS0_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS0_ACS_HIT_CNT.Reg)
}

// CACHE.L2_DBUS0_ACS_MISS_CNT: L2-Cache bus0 Miss-Access Counter register
func (o *CACHE_Type) SetL2_DBUS0_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS0_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS0_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS0_ACS_MISS_CNT.Reg)
}

// CACHE.L2_DBUS0_ACS_CONFLICT_CNT: L2-Cache bus0 Conflict-Access Counter register
func (o *CACHE_Type) SetL2_DBUS0_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS0_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS0_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS0_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L2_DBUS0_ACS_NXTLVL_RD_CNT: L2-Cache bus0 Next-Level-Access Counter register
func (o *CACHE_Type) SetL2_DBUS0_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS0_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS0_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS0_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L2_DBUS0_ACS_NXTLVL_WR_CNT: L2-Cache bus0 WB-Access Counter register
func (o *CACHE_Type) SetL2_DBUS0_ACS_NXTLVL_WR_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS0_ACS_NXTLVL_WR_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS0_ACS_NXTLVL_WR_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS0_ACS_NXTLVL_WR_CNT.Reg)
}

// CACHE.L2_DBUS1_ACS_HIT_CNT: L2-Cache bus1 Hit-Access Counter register
func (o *CACHE_Type) SetL2_DBUS1_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS1_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS1_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS1_ACS_HIT_CNT.Reg)
}

// CACHE.L2_DBUS1_ACS_MISS_CNT: L2-Cache bus1 Miss-Access Counter register
func (o *CACHE_Type) SetL2_DBUS1_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS1_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS1_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS1_ACS_MISS_CNT.Reg)
}

// CACHE.L2_DBUS1_ACS_CONFLICT_CNT: L2-Cache bus1 Conflict-Access Counter register
func (o *CACHE_Type) SetL2_DBUS1_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS1_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS1_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS1_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L2_DBUS1_ACS_NXTLVL_RD_CNT: L2-Cache bus1 Next-Level-Access Counter register
func (o *CACHE_Type) SetL2_DBUS1_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS1_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS1_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS1_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L2_DBUS1_ACS_NXTLVL_WR_CNT: L2-Cache bus1 WB-Access Counter register
func (o *CACHE_Type) SetL2_DBUS1_ACS_NXTLVL_WR_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS1_ACS_NXTLVL_WR_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS1_ACS_NXTLVL_WR_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS1_ACS_NXTLVL_WR_CNT.Reg)
}

// CACHE.L2_DBUS2_ACS_HIT_CNT: L2-Cache bus2 Hit-Access Counter register
func (o *CACHE_Type) SetL2_DBUS2_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS2_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS2_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS2_ACS_HIT_CNT.Reg)
}

// CACHE.L2_DBUS2_ACS_MISS_CNT: L2-Cache bus2 Miss-Access Counter register
func (o *CACHE_Type) SetL2_DBUS2_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS2_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS2_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS2_ACS_MISS_CNT.Reg)
}

// CACHE.L2_DBUS2_ACS_CONFLICT_CNT: L2-Cache bus2 Conflict-Access Counter register
func (o *CACHE_Type) SetL2_DBUS2_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS2_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS2_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS2_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L2_DBUS2_ACS_NXTLVL_RD_CNT: L2-Cache bus2 Next-Level-Access Counter register
func (o *CACHE_Type) SetL2_DBUS2_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS2_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS2_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS2_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L2_DBUS2_ACS_NXTLVL_WR_CNT: L2-Cache bus2 WB-Access Counter register
func (o *CACHE_Type) SetL2_DBUS2_ACS_NXTLVL_WR_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS2_ACS_NXTLVL_WR_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS2_ACS_NXTLVL_WR_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS2_ACS_NXTLVL_WR_CNT.Reg)
}

// CACHE.L2_DBUS3_ACS_HIT_CNT: L2-Cache bus3 Hit-Access Counter register
func (o *CACHE_Type) SetL2_DBUS3_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS3_ACS_HIT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS3_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS3_ACS_HIT_CNT.Reg)
}

// CACHE.L2_DBUS3_ACS_MISS_CNT: L2-Cache bus3 Miss-Access Counter register
func (o *CACHE_Type) SetL2_DBUS3_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS3_ACS_MISS_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS3_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS3_ACS_MISS_CNT.Reg)
}

// CACHE.L2_DBUS3_ACS_CONFLICT_CNT: L2-Cache bus3 Conflict-Access Counter register
func (o *CACHE_Type) SetL2_DBUS3_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS3_ACS_CONFLICT_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS3_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS3_ACS_CONFLICT_CNT.Reg)
}

// CACHE.L2_DBUS3_ACS_NXTLVL_RD_CNT: L2-Cache bus3 Next-Level-Access Counter register
func (o *CACHE_Type) SetL2_DBUS3_ACS_NXTLVL_RD_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS3_ACS_NXTLVL_RD_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS3_ACS_NXTLVL_RD_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS3_ACS_NXTLVL_RD_CNT.Reg)
}

// CACHE.L2_DBUS3_ACS_NXTLVL_WR_CNT: L2-Cache bus3 WB-Access Counter register
func (o *CACHE_Type) SetL2_DBUS3_ACS_NXTLVL_WR_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS3_ACS_NXTLVL_WR_CNT.Reg, value)
}
func (o *CACHE_Type) GetL2_DBUS3_ACS_NXTLVL_WR_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS3_ACS_NXTLVL_WR_CNT.Reg)
}

// CACHE.L2_CACHE_ACS_FAIL_ID_ATTR: L2-Cache Access Fail ID/attribution information register
func (o *CACHE_Type) SetL2_CACHE_ACS_FAIL_ID_ATTR_L2_CACHE_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_FAIL_ID_ATTR_L2_CACHE_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *CACHE_Type) SetL2_CACHE_ACS_FAIL_ID_ATTR_L2_CACHE_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_FAIL_ID_ATTR_L2_CACHE_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// CACHE.L2_CACHE_ACS_FAIL_ADDR: L2-Cache Access Fail Address information register
func (o *CACHE_Type) SetL2_CACHE_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_ADDR.Reg, value)
}
func (o *CACHE_Type) GetL2_CACHE_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_ADDR.Reg)
}

// CACHE.L2_CACHE_SYNC_PRELOAD_INT_ENA: L1-Cache Access Fail Interrupt enable register
func (o *CACHE_Type) SetL2_CACHE_SYNC_PRELOAD_INT_ENA_L2_CACHE_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_SYNC_PRELOAD_INT_ENA_L2_CACHE_PLD_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL2_CACHE_SYNC_PRELOAD_INT_ENA_L2_CACHE_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_SYNC_PRELOAD_INT_ENA_L2_CACHE_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x1000) >> 12
}

// CACHE.L2_CACHE_SYNC_PRELOAD_INT_CLR: Sync Preload operation Interrupt clear register
func (o *CACHE_Type) SetL2_CACHE_SYNC_PRELOAD_INT_CLR_L2_CACHE_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_SYNC_PRELOAD_INT_CLR_L2_CACHE_PLD_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL2_CACHE_SYNC_PRELOAD_INT_CLR_L2_CACHE_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_SYNC_PRELOAD_INT_CLR_L2_CACHE_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x1000) >> 12
}

// CACHE.L2_CACHE_SYNC_PRELOAD_INT_RAW: Sync Preload operation Interrupt raw register
func (o *CACHE_Type) SetL2_CACHE_SYNC_PRELOAD_INT_RAW_L2_CACHE_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_SYNC_PRELOAD_INT_RAW_L2_CACHE_PLD_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL2_CACHE_SYNC_PRELOAD_INT_RAW_L2_CACHE_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_SYNC_PRELOAD_INT_RAW_L2_CACHE_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x1000) >> 12
}

// CACHE.L2_CACHE_SYNC_PRELOAD_INT_ST: L1-Cache Access Fail Interrupt status register
func (o *CACHE_Type) SetL2_CACHE_SYNC_PRELOAD_INT_ST_L2_CACHE_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_SYNC_PRELOAD_INT_ST_L2_CACHE_PLD_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL2_CACHE_SYNC_PRELOAD_INT_ST_L2_CACHE_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *CACHE_Type) GetL2_CACHE_SYNC_PRELOAD_INT_ST_L2_CACHE_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x1000) >> 12
}

// CACHE.L2_CACHE_SYNC_PRELOAD_EXCEPTION: Cache Sync/Preload Operation exception register
func (o *CACHE_Type) SetL2_CACHE_SYNC_PRELOAD_EXCEPTION_L2_CACHE_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_EXCEPTION.Reg)&^(0xc00)|value<<10)
}
func (o *CACHE_Type) GetL2_CACHE_SYNC_PRELOAD_EXCEPTION_L2_CACHE_PLD_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_EXCEPTION.Reg) & 0xc00) >> 10
}

// CACHE.L2_CACHE_SYNC_RST_CTRL: Cache Sync Reset control register
func (o *CACHE_Type) SetL2_CACHE_SYNC_RST_CTRL_L2_CACHE_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_RST_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_SYNC_RST_CTRL_L2_CACHE_SYNC_RST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_RST_CTRL.Reg) & 0x20) >> 5
}

// CACHE.L2_CACHE_PRELOAD_RST_CTRL: Cache Preload Reset control register
func (o *CACHE_Type) SetL2_CACHE_PRELOAD_RST_CTRL_L2_CACHE_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_PRELOAD_RST_CTRL_L2_CACHE_PLD_RST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOAD_RST_CTRL.Reg) & 0x20) >> 5
}

// CACHE.L2_CACHE_AUTOLOAD_BUF_CLR_CTRL: Cache Autoload buffer clear control register
func (o *CACHE_Type) SetL2_CACHE_AUTOLOAD_BUF_CLR_CTRL_L2_CACHE_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_AUTOLOAD_BUF_CLR_CTRL_L2_CACHE_ALD_BUF_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x20) >> 5
}

// CACHE.L2_UNALLOCATE_BUFFER_CLEAR: Unallocate request buffer clear registers
func (o *CACHE_Type) SetL2_UNALLOCATE_BUFFER_CLEAR_L2_CACHE_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L2_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_UNALLOCATE_BUFFER_CLEAR_L2_CACHE_UNALLOC_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x20) >> 5
}

// CACHE.L2_CACHE_ACCESS_ATTR_CTRL: L2 cache access attribute control register
func (o *CACHE_Type) SetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_CC(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_CC() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg) & 0x1
}
func (o *CACHE_Type) SetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_WB(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CACHE_Type) GetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_WB() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg) & 0x2) >> 1
}
func (o *CACHE_Type) SetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_WMA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CACHE_Type) GetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_WMA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg) & 0x4) >> 2
}
func (o *CACHE_Type) SetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_RMA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *CACHE_Type) GetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_RMA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg) & 0x8) >> 3
}

// CACHE.L2_CACHE_OBJECT_CTRL: Cache Tag and Data memory Object control register
func (o *CACHE_Type) SetL2_CACHE_OBJECT_CTRL_L2_CACHE_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_OBJECT_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *CACHE_Type) GetL2_CACHE_OBJECT_CTRL_L2_CACHE_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_OBJECT_CTRL.Reg) & 0x20) >> 5
}
func (o *CACHE_Type) SetL2_CACHE_OBJECT_CTRL_L2_CACHE_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_OBJECT_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CACHE_Type) GetL2_CACHE_OBJECT_CTRL_L2_CACHE_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_OBJECT_CTRL.Reg) & 0x800) >> 11
}

// CACHE.L2_CACHE_WAY_OBJECT: Cache Tag and Data memory way register
func (o *CACHE_Type) SetL2_CACHE_WAY_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_WAY_OBJECT.Reg, volatile.LoadUint32(&o.L2_CACHE_WAY_OBJECT.Reg)&^(0x7)|value)
}
func (o *CACHE_Type) GetL2_CACHE_WAY_OBJECT() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_WAY_OBJECT.Reg) & 0x7
}

// CACHE.L2_CACHE_VADDR: Cache Vaddr register
func (o *CACHE_Type) SetL2_CACHE_VADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_VADDR.Reg, value)
}
func (o *CACHE_Type) GetL2_CACHE_VADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_VADDR.Reg)
}

// CACHE.L2_CACHE_DEBUG_BUS: Cache Tag/data memory content register
func (o *CACHE_Type) SetL2_CACHE_DEBUG_BUS(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DEBUG_BUS.Reg, value)
}
func (o *CACHE_Type) GetL2_CACHE_DEBUG_BUS() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_DEBUG_BUS.Reg)
}

// CACHE.LEVEL_SPLIT1: USED TO SPLIT L1 CACHE AND L2 CACHE
func (o *CACHE_Type) SetLEVEL_SPLIT1(value uint32) {
	volatile.StoreUint32(&o.LEVEL_SPLIT1.Reg, value)
}
func (o *CACHE_Type) GetLEVEL_SPLIT1() uint32 {
	return volatile.LoadUint32(&o.LEVEL_SPLIT1.Reg)
}

// CACHE.CLOCK_GATE: Clock gate control register
func (o *CACHE_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *CACHE_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// CACHE.REDUNDANCY_SIG0: Cache redundancy signal 0 register
func (o *CACHE_Type) SetREDUNDANCY_SIG0(value uint32) {
	volatile.StoreUint32(&o.REDUNDANCY_SIG0.Reg, value)
}
func (o *CACHE_Type) GetREDUNDANCY_SIG0() uint32 {
	return volatile.LoadUint32(&o.REDUNDANCY_SIG0.Reg)
}

// CACHE.REDUNDANCY_SIG1: Cache redundancy signal 1 register
func (o *CACHE_Type) SetREDUNDANCY_SIG1(value uint32) {
	volatile.StoreUint32(&o.REDUNDANCY_SIG1.Reg, value)
}
func (o *CACHE_Type) GetREDUNDANCY_SIG1() uint32 {
	return volatile.LoadUint32(&o.REDUNDANCY_SIG1.Reg)
}

// CACHE.REDUNDANCY_SIG2: Cache redundancy signal 2 register
func (o *CACHE_Type) SetREDUNDANCY_SIG2(value uint32) {
	volatile.StoreUint32(&o.REDUNDANCY_SIG2.Reg, value)
}
func (o *CACHE_Type) GetREDUNDANCY_SIG2() uint32 {
	return volatile.LoadUint32(&o.REDUNDANCY_SIG2.Reg)
}

// CACHE.REDUNDANCY_SIG3: Cache redundancy signal 3 register
func (o *CACHE_Type) SetREDUNDANCY_SIG3(value uint32) {
	volatile.StoreUint32(&o.REDUNDANCY_SIG3.Reg, value)
}
func (o *CACHE_Type) GetREDUNDANCY_SIG3() uint32 {
	return volatile.LoadUint32(&o.REDUNDANCY_SIG3.Reg)
}

// CACHE.REDUNDANCY_SIG4: Cache redundancy signal 0 register
func (o *CACHE_Type) SetREDUNDANCY_SIG4_REDCY_SIG4(value uint32) {
	volatile.StoreUint32(&o.REDUNDANCY_SIG4.Reg, volatile.LoadUint32(&o.REDUNDANCY_SIG4.Reg)&^(0xf)|value)
}
func (o *CACHE_Type) GetREDUNDANCY_SIG4_REDCY_SIG4() uint32 {
	return volatile.LoadUint32(&o.REDUNDANCY_SIG4.Reg) & 0xf
}

// CACHE.DATE: Version control register
func (o *CACHE_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *CACHE_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// Interrupt Controller (Core 0)
type CORE0_Type struct {
	LP_RTC_INT_MAP                  volatile.Register32 // 0x0
	LP_WDT_INT_MAP                  volatile.Register32 // 0x4
	LP_TIMER_REG_0_INT_MAP          volatile.Register32 // 0x8
	LP_TIMER_REG_1_INT_MAP          volatile.Register32 // 0xC
	MB_HP_INT_MAP                   volatile.Register32 // 0x10
	MB_LP_INT_MAP                   volatile.Register32 // 0x14
	PMU_REG_0_INT_MAP               volatile.Register32 // 0x18
	PMU_REG_1_INT_MAP               volatile.Register32 // 0x1C
	LP_ANAPERI_INT_MAP              volatile.Register32 // 0x20
	LP_ADC_INT_MAP                  volatile.Register32 // 0x24
	LP_GPIO_INT_MAP                 volatile.Register32 // 0x28
	LP_I2C_INT_MAP                  volatile.Register32 // 0x2C
	LP_I2S_INT_MAP                  volatile.Register32 // 0x30
	LP_SPI_INT_MAP                  volatile.Register32 // 0x34
	LP_TOUCH_INT_MAP                volatile.Register32 // 0x38
	LP_TSENS_INT_MAP                volatile.Register32 // 0x3C
	LP_UART_INT_MAP                 volatile.Register32 // 0x40
	LP_EFUSE_INT_MAP                volatile.Register32 // 0x44
	LP_SW_INT_MAP                   volatile.Register32 // 0x48
	LP_SYSREG_INT_MAP               volatile.Register32 // 0x4C
	LP_HUK_INT_MAP                  volatile.Register32 // 0x50
	SYS_ICM_INT_MAP                 volatile.Register32 // 0x54
	USB_DEVICE_INT_MAP              volatile.Register32 // 0x58
	SDIO_HOST_INT_MAP               volatile.Register32 // 0x5C
	GDMA_INT_MAP                    volatile.Register32 // 0x60
	SPI2_INT_MAP                    volatile.Register32 // 0x64
	SPI3_INT_MAP                    volatile.Register32 // 0x68
	I2S0_INT_MAP                    volatile.Register32 // 0x6C
	I2S1_INT_MAP                    volatile.Register32 // 0x70
	I2S2_INT_MAP                    volatile.Register32 // 0x74
	UHCI0_INT_MAP                   volatile.Register32 // 0x78
	UART0_INT_MAP                   volatile.Register32 // 0x7C
	UART1_INT_MAP                   volatile.Register32 // 0x80
	UART2_INT_MAP                   volatile.Register32 // 0x84
	UART3_INT_MAP                   volatile.Register32 // 0x88
	UART4_INT_MAP                   volatile.Register32 // 0x8C
	LCD_CAM_INT_MAP                 volatile.Register32 // 0x90
	ADC_INT_MAP                     volatile.Register32 // 0x94
	PWM0_INT_MAP                    volatile.Register32 // 0x98
	PWM1_INT_MAP                    volatile.Register32 // 0x9C
	CAN0_INT_MAP                    volatile.Register32 // 0xA0
	CAN1_INT_MAP                    volatile.Register32 // 0xA4
	CAN2_INT_MAP                    volatile.Register32 // 0xA8
	RMT_INT_MAP                     volatile.Register32 // 0xAC
	I2C0_INT_MAP                    volatile.Register32 // 0xB0
	I2C1_INT_MAP                    volatile.Register32 // 0xB4
	TIMERGRP0_T0_INT_MAP            volatile.Register32 // 0xB8
	TIMERGRP0_T1_INT_MAP            volatile.Register32 // 0xBC
	TIMERGRP0_WDT_INT_MAP           volatile.Register32 // 0xC0
	TIMERGRP1_T0_INT_MAP            volatile.Register32 // 0xC4
	TIMERGRP1_T1_INT_MAP            volatile.Register32 // 0xC8
	TIMERGRP1_WDT_INT_MAP           volatile.Register32 // 0xCC
	LEDC_INT_MAP                    volatile.Register32 // 0xD0
	SYSTIMER_TARGET0_INT_MAP        volatile.Register32 // 0xD4
	SYSTIMER_TARGET1_INT_MAP        volatile.Register32 // 0xD8
	SYSTIMER_TARGET2_INT_MAP        volatile.Register32 // 0xDC
	AHB_PDMA_IN_CH0_INT_MAP         volatile.Register32 // 0xE0
	AHB_PDMA_IN_CH1_INT_MAP         volatile.Register32 // 0xE4
	AHB_PDMA_IN_CH2_INT_MAP         volatile.Register32 // 0xE8
	AHB_PDMA_OUT_CH0_INT_MAP        volatile.Register32 // 0xEC
	AHB_PDMA_OUT_CH1_INT_MAP        volatile.Register32 // 0xF0
	AHB_PDMA_OUT_CH2_INT_MAP        volatile.Register32 // 0xF4
	AXI_PDMA_IN_CH0_INT_MAP         volatile.Register32 // 0xF8
	AXI_PDMA_IN_CH1_INT_MAP         volatile.Register32 // 0xFC
	AXI_PDMA_IN_CH2_INT_MAP         volatile.Register32 // 0x100
	AXI_PDMA_OUT_CH0_INT_MAP        volatile.Register32 // 0x104
	AXI_PDMA_OUT_CH1_INT_MAP        volatile.Register32 // 0x108
	AXI_PDMA_OUT_CH2_INT_MAP        volatile.Register32 // 0x10C
	RSA_INT_MAP                     volatile.Register32 // 0x110
	AES_INT_MAP                     volatile.Register32 // 0x114
	SHA_INT_MAP                     volatile.Register32 // 0x118
	ECC_INT_MAP                     volatile.Register32 // 0x11C
	ECDSA_INT_MAP                   volatile.Register32 // 0x120
	KM_INT_MAP                      volatile.Register32 // 0x124
	GPIO_INT0_MAP                   volatile.Register32 // 0x128
	GPIO_INT1_MAP                   volatile.Register32 // 0x12C
	GPIO_INT2_MAP                   volatile.Register32 // 0x130
	GPIO_INT3_MAP                   volatile.Register32 // 0x134
	GPIO_PAD_COMP_INT_MAP           volatile.Register32 // 0x138
	CPU_INT_FROM_CPU_0_MAP          volatile.Register32 // 0x13C
	CPU_INT_FROM_CPU_1_MAP          volatile.Register32 // 0x140
	CPU_INT_FROM_CPU_2_MAP          volatile.Register32 // 0x144
	CPU_INT_FROM_CPU_3_MAP          volatile.Register32 // 0x148
	CACHE_INT_MAP                   volatile.Register32 // 0x14C
	FLASH_MSPI_INT_MAP              volatile.Register32 // 0x150
	CSI_BRIDGE_INT_MAP              volatile.Register32 // 0x154
	DSI_BRIDGE_INT_MAP              volatile.Register32 // 0x158
	CSI_INT_MAP                     volatile.Register32 // 0x15C
	DSI_INT_MAP                     volatile.Register32 // 0x160
	GMII_PHY_INT_MAP                volatile.Register32 // 0x164
	LPI_INT_MAP                     volatile.Register32 // 0x168
	PMT_INT_MAP                     volatile.Register32 // 0x16C
	SBD_INT_MAP                     volatile.Register32 // 0x170
	USB_OTG_INT_MAP                 volatile.Register32 // 0x174
	USB_OTG_ENDP_MULTI_PROC_INT_MAP volatile.Register32 // 0x178
	JPEG_INT_MAP                    volatile.Register32 // 0x17C
	PPA_INT_MAP                     volatile.Register32 // 0x180
	CORE0_TRACE_INT_MAP             volatile.Register32 // 0x184
	CORE1_TRACE_INT_MAP             volatile.Register32 // 0x188
	HP_CORE_CTRL_INT_MAP            volatile.Register32 // 0x18C
	ISP_INT_MAP                     volatile.Register32 // 0x190
	I3C_MST_INT_MAP                 volatile.Register32 // 0x194
	I3C_SLV_INT_MAP                 volatile.Register32 // 0x198
	USB_OTG11_INT_MAP               volatile.Register32 // 0x19C
	DMA2D_IN_CH0_INT_MAP            volatile.Register32 // 0x1A0
	DMA2D_IN_CH1_INT_MAP            volatile.Register32 // 0x1A4
	DMA2D_OUT_CH0_INT_MAP           volatile.Register32 // 0x1A8
	DMA2D_OUT_CH1_INT_MAP           volatile.Register32 // 0x1AC
	DMA2D_OUT_CH2_INT_MAP           volatile.Register32 // 0x1B0
	PSRAM_MSPI_INT_MAP              volatile.Register32 // 0x1B4
	HP_SYSREG_INT_MAP               volatile.Register32 // 0x1B8
	PCNT_INT_MAP                    volatile.Register32 // 0x1BC
	HP_PAU_INT_MAP                  volatile.Register32 // 0x1C0
	HP_PARLIO_RX_INT_MAP            volatile.Register32 // 0x1C4
	HP_PARLIO_TX_INT_MAP            volatile.Register32 // 0x1C8
	H264_DMA2D_OUT_CH0_INT_MAP      volatile.Register32 // 0x1CC
	H264_DMA2D_OUT_CH1_INT_MAP      volatile.Register32 // 0x1D0
	H264_DMA2D_OUT_CH2_INT_MAP      volatile.Register32 // 0x1D4
	H264_DMA2D_OUT_CH3_INT_MAP      volatile.Register32 // 0x1D8
	H264_DMA2D_OUT_CH4_INT_MAP      volatile.Register32 // 0x1DC
	H264_DMA2D_IN_CH0_INT_MAP       volatile.Register32 // 0x1E0
	H264_DMA2D_IN_CH1_INT_MAP       volatile.Register32 // 0x1E4
	H264_DMA2D_IN_CH2_INT_MAP       volatile.Register32 // 0x1E8
	H264_DMA2D_IN_CH3_INT_MAP       volatile.Register32 // 0x1EC
	H264_DMA2D_IN_CH4_INT_MAP       volatile.Register32 // 0x1F0
	H264_DMA2D_IN_CH5_INT_MAP       volatile.Register32 // 0x1F4
	H264_REG_INT_MAP                volatile.Register32 // 0x1F8
	ASSIST_DEBUG_INT_MAP            volatile.Register32 // 0x1FC
	INTR_STATUS_REG_0               volatile.Register32 // 0x200
	INTR_STATUS_REG_1               volatile.Register32 // 0x204
	INTR_STATUS_REG_2               volatile.Register32 // 0x208
	INTR_STATUS_REG_3               volatile.Register32 // 0x20C
	CLOCK_GATE                      volatile.Register32 // 0x210
	_                               [488]byte
	INTERRUPT_REG_DATE              volatile.Register32 // 0x3FC
}

// CORE0.LP_RTC_INT_MAP: NA
func (o *CORE0_Type) SetLP_RTC_INT_MAP_CORE0_LP_RTC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_RTC_INT_MAP.Reg, volatile.LoadUint32(&o.LP_RTC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_RTC_INT_MAP_CORE0_LP_RTC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_RTC_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_WDT_INT_MAP: NA
func (o *CORE0_Type) SetLP_WDT_INT_MAP_CORE0_LP_WDT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_WDT_INT_MAP.Reg, volatile.LoadUint32(&o.LP_WDT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_WDT_INT_MAP_CORE0_LP_WDT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_WDT_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_TIMER_REG_0_INT_MAP: NA
func (o *CORE0_Type) SetLP_TIMER_REG_0_INT_MAP_CORE0_LP_TIMER_REG_0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_TIMER_REG_0_INT_MAP.Reg, volatile.LoadUint32(&o.LP_TIMER_REG_0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_TIMER_REG_0_INT_MAP_CORE0_LP_TIMER_REG_0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_TIMER_REG_0_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_TIMER_REG_1_INT_MAP: NA
func (o *CORE0_Type) SetLP_TIMER_REG_1_INT_MAP_CORE0_LP_TIMER_REG_1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_TIMER_REG_1_INT_MAP.Reg, volatile.LoadUint32(&o.LP_TIMER_REG_1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_TIMER_REG_1_INT_MAP_CORE0_LP_TIMER_REG_1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_TIMER_REG_1_INT_MAP.Reg) & 0x3f
}

// CORE0.MB_HP_INT_MAP: NA
func (o *CORE0_Type) SetMB_HP_INT_MAP_CORE0_MB_HP_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.MB_HP_INT_MAP.Reg, volatile.LoadUint32(&o.MB_HP_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetMB_HP_INT_MAP_CORE0_MB_HP_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.MB_HP_INT_MAP.Reg) & 0x3f
}

// CORE0.MB_LP_INT_MAP: NA
func (o *CORE0_Type) SetMB_LP_INT_MAP_CORE0_MB_LP_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.MB_LP_INT_MAP.Reg, volatile.LoadUint32(&o.MB_LP_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetMB_LP_INT_MAP_CORE0_MB_LP_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.MB_LP_INT_MAP.Reg) & 0x3f
}

// CORE0.PMU_REG_0_INT_MAP: NA
func (o *CORE0_Type) SetPMU_REG_0_INT_MAP_CORE0_PMU_REG_0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PMU_REG_0_INT_MAP.Reg, volatile.LoadUint32(&o.PMU_REG_0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetPMU_REG_0_INT_MAP_CORE0_PMU_REG_0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PMU_REG_0_INT_MAP.Reg) & 0x3f
}

// CORE0.PMU_REG_1_INT_MAP: NA
func (o *CORE0_Type) SetPMU_REG_1_INT_MAP_CORE0_PMU_REG_1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PMU_REG_1_INT_MAP.Reg, volatile.LoadUint32(&o.PMU_REG_1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetPMU_REG_1_INT_MAP_CORE0_PMU_REG_1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PMU_REG_1_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_ANAPERI_INT_MAP: NA
func (o *CORE0_Type) SetLP_ANAPERI_INT_MAP_CORE0_LP_ANAPERI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_ANAPERI_INT_MAP.Reg, volatile.LoadUint32(&o.LP_ANAPERI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_ANAPERI_INT_MAP_CORE0_LP_ANAPERI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_ANAPERI_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_ADC_INT_MAP: NA
func (o *CORE0_Type) SetLP_ADC_INT_MAP_CORE0_LP_ADC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_ADC_INT_MAP.Reg, volatile.LoadUint32(&o.LP_ADC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_ADC_INT_MAP_CORE0_LP_ADC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_ADC_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_GPIO_INT_MAP: NA
func (o *CORE0_Type) SetLP_GPIO_INT_MAP_CORE0_LP_GPIO_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_GPIO_INT_MAP.Reg, volatile.LoadUint32(&o.LP_GPIO_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_GPIO_INT_MAP_CORE0_LP_GPIO_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_GPIO_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_I2C_INT_MAP: NA
func (o *CORE0_Type) SetLP_I2C_INT_MAP_CORE0_LP_I2C_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_I2C_INT_MAP.Reg, volatile.LoadUint32(&o.LP_I2C_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_I2C_INT_MAP_CORE0_LP_I2C_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_I2C_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_I2S_INT_MAP: NA
func (o *CORE0_Type) SetLP_I2S_INT_MAP_CORE0_LP_I2S_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_I2S_INT_MAP.Reg, volatile.LoadUint32(&o.LP_I2S_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_I2S_INT_MAP_CORE0_LP_I2S_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_I2S_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_SPI_INT_MAP: NA
func (o *CORE0_Type) SetLP_SPI_INT_MAP_CORE0_LP_SPI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_SPI_INT_MAP.Reg, volatile.LoadUint32(&o.LP_SPI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_SPI_INT_MAP_CORE0_LP_SPI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_SPI_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_TOUCH_INT_MAP: NA
func (o *CORE0_Type) SetLP_TOUCH_INT_MAP_CORE0_LP_TOUCH_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_TOUCH_INT_MAP.Reg, volatile.LoadUint32(&o.LP_TOUCH_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_TOUCH_INT_MAP_CORE0_LP_TOUCH_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_TOUCH_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_TSENS_INT_MAP: NA
func (o *CORE0_Type) SetLP_TSENS_INT_MAP_CORE0_LP_TSENS_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_TSENS_INT_MAP.Reg, volatile.LoadUint32(&o.LP_TSENS_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_TSENS_INT_MAP_CORE0_LP_TSENS_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_TSENS_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_UART_INT_MAP: NA
func (o *CORE0_Type) SetLP_UART_INT_MAP_CORE0_LP_UART_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_UART_INT_MAP.Reg, volatile.LoadUint32(&o.LP_UART_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_UART_INT_MAP_CORE0_LP_UART_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_UART_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_EFUSE_INT_MAP: NA
func (o *CORE0_Type) SetLP_EFUSE_INT_MAP_CORE0_LP_EFUSE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_EFUSE_INT_MAP.Reg, volatile.LoadUint32(&o.LP_EFUSE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_EFUSE_INT_MAP_CORE0_LP_EFUSE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_EFUSE_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_SW_INT_MAP: NA
func (o *CORE0_Type) SetLP_SW_INT_MAP_CORE0_LP_SW_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_SW_INT_MAP.Reg, volatile.LoadUint32(&o.LP_SW_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_SW_INT_MAP_CORE0_LP_SW_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_SW_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_SYSREG_INT_MAP: NA
func (o *CORE0_Type) SetLP_SYSREG_INT_MAP_CORE0_LP_SYSREG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_SYSREG_INT_MAP.Reg, volatile.LoadUint32(&o.LP_SYSREG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_SYSREG_INT_MAP_CORE0_LP_SYSREG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_SYSREG_INT_MAP.Reg) & 0x3f
}

// CORE0.LP_HUK_INT_MAP: NA
func (o *CORE0_Type) SetLP_HUK_INT_MAP_CORE0_LP_HUK_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_HUK_INT_MAP.Reg, volatile.LoadUint32(&o.LP_HUK_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLP_HUK_INT_MAP_CORE0_LP_HUK_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_HUK_INT_MAP.Reg) & 0x3f
}

// CORE0.SYS_ICM_INT_MAP: NA
func (o *CORE0_Type) SetSYS_ICM_INT_MAP_CORE0_SYS_ICM_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYS_ICM_INT_MAP.Reg, volatile.LoadUint32(&o.SYS_ICM_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetSYS_ICM_INT_MAP_CORE0_SYS_ICM_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYS_ICM_INT_MAP.Reg) & 0x3f
}

// CORE0.USB_DEVICE_INT_MAP: NA
func (o *CORE0_Type) SetUSB_DEVICE_INT_MAP_CORE0_USB_DEVICE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.USB_DEVICE_INT_MAP.Reg, volatile.LoadUint32(&o.USB_DEVICE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetUSB_DEVICE_INT_MAP_CORE0_USB_DEVICE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.USB_DEVICE_INT_MAP.Reg) & 0x3f
}

// CORE0.SDIO_HOST_INT_MAP: NA
func (o *CORE0_Type) SetSDIO_HOST_INT_MAP_CORE0_SDIO_HOST_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SDIO_HOST_INT_MAP.Reg, volatile.LoadUint32(&o.SDIO_HOST_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetSDIO_HOST_INT_MAP_CORE0_SDIO_HOST_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SDIO_HOST_INT_MAP.Reg) & 0x3f
}

// CORE0.GDMA_INT_MAP: NA
func (o *CORE0_Type) SetGDMA_INT_MAP_CORE0_GDMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.GDMA_INT_MAP.Reg, volatile.LoadUint32(&o.GDMA_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetGDMA_INT_MAP_CORE0_GDMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.GDMA_INT_MAP.Reg) & 0x3f
}

// CORE0.SPI2_INT_MAP: NA
func (o *CORE0_Type) SetSPI2_INT_MAP_CORE0_SPI2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SPI2_INT_MAP.Reg, volatile.LoadUint32(&o.SPI2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetSPI2_INT_MAP_CORE0_SPI2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SPI2_INT_MAP.Reg) & 0x3f
}

// CORE0.SPI3_INT_MAP: NA
func (o *CORE0_Type) SetSPI3_INT_MAP_CORE0_SPI3_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SPI3_INT_MAP.Reg, volatile.LoadUint32(&o.SPI3_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetSPI3_INT_MAP_CORE0_SPI3_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SPI3_INT_MAP.Reg) & 0x3f
}

// CORE0.I2S0_INT_MAP: NA
func (o *CORE0_Type) SetI2S0_INT_MAP_CORE0_I2S0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2S0_INT_MAP.Reg, volatile.LoadUint32(&o.I2S0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetI2S0_INT_MAP_CORE0_I2S0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2S0_INT_MAP.Reg) & 0x3f
}

// CORE0.I2S1_INT_MAP: NA
func (o *CORE0_Type) SetI2S1_INT_MAP_CORE0_I2S1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2S1_INT_MAP.Reg, volatile.LoadUint32(&o.I2S1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetI2S1_INT_MAP_CORE0_I2S1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2S1_INT_MAP.Reg) & 0x3f
}

// CORE0.I2S2_INT_MAP: NA
func (o *CORE0_Type) SetI2S2_INT_MAP_CORE0_I2S2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2S2_INT_MAP.Reg, volatile.LoadUint32(&o.I2S2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetI2S2_INT_MAP_CORE0_I2S2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2S2_INT_MAP.Reg) & 0x3f
}

// CORE0.UHCI0_INT_MAP: NA
func (o *CORE0_Type) SetUHCI0_INT_MAP_CORE0_UHCI0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UHCI0_INT_MAP.Reg, volatile.LoadUint32(&o.UHCI0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetUHCI0_INT_MAP_CORE0_UHCI0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UHCI0_INT_MAP.Reg) & 0x3f
}

// CORE0.UART0_INT_MAP: NA
func (o *CORE0_Type) SetUART0_INT_MAP_CORE0_UART0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UART0_INT_MAP.Reg, volatile.LoadUint32(&o.UART0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetUART0_INT_MAP_CORE0_UART0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UART0_INT_MAP.Reg) & 0x3f
}

// CORE0.UART1_INT_MAP: NA
func (o *CORE0_Type) SetUART1_INT_MAP_CORE0_UART1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UART1_INT_MAP.Reg, volatile.LoadUint32(&o.UART1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetUART1_INT_MAP_CORE0_UART1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UART1_INT_MAP.Reg) & 0x3f
}

// CORE0.UART2_INT_MAP: NA
func (o *CORE0_Type) SetUART2_INT_MAP_CORE0_UART2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UART2_INT_MAP.Reg, volatile.LoadUint32(&o.UART2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetUART2_INT_MAP_CORE0_UART2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UART2_INT_MAP.Reg) & 0x3f
}

// CORE0.UART3_INT_MAP: NA
func (o *CORE0_Type) SetUART3_INT_MAP_CORE0_UART3_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UART3_INT_MAP.Reg, volatile.LoadUint32(&o.UART3_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetUART3_INT_MAP_CORE0_UART3_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UART3_INT_MAP.Reg) & 0x3f
}

// CORE0.UART4_INT_MAP: NA
func (o *CORE0_Type) SetUART4_INT_MAP_CORE0_UART4_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UART4_INT_MAP.Reg, volatile.LoadUint32(&o.UART4_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetUART4_INT_MAP_CORE0_UART4_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UART4_INT_MAP.Reg) & 0x3f
}

// CORE0.LCD_CAM_INT_MAP: NA
func (o *CORE0_Type) SetLCD_CAM_INT_MAP_CORE0_LCD_CAM_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LCD_CAM_INT_MAP.Reg, volatile.LoadUint32(&o.LCD_CAM_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLCD_CAM_INT_MAP_CORE0_LCD_CAM_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LCD_CAM_INT_MAP.Reg) & 0x3f
}

// CORE0.ADC_INT_MAP: NA
func (o *CORE0_Type) SetADC_INT_MAP_CORE0_ADC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ADC_INT_MAP.Reg, volatile.LoadUint32(&o.ADC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetADC_INT_MAP_CORE0_ADC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ADC_INT_MAP.Reg) & 0x3f
}

// CORE0.PWM0_INT_MAP: NA
func (o *CORE0_Type) SetPWM0_INT_MAP_CORE0_PWM0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PWM0_INT_MAP.Reg, volatile.LoadUint32(&o.PWM0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetPWM0_INT_MAP_CORE0_PWM0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PWM0_INT_MAP.Reg) & 0x3f
}

// CORE0.PWM1_INT_MAP: NA
func (o *CORE0_Type) SetPWM1_INT_MAP_CORE0_PWM1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PWM1_INT_MAP.Reg, volatile.LoadUint32(&o.PWM1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetPWM1_INT_MAP_CORE0_PWM1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PWM1_INT_MAP.Reg) & 0x3f
}

// CORE0.CAN0_INT_MAP: NA
func (o *CORE0_Type) SetCAN0_INT_MAP_CORE0_CAN0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CAN0_INT_MAP.Reg, volatile.LoadUint32(&o.CAN0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCAN0_INT_MAP_CORE0_CAN0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CAN0_INT_MAP.Reg) & 0x3f
}

// CORE0.CAN1_INT_MAP: NA
func (o *CORE0_Type) SetCAN1_INT_MAP_CORE0_CAN1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CAN1_INT_MAP.Reg, volatile.LoadUint32(&o.CAN1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCAN1_INT_MAP_CORE0_CAN1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CAN1_INT_MAP.Reg) & 0x3f
}

// CORE0.CAN2_INT_MAP: NA
func (o *CORE0_Type) SetCAN2_INT_MAP_CORE0_CAN2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CAN2_INT_MAP.Reg, volatile.LoadUint32(&o.CAN2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCAN2_INT_MAP_CORE0_CAN2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CAN2_INT_MAP.Reg) & 0x3f
}

// CORE0.RMT_INT_MAP: NA
func (o *CORE0_Type) SetRMT_INT_MAP_CORE0_RMT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.RMT_INT_MAP.Reg, volatile.LoadUint32(&o.RMT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetRMT_INT_MAP_CORE0_RMT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.RMT_INT_MAP.Reg) & 0x3f
}

// CORE0.I2C0_INT_MAP: NA
func (o *CORE0_Type) SetI2C0_INT_MAP_CORE0_I2C0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2C0_INT_MAP.Reg, volatile.LoadUint32(&o.I2C0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetI2C0_INT_MAP_CORE0_I2C0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2C0_INT_MAP.Reg) & 0x3f
}

// CORE0.I2C1_INT_MAP: NA
func (o *CORE0_Type) SetI2C1_INT_MAP_CORE0_I2C1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2C1_INT_MAP.Reg, volatile.LoadUint32(&o.I2C1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetI2C1_INT_MAP_CORE0_I2C1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2C1_INT_MAP.Reg) & 0x3f
}

// CORE0.TIMERGRP0_T0_INT_MAP: NA
func (o *CORE0_Type) SetTIMERGRP0_T0_INT_MAP_CORE0_TIMERGRP0_T0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP0_T0_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP0_T0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetTIMERGRP0_T0_INT_MAP_CORE0_TIMERGRP0_T0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP0_T0_INT_MAP.Reg) & 0x3f
}

// CORE0.TIMERGRP0_T1_INT_MAP: NA
func (o *CORE0_Type) SetTIMERGRP0_T1_INT_MAP_CORE0_TIMERGRP0_T1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP0_T1_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP0_T1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetTIMERGRP0_T1_INT_MAP_CORE0_TIMERGRP0_T1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP0_T1_INT_MAP.Reg) & 0x3f
}

// CORE0.TIMERGRP0_WDT_INT_MAP: NA
func (o *CORE0_Type) SetTIMERGRP0_WDT_INT_MAP_CORE0_TIMERGRP0_WDT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP0_WDT_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP0_WDT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetTIMERGRP0_WDT_INT_MAP_CORE0_TIMERGRP0_WDT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP0_WDT_INT_MAP.Reg) & 0x3f
}

// CORE0.TIMERGRP1_T0_INT_MAP: NA
func (o *CORE0_Type) SetTIMERGRP1_T0_INT_MAP_CORE0_TIMERGRP1_T0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP1_T0_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP1_T0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetTIMERGRP1_T0_INT_MAP_CORE0_TIMERGRP1_T0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP1_T0_INT_MAP.Reg) & 0x3f
}

// CORE0.TIMERGRP1_T1_INT_MAP: NA
func (o *CORE0_Type) SetTIMERGRP1_T1_INT_MAP_CORE0_TIMERGRP1_T1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP1_T1_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP1_T1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetTIMERGRP1_T1_INT_MAP_CORE0_TIMERGRP1_T1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP1_T1_INT_MAP.Reg) & 0x3f
}

// CORE0.TIMERGRP1_WDT_INT_MAP: NA
func (o *CORE0_Type) SetTIMERGRP1_WDT_INT_MAP_CORE0_TIMERGRP1_WDT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP1_WDT_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP1_WDT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetTIMERGRP1_WDT_INT_MAP_CORE0_TIMERGRP1_WDT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP1_WDT_INT_MAP.Reg) & 0x3f
}

// CORE0.LEDC_INT_MAP: NA
func (o *CORE0_Type) SetLEDC_INT_MAP_CORE0_LEDC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LEDC_INT_MAP.Reg, volatile.LoadUint32(&o.LEDC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLEDC_INT_MAP_CORE0_LEDC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LEDC_INT_MAP.Reg) & 0x3f
}

// CORE0.SYSTIMER_TARGET0_INT_MAP: NA
func (o *CORE0_Type) SetSYSTIMER_TARGET0_INT_MAP_CORE0_SYSTIMER_TARGET0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetSYSTIMER_TARGET0_INT_MAP_CORE0_SYSTIMER_TARGET0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg) & 0x3f
}

// CORE0.SYSTIMER_TARGET1_INT_MAP: NA
func (o *CORE0_Type) SetSYSTIMER_TARGET1_INT_MAP_CORE0_SYSTIMER_TARGET1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetSYSTIMER_TARGET1_INT_MAP_CORE0_SYSTIMER_TARGET1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg) & 0x3f
}

// CORE0.SYSTIMER_TARGET2_INT_MAP: NA
func (o *CORE0_Type) SetSYSTIMER_TARGET2_INT_MAP_CORE0_SYSTIMER_TARGET2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetSYSTIMER_TARGET2_INT_MAP_CORE0_SYSTIMER_TARGET2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg) & 0x3f
}

// CORE0.AHB_PDMA_IN_CH0_INT_MAP: NA
func (o *CORE0_Type) SetAHB_PDMA_IN_CH0_INT_MAP_CORE0_AHB_PDMA_IN_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_IN_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_IN_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAHB_PDMA_IN_CH0_INT_MAP_CORE0_AHB_PDMA_IN_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_IN_CH0_INT_MAP.Reg) & 0x3f
}

// CORE0.AHB_PDMA_IN_CH1_INT_MAP: NA
func (o *CORE0_Type) SetAHB_PDMA_IN_CH1_INT_MAP_CORE0_AHB_PDMA_IN_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_IN_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_IN_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAHB_PDMA_IN_CH1_INT_MAP_CORE0_AHB_PDMA_IN_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_IN_CH1_INT_MAP.Reg) & 0x3f
}

// CORE0.AHB_PDMA_IN_CH2_INT_MAP: NA
func (o *CORE0_Type) SetAHB_PDMA_IN_CH2_INT_MAP_CORE0_AHB_PDMA_IN_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_IN_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_IN_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAHB_PDMA_IN_CH2_INT_MAP_CORE0_AHB_PDMA_IN_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_IN_CH2_INT_MAP.Reg) & 0x3f
}

// CORE0.AHB_PDMA_OUT_CH0_INT_MAP: NA
func (o *CORE0_Type) SetAHB_PDMA_OUT_CH0_INT_MAP_CORE0_AHB_PDMA_OUT_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_OUT_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_OUT_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAHB_PDMA_OUT_CH0_INT_MAP_CORE0_AHB_PDMA_OUT_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_OUT_CH0_INT_MAP.Reg) & 0x3f
}

// CORE0.AHB_PDMA_OUT_CH1_INT_MAP: NA
func (o *CORE0_Type) SetAHB_PDMA_OUT_CH1_INT_MAP_CORE0_AHB_PDMA_OUT_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_OUT_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_OUT_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAHB_PDMA_OUT_CH1_INT_MAP_CORE0_AHB_PDMA_OUT_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_OUT_CH1_INT_MAP.Reg) & 0x3f
}

// CORE0.AHB_PDMA_OUT_CH2_INT_MAP: NA
func (o *CORE0_Type) SetAHB_PDMA_OUT_CH2_INT_MAP_CORE0_AHB_PDMA_OUT_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_OUT_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_OUT_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAHB_PDMA_OUT_CH2_INT_MAP_CORE0_AHB_PDMA_OUT_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_OUT_CH2_INT_MAP.Reg) & 0x3f
}

// CORE0.AXI_PDMA_IN_CH0_INT_MAP: NA
func (o *CORE0_Type) SetAXI_PDMA_IN_CH0_INT_MAP_CORE0_AXI_PDMA_IN_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_IN_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_IN_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAXI_PDMA_IN_CH0_INT_MAP_CORE0_AXI_PDMA_IN_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_IN_CH0_INT_MAP.Reg) & 0x3f
}

// CORE0.AXI_PDMA_IN_CH1_INT_MAP: NA
func (o *CORE0_Type) SetAXI_PDMA_IN_CH1_INT_MAP_CORE0_AXI_PDMA_IN_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_IN_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_IN_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAXI_PDMA_IN_CH1_INT_MAP_CORE0_AXI_PDMA_IN_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_IN_CH1_INT_MAP.Reg) & 0x3f
}

// CORE0.AXI_PDMA_IN_CH2_INT_MAP: NA
func (o *CORE0_Type) SetAXI_PDMA_IN_CH2_INT_MAP_CORE0_AXI_PDMA_IN_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_IN_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_IN_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAXI_PDMA_IN_CH2_INT_MAP_CORE0_AXI_PDMA_IN_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_IN_CH2_INT_MAP.Reg) & 0x3f
}

// CORE0.AXI_PDMA_OUT_CH0_INT_MAP: NA
func (o *CORE0_Type) SetAXI_PDMA_OUT_CH0_INT_MAP_CORE0_AXI_PDMA_OUT_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_OUT_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_OUT_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAXI_PDMA_OUT_CH0_INT_MAP_CORE0_AXI_PDMA_OUT_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_OUT_CH0_INT_MAP.Reg) & 0x3f
}

// CORE0.AXI_PDMA_OUT_CH1_INT_MAP: NA
func (o *CORE0_Type) SetAXI_PDMA_OUT_CH1_INT_MAP_CORE0_AXI_PDMA_OUT_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_OUT_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_OUT_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAXI_PDMA_OUT_CH1_INT_MAP_CORE0_AXI_PDMA_OUT_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_OUT_CH1_INT_MAP.Reg) & 0x3f
}

// CORE0.AXI_PDMA_OUT_CH2_INT_MAP: NA
func (o *CORE0_Type) SetAXI_PDMA_OUT_CH2_INT_MAP_CORE0_AXI_PDMA_OUT_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_OUT_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_OUT_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAXI_PDMA_OUT_CH2_INT_MAP_CORE0_AXI_PDMA_OUT_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_OUT_CH2_INT_MAP.Reg) & 0x3f
}

// CORE0.RSA_INT_MAP: NA
func (o *CORE0_Type) SetRSA_INT_MAP_CORE0_RSA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.RSA_INT_MAP.Reg, volatile.LoadUint32(&o.RSA_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetRSA_INT_MAP_CORE0_RSA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.RSA_INT_MAP.Reg) & 0x3f
}

// CORE0.AES_INT_MAP: NA
func (o *CORE0_Type) SetAES_INT_MAP_CORE0_AES_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AES_INT_MAP.Reg, volatile.LoadUint32(&o.AES_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetAES_INT_MAP_CORE0_AES_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AES_INT_MAP.Reg) & 0x3f
}

// CORE0.SHA_INT_MAP: NA
func (o *CORE0_Type) SetSHA_INT_MAP_CORE0_SHA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SHA_INT_MAP.Reg, volatile.LoadUint32(&o.SHA_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetSHA_INT_MAP_CORE0_SHA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SHA_INT_MAP.Reg) & 0x3f
}

// CORE0.ECC_INT_MAP: NA
func (o *CORE0_Type) SetECC_INT_MAP_CORE0_ECC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ECC_INT_MAP.Reg, volatile.LoadUint32(&o.ECC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetECC_INT_MAP_CORE0_ECC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ECC_INT_MAP.Reg) & 0x3f
}

// CORE0.ECDSA_INT_MAP: NA
func (o *CORE0_Type) SetECDSA_INT_MAP_CORE0_ECDSA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ECDSA_INT_MAP.Reg, volatile.LoadUint32(&o.ECDSA_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetECDSA_INT_MAP_CORE0_ECDSA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ECDSA_INT_MAP.Reg) & 0x3f
}

// CORE0.KM_INT_MAP: NA
func (o *CORE0_Type) SetKM_INT_MAP_CORE0_KM_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.KM_INT_MAP.Reg, volatile.LoadUint32(&o.KM_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetKM_INT_MAP_CORE0_KM_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.KM_INT_MAP.Reg) & 0x3f
}

// CORE0.GPIO_INT0_MAP: NA
func (o *CORE0_Type) SetGPIO_INT0_MAP_CORE0_GPIO_INT0_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INT0_MAP.Reg, volatile.LoadUint32(&o.GPIO_INT0_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetGPIO_INT0_MAP_CORE0_GPIO_INT0_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INT0_MAP.Reg) & 0x3f
}

// CORE0.GPIO_INT1_MAP: NA
func (o *CORE0_Type) SetGPIO_INT1_MAP_CORE0_GPIO_INT1_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INT1_MAP.Reg, volatile.LoadUint32(&o.GPIO_INT1_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetGPIO_INT1_MAP_CORE0_GPIO_INT1_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INT1_MAP.Reg) & 0x3f
}

// CORE0.GPIO_INT2_MAP: NA
func (o *CORE0_Type) SetGPIO_INT2_MAP_CORE0_GPIO_INT2_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INT2_MAP.Reg, volatile.LoadUint32(&o.GPIO_INT2_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetGPIO_INT2_MAP_CORE0_GPIO_INT2_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INT2_MAP.Reg) & 0x3f
}

// CORE0.GPIO_INT3_MAP: NA
func (o *CORE0_Type) SetGPIO_INT3_MAP_CORE0_GPIO_INT3_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INT3_MAP.Reg, volatile.LoadUint32(&o.GPIO_INT3_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetGPIO_INT3_MAP_CORE0_GPIO_INT3_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INT3_MAP.Reg) & 0x3f
}

// CORE0.GPIO_PAD_COMP_INT_MAP: NA
func (o *CORE0_Type) SetGPIO_PAD_COMP_INT_MAP_CORE0_GPIO_PAD_COMP_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_PAD_COMP_INT_MAP.Reg, volatile.LoadUint32(&o.GPIO_PAD_COMP_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetGPIO_PAD_COMP_INT_MAP_CORE0_GPIO_PAD_COMP_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_PAD_COMP_INT_MAP.Reg) & 0x3f
}

// CORE0.CPU_INT_FROM_CPU_0_MAP: NA
func (o *CORE0_Type) SetCPU_INT_FROM_CPU_0_MAP_CORE0_CPU_INT_FROM_CPU_0_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_FROM_CPU_0_MAP.Reg, volatile.LoadUint32(&o.CPU_INT_FROM_CPU_0_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCPU_INT_FROM_CPU_0_MAP_CORE0_CPU_INT_FROM_CPU_0_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_FROM_CPU_0_MAP.Reg) & 0x3f
}

// CORE0.CPU_INT_FROM_CPU_1_MAP: NA
func (o *CORE0_Type) SetCPU_INT_FROM_CPU_1_MAP_CORE0_CPU_INT_FROM_CPU_1_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_FROM_CPU_1_MAP.Reg, volatile.LoadUint32(&o.CPU_INT_FROM_CPU_1_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCPU_INT_FROM_CPU_1_MAP_CORE0_CPU_INT_FROM_CPU_1_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_FROM_CPU_1_MAP.Reg) & 0x3f
}

// CORE0.CPU_INT_FROM_CPU_2_MAP: NA
func (o *CORE0_Type) SetCPU_INT_FROM_CPU_2_MAP_CORE0_CPU_INT_FROM_CPU_2_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_FROM_CPU_2_MAP.Reg, volatile.LoadUint32(&o.CPU_INT_FROM_CPU_2_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCPU_INT_FROM_CPU_2_MAP_CORE0_CPU_INT_FROM_CPU_2_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_FROM_CPU_2_MAP.Reg) & 0x3f
}

// CORE0.CPU_INT_FROM_CPU_3_MAP: NA
func (o *CORE0_Type) SetCPU_INT_FROM_CPU_3_MAP_CORE0_CPU_INT_FROM_CPU_3_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_FROM_CPU_3_MAP.Reg, volatile.LoadUint32(&o.CPU_INT_FROM_CPU_3_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCPU_INT_FROM_CPU_3_MAP_CORE0_CPU_INT_FROM_CPU_3_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_FROM_CPU_3_MAP.Reg) & 0x3f
}

// CORE0.CACHE_INT_MAP: NA
func (o *CORE0_Type) SetCACHE_INT_MAP_CORE0_CACHE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CACHE_INT_MAP.Reg, volatile.LoadUint32(&o.CACHE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCACHE_INT_MAP_CORE0_CACHE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CACHE_INT_MAP.Reg) & 0x3f
}

// CORE0.FLASH_MSPI_INT_MAP: NA
func (o *CORE0_Type) SetFLASH_MSPI_INT_MAP_CORE0_FLASH_MSPI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.FLASH_MSPI_INT_MAP.Reg, volatile.LoadUint32(&o.FLASH_MSPI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetFLASH_MSPI_INT_MAP_CORE0_FLASH_MSPI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.FLASH_MSPI_INT_MAP.Reg) & 0x3f
}

// CORE0.CSI_BRIDGE_INT_MAP: NA
func (o *CORE0_Type) SetCSI_BRIDGE_INT_MAP_CORE0_CSI_BRIDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CSI_BRIDGE_INT_MAP.Reg, volatile.LoadUint32(&o.CSI_BRIDGE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCSI_BRIDGE_INT_MAP_CORE0_CSI_BRIDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CSI_BRIDGE_INT_MAP.Reg) & 0x3f
}

// CORE0.DSI_BRIDGE_INT_MAP: NA
func (o *CORE0_Type) SetDSI_BRIDGE_INT_MAP_CORE0_DSI_BRIDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DSI_BRIDGE_INT_MAP.Reg, volatile.LoadUint32(&o.DSI_BRIDGE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetDSI_BRIDGE_INT_MAP_CORE0_DSI_BRIDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DSI_BRIDGE_INT_MAP.Reg) & 0x3f
}

// CORE0.CSI_INT_MAP: NA
func (o *CORE0_Type) SetCSI_INT_MAP_CORE0_CSI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CSI_INT_MAP.Reg, volatile.LoadUint32(&o.CSI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCSI_INT_MAP_CORE0_CSI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CSI_INT_MAP.Reg) & 0x3f
}

// CORE0.DSI_INT_MAP: NA
func (o *CORE0_Type) SetDSI_INT_MAP_CORE0_DSI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DSI_INT_MAP.Reg, volatile.LoadUint32(&o.DSI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetDSI_INT_MAP_CORE0_DSI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DSI_INT_MAP.Reg) & 0x3f
}

// CORE0.GMII_PHY_INT_MAP: NA
func (o *CORE0_Type) SetGMII_PHY_INT_MAP_CORE0_GMII_PHY_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.GMII_PHY_INT_MAP.Reg, volatile.LoadUint32(&o.GMII_PHY_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetGMII_PHY_INT_MAP_CORE0_GMII_PHY_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.GMII_PHY_INT_MAP.Reg) & 0x3f
}

// CORE0.LPI_INT_MAP: NA
func (o *CORE0_Type) SetLPI_INT_MAP_CORE0_LPI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LPI_INT_MAP.Reg, volatile.LoadUint32(&o.LPI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetLPI_INT_MAP_CORE0_LPI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LPI_INT_MAP.Reg) & 0x3f
}

// CORE0.PMT_INT_MAP: NA
func (o *CORE0_Type) SetPMT_INT_MAP_CORE0_PMT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PMT_INT_MAP.Reg, volatile.LoadUint32(&o.PMT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetPMT_INT_MAP_CORE0_PMT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PMT_INT_MAP.Reg) & 0x3f
}

// CORE0.SBD_INT_MAP: NA
func (o *CORE0_Type) SetSBD_INT_MAP_CORE0_SBD_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SBD_INT_MAP.Reg, volatile.LoadUint32(&o.SBD_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetSBD_INT_MAP_CORE0_SBD_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SBD_INT_MAP.Reg) & 0x3f
}

// CORE0.USB_OTG_INT_MAP: NA
func (o *CORE0_Type) SetUSB_OTG_INT_MAP_CORE0_USB_OTG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.USB_OTG_INT_MAP.Reg, volatile.LoadUint32(&o.USB_OTG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetUSB_OTG_INT_MAP_CORE0_USB_OTG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.USB_OTG_INT_MAP.Reg) & 0x3f
}

// CORE0.USB_OTG_ENDP_MULTI_PROC_INT_MAP: NA
func (o *CORE0_Type) SetUSB_OTG_ENDP_MULTI_PROC_INT_MAP_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.USB_OTG_ENDP_MULTI_PROC_INT_MAP.Reg, volatile.LoadUint32(&o.USB_OTG_ENDP_MULTI_PROC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetUSB_OTG_ENDP_MULTI_PROC_INT_MAP_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.USB_OTG_ENDP_MULTI_PROC_INT_MAP.Reg) & 0x3f
}

// CORE0.JPEG_INT_MAP: NA
func (o *CORE0_Type) SetJPEG_INT_MAP_CORE0_JPEG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.JPEG_INT_MAP.Reg, volatile.LoadUint32(&o.JPEG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetJPEG_INT_MAP_CORE0_JPEG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.JPEG_INT_MAP.Reg) & 0x3f
}

// CORE0.PPA_INT_MAP: NA
func (o *CORE0_Type) SetPPA_INT_MAP_CORE0_PPA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PPA_INT_MAP.Reg, volatile.LoadUint32(&o.PPA_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetPPA_INT_MAP_CORE0_PPA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PPA_INT_MAP.Reg) & 0x3f
}

// CORE0.CORE0_TRACE_INT_MAP: NA
func (o *CORE0_Type) SetCORE0_TRACE_INT_MAP_CORE0_CORE0_TRACE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CORE0_TRACE_INT_MAP.Reg, volatile.LoadUint32(&o.CORE0_TRACE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCORE0_TRACE_INT_MAP_CORE0_CORE0_TRACE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CORE0_TRACE_INT_MAP.Reg) & 0x3f
}

// CORE0.CORE1_TRACE_INT_MAP: NA
func (o *CORE0_Type) SetCORE1_TRACE_INT_MAP_CORE0_CORE1_TRACE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CORE1_TRACE_INT_MAP.Reg, volatile.LoadUint32(&o.CORE1_TRACE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetCORE1_TRACE_INT_MAP_CORE0_CORE1_TRACE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CORE1_TRACE_INT_MAP.Reg) & 0x3f
}

// CORE0.HP_CORE_CTRL_INT_MAP: NA
func (o *CORE0_Type) SetHP_CORE_CTRL_INT_MAP_CORE0_HP_CORE_CTRL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.HP_CORE_CTRL_INT_MAP.Reg, volatile.LoadUint32(&o.HP_CORE_CTRL_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetHP_CORE_CTRL_INT_MAP_CORE0_HP_CORE_CTRL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.HP_CORE_CTRL_INT_MAP.Reg) & 0x3f
}

// CORE0.ISP_INT_MAP: NA
func (o *CORE0_Type) SetISP_INT_MAP_CORE0_ISP_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ISP_INT_MAP.Reg, volatile.LoadUint32(&o.ISP_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetISP_INT_MAP_CORE0_ISP_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ISP_INT_MAP.Reg) & 0x3f
}

// CORE0.I3C_MST_INT_MAP: NA
func (o *CORE0_Type) SetI3C_MST_INT_MAP_CORE0_I3C_MST_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I3C_MST_INT_MAP.Reg, volatile.LoadUint32(&o.I3C_MST_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetI3C_MST_INT_MAP_CORE0_I3C_MST_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I3C_MST_INT_MAP.Reg) & 0x3f
}

// CORE0.I3C_SLV_INT_MAP: NA
func (o *CORE0_Type) SetI3C_SLV_INT_MAP_CORE0_I3C_SLV_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I3C_SLV_INT_MAP.Reg, volatile.LoadUint32(&o.I3C_SLV_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetI3C_SLV_INT_MAP_CORE0_I3C_SLV_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I3C_SLV_INT_MAP.Reg) & 0x3f
}

// CORE0.USB_OTG11_INT_MAP: NA
func (o *CORE0_Type) SetUSB_OTG11_INT_MAP_CORE0_USB_OTG11_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.USB_OTG11_INT_MAP.Reg, volatile.LoadUint32(&o.USB_OTG11_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetUSB_OTG11_INT_MAP_CORE0_USB_OTG11_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.USB_OTG11_INT_MAP.Reg) & 0x3f
}

// CORE0.DMA2D_IN_CH0_INT_MAP: NA
func (o *CORE0_Type) SetDMA2D_IN_CH0_INT_MAP_CORE0_DMA2D_IN_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA2D_IN_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.DMA2D_IN_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetDMA2D_IN_CH0_INT_MAP_CORE0_DMA2D_IN_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA2D_IN_CH0_INT_MAP.Reg) & 0x3f
}

// CORE0.DMA2D_IN_CH1_INT_MAP: NA
func (o *CORE0_Type) SetDMA2D_IN_CH1_INT_MAP_CORE0_DMA2D_IN_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA2D_IN_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.DMA2D_IN_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetDMA2D_IN_CH1_INT_MAP_CORE0_DMA2D_IN_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA2D_IN_CH1_INT_MAP.Reg) & 0x3f
}

// CORE0.DMA2D_OUT_CH0_INT_MAP: NA
func (o *CORE0_Type) SetDMA2D_OUT_CH0_INT_MAP_CORE0_DMA2D_OUT_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA2D_OUT_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.DMA2D_OUT_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetDMA2D_OUT_CH0_INT_MAP_CORE0_DMA2D_OUT_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA2D_OUT_CH0_INT_MAP.Reg) & 0x3f
}

// CORE0.DMA2D_OUT_CH1_INT_MAP: NA
func (o *CORE0_Type) SetDMA2D_OUT_CH1_INT_MAP_CORE0_DMA2D_OUT_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA2D_OUT_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.DMA2D_OUT_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetDMA2D_OUT_CH1_INT_MAP_CORE0_DMA2D_OUT_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA2D_OUT_CH1_INT_MAP.Reg) & 0x3f
}

// CORE0.DMA2D_OUT_CH2_INT_MAP: NA
func (o *CORE0_Type) SetDMA2D_OUT_CH2_INT_MAP_CORE0_DMA2D_OUT_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA2D_OUT_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.DMA2D_OUT_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetDMA2D_OUT_CH2_INT_MAP_CORE0_DMA2D_OUT_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA2D_OUT_CH2_INT_MAP.Reg) & 0x3f
}

// CORE0.PSRAM_MSPI_INT_MAP: NA
func (o *CORE0_Type) SetPSRAM_MSPI_INT_MAP_CORE0_PSRAM_MSPI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PSRAM_MSPI_INT_MAP.Reg, volatile.LoadUint32(&o.PSRAM_MSPI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetPSRAM_MSPI_INT_MAP_CORE0_PSRAM_MSPI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PSRAM_MSPI_INT_MAP.Reg) & 0x3f
}

// CORE0.HP_SYSREG_INT_MAP: NA
func (o *CORE0_Type) SetHP_SYSREG_INT_MAP_CORE0_HP_SYSREG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.HP_SYSREG_INT_MAP.Reg, volatile.LoadUint32(&o.HP_SYSREG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetHP_SYSREG_INT_MAP_CORE0_HP_SYSREG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.HP_SYSREG_INT_MAP.Reg) & 0x3f
}

// CORE0.PCNT_INT_MAP: NA
func (o *CORE0_Type) SetPCNT_INT_MAP_CORE0_PCNT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PCNT_INT_MAP.Reg, volatile.LoadUint32(&o.PCNT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetPCNT_INT_MAP_CORE0_PCNT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PCNT_INT_MAP.Reg) & 0x3f
}

// CORE0.HP_PAU_INT_MAP: NA
func (o *CORE0_Type) SetHP_PAU_INT_MAP_CORE0_HP_PAU_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.HP_PAU_INT_MAP.Reg, volatile.LoadUint32(&o.HP_PAU_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetHP_PAU_INT_MAP_CORE0_HP_PAU_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.HP_PAU_INT_MAP.Reg) & 0x3f
}

// CORE0.HP_PARLIO_RX_INT_MAP: NA
func (o *CORE0_Type) SetHP_PARLIO_RX_INT_MAP_CORE0_HP_PARLIO_RX_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.HP_PARLIO_RX_INT_MAP.Reg, volatile.LoadUint32(&o.HP_PARLIO_RX_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetHP_PARLIO_RX_INT_MAP_CORE0_HP_PARLIO_RX_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.HP_PARLIO_RX_INT_MAP.Reg) & 0x3f
}

// CORE0.HP_PARLIO_TX_INT_MAP: NA
func (o *CORE0_Type) SetHP_PARLIO_TX_INT_MAP_CORE0_HP_PARLIO_TX_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.HP_PARLIO_TX_INT_MAP.Reg, volatile.LoadUint32(&o.HP_PARLIO_TX_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetHP_PARLIO_TX_INT_MAP_CORE0_HP_PARLIO_TX_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.HP_PARLIO_TX_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_OUT_CH0_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_OUT_CH0_INT_MAP_CORE0_H264_DMA2D_OUT_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_OUT_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_OUT_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_OUT_CH0_INT_MAP_CORE0_H264_DMA2D_OUT_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_OUT_CH0_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_OUT_CH1_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_OUT_CH1_INT_MAP_CORE0_H264_DMA2D_OUT_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_OUT_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_OUT_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_OUT_CH1_INT_MAP_CORE0_H264_DMA2D_OUT_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_OUT_CH1_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_OUT_CH2_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_OUT_CH2_INT_MAP_CORE0_H264_DMA2D_OUT_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_OUT_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_OUT_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_OUT_CH2_INT_MAP_CORE0_H264_DMA2D_OUT_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_OUT_CH2_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_OUT_CH3_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_OUT_CH3_INT_MAP_CORE0_H264_DMA2D_OUT_CH3_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_OUT_CH3_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_OUT_CH3_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_OUT_CH3_INT_MAP_CORE0_H264_DMA2D_OUT_CH3_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_OUT_CH3_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_OUT_CH4_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_OUT_CH4_INT_MAP_CORE0_H264_DMA2D_OUT_CH4_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_OUT_CH4_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_OUT_CH4_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_OUT_CH4_INT_MAP_CORE0_H264_DMA2D_OUT_CH4_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_OUT_CH4_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_IN_CH0_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_IN_CH0_INT_MAP_CORE0_H264_DMA2D_IN_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_IN_CH0_INT_MAP_CORE0_H264_DMA2D_IN_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH0_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_IN_CH1_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_IN_CH1_INT_MAP_CORE0_H264_DMA2D_IN_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_IN_CH1_INT_MAP_CORE0_H264_DMA2D_IN_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH1_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_IN_CH2_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_IN_CH2_INT_MAP_CORE0_H264_DMA2D_IN_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_IN_CH2_INT_MAP_CORE0_H264_DMA2D_IN_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH2_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_IN_CH3_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_IN_CH3_INT_MAP_CORE0_H264_DMA2D_IN_CH3_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH3_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH3_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_IN_CH3_INT_MAP_CORE0_H264_DMA2D_IN_CH3_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH3_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_IN_CH4_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_IN_CH4_INT_MAP_CORE0_H264_DMA2D_IN_CH4_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH4_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH4_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_IN_CH4_INT_MAP_CORE0_H264_DMA2D_IN_CH4_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH4_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_DMA2D_IN_CH5_INT_MAP: NA
func (o *CORE0_Type) SetH264_DMA2D_IN_CH5_INT_MAP_CORE0_H264_DMA2D_IN_CH5_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH5_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH5_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_DMA2D_IN_CH5_INT_MAP_CORE0_H264_DMA2D_IN_CH5_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH5_INT_MAP.Reg) & 0x3f
}

// CORE0.H264_REG_INT_MAP: NA
func (o *CORE0_Type) SetH264_REG_INT_MAP_CORE0_H264_REG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_REG_INT_MAP.Reg, volatile.LoadUint32(&o.H264_REG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetH264_REG_INT_MAP_CORE0_H264_REG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_REG_INT_MAP.Reg) & 0x3f
}

// CORE0.ASSIST_DEBUG_INT_MAP: NA
func (o *CORE0_Type) SetASSIST_DEBUG_INT_MAP_CORE0_ASSIST_DEBUG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ASSIST_DEBUG_INT_MAP.Reg, volatile.LoadUint32(&o.ASSIST_DEBUG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE0_Type) GetASSIST_DEBUG_INT_MAP_CORE0_ASSIST_DEBUG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ASSIST_DEBUG_INT_MAP.Reg) & 0x3f
}

// CORE0.INTR_STATUS_REG_0: NA
func (o *CORE0_Type) SetINTR_STATUS_REG_0(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_0.Reg, value)
}
func (o *CORE0_Type) GetINTR_STATUS_REG_0() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_0.Reg)
}

// CORE0.INTR_STATUS_REG_1: NA
func (o *CORE0_Type) SetINTR_STATUS_REG_1(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_1.Reg, value)
}
func (o *CORE0_Type) GetINTR_STATUS_REG_1() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_1.Reg)
}

// CORE0.INTR_STATUS_REG_2: NA
func (o *CORE0_Type) SetINTR_STATUS_REG_2(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_2.Reg, value)
}
func (o *CORE0_Type) GetINTR_STATUS_REG_2() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_2.Reg)
}

// CORE0.INTR_STATUS_REG_3: NA
func (o *CORE0_Type) SetINTR_STATUS_REG_3(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_3.Reg, value)
}
func (o *CORE0_Type) GetINTR_STATUS_REG_3() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_3.Reg)
}

// CORE0.CLOCK_GATE: NA
func (o *CORE0_Type) SetCLOCK_GATE_CORE0_REG_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *CORE0_Type) GetCLOCK_GATE_CORE0_REG_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// CORE0.INTERRUPT_REG_DATE: NA
func (o *CORE0_Type) SetINTERRUPT_REG_DATE_CORE0_INTERRUPT_REG_DATE(value uint32) {
	volatile.StoreUint32(&o.INTERRUPT_REG_DATE.Reg, volatile.LoadUint32(&o.INTERRUPT_REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *CORE0_Type) GetINTERRUPT_REG_DATE_CORE0_INTERRUPT_REG_DATE() uint32 {
	return volatile.LoadUint32(&o.INTERRUPT_REG_DATE.Reg) & 0xfffffff
}

// Interrupt Controller (Core 1)
type CORE1_Type struct {
	LP_RTC_INT_MAP                  volatile.Register32 // 0x0
	LP_WDT_INT_MAP                  volatile.Register32 // 0x4
	LP_TIMER_REG_0_INT_MAP          volatile.Register32 // 0x8
	LP_TIMER_REG_1_INT_MAP          volatile.Register32 // 0xC
	MB_HP_INT_MAP                   volatile.Register32 // 0x10
	MB_LP_INT_MAP                   volatile.Register32 // 0x14
	PMU_REG_0_INT_MAP               volatile.Register32 // 0x18
	PMU_REG_1_INT_MAP               volatile.Register32 // 0x1C
	LP_ANAPERI_INT_MAP              volatile.Register32 // 0x20
	LP_ADC_INT_MAP                  volatile.Register32 // 0x24
	LP_GPIO_INT_MAP                 volatile.Register32 // 0x28
	LP_I2C_INT_MAP                  volatile.Register32 // 0x2C
	LP_I2S_INT_MAP                  volatile.Register32 // 0x30
	LP_SPI_INT_MAP                  volatile.Register32 // 0x34
	LP_TOUCH_INT_MAP                volatile.Register32 // 0x38
	LP_TSENS_INT_MAP                volatile.Register32 // 0x3C
	LP_UART_INT_MAP                 volatile.Register32 // 0x40
	LP_EFUSE_INT_MAP                volatile.Register32 // 0x44
	LP_SW_INT_MAP                   volatile.Register32 // 0x48
	LP_SYSREG_INT_MAP               volatile.Register32 // 0x4C
	LP_HUK_INT_MAP                  volatile.Register32 // 0x50
	SYS_ICM_INT_MAP                 volatile.Register32 // 0x54
	USB_DEVICE_INT_MAP              volatile.Register32 // 0x58
	SDIO_HOST_INT_MAP               volatile.Register32 // 0x5C
	GDMA_INT_MAP                    volatile.Register32 // 0x60
	SPI2_INT_MAP                    volatile.Register32 // 0x64
	SPI3_INT_MAP                    volatile.Register32 // 0x68
	I2S0_INT_MAP                    volatile.Register32 // 0x6C
	I2S1_INT_MAP                    volatile.Register32 // 0x70
	I2S2_INT_MAP                    volatile.Register32 // 0x74
	UHCI0_INT_MAP                   volatile.Register32 // 0x78
	UART0_INT_MAP                   volatile.Register32 // 0x7C
	UART1_INT_MAP                   volatile.Register32 // 0x80
	UART2_INT_MAP                   volatile.Register32 // 0x84
	UART3_INT_MAP                   volatile.Register32 // 0x88
	UART4_INT_MAP                   volatile.Register32 // 0x8C
	LCD_CAM_INT_MAP                 volatile.Register32 // 0x90
	ADC_INT_MAP                     volatile.Register32 // 0x94
	PWM0_INT_MAP                    volatile.Register32 // 0x98
	PWM1_INT_MAP                    volatile.Register32 // 0x9C
	CAN0_INT_MAP                    volatile.Register32 // 0xA0
	CAN1_INT_MAP                    volatile.Register32 // 0xA4
	CAN2_INT_MAP                    volatile.Register32 // 0xA8
	RMT_INT_MAP                     volatile.Register32 // 0xAC
	I2C0_INT_MAP                    volatile.Register32 // 0xB0
	I2C1_INT_MAP                    volatile.Register32 // 0xB4
	TIMERGRP0_T0_INT_MAP            volatile.Register32 // 0xB8
	TIMERGRP0_T1_INT_MAP            volatile.Register32 // 0xBC
	TIMERGRP0_WDT_INT_MAP           volatile.Register32 // 0xC0
	TIMERGRP1_T0_INT_MAP            volatile.Register32 // 0xC4
	TIMERGRP1_T1_INT_MAP            volatile.Register32 // 0xC8
	TIMERGRP1_WDT_INT_MAP           volatile.Register32 // 0xCC
	LEDC_INT_MAP                    volatile.Register32 // 0xD0
	SYSTIMER_TARGET0_INT_MAP        volatile.Register32 // 0xD4
	SYSTIMER_TARGET1_INT_MAP        volatile.Register32 // 0xD8
	SYSTIMER_TARGET2_INT_MAP        volatile.Register32 // 0xDC
	AHB_PDMA_IN_CH0_INT_MAP         volatile.Register32 // 0xE0
	AHB_PDMA_IN_CH1_INT_MAP         volatile.Register32 // 0xE4
	AHB_PDMA_IN_CH2_INT_MAP         volatile.Register32 // 0xE8
	AHB_PDMA_OUT_CH0_INT_MAP        volatile.Register32 // 0xEC
	AHB_PDMA_OUT_CH1_INT_MAP        volatile.Register32 // 0xF0
	AHB_PDMA_OUT_CH2_INT_MAP        volatile.Register32 // 0xF4
	AXI_PDMA_IN_CH0_INT_MAP         volatile.Register32 // 0xF8
	AXI_PDMA_IN_CH1_INT_MAP         volatile.Register32 // 0xFC
	AXI_PDMA_IN_CH2_INT_MAP         volatile.Register32 // 0x100
	AXI_PDMA_OUT_CH0_INT_MAP        volatile.Register32 // 0x104
	AXI_PDMA_OUT_CH1_INT_MAP        volatile.Register32 // 0x108
	AXI_PDMA_OUT_CH2_INT_MAP        volatile.Register32 // 0x10C
	RSA_INT_MAP                     volatile.Register32 // 0x110
	AES_INT_MAP                     volatile.Register32 // 0x114
	SHA_INT_MAP                     volatile.Register32 // 0x118
	ECC_INT_MAP                     volatile.Register32 // 0x11C
	ECDSA_INT_MAP                   volatile.Register32 // 0x120
	KM_INT_MAP                      volatile.Register32 // 0x124
	GPIO_INT0_MAP                   volatile.Register32 // 0x128
	GPIO_INT1_MAP                   volatile.Register32 // 0x12C
	GPIO_INT2_MAP                   volatile.Register32 // 0x130
	GPIO_INT3_MAP                   volatile.Register32 // 0x134
	GPIO_PAD_COMP_INT_MAP           volatile.Register32 // 0x138
	CPU_INT_FROM_CPU_0_MAP          volatile.Register32 // 0x13C
	CPU_INT_FROM_CPU_1_MAP          volatile.Register32 // 0x140
	CPU_INT_FROM_CPU_2_MAP          volatile.Register32 // 0x144
	CPU_INT_FROM_CPU_3_MAP          volatile.Register32 // 0x148
	CACHE_INT_MAP                   volatile.Register32 // 0x14C
	FLASH_MSPI_INT_MAP              volatile.Register32 // 0x150
	CSI_BRIDGE_INT_MAP              volatile.Register32 // 0x154
	DSI_BRIDGE_INT_MAP              volatile.Register32 // 0x158
	CSI_INT_MAP                     volatile.Register32 // 0x15C
	DSI_INT_MAP                     volatile.Register32 // 0x160
	GMII_PHY_INT_MAP                volatile.Register32 // 0x164
	LPI_INT_MAP                     volatile.Register32 // 0x168
	PMT_INT_MAP                     volatile.Register32 // 0x16C
	SBD_INT_MAP                     volatile.Register32 // 0x170
	USB_OTG_INT_MAP                 volatile.Register32 // 0x174
	USB_OTG_ENDP_MULTI_PROC_INT_MAP volatile.Register32 // 0x178
	JPEG_INT_MAP                    volatile.Register32 // 0x17C
	PPA_INT_MAP                     volatile.Register32 // 0x180
	CORE0_TRACE_INT_MAP             volatile.Register32 // 0x184
	CORE1_TRACE_INT_MAP             volatile.Register32 // 0x188
	HP_CORE_CTRL_INT_MAP            volatile.Register32 // 0x18C
	ISP_INT_MAP                     volatile.Register32 // 0x190
	I3C_MST_INT_MAP                 volatile.Register32 // 0x194
	I3C_SLV_INT_MAP                 volatile.Register32 // 0x198
	USB_OTG11_INT_MAP               volatile.Register32 // 0x19C
	DMA2D_IN_CH0_INT_MAP            volatile.Register32 // 0x1A0
	DMA2D_IN_CH1_INT_MAP            volatile.Register32 // 0x1A4
	DMA2D_OUT_CH0_INT_MAP           volatile.Register32 // 0x1A8
	DMA2D_OUT_CH1_INT_MAP           volatile.Register32 // 0x1AC
	DMA2D_OUT_CH2_INT_MAP           volatile.Register32 // 0x1B0
	PSRAM_MSPI_INT_MAP              volatile.Register32 // 0x1B4
	HP_SYSREG_INT_MAP               volatile.Register32 // 0x1B8
	PCNT_INT_MAP                    volatile.Register32 // 0x1BC
	HP_PAU_INT_MAP                  volatile.Register32 // 0x1C0
	HP_PARLIO_RX_INT_MAP            volatile.Register32 // 0x1C4
	HP_PARLIO_TX_INT_MAP            volatile.Register32 // 0x1C8
	H264_DMA2D_OUT_CH0_INT_MAP      volatile.Register32 // 0x1CC
	H264_DMA2D_OUT_CH1_INT_MAP      volatile.Register32 // 0x1D0
	H264_DMA2D_OUT_CH2_INT_MAP      volatile.Register32 // 0x1D4
	H264_DMA2D_OUT_CH3_INT_MAP      volatile.Register32 // 0x1D8
	H264_DMA2D_OUT_CH4_INT_MAP      volatile.Register32 // 0x1DC
	H264_DMA2D_IN_CH0_INT_MAP       volatile.Register32 // 0x1E0
	H264_DMA2D_IN_CH1_INT_MAP       volatile.Register32 // 0x1E4
	H264_DMA2D_IN_CH2_INT_MAP       volatile.Register32 // 0x1E8
	H264_DMA2D_IN_CH3_INT_MAP       volatile.Register32 // 0x1EC
	H264_DMA2D_IN_CH4_INT_MAP       volatile.Register32 // 0x1F0
	H264_DMA2D_IN_CH5_INT_MAP       volatile.Register32 // 0x1F4
	H264_REG_INT_MAP                volatile.Register32 // 0x1F8
	ASSIST_DEBUG_INT_MAP            volatile.Register32 // 0x1FC
	INTR_STATUS_REG_0               volatile.Register32 // 0x200
	INTR_STATUS_REG_1               volatile.Register32 // 0x204
	INTR_STATUS_REG_2               volatile.Register32 // 0x208
	INTR_STATUS_REG_3               volatile.Register32 // 0x20C
	CLOCK_GATE                      volatile.Register32 // 0x210
	_                               [488]byte
	INTERRUPT_REG_DATE              volatile.Register32 // 0x3FC
}

// CORE1.LP_RTC_INT_MAP: NA
func (o *CORE1_Type) SetLP_RTC_INT_MAP_CORE1_LP_RTC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_RTC_INT_MAP.Reg, volatile.LoadUint32(&o.LP_RTC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_RTC_INT_MAP_CORE1_LP_RTC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_RTC_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_WDT_INT_MAP: NA
func (o *CORE1_Type) SetLP_WDT_INT_MAP_CORE1_LP_WDT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_WDT_INT_MAP.Reg, volatile.LoadUint32(&o.LP_WDT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_WDT_INT_MAP_CORE1_LP_WDT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_WDT_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_TIMER_REG_0_INT_MAP: NA
func (o *CORE1_Type) SetLP_TIMER_REG_0_INT_MAP_CORE1_LP_TIMER_REG_0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_TIMER_REG_0_INT_MAP.Reg, volatile.LoadUint32(&o.LP_TIMER_REG_0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_TIMER_REG_0_INT_MAP_CORE1_LP_TIMER_REG_0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_TIMER_REG_0_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_TIMER_REG_1_INT_MAP: NA
func (o *CORE1_Type) SetLP_TIMER_REG_1_INT_MAP_CORE1_LP_TIMER_REG_1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_TIMER_REG_1_INT_MAP.Reg, volatile.LoadUint32(&o.LP_TIMER_REG_1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_TIMER_REG_1_INT_MAP_CORE1_LP_TIMER_REG_1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_TIMER_REG_1_INT_MAP.Reg) & 0x3f
}

// CORE1.MB_HP_INT_MAP: NA
func (o *CORE1_Type) SetMB_HP_INT_MAP_CORE1_MB_HP_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.MB_HP_INT_MAP.Reg, volatile.LoadUint32(&o.MB_HP_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetMB_HP_INT_MAP_CORE1_MB_HP_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.MB_HP_INT_MAP.Reg) & 0x3f
}

// CORE1.MB_LP_INT_MAP: NA
func (o *CORE1_Type) SetMB_LP_INT_MAP_CORE1_MB_LP_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.MB_LP_INT_MAP.Reg, volatile.LoadUint32(&o.MB_LP_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetMB_LP_INT_MAP_CORE1_MB_LP_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.MB_LP_INT_MAP.Reg) & 0x3f
}

// CORE1.PMU_REG_0_INT_MAP: NA
func (o *CORE1_Type) SetPMU_REG_0_INT_MAP_CORE1_PMU_REG_0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PMU_REG_0_INT_MAP.Reg, volatile.LoadUint32(&o.PMU_REG_0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetPMU_REG_0_INT_MAP_CORE1_PMU_REG_0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PMU_REG_0_INT_MAP.Reg) & 0x3f
}

// CORE1.PMU_REG_1_INT_MAP: NA
func (o *CORE1_Type) SetPMU_REG_1_INT_MAP_CORE1_PMU_REG_1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PMU_REG_1_INT_MAP.Reg, volatile.LoadUint32(&o.PMU_REG_1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetPMU_REG_1_INT_MAP_CORE1_PMU_REG_1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PMU_REG_1_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_ANAPERI_INT_MAP: NA
func (o *CORE1_Type) SetLP_ANAPERI_INT_MAP_CORE1_LP_ANAPERI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_ANAPERI_INT_MAP.Reg, volatile.LoadUint32(&o.LP_ANAPERI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_ANAPERI_INT_MAP_CORE1_LP_ANAPERI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_ANAPERI_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_ADC_INT_MAP: NA
func (o *CORE1_Type) SetLP_ADC_INT_MAP_CORE1_LP_ADC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_ADC_INT_MAP.Reg, volatile.LoadUint32(&o.LP_ADC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_ADC_INT_MAP_CORE1_LP_ADC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_ADC_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_GPIO_INT_MAP: NA
func (o *CORE1_Type) SetLP_GPIO_INT_MAP_CORE1_LP_GPIO_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_GPIO_INT_MAP.Reg, volatile.LoadUint32(&o.LP_GPIO_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_GPIO_INT_MAP_CORE1_LP_GPIO_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_GPIO_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_I2C_INT_MAP: NA
func (o *CORE1_Type) SetLP_I2C_INT_MAP_CORE1_LP_I2C_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_I2C_INT_MAP.Reg, volatile.LoadUint32(&o.LP_I2C_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_I2C_INT_MAP_CORE1_LP_I2C_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_I2C_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_I2S_INT_MAP: NA
func (o *CORE1_Type) SetLP_I2S_INT_MAP_CORE1_LP_I2S_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_I2S_INT_MAP.Reg, volatile.LoadUint32(&o.LP_I2S_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_I2S_INT_MAP_CORE1_LP_I2S_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_I2S_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_SPI_INT_MAP: NA
func (o *CORE1_Type) SetLP_SPI_INT_MAP_CORE1_LP_SPI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_SPI_INT_MAP.Reg, volatile.LoadUint32(&o.LP_SPI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_SPI_INT_MAP_CORE1_LP_SPI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_SPI_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_TOUCH_INT_MAP: NA
func (o *CORE1_Type) SetLP_TOUCH_INT_MAP_CORE1_LP_TOUCH_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_TOUCH_INT_MAP.Reg, volatile.LoadUint32(&o.LP_TOUCH_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_TOUCH_INT_MAP_CORE1_LP_TOUCH_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_TOUCH_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_TSENS_INT_MAP: NA
func (o *CORE1_Type) SetLP_TSENS_INT_MAP_CORE1_LP_TSENS_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_TSENS_INT_MAP.Reg, volatile.LoadUint32(&o.LP_TSENS_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_TSENS_INT_MAP_CORE1_LP_TSENS_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_TSENS_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_UART_INT_MAP: NA
func (o *CORE1_Type) SetLP_UART_INT_MAP_CORE1_LP_UART_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_UART_INT_MAP.Reg, volatile.LoadUint32(&o.LP_UART_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_UART_INT_MAP_CORE1_LP_UART_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_UART_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_EFUSE_INT_MAP: NA
func (o *CORE1_Type) SetLP_EFUSE_INT_MAP_CORE1_LP_EFUSE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_EFUSE_INT_MAP.Reg, volatile.LoadUint32(&o.LP_EFUSE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_EFUSE_INT_MAP_CORE1_LP_EFUSE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_EFUSE_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_SW_INT_MAP: NA
func (o *CORE1_Type) SetLP_SW_INT_MAP_CORE1_LP_SW_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_SW_INT_MAP.Reg, volatile.LoadUint32(&o.LP_SW_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_SW_INT_MAP_CORE1_LP_SW_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_SW_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_SYSREG_INT_MAP: NA
func (o *CORE1_Type) SetLP_SYSREG_INT_MAP_CORE1_LP_SYSREG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_SYSREG_INT_MAP.Reg, volatile.LoadUint32(&o.LP_SYSREG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_SYSREG_INT_MAP_CORE1_LP_SYSREG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_SYSREG_INT_MAP.Reg) & 0x3f
}

// CORE1.LP_HUK_INT_MAP: NA
func (o *CORE1_Type) SetLP_HUK_INT_MAP_CORE1_LP_HUK_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LP_HUK_INT_MAP.Reg, volatile.LoadUint32(&o.LP_HUK_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLP_HUK_INT_MAP_CORE1_LP_HUK_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LP_HUK_INT_MAP.Reg) & 0x3f
}

// CORE1.SYS_ICM_INT_MAP: NA
func (o *CORE1_Type) SetSYS_ICM_INT_MAP_CORE1_SYS_ICM_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYS_ICM_INT_MAP.Reg, volatile.LoadUint32(&o.SYS_ICM_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetSYS_ICM_INT_MAP_CORE1_SYS_ICM_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYS_ICM_INT_MAP.Reg) & 0x3f
}

// CORE1.USB_DEVICE_INT_MAP: NA
func (o *CORE1_Type) SetUSB_DEVICE_INT_MAP_CORE1_USB_DEVICE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.USB_DEVICE_INT_MAP.Reg, volatile.LoadUint32(&o.USB_DEVICE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetUSB_DEVICE_INT_MAP_CORE1_USB_DEVICE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.USB_DEVICE_INT_MAP.Reg) & 0x3f
}

// CORE1.SDIO_HOST_INT_MAP: NA
func (o *CORE1_Type) SetSDIO_HOST_INT_MAP_CORE1_SDIO_HOST_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SDIO_HOST_INT_MAP.Reg, volatile.LoadUint32(&o.SDIO_HOST_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetSDIO_HOST_INT_MAP_CORE1_SDIO_HOST_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SDIO_HOST_INT_MAP.Reg) & 0x3f
}

// CORE1.GDMA_INT_MAP: NA
func (o *CORE1_Type) SetGDMA_INT_MAP_CORE1_GDMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.GDMA_INT_MAP.Reg, volatile.LoadUint32(&o.GDMA_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetGDMA_INT_MAP_CORE1_GDMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.GDMA_INT_MAP.Reg) & 0x3f
}

// CORE1.SPI2_INT_MAP: NA
func (o *CORE1_Type) SetSPI2_INT_MAP_CORE1_SPI2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SPI2_INT_MAP.Reg, volatile.LoadUint32(&o.SPI2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetSPI2_INT_MAP_CORE1_SPI2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SPI2_INT_MAP.Reg) & 0x3f
}

// CORE1.SPI3_INT_MAP: NA
func (o *CORE1_Type) SetSPI3_INT_MAP_CORE1_SPI3_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SPI3_INT_MAP.Reg, volatile.LoadUint32(&o.SPI3_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetSPI3_INT_MAP_CORE1_SPI3_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SPI3_INT_MAP.Reg) & 0x3f
}

// CORE1.I2S0_INT_MAP: NA
func (o *CORE1_Type) SetI2S0_INT_MAP_CORE1_I2S0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2S0_INT_MAP.Reg, volatile.LoadUint32(&o.I2S0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetI2S0_INT_MAP_CORE1_I2S0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2S0_INT_MAP.Reg) & 0x3f
}

// CORE1.I2S1_INT_MAP: NA
func (o *CORE1_Type) SetI2S1_INT_MAP_CORE1_I2S1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2S1_INT_MAP.Reg, volatile.LoadUint32(&o.I2S1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetI2S1_INT_MAP_CORE1_I2S1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2S1_INT_MAP.Reg) & 0x3f
}

// CORE1.I2S2_INT_MAP: NA
func (o *CORE1_Type) SetI2S2_INT_MAP_CORE1_I2S2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2S2_INT_MAP.Reg, volatile.LoadUint32(&o.I2S2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetI2S2_INT_MAP_CORE1_I2S2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2S2_INT_MAP.Reg) & 0x3f
}

// CORE1.UHCI0_INT_MAP: NA
func (o *CORE1_Type) SetUHCI0_INT_MAP_CORE1_UHCI0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UHCI0_INT_MAP.Reg, volatile.LoadUint32(&o.UHCI0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetUHCI0_INT_MAP_CORE1_UHCI0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UHCI0_INT_MAP.Reg) & 0x3f
}

// CORE1.UART0_INT_MAP: NA
func (o *CORE1_Type) SetUART0_INT_MAP_CORE1_UART0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UART0_INT_MAP.Reg, volatile.LoadUint32(&o.UART0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetUART0_INT_MAP_CORE1_UART0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UART0_INT_MAP.Reg) & 0x3f
}

// CORE1.UART1_INT_MAP: NA
func (o *CORE1_Type) SetUART1_INT_MAP_CORE1_UART1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UART1_INT_MAP.Reg, volatile.LoadUint32(&o.UART1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetUART1_INT_MAP_CORE1_UART1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UART1_INT_MAP.Reg) & 0x3f
}

// CORE1.UART2_INT_MAP: NA
func (o *CORE1_Type) SetUART2_INT_MAP_CORE1_UART2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UART2_INT_MAP.Reg, volatile.LoadUint32(&o.UART2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetUART2_INT_MAP_CORE1_UART2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UART2_INT_MAP.Reg) & 0x3f
}

// CORE1.UART3_INT_MAP: NA
func (o *CORE1_Type) SetUART3_INT_MAP_CORE1_UART3_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UART3_INT_MAP.Reg, volatile.LoadUint32(&o.UART3_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetUART3_INT_MAP_CORE1_UART3_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UART3_INT_MAP.Reg) & 0x3f
}

// CORE1.UART4_INT_MAP: NA
func (o *CORE1_Type) SetUART4_INT_MAP_CORE1_UART4_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.UART4_INT_MAP.Reg, volatile.LoadUint32(&o.UART4_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetUART4_INT_MAP_CORE1_UART4_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.UART4_INT_MAP.Reg) & 0x3f
}

// CORE1.LCD_CAM_INT_MAP: NA
func (o *CORE1_Type) SetLCD_CAM_INT_MAP_CORE1_LCD_CAM_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LCD_CAM_INT_MAP.Reg, volatile.LoadUint32(&o.LCD_CAM_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLCD_CAM_INT_MAP_CORE1_LCD_CAM_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LCD_CAM_INT_MAP.Reg) & 0x3f
}

// CORE1.ADC_INT_MAP: NA
func (o *CORE1_Type) SetADC_INT_MAP_CORE1_ADC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ADC_INT_MAP.Reg, volatile.LoadUint32(&o.ADC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetADC_INT_MAP_CORE1_ADC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ADC_INT_MAP.Reg) & 0x3f
}

// CORE1.PWM0_INT_MAP: NA
func (o *CORE1_Type) SetPWM0_INT_MAP_CORE1_PWM0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PWM0_INT_MAP.Reg, volatile.LoadUint32(&o.PWM0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetPWM0_INT_MAP_CORE1_PWM0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PWM0_INT_MAP.Reg) & 0x3f
}

// CORE1.PWM1_INT_MAP: NA
func (o *CORE1_Type) SetPWM1_INT_MAP_CORE1_PWM1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PWM1_INT_MAP.Reg, volatile.LoadUint32(&o.PWM1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetPWM1_INT_MAP_CORE1_PWM1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PWM1_INT_MAP.Reg) & 0x3f
}

// CORE1.CAN0_INT_MAP: NA
func (o *CORE1_Type) SetCAN0_INT_MAP_CORE1_CAN0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CAN0_INT_MAP.Reg, volatile.LoadUint32(&o.CAN0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCAN0_INT_MAP_CORE1_CAN0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CAN0_INT_MAP.Reg) & 0x3f
}

// CORE1.CAN1_INT_MAP: NA
func (o *CORE1_Type) SetCAN1_INT_MAP_CORE1_CAN1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CAN1_INT_MAP.Reg, volatile.LoadUint32(&o.CAN1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCAN1_INT_MAP_CORE1_CAN1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CAN1_INT_MAP.Reg) & 0x3f
}

// CORE1.CAN2_INT_MAP: NA
func (o *CORE1_Type) SetCAN2_INT_MAP_CORE1_CAN2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CAN2_INT_MAP.Reg, volatile.LoadUint32(&o.CAN2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCAN2_INT_MAP_CORE1_CAN2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CAN2_INT_MAP.Reg) & 0x3f
}

// CORE1.RMT_INT_MAP: NA
func (o *CORE1_Type) SetRMT_INT_MAP_CORE1_RMT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.RMT_INT_MAP.Reg, volatile.LoadUint32(&o.RMT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetRMT_INT_MAP_CORE1_RMT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.RMT_INT_MAP.Reg) & 0x3f
}

// CORE1.I2C0_INT_MAP: NA
func (o *CORE1_Type) SetI2C0_INT_MAP_CORE1_I2C0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2C0_INT_MAP.Reg, volatile.LoadUint32(&o.I2C0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetI2C0_INT_MAP_CORE1_I2C0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2C0_INT_MAP.Reg) & 0x3f
}

// CORE1.I2C1_INT_MAP: NA
func (o *CORE1_Type) SetI2C1_INT_MAP_CORE1_I2C1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I2C1_INT_MAP.Reg, volatile.LoadUint32(&o.I2C1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetI2C1_INT_MAP_CORE1_I2C1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I2C1_INT_MAP.Reg) & 0x3f
}

// CORE1.TIMERGRP0_T0_INT_MAP: NA
func (o *CORE1_Type) SetTIMERGRP0_T0_INT_MAP_CORE1_TIMERGRP0_T0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP0_T0_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP0_T0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetTIMERGRP0_T0_INT_MAP_CORE1_TIMERGRP0_T0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP0_T0_INT_MAP.Reg) & 0x3f
}

// CORE1.TIMERGRP0_T1_INT_MAP: NA
func (o *CORE1_Type) SetTIMERGRP0_T1_INT_MAP_CORE1_TIMERGRP0_T1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP0_T1_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP0_T1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetTIMERGRP0_T1_INT_MAP_CORE1_TIMERGRP0_T1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP0_T1_INT_MAP.Reg) & 0x3f
}

// CORE1.TIMERGRP0_WDT_INT_MAP: NA
func (o *CORE1_Type) SetTIMERGRP0_WDT_INT_MAP_CORE1_TIMERGRP0_WDT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP0_WDT_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP0_WDT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetTIMERGRP0_WDT_INT_MAP_CORE1_TIMERGRP0_WDT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP0_WDT_INT_MAP.Reg) & 0x3f
}

// CORE1.TIMERGRP1_T0_INT_MAP: NA
func (o *CORE1_Type) SetTIMERGRP1_T0_INT_MAP_CORE1_TIMERGRP1_T0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP1_T0_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP1_T0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetTIMERGRP1_T0_INT_MAP_CORE1_TIMERGRP1_T0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP1_T0_INT_MAP.Reg) & 0x3f
}

// CORE1.TIMERGRP1_T1_INT_MAP: NA
func (o *CORE1_Type) SetTIMERGRP1_T1_INT_MAP_CORE1_TIMERGRP1_T1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP1_T1_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP1_T1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetTIMERGRP1_T1_INT_MAP_CORE1_TIMERGRP1_T1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP1_T1_INT_MAP.Reg) & 0x3f
}

// CORE1.TIMERGRP1_WDT_INT_MAP: NA
func (o *CORE1_Type) SetTIMERGRP1_WDT_INT_MAP_CORE1_TIMERGRP1_WDT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.TIMERGRP1_WDT_INT_MAP.Reg, volatile.LoadUint32(&o.TIMERGRP1_WDT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetTIMERGRP1_WDT_INT_MAP_CORE1_TIMERGRP1_WDT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.TIMERGRP1_WDT_INT_MAP.Reg) & 0x3f
}

// CORE1.LEDC_INT_MAP: NA
func (o *CORE1_Type) SetLEDC_INT_MAP_CORE1_LEDC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LEDC_INT_MAP.Reg, volatile.LoadUint32(&o.LEDC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLEDC_INT_MAP_CORE1_LEDC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LEDC_INT_MAP.Reg) & 0x3f
}

// CORE1.SYSTIMER_TARGET0_INT_MAP: NA
func (o *CORE1_Type) SetSYSTIMER_TARGET0_INT_MAP_CORE1_SYSTIMER_TARGET0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetSYSTIMER_TARGET0_INT_MAP_CORE1_SYSTIMER_TARGET0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET0_INT_MAP.Reg) & 0x3f
}

// CORE1.SYSTIMER_TARGET1_INT_MAP: NA
func (o *CORE1_Type) SetSYSTIMER_TARGET1_INT_MAP_CORE1_SYSTIMER_TARGET1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetSYSTIMER_TARGET1_INT_MAP_CORE1_SYSTIMER_TARGET1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET1_INT_MAP.Reg) & 0x3f
}

// CORE1.SYSTIMER_TARGET2_INT_MAP: NA
func (o *CORE1_Type) SetSYSTIMER_TARGET2_INT_MAP_CORE1_SYSTIMER_TARGET2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg, volatile.LoadUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetSYSTIMER_TARGET2_INT_MAP_CORE1_SYSTIMER_TARGET2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SYSTIMER_TARGET2_INT_MAP.Reg) & 0x3f
}

// CORE1.AHB_PDMA_IN_CH0_INT_MAP: NA
func (o *CORE1_Type) SetAHB_PDMA_IN_CH0_INT_MAP_CORE1_AHB_PDMA_IN_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_IN_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_IN_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAHB_PDMA_IN_CH0_INT_MAP_CORE1_AHB_PDMA_IN_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_IN_CH0_INT_MAP.Reg) & 0x3f
}

// CORE1.AHB_PDMA_IN_CH1_INT_MAP: NA
func (o *CORE1_Type) SetAHB_PDMA_IN_CH1_INT_MAP_CORE1_AHB_PDMA_IN_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_IN_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_IN_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAHB_PDMA_IN_CH1_INT_MAP_CORE1_AHB_PDMA_IN_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_IN_CH1_INT_MAP.Reg) & 0x3f
}

// CORE1.AHB_PDMA_IN_CH2_INT_MAP: NA
func (o *CORE1_Type) SetAHB_PDMA_IN_CH2_INT_MAP_CORE1_AHB_PDMA_IN_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_IN_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_IN_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAHB_PDMA_IN_CH2_INT_MAP_CORE1_AHB_PDMA_IN_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_IN_CH2_INT_MAP.Reg) & 0x3f
}

// CORE1.AHB_PDMA_OUT_CH0_INT_MAP: NA
func (o *CORE1_Type) SetAHB_PDMA_OUT_CH0_INT_MAP_CORE1_AHB_PDMA_OUT_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_OUT_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_OUT_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAHB_PDMA_OUT_CH0_INT_MAP_CORE1_AHB_PDMA_OUT_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_OUT_CH0_INT_MAP.Reg) & 0x3f
}

// CORE1.AHB_PDMA_OUT_CH1_INT_MAP: NA
func (o *CORE1_Type) SetAHB_PDMA_OUT_CH1_INT_MAP_CORE1_AHB_PDMA_OUT_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_OUT_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_OUT_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAHB_PDMA_OUT_CH1_INT_MAP_CORE1_AHB_PDMA_OUT_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_OUT_CH1_INT_MAP.Reg) & 0x3f
}

// CORE1.AHB_PDMA_OUT_CH2_INT_MAP: NA
func (o *CORE1_Type) SetAHB_PDMA_OUT_CH2_INT_MAP_CORE1_AHB_PDMA_OUT_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AHB_PDMA_OUT_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.AHB_PDMA_OUT_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAHB_PDMA_OUT_CH2_INT_MAP_CORE1_AHB_PDMA_OUT_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AHB_PDMA_OUT_CH2_INT_MAP.Reg) & 0x3f
}

// CORE1.AXI_PDMA_IN_CH0_INT_MAP: NA
func (o *CORE1_Type) SetAXI_PDMA_IN_CH0_INT_MAP_CORE1_AXI_PDMA_IN_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_IN_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_IN_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAXI_PDMA_IN_CH0_INT_MAP_CORE1_AXI_PDMA_IN_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_IN_CH0_INT_MAP.Reg) & 0x3f
}

// CORE1.AXI_PDMA_IN_CH1_INT_MAP: NA
func (o *CORE1_Type) SetAXI_PDMA_IN_CH1_INT_MAP_CORE1_AXI_PDMA_IN_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_IN_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_IN_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAXI_PDMA_IN_CH1_INT_MAP_CORE1_AXI_PDMA_IN_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_IN_CH1_INT_MAP.Reg) & 0x3f
}

// CORE1.AXI_PDMA_IN_CH2_INT_MAP: NA
func (o *CORE1_Type) SetAXI_PDMA_IN_CH2_INT_MAP_CORE1_AXI_PDMA_IN_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_IN_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_IN_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAXI_PDMA_IN_CH2_INT_MAP_CORE1_AXI_PDMA_IN_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_IN_CH2_INT_MAP.Reg) & 0x3f
}

// CORE1.AXI_PDMA_OUT_CH0_INT_MAP: NA
func (o *CORE1_Type) SetAXI_PDMA_OUT_CH0_INT_MAP_CORE1_AXI_PDMA_OUT_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_OUT_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_OUT_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAXI_PDMA_OUT_CH0_INT_MAP_CORE1_AXI_PDMA_OUT_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_OUT_CH0_INT_MAP.Reg) & 0x3f
}

// CORE1.AXI_PDMA_OUT_CH1_INT_MAP: NA
func (o *CORE1_Type) SetAXI_PDMA_OUT_CH1_INT_MAP_CORE1_AXI_PDMA_OUT_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_OUT_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_OUT_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAXI_PDMA_OUT_CH1_INT_MAP_CORE1_AXI_PDMA_OUT_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_OUT_CH1_INT_MAP.Reg) & 0x3f
}

// CORE1.AXI_PDMA_OUT_CH2_INT_MAP: NA
func (o *CORE1_Type) SetAXI_PDMA_OUT_CH2_INT_MAP_CORE1_AXI_PDMA_OUT_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AXI_PDMA_OUT_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.AXI_PDMA_OUT_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAXI_PDMA_OUT_CH2_INT_MAP_CORE1_AXI_PDMA_OUT_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AXI_PDMA_OUT_CH2_INT_MAP.Reg) & 0x3f
}

// CORE1.RSA_INT_MAP: NA
func (o *CORE1_Type) SetRSA_INT_MAP_CORE1_RSA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.RSA_INT_MAP.Reg, volatile.LoadUint32(&o.RSA_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetRSA_INT_MAP_CORE1_RSA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.RSA_INT_MAP.Reg) & 0x3f
}

// CORE1.AES_INT_MAP: NA
func (o *CORE1_Type) SetAES_INT_MAP_CORE1_AES_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.AES_INT_MAP.Reg, volatile.LoadUint32(&o.AES_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetAES_INT_MAP_CORE1_AES_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.AES_INT_MAP.Reg) & 0x3f
}

// CORE1.SHA_INT_MAP: NA
func (o *CORE1_Type) SetSHA_INT_MAP_CORE1_SHA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SHA_INT_MAP.Reg, volatile.LoadUint32(&o.SHA_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetSHA_INT_MAP_CORE1_SHA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SHA_INT_MAP.Reg) & 0x3f
}

// CORE1.ECC_INT_MAP: NA
func (o *CORE1_Type) SetECC_INT_MAP_CORE1_ECC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ECC_INT_MAP.Reg, volatile.LoadUint32(&o.ECC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetECC_INT_MAP_CORE1_ECC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ECC_INT_MAP.Reg) & 0x3f
}

// CORE1.ECDSA_INT_MAP: NA
func (o *CORE1_Type) SetECDSA_INT_MAP_CORE1_ECDSA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ECDSA_INT_MAP.Reg, volatile.LoadUint32(&o.ECDSA_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetECDSA_INT_MAP_CORE1_ECDSA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ECDSA_INT_MAP.Reg) & 0x3f
}

// CORE1.KM_INT_MAP: NA
func (o *CORE1_Type) SetKM_INT_MAP_CORE1_KM_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.KM_INT_MAP.Reg, volatile.LoadUint32(&o.KM_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetKM_INT_MAP_CORE1_KM_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.KM_INT_MAP.Reg) & 0x3f
}

// CORE1.GPIO_INT0_MAP: NA
func (o *CORE1_Type) SetGPIO_INT0_MAP_CORE1_GPIO_INT0_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INT0_MAP.Reg, volatile.LoadUint32(&o.GPIO_INT0_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetGPIO_INT0_MAP_CORE1_GPIO_INT0_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INT0_MAP.Reg) & 0x3f
}

// CORE1.GPIO_INT1_MAP: NA
func (o *CORE1_Type) SetGPIO_INT1_MAP_CORE1_GPIO_INT1_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INT1_MAP.Reg, volatile.LoadUint32(&o.GPIO_INT1_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetGPIO_INT1_MAP_CORE1_GPIO_INT1_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INT1_MAP.Reg) & 0x3f
}

// CORE1.GPIO_INT2_MAP: NA
func (o *CORE1_Type) SetGPIO_INT2_MAP_CORE1_GPIO_INT2_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INT2_MAP.Reg, volatile.LoadUint32(&o.GPIO_INT2_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetGPIO_INT2_MAP_CORE1_GPIO_INT2_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INT2_MAP.Reg) & 0x3f
}

// CORE1.GPIO_INT3_MAP: NA
func (o *CORE1_Type) SetGPIO_INT3_MAP_CORE1_GPIO_INT3_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_INT3_MAP.Reg, volatile.LoadUint32(&o.GPIO_INT3_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetGPIO_INT3_MAP_CORE1_GPIO_INT3_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_INT3_MAP.Reg) & 0x3f
}

// CORE1.GPIO_PAD_COMP_INT_MAP: NA
func (o *CORE1_Type) SetGPIO_PAD_COMP_INT_MAP_CORE1_GPIO_PAD_COMP_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.GPIO_PAD_COMP_INT_MAP.Reg, volatile.LoadUint32(&o.GPIO_PAD_COMP_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetGPIO_PAD_COMP_INT_MAP_CORE1_GPIO_PAD_COMP_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.GPIO_PAD_COMP_INT_MAP.Reg) & 0x3f
}

// CORE1.CPU_INT_FROM_CPU_0_MAP: NA
func (o *CORE1_Type) SetCPU_INT_FROM_CPU_0_MAP_CORE1_CPU_INT_FROM_CPU_0_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_FROM_CPU_0_MAP.Reg, volatile.LoadUint32(&o.CPU_INT_FROM_CPU_0_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCPU_INT_FROM_CPU_0_MAP_CORE1_CPU_INT_FROM_CPU_0_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_FROM_CPU_0_MAP.Reg) & 0x3f
}

// CORE1.CPU_INT_FROM_CPU_1_MAP: NA
func (o *CORE1_Type) SetCPU_INT_FROM_CPU_1_MAP_CORE1_CPU_INT_FROM_CPU_1_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_FROM_CPU_1_MAP.Reg, volatile.LoadUint32(&o.CPU_INT_FROM_CPU_1_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCPU_INT_FROM_CPU_1_MAP_CORE1_CPU_INT_FROM_CPU_1_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_FROM_CPU_1_MAP.Reg) & 0x3f
}

// CORE1.CPU_INT_FROM_CPU_2_MAP: NA
func (o *CORE1_Type) SetCPU_INT_FROM_CPU_2_MAP_CORE1_CPU_INT_FROM_CPU_2_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_FROM_CPU_2_MAP.Reg, volatile.LoadUint32(&o.CPU_INT_FROM_CPU_2_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCPU_INT_FROM_CPU_2_MAP_CORE1_CPU_INT_FROM_CPU_2_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_FROM_CPU_2_MAP.Reg) & 0x3f
}

// CORE1.CPU_INT_FROM_CPU_3_MAP: NA
func (o *CORE1_Type) SetCPU_INT_FROM_CPU_3_MAP_CORE1_CPU_INT_FROM_CPU_3_MAP(value uint32) {
	volatile.StoreUint32(&o.CPU_INT_FROM_CPU_3_MAP.Reg, volatile.LoadUint32(&o.CPU_INT_FROM_CPU_3_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCPU_INT_FROM_CPU_3_MAP_CORE1_CPU_INT_FROM_CPU_3_MAP() uint32 {
	return volatile.LoadUint32(&o.CPU_INT_FROM_CPU_3_MAP.Reg) & 0x3f
}

// CORE1.CACHE_INT_MAP: NA
func (o *CORE1_Type) SetCACHE_INT_MAP_CORE1_CACHE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CACHE_INT_MAP.Reg, volatile.LoadUint32(&o.CACHE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCACHE_INT_MAP_CORE1_CACHE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CACHE_INT_MAP.Reg) & 0x3f
}

// CORE1.FLASH_MSPI_INT_MAP: NA
func (o *CORE1_Type) SetFLASH_MSPI_INT_MAP_CORE1_FLASH_MSPI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.FLASH_MSPI_INT_MAP.Reg, volatile.LoadUint32(&o.FLASH_MSPI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetFLASH_MSPI_INT_MAP_CORE1_FLASH_MSPI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.FLASH_MSPI_INT_MAP.Reg) & 0x3f
}

// CORE1.CSI_BRIDGE_INT_MAP: NA
func (o *CORE1_Type) SetCSI_BRIDGE_INT_MAP_CORE1_CSI_BRIDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CSI_BRIDGE_INT_MAP.Reg, volatile.LoadUint32(&o.CSI_BRIDGE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCSI_BRIDGE_INT_MAP_CORE1_CSI_BRIDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CSI_BRIDGE_INT_MAP.Reg) & 0x3f
}

// CORE1.DSI_BRIDGE_INT_MAP: NA
func (o *CORE1_Type) SetDSI_BRIDGE_INT_MAP_CORE1_DSI_BRIDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DSI_BRIDGE_INT_MAP.Reg, volatile.LoadUint32(&o.DSI_BRIDGE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetDSI_BRIDGE_INT_MAP_CORE1_DSI_BRIDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DSI_BRIDGE_INT_MAP.Reg) & 0x3f
}

// CORE1.CSI_INT_MAP: NA
func (o *CORE1_Type) SetCSI_INT_MAP_CORE1_CSI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CSI_INT_MAP.Reg, volatile.LoadUint32(&o.CSI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCSI_INT_MAP_CORE1_CSI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CSI_INT_MAP.Reg) & 0x3f
}

// CORE1.DSI_INT_MAP: NA
func (o *CORE1_Type) SetDSI_INT_MAP_CORE1_DSI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DSI_INT_MAP.Reg, volatile.LoadUint32(&o.DSI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetDSI_INT_MAP_CORE1_DSI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DSI_INT_MAP.Reg) & 0x3f
}

// CORE1.GMII_PHY_INT_MAP: NA
func (o *CORE1_Type) SetGMII_PHY_INT_MAP_CORE1_GMII_PHY_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.GMII_PHY_INT_MAP.Reg, volatile.LoadUint32(&o.GMII_PHY_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetGMII_PHY_INT_MAP_CORE1_GMII_PHY_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.GMII_PHY_INT_MAP.Reg) & 0x3f
}

// CORE1.LPI_INT_MAP: NA
func (o *CORE1_Type) SetLPI_INT_MAP_CORE1_LPI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.LPI_INT_MAP.Reg, volatile.LoadUint32(&o.LPI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetLPI_INT_MAP_CORE1_LPI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.LPI_INT_MAP.Reg) & 0x3f
}

// CORE1.PMT_INT_MAP: NA
func (o *CORE1_Type) SetPMT_INT_MAP_CORE1_PMT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PMT_INT_MAP.Reg, volatile.LoadUint32(&o.PMT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetPMT_INT_MAP_CORE1_PMT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PMT_INT_MAP.Reg) & 0x3f
}

// CORE1.SBD_INT_MAP: NA
func (o *CORE1_Type) SetSBD_INT_MAP_CORE1_SBD_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.SBD_INT_MAP.Reg, volatile.LoadUint32(&o.SBD_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetSBD_INT_MAP_CORE1_SBD_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.SBD_INT_MAP.Reg) & 0x3f
}

// CORE1.USB_OTG_INT_MAP: NA
func (o *CORE1_Type) SetUSB_OTG_INT_MAP_CORE1_USB_OTG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.USB_OTG_INT_MAP.Reg, volatile.LoadUint32(&o.USB_OTG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetUSB_OTG_INT_MAP_CORE1_USB_OTG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.USB_OTG_INT_MAP.Reg) & 0x3f
}

// CORE1.USB_OTG_ENDP_MULTI_PROC_INT_MAP: NA
func (o *CORE1_Type) SetUSB_OTG_ENDP_MULTI_PROC_INT_MAP_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.USB_OTG_ENDP_MULTI_PROC_INT_MAP.Reg, volatile.LoadUint32(&o.USB_OTG_ENDP_MULTI_PROC_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetUSB_OTG_ENDP_MULTI_PROC_INT_MAP_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.USB_OTG_ENDP_MULTI_PROC_INT_MAP.Reg) & 0x3f
}

// CORE1.JPEG_INT_MAP: NA
func (o *CORE1_Type) SetJPEG_INT_MAP_CORE1_JPEG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.JPEG_INT_MAP.Reg, volatile.LoadUint32(&o.JPEG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetJPEG_INT_MAP_CORE1_JPEG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.JPEG_INT_MAP.Reg) & 0x3f
}

// CORE1.PPA_INT_MAP: NA
func (o *CORE1_Type) SetPPA_INT_MAP_CORE1_PPA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PPA_INT_MAP.Reg, volatile.LoadUint32(&o.PPA_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetPPA_INT_MAP_CORE1_PPA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PPA_INT_MAP.Reg) & 0x3f
}

// CORE1.CORE0_TRACE_INT_MAP: NA
func (o *CORE1_Type) SetCORE0_TRACE_INT_MAP_CORE1_CORE0_TRACE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CORE0_TRACE_INT_MAP.Reg, volatile.LoadUint32(&o.CORE0_TRACE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCORE0_TRACE_INT_MAP_CORE1_CORE0_TRACE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CORE0_TRACE_INT_MAP.Reg) & 0x3f
}

// CORE1.CORE1_TRACE_INT_MAP: NA
func (o *CORE1_Type) SetCORE1_TRACE_INT_MAP_CORE1_CORE1_TRACE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.CORE1_TRACE_INT_MAP.Reg, volatile.LoadUint32(&o.CORE1_TRACE_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetCORE1_TRACE_INT_MAP_CORE1_CORE1_TRACE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.CORE1_TRACE_INT_MAP.Reg) & 0x3f
}

// CORE1.HP_CORE_CTRL_INT_MAP: NA
func (o *CORE1_Type) SetHP_CORE_CTRL_INT_MAP_CORE1_HP_CORE_CTRL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.HP_CORE_CTRL_INT_MAP.Reg, volatile.LoadUint32(&o.HP_CORE_CTRL_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetHP_CORE_CTRL_INT_MAP_CORE1_HP_CORE_CTRL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.HP_CORE_CTRL_INT_MAP.Reg) & 0x3f
}

// CORE1.ISP_INT_MAP: NA
func (o *CORE1_Type) SetISP_INT_MAP_CORE1_ISP_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ISP_INT_MAP.Reg, volatile.LoadUint32(&o.ISP_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetISP_INT_MAP_CORE1_ISP_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ISP_INT_MAP.Reg) & 0x3f
}

// CORE1.I3C_MST_INT_MAP: NA
func (o *CORE1_Type) SetI3C_MST_INT_MAP_CORE1_I3C_MST_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I3C_MST_INT_MAP.Reg, volatile.LoadUint32(&o.I3C_MST_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetI3C_MST_INT_MAP_CORE1_I3C_MST_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I3C_MST_INT_MAP.Reg) & 0x3f
}

// CORE1.I3C_SLV_INT_MAP: NA
func (o *CORE1_Type) SetI3C_SLV_INT_MAP_CORE1_I3C_SLV_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.I3C_SLV_INT_MAP.Reg, volatile.LoadUint32(&o.I3C_SLV_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetI3C_SLV_INT_MAP_CORE1_I3C_SLV_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.I3C_SLV_INT_MAP.Reg) & 0x3f
}

// CORE1.USB_OTG11_INT_MAP: NA
func (o *CORE1_Type) SetUSB_OTG11_INT_MAP_CORE1_USB_OTG11_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.USB_OTG11_INT_MAP.Reg, volatile.LoadUint32(&o.USB_OTG11_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetUSB_OTG11_INT_MAP_CORE1_USB_OTG11_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.USB_OTG11_INT_MAP.Reg) & 0x3f
}

// CORE1.DMA2D_IN_CH0_INT_MAP: NA
func (o *CORE1_Type) SetDMA2D_IN_CH0_INT_MAP_CORE1_DMA2D_IN_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA2D_IN_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.DMA2D_IN_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetDMA2D_IN_CH0_INT_MAP_CORE1_DMA2D_IN_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA2D_IN_CH0_INT_MAP.Reg) & 0x3f
}

// CORE1.DMA2D_IN_CH1_INT_MAP: NA
func (o *CORE1_Type) SetDMA2D_IN_CH1_INT_MAP_CORE1_DMA2D_IN_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA2D_IN_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.DMA2D_IN_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetDMA2D_IN_CH1_INT_MAP_CORE1_DMA2D_IN_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA2D_IN_CH1_INT_MAP.Reg) & 0x3f
}

// CORE1.DMA2D_OUT_CH0_INT_MAP: NA
func (o *CORE1_Type) SetDMA2D_OUT_CH0_INT_MAP_CORE1_DMA2D_OUT_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA2D_OUT_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.DMA2D_OUT_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetDMA2D_OUT_CH0_INT_MAP_CORE1_DMA2D_OUT_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA2D_OUT_CH0_INT_MAP.Reg) & 0x3f
}

// CORE1.DMA2D_OUT_CH1_INT_MAP: NA
func (o *CORE1_Type) SetDMA2D_OUT_CH1_INT_MAP_CORE1_DMA2D_OUT_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA2D_OUT_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.DMA2D_OUT_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetDMA2D_OUT_CH1_INT_MAP_CORE1_DMA2D_OUT_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA2D_OUT_CH1_INT_MAP.Reg) & 0x3f
}

// CORE1.DMA2D_OUT_CH2_INT_MAP: NA
func (o *CORE1_Type) SetDMA2D_OUT_CH2_INT_MAP_CORE1_DMA2D_OUT_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.DMA2D_OUT_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.DMA2D_OUT_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetDMA2D_OUT_CH2_INT_MAP_CORE1_DMA2D_OUT_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.DMA2D_OUT_CH2_INT_MAP.Reg) & 0x3f
}

// CORE1.PSRAM_MSPI_INT_MAP: NA
func (o *CORE1_Type) SetPSRAM_MSPI_INT_MAP_CORE1_PSRAM_MSPI_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PSRAM_MSPI_INT_MAP.Reg, volatile.LoadUint32(&o.PSRAM_MSPI_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetPSRAM_MSPI_INT_MAP_CORE1_PSRAM_MSPI_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PSRAM_MSPI_INT_MAP.Reg) & 0x3f
}

// CORE1.HP_SYSREG_INT_MAP: NA
func (o *CORE1_Type) SetHP_SYSREG_INT_MAP_CORE1_HP_SYSREG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.HP_SYSREG_INT_MAP.Reg, volatile.LoadUint32(&o.HP_SYSREG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetHP_SYSREG_INT_MAP_CORE1_HP_SYSREG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.HP_SYSREG_INT_MAP.Reg) & 0x3f
}

// CORE1.PCNT_INT_MAP: NA
func (o *CORE1_Type) SetPCNT_INT_MAP_CORE1_PCNT_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PCNT_INT_MAP.Reg, volatile.LoadUint32(&o.PCNT_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetPCNT_INT_MAP_CORE1_PCNT_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PCNT_INT_MAP.Reg) & 0x3f
}

// CORE1.HP_PAU_INT_MAP: NA
func (o *CORE1_Type) SetHP_PAU_INT_MAP_CORE1_HP_PAU_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.HP_PAU_INT_MAP.Reg, volatile.LoadUint32(&o.HP_PAU_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetHP_PAU_INT_MAP_CORE1_HP_PAU_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.HP_PAU_INT_MAP.Reg) & 0x3f
}

// CORE1.HP_PARLIO_RX_INT_MAP: NA
func (o *CORE1_Type) SetHP_PARLIO_RX_INT_MAP_CORE1_HP_PARLIO_RX_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.HP_PARLIO_RX_INT_MAP.Reg, volatile.LoadUint32(&o.HP_PARLIO_RX_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetHP_PARLIO_RX_INT_MAP_CORE1_HP_PARLIO_RX_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.HP_PARLIO_RX_INT_MAP.Reg) & 0x3f
}

// CORE1.HP_PARLIO_TX_INT_MAP: NA
func (o *CORE1_Type) SetHP_PARLIO_TX_INT_MAP_CORE1_HP_PARLIO_TX_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.HP_PARLIO_TX_INT_MAP.Reg, volatile.LoadUint32(&o.HP_PARLIO_TX_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetHP_PARLIO_TX_INT_MAP_CORE1_HP_PARLIO_TX_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.HP_PARLIO_TX_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_OUT_CH0_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_OUT_CH0_INT_MAP_CORE1_H264_DMA2D_OUT_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_OUT_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_OUT_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_OUT_CH0_INT_MAP_CORE1_H264_DMA2D_OUT_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_OUT_CH0_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_OUT_CH1_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_OUT_CH1_INT_MAP_CORE1_H264_DMA2D_OUT_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_OUT_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_OUT_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_OUT_CH1_INT_MAP_CORE1_H264_DMA2D_OUT_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_OUT_CH1_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_OUT_CH2_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_OUT_CH2_INT_MAP_CORE1_H264_DMA2D_OUT_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_OUT_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_OUT_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_OUT_CH2_INT_MAP_CORE1_H264_DMA2D_OUT_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_OUT_CH2_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_OUT_CH3_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_OUT_CH3_INT_MAP_CORE1_H264_DMA2D_OUT_CH3_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_OUT_CH3_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_OUT_CH3_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_OUT_CH3_INT_MAP_CORE1_H264_DMA2D_OUT_CH3_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_OUT_CH3_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_OUT_CH4_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_OUT_CH4_INT_MAP_CORE1_H264_DMA2D_OUT_CH4_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_OUT_CH4_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_OUT_CH4_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_OUT_CH4_INT_MAP_CORE1_H264_DMA2D_OUT_CH4_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_OUT_CH4_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_IN_CH0_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_IN_CH0_INT_MAP_CORE1_H264_DMA2D_IN_CH0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH0_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH0_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_IN_CH0_INT_MAP_CORE1_H264_DMA2D_IN_CH0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH0_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_IN_CH1_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_IN_CH1_INT_MAP_CORE1_H264_DMA2D_IN_CH1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH1_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH1_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_IN_CH1_INT_MAP_CORE1_H264_DMA2D_IN_CH1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH1_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_IN_CH2_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_IN_CH2_INT_MAP_CORE1_H264_DMA2D_IN_CH2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH2_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH2_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_IN_CH2_INT_MAP_CORE1_H264_DMA2D_IN_CH2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH2_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_IN_CH3_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_IN_CH3_INT_MAP_CORE1_H264_DMA2D_IN_CH3_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH3_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH3_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_IN_CH3_INT_MAP_CORE1_H264_DMA2D_IN_CH3_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH3_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_IN_CH4_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_IN_CH4_INT_MAP_CORE1_H264_DMA2D_IN_CH4_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH4_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH4_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_IN_CH4_INT_MAP_CORE1_H264_DMA2D_IN_CH4_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH4_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_DMA2D_IN_CH5_INT_MAP: NA
func (o *CORE1_Type) SetH264_DMA2D_IN_CH5_INT_MAP_CORE1_H264_DMA2D_IN_CH5_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_DMA2D_IN_CH5_INT_MAP.Reg, volatile.LoadUint32(&o.H264_DMA2D_IN_CH5_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_DMA2D_IN_CH5_INT_MAP_CORE1_H264_DMA2D_IN_CH5_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_DMA2D_IN_CH5_INT_MAP.Reg) & 0x3f
}

// CORE1.H264_REG_INT_MAP: NA
func (o *CORE1_Type) SetH264_REG_INT_MAP_CORE1_H264_REG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.H264_REG_INT_MAP.Reg, volatile.LoadUint32(&o.H264_REG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetH264_REG_INT_MAP_CORE1_H264_REG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.H264_REG_INT_MAP.Reg) & 0x3f
}

// CORE1.ASSIST_DEBUG_INT_MAP: NA
func (o *CORE1_Type) SetASSIST_DEBUG_INT_MAP_CORE1_ASSIST_DEBUG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.ASSIST_DEBUG_INT_MAP.Reg, volatile.LoadUint32(&o.ASSIST_DEBUG_INT_MAP.Reg)&^(0x3f)|value)
}
func (o *CORE1_Type) GetASSIST_DEBUG_INT_MAP_CORE1_ASSIST_DEBUG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.ASSIST_DEBUG_INT_MAP.Reg) & 0x3f
}

// CORE1.INTR_STATUS_REG_0: NA
func (o *CORE1_Type) SetINTR_STATUS_REG_0(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_0.Reg, value)
}
func (o *CORE1_Type) GetINTR_STATUS_REG_0() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_0.Reg)
}

// CORE1.INTR_STATUS_REG_1: NA
func (o *CORE1_Type) SetINTR_STATUS_REG_1(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_1.Reg, value)
}
func (o *CORE1_Type) GetINTR_STATUS_REG_1() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_1.Reg)
}

// CORE1.INTR_STATUS_REG_2: NA
func (o *CORE1_Type) SetINTR_STATUS_REG_2(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_2.Reg, value)
}
func (o *CORE1_Type) GetINTR_STATUS_REG_2() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_2.Reg)
}

// CORE1.INTR_STATUS_REG_3: NA
func (o *CORE1_Type) SetINTR_STATUS_REG_3(value uint32) {
	volatile.StoreUint32(&o.INTR_STATUS_REG_3.Reg, value)
}
func (o *CORE1_Type) GetINTR_STATUS_REG_3() uint32 {
	return volatile.LoadUint32(&o.INTR_STATUS_REG_3.Reg)
}

// CORE1.CLOCK_GATE: NA
func (o *CORE1_Type) SetCLOCK_GATE_CORE1_REG_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *CORE1_Type) GetCLOCK_GATE_CORE1_REG_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// CORE1.INTERRUPT_REG_DATE: NA
func (o *CORE1_Type) SetINTERRUPT_REG_DATE_CORE1_INTERRUPT_REG_DATE(value uint32) {
	volatile.StoreUint32(&o.INTERRUPT_REG_DATE.Reg, volatile.LoadUint32(&o.INTERRUPT_REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *CORE1_Type) GetINTERRUPT_REG_DATE_CORE1_INTERRUPT_REG_DATE() uint32 {
	return volatile.LoadUint32(&o.INTERRUPT_REG_DATE.Reg) & 0xfffffff
}

// MIPI Camera Interface Bridge
type CSI_BRIG_Type struct {
	CLK_EN           volatile.Register32 // 0x0
	CSI_EN           volatile.Register32 // 0x4
	DMA_REQ_CFG      volatile.Register32 // 0x8
	BUF_FLOW_CTL     volatile.Register32 // 0xC
	DATA_TYPE_CFG    volatile.Register32 // 0x10
	FRAME_CFG        volatile.Register32 // 0x14
	ENDIAN_MODE      volatile.Register32 // 0x18
	INT_RAW          volatile.Register32 // 0x1C
	INT_CLR          volatile.Register32 // 0x20
	INT_ST           volatile.Register32 // 0x24
	INT_ENA          volatile.Register32 // 0x28
	DMA_REQ_INTERVAL volatile.Register32 // 0x2C
	DMABLK_SIZE      volatile.Register32 // 0x30
	RDN_ECO_CS       volatile.Register32 // 0x34
	RDN_ECO_LOW      volatile.Register32 // 0x38
	RDN_ECO_HIGH     volatile.Register32 // 0x3C
	HOST_CTRL        volatile.Register32 // 0x40
	MEM_CTRL         volatile.Register32 // 0x44
}

// CSI_BRIG.CLK_EN: csi bridge register mapping unit clock gating.
func (o *CSI_BRIG_Type) SetCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK_EN.Reg, volatile.LoadUint32(&o.CLK_EN.Reg)&^(0x1)|value)
}
func (o *CSI_BRIG_Type) GetCLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLK_EN.Reg) & 0x1
}

// CSI_BRIG.CSI_EN: csi bridge enable.
func (o *CSI_BRIG_Type) SetCSI_EN_CSI_BRIG_EN(value uint32) {
	volatile.StoreUint32(&o.CSI_EN.Reg, volatile.LoadUint32(&o.CSI_EN.Reg)&^(0x1)|value)
}
func (o *CSI_BRIG_Type) GetCSI_EN_CSI_BRIG_EN() uint32 {
	return volatile.LoadUint32(&o.CSI_EN.Reg) & 0x1
}

// CSI_BRIG.DMA_REQ_CFG: dma request configuration.
func (o *CSI_BRIG_Type) SetDMA_REQ_CFG_DMA_BURST_LEN(value uint32) {
	volatile.StoreUint32(&o.DMA_REQ_CFG.Reg, volatile.LoadUint32(&o.DMA_REQ_CFG.Reg)&^(0xfff)|value)
}
func (o *CSI_BRIG_Type) GetDMA_REQ_CFG_DMA_BURST_LEN() uint32 {
	return volatile.LoadUint32(&o.DMA_REQ_CFG.Reg) & 0xfff
}
func (o *CSI_BRIG_Type) SetDMA_REQ_CFG_DMA_CFG_UPD_BY_BLK(value uint32) {
	volatile.StoreUint32(&o.DMA_REQ_CFG.Reg, volatile.LoadUint32(&o.DMA_REQ_CFG.Reg)&^(0x1000)|value<<12)
}
func (o *CSI_BRIG_Type) GetDMA_REQ_CFG_DMA_CFG_UPD_BY_BLK() uint32 {
	return (volatile.LoadUint32(&o.DMA_REQ_CFG.Reg) & 0x1000) >> 12
}
func (o *CSI_BRIG_Type) SetDMA_REQ_CFG_DMA_FORCE_RD_STATUS(value uint32) {
	volatile.StoreUint32(&o.DMA_REQ_CFG.Reg, volatile.LoadUint32(&o.DMA_REQ_CFG.Reg)&^(0x10000)|value<<16)
}
func (o *CSI_BRIG_Type) GetDMA_REQ_CFG_DMA_FORCE_RD_STATUS() uint32 {
	return (volatile.LoadUint32(&o.DMA_REQ_CFG.Reg) & 0x10000) >> 16
}

// CSI_BRIG.BUF_FLOW_CTL: csi bridge buffer control.
func (o *CSI_BRIG_Type) SetBUF_FLOW_CTL_CSI_BUF_AFULL_THRD(value uint32) {
	volatile.StoreUint32(&o.BUF_FLOW_CTL.Reg, volatile.LoadUint32(&o.BUF_FLOW_CTL.Reg)&^(0x3fff)|value)
}
func (o *CSI_BRIG_Type) GetBUF_FLOW_CTL_CSI_BUF_AFULL_THRD() uint32 {
	return volatile.LoadUint32(&o.BUF_FLOW_CTL.Reg) & 0x3fff
}
func (o *CSI_BRIG_Type) SetBUF_FLOW_CTL_CSI_BUF_DEPTH(value uint32) {
	volatile.StoreUint32(&o.BUF_FLOW_CTL.Reg, volatile.LoadUint32(&o.BUF_FLOW_CTL.Reg)&^(0x3fff0000)|value<<16)
}
func (o *CSI_BRIG_Type) GetBUF_FLOW_CTL_CSI_BUF_DEPTH() uint32 {
	return (volatile.LoadUint32(&o.BUF_FLOW_CTL.Reg) & 0x3fff0000) >> 16
}

// CSI_BRIG.DATA_TYPE_CFG: pixel data type configuration.
func (o *CSI_BRIG_Type) SetDATA_TYPE_CFG_DATA_TYPE_MIN(value uint32) {
	volatile.StoreUint32(&o.DATA_TYPE_CFG.Reg, volatile.LoadUint32(&o.DATA_TYPE_CFG.Reg)&^(0x3f)|value)
}
func (o *CSI_BRIG_Type) GetDATA_TYPE_CFG_DATA_TYPE_MIN() uint32 {
	return volatile.LoadUint32(&o.DATA_TYPE_CFG.Reg) & 0x3f
}
func (o *CSI_BRIG_Type) SetDATA_TYPE_CFG_DATA_TYPE_MAX(value uint32) {
	volatile.StoreUint32(&o.DATA_TYPE_CFG.Reg, volatile.LoadUint32(&o.DATA_TYPE_CFG.Reg)&^(0x3f00)|value<<8)
}
func (o *CSI_BRIG_Type) GetDATA_TYPE_CFG_DATA_TYPE_MAX() uint32 {
	return (volatile.LoadUint32(&o.DATA_TYPE_CFG.Reg) & 0x3f00) >> 8
}

// CSI_BRIG.FRAME_CFG: frame configuration.
func (o *CSI_BRIG_Type) SetFRAME_CFG_VADR_NUM(value uint32) {
	volatile.StoreUint32(&o.FRAME_CFG.Reg, volatile.LoadUint32(&o.FRAME_CFG.Reg)&^(0xfff)|value)
}
func (o *CSI_BRIG_Type) GetFRAME_CFG_VADR_NUM() uint32 {
	return volatile.LoadUint32(&o.FRAME_CFG.Reg) & 0xfff
}
func (o *CSI_BRIG_Type) SetFRAME_CFG_HADR_NUM(value uint32) {
	volatile.StoreUint32(&o.FRAME_CFG.Reg, volatile.LoadUint32(&o.FRAME_CFG.Reg)&^(0xfff000)|value<<12)
}
func (o *CSI_BRIG_Type) GetFRAME_CFG_HADR_NUM() uint32 {
	return (volatile.LoadUint32(&o.FRAME_CFG.Reg) & 0xfff000) >> 12
}
func (o *CSI_BRIG_Type) SetFRAME_CFG_HAS_HSYNC_E(value uint32) {
	volatile.StoreUint32(&o.FRAME_CFG.Reg, volatile.LoadUint32(&o.FRAME_CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *CSI_BRIG_Type) GetFRAME_CFG_HAS_HSYNC_E() uint32 {
	return (volatile.LoadUint32(&o.FRAME_CFG.Reg) & 0x1000000) >> 24
}
func (o *CSI_BRIG_Type) SetFRAME_CFG_VADR_NUM_CHECK(value uint32) {
	volatile.StoreUint32(&o.FRAME_CFG.Reg, volatile.LoadUint32(&o.FRAME_CFG.Reg)&^(0x2000000)|value<<25)
}
func (o *CSI_BRIG_Type) GetFRAME_CFG_VADR_NUM_CHECK() uint32 {
	return (volatile.LoadUint32(&o.FRAME_CFG.Reg) & 0x2000000) >> 25
}

// CSI_BRIG.ENDIAN_MODE: data endianness order configuration.
func (o *CSI_BRIG_Type) SetENDIAN_MODE_BYTE_ENDIAN_ORDER(value uint32) {
	volatile.StoreUint32(&o.ENDIAN_MODE.Reg, volatile.LoadUint32(&o.ENDIAN_MODE.Reg)&^(0x1)|value)
}
func (o *CSI_BRIG_Type) GetENDIAN_MODE_BYTE_ENDIAN_ORDER() uint32 {
	return volatile.LoadUint32(&o.ENDIAN_MODE.Reg) & 0x1
}
func (o *CSI_BRIG_Type) SetENDIAN_MODE_BIT_ENDIAN_ORDER(value uint32) {
	volatile.StoreUint32(&o.ENDIAN_MODE.Reg, volatile.LoadUint32(&o.ENDIAN_MODE.Reg)&^(0x2)|value<<1)
}
func (o *CSI_BRIG_Type) GetENDIAN_MODE_BIT_ENDIAN_ORDER() uint32 {
	return (volatile.LoadUint32(&o.ENDIAN_MODE.Reg) & 0x2) >> 1
}

// CSI_BRIG.INT_RAW: csi bridge interrupt raw.
func (o *CSI_BRIG_Type) SetINT_RAW_VADR_NUM_GT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *CSI_BRIG_Type) GetINT_RAW_VADR_NUM_GT_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *CSI_BRIG_Type) SetINT_RAW_VADR_NUM_LT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *CSI_BRIG_Type) GetINT_RAW_VADR_NUM_LT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *CSI_BRIG_Type) SetINT_RAW_DISCARD_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *CSI_BRIG_Type) GetINT_RAW_DISCARD_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *CSI_BRIG_Type) SetINT_RAW_CSI_BUF_OVERRUN_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *CSI_BRIG_Type) GetINT_RAW_CSI_BUF_OVERRUN_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *CSI_BRIG_Type) SetINT_RAW_CSI_ASYNC_FIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *CSI_BRIG_Type) GetINT_RAW_CSI_ASYNC_FIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *CSI_BRIG_Type) SetINT_RAW_DMA_CFG_HAS_UPDATED_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *CSI_BRIG_Type) GetINT_RAW_DMA_CFG_HAS_UPDATED_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}

// CSI_BRIG.INT_CLR: csi bridge interrupt clr.
func (o *CSI_BRIG_Type) SetINT_CLR_VADR_NUM_GT_REAL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *CSI_BRIG_Type) GetINT_CLR_VADR_NUM_GT_REAL_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *CSI_BRIG_Type) SetINT_CLR_VADR_NUM_LT_REAL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *CSI_BRIG_Type) GetINT_CLR_VADR_NUM_LT_REAL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *CSI_BRIG_Type) SetINT_CLR_DISCARD_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *CSI_BRIG_Type) GetINT_CLR_DISCARD_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *CSI_BRIG_Type) SetINT_CLR_CSI_BUF_OVERRUN_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *CSI_BRIG_Type) GetINT_CLR_CSI_BUF_OVERRUN_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *CSI_BRIG_Type) SetINT_CLR_CSI_ASYNC_FIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *CSI_BRIG_Type) GetINT_CLR_CSI_ASYNC_FIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *CSI_BRIG_Type) SetINT_CLR_DMA_CFG_HAS_UPDATED_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *CSI_BRIG_Type) GetINT_CLR_DMA_CFG_HAS_UPDATED_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}

// CSI_BRIG.INT_ST: csi bridge interrupt st.
func (o *CSI_BRIG_Type) SetINT_ST_VADR_NUM_GT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *CSI_BRIG_Type) GetINT_ST_VADR_NUM_GT_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *CSI_BRIG_Type) SetINT_ST_VADR_NUM_LT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *CSI_BRIG_Type) GetINT_ST_VADR_NUM_LT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *CSI_BRIG_Type) SetINT_ST_DISCARD_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *CSI_BRIG_Type) GetINT_ST_DISCARD_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *CSI_BRIG_Type) SetINT_ST_CSI_BUF_OVERRUN_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *CSI_BRIG_Type) GetINT_ST_CSI_BUF_OVERRUN_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}
func (o *CSI_BRIG_Type) SetINT_ST_CSI_ASYNC_FIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *CSI_BRIG_Type) GetINT_ST_CSI_ASYNC_FIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10) >> 4
}
func (o *CSI_BRIG_Type) SetINT_ST_DMA_CFG_HAS_UPDATED_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *CSI_BRIG_Type) GetINT_ST_DMA_CFG_HAS_UPDATED_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20) >> 5
}

// CSI_BRIG.INT_ENA: csi bridge interrupt enable.
func (o *CSI_BRIG_Type) SetINT_ENA_VADR_NUM_GT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *CSI_BRIG_Type) GetINT_ENA_VADR_NUM_GT_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *CSI_BRIG_Type) SetINT_ENA_VADR_NUM_LT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *CSI_BRIG_Type) GetINT_ENA_VADR_NUM_LT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *CSI_BRIG_Type) SetINT_ENA_DISCARD_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *CSI_BRIG_Type) GetINT_ENA_DISCARD_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *CSI_BRIG_Type) SetINT_ENA_CSI_BUF_OVERRUN_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *CSI_BRIG_Type) GetINT_ENA_CSI_BUF_OVERRUN_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *CSI_BRIG_Type) SetINT_ENA_CSI_ASYNC_FIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *CSI_BRIG_Type) GetINT_ENA_CSI_ASYNC_FIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *CSI_BRIG_Type) SetINT_ENA_DMA_CFG_HAS_UPDATED_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *CSI_BRIG_Type) GetINT_ENA_DMA_CFG_HAS_UPDATED_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}

// CSI_BRIG.DMA_REQ_INTERVAL: DMA interval configuration.
func (o *CSI_BRIG_Type) SetDMA_REQ_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.DMA_REQ_INTERVAL.Reg, volatile.LoadUint32(&o.DMA_REQ_INTERVAL.Reg)&^(0xffff)|value)
}
func (o *CSI_BRIG_Type) GetDMA_REQ_INTERVAL() uint32 {
	return volatile.LoadUint32(&o.DMA_REQ_INTERVAL.Reg) & 0xffff
}

// CSI_BRIG.DMABLK_SIZE: DMA block size configuration.
func (o *CSI_BRIG_Type) SetDMABLK_SIZE(value uint32) {
	volatile.StoreUint32(&o.DMABLK_SIZE.Reg, volatile.LoadUint32(&o.DMABLK_SIZE.Reg)&^(0x1fff)|value)
}
func (o *CSI_BRIG_Type) GetDMABLK_SIZE() uint32 {
	return volatile.LoadUint32(&o.DMABLK_SIZE.Reg) & 0x1fff
}

// CSI_BRIG.RDN_ECO_CS: N/A
func (o *CSI_BRIG_Type) SetRDN_ECO_CS_RDN_ECO_EN(value uint32) {
	volatile.StoreUint32(&o.RDN_ECO_CS.Reg, volatile.LoadUint32(&o.RDN_ECO_CS.Reg)&^(0x1)|value)
}
func (o *CSI_BRIG_Type) GetRDN_ECO_CS_RDN_ECO_EN() uint32 {
	return volatile.LoadUint32(&o.RDN_ECO_CS.Reg) & 0x1
}
func (o *CSI_BRIG_Type) SetRDN_ECO_CS_RDN_ECO_RESULT(value uint32) {
	volatile.StoreUint32(&o.RDN_ECO_CS.Reg, volatile.LoadUint32(&o.RDN_ECO_CS.Reg)&^(0x2)|value<<1)
}
func (o *CSI_BRIG_Type) GetRDN_ECO_CS_RDN_ECO_RESULT() uint32 {
	return (volatile.LoadUint32(&o.RDN_ECO_CS.Reg) & 0x2) >> 1
}

// CSI_BRIG.RDN_ECO_LOW: N/A
func (o *CSI_BRIG_Type) SetRDN_ECO_LOW(value uint32) {
	volatile.StoreUint32(&o.RDN_ECO_LOW.Reg, value)
}
func (o *CSI_BRIG_Type) GetRDN_ECO_LOW() uint32 {
	return volatile.LoadUint32(&o.RDN_ECO_LOW.Reg)
}

// CSI_BRIG.RDN_ECO_HIGH: N/A
func (o *CSI_BRIG_Type) SetRDN_ECO_HIGH(value uint32) {
	volatile.StoreUint32(&o.RDN_ECO_HIGH.Reg, value)
}
func (o *CSI_BRIG_Type) GetRDN_ECO_HIGH() uint32 {
	return volatile.LoadUint32(&o.RDN_ECO_HIGH.Reg)
}

// CSI_BRIG.HOST_CTRL: csi host control by csi bridge.
func (o *CSI_BRIG_Type) SetHOST_CTRL_CSI_ENABLECLK(value uint32) {
	volatile.StoreUint32(&o.HOST_CTRL.Reg, volatile.LoadUint32(&o.HOST_CTRL.Reg)&^(0x1)|value)
}
func (o *CSI_BRIG_Type) GetHOST_CTRL_CSI_ENABLECLK() uint32 {
	return volatile.LoadUint32(&o.HOST_CTRL.Reg) & 0x1
}
func (o *CSI_BRIG_Type) SetHOST_CTRL_CSI_CFG_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.HOST_CTRL.Reg, volatile.LoadUint32(&o.HOST_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_BRIG_Type) GetHOST_CTRL_CSI_CFG_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.HOST_CTRL.Reg) & 0x2) >> 1
}
func (o *CSI_BRIG_Type) SetHOST_CTRL_LOOPBK_TEST_EN(value uint32) {
	volatile.StoreUint32(&o.HOST_CTRL.Reg, volatile.LoadUint32(&o.HOST_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *CSI_BRIG_Type) GetHOST_CTRL_LOOPBK_TEST_EN() uint32 {
	return (volatile.LoadUint32(&o.HOST_CTRL.Reg) & 0x4) >> 2
}

// CSI_BRIG.MEM_CTRL: csi bridge buffer control.
func (o *CSI_BRIG_Type) SetMEM_CTRL_CSI_BRIDGE_MEM_CLK_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.MEM_CTRL.Reg, volatile.LoadUint32(&o.MEM_CTRL.Reg)&^(0x1)|value)
}
func (o *CSI_BRIG_Type) GetMEM_CTRL_CSI_BRIDGE_MEM_CLK_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.MEM_CTRL.Reg) & 0x1
}
func (o *CSI_BRIG_Type) SetMEM_CTRL_CSI_MEM_AUX_CTRL(value uint32) {
	volatile.StoreUint32(&o.MEM_CTRL.Reg, volatile.LoadUint32(&o.MEM_CTRL.Reg)&^(0x7ffe)|value<<1)
}
func (o *CSI_BRIG_Type) GetMEM_CTRL_CSI_MEM_AUX_CTRL() uint32 {
	return (volatile.LoadUint32(&o.MEM_CTRL.Reg) & 0x7ffe) >> 1
}

// MIPI Camera Interface Host
type CSI_HOST_Type struct {
	VERSION                     volatile.Register32 // 0x0
	N_LANES                     volatile.Register32 // 0x4
	CSI2_RESETN                 volatile.Register32 // 0x8
	INT_ST_MAIN                 volatile.Register32 // 0xC
	_                           [48]byte
	PHY_SHUTDOWNZ               volatile.Register32 // 0x40
	DPHY_RSTZ                   volatile.Register32 // 0x44
	PHY_RX                      volatile.Register32 // 0x48
	PHY_STOPSTATE               volatile.Register32 // 0x4C
	PHY_TEST_CTRL0              volatile.Register32 // 0x50
	PHY_TEST_CTRL1              volatile.Register32 // 0x54
	_                           [112]byte
	VC_EXTENSION                volatile.Register32 // 0xC8
	PHY_CAL                     volatile.Register32 // 0xCC
	_                           [16]byte
	INT_ST_PHY_FATAL            volatile.Register32 // 0xE0
	INT_MSK_PHY_FATAL           volatile.Register32 // 0xE4
	INT_FORCE_PHY_FATAL         volatile.Register32 // 0xE8
	_                           [4]byte
	INT_ST_PKT_FATAL            volatile.Register32 // 0xF0
	INT_MSK_PKT_FATAL           volatile.Register32 // 0xF4
	INT_FORCE_PKT_FATAL         volatile.Register32 // 0xF8
	_                           [20]byte
	INT_ST_PHY                  volatile.Register32 // 0x110
	INT_MSK_PHY                 volatile.Register32 // 0x114
	INT_FORCE_PHY               volatile.Register32 // 0x118
	_                           [356]byte
	INT_ST_BNDRY_FRAME_FATAL    volatile.Register32 // 0x280
	INT_MSK_BNDRY_FRAME_FATAL   volatile.Register32 // 0x284
	INT_FORCE_BNDRY_FRAME_FATAL volatile.Register32 // 0x288
	_                           [4]byte
	INT_ST_SEQ_FRAME_FATAL      volatile.Register32 // 0x290
	INT_MSK_SEQ_FRAME_FATAL     volatile.Register32 // 0x294
	INT_FORCE_SEQ_FRAME_FATAL   volatile.Register32 // 0x298
	_                           [4]byte
	INT_ST_CRC_FRAME_FATAL      volatile.Register32 // 0x2A0
	INT_MSK_CRC_FRAME_FATAL     volatile.Register32 // 0x2A4
	INT_FORCE_CRC_FRAME_FATAL   volatile.Register32 // 0x2A8
	_                           [4]byte
	INT_ST_PLD_CRC_FATAL        volatile.Register32 // 0x2B0
	INT_MSK_PLD_CRC_FATAL       volatile.Register32 // 0x2B4
	INT_FORCE_PLD_CRC_FATAL     volatile.Register32 // 0x2B8
	_                           [4]byte
	INT_ST_DATA_ID              volatile.Register32 // 0x2C0
	INT_MSK_DATA_ID             volatile.Register32 // 0x2C4
	INT_FORCE_DATA_ID           volatile.Register32 // 0x2C8
	_                           [4]byte
	INT_ST_ECC_CORRECTED        volatile.Register32 // 0x2D0
	INT_MSK_ECC_CORRECTED       volatile.Register32 // 0x2D4
	INT_FORCE_ECC_CORRECTED     volatile.Register32 // 0x2D8
	_                           [36]byte
	SCRAMBLING                  volatile.Register32 // 0x300
	SCRAMBLING_SEED1            volatile.Register32 // 0x304
	SCRAMBLING_SEED2            volatile.Register32 // 0x308
}

// CSI_HOST.VERSION: NA
func (o *CSI_HOST_Type) SetVERSION(value uint32) {
	volatile.StoreUint32(&o.VERSION.Reg, value)
}
func (o *CSI_HOST_Type) GetVERSION() uint32 {
	return volatile.LoadUint32(&o.VERSION.Reg)
}

// CSI_HOST.N_LANES: NA
func (o *CSI_HOST_Type) SetN_LANES(value uint32) {
	volatile.StoreUint32(&o.N_LANES.Reg, volatile.LoadUint32(&o.N_LANES.Reg)&^(0x7)|value)
}
func (o *CSI_HOST_Type) GetN_LANES() uint32 {
	return volatile.LoadUint32(&o.N_LANES.Reg) & 0x7
}

// CSI_HOST.CSI2_RESETN: NA
func (o *CSI_HOST_Type) SetCSI2_RESETN(value uint32) {
	volatile.StoreUint32(&o.CSI2_RESETN.Reg, volatile.LoadUint32(&o.CSI2_RESETN.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetCSI2_RESETN() uint32 {
	return volatile.LoadUint32(&o.CSI2_RESETN.Reg) & 0x1
}

// CSI_HOST.INT_ST_MAIN: NA
func (o *CSI_HOST_Type) SetINT_ST_MAIN_ST_STATUS_INT_PHY_FATAL(value uint32) {
	volatile.StoreUint32(&o.INT_ST_MAIN.Reg, volatile.LoadUint32(&o.INT_ST_MAIN.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_ST_MAIN_ST_STATUS_INT_PHY_FATAL() uint32 {
	return volatile.LoadUint32(&o.INT_ST_MAIN.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_ST_MAIN_ST_STATUS_INT_PKT_FATAL(value uint32) {
	volatile.StoreUint32(&o.INT_ST_MAIN.Reg, volatile.LoadUint32(&o.INT_ST_MAIN.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_ST_MAIN_ST_STATUS_INT_PKT_FATAL() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_MAIN.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_ST_MAIN_ST_STATUS_INT_BNDRY_FRAME_FATAL(value uint32) {
	volatile.StoreUint32(&o.INT_ST_MAIN.Reg, volatile.LoadUint32(&o.INT_ST_MAIN.Reg)&^(0x4)|value<<2)
}
func (o *CSI_HOST_Type) GetINT_ST_MAIN_ST_STATUS_INT_BNDRY_FRAME_FATAL() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_MAIN.Reg) & 0x4) >> 2
}
func (o *CSI_HOST_Type) SetINT_ST_MAIN_ST_STATUS_INT_SEQ_FRAME_FATAL(value uint32) {
	volatile.StoreUint32(&o.INT_ST_MAIN.Reg, volatile.LoadUint32(&o.INT_ST_MAIN.Reg)&^(0x8)|value<<3)
}
func (o *CSI_HOST_Type) GetINT_ST_MAIN_ST_STATUS_INT_SEQ_FRAME_FATAL() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_MAIN.Reg) & 0x8) >> 3
}
func (o *CSI_HOST_Type) SetINT_ST_MAIN_ST_STATUS_INT_CRC_FRAME_FATAL(value uint32) {
	volatile.StoreUint32(&o.INT_ST_MAIN.Reg, volatile.LoadUint32(&o.INT_ST_MAIN.Reg)&^(0x10)|value<<4)
}
func (o *CSI_HOST_Type) GetINT_ST_MAIN_ST_STATUS_INT_CRC_FRAME_FATAL() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_MAIN.Reg) & 0x10) >> 4
}
func (o *CSI_HOST_Type) SetINT_ST_MAIN_ST_STATUS_INT_PLD_CRC_FATAL(value uint32) {
	volatile.StoreUint32(&o.INT_ST_MAIN.Reg, volatile.LoadUint32(&o.INT_ST_MAIN.Reg)&^(0x20)|value<<5)
}
func (o *CSI_HOST_Type) GetINT_ST_MAIN_ST_STATUS_INT_PLD_CRC_FATAL() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_MAIN.Reg) & 0x20) >> 5
}
func (o *CSI_HOST_Type) SetINT_ST_MAIN_ST_STATUS_INT_DATA_ID(value uint32) {
	volatile.StoreUint32(&o.INT_ST_MAIN.Reg, volatile.LoadUint32(&o.INT_ST_MAIN.Reg)&^(0x40)|value<<6)
}
func (o *CSI_HOST_Type) GetINT_ST_MAIN_ST_STATUS_INT_DATA_ID() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_MAIN.Reg) & 0x40) >> 6
}
func (o *CSI_HOST_Type) SetINT_ST_MAIN_ST_STATUS_INT_ECC_CORRECTED(value uint32) {
	volatile.StoreUint32(&o.INT_ST_MAIN.Reg, volatile.LoadUint32(&o.INT_ST_MAIN.Reg)&^(0x80)|value<<7)
}
func (o *CSI_HOST_Type) GetINT_ST_MAIN_ST_STATUS_INT_ECC_CORRECTED() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_MAIN.Reg) & 0x80) >> 7
}
func (o *CSI_HOST_Type) SetINT_ST_MAIN_ST_STATUS_INT_PHY(value uint32) {
	volatile.StoreUint32(&o.INT_ST_MAIN.Reg, volatile.LoadUint32(&o.INT_ST_MAIN.Reg)&^(0x10000)|value<<16)
}
func (o *CSI_HOST_Type) GetINT_ST_MAIN_ST_STATUS_INT_PHY() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_MAIN.Reg) & 0x10000) >> 16
}

// CSI_HOST.PHY_SHUTDOWNZ: NA
func (o *CSI_HOST_Type) SetPHY_SHUTDOWNZ(value uint32) {
	volatile.StoreUint32(&o.PHY_SHUTDOWNZ.Reg, volatile.LoadUint32(&o.PHY_SHUTDOWNZ.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetPHY_SHUTDOWNZ() uint32 {
	return volatile.LoadUint32(&o.PHY_SHUTDOWNZ.Reg) & 0x1
}

// CSI_HOST.DPHY_RSTZ: NA
func (o *CSI_HOST_Type) SetDPHY_RSTZ(value uint32) {
	volatile.StoreUint32(&o.DPHY_RSTZ.Reg, volatile.LoadUint32(&o.DPHY_RSTZ.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetDPHY_RSTZ() uint32 {
	return volatile.LoadUint32(&o.DPHY_RSTZ.Reg) & 0x1
}

// CSI_HOST.PHY_RX: NA
func (o *CSI_HOST_Type) SetPHY_RX_PHY_RXULPSESC_0(value uint32) {
	volatile.StoreUint32(&o.PHY_RX.Reg, volatile.LoadUint32(&o.PHY_RX.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetPHY_RX_PHY_RXULPSESC_0() uint32 {
	return volatile.LoadUint32(&o.PHY_RX.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetPHY_RX_PHY_RXULPSESC_1(value uint32) {
	volatile.StoreUint32(&o.PHY_RX.Reg, volatile.LoadUint32(&o.PHY_RX.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetPHY_RX_PHY_RXULPSESC_1() uint32 {
	return (volatile.LoadUint32(&o.PHY_RX.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetPHY_RX_PHY_RXULPSCLKNOT(value uint32) {
	volatile.StoreUint32(&o.PHY_RX.Reg, volatile.LoadUint32(&o.PHY_RX.Reg)&^(0x10000)|value<<16)
}
func (o *CSI_HOST_Type) GetPHY_RX_PHY_RXULPSCLKNOT() uint32 {
	return (volatile.LoadUint32(&o.PHY_RX.Reg) & 0x10000) >> 16
}
func (o *CSI_HOST_Type) SetPHY_RX_PHY_RXCLKACTIVEHS(value uint32) {
	volatile.StoreUint32(&o.PHY_RX.Reg, volatile.LoadUint32(&o.PHY_RX.Reg)&^(0x20000)|value<<17)
}
func (o *CSI_HOST_Type) GetPHY_RX_PHY_RXCLKACTIVEHS() uint32 {
	return (volatile.LoadUint32(&o.PHY_RX.Reg) & 0x20000) >> 17
}

// CSI_HOST.PHY_STOPSTATE: NA
func (o *CSI_HOST_Type) SetPHY_STOPSTATE_PHY_STOPSTATEDATA_0(value uint32) {
	volatile.StoreUint32(&o.PHY_STOPSTATE.Reg, volatile.LoadUint32(&o.PHY_STOPSTATE.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetPHY_STOPSTATE_PHY_STOPSTATEDATA_0() uint32 {
	return volatile.LoadUint32(&o.PHY_STOPSTATE.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetPHY_STOPSTATE_PHY_STOPSTATEDATA_1(value uint32) {
	volatile.StoreUint32(&o.PHY_STOPSTATE.Reg, volatile.LoadUint32(&o.PHY_STOPSTATE.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetPHY_STOPSTATE_PHY_STOPSTATEDATA_1() uint32 {
	return (volatile.LoadUint32(&o.PHY_STOPSTATE.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetPHY_STOPSTATE_PHY_STOPSTATECLK(value uint32) {
	volatile.StoreUint32(&o.PHY_STOPSTATE.Reg, volatile.LoadUint32(&o.PHY_STOPSTATE.Reg)&^(0x10000)|value<<16)
}
func (o *CSI_HOST_Type) GetPHY_STOPSTATE_PHY_STOPSTATECLK() uint32 {
	return (volatile.LoadUint32(&o.PHY_STOPSTATE.Reg) & 0x10000) >> 16
}

// CSI_HOST.PHY_TEST_CTRL0: NA
func (o *CSI_HOST_Type) SetPHY_TEST_CTRL0_PHY_TESTCLR(value uint32) {
	volatile.StoreUint32(&o.PHY_TEST_CTRL0.Reg, volatile.LoadUint32(&o.PHY_TEST_CTRL0.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetPHY_TEST_CTRL0_PHY_TESTCLR() uint32 {
	return volatile.LoadUint32(&o.PHY_TEST_CTRL0.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetPHY_TEST_CTRL0_PHY_TESTCLK(value uint32) {
	volatile.StoreUint32(&o.PHY_TEST_CTRL0.Reg, volatile.LoadUint32(&o.PHY_TEST_CTRL0.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetPHY_TEST_CTRL0_PHY_TESTCLK() uint32 {
	return (volatile.LoadUint32(&o.PHY_TEST_CTRL0.Reg) & 0x2) >> 1
}

// CSI_HOST.PHY_TEST_CTRL1: NA
func (o *CSI_HOST_Type) SetPHY_TEST_CTRL1_PHY_TESTDIN(value uint32) {
	volatile.StoreUint32(&o.PHY_TEST_CTRL1.Reg, volatile.LoadUint32(&o.PHY_TEST_CTRL1.Reg)&^(0xff)|value)
}
func (o *CSI_HOST_Type) GetPHY_TEST_CTRL1_PHY_TESTDIN() uint32 {
	return volatile.LoadUint32(&o.PHY_TEST_CTRL1.Reg) & 0xff
}
func (o *CSI_HOST_Type) SetPHY_TEST_CTRL1_PHY_TESTDOUT(value uint32) {
	volatile.StoreUint32(&o.PHY_TEST_CTRL1.Reg, volatile.LoadUint32(&o.PHY_TEST_CTRL1.Reg)&^(0xff00)|value<<8)
}
func (o *CSI_HOST_Type) GetPHY_TEST_CTRL1_PHY_TESTDOUT() uint32 {
	return (volatile.LoadUint32(&o.PHY_TEST_CTRL1.Reg) & 0xff00) >> 8
}
func (o *CSI_HOST_Type) SetPHY_TEST_CTRL1_PHY_TESTEN(value uint32) {
	volatile.StoreUint32(&o.PHY_TEST_CTRL1.Reg, volatile.LoadUint32(&o.PHY_TEST_CTRL1.Reg)&^(0x10000)|value<<16)
}
func (o *CSI_HOST_Type) GetPHY_TEST_CTRL1_PHY_TESTEN() uint32 {
	return (volatile.LoadUint32(&o.PHY_TEST_CTRL1.Reg) & 0x10000) >> 16
}

// CSI_HOST.VC_EXTENSION: NA
func (o *CSI_HOST_Type) SetVC_EXTENSION_VCX(value uint32) {
	volatile.StoreUint32(&o.VC_EXTENSION.Reg, volatile.LoadUint32(&o.VC_EXTENSION.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetVC_EXTENSION_VCX() uint32 {
	return volatile.LoadUint32(&o.VC_EXTENSION.Reg) & 0x1
}

// CSI_HOST.PHY_CAL: NA
func (o *CSI_HOST_Type) SetPHY_CAL_RXSKEWCALHS(value uint32) {
	volatile.StoreUint32(&o.PHY_CAL.Reg, volatile.LoadUint32(&o.PHY_CAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetPHY_CAL_RXSKEWCALHS() uint32 {
	return volatile.LoadUint32(&o.PHY_CAL.Reg) & 0x1
}

// CSI_HOST.INT_ST_PHY_FATAL: NA
func (o *CSI_HOST_Type) SetINT_ST_PHY_FATAL_ST_PHY_ERRSOTSYNCHS_0(value uint32) {
	volatile.StoreUint32(&o.INT_ST_PHY_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_PHY_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_ST_PHY_FATAL_ST_PHY_ERRSOTSYNCHS_0() uint32 {
	return volatile.LoadUint32(&o.INT_ST_PHY_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_ST_PHY_FATAL_ST_PHY_ERRSOTSYNCHS_1(value uint32) {
	volatile.StoreUint32(&o.INT_ST_PHY_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_PHY_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_ST_PHY_FATAL_ST_PHY_ERRSOTSYNCHS_1() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_PHY_FATAL.Reg) & 0x2) >> 1
}

// CSI_HOST.INT_MSK_PHY_FATAL: NA
func (o *CSI_HOST_Type) SetINT_MSK_PHY_FATAL_MASK_PHY_ERRSOTSYNCHS_0(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_PHY_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_PHY_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_MSK_PHY_FATAL_MASK_PHY_ERRSOTSYNCHS_0() uint32 {
	return volatile.LoadUint32(&o.INT_MSK_PHY_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_MSK_PHY_FATAL_MASK_PHY_ERRSOTSYNCHS_1(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_PHY_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_PHY_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_MSK_PHY_FATAL_MASK_PHY_ERRSOTSYNCHS_1() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_PHY_FATAL.Reg) & 0x2) >> 1
}

// CSI_HOST.INT_FORCE_PHY_FATAL: NA
func (o *CSI_HOST_Type) SetINT_FORCE_PHY_FATAL_FORCE_PHY_ERRSOTSYNCHS_0(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_PHY_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_PHY_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_FORCE_PHY_FATAL_FORCE_PHY_ERRSOTSYNCHS_0() uint32 {
	return volatile.LoadUint32(&o.INT_FORCE_PHY_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_FORCE_PHY_FATAL_FORCE_PHY_ERRSOTSYNCHS_1(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_PHY_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_PHY_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_FORCE_PHY_FATAL_FORCE_PHY_ERRSOTSYNCHS_1() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_PHY_FATAL.Reg) & 0x2) >> 1
}

// CSI_HOST.INT_ST_PKT_FATAL: NA
func (o *CSI_HOST_Type) SetINT_ST_PKT_FATAL_ST_ERR_ECC_DOUBLE(value uint32) {
	volatile.StoreUint32(&o.INT_ST_PKT_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_PKT_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_ST_PKT_FATAL_ST_ERR_ECC_DOUBLE() uint32 {
	return volatile.LoadUint32(&o.INT_ST_PKT_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_ST_PKT_FATAL_ST_SHORTER_PAYLOAD(value uint32) {
	volatile.StoreUint32(&o.INT_ST_PKT_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_PKT_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_ST_PKT_FATAL_ST_SHORTER_PAYLOAD() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_PKT_FATAL.Reg) & 0x2) >> 1
}

// CSI_HOST.INT_MSK_PKT_FATAL: NA
func (o *CSI_HOST_Type) SetINT_MSK_PKT_FATAL_MASK_ERR_ECC_DOUBLE(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_PKT_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_PKT_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_MSK_PKT_FATAL_MASK_ERR_ECC_DOUBLE() uint32 {
	return volatile.LoadUint32(&o.INT_MSK_PKT_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_MSK_PKT_FATAL_MASK_SHORTER_PAYLOAD(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_PKT_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_PKT_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_MSK_PKT_FATAL_MASK_SHORTER_PAYLOAD() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_PKT_FATAL.Reg) & 0x2) >> 1
}

// CSI_HOST.INT_FORCE_PKT_FATAL: NA
func (o *CSI_HOST_Type) SetINT_FORCE_PKT_FATAL_FORCE_ERR_ECC_DOUBLE(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_PKT_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_PKT_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_FORCE_PKT_FATAL_FORCE_ERR_ECC_DOUBLE() uint32 {
	return volatile.LoadUint32(&o.INT_FORCE_PKT_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_FORCE_PKT_FATAL_FORCE_SHORTER_PAYLOAD(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_PKT_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_PKT_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_FORCE_PKT_FATAL_FORCE_SHORTER_PAYLOAD() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_PKT_FATAL.Reg) & 0x2) >> 1
}

// CSI_HOST.INT_ST_PHY: NA
func (o *CSI_HOST_Type) SetINT_ST_PHY_ST_PHY_ERRSOTHS_0(value uint32) {
	volatile.StoreUint32(&o.INT_ST_PHY.Reg, volatile.LoadUint32(&o.INT_ST_PHY.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_ST_PHY_ST_PHY_ERRSOTHS_0() uint32 {
	return volatile.LoadUint32(&o.INT_ST_PHY.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_ST_PHY_ST_PHY_ERRSOTHS_1(value uint32) {
	volatile.StoreUint32(&o.INT_ST_PHY.Reg, volatile.LoadUint32(&o.INT_ST_PHY.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_ST_PHY_ST_PHY_ERRSOTHS_1() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_PHY.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_ST_PHY_ST_PHY_ERRESC_0(value uint32) {
	volatile.StoreUint32(&o.INT_ST_PHY.Reg, volatile.LoadUint32(&o.INT_ST_PHY.Reg)&^(0x10000)|value<<16)
}
func (o *CSI_HOST_Type) GetINT_ST_PHY_ST_PHY_ERRESC_0() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_PHY.Reg) & 0x10000) >> 16
}
func (o *CSI_HOST_Type) SetINT_ST_PHY_ST_PHY_ERRESC_1(value uint32) {
	volatile.StoreUint32(&o.INT_ST_PHY.Reg, volatile.LoadUint32(&o.INT_ST_PHY.Reg)&^(0x20000)|value<<17)
}
func (o *CSI_HOST_Type) GetINT_ST_PHY_ST_PHY_ERRESC_1() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_PHY.Reg) & 0x20000) >> 17
}

// CSI_HOST.INT_MSK_PHY: NA
func (o *CSI_HOST_Type) SetINT_MSK_PHY_MASK_PHY_ERRSOTHS_0(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_PHY.Reg, volatile.LoadUint32(&o.INT_MSK_PHY.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_MSK_PHY_MASK_PHY_ERRSOTHS_0() uint32 {
	return volatile.LoadUint32(&o.INT_MSK_PHY.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_MSK_PHY_MASK_PHY_ERRSOTHS_1(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_PHY.Reg, volatile.LoadUint32(&o.INT_MSK_PHY.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_MSK_PHY_MASK_PHY_ERRSOTHS_1() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_PHY.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_MSK_PHY_MASK_PHY_ERRESC_0(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_PHY.Reg, volatile.LoadUint32(&o.INT_MSK_PHY.Reg)&^(0x10000)|value<<16)
}
func (o *CSI_HOST_Type) GetINT_MSK_PHY_MASK_PHY_ERRESC_0() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_PHY.Reg) & 0x10000) >> 16
}
func (o *CSI_HOST_Type) SetINT_MSK_PHY_MASK_PHY_ERRESC_1(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_PHY.Reg, volatile.LoadUint32(&o.INT_MSK_PHY.Reg)&^(0x20000)|value<<17)
}
func (o *CSI_HOST_Type) GetINT_MSK_PHY_MASK_PHY_ERRESC_1() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_PHY.Reg) & 0x20000) >> 17
}

// CSI_HOST.INT_FORCE_PHY: NA
func (o *CSI_HOST_Type) SetINT_FORCE_PHY_FORCE_PHY_ERRSOTHS_0(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_PHY.Reg, volatile.LoadUint32(&o.INT_FORCE_PHY.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_FORCE_PHY_FORCE_PHY_ERRSOTHS_0() uint32 {
	return volatile.LoadUint32(&o.INT_FORCE_PHY.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_FORCE_PHY_FORCE_PHY_ERRSOTHS_1(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_PHY.Reg, volatile.LoadUint32(&o.INT_FORCE_PHY.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_FORCE_PHY_FORCE_PHY_ERRSOTHS_1() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_PHY.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_FORCE_PHY_FORCE_PHY_ERRESC_0(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_PHY.Reg, volatile.LoadUint32(&o.INT_FORCE_PHY.Reg)&^(0x10000)|value<<16)
}
func (o *CSI_HOST_Type) GetINT_FORCE_PHY_FORCE_PHY_ERRESC_0() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_PHY.Reg) & 0x10000) >> 16
}
func (o *CSI_HOST_Type) SetINT_FORCE_PHY_FORCE_PHY_ERRESC_1(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_PHY.Reg, volatile.LoadUint32(&o.INT_FORCE_PHY.Reg)&^(0x20000)|value<<17)
}
func (o *CSI_HOST_Type) GetINT_FORCE_PHY_FORCE_PHY_ERRESC_1() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_PHY.Reg) & 0x20000) >> 17
}

// CSI_HOST.INT_ST_BNDRY_FRAME_FATAL: NA
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC0(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC0() uint32 {
	return volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC1(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC1() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC2(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x4)|value<<2)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC2() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x4) >> 2
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC3(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x8)|value<<3)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC3() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x8) >> 3
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC4(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x10)|value<<4)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC4() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x10) >> 4
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC5(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x20)|value<<5)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC5() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x20) >> 5
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC6(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x40)|value<<6)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC6() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x40) >> 6
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC7(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x80)|value<<7)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC7() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x80) >> 7
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC8(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x100)|value<<8)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC8() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x100) >> 8
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC9(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x200)|value<<9)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC9() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x200) >> 9
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC10(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x400)|value<<10)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC10() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x400) >> 10
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC11(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x800)|value<<11)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC11() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x800) >> 11
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC12(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x1000)|value<<12)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC12() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x1000) >> 12
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC13(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x2000)|value<<13)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC13() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x2000) >> 13
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC14(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x4000)|value<<14)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC14() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x4000) >> 14
}
func (o *CSI_HOST_Type) SetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC15(value uint32) {
	volatile.StoreUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg)&^(0x8000)|value<<15)
}
func (o *CSI_HOST_Type) GetINT_ST_BNDRY_FRAME_FATAL_ST_ERR_F_BNDRY_MATCH_VC15() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_BNDRY_FRAME_FATAL.Reg) & 0x8000) >> 15
}

// CSI_HOST.INT_MSK_BNDRY_FRAME_FATAL: NA
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC0(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC0() uint32 {
	return volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC1(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC1() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC2(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x4)|value<<2)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC2() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x4) >> 2
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC3(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x8)|value<<3)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC3() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x8) >> 3
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC4(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x10)|value<<4)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC4() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x10) >> 4
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC5(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x20)|value<<5)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC5() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x20) >> 5
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC6(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x40)|value<<6)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC6() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x40) >> 6
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC7(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x80)|value<<7)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC7() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x80) >> 7
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC8(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x100)|value<<8)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC8() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x100) >> 8
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC9(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x200)|value<<9)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC9() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x200) >> 9
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC10(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x400)|value<<10)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC10() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x400) >> 10
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC11(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x800)|value<<11)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC11() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x800) >> 11
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC12(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x1000)|value<<12)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC12() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x1000) >> 12
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC13(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x2000)|value<<13)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC13() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x2000) >> 13
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC14(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x4000)|value<<14)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC14() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x4000) >> 14
}
func (o *CSI_HOST_Type) SetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC15(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg)&^(0x8000)|value<<15)
}
func (o *CSI_HOST_Type) GetINT_MSK_BNDRY_FRAME_FATAL_MASK_ERR_F_BNDRY_MATCH_VC15() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_BNDRY_FRAME_FATAL.Reg) & 0x8000) >> 15
}

// CSI_HOST.INT_FORCE_BNDRY_FRAME_FATAL: NA
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC0(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC0() uint32 {
	return volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC1(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC1() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC2(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x4)|value<<2)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC2() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x4) >> 2
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC3(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x8)|value<<3)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC3() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x8) >> 3
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC4(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x10)|value<<4)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC4() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x10) >> 4
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC5(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x20)|value<<5)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC5() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x20) >> 5
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC6(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x40)|value<<6)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC6() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x40) >> 6
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC7(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x80)|value<<7)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC7() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x80) >> 7
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC8(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x100)|value<<8)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC8() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x100) >> 8
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC9(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x200)|value<<9)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC9() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x200) >> 9
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC10(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x400)|value<<10)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC10() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x400) >> 10
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC11(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x800)|value<<11)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC11() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x800) >> 11
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC12(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x1000)|value<<12)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC12() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x1000) >> 12
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC13(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x2000)|value<<13)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC13() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x2000) >> 13
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC14(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x4000)|value<<14)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC14() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x4000) >> 14
}
func (o *CSI_HOST_Type) SetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC15(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg)&^(0x8000)|value<<15)
}
func (o *CSI_HOST_Type) GetINT_FORCE_BNDRY_FRAME_FATAL_FORCE_ERR_F_BNDRY_MATCH_VC15() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_BNDRY_FRAME_FATAL.Reg) & 0x8000) >> 15
}

// CSI_HOST.INT_ST_SEQ_FRAME_FATAL: NA
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC0(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC0() uint32 {
	return volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC1(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC1() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC2(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x4)|value<<2)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC2() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x4) >> 2
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC3(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x8)|value<<3)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC3() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x8) >> 3
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC4(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x10)|value<<4)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC4() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x10) >> 4
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC5(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x20)|value<<5)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC5() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x20) >> 5
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC6(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x40)|value<<6)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC6() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x40) >> 6
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC7(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x80)|value<<7)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC7() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x80) >> 7
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC8(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x100)|value<<8)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC8() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x100) >> 8
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC9(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x200)|value<<9)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC9() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x200) >> 9
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC10(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x400)|value<<10)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC10() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x400) >> 10
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC11(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x800)|value<<11)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC11() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x800) >> 11
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC12(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x1000)|value<<12)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC12() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x1000) >> 12
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC13(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x2000)|value<<13)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC13() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x2000) >> 13
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC14(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x4000)|value<<14)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC14() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x4000) >> 14
}
func (o *CSI_HOST_Type) SetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC15(value uint32) {
	volatile.StoreUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg)&^(0x8000)|value<<15)
}
func (o *CSI_HOST_Type) GetINT_ST_SEQ_FRAME_FATAL_ST_ERR_F_SEQ_VC15() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_SEQ_FRAME_FATAL.Reg) & 0x8000) >> 15
}

// CSI_HOST.INT_MSK_SEQ_FRAME_FATAL: NA
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC0(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC0() uint32 {
	return volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC1(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC1() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC2(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x4)|value<<2)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC2() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x4) >> 2
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC3(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x8)|value<<3)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC3() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x8) >> 3
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC4(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x10)|value<<4)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC4() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x10) >> 4
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC5(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x20)|value<<5)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC5() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x20) >> 5
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC6(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x40)|value<<6)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC6() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x40) >> 6
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC7(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x80)|value<<7)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC7() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x80) >> 7
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC8(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x100)|value<<8)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC8() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x100) >> 8
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC9(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x200)|value<<9)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC9() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x200) >> 9
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC10(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x400)|value<<10)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC10() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x400) >> 10
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC11(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x800)|value<<11)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC11() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x800) >> 11
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC12(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x1000)|value<<12)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC12() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x1000) >> 12
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC13(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x2000)|value<<13)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC13() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x2000) >> 13
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC14(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x4000)|value<<14)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC14() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x4000) >> 14
}
func (o *CSI_HOST_Type) SetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC15(value uint32) {
	volatile.StoreUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg)&^(0x8000)|value<<15)
}
func (o *CSI_HOST_Type) GetINT_MSK_SEQ_FRAME_FATAL_MASK_ERR_F_SEQ_VC15() uint32 {
	return (volatile.LoadUint32(&o.INT_MSK_SEQ_FRAME_FATAL.Reg) & 0x8000) >> 15
}

// CSI_HOST.INT_FORCE_SEQ_FRAME_FATAL: NA
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC0(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC0() uint32 {
	return volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC1(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC1() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC2(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x4)|value<<2)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC2() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x4) >> 2
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC3(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x8)|value<<3)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC3() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x8) >> 3
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC4(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x10)|value<<4)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC4() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x10) >> 4
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC5(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x20)|value<<5)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC5() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x20) >> 5
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC6(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x40)|value<<6)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC6() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x40) >> 6
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC7(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x80)|value<<7)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC7() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x80) >> 7
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC8(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x100)|value<<8)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC8() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x100) >> 8
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC9(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x200)|value<<9)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC9() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x200) >> 9
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC10(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x400)|value<<10)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC10() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x400) >> 10
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC11(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x800)|value<<11)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC11() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x800) >> 11
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC12(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x1000)|value<<12)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC12() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x1000) >> 12
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC13(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x2000)|value<<13)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC13() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x2000) >> 13
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC14(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x4000)|value<<14)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC14() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x4000) >> 14
}
func (o *CSI_HOST_Type) SetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC15(value uint32) {
	volatile.StoreUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg)&^(0x8000)|value<<15)
}
func (o *CSI_HOST_Type) GetINT_FORCE_SEQ_FRAME_FATAL_FORCE_ERR_F_SEQ_VC15() uint32 {
	return (volatile.LoadUint32(&o.INT_FORCE_SEQ_FRAME_FATAL.Reg) & 0x8000) >> 15
}

// CSI_HOST.INT_ST_CRC_FRAME_FATAL: NA
func (o *CSI_HOST_Type) SetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC0(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg)&^(0x1)|value)
}
func (o *CSI_HOST_Type) GetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC0() uint32 {
	return volatile.LoadUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg) & 0x1
}
func (o *CSI_HOST_Type) SetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC1(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg)&^(0x2)|value<<1)
}
func (o *CSI_HOST_Type) GetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC1() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg) & 0x2) >> 1
}
func (o *CSI_HOST_Type) SetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC2(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg)&^(0x4)|value<<2)
}
func (o *CSI_HOST_Type) GetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC2() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg) & 0x4) >> 2
}
func (o *CSI_HOST_Type) SetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC3(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg)&^(0x8)|value<<3)
}
func (o *CSI_HOST_Type) GetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC3() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg) & 0x8) >> 3
}
func (o *CSI_HOST_Type) SetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC4(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg)&^(0x10)|value<<4)
}
func (o *CSI_HOST_Type) GetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC4() uint32 {
	return (volatile.LoadUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg) & 0x10) >> 4
}
func (o *CSI_HOST_Type) SetINT_ST_CRC_FRAME_FATAL_ST_ERR_FRAME_DATA_VC5(value uint32) {
	volatile.StoreUint32(&o.INT_ST_CRC_FRAME_FATAL.Reg, volatile.LoadUint32(&o.INT_ST_CRC_F