# AvogadroLibs CMake configuration file - http://www.openchemistry.org/

# If this file was found, then OpenQube has been found
set(AvogadroLibs_FOUND 1)

set(AvogadroLibs_VERSION_MAJOR   "1")
set(AvogadroLibs_VERSION_MINOR   "99")
set(AvogadroLibs_VERSION_PATCH   "0")
set(AvogadroLibs_VERSION         "${AvogadroLibs_VERSION_MAJOR}.${AvogadroLibs_VERSION_MINOR}.${AvogadroLibs_VERSION_PATCH}")

set(AvogadroLibs_INSTALL_PREFIX  "${CMAKE_CURRENT_LIST_DIR}/../../..")
set(AvogadroLibs_INCLUDE_DIRS    "${AvogadroLibs_INSTALL_PREFIX}/include")
set(AvogadroLibs_LIBRARY_DIR     "${AvogadroLibs_INSTALL_PREFIX}/lib")
set(AvogadroLibs_RUNTIME_DIR     "${AvogadroLibs_INSTALL_PREFIX}/bin")
set(AvogadroLibs_DATA_DIR        "${AvogadroLibs_INSTALL_PREFIX}/share")
set(AvogadroLibs_CMAKE_DIR       "${AvogadroLibs_LIBRARY_DIR}/cmake/avogadrolibs")

# List of target names that are plugins:
set(AvogadroLibs_PLUGINS         "ThreeDMol;ApplyColors;AlignTool;BondCentric;Bonding;Cartoons;Centroid;ConfigurePython;CopyPaste;Crystal;CrystalScene;CustomElements;Editor;FetchPDB;Focus;Hydrogens;ImportPQR;NucleicInput;Label;LabelEditor;LammpsInput;LineFormatInput;Manipulator;MeasureTool;Navigator;NetworkDatabases;OpenBabel;OpenMMInput;PlayerTool;PLY;POVRay;PropertyTables;ResetView;Select;Selection;SpaceGroup;Surfaces;TemplateTool;Vibrations;VRML;ColorOpacityMap;Spectra;PlotPdf;PlotRmsd;PlotXrd;Yaehmop;ScriptFileFormats;PluginDownloader;BallStick;CloseContacts;Force;Licorice;Meshes;NonCovalent;VanDerWaals;Wireframe;OverlayAxes")
set(AvogadroLibs_STATIC_PLUGINS  "")

if(NOT TARGET AvogadroCore)
  include("${AvogadroLibs_CMAKE_DIR}/AvogadroLibsTargets.cmake")
endif()
