/*
 *	PROGRAM:		Firebird interface.
 *	MODULE:			fb_c_api.h
 *	DESCRIPTION:	C API file.
 *
 *  The contents of this file are subject to the Initial
 *  Developer's Public License Version 1.0 (the "License");
 *  you may not use this file except in compliance with the
 *  License. You may obtain a copy of the License at
 *  http://www.ibphoenix.com/main.nfs?a=ibphoenix&page=ibp_idpl.
 *
 *  Software distributed under the License is distributed AS IS,
 *  WITHOUT WARRANTY OF ANY KIND, either express or implied.
 *  See the License for the specific language governing rights
 *  and limitations under the License.
 *
 *  The Original Code was created by Alex Peshkov
 *  for the Firebird Open Source RDBMS project.
 *
 *  Copyright (c) 2024 Alex Peshkov <alexander.peshkoff@gmail.com>
 *  and all contributors signed below.
 *
 *  All Rights Reserved.
 *  Contributor(s): ______________________________________.
 *
 *
 */

#include <ibase.h>

#ifndef FB_C_API_H
struct IMaster* ISC_EXPORT fb_get_master_interface(void);
#endif

/* This file was autogenerated by cloop - Cross Language Object Oriented Programming */

#ifndef FB_C_API_H
#define FB_C_API_H

#include <stdint.h>

#ifndef CLOOP_EXTERN_C
#ifdef __cplusplus
#define CLOOP_EXTERN_C extern "C"
#else
#define CLOOP_EXTERN_C
#endif
#endif


struct IVersioned;
struct IReferenceCounted;
struct IDisposable;
struct IStatus;
struct IMaster;
struct IPluginBase;
struct IPluginSet;
struct IConfigEntry;
struct IConfig;
struct IFirebirdConf;
struct IPluginConfig;
struct IPluginFactory;
struct IPluginModule;
struct IPluginManager;
struct ICryptKey;
struct IConfigManager;
struct IEventCallback;
struct IBlob;
struct ITransaction;
struct IMessageMetadata;
struct IMetadataBuilder;
struct IResultSet;
struct IStatement;
struct IBatch;
struct IBatchCompletionState;
struct IReplicator;
struct IRequest;
struct IEvents;
struct IAttachment;
struct IService;
struct IProvider;
struct IDtcStart;
struct IDtc;
struct IAuth;
struct IWriter;
struct IServerBlock;
struct IClientBlock;
struct IServer;
struct IClient;
struct IUserField;
struct ICharUserField;
struct IIntUserField;
struct IUser;
struct IListUsers;
struct ILogonInfo;
struct IManagement;
struct IAuthBlock;
struct IWireCryptPlugin;
struct ICryptKeyCallback;
struct IKeyHolderPlugin;
struct IDbCryptInfo;
struct IDbCryptPlugin;
struct IExternalContext;
struct IExternalResultSet;
struct IExternalFunction;
struct IExternalProcedure;
struct IExternalTrigger;
struct IRoutineMetadata;
struct IExternalEngine;
struct ITimer;
struct ITimerControl;
struct IVersionCallback;
struct IUtil;
struct IOffsetsCallback;
struct IXpbBuilder;
struct ITraceConnection;
struct ITraceDatabaseConnection;
struct ITraceTransaction;
struct ITraceParams;
struct ITraceStatement;
struct ITraceSQLStatement;
struct ITraceBLRStatement;
struct ITraceDYNRequest;
struct ITraceContextVariable;
struct ITraceProcedure;
struct ITraceFunction;
struct ITraceTrigger;
struct ITraceServiceConnection;
struct ITraceStatusVector;
struct ITraceSweepInfo;
struct ITraceLogWriter;
struct ITraceInitInfo;
struct ITracePlugin;
struct ITraceFactory;
struct IUdrFunctionFactory;
struct IUdrProcedureFactory;
struct IUdrTriggerFactory;
struct IUdrPlugin;
struct IDecFloat16;
struct IDecFloat34;
struct IInt128;
struct IReplicatedField;
struct IReplicatedRecord;
struct IReplicatedTransaction;
struct IReplicatedSession;
struct IProfilerPlugin;
struct IProfilerSession;
struct IProfilerStats;


#define IVersioned_VERSION 1

struct IVersioned;

struct IVersionedVTable
{
	void* cloopDummy[1];
	uintptr_t version;
};

struct IVersioned
{
	void* cloopDummy[1];
	struct IVersionedVTable* vtable;
};


#define IReferenceCounted_VERSION 2

struct IReferenceCounted;

struct IReferenceCountedVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IReferenceCounted* self);
	int (*release)(struct IReferenceCounted* self);
};

struct IReferenceCounted
{
	void* cloopDummy[1];
	struct IReferenceCountedVTable* vtable;
};

#define IReferenceCounted_addRef(self) (self)->vtable->addRef(self)
#define IReferenceCounted_release(self) ((self)->vtable->release(self))

#define IDisposable_VERSION 2

struct IDisposable;

struct IDisposableVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IDisposable* self);
};

struct IDisposable
{
	void* cloopDummy[1];
	struct IDisposableVTable* vtable;
};

#define IDisposable_dispose(self) (self)->vtable->dispose(self)

#define IStatus_VERSION 3

#define IStatus_STATE_WARNINGS ((unsigned) (0x1))
#define IStatus_STATE_ERRORS ((unsigned) (0x2))
#define IStatus_RESULT_ERROR ((int) (-1))
#define IStatus_RESULT_OK ((int) (0))
#define IStatus_RESULT_NO_DATA ((int) (1))
#define IStatus_RESULT_SEGMENT ((int) (2))

struct IStatus;

struct IStatusVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IStatus* self);
	void (*init)(struct IStatus* self);
	unsigned (*getState)(const struct IStatus* self);
	void (*setErrors2)(struct IStatus* self, unsigned length, const intptr_t* value);
	void (*setWarnings2)(struct IStatus* self, unsigned length, const intptr_t* value);
	void (*setErrors)(struct IStatus* self, const intptr_t* value);
	void (*setWarnings)(struct IStatus* self, const intptr_t* value);
	const intptr_t* (*getErrors)(const struct IStatus* self);
	const intptr_t* (*getWarnings)(const struct IStatus* self);
	struct IStatus* (*clone)(const struct IStatus* self);
};

struct IStatus
{
	void* cloopDummy[1];
	struct IStatusVTable* vtable;
};

#define IStatus_dispose(self) (self)->vtable->dispose(self)
#define IStatus_init(self) (self)->vtable->init(self)
#define IStatus_getState(self) ((self)->vtable->getState(self))
#define IStatus_setErrors2(self, length, value) (self)->vtable->setErrors2(self, (length), (value))
#define IStatus_setWarnings2(self, length, value) (self)->vtable->setWarnings2(self, (length), (value))
#define IStatus_setErrors(self, value) (self)->vtable->setErrors(self, (value))
#define IStatus_setWarnings(self, value) (self)->vtable->setWarnings(self, (value))
#define IStatus_getErrors(self) ((self)->vtable->getErrors(self))
#define IStatus_getWarnings(self) ((self)->vtable->getWarnings(self))
#define IStatus_clone(self) ((self)->vtable->clone(self))

#define IMaster_VERSION 2

struct IMaster;

struct IMasterVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	struct IStatus* (*getStatus)(struct IMaster* self);
	struct IProvider* (*getDispatcher)(struct IMaster* self);
	struct IPluginManager* (*getPluginManager)(struct IMaster* self);
	struct ITimerControl* (*getTimerControl)(struct IMaster* self);
	struct IDtc* (*getDtc)(struct IMaster* self);
	struct IAttachment* (*registerAttachment)(struct IMaster* self, struct IProvider* provider, struct IAttachment* attachment);
	struct ITransaction* (*registerTransaction)(struct IMaster* self, struct IAttachment* attachment, struct ITransaction* transaction);
	struct IMetadataBuilder* (*getMetadataBuilder)(struct IMaster* self, struct IStatus* status, unsigned fieldCount);
	int (*serverMode)(struct IMaster* self, int mode);
	struct IUtil* (*getUtilInterface)(struct IMaster* self);
	struct IConfigManager* (*getConfigManager)(struct IMaster* self);
	FB_BOOLEAN (*getProcessExiting)(struct IMaster* self);
};

struct IMaster
{
	void* cloopDummy[1];
	struct IMasterVTable* vtable;
};

#define IMaster_getStatus(self) ((self)->vtable->getStatus(self))
#define IMaster_getDispatcher(self) ((self)->vtable->getDispatcher(self))
#define IMaster_getPluginManager(self) ((self)->vtable->getPluginManager(self))
#define IMaster_getTimerControl(self) ((self)->vtable->getTimerControl(self))
#define IMaster_getDtc(self) ((self)->vtable->getDtc(self))
#define IMaster_registerAttachment(self, provider, attachment) ((self)->vtable->registerAttachment(self, (provider), (attachment)))
#define IMaster_registerTransaction(self, attachment, transaction) ((self)->vtable->registerTransaction(self, (attachment), (transaction)))
#define IMaster_getMetadataBuilder(self, status, fieldCount) ((self)->vtable->getMetadataBuilder(self, (status), (fieldCount)))
#define IMaster_serverMode(self, mode) ((self)->vtable->serverMode(self, (mode)))
#define IMaster_getUtilInterface(self) ((self)->vtable->getUtilInterface(self))
#define IMaster_getConfigManager(self) ((self)->vtable->getConfigManager(self))
#define IMaster_getProcessExiting(self) ((self)->vtable->getProcessExiting(self))

#define IPluginBase_VERSION 3

struct IPluginBase;

struct IPluginBaseVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IPluginBase* self);
	int (*release)(struct IPluginBase* self);
	void (*setOwner)(struct IPluginBase* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IPluginBase* self);
};

struct IPluginBase
{
	void* cloopDummy[1];
	struct IPluginBaseVTable* vtable;
};

#define IPluginBase_addRef(self) (self)->vtable->addRef(self)
#define IPluginBase_release(self) ((self)->vtable->release(self))
#define IPluginBase_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IPluginBase_getOwner(self) ((self)->vtable->getOwner(self))

#define IPluginSet_VERSION 3

struct IPluginSet;

struct IPluginSetVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IPluginSet* self);
	int (*release)(struct IPluginSet* self);
	const char* (*getName)(const struct IPluginSet* self);
	const char* (*getModuleName)(const struct IPluginSet* self);
	struct IPluginBase* (*getPlugin)(struct IPluginSet* self, struct IStatus* status);
	void (*next)(struct IPluginSet* self, struct IStatus* status);
	void (*set)(struct IPluginSet* self, struct IStatus* status, const char* s);
};

struct IPluginSet
{
	void* cloopDummy[1];
	struct IPluginSetVTable* vtable;
};

#define IPluginSet_addRef(self) (self)->vtable->addRef(self)
#define IPluginSet_release(self) ((self)->vtable->release(self))
#define IPluginSet_getName(self) ((self)->vtable->getName(self))
#define IPluginSet_getModuleName(self) ((self)->vtable->getModuleName(self))
#define IPluginSet_getPlugin(self, status) ((self)->vtable->getPlugin(self, (status)))
#define IPluginSet_next(self, status) (self)->vtable->next(self, (status))
#define IPluginSet_set(self, status, s) (self)->vtable->set(self, (status), (s))

#define IConfigEntry_VERSION 3

struct IConfigEntry;

struct IConfigEntryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IConfigEntry* self);
	int (*release)(struct IConfigEntry* self);
	const char* (*getName)(struct IConfigEntry* self);
	const char* (*getValue)(struct IConfigEntry* self);
	ISC_INT64 (*getIntValue)(struct IConfigEntry* self);
	FB_BOOLEAN (*getBoolValue)(struct IConfigEntry* self);
	struct IConfig* (*getSubConfig)(struct IConfigEntry* self, struct IStatus* status);
};

struct IConfigEntry
{
	void* cloopDummy[1];
	struct IConfigEntryVTable* vtable;
};

#define IConfigEntry_addRef(self) (self)->vtable->addRef(self)
#define IConfigEntry_release(self) ((self)->vtable->release(self))
#define IConfigEntry_getName(self) ((self)->vtable->getName(self))
#define IConfigEntry_getValue(self) ((self)->vtable->getValue(self))
#define IConfigEntry_getIntValue(self) ((self)->vtable->getIntValue(self))
#define IConfigEntry_getBoolValue(self) ((self)->vtable->getBoolValue(self))
#define IConfigEntry_getSubConfig(self, status) ((self)->vtable->getSubConfig(self, (status)))

#define IConfig_VERSION 3

struct IConfig;

struct IConfigVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IConfig* self);
	int (*release)(struct IConfig* self);
	struct IConfigEntry* (*find)(struct IConfig* self, struct IStatus* status, const char* name);
	struct IConfigEntry* (*findValue)(struct IConfig* self, struct IStatus* status, const char* name, const char* value);
	struct IConfigEntry* (*findPos)(struct IConfig* self, struct IStatus* status, const char* name, unsigned pos);
};

struct IConfig
{
	void* cloopDummy[1];
	struct IConfigVTable* vtable;
};

#define IConfig_addRef(self) (self)->vtable->addRef(self)
#define IConfig_release(self) ((self)->vtable->release(self))
#define IConfig_find(self, status, name) ((self)->vtable->find(self, (status), (name)))
#define IConfig_findValue(self, status, name, value) ((self)->vtable->findValue(self, (status), (name), (value)))
#define IConfig_findPos(self, status, name, pos) ((self)->vtable->findPos(self, (status), (name), (pos)))

#define IFirebirdConf_VERSION 4

struct IFirebirdConf;

struct IFirebirdConfVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IFirebirdConf* self);
	int (*release)(struct IFirebirdConf* self);
	unsigned (*getKey)(struct IFirebirdConf* self, const char* name);
	ISC_INT64 (*asInteger)(struct IFirebirdConf* self, unsigned key);
	const char* (*asString)(struct IFirebirdConf* self, unsigned key);
	FB_BOOLEAN (*asBoolean)(struct IFirebirdConf* self, unsigned key);
	unsigned (*getVersion)(struct IFirebirdConf* self, struct IStatus* status);
};

struct IFirebirdConf
{
	void* cloopDummy[1];
	struct IFirebirdConfVTable* vtable;
};

#define IFirebirdConf_addRef(self) (self)->vtable->addRef(self)
#define IFirebirdConf_release(self) ((self)->vtable->release(self))
#define IFirebirdConf_getKey(self, name) ((self)->vtable->getKey(self, (name)))
#define IFirebirdConf_asInteger(self, key) ((self)->vtable->asInteger(self, (key)))
#define IFirebirdConf_asString(self, key) ((self)->vtable->asString(self, (key)))
#define IFirebirdConf_asBoolean(self, key) ((self)->vtable->asBoolean(self, (key)))
#define IFirebirdConf_getVersion(self, status) ((self)->vtable->getVersion(self, (status)))

#define IPluginConfig_VERSION 3

struct IPluginConfig;

struct IPluginConfigVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IPluginConfig* self);
	int (*release)(struct IPluginConfig* self);
	const char* (*getConfigFileName)(struct IPluginConfig* self);
	struct IConfig* (*getDefaultConfig)(struct IPluginConfig* self, struct IStatus* status);
	struct IFirebirdConf* (*getFirebirdConf)(struct IPluginConfig* self, struct IStatus* status);
	void (*setReleaseDelay)(struct IPluginConfig* self, struct IStatus* status, ISC_UINT64 microSeconds);
};

struct IPluginConfig
{
	void* cloopDummy[1];
	struct IPluginConfigVTable* vtable;
};

#define IPluginConfig_addRef(self) (self)->vtable->addRef(self)
#define IPluginConfig_release(self) ((self)->vtable->release(self))
#define IPluginConfig_getConfigFileName(self) ((self)->vtable->getConfigFileName(self))
#define IPluginConfig_getDefaultConfig(self, status) ((self)->vtable->getDefaultConfig(self, (status)))
#define IPluginConfig_getFirebirdConf(self, status) ((self)->vtable->getFirebirdConf(self, (status)))
#define IPluginConfig_setReleaseDelay(self, status, microSeconds) (self)->vtable->setReleaseDelay(self, (status), (microSeconds))

#define IPluginFactory_VERSION 2

struct IPluginFactory;

struct IPluginFactoryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	struct IPluginBase* (*createPlugin)(struct IPluginFactory* self, struct IStatus* status, struct IPluginConfig* factoryParameter);
};

struct IPluginFactory
{
	void* cloopDummy[1];
	struct IPluginFactoryVTable* vtable;
};

#define IPluginFactory_createPlugin(self, status, factoryParameter) ((self)->vtable->createPlugin(self, (status), (factoryParameter)))

#define IPluginModule_VERSION 3

struct IPluginModule;

struct IPluginModuleVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*doClean)(struct IPluginModule* self);
	void (*threadDetach)(struct IPluginModule* self);
};

struct IPluginModule
{
	void* cloopDummy[1];
	struct IPluginModuleVTable* vtable;
};

#define IPluginModule_doClean(self) (self)->vtable->doClean(self)
#define IPluginModule_threadDetach(self) (self)->vtable->threadDetach(self)

#define IPluginManager_VERSION 2

#define IPluginManager_TYPE_PROVIDER ((unsigned) (1))
#define IPluginManager_TYPE_FIRST_NON_LIB ((unsigned) (2))
#define IPluginManager_TYPE_AUTH_SERVER ((unsigned) (3))
#define IPluginManager_TYPE_AUTH_CLIENT ((unsigned) (4))
#define IPluginManager_TYPE_AUTH_USER_MANAGEMENT ((unsigned) (5))
#define IPluginManager_TYPE_EXTERNAL_ENGINE ((unsigned) (6))
#define IPluginManager_TYPE_TRACE ((unsigned) (7))
#define IPluginManager_TYPE_WIRE_CRYPT ((unsigned) (8))
#define IPluginManager_TYPE_DB_CRYPT ((unsigned) (9))
#define IPluginManager_TYPE_KEY_HOLDER ((unsigned) (10))
#define IPluginManager_TYPE_REPLICATOR ((unsigned) (11))
#define IPluginManager_TYPE_PROFILER ((unsigned) (12))
#define IPluginManager_TYPE_COUNT ((unsigned) (13))

struct IPluginManager;

struct IPluginManagerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*registerPluginFactory)(struct IPluginManager* self, unsigned pluginType, const char* defaultName, struct IPluginFactory* factory);
	void (*registerModule)(struct IPluginManager* self, struct IPluginModule* cleanup);
	void (*unregisterModule)(struct IPluginManager* self, struct IPluginModule* cleanup);
	struct IPluginSet* (*getPlugins)(struct IPluginManager* self, struct IStatus* status, unsigned pluginType, const char* namesList, struct IFirebirdConf* firebirdConf);
	struct IConfig* (*getConfig)(struct IPluginManager* self, struct IStatus* status, const char* filename);
	void (*releasePlugin)(struct IPluginManager* self, struct IPluginBase* plugin);
};

struct IPluginManager
{
	void* cloopDummy[1];
	struct IPluginManagerVTable* vtable;
};

#define IPluginManager_registerPluginFactory(self, pluginType, defaultName, factory) (self)->vtable->registerPluginFactory(self, (pluginType), (defaultName), (factory))
#define IPluginManager_registerModule(self, cleanup) (self)->vtable->registerModule(self, (cleanup))
#define IPluginManager_unregisterModule(self, cleanup) (self)->vtable->unregisterModule(self, (cleanup))
#define IPluginManager_getPlugins(self, status, pluginType, namesList, firebirdConf) ((self)->vtable->getPlugins(self, (status), (pluginType), (namesList), (firebirdConf)))
#define IPluginManager_getConfig(self, status, filename) ((self)->vtable->getConfig(self, (status), (filename)))
#define IPluginManager_releasePlugin(self, plugin) (self)->vtable->releasePlugin(self, (plugin))

#define ICryptKey_VERSION 2

struct ICryptKey;

struct ICryptKeyVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*setSymmetric)(struct ICryptKey* self, struct IStatus* status, const char* type, unsigned keyLength, const void* key);
	void (*setAsymmetric)(struct ICryptKey* self, struct IStatus* status, const char* type, unsigned encryptKeyLength, const void* encryptKey, unsigned decryptKeyLength, const void* decryptKey);
	const void* (*getEncryptKey)(struct ICryptKey* self, unsigned* length);
	const void* (*getDecryptKey)(struct ICryptKey* self, unsigned* length);
};

struct ICryptKey
{
	void* cloopDummy[1];
	struct ICryptKeyVTable* vtable;
};

#define ICryptKey_setSymmetric(self, status, type, keyLength, key) (self)->vtable->setSymmetric(self, (status), (type), (keyLength), (key))
#define ICryptKey_setAsymmetric(self, status, type, encryptKeyLength, encryptKey, decryptKeyLength, decryptKey) (self)->vtable->setAsymmetric(self, (status), (type), (encryptKeyLength), (encryptKey), (decryptKeyLength), (decryptKey))
#define ICryptKey_getEncryptKey(self, length) (self)->vtable->getEncryptKey(self, (length))
#define ICryptKey_getDecryptKey(self, length) (self)->vtable->getDecryptKey(self, (length))

#define IConfigManager_VERSION 3

#define IConfigManager_DIR_BIN ((unsigned) (0))
#define IConfigManager_DIR_SBIN ((unsigned) (1))
#define IConfigManager_DIR_CONF ((unsigned) (2))
#define IConfigManager_DIR_LIB ((unsigned) (3))
#define IConfigManager_DIR_INC ((unsigned) (4))
#define IConfigManager_DIR_DOC ((unsigned) (5))
#define IConfigManager_DIR_UDF ((unsigned) (6))
#define IConfigManager_DIR_SAMPLE ((unsigned) (7))
#define IConfigManager_DIR_SAMPLEDB ((unsigned) (8))
#define IConfigManager_DIR_HELP ((unsigned) (9))
#define IConfigManager_DIR_INTL ((unsigned) (10))
#define IConfigManager_DIR_MISC ((unsigned) (11))
#define IConfigManager_DIR_SECDB ((unsigned) (12))
#define IConfigManager_DIR_MSG ((unsigned) (13))
#define IConfigManager_DIR_LOG ((unsigned) (14))
#define IConfigManager_DIR_GUARD ((unsigned) (15))
#define IConfigManager_DIR_PLUGINS ((unsigned) (16))
#define IConfigManager_DIR_TZDATA ((unsigned) (17))
#define IConfigManager_DIR_COUNT ((unsigned) (18))

struct IConfigManager;

struct IConfigManagerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getDirectory)(struct IConfigManager* self, unsigned code);
	struct IFirebirdConf* (*getFirebirdConf)(struct IConfigManager* self);
	struct IFirebirdConf* (*getDatabaseConf)(struct IConfigManager* self, const char* dbName);
	struct IConfig* (*getPluginConfig)(struct IConfigManager* self, const char* configuredPlugin);
	const char* (*getInstallDirectory)(struct IConfigManager* self);
	const char* (*getRootDirectory)(struct IConfigManager* self);
	const char* (*getDefaultSecurityDb)(struct IConfigManager* self);
};

struct IConfigManager
{
	void* cloopDummy[1];
	struct IConfigManagerVTable* vtable;
};

#define IConfigManager_getDirectory(self, code) ((self)->vtable->getDirectory(self, (code)))
#define IConfigManager_getFirebirdConf(self) ((self)->vtable->getFirebirdConf(self))
#define IConfigManager_getDatabaseConf(self, dbName) ((self)->vtable->getDatabaseConf(self, (dbName)))
#define IConfigManager_getPluginConfig(self, configuredPlugin) ((self)->vtable->getPluginConfig(self, (configuredPlugin)))
#define IConfigManager_getInstallDirectory(self) ((self)->vtable->getInstallDirectory(self))
#define IConfigManager_getRootDirectory(self) ((self)->vtable->getRootDirectory(self))
#define IConfigManager_getDefaultSecurityDb(self) ((self)->vtable->getDefaultSecurityDb(self))

#define IEventCallback_VERSION 3

struct IEventCallback;

struct IEventCallbackVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IEventCallback* self);
	int (*release)(struct IEventCallback* self);
	void (*eventCallbackFunction)(struct IEventCallback* self, unsigned length, const unsigned char* events);
};

struct IEventCallback
{
	void* cloopDummy[1];
	struct IEventCallbackVTable* vtable;
};

#define IEventCallback_addRef(self) (self)->vtable->addRef(self)
#define IEventCallback_release(self) ((self)->vtable->release(self))
#define IEventCallback_eventCallbackFunction(self, length, events) (self)->vtable->eventCallbackFunction(self, (length), (events))

#define IBlob_VERSION 4

struct IBlob;

struct IBlobVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IBlob* self);
	int (*release)(struct IBlob* self);
	void (*getInfo)(struct IBlob* self, struct IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
	int (*getSegment)(struct IBlob* self, struct IStatus* status, unsigned bufferLength, void* buffer, unsigned* segmentLength);
	void (*putSegment)(struct IBlob* self, struct IStatus* status, unsigned length, const void* buffer);
	void (*deprecatedCancel)(struct IBlob* self, struct IStatus* status);
	void (*deprecatedClose)(struct IBlob* self, struct IStatus* status);
	int (*seek)(struct IBlob* self, struct IStatus* status, int mode, int offset);
	void (*cancel)(struct IBlob* self, struct IStatus* status);
	void (*close)(struct IBlob* self, struct IStatus* status);
};

struct IBlob
{
	void* cloopDummy[1];
	struct IBlobVTable* vtable;
};

#define IBlob_addRef(self) (self)->vtable->addRef(self)
#define IBlob_release(self) ((self)->vtable->release(self))
#define IBlob_getInfo(self, status, itemsLength, items, bufferLength, buffer) (self)->vtable->getInfo(self, (status), (itemsLength), (items), (bufferLength), (buffer))
#define IBlob_getSegment(self, status, bufferLength, buffer, segmentLength) ((self)->vtable->getSegment(self, (status), (bufferLength), (buffer), (segmentLength)))
#define IBlob_putSegment(self, status, length, buffer) (self)->vtable->putSegment(self, (status), (length), (buffer))
#define IBlob_deprecatedCancel(self, status) (self)->vtable->deprecatedCancel(self, (status))
#define IBlob_deprecatedClose(self, status) (self)->vtable->deprecatedClose(self, (status))
#define IBlob_seek(self, status, mode, offset) ((self)->vtable->seek(self, (status), (mode), (offset)))
#define IBlob_cancel(self, status) (self)->vtable->cancel(self, (status))
#define IBlob_close(self, status) (self)->vtable->close(self, (status))

#define ITransaction_VERSION 4

struct ITransaction;

struct ITransactionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct ITransaction* self);
	int (*release)(struct ITransaction* self);
	void (*getInfo)(struct ITransaction* self, struct IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
	void (*prepare)(struct ITransaction* self, struct IStatus* status, unsigned msgLength, const unsigned char* message);
	void (*deprecatedCommit)(struct ITransaction* self, struct IStatus* status);
	void (*commitRetaining)(struct ITransaction* self, struct IStatus* status);
	void (*deprecatedRollback)(struct ITransaction* self, struct IStatus* status);
	void (*rollbackRetaining)(struct ITransaction* self, struct IStatus* status);
	void (*deprecatedDisconnect)(struct ITransaction* self, struct IStatus* status);
	struct ITransaction* (*join)(struct ITransaction* self, struct IStatus* status, struct ITransaction* transaction);
	struct ITransaction* (*validate)(struct ITransaction* self, struct IStatus* status, struct IAttachment* attachment);
	struct ITransaction* (*enterDtc)(struct ITransaction* self, struct IStatus* status);
	void (*commit)(struct ITransaction* self, struct IStatus* status);
	void (*rollback)(struct ITransaction* self, struct IStatus* status);
	void (*disconnect)(struct ITransaction* self, struct IStatus* status);
};

struct ITransaction
{
	void* cloopDummy[1];
	struct ITransactionVTable* vtable;
};

#define ITransaction_addRef(self) (self)->vtable->addRef(self)
#define ITransaction_release(self) ((self)->vtable->release(self))
#define ITransaction_getInfo(self, status, itemsLength, items, bufferLength, buffer) (self)->vtable->getInfo(self, (status), (itemsLength), (items), (bufferLength), (buffer))
#define ITransaction_prepare(self, status, msgLength, message) (self)->vtable->prepare(self, (status), (msgLength), (message))
#define ITransaction_deprecatedCommit(self, status) (self)->vtable->deprecatedCommit(self, (status))
#define ITransaction_commitRetaining(self, status) (self)->vtable->commitRetaining(self, (status))
#define ITransaction_deprecatedRollback(self, status) (self)->vtable->deprecatedRollback(self, (status))
#define ITransaction_rollbackRetaining(self, status) (self)->vtable->rollbackRetaining(self, (status))
#define ITransaction_deprecatedDisconnect(self, status) (self)->vtable->deprecatedDisconnect(self, (status))
#define ITransaction_join(self, status, transaction) ((self)->vtable->join(self, (status), (transaction)))
#define ITransaction_validate(self, status, attachment) ((self)->vtable->validate(self, (status), (attachment)))
#define ITransaction_enterDtc(self, status) ((self)->vtable->enterDtc(self, (status)))
#define ITransaction_commit(self, status) (self)->vtable->commit(self, (status))
#define ITransaction_rollback(self, status) (self)->vtable->rollback(self, (status))
#define ITransaction_disconnect(self, status) (self)->vtable->disconnect(self, (status))

#define IMessageMetadata_VERSION 4

struct IMessageMetadata;

struct IMessageMetadataVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IMessageMetadata* self);
	int (*release)(struct IMessageMetadata* self);
	unsigned (*getCount)(struct IMessageMetadata* self, struct IStatus* status);
	const char* (*getField)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	const char* (*getRelation)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	const char* (*getOwner)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	const char* (*getAlias)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	unsigned (*getType)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	FB_BOOLEAN (*isNullable)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	int (*getSubType)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	unsigned (*getLength)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	int (*getScale)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	unsigned (*getCharSet)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	unsigned (*getOffset)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	unsigned (*getNullOffset)(struct IMessageMetadata* self, struct IStatus* status, unsigned index);
	struct IMetadataBuilder* (*getBuilder)(struct IMessageMetadata* self, struct IStatus* status);
	unsigned (*getMessageLength)(struct IMessageMetadata* self, struct IStatus* status);
	unsigned (*getAlignment)(struct IMessageMetadata* self, struct IStatus* status);
	unsigned (*getAlignedLength)(struct IMessageMetadata* self, struct IStatus* status);
};

struct IMessageMetadata
{
	void* cloopDummy[1];
	struct IMessageMetadataVTable* vtable;
};

#define IMessageMetadata_addRef(self) (self)->vtable->addRef(self)
#define IMessageMetadata_release(self) ((self)->vtable->release(self))
#define IMessageMetadata_getCount(self, status) ((self)->vtable->getCount(self, (status)))
#define IMessageMetadata_getField(self, status, index) ((self)->vtable->getField(self, (status), (index)))
#define IMessageMetadata_getRelation(self, status, index) ((self)->vtable->getRelation(self, (status), (index)))
#define IMessageMetadata_getOwner(self, status, index) ((self)->vtable->getOwner(self, (status), (index)))
#define IMessageMetadata_getAlias(self, status, index) ((self)->vtable->getAlias(self, (status), (index)))
#define IMessageMetadata_getType(self, status, index) ((self)->vtable->getType(self, (status), (index)))
#define IMessageMetadata_isNullable(self, status, index) ((self)->vtable->isNullable(self, (status), (index)))
#define IMessageMetadata_getSubType(self, status, index) ((self)->vtable->getSubType(self, (status), (index)))
#define IMessageMetadata_getLength(self, status, index) ((self)->vtable->getLength(self, (status), (index)))
#define IMessageMetadata_getScale(self, status, index) ((self)->vtable->getScale(self, (status), (index)))
#define IMessageMetadata_getCharSet(self, status, index) ((self)->vtable->getCharSet(self, (status), (index)))
#define IMessageMetadata_getOffset(self, status, index) ((self)->vtable->getOffset(self, (status), (index)))
#define IMessageMetadata_getNullOffset(self, status, index) ((self)->vtable->getNullOffset(self, (status), (index)))
#define IMessageMetadata_getBuilder(self, status) ((self)->vtable->getBuilder(self, (status)))
#define IMessageMetadata_getMessageLength(self, status) ((self)->vtable->getMessageLength(self, (status)))
#define IMessageMetadata_getAlignment(self, status) ((self)->vtable->getAlignment(self, (status)))
#define IMessageMetadata_getAlignedLength(self, status) ((self)->vtable->getAlignedLength(self, (status)))

#define IMetadataBuilder_VERSION 4

struct IMetadataBuilder;

struct IMetadataBuilderVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IMetadataBuilder* self);
	int (*release)(struct IMetadataBuilder* self);
	void (*setType)(struct IMetadataBuilder* self, struct IStatus* status, unsigned index, unsigned type);
	void (*setSubType)(struct IMetadataBuilder* self, struct IStatus* status, unsigned index, int subType);
	void (*setLength)(struct IMetadataBuilder* self, struct IStatus* status, unsigned index, unsigned length);
	void (*setCharSet)(struct IMetadataBuilder* self, struct IStatus* status, unsigned index, unsigned charSet);
	void (*setScale)(struct IMetadataBuilder* self, struct IStatus* status, unsigned index, int scale);
	void (*truncate)(struct IMetadataBuilder* self, struct IStatus* status, unsigned count);
	void (*moveNameToIndex)(struct IMetadataBuilder* self, struct IStatus* status, const char* name, unsigned index);
	void (*remove)(struct IMetadataBuilder* self, struct IStatus* status, unsigned index);
	unsigned (*addField)(struct IMetadataBuilder* self, struct IStatus* status);
	struct IMessageMetadata* (*getMetadata)(struct IMetadataBuilder* self, struct IStatus* status);
	void (*setField)(struct IMetadataBuilder* self, struct IStatus* status, unsigned index, const char* field);
	void (*setRelation)(struct IMetadataBuilder* self, struct IStatus* status, unsigned index, const char* relation);
	void (*setOwner)(struct IMetadataBuilder* self, struct IStatus* status, unsigned index, const char* owner);
	void (*setAlias)(struct IMetadataBuilder* self, struct IStatus* status, unsigned index, const char* alias);
};

struct IMetadataBuilder
{
	void* cloopDummy[1];
	struct IMetadataBuilderVTable* vtable;
};

#define IMetadataBuilder_addRef(self) (self)->vtable->addRef(self)
#define IMetadataBuilder_release(self) ((self)->vtable->release(self))
#define IMetadataBuilder_setType(self, status, index, type) (self)->vtable->setType(self, (status), (index), (type))
#define IMetadataBuilder_setSubType(self, status, index, subType) (self)->vtable->setSubType(self, (status), (index), (subType))
#define IMetadataBuilder_setLength(self, status, index, length) (self)->vtable->setLength(self, (status), (index), (length))
#define IMetadataBuilder_setCharSet(self, status, index, charSet) (self)->vtable->setCharSet(self, (status), (index), (charSet))
#define IMetadataBuilder_setScale(self, status, index, scale) (self)->vtable->setScale(self, (status), (index), (scale))
#define IMetadataBuilder_truncate(self, status, count) (self)->vtable->truncate(self, (status), (count))
#define IMetadataBuilder_moveNameToIndex(self, status, name, index) (self)->vtable->moveNameToIndex(self, (status), (name), (index))
#define IMetadataBuilder_remove(self, status, index) (self)->vtable->remove(self, (status), (index))
#define IMetadataBuilder_addField(self, status) ((self)->vtable->addField(self, (status)))
#define IMetadataBuilder_getMetadata(self, status) ((self)->vtable->getMetadata(self, (status)))
#define IMetadataBuilder_setField(self, status, index, field) (self)->vtable->setField(self, (status), (index), (field))
#define IMetadataBuilder_setRelation(self, status, index, relation) (self)->vtable->setRelation(self, (status), (index), (relation))
#define IMetadataBuilder_setOwner(self, status, index, owner) (self)->vtable->setOwner(self, (status), (index), (owner))
#define IMetadataBuilder_setAlias(self, status, index, alias) (self)->vtable->setAlias(self, (status), (index), (alias))

#define IResultSet_VERSION 5

#define IResultSet_INF_RECORD_COUNT ((unsigned char) (10))

struct IResultSet;

struct IResultSetVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IResultSet* self);
	int (*release)(struct IResultSet* self);
	int (*fetchNext)(struct IResultSet* self, struct IStatus* status, void* message);
	int (*fetchPrior)(struct IResultSet* self, struct IStatus* status, void* message);
	int (*fetchFirst)(struct IResultSet* self, struct IStatus* status, void* message);
	int (*fetchLast)(struct IResultSet* self, struct IStatus* status, void* message);
	int (*fetchAbsolute)(struct IResultSet* self, struct IStatus* status, int position, void* message);
	int (*fetchRelative)(struct IResultSet* self, struct IStatus* status, int offset, void* message);
	FB_BOOLEAN (*isEof)(struct IResultSet* self, struct IStatus* status);
	FB_BOOLEAN (*isBof)(struct IResultSet* self, struct IStatus* status);
	struct IMessageMetadata* (*getMetadata)(struct IResultSet* self, struct IStatus* status);
	void (*deprecatedClose)(struct IResultSet* self, struct IStatus* status);
	void (*setDelayedOutputFormat)(struct IResultSet* self, struct IStatus* status, struct IMessageMetadata* format);
	void (*close)(struct IResultSet* self, struct IStatus* status);
	void (*getInfo)(struct IResultSet* self, struct IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
};

struct IResultSet
{
	void* cloopDummy[1];
	struct IResultSetVTable* vtable;
};

#define IResultSet_addRef(self) (self)->vtable->addRef(self)
#define IResultSet_release(self) ((self)->vtable->release(self))
#define IResultSet_fetchNext(self, status, message) ((self)->vtable->fetchNext(self, (status), (message)))
#define IResultSet_fetchPrior(self, status, message) ((self)->vtable->fetchPrior(self, (status), (message)))
#define IResultSet_fetchFirst(self, status, message) ((self)->vtable->fetchFirst(self, (status), (message)))
#define IResultSet_fetchLast(self, status, message) ((self)->vtable->fetchLast(self, (status), (message)))
#define IResultSet_fetchAbsolute(self, status, position, message) ((self)->vtable->fetchAbsolute(self, (status), (position), (message)))
#define IResultSet_fetchRelative(self, status, offset, message) ((self)->vtable->fetchRelative(self, (status), (offset), (message)))
#define IResultSet_isEof(self, status) ((self)->vtable->isEof(self, (status)))
#define IResultSet_isBof(self, status) ((self)->vtable->isBof(self, (status)))
#define IResultSet_getMetadata(self, status) ((self)->vtable->getMetadata(self, (status)))
#define IResultSet_deprecatedClose(self, status) (self)->vtable->deprecatedClose(self, (status))
#define IResultSet_setDelayedOutputFormat(self, status, format) (self)->vtable->setDelayedOutputFormat(self, (status), (format))
#define IResultSet_close(self, status) (self)->vtable->close(self, (status))
#define IResultSet_getInfo(self, status, itemsLength, items, bufferLength, buffer) (self)->vtable->getInfo(self, (status), (itemsLength), (items), (bufferLength), (buffer))

#define IStatement_VERSION 5

#define IStatement_PREPARE_PREFETCH_NONE ((unsigned) (0x0))
#define IStatement_PREPARE_PREFETCH_TYPE ((unsigned) (0x1))
#define IStatement_PREPARE_PREFETCH_INPUT_PARAMETERS ((unsigned) (0x2))
#define IStatement_PREPARE_PREFETCH_OUTPUT_PARAMETERS ((unsigned) (0x4))
#define IStatement_PREPARE_PREFETCH_LEGACY_PLAN ((unsigned) (0x8))
#define IStatement_PREPARE_PREFETCH_DETAILED_PLAN ((unsigned) (0x10))
#define IStatement_PREPARE_PREFETCH_AFFECTED_RECORDS ((unsigned) (0x20))
#define IStatement_PREPARE_PREFETCH_FLAGS ((unsigned) (0x40))
#define IStatement_PREPARE_PREFETCH_METADATA ((unsigned) (IStatement_PREPARE_PREFETCH_TYPE | IStatement_PREPARE_PREFETCH_FLAGS | IStatement_PREPARE_PREFETCH_INPUT_PARAMETERS | IStatement_PREPARE_PREFETCH_OUTPUT_PARAMETERS))
#define IStatement_PREPARE_PREFETCH_ALL ((unsigned) (IStatement_PREPARE_PREFETCH_METADATA | IStatement_PREPARE_PREFETCH_LEGACY_PLAN | IStatement_PREPARE_PREFETCH_DETAILED_PLAN | IStatement_PREPARE_PREFETCH_AFFECTED_RECORDS))
#define IStatement_FLAG_HAS_CURSOR ((unsigned) (0x1))
#define IStatement_FLAG_REPEAT_EXECUTE ((unsigned) (0x2))
#define IStatement_CURSOR_TYPE_SCROLLABLE ((unsigned) (0x1))

struct IStatement;

struct IStatementVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IStatement* self);
	int (*release)(struct IStatement* self);
	void (*getInfo)(struct IStatement* self, struct IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
	unsigned (*getType)(struct IStatement* self, struct IStatus* status);
	const char* (*getPlan)(struct IStatement* self, struct IStatus* status, FB_BOOLEAN detailed);
	ISC_UINT64 (*getAffectedRecords)(struct IStatement* self, struct IStatus* status);
	struct IMessageMetadata* (*getInputMetadata)(struct IStatement* self, struct IStatus* status);
	struct IMessageMetadata* (*getOutputMetadata)(struct IStatement* self, struct IStatus* status);
	struct ITransaction* (*execute)(struct IStatement* self, struct IStatus* status, struct ITransaction* transaction, struct IMessageMetadata* inMetadata, void* inBuffer, struct IMessageMetadata* outMetadata, void* outBuffer);
	struct IResultSet* (*openCursor)(struct IStatement* self, struct IStatus* status, struct ITransaction* transaction, struct IMessageMetadata* inMetadata, void* inBuffer, struct IMessageMetadata* outMetadata, unsigned flags);
	void (*setCursorName)(struct IStatement* self, struct IStatus* status, const char* name);
	void (*deprecatedFree)(struct IStatement* self, struct IStatus* status);
	unsigned (*getFlags)(struct IStatement* self, struct IStatus* status);
	unsigned (*getTimeout)(struct IStatement* self, struct IStatus* status);
	void (*setTimeout)(struct IStatement* self, struct IStatus* status, unsigned timeOut);
	struct IBatch* (*createBatch)(struct IStatement* self, struct IStatus* status, struct IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par);
	void (*free)(struct IStatement* self, struct IStatus* status);
};

struct IStatement
{
	void* cloopDummy[1];
	struct IStatementVTable* vtable;
};

#define IStatement_addRef(self) (self)->vtable->addRef(self)
#define IStatement_release(self) ((self)->vtable->release(self))
#define IStatement_getInfo(self, status, itemsLength, items, bufferLength, buffer) (self)->vtable->getInfo(self, (status), (itemsLength), (items), (bufferLength), (buffer))
#define IStatement_getType(self, status) ((self)->vtable->getType(self, (status)))
#define IStatement_getPlan(self, status, detailed) ((self)->vtable->getPlan(self, (status), (detailed)))
#define IStatement_getAffectedRecords(self, status) ((self)->vtable->getAffectedRecords(self, (status)))
#define IStatement_getInputMetadata(self, status) ((self)->vtable->getInputMetadata(self, (status)))
#define IStatement_getOutputMetadata(self, status) ((self)->vtable->getOutputMetadata(self, (status)))
#define IStatement_execute(self, status, transaction, inMetadata, inBuffer, outMetadata, outBuffer) ((self)->vtable->execute(self, (status), (transaction), (inMetadata), (inBuffer), (outMetadata), (outBuffer)))
#define IStatement_openCursor(self, status, transaction, inMetadata, inBuffer, outMetadata, flags) ((self)->vtable->openCursor(self, (status), (transaction), (inMetadata), (inBuffer), (outMetadata), (flags)))
#define IStatement_setCursorName(self, status, name) (self)->vtable->setCursorName(self, (status), (name))
#define IStatement_deprecatedFree(self, status) (self)->vtable->deprecatedFree(self, (status))
#define IStatement_getFlags(self, status) ((self)->vtable->getFlags(self, (status)))
#define IStatement_getTimeout(self, status) ((self)->vtable->getTimeout(self, (status)))
#define IStatement_setTimeout(self, status, timeOut) (self)->vtable->setTimeout(self, (status), (timeOut))
#define IStatement_createBatch(self, status, inMetadata, parLength, par) ((self)->vtable->createBatch(self, (status), (inMetadata), (parLength), (par)))
#define IStatement_free(self, status) (self)->vtable->free(self, (status))

#define IBatch_VERSION 4

#define IBatch_VERSION1 ((unsigned char) (1))
#define IBatch_CURRENT_VERSION ((unsigned char) (IBatch_VERSION1))
#define IBatch_TAG_MULTIERROR ((unsigned char) (1))
#define IBatch_TAG_RECORD_COUNTS ((unsigned char) (2))
#define IBatch_TAG_BUFFER_BYTES_SIZE ((unsigned char) (3))
#define IBatch_TAG_BLOB_POLICY ((unsigned char) (4))
#define IBatch_TAG_DETAILED_ERRORS ((unsigned char) (5))
#define IBatch_INF_BUFFER_BYTES_SIZE ((unsigned char) (10))
#define IBatch_INF_DATA_BYTES_SIZE ((unsigned char) (11))
#define IBatch_INF_BLOBS_BYTES_SIZE ((unsigned char) (12))
#define IBatch_INF_BLOB_ALIGNMENT ((unsigned char) (13))
#define IBatch_INF_BLOB_HEADER ((unsigned char) (14))
#define IBatch_BLOB_NONE ((unsigned char) (0))
#define IBatch_BLOB_ID_ENGINE ((unsigned char) (1))
#define IBatch_BLOB_ID_USER ((unsigned char) (2))
#define IBatch_BLOB_STREAM ((unsigned char) (3))
#define IBatch_BLOB_SEGHDR_ALIGN ((unsigned) (2))

struct IBatch;

struct IBatchVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IBatch* self);
	int (*release)(struct IBatch* self);
	void (*add)(struct IBatch* self, struct IStatus* status, unsigned count, const void* inBuffer);
	void (*addBlob)(struct IBatch* self, struct IStatus* status, unsigned length, const void* inBuffer, ISC_QUAD* blobId, unsigned parLength, const unsigned char* par);
	void (*appendBlobData)(struct IBatch* self, struct IStatus* status, unsigned length, const void* inBuffer);
	void (*addBlobStream)(struct IBatch* self, struct IStatus* status, unsigned length, const void* inBuffer);
	void (*registerBlob)(struct IBatch* self, struct IStatus* status, const ISC_QUAD* existingBlob, ISC_QUAD* blobId);
	struct IBatchCompletionState* (*execute)(struct IBatch* self, struct IStatus* status, struct ITransaction* transaction);
	void (*cancel)(struct IBatch* self, struct IStatus* status);
	unsigned (*getBlobAlignment)(struct IBatch* self, struct IStatus* status);
	struct IMessageMetadata* (*getMetadata)(struct IBatch* self, struct IStatus* status);
	void (*setDefaultBpb)(struct IBatch* self, struct IStatus* status, unsigned parLength, const unsigned char* par);
	void (*deprecatedClose)(struct IBatch* self, struct IStatus* status);
	void (*close)(struct IBatch* self, struct IStatus* status);
	void (*getInfo)(struct IBatch* self, struct IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
};

struct IBatch
{
	void* cloopDummy[1];
	struct IBatchVTable* vtable;
};

#define IBatch_addRef(self) (self)->vtable->addRef(self)
#define IBatch_release(self) ((self)->vtable->release(self))
#define IBatch_add(self, status, count, inBuffer) (self)->vtable->add(self, (status), (count), (inBuffer))
#define IBatch_addBlob(self, status, length, inBuffer, blobId, parLength, par) (self)->vtable->addBlob(self, (status), (length), (inBuffer), (blobId), (parLength), (par))
#define IBatch_appendBlobData(self, status, length, inBuffer) (self)->vtable->appendBlobData(self, (status), (length), (inBuffer))
#define IBatch_addBlobStream(self, status, length, inBuffer) (self)->vtable->addBlobStream(self, (status), (length), (inBuffer))
#define IBatch_registerBlob(self, status, existingBlob, blobId) (self)->vtable->registerBlob(self, (status), (existingBlob), (blobId))
#define IBatch_execute(self, status, transaction) ((self)->vtable->execute(self, (status), (transaction)))
#define IBatch_cancel(self, status) (self)->vtable->cancel(self, (status))
#define IBatch_getBlobAlignment(self, status) ((self)->vtable->getBlobAlignment(self, (status)))
#define IBatch_getMetadata(self, status) ((self)->vtable->getMetadata(self, (status)))
#define IBatch_setDefaultBpb(self, status, parLength, par) (self)->vtable->setDefaultBpb(self, (status), (parLength), (par))
#define IBatch_deprecatedClose(self, status) (self)->vtable->deprecatedClose(self, (status))
#define IBatch_close(self, status) (self)->vtable->close(self, (status))
#define IBatch_getInfo(self, status, itemsLength, items, bufferLength, buffer) (self)->vtable->getInfo(self, (status), (itemsLength), (items), (bufferLength), (buffer))

#define IBatchCompletionState_VERSION 3

#define IBatchCompletionState_EXECUTE_FAILED ((int) (-1))
#define IBatchCompletionState_SUCCESS_NO_INFO ((int) (-2))
#define IBatchCompletionState_NO_MORE_ERRORS ((unsigned) (0xffffffff))

struct IBatchCompletionState;

struct IBatchCompletionStateVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IBatchCompletionState* self);
	unsigned (*getSize)(struct IBatchCompletionState* self, struct IStatus* status);
	int (*getState)(struct IBatchCompletionState* self, struct IStatus* status, unsigned pos);
	unsigned (*findError)(struct IBatchCompletionState* self, struct IStatus* status, unsigned pos);
	void (*getStatus)(struct IBatchCompletionState* self, struct IStatus* status, struct IStatus* to, unsigned pos);
};

struct IBatchCompletionState
{
	void* cloopDummy[1];
	struct IBatchCompletionStateVTable* vtable;
};

#define IBatchCompletionState_dispose(self) (self)->vtable->dispose(self)
#define IBatchCompletionState_getSize(self, status) ((self)->vtable->getSize(self, (status)))
#define IBatchCompletionState_getState(self, status, pos) ((self)->vtable->getState(self, (status), (pos)))
#define IBatchCompletionState_findError(self, status, pos) ((self)->vtable->findError(self, (status), (pos)))
#define IBatchCompletionState_getStatus(self, status, to, pos) (self)->vtable->getStatus(self, (status), (to), (pos))

#define IReplicator_VERSION 4

struct IReplicator;

struct IReplicatorVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IReplicator* self);
	int (*release)(struct IReplicator* self);
	void (*process)(struct IReplicator* self, struct IStatus* status, unsigned length, const unsigned char* data);
	void (*deprecatedClose)(struct IReplicator* self, struct IStatus* status);
	void (*close)(struct IReplicator* self, struct IStatus* status);
};

struct IReplicator
{
	void* cloopDummy[1];
	struct IReplicatorVTable* vtable;
};

#define IReplicator_addRef(self) (self)->vtable->addRef(self)
#define IReplicator_release(self) ((self)->vtable->release(self))
#define IReplicator_process(self, status, length, data) (self)->vtable->process(self, (status), (length), (data))
#define IReplicator_deprecatedClose(self, status) (self)->vtable->deprecatedClose(self, (status))
#define IReplicator_close(self, status) (self)->vtable->close(self, (status))

#define IRequest_VERSION 4

struct IRequest;

struct IRequestVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IRequest* self);
	int (*release)(struct IRequest* self);
	void (*receive)(struct IRequest* self, struct IStatus* status, int level, unsigned msgType, unsigned length, void* message);
	void (*send)(struct IRequest* self, struct IStatus* status, int level, unsigned msgType, unsigned length, const void* message);
	void (*getInfo)(struct IRequest* self, struct IStatus* status, int level, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
	void (*start)(struct IRequest* self, struct IStatus* status, struct ITransaction* tra, int level);
	void (*startAndSend)(struct IRequest* self, struct IStatus* status, struct ITransaction* tra, int level, unsigned msgType, unsigned length, const void* message);
	void (*unwind)(struct IRequest* self, struct IStatus* status, int level);
	void (*deprecatedFree)(struct IRequest* self, struct IStatus* status);
	void (*free)(struct IRequest* self, struct IStatus* status);
};

struct IRequest
{
	void* cloopDummy[1];
	struct IRequestVTable* vtable;
};

#define IRequest_addRef(self) (self)->vtable->addRef(self)
#define IRequest_release(self) ((self)->vtable->release(self))
#define IRequest_receive(self, status, level, msgType, length, message) (self)->vtable->receive(self, (status), (level), (msgType), (length), (message))
#define IRequest_send(self, status, level, msgType, length, message) (self)->vtable->send(self, (status), (level), (msgType), (length), (message))
#define IRequest_getInfo(self, status, level, itemsLength, items, bufferLength, buffer) (self)->vtable->getInfo(self, (status), (level), (itemsLength), (items), (bufferLength), (buffer))
#define IRequest_start(self, status, tra, level) (self)->vtable->start(self, (status), (tra), (level))
#define IRequest_startAndSend(self, status, tra, level, msgType, length, message) (self)->vtable->startAndSend(self, (status), (tra), (level), (msgType), (length), (message))
#define IRequest_unwind(self, status, level) (self)->vtable->unwind(self, (status), (level))
#define IRequest_deprecatedFree(self, status) (self)->vtable->deprecatedFree(self, (status))
#define IRequest_free(self, status) (self)->vtable->free(self, (status))

#define IEvents_VERSION 4

struct IEvents;

struct IEventsVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IEvents* self);
	int (*release)(struct IEvents* self);
	void (*deprecatedCancel)(struct IEvents* self, struct IStatus* status);
	void (*cancel)(struct IEvents* self, struct IStatus* status);
};

struct IEvents
{
	void* cloopDummy[1];
	struct IEventsVTable* vtable;
};

#define IEvents_addRef(self) (self)->vtable->addRef(self)
#define IEvents_release(self) ((self)->vtable->release(self))
#define IEvents_deprecatedCancel(self, status) (self)->vtable->deprecatedCancel(self, (status))
#define IEvents_cancel(self, status) (self)->vtable->cancel(self, (status))

#define IAttachment_VERSION 5

struct IAttachment;

struct IAttachmentVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IAttachment* self);
	int (*release)(struct IAttachment* self);
	void (*getInfo)(struct IAttachment* self, struct IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer);
	struct ITransaction* (*startTransaction)(struct IAttachment* self, struct IStatus* status, unsigned tpbLength, const unsigned char* tpb);
	struct ITransaction* (*reconnectTransaction)(struct IAttachment* self, struct IStatus* status, unsigned length, const unsigned char* id);
	struct IRequest* (*compileRequest)(struct IAttachment* self, struct IStatus* status, unsigned blrLength, const unsigned char* blr);
	void (*transactRequest)(struct IAttachment* self, struct IStatus* status, struct ITransaction* transaction, unsigned blrLength, const unsigned char* blr, unsigned inMsgLength, const unsigned char* inMsg, unsigned outMsgLength, unsigned char* outMsg);
	struct IBlob* (*createBlob)(struct IAttachment* self, struct IStatus* status, struct ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb);
	struct IBlob* (*openBlob)(struct IAttachment* self, struct IStatus* status, struct ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb);
	int (*getSlice)(struct IAttachment* self, struct IStatus* status, struct ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice);
	void (*putSlice)(struct IAttachment* self, struct IStatus* status, struct ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice);
	void (*executeDyn)(struct IAttachment* self, struct IStatus* status, struct ITransaction* transaction, unsigned length, const unsigned char* dyn);
	struct IStatement* (*prepare)(struct IAttachment* self, struct IStatus* status, struct ITransaction* tra, unsigned stmtLength, const char* sqlStmt, unsigned dialect, unsigned flags);
	struct ITransaction* (*execute)(struct IAttachment* self, struct IStatus* status, struct ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, struct IMessageMetadata* inMetadata, void* inBuffer, struct IMessageMetadata* outMetadata, void* outBuffer);
	struct IResultSet* (*openCursor)(struct IAttachment* self, struct IStatus* status, struct ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, struct IMessageMetadata* inMetadata, void* inBuffer, struct IMessageMetadata* outMetadata, const char* cursorName, unsigned cursorFlags);
	struct IEvents* (*queEvents)(struct IAttachment* self, struct IStatus* status, struct IEventCallback* callback, unsigned length, const unsigned char* events);
	void (*cancelOperation)(struct IAttachment* self, struct IStatus* status, int option);
	void (*ping)(struct IAttachment* self, struct IStatus* status);
	void (*deprecatedDetach)(struct IAttachment* self, struct IStatus* status);
	void (*deprecatedDropDatabase)(struct IAttachment* self, struct IStatus* status);
	unsigned (*getIdleTimeout)(struct IAttachment* self, struct IStatus* status);
	void (*setIdleTimeout)(struct IAttachment* self, struct IStatus* status, unsigned timeOut);
	unsigned (*getStatementTimeout)(struct IAttachment* self, struct IStatus* status);
	void (*setStatementTimeout)(struct IAttachment* self, struct IStatus* status, unsigned timeOut);
	struct IBatch* (*createBatch)(struct IAttachment* self, struct IStatus* status, struct ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, struct IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par);
	struct IReplicator* (*createReplicator)(struct IAttachment* self, struct IStatus* status);
	void (*detach)(struct IAttachment* self, struct IStatus* status);
	void (*dropDatabase)(struct IAttachment* self, struct IStatus* status);
};

struct IAttachment
{
	void* cloopDummy[1];
	struct IAttachmentVTable* vtable;
};

#define IAttachment_addRef(self) (self)->vtable->addRef(self)
#define IAttachment_release(self) ((self)->vtable->release(self))
#define IAttachment_getInfo(self, status, itemsLength, items, bufferLength, buffer) (self)->vtable->getInfo(self, (status), (itemsLength), (items), (bufferLength), (buffer))
#define IAttachment_startTransaction(self, status, tpbLength, tpb) ((self)->vtable->startTransaction(self, (status), (tpbLength), (tpb)))
#define IAttachment_reconnectTransaction(self, status, length, id) ((self)->vtable->reconnectTransaction(self, (status), (length), (id)))
#define IAttachment_compileRequest(self, status, blrLength, blr) ((self)->vtable->compileRequest(self, (status), (blrLength), (blr)))
#define IAttachment_transactRequest(self, status, transaction, blrLength, blr, inMsgLength, inMsg, outMsgLength, outMsg) (self)->vtable->transactRequest(self, (status), (transaction), (blrLength), (blr), (inMsgLength), (inMsg), (outMsgLength), (outMsg))
#define IAttachment_createBlob(self, status, transaction, id, bpbLength, bpb) ((self)->vtable->createBlob(self, (status), (transaction), (id), (bpbLength), (bpb)))
#define IAttachment_openBlob(self, status, transaction, id, bpbLength, bpb) ((self)->vtable->openBlob(self, (status), (transaction), (id), (bpbLength), (bpb)))
#define IAttachment_getSlice(self, status, transaction, id, sdlLength, sdl, paramLength, param, sliceLength, slice) ((self)->vtable->getSlice(self, (status), (transaction), (id), (sdlLength), (sdl), (paramLength), (param), (sliceLength), (slice)))
#define IAttachment_putSlice(self, status, transaction, id, sdlLength, sdl, paramLength, param, sliceLength, slice) (self)->vtable->putSlice(self, (status), (transaction), (id), (sdlLength), (sdl), (paramLength), (param), (sliceLength), (slice))
#define IAttachment_executeDyn(self, status, transaction, length, dyn) (self)->vtable->executeDyn(self, (status), (transaction), (length), (dyn))
#define IAttachment_prepare(self, status, tra, stmtLength, sqlStmt, dialect, flags) ((self)->vtable->prepare(self, (status), (tra), (stmtLength), (sqlStmt), (dialect), (flags)))
#define IAttachment_execute(self, status, transaction, stmtLength, sqlStmt, dialect, inMetadata, inBuffer, outMetadata, outBuffer) ((self)->vtable->execute(self, (status), (transaction), (stmtLength), (sqlStmt), (dialect), (inMetadata), (inBuffer), (outMetadata), (outBuffer)))
#define IAttachment_openCursor(self, status, transaction, stmtLength, sqlStmt, dialect, inMetadata, inBuffer, outMetadata, cursorName, cursorFlags) ((self)->vtable->openCursor(self, (status), (transaction), (stmtLength), (sqlStmt), (dialect), (inMetadata), (inBuffer), (outMetadata), (cursorName), (cursorFlags)))
#define IAttachment_queEvents(self, status, callback, length, events) ((self)->vtable->queEvents(self, (status), (callback), (length), (events)))
#define IAttachment_cancelOperation(self, status, option) (self)->vtable->cancelOperation(self, (status), (option))
#define IAttachment_ping(self, status) (self)->vtable->ping(self, (status))
#define IAttachment_deprecatedDetach(self, status) (self)->vtable->deprecatedDetach(self, (status))
#define IAttachment_deprecatedDropDatabase(self, status) (self)->vtable->deprecatedDropDatabase(self, (status))
#define IAttachment_getIdleTimeout(self, status) ((self)->vtable->getIdleTimeout(self, (status)))
#define IAttachment_setIdleTimeout(self, status, timeOut) (self)->vtable->setIdleTimeout(self, (status), (timeOut))
#define IAttachment_getStatementTimeout(self, status) ((self)->vtable->getStatementTimeout(self, (status)))
#define IAttachment_setStatementTimeout(self, status, timeOut) (self)->vtable->setStatementTimeout(self, (status), (timeOut))
#define IAttachment_createBatch(self, status, transaction, stmtLength, sqlStmt, dialect, inMetadata, parLength, par) ((self)->vtable->createBatch(self, (status), (transaction), (stmtLength), (sqlStmt), (dialect), (inMetadata), (parLength), (par)))
#define IAttachment_createReplicator(self, status) ((self)->vtable->createReplicator(self, (status)))
#define IAttachment_detach(self, status) (self)->vtable->detach(self, (status))
#define IAttachment_dropDatabase(self, status) (self)->vtable->dropDatabase(self, (status))

#define IService_VERSION 5

struct IService;

struct IServiceVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IService* self);
	int (*release)(struct IService* self);
	void (*deprecatedDetach)(struct IService* self, struct IStatus* status);
	void (*query)(struct IService* self, struct IStatus* status, unsigned sendLength, const unsigned char* sendItems, unsigned receiveLength, const unsigned char* receiveItems, unsigned bufferLength, unsigned char* buffer);
	void (*start)(struct IService* self, struct IStatus* status, unsigned spbLength, const unsigned char* spb);
	void (*detach)(struct IService* self, struct IStatus* status);
	void (*cancel)(struct IService* self, struct IStatus* status);
};

struct IService
{
	void* cloopDummy[1];
	struct IServiceVTable* vtable;
};

#define IService_addRef(self) (self)->vtable->addRef(self)
#define IService_release(self) ((self)->vtable->release(self))
#define IService_deprecatedDetach(self, status) (self)->vtable->deprecatedDetach(self, (status))
#define IService_query(self, status, sendLength, sendItems, receiveLength, receiveItems, bufferLength, buffer) (self)->vtable->query(self, (status), (sendLength), (sendItems), (receiveLength), (receiveItems), (bufferLength), (buffer))
#define IService_start(self, status, spbLength, spb) (self)->vtable->start(self, (status), (spbLength), (spb))
#define IService_detach(self, status) (self)->vtable->detach(self, (status))
#define IService_cancel(self, status) (self)->vtable->cancel(self, (status))

#define IProvider_VERSION 4

struct IProvider;

struct IProviderVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IProvider* self);
	int (*release)(struct IProvider* self);
	void (*setOwner)(struct IProvider* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IProvider* self);
	struct IAttachment* (*attachDatabase)(struct IProvider* self, struct IStatus* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb);
	struct IAttachment* (*createDatabase)(struct IProvider* self, struct IStatus* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb);
	struct IService* (*attachServiceManager)(struct IProvider* self, struct IStatus* status, const char* service, unsigned spbLength, const unsigned char* spb);
	void (*shutdown)(struct IProvider* self, struct IStatus* status, unsigned timeout, const int reason);
	void (*setDbCryptCallback)(struct IProvider* self, struct IStatus* status, struct ICryptKeyCallback* cryptCallback);
};

struct IProvider
{
	void* cloopDummy[1];
	struct IProviderVTable* vtable;
};

#define IProvider_addRef(self) (self)->vtable->addRef(self)
#define IProvider_release(self) ((self)->vtable->release(self))
#define IProvider_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IProvider_getOwner(self) ((self)->vtable->getOwner(self))
#define IProvider_attachDatabase(self, status, fileName, dpbLength, dpb) ((self)->vtable->attachDatabase(self, (status), (fileName), (dpbLength), (dpb)))
#define IProvider_createDatabase(self, status, fileName, dpbLength, dpb) ((self)->vtable->createDatabase(self, (status), (fileName), (dpbLength), (dpb)))
#define IProvider_attachServiceManager(self, status, service, spbLength, spb) ((self)->vtable->attachServiceManager(self, (status), (service), (spbLength), (spb)))
#define IProvider_shutdown(self, status, timeout, reason) (self)->vtable->shutdown(self, (status), (timeout), (reason))
#define IProvider_setDbCryptCallback(self, status, cryptCallback) (self)->vtable->setDbCryptCallback(self, (status), (cryptCallback))

#define IDtcStart_VERSION 3

struct IDtcStart;

struct IDtcStartVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IDtcStart* self);
	void (*addAttachment)(struct IDtcStart* self, struct IStatus* status, struct IAttachment* att);
	void (*addWithTpb)(struct IDtcStart* self, struct IStatus* status, struct IAttachment* att, unsigned length, const unsigned char* tpb);
	struct ITransaction* (*start)(struct IDtcStart* self, struct IStatus* status);
};

struct IDtcStart
{
	void* cloopDummy[1];
	struct IDtcStartVTable* vtable;
};

#define IDtcStart_dispose(self) (self)->vtable->dispose(self)
#define IDtcStart_addAttachment(self, status, att) (self)->vtable->addAttachment(self, (status), (att))
#define IDtcStart_addWithTpb(self, status, att, length, tpb) (self)->vtable->addWithTpb(self, (status), (att), (length), (tpb))
#define IDtcStart_start(self, status) ((self)->vtable->start(self, (status)))

#define IDtc_VERSION 2

struct IDtc;

struct IDtcVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	struct ITransaction* (*join)(struct IDtc* self, struct IStatus* status, struct ITransaction* one, struct ITransaction* two);
	struct IDtcStart* (*startBuilder)(struct IDtc* self, struct IStatus* status);
};

struct IDtc
{
	void* cloopDummy[1];
	struct IDtcVTable* vtable;
};

#define IDtc_join(self, status, one, two) ((self)->vtable->join(self, (status), (one), (two)))
#define IDtc_startBuilder(self, status) ((self)->vtable->startBuilder(self, (status)))

#define IAuth_VERSION 4

#define IAuth_AUTH_FAILED ((int) (-1))
#define IAuth_AUTH_SUCCESS ((int) (0))
#define IAuth_AUTH_MORE_DATA ((int) (1))
#define IAuth_AUTH_CONTINUE ((int) (2))
#define IAuth_AUTH_SUCCESS_WITH_DATA ((int) (3))

struct IAuth;

struct IAuthVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IAuth* self);
	int (*release)(struct IAuth* self);
	void (*setOwner)(struct IAuth* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IAuth* self);
};

struct IAuth
{
	void* cloopDummy[1];
	struct IAuthVTable* vtable;
};

#define IAuth_addRef(self) (self)->vtable->addRef(self)
#define IAuth_release(self) ((self)->vtable->release(self))
#define IAuth_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IAuth_getOwner(self) ((self)->vtable->getOwner(self))

#define IWriter_VERSION 2

struct IWriter;

struct IWriterVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*reset)(struct IWriter* self);
	void (*add)(struct IWriter* self, struct IStatus* status, const char* name);
	void (*setType)(struct IWriter* self, struct IStatus* status, const char* value);
	void (*setDb)(struct IWriter* self, struct IStatus* status, const char* value);
};

struct IWriter
{
	void* cloopDummy[1];
	struct IWriterVTable* vtable;
};

#define IWriter_reset(self) (self)->vtable->reset(self)
#define IWriter_add(self, status, name) (self)->vtable->add(self, (status), (name))
#define IWriter_setType(self, status, value) (self)->vtable->setType(self, (status), (value))
#define IWriter_setDb(self, status, value) (self)->vtable->setDb(self, (status), (value))

#define IServerBlock_VERSION 2

struct IServerBlock;

struct IServerBlockVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getLogin)(struct IServerBlock* self);
	const unsigned char* (*getData)(struct IServerBlock* self, unsigned* length);
	void (*putData)(struct IServerBlock* self, struct IStatus* status, unsigned length, const void* data);
	struct ICryptKey* (*newKey)(struct IServerBlock* self, struct IStatus* status);
};

struct IServerBlock
{
	void* cloopDummy[1];
	struct IServerBlockVTable* vtable;
};

#define IServerBlock_getLogin(self) ((self)->vtable->getLogin(self))
#define IServerBlock_getData(self, length) ((self)->vtable->getData(self, (length)))
#define IServerBlock_putData(self, status, length, data) (self)->vtable->putData(self, (status), (length), (data))
#define IServerBlock_newKey(self, status) ((self)->vtable->newKey(self, (status)))

#define IClientBlock_VERSION 4

struct IClientBlock;

struct IClientBlockVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IClientBlock* self);
	int (*release)(struct IClientBlock* self);
	const char* (*getLogin)(struct IClientBlock* self);
	const char* (*getPassword)(struct IClientBlock* self);
	const unsigned char* (*getData)(struct IClientBlock* self, unsigned* length);
	void (*putData)(struct IClientBlock* self, struct IStatus* status, unsigned length, const void* data);
	struct ICryptKey* (*newKey)(struct IClientBlock* self, struct IStatus* status);
	struct IAuthBlock* (*getAuthBlock)(struct IClientBlock* self, struct IStatus* status);
};

struct IClientBlock
{
	void* cloopDummy[1];
	struct IClientBlockVTable* vtable;
};

#define IClientBlock_addRef(self) (self)->vtable->addRef(self)
#define IClientBlock_release(self) ((self)->vtable->release(self))
#define IClientBlock_getLogin(self) ((self)->vtable->getLogin(self))
#define IClientBlock_getPassword(self) ((self)->vtable->getPassword(self))
#define IClientBlock_getData(self, length) ((self)->vtable->getData(self, (length)))
#define IClientBlock_putData(self, status, length, data) (self)->vtable->putData(self, (status), (length), (data))
#define IClientBlock_newKey(self, status) ((self)->vtable->newKey(self, (status)))
#define IClientBlock_getAuthBlock(self, status) ((self)->vtable->getAuthBlock(self, (status)))

#define IServer_VERSION 6

struct IServer;

struct IServerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IServer* self);
	int (*release)(struct IServer* self);
	void (*setOwner)(struct IServer* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IServer* self);
	int (*authenticate)(struct IServer* self, struct IStatus* status, struct IServerBlock* sBlock, struct IWriter* writerInterface);
	void (*setDbCryptCallback)(struct IServer* self, struct IStatus* status, struct ICryptKeyCallback* cryptCallback);
};

struct IServer
{
	void* cloopDummy[1];
	struct IServerVTable* vtable;
};

#define IServer_addRef(self) (self)->vtable->addRef(self)
#define IServer_release(self) ((self)->vtable->release(self))
#define IServer_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IServer_getOwner(self) ((self)->vtable->getOwner(self))
#define IServer_authenticate(self, status, sBlock, writerInterface) ((self)->vtable->authenticate(self, (status), (sBlock), (writerInterface)))
#define IServer_setDbCryptCallback(self, status, cryptCallback) (self)->vtable->setDbCryptCallback(self, (status), (cryptCallback))

#define IClient_VERSION 5

struct IClient;

struct IClientVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IClient* self);
	int (*release)(struct IClient* self);
	void (*setOwner)(struct IClient* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IClient* self);
	int (*authenticate)(struct IClient* self, struct IStatus* status, struct IClientBlock* cBlock);
};

struct IClient
{
	void* cloopDummy[1];
	struct IClientVTable* vtable;
};

#define IClient_addRef(self) (self)->vtable->addRef(self)
#define IClient_release(self) ((self)->vtable->release(self))
#define IClient_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IClient_getOwner(self) ((self)->vtable->getOwner(self))
#define IClient_authenticate(self, status, cBlock) ((self)->vtable->authenticate(self, (status), (cBlock)))

#define IUserField_VERSION 2

struct IUserField;

struct IUserFieldVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	int (*entered)(struct IUserField* self);
	int (*specified)(struct IUserField* self);
	void (*setEntered)(struct IUserField* self, struct IStatus* status, int newValue);
};

struct IUserField
{
	void* cloopDummy[1];
	struct IUserFieldVTable* vtable;
};

#define IUserField_entered(self) ((self)->vtable->entered(self))
#define IUserField_specified(self) ((self)->vtable->specified(self))
#define IUserField_setEntered(self, status, newValue) (self)->vtable->setEntered(self, (status), (newValue))

#define ICharUserField_VERSION 3

struct ICharUserField;

struct ICharUserFieldVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	int (*entered)(struct ICharUserField* self);
	int (*specified)(struct ICharUserField* self);
	void (*setEntered)(struct ICharUserField* self, struct IStatus* status, int newValue);
	const char* (*get)(struct ICharUserField* self);
	void (*set)(struct ICharUserField* self, struct IStatus* status, const char* newValue);
};

struct ICharUserField
{
	void* cloopDummy[1];
	struct ICharUserFieldVTable* vtable;
};

#define ICharUserField_entered(self) ((self)->vtable->entered(self))
#define ICharUserField_specified(self) ((self)->vtable->specified(self))
#define ICharUserField_setEntered(self, status, newValue) (self)->vtable->setEntered(self, (status), (newValue))
#define ICharUserField_get(self) ((self)->vtable->get(self))
#define ICharUserField_set(self, status, newValue) (self)->vtable->set(self, (status), (newValue))

#define IIntUserField_VERSION 3

struct IIntUserField;

struct IIntUserFieldVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	int (*entered)(struct IIntUserField* self);
	int (*specified)(struct IIntUserField* self);
	void (*setEntered)(struct IIntUserField* self, struct IStatus* status, int newValue);
	int (*get)(struct IIntUserField* self);
	void (*set)(struct IIntUserField* self, struct IStatus* status, int newValue);
};

struct IIntUserField
{
	void* cloopDummy[1];
	struct IIntUserFieldVTable* vtable;
};

#define IIntUserField_entered(self) ((self)->vtable->entered(self))
#define IIntUserField_specified(self) ((self)->vtable->specified(self))
#define IIntUserField_setEntered(self, status, newValue) (self)->vtable->setEntered(self, (status), (newValue))
#define IIntUserField_get(self) ((self)->vtable->get(self))
#define IIntUserField_set(self, status, newValue) (self)->vtable->set(self, (status), (newValue))

#define IUser_VERSION 2

#define IUser_OP_USER_ADD ((unsigned) (1))
#define IUser_OP_USER_MODIFY ((unsigned) (2))
#define IUser_OP_USER_DELETE ((unsigned) (3))
#define IUser_OP_USER_DISPLAY ((unsigned) (4))
#define IUser_OP_USER_SET_MAP ((unsigned) (5))
#define IUser_OP_USER_DROP_MAP ((unsigned) (6))

struct IUser;

struct IUserVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*operation)(struct IUser* self);
	struct ICharUserField* (*userName)(struct IUser* self);
	struct ICharUserField* (*password)(struct IUser* self);
	struct ICharUserField* (*firstName)(struct IUser* self);
	struct ICharUserField* (*lastName)(struct IUser* self);
	struct ICharUserField* (*middleName)(struct IUser* self);
	struct ICharUserField* (*comment)(struct IUser* self);
	struct ICharUserField* (*attributes)(struct IUser* self);
	struct IIntUserField* (*active)(struct IUser* self);
	struct IIntUserField* (*admin)(struct IUser* self);
	void (*clear)(struct IUser* self, struct IStatus* status);
};

struct IUser
{
	void* cloopDummy[1];
	struct IUserVTable* vtable;
};

#define IUser_operation(self) ((self)->vtable->operation(self))
#define IUser_userName(self) ((self)->vtable->userName(self))
#define IUser_password(self) ((self)->vtable->password(self))
#define IUser_firstName(self) ((self)->vtable->firstName(self))
#define IUser_lastName(self) ((self)->vtable->lastName(self))
#define IUser_middleName(self) ((self)->vtable->middleName(self))
#define IUser_comment(self) ((self)->vtable->comment(self))
#define IUser_attributes(self) ((self)->vtable->attributes(self))
#define IUser_active(self) ((self)->vtable->active(self))
#define IUser_admin(self) ((self)->vtable->admin(self))
#define IUser_clear(self, status) (self)->vtable->clear(self, (status))

#define IListUsers_VERSION 2

struct IListUsers;

struct IListUsersVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*list)(struct IListUsers* self, struct IStatus* status, struct IUser* user);
};

struct IListUsers
{
	void* cloopDummy[1];
	struct IListUsersVTable* vtable;
};

#define IListUsers_list(self, status, user) (self)->vtable->list(self, (status), (user))

#define ILogonInfo_VERSION 3

struct ILogonInfo;

struct ILogonInfoVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*name)(struct ILogonInfo* self);
	const char* (*role)(struct ILogonInfo* self);
	const char* (*networkProtocol)(struct ILogonInfo* self);
	const char* (*remoteAddress)(struct ILogonInfo* self);
	const unsigned char* (*authBlock)(struct ILogonInfo* self, unsigned* length);
	struct IAttachment* (*attachment)(struct ILogonInfo* self, struct IStatus* status);
	struct ITransaction* (*transaction)(struct ILogonInfo* self, struct IStatus* status);
};

struct ILogonInfo
{
	void* cloopDummy[1];
	struct ILogonInfoVTable* vtable;
};

#define ILogonInfo_name(self) ((self)->vtable->name(self))
#define ILogonInfo_role(self) ((self)->vtable->role(self))
#define ILogonInfo_networkProtocol(self) ((self)->vtable->networkProtocol(self))
#define ILogonInfo_remoteAddress(self) ((self)->vtable->remoteAddress(self))
#define ILogonInfo_authBlock(self, length) ((self)->vtable->authBlock(self, (length)))
#define ILogonInfo_attachment(self, status) ((self)->vtable->attachment(self, (status)))
#define ILogonInfo_transaction(self, status) ((self)->vtable->transaction(self, (status)))

#define IManagement_VERSION 4

struct IManagement;

struct IManagementVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IManagement* self);
	int (*release)(struct IManagement* self);
	void (*setOwner)(struct IManagement* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IManagement* self);
	void (*start)(struct IManagement* self, struct IStatus* status, struct ILogonInfo* logonInfo);
	int (*execute)(struct IManagement* self, struct IStatus* status, struct IUser* user, struct IListUsers* callback);
	void (*commit)(struct IManagement* self, struct IStatus* status);
	void (*rollback)(struct IManagement* self, struct IStatus* status);
};

struct IManagement
{
	void* cloopDummy[1];
	struct IManagementVTable* vtable;
};

#define IManagement_addRef(self) (self)->vtable->addRef(self)
#define IManagement_release(self) ((self)->vtable->release(self))
#define IManagement_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IManagement_getOwner(self) ((self)->vtable->getOwner(self))
#define IManagement_start(self, status, logonInfo) (self)->vtable->start(self, (status), (logonInfo))
#define IManagement_execute(self, status, user, callback) ((self)->vtable->execute(self, (status), (user), (callback)))
#define IManagement_commit(self, status) (self)->vtable->commit(self, (status))
#define IManagement_rollback(self, status) (self)->vtable->rollback(self, (status))

#define IAuthBlock_VERSION 2

struct IAuthBlock;

struct IAuthBlockVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getType)(struct IAuthBlock* self);
	const char* (*getName)(struct IAuthBlock* self);
	const char* (*getPlugin)(struct IAuthBlock* self);
	const char* (*getSecurityDb)(struct IAuthBlock* self);
	const char* (*getOriginalPlugin)(struct IAuthBlock* self);
	FB_BOOLEAN (*next)(struct IAuthBlock* self, struct IStatus* status);
	FB_BOOLEAN (*first)(struct IAuthBlock* self, struct IStatus* status);
};

struct IAuthBlock
{
	void* cloopDummy[1];
	struct IAuthBlockVTable* vtable;
};

#define IAuthBlock_getType(self) ((self)->vtable->getType(self))
#define IAuthBlock_getName(self) ((self)->vtable->getName(self))
#define IAuthBlock_getPlugin(self) ((self)->vtable->getPlugin(self))
#define IAuthBlock_getSecurityDb(self) ((self)->vtable->getSecurityDb(self))
#define IAuthBlock_getOriginalPlugin(self) ((self)->vtable->getOriginalPlugin(self))
#define IAuthBlock_next(self, status) ((self)->vtable->next(self, (status)))
#define IAuthBlock_first(self, status) ((self)->vtable->first(self, (status)))

#define IWireCryptPlugin_VERSION 5

struct IWireCryptPlugin;

struct IWireCryptPluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IWireCryptPlugin* self);
	int (*release)(struct IWireCryptPlugin* self);
	void (*setOwner)(struct IWireCryptPlugin* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IWireCryptPlugin* self);
	const char* (*getKnownTypes)(struct IWireCryptPlugin* self, struct IStatus* status);
	void (*setKey)(struct IWireCryptPlugin* self, struct IStatus* status, struct ICryptKey* key);
	void (*encrypt)(struct IWireCryptPlugin* self, struct IStatus* status, unsigned length, const void* from, void* to);
	void (*decrypt)(struct IWireCryptPlugin* self, struct IStatus* status, unsigned length, const void* from, void* to);
	const unsigned char* (*getSpecificData)(struct IWireCryptPlugin* self, struct IStatus* status, const char* keyType, unsigned* length);
	void (*setSpecificData)(struct IWireCryptPlugin* self, struct IStatus* status, const char* keyType, unsigned length, const unsigned char* data);
};

struct IWireCryptPlugin
{
	void* cloopDummy[1];
	struct IWireCryptPluginVTable* vtable;
};

#define IWireCryptPlugin_addRef(self) (self)->vtable->addRef(self)
#define IWireCryptPlugin_release(self) ((self)->vtable->release(self))
#define IWireCryptPlugin_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IWireCryptPlugin_getOwner(self) ((self)->vtable->getOwner(self))
#define IWireCryptPlugin_getKnownTypes(self, status) ((self)->vtable->getKnownTypes(self, (status)))
#define IWireCryptPlugin_setKey(self, status, key) (self)->vtable->setKey(self, (status), (key))
#define IWireCryptPlugin_encrypt(self, status, length, from, to) (self)->vtable->encrypt(self, (status), (length), (from), (to))
#define IWireCryptPlugin_decrypt(self, status, length, from, to) (self)->vtable->decrypt(self, (status), (length), (from), (to))
#define IWireCryptPlugin_getSpecificData(self, status, keyType, length) ((self)->vtable->getSpecificData(self, (status), (keyType), (length)))
#define IWireCryptPlugin_setSpecificData(self, status, keyType, length, data) (self)->vtable->setSpecificData(self, (status), (keyType), (length), (data))

#define ICryptKeyCallback_VERSION 3

struct ICryptKeyCallback;

struct ICryptKeyCallbackVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*callback)(struct ICryptKeyCallback* self, unsigned dataLength, const void* data, unsigned bufferLength, void* buffer);
	void (*dummy1)(struct ICryptKeyCallback* self, struct IStatus* status);
	void (*dummy2)(struct ICryptKeyCallback* self);
	int (*getHashLength)(struct ICryptKeyCallback* self, struct IStatus* status);
	void (*getHashData)(struct ICryptKeyCallback* self, struct IStatus* status, void* hash);
};

struct ICryptKeyCallback
{
	void* cloopDummy[1];
	struct ICryptKeyCallbackVTable* vtable;
};

#define ICryptKeyCallback_callback(self, dataLength, data, bufferLength, buffer) ((self)->vtable->callback(self, (dataLength), (data), (bufferLength), (buffer)))
#define ICryptKeyCallback_dummy1(self, status) (self)->vtable->dummy1(self, (status))
#define ICryptKeyCallback_dummy2(self) (self)->vtable->dummy2(self)
#define ICryptKeyCallback_getHashLength(self, status) ((self)->vtable->getHashLength(self, (status)))
#define ICryptKeyCallback_getHashData(self, status, hash) (self)->vtable->getHashData(self, (status), (hash))

#define IKeyHolderPlugin_VERSION 5

struct IKeyHolderPlugin;

struct IKeyHolderPluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IKeyHolderPlugin* self);
	int (*release)(struct IKeyHolderPlugin* self);
	void (*setOwner)(struct IKeyHolderPlugin* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IKeyHolderPlugin* self);
	int (*keyCallback)(struct IKeyHolderPlugin* self, struct IStatus* status, struct ICryptKeyCallback* callback);
	struct ICryptKeyCallback* (*keyHandle)(struct IKeyHolderPlugin* self, struct IStatus* status, const char* keyName);
	FB_BOOLEAN (*useOnlyOwnKeys)(struct IKeyHolderPlugin* self, struct IStatus* status);
	struct ICryptKeyCallback* (*chainHandle)(struct IKeyHolderPlugin* self, struct IStatus* status);
};

struct IKeyHolderPlugin
{
	void* cloopDummy[1];
	struct IKeyHolderPluginVTable* vtable;
};

#define IKeyHolderPlugin_addRef(self) (self)->vtable->addRef(self)
#define IKeyHolderPlugin_release(self) ((self)->vtable->release(self))
#define IKeyHolderPlugin_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IKeyHolderPlugin_getOwner(self) ((self)->vtable->getOwner(self))
#define IKeyHolderPlugin_keyCallback(self, status, callback) ((self)->vtable->keyCallback(self, (status), (callback)))
#define IKeyHolderPlugin_keyHandle(self, status, keyName) ((self)->vtable->keyHandle(self, (status), (keyName)))
#define IKeyHolderPlugin_useOnlyOwnKeys(self, status) ((self)->vtable->useOnlyOwnKeys(self, (status)))
#define IKeyHolderPlugin_chainHandle(self, status) ((self)->vtable->chainHandle(self, (status)))

#define IDbCryptInfo_VERSION 3

struct IDbCryptInfo;

struct IDbCryptInfoVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IDbCryptInfo* self);
	int (*release)(struct IDbCryptInfo* self);
	const char* (*getDatabaseFullPath)(struct IDbCryptInfo* self, struct IStatus* status);
};

struct IDbCryptInfo
{
	void* cloopDummy[1];
	struct IDbCryptInfoVTable* vtable;
};

#define IDbCryptInfo_addRef(self) (self)->vtable->addRef(self)
#define IDbCryptInfo_release(self) ((self)->vtable->release(self))
#define IDbCryptInfo_getDatabaseFullPath(self, status) ((self)->vtable->getDatabaseFullPath(self, (status)))

#define IDbCryptPlugin_VERSION 5

struct IDbCryptPlugin;

struct IDbCryptPluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IDbCryptPlugin* self);
	int (*release)(struct IDbCryptPlugin* self);
	void (*setOwner)(struct IDbCryptPlugin* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IDbCryptPlugin* self);
	void (*setKey)(struct IDbCryptPlugin* self, struct IStatus* status, unsigned length, struct IKeyHolderPlugin** sources, const char* keyName);
	void (*encrypt)(struct IDbCryptPlugin* self, struct IStatus* status, unsigned length, const void* from, void* to);
	void (*decrypt)(struct IDbCryptPlugin* self, struct IStatus* status, unsigned length, const void* from, void* to);
	void (*setInfo)(struct IDbCryptPlugin* self, struct IStatus* status, struct IDbCryptInfo* info);
};

struct IDbCryptPlugin
{
	void* cloopDummy[1];
	struct IDbCryptPluginVTable* vtable;
};

#define IDbCryptPlugin_addRef(self) (self)->vtable->addRef(self)
#define IDbCryptPlugin_release(self) ((self)->vtable->release(self))
#define IDbCryptPlugin_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IDbCryptPlugin_getOwner(self) ((self)->vtable->getOwner(self))
#define IDbCryptPlugin_setKey(self, status, length, sources, keyName) (self)->vtable->setKey(self, (status), (length), (sources), (keyName))
#define IDbCryptPlugin_encrypt(self, status, length, from, to) (self)->vtable->encrypt(self, (status), (length), (from), (to))
#define IDbCryptPlugin_decrypt(self, status, length, from, to) (self)->vtable->decrypt(self, (status), (length), (from), (to))
#define IDbCryptPlugin_setInfo(self, status, info) (self)->vtable->setInfo(self, (status), (info))

#define IExternalContext_VERSION 2

struct IExternalContext;

struct IExternalContextVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	struct IMaster* (*getMaster)(struct IExternalContext* self);
	struct IExternalEngine* (*getEngine)(struct IExternalContext* self, struct IStatus* status);
	struct IAttachment* (*getAttachment)(struct IExternalContext* self, struct IStatus* status);
	struct ITransaction* (*getTransaction)(struct IExternalContext* self, struct IStatus* status);
	const char* (*getUserName)(struct IExternalContext* self);
	const char* (*getDatabaseName)(struct IExternalContext* self);
	const char* (*getClientCharSet)(struct IExternalContext* self);
	int (*obtainInfoCode)(struct IExternalContext* self);
	void* (*getInfo)(struct IExternalContext* self, int code);
	void* (*setInfo)(struct IExternalContext* self, int code, void* value);
};

struct IExternalContext
{
	void* cloopDummy[1];
	struct IExternalContextVTable* vtable;
};

#define IExternalContext_getMaster(self) ((self)->vtable->getMaster(self))
#define IExternalContext_getEngine(self, status) ((self)->vtable->getEngine(self, (status)))
#define IExternalContext_getAttachment(self, status) ((self)->vtable->getAttachment(self, (status)))
#define IExternalContext_getTransaction(self, status) ((self)->vtable->getTransaction(self, (status)))
#define IExternalContext_getUserName(self) ((self)->vtable->getUserName(self))
#define IExternalContext_getDatabaseName(self) ((self)->vtable->getDatabaseName(self))
#define IExternalContext_getClientCharSet(self) ((self)->vtable->getClientCharSet(self))
#define IExternalContext_obtainInfoCode(self) ((self)->vtable->obtainInfoCode(self))
#define IExternalContext_getInfo(self, code) (self)->vtable->getInfo(self, (code))
#define IExternalContext_setInfo(self, code, value) (self)->vtable->setInfo(self, (code), (value))

#define IExternalResultSet_VERSION 3

struct IExternalResultSet;

struct IExternalResultSetVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IExternalResultSet* self);
	FB_BOOLEAN (*fetch)(struct IExternalResultSet* self, struct IStatus* status);
};

struct IExternalResultSet
{
	void* cloopDummy[1];
	struct IExternalResultSetVTable* vtable;
};

#define IExternalResultSet_dispose(self) (self)->vtable->dispose(self)
#define IExternalResultSet_fetch(self, status) ((self)->vtable->fetch(self, (status)))

#define IExternalFunction_VERSION 3

struct IExternalFunction;

struct IExternalFunctionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IExternalFunction* self);
	void (*getCharSet)(struct IExternalFunction* self, struct IStatus* status, struct IExternalContext* context, char* name, unsigned nameSize);
	void (*execute)(struct IExternalFunction* self, struct IStatus* status, struct IExternalContext* context, void* inMsg, void* outMsg);
};

struct IExternalFunction
{
	void* cloopDummy[1];
	struct IExternalFunctionVTable* vtable;
};

#define IExternalFunction_dispose(self) (self)->vtable->dispose(self)
#define IExternalFunction_getCharSet(self, status, context, name, nameSize) (self)->vtable->getCharSet(self, (status), (context), (name), (nameSize))
#define IExternalFunction_execute(self, status, context, inMsg, outMsg) (self)->vtable->execute(self, (status), (context), (inMsg), (outMsg))

#define IExternalProcedure_VERSION 3

struct IExternalProcedure;

struct IExternalProcedureVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IExternalProcedure* self);
	void (*getCharSet)(struct IExternalProcedure* self, struct IStatus* status, struct IExternalContext* context, char* name, unsigned nameSize);
	struct IExternalResultSet* (*open)(struct IExternalProcedure* self, struct IStatus* status, struct IExternalContext* context, void* inMsg, void* outMsg);
};

struct IExternalProcedure
{
	void* cloopDummy[1];
	struct IExternalProcedureVTable* vtable;
};

#define IExternalProcedure_dispose(self) (self)->vtable->dispose(self)
#define IExternalProcedure_getCharSet(self, status, context, name, nameSize) (self)->vtable->getCharSet(self, (status), (context), (name), (nameSize))
#define IExternalProcedure_open(self, status, context, inMsg, outMsg) ((self)->vtable->open(self, (status), (context), (inMsg), (outMsg)))

#define IExternalTrigger_VERSION 3

#define IExternalTrigger_TYPE_BEFORE ((unsigned) (1))
#define IExternalTrigger_TYPE_AFTER ((unsigned) (2))
#define IExternalTrigger_TYPE_DATABASE ((unsigned) (3))
#define IExternalTrigger_ACTION_INSERT ((unsigned) (1))
#define IExternalTrigger_ACTION_UPDATE ((unsigned) (2))
#define IExternalTrigger_ACTION_DELETE ((unsigned) (3))
#define IExternalTrigger_ACTION_CONNECT ((unsigned) (4))
#define IExternalTrigger_ACTION_DISCONNECT ((unsigned) (5))
#define IExternalTrigger_ACTION_TRANS_START ((unsigned) (6))
#define IExternalTrigger_ACTION_TRANS_COMMIT ((unsigned) (7))
#define IExternalTrigger_ACTION_TRANS_ROLLBACK ((unsigned) (8))
#define IExternalTrigger_ACTION_DDL ((unsigned) (9))

struct IExternalTrigger;

struct IExternalTriggerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IExternalTrigger* self);
	void (*getCharSet)(struct IExternalTrigger* self, struct IStatus* status, struct IExternalContext* context, char* name, unsigned nameSize);
	void (*execute)(struct IExternalTrigger* self, struct IStatus* status, struct IExternalContext* context, unsigned action, void* oldMsg, void* newMsg);
};

struct IExternalTrigger
{
	void* cloopDummy[1];
	struct IExternalTriggerVTable* vtable;
};

#define IExternalTrigger_dispose(self) (self)->vtable->dispose(self)
#define IExternalTrigger_getCharSet(self, status, context, name, nameSize) (self)->vtable->getCharSet(self, (status), (context), (name), (nameSize))
#define IExternalTrigger_execute(self, status, context, action, oldMsg, newMsg) (self)->vtable->execute(self, (status), (context), (action), (oldMsg), (newMsg))

#define IRoutineMetadata_VERSION 2

struct IRoutineMetadata;

struct IRoutineMetadataVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getPackage)(const struct IRoutineMetadata* self, struct IStatus* status);
	const char* (*getName)(const struct IRoutineMetadata* self, struct IStatus* status);
	const char* (*getEntryPoint)(const struct IRoutineMetadata* self, struct IStatus* status);
	const char* (*getBody)(const struct IRoutineMetadata* self, struct IStatus* status);
	struct IMessageMetadata* (*getInputMetadata)(const struct IRoutineMetadata* self, struct IStatus* status);
	struct IMessageMetadata* (*getOutputMetadata)(const struct IRoutineMetadata* self, struct IStatus* status);
	struct IMessageMetadata* (*getTriggerMetadata)(const struct IRoutineMetadata* self, struct IStatus* status);
	const char* (*getTriggerTable)(const struct IRoutineMetadata* self, struct IStatus* status);
	unsigned (*getTriggerType)(const struct IRoutineMetadata* self, struct IStatus* status);
};

struct IRoutineMetadata
{
	void* cloopDummy[1];
	struct IRoutineMetadataVTable* vtable;
};

#define IRoutineMetadata_getPackage(self, status) ((self)->vtable->getPackage(self, (status)))
#define IRoutineMetadata_getName(self, status) ((self)->vtable->getName(self, (status)))
#define IRoutineMetadata_getEntryPoint(self, status) ((self)->vtable->getEntryPoint(self, (status)))
#define IRoutineMetadata_getBody(self, status) ((self)->vtable->getBody(self, (status)))
#define IRoutineMetadata_getInputMetadata(self, status) ((self)->vtable->getInputMetadata(self, (status)))
#define IRoutineMetadata_getOutputMetadata(self, status) ((self)->vtable->getOutputMetadata(self, (status)))
#define IRoutineMetadata_getTriggerMetadata(self, status) ((self)->vtable->getTriggerMetadata(self, (status)))
#define IRoutineMetadata_getTriggerTable(self, status) ((self)->vtable->getTriggerTable(self, (status)))
#define IRoutineMetadata_getTriggerType(self, status) ((self)->vtable->getTriggerType(self, (status)))

#define IExternalEngine_VERSION 4

struct IExternalEngine;

struct IExternalEngineVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IExternalEngine* self);
	int (*release)(struct IExternalEngine* self);
	void (*setOwner)(struct IExternalEngine* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IExternalEngine* self);
	void (*open)(struct IExternalEngine* self, struct IStatus* status, struct IExternalContext* context, char* charSet, unsigned charSetSize);
	void (*openAttachment)(struct IExternalEngine* self, struct IStatus* status, struct IExternalContext* context);
	void (*closeAttachment)(struct IExternalEngine* self, struct IStatus* status, struct IExternalContext* context);
	struct IExternalFunction* (*makeFunction)(struct IExternalEngine* self, struct IStatus* status, struct IExternalContext* context, struct IRoutineMetadata* metadata, struct IMetadataBuilder* inBuilder, struct IMetadataBuilder* outBuilder);
	struct IExternalProcedure* (*makeProcedure)(struct IExternalEngine* self, struct IStatus* status, struct IExternalContext* context, struct IRoutineMetadata* metadata, struct IMetadataBuilder* inBuilder, struct IMetadataBuilder* outBuilder);
	struct IExternalTrigger* (*makeTrigger)(struct IExternalEngine* self, struct IStatus* status, struct IExternalContext* context, struct IRoutineMetadata* metadata, struct IMetadataBuilder* fieldsBuilder);
};

struct IExternalEngine
{
	void* cloopDummy[1];
	struct IExternalEngineVTable* vtable;
};

#define IExternalEngine_addRef(self) (self)->vtable->addRef(self)
#define IExternalEngine_release(self) ((self)->vtable->release(self))
#define IExternalEngine_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IExternalEngine_getOwner(self) ((self)->vtable->getOwner(self))
#define IExternalEngine_open(self, status, context, charSet, charSetSize) (self)->vtable->open(self, (status), (context), (charSet), (charSetSize))
#define IExternalEngine_openAttachment(self, status, context) (self)->vtable->openAttachment(self, (status), (context))
#define IExternalEngine_closeAttachment(self, status, context) (self)->vtable->closeAttachment(self, (status), (context))
#define IExternalEngine_makeFunction(self, status, context, metadata, inBuilder, outBuilder) ((self)->vtable->makeFunction(self, (status), (context), (metadata), (inBuilder), (outBuilder)))
#define IExternalEngine_makeProcedure(self, status, context, metadata, inBuilder, outBuilder) ((self)->vtable->makeProcedure(self, (status), (context), (metadata), (inBuilder), (outBuilder)))
#define IExternalEngine_makeTrigger(self, status, context, metadata, fieldsBuilder) ((self)->vtable->makeTrigger(self, (status), (context), (metadata), (fieldsBuilder)))

#define ITimer_VERSION 3

struct ITimer;

struct ITimerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct ITimer* self);
	int (*release)(struct ITimer* self);
	void (*handler)(struct ITimer* self);
};

struct ITimer
{
	void* cloopDummy[1];
	struct ITimerVTable* vtable;
};

#define ITimer_addRef(self) (self)->vtable->addRef(self)
#define ITimer_release(self) ((self)->vtable->release(self))
#define ITimer_handler(self) (self)->vtable->handler(self)

#define ITimerControl_VERSION 2

struct ITimerControl;

struct ITimerControlVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*start)(struct ITimerControl* self, struct IStatus* status, struct ITimer* timer, ISC_UINT64 microSeconds);
	void (*stop)(struct ITimerControl* self, struct IStatus* status, struct ITimer* timer);
};

struct ITimerControl
{
	void* cloopDummy[1];
	struct ITimerControlVTable* vtable;
};

#define ITimerControl_start(self, status, timer, microSeconds) (self)->vtable->start(self, (status), (timer), (microSeconds))
#define ITimerControl_stop(self, status, timer) (self)->vtable->stop(self, (status), (timer))

#define IVersionCallback_VERSION 2

struct IVersionCallback;

struct IVersionCallbackVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*callback)(struct IVersionCallback* self, struct IStatus* status, const char* text);
};

struct IVersionCallback
{
	void* cloopDummy[1];
	struct IVersionCallbackVTable* vtable;
};

#define IVersionCallback_callback(self, status, text) (self)->vtable->callback(self, (status), (text))

#define IUtil_VERSION 4

struct IUtil;

struct IUtilVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*getFbVersion)(struct IUtil* self, struct IStatus* status, struct IAttachment* att, struct IVersionCallback* callback);
	void (*loadBlob)(struct IUtil* self, struct IStatus* status, ISC_QUAD* blobId, struct IAttachment* att, struct ITransaction* tra, const char* file, FB_BOOLEAN txt);
	void (*dumpBlob)(struct IUtil* self, struct IStatus* status, ISC_QUAD* blobId, struct IAttachment* att, struct ITransaction* tra, const char* file, FB_BOOLEAN txt);
	void (*getPerfCounters)(struct IUtil* self, struct IStatus* status, struct IAttachment* att, const char* countersSet, ISC_INT64* counters);
	struct IAttachment* (*executeCreateDatabase)(struct IUtil* self, struct IStatus* status, unsigned stmtLength, const char* creatDBstatement, unsigned dialect, FB_BOOLEAN* stmtIsCreateDb);
	void (*decodeDate)(struct IUtil* self, ISC_DATE date, unsigned* year, unsigned* month, unsigned* day);
	void (*decodeTime)(struct IUtil* self, ISC_TIME time, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions);
	ISC_DATE (*encodeDate)(struct IUtil* self, unsigned year, unsigned month, unsigned day);
	ISC_TIME (*encodeTime)(struct IUtil* self, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions);
	unsigned (*formatStatus)(struct IUtil* self, char* buffer, unsigned bufferSize, struct IStatus* status);
	unsigned (*getClientVersion)(struct IUtil* self);
	struct IXpbBuilder* (*getXpbBuilder)(struct IUtil* self, struct IStatus* status, unsigned kind, const unsigned char* buf, unsigned len);
	unsigned (*setOffsets)(struct IUtil* self, struct IStatus* status, struct IMessageMetadata* metadata, struct IOffsetsCallback* callback);
	struct IDecFloat16* (*getDecFloat16)(struct IUtil* self, struct IStatus* status);
	struct IDecFloat34* (*getDecFloat34)(struct IUtil* self, struct IStatus* status);
	void (*decodeTimeTz)(struct IUtil* self, struct IStatus* status, const ISC_TIME_TZ* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
	void (*decodeTimeStampTz)(struct IUtil* self, struct IStatus* status, const ISC_TIMESTAMP_TZ* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
	void (*encodeTimeTz)(struct IUtil* self, struct IStatus* status, ISC_TIME_TZ* timeTz, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone);
	void (*encodeTimeStampTz)(struct IUtil* self, struct IStatus* status, ISC_TIMESTAMP_TZ* timeStampTz, unsigned year, unsigned month, unsigned day, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone);
	struct IInt128* (*getInt128)(struct IUtil* self, struct IStatus* status);
	void (*decodeTimeTzEx)(struct IUtil* self, struct IStatus* status, const ISC_TIME_TZ_EX* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
	void (*decodeTimeStampTzEx)(struct IUtil* self, struct IStatus* status, const ISC_TIMESTAMP_TZ_EX* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer);
};

struct IUtil
{
	void* cloopDummy[1];
	struct IUtilVTable* vtable;
};

#define IUtil_getFbVersion(self, status, att, callback) (self)->vtable->getFbVersion(self, (status), (att), (callback))
#define IUtil_loadBlob(self, status, blobId, att, tra, file, txt) (self)->vtable->loadBlob(self, (status), (blobId), (att), (tra), (file), (txt))
#define IUtil_dumpBlob(self, status, blobId, att, tra, file, txt) (self)->vtable->dumpBlob(self, (status), (blobId), (att), (tra), (file), (txt))
#define IUtil_getPerfCounters(self, status, att, countersSet, counters) (self)->vtable->getPerfCounters(self, (status), (att), (countersSet), (counters))
#define IUtil_executeCreateDatabase(self, status, stmtLength, creatDBstatement, dialect, stmtIsCreateDb) ((self)->vtable->executeCreateDatabase(self, (status), (stmtLength), (creatDBstatement), (dialect), (stmtIsCreateDb)))
#define IUtil_decodeDate(self, date, year, month, day) (self)->vtable->decodeDate(self, (date), (year), (month), (day))
#define IUtil_decodeTime(self, time, hours, minutes, seconds, fractions) (self)->vtable->decodeTime(self, (time), (hours), (minutes), (seconds), (fractions))
#define IUtil_encodeDate(self, year, month, day) ((self)->vtable->encodeDate(self, (year), (month), (day)))
#define IUtil_encodeTime(self, hours, minutes, seconds, fractions) ((self)->vtable->encodeTime(self, (hours), (minutes), (seconds), (fractions)))
#define IUtil_formatStatus(self, buffer, bufferSize, status) ((self)->vtable->formatStatus(self, (buffer), (bufferSize), (status)))
#define IUtil_getClientVersion(self) ((self)->vtable->getClientVersion(self))
#define IUtil_getXpbBuilder(self, status, kind, buf, len) ((self)->vtable->getXpbBuilder(self, (status), (kind), (buf), (len)))
#define IUtil_setOffsets(self, status, metadata, callback) ((self)->vtable->setOffsets(self, (status), (metadata), (callback)))
#define IUtil_getDecFloat16(self, status) ((self)->vtable->getDecFloat16(self, (status)))
#define IUtil_getDecFloat34(self, status) ((self)->vtable->getDecFloat34(self, (status)))
#define IUtil_decodeTimeTz(self, status, timeTz, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer) (self)->vtable->decodeTimeTz(self, (status), (timeTz), (hours), (minutes), (seconds), (fractions), (timeZoneBufferLength), (timeZoneBuffer))
#define IUtil_decodeTimeStampTz(self, status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer) (self)->vtable->decodeTimeStampTz(self, (status), (timeStampTz), (year), (month), (day), (hours), (minutes), (seconds), (fractions), (timeZoneBufferLength), (timeZoneBuffer))
#define IUtil_encodeTimeTz(self, status, timeTz, hours, minutes, seconds, fractions, timeZone) (self)->vtable->encodeTimeTz(self, (status), (timeTz), (hours), (minutes), (seconds), (fractions), (timeZone))
#define IUtil_encodeTimeStampTz(self, status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZone) (self)->vtable->encodeTimeStampTz(self, (status), (timeStampTz), (year), (month), (day), (hours), (minutes), (seconds), (fractions), (timeZone))
#define IUtil_getInt128(self, status) ((self)->vtable->getInt128(self, (status)))
#define IUtil_decodeTimeTzEx(self, status, timeTz, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer) (self)->vtable->decodeTimeTzEx(self, (status), (timeTz), (hours), (minutes), (seconds), (fractions), (timeZoneBufferLength), (timeZoneBuffer))
#define IUtil_decodeTimeStampTzEx(self, status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer) (self)->vtable->decodeTimeStampTzEx(self, (status), (timeStampTz), (year), (month), (day), (hours), (minutes), (seconds), (fractions), (timeZoneBufferLength), (timeZoneBuffer))

#define IOffsetsCallback_VERSION 2

struct IOffsetsCallback;

struct IOffsetsCallbackVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*setOffset)(struct IOffsetsCallback* self, struct IStatus* status, unsigned index, unsigned offset, unsigned nullOffset);
};

struct IOffsetsCallback
{
	void* cloopDummy[1];
	struct IOffsetsCallbackVTable* vtable;
};

#define IOffsetsCallback_setOffset(self, status, index, offset, nullOffset) (self)->vtable->setOffset(self, (status), (index), (offset), (nullOffset))

#define IXpbBuilder_VERSION 3

#define IXpbBuilder_DPB ((unsigned) (1))
#define IXpbBuilder_SPB_ATTACH ((unsigned) (2))
#define IXpbBuilder_SPB_START ((unsigned) (3))
#define IXpbBuilder_TPB ((unsigned) (4))
#define IXpbBuilder_BATCH ((unsigned) (5))
#define IXpbBuilder_BPB ((unsigned) (6))
#define IXpbBuilder_SPB_SEND ((unsigned) (7))
#define IXpbBuilder_SPB_RECEIVE ((unsigned) (8))
#define IXpbBuilder_SPB_RESPONSE ((unsigned) (9))
#define IXpbBuilder_INFO_SEND ((unsigned) (10))
#define IXpbBuilder_INFO_RESPONSE ((unsigned) (11))

struct IXpbBuilder;

struct IXpbBuilderVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IXpbBuilder* self);
	void (*clear)(struct IXpbBuilder* self, struct IStatus* status);
	void (*removeCurrent)(struct IXpbBuilder* self, struct IStatus* status);
	void (*insertInt)(struct IXpbBuilder* self, struct IStatus* status, unsigned char tag, int value);
	void (*insertBigInt)(struct IXpbBuilder* self, struct IStatus* status, unsigned char tag, ISC_INT64 value);
	void (*insertBytes)(struct IXpbBuilder* self, struct IStatus* status, unsigned char tag, const void* bytes, unsigned length);
	void (*insertString)(struct IXpbBuilder* self, struct IStatus* status, unsigned char tag, const char* str);
	void (*insertTag)(struct IXpbBuilder* self, struct IStatus* status, unsigned char tag);
	FB_BOOLEAN (*isEof)(struct IXpbBuilder* self, struct IStatus* status);
	void (*moveNext)(struct IXpbBuilder* self, struct IStatus* status);
	void (*rewind)(struct IXpbBuilder* self, struct IStatus* status);
	FB_BOOLEAN (*findFirst)(struct IXpbBuilder* self, struct IStatus* status, unsigned char tag);
	FB_BOOLEAN (*findNext)(struct IXpbBuilder* self, struct IStatus* status);
	unsigned char (*getTag)(struct IXpbBuilder* self, struct IStatus* status);
	unsigned (*getLength)(struct IXpbBuilder* self, struct IStatus* status);
	int (*getInt)(struct IXpbBuilder* self, struct IStatus* status);
	ISC_INT64 (*getBigInt)(struct IXpbBuilder* self, struct IStatus* status);
	const char* (*getString)(struct IXpbBuilder* self, struct IStatus* status);
	const unsigned char* (*getBytes)(struct IXpbBuilder* self, struct IStatus* status);
	unsigned (*getBufferLength)(struct IXpbBuilder* self, struct IStatus* status);
	const unsigned char* (*getBuffer)(struct IXpbBuilder* self, struct IStatus* status);
};

struct IXpbBuilder
{
	void* cloopDummy[1];
	struct IXpbBuilderVTable* vtable;
};

#define IXpbBuilder_dispose(self) (self)->vtable->dispose(self)
#define IXpbBuilder_clear(self, status) (self)->vtable->clear(self, (status))
#define IXpbBuilder_removeCurrent(self, status) (self)->vtable->removeCurrent(self, (status))
#define IXpbBuilder_insertInt(self, status, tag, value) (self)->vtable->insertInt(self, (status), (tag), (value))
#define IXpbBuilder_insertBigInt(self, status, tag, value) (self)->vtable->insertBigInt(self, (status), (tag), (value))
#define IXpbBuilder_insertBytes(self, status, tag, bytes, length) (self)->vtable->insertBytes(self, (status), (tag), (bytes), (length))
#define IXpbBuilder_insertString(self, status, tag, str) (self)->vtable->insertString(self, (status), (tag), (str))
#define IXpbBuilder_insertTag(self, status, tag) (self)->vtable->insertTag(self, (status), (tag))
#define IXpbBuilder_isEof(self, status) ((self)->vtable->isEof(self, (status)))
#define IXpbBuilder_moveNext(self, status) (self)->vtable->moveNext(self, (status))
#define IXpbBuilder_rewind(self, status) (self)->vtable->rewind(self, (status))
#define IXpbBuilder_findFirst(self, status, tag) ((self)->vtable->findFirst(self, (status), (tag)))
#define IXpbBuilder_findNext(self, status) ((self)->vtable->findNext(self, (status)))
#define IXpbBuilder_getTag(self, status) ((self)->vtable->getTag(self, (status)))
#define IXpbBuilder_getLength(self, status) ((self)->vtable->getLength(self, (status)))
#define IXpbBuilder_getInt(self, status) ((self)->vtable->getInt(self, (status)))
#define IXpbBuilder_getBigInt(self, status) ((self)->vtable->getBigInt(self, (status)))
#define IXpbBuilder_getString(self, status) ((self)->vtable->getString(self, (status)))
#define IXpbBuilder_getBytes(self, status) ((self)->vtable->getBytes(self, (status)))
#define IXpbBuilder_getBufferLength(self, status) ((self)->vtable->getBufferLength(self, (status)))
#define IXpbBuilder_getBuffer(self, status) ((self)->vtable->getBuffer(self, (status)))

#define ITraceConnection_VERSION 2

#define ITraceConnection_KIND_DATABASE ((unsigned) (1))
#define ITraceConnection_KIND_SERVICE ((unsigned) (2))

struct ITraceConnection;

struct ITraceConnectionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*getKind)(struct ITraceConnection* self);
	int (*getProcessID)(struct ITraceConnection* self);
	const char* (*getUserName)(struct ITraceConnection* self);
	const char* (*getRoleName)(struct ITraceConnection* self);
	const char* (*getCharSet)(struct ITraceConnection* self);
	const char* (*getRemoteProtocol)(struct ITraceConnection* self);
	const char* (*getRemoteAddress)(struct ITraceConnection* self);
	int (*getRemoteProcessID)(struct ITraceConnection* self);
	const char* (*getRemoteProcessName)(struct ITraceConnection* self);
};

struct ITraceConnection
{
	void* cloopDummy[1];
	struct ITraceConnectionVTable* vtable;
};

#define ITraceConnection_getKind(self) ((self)->vtable->getKind(self))
#define ITraceConnection_getProcessID(self) ((self)->vtable->getProcessID(self))
#define ITraceConnection_getUserName(self) ((self)->vtable->getUserName(self))
#define ITraceConnection_getRoleName(self) ((self)->vtable->getRoleName(self))
#define ITraceConnection_getCharSet(self) ((self)->vtable->getCharSet(self))
#define ITraceConnection_getRemoteProtocol(self) ((self)->vtable->getRemoteProtocol(self))
#define ITraceConnection_getRemoteAddress(self) ((self)->vtable->getRemoteAddress(self))
#define ITraceConnection_getRemoteProcessID(self) ((self)->vtable->getRemoteProcessID(self))
#define ITraceConnection_getRemoteProcessName(self) ((self)->vtable->getRemoteProcessName(self))

#define ITraceDatabaseConnection_VERSION 3

struct ITraceDatabaseConnection;

struct ITraceDatabaseConnectionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*getKind)(struct ITraceDatabaseConnection* self);
	int (*getProcessID)(struct ITraceDatabaseConnection* self);
	const char* (*getUserName)(struct ITraceDatabaseConnection* self);
	const char* (*getRoleName)(struct ITraceDatabaseConnection* self);
	const char* (*getCharSet)(struct ITraceDatabaseConnection* self);
	const char* (*getRemoteProtocol)(struct ITraceDatabaseConnection* self);
	const char* (*getRemoteAddress)(struct ITraceDatabaseConnection* self);
	int (*getRemoteProcessID)(struct ITraceDatabaseConnection* self);
	const char* (*getRemoteProcessName)(struct ITraceDatabaseConnection* self);
	ISC_INT64 (*getConnectionID)(struct ITraceDatabaseConnection* self);
	const char* (*getDatabaseName)(struct ITraceDatabaseConnection* self);
};

struct ITraceDatabaseConnection
{
	void* cloopDummy[1];
	struct ITraceDatabaseConnectionVTable* vtable;
};

#define ITraceDatabaseConnection_getKind(self) ((self)->vtable->getKind(self))
#define ITraceDatabaseConnection_getProcessID(self) ((self)->vtable->getProcessID(self))
#define ITraceDatabaseConnection_getUserName(self) ((self)->vtable->getUserName(self))
#define ITraceDatabaseConnection_getRoleName(self) ((self)->vtable->getRoleName(self))
#define ITraceDatabaseConnection_getCharSet(self) ((self)->vtable->getCharSet(self))
#define ITraceDatabaseConnection_getRemoteProtocol(self) ((self)->vtable->getRemoteProtocol(self))
#define ITraceDatabaseConnection_getRemoteAddress(self) ((self)->vtable->getRemoteAddress(self))
#define ITraceDatabaseConnection_getRemoteProcessID(self) ((self)->vtable->getRemoteProcessID(self))
#define ITraceDatabaseConnection_getRemoteProcessName(self) ((self)->vtable->getRemoteProcessName(self))
#define ITraceDatabaseConnection_getConnectionID(self) ((self)->vtable->getConnectionID(self))
#define ITraceDatabaseConnection_getDatabaseName(self) ((self)->vtable->getDatabaseName(self))

#define ITraceTransaction_VERSION 3

#define ITraceTransaction_ISOLATION_CONSISTENCY ((unsigned) (1))
#define ITraceTransaction_ISOLATION_CONCURRENCY ((unsigned) (2))
#define ITraceTransaction_ISOLATION_READ_COMMITTED_RECVER ((unsigned) (3))
#define ITraceTransaction_ISOLATION_READ_COMMITTED_NORECVER ((unsigned) (4))
#define ITraceTransaction_ISOLATION_READ_COMMITTED_READ_CONSISTENCY ((unsigned) (5))

struct ITraceTransaction;

struct ITraceTransactionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_INT64 (*getTransactionID)(struct ITraceTransaction* self);
	FB_BOOLEAN (*getReadOnly)(struct ITraceTransaction* self);
	int (*getWait)(struct ITraceTransaction* self);
	unsigned (*getIsolation)(struct ITraceTransaction* self);
	struct PerformanceInfo* (*getPerf)(struct ITraceTransaction* self);
	ISC_INT64 (*getInitialID)(struct ITraceTransaction* self);
	ISC_INT64 (*getPreviousID)(struct ITraceTransaction* self);
};

struct ITraceTransaction
{
	void* cloopDummy[1];
	struct ITraceTransactionVTable* vtable;
};

#define ITraceTransaction_getTransactionID(self) ((self)->vtable->getTransactionID(self))
#define ITraceTransaction_getReadOnly(self) ((self)->vtable->getReadOnly(self))
#define ITraceTransaction_getWait(self) ((self)->vtable->getWait(self))
#define ITraceTransaction_getIsolation(self) ((self)->vtable->getIsolation(self))
#define ITraceTransaction_getPerf(self) ((self)->vtable->getPerf(self))
#define ITraceTransaction_getInitialID(self) ((self)->vtable->getInitialID(self))
#define ITraceTransaction_getPreviousID(self) ((self)->vtable->getPreviousID(self))

#define ITraceParams_VERSION 3

struct ITraceParams;

struct ITraceParamsVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*getCount)(struct ITraceParams* self);
	const struct dsc* (*getParam)(struct ITraceParams* self, unsigned idx);
	const char* (*getTextUTF8)(struct ITraceParams* self, struct IStatus* status, unsigned idx);
};

struct ITraceParams
{
	void* cloopDummy[1];
	struct ITraceParamsVTable* vtable;
};

#define ITraceParams_getCount(self) ((self)->vtable->getCount(self))
#define ITraceParams_getParam(self, idx) ((self)->vtable->getParam(self, (idx)))
#define ITraceParams_getTextUTF8(self, status, idx) ((self)->vtable->getTextUTF8(self, (status), (idx)))

#define ITraceStatement_VERSION 2

struct ITraceStatement;

struct ITraceStatementVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_INT64 (*getStmtID)(struct ITraceStatement* self);
	struct PerformanceInfo* (*getPerf)(struct ITraceStatement* self);
};

struct ITraceStatement
{
	void* cloopDummy[1];
	struct ITraceStatementVTable* vtable;
};

#define ITraceStatement_getStmtID(self) ((self)->vtable->getStmtID(self))
#define ITraceStatement_getPerf(self) ((self)->vtable->getPerf(self))

#define ITraceSQLStatement_VERSION 3

struct ITraceSQLStatement;

struct ITraceSQLStatementVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_INT64 (*getStmtID)(struct ITraceSQLStatement* self);
	struct PerformanceInfo* (*getPerf)(struct ITraceSQLStatement* self);
	const char* (*getText)(struct ITraceSQLStatement* self);
	const char* (*getPlan)(struct ITraceSQLStatement* self);
	struct ITraceParams* (*getInputs)(struct ITraceSQLStatement* self);
	const char* (*getTextUTF8)(struct ITraceSQLStatement* self);
	const char* (*getExplainedPlan)(struct ITraceSQLStatement* self);
};

struct ITraceSQLStatement
{
	void* cloopDummy[1];
	struct ITraceSQLStatementVTable* vtable;
};

#define ITraceSQLStatement_getStmtID(self) ((self)->vtable->getStmtID(self))
#define ITraceSQLStatement_getPerf(self) ((self)->vtable->getPerf(self))
#define ITraceSQLStatement_getText(self) ((self)->vtable->getText(self))
#define ITraceSQLStatement_getPlan(self) ((self)->vtable->getPlan(self))
#define ITraceSQLStatement_getInputs(self) ((self)->vtable->getInputs(self))
#define ITraceSQLStatement_getTextUTF8(self) ((self)->vtable->getTextUTF8(self))
#define ITraceSQLStatement_getExplainedPlan(self) ((self)->vtable->getExplainedPlan(self))

#define ITraceBLRStatement_VERSION 3

struct ITraceBLRStatement;

struct ITraceBLRStatementVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_INT64 (*getStmtID)(struct ITraceBLRStatement* self);
	struct PerformanceInfo* (*getPerf)(struct ITraceBLRStatement* self);
	const unsigned char* (*getData)(struct ITraceBLRStatement* self);
	unsigned (*getDataLength)(struct ITraceBLRStatement* self);
	const char* (*getText)(struct ITraceBLRStatement* self);
};

struct ITraceBLRStatement
{
	void* cloopDummy[1];
	struct ITraceBLRStatementVTable* vtable;
};

#define ITraceBLRStatement_getStmtID(self) ((self)->vtable->getStmtID(self))
#define ITraceBLRStatement_getPerf(self) ((self)->vtable->getPerf(self))
#define ITraceBLRStatement_getData(self) ((self)->vtable->getData(self))
#define ITraceBLRStatement_getDataLength(self) ((self)->vtable->getDataLength(self))
#define ITraceBLRStatement_getText(self) ((self)->vtable->getText(self))

#define ITraceDYNRequest_VERSION 2

struct ITraceDYNRequest;

struct ITraceDYNRequestVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const unsigned char* (*getData)(struct ITraceDYNRequest* self);
	unsigned (*getDataLength)(struct ITraceDYNRequest* self);
	const char* (*getText)(struct ITraceDYNRequest* self);
};

struct ITraceDYNRequest
{
	void* cloopDummy[1];
	struct ITraceDYNRequestVTable* vtable;
};

#define ITraceDYNRequest_getData(self) ((self)->vtable->getData(self))
#define ITraceDYNRequest_getDataLength(self) ((self)->vtable->getDataLength(self))
#define ITraceDYNRequest_getText(self) ((self)->vtable->getText(self))

#define ITraceContextVariable_VERSION 2

struct ITraceContextVariable;

struct ITraceContextVariableVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getNameSpace)(struct ITraceContextVariable* self);
	const char* (*getVarName)(struct ITraceContextVariable* self);
	const char* (*getVarValue)(struct ITraceContextVariable* self);
};

struct ITraceContextVariable
{
	void* cloopDummy[1];
	struct ITraceContextVariableVTable* vtable;
};

#define ITraceContextVariable_getNameSpace(self) ((self)->vtable->getNameSpace(self))
#define ITraceContextVariable_getVarName(self) ((self)->vtable->getVarName(self))
#define ITraceContextVariable_getVarValue(self) ((self)->vtable->getVarValue(self))

#define ITraceProcedure_VERSION 3

struct ITraceProcedure;

struct ITraceProcedureVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getProcName)(struct ITraceProcedure* self);
	struct ITraceParams* (*getInputs)(struct ITraceProcedure* self);
	struct PerformanceInfo* (*getPerf)(struct ITraceProcedure* self);
	ISC_INT64 (*getStmtID)(struct ITraceProcedure* self);
	const char* (*getPlan)(struct ITraceProcedure* self);
	const char* (*getExplainedPlan)(struct ITraceProcedure* self);
};

struct ITraceProcedure
{
	void* cloopDummy[1];
	struct ITraceProcedureVTable* vtable;
};

#define ITraceProcedure_getProcName(self) ((self)->vtable->getProcName(self))
#define ITraceProcedure_getInputs(self) ((self)->vtable->getInputs(self))
#define ITraceProcedure_getPerf(self) ((self)->vtable->getPerf(self))
#define ITraceProcedure_getStmtID(self) ((self)->vtable->getStmtID(self))
#define ITraceProcedure_getPlan(self) ((self)->vtable->getPlan(self))
#define ITraceProcedure_getExplainedPlan(self) ((self)->vtable->getExplainedPlan(self))

#define ITraceFunction_VERSION 3

struct ITraceFunction;

struct ITraceFunctionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getFuncName)(struct ITraceFunction* self);
	struct ITraceParams* (*getInputs)(struct ITraceFunction* self);
	struct ITraceParams* (*getResult)(struct ITraceFunction* self);
	struct PerformanceInfo* (*getPerf)(struct ITraceFunction* self);
	ISC_INT64 (*getStmtID)(struct ITraceFunction* self);
	const char* (*getPlan)(struct ITraceFunction* self);
	const char* (*getExplainedPlan)(struct ITraceFunction* self);
};

struct ITraceFunction
{
	void* cloopDummy[1];
	struct ITraceFunctionVTable* vtable;
};

#define ITraceFunction_getFuncName(self) ((self)->vtable->getFuncName(self))
#define ITraceFunction_getInputs(self) ((self)->vtable->getInputs(self))
#define ITraceFunction_getResult(self) ((self)->vtable->getResult(self))
#define ITraceFunction_getPerf(self) ((self)->vtable->getPerf(self))
#define ITraceFunction_getStmtID(self) ((self)->vtable->getStmtID(self))
#define ITraceFunction_getPlan(self) ((self)->vtable->getPlan(self))
#define ITraceFunction_getExplainedPlan(self) ((self)->vtable->getExplainedPlan(self))

#define ITraceTrigger_VERSION 3

#define ITraceTrigger_TYPE_ALL ((unsigned) (0))
#define ITraceTrigger_TYPE_BEFORE ((unsigned) (1))
#define ITraceTrigger_TYPE_AFTER ((unsigned) (2))

struct ITraceTrigger;

struct ITraceTriggerVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getTriggerName)(struct ITraceTrigger* self);
	const char* (*getRelationName)(struct ITraceTrigger* self);
	int (*getAction)(struct ITraceTrigger* self);
	int (*getWhich)(struct ITraceTrigger* self);
	struct PerformanceInfo* (*getPerf)(struct ITraceTrigger* self);
	ISC_INT64 (*getStmtID)(struct ITraceTrigger* self);
	const char* (*getPlan)(struct ITraceTrigger* self);
	const char* (*getExplainedPlan)(struct ITraceTrigger* self);
};

struct ITraceTrigger
{
	void* cloopDummy[1];
	struct ITraceTriggerVTable* vtable;
};

#define ITraceTrigger_getTriggerName(self) ((self)->vtable->getTriggerName(self))
#define ITraceTrigger_getRelationName(self) ((self)->vtable->getRelationName(self))
#define ITraceTrigger_getAction(self) ((self)->vtable->getAction(self))
#define ITraceTrigger_getWhich(self) ((self)->vtable->getWhich(self))
#define ITraceTrigger_getPerf(self) ((self)->vtable->getPerf(self))
#define ITraceTrigger_getStmtID(self) ((self)->vtable->getStmtID(self))
#define ITraceTrigger_getPlan(self) ((self)->vtable->getPlan(self))
#define ITraceTrigger_getExplainedPlan(self) ((self)->vtable->getExplainedPlan(self))

#define ITraceServiceConnection_VERSION 3

struct ITraceServiceConnection;

struct ITraceServiceConnectionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*getKind)(struct ITraceServiceConnection* self);
	int (*getProcessID)(struct ITraceServiceConnection* self);
	const char* (*getUserName)(struct ITraceServiceConnection* self);
	const char* (*getRoleName)(struct ITraceServiceConnection* self);
	const char* (*getCharSet)(struct ITraceServiceConnection* self);
	const char* (*getRemoteProtocol)(struct ITraceServiceConnection* self);
	const char* (*getRemoteAddress)(struct ITraceServiceConnection* self);
	int (*getRemoteProcessID)(struct ITraceServiceConnection* self);
	const char* (*getRemoteProcessName)(struct ITraceServiceConnection* self);
	void* (*getServiceID)(struct ITraceServiceConnection* self);
	const char* (*getServiceMgr)(struct ITraceServiceConnection* self);
	const char* (*getServiceName)(struct ITraceServiceConnection* self);
};

struct ITraceServiceConnection
{
	void* cloopDummy[1];
	struct ITraceServiceConnectionVTable* vtable;
};

#define ITraceServiceConnection_getKind(self) ((self)->vtable->getKind(self))
#define ITraceServiceConnection_getProcessID(self) ((self)->vtable->getProcessID(self))
#define ITraceServiceConnection_getUserName(self) ((self)->vtable->getUserName(self))
#define ITraceServiceConnection_getRoleName(self) ((self)->vtable->getRoleName(self))
#define ITraceServiceConnection_getCharSet(self) ((self)->vtable->getCharSet(self))
#define ITraceServiceConnection_getRemoteProtocol(self) ((self)->vtable->getRemoteProtocol(self))
#define ITraceServiceConnection_getRemoteAddress(self) ((self)->vtable->getRemoteAddress(self))
#define ITraceServiceConnection_getRemoteProcessID(self) ((self)->vtable->getRemoteProcessID(self))
#define ITraceServiceConnection_getRemoteProcessName(self) ((self)->vtable->getRemoteProcessName(self))
#define ITraceServiceConnection_getServiceID(self) (self)->vtable->getServiceID(self)
#define ITraceServiceConnection_getServiceMgr(self) ((self)->vtable->getServiceMgr(self))
#define ITraceServiceConnection_getServiceName(self) ((self)->vtable->getServiceName(self))

#define ITraceStatusVector_VERSION 2

struct ITraceStatusVector;

struct ITraceStatusVectorVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	FB_BOOLEAN (*hasError)(struct ITraceStatusVector* self);
	FB_BOOLEAN (*hasWarning)(struct ITraceStatusVector* self);
	struct IStatus* (*getStatus)(struct ITraceStatusVector* self);
	const char* (*getText)(struct ITraceStatusVector* self);
};

struct ITraceStatusVector
{
	void* cloopDummy[1];
	struct ITraceStatusVectorVTable* vtable;
};

#define ITraceStatusVector_hasError(self) ((self)->vtable->hasError(self))
#define ITraceStatusVector_hasWarning(self) ((self)->vtable->hasWarning(self))
#define ITraceStatusVector_getStatus(self) ((self)->vtable->getStatus(self))
#define ITraceStatusVector_getText(self) ((self)->vtable->getText(self))

#define ITraceSweepInfo_VERSION 2

struct ITraceSweepInfo;

struct ITraceSweepInfoVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_INT64 (*getOIT)(struct ITraceSweepInfo* self);
	ISC_INT64 (*getOST)(struct ITraceSweepInfo* self);
	ISC_INT64 (*getOAT)(struct ITraceSweepInfo* self);
	ISC_INT64 (*getNext)(struct ITraceSweepInfo* self);
	struct PerformanceInfo* (*getPerf)(struct ITraceSweepInfo* self);
};

struct ITraceSweepInfo
{
	void* cloopDummy[1];
	struct ITraceSweepInfoVTable* vtable;
};

#define ITraceSweepInfo_getOIT(self) ((self)->vtable->getOIT(self))
#define ITraceSweepInfo_getOST(self) ((self)->vtable->getOST(self))
#define ITraceSweepInfo_getOAT(self) ((self)->vtable->getOAT(self))
#define ITraceSweepInfo_getNext(self) ((self)->vtable->getNext(self))
#define ITraceSweepInfo_getPerf(self) ((self)->vtable->getPerf(self))

#define ITraceLogWriter_VERSION 4

struct ITraceLogWriter;

struct ITraceLogWriterVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct ITraceLogWriter* self);
	int (*release)(struct ITraceLogWriter* self);
	unsigned (*write)(struct ITraceLogWriter* self, const void* buf, unsigned size);
	unsigned (*write_s)(struct ITraceLogWriter* self, struct IStatus* status, const void* buf, unsigned size);
};

struct ITraceLogWriter
{
	void* cloopDummy[1];
	struct ITraceLogWriterVTable* vtable;
};

#define ITraceLogWriter_addRef(self) (self)->vtable->addRef(self)
#define ITraceLogWriter_release(self) ((self)->vtable->release(self))
#define ITraceLogWriter_write(self, buf, size) ((self)->vtable->write(self, (buf), (size)))
#define ITraceLogWriter_write_s(self, status, buf, size) ((self)->vtable->write_s(self, (status), (buf), (size)))

#define ITraceInitInfo_VERSION 2

struct ITraceInitInfo;

struct ITraceInitInfoVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getConfigText)(struct ITraceInitInfo* self);
	int (*getTraceSessionID)(struct ITraceInitInfo* self);
	const char* (*getTraceSessionName)(struct ITraceInitInfo* self);
	const char* (*getFirebirdRootDirectory)(struct ITraceInitInfo* self);
	const char* (*getDatabaseName)(struct ITraceInitInfo* self);
	struct ITraceDatabaseConnection* (*getConnection)(struct ITraceInitInfo* self);
	struct ITraceLogWriter* (*getLogWriter)(struct ITraceInitInfo* self);
};

struct ITraceInitInfo
{
	void* cloopDummy[1];
	struct ITraceInitInfoVTable* vtable;
};

#define ITraceInitInfo_getConfigText(self) ((self)->vtable->getConfigText(self))
#define ITraceInitInfo_getTraceSessionID(self) ((self)->vtable->getTraceSessionID(self))
#define ITraceInitInfo_getTraceSessionName(self) ((self)->vtable->getTraceSessionName(self))
#define ITraceInitInfo_getFirebirdRootDirectory(self) ((self)->vtable->getFirebirdRootDirectory(self))
#define ITraceInitInfo_getDatabaseName(self) ((self)->vtable->getDatabaseName(self))
#define ITraceInitInfo_getConnection(self) ((self)->vtable->getConnection(self))
#define ITraceInitInfo_getLogWriter(self) ((self)->vtable->getLogWriter(self))

#define ITracePlugin_VERSION 5

#define ITracePlugin_RESULT_SUCCESS ((unsigned) (0))
#define ITracePlugin_RESULT_FAILED ((unsigned) (1))
#define ITracePlugin_RESULT_UNAUTHORIZED ((unsigned) (2))
#define ITracePlugin_SWEEP_STATE_STARTED ((unsigned) (1))
#define ITracePlugin_SWEEP_STATE_FINISHED ((unsigned) (2))
#define ITracePlugin_SWEEP_STATE_FAILED ((unsigned) (3))
#define ITracePlugin_SWEEP_STATE_PROGRESS ((unsigned) (4))

struct ITracePlugin;

struct ITracePluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct ITracePlugin* self);
	int (*release)(struct ITracePlugin* self);
	const char* (*trace_get_error)(struct ITracePlugin* self);
	FB_BOOLEAN (*trace_attach)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, FB_BOOLEAN create_db, unsigned att_result);
	FB_BOOLEAN (*trace_detach)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, FB_BOOLEAN drop_db);
	FB_BOOLEAN (*trace_transaction_start)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, unsigned tpb_length, const unsigned char* tpb, unsigned tra_result);
	FB_BOOLEAN (*trace_transaction_end)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, FB_BOOLEAN commit, FB_BOOLEAN retain_context, unsigned tra_result);
	FB_BOOLEAN (*trace_proc_execute)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, struct ITraceProcedure* procedure, FB_BOOLEAN started, unsigned proc_result);
	FB_BOOLEAN (*trace_trigger_execute)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, struct ITraceTrigger* trigger, FB_BOOLEAN started, unsigned trig_result);
	FB_BOOLEAN (*trace_set_context)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, struct ITraceContextVariable* variable);
	FB_BOOLEAN (*trace_dsql_prepare)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, struct ITraceSQLStatement* statement, ISC_INT64 time_millis, unsigned req_result);
	FB_BOOLEAN (*trace_dsql_free)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceSQLStatement* statement, unsigned option);
	FB_BOOLEAN (*trace_dsql_execute)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, struct ITraceSQLStatement* statement, FB_BOOLEAN started, unsigned req_result);
	FB_BOOLEAN (*trace_blr_compile)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, struct ITraceBLRStatement* statement, ISC_INT64 time_millis, unsigned req_result);
	FB_BOOLEAN (*trace_blr_execute)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, struct ITraceBLRStatement* statement, unsigned req_result);
	FB_BOOLEAN (*trace_dyn_execute)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, struct ITraceDYNRequest* request, ISC_INT64 time_millis, unsigned req_result);
	FB_BOOLEAN (*trace_service_attach)(struct ITracePlugin* self, struct ITraceServiceConnection* service, unsigned att_result);
	FB_BOOLEAN (*trace_service_start)(struct ITracePlugin* self, struct ITraceServiceConnection* service, unsigned switches_length, const char* switches, unsigned start_result);
	FB_BOOLEAN (*trace_service_query)(struct ITracePlugin* self, struct ITraceServiceConnection* service, unsigned send_item_length, const unsigned char* send_items, unsigned recv_item_length, const unsigned char* recv_items, unsigned query_result);
	FB_BOOLEAN (*trace_service_detach)(struct ITracePlugin* self, struct ITraceServiceConnection* service, unsigned detach_result);
	FB_BOOLEAN (*trace_event_error)(struct ITracePlugin* self, struct ITraceConnection* connection, struct ITraceStatusVector* status, const char* function);
	FB_BOOLEAN (*trace_event_sweep)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceSweepInfo* sweep, unsigned sweep_state);
	FB_BOOLEAN (*trace_func_execute)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, struct ITraceFunction* function, FB_BOOLEAN started, unsigned func_result);
	FB_BOOLEAN (*trace_dsql_restart)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTransaction* transaction, struct ITraceSQLStatement* statement, unsigned number);
	FB_BOOLEAN (*trace_proc_compile)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceProcedure* procedure, ISC_INT64 time_millis, unsigned proc_result);
	FB_BOOLEAN (*trace_func_compile)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceFunction* function, ISC_INT64 time_millis, unsigned func_result);
	FB_BOOLEAN (*trace_trigger_compile)(struct ITracePlugin* self, struct ITraceDatabaseConnection* connection, struct ITraceTrigger* trigger, ISC_INT64 time_millis, unsigned trig_result);
};

struct ITracePlugin
{
	void* cloopDummy[1];
	struct ITracePluginVTable* vtable;
};

#define ITracePlugin_addRef(self) (self)->vtable->addRef(self)
#define ITracePlugin_release(self) ((self)->vtable->release(self))
#define ITracePlugin_trace_get_error(self) ((self)->vtable->trace_get_error(self))
#define ITracePlugin_trace_attach(self, connection, create_db, att_result) ((self)->vtable->trace_attach(self, (connection), (create_db), (att_result)))
#define ITracePlugin_trace_detach(self, connection, drop_db) ((self)->vtable->trace_detach(self, (connection), (drop_db)))
#define ITracePlugin_trace_transaction_start(self, connection, transaction, tpb_length, tpb, tra_result) ((self)->vtable->trace_transaction_start(self, (connection), (transaction), (tpb_length), (tpb), (tra_result)))
#define ITracePlugin_trace_transaction_end(self, connection, transaction, commit, retain_context, tra_result) ((self)->vtable->trace_transaction_end(self, (connection), (transaction), (commit), (retain_context), (tra_result)))
#define ITracePlugin_trace_proc_execute(self, connection, transaction, procedure, started, proc_result) ((self)->vtable->trace_proc_execute(self, (connection), (transaction), (procedure), (started), (proc_result)))
#define ITracePlugin_trace_trigger_execute(self, connection, transaction, trigger, started, trig_result) ((self)->vtable->trace_trigger_execute(self, (connection), (transaction), (trigger), (started), (trig_result)))
#define ITracePlugin_trace_set_context(self, connection, transaction, variable) ((self)->vtable->trace_set_context(self, (connection), (transaction), (variable)))
#define ITracePlugin_trace_dsql_prepare(self, connection, transaction, statement, time_millis, req_result) ((self)->vtable->trace_dsql_prepare(self, (connection), (transaction), (statement), (time_millis), (req_result)))
#define ITracePlugin_trace_dsql_free(self, connection, statement, option) ((self)->vtable->trace_dsql_free(self, (connection), (statement), (option)))
#define ITracePlugin_trace_dsql_execute(self, connection, transaction, statement, started, req_result) ((self)->vtable->trace_dsql_execute(self, (connection), (transaction), (statement), (started), (req_result)))
#define ITracePlugin_trace_blr_compile(self, connection, transaction, statement, time_millis, req_result) ((self)->vtable->trace_blr_compile(self, (connection), (transaction), (statement), (time_millis), (req_result)))
#define ITracePlugin_trace_blr_execute(self, connection, transaction, statement, req_result) ((self)->vtable->trace_blr_execute(self, (connection), (transaction), (statement), (req_result)))
#define ITracePlugin_trace_dyn_execute(self, connection, transaction, request, time_millis, req_result) ((self)->vtable->trace_dyn_execute(self, (connection), (transaction), (request), (time_millis), (req_result)))
#define ITracePlugin_trace_service_attach(self, service, att_result) ((self)->vtable->trace_service_attach(self, (service), (att_result)))
#define ITracePlugin_trace_service_start(self, service, switches_length, switches, start_result) ((self)->vtable->trace_service_start(self, (service), (switches_length), (switches), (start_result)))
#define ITracePlugin_trace_service_query(self, service, send_item_length, send_items, recv_item_length, recv_items, query_result) ((self)->vtable->trace_service_query(self, (service), (send_item_length), (send_items), (recv_item_length), (recv_items), (query_result)))
#define ITracePlugin_trace_service_detach(self, service, detach_result) ((self)->vtable->trace_service_detach(self, (service), (detach_result)))
#define ITracePlugin_trace_event_error(self, connection, status, function) ((self)->vtable->trace_event_error(self, (connection), (status), (function)))
#define ITracePlugin_trace_event_sweep(self, connection, sweep, sweep_state) ((self)->vtable->trace_event_sweep(self, (connection), (sweep), (sweep_state)))
#define ITracePlugin_trace_func_execute(self, connection, transaction, function, started, func_result) ((self)->vtable->trace_func_execute(self, (connection), (transaction), (function), (started), (func_result)))
#define ITracePlugin_trace_dsql_restart(self, connection, transaction, statement, number) ((self)->vtable->trace_dsql_restart(self, (connection), (transaction), (statement), (number)))
#define ITracePlugin_trace_proc_compile(self, connection, procedure, time_millis, proc_result) ((self)->vtable->trace_proc_compile(self, (connection), (procedure), (time_millis), (proc_result)))
#define ITracePlugin_trace_func_compile(self, connection, function, time_millis, func_result) ((self)->vtable->trace_func_compile(self, (connection), (function), (time_millis), (func_result)))
#define ITracePlugin_trace_trigger_compile(self, connection, trigger, time_millis, trig_result) ((self)->vtable->trace_trigger_compile(self, (connection), (trigger), (time_millis), (trig_result)))

#define ITraceFactory_VERSION 4

#define ITraceFactory_TRACE_EVENT_ATTACH ((unsigned) (0))
#define ITraceFactory_TRACE_EVENT_DETACH ((unsigned) (1))
#define ITraceFactory_TRACE_EVENT_TRANSACTION_START ((unsigned) (2))
#define ITraceFactory_TRACE_EVENT_TRANSACTION_END ((unsigned) (3))
#define ITraceFactory_TRACE_EVENT_SET_CONTEXT ((unsigned) (4))
#define ITraceFactory_TRACE_EVENT_PROC_EXECUTE ((unsigned) (5))
#define ITraceFactory_TRACE_EVENT_TRIGGER_EXECUTE ((unsigned) (6))
#define ITraceFactory_TRACE_EVENT_DSQL_PREPARE ((unsigned) (7))
#define ITraceFactory_TRACE_EVENT_DSQL_FREE ((unsigned) (8))
#define ITraceFactory_TRACE_EVENT_DSQL_EXECUTE ((unsigned) (9))
#define ITraceFactory_TRACE_EVENT_BLR_COMPILE ((unsigned) (10))
#define ITraceFactory_TRACE_EVENT_BLR_EXECUTE ((unsigned) (11))
#define ITraceFactory_TRACE_EVENT_DYN_EXECUTE ((unsigned) (12))
#define ITraceFactory_TRACE_EVENT_SERVICE_ATTACH ((unsigned) (13))
#define ITraceFactory_TRACE_EVENT_SERVICE_START ((unsigned) (14))
#define ITraceFactory_TRACE_EVENT_SERVICE_QUERY ((unsigned) (15))
#define ITraceFactory_TRACE_EVENT_SERVICE_DETACH ((unsigned) (16))
#define ITraceFactory_TRACE_EVENT_ERROR ((unsigned) (17))
#define ITraceFactory_TRACE_EVENT_SWEEP ((unsigned) (18))
#define ITraceFactory_TRACE_EVENT_FUNC_EXECUTE ((unsigned) (19))
#define ITraceFactory_TRACE_EVENT_PROC_COMPILE ((unsigned) (20))
#define ITraceFactory_TRACE_EVENT_FUNC_COMPILE ((unsigned) (21))
#define ITraceFactory_TRACE_EVENT_TRIGGER_COMPILE ((unsigned) (22))
#define ITraceFactory_TRACE_EVENT_MAX ((unsigned) (23))

struct ITraceFactory;

struct ITraceFactoryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct ITraceFactory* self);
	int (*release)(struct ITraceFactory* self);
	void (*setOwner)(struct ITraceFactory* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct ITraceFactory* self);
	ISC_UINT64 (*trace_needs)(struct ITraceFactory* self);
	struct ITracePlugin* (*trace_create)(struct ITraceFactory* self, struct IStatus* status, struct ITraceInitInfo* init_info);
};

struct ITraceFactory
{
	void* cloopDummy[1];
	struct ITraceFactoryVTable* vtable;
};

#define ITraceFactory_addRef(self) (self)->vtable->addRef(self)
#define ITraceFactory_release(self) ((self)->vtable->release(self))
#define ITraceFactory_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define ITraceFactory_getOwner(self) ((self)->vtable->getOwner(self))
#define ITraceFactory_trace_needs(self) ((self)->vtable->trace_needs(self))
#define ITraceFactory_trace_create(self, status, init_info) ((self)->vtable->trace_create(self, (status), (init_info)))

#define IUdrFunctionFactory_VERSION 3

struct IUdrFunctionFactory;

struct IUdrFunctionFactoryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IUdrFunctionFactory* self);
	void (*setup)(struct IUdrFunctionFactory* self, struct IStatus* status, struct IExternalContext* context, struct IRoutineMetadata* metadata, struct IMetadataBuilder* inBuilder, struct IMetadataBuilder* outBuilder);
	struct IExternalFunction* (*newItem)(struct IUdrFunctionFactory* self, struct IStatus* status, struct IExternalContext* context, struct IRoutineMetadata* metadata);
};

struct IUdrFunctionFactory
{
	void* cloopDummy[1];
	struct IUdrFunctionFactoryVTable* vtable;
};

#define IUdrFunctionFactory_dispose(self) (self)->vtable->dispose(self)
#define IUdrFunctionFactory_setup(self, status, context, metadata, inBuilder, outBuilder) (self)->vtable->setup(self, (status), (context), (metadata), (inBuilder), (outBuilder))
#define IUdrFunctionFactory_newItem(self, status, context, metadata) ((self)->vtable->newItem(self, (status), (context), (metadata)))

#define IUdrProcedureFactory_VERSION 3

struct IUdrProcedureFactory;

struct IUdrProcedureFactoryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IUdrProcedureFactory* self);
	void (*setup)(struct IUdrProcedureFactory* self, struct IStatus* status, struct IExternalContext* context, struct IRoutineMetadata* metadata, struct IMetadataBuilder* inBuilder, struct IMetadataBuilder* outBuilder);
	struct IExternalProcedure* (*newItem)(struct IUdrProcedureFactory* self, struct IStatus* status, struct IExternalContext* context, struct IRoutineMetadata* metadata);
};

struct IUdrProcedureFactory
{
	void* cloopDummy[1];
	struct IUdrProcedureFactoryVTable* vtable;
};

#define IUdrProcedureFactory_dispose(self) (self)->vtable->dispose(self)
#define IUdrProcedureFactory_setup(self, status, context, metadata, inBuilder, outBuilder) (self)->vtable->setup(self, (status), (context), (metadata), (inBuilder), (outBuilder))
#define IUdrProcedureFactory_newItem(self, status, context, metadata) ((self)->vtable->newItem(self, (status), (context), (metadata)))

#define IUdrTriggerFactory_VERSION 3

struct IUdrTriggerFactory;

struct IUdrTriggerFactoryVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IUdrTriggerFactory* self);
	void (*setup)(struct IUdrTriggerFactory* self, struct IStatus* status, struct IExternalContext* context, struct IRoutineMetadata* metadata, struct IMetadataBuilder* fieldsBuilder);
	struct IExternalTrigger* (*newItem)(struct IUdrTriggerFactory* self, struct IStatus* status, struct IExternalContext* context, struct IRoutineMetadata* metadata);
};

struct IUdrTriggerFactory
{
	void* cloopDummy[1];
	struct IUdrTriggerFactoryVTable* vtable;
};

#define IUdrTriggerFactory_dispose(self) (self)->vtable->dispose(self)
#define IUdrTriggerFactory_setup(self, status, context, metadata, fieldsBuilder) (self)->vtable->setup(self, (status), (context), (metadata), (fieldsBuilder))
#define IUdrTriggerFactory_newItem(self, status, context, metadata) ((self)->vtable->newItem(self, (status), (context), (metadata)))

#define IUdrPlugin_VERSION 2

struct IUdrPlugin;

struct IUdrPluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	struct IMaster* (*getMaster)(struct IUdrPlugin* self);
	void (*registerFunction)(struct IUdrPlugin* self, struct IStatus* status, const char* name, struct IUdrFunctionFactory* factory);
	void (*registerProcedure)(struct IUdrPlugin* self, struct IStatus* status, const char* name, struct IUdrProcedureFactory* factory);
	void (*registerTrigger)(struct IUdrPlugin* self, struct IStatus* status, const char* name, struct IUdrTriggerFactory* factory);
};

struct IUdrPlugin
{
	void* cloopDummy[1];
	struct IUdrPluginVTable* vtable;
};

#define IUdrPlugin_getMaster(self) ((self)->vtable->getMaster(self))
#define IUdrPlugin_registerFunction(self, status, name, factory) (self)->vtable->registerFunction(self, (status), (name), (factory))
#define IUdrPlugin_registerProcedure(self, status, name, factory) (self)->vtable->registerProcedure(self, (status), (name), (factory))
#define IUdrPlugin_registerTrigger(self, status, name, factory) (self)->vtable->registerTrigger(self, (status), (name), (factory))

#define IDecFloat16_VERSION 2

#define IDecFloat16_BCD_SIZE ((unsigned) (16))
#define IDecFloat16_STRING_SIZE ((unsigned) (24))

struct IDecFloat16;

struct IDecFloat16VTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*toBcd)(struct IDecFloat16* self, const FB_DEC16* from, int* sign, unsigned char* bcd, int* exp);
	void (*toString)(struct IDecFloat16* self, struct IStatus* status, const FB_DEC16* from, unsigned bufferLength, char* buffer);
	void (*fromBcd)(struct IDecFloat16* self, int sign, const unsigned char* bcd, int exp, FB_DEC16* to);
	void (*fromString)(struct IDecFloat16* self, struct IStatus* status, const char* from, FB_DEC16* to);
};

struct IDecFloat16
{
	void* cloopDummy[1];
	struct IDecFloat16VTable* vtable;
};

#define IDecFloat16_toBcd(self, from, sign, bcd, exp) (self)->vtable->toBcd(self, (from), (sign), (bcd), (exp))
#define IDecFloat16_toString(self, status, from, bufferLength, buffer) (self)->vtable->toString(self, (status), (from), (bufferLength), (buffer))
#define IDecFloat16_fromBcd(self, sign, bcd, exp, to) (self)->vtable->fromBcd(self, (sign), (bcd), (exp), (to))
#define IDecFloat16_fromString(self, status, from, to) (self)->vtable->fromString(self, (status), (from), (to))

#define IDecFloat34_VERSION 2

#define IDecFloat34_BCD_SIZE ((unsigned) (34))
#define IDecFloat34_STRING_SIZE ((unsigned) (43))

struct IDecFloat34;

struct IDecFloat34VTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*toBcd)(struct IDecFloat34* self, const FB_DEC34* from, int* sign, unsigned char* bcd, int* exp);
	void (*toString)(struct IDecFloat34* self, struct IStatus* status, const FB_DEC34* from, unsigned bufferLength, char* buffer);
	void (*fromBcd)(struct IDecFloat34* self, int sign, const unsigned char* bcd, int exp, FB_DEC34* to);
	void (*fromString)(struct IDecFloat34* self, struct IStatus* status, const char* from, FB_DEC34* to);
};

struct IDecFloat34
{
	void* cloopDummy[1];
	struct IDecFloat34VTable* vtable;
};

#define IDecFloat34_toBcd(self, from, sign, bcd, exp) (self)->vtable->toBcd(self, (from), (sign), (bcd), (exp))
#define IDecFloat34_toString(self, status, from, bufferLength, buffer) (self)->vtable->toString(self, (status), (from), (bufferLength), (buffer))
#define IDecFloat34_fromBcd(self, sign, bcd, exp, to) (self)->vtable->fromBcd(self, (sign), (bcd), (exp), (to))
#define IDecFloat34_fromString(self, status, from, to) (self)->vtable->fromString(self, (status), (from), (to))

#define IInt128_VERSION 2

#define IInt128_STRING_SIZE ((unsigned) (46))

struct IInt128;

struct IInt128VTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*toString)(struct IInt128* self, struct IStatus* status, const FB_I128* from, int scale, unsigned bufferLength, char* buffer);
	void (*fromString)(struct IInt128* self, struct IStatus* status, int scale, const char* from, FB_I128* to);
};

struct IInt128
{
	void* cloopDummy[1];
	struct IInt128VTable* vtable;
};

#define IInt128_toString(self, status, from, scale, bufferLength, buffer) (self)->vtable->toString(self, (status), (from), (scale), (bufferLength), (buffer))
#define IInt128_fromString(self, status, scale, from, to) (self)->vtable->fromString(self, (status), (scale), (from), (to))

#define IReplicatedField_VERSION 2

struct IReplicatedField;

struct IReplicatedFieldVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	const char* (*getName)(struct IReplicatedField* self);
	unsigned (*getType)(struct IReplicatedField* self);
	int (*getSubType)(struct IReplicatedField* self);
	int (*getScale)(struct IReplicatedField* self);
	unsigned (*getLength)(struct IReplicatedField* self);
	unsigned (*getCharSet)(struct IReplicatedField* self);
	const void* (*getData)(struct IReplicatedField* self);
};

struct IReplicatedField
{
	void* cloopDummy[1];
	struct IReplicatedFieldVTable* vtable;
};

#define IReplicatedField_getName(self) ((self)->vtable->getName(self))
#define IReplicatedField_getType(self) ((self)->vtable->getType(self))
#define IReplicatedField_getSubType(self) ((self)->vtable->getSubType(self))
#define IReplicatedField_getScale(self) ((self)->vtable->getScale(self))
#define IReplicatedField_getLength(self) ((self)->vtable->getLength(self))
#define IReplicatedField_getCharSet(self) ((self)->vtable->getCharSet(self))
#define IReplicatedField_getData(self) (self)->vtable->getData(self)

#define IReplicatedRecord_VERSION 2

struct IReplicatedRecord;

struct IReplicatedRecordVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	unsigned (*getCount)(struct IReplicatedRecord* self);
	struct IReplicatedField* (*getField)(struct IReplicatedRecord* self, unsigned index);
	unsigned (*getRawLength)(struct IReplicatedRecord* self);
	const unsigned char* (*getRawData)(struct IReplicatedRecord* self);
};

struct IReplicatedRecord
{
	void* cloopDummy[1];
	struct IReplicatedRecordVTable* vtable;
};

#define IReplicatedRecord_getCount(self) ((self)->vtable->getCount(self))
#define IReplicatedRecord_getField(self, index) ((self)->vtable->getField(self, (index)))
#define IReplicatedRecord_getRawLength(self) ((self)->vtable->getRawLength(self))
#define IReplicatedRecord_getRawData(self) ((self)->vtable->getRawData(self))

#define IReplicatedTransaction_VERSION 3

struct IReplicatedTransaction;

struct IReplicatedTransactionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IReplicatedTransaction* self);
	void (*prepare)(struct IReplicatedTransaction* self, struct IStatus* status);
	void (*commit)(struct IReplicatedTransaction* self, struct IStatus* status);
	void (*rollback)(struct IReplicatedTransaction* self, struct IStatus* status);
	void (*startSavepoint)(struct IReplicatedTransaction* self, struct IStatus* status);
	void (*releaseSavepoint)(struct IReplicatedTransaction* self, struct IStatus* status);
	void (*rollbackSavepoint)(struct IReplicatedTransaction* self, struct IStatus* status);
	void (*insertRecord)(struct IReplicatedTransaction* self, struct IStatus* status, const char* name, struct IReplicatedRecord* record);
	void (*updateRecord)(struct IReplicatedTransaction* self, struct IStatus* status, const char* name, struct IReplicatedRecord* orgRecord, struct IReplicatedRecord* newRecord);
	void (*deleteRecord)(struct IReplicatedTransaction* self, struct IStatus* status, const char* name, struct IReplicatedRecord* record);
	void (*executeSql)(struct IReplicatedTransaction* self, struct IStatus* status, const char* sql);
	void (*executeSqlIntl)(struct IReplicatedTransaction* self, struct IStatus* status, unsigned charset, const char* sql);
};

struct IReplicatedTransaction
{
	void* cloopDummy[1];
	struct IReplicatedTransactionVTable* vtable;
};

#define IReplicatedTransaction_dispose(self) (self)->vtable->dispose(self)
#define IReplicatedTransaction_prepare(self, status) (self)->vtable->prepare(self, (status))
#define IReplicatedTransaction_commit(self, status) (self)->vtable->commit(self, (status))
#define IReplicatedTransaction_rollback(self, status) (self)->vtable->rollback(self, (status))
#define IReplicatedTransaction_startSavepoint(self, status) (self)->vtable->startSavepoint(self, (status))
#define IReplicatedTransaction_releaseSavepoint(self, status) (self)->vtable->releaseSavepoint(self, (status))
#define IReplicatedTransaction_rollbackSavepoint(self, status) (self)->vtable->rollbackSavepoint(self, (status))
#define IReplicatedTransaction_insertRecord(self, status, name, record) (self)->vtable->insertRecord(self, (status), (name), (record))
#define IReplicatedTransaction_updateRecord(self, status, name, orgRecord, newRecord) (self)->vtable->updateRecord(self, (status), (name), (orgRecord), (newRecord))
#define IReplicatedTransaction_deleteRecord(self, status, name, record) (self)->vtable->deleteRecord(self, (status), (name), (record))
#define IReplicatedTransaction_executeSql(self, status, sql) (self)->vtable->executeSql(self, (status), (sql))
#define IReplicatedTransaction_executeSqlIntl(self, status, charset, sql) (self)->vtable->executeSqlIntl(self, (status), (charset), (sql))

#define IReplicatedSession_VERSION 4

struct IReplicatedSession;

struct IReplicatedSessionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IReplicatedSession* self);
	int (*release)(struct IReplicatedSession* self);
	void (*setOwner)(struct IReplicatedSession* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IReplicatedSession* self);
	FB_BOOLEAN (*init)(struct IReplicatedSession* self, struct IStatus* status, struct IAttachment* attachment);
	struct IReplicatedTransaction* (*startTransaction)(struct IReplicatedSession* self, struct IStatus* status, struct ITransaction* transaction, ISC_INT64 number);
	void (*cleanupTransaction)(struct IReplicatedSession* self, struct IStatus* status, ISC_INT64 number);
	void (*setSequence)(struct IReplicatedSession* self, struct IStatus* status, const char* name, ISC_INT64 value);
};

struct IReplicatedSession
{
	void* cloopDummy[1];
	struct IReplicatedSessionVTable* vtable;
};

#define IReplicatedSession_addRef(self) (self)->vtable->addRef(self)
#define IReplicatedSession_release(self) ((self)->vtable->release(self))
#define IReplicatedSession_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IReplicatedSession_getOwner(self) ((self)->vtable->getOwner(self))
#define IReplicatedSession_init(self, status, attachment) ((self)->vtable->init(self, (status), (attachment)))
#define IReplicatedSession_startTransaction(self, status, transaction, number) ((self)->vtable->startTransaction(self, (status), (transaction), (number)))
#define IReplicatedSession_cleanupTransaction(self, status, number) (self)->vtable->cleanupTransaction(self, (status), (number))
#define IReplicatedSession_setSequence(self, status, name, value) (self)->vtable->setSequence(self, (status), (name), (value))

#define IProfilerPlugin_VERSION 4

struct IProfilerPlugin;

struct IProfilerPluginVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*addRef)(struct IProfilerPlugin* self);
	int (*release)(struct IProfilerPlugin* self);
	void (*setOwner)(struct IProfilerPlugin* self, struct IReferenceCounted* r);
	struct IReferenceCounted* (*getOwner)(struct IProfilerPlugin* self);
	void (*init)(struct IProfilerPlugin* self, struct IStatus* status, struct IAttachment* attachment, ISC_UINT64 ticksFrequency);
	struct IProfilerSession* (*startSession)(struct IProfilerPlugin* self, struct IStatus* status, const char* description, const char* options, ISC_TIMESTAMP_TZ timestamp);
	void (*flush)(struct IProfilerPlugin* self, struct IStatus* status);
};

struct IProfilerPlugin
{
	void* cloopDummy[1];
	struct IProfilerPluginVTable* vtable;
};

#define IProfilerPlugin_addRef(self) (self)->vtable->addRef(self)
#define IProfilerPlugin_release(self) ((self)->vtable->release(self))
#define IProfilerPlugin_setOwner(self, r) (self)->vtable->setOwner(self, (r))
#define IProfilerPlugin_getOwner(self) ((self)->vtable->getOwner(self))
#define IProfilerPlugin_init(self, status, attachment, ticksFrequency) (self)->vtable->init(self, (status), (attachment), (ticksFrequency))
#define IProfilerPlugin_startSession(self, status, description, options, timestamp) ((self)->vtable->startSession(self, (status), (description), (options), (timestamp)))
#define IProfilerPlugin_flush(self, status) (self)->vtable->flush(self, (status))

#define IProfilerSession_VERSION 3

#define IProfilerSession_FLAG_BEFORE_EVENTS ((unsigned) (0x1))
#define IProfilerSession_FLAG_AFTER_EVENTS ((unsigned) (0x2))

struct IProfilerSession;

struct IProfilerSessionVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	void (*dispose)(struct IProfilerSession* self);
	ISC_INT64 (*getId)(struct IProfilerSession* self);
	unsigned (*getFlags)(struct IProfilerSession* self);
	void (*cancel)(struct IProfilerSession* self, struct IStatus* status);
	void (*finish)(struct IProfilerSession* self, struct IStatus* status, ISC_TIMESTAMP_TZ timestamp);
	void (*defineStatement)(struct IProfilerSession* self, struct IStatus* status, ISC_INT64 statementId, ISC_INT64 parentStatementId, const char* type, const char* packageName, const char* routineName, const char* sqlText);
	void (*defineCursor)(struct IProfilerSession* self, ISC_INT64 statementId, unsigned cursorId, const char* name, unsigned line, unsigned column);
	void (*defineRecordSource)(struct IProfilerSession* self, ISC_INT64 statementId, unsigned cursorId, unsigned recSourceId, unsigned level, const char* accessPath, unsigned parentRecSourceId);
	void (*onRequestStart)(struct IProfilerSession* self, struct IStatus* status, ISC_INT64 statementId, ISC_INT64 requestId, ISC_INT64 callerStatementId, ISC_INT64 callerRequestId, ISC_TIMESTAMP_TZ timestamp);
	void (*onRequestFinish)(struct IProfilerSession* self, struct IStatus* status, ISC_INT64 statementId, ISC_INT64 requestId, ISC_TIMESTAMP_TZ timestamp, struct IProfilerStats* stats);
	void (*beforePsqlLineColumn)(struct IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned line, unsigned column);
	void (*afterPsqlLineColumn)(struct IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned line, unsigned column, struct IProfilerStats* stats);
	void (*beforeRecordSourceOpen)(struct IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId);
	void (*afterRecordSourceOpen)(struct IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId, struct IProfilerStats* stats);
	void (*beforeRecordSourceGetRecord)(struct IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId);
	void (*afterRecordSourceGetRecord)(struct IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId, struct IProfilerStats* stats);
};

struct IProfilerSession
{
	void* cloopDummy[1];
	struct IProfilerSessionVTable* vtable;
};

#define IProfilerSession_dispose(self) (self)->vtable->dispose(self)
#define IProfilerSession_getId(self) ((self)->vtable->getId(self))
#define IProfilerSession_getFlags(self) ((self)->vtable->getFlags(self))
#define IProfilerSession_cancel(self, status) (self)->vtable->cancel(self, (status))
#define IProfilerSession_finish(self, status, timestamp) (self)->vtable->finish(self, (status), (timestamp))
#define IProfilerSession_defineStatement(self, status, statementId, parentStatementId, type, packageName, routineName, sqlText) (self)->vtable->defineStatement(self, (status), (statementId), (parentStatementId), (type), (packageName), (routineName), (sqlText))
#define IProfilerSession_defineCursor(self, statementId, cursorId, name, line, column) (self)->vtable->defineCursor(self, (statementId), (cursorId), (name), (line), (column))
#define IProfilerSession_defineRecordSource(self, statementId, cursorId, recSourceId, level, accessPath, parentRecSourceId) (self)->vtable->defineRecordSource(self, (statementId), (cursorId), (recSourceId), (level), (accessPath), (parentRecSourceId))
#define IProfilerSession_onRequestStart(self, status, statementId, requestId, callerStatementId, callerRequestId, timestamp) (self)->vtable->onRequestStart(self, (status), (statementId), (requestId), (callerStatementId), (callerRequestId), (timestamp))
#define IProfilerSession_onRequestFinish(self, status, statementId, requestId, timestamp, stats) (self)->vtable->onRequestFinish(self, (status), (statementId), (requestId), (timestamp), (stats))
#define IProfilerSession_beforePsqlLineColumn(self, statementId, requestId, line, column) (self)->vtable->beforePsqlLineColumn(self, (statementId), (requestId), (line), (column))
#define IProfilerSession_afterPsqlLineColumn(self, statementId, requestId, line, column, stats) (self)->vtable->afterPsqlLineColumn(self, (statementId), (requestId), (line), (column), (stats))
#define IProfilerSession_beforeRecordSourceOpen(self, statementId, requestId, cursorId, recSourceId) (self)->vtable->beforeRecordSourceOpen(self, (statementId), (requestId), (cursorId), (recSourceId))
#define IProfilerSession_afterRecordSourceOpen(self, statementId, requestId, cursorId, recSourceId, stats) (self)->vtable->afterRecordSourceOpen(self, (statementId), (requestId), (cursorId), (recSourceId), (stats))
#define IProfilerSession_beforeRecordSourceGetRecord(self, statementId, requestId, cursorId, recSourceId) (self)->vtable->beforeRecordSourceGetRecord(self, (statementId), (requestId), (cursorId), (recSourceId))
#define IProfilerSession_afterRecordSourceGetRecord(self, statementId, requestId, cursorId, recSourceId, stats) (self)->vtable->afterRecordSourceGetRecord(self, (statementId), (requestId), (cursorId), (recSourceId), (stats))

#define IProfilerStats_VERSION 2

struct IProfilerStats;

struct IProfilerStatsVTable
{
	void* cloopDummy[1];
	uintptr_t version;
	ISC_UINT64 (*getElapsedTicks)(struct IProfilerStats* self);
};

struct IProfilerStats
{
	void* cloopDummy[1];
	struct IProfilerStatsVTable* vtable;
};

#define IProfilerStats_getElapsedTicks(self) ((self)->vtable->getElapsedTicks(self))


#endif	// FB_C_API_H
