#ifndef GODOT_CPP_SCENETREETWEEN_HPP
#define GODOT_CPP_SCENETREETWEEN_HPP


#include <gdnative_api_struct.gen.h>
#include <cstdint>

#include <core/CoreTypes.hpp>
#include <core/Ref.hpp>

#include "Reference.hpp"
namespace godot {

class SceneTreeTween;
class Node;
class CallbackTweener;
class Object;
class IntervalTweener;
class MethodTweener;
class PropertyTweener;

class SceneTreeTween : public Reference {
	struct ___method_bindings {
		godot_method_bind *mb_bind_node;
		godot_method_bind *mb_chain;
		godot_method_bind *mb_custom_step;
		godot_method_bind *mb_get_total_elapsed_time;
		godot_method_bind *mb_interpolate_value;
		godot_method_bind *mb_is_running;
		godot_method_bind *mb_is_valid;
		godot_method_bind *mb_kill;
		godot_method_bind *mb_parallel;
		godot_method_bind *mb_pause;
		godot_method_bind *mb_play;
		godot_method_bind *mb_set_ease;
		godot_method_bind *mb_set_loops;
		godot_method_bind *mb_set_parallel;
		godot_method_bind *mb_set_pause_mode;
		godot_method_bind *mb_set_process_mode;
		godot_method_bind *mb_set_speed_scale;
		godot_method_bind *mb_set_trans;
		godot_method_bind *mb_stop;
		godot_method_bind *mb_tween_callback;
		godot_method_bind *mb_tween_interval;
		godot_method_bind *mb_tween_method;
		godot_method_bind *mb_tween_property;
	};
	static ___method_bindings ___mb;
	static void *_detail_class_tag;

public:
	static void ___init_method_bindings();
	inline static size_t ___get_id() { return (size_t)_detail_class_tag; }

	static inline const char *___get_class_name() { return (const char *) "SceneTreeTween"; }
	static inline const char *___get_godot_class_name() { return (const char *) "SceneTreeTween"; }
	static inline Object *___get_from_variant(Variant a) { godot_object *o = (godot_object*) a; return (o) ? (Object *) godot::nativescript_1_1_api->godot_nativescript_get_instance_binding_data(godot::_RegisterState::language_index, o) : nullptr; }

	// enums
	enum TweenPauseMode {
		TWEEN_PAUSE_BOUND = 0,
		TWEEN_PAUSE_STOP = 1,
		TWEEN_PAUSE_PROCESS = 2,
	};

	// constants


	static SceneTreeTween *_new();

	// methods
	Ref<SceneTreeTween> bind_node(const Node *node);
	Ref<SceneTreeTween> chain();
	bool custom_step(const real_t delta);
	real_t get_total_elapsed_time() const;
	Variant interpolate_value(const Variant initial_value, const Variant delta_value, const real_t elapsed_time, const real_t duration, const int64_t trans_type, const int64_t ease_type) const;
	bool is_running() const;
	bool is_valid() const;
	void kill();
	Ref<SceneTreeTween> parallel();
	void pause();
	void play();
	Ref<SceneTreeTween> set_ease(const int64_t ease);
	Ref<SceneTreeTween> set_loops(const int64_t loops = 0);
	Ref<SceneTreeTween> set_parallel(const bool parallel = true);
	Ref<SceneTreeTween> set_pause_mode(const int64_t mode);
	Ref<SceneTreeTween> set_process_mode(const int64_t mode);
	Ref<SceneTreeTween> set_speed_scale(const real_t speed);
	Ref<SceneTreeTween> set_trans(const int64_t trans);
	void stop();
	Ref<CallbackTweener> tween_callback(const Object *object, const String method, const Array binds = Array());
	Ref<IntervalTweener> tween_interval(const real_t time);
	Ref<MethodTweener> tween_method(const Object *object, const String method, const Variant from, const Variant to, const real_t duration, const Array binds = Array());
	Ref<PropertyTweener> tween_property(const Object *object, const NodePath property, const Variant final_val, const real_t duration);

};

}

#endif