# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Bayesian algorithms."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _bayesian
else:
    import _bayesian

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _bayesian.delete_SwigPyIterator

    def value(self):
        return _bayesian.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _bayesian.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _bayesian.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _bayesian.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _bayesian.SwigPyIterator_equal(self, x)

    def copy(self):
        return _bayesian.SwigPyIterator_copy(self)

    def next(self):
        return _bayesian.SwigPyIterator_next(self)

    def __next__(self):
        return _bayesian.SwigPyIterator___next__(self)

    def previous(self):
        return _bayesian.SwigPyIterator_previous(self)

    def advance(self, n):
        return _bayesian.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _bayesian.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _bayesian.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _bayesian.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _bayesian.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _bayesian.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _bayesian.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _bayesian:
_bayesian.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.randomvector
class CalibrationResult(openturns.common.PersistentObject):
    r"""
    Calibration result.

    Returned by calibration algorithms, see :class:`~openturns.CalibrationAlgorithm`.

    Parameters
    ----------
    parameterPrior : :class:`~openturns.Distribution`
        The prior distribution of the parameter.
    parameterPosterior : :class:`~openturns.Distribution`
        The posterior distribution of the parameter.
    parameterMap : sequence of float
        The maximum a posteriori estimate of the parameter.
    observationsError : :class:`~openturns.Distribution`
        The distribution of the observations error.
    inputObservations : :class:`~openturns.Sample`
        The sample of input observations.
    outputObservations : :class:`~openturns.Sample`
        The sample of output observations.
    residualFunction : :class:`~openturns.Function`
        The residual function.

    Notes
    -----
    The residual function returns `model(inputObservations) - outputObservations`.

    Examples
    --------
    >>> import openturns as ot

    # assume we obtained a result from CalibrationAlgorithm

    >>> result = ot.CalibrationResult()
    >>> pmap = result.getParameterMAP()
    >>> prior = result.getParameterPrior()
    >>> posterior = result.getParameterPosterior()
    >>> graph1 = result.drawParameterDistributions()  # doctest: +SKIP
    >>> graph2 = result.drawResiduals()  # doctest: +SKIP
    >>> graph3 = result.drawObservationsVsInputs()  # doctest: +SKIP
    >>> graph4 = result.drawObservationsVsPredictions()  # doctest: +SKIP

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationResult_getClassName(self)

    def setParameterPrior(self, parameterPrior):
        r"""
        Accessor to the parameter prior distribution.

        Parameters
        ----------
        parameterPrior : : :class:`~openturns.Distribution`
            The prior distribution of the parameter.
        """
        return _bayesian.CalibrationResult_setParameterPrior(self, parameterPrior)

    def getParameterPrior(self):
        r"""
        Accessor to the parameter prior distribution.

        Returns
        -------
        parameterPrior : :class:`~openturns.Distribution`
            The prior distribution of the parameter.
        """
        return _bayesian.CalibrationResult_getParameterPrior(self)

    def setParameterPosterior(self, parameterPosterior):
        r"""
        Accessor to the parameter posterior distribution.

        Parameters
        ----------
        parameterPosterior : : :class:`~openturns.Distribution`
            The posterior distribution of the parameter.
        """
        return _bayesian.CalibrationResult_setParameterPosterior(self, parameterPosterior)

    def getParameterPosterior(self):
        r"""
        Accessor to the parameter posterior distribution.

        Returns
        -------
        parameterPosterior : :class:`~openturns.Distribution`
            The posterior distribution of the parameter.
        """
        return _bayesian.CalibrationResult_getParameterPosterior(self)

    def setObservationsError(self, observationsError):
        r"""
        Accessor to the observations error distribution.

        Parameters
        ----------
        observationsError : :class:`~openturns.Distribution`
            The observations error distribution.
        """
        return _bayesian.CalibrationResult_setObservationsError(self, observationsError)

    def getObservationsError(self):
        r"""
        Accessor to the observations error distribution.

        Returns
        -------
        observationsError : :class:`~openturns.Distribution`
            The observations error distribution.
        """
        return _bayesian.CalibrationResult_getObservationsError(self)

    def setParameterMAP(self, parameterMAP):
        r"""
        Accessor to the maximum a posteriori parameter estimate.

        Parameters
        ----------
        parameterPosterior : sequence of float
            The maximum a posteriori parameter estimate.
        """
        return _bayesian.CalibrationResult_setParameterMAP(self, parameterMAP)

    def getParameterMAP(self):
        r"""
        Accessor to the maximum a posteriori parameter estimate.

        Returns
        -------
        parameterPosterior : :class:`~openturns.Point`
            The maximum a posteriori parameter estimate.
        """
        return _bayesian.CalibrationResult_getParameterMAP(self)

    def setInputObservations(self, inputObservations):
        r"""
        Accessor to the input observations.

        Parameters
        ----------
        inputObservations : :class:`~openturns.Sample`
            The sample of input observations.
        """
        return _bayesian.CalibrationResult_setInputObservations(self, inputObservations)

    def getInputObservations(self):
        r"""
        Accessor to the input observations.

        Returns
        -------
        inputObservations : :class:`~openturns.Sample`
            The sample of input observations.
        """
        return _bayesian.CalibrationResult_getInputObservations(self)

    def setOutputObservations(self, outputObservations):
        r"""
        Accessor to the output observations.

        Parameters
        ----------
        outputObservations : :class:`~openturns.Sample`
            The sample of output observations.
        """
        return _bayesian.CalibrationResult_setOutputObservations(self, outputObservations)

    def getOutputObservations(self):
        r"""
        Accessor to the output observations.

        Returns
        -------
        outputObservations : :class:`~openturns.Sample`
            The sample of output observations.
        """
        return _bayesian.CalibrationResult_getOutputObservations(self)

    def setResidualFunction(self, residualFunction):
        r"""
        Accessor to the residual function.

        Parameters
        ----------
        residualFunction : :class:`~openturns.Function`
            The residual function.
        """
        return _bayesian.CalibrationResult_setResidualFunction(self, residualFunction)

    def getResidualFunction(self):
        r"""
        Accessor to the residual function.

        Returns
        -------
        residualFunction : :class:`~openturns.Function`
            The residual function.
        """
        return _bayesian.CalibrationResult_getResidualFunction(self)

    def __repr__(self):
        return _bayesian.CalibrationResult___repr__(self)

    def setOutputAtPriorAndPosteriorMean(self, outputAtPriorMean, outputAtPosteriorMean):
        r"""
        Accessor to the output at prior/posterior mean.

        Parameters
        ----------
        outputAtPrior : :class:`~openturns.Sample`
            The sample of output at prior mean.
        outputAtPosterior : :class:`~openturns.Sample`
            The sample of output at posterior mean.
        """
        return _bayesian.CalibrationResult_setOutputAtPriorAndPosteriorMean(self, outputAtPriorMean, outputAtPosteriorMean)

    def getOutputAtPriorMean(self):
        r"""
        Accessor to the output observations.

        Returns
        -------
        outputAtPrior : :class:`~openturns.Sample`
            Output at prior mean.
        """
        return _bayesian.CalibrationResult_getOutputAtPriorMean(self)

    def getOutputAtPosteriorMean(self):
        r"""
        Accessor to the output observations.

        Returns
        -------
        outputAtPosterior : :class:`~openturns.Sample`
            Output at posterior mean.
        """
        return _bayesian.CalibrationResult_getOutputAtPosteriorMean(self)

    def drawParameterDistributions(self):
        r"""
        Draw parameter prior/posterior.

        Plots the prior and posterior distribution of the calibrated parameter theta.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Graph array.
        """
        return _bayesian.CalibrationResult_drawParameterDistributions(self)

    def drawResiduals(self):
        r"""
        Draw residuals.

        Plot the distribution of the sample residuals before and after calibration 
        using kernel smoothing and the distribution of the observation errors.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Graph array.
        """
        return _bayesian.CalibrationResult_drawResiduals(self)

    def drawObservationsVsInputs(self):
        r"""
        Draw observations/inputs.

        Plot the observed output of the model depending on the observed input before
        and after calibration.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Graph array.
        """
        return _bayesian.CalibrationResult_drawObservationsVsInputs(self)

    def drawObservationsVsPredictions(self):
        r"""
        Draw observations/predictions.

        Plots the output of the model depending on the output observations before and
        after calibration.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Graph array.
        """
        return _bayesian.CalibrationResult_drawObservationsVsPredictions(self)

    def drawResidualsNormalPlot(self):
        r"""
        Draw residuals normal plot.

        Plots the quantile-quantile graphs of the empirical residual 
        after calibration vs the Gaussian distribution.

        Returns
        -------
        grid : :class:`~openturns.GridLayout`
            Graph array.
        """
        return _bayesian.CalibrationResult_drawResidualsNormalPlot(self)

    def __init__(self, *args):
        _bayesian.CalibrationResult_swiginit(self, _bayesian.new_CalibrationResult(*args))
    __swig_destroy__ = _bayesian.delete_CalibrationResult

# Register CalibrationResult in _bayesian:
_bayesian.CalibrationResult_swigregister(CalibrationResult)
class CalibrationAlgorithmImplementation(openturns.common.PersistentObject):
    r"""
    Base class for calibration algorithms.

    Parameters
    ----------
    outputObservations : 2-d sequence of float
        The output data to be fitted.
    prior : :class:`~openturns.Distribution`
        The prior distribution of the parameter

    See also
    --------
    CalibrationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationAlgorithmImplementation_getClassName(self)

    def __repr__(self):
        return _bayesian.CalibrationAlgorithmImplementation___repr__(self)

    def getModel(self):
        r"""
        Accessor to the model to be fitted.

        Returns
        -------
        data : :class:`~openturns.Function`
            The model to be fitted.
        """
        return _bayesian.CalibrationAlgorithmImplementation_getModel(self)

    def getInputObservations(self):
        r"""
        Accessor to the input data to be fitted.

        Returns
        -------
        data : :class:`~openturns.Sample`
            The input data to be fitted.
        """
        return _bayesian.CalibrationAlgorithmImplementation_getInputObservations(self)

    def getOutputObservations(self):
        r"""
        Accessor to the output data to be fitted.

        Returns
        -------
        data : :class:`~openturns.Sample`
            The output data to be fitted.
        """
        return _bayesian.CalibrationAlgorithmImplementation_getOutputObservations(self)

    def getParameterPrior(self):
        r"""
        Accessor to the parameter prior distribution.

        Returns
        -------
        prior : :class:`~openturns.Distribution`
            The parameter prior distribution.
        """
        return _bayesian.CalibrationAlgorithmImplementation_getParameterPrior(self)

    def run(self):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.CalibrationAlgorithmImplementation_run(self)

    def getResult(self):
        r"""
        Get the result structure.

        Returns
        -------
        resCalibration: :class:`~openturns.CalibrationResult`
            The structure containing all the results of the calibration problem.

        Notes
        -----
        The structure contains all the results of the calibration problem.
        """
        return _bayesian.CalibrationAlgorithmImplementation_getResult(self)

    def setResult(self, result):
        r"""
        Accessor to optimization result.

        Parameters
        ----------
        result : :class:`~openturns.CalibrationResult`
            Result class.
        """
        return _bayesian.CalibrationAlgorithmImplementation_setResult(self, result)

    def __init__(self, *args):
        _bayesian.CalibrationAlgorithmImplementation_swiginit(self, _bayesian.new_CalibrationAlgorithmImplementation(*args))
    __swig_destroy__ = _bayesian.delete_CalibrationAlgorithmImplementation

# Register CalibrationAlgorithmImplementation in _bayesian:
_bayesian.CalibrationAlgorithmImplementation_swigregister(CalibrationAlgorithmImplementation)
class _CalibrationAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _bayesian._CalibrationAlgorithmImplementationTypedInterfaceObject_swiginit(self, _bayesian.new__CalibrationAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _bayesian._CalibrationAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _bayesian._CalibrationAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _bayesian._CalibrationAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _bayesian._CalibrationAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _bayesian._CalibrationAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _bayesian.delete__CalibrationAlgorithmImplementationTypedInterfaceObject

# Register _CalibrationAlgorithmImplementationTypedInterfaceObject in _bayesian:
_bayesian._CalibrationAlgorithmImplementationTypedInterfaceObject_swigregister(_CalibrationAlgorithmImplementationTypedInterfaceObject)
class CalibrationAlgorithm(_CalibrationAlgorithmImplementationTypedInterfaceObject):
    r"""
    Base class for calibration algorithms.

    Parameters
    ----------
    outputObservations : 2-d sequence of float
        The output data to be fitted.
    prior : :class:`~openturns.Distribution`
        The prior distribution of the parameter

    See also
    --------
    CalibrationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationAlgorithm_getClassName(self)

    def run(self):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.CalibrationAlgorithm_run(self)

    def getOutputObservations(self):
        r"""
        Accessor to the output data to be fitted.

        Returns
        -------
        data : :class:`~openturns.Sample`
            The output data to be fitted.
        """
        return _bayesian.CalibrationAlgorithm_getOutputObservations(self)

    def getParameterPrior(self):
        r"""
        Accessor to the parameter prior distribution.

        Returns
        -------
        prior : :class:`~openturns.Distribution`
            The parameter prior distribution.
        """
        return _bayesian.CalibrationAlgorithm_getParameterPrior(self)

    def setResult(self, result):
        r"""
        Accessor to optimization result.

        Parameters
        ----------
        result : :class:`~openturns.CalibrationResult`
            Result class.
        """
        return _bayesian.CalibrationAlgorithm_setResult(self, result)

    def getResult(self):
        r"""
        Get the result structure.

        Returns
        -------
        resCalibration: :class:`~openturns.CalibrationResult`
            The structure containing all the results of the calibration problem.

        Notes
        -----
        The structure contains all the results of the calibration problem.
        """
        return _bayesian.CalibrationAlgorithm_getResult(self)

    def __init__(self, *args):
        _bayesian.CalibrationAlgorithm_swiginit(self, _bayesian.new_CalibrationAlgorithm(*args))
    __swig_destroy__ = _bayesian.delete_CalibrationAlgorithm

# Register CalibrationAlgorithm in _bayesian:
_bayesian.CalibrationAlgorithm_swigregister(CalibrationAlgorithm)
class GaussianLinearCalibration(CalibrationAlgorithmImplementation):
    r"""
    Gaussian linear calibration algorithm.

    Available constructors:
        GaussianLinearCalibration(*model, inputObservations, outputObservations, parameterMean, parameterCovariance, errorCovariance, methodName*)

        GaussianLinearCalibration(*modelObservations, gradientObservations, outputObservations, parameterMean, parameterCovariance, errorCovariance, methodName*)

    Parameters
    ----------
    model : :class:`~openturns.Function`
        The parametric function to be calibrated.
    inputObservations : 2-d sequence of float
        The sample of input observations.
        Can have dimension 0 to specify no observations. 
    outputObservations : 2-d sequence of float
        The sample of output observations.
    parameterMean : sequence of float
        The mean of the Gaussian prior distribution of the parameter.
    parameterCovariance : 2-d sequence of float
        The covariance matrix of the Gaussian prior distribution of the parameter.
    errorCovariance : 2-d sequence of float
        The covariance matrix of the Gaussian distribution of the observations error.
    methodName : str
        The name of the least-squares method to use for the calibration.
        By default, equal to *QR*. Possible values are *SVD*, *QR*, *Cholesky*.
    modelObservations : 2-d sequence of float
        The sample of output values of the model.
    gradientObservations : 2-d sequence of float
        The Jacobian matrix of the model with respect to the parameter.

    Notes
    -----
    This class implements the Maximum A Posteriori (MAP) estimator for a linear model
    under the Bayesian hypothesis that the prior and the observation errors have Gaussian distributions. 
    This is also known as the Kalman filter. 

    The given observation error covariance can be either *local*, ie the same matrix applies for each observation and is of
    dimension the output dimension of the model, or *global*, ie the matrix describes
    the full set of observation errors, in which case its dimension is the product of
    the output dimension of the model and the number of observations.

    The prior distribution of the parameter is a :class:`~openturns.Normal`.

    The posterior distribution of the parameter is :class:`~openturns.Normal`.

    The resulting error distribution is :class:`~openturns.Normal`
    with a zero mean and with a covariance matrix equal to the
    `errorCovariance` input argument.

    Please read :ref:`gaussian_calibration` for more details.

    See also
    --------
    LinearLeastSquaresCalibration, NonLinearLeastSquaresCalibration, GaussianNonLinearCalibration

    Examples
    --------
    Calibrate a nonlinear model using GaussianLinearCalibration:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> m = 10
    >>> x = [[0.5 + i] for i in range(m)]
    >>> inVars = ['a', 'b', 'c', 'x']
    >>> formulas = ['a + b * exp(c * x)']
    >>> model = ot.SymbolicFunction(inVars, formulas)
    >>> p_ref = [2.8, 1.2, 0.5]
    >>> params = [0, 1, 2]
    >>> modelX = ot.ParametricFunction(model, params, p_ref)
    >>> y = modelX(x)
    >>> y += ot.Normal(0.0, 0.05).getSample(m)
    >>> parameterMean = [1.0]*3
    >>> priorCovariance = ot.CovarianceMatrix(3)
    >>> errorCovariance = ot.CovarianceMatrix(1, [0.1])
    >>> method = 'SVD'
    >>> algo = ot.GaussianLinearCalibration(modelX, x, y, parameterMean, priorCovariance, errorCovariance, method)
    >>> algo.run()
    >>> print(algo.getResult().getParameterMAP())
    [8.11483,0.0770992,0.992927]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.GaussianLinearCalibration_getClassName(self)

    def __repr__(self):
        return _bayesian.GaussianLinearCalibration___repr__(self)

    def run(self):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.GaussianLinearCalibration_run(self)

    def getModelObservations(self):
        r"""
        Accessor to the model evaluation at the `parameterMean`.

        Returns
        -------
        modelObservation : :class:`~openturns.Sample`
            Evaluation of the model at the `parameterMean` point.
        """
        return _bayesian.GaussianLinearCalibration_getModelObservations(self)

    def getGradientObservations(self):
        r"""
        Accessor to the model gradient at the `parameterMean`.

        Returns
        -------
        gradientObservation : :class:`~openturns.Matrix`
            Gradient of the model at the `parameterMean` point.
        """
        return _bayesian.GaussianLinearCalibration_getGradientObservations(self)

    def getParameterMean(self):
        r"""
        Accessor to the parameter `parameterMean`.

        Returns
        -------
        parameterMean : :class:`~openturns.Point`
            Parameter parameterMean.
        """
        return _bayesian.GaussianLinearCalibration_getParameterMean(self)

    def getParameterCovariance(self):
        r"""
        Accessor to the parameter prior covariance.

        Returns
        -------
        prior : :class:`~openturns.CovarianceMatrix`
            Parameter prior covariance.
        """
        return _bayesian.GaussianLinearCalibration_getParameterCovariance(self)

    def getErrorCovariance(self):
        r"""
        Accessor to the observation error covariance.

        Returns
        -------
        error : :class:`~openturns.CovarianceMatrix`
            Observation error covariance.
        """
        return _bayesian.GaussianLinearCalibration_getErrorCovariance(self)

    def getGlobalErrorCovariance(self):
        r"""
        Accessor to the flag for a global observation error covariance.

        Returns
        -------
        flag : bool
            Flag telling if the given observation error covariance is global or not.
        """
        return _bayesian.GaussianLinearCalibration_getGlobalErrorCovariance(self)

    def getMethodName(self):
        r"""
        Accessor to the name of least-squares method used for the resolution.

        Returns
        -------
        name : :class:`~openturns.String`
            Name of least-squares method used for the resolution.
        """
        return _bayesian.GaussianLinearCalibration_getMethodName(self)

    def __init__(self, *args):
        _bayesian.GaussianLinearCalibration_swiginit(self, _bayesian.new_GaussianLinearCalibration(*args))
    __swig_destroy__ = _bayesian.delete_GaussianLinearCalibration

# Register GaussianLinearCalibration in _bayesian:
_bayesian.GaussianLinearCalibration_swigregister(GaussianLinearCalibration)
class LinearLeastSquaresCalibration(CalibrationAlgorithmImplementation):
    r"""
    Linear least squares calibration algorithm.

    Available constructors:
        LinearLeastSquaresCalibration(*model, inputObservations, outputObservations, startingPoint, methodName*)

        LinearLeastSquaresCalibration(*modelObservations, gradientObservations, outputObservations, startingPoint, methodName*)

    Parameters
    ----------
    model : :class:`~openturns.Function`
        The parametric function to be calibrated.
    inputObservations : 2-d sequence of float
        The sample of input observations.
        Can have dimension 0 to specify no observations.
    outputObservations : 2-d sequence of float
        The sample of output observations.
    startingPoint : sequence of float
        The reference value of the parameter, where the linearization
        of the parametric model is evaluated.
    methodName : str
        The name of the least-squares method to use for the calibration.
        By default, equal to *QR*. Possible values are *SVD*, *QR*, *Cholesky*.
    modelObservations : 2-d sequence of float
        The sample of output values of the model.
    gradientObservations : 2-d sequence of float
        The Jacobian matrix of the model with respect to the parameter.

    Notes
    -----
    LinearLeastSquaresCalibration is the minimum variance estimator of the parameter of a given model under the assumption that this parameter acts linearly in the model.

    The prior distribution of the parameter is a noninformative prior
    emulated using a flat :class:`~openturns.Normal` centered on the `startingPoint` and with a variance equal to SpecFunc.MaxScalar.

    The posterior distribution of the parameter is :class:`~openturns.Normal` and reflects the 
    variability of the optimum parameter depending on the observation sample. 
    The associated covariance matrix may be regularized depending on the value of the 
    key `LinearLeastSquaresCalibration-Regularization` in the :class:`~openturns.ResourceMap`. 
    Let us denote by :math:`\sigma_1` the largest singular value of the covariance matrix. 
    The default value of the `LinearLeastSquaresCalibration-Regularization`, zero, 
    ensures that the singular values of the covariance matrix are left unmodified.  
    If this parameter is set to a nonzero, relatively small, value denoted by :math:`\epsilon`, 
    then all singular values of the covariance matrix are increased by :math:`\epsilon \sigma_1`. 

    The resulting distribution of the output error is :class:`~openturns.Normal` with a zero mean
    and a diagonal covariance matrix computed from the residuals.
    The residuals are computed based on the linearization of the model,
    where the Jacobian matrix is evaluated at the `startingPoint`.
    The diagonal of the covariance matrix of the output error
    is constant and is estimated with the unbiased variance estimator.

    Please read :ref:`code_calibration` for more details.

    See also
    --------
    GaussianLinearCalibration, NonLinearLeastSquaresCalibration, GaussianNonLinearCalibration

    Examples
    --------
    Calibrate a nonlinear model using linear least-squares:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> m = 10
    >>> x = [[0.5 + i] for i in range(m)]
    >>> inVars = ['a', 'b', 'c', 'x']
    >>> formulas = ['a + b * exp(c * x)']
    >>> model = ot.SymbolicFunction(inVars, formulas)
    >>> p_ref = [2.8, 1.2, 0.5]
    >>> params = [0, 1, 2]
    >>> modelX = ot.ParametricFunction(model, params, p_ref)
    >>> y = modelX(x)
    >>> y += ot.Normal(0.0, 0.05).getSample(m)
    >>> startingPoint = [1.0]*3
    >>> method = 'SVD'
    >>> algo = ot.LinearLeastSquaresCalibration(modelX, x, y, startingPoint, method)
    >>> algo.run()
    >>> print(algo.getResult().getParameterMAP())
    [8.24019,0.0768046,0.992957]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.LinearLeastSquaresCalibration_getClassName(self)

    def __repr__(self):
        return _bayesian.LinearLeastSquaresCalibration___repr__(self)

    def run(self):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.LinearLeastSquaresCalibration_run(self)

    def getModelObservations(self):
        r"""
        Accessor to the model evaluation at the `startingPoint`.

        Returns
        -------
        modelObservation : :class:`~openturns.Sample`
            Evaluation of the model at the `startingPoint`.
        """
        return _bayesian.LinearLeastSquaresCalibration_getModelObservations(self)

    def getGradientObservations(self):
        r"""
        Accessor to the model gradient at the startingPoint.

        Returns
        -------
        gradientObservation : :class:`~openturns.Matrix`
            Gradient of the model at the startingPoint point.
        """
        return _bayesian.LinearLeastSquaresCalibration_getGradientObservations(self)

    def getStartingPoint(self):
        r"""
        Accessor to the parameter startingPoint.

        Returns
        -------
        startingPoint : :class:`~openturns.Point`
            Parameter startingPoint.
        """
        return _bayesian.LinearLeastSquaresCalibration_getStartingPoint(self)

    def getMethodName(self):
        r"""
        Accessor to the name of least-squares method used for the resolution.

        Returns
        -------
        name : :class:`~openturns.String`
            Name of least-squares method used for the resolution.
        """
        return _bayesian.LinearLeastSquaresCalibration_getMethodName(self)

    def __init__(self, *args):
        _bayesian.LinearLeastSquaresCalibration_swiginit(self, _bayesian.new_LinearLeastSquaresCalibration(*args))
    __swig_destroy__ = _bayesian.delete_LinearLeastSquaresCalibration

# Register LinearLeastSquaresCalibration in _bayesian:
_bayesian.LinearLeastSquaresCalibration_swigregister(LinearLeastSquaresCalibration)
class MetropolisHastingsImplementation(openturns.randomvector.RandomVectorImplementation):
    r"""
    Base class for Metropolis-Hastings algorithms.

    Refer to :ref:`bayesian_calibration`, :ref:`metropolis_hastings`.

    Notes
    -----
    Metropolis-Hastings algorithms are Markov Chain Monte-Carlo algorithms:
    they can sample from a target distribution
    defined as having a PDF proportional to some known function.

    If :meth:`setLikelihood` is used,
    then a likelihood factor is applied to the PDF of the target distribution:
    in Bayesian terms, the initially targeted distribution is the prior,
    and multiplying its PDF by the likelihood yields the PDF of the posterior
    up to a multiplicative constant.

    See Also
    --------
    RandomWalkMetropolisHastings
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.MetropolisHastingsImplementation_getClassName(self)

    def __repr__(self):
        return _bayesian.MetropolisHastingsImplementation___repr__(self)

    def getRealization(self):
        r"""
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _bayesian.MetropolisHastingsImplementation_getRealization(self)

    def computeLogLikelihood(self, state):
        r"""
        Compute the logarithm of the likelihood w.r.t. observations.

        Parameters
        ----------
        currentState : sequence of float
            Current state.

        Returns
        -------
        logLikelihood : float
            Logarithm of the likelihood w.r.t. observations
            :math:`(\vect{y}^1, \dots, \vect{y}^n)`.
        """
        return _bayesian.MetropolisHastingsImplementation_computeLogLikelihood(self, state)

    def computeLogPosterior(self, state):
        r"""
        Compute the logarithm of the unnormalized posterior density.

        Parameters
        ----------
        currentState : sequence of float
            Current state.

        Returns
        -------
        logPosterior : float
            Target log-PDF plus log-likelihood if the log-likelihood is defined
        """
        return _bayesian.MetropolisHastingsImplementation_computeLogPosterior(self, state)

    def getTargetDistribution(self):
        r"""
        Get the target distribution.

        Returns
        -------
        targetDistribution : :class:`~openturns.Distribution`
            The *targetDistribution* argument provided to the constructor
        """
        return _bayesian.MetropolisHastingsImplementation_getTargetDistribution(self)

    def getTargetLogPDF(self):
        r"""
        Get the target log-pdf.

        Returns
        -------
        targetLogPDF : :class:`~openturns.Function`
            The *targetLogPDF* argument provided to the constructor
        """
        return _bayesian.MetropolisHastingsImplementation_getTargetLogPDF(self)

    def getTargetLogPDFSupport(self):
        r"""
        Get the target log-pdf support.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The *support* argument provided to the constructor
        """
        return _bayesian.MetropolisHastingsImplementation_getTargetLogPDFSupport(self)

    def getInitialState(self):
        r"""
        Get the initial state.

        Returns
        -------
        initialState : sequence of float
            Initial state of the chain
        """
        return _bayesian.MetropolisHastingsImplementation_getInitialState(self)

    def getMarginalIndices(self):
        r"""
        Get the indices of the sampled components.

        Returns
        -------
        marginalIndices : :class:`~openturns.Indices`
            The *marginalIndices* argument provided to the constructor
        """
        return _bayesian.MetropolisHastingsImplementation_getMarginalIndices(self)

    def setLikelihood(self, *args):
        r"""
        Set the likelihood.

        Parameters
        ----------
        conditional : :class:`~openturns.Distribution`
            Required distribution to define the likelihood of the underlying Bayesian
            statistical model.
        observations : 2-d sequence of float
            Observations :math:`\vect y^i` required to define the likelihood.
        linkFunction : :class:`~openturns.Function`, optional
            Function :math:`g` that maps the chain into the conditional distribution parameters.
            If provided, its input dimension must match the chain dimension and its
            output dimension must match the conditional distribution parameter dimension.
            Else it is set to the identity.
        covariates : 2-d sequence of float, optional
            Parameters :math:`\vect c^i` of the linkFunction for each observation :math:`\vect y^i`.
            If provided, their dimension must match the parameter dimension of *linkFunction*.

        Notes
        -----
        Once this method is called, the class no longer samples from the distribution *targetDistribution*
        or from the distribution defined by *targetLogPDF* and *support*,
        but considers that distribution as being the prior.
        Let :math:`\pi(\vect \theta)` be the PDF of the prior at the point :math:`\vect \theta`.
        The class now samples from the posterior, whose PDF is proportional to :math:`L(\vect\theta) \, \pi(\vect\theta)`,
        the likelihood :math:`L(\vect \theta)` being defined from the arguments of this method.

        The optional parameters *linkFunction* and *covariates* allow several options to define the likelihood :math:`L(\vect \theta)`.
        Letting :math:`f` be the PDF of the distribution *conditional*:

        - Without *linkFunction* and *covariates* the likelihood term reads:

            .. math:: L(\vect \theta) = \prod_{i=1}^n f(\vect{y}^i|\vect{\theta})

        - If only the *linkFunction* is provided:

            .. math:: L(\vect \theta) = \prod_{i=1}^n f(\vect{y}^i|g(\vect{\theta}))

        - If both the *linkFunction* and *covariates* are provided:

            .. math:: L(\vect \theta) = \prod_{i=1}^n f(\vect{y}^i|g_{\vect c^i}(\vect{\theta}))

        """
        return _bayesian.MetropolisHastingsImplementation_setLikelihood(self, *args)

    def getConditional(self):
        r"""
        Get the *conditional* distribution.

        Returns
        -------
        conditional : :class:`~openturns.Distribution`
            The *conditional* argument provided to :meth:`setLikelihood`
        """
        return _bayesian.MetropolisHastingsImplementation_getConditional(self)

    def getLinkFunction(self):
        r"""
        Get the model.

        Returns
        -------
        linkFunction : :class:`~openturns.Function`
            The *linkFunction* argument provided to :meth:`setLikelihood`
        """
        return _bayesian.MetropolisHastingsImplementation_getLinkFunction(self)

    def getObservations(self):
        r"""
        Get the observations.

        Returns
        -------
        observations : :class:`~openturns.Sample`
            The *observations* argument provided to :meth:`setLikelihood`
        """
        return _bayesian.MetropolisHastingsImplementation_getObservations(self)

    def getCovariates(self):
        r"""
        Get the parameters.

        Returns
        -------
        parameters : :class:`~openturns.Point`
            Fixed parameters of the model :math:`g` required to define the likelihood.
        """
        return _bayesian.MetropolisHastingsImplementation_getCovariates(self)

    def setHistory(self, strategy):
        r"""
        Set the history storage.

        Parameters
        ----------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian.MetropolisHastingsImplementation_setHistory(self, strategy)

    def getHistory(self):
        r"""
        Get the history storage.

        Returns
        -------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian.MetropolisHastingsImplementation_getHistory(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _bayesian.MetropolisHastingsImplementation_getDimension(self)

    def setVerbose(self, verbose):
        return _bayesian.MetropolisHastingsImplementation_setVerbose(self, verbose)

    def getVerbose(self):
        return _bayesian.MetropolisHastingsImplementation_getVerbose(self)

    def getAcceptanceRate(self):
        r"""
        Get acceptance rate.

        Returns
        -------
        acceptanceRate : float
            Global acceptance rates over all the MCMC iterations performed.
        """
        return _bayesian.MetropolisHastingsImplementation_getAcceptanceRate(self)

    def __init__(self, *args):
        _bayesian.MetropolisHastingsImplementation_swiginit(self, _bayesian.new_MetropolisHastingsImplementation(*args))
    __swig_destroy__ = _bayesian.delete_MetropolisHastingsImplementation

# Register MetropolisHastingsImplementation in _bayesian:
_bayesian.MetropolisHastingsImplementation_swigregister(MetropolisHastingsImplementation)
class _MetropolisHastingsImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _bayesian._MetropolisHastingsImplementationTypedInterfaceObject_swiginit(self, _bayesian.new__MetropolisHastingsImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _bayesian._MetropolisHastingsImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _bayesian._MetropolisHastingsImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _bayesian._MetropolisHastingsImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _bayesian._MetropolisHastingsImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _bayesian._MetropolisHastingsImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _bayesian.delete__MetropolisHastingsImplementationTypedInterfaceObject

# Register _MetropolisHastingsImplementationTypedInterfaceObject in _bayesian:
_bayesian._MetropolisHastingsImplementationTypedInterfaceObject_swigregister(_MetropolisHastingsImplementationTypedInterfaceObject)
class MetropolisHastingsCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _bayesian.delete_MetropolisHastingsCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _bayesian.MetropolisHastingsCollection_clear(self)

    def __len__(self):
        return _bayesian.MetropolisHastingsCollection___len__(self)

    def __eq__(self, rhs):
        return _bayesian.MetropolisHastingsCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _bayesian.MetropolisHastingsCollection___contains__(self, val)

    def select(self, marginalIndices):
        r"""
        Selection from indices.

        Parameters
        ----------
        indices : sequence of int
            Indices to select

        Returns
        -------
        coll : sequence
            Sub-collection of values at the selection indices.
        """
        return _bayesian.MetropolisHastingsCollection_select(self, marginalIndices)

    def __getitem__(self, i):
        return _bayesian.MetropolisHastingsCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _bayesian.MetropolisHastingsCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _bayesian.MetropolisHastingsCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _bayesian.MetropolisHastingsCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _bayesian.MetropolisHastingsCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _bayesian.MetropolisHastingsCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _bayesian.MetropolisHastingsCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _bayesian.MetropolisHastingsCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurrence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _bayesian.MetropolisHastingsCollection_find(self, val)

    def __repr__(self):
        return _bayesian.MetropolisHastingsCollection___repr__(self)

    def __str__(self, *args):
        return _bayesian.MetropolisHastingsCollection___str__(self, *args)

    def __init__(self, *args):
        _bayesian.MetropolisHastingsCollection_swiginit(self, _bayesian.new_MetropolisHastingsCollection(*args))

# Register MetropolisHastingsCollection in _bayesian:
_bayesian.MetropolisHastingsCollection_swigregister(MetropolisHastingsCollection)
class MetropolisHastings(_MetropolisHastingsImplementationTypedInterfaceObject):
    r"""
    Base class for Metropolis-Hastings algorithms.

    Refer to :ref:`bayesian_calibration`, :ref:`metropolis_hastings`.

    Notes
    -----
    Metropolis-Hastings algorithms are Markov Chain Monte-Carlo algorithms:
    they can sample from a target distribution
    defined as having a PDF proportional to some known function.

    If :meth:`setLikelihood` is used,
    then a likelihood factor is applied to the PDF of the target distribution:
    in Bayesian terms, the initially targeted distribution is the prior,
    and multiplying its PDF by the likelihood yields the PDF of the posterior
    up to a multiplicative constant.

    See Also
    --------
    RandomWalkMetropolisHastings
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.MetropolisHastings_getClassName(self)

    def getRealization(self):
        r"""
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _bayesian.MetropolisHastings_getRealization(self)

    def getTargetDistribution(self):
        r"""
        Get the target distribution.

        Returns
        -------
        targetDistribution : :class:`~openturns.Distribution`
            The *targetDistribution* argument provided to the constructor
        """
        return _bayesian.MetropolisHastings_getTargetDistribution(self)

    def getTargetLogPDF(self):
        r"""
        Get the target log-pdf.

        Returns
        -------
        targetLogPDF : :class:`~openturns.Function`
            The *targetLogPDF* argument provided to the constructor
        """
        return _bayesian.MetropolisHastings_getTargetLogPDF(self)

    def getTargetLogPDFSupport(self):
        r"""
        Get the target log-pdf support.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The *support* argument provided to the constructor
        """
        return _bayesian.MetropolisHastings_getTargetLogPDFSupport(self)

    def getInitialState(self):
        r"""
        Get the initial state.

        Returns
        -------
        initialState : sequence of float
            Initial state of the chain
        """
        return _bayesian.MetropolisHastings_getInitialState(self)

    def getMarginalIndices(self):
        return _bayesian.MetropolisHastings_getMarginalIndices(self)

    def setHistory(self, strategy):
        r"""
        Set the history storage.

        Parameters
        ----------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian.MetropolisHastings_setHistory(self, strategy)

    def getHistory(self):
        r"""
        Get the history storage.

        Returns
        -------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian.MetropolisHastings_getHistory(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _bayesian.MetropolisHastings_getDimension(self)

    def setLikelihood(self, *args):
        r"""
        Set the likelihood.

        Parameters
        ----------
        conditional : :class:`~openturns.Distribution`
            Required distribution to define the likelihood of the underlying Bayesian
            statistical model.
        observations : 2-d sequence of float
            Observations :math:`\vect y^i` required to define the likelihood.
        linkFunction : :class:`~openturns.Function`, optional
            Function :math:`g` that maps the chain into the conditional distribution parameters.
            If provided, its input dimension must match the chain dimension and its
            output dimension must match the conditional distribution parameter dimension.
            Else it is set to the identity.
        covariates : 2-d sequence of float, optional
            Parameters :math:`\vect c^i` of the linkFunction for each observation :math:`\vect y^i`.
            If provided, their dimension must match the parameter dimension of *linkFunction*.

        Notes
        -----
        Once this method is called, the class no longer samples from the distribution *targetDistribution*
        or from the distribution defined by *targetLogPDF* and *support*,
        but considers that distribution as being the prior.
        Let :math:`\pi(\vect \theta)` be the PDF of the prior at the point :math:`\vect \theta`.
        The class now samples from the posterior, whose PDF is proportional to :math:`L(\vect\theta) \, \pi(\vect\theta)`,
        the likelihood :math:`L(\vect \theta)` being defined from the arguments of this method.

        The optional parameters *linkFunction* and *covariates* allow several options to define the likelihood :math:`L(\vect \theta)`.
        Letting :math:`f` be the PDF of the distribution *conditional*:

        - Without *linkFunction* and *covariates* the likelihood term reads:

            .. math:: L(\vect \theta) = \prod_{i=1}^n f(\vect{y}^i|\vect{\theta})

        - If only the *linkFunction* is provided:

            .. math:: L(\vect \theta) = \prod_{i=1}^n f(\vect{y}^i|g(\vect{\theta}))

        - If both the *linkFunction* and *covariates* are provided:

            .. math:: L(\vect \theta) = \prod_{i=1}^n f(\vect{y}^i|g_{\vect c^i}(\vect{\theta}))

        """
        return _bayesian.MetropolisHastings_setLikelihood(self, *args)

    def getConditional(self):
        r"""
        Get the *conditional* distribution.

        Returns
        -------
        conditional : :class:`~openturns.Distribution`
            The *conditional* argument provided to :meth:`setLikelihood`
        """
        return _bayesian.MetropolisHastings_getConditional(self)

    def getLinkFunction(self):
        r"""
        Get the model.

        Returns
        -------
        linkFunction : :class:`~openturns.Function`
            The *linkFunction* argument provided to :meth:`setLikelihood`
        """
        return _bayesian.MetropolisHastings_getLinkFunction(self)

    def getObservations(self):
        r"""
        Get the observations.

        Returns
        -------
        observations : :class:`~openturns.Sample`
            The *observations* argument provided to :meth:`setLikelihood`
        """
        return _bayesian.MetropolisHastings_getObservations(self)

    def getCovariates(self):
        r"""
        Get the parameters.

        Returns
        -------
        parameters : :class:`~openturns.Point`
            Fixed parameters of the model :math:`g` required to define the likelihood.
        """
        return _bayesian.MetropolisHastings_getCovariates(self)

    def computeLogLikelihood(self, state):
        r"""
        Compute the logarithm of the likelihood w.r.t. observations.

        Parameters
        ----------
        currentState : sequence of float
            Current state.

        Returns
        -------
        logLikelihood : float
            Logarithm of the likelihood w.r.t. observations
            :math:`(\vect{y}^1, \dots, \vect{y}^n)`.
        """
        return _bayesian.MetropolisHastings_computeLogLikelihood(self, state)

    def computeLogPosterior(self, currentState):
        r"""
        Compute the logarithm of the unnormalized posterior density.

        Parameters
        ----------
        currentState : sequence of float
            Current state.

        Returns
        -------
        logPosterior : float
            Target log-PDF plus log-likelihood if the log-likelihood is defined
        """
        return _bayesian.MetropolisHastings_computeLogPosterior(self, currentState)

    def getAcceptanceRate(self):
        r"""
        Get acceptance rate.

        Returns
        -------
        acceptanceRate : float
            Global acceptance rates over all the MCMC iterations performed.
        """
        return _bayesian.MetropolisHastings_getAcceptanceRate(self)

    def __init__(self, *args):
        _bayesian.MetropolisHastings_swiginit(self, _bayesian.new_MetropolisHastings(*args))
    __swig_destroy__ = _bayesian.delete_MetropolisHastings

# Register MetropolisHastings in _bayesian:
_bayesian.MetropolisHastings_swigregister(MetropolisHastings)
class NonLinearLeastSquaresCalibration(CalibrationAlgorithmImplementation):
    r"""
    Non-linear least-squares calibration algorithm.

    Parameters
    ----------
    model : :class:`~openturns.Function`
        The parametric function to be calibrated.
    inputObservations : 2-d sequence of float
        The sample of input observations.
        Can have dimension 0 to specify no observations.
    outputObservations : 2-d sequence of float
        The sample of output observations.
    startingPoint : sequence of float
        The reference value of the parameter, used as the starting point
        of the optimization.

    Notes
    -----
    NonLinearLeastSquaresCalibration is the minimum variance estimator of the parameter 
    of a given model with no assumption on the dependence of the model with respect 
    to the parameter.

    The prior distribution of the parameter is a noninformative prior
    emulated using a flat :class:`~openturns.Normal` centered on the `startingPoint` and with a variance equal to SpecFunc.MaxScalar.

    The posterior distribution of the parameter is :class:`~openturns.Normal` and reflects the 
    variability of the optimum parameter depending on the observation sample. 
    By default, the posterior distribution is evaluated based on a linear approximation 
    of the model at the optimum. 
    This corresponds to using the :class:`~openturns.LinearLeastSquaresCalibration` at the optimum, 
    and is named *Laplace approximation* in the Bayesian context. 
    However, if the key `NonLinearLeastSquaresCalibration-BootstrapSize` in the :class:`~openturns.ResourceMap` 
    is set to a nonzero positive integer, then a bootstrap resampling of the observations 
    is performed and the posterior distribution is based on a :class:`~openturns.KernelSmoothing` 
    of the sample of boostrap optimum parameters. 

    The resulting distribution of the output error is a :class:`~openturns.Normal` and is 
    computed from the residuals. 

    If least squares optimization algorithms are enabled, then the algorithm used is the
    first found by `Build` of :class:`~openturns.OptimizationAlgorithm`.
    Otherwise, the algorithm :class:`~openturns.TNC` is used combined with
    a multistart algorithm which makes use of the `NonLinearLeastSquaresCalibration-MultiStartSize`
    key in the :class:`~openturns.ResourceMap`.

    Please read :ref:`code_calibration` for more details.

    See also
    --------
    GaussianLinearCalibration, LinearLeastSquaresCalibration, GaussianNonLinearCalibration

    Examples
    --------
    Calibrate a nonlinear model using non-linear least-squares:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> m = 10
    >>> x = [[0.5 + i] for i in range(m)]
    >>> inVars = ['a', 'b', 'c', 'x']
    >>> formulas = ['a + b * exp(c * x)']
    >>> model = ot.SymbolicFunction(inVars, formulas)
    >>> p_ref = [2.8, 1.2, 0.5]
    >>> params = [0, 1, 2]
    >>> modelX = ot.ParametricFunction(model, params, p_ref)
    >>> y = modelX(x)
    >>> y += ot.Normal(0.0, 0.05).getSample(m)
    >>> startingPoint = [1.0]*3
    >>> algo = ot.NonLinearLeastSquaresCalibration(modelX, x, y, startingPoint)
    >>> algo.run()
    >>> print(algo.getResult().getParameterMAP())
    [2.773...,1.203...,0.499...]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.NonLinearLeastSquaresCalibration_getClassName(self)

    def __repr__(self):
        return _bayesian.NonLinearLeastSquaresCalibration___repr__(self)

    def run(self, *args):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_run(self, *args)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the optimization algorithm used for the computation.

        Returns
        -------
        algo : :class:`~openturns.OptimizationAlgorithm`
            Optimization algorithm used for the computation.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, algorithm):
        r"""
        Accessor to the optimization algorithm used for the computation.

        Parameters
        ----------
        algo : :class:`~openturns.OptimizationAlgorithm`
            Optimization algorithm to use for the computation.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_setOptimizationAlgorithm(self, algorithm)

    def getStartingPoint(self):
        r"""
        Accessor to the parameter `startingPoint`.

        Returns
        -------
        startingPoint : :class:`~openturns.Point`
            Parameter startingPoint.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_getStartingPoint(self)

    def getBootstrapSize(self):
        r"""
        Accessor to the bootstrap size used to sample the posterior distribution.

        Returns
        -------
        size : int
            Bootstrap size used to sample the posterior distribution. A value of 0
            means that no bootstrap has been done but a linear approximation has
            been used to get the posterior distribution, using the :class:`~openturns.GaussianLinearCalibration`
            algorithm at the maximum a posteriori estimate.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Accessor to the bootstrap size used to sample the posterior distribution.

        Parameters
        ----------
        size : int
            Bootstrap size used to sample the posterior distribution. A value of 0
            means that no bootstrap has to be done but a linear approximation has
            been used to get the posterior distribution, using the :class:`~openturns.GaussianLinearCalibration`
            algorithm at the maximum a posteriori estimate.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_setBootstrapSize(self, bootstrapSize)

    @staticmethod
    def BuildResidualFunction(model, inputObservations, outputObservations):
        r"""
        Build a residual function given a parametric model, input and output observations.

        Parameters
        ----------
        model : :class:`~openturns.Function`
            Parametric model.
        inputObservations : 2-d sequence of float
            Input observations associated to the output observations.
        outputObservations : :class:`~openturns.Function`
            Output observations.

        Returns
        -------
        residual : :class:`~openturns.Function`
        Residual function.

        Notes
        -----
        Given a parametric model :math:`F_{\theta}:\Rset^n\rightarrow\Rset^p` with
        parameter :math:`\theta\in\Rset^m`, a sample of input points
        :math:`(x_i)_{i=1,\dots,N}` and the associated output
        :math:`(y_i)_{i=1,\dots,N}`, the residual function :math:`f` is defined by:

        .. math::

            \forall \theta\in\Rset^m, f(\theta)=\left(\begin{array}{c}
            F_{\theta}(x_1)-y_1 \\
            \vdots \\
            F_{\theta}(x_N)-y_N
            \end{array}
            \right)


        """
        return _bayesian.NonLinearLeastSquaresCalibration_BuildResidualFunction(model, inputObservations, outputObservations)

    def __init__(self, *args):
        _bayesian.NonLinearLeastSquaresCalibration_swiginit(self, _bayesian.new_NonLinearLeastSquaresCalibration(*args))
    __swig_destroy__ = _bayesian.delete_NonLinearLeastSquaresCalibration

# Register NonLinearLeastSquaresCalibration in _bayesian:
_bayesian.NonLinearLeastSquaresCalibration_swigregister(NonLinearLeastSquaresCalibration)
class GaussianNonLinearCalibration(CalibrationAlgorithmImplementation):
    r"""
    Gaussian non linear calibration algorithm (3DVAR).

    Parameters
    ----------
    model : :class:`~openturns.Function`
        The parametric function to be calibrated.
    inputObservations : 2-d sequence of float
        The sample of input observations.
        Can have dimension 0 to specify no observations.
    outputObservations : 2-d sequence of float
        The sample of output observations.
    parameterMean : sequence of float
        The mean of the Gaussian prior distribution of the parameter.
    parameterCovariance : 2-d sequence of float
        The covariance matrix of the Gaussian prior distribution of the parameter.
    errorCovariance : 2-d sequence of float
        The covariance matrix of the Gaussian distribution of the observations error.

    Notes
    -----
    This class implements the Maximum A Posteriori (MAP) estimator for a nonlinear model
    under the Bayesian hypothesis that the prior and the observation errors have Gaussian distributions. 
    This algorithm is also known as *3DVAR*. 

    The given observation error covariance can be either *local*,
    i.e. the same matrix applies for each observation and is of dimension the output
    dimension of the model, or *global*, i.e. the matrix describes the full set of
    observation errors, in which case its dimension is the product of the output
    dimension of the model and the number of observations.

    The prior distribution of the parameter is :class:`~openturns.Normal`.  

    The posterior distribution of the parameter is also :class:`~openturns.Normal`.

    Depending on the value of the `GaussianNonLinearCalibration-BootstrapSize` key 
    in the :class:`~openturns.ResourceMap`, the parameters are estimated differently.

    - If `GaussianNonLinearCalibration-BootstrapSize`
      is set to a nonzero positive integer, then a bootstrap resampling of the observations
      is performed and the posterior distribution is based on a :class:`~openturns.KernelSmoothing`
      of the sample of boostrap optimum parameters.
    - If `GaussianNonLinearCalibration-BootstrapSize`
      is set to zero, then the posterior distribution is
      evaluated based on a linear approximation of the model at the optimum. 
      This corresponds to using :class:`~openturns.GaussianLinearCalibration` at the optimum,
      and is named *Laplace approximation* in the Bayesian context.

    The default value of `GaussianNonLinearCalibration-BootstrapSize` is nonzero, 
    meaning that a bootstrap is used by default.
    This can be costly in some practical use cases, because it requires
    several runs of the optimization algorithm.
    In this case, please set the bootstrap size to zero.

    The resulting error distribution is :class:`~openturns.Normal`
    with a mean estimated from the sample mean of the residuals and with a
    covariance matrix equal to the `errorCovariance` input argument.

    Please read read :ref:`gaussian_calibration` for more details
    on Gaussian calibration.

    See also
    --------
    GaussianLinearCalibration, LinearLeastSquaresCalibration, NonLinearLeastSquaresCalibration

    Examples
    --------
    Calibrate a nonlinear model using 3DVAR:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> m = 10
    >>> x = [[0.5 + i] for i in range(m)]
    >>> inVars = ['a', 'b', 'c', 'x']
    >>> formulas = ['a + b * exp(c * x)']
    >>> model = ot.SymbolicFunction(inVars, formulas)
    >>> p_ref = [2.8, 1.2, 0.5]
    >>> params = [0, 1, 2]
    >>> modelX = ot.ParametricFunction(model, params, p_ref)
    >>> y = modelX(x)
    >>> y += ot.Normal(0.0, 0.05).getSample(m)
    >>> parameterMean = [1.0]*3
    >>> priorCovariance = ot.CovarianceMatrix(3)
    >>> errorCovariance = ot.CovarianceMatrix(1, [0.1])
    >>> algo = ot.GaussianNonLinearCalibration(modelX, x, y, parameterMean, priorCovariance, errorCovariance)
    >>> algo.run()
    >>> print(algo.getResult().getParameterMAP())
    [2.705...,1.212...,0.499...]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.GaussianNonLinearCalibration_getClassName(self)

    def __repr__(self):
        return _bayesian.GaussianNonLinearCalibration___repr__(self)

    def run(self, *args):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.GaussianNonLinearCalibration_run(self, *args)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the optimization algorithm used for the computation.

        Returns
        -------
        algo : :class:`~openturns.OptimizationAlgorithm`
            Optimization algorithm used for the computation.
        """
        return _bayesian.GaussianNonLinearCalibration_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, algorithm):
        r"""
        Accessor to the optimization algorithm used for the computation.

        Parameters
        ----------
        algo : :class:`~openturns.OptimizationAlgorithm`
            Optimization algorithm to use for the computation.
        """
        return _bayesian.GaussianNonLinearCalibration_setOptimizationAlgorithm(self, algorithm)

    def getParameterMean(self):
        r"""
        Accessor to the parameter `parameterMean`.

        Returns
        -------
        parameterMean : :class:`~openturns.Point`
            Parameter `parameterMean`.
        """
        return _bayesian.GaussianNonLinearCalibration_getParameterMean(self)

    def getParameterCovariance(self):
        r"""
        Accessor to the parameter prior covariance.

        Returns
        -------
        prior : :class:`~openturns.CovarianceMatrix`
            Parameter prior covariance.
        """
        return _bayesian.GaussianNonLinearCalibration_getParameterCovariance(self)

    def getErrorCovariance(self):
        r"""
        Accessor to the observation error covariance.

        Returns
        -------
        error : :class:`~openturns.CovarianceMatrix`
            Observation error covariance.
        """
        return _bayesian.GaussianNonLinearCalibration_getErrorCovariance(self)

    def getGlobalErrorCovariance(self):
        r"""
        Accessor to the flag for a global observation error covariance.

        Returns
        -------
        flag : bool
            Flag telling if the given observation error covariance is global or not.
        """
        return _bayesian.GaussianNonLinearCalibration_getGlobalErrorCovariance(self)

    def getBootstrapSize(self):
        r"""
        Accessor to the bootstrap size used to sample the posterior distribution.

        Returns
        -------
        size : int
            Bootstrap size used to sample the posterior distribution. A value of 0
            means that no bootstrap has been done but a linear approximation has
            been used to get the posterior distribution, using the :class:`~openturns.GaussianLinearCalibration`
            algorithm at the maximum a posteriori estimate.
        """
        return _bayesian.GaussianNonLinearCalibration_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Accessor to the bootstrap size used to sample the posterior distribution.

        Parameters
        ----------
        size : int
            Bootstrap size used to sample the posterior distribution. A value of 0
            means that no bootstrap has to be done but a linear approximation has
            been used to get the posterior distribution, using the :class:`~openturns.GaussianLinearCalibration`
            algorithm at the maximum a posteriori estimate.
        """
        return _bayesian.GaussianNonLinearCalibration_setBootstrapSize(self, bootstrapSize)

    def __init__(self, *args):
        _bayesian.GaussianNonLinearCalibration_swiginit(self, _bayesian.new_GaussianNonLinearCalibration(*args))
    __swig_destroy__ = _bayesian.delete_GaussianNonLinearCalibration

# Register GaussianNonLinearCalibration in _bayesian:
_bayesian.GaussianNonLinearCalibration_swigregister(GaussianNonLinearCalibration)
class RandomVectorMetropolisHastings(MetropolisHastingsImplementation):
    r"""
    Simple Metropolis-Hastings sampler defined from a random variable.

    Refer to :ref:`bayesian_calibration`, :ref:`metropolis_hastings`.

    Parameters
    ----------
    randomVector : :class:`~openturns.RandomVector`
        The random variable from which to update the chain
    initialState : sequence of float
        Initial state of the chain
    marginalIndices : sequence of int, optional
        Indices of the components to be updated.
        If not specified, all components are updated.
        The number of updated components must be equal to the dimension of *proposal*.
    linkFunction : :class:`~openturns.Function`, optional
        Link between the state of the chain and the parameters of *randomVector*.
        If not provided, then the parameters of *randomVector* are not updated,
        which means that samples from *randomVector* are produced independently
        from the state of the Markov chain.

    Notes
    -----
    This class creates a Markov chain from a :class:`~openturns.RandomVector`.
    It updates the parameters of the random vector
    based on the current state of the Markov chain,
    gets a realization from the random vector with the updated parameters,
    and then uses it to update the Markov chain.

    If no likelihood is set with the :meth:`setLikelihood` method,
    then it can be viewed as trivial Metropolis-Hastings algorithm
    where the proposal distribution is equal to the target distribution,
    so the Metropolis-Hastings ratio is always equal to 1
    and the candidate is always accepted.

    If a likelihood is set, then the Metropolis-Hastings ratio
    is the ratio of the likelihoods of the new and of the current state.

    See Also
    --------
    Gibbs, RandomWalkMetropolisHastings

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)

    Build a random vector and choose the initial state of the Markov chain:

    >>> randomVector = ot.RandomVector(ot.Normal())
    >>> initialState = [3.0]

    We can also link the parameters of the random vector to the state of the chain,
    Let us link the parameters of the random vector to the state of the chain.
    Here the parameters of the random vector are the parameters of its distribution:

    >>> linkFunction = ot.SymbolicFunction(['x'], ['x', '0.1'])

    The link function makes the first parameter of the normal distribution (the mean)
    equal to the current value of the Markov chain.
    Its standard deviation remains constant: :math:`0.1`.
    That way we construct a random walk with normal steps of standard deviation :math:`0.1`.

    >>> sampler = ot.RandomVectorMetropolisHastings(randomVector, initialState, [0], linkFunction)
    >>> x = sampler.getSample(10)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.RandomVectorMetropolisHastings_getClassName(self)

    def __repr__(self):
        return _bayesian.RandomVectorMetropolisHastings___repr__(self)

    def setRandomVector(self, randomVector):
        r"""
        Random vector accessor.

        Parameters
        ----------
        randomVector : :class:`~openturns.RandomVector`
            The random variable from which to update the chain
        """
        return _bayesian.RandomVectorMetropolisHastings_setRandomVector(self, randomVector)

    def getRandomVector(self):
        r"""
        Random vector accessor.

        Returns
        -------
        randomVector : :class:`~openturns.RandomVector`
            The random variable from which to update the chain
        """
        return _bayesian.RandomVectorMetropolisHastings_getRandomVector(self)

    def __init__(self, *args):
        _bayesian.RandomVectorMetropolisHastings_swiginit(self, _bayesian.new_RandomVectorMetropolisHastings(*args))
    __swig_destroy__ = _bayesian.delete_RandomVectorMetropolisHastings

# Register RandomVectorMetropolisHastings in _bayesian:
_bayesian.RandomVectorMetropolisHastings_swigregister(RandomVectorMetropolisHastings)
class RandomWalkMetropolisHastings(MetropolisHastingsImplementation):
    r"""
    Random Walk Metropolis-Hastings method.

    Refer to :ref:`bayesian_calibration`, :ref:`metropolis_hastings`.

    Available constructor:
        RandomWalkMetropolisHastings(*targetDistribution, initialState, proposal, marginalIndices*)

        RandomWalkMetropolisHastings(*targetLogPDF, support, initialState, proposal, marginalIndices*)

    Parameters
    ----------
    targetDistribution : :class:`~openturns.Distribution`
        Target distribution sampled
    targetLogPDF : :class:`~openturns.Function`
        Target log-density up to an additive constant
    support : :class:`~openturns.Domain`
        Support of the target when defined with *targetLogPDF*
    initialState : sequence of float
        Initial state of the chain
    proposal : :class:`~openturns.Distribution`
        Distribution of the steps of the random walk
    marginalIndices : sequence of int, optional
        Indices of the components to be updated.
        If not specified, all components are updated.
        The number of updated components must be equal to the dimension of *proposal*.

    Notes
    -----
    The random walk Metropolis-Hastings algorithm
    is a Markov Chain Monte-Carlo algorithm.
    It draws candidates for the
    next state of the chain as follows: denoting the current state by
    :math:`\vect{\theta}^k`, the candidate :math:`\vect{c}^k` for
    :math:`\vect{\theta}^{k+1}` can be expressed as
    :math:`\vect{c}^k = \vect{\theta}^k +\vect{\delta}^k` where the
    distribution of :math:`\vect{\delta}^k` is the provided *proposal* distribution.

    See Also
    --------
    Gibbs, RandomVectorMetropolisHastings

    Examples
    --------
    >>> import openturns as ot
    >>> import math as m
    >>> ot.RandomGenerator.SetSeed(0)

    Sample from a target distribution defined through its log-PDF (defined up to some additive constant) and its support:

    >>> log_density = ot.SymbolicFunction('x', 'log(2 + sin(x)^2) - (2 + cos(3*x)^3 + sin(2*x)^3) * x')
    >>> support = ot.Interval([0.0], [2.0 * m.pi])
    >>> proposal = ot.Normal(0.0, 2.0)
    >>> initialState = [3.0]
    >>> sampler = ot.RandomWalkMetropolisHastings(log_density, support, initialState, proposal)
    >>> x = sampler.getSample(10)

    The target distribution can also be a :class:`~openturns.Distribution`.
    Since all :class:`~openturns.Distribution` objects have a :meth:`~openturns.Distribution.getSample`
    method, this is only useful in Bayesian settings where we also define a likelihood.
    The likelihood function penalizes the initially provided target distribution (now viewed as the *prior*)
    in order to get the *posterior* distribution.
    We sample from the posterior.

    >>> prior = ot.ComposedDistribution([ot.Uniform(-100.0, 100.0)] * 2)
    >>> proposal = ot.Normal([0.0] * 2, [0.5, 0.05], ot.IdentityMatrix(2))
    >>> initialState = [0.0] * 2
    >>> sampler = ot.RandomWalkMetropolisHastings(prior, initialState, proposal)
    >>> conditional = ot.Bernoulli()
    >>> data = ot.Sample([[53, 1], [57, 1], [58, 1], [63, 1], [66, 0], [67, 0],
    ... [67, 0], [67, 0], [68, 0], [69, 0], [70, 0], [70, 0], [70, 1], [70, 1],
    ... [72, 0], [73, 0], [75, 0], [75, 1], [76, 0], [76, 0], [78, 0], [79, 0], [81, 0]])
    >>> observations = data[:, 1]
    >>> covariates = data[:, 0]
    >>> fun = ot.SymbolicFunction(['alpha', 'beta', 'x'], ['exp(alpha + beta * x) / (1 + exp(alpha + beta * x))'])
    >>> linkFunction = ot.ParametricFunction(fun, [2], [0.0])
    >>> sampler.setLikelihood(conditional, observations, linkFunction, covariates)
    >>> alpha_beta = sampler.getSample(10)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.RandomWalkMetropolisHastings_getClassName(self)

    def __repr__(self):
        return _bayesian.RandomWalkMetropolisHastings___repr__(self)

    def setProposal(self, proposal):
        r"""
        Set the proposal distribution.

        Parameters
        ----------
        proposal : :class:`~openturns.Distribution`
            The distribution from which the transition kernels of the random walk
            Metropolis-Hastings algorithm is defined
        """
        return _bayesian.RandomWalkMetropolisHastings_setProposal(self, proposal)

    def getProposal(self):
        r"""
        Get the proposal distribution.

        Returns
        -------
        proposal : :class:`~openturns.Distribution`
            The distribution from which the transition kernels of the random walk
            Metropolis-Hastings algorithm is defined
        """
        return _bayesian.RandomWalkMetropolisHastings_getProposal(self)

    def setBurnIn(self, burnIn):
        r"""
        Set the length of the burn-in period.

        Parameters
        ----------
        burnin : int
            Length of the burn-in period: this is
            the number of iterations after which adaptation stops.
        """
        return _bayesian.RandomWalkMetropolisHastings_setBurnIn(self, burnIn)

    def getBurnIn(self):
        r"""
        Get the length of the burn-in period.

        Returns
        -------
        burnin : int
            Length of the burn-in period: this is
            the number of iterations after which adaptation stops.
        """
        return _bayesian.RandomWalkMetropolisHastings_getBurnIn(self)

    def setAdaptationRange(self, range):
        r"""
        Set the expected range for the acceptance rate.
        During burn-in, at the end of every adaptation period,
        if the acceptance rate does not belong to this range,
        the adaptation factor is multiplied
        either by the expansion factor
        (if the acceptance rate is larger than the *upperBound*)
        or by the shrink factor
        (if the acceptance rate is smaller than the *lowerBound*).

        Parameters
        ----------
        range : :class:`~openturns.Interval` of dimension 1
            Range [*lowerBound*, *upperBound*] of the expected acceptance rate.
        """
        return _bayesian.RandomWalkMetropolisHastings_setAdaptationRange(self, range)

    def getAdaptationRange(self):
        r"""
        Get the expected range for the acceptance rate.
        During burn-in, at the end of every adaptation period,
        if the acceptance rate does not belong to this range,
        the adaptation factor is multiplied
        either by the expansion factor
        (if the acceptance rate is larger than the *upperBound*)
        or by the shrink factor
        (if the acceptance rate is smaller than the *lowerBound*).

        Returns
        -------
        range : :class:`~openturns.Interval` of dimension 1
            Range [*lowerBound*, *upperBound*] of the expected acceptance rate.
        """
        return _bayesian.RandomWalkMetropolisHastings_getAdaptationRange(self)

    def setAdaptationExpansionFactor(self, expansionFactor):
        r"""
        Set the adaptation expansion factor.

        Parameters
        ----------
        expansionFactor : float, :math:`e > 1`
            Expansion factor :math:`e` of the adaptation factor.
        """
        return _bayesian.RandomWalkMetropolisHastings_setAdaptationExpansionFactor(self, expansionFactor)

    def getAdaptationExpansionFactor(self):
        r"""
        Get the adaptation expansion factor.

        Returns
        -------
        expansionFactor : float
            Expansion factor :math:`e` of the adaptation factor.
        """
        return _bayesian.RandomWalkMetropolisHastings_getAdaptationExpansionFactor(self)

    def setAdaptationShrinkFactor(self, shrinkFactor):
        r"""
        Set the adaptation shrink factor.

        Parameters
        ----------
        shrinkFactor : float, :math:`0 < s < 1`
            Shrink factor :math:`s` of the adaptation factor.
        """
        return _bayesian.RandomWalkMetropolisHastings_setAdaptationShrinkFactor(self, shrinkFactor)

    def getAdaptationShrinkFactor(self):
        r"""
        Get the adaptation shrink factor.

        Returns
        -------
        shrinkFactor : float
            Shrink factor :math:`s` of the adaptation factor.
        """
        return _bayesian.RandomWalkMetropolisHastings_getAdaptationShrinkFactor(self)

    def setAdaptationPeriod(self, period):
        r"""
        Set the adaptation period.

        Parameters
        ----------
        period : positive int
            During burn-in, adaptation is performed once every *period* iterations.
        """
        return _bayesian.RandomWalkMetropolisHastings_setAdaptationPeriod(self, period)

    def getAdaptationPeriod(self):
        r"""
        Get the adaptation step.

        Returns
        -------
        period : positive int
            During burn-in, adaptation is performed once every *period* iterations.
        """
        return _bayesian.RandomWalkMetropolisHastings_getAdaptationPeriod(self)

    def getAdaptationFactor(self):
        r"""
        Get the adaptation factor.

        Returns
        -------
        factor : float
            Current adaptation factor, for inspection.
        """
        return _bayesian.RandomWalkMetropolisHastings_getAdaptationFactor(self)

    def __init__(self, *args):
        _bayesian.RandomWalkMetropolisHastings_swiginit(self, _bayesian.new_RandomWalkMetropolisHastings(*args))
    __swig_destroy__ = _bayesian.delete_RandomWalkMetropolisHastings

# Register RandomWalkMetropolisHastings in _bayesian:
_bayesian.RandomWalkMetropolisHastings_swigregister(RandomWalkMetropolisHastings)
class IndependentMetropolisHastings(MetropolisHastingsImplementation):
    r"""
    Independent Metropolis-Hastings method.

    Refer to :ref:`bayesian_calibration`, :ref:`metropolis_hastings`.

    Available constructor:
        IndependentMetropolisHastings(*targetDistribution, initialState, proposal, marginalIndices*)

        IndependentMetropolisHastings(*targetLogPDF, support, initialState, proposal, marginalIndices*)

    Parameters
    ----------
    targetDistribution : :class:`~openturns.Distribution`
        Target distribution sampled
    targetLogPDF : :class:`~openturns.Function`
        Target log-density up to an additive constant
    support : :class:`~openturns.Domain`
        Support of the target when defined with *targetLogPDF*
    initialState : sequence of float
        Initial state of the chain
    proposal : :class:`~openturns.Distribution`
        Proposal distribution, independent from the current state
    marginalIndices : sequence of int, optional
        Indices of the components to be updated.
        If not specified, all components are updated.
        The number of updated components must be equal to the dimension of *proposal*.

    Notes
    -----
    The independent Metropolis-Hastings algorithm 
    is a Markov Chain Monte-Carlo algorithm.
    It draws candidates :math:`\vect{c}^k` for the
    next state of the chain following the user-specified *proposal* distribution.
    By construction, the proposal distribution is fixed, 
    and does not depend on the current state of the chain.
    Hence, proposals should be built as approximations to the target distribution.
    Performance of the algorithm is measured by the acceptance rate (the higher the better).

    Examples
    --------
    >>> import openturns as ot
    >>> import math as m
    >>> ot.RandomGenerator.SetSeed(0)

    Sample from a target distribution defined through its log-PDF (defined up to some additive constant) and its support:

    >>> log_density = ot.SymbolicFunction('x', 'log(2 + sin(x)^2) - (2 + cos(3*x)^3 + sin(2*x)^3) * x')
    >>> support = ot.Interval([0.0], [2.0 * m.pi])
    >>> proposal = ot.Uniform(0.0, 2.0 * m.pi)
    >>> initialState = [3.0]
    >>> sampler = ot.IndependentMetropolisHastings(log_density, support, initialState, proposal)
    >>> x = sampler.getSample(10)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.IndependentMetropolisHastings_getClassName(self)

    def __repr__(self):
        return _bayesian.IndependentMetropolisHastings___repr__(self)

    def setProposal(self, proposal):
        r"""
        Set the proposal distribution.

        Parameters
        ----------
        proposal : :class:`~openturns.Distribution`
            The distribution from which the transition kernels of the independent
            Metropolis-Hastings algorithm is defined
        """
        return _bayesian.IndependentMetropolisHastings_setProposal(self, proposal)

    def getProposal(self):
        r"""
        Get the proposal distribution.

        Returns
        -------
        proposal : :class:`~openturns.Distribution`
            The distribution from which the transition kernels of the independent
            Metropolis-Hastings algorithm is defined
        """
        return _bayesian.IndependentMetropolisHastings_getProposal(self)

    def __init__(self, *args):
        _bayesian.IndependentMetropolisHastings_swiginit(self, _bayesian.new_IndependentMetropolisHastings(*args))
    __swig_destroy__ = _bayesian.delete_IndependentMetropolisHastings

# Register IndependentMetropolisHastings in _bayesian:
_bayesian.IndependentMetropolisHastings_swigregister(IndependentMetropolisHastings)
class Gibbs(openturns.randomvector.RandomVectorImplementation):
    r"""
    Gibbs sampling method.

    Refer to :ref:`bayesian_calibration`, :ref:`metropolis_hastings`.

    Parameters
    ----------
    samplers : sequence of :class:`~openturns.MetropolisHastings`
        List of samplers for each bloc of the chain

    Notes
    -----
    Assume we want to sample from a complicated joint distribution.
    The Gibbs algorithm is a Markov Chain Monte-Carlo algorithm
    which calls samplers (implemented as :class:`~openturns.MetropolisHastings` objects)
    in a predetermined sequence (by default)
    or randomly: see :meth:`setUpdatingMethod` to manually choose the behavior,
    and note the default behavior can be changed by setting the
    `Gibbs-DefaultUpdatingMethod` :class:`~openturns.ResourceMap` key.
    Each sampler samples from the conditional distributions of one or several components.

    See Also
    --------
    RandomWalkMetropolisHastings, RandomVectorMetropolisHastings

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> chainDim = 3
    >>> # Observations
    >>> obsDim = 1
    >>> obsSize = 10
    >>> y = [-9.50794871493506, -3.83296694500105, -2.44545713047953,
    ...      0.0803625289211318, 1.01898069723583, 0.661725805623086,
    ...      -1.57581204592385, -2.95308465670895, -8.8878164296758,
    ...      -13.0812290405651]
    >>> y_obs = ot.Sample([[yi] for yi in y])
    >>> # Parameters
    >>> covariates = ot.Sample(obsSize, chainDim)
    >>> for i in range(obsSize):
    ...     for j in range(chainDim):
    ...         covariates[i, j] = (-2 + 5.0 * i / 9.0) ** j
    >>> # Model
    >>> fullModel = ot.SymbolicFunction(
    ...          ['p1', 'p2', 'p3', 'x1', 'x2', 'x3'],
    ...          ['p1*x1+p2*x2+p3*x3', '1.0'])
    >>> parametersSet = range(chainDim)
    >>> parametersValue = [0.0] * len(parametersSet) # 0.0 is a placeholder
    >>> linkFunction = ot.ParametricFunction(fullModel, parametersSet, parametersValue)
    >>> # Calibration parameters
    >>> # Proposal distribution
    >>> prop = ot.Uniform(-1.0, 1.0)
    >>> # Prior distribution
    >>> sigma0 = [10.0]*chainDim
    >>> #  Covariance matrix
    >>> Q0_inv = ot.CorrelationMatrix(chainDim)
    >>> for i in range(chainDim): 
    ...     Q0_inv[i, i] = sigma0[i] * sigma0[i]
    >>> mu0 = [0.0]*chainDim
    >>> # x0 ~ N(mu0, sigma0)
    >>> prior = ot.Normal(mu0, Q0_inv)
    >>> # Conditional distribution y~N(z, 1.0)
    >>> conditional = ot.Normal()
    >>> # Create a Gibbs sampler
    >>> coll = [ot.RandomWalkMetropolisHastings(prior, mu0, prop, [i]) for i in range(chainDim)]
    >>> for mh in coll: mh.setLikelihood(conditional, y_obs, linkFunction, covariates)
    >>> sampler = ot.Gibbs(coll)
    >>> # Get a realization
    >>> mu = sampler.getRealization()
    >>> # Create a Gibbs sampler which updates one randomly chosen component at each step
    >>> sampler2 = ot.Gibbs(coll)
    >>> sampler2.setUpdatingMethod(ot.Gibbs.RANDOM_UPDATING)
    >>> mu2 = sampler2.getRealization()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.Gibbs_getClassName(self)

    def __repr__(self):
        return _bayesian.Gibbs___repr__(self)

    def getMetropolisHastingsCollection(self):
        r"""
        Get the list of Metropolis-Hastings samplers.

        Returns
        -------
        samplers : sequence of :class:`MetropolisHastings`
            List of all Metropolis-Hastings samplers used in the Gibbs algorithm
        """
        return _bayesian.Gibbs_getMetropolisHastingsCollection(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _bayesian.Gibbs_getDimension(self)
    DETERMINISTIC_UPDATING = _bayesian.Gibbs_DETERMINISTIC_UPDATING
    RANDOM_UPDATING = _bayesian.Gibbs_RANDOM_UPDATING

    def setUpdatingMethod(self, updatingMethod):
        r"""
        Set how the order of the samplers is determined.

        Available values are:

          * 0 (Gibbs.DETERMINISTIC_UPDATING): the samplers are sequentially called in the given order.

          * 1 (Gibbs.RANDOM_UPDATING): one of the samplers is randomly selected to produce the next realization.

        Note that under DETERMINISTIC_UPDATING,
        all samplers are called in the specified order every time :meth:`getRealization` is called.
        By contrast, under RANDOM_UPDATING, only one sampler is called
        by :meth:`getRealization`, and this sampler is randomly chosen among all specified samplers.

        Parameters
        ----------
        updatingMethod : int
            See above for the possible values and their meaning.
        """
        return _bayesian.Gibbs_setUpdatingMethod(self, updatingMethod)

    def getUpdatingMethod(self):
        r"""
        Get how the order of the samplers is determined.

        Available values are:

          * 0 (Gibbs.DETERMINISTIC_UPDATING): the samplers are sequentially called in the given order.

          * 1 (Gibbs.RANDOM_UPDATING): one of the samplers is randomly selected to produce the next realization.

        Refer to the :meth:`setUpdatingMethod` documentation for details.

        Returns
        -------
        updatingMethod : int
            See above for the possible values and their meaning.
        """
        return _bayesian.Gibbs_getUpdatingMethod(self)

    def getRealization(self):
        r"""
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _bayesian.Gibbs_getRealization(self)

    def getRecomputeLogPosterior(self):
        r"""
        Get the posterior recompute flags.

        Returns
        -------
        recompute : :class:`~openturns.Indices`
            Whether the posterior at the state received from the previous sampler is recomputed.
            For debug use only.
        """
        return _bayesian.Gibbs_getRecomputeLogPosterior(self)

    def setHistory(self, strategy):
        r"""
        Set the history storage.

        Parameters
        ----------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian.Gibbs_setHistory(self, strategy)

    def getHistory(self):
        r"""
        Get the history storage.

        Returns
        -------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian.Gibbs_getHistory(self)

    def __init__(self, *args):
        _bayesian.Gibbs_swiginit(self, _bayesian.new_Gibbs(*args))
    __swig_destroy__ = _bayesian.delete_Gibbs

# Register Gibbs in _bayesian:
_bayesian.Gibbs_swigregister(Gibbs)
class _MetropolisHastingsImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_bayesian._MetropolisHastingsImplementationPointer_ptr__get, _bayesian._MetropolisHastingsImplementationPointer_ptr__set)

    def __init__(self, *args):
        _bayesian._MetropolisHastingsImplementationPointer_swiginit(self, _bayesian.new__MetropolisHastingsImplementationPointer(*args))
    __swig_destroy__ = _bayesian.delete__MetropolisHastingsImplementationPointer

    def reset(self):
        return _bayesian._MetropolisHastingsImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _bayesian._MetropolisHastingsImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _bayesian._MetropolisHastingsImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _bayesian._MetropolisHastingsImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _bayesian._MetropolisHastingsImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _bayesian._MetropolisHastingsImplementationPointer_get(self)

    def getImplementation(self):
        return _bayesian._MetropolisHastingsImplementationPointer_getImplementation(self)

    def unique(self):
        return _bayesian._MetropolisHastingsImplementationPointer_unique(self)

    def use_count(self):
        return _bayesian._MetropolisHastingsImplementationPointer_use_count(self)

    def swap(self, other):
        return _bayesian._MetropolisHastingsImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getClassName(self)

    def __repr__(self):
        return _bayesian._MetropolisHastingsImplementationPointer___repr__(self)

    def getRealization(self):
        r"""
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getRealization(self)

    def computeLogLikelihood(self, state):
        r"""
        Compute the logarithm of the likelihood w.r.t. observations.

        Parameters
        ----------
        currentState : sequence of float
            Current state.

        Returns
        -------
        logLikelihood : float
            Logarithm of the likelihood w.r.t. observations
            :math:`(\vect{y}^1, \dots, \vect{y}^n)`.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_computeLogLikelihood(self, state)

    def computeLogPosterior(self, state):
        r"""
        Compute the logarithm of the unnormalized posterior density.

        Parameters
        ----------
        currentState : sequence of float
            Current state.

        Returns
        -------
        logPosterior : float
            Target log-PDF plus log-likelihood if the log-likelihood is defined
        """
        return _bayesian._MetropolisHastingsImplementationPointer_computeLogPosterior(self, state)

    def getTargetDistribution(self):
        r"""
        Get the target distribution.

        Returns
        -------
        targetDistribution : :class:`~openturns.Distribution`
            The *targetDistribution* argument provided to the constructor
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getTargetDistribution(self)

    def getTargetLogPDF(self):
        r"""
        Get the target log-pdf.

        Returns
        -------
        targetLogPDF : :class:`~openturns.Function`
            The *targetLogPDF* argument provided to the constructor
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getTargetLogPDF(self)

    def getTargetLogPDFSupport(self):
        r"""
        Get the target log-pdf support.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The *support* argument provided to the constructor
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getTargetLogPDFSupport(self)

    def getInitialState(self):
        r"""
        Get the initial state.

        Returns
        -------
        initialState : sequence of float
            Initial state of the chain
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getInitialState(self)

    def getMarginalIndices(self):
        r"""
        Get the indices of the sampled components.

        Returns
        -------
        marginalIndices : :class:`~openturns.Indices`
            The *marginalIndices* argument provided to the constructor
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getMarginalIndices(self)

    def setLikelihood(self, *args):
        r"""
        Set the likelihood.

        Parameters
        ----------
        conditional : :class:`~openturns.Distribution`
            Required distribution to define the likelihood of the underlying Bayesian
            statistical model.
        observations : 2-d sequence of float
            Observations :math:`\vect y^i` required to define the likelihood.
        linkFunction : :class:`~openturns.Function`, optional
            Function :math:`g` that maps the chain into the conditional distribution parameters.
            If provided, its input dimension must match the chain dimension and its
            output dimension must match the conditional distribution parameter dimension.
            Else it is set to the identity.
        covariates : 2-d sequence of float, optional
            Parameters :math:`\vect c^i` of the linkFunction for each observation :math:`\vect y^i`.
            If provided, their dimension must match the parameter dimension of *linkFunction*.

        Notes
        -----
        Once this method is called, the class no longer samples from the distribution *targetDistribution*
        or from the distribution defined by *targetLogPDF* and *support*,
        but considers that distribution as being the prior.
        Let :math:`\pi(\vect \theta)` be the PDF of the prior at the point :math:`\vect \theta`.
        The class now samples from the posterior, whose PDF is proportional to :math:`L(\vect\theta) \, \pi(\vect\theta)`,
        the likelihood :math:`L(\vect \theta)` being defined from the arguments of this method.

        The optional parameters *linkFunction* and *covariates* allow several options to define the likelihood :math:`L(\vect \theta)`.
        Letting :math:`f` be the PDF of the distribution *conditional*:

        - Without *linkFunction* and *covariates* the likelihood term reads:

            .. math:: L(\vect \theta) = \prod_{i=1}^n f(\vect{y}^i|\vect{\theta})

        - If only the *linkFunction* is provided:

            .. math:: L(\vect \theta) = \prod_{i=1}^n f(\vect{y}^i|g(\vect{\theta}))

        - If both the *linkFunction* and *covariates* are provided:

            .. math:: L(\vect \theta) = \prod_{i=1}^n f(\vect{y}^i|g_{\vect c^i}(\vect{\theta}))

        """
        return _bayesian._MetropolisHastingsImplementationPointer_setLikelihood(self, *args)

    def getConditional(self):
        r"""
        Get the *conditional* distribution.

        Returns
        -------
        conditional : :class:`~openturns.Distribution`
            The *conditional* argument provided to :meth:`setLikelihood`
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getConditional(self)

    def getLinkFunction(self):
        r"""
        Get the model.

        Returns
        -------
        linkFunction : :class:`~openturns.Function`
            The *linkFunction* argument provided to :meth:`setLikelihood`
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getLinkFunction(self)

    def getObservations(self):
        r"""
        Get the observations.

        Returns
        -------
        observations : :class:`~openturns.Sample`
            The *observations* argument provided to :meth:`setLikelihood`
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getObservations(self)

    def getCovariates(self):
        r"""
        Get the parameters.

        Returns
        -------
        parameters : :class:`~openturns.Point`
            Fixed parameters of the model :math:`g` required to define the likelihood.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getCovariates(self)

    def setHistory(self, strategy):
        r"""
        Set the history storage.

        Parameters
        ----------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_setHistory(self, strategy)

    def getHistory(self):
        r"""
        Get the history storage.

        Returns
        -------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getHistory(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getDimension(self)

    def setVerbose(self, verbose):
        return _bayesian._MetropolisHastingsImplementationPointer_setVerbose(self, verbose)

    def getVerbose(self):
        return _bayesian._MetropolisHastingsImplementationPointer_getVerbose(self)

    def getAcceptanceRate(self):
        r"""
        Get acceptance rate.

        Returns
        -------
        acceptanceRate : float
            Global acceptance rates over all the MCMC iterations performed.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getAcceptanceRate(self)

    def isComposite(self):
        r"""
        Accessor to know if the RandomVector is a composite one.

        Returns
        -------
        isComposite : bool
            Indicates if the RandomVector is of type Composite or not.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_isComposite(self)

    def getFrozenRealization(self, fixedPoint):
        r"""
        Compute realizations of the RandomVector.

        In the case of a :class:`~openturns.CompositeRandomVector`
        or an event of some kind, this method returns
        the value taken by the random vector if the root cause
        takes the value given as argument.

        Parameters
        ----------
        fixedPoint : :class:`~openturns.Point`
            Point chosen as the root cause of the random vector.

        Returns
        -------
        realization : :class:`~openturns.Point`
            The realization corresponding to the chosen root cause.

        See also
        --------
        getRealization
        getFrozenSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal()
        >>> randomVector = ot.RandomVector(distribution)
        >>> f = ot.SymbolicFunction('x', 'x')
        >>> compositeRandomVector = ot.CompositeRandomVector(f, randomVector)
        >>> event = ot.ThresholdEvent(compositeRandomVector, ot.Less(), 0.0)
        >>> print(event.getFrozenRealization([0.2]))
        [0]
        >>> print(event.getFrozenRealization([-0.1]))
        [1]
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getFrozenRealization(self, fixedPoint)

    def getSample(self, size):
        r"""
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getSample(self, size)

    def getFrozenSample(self, fixedSample):
        r"""
        Compute realizations of the RandomVector.

        In the case of a :class:`~openturns.CompositeRandomVector`
        or an event of some kind, this method returns
        the different values taken by the random vector when the root cause
        takes the values given as argument.

        Parameters
        ----------
        fixedSample : :class:`~openturns.Sample`
            Sample of root causes of the random vector.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample of the realizations corresponding to the chosen root causes.

        See also
        --------
        getSample
        getFrozenRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal()
        >>> randomVector = ot.RandomVector(distribution)
        >>> f = ot.SymbolicFunction('x', 'x')
        >>> compositeRandomVector = ot.CompositeRandomVector(f, randomVector)
        >>> event = ot.ThresholdEvent(compositeRandomVector, ot.Less(), 0.0)
        >>> print(event.getFrozenSample([[0.2], [-0.1]]))
            [ y0 ]
        0 : [ 0  ]
        1 : [ 1  ]
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getFrozenSample(self, fixedSample)

    def getMean(self):
        r"""
        Accessor to the mean of the RandomVector.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Mean of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMean())
        [0,0.5]
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getMean(self)

    def getCovariance(self):
        r"""
        Accessor to the covariance of the RandomVector.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getCovariance())
        [[ 1    0    ]
         [ 0    2.25 ]]
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getCovariance(self)

    def getMarginal(self, *args):
        r"""
        Get the random vector corresponding to the :math:`i^{th}` marginal component(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0\leq i < dim`
            Indicates the component(s) concerned. :math:`dim` is the dimension of the
            RandomVector.

        Returns
        -------
        vector :  :class:`~openturns.RandomVector`
            RandomVector restricted to the concerned components.

        Notes
        -----
        Let's note :math:`\vect{Y}=\Tr{(Y_1,\dots,Y_n)}` a random vector and
        :math:`I \in [1,n]` a set of indices. If :math:`\vect{Y}` is a
        :class:`~openturns.UsualRandomVector`, the subvector is defined by
        :math:`\tilde{\vect{Y}}=\Tr{(Y_i)}_{i \in I}`. If :math:`\vect{Y}` is a
        :class:`~openturns.CompositeRandomVector`, defined by
        :math:`\vect{Y}=f(\vect{X})` with :math:`f=(f_1,\dots,f_n)`,
        :math:`f_i` some scalar functions, the subvector is
        :math:`\tilde{\vect{Y}}=(f_i(\vect{X}))_{i \in I}`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMarginal(1).getRealization())
        [0.608202]
        >>> print(randomVector.getMarginal(1).getDistribution())
        Normal(mu = 0, sigma = 1)
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getMarginal(self, *args)

    def getAntecedent(self):
        r"""
        Accessor to the antecedent RandomVector in case of a composite RandomVector.

        Returns
        -------
        antecedent : :class:`~openturns.RandomVector`
            Antecedent RandomVector :math:`\vect{X}` in case of a
            :class:`~openturns.CompositeRandomVector` such as:
            :math:`\vect{Y}=f(\vect{X})`.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getAntecedent(self)

    def getFunction(self):
        r"""
        Accessor to the Function in case of a composite RandomVector.

        Returns
        -------
        function : :class:`~openturns.Function`
            Function used to define a :class:`~openturns.CompositeRandomVector` as the
            image through this function of the antecedent :math:`\vect{X}`:
            :math:`\vect{Y}=f(\vect{X})`.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getFunction(self)

    def getDistribution(self):
        r"""
        Accessor to the distribution of the RandomVector.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getDistribution())
        Normal(mu = [0,0], sigma = [1,1], R = [[ 1 0 ]
         [ 0 1 ]])
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getDistribution(self)

    def getOperator(self):
        r"""
        Accessor to the comparaison operator of the Event.

        Returns
        -------
        operator : :class:`~openturns.ComparisonOperator`
            Comparaison operator used to define the :class:`~openturns.RandomVector`.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getOperator(self)

    def getDomain(self):
        r"""
        Accessor to the domain of the Event.

        Returns
        -------
        domain : :class:`~openturns.Domain`
            Describes the domain of an event.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getDomain(self)

    def getProcess(self):
        r"""
        Get the stochastic process.

        Returns
        -------
        process : :class:`~openturns.Process`
            Stochastic process used to define the :class:`~openturns.RandomVector`.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getProcess(self)

    def getThreshold(self):
        r"""
        Accessor to the threshold of the Event.

        Returns
        -------
        threshold : float
            Threshold of the :class:`~openturns.RandomVector`.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getThreshold(self)

    def setDescription(self, description):
        r"""
        Accessor to the description of the RandomVector.

        Parameters
        ----------
        description : str or sequence of str
            Describes the components of the RandomVector.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the description of the RandomVector.

        Returns
        -------
        description : :class:`~openturns.Description`
            Describes the components of the RandomVector.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getDescription(self)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getParameterDescription(self)

    def isEvent(self):
        r"""
        Whether the random vector is an event.

        Returns
        -------
        isEvent : bool
            Whether it takes it values in {0, 1}.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_isEvent(self)

    def asComposedEvent(self):
        r"""
        If the random vector can be viewed as the composition of several :class:`~openturns.ThresholdEvent` objects,
        this method builds and returns the composition.
        Otherwise throws.

        Returns
        -------
        composed : :class:`~openturns.RandomVector`
            Composed event.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_asComposedEvent(self)

    def __eq__(self, other):
        return _bayesian._MetropolisHastingsImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _bayesian._MetropolisHastingsImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _bayesian._MetropolisHastingsImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _bayesian._MetropolisHastingsImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _bayesian._MetropolisHastingsImplementationPointer__repr_html_(self)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _bayesian._MetropolisHastingsImplementationPointer_setName(self, name)

# Register _MetropolisHastingsImplementationPointer in _bayesian:
_bayesian._MetropolisHastingsImplementationPointer_swigregister(_MetropolisHastingsImplementationPointer)

