/*=========================================================================

   Program: ParaView
   Module:  pqCheckBoxDelegate.h

   Copyright (c) 2005-2008 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2.

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "pqCoreModule.h"
#include <QStyledItemDelegate>

/**
 * Delegate for QTableView to draw a checkbox as an left-right (unchecked)
 * and top-bottom (checked) arrow.
 * The checkbox has an extra state for unchecked disabled.
 * Based on a Stack overflow answer:
 * http://stackoverflow.com/questions/3363190/qt-qtableview-how-to-have-a-checkbox-only-column
 */
class PQCORE_EXPORT pqCheckBoxDelegate : public QStyledItemDelegate
{
  Q_OBJECT

public:
  enum CheckBoxValues
  {
    NOT_EXPANDED,
    EXPANDED,
    NOT_EXPANDED_DISABLED
  };

  pqCheckBoxDelegate(QObject* parent);
  ~pqCheckBoxDelegate() override;

  void paint(
    QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index) const override;
  bool editorEvent(QEvent* event, QAbstractItemModel* model, const QStyleOptionViewItem& option,
    const QModelIndex& index) override;

private:
  Q_DISABLE_COPY(pqCheckBoxDelegate)
  struct pqInternals;
  pqInternals* Internals;
};
