/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.File;
import java.io.IOException;

public class TeXSyntaxException
extends IOException {
    private String errorTag;
    private Object[] params;
    private int lineNum = -1;
    private File file = null;
    private TeXParser parser = null;
    public static final String ERROR_BAD_PARAM = "tex.error.bad_param";
    public static final String ERROR_ILLEGAL_PARAM = "tex.error.illegal_param";
    public static final String ERROR_NO_EG = "tex.error.no_eg";
    public static final String ERROR_PAR_BEFORE_EG = "tex.error.par_before_eg";
    public static final String ERROR_UNEXPECTED_EG = "tex.error.unexpected_eg";
    public static final String ERROR_MISSING_ENDMATH = "tex.error.missing_endmath";
    public static final String ERROR_DOLLAR2_ENDED_WITH_DOLLAR = "tex.error.dollar2_ended_with_dollar";
    public static final String ERROR_NOT_FOUND = "tex.error.not_found";
    public static final String ERROR_MISSING_PARAM = "tex.error.missing_param";
    public static final String ERROR_EMPTY_STACK = "tex.error.empty_stack";
    public static final String ERROR_NOT_MATH_MODE = "tex.error.not_math_mode";
    public static final String ERROR_INVALID_ACCENT = "tex.error.invalid_accent";
    public static final String ERROR_AMBIGUOUS_MIDCS = "tex.error.ambiguous.mid_cs";
    public static final String ERROR_MISSING_CLOSING = "tex.error.missing_closing";
    public static final String ERROR_DIMEN_EXPECTED = "tex.error.dimen_expected";
    public static final String ERROR_MISSING_UNIT = "tex.error.missing_unit";
    public static final String ERROR_EXPECTED = "tex.error.expected";
    public static final String ERROR_UNDEFINED = "tex.error.undefined";
    public static final String ERROR_UNDEFINED_CHAR = "tex.error.undefined_char";
    public static final String ERROR_CS_EXPECTED = "tex.error.cs_expected";
    public static final String ERROR_NUMBER_EXPECTED = "tex.error.number_expected";
    public static final String ERROR_REGISTER_UNDEF = "tex.error.register_undef";
    public static final String ERROR_SYNTAX = "tex.error.syntax";
    public static final String ERROR_EXTRA = "tex.error.extra";
    public static final String ERROR_DOUBLE_SUBSCRIPT = "tex.error.double_subscript";
    public static final String ERROR_DOUBLE_SUPERSCRIPT = "tex.error.double_superscript";
    public static final String ERROR_MISPLACED_OMIT = "tex.error.misplaced_omit";
    public static final String ERROR_ILLEGAL_ALIGN = "tex.error.illegal_align";
    public static final String ERROR_IMPROPER_ALPHABETIC_CONSTANT = "tex.error.improper_alphabetic_constant";
    public static final String ERROR_EXTRA_OR_FORGOTTEN = "tex.error.extra_or_forgotten";
    public static final String ERROR_REGISTER_EXPECTED = "tex.error.register_expected";
    public static final String ERROR_REGISTER_EXPECTED_BUT_FOUND = "tex.error.register_expected_but_found";
    public static final String ERROR_INTERNAL_QUANTITY_EXPECTED = "tex.error.internal_quantity_expected";
    public static final String ERROR_INTERNAL_QUANTITY_EXPECTED_BUT_FOUND = "tex.error.internal_quantity_expected_but_found";
    public static final String ERROR_NUMERIC_REGISTER_EXPECTED = "tex.error.numeric_register_expected";
    public static final String ERROR_REGISTER_NOT_NUMERIC = "tex.error.register_not_numeric";
    public static final String ERROR_REGISTER_NOT_TOKEN = "tex.error.register_not_token";
    public static final String ERROR_FILE_NOT_FOUND = "tex.error.file.not.found";
    public static final String ERROR_GENERIC = "tex.error.generic";
    public static final String ERROR_UNEXPANDABLE = "tex.error.unexpandable";

    public TeXSyntaxException(TeXParser teXParser, String string, Object ... objectArray) {
        super("TeX syntax error code " + string);
        if (teXParser == null) {
            this.file = null;
            this.lineNum = -1;
        } else {
            this.file = teXParser.getCurrentFile();
            this.lineNum = teXParser.getLineNumber();
        }
        this.errorTag = string;
        this.params = objectArray;
        this.parser = teXParser;
    }

    public TeXSyntaxException(Throwable throwable, TeXParser teXParser, String string, Object ... objectArray) {
        super("TeX syntax error code " + string, throwable);
        if (teXParser == null) {
            this.file = null;
            this.lineNum = -1;
        } else {
            this.file = teXParser.getCurrentFile();
            this.lineNum = teXParser.getLineNumber();
        }
        this.errorTag = string;
        this.params = objectArray;
        this.parser = teXParser;
    }

    public TeXParser getParser() {
        return this.parser;
    }

    public String getErrorTag() {
        return this.errorTag;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setLineNumber(int n) {
        this.lineNum = n;
    }

    public int getLineNumber() {
        return this.lineNum;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getMessage(TeXApp teXApp) {
        if (teXApp == null) {
            return this.getMessage();
        }
        String string = teXApp.getMessage(this.errorTag, this.params);
        if (this.file == null && this.lineNum == -1) {
            return string;
        }
        if (this.lineNum == -1) {
            return String.format("%s: %s", this.file.getName(), string);
        }
        if (this.file == null) {
            return String.format("l.%d: %s", this.lineNum, string);
        }
        return String.format("%s:%d: %s", this.file.getName(), this.lineNum, string);
    }
}

