﻿!mod$ v1 sum:ce02af9c143b0948
!need$ ae78003ee30bd742 n mctc_env
!need$ 880c3f35e6e2ea39 n mctc_io
!need$ 9dbd3ba73b66cb81 n mctc_io_convert
!need$ caad3462fe6207cd n mctc_io_math
!need$ 8f2bb99b9e3c04c9 n dftd4_damping
!need$ 28e2c59dad977eab n dftd4_damping_rational
!need$ 7d8eadee84d1f611 n dftd4_model
!need$ d76b50e2f4eab45b n dftd4_version
module dftd4_output
use mctc_env,only:wp
use mctc_io,only:structure_type
use mctc_io_convert,only:autoaa
use mctc_io_convert,only:autokcal
use mctc_io_convert,only:autoev
use mctc_io_math,only:matinv_3x3
use dftd4_damping,only:damping_param
use dftd4_damping_rational,only:rational_damping_param
use dftd4_model,only:d4_model
use dftd4_version,only:get_dftd4_version
private::wp
private::structure_type
private::autoaa
private::autokcal
private::autoev
private::matinv_3x3
private::damping_param
private::rational_damping_param
private::d4_model
private::get_dftd4_version
private::getline
private::write_json_array
contains
subroutine ascii_atomic_radii(unit,mol,disp)
integer(4),intent(in)::unit
class(structure_type),intent(in)::mol
class(d4_model),intent(in)::disp
end
subroutine ascii_atomic_references(unit,mol,disp)
integer(4),intent(in)::unit
class(structure_type),intent(in)::mol
class(d4_model),intent(in)::disp
end
subroutine ascii_system_properties(unit,mol,disp,cn,q,c6)
integer(4),intent(in)::unit
class(structure_type),intent(in)::mol
class(d4_model),intent(in)::disp
real(8),intent(in)::cn(:)
real(8),intent(in)::q(:)
real(8),intent(in)::c6(:,:)
end
subroutine ascii_results(unit,mol,energy,gradient,sigma)
integer(4),intent(in)::unit
class(structure_type),intent(in)::mol
real(8),intent(in)::energy
real(8),intent(in),optional::gradient(:,:)
real(8),intent(in),optional::sigma(:,:)
end
subroutine ascii_pairwise(unit,mol,pair_disp2,pair_disp3)
integer(4),intent(in)::unit
class(structure_type),intent(in)::mol
real(8),intent(in)::pair_disp2(:,:)
real(8),intent(in)::pair_disp3(:,:)
end
subroutine ascii_damping_param(unit,param,method)
integer(4),intent(in)::unit
class(damping_param),intent(in)::param
character(*,1),intent(in),optional::method
end
subroutine turbomole_gradlatt(mol,fname,energy,sigma,stat)
type(structure_type),intent(in)::mol
character(*,1),intent(in)::fname
real(8),intent(in)::energy
real(8),intent(in)::sigma(1_8:3_8,1_8:3_8)
integer(4),intent(out)::stat
end
subroutine turbomole_gradient(mol,fname,energy,gradient,stat)
type(structure_type),intent(in)::mol
character(*,1),intent(in)::fname
real(8),intent(in)::energy
real(8),intent(in)::gradient(:,:)
integer(4),intent(out)::stat
end
subroutine getline(unit,line,iostat)
integer(4),intent(in)::unit
character(:,1),allocatable,intent(out)::line
integer(4),intent(out),optional::iostat
end
subroutine json_results(unit,indentation,energy,gradient,sigma,hessian,cn,q,c6,alpha,pairwise_energy2,pairwise_energy3)
integer(4),intent(in)::unit
character(*,1),intent(in),optional::indentation
real(8),intent(in),optional::energy
real(8),intent(in),optional::gradient(:,:)
real(8),intent(in),optional::sigma(:,:)
real(8),intent(in),optional::hessian(:,:,:,:)
real(8),intent(in),optional::cn(:)
real(8),intent(in),optional::q(:)
real(8),intent(in),optional::c6(:,:)
real(8),intent(in),optional::alpha(:)
real(8),intent(in),optional::pairwise_energy2(:,:)
real(8),intent(in),optional::pairwise_energy3(:,:)
end
subroutine write_json_array(unit,array,indent)
integer(4),intent(in)::unit
real(8),intent(in)::array(:)
character(:,1),allocatable,intent(in)::indent
end
subroutine tagged_result(unit,energy,gradient,sigma,hessian)
integer(4),intent(in)::unit
real(8),intent(in),optional::energy
real(8),intent(in),optional::gradient(:,:)
real(8),intent(in),optional::sigma(:,:)
real(8),intent(in),optional::hessian(:,:,:,:)
end
end
