/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Flecs", "index.html", [
    [ "Documentation", "md_docs_2Docs.html", [
      [ "What is an Entity Component System?", "index.html#what-is-an-entity-component-system", null ],
      [ "Try it out!", "index.html#try-it-out", null ],
      [ "Documentation", "index.html#documentation", null ],
      [ "Performance", "index.html#performance", null ],
      [ "Show me the code!", "index.html#show-me-the-code", null ],
      [ "Projects using Flecs", "index.html#projects-using-flecs", [
        [ "Hytale", "index.html#hytalehttpshytalecom", null ],
        [ "Tempest Rising", "index.html#tempest-risinghttpsstoresteampoweredcomapp1486920tempest_rising", null ],
        [ "Territory Control", "index.html#territory-controlhttpsstoresteampoweredcomapp690290territory_control_2", null ],
        [ "The Forge", "index.html#the-forgehttpsgithubcomconfettifxthe-forge", null ],
        [ "Extermination Shock", "index.html#extermination-shockhttpsstoresteampoweredcomapp2510820extermination_shock", null ],
        [ "Sol Survivor", "index.html#sol-survivorhttpsnicokitchiosol-survivor-demo", null ],
        [ "Equilibrium Engine", "index.html#equilibrium-enginehttpsgithubcomclibequilibriumequilibriumengine", null ],
        [ "Gravitas", "index.html#gravitashttpsthepunkcollectiveitchiogravitas", null ],
        [ "After Sun", "index.html#after-sunhttpsgithubcomfoxnneaftersun", null ],
        [ "Flecs Demo's", "index.html#flecs-demos", null ]
      ] ],
      [ "Resources", "index.html#resources", [
        [ "Resources provided by the community :heart:", "index.html#resources-provided-by-the-community-heart", null ],
        [ "Flecs around the web", "index.html#flecs-around-the-web", null ]
      ] ],
      [ "Flecs Hub", "index.html#flecs-hub", null ],
      [ "Language bindings", "index.html#language-bindings", null ],
      [ "Getting Started", "md_docs_2Docs.html#getting-started", null ],
      [ "Manuals", "md_docs_2Docs.html#manuals", null ],
      [ "API reference", "md_docs_2Docs.html#api-reference", null ],
      [ "Examples", "md_docs_2Docs.html#examples", null ],
      [ "Demos", "md_docs_2Docs.html#demos", null ],
      [ "Articles", "md_docs_2Docs.html#articles", null ]
    ] ],
    [ "Flecs Quickstart", "md_docs_2Quickstart.html", [
      [ "Building Flecs", "md_docs_2Quickstart.html#building-flecs", [
        [ "Dynamic linking", "md_docs_2Quickstart.html#dynamic-linking", null ],
        [ "Building with CMake", "md_docs_2Quickstart.html#building-with-cmake", null ],
        [ "Building with Bake", "md_docs_2Quickstart.html#building-with-bake", null ],
        [ "Running tests (bake)", "md_docs_2Quickstart.html#running-tests-bake", [
          [ "Running tests (cmake, experimental)", "md_docs_2Quickstart.html#running-tests-cmake-experimental", null ]
        ] ],
        [ "Emscripten", "md_docs_2Quickstart.html#emscripten", null ],
        [ "Addons", "md_docs_2Quickstart.html#addons", null ]
      ] ],
      [ "Concepts", "md_docs_2Quickstart.html#concepts", [
        [ "World", "md_docs_2Quickstart.html#world", null ],
        [ "Entity", "md_docs_2Quickstart.html#entity", null ],
        [ "Id", "md_docs_2Quickstart.html#id", null ],
        [ "Component", "md_docs_2Quickstart.html#component", null ],
        [ "Tag", "md_docs_2Quickstart.html#tag", null ],
        [ "Pair", "md_docs_2Quickstart.html#pair", null ],
        [ "Hierarchies", "md_docs_2Quickstart.html#hierarchies", null ],
        [ "Instancing", "md_docs_2Quickstart.html#instancing", null ],
        [ "Type", "md_docs_2Quickstart.html#type", null ],
        [ "Singleton", "md_docs_2Quickstart.html#singleton", null ],
        [ "Filter", "md_docs_2Quickstart.html#filter", null ],
        [ "Query", "md_docs_2Quickstart.html#query", null ],
        [ "System", "md_docs_2Quickstart.html#system", null ],
        [ "Pipeline", "md_docs_2Quickstart.html#pipeline", null ],
        [ "Observer", "md_docs_2Quickstart.html#observer", null ],
        [ "Module", "md_docs_2Quickstart.html#module", null ]
      ] ]
    ] ],
    [ "FAQ", "md_docs_2FAQ.html", [
      [ "What is an ECS?", "md_docs_2FAQ.html#what-is-an-ecs", null ],
      [ "Why is Flecs written in C?", "md_docs_2FAQ.html#why-is-flecs-written-in-c", null ],
      [ "Can I use Flecs with C++14 or higher?", "md_docs_2FAQ.html#can-i-use-flecs-with-c14-or-higher", null ],
      [ "Can I use std::vector or other types inside components?", "md_docs_2FAQ.html#can-i-use-stdvector-or-other-types-inside-components", null ],
      [ "What is an archetype?", "md_docs_2FAQ.html#what-is-an-archetype", null ],
      [ "How does Flecs compare with EnTT?", "md_docs_2FAQ.html#how-does-flecs-compare-with-entt", null ],
      [ "Is Flecs used for commercial projects?", "md_docs_2FAQ.html#is-flecs-used-for-commercial-projects", null ],
      [ "Why are queries slow?", "md_docs_2FAQ.html#why-are-queries-slow", null ],
      [ "Why are queries taking up a lot of RAM?", "md_docs_2FAQ.html#why-are-queries-taking-up-a-lot-of-ram", null ],
      [ "Why is my system called multiple times per frame?", "md_docs_2FAQ.html#why-is-my-system-called-multiple-times-per-frame", null ],
      [ "Can Flecs be compiled to web assembly?", "md_docs_2FAQ.html#can-flecs-be-compiled-to-web-assembly", null ],
      [ "Why am I getting an “use of undeclared identifier 'FLECS_ID …’” compiler error?", "md_docs_2FAQ.html#why-am-i-getting-an-use-of-undeclared-identifier-flecs_id--compiler-error", null ],
      [ "Why are my entity ids so large?", "md_docs_2FAQ.html#why-are-my-entity-ids-so-large", null ],
      [ "What is the difference between add & set? Why do both exist?", "md_docs_2FAQ.html#what-is-the-difference-between-add--set-why-do-both-exist", null ],
      [ "Can Flecs serialize components?", "md_docs_2FAQ.html#can-flecs-serialize-components", null ],
      [ "Why is Flecs so large?", "md_docs_2FAQ.html#why-is-flecs-so-large", null ],
      [ "Why does the explorer not work?", "md_docs_2FAQ.html#why-does-the-explorer-not-work", null ],
      [ "Does the explorer collect data from my application?", "md_docs_2FAQ.html#does-the-explorer-collect-data-from-my-application", null ],
      [ "Why can't I see component values in the explorer?", "md_docs_2FAQ.html#why-cant-i-see-component-values-in-the-explorer", null ],
      [ "How do I detect which entities have changed?", "md_docs_2FAQ.html#how-do-i-detect-which-entities-have-changed", null ],
      [ "Are relationships just a component with an entity handle?", "md_docs_2FAQ.html#are-relationships-just-a-component-with-an-entity-handle", null ],
      [ "Can I create systems outside of the main function?", "md_docs_2FAQ.html#can-i-create-systems-outside-of-the-main-function", null ],
      [ "Can I use my own scheduler implementation?", "md_docs_2FAQ.html#can-i-use-my-own-scheduler-implementation", null ],
      [ "Can I use Flecs without using systems?", "md_docs_2FAQ.html#can-i-use-flecs-without-using-systems", null ],
      [ "Why does the lookup function not find my entity?", "md_docs_2FAQ.html#why-does-the-lookup-function-not-find-my-entity", null ],
      [ "Can I add or remove components from within a system?", "md_docs_2FAQ.html#can-i-add-or-remove-components-from-within-a-system", null ]
    ] ],
    [ "Designing with Flecs", "md_docs_2DesignWithFlecs.html", [
      [ "Entities", "md_docs_2DesignWithFlecs.html#entities", [
        [ "Entity Initialization", "md_docs_2DesignWithFlecs.html#entity-initialization", null ],
        [ "Entity Lifecycle", "md_docs_2DesignWithFlecs.html#entity-lifecycle", null ],
        [ "Entity Names", "md_docs_2DesignWithFlecs.html#entity-names", null ]
      ] ],
      [ "Components", "md_docs_2DesignWithFlecs.html#components", [
        [ "Component Size", "md_docs_2DesignWithFlecs.html#component-size", null ],
        [ "Complex component data", "md_docs_2DesignWithFlecs.html#complex-component-data", null ]
      ] ],
      [ "Queries", "md_docs_2DesignWithFlecs.html#queries", [
        [ "Use the right query", "md_docs_2DesignWithFlecs.html#use-the-right-query", null ],
        [ "Use in/inout/out annotations", "md_docs_2DesignWithFlecs.html#use-ininoutout-annotations", null ],
        [ "Annotations", "md_docs_2DesignWithFlecs.html#annotations", null ]
      ] ],
      [ "Systems", "md_docs_2DesignWithFlecs.html#systems", [
        [ "System Scope", "md_docs_2DesignWithFlecs.html#system-scope", null ],
        [ "System Scheduling", "md_docs_2DesignWithFlecs.html#system-scheduling", null ]
      ] ],
      [ "Phases and Pipelines", "md_docs_2DesignWithFlecs.html#phases-and-pipelines", [
        [ "Selecting a Phase", "md_docs_2DesignWithFlecs.html#selecting-a-phase", null ],
        [ "OnLoad", "md_docs_2DesignWithFlecs.html#onload", null ],
        [ "PostLoad", "md_docs_2DesignWithFlecs.html#postload", null ],
        [ "PreUpdate", "md_docs_2DesignWithFlecs.html#preupdate", null ],
        [ "OnUpdate", "md_docs_2DesignWithFlecs.html#onupdate", null ],
        [ "OnValidate", "md_docs_2DesignWithFlecs.html#onvalidate", null ],
        [ "PostUpdate", "md_docs_2DesignWithFlecs.html#postupdate", null ],
        [ "PreStore", "md_docs_2DesignWithFlecs.html#prestore", null ],
        [ "OnStore", "md_docs_2DesignWithFlecs.html#onstore", null ],
        [ "Custom phases and pipelines", "md_docs_2DesignWithFlecs.html#custom-phases-and-pipelines", null ]
      ] ],
      [ "Modules", "md_docs_2DesignWithFlecs.html#modules", [
        [ "Defining Modules", "md_docs_2DesignWithFlecs.html#defining-modules", null ],
        [ "Module Dependencies and Ordering", "md_docs_2DesignWithFlecs.html#module-dependencies-and-ordering", null ],
        [ "Modules and Feature Swapping", "md_docs_2DesignWithFlecs.html#modules-and-feature-swapping", null ],
        [ "Module Overhead", "md_docs_2DesignWithFlecs.html#module-overhead", null ]
      ] ],
      [ "Relationships", "md_docs_2DesignWithFlecs.html#relationships", null ]
    ] ],
    [ "Flecs Script Tutorial", "md_docs_2FlecsScriptTutorial.html", [
      [ "Getting Started with the Explorer", "md_docs_2FlecsScriptTutorial.html#getting-started-with-the-explorer", null ],
      [ "The Basics", "md_docs_2FlecsScriptTutorial.html#the-basics", null ],
      [ "Adding Components", "md_docs_2FlecsScriptTutorial.html#adding-components", null ],
      [ "Drawing Shapes", "md_docs_2FlecsScriptTutorial.html#drawing-shapes", null ],
      [ "Drawing a Fence", "md_docs_2FlecsScriptTutorial.html#drawing-a-fence", null ],
      [ "Prefabs", "md_docs_2FlecsScriptTutorial.html#prefabs", null ],
      [ "Assemblies", "md_docs_2FlecsScriptTutorial.html#assemblies", null ],
      [ "Grids", "md_docs_2FlecsScriptTutorial.html#grids", null ],
      [ "Nested Assemblies", "md_docs_2FlecsScriptTutorial.html#nested-assemblies", null ]
    ] ],
    [ "Manual", "md_docs_2Manual.html", [
      [ "Introduction", "md_docs_2Manual.html#introduction", null ],
      [ "Design Goals", "md_docs_2Manual.html#design-goals", [
        [ "Performance", "md_docs_2Manual.html#autotoc_md1-performance", null ],
        [ "Portability", "md_docs_2Manual.html#autotoc_md2-portability", null ],
        [ "Reusability", "md_docs_2Manual.html#autotoc_md3-reusability", null ],
        [ "Usability", "md_docs_2Manual.html#autotoc_md4-usability", null ],
        [ "Extensibility", "md_docs_2Manual.html#autotoc_md5-extensibility", null ],
        [ "Have fun!", "md_docs_2Manual.html#autotoc_md6-have-fun", null ]
      ] ],
      [ "Diagrams", "md_docs_2Manual.html#diagrams", [
        [ "High level architecture", "md_docs_2Manual.html#high-level-architecture", null ],
        [ "Component add flow", "md_docs_2Manual.html#component-add-flow", null ],
        [ "Component remove flow", "md_docs_2Manual.html#component-remove-flow", null ],
        [ "Staging flow", "md_docs_2Manual.html#staging-flow", null ]
      ] ],
      [ "API design", "md_docs_2Manual.html#api-design", [
        [ "Naming conventions", "md_docs_2Manual.html#naming-conventions", null ],
        [ "Idempotence", "md_docs_2Manual.html#idempotence", null ],
        [ "Error handling", "md_docs_2Manual.html#error-handling", null ],
        [ "Memory ownership", "md_docs_2Manual.html#memory-ownership", null ],
        [ "Entity names", "md_docs_2Manual.html#entity-names-1", null ],
        [ "Macros", "md_docs_2Manual.html#macros", null ]
      ] ],
      [ "Entities", "md_docs_2Manual.html#entities-1", [
        [ "Id recycling", "md_docs_2Manual.html#id-recycling", null ],
        [ "Generations", "md_docs_2Manual.html#generations", null ],
        [ "Manual id generation", "md_docs_2Manual.html#manual-id-generation", null ],
        [ "Id ranges", "md_docs_2Manual.html#id-ranges", null ]
      ] ],
      [ "Types", "md_docs_2Manual.html#types", [
        [ "Basic usage", "md_docs_2Manual.html#basic-usage", null ],
        [ "Advanced usage", "md_docs_2Manual.html#advanced-usage", null ]
      ] ],
      [ "Components", "md_docs_2Manual.html#components-1", [
        [ "Component handles", "md_docs_2Manual.html#component-handles", [
          [ "Global component handles", "md_docs_2Manual.html#global-component-handles", null ],
          [ "Local component handles", "md_docs_2Manual.html#local-component-handles", null ]
        ] ],
        [ "Component disabling", "md_docs_2Manual.html#component-disabling", [
          [ "Limitations", "md_docs_2Manual.html#limitations", null ]
        ] ]
      ] ],
      [ "Tagging", "md_docs_2Manual.html#tagging", [
        [ "Tag handles", "md_docs_2Manual.html#tag-handles", null ]
      ] ],
      [ "Observers", "md_docs_2Manual.html#observers", null ],
      [ "Modules", "md_docs_2Manual.html#modules-1", [
        [ "Modules in C++", "md_docs_2Manual.html#modules-in-c", null ]
      ] ],
      [ "Hierarchies", "md_docs_2Manual.html#hierarchies-1", [
        [ "Iteration", "md_docs_2Manual.html#iteration", null ],
        [ "Hierarchical queries", "md_docs_2Manual.html#hierarchical-queries", null ],
        [ "Path identifiers", "md_docs_2Manual.html#path-identifiers", null ],
        [ "Scoping", "md_docs_2Manual.html#scoping", null ],
        [ "Paths and signatures", "md_docs_2Manual.html#paths-and-signatures", null ]
      ] ],
      [ "Inheritance", "md_docs_2Manual.html#inheritance", [
        [ "Overriding", "md_docs_2Manual.html#overriding", null ],
        [ "Automatic overriding", "md_docs_2Manual.html#automatic-overriding", null ],
        [ "Inheritance hierarchies", "md_docs_2Manual.html#inheritance-hierarchies", null ],
        [ "Prefabs", "md_docs_2Manual.html#prefabs-1", null ]
      ] ],
      [ "Deferred operations", "md_docs_2Manual.html#deferred-operations", null ]
    ] ],
    [ "Queries", "md_docs_2Queries.html", [
      [ "Highlights", "md_docs_2Queries.html#highlights", null ],
      [ "Definitions", "md_docs_2Queries.html#definitions", null ],
      [ "Examples", "md_docs_2Queries.html#examples-1", null ],
      [ "Types", "md_docs_2Queries.html#types-1", [
        [ "Filters", "md_docs_2Queries.html#filters", null ],
        [ "Cached Queries", "md_docs_2Queries.html#cached-queries", null ],
        [ "Rules", "md_docs_2Queries.html#rules", null ]
      ] ],
      [ "Creation", "md_docs_2Queries.html#creation", [
        [ "Query Descriptors (C)", "md_docs_2Queries.html#query-descriptors-c", null ],
        [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c", null ],
        [ "Query DSL", "md_docs_2Queries.html#query-dsl", null ]
      ] ],
      [ "Iteration", "md_docs_2Queries.html#iteration-1", [
        [ "Iterators (C)", "md_docs_2Queries.html#iterators-c", null ],
        [ "Each (C++)", "md_docs_2Queries.html#each-c", null ],
        [ "Iter (C++)", "md_docs_2Queries.html#iter-c", null ],
        [ "Iteration safety", "md_docs_2Queries.html#iteration-safety", null ]
      ] ],
      [ "Reference", "md_docs_2Queries.html#reference", [
        [ "Components", "md_docs_2Queries.html#components-2", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-1", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-1", null ]
        ] ],
        [ "Wildcards", "md_docs_2Queries.html#wildcards", null ],
        [ "Pairs", "md_docs_2Queries.html#pairs", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-1", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-2", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-2", null ]
        ] ],
        [ "Access modifiers", "md_docs_2Queries.html#access-modifiers", [
          [ "Query Descriptors (C)", "md_docs_2Queries.html#query-descriptors-c-1", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-3", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-3", null ]
        ] ],
        [ "Operator Overview", "md_docs_2Queries.html#operator-overview", null ],
        [ "And Operator", "md_docs_2Queries.html#and-operator", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-2", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-4", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-4", null ]
        ] ],
        [ "Or Operator", "md_docs_2Queries.html#or-operator", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-3", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-5", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-5", null ]
        ] ],
        [ "Not Operator", "md_docs_2Queries.html#not-operator", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-4", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-6", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-6", null ]
        ] ],
        [ "Optional Operator", "md_docs_2Queries.html#optional-operator", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-5", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-7", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-7", null ]
        ] ],
        [ "Equality operators", "md_docs_2Queries.html#equality-operators", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-6", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-8", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-8", null ]
        ] ],
        [ "AndFrom, OrFrom, NotFrom Operators", "md_docs_2Queries.html#andfrom-orfrom-notfrom-operators", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-7", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-9", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-9", null ]
        ] ],
        [ "Query scopes", "md_docs_2Queries.html#query-scopes", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-8", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-10", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-10", null ]
        ] ],
        [ "Source", "md_docs_2Queries.html#source", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-9", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-11", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-11", null ]
        ] ],
        [ "Singletons", "md_docs_2Queries.html#singletons", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-10", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-12", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-12", null ]
        ] ],
        [ "Relationship Traversal", "md_docs_2Queries.html#relationship-traversal", [
          [ "Traversal Flags", "md_docs_2Queries.html#traversal-flags", null ],
          [ "Iteration", "md_docs_2Queries.html#iteration-2", null ],
          [ "Limitations", "md_docs_2Queries.html#limitations-1", null ],
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-11", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-13", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-13", null ]
        ] ],
        [ "Instancing", "md_docs_2Queries.html#instancing-1", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-12", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-14", null ]
        ] ],
        [ "Variables", "md_docs_2Queries.html#variables", [
          [ "Setting Variables", "md_docs_2Queries.html#setting-variables", null ],
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-13", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-15", null ]
        ] ],
        [ "Change Detection", "md_docs_2Queries.html#change-detection", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-14", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-16", null ]
        ] ],
        [ "Sorting", "md_docs_2Queries.html#sorting", [
          [ "Sorting Algorithm", "md_docs_2Queries.html#sorting-algorithm", null ],
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-15", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-17", null ]
        ] ],
        [ "Grouping", "md_docs_2Queries.html#grouping", [
          [ "Group Iterators", "md_docs_2Queries.html#group-iterators", null ],
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-16", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-18", null ]
        ] ],
        [ "Component Inheritance", "md_docs_2Queries.html#component-inheritance", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-17", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-19", null ]
        ] ],
        [ "Transitive Relationships", "md_docs_2Queries.html#transitive-relationships", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-18", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-20", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-14", null ]
        ] ],
        [ "Reflexive Relationships", "md_docs_2Queries.html#reflexive-relationships", [
          [ "Query Descriptor (C)", "md_docs_2Queries.html#query-descriptor-c-19", null ],
          [ "Query Builder (C++)", "md_docs_2Queries.html#query-builder-c-21", null ],
          [ "Query DSL", "md_docs_2Queries.html#query-dsl-15", null ]
        ] ]
      ] ],
      [ "Performance", "md_docs_2Queries.html#performance-1", [
        [ "Filter", "md_docs_2Queries.html#filter-1", null ],
        [ "Cached Queries", "md_docs_2Queries.html#cached-queries-1", null ]
      ] ]
    ] ],
    [ "Systems", "md_docs_2Systems.html", [
      [ "System Iteration", "md_docs_2Systems.html#system-iteration", null ],
      [ "Using delta_time", "md_docs_2Systems.html#using-delta_time", null ],
      [ "Tasks", "md_docs_2Systems.html#tasks", null ],
      [ "Pipelines", "md_docs_2Systems.html#pipelines", [
        [ "Builtin Pipeline", "md_docs_2Systems.html#builtin-pipeline", [
          [ "Builtin Pipeline Query", "md_docs_2Systems.html#builtin-pipeline-query", null ]
        ] ],
        [ "Custom pipeline", "md_docs_2Systems.html#custom-pipeline", [
          [ "Pipeline switching performance", "md_docs_2Systems.html#pipeline-switching-performance", null ]
        ] ],
        [ "Disabling systems", "md_docs_2Systems.html#disabling-systems", null ]
      ] ],
      [ "Staging", "md_docs_2Systems.html#staging", [
        [ "Sync points", "md_docs_2Systems.html#sync-points", null ],
        [ "No readonly systems", "md_docs_2Systems.html#no-readonly-systems", null ],
        [ "Threading", "md_docs_2Systems.html#threading", null ],
        [ "Threading with Async Tasks", "md_docs_2Systems.html#threading-with-async-tasks", null ]
      ] ],
      [ "Timers", "md_docs_2Systems.html#timers", [
        [ "Interval", "md_docs_2Systems.html#interval", null ],
        [ "Rate", "md_docs_2Systems.html#rate", null ],
        [ "Tick source", "md_docs_2Systems.html#tick-source", null ],
        [ "Nested tick sources", "md_docs_2Systems.html#nested-tick-sources", null ]
      ] ]
    ] ],
    [ "Relationships", "md_docs_2Relationships.html", [
      [ "Definitions", "md_docs_2Relationships.html#definitions-1", null ],
      [ "Examples", "md_docs_2Relationships.html#examples-2", null ],
      [ "Introduction", "md_docs_2Relationships.html#introduction-1", null ],
      [ "Relationship queries", "md_docs_2Relationships.html#relationship-queries", [
        [ "Test if entity has a relationship pair", "md_docs_2Relationships.html#test-if-entity-has-a-relationship-pair", null ],
        [ "Test if entity has a relationship wildcard", "md_docs_2Relationships.html#test-if-entity-has-a-relationship-wildcard", null ],
        [ "Get parent for entity", "md_docs_2Relationships.html#get-parent-for-entity", null ],
        [ "Find first target of a relationship for entity", "md_docs_2Relationships.html#find-first-target-of-a-relationship-for-entity", null ],
        [ "Find all targets of a relationship for entity", "md_docs_2Relationships.html#find-all-targets-of-a-relationship-for-entity", null ],
        [ "Find target of a relationship with component", "md_docs_2Relationships.html#find-target-of-a-relationship-with-component", null ],
        [ "Iterate all pairs for entity", "md_docs_2Relationships.html#iterate-all-pairs-for-entity", null ],
        [ "Find all entities with a pair", "md_docs_2Relationships.html#find-all-entities-with-a-pair", null ],
        [ "Find all entities with a pair wildcard", "md_docs_2Relationships.html#find-all-entities-with-a-pair-wildcard", null ],
        [ "Iterate all children for a parent", "md_docs_2Relationships.html#iterate-all-children-for-a-parent", null ]
      ] ],
      [ "Relationship components", "md_docs_2Relationships.html#relationship-components", [
        [ "Using relationships to add components multiple times", "md_docs_2Relationships.html#using-relationships-to-add-components-multiple-times", null ]
      ] ],
      [ "Relationship wildcards", "md_docs_2Relationships.html#relationship-wildcards", null ],
      [ "Inspecting relationships", "md_docs_2Relationships.html#inspecting-relationships", null ],
      [ "Builtin relationships", "md_docs_2Relationships.html#builtin-relationships", [
        [ "The IsA relationship", "md_docs_2Relationships.html#the-isa-relationship", [
          [ "Component sharing", "md_docs_2Relationships.html#component-sharing", null ]
        ] ],
        [ "The ChildOf relationship", "md_docs_2Relationships.html#the-childof-relationship", [
          [ "Namespacing", "md_docs_2Relationships.html#namespacing", null ],
          [ "Scoping", "md_docs_2Relationships.html#scoping-1", null ]
        ] ]
      ] ],
      [ "Cleanup properties", "md_docs_2Relationships.html#cleanup-properties", [
        [ "Examples", "md_docs_2Relationships.html#examples-3", null ],
        [ "Cleanup order", "md_docs_2Relationships.html#cleanup-order", [
          [ "Cleanup order during world teardown", "md_docs_2Relationships.html#cleanup-order-during-world-teardown", null ],
          [ "World teardown sequence", "md_docs_2Relationships.html#world-teardown-sequence", null ]
        ] ]
      ] ],
      [ "Relationship properties", "md_docs_2Relationships.html#relationship-properties", [
        [ "Tag property", "md_docs_2Relationships.html#tag-property", null ],
        [ "Final property", "md_docs_2Relationships.html#final-property", null ],
        [ "DontInherit property", "md_docs_2Relationships.html#dontinherit-property", null ],
        [ "AlwaysOverride property", "md_docs_2Relationships.html#alwaysoverride-property", null ],
        [ "Transitive property", "md_docs_2Relationships.html#transitive-property", null ],
        [ "Reflexive property", "md_docs_2Relationships.html#reflexive-property", null ],
        [ "Acyclic property", "md_docs_2Relationships.html#acyclic-property", null ],
        [ "Traversable property", "md_docs_2Relationships.html#traversable-property", null ],
        [ "Exclusive property", "md_docs_2Relationships.html#exclusive-property", null ],
        [ "Union property", "md_docs_2Relationships.html#union-property", null ],
        [ "Symmetric property", "md_docs_2Relationships.html#symmetric-property", null ],
        [ "With property", "md_docs_2Relationships.html#with-property", null ],
        [ "OneOf property", "md_docs_2Relationships.html#oneof-property", null ]
      ] ],
      [ "Relationship performance", "md_docs_2Relationships.html#relationship-performance", [
        [ "Introduction", "md_docs_2Relationships.html#introduction-2", null ],
        [ "Storing relationships", "md_docs_2Relationships.html#storing-relationships", null ],
        [ "Id ranges", "md_docs_2Relationships.html#id-ranges-1", null ],
        [ "Fragmentation", "md_docs_2Relationships.html#fragmentation", null ],
        [ "Relationship flattening", "md_docs_2Relationships.html#relationship-flattening", null ],
        [ "Table Creation", "md_docs_2Relationships.html#table-creation", null ],
        [ "Indexing", "md_docs_2Relationships.html#indexing", null ],
        [ "Wildcard Queries", "md_docs_2Relationships.html#wildcard-queries", null ]
      ] ]
    ] ],
    [ "REST API", "md_docs_2RestApi.html", [
      [ "Enable the REST API", "md_docs_2RestApi.html#enable-the-rest-api", null ],
      [ "Explorer", "md_docs_2RestApi.html#explorer", [
        [ "Queries", "md_docs_2RestApi.html#queries-2", null ]
      ] ],
      [ "Endpoints", "md_docs_2RestApi.html#endpoints", [
        [ "entity", "md_docs_2RestApi.html#entity-1", [
          [ "path", "md_docs_2RestApi.html#path", null ],
          [ "label", "md_docs_2RestApi.html#label", null ],
          [ "brief", "md_docs_2RestApi.html#brief", null ],
          [ "link", "md_docs_2RestApi.html#link", null ],
          [ "id_labels", "md_docs_2RestApi.html#id_labels", null ],
          [ "base", "md_docs_2RestApi.html#base", null ],
          [ "values", "md_docs_2RestApi.html#values", null ],
          [ "private", "md_docs_2RestApi.html#private", null ],
          [ "type_info", "md_docs_2RestApi.html#type_info", null ],
          [ "alerts", "md_docs_2RestApi.html#alerts", null ],
          [ "Example", "md_docs_2RestApi.html#example", null ]
        ] ],
        [ "enable", "md_docs_2RestApi.html#enable", null ],
        [ "disable", "md_docs_2RestApi.html#disable", null ],
        [ "delete", "md_docs_2RestApi.html#delete", null ],
        [ "set", "md_docs_2RestApi.html#set", null ],
        [ "query", "md_docs_2RestApi.html#query-1", [
          [ "name", "md_docs_2RestApi.html#name", null ],
          [ "offset", "md_docs_2RestApi.html#offset", null ],
          [ "limit", "md_docs_2RestApi.html#limit", null ],
          [ "term_ids", "md_docs_2RestApi.html#term_ids", null ],
          [ "term_labels", "md_docs_2RestApi.html#term_labels", null ],
          [ "ids", "md_docs_2RestApi.html#ids", null ],
          [ "id_labels", "md_docs_2RestApi.html#id_labels-1", null ],
          [ "sources", "md_docs_2RestApi.html#sources", null ],
          [ "variables", "md_docs_2RestApi.html#variables-1", null ],
          [ "is_set", "md_docs_2RestApi.html#is_set", null ],
          [ "values", "md_docs_2RestApi.html#values-1", null ],
          [ "entities", "md_docs_2RestApi.html#entities-2", null ],
          [ "entity_labels", "md_docs_2RestApi.html#entity_labels", null ],
          [ "entity_ids", "md_docs_2RestApi.html#entity_ids", null ],
          [ "variable_labels", "md_docs_2RestApi.html#variable_labels", null ],
          [ "variable_ids", "md_docs_2RestApi.html#variable_ids", null ],
          [ "duration", "md_docs_2RestApi.html#duration", null ],
          [ "type_info", "md_docs_2RestApi.html#type_info-1", null ],
          [ "Example:", "md_docs_2RestApi.html#example-1", null ]
        ] ],
        [ "stats", "md_docs_2RestApi.html#stats", null ]
      ] ]
    ] ],
    [ "JSON format", "md_docs_2JsonFormat.html", [
      [ "Value kinds", "md_docs_2JsonFormat.html#value-kinds", [
        [ "Name", "md_docs_2JsonFormat.html#name-1", null ],
        [ "Path", "md_docs_2JsonFormat.html#path-1", null ],
        [ "Label", "md_docs_2JsonFormat.html#label-1", null ],
        [ "Id", "md_docs_2JsonFormat.html#id-1", null ],
        [ "Id**", "md_docs_2JsonFormat.html#id-2", null ],
        [ "Value", "md_docs_2JsonFormat.html#value", null ],
        [ "Type**", "md_docs_2JsonFormat.html#type-1", null ],
        [ "Entity", "md_docs_2JsonFormat.html#entity-2", [
          [ "\"path", "md_docs_2JsonFormat.html#path-2", null ],
          [ "\"label", "md_docs_2JsonFormat.html#label-2", null ],
          [ "\"brief", "md_docs_2JsonFormat.html#brief-1", null ],
          [ "\"link", "md_docs_2JsonFormat.html#link-1", null ],
          [ "\"is_a", "md_docs_2JsonFormat.html#is_a", null ],
          [ "\"ids", "md_docs_2JsonFormat.html#ids-1", null ],
          [ "\"id_labels", "md_docs_2JsonFormat.html#id_labels-2", null ],
          [ "\"hidden", "md_docs_2JsonFormat.html#hidden", null ],
          [ "\"values", "md_docs_2JsonFormat.html#values-2", null ],
          [ "\"type_info", "md_docs_2JsonFormat.html#type_info-2", null ],
          [ "Example", "md_docs_2JsonFormat.html#example-2", null ]
        ] ],
        [ "Result", "md_docs_2JsonFormat.html#result", [
          [ "parent", "md_docs_2JsonFormat.html#parent", null ],
          [ "entities", "md_docs_2JsonFormat.html#entities-3", null ],
          [ "entity_labels", "md_docs_2JsonFormat.html#entity_labels-1", null ],
          [ "entity_ids", "md_docs_2JsonFormat.html#entity_ids-1", null ],
          [ "sources", "md_docs_2JsonFormat.html#sources-1", null ],
          [ "variables", "md_docs_2JsonFormat.html#variables-2", null ],
          [ "variable_labels", "md_docs_2JsonFormat.html#variable_labels-1", null ],
          [ "variable_ids", "md_docs_2JsonFormat.html#variable_ids-1", null ],
          [ "ids", "md_docs_2JsonFormat.html#ids-2", null ],
          [ "is_set", "md_docs_2JsonFormat.html#is_set-1", null ],
          [ "values", "md_docs_2JsonFormat.html#values-3", null ]
        ] ],
        [ "Iterator", "md_docs_2JsonFormat.html#iterator", [
          [ "\"ids", "md_docs_2JsonFormat.html#ids-3", null ],
          [ "\"variables", "md_docs_2JsonFormat.html#variables-3", null ],
          [ "\"results", "md_docs_2JsonFormat.html#results", null ],
          [ "\"eval_duration", "md_docs_2JsonFormat.html#eval_duration", null ],
          [ "\"type_info", "md_docs_2JsonFormat.html#type_info-3", null ],
          [ "Example", "md_docs_2JsonFormat.html#example-3", null ]
        ] ]
      ] ],
      [ "Entity serializer", "md_docs_2JsonFormat.html#entity-serializer", [
        [ "Serializer options", "md_docs_2JsonFormat.html#serializer-options", [
          [ "serialize_path", "md_docs_2JsonFormat.html#serialize_path", null ],
          [ "serialize_label", "md_docs_2JsonFormat.html#serialize_label", null ],
          [ "serialize_brief", "md_docs_2JsonFormat.html#serialize_brief", null ],
          [ "serialize_link", "md_docs_2JsonFormat.html#serialize_link", null ],
          [ "serialize_id_labels", "md_docs_2JsonFormat.html#serialize_id_labels", null ],
          [ "serialize_base", "md_docs_2JsonFormat.html#serialize_base", null ],
          [ "serialize_private", "md_docs_2JsonFormat.html#serialize_private", null ],
          [ "serialize_hidden", "md_docs_2JsonFormat.html#serialize_hidden", null ],
          [ "serialize_values", "md_docs_2JsonFormat.html#serialize_values", null ],
          [ "serialize_type_info", "md_docs_2JsonFormat.html#serialize_type_info", null ]
        ] ]
      ] ],
      [ "Iterator serializer", "md_docs_2JsonFormat.html#iterator-serializer", [
        [ "Serializer options", "md_docs_2JsonFormat.html#serializer-options-1", [
          [ "serialize_term_ids", "md_docs_2JsonFormat.html#serialize_term_ids", null ],
          [ "serialize_ids", "md_docs_2JsonFormat.html#serialize_ids", null ],
          [ "serialize_sources", "md_docs_2JsonFormat.html#serialize_sources", null ],
          [ "serialize_variables", "md_docs_2JsonFormat.html#serialize_variables", null ],
          [ "serialize_is_set", "md_docs_2JsonFormat.html#serialize_is_set", null ],
          [ "serialize_values", "md_docs_2JsonFormat.html#serialize_values-1", null ],
          [ "serialize_entities", "md_docs_2JsonFormat.html#serialize_entities", null ],
          [ "serialize_entity_labels", "md_docs_2JsonFormat.html#serialize_entity_labels", null ],
          [ "serialize_variable_labels", "md_docs_2JsonFormat.html#serialize_variable_labels", null ],
          [ "measure_eval_duration", "md_docs_2JsonFormat.html#measure_eval_duration", null ],
          [ "serialize_type_info", "md_docs_2JsonFormat.html#serialize_type_info-1", null ]
        ] ]
      ] ]
    ] ],
    [ "Topics", "topics.html", "topics" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", null ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", null ],
        [ "Functions", "namespacemembers_func.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", null ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", null ],
        [ "Macros", "globals_defs.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"alerts_2builder__i_8hpp.html",
"group__builtin__tags.html#ga3aa3f0e38642e1953d7d363c255c8d19",
"group__c__addons__parser.html#ga4422693b80b0831f7601c9daad943a34",
"group__cpp__addons__meta.html#gacd2ebeff1d616dd3fe4da8cf655d0ee3",
"group__function__types.html#gabcff38f9f396305a6de3750d59f4f2a2",
"group__world__frame.html",
"md_docs_2Manual.html#hierarchies-1",
"md_docs_2RestApi.html#values",
"structEcsWorldSummary.html#abe605a094cff8ebcb14a393981c362e7",
"structecs__observer__desc__t.html#a4f2b3232b25e085a8a7afea8f6cd1722",
"structecs__world__stats__t.html#a666b32a9e10907b61cc5b735974ee2dd",
"structflecs_1_1entity__builder.html#acdbeee3950128822c6838066e29616b2",
"structflecs_1_1system__builder__i.html#a6a5258e4e5437d8b2f54121d00f7519f",
"structflecs_1_1world.html#a793caf3103af38cb62cd801323532de6"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';