//
// File: XML.h
// This code was produced by the dragon parser generator
//
#include <lfcbase/Exception.h>
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#define MAXTOKENVAL 100

class XML
{

public:

   XML();
   virtual ~XML();

   void parse();
   ListT<Chain>& getTokenList() { return _tokenList; }

protected:

   virtual char nextChar() = 0;
   virtual void backChar() = 0;
   virtual void putPreamble() = 0;
   virtual void putAttribute() = 0;
   virtual void putBody() = 0;
   virtual void putDocType() = 0;
   virtual void putElement() = 0;
   virtual void putStreamElement() = 0;
   virtual void preStreamData() = 0;
   virtual void postStreamData() = 0;
   virtual void preElement() = 0;
   virtual void conElement() = 0;
   virtual void postElement() = 0;
   virtual void putData() = 0;
   virtual void storeData() = 0;
   virtual void preData() = 0;

   enum Token {
      IDENTIFIER,
      INTVAL,
      XMLTOKEN,
      STREAM,
      EMARK,
      QMARK,
      SLASH,
      RB,
      LB,
      MT,
      LT,
      DOCTYPE,
      CDATA,
      EQU,
      DATA,
      CONTENT,
      STRINGVAL,
      ENDTOKEN
   };
   void setReserved(Token t);

private:

   enum Symbol { PROD, TOKEN, NONE };
   enum ScannerStateType { START, INTERMEDIATE, FINAL, ANY };
   enum Action { SHIFT, REDUCE, ACCEPT, NULLACTION };
   enum Production {
      Start,
      XMLHeader,
      AttrList,
      Attr,
      XMLBody,
      XMLTag,
      StreamPre,
      StreamContent,
      Elem,
      ElementPre,
      ElementContent,
      ElementPost,
      ElementList,
      DataList,
      Data,
      DataContent,
      DataPre
   };
   void loadScanner();
   void loadParser0();
   void loadParser1();
   void loadParser2();
   void loadParser3();

   class ScannerStateEntry {

   public:

      ScannerStateEntry();
      ScannerStateEntry(int state, ScannerStateType type = INTERMEDIATE);
      ScannerStateEntry& operator = (const ScannerStateEntry& s);
      bool operator == (const ScannerStateEntry& s);

	   int getState();
      ScannerStateType getType();

   private:

      int _state;
      ScannerStateType _type;
   };

class ScannerTransEntry {

   public:

      ScannerTransEntry();
      ScannerTransEntry(int state, char c);
      ScannerTransEntry(int state, char c, int fstate);
      ScannerTransEntry& operator = (const ScannerTransEntry& s);
      bool operator == (const ScannerTransEntry& s);

      int getFState();

   private:

      int  _state;
      char _c;
      int _fstate;
   };

   class Scanner {

   public:

      Scanner();
      Scanner(Token t);

      Token getToken();
      void addState(ScannerStateEntry s);
      void addTransition(ScannerTransEntry t);
      bool checkPattern(const Chain& pattern);

   private:

      Token _token;
      ListT<ScannerStateEntry> _stateList;
      ListT<ScannerTransEntry> _transList;
   };

   ListT<Scanner> _scannerList;
   class StackEntry {

   public:

      StackEntry();
      StackEntry(Symbol prod, int num, int state, Chain tval = "");
      StackEntry& operator = (const StackEntry& a);

      int getState();
      Symbol getSymbol();
      Chain& getTval();

   private:

      Symbol _symbol;
      int _num;
      int _state;
      Chain _tval;
   };

   class ActionEntry {

   public:

      ActionEntry();
      ActionEntry(Action action, int num);
      bool operator == (const ActionEntry& a);
      ActionEntry& operator = (const ActionEntry& a);

      Action getAction();
      int getNum();

   private:

      Action _action;
      int _num;
   };

   ActionEntry _actionMap[57][18];
   int _jumpMap[57][18];

   class ProdEntry {

   public:

      ProdEntry();
      ProdEntry(int id);
      ProdEntry(int id, Production prod, int numSymbol);
      bool operator == (const ProdEntry& a);
      ProdEntry& operator = (const ProdEntry& a);

      int getId();
      Production getProd();
      int getNumSymbol();

   private:

      int _id;
      Production _prod;
      int _numSymbol;

   };

   ListT<ProdEntry> _prodInfo;

   bool isSepIgnore(char c);
   bool isSepSign(char c);
   bool shiftToken();

   bool getAction(int state, Token token, Action& a, int& num);
   bool getJump(int state, Production prod, int& fstate);

   Token _reservedToken;
   bool _isReserved;
   Token _token;
   char _tokenVal[MAXTOKENVAL];
   ListT<Chain> _tokenList;

};
