# The values below are for a copy of MOAB used directly
# from its build directory. These values will be overridden below
# for installed copies of MOAB.

# Feature list
MOAB_MPI_ENABLED = OFF
MOAB_FORTRAN_ENABLED = OFF
MOAB_HDF5_ENABLED = OFF
MOAB_NETCDF_ENABLED = OFF
MOAB_PNETCDF_ENABLED = OFF
MOAB_IGEOM_ENABLED = OFF
MOAB_IMESH_ENABLED = OFF
MOAB_IREL_ENABLED = OFF
MOAB_FBIGEOM_ENABLED = OFF
MOAB_MESQUITE_ENABLED = 

# Library and Include paths
MOAB_LIBDIR = C:/M/B/src/build-CLANGARM64/src/.libs
MOAB_INCLUDES = -IC:/M/B/src/moab-5.5.1/src \
                -IC:/M/B/src/build-CLANGARM64/src \
                -IC:/M/B/src/moab-5.5.1/src/oldinc \
                -IC:/M/B/src/moab-5.5.1/src/verdict \
                -IC:/M/B/src/moab-5.5.1/src/parallel \
                -IC:/M/B/src/build-CLANGARM64/src/parallel \
                -IC:/M/B/src/moab-5.5.1/src/LocalDiscretization \
                -IC:/M/B/src/moab-5.5.1/src/RefineMesh

ifeq ($(MOAB_IGEOM_ENABLED),yes)
include 
MOAB_INCLUDES += $(IGEOM_INCLUDES)
endif

ifeq ($(MOAB_MESQUITE_ENABLED),yes)
MSQ_LIBDIR = C:/M/B/src/build-CLANGARM64/src/mesquite/.libs
MSQ_LIBS = -LC:/M/B/src/build-CLANGARM64/src/mesquite/.libs -lmbmesquite
MSQ_INCLUDES = -IC:/M/B/src/moab-5.5.1/src/mesquite/include \
	-IC:/M/B/src/build-CLANGARM64/src/mesquite/include \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/Mesh \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/Control \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/Wrappers \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/MappingFunction \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/MappingFunction/Lagrange \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/MappingFunction/Linear \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/Misc \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/ObjectiveFunction \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityAssessor \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityImprover \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityImprover/OptSolvers \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityImprover/Relaxation \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/Debug \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/Shape \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/Smoothness \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/TMP \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/Untangle \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/Volume \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/TargetCalculator \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/Misc \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/Shape \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/ShapeOrient \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/ShapeSize \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/ShapeSizeOrient \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/Size \
	-IC:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/Untangle

MOAB_INCLUDES += ${MSQ_INCLUDES}
endif

MOAB_INCLUDES += 

MOAB_CPPFLAGS = -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 -pedantic -fpic -Wall -Wno-long-long -Wextra -Wno-cast-align -Wsign-compare -Wpointer-arith -Wformat -Wformat-security -Wunused-parameter -fstack-protector-all -fpermissive -Wno-ignored-attributes -Wno-variadic-macros -Wno-deprecated-declarations -Wno-unused-local-typedefs -IC:/a/msys64/clangarm64/include/eigen3 
MOAB_CXXFLAGS = -O3 -DNDEBUG 
MOAB_CFLAGS = -O3 -DNDEBUG 
MOAB_FFLAGS = 
MOAB_FCFLAGS = 
MOAB_LDFLAGS =   

# missing support for DAMSEL, CCMIO
# PROBABLY FORMATTED INCORRECTLY
MOAB_EXT_LIBS =     \
                    \
                  C:/a/msys64/clangarm64/lib/libopenblas.dll.a;-pthread C:/a/msys64/clangarm64/lib/libopenblas.dll.a  
MOAB_LIBS_LINK = ${MOAB_LDFLAGS} -L${MOAB_LIBDIR} -lMOAB ${MSQ_LIBS} $(MOAB_EXT_LIBS) 
DAGMC_LIBS_LINK = ${MOAB_LDFLAGS} -L${MOAB_LIBDIR}  -lMOAB ${MSQ_LIBS} $(MOAB_EXT_LIBS)

MOAB_CXX = C:/a/msys64/clangarm64/bin/clang++.exe
MOAB_CC  = C:/a/msys64/clangarm64/bin/clang.exe
MOAB_FC  = 
MOAB_F77  = 

# Override MOAB_LIBDIR and MOAB_INCLUDES from above with the correct
# values for the installed MOAB.

# NEED TO ADD SOMETHING TO MODIFY THIS FILE AT INSTALL TIME (OR FIX ISSUE #30)
