// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Transfer_MultipleBinder_HeaderFile
#define _Transfer_MultipleBinder_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Transfer_MultipleBinder.hxx>

#include <Handle_TColStd_HSequenceOfTransient.hxx>
#include <Transfer_Binder.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Standard_Type.hxx>
#include <Standard_CString.hxx>
#include <Handle_Standard_Transient.hxx>
#include <Standard_Integer.hxx>
class TColStd_HSequenceOfTransient;
class Transfer_TransferFailure;
class Standard_OutOfRange;
class Standard_Type;
class Standard_Transient;


//! Allows direct binding between a starting Object and the Result
//! of its transfer, when it can be made of several Transient
//! Objects. Compared to a Transcriptor, it has no Transfer Action
//!
//! Result is a list of Transient Results. Unique Result is not
//! available : SetResult is redefined to start the list on the
//! first call, and refuse the other times.
//!
//! rr
//!
//! Remark : MultipleBinder itself is intended to be created and
//! filled by TransferProcess itself (method Bind). In particular,
//! conflicts between Unique (Standard) result and Multiple result
//! are avoided through management made by TransferProcess.
//!
//! Also, a Transcriptor (with an effective Transfer Method) which
//! can produce a Multiple Result, may be defined as a sub-class
//! of MultipleBinder by redefining method Transfer.
class Transfer_MultipleBinder : public Transfer_Binder
{

public:

  
  //! normal standard constructor, creates an empty MultipleBinder
  Standard_EXPORT Transfer_MultipleBinder();
  
  //! Returns True if a starting object is bound with SEVERAL
  //! results : Here, returns allways True
  Standard_EXPORT virtual   Standard_Boolean IsMultiple()  const;
  
  //! Returns the Type permitted for Results, i.e. here Transient
  Standard_EXPORT   Handle(Standard_Type) ResultType()  const;
  
  //! Returns the Name of the Type which characterizes the Result
  //! Here, returns "(list)"
  Standard_EXPORT   Standard_CString ResultTypeName()  const;
  
  //! Adds a new Item to the Multiple Result
  Standard_EXPORT   void AddResult (const Handle(Standard_Transient)& res) ;
  
  //! Returns the actual count of recorded (Transient) results
  Standard_EXPORT   Standard_Integer NbResults()  const;
  
  //! Returns the value of the recorded result n0 <num>
  Standard_EXPORT   Handle(Standard_Transient) ResultValue (const Standard_Integer num)  const;
  
  //! Returns the Multiple Result, if it is defined (at least one
  //! Item). Else, returns a Null Handle
  Standard_EXPORT   Handle(TColStd_HSequenceOfTransient) MultipleResult()  const;
  
  //! Defines a Binding with a Multiple Result, given as a Sequence
  //! Error if a Unique Result has yet been defined
  Standard_EXPORT   void SetMultipleResult (const Handle(TColStd_HSequenceOfTransient)& mulres) ;




  DEFINE_STANDARD_RTTI(Transfer_MultipleBinder)

protected:




private: 


  Handle(TColStd_HSequenceOfTransient) themulres;


};







#endif // _Transfer_MultipleBinder_HeaderFile
