# This script is meant to be installed in /etc/profile.d and sourced
# *after* any PATH modifications done by MSYS Perl.

[ "${MSYSTEM_PREFIX}" != "/clangarm64" ] && return 0

if [ "$(echo -n "$PATH" | wc -l)" -gt 0 ]; then
    echo "/etc/profile.d/z-perl-clang-aarch64.sh: ERROR: PATH contains line break, skipping PATH setup" >&2
    return 1
fi

modify_path() {
    local mypath="/clangarm64/bin/site_perl/5.38.4:/clangarm64/bin/vendor_perl:/clangarm64/bin/core_perl"

    # Remove MSYS perl modules from PATH to avoid conflicts
    local newpath="$(echo -n "${PATH}" \
        | gawk -v mypath="${mypath}" '
            BEGIN { RS = ":" }
            /^\/usr\/bin\/.*_perl$/ { next }
            { printf "%s", (++i > 1 ? ":" : "") $0 }
            mypath && /^\/clangarm64\/bin$/ { printf "%s", ":" mypath }
        '
    )"
    [ -z "${newpath}" ] && return 1

    PATH="${newpath}"
}

modify_path

unset modify_path

# vim: set ts=4 sw=4 et ai syn=sh:
