(function() {var type_impls = {
"core":[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/f64.rs.html#370-1505\">source</a><a href=\"#impl-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedconstant.RADIX\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#373\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.RADIX\" class=\"constant\">RADIX</a>: <a class=\"primitive\" href=\"primitive.u32.html\">u32</a> = 2u32</h4></section></summary><div class=\"docblock\"><p>The radix or base of the internal representation of <code>f64</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.MANTISSA_DIGITS\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#377\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.MANTISSA_DIGITS\" class=\"constant\">MANTISSA_DIGITS</a>: <a class=\"primitive\" href=\"primitive.u32.html\">u32</a> = 53u32</h4></section></summary><div class=\"docblock\"><p>Number of significant digits in base 2.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.DIGITS\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#387\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.DIGITS\" class=\"constant\">DIGITS</a>: <a class=\"primitive\" href=\"primitive.u32.html\">u32</a> = 15u32</h4></section></summary><div class=\"docblock\"><p>Approximate number of significant digits in base 10.</p>\n<p>This is the maximum <i>x</i> such that any decimal number with <i>x</i>\nsignificant digits can be converted to <code>f64</code> and back without loss.</p>\n<p>Equal to floor(log<sub>10</sub> 2<sup><a href=\"core/primitive.f64.html#associatedconstant.MANTISSA_DIGITS\" title=\"associated constant f64::MANTISSA_DIGITS\"><code>MANTISSA_DIGITS</code></a> − 1</sup>).</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.EPSILON\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#398\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.EPSILON\" class=\"constant\">EPSILON</a>: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a> = 2.2204460492503131E-16f64</h4></section></summary><div class=\"docblock\"><p><a href=\"https://en.wikipedia.org/wiki/Machine_epsilon\">Machine epsilon</a> value for <code>f64</code>.</p>\n<p>This is the difference between <code>1.0</code> and the next larger representable number.</p>\n<p>Equal to 2<sup>1 − <a href=\"core/primitive.f64.html#associatedconstant.MANTISSA_DIGITS\" title=\"associated constant f64::MANTISSA_DIGITS\"><code>MANTISSA_DIGITS</code></a></sup>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.MIN\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#406\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.MIN\" class=\"constant\">MIN</a>: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a> = -1.7976931348623157E+308f64</h4></section></summary><div class=\"docblock\"><p>Smallest finite <code>f64</code> value.</p>\n<p>Equal to −<a href=\"core/primitive.f64.html#associatedconstant.MAX\" title=\"associated constant f64::MAX\"><code>MAX</code></a>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.MIN_POSITIVE\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#413\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.MIN_POSITIVE\" class=\"constant\">MIN_POSITIVE</a>: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a> = 2.2250738585072014E-308f64</h4></section></summary><div class=\"docblock\"><p>Smallest positive normal <code>f64</code> value.</p>\n<p>Equal to 2<sup><a href=\"core/primitive.f64.html#associatedconstant.MIN_EXP\" title=\"associated constant f64::MIN_EXP\"><code>MIN_EXP</code></a> − 1</sup>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.MAX\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#422\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.MAX\" class=\"constant\">MAX</a>: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a> = 1.7976931348623157E+308f64</h4></section></summary><div class=\"docblock\"><p>Largest finite <code>f64</code> value.</p>\n<p>Equal to\n(1 − 2<sup>−<a href=\"core/primitive.f64.html#associatedconstant.MANTISSA_DIGITS\" title=\"associated constant f64::MANTISSA_DIGITS\"><code>MANTISSA_DIGITS</code></a></sup>) 2<sup><a href=\"core/primitive.f64.html#associatedconstant.MAX_EXP\" title=\"associated constant f64::MAX_EXP\"><code>MAX_EXP</code></a></sup>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.MIN_EXP\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#429\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.MIN_EXP\" class=\"constant\">MIN_EXP</a>: <a class=\"primitive\" href=\"primitive.i32.html\">i32</a> = -1_021i32</h4></section></summary><div class=\"docblock\"><p>One greater than the minimum possible normal power of 2 exponent.</p>\n<p>If <i>x</i> = <code>MIN_EXP</code>, then normal numbers\n≥ 0.5 × 2<sup><i>x</i></sup>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.MAX_EXP\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#435\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.MAX_EXP\" class=\"constant\">MAX_EXP</a>: <a class=\"primitive\" href=\"primitive.i32.html\">i32</a> = 1_024i32</h4></section></summary><div class=\"docblock\"><p>Maximum possible power of 2 exponent.</p>\n<p>If <i>x</i> = <code>MAX_EXP</code>, then normal numbers\n&lt; 1 × 2<sup><i>x</i></sup>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.MIN_10_EXP\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#443\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.MIN_10_EXP\" class=\"constant\">MIN_10_EXP</a>: <a class=\"primitive\" href=\"primitive.i32.html\">i32</a> = -307i32</h4></section></summary><div class=\"docblock\"><p>Minimum <i>x</i> for which 10<sup><i>x</i></sup> is normal.</p>\n<p>Equal to ceil(log<sub>10</sub> <a href=\"core/primitive.f64.html#associatedconstant.MIN_POSITIVE\" title=\"associated constant f64::MIN_POSITIVE\"><code>MIN_POSITIVE</code></a>).</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.MAX_10_EXP\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#450\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.MAX_10_EXP\" class=\"constant\">MAX_10_EXP</a>: <a class=\"primitive\" href=\"primitive.i32.html\">i32</a> = 308i32</h4></section></summary><div class=\"docblock\"><p>Maximum <i>x</i> for which 10<sup><i>x</i></sup> is normal.</p>\n<p>Equal to floor(log<sub>10</sub> <a href=\"core/primitive.f64.html#associatedconstant.MAX\" title=\"associated constant f64::MAX\"><code>MAX</code></a>).</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.NAN\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#464\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.NAN\" class=\"constant\">NAN</a>: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a> = NaN_f64</h4></section></summary><div class=\"docblock\"><p>Not a Number (NaN).</p>\n<p>Note that IEEE 754 doesn’t define just a single NaN value;\na plethora of bit patterns are considered to be NaN.\nFurthermore, the standard makes a difference\nbetween a “signaling” and a “quiet” NaN,\nand allows inspecting its “payload” (the unspecified bits in the bit pattern).\nThis constant isn’t guaranteed to equal to any specific NaN bitpattern,\nand the stability of its representation over Rust versions\nand target platforms isn’t guaranteed.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.INFINITY\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#467\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.INFINITY\" class=\"constant\">INFINITY</a>: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a> = +Inf_f64</h4></section></summary><div class=\"docblock\"><p>Infinity (∞).</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.NEG_INFINITY\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.43.0\">1.43.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#470\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/primitive.f64.html#associatedconstant.NEG_INFINITY\" class=\"constant\">NEG_INFINITY</a>: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a> = -Inf_f64</h4></section></summary><div class=\"docblock\"><p>Negative infinity (−∞).</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_nan\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72505\" title=\"Tracking issue for const_float_classify\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#485-487\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.is_nan\" class=\"fn\">is_nan</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if this value is NaN.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>nan = f64::NAN;\n<span class=\"kw\">let </span>f = <span class=\"number\">7.0_f64</span>;\n\n<span class=\"macro\">assert!</span>(nan.is_nan());\n<span class=\"macro\">assert!</span>(!f.is_nan());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+nan+=+f64::NAN;%0Alet+f+=+7.0_f64;%0A%0Aassert!(nan.is_nan());%0Aassert!(!f.is_nan());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_infinite\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72505\" title=\"Tracking issue for const_float_classify\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#520-525\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.is_infinite\" class=\"fn\">is_infinite</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if this value is positive infinity or negative infinity, and\n<code>false</code> otherwise.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>f = <span class=\"number\">7.0f64</span>;\n<span class=\"kw\">let </span>inf = f64::INFINITY;\n<span class=\"kw\">let </span>neg_inf = f64::NEG_INFINITY;\n<span class=\"kw\">let </span>nan = f64::NAN;\n\n<span class=\"macro\">assert!</span>(!f.is_infinite());\n<span class=\"macro\">assert!</span>(!nan.is_infinite());\n\n<span class=\"macro\">assert!</span>(inf.is_infinite());\n<span class=\"macro\">assert!</span>(neg_inf.is_infinite());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+f+=+7.0f64;%0Alet+inf+=+f64::INFINITY;%0Alet+neg_inf+=+f64::NEG_INFINITY;%0Alet+nan+=+f64::NAN;%0A%0Aassert!(!f.is_infinite());%0Aassert!(!nan.is_infinite());%0A%0Aassert!(inf.is_infinite());%0Aassert!(neg_inf.is_infinite());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_finite\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72505\" title=\"Tracking issue for const_float_classify\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#545-549\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.is_finite\" class=\"fn\">is_finite</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if this number is neither infinite nor NaN.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>f = <span class=\"number\">7.0f64</span>;\n<span class=\"kw\">let </span>inf: f64 = f64::INFINITY;\n<span class=\"kw\">let </span>neg_inf: f64 = f64::NEG_INFINITY;\n<span class=\"kw\">let </span>nan: f64 = f64::NAN;\n\n<span class=\"macro\">assert!</span>(f.is_finite());\n\n<span class=\"macro\">assert!</span>(!nan.is_finite());\n<span class=\"macro\">assert!</span>(!inf.is_finite());\n<span class=\"macro\">assert!</span>(!neg_inf.is_finite());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+f+=+7.0f64;%0Alet+inf:+f64+=+f64::INFINITY;%0Alet+neg_inf:+f64+=+f64::NEG_INFINITY;%0Alet+nan:+f64+=+f64::NAN;%0A%0Aassert!(f.is_finite());%0A%0Aassert!(!nan.is_finite());%0Aassert!(!inf.is_finite());%0Aassert!(!neg_inf.is_finite());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_subnormal\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.53.0, const unstable\">1.53.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72505\" title=\"Tracking issue for const_float_classify\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#573-575\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.is_subnormal\" class=\"fn\">is_subnormal</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the number is <a href=\"https://en.wikipedia.org/wiki/Denormal_number\">subnormal</a>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>min = f64::MIN_POSITIVE; <span class=\"comment\">// 2.2250738585072014e-308_f64\n</span><span class=\"kw\">let </span>max = f64::MAX;\n<span class=\"kw\">let </span>lower_than_min = <span class=\"number\">1.0e-308_f64</span>;\n<span class=\"kw\">let </span>zero = <span class=\"number\">0.0_f64</span>;\n\n<span class=\"macro\">assert!</span>(!min.is_subnormal());\n<span class=\"macro\">assert!</span>(!max.is_subnormal());\n\n<span class=\"macro\">assert!</span>(!zero.is_subnormal());\n<span class=\"macro\">assert!</span>(!f64::NAN.is_subnormal());\n<span class=\"macro\">assert!</span>(!f64::INFINITY.is_subnormal());\n<span class=\"comment\">// Values between `0` and `min` are Subnormal.\n</span><span class=\"macro\">assert!</span>(lower_than_min.is_subnormal());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+min+=+f64::MIN_POSITIVE;+//+2.2250738585072014e-308_f64%0Alet+max+=+f64::MAX;%0Alet+lower_than_min+=+1.0e-308_f64;%0Alet+zero+=+0.0_f64;%0A%0Aassert!(!min.is_subnormal());%0Aassert!(!max.is_subnormal());%0A%0Aassert!(!zero.is_subnormal());%0Aassert!(!f64::NAN.is_subnormal());%0Aassert!(!f64::INFINITY.is_subnormal());%0A//+Values+between+%600%60+and+%60min%60+are+Subnormal.%0Aassert!(lower_than_min.is_subnormal());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_normal\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72505\" title=\"Tracking issue for const_float_classify\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#600-602\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.is_normal\" class=\"fn\">is_normal</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the number is neither zero, infinite,\n<a href=\"https://en.wikipedia.org/wiki/Denormal_number\">subnormal</a>, or NaN.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>min = f64::MIN_POSITIVE; <span class=\"comment\">// 2.2250738585072014e-308f64\n</span><span class=\"kw\">let </span>max = f64::MAX;\n<span class=\"kw\">let </span>lower_than_min = <span class=\"number\">1.0e-308_f64</span>;\n<span class=\"kw\">let </span>zero = <span class=\"number\">0.0f64</span>;\n\n<span class=\"macro\">assert!</span>(min.is_normal());\n<span class=\"macro\">assert!</span>(max.is_normal());\n\n<span class=\"macro\">assert!</span>(!zero.is_normal());\n<span class=\"macro\">assert!</span>(!f64::NAN.is_normal());\n<span class=\"macro\">assert!</span>(!f64::INFINITY.is_normal());\n<span class=\"comment\">// Values between `0` and `min` are Subnormal.\n</span><span class=\"macro\">assert!</span>(!lower_than_min.is_normal());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+min+=+f64::MIN_POSITIVE;+//+2.2250738585072014e-308f64%0Alet+max+=+f64::MAX;%0Alet+lower_than_min+=+1.0e-308_f64;%0Alet+zero+=+0.0f64;%0A%0Aassert!(min.is_normal());%0Aassert!(max.is_normal());%0A%0Aassert!(!zero.is_normal());%0Aassert!(!f64::NAN.is_normal());%0Aassert!(!f64::INFINITY.is_normal());%0A//+Values+between+%600%60+and+%60min%60+are+Subnormal.%0Aassert!(!lower_than_min.is_normal());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.classify\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72505\" title=\"Tracking issue for const_float_classify\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#619-648\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.classify\" class=\"fn\">classify</a>(self) -&gt; <a class=\"enum\" href=\"core/num/enum.FpCategory.html\" title=\"enum core::num::FpCategory\">FpCategory</a></h4></section></summary><div class=\"docblock\"><p>Returns the floating point category of the number. If only one property\nis going to be tested, it is generally faster to use the specific\npredicate instead.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::num::FpCategory;\n\n<span class=\"kw\">let </span>num = <span class=\"number\">12.4_f64</span>;\n<span class=\"kw\">let </span>inf = f64::INFINITY;\n\n<span class=\"macro\">assert_eq!</span>(num.classify(), FpCategory::Normal);\n<span class=\"macro\">assert_eq!</span>(inf.classify(), FpCategory::Infinite);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::num::FpCategory;%0A%0Alet+num+=+12.4_f64;%0Alet+inf+=+f64::INFINITY;%0A%0Aassert_eq!(num.classify(),+FpCategory::Normal);%0Aassert_eq!(inf.classify(),+FpCategory::Infinite);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_sign_positive\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72505\" title=\"Tracking issue for const_float_classify\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#703-705\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.is_sign_positive\" class=\"fn\">is_sign_positive</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if <code>self</code> has a positive sign, including <code>+0.0</code>, NaNs with\npositive sign bit and positive infinity. Note that IEEE 754 doesn’t assign any\nmeaning to the sign bit in case of a NaN, and as Rust doesn’t guarantee that\nthe bit pattern of NaNs are conserved over arithmetic operations, the result of\n<code>is_sign_positive</code> on a NaN might produce an unexpected result in some cases.\nSee <a href=\"core/primitive.f32.html\" title=\"primitive f32\">explanation of NaN as a special value</a> for more info.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>f = <span class=\"number\">7.0_f64</span>;\n<span class=\"kw\">let </span>g = -<span class=\"number\">7.0_f64</span>;\n\n<span class=\"macro\">assert!</span>(f.is_sign_positive());\n<span class=\"macro\">assert!</span>(!g.is_sign_positive());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+f+=+7.0_f64;%0Alet+g+=+-7.0_f64;%0A%0Aassert!(f.is_sign_positive());%0Aassert!(!g.is_sign_positive());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_sign_negative\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72505\" title=\"Tracking issue for const_float_classify\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#734-739\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.is_sign_negative\" class=\"fn\">is_sign_negative</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if <code>self</code> has a negative sign, including <code>-0.0</code>, NaNs with\nnegative sign bit and negative infinity. Note that IEEE 754 doesn’t assign any\nmeaning to the sign bit in case of a NaN, and as Rust doesn’t guarantee that\nthe bit pattern of NaNs are conserved over arithmetic operations, the result of\n<code>is_sign_negative</code> on a NaN might produce an unexpected result in some cases.\nSee <a href=\"core/primitive.f32.html\" title=\"primitive f32\">explanation of NaN as a special value</a> for more info.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>f = <span class=\"number\">7.0_f64</span>;\n<span class=\"kw\">let </span>g = -<span class=\"number\">7.0_f64</span>;\n\n<span class=\"macro\">assert!</span>(!f.is_sign_negative());\n<span class=\"macro\">assert!</span>(g.is_sign_negative());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+f+=+7.0_f64;%0Alet+g+=+-7.0_f64;%0A%0Aassert!(!f.is_sign_negative());%0Aassert!(g.is_sign_negative());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.next_up\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/91399\" title=\"Tracking issue for float_next_up_down\">unstable</a></span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#778-798\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.next_up\" class=\"fn\">next_up</a>(self) -&gt; Self</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>float_next_up_down</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91399\">#91399</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the least number greater than <code>self</code>.</p>\n<p>Let <code>TINY</code> be the smallest representable positive <code>f64</code>. Then,</p>\n<ul>\n<li>if <code>self.is_nan()</code>, this returns <code>self</code>;</li>\n<li>if <code>self</code> is <a href=\"core/primitive.f64.html#associatedconstant.NEG_INFINITY\" title=\"associated constant f64::NEG_INFINITY\"><code>NEG_INFINITY</code></a>, this returns <a href=\"core/primitive.f64.html#associatedconstant.MIN\" title=\"associated constant f64::MIN\"><code>MIN</code></a>;</li>\n<li>if <code>self</code> is <code>-TINY</code>, this returns -0.0;</li>\n<li>if <code>self</code> is -0.0 or +0.0, this returns <code>TINY</code>;</li>\n<li>if <code>self</code> is <a href=\"core/primitive.f64.html#associatedconstant.MAX\" title=\"associated constant f64::MAX\"><code>MAX</code></a> or <a href=\"core/primitive.f64.html#associatedconstant.INFINITY\" title=\"associated constant f64::INFINITY\"><code>INFINITY</code></a>, this returns <a href=\"core/primitive.f64.html#associatedconstant.INFINITY\" title=\"associated constant f64::INFINITY\"><code>INFINITY</code></a>;</li>\n<li>otherwise the unique least value greater than <code>self</code> is returned.</li>\n</ul>\n<p>The identity <code>x.next_up() == -(-x).next_down()</code> holds for all non-NaN <code>x</code>. When <code>x</code>\nis finite <code>x == x.next_up().next_down()</code> also holds.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(float_next_up_down)]\n</span><span class=\"comment\">// f64::EPSILON is the difference between 1.0 and the next number up.\n</span><span class=\"macro\">assert_eq!</span>(<span class=\"number\">1.0f64</span>.next_up(), <span class=\"number\">1.0 </span>+ f64::EPSILON);\n<span class=\"comment\">// But not for most numbers.\n</span><span class=\"macro\">assert!</span>(<span class=\"number\">0.1f64</span>.next_up() &lt; <span class=\"number\">0.1 </span>+ f64::EPSILON);\n<span class=\"macro\">assert_eq!</span>(<span class=\"number\">9007199254740992f64</span>.next_up(), <span class=\"number\">9007199254740994.0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(float_next_up_down)%5D%0A//+f64::EPSILON+is+the+difference+between+1.0+and+the+next+number+up.%0Afn+main()+%7B%0Aassert_eq!(1.0f64.next_up(),+1.0+%2B+f64::EPSILON);%0A//+But+not+for+most+numbers.%0Aassert!(0.1f64.next_up()+%3C+0.1+%2B+f64::EPSILON);%0Aassert_eq!(9007199254740992f64.next_up(),+9007199254740994.0);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.next_down\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/91399\" title=\"Tracking issue for float_next_up_down\">unstable</a></span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#828-848\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.next_down\" class=\"fn\">next_down</a>(self) -&gt; Self</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>float_next_up_down</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91399\">#91399</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the greatest number less than <code>self</code>.</p>\n<p>Let <code>TINY</code> be the smallest representable positive <code>f64</code>. Then,</p>\n<ul>\n<li>if <code>self.is_nan()</code>, this returns <code>self</code>;</li>\n<li>if <code>self</code> is <a href=\"core/primitive.f64.html#associatedconstant.INFINITY\" title=\"associated constant f64::INFINITY\"><code>INFINITY</code></a>, this returns <a href=\"core/primitive.f64.html#associatedconstant.MAX\" title=\"associated constant f64::MAX\"><code>MAX</code></a>;</li>\n<li>if <code>self</code> is <code>TINY</code>, this returns 0.0;</li>\n<li>if <code>self</code> is -0.0 or +0.0, this returns <code>-TINY</code>;</li>\n<li>if <code>self</code> is <a href=\"core/primitive.f64.html#associatedconstant.MIN\" title=\"associated constant f64::MIN\"><code>MIN</code></a> or <a href=\"core/primitive.f64.html#associatedconstant.NEG_INFINITY\" title=\"associated constant f64::NEG_INFINITY\"><code>NEG_INFINITY</code></a>, this returns <a href=\"core/primitive.f64.html#associatedconstant.NEG_INFINITY\" title=\"associated constant f64::NEG_INFINITY\"><code>NEG_INFINITY</code></a>;</li>\n<li>otherwise the unique greatest value less than <code>self</code> is returned.</li>\n</ul>\n<p>The identity <code>x.next_down() == -(-x).next_up()</code> holds for all non-NaN <code>x</code>. When <code>x</code>\nis finite <code>x == x.next_down().next_up()</code> also holds.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(float_next_up_down)]\n</span><span class=\"kw\">let </span>x = <span class=\"number\">1.0f64</span>;\n<span class=\"comment\">// Clamp value into range [0, 1).\n</span><span class=\"kw\">let </span>clamped = x.clamp(<span class=\"number\">0.0</span>, <span class=\"number\">1.0f64</span>.next_down());\n<span class=\"macro\">assert!</span>(clamped &lt; <span class=\"number\">1.0</span>);\n<span class=\"macro\">assert_eq!</span>(clamped.next_up(), <span class=\"number\">1.0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(float_next_up_down)%5D%0Afn+main()+%7B%0Alet+x+=+1.0f64;%0A//+Clamp+value+into+range+%5B0,+1).%0Alet+clamped+=+x.clamp(0.0,+1.0f64.next_down());%0Aassert!(clamped+%3C+1.0);%0Aassert_eq!(clamped.next_up(),+1.0);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.recip\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#861-863\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.recip\" class=\"fn\">recip</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class=\"docblock\"><p>Takes the reciprocal (inverse) of a number, <code>1/x</code>.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x = <span class=\"number\">2.0_f64</span>;\n<span class=\"kw\">let </span>abs_difference = (x.recip() - (<span class=\"number\">1.0 </span>/ x)).abs();\n\n<span class=\"macro\">assert!</span>(abs_difference &lt; <span class=\"number\">1e-10</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x+=+2.0_f64;%0Alet+abs_difference+=+(x.recip()+-+(1.0+/+x)).abs();%0A%0Aassert!(abs_difference+%3C+1e-10);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_degrees\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#878-883\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.to_degrees\" class=\"fn\">to_degrees</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class=\"docblock\"><p>Converts radians to degrees.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>angle = std::f64::consts::PI;\n\n<span class=\"kw\">let </span>abs_difference = (angle.to_degrees() - <span class=\"number\">180.0</span>).abs();\n\n<span class=\"macro\">assert!</span>(abs_difference &lt; <span class=\"number\">1e-10</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+angle+=+std::f64::consts::PI;%0A%0Alet+abs_difference+=+(angle.to_degrees()+-+180.0).abs();%0A%0Aassert!(abs_difference+%3C+1e-10);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_radians\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#898-901\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.to_radians\" class=\"fn\">to_radians</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class=\"docblock\"><p>Converts degrees to radians.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>angle = <span class=\"number\">180.0_f64</span>;\n\n<span class=\"kw\">let </span>abs_difference = (angle.to_radians() - std::f64::consts::PI).abs();\n\n<span class=\"macro\">assert!</span>(abs_difference &lt; <span class=\"number\">1e-10</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+angle+=+180.0_f64;%0A%0Alet+abs_difference+=+(angle.to_radians()+-+std::f64::consts::PI).abs();%0A%0Aassert!(abs_difference+%3C+1e-10);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.max\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#919-921\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.max\" class=\"fn\">max</a>(self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class=\"docblock\"><p>Returns the maximum of the two numbers, ignoring NaN.</p>\n<p>If one of the arguments is NaN, then the other argument is returned.\nThis follows the IEEE 754-2008 semantics for maxNum, except for handling of signaling NaNs;\nthis function handles all NaNs the same way and avoids maxNum’s problems with associativity.\nThis also matches the behavior of libm’s fmax.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x = <span class=\"number\">1.0_f64</span>;\n<span class=\"kw\">let </span>y = <span class=\"number\">2.0_f64</span>;\n\n<span class=\"macro\">assert_eq!</span>(x.max(y), y);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x+=+1.0_f64;%0Alet+y+=+2.0_f64;%0A%0Aassert_eq!(x.max(y),+y);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.min\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#939-941\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.min\" class=\"fn\">min</a>(self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class=\"docblock\"><p>Returns the minimum of the two numbers, ignoring NaN.</p>\n<p>If one of the arguments is NaN, then the other argument is returned.\nThis follows the IEEE 754-2008 semantics for minNum, except for handling of signaling NaNs;\nthis function handles all NaNs the same way and avoids minNum’s problems with associativity.\nThis also matches the behavior of libm’s fmin.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x = <span class=\"number\">1.0_f64</span>;\n<span class=\"kw\">let </span>y = <span class=\"number\">2.0_f64</span>;\n\n<span class=\"macro\">assert_eq!</span>(x.min(y), x);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x+=+1.0_f64;%0Alet+y+=+2.0_f64;%0A%0Aassert_eq!(x.min(y),+x);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.maximum\" class=\"method\"><a class=\"src rightside\" href=\"src/core/num/f64.rs.html#966-976\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.maximum\" class=\"fn\">maximum</a>(self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>float_minimum_maximum</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91079\">#91079</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the maximum of the two numbers, propagating NaN.</p>\n<p>This returns NaN when <em>either</em> argument is NaN, as opposed to\n<a href=\"core/primitive.f64.html#method.max\" title=\"method f64::max\"><code>f64::max</code></a> which only returns NaN when <em>both</em> arguments are NaN.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(float_minimum_maximum)]\n</span><span class=\"kw\">let </span>x = <span class=\"number\">1.0_f64</span>;\n<span class=\"kw\">let </span>y = <span class=\"number\">2.0_f64</span>;\n\n<span class=\"macro\">assert_eq!</span>(x.maximum(y), y);\n<span class=\"macro\">assert!</span>(x.maximum(f64::NAN).is_nan());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(float_minimum_maximum)%5D%0Afn+main()+%7B%0Alet+x+=+1.0_f64;%0Alet+y+=+2.0_f64;%0A%0Aassert_eq!(x.maximum(y),+y);%0Aassert!(x.maximum(f64::NAN).is_nan());%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n<p>If one of the arguments is NaN, then NaN is returned. Otherwise this returns the greater\nof the two numbers. For this operation, -0.0 is considered to be less than +0.0.\nNote that this follows the semantics specified in IEEE 754-2019.</p>\n<p>Also note that “propagation” of NaNs here doesn’t necessarily mean that the bitpattern of a NaN\noperand is conserved; see <a href=\"core/primitive.f32.html\" title=\"primitive f32\">explanation of NaN as a special value</a> for more info.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.minimum\" class=\"method\"><a class=\"src rightside\" href=\"src/core/num/f64.rs.html#1001-1012\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.minimum\" class=\"fn\">minimum</a>(self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>float_minimum_maximum</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91079\">#91079</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns the minimum of the two numbers, propagating NaN.</p>\n<p>This returns NaN when <em>either</em> argument is NaN, as opposed to\n<a href=\"core/primitive.f64.html#method.min\" title=\"method f64::min\"><code>f64::min</code></a> which only returns NaN when <em>both</em> arguments are NaN.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(float_minimum_maximum)]\n</span><span class=\"kw\">let </span>x = <span class=\"number\">1.0_f64</span>;\n<span class=\"kw\">let </span>y = <span class=\"number\">2.0_f64</span>;\n\n<span class=\"macro\">assert_eq!</span>(x.minimum(y), x);\n<span class=\"macro\">assert!</span>(x.minimum(f64::NAN).is_nan());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(float_minimum_maximum)%5D%0Afn+main()+%7B%0Alet+x+=+1.0_f64;%0Alet+y+=+2.0_f64;%0A%0Aassert_eq!(x.minimum(y),+x);%0Aassert!(x.minimum(f64::NAN).is_nan());%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n<p>If one of the arguments is NaN, then NaN is returned. Otherwise this returns the lesser\nof the two numbers. For this operation, -0.0 is considered to be less than +0.0.\nNote that this follows the semantics specified in IEEE 754-2019.</p>\n<p>Also note that “propagation” of NaNs here doesn’t necessarily mean that the bitpattern of a NaN\noperand is conserved; see <a href=\"core/primitive.f32.html\" title=\"primitive f32\">explanation of NaN as a special value</a> for more info.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.midpoint\" class=\"method\"><a class=\"src rightside\" href=\"src/core/num/f64.rs.html#1027-1048\">source</a><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.midpoint\" class=\"fn\">midpoint</a>(self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>num_midpoint</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/110840\">#110840</a>)</span></div></span></summary><div class=\"docblock\"><p>Calculates the middle point of <code>self</code> and <code>rhs</code>.</p>\n<p>This returns NaN when <em>either</em> argument is NaN or if a combination of\n+inf and -inf is provided as arguments.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(num_midpoint)]\n</span><span class=\"macro\">assert_eq!</span>(<span class=\"number\">1f64</span>.midpoint(<span class=\"number\">4.0</span>), <span class=\"number\">2.5</span>);\n<span class=\"macro\">assert_eq!</span>((-<span class=\"number\">5.5f64</span>).midpoint(<span class=\"number\">8.0</span>), <span class=\"number\">1.25</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(num_midpoint)%5D%0Afn+main()+%7B%0Aassert_eq!(1f64.midpoint(4.0),+2.5);%0Aassert_eq!((-5.5f64).midpoint(8.0),+1.25);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_int_unchecked\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.44.0\">1.44.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1074-1081\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"core/primitive.f64.html#tymethod.to_int_unchecked\" class=\"fn\">to_int_unchecked</a>&lt;Int&gt;(self) -&gt; Int<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;Int&gt;,</div></h4></section></summary><div class=\"docblock\"><p>Rounds toward zero and converts to any primitive integer type,\nassuming that the value is finite and fits in that type.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>value = <span class=\"number\">4.6_f64</span>;\n<span class=\"kw\">let </span>rounded = <span class=\"kw\">unsafe </span>{ value.to_int_unchecked::&lt;u16&gt;() };\n<span class=\"macro\">assert_eq!</span>(rounded, <span class=\"number\">4</span>);\n\n<span class=\"kw\">let </span>value = -<span class=\"number\">128.9_f64</span>;\n<span class=\"kw\">let </span>rounded = <span class=\"kw\">unsafe </span>{ value.to_int_unchecked::&lt;i8&gt;() };\n<span class=\"macro\">assert_eq!</span>(rounded, i8::MIN);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+value+=+4.6_f64;%0Alet+rounded+=+unsafe+%7B+value.to_int_unchecked::%3Cu16%3E()+%7D;%0Aassert_eq!(rounded,+4);%0A%0Alet+value+=+-128.9_f64;%0Alet+rounded+=+unsafe+%7B+value.to_int_unchecked::%3Ci8%3E()+%7D;%0Aassert_eq!(rounded,+i8::MIN);%0A%7D&amp;edition=2021\">Run</a></div>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<p>The value must:</p>\n<ul>\n<li>Not be <code>NaN</code></li>\n<li>Not be infinite</li>\n<li>Be representable in the return type <code>Int</code>, after truncating off its fractional part</li>\n</ul>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_bits\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.20.0, const unstable\">1.20.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72447\" title=\"Tracking issue for const_float_bits_conv\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1105-1135\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.to_bits\" class=\"fn\">to_bits</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.u64.html\">u64</a></h4></section></summary><div class=\"docblock\"><p>Raw transmutation to <code>u64</code>.</p>\n<p>This is currently identical to <code>transmute::&lt;f64, u64&gt;(self)</code> on all platforms.</p>\n<p>See <a href=\"core/primitive.f64.html#method.from_bits\" title=\"associated function f64::from_bits\"><code>from_bits</code></a> for some discussion of the\nportability of this operation (there are almost no issues).</p>\n<p>Note that this function is distinct from <code>as</code> casting, which attempts to\npreserve the <em>numeric</em> value, and not the bitwise value.</p>\n<h5 id=\"examples-1\"><a class=\"doc-anchor\" href=\"#examples-1\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert!</span>((<span class=\"number\">1f64</span>).to_bits() != <span class=\"number\">1f64 </span><span class=\"kw\">as </span>u64); <span class=\"comment\">// to_bits() is not casting!\n</span><span class=\"macro\">assert_eq!</span>((<span class=\"number\">12.5f64</span>).to_bits(), <span class=\"number\">0x4029000000000000</span>);\n</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Aassert!((1f64).to_bits()+!=+1f64+as+u64);+//+to_bits()+is+not+casting!%0Aassert_eq!((12.5f64).to_bits(),+0x4029000000000000);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_bits\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.20.0, const unstable\">1.20.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72447\" title=\"Tracking issue for const_float_bits_conv\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1177-1232\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.from_bits\" class=\"fn\">from_bits</a>(v: <a class=\"primitive\" href=\"primitive.u64.html\">u64</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Raw transmutation from <code>u64</code>.</p>\n<p>This is currently identical to <code>transmute::&lt;u64, f64&gt;(v)</code> on all platforms.\nIt turns out this is incredibly portable, for two reasons:</p>\n<ul>\n<li>Floats and Ints have the same endianness on all supported platforms.</li>\n<li>IEEE 754 very precisely specifies the bit layout of floats.</li>\n</ul>\n<p>However there is one caveat: prior to the 2008 version of IEEE 754, how\nto interpret the NaN signaling bit wasn’t actually specified. Most platforms\n(notably x86 and ARM) picked the interpretation that was ultimately\nstandardized in 2008, but some didn’t (notably MIPS). As a result, all\nsignaling NaNs on MIPS are quiet NaNs on x86, and vice-versa.</p>\n<p>Rather than trying to preserve signaling-ness cross-platform, this\nimplementation favors preserving the exact bits. This means that\nany payloads encoded in NaNs will be preserved even if the result of\nthis method is sent over the network from an x86 machine to a MIPS one.</p>\n<p>If the results of this method are only manipulated by the same\narchitecture that produced them, then there is no portability concern.</p>\n<p>If the input isn’t NaN, then there is no portability concern.</p>\n<p>If you don’t care about signaling-ness (very likely), then there is no\nportability concern.</p>\n<p>Note that this function is distinct from <code>as</code> casting, which attempts to\npreserve the <em>numeric</em> value, and not the bitwise value.</p>\n<h5 id=\"examples-2\"><a class=\"doc-anchor\" href=\"#examples-2\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = f64::from_bits(<span class=\"number\">0x4029000000000000</span>);\n<span class=\"macro\">assert_eq!</span>(v, <span class=\"number\">12.5</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+v+=+f64::from_bits(0x4029000000000000);%0Aassert_eq!(v,+12.5);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_be_bytes\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.40.0, const unstable\">1.40.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72447\" title=\"Tracking issue for const_float_bits_conv\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1251-1253\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.to_be_bytes\" class=\"fn\">to_be_bytes</a>(self) -&gt; [<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>; <a class=\"primitive\" href=\"primitive.array.html\">8</a>]</h4></section></summary><div class=\"docblock\"><p>Return the memory representation of this floating point number as a byte array in\nbig-endian (network) byte order.</p>\n<p>See <a href=\"core/primitive.f64.html#method.from_bits\" title=\"associated function f64::from_bits\"><code>from_bits</code></a> for some discussion of the\nportability of this operation (there are almost no issues).</p>\n<h5 id=\"examples-3\"><a class=\"doc-anchor\" href=\"#examples-3\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>bytes = <span class=\"number\">12.5f64</span>.to_be_bytes();\n<span class=\"macro\">assert_eq!</span>(bytes, [<span class=\"number\">0x40</span>, <span class=\"number\">0x29</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+bytes+=+12.5f64.to_be_bytes();%0Aassert_eq!(bytes,+%5B0x40,+0x29,+0x00,+0x00,+0x00,+0x00,+0x00,+0x00%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_le_bytes\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.40.0, const unstable\">1.40.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72447\" title=\"Tracking issue for const_float_bits_conv\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1272-1274\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.to_le_bytes\" class=\"fn\">to_le_bytes</a>(self) -&gt; [<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>; <a class=\"primitive\" href=\"primitive.array.html\">8</a>]</h4></section></summary><div class=\"docblock\"><p>Return the memory representation of this floating point number as a byte array in\nlittle-endian byte order.</p>\n<p>See <a href=\"core/primitive.f64.html#method.from_bits\" title=\"associated function f64::from_bits\"><code>from_bits</code></a> for some discussion of the\nportability of this operation (there are almost no issues).</p>\n<h5 id=\"examples-4\"><a class=\"doc-anchor\" href=\"#examples-4\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>bytes = <span class=\"number\">12.5f64</span>.to_le_bytes();\n<span class=\"macro\">assert_eq!</span>(bytes, [<span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x29</span>, <span class=\"number\">0x40</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+bytes+=+12.5f64.to_le_bytes();%0Aassert_eq!(bytes,+%5B0x00,+0x00,+0x00,+0x00,+0x00,+0x00,+0x29,+0x40%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_ne_bytes\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.40.0, const unstable\">1.40.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72447\" title=\"Tracking issue for const_float_bits_conv\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1306-1308\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.to_ne_bytes\" class=\"fn\">to_ne_bytes</a>(self) -&gt; [<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>; <a class=\"primitive\" href=\"primitive.array.html\">8</a>]</h4></section></summary><div class=\"docblock\"><p>Return the memory representation of this floating point number as a byte array in\nnative byte order.</p>\n<p>As the target platform’s native endianness is used, portable code\nshould use <a href=\"core/primitive.f64.html#method.to_be_bytes\" title=\"method f64::to_be_bytes\"><code>to_be_bytes</code></a> or <a href=\"core/primitive.f64.html#method.to_le_bytes\" title=\"method f64::to_le_bytes\"><code>to_le_bytes</code></a>, as appropriate, instead.</p>\n<p>See <a href=\"core/primitive.f64.html#method.from_bits\" title=\"associated function f64::from_bits\"><code>from_bits</code></a> for some discussion of the\nportability of this operation (there are almost no issues).</p>\n<h5 id=\"examples-5\"><a class=\"doc-anchor\" href=\"#examples-5\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>bytes = <span class=\"number\">12.5f64</span>.to_ne_bytes();\n<span class=\"macro\">assert_eq!</span>(\n    bytes,\n    <span class=\"kw\">if </span><span class=\"macro\">cfg!</span>(target_endian = <span class=\"string\">\"big\"</span>) {\n        [<span class=\"number\">0x40</span>, <span class=\"number\">0x29</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>]\n    } <span class=\"kw\">else </span>{\n        [<span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x29</span>, <span class=\"number\">0x40</span>]\n    }\n);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+bytes+=+12.5f64.to_ne_bytes();%0Aassert_eq!(%0A++++bytes,%0A++++if+cfg!(target_endian+=+%22big%22)+%7B%0A++++++++%5B0x40,+0x29,+0x00,+0x00,+0x00,+0x00,+0x00,+0x00%5D%0A++++%7D+else+%7B%0A++++++++%5B0x00,+0x00,+0x00,+0x00,+0x00,+0x00,+0x29,+0x40%5D%0A++++%7D%0A);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_be_bytes\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.40.0, const unstable\">1.40.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72447\" title=\"Tracking issue for const_float_bits_conv\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1325-1327\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.from_be_bytes\" class=\"fn\">from_be_bytes</a>(bytes: [<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>; <a class=\"primitive\" href=\"primitive.array.html\">8</a>]) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Create a floating point value from its representation as a byte array in big endian.</p>\n<p>See <a href=\"core/primitive.f64.html#method.from_bits\" title=\"associated function f64::from_bits\"><code>from_bits</code></a> for some discussion of the\nportability of this operation (there are almost no issues).</p>\n<h5 id=\"examples-6\"><a class=\"doc-anchor\" href=\"#examples-6\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>value = f64::from_be_bytes([<span class=\"number\">0x40</span>, <span class=\"number\">0x29</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>]);\n<span class=\"macro\">assert_eq!</span>(value, <span class=\"number\">12.5</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+value+=+f64::from_be_bytes(%5B0x40,+0x29,+0x00,+0x00,+0x00,+0x00,+0x00,+0x00%5D);%0Aassert_eq!(value,+12.5);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_le_bytes\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.40.0, const unstable\">1.40.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72447\" title=\"Tracking issue for const_float_bits_conv\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1344-1346\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.from_le_bytes\" class=\"fn\">from_le_bytes</a>(bytes: [<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>; <a class=\"primitive\" href=\"primitive.array.html\">8</a>]) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Create a floating point value from its representation as a byte array in little endian.</p>\n<p>See <a href=\"core/primitive.f64.html#method.from_bits\" title=\"associated function f64::from_bits\"><code>from_bits</code></a> for some discussion of the\nportability of this operation (there are almost no issues).</p>\n<h5 id=\"examples-7\"><a class=\"doc-anchor\" href=\"#examples-7\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>value = f64::from_le_bytes([<span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x29</span>, <span class=\"number\">0x40</span>]);\n<span class=\"macro\">assert_eq!</span>(value, <span class=\"number\">12.5</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+value+=+f64::from_le_bytes(%5B0x00,+0x00,+0x00,+0x00,+0x00,+0x00,+0x29,+0x40%5D);%0Aassert_eq!(value,+12.5);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_ne_bytes\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.40.0, const unstable\">1.40.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/72447\" title=\"Tracking issue for const_float_bits_conv\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1374-1376\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.from_ne_bytes\" class=\"fn\">from_ne_bytes</a>(bytes: [<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>; <a class=\"primitive\" href=\"primitive.array.html\">8</a>]) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Create a floating point value from its representation as a byte array in native endian.</p>\n<p>As the target platform’s native endianness is used, portable code\nlikely wants to use <a href=\"core/primitive.f64.html#method.from_be_bytes\" title=\"associated function f64::from_be_bytes\"><code>from_be_bytes</code></a> or <a href=\"core/primitive.f64.html#method.from_le_bytes\" title=\"associated function f64::from_le_bytes\"><code>from_le_bytes</code></a>, as\nappropriate instead.</p>\n<p>See <a href=\"core/primitive.f64.html#method.from_bits\" title=\"associated function f64::from_bits\"><code>from_bits</code></a> for some discussion of the\nportability of this operation (there are almost no issues).</p>\n<h5 id=\"examples-8\"><a class=\"doc-anchor\" href=\"#examples-8\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>value = f64::from_ne_bytes(<span class=\"kw\">if </span><span class=\"macro\">cfg!</span>(target_endian = <span class=\"string\">\"big\"</span>) {\n    [<span class=\"number\">0x40</span>, <span class=\"number\">0x29</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>]\n} <span class=\"kw\">else </span>{\n    [<span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x00</span>, <span class=\"number\">0x29</span>, <span class=\"number\">0x40</span>]\n});\n<span class=\"macro\">assert_eq!</span>(value, <span class=\"number\">12.5</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+value+=+f64::from_ne_bytes(if+cfg!(target_endian+=+%22big%22)+%7B%0A++++%5B0x40,+0x29,+0x00,+0x00,+0x00,+0x00,+0x00,+0x00%5D%0A%7D+else+%7B%0A++++%5B0x00,+0x00,+0x00,+0x00,+0x00,+0x00,+0x29,+0x40%5D%0A%7D);%0Aassert_eq!(value,+12.5);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.total_cmp\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.62.0\">1.62.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1440-1470\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.total_cmp\" class=\"fn\">total_cmp</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Self</a>) -&gt; <a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a></h4></section></summary><div class=\"docblock\"><p>Return the ordering between <code>self</code> and <code>other</code>.</p>\n<p>Unlike the standard partial comparison between floating point numbers,\nthis comparison always produces an ordering in accordance to\nthe <code>totalOrder</code> predicate as defined in the IEEE 754 (2008 revision)\nfloating point standard. The values are ordered in the following sequence:</p>\n<ul>\n<li>negative quiet NaN</li>\n<li>negative signaling NaN</li>\n<li>negative infinity</li>\n<li>negative numbers</li>\n<li>negative subnormal numbers</li>\n<li>negative zero</li>\n<li>positive zero</li>\n<li>positive subnormal numbers</li>\n<li>positive numbers</li>\n<li>positive infinity</li>\n<li>positive signaling NaN</li>\n<li>positive quiet NaN.</li>\n</ul>\n<p>The ordering established by this function does not always agree with the\n<a href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\"><code>PartialOrd</code></a> and <a href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\"><code>PartialEq</code></a> implementations of <code>f64</code>. For example,\nthey consider negative and positive zero equal, while <code>total_cmp</code>\ndoesn’t.</p>\n<p>The interpretation of the signaling NaN bit follows the definition in\nthe IEEE 754 standard, which may not match the interpretation by some of\nthe older, non-conformant (e.g. MIPS) hardware implementations.</p>\n<h5 id=\"example\"><a class=\"doc-anchor\" href=\"#example\">§</a>Example</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">struct </span>GoodBoy {\n    name: String,\n    weight: f64,\n}\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>bois = <span class=\"macro\">vec!</span>[\n    GoodBoy { name: <span class=\"string\">\"Pucci\"</span>.to_owned(), weight: <span class=\"number\">0.1 </span>},\n    GoodBoy { name: <span class=\"string\">\"Woofer\"</span>.to_owned(), weight: <span class=\"number\">99.0 </span>},\n    GoodBoy { name: <span class=\"string\">\"Yapper\"</span>.to_owned(), weight: <span class=\"number\">10.0 </span>},\n    GoodBoy { name: <span class=\"string\">\"Chonk\"</span>.to_owned(), weight: f64::INFINITY },\n    GoodBoy { name: <span class=\"string\">\"Abs. Unit\"</span>.to_owned(), weight: f64::NAN },\n    GoodBoy { name: <span class=\"string\">\"Floaty\"</span>.to_owned(), weight: -<span class=\"number\">5.0 </span>},\n];\n\nbois.sort_by(|a, b| a.weight.total_cmp(<span class=\"kw-2\">&amp;</span>b.weight));\n\n<span class=\"comment\">// `f64::NAN` could be positive or negative, which will affect the sort order.\n</span><span class=\"kw\">if </span>f64::NAN.is_sign_negative() {\n    <span class=\"macro\">assert!</span>(bois.into_iter().map(|b| b.weight)\n        .zip([f64::NAN, -<span class=\"number\">5.0</span>, <span class=\"number\">0.1</span>, <span class=\"number\">10.0</span>, <span class=\"number\">99.0</span>, f64::INFINITY].iter())\n        .all(|(a, b)| a.to_bits() == b.to_bits()))\n} <span class=\"kw\">else </span>{\n    <span class=\"macro\">assert!</span>(bois.into_iter().map(|b| b.weight)\n        .zip([-<span class=\"number\">5.0</span>, <span class=\"number\">0.1</span>, <span class=\"number\">10.0</span>, <span class=\"number\">99.0</span>, f64::INFINITY, f64::NAN].iter())\n        .all(|(a, b)| a.to_bits() == b.to_bits()))\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Astruct+GoodBoy+%7B%0A++++name:+String,%0A++++weight:+f64,%0A%7D%0A%0Alet+mut+bois+=+vec!%5B%0A++++GoodBoy+%7B+name:+%22Pucci%22.to_owned(),+weight:+0.1+%7D,%0A++++GoodBoy+%7B+name:+%22Woofer%22.to_owned(),+weight:+99.0+%7D,%0A++++GoodBoy+%7B+name:+%22Yapper%22.to_owned(),+weight:+10.0+%7D,%0A++++GoodBoy+%7B+name:+%22Chonk%22.to_owned(),+weight:+f64::INFINITY+%7D,%0A++++GoodBoy+%7B+name:+%22Abs.+Unit%22.to_owned(),+weight:+f64::NAN+%7D,%0A++++GoodBoy+%7B+name:+%22Floaty%22.to_owned(),+weight:+-5.0+%7D,%0A%5D;%0A%0Abois.sort_by(%7Ca,+b%7C+a.weight.total_cmp(%26b.weight));%0A%0A//+%60f64::NAN%60+could+be+positive+or+negative,+which+will+affect+the+sort+order.%0Aif+f64::NAN.is_sign_negative()+%7B%0A++++assert!(bois.into_iter().map(%7Cb%7C+b.weight)%0A++++++++.zip(%5Bf64::NAN,+-5.0,+0.1,+10.0,+99.0,+f64::INFINITY%5D.iter())%0A++++++++.all(%7C(a,+b)%7C+a.to_bits()+==+b.to_bits()))%0A%7D+else+%7B%0A++++assert!(bois.into_iter().map(%7Cb%7C+b.weight)%0A++++++++.zip(%5B-5.0,+0.1,+10.0,+99.0,+f64::INFINITY,+f64::NAN%5D.iter())%0A++++++++.all(%7C(a,+b)%7C+a.to_bits()+==+b.to_bits()))%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clamp\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.50.0\">1.50.0</span> · <a class=\"src\" href=\"src/core/num/f64.rs.html#1495-1504\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"core/primitive.f64.html#tymethod.clamp\" class=\"fn\">clamp</a>(self, min: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>, max: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class=\"docblock\"><p>Restrict a value to a certain interval unless it is NaN.</p>\n<p>Returns <code>max</code> if <code>self</code> is greater than <code>max</code>, and <code>min</code> if <code>self</code> is\nless than <code>min</code>. Otherwise this returns <code>self</code>.</p>\n<p>Note that this function returns NaN if the initial value was NaN as\nwell.</p>\n<h5 id=\"panics\"><a class=\"doc-anchor\" href=\"#panics\">§</a>Panics</h5>\n<p>Panics if <code>min &gt; max</code>, <code>min</code> is NaN, or <code>max</code> is NaN.</p>\n<h5 id=\"examples-9\"><a class=\"doc-anchor\" href=\"#examples-9\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert!</span>((-<span class=\"number\">3.0f64</span>).clamp(-<span class=\"number\">2.0</span>, <span class=\"number\">1.0</span>) == -<span class=\"number\">2.0</span>);\n<span class=\"macro\">assert!</span>((<span class=\"number\">0.0f64</span>).clamp(-<span class=\"number\">2.0</span>, <span class=\"number\">1.0</span>) == <span class=\"number\">0.0</span>);\n<span class=\"macro\">assert!</span>((<span class=\"number\">2.0f64</span>).clamp(-<span class=\"number\">2.0</span>, <span class=\"number\">1.0</span>) == <span class=\"number\">1.0</span>);\n<span class=\"macro\">assert!</span>((f64::NAN).clamp(-<span class=\"number\">2.0</span>, <span class=\"number\">1.0</span>).is_nan());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Aassert!((-3.0f64).clamp(-2.0,+1.0)+==+-2.0);%0Aassert!((0.0f64).clamp(-2.0,+1.0)+==+0.0);%0Aassert!((2.0f64).clamp(-2.0,+1.0)+==+1.0);%0Aassert!((f64::NAN).clamp(-2.0,+1.0).is_nan());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#349\">source</a></span><a href=\"#impl-Mul%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Mul.html\" title=\"trait core::ops::Mul\">Mul</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = &lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"core/ops/trait.Mul.html\" title=\"trait core::ops::Mul\">Mul</a>&gt;::<a class=\"associatedtype\" href=\"core/ops/trait.Mul.html#associatedtype.Output\" title=\"type core::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#349\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; &lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"core/ops/trait.Mul.html\" title=\"trait core::ops::Mul\">Mul</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt;&gt;::<a class=\"associatedtype\" href=\"core/ops/trait.Mul.html#associatedtype.Output\" title=\"type core::ops::Mul::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"core/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul<&f64>","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Cisize%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Cisize%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.isize.html\">isize</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<isize>","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Ci128%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Ci128%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.i128.html\">i128</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<i128>","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Ci64%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Ci64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.i64.html\">i64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<i64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.12.0\">1.12.0</span> · <a class=\"src\" href=\"src/core/iter\\traits/accum.rs.html#150\">source</a></span><a href=\"#impl-Product-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/iter/trait.Product.html\" title=\"trait core::iter::Product\">Product</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/iter\\traits/accum.rs.html#150\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I: <a class=\"trait\" href=\"core/iter/trait.Iterator.html\" title=\"trait core::iter::Iterator\">Iterator</a>&lt;Item = Self&gt;&gt;(iter: I) -&gt; Self</h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1498\">source</a></span><a href=\"#impl-PartialOrd-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1498\">source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1498\">source</a><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1498\">source</a><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;=</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1498\">source</a><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;=</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1498\">source</a><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details></div></details>","PartialOrd","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3Cbool%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.68.0\">1.68.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#191-208\">source</a></span><a href=\"#impl-From%3Cbool%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"primitive\" href=\"primitive.bool.html\">bool</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#205-207\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(small: <a class=\"primitive\" href=\"primitive.bool.html\">bool</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Converts <code>bool</code> to <code>f64</code> losslessly. The resulting value is positive\n<code>0.0</code> for <code>false</code> and <code>1.0</code> for <code>true</code> values.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: f64 = <span class=\"bool-val\">false</span>.into();\n<span class=\"macro\">assert_eq!</span>(x, <span class=\"number\">0.0</span>);\n<span class=\"macro\">assert!</span>(x.is_sign_positive());\n\n<span class=\"kw\">let </span>y: f64 = <span class=\"bool-val\">true</span>.into();\n<span class=\"macro\">assert_eq!</span>(y, <span class=\"number\">1.0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+f64+=+false.into();%0Aassert_eq!(x,+0.0);%0Aassert!(x.is_sign_positive());%0A%0Alet+y:+f64+=+true.into();%0Aassert_eq!(y,+1.0);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<bool>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Default-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/default.rs.html#177\">source</a></span><a href=\"#impl-Default-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/default/trait.Default.html\" title=\"trait core::default::Default\">Default</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.default\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/default.rs.html#177\">source</a><a href=\"#method.default\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/default/trait.Default.html#tymethod.default\" class=\"fn\">default</a>() -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class=\"docblock\"><p>Returns the default value of <code>0.0</code></p>\n</div></details></div></details>","Default","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3Cf32%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.6.0\">1.6.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#168\">source</a></span><a href=\"#impl-From%3Cf32%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"primitive\" href=\"primitive.f32.html\">f32</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#168\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(small: <a class=\"primitive\" href=\"primitive.f32.html\">f32</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Converts <code>f32</code> to <code>f64</code> losslessly.</p>\n</div></details></div></details>","From<f32>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#219\">source</a></span><a href=\"#impl-Sub-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Sub.html\" title=\"trait core::ops::Sub\">Sub</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#219\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"core/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3Ci16%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.6.0\">1.6.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#157\">source</a></span><a href=\"#impl-From%3Ci16%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#157\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(small: <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Converts <code>i16</code> to <code>f64</code> losslessly.</p>\n</div></details></div></details>","From<i16>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Display-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/fmt/float.rs.html#230\">source</a></span><a href=\"#impl-Display-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.Display.html\" title=\"trait core::fmt::Display\">Display</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/fmt/float.rs.html#230\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Display.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, fmt: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Display.html#tymethod.fmt\">Read more</a></div></details></div></details>","Display","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Cusize%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Cusize%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<usize>","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Ci16%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Ci16%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<i16>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3Ci32%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.6.0\">1.6.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#158\">source</a></span><a href=\"#impl-From%3Ci32%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#158\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(small: <a class=\"primitive\" href=\"primitive.i32.html\">i32</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Converts <code>i32</code> to <code>f64</code> losslessly.</p>\n</div></details></div></details>","From<i32>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromStr-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/num\\dec2flt/mod.rs.html#164\">source</a></span><a href=\"#impl-FromStr-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/str/trait.FromStr.html\" title=\"trait core::str::FromStr\">FromStr</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_str\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num\\dec2flt/mod.rs.html#164\">source</a><a href=\"#method.from_str\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/str/trait.FromStr.html#tymethod.from_str\" class=\"fn\">from_str</a>(src: &amp;<a class=\"primitive\" href=\"primitive.str.html\">str</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, <a class=\"struct\" href=\"core/num/struct.ParseFloatError.html\" title=\"struct core::num::ParseFloatError\">ParseFloatError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Converts a string in base 10 to a float.\nAccepts an optional decimal exponent.</p>\n<p>This function accepts strings such as</p>\n<ul>\n<li>‘3.14’</li>\n<li>‘-3.14’</li>\n<li>‘2.5E10’, or equivalently, ‘2.5e10’</li>\n<li>‘2.5E-10’</li>\n<li>‘5.’</li>\n<li>‘.5’, or, equivalently, ‘0.5’</li>\n<li>‘inf’, ‘-inf’, ‘+infinity’, ‘NaN’</li>\n</ul>\n<p>Note that alphabetical characters are not case-sensitive.</p>\n<p>Leading and trailing whitespace represent an error.</p>\n<h5 id=\"grammar\"><a class=\"doc-anchor\" href=\"#grammar\">§</a>Grammar</h5>\n<p>All strings that adhere to the following <a href=\"https://www.w3.org/TR/REC-xml/#sec-notation\">EBNF</a> grammar when\nlowercased will result in an <a href=\"core/result/enum.Result.html#variant.Ok\" title=\"variant core::result::Result::Ok\"><code>Ok</code></a> being returned:</p>\n<div class=\"example-wrap\"><pre class=\"language-txt\"><code>Float  ::= Sign? ( &#39;inf&#39; | &#39;infinity&#39; | &#39;nan&#39; | Number )\nNumber ::= ( Digit+ |\n             Digit+ &#39;.&#39; Digit* |\n             Digit* &#39;.&#39; Digit+ ) Exp?\nExp    ::= &#39;e&#39; Sign? Digit+\nSign   ::= [+-]\nDigit  ::= [0-9]\n</code></pre></div><h5 id=\"arguments\"><a class=\"doc-anchor\" href=\"#arguments\">§</a>Arguments</h5>\n<ul>\n<li>src - A string</li>\n</ul>\n<h5 id=\"return-value\"><a class=\"doc-anchor\" href=\"#return-value\">§</a>Return value</h5>\n<p><code>Err(ParseFloatError)</code> if the string did not represent a valid\nnumber. Otherwise, <code>Ok(n)</code> where <code>n</code> is the closest\nrepresentable floating-point number to the number represented\nby <code>src</code> (following the same rules for rounding as for the\nresults of primitive operations).</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Err\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Err\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/str/trait.FromStr.html#associatedtype.Err\" class=\"associatedtype\">Err</a> = <a class=\"struct\" href=\"core/num/struct.ParseFloatError.html\" title=\"struct core::num::ParseFloatError\">ParseFloatError</a></h4></section></summary><div class='docblock'>The associated error which can be returned from parsing.</div></details></div></details>","FromStr","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-RemAssign%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.22.0\">1.22.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#1009\">source</a></span><a href=\"#impl-RemAssign%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.RemAssign.html\" title=\"trait core::ops::RemAssign\">RemAssign</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#1009\">source</a><a href=\"#method.rem_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.RemAssign.html#tymethod.rem_assign\" class=\"fn\">rem_assign</a>(&amp;mut self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>)</h4></section></summary><div class='docblock'>Performs the <code>%=</code> operation. <a href=\"core/ops/trait.RemAssign.html#tymethod.rem_assign\">Read more</a></div></details></div></details>","RemAssign<&f64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-RemAssign-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.8.0\">1.8.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#1009\">source</a></span><a href=\"#impl-RemAssign-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.RemAssign.html\" title=\"trait core::ops::RemAssign\">RemAssign</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#1009\">source</a><a href=\"#method.rem_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.RemAssign.html#tymethod.rem_assign\" class=\"fn\">rem_assign</a>(&amp;mut self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>)</h4></section></summary><div class='docblock'>Performs the <code>%=</code> operation. <a href=\"core/ops/trait.RemAssign.html#tymethod.rem_assign\">Read more</a></div></details></div></details>","RemAssign","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdElement-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd\\crates\\core_simd\\src/vector.rs.html#955-957\">source</a><a href=\"#impl-SimdElement-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/simd/trait.SimdElement.html\" title=\"trait core::simd::SimdElement\">SimdElement</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/simd/trait.SimdElement.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"primitive\" href=\"primitive.i64.html\">i64</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask element type corresponding to this element type.</div></details></div></details>","SimdElement","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Ci32%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Ci32%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.i32.html\">i32</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<i32>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-LowerExp-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/fmt/float.rs.html#230\">source</a></span><a href=\"#impl-LowerExp-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.LowerExp.html\" title=\"trait core::fmt::LowerExp\">LowerExp</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/fmt/float.rs.html#230\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.LowerExp.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, fmt: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","LowerExp","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Cu32%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Cu32%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<u32>","core::ffi::c_double"],["<section id=\"impl-Copy-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/marker.rs.html#491-501\">source</a></span><a href=\"#impl-Copy-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/marker/trait.Copy.html\" title=\"trait core::marker::Copy\">Copy</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","Copy","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/fmt/float.rs.html#230\">source</a></span><a href=\"#impl-Debug-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/fmt/float.rs.html#230\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, fmt: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-UpperExp-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/fmt/float.rs.html#230\">source</a></span><a href=\"#impl-UpperExp-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.UpperExp.html\" title=\"trait core::fmt::UpperExp\">UpperExp</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/fmt/float.rs.html#230\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.UpperExp.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, fmt: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","UpperExp","core::ffi::c_double"],["<section id=\"impl-SimdCast-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd\\crates\\core_simd\\src/cast.rs.html#51\">source</a><a href=\"#impl-SimdCast-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/simd/trait.SimdCast.html\" title=\"trait core::simd::SimdCast\">SimdCast</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","SimdCast","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-DivAssign%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.22.0\">1.22.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#948\">source</a></span><a href=\"#impl-DivAssign%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.DivAssign.html\" title=\"trait core::ops::DivAssign\">DivAssign</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.div_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#948\">source</a><a href=\"#method.div_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.DivAssign.html#tymethod.div_assign\" class=\"fn\">div_assign</a>(&amp;mut self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>)</h4></section></summary><div class='docblock'>Performs the <code>/=</code> operation. <a href=\"core/ops/trait.DivAssign.html#tymethod.div_assign\">Read more</a></div></details></div></details>","DivAssign<&f64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Product%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.12.0\">1.12.0</span> · <a class=\"src\" href=\"src/core/iter\\traits/accum.rs.html#150\">source</a></span><a href=\"#impl-Product%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a&gt; <a class=\"trait\" href=\"core/iter/trait.Product.html\" title=\"trait core::iter::Product\">Product</a>&lt;&amp;'a <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.product\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/iter\\traits/accum.rs.html#150\">source</a><a href=\"#method.product\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/trait.Product.html#tymethod.product\" class=\"fn\">product</a>&lt;I: <a class=\"trait\" href=\"core/iter/trait.Iterator.html\" title=\"trait core::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"primitive\" href=\"primitive.reference.html\">&amp;'a Self</a>&gt;&gt;(iter: I) -&gt; Self</h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\nmultiplying the items.</div></details></div></details>","Product<&'a f64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/92391\" title=\"Tracking issue for const_cmp\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1444-1446\">source</a></span><a href=\"#impl-PartialEq-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/92391\" title=\"Tracking issue for const_cmp\">unstable</a></span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1444-1446\">source</a></span><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/92391\" title=\"Tracking issue for const_cmp\">unstable</a></span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1444-1446\">source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Mul-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#349\">source</a></span><a href=\"#impl-Mul-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Mul.html\" title=\"trait core::ops::Mul\">Mul</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Mul.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>*</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#349\">source</a><a href=\"#method.mul\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Mul.html#tymethod.mul\" class=\"fn\">mul</a>(self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>Performs the <code>*</code> operation. <a href=\"core/ops/trait.Mul.html#tymethod.mul\">Read more</a></div></details></div></details>","Mul","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Cu8%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Cu8%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<u8>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.12.0\">1.12.0</span> · <a class=\"src\" href=\"src/core/iter\\traits/accum.rs.html#150\">source</a></span><a href=\"#impl-Sum%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a&gt; <a class=\"trait\" href=\"core/iter/trait.Sum.html\" title=\"trait core::iter::Sum\">Sum</a>&lt;&amp;'a <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/iter\\traits/accum.rs.html#150\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I: <a class=\"trait\" href=\"core/iter/trait.Iterator.html\" title=\"trait core::iter::Iterator\">Iterator</a>&lt;Item = <a class=\"primitive\" href=\"primitive.reference.html\">&amp;'a Self</a>&gt;&gt;(iter: I) -&gt; Self</h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum<&'a f64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3Cu8%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.6.0\">1.6.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#162\">source</a></span><a href=\"#impl-From%3Cu8%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#162\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(small: <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Converts <code>u8</code> to <code>f64</code> losslessly.</p>\n</div></details></div></details>","From<u8>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Div-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#507\">source</a></span><a href=\"#impl-Div-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Div.html\" title=\"trait core::ops::Div\">Div</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Div.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>/</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.div\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#507\">source</a><a href=\"#method.div\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Div.html#tymethod.div\" class=\"fn\">div</a>(self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>Performs the <code>/</code> operation. <a href=\"core/ops/trait.Div.html#tymethod.div\">Read more</a></div></details></div></details>","Div","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-DivAssign-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.8.0\">1.8.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#948\">source</a></span><a href=\"#impl-DivAssign-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.DivAssign.html\" title=\"trait core::ops::DivAssign\">DivAssign</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.div_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#948\">source</a><a href=\"#method.div_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.DivAssign.html#tymethod.div_assign\" class=\"fn\">div_assign</a>(&amp;mut self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>)</h4></section></summary><div class='docblock'>Performs the <code>/=</code> operation. <a href=\"core/ops/trait.DivAssign.html#tymethod.div_assign\">Read more</a></div></details></div></details>","DivAssign","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3Cu16%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.6.0\">1.6.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#164\">source</a></span><a href=\"#impl-From%3Cu16%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#164\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(small: <a class=\"primitive\" href=\"primitive.u16.html\">u16</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Converts <code>u16</code> to <code>f64</code> losslessly.</p>\n</div></details></div></details>","From<u16>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3Ci8%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.6.0\">1.6.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#155\">source</a></span><a href=\"#impl-From%3Ci8%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#155\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(small: <a class=\"primitive\" href=\"primitive.i8.html\">i8</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Converts <code>i8</code> to <code>f64</code> losslessly.</p>\n</div></details></div></details>","From<i8>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Clone-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/clone.rs.html#227-232\">source</a></span><a href=\"#impl-Clone-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/clone.rs.html#227-232\">source</a><a href=\"#method.clone\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#tymethod.clone\" class=\"fn\">clone</a>(&amp;self) -&gt; Self</h4></section></summary><div class='docblock'>Returns a copy of the value. <a href=\"core/clone/trait.Clone.html#tymethod.clone\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone_from\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/clone.rs.html#169-171\">source</a></span><a href=\"#method.clone_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#method.clone_from\" class=\"fn\">clone_from</a>(&amp;mut self, source: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Self</a>)</h4></section></summary><div class='docblock'>Performs copy-assignment from <code>source</code>. <a href=\"core/clone/trait.Clone.html#method.clone_from\">Read more</a></div></details></div></details>","Clone","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#110\">source</a></span><a href=\"#impl-Add%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Add.html\" title=\"trait core::ops::Add\">Add</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = &lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"core/ops/trait.Add.html\" title=\"trait core::ops::Add\">Add</a>&gt;::<a class=\"associatedtype\" href=\"core/ops/trait.Add.html#associatedtype.Output\" title=\"type core::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#110\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; &lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"core/ops/trait.Add.html\" title=\"trait core::ops::Add\">Add</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt;&gt;::<a class=\"associatedtype\" href=\"core/ops/trait.Add.html#associatedtype.Output\" title=\"type core::ops::Add::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"core/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add<&f64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Add-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#110\">source</a></span><a href=\"#impl-Add-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Add.html\" title=\"trait core::ops::Add\">Add</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Add.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>+</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#110\">source</a><a href=\"#method.add\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Add.html#tymethod.add\" class=\"fn\">add</a>(self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>Performs the <code>+</code> operation. <a href=\"core/ops/trait.Add.html#tymethod.add\">Read more</a></div></details></div></details>","Add","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Cu128%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Cu128%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.u128.html\">u128</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<u128>","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Cu64%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Cu64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.u64.html\">u64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<u64>","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Cu16%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Cu16%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.u16.html\">u16</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<u16>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#624\">source</a></span><a href=\"#impl-Rem%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Rem.html\" title=\"trait core::ops::Rem\">Rem</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = &lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"core/ops/trait.Rem.html\" title=\"trait core::ops::Rem\">Rem</a>&gt;::<a class=\"associatedtype\" href=\"core/ops/trait.Rem.html#associatedtype.Output\" title=\"type core::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#624\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; &lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"core/ops/trait.Rem.html\" title=\"trait core::ops::Rem\">Rem</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt;&gt;::<a class=\"associatedtype\" href=\"core/ops/trait.Rem.html#associatedtype.Output\" title=\"type core::ops::Rem::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"core/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem<&f64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SubAssign-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.8.0\">1.8.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#833\">source</a></span><a href=\"#impl-SubAssign-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.SubAssign.html\" title=\"trait core::ops::SubAssign\">SubAssign</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#833\">source</a><a href=\"#method.sub_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.SubAssign.html#tymethod.sub_assign\" class=\"fn\">sub_assign</a>(&amp;mut self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>)</h4></section></summary><div class='docblock'>Performs the <code>-=</code> operation. <a href=\"core/ops/trait.SubAssign.html#tymethod.sub_assign\">Read more</a></div></details></div></details>","SubAssign","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Neg-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#699\">source</a></span><a href=\"#impl-Neg-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Neg.html\" title=\"trait core::ops::Neg\">Neg</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Neg.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#699\">source</a><a href=\"#method.neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Neg.html#tymethod.neg\" class=\"fn\">neg</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>Performs the unary <code>-</code> operation. <a href=\"core/ops/trait.Neg.html#tymethod.neg\">Read more</a></div></details></div></details>","Neg","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Div%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#507\">source</a></span><a href=\"#impl-Div%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Div.html\" title=\"trait core::ops::Div\">Div</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Div.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = &lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"core/ops/trait.Div.html\" title=\"trait core::ops::Div\">Div</a>&gt;::<a class=\"associatedtype\" href=\"core/ops/trait.Div.html#associatedtype.Output\" title=\"type core::ops::Div::Output\">Output</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>/</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.div\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#507\">source</a><a href=\"#method.div\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Div.html#tymethod.div\" class=\"fn\">div</a>(self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; &lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"core/ops/trait.Div.html\" title=\"trait core::ops::Div\">Div</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt;&gt;::<a class=\"associatedtype\" href=\"core/ops/trait.Div.html#associatedtype.Output\" title=\"type core::ops::Div::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>/</code> operation. <a href=\"core/ops/trait.Div.html#tymethod.div\">Read more</a></div></details></div></details>","Div<&f64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-MulAssign-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.8.0\">1.8.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#891\">source</a></span><a href=\"#impl-MulAssign-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.MulAssign.html\" title=\"trait core::ops::MulAssign\">MulAssign</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#891\">source</a><a href=\"#method.mul_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.MulAssign.html#tymethod.mul_assign\" class=\"fn\">mul_assign</a>(&amp;mut self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>)</h4></section></summary><div class='docblock'>Performs the <code>*=</code> operation. <a href=\"core/ops/trait.MulAssign.html#tymethod.mul_assign\">Read more</a></div></details></div></details>","MulAssign","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-MulAssign%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.22.0\">1.22.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#891\">source</a></span><a href=\"#impl-MulAssign%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.MulAssign.html\" title=\"trait core::ops::MulAssign\">MulAssign</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.mul_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#891\">source</a><a href=\"#method.mul_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.MulAssign.html#tymethod.mul_assign\" class=\"fn\">mul_assign</a>(&amp;mut self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>)</h4></section></summary><div class='docblock'>Performs the <code>*=</code> operation. <a href=\"core/ops/trait.MulAssign.html#tymethod.mul_assign\">Read more</a></div></details></div></details>","MulAssign<&f64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sum-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.12.0\">1.12.0</span> · <a class=\"src\" href=\"src/core/iter\\traits/accum.rs.html#150\">source</a></span><a href=\"#impl-Sum-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/iter/trait.Sum.html\" title=\"trait core::iter::Sum\">Sum</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sum\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/iter\\traits/accum.rs.html#150\">source</a><a href=\"#method.sum\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/trait.Sum.html#tymethod.sum\" class=\"fn\">sum</a>&lt;I: <a class=\"trait\" href=\"core/iter/trait.Iterator.html\" title=\"trait core::iter::Iterator\">Iterator</a>&lt;Item = Self&gt;&gt;(iter: I) -&gt; Self</h4></section></summary><div class='docblock'>Method which takes an iterator and generates <code>Self</code> from the elements by\n“summing up” the items.</div></details></div></details>","Sum","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Rem-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#624\">source</a></span><a href=\"#impl-Rem-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Rem.html\" title=\"trait core::ops::Rem\">Rem</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"docblock\"><p>The remainder from the division of two floats.</p>\n<p>The remainder has the same sign as the dividend and is computed as:\n<code>x - (x / y).trunc() * y</code>.</p>\n<h4 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h4>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x: f32 = <span class=\"number\">50.50</span>;\n<span class=\"kw\">let </span>y: f32 = <span class=\"number\">8.125</span>;\n<span class=\"kw\">let </span>remainder = x - (x / y).trunc() * y;\n\n<span class=\"comment\">// The answer to both operations is 1.75\n</span><span class=\"macro\">assert_eq!</span>(x % y, remainder);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x:+f32+=+50.50;%0Alet+y:+f32+=+8.125;%0Alet+remainder+=+x+-+(x+/+y).trunc()+*+y;%0A%0A//+The+answer+to+both+operations+is+1.75%0Aassert_eq!(x+%25+y,+remainder);%0A%7D&amp;edition=2021\">Run</a></div>\n</div><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Rem.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>%</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.rem\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#624\">source</a><a href=\"#method.rem\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Rem.html#tymethod.rem\" class=\"fn\">rem</a>(self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h4></section></summary><div class='docblock'>Performs the <code>%</code> operation. <a href=\"core/ops/trait.Rem.html#tymethod.rem\">Read more</a></div></details></div></details>","Rem","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3Cu32%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.6.0\">1.6.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#165\">source</a></span><a href=\"#impl-From%3Cu32%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"primitive\" href=\"primitive.u32.html\">u32</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#165\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(small: <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Converts <code>u32</code> to <code>f64</code> losslessly.</p>\n</div></details></div></details>","From<u32>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AddAssign%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.22.0\">1.22.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#766\">source</a></span><a href=\"#impl-AddAssign%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.AddAssign.html\" title=\"trait core::ops::AddAssign\">AddAssign</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.add_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#766\">source</a><a href=\"#method.add_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.AddAssign.html#tymethod.add_assign\" class=\"fn\">add_assign</a>(&amp;mut self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>)</h4></section></summary><div class='docblock'>Performs the <code>+=</code> operation. <a href=\"core/ops/trait.AddAssign.html#tymethod.add_assign\">Read more</a></div></details></div></details>","AddAssign<&f64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Sub%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#219\">source</a></span><a href=\"#impl-Sub%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Sub.html\" title=\"trait core::ops::Sub\">Sub</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Sub.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = &lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"core/ops/trait.Sub.html\" title=\"trait core::ops::Sub\">Sub</a>&gt;::<a class=\"associatedtype\" href=\"core/ops/trait.Sub.html#associatedtype.Output\" title=\"type core::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#219\">source</a><a href=\"#method.sub\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Sub.html#tymethod.sub\" class=\"fn\">sub</a>(self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>) -&gt; &lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a> as <a class=\"trait\" href=\"core/ops/trait.Sub.html\" title=\"trait core::ops::Sub\">Sub</a>&lt;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt;&gt;::<a class=\"associatedtype\" href=\"core/ops/trait.Sub.html#associatedtype.Output\" title=\"type core::ops::Sub::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>-</code> operation. <a href=\"core/ops/trait.Sub.html#tymethod.sub\">Read more</a></div></details></div></details>","Sub<&f64>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AddAssign-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.8.0\">1.8.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#766\">source</a></span><a href=\"#impl-AddAssign-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.AddAssign.html\" title=\"trait core::ops::AddAssign\">AddAssign</a> for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.add_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#766\">source</a><a href=\"#method.add_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.AddAssign.html#tymethod.add_assign\" class=\"fn\">add_assign</a>(&amp;mut self, other: <a class=\"primitive\" href=\"primitive.f64.html\">f64</a>)</h4></section></summary><div class='docblock'>Performs the <code>+=</code> operation. <a href=\"core/ops/trait.AddAssign.html#tymethod.add_assign\">Read more</a></div></details></div></details>","AddAssign","core::ffi::c_double"],["<section id=\"impl-FloatToInt%3Ci8%3E-for-f64\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#39\">source</a><a href=\"#impl-FloatToInt%3Ci8%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.FloatToInt.html\" title=\"trait core::convert::FloatToInt\">FloatToInt</a>&lt;<a class=\"primitive\" href=\"primitive.i8.html\">i8</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section>","FloatToInt<i8>","core::ffi::c_double"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SubAssign%3C%26f64%3E-for-f64\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.22.0\">1.22.0</span> · <a class=\"src\" href=\"src/core/ops/arith.rs.html#833\">source</a></span><a href=\"#impl-SubAssign%3C%26f64%3E-for-f64\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.SubAssign.html\" title=\"trait core::ops::SubAssign\">SubAssign</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>&gt; for <a class=\"primitive\" href=\"primitive.f64.html\">f64</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ops/arith.rs.html#833\">source</a><a href=\"#method.sub_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.SubAssign.html#tymethod.sub_assign\" class=\"fn\">sub_assign</a>(&amp;mut self, other: &amp;<a class=\"primitive\" href=\"primitive.f64.html\">f64</a>)</h4></section></summary><div class='docblock'>Performs the <code>-=</code> operation. <a href=\"core/ops/trait.SubAssign.html#tymethod.sub_assign\">Read more</a></div></details></div></details>","SubAssign<&f64>","core::ffi::c_double"]]
};if (window.register_type_impls) {window.register_type_impls(type_impls);} else {window.pending_type_impls = type_impls;}})()