﻿!mod$ v1 sum:f4e4714d26fb7c5f
module w90_berry
use w90_constants,only:dp
private::dp
integer(4),parameter,private::alpha_a(1_8:3_8)=[INTEGER(4)::2_4,3_4,1_4]
integer(4),parameter,private::beta_a(1_8:3_8)=[INTEGER(4)::3_4,1_4,2_4]
integer(4),parameter,private::alpha_s(1_8:6_8)=[INTEGER(4)::1_4,2_4,3_4,1_4,1_4,2_4]
integer(4),parameter,private::beta_s(1_8:6_8)=[INTEGER(4)::1_4,2_4,3_4,2_4,3_4,3_4]
integer(4),parameter::berry_alpha_s(1_8:6_8)=[INTEGER(4)::1_4,2_4,3_4,1_4,1_4,2_4]
integer(4),parameter::berry_beta_s(1_8:6_8)=[INTEGER(4)::1_4,2_4,3_4,2_4,3_4,3_4]
integer(4),parameter::berry_alpha_beta_s(1_8:3_8,1_8:3_8)=reshape([INTEGER(4)::1_4,4_4,5_4,4_4,2_4,6_4,5_4,6_4,3_4],shape=[3,3])
intrinsic::reshape
private::reshape
private::berry_get_kubo_k
private::berry_print_progress
contains
subroutine berry_main()
end
subroutine berry_get_imf_klist(kpt,imf_k_list,occ,ladpt)
real(8),intent(in)::kpt(1_8:3_8)
real(8),intent(out)::imf_k_list(:,:,:)
real(8),intent(in),optional::occ(:)
logical(4),intent(in),optional::ladpt(:)
end
subroutine berry_get_imfgh_klist(kpt,imf_k_list,img_k_list,imh_k_list,occ,ladpt)
real(8),intent(in)::kpt(1_8:3_8)
real(8),intent(out),optional::imf_k_list(:,:,:)
real(8),intent(out),optional::img_k_list(:,:,:)
real(8),intent(out),optional::imh_k_list(:,:,:)
real(8),intent(in),optional::occ(:)
logical(4),intent(in),optional::ladpt(:)
end
subroutine berry_get_kubo_k(kpt,kubo_h_k,kubo_ah_k,jdos_k,kubo_h_k_spn,kubo_ah_k_spn,jdos_k_spn)
real(8),intent(in)::kpt(1_8:3_8)
complex(8),intent(out)::kubo_h_k(:,:,:)
complex(8),intent(out)::kubo_ah_k(:,:,:)
real(8),intent(out)::jdos_k(:)
complex(8),intent(out),optional::kubo_h_k_spn(:,:,:,:)
complex(8),intent(out),optional::kubo_ah_k_spn(:,:,:,:)
real(8),intent(out),optional::jdos_k_spn(:,:)
end
subroutine berry_get_sc_klist(kpt,sc_k_list)
real(8),intent(in)::kpt(1_8:3_8)
real(8),intent(out)::sc_k_list(:,:,:)
end
subroutine berry_get_shc_klist(kpt,shc_k_fermi,shc_k_freq,shc_k_band)
use w90_parameters,only:nfermi
use w90_parameters,only:kubo_nfreq
use w90_parameters,only:num_wann
real(8),intent(in)::kpt(1_8:3_8)
real(8),intent(out),optional::shc_k_fermi(1_8:int(nfermi,kind=8))
complex(8),intent(out),optional::shc_k_freq(1_8:int(kubo_nfreq,kind=8))
real(8),intent(out),optional::shc_k_band(1_8:int(num_wann,kind=8))
end
subroutine berry_print_progress(loop_k,start_k,end_k,step_k)
integer(4),intent(in)::loop_k
integer(4),intent(in)::start_k
integer(4),intent(in)::end_k
integer(4),intent(in)::step_k
end
end
