pragma Ada_2012;

pragma Style_Checks (Off);
pragma Warnings (Off, "-gnatwu");

with Interfaces.C; use Interfaces.C;

package libfswatch_types_h is

  -- * Copyright (c) 2015-2022 Enrico M. Crisostomo
  -- *
  -- * This program is free software; you can redistribute it and/or modify it under
  -- * the terms of the GNU General Public License as published by the Free Software
  -- * Foundation; either version 3, or (at your option) any later version.
  -- *
  -- * This program is distributed in the hope that it will be useful, but WITHOUT
  -- * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  -- * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  -- * details.
  -- *
  -- * You should have received a copy of the GNU General Public License along with
  -- * this program.  If not, see <http://www.gnu.org/licenses/>.
  --  

  --*
  -- * @file
  -- * @brief Header of the `libfswatch` library containing common types.
  -- *
  -- * This header file defines the types used by the `libfswatch` library.
  -- *
  -- * @copyright Copyright (c) 2014-2015 Enrico M. Crisostomo
  -- * @license GNU General Public License v. 3.0
  -- * @author Enrico M. Crisostomo
  -- * @version 1.8.0
  --  

  --*
  -- * @brief Opaque type representing a monitoring session.
  --  

   type FSW_SESSION is null record;   -- incomplete struct

  --*
  -- * @brief Handle to a monitoring session.
  --  

   type FSW_HANDLE is access all FSW_SESSION;  -- D:/a/msys64/mingw64/include/libfswatch/c/libfswatch_types.h:44

  --*
  -- * @brief Status of a library call.
  --  

   subtype FSW_STATUS is int;  -- D:/a/msys64/mingw64/include/libfswatch/c/libfswatch_types.h:49

end libfswatch_types_h;

pragma Style_Checks (On);
pragma Warnings (On, "-gnatwu");
