pragma Ada_2012;

pragma Style_Checks (Off);
pragma Warnings (Off, "-gnatwu");

with Interfaces.C; use Interfaces.C;
limited with sys_timeb_h;
with pthread_compat_h;

package pthread_time_h is

   TIMER_ABSTIME : constant := 1;  --  D:/a/msys64/mingw64/include/pthread_time.h:49

   CLOCK_REALTIME : constant := 0;  --  D:/a/msys64/mingw64/include/pthread_time.h:53

   CLOCK_MONOTONIC : constant := 1;  --  D:/a/msys64/mingw64/include/pthread_time.h:57

   CLOCK_PROCESS_CPUTIME_ID : constant := 2;  --  D:/a/msys64/mingw64/include/pthread_time.h:61

   CLOCK_THREAD_CPUTIME_ID : constant := 3;  --  D:/a/msys64/mingw64/include/pthread_time.h:65

   CLOCK_REALTIME_COARSE : constant := 4;  --  D:/a/msys64/mingw64/include/pthread_time.h:69

  --   Copyright (c) 2011-2016  mingw-w64 project
  --   Permission is hereby granted, free of charge, to any person obtaining a
  --   copy of this software and associated documentation files (the "Software"),
  --   to deal in the Software without restriction, including without limitation
  --   the rights to use, copy, modify, merge, publish, distribute, sublicense,
  --   and/or sell copies of the Software, and to permit persons to whom the
  --   Software is furnished to do so, subject to the following conditions:
  --   The above copyright notice and this permission notice shall be included in
  --   all copies or substantial portions of the Software.
  --   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  --   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  --   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  --   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  --   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  --   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  --   DEALINGS IN THE SOFTWARE.
  -- 

  -- Posix timers are supported  
  -- Monotonic clocks are available.   
  -- CPU-time clocks are available.   
  -- Clock support in threads are available.   
   function nanosleep (request : access constant sys_timeb_h.timespec; remain : access sys_timeb_h.timespec) return int  -- D:/a/msys64/mingw64/include/pthread_time.h:76
   with Import => True, 
        Convention => C, 
        External_Name => "nanosleep";

   function clock_nanosleep
     (clock_id : pthread_compat_h.clockid_t;
      flags : int;
      request : access constant sys_timeb_h.timespec;
      remain : access sys_timeb_h.timespec) return int  -- D:/a/msys64/mingw64/include/pthread_time.h:78
   with Import => True, 
        Convention => C, 
        External_Name => "clock_nanosleep";

   function clock_getres (clock_id : pthread_compat_h.clockid_t; res : access sys_timeb_h.timespec) return int  -- D:/a/msys64/mingw64/include/pthread_time.h:79
   with Import => True, 
        Convention => C, 
        External_Name => "clock_getres";

   function clock_gettime (clock_id : pthread_compat_h.clockid_t; tp : access sys_timeb_h.timespec) return int  -- D:/a/msys64/mingw64/include/pthread_time.h:80
   with Import => True, 
        Convention => C, 
        External_Name => "clock_gettime";

   function clock_settime (clock_id : pthread_compat_h.clockid_t; tp : access constant sys_timeb_h.timespec) return int  -- D:/a/msys64/mingw64/include/pthread_time.h:81
   with Import => True, 
        Convention => C, 
        External_Name => "clock_settime";

end pthread_time_h;

pragma Style_Checks (On);
pragma Warnings (On, "-gnatwu");
