/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_TABLES_0_H
#define LEXBOR_UNICODE_TABLES_0_H

#ifdef __cplusplus
extern "C" {
#endif


static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0041 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0042 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0043 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0044 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0045 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0046 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0047 = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0048 = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0049 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_004A = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_004B = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_004C = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_004D = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_004E = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_004F = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0050 = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0051 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0052 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0053 = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0054 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0055 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0056 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0057 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0058 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0059 = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_005A = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00A0 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00A8 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0308}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00AA = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00AF = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0304}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00B2 = {.cps = (lxb_codepoint_t[]) {0x0032}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00B3 = {.cps = (lxb_codepoint_t[]) {0x0033}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00B4 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0301}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00B5 = {.cps = (lxb_codepoint_t[]) {0x03BC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00B8 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0327}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00B9 = {.cps = (lxb_codepoint_t[]) {0x0031}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00BA = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00BC = {.cps = (lxb_codepoint_t[]) {0x0031, 0x2044, 0x0034}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00BD = {.cps = (lxb_codepoint_t[]) {0x0031, 0x2044, 0x0032}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00BE = {.cps = (lxb_codepoint_t[]) {0x0033, 0x2044, 0x0034}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00C0 = {.cps = (lxb_codepoint_t[]) {0x00E0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00C1 = {.cps = (lxb_codepoint_t[]) {0x00E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00C2 = {.cps = (lxb_codepoint_t[]) {0x00E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00C3 = {.cps = (lxb_codepoint_t[]) {0x00E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00C4 = {.cps = (lxb_codepoint_t[]) {0x00E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00C5 = {.cps = (lxb_codepoint_t[]) {0x00E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00C6 = {.cps = (lxb_codepoint_t[]) {0x00E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00C7 = {.cps = (lxb_codepoint_t[]) {0x00E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00C8 = {.cps = (lxb_codepoint_t[]) {0x00E8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00C9 = {.cps = (lxb_codepoint_t[]) {0x00E9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00CA = {.cps = (lxb_codepoint_t[]) {0x00EA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00CB = {.cps = (lxb_codepoint_t[]) {0x00EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00CC = {.cps = (lxb_codepoint_t[]) {0x00EC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00CD = {.cps = (lxb_codepoint_t[]) {0x00ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00CE = {.cps = (lxb_codepoint_t[]) {0x00EE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00CF = {.cps = (lxb_codepoint_t[]) {0x00EF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00D0 = {.cps = (lxb_codepoint_t[]) {0x00F0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00D1 = {.cps = (lxb_codepoint_t[]) {0x00F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00D2 = {.cps = (lxb_codepoint_t[]) {0x00F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00D3 = {.cps = (lxb_codepoint_t[]) {0x00F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00D4 = {.cps = (lxb_codepoint_t[]) {0x00F4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00D5 = {.cps = (lxb_codepoint_t[]) {0x00F5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00D6 = {.cps = (lxb_codepoint_t[]) {0x00F6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00D8 = {.cps = (lxb_codepoint_t[]) {0x00F8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00D9 = {.cps = (lxb_codepoint_t[]) {0x00F9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00DA = {.cps = (lxb_codepoint_t[]) {0x00FA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00DB = {.cps = (lxb_codepoint_t[]) {0x00FB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00DC = {.cps = (lxb_codepoint_t[]) {0x00FC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00DD = {.cps = (lxb_codepoint_t[]) {0x00FD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00DE = {.cps = (lxb_codepoint_t[]) {0x00FE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_00DF = {.cps = (lxb_codepoint_t[]) {0x0073, 0x0073}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0100 = {.cps = (lxb_codepoint_t[]) {0x0101}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0102 = {.cps = (lxb_codepoint_t[]) {0x0103}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0104 = {.cps = (lxb_codepoint_t[]) {0x0105}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0106 = {.cps = (lxb_codepoint_t[]) {0x0107}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0108 = {.cps = (lxb_codepoint_t[]) {0x0109}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_010A = {.cps = (lxb_codepoint_t[]) {0x010B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_010C = {.cps = (lxb_codepoint_t[]) {0x010D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_010E = {.cps = (lxb_codepoint_t[]) {0x010F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0110 = {.cps = (lxb_codepoint_t[]) {0x0111}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0112 = {.cps = (lxb_codepoint_t[]) {0x0113}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0114 = {.cps = (lxb_codepoint_t[]) {0x0115}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0116 = {.cps = (lxb_codepoint_t[]) {0x0117}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0118 = {.cps = (lxb_codepoint_t[]) {0x0119}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_011A = {.cps = (lxb_codepoint_t[]) {0x011B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_011C = {.cps = (lxb_codepoint_t[]) {0x011D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_011E = {.cps = (lxb_codepoint_t[]) {0x011F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0120 = {.cps = (lxb_codepoint_t[]) {0x0121}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0122 = {.cps = (lxb_codepoint_t[]) {0x0123}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0124 = {.cps = (lxb_codepoint_t[]) {0x0125}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0126 = {.cps = (lxb_codepoint_t[]) {0x0127}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0128 = {.cps = (lxb_codepoint_t[]) {0x0129}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_012A = {.cps = (lxb_codepoint_t[]) {0x012B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_012C = {.cps = (lxb_codepoint_t[]) {0x012D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_012E = {.cps = (lxb_codepoint_t[]) {0x012F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0130 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x0307}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0132 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x006A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0133 = {.cps = (lxb_codepoint_t[]) {0x0069, 0x006A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0134 = {.cps = (lxb_codepoint_t[]) {0x0135}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0136 = {.cps = (lxb_codepoint_t[]) {0x0137}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0139 = {.cps = (lxb_codepoint_t[]) {0x013A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_013B = {.cps = (lxb_codepoint_t[]) {0x013C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_013D = {.cps = (lxb_codepoint_t[]) {0x013E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_013F = {.cps = (lxb_codepoint_t[]) {0x006C, 0x00B7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0140 = {.cps = (lxb_codepoint_t[]) {0x006C, 0x00B7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0141 = {.cps = (lxb_codepoint_t[]) {0x0142}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0143 = {.cps = (lxb_codepoint_t[]) {0x0144}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0145 = {.cps = (lxb_codepoint_t[]) {0x0146}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0147 = {.cps = (lxb_codepoint_t[]) {0x0148}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0149 = {.cps = (lxb_codepoint_t[]) {0x02BC, 0x006E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_014A = {.cps = (lxb_codepoint_t[]) {0x014B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_014C = {.cps = (lxb_codepoint_t[]) {0x014D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_014E = {.cps = (lxb_codepoint_t[]) {0x014F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0150 = {.cps = (lxb_codepoint_t[]) {0x0151}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0152 = {.cps = (lxb_codepoint_t[]) {0x0153}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0154 = {.cps = (lxb_codepoint_t[]) {0x0155}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0156 = {.cps = (lxb_codepoint_t[]) {0x0157}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0158 = {.cps = (lxb_codepoint_t[]) {0x0159}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_015A = {.cps = (lxb_codepoint_t[]) {0x015B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_015C = {.cps = (lxb_codepoint_t[]) {0x015D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_015E = {.cps = (lxb_codepoint_t[]) {0x015F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0160 = {.cps = (lxb_codepoint_t[]) {0x0161}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0162 = {.cps = (lxb_codepoint_t[]) {0x0163}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0164 = {.cps = (lxb_codepoint_t[]) {0x0165}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0166 = {.cps = (lxb_codepoint_t[]) {0x0167}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0168 = {.cps = (lxb_codepoint_t[]) {0x0169}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_016A = {.cps = (lxb_codepoint_t[]) {0x016B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_016C = {.cps = (lxb_codepoint_t[]) {0x016D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_016E = {.cps = (lxb_codepoint_t[]) {0x016F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0170 = {.cps = (lxb_codepoint_t[]) {0x0171}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0172 = {.cps = (lxb_codepoint_t[]) {0x0173}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0174 = {.cps = (lxb_codepoint_t[]) {0x0175}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0176 = {.cps = (lxb_codepoint_t[]) {0x0177}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0178 = {.cps = (lxb_codepoint_t[]) {0x00FF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0179 = {.cps = (lxb_codepoint_t[]) {0x017A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_017B = {.cps = (lxb_codepoint_t[]) {0x017C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_017D = {.cps = (lxb_codepoint_t[]) {0x017E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_017F = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0181 = {.cps = (lxb_codepoint_t[]) {0x0253}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0182 = {.cps = (lxb_codepoint_t[]) {0x0183}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0184 = {.cps = (lxb_codepoint_t[]) {0x0185}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0186 = {.cps = (lxb_codepoint_t[]) {0x0254}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0187 = {.cps = (lxb_codepoint_t[]) {0x0188}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0189 = {.cps = (lxb_codepoint_t[]) {0x0256}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_018A = {.cps = (lxb_codepoint_t[]) {0x0257}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_018B = {.cps = (lxb_codepoint_t[]) {0x018C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_018E = {.cps = (lxb_codepoint_t[]) {0x01DD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_018F = {.cps = (lxb_codepoint_t[]) {0x0259}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0190 = {.cps = (lxb_codepoint_t[]) {0x025B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0191 = {.cps = (lxb_codepoint_t[]) {0x0192}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0193 = {.cps = (lxb_codepoint_t[]) {0x0260}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0194 = {.cps = (lxb_codepoint_t[]) {0x0263}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0196 = {.cps = (lxb_codepoint_t[]) {0x0269}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0197 = {.cps = (lxb_codepoint_t[]) {0x0268}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0198 = {.cps = (lxb_codepoint_t[]) {0x0199}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_019C = {.cps = (lxb_codepoint_t[]) {0x026F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_019D = {.cps = (lxb_codepoint_t[]) {0x0272}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_019F = {.cps = (lxb_codepoint_t[]) {0x0275}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01A0 = {.cps = (lxb_codepoint_t[]) {0x01A1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01A2 = {.cps = (lxb_codepoint_t[]) {0x01A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01A4 = {.cps = (lxb_codepoint_t[]) {0x01A5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01A6 = {.cps = (lxb_codepoint_t[]) {0x0280}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01A7 = {.cps = (lxb_codepoint_t[]) {0x01A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01A9 = {.cps = (lxb_codepoint_t[]) {0x0283}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01AC = {.cps = (lxb_codepoint_t[]) {0x01AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01AE = {.cps = (lxb_codepoint_t[]) {0x0288}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01AF = {.cps = (lxb_codepoint_t[]) {0x01B0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01B1 = {.cps = (lxb_codepoint_t[]) {0x028A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01B2 = {.cps = (lxb_codepoint_t[]) {0x028B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01B3 = {.cps = (lxb_codepoint_t[]) {0x01B4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01B5 = {.cps = (lxb_codepoint_t[]) {0x01B6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01B7 = {.cps = (lxb_codepoint_t[]) {0x0292}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01B8 = {.cps = (lxb_codepoint_t[]) {0x01B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01BC = {.cps = (lxb_codepoint_t[]) {0x01BD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01C4 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x017E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01C5 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x017E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01C6 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x017E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01C7 = {.cps = (lxb_codepoint_t[]) {0x006C, 0x006A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01C8 = {.cps = (lxb_codepoint_t[]) {0x006C, 0x006A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01C9 = {.cps = (lxb_codepoint_t[]) {0x006C, 0x006A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01CA = {.cps = (lxb_codepoint_t[]) {0x006E, 0x006A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01CB = {.cps = (lxb_codepoint_t[]) {0x006E, 0x006A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01CC = {.cps = (lxb_codepoint_t[]) {0x006E, 0x006A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01CD = {.cps = (lxb_codepoint_t[]) {0x01CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01CF = {.cps = (lxb_codepoint_t[]) {0x01D0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01D1 = {.cps = (lxb_codepoint_t[]) {0x01D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01D3 = {.cps = (lxb_codepoint_t[]) {0x01D4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01D5 = {.cps = (lxb_codepoint_t[]) {0x01D6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01D7 = {.cps = (lxb_codepoint_t[]) {0x01D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01D9 = {.cps = (lxb_codepoint_t[]) {0x01DA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01DB = {.cps = (lxb_codepoint_t[]) {0x01DC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01DE = {.cps = (lxb_codepoint_t[]) {0x01DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01E0 = {.cps = (lxb_codepoint_t[]) {0x01E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01E2 = {.cps = (lxb_codepoint_t[]) {0x01E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01E4 = {.cps = (lxb_codepoint_t[]) {0x01E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01E6 = {.cps = (lxb_codepoint_t[]) {0x01E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01E8 = {.cps = (lxb_codepoint_t[]) {0x01E9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01EA = {.cps = (lxb_codepoint_t[]) {0x01EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01EC = {.cps = (lxb_codepoint_t[]) {0x01ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01EE = {.cps = (lxb_codepoint_t[]) {0x01EF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01F1 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x007A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01F2 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x007A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01F3 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x007A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01F4 = {.cps = (lxb_codepoint_t[]) {0x01F5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01F6 = {.cps = (lxb_codepoint_t[]) {0x0195}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01F7 = {.cps = (lxb_codepoint_t[]) {0x01BF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01F8 = {.cps = (lxb_codepoint_t[]) {0x01F9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01FA = {.cps = (lxb_codepoint_t[]) {0x01FB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01FC = {.cps = (lxb_codepoint_t[]) {0x01FD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_01FE = {.cps = (lxb_codepoint_t[]) {0x01FF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0200 = {.cps = (lxb_codepoint_t[]) {0x0201}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0202 = {.cps = (lxb_codepoint_t[]) {0x0203}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0204 = {.cps = (lxb_codepoint_t[]) {0x0205}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0206 = {.cps = (lxb_codepoint_t[]) {0x0207}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0208 = {.cps = (lxb_codepoint_t[]) {0x0209}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_020A = {.cps = (lxb_codepoint_t[]) {0x020B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_020C = {.cps = (lxb_codepoint_t[]) {0x020D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_020E = {.cps = (lxb_codepoint_t[]) {0x020F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0210 = {.cps = (lxb_codepoint_t[]) {0x0211}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0212 = {.cps = (lxb_codepoint_t[]) {0x0213}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0214 = {.cps = (lxb_codepoint_t[]) {0x0215}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0216 = {.cps = (lxb_codepoint_t[]) {0x0217}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0218 = {.cps = (lxb_codepoint_t[]) {0x0219}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_021A = {.cps = (lxb_codepoint_t[]) {0x021B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_021C = {.cps = (lxb_codepoint_t[]) {0x021D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_021E = {.cps = (lxb_codepoint_t[]) {0x021F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0220 = {.cps = (lxb_codepoint_t[]) {0x019E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0222 = {.cps = (lxb_codepoint_t[]) {0x0223}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0224 = {.cps = (lxb_codepoint_t[]) {0x0225}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0226 = {.cps = (lxb_codepoint_t[]) {0x0227}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0228 = {.cps = (lxb_codepoint_t[]) {0x0229}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_022A = {.cps = (lxb_codepoint_t[]) {0x022B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_022C = {.cps = (lxb_codepoint_t[]) {0x022D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_022E = {.cps = (lxb_codepoint_t[]) {0x022F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0230 = {.cps = (lxb_codepoint_t[]) {0x0231}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0232 = {.cps = (lxb_codepoint_t[]) {0x0233}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_023A = {.cps = (lxb_codepoint_t[]) {0x2C65}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_023B = {.cps = (lxb_codepoint_t[]) {0x023C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_023D = {.cps = (lxb_codepoint_t[]) {0x019A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_023E = {.cps = (lxb_codepoint_t[]) {0x2C66}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0241 = {.cps = (lxb_codepoint_t[]) {0x0242}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0243 = {.cps = (lxb_codepoint_t[]) {0x0180}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0244 = {.cps = (lxb_codepoint_t[]) {0x0289}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0245 = {.cps = (lxb_codepoint_t[]) {0x028C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0246 = {.cps = (lxb_codepoint_t[]) {0x0247}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0248 = {.cps = (lxb_codepoint_t[]) {0x0249}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_024A = {.cps = (lxb_codepoint_t[]) {0x024B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_024C = {.cps = (lxb_codepoint_t[]) {0x024D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_024E = {.cps = (lxb_codepoint_t[]) {0x024F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02B0 = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02B1 = {.cps = (lxb_codepoint_t[]) {0x0266}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02B2 = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02B3 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02B4 = {.cps = (lxb_codepoint_t[]) {0x0279}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02B5 = {.cps = (lxb_codepoint_t[]) {0x027B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02B6 = {.cps = (lxb_codepoint_t[]) {0x0281}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02B7 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02B8 = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02D8 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0306}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02D9 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0307}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02DA = {.cps = (lxb_codepoint_t[]) {0x0020, 0x030A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02DB = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0328}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02DC = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0303}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02DD = {.cps = (lxb_codepoint_t[]) {0x0020, 0x030B}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02E0 = {.cps = (lxb_codepoint_t[]) {0x0263}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02E1 = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02E2 = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02E3 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_02E4 = {.cps = (lxb_codepoint_t[]) {0x0295}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0340 = {.cps = (lxb_codepoint_t[]) {0x0300}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0341 = {.cps = (lxb_codepoint_t[]) {0x0301}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0343 = {.cps = (lxb_codepoint_t[]) {0x0313}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0344 = {.cps = (lxb_codepoint_t[]) {0x0308, 0x0301}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0345 = {.cps = (lxb_codepoint_t[]) {0x03B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0370 = {.cps = (lxb_codepoint_t[]) {0x0371}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0372 = {.cps = (lxb_codepoint_t[]) {0x0373}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0374 = {.cps = (lxb_codepoint_t[]) {0x02B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0376 = {.cps = (lxb_codepoint_t[]) {0x0377}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_037A = {.cps = (lxb_codepoint_t[]) {0x0020, 0x03B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_037E = {.cps = (lxb_codepoint_t[]) {0x003B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_037F = {.cps = (lxb_codepoint_t[]) {0x03F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0384 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0301}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0385 = {.cps = (lxb_codepoint_t[]) {0x0020, 0x0308, 0x0301}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0386 = {.cps = (lxb_codepoint_t[]) {0x03AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0387 = {.cps = (lxb_codepoint_t[]) {0x00B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0388 = {.cps = (lxb_codepoint_t[]) {0x03AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0389 = {.cps = (lxb_codepoint_t[]) {0x03AE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_038A = {.cps = (lxb_codepoint_t[]) {0x03AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_038C = {.cps = (lxb_codepoint_t[]) {0x03CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_038E = {.cps = (lxb_codepoint_t[]) {0x03CD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_038F = {.cps = (lxb_codepoint_t[]) {0x03CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0391 = {.cps = (lxb_codepoint_t[]) {0x03B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0392 = {.cps = (lxb_codepoint_t[]) {0x03B2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0393 = {.cps = (lxb_codepoint_t[]) {0x03B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0394 = {.cps = (lxb_codepoint_t[]) {0x03B4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0395 = {.cps = (lxb_codepoint_t[]) {0x03B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0396 = {.cps = (lxb_codepoint_t[]) {0x03B6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0397 = {.cps = (lxb_codepoint_t[]) {0x03B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0398 = {.cps = (lxb_codepoint_t[]) {0x03B8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0399 = {.cps = (lxb_codepoint_t[]) {0x03B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_039A = {.cps = (lxb_codepoint_t[]) {0x03BA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_039B = {.cps = (lxb_codepoint_t[]) {0x03BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_039C = {.cps = (lxb_codepoint_t[]) {0x03BC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_039D = {.cps = (lxb_codepoint_t[]) {0x03BD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_039E = {.cps = (lxb_codepoint_t[]) {0x03BE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_039F = {.cps = (lxb_codepoint_t[]) {0x03BF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03A0 = {.cps = (lxb_codepoint_t[]) {0x03C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03A1 = {.cps = (lxb_codepoint_t[]) {0x03C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03A3 = {.cps = (lxb_codepoint_t[]) {0x03C3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03A4 = {.cps = (lxb_codepoint_t[]) {0x03C4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03A5 = {.cps = (lxb_codepoint_t[]) {0x03C5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03A6 = {.cps = (lxb_codepoint_t[]) {0x03C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03A7 = {.cps = (lxb_codepoint_t[]) {0x03C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03A8 = {.cps = (lxb_codepoint_t[]) {0x03C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03A9 = {.cps = (lxb_codepoint_t[]) {0x03C9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03AA = {.cps = (lxb_codepoint_t[]) {0x03CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03AB = {.cps = (lxb_codepoint_t[]) {0x03CB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03C2 = {.cps = (lxb_codepoint_t[]) {0x03C3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03CF = {.cps = (lxb_codepoint_t[]) {0x03D7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03D0 = {.cps = (lxb_codepoint_t[]) {0x03B2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03D1 = {.cps = (lxb_codepoint_t[]) {0x03B8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03D2 = {.cps = (lxb_codepoint_t[]) {0x03C5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03D3 = {.cps = (lxb_codepoint_t[]) {0x03CD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03D4 = {.cps = (lxb_codepoint_t[]) {0x03CB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03D5 = {.cps = (lxb_codepoint_t[]) {0x03C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03D6 = {.cps = (lxb_codepoint_t[]) {0x03C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03D8 = {.cps = (lxb_codepoint_t[]) {0x03D9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03DA = {.cps = (lxb_codepoint_t[]) {0x03DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03DC = {.cps = (lxb_codepoint_t[]) {0x03DD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03DE = {.cps = (lxb_codepoint_t[]) {0x03DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03E0 = {.cps = (lxb_codepoint_t[]) {0x03E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03E2 = {.cps = (lxb_codepoint_t[]) {0x03E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03E4 = {.cps = (lxb_codepoint_t[]) {0x03E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03E6 = {.cps = (lxb_codepoint_t[]) {0x03E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03E8 = {.cps = (lxb_codepoint_t[]) {0x03E9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03EA = {.cps = (lxb_codepoint_t[]) {0x03EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03EC = {.cps = (lxb_codepoint_t[]) {0x03ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03EE = {.cps = (lxb_codepoint_t[]) {0x03EF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03F0 = {.cps = (lxb_codepoint_t[]) {0x03BA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03F1 = {.cps = (lxb_codepoint_t[]) {0x03C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03F2 = {.cps = (lxb_codepoint_t[]) {0x03C3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03F4 = {.cps = (lxb_codepoint_t[]) {0x03B8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03F5 = {.cps = (lxb_codepoint_t[]) {0x03B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03F7 = {.cps = (lxb_codepoint_t[]) {0x03F8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03F9 = {.cps = (lxb_codepoint_t[]) {0x03C3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03FA = {.cps = (lxb_codepoint_t[]) {0x03FB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03FD = {.cps = (lxb_codepoint_t[]) {0x037B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03FE = {.cps = (lxb_codepoint_t[]) {0x037C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_03FF = {.cps = (lxb_codepoint_t[]) {0x037D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0400 = {.cps = (lxb_codepoint_t[]) {0x0450}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0401 = {.cps = (lxb_codepoint_t[]) {0x0451}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0402 = {.cps = (lxb_codepoint_t[]) {0x0452}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0403 = {.cps = (lxb_codepoint_t[]) {0x0453}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0404 = {.cps = (lxb_codepoint_t[]) {0x0454}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0405 = {.cps = (lxb_codepoint_t[]) {0x0455}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0406 = {.cps = (lxb_codepoint_t[]) {0x0456}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0407 = {.cps = (lxb_codepoint_t[]) {0x0457}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0408 = {.cps = (lxb_codepoint_t[]) {0x0458}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0409 = {.cps = (lxb_codepoint_t[]) {0x0459}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_040A = {.cps = (lxb_codepoint_t[]) {0x045A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_040B = {.cps = (lxb_codepoint_t[]) {0x045B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_040C = {.cps = (lxb_codepoint_t[]) {0x045C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_040D = {.cps = (lxb_codepoint_t[]) {0x045D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_040E = {.cps = (lxb_codepoint_t[]) {0x045E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_040F = {.cps = (lxb_codepoint_t[]) {0x045F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0410 = {.cps = (lxb_codepoint_t[]) {0x0430}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0411 = {.cps = (lxb_codepoint_t[]) {0x0431}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0412 = {.cps = (lxb_codepoint_t[]) {0x0432}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0413 = {.cps = (lxb_codepoint_t[]) {0x0433}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0414 = {.cps = (lxb_codepoint_t[]) {0x0434}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0415 = {.cps = (lxb_codepoint_t[]) {0x0435}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0416 = {.cps = (lxb_codepoint_t[]) {0x0436}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0417 = {.cps = (lxb_codepoint_t[]) {0x0437}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0418 = {.cps = (lxb_codepoint_t[]) {0x0438}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0419 = {.cps = (lxb_codepoint_t[]) {0x0439}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_041A = {.cps = (lxb_codepoint_t[]) {0x043A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_041B = {.cps = (lxb_codepoint_t[]) {0x043B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_041C = {.cps = (lxb_codepoint_t[]) {0x043C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_041D = {.cps = (lxb_codepoint_t[]) {0x043D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_041E = {.cps = (lxb_codepoint_t[]) {0x043E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_041F = {.cps = (lxb_codepoint_t[]) {0x043F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0420 = {.cps = (lxb_codepoint_t[]) {0x0440}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0421 = {.cps = (lxb_codepoint_t[]) {0x0441}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0422 = {.cps = (lxb_codepoint_t[]) {0x0442}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0423 = {.cps = (lxb_codepoint_t[]) {0x0443}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0424 = {.cps = (lxb_codepoint_t[]) {0x0444}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0425 = {.cps = (lxb_codepoint_t[]) {0x0445}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0426 = {.cps = (lxb_codepoint_t[]) {0x0446}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0427 = {.cps = (lxb_codepoint_t[]) {0x0447}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0428 = {.cps = (lxb_codepoint_t[]) {0x0448}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0429 = {.cps = (lxb_codepoint_t[]) {0x0449}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_042A = {.cps = (lxb_codepoint_t[]) {0x044A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_042B = {.cps = (lxb_codepoint_t[]) {0x044B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_042C = {.cps = (lxb_codepoint_t[]) {0x044C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_042D = {.cps = (lxb_codepoint_t[]) {0x044D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_042E = {.cps = (lxb_codepoint_t[]) {0x044E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_042F = {.cps = (lxb_codepoint_t[]) {0x044F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0460 = {.cps = (lxb_codepoint_t[]) {0x0461}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0462 = {.cps = (lxb_codepoint_t[]) {0x0463}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0464 = {.cps = (lxb_codepoint_t[]) {0x0465}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0466 = {.cps = (lxb_codepoint_t[]) {0x0467}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0468 = {.cps = (lxb_codepoint_t[]) {0x0469}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_046A = {.cps = (lxb_codepoint_t[]) {0x046B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_046C = {.cps = (lxb_codepoint_t[]) {0x046D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_046E = {.cps = (lxb_codepoint_t[]) {0x046F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0470 = {.cps = (lxb_codepoint_t[]) {0x0471}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0472 = {.cps = (lxb_codepoint_t[]) {0x0473}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0474 = {.cps = (lxb_codepoint_t[]) {0x0475}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0476 = {.cps = (lxb_codepoint_t[]) {0x0477}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0478 = {.cps = (lxb_codepoint_t[]) {0x0479}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_047A = {.cps = (lxb_codepoint_t[]) {0x047B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_047C = {.cps = (lxb_codepoint_t[]) {0x047D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_047E = {.cps = (lxb_codepoint_t[]) {0x047F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0480 = {.cps = (lxb_codepoint_t[]) {0x0481}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_048A = {.cps = (lxb_codepoint_t[]) {0x048B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_048C = {.cps = (lxb_codepoint_t[]) {0x048D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_048E = {.cps = (lxb_codepoint_t[]) {0x048F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0490 = {.cps = (lxb_codepoint_t[]) {0x0491}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0492 = {.cps = (lxb_codepoint_t[]) {0x0493}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0494 = {.cps = (lxb_codepoint_t[]) {0x0495}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0496 = {.cps = (lxb_codepoint_t[]) {0x0497}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0498 = {.cps = (lxb_codepoint_t[]) {0x0499}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_049A = {.cps = (lxb_codepoint_t[]) {0x049B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_049C = {.cps = (lxb_codepoint_t[]) {0x049D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_049E = {.cps = (lxb_codepoint_t[]) {0x049F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04A0 = {.cps = (lxb_codepoint_t[]) {0x04A1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04A2 = {.cps = (lxb_codepoint_t[]) {0x04A3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04A4 = {.cps = (lxb_codepoint_t[]) {0x04A5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04A6 = {.cps = (lxb_codepoint_t[]) {0x04A7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04A8 = {.cps = (lxb_codepoint_t[]) {0x04A9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04AA = {.cps = (lxb_codepoint_t[]) {0x04AB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04AC = {.cps = (lxb_codepoint_t[]) {0x04AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04AE = {.cps = (lxb_codepoint_t[]) {0x04AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04B0 = {.cps = (lxb_codepoint_t[]) {0x04B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04B2 = {.cps = (lxb_codepoint_t[]) {0x04B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04B4 = {.cps = (lxb_codepoint_t[]) {0x04B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04B6 = {.cps = (lxb_codepoint_t[]) {0x04B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04B8 = {.cps = (lxb_codepoint_t[]) {0x04B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04BA = {.cps = (lxb_codepoint_t[]) {0x04BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04BC = {.cps = (lxb_codepoint_t[]) {0x04BD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04BE = {.cps = (lxb_codepoint_t[]) {0x04BF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04C1 = {.cps = (lxb_codepoint_t[]) {0x04C2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04C3 = {.cps = (lxb_codepoint_t[]) {0x04C4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04C5 = {.cps = (lxb_codepoint_t[]) {0x04C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04C7 = {.cps = (lxb_codepoint_t[]) {0x04C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04C9 = {.cps = (lxb_codepoint_t[]) {0x04CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04CB = {.cps = (lxb_codepoint_t[]) {0x04CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04CD = {.cps = (lxb_codepoint_t[]) {0x04CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04D0 = {.cps = (lxb_codepoint_t[]) {0x04D1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04D2 = {.cps = (lxb_codepoint_t[]) {0x04D3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04D4 = {.cps = (lxb_codepoint_t[]) {0x04D5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04D6 = {.cps = (lxb_codepoint_t[]) {0x04D7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04D8 = {.cps = (lxb_codepoint_t[]) {0x04D9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04DA = {.cps = (lxb_codepoint_t[]) {0x04DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04DC = {.cps = (lxb_codepoint_t[]) {0x04DD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04DE = {.cps = (lxb_codepoint_t[]) {0x04DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04E0 = {.cps = (lxb_codepoint_t[]) {0x04E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04E2 = {.cps = (lxb_codepoint_t[]) {0x04E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04E4 = {.cps = (lxb_codepoint_t[]) {0x04E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04E6 = {.cps = (lxb_codepoint_t[]) {0x04E7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04E8 = {.cps = (lxb_codepoint_t[]) {0x04E9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04EA = {.cps = (lxb_codepoint_t[]) {0x04EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04EC = {.cps = (lxb_codepoint_t[]) {0x04ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04EE = {.cps = (lxb_codepoint_t[]) {0x04EF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04F0 = {.cps = (lxb_codepoint_t[]) {0x04F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04F2 = {.cps = (lxb_codepoint_t[]) {0x04F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04F4 = {.cps = (lxb_codepoint_t[]) {0x04F5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04F6 = {.cps = (lxb_codepoint_t[]) {0x04F7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04F8 = {.cps = (lxb_codepoint_t[]) {0x04F9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04FA = {.cps = (lxb_codepoint_t[]) {0x04FB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04FC = {.cps = (lxb_codepoint_t[]) {0x04FD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_04FE = {.cps = (lxb_codepoint_t[]) {0x04FF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0500 = {.cps = (lxb_codepoint_t[]) {0x0501}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0502 = {.cps = (lxb_codepoint_t[]) {0x0503}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0504 = {.cps = (lxb_codepoint_t[]) {0x0505}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0506 = {.cps = (lxb_codepoint_t[]) {0x0507}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0508 = {.cps = (lxb_codepoint_t[]) {0x0509}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_050A = {.cps = (lxb_codepoint_t[]) {0x050B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_050C = {.cps = (lxb_codepoint_t[]) {0x050D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_050E = {.cps = (lxb_codepoint_t[]) {0x050F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0510 = {.cps = (lxb_codepoint_t[]) {0x0511}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0512 = {.cps = (lxb_codepoint_t[]) {0x0513}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0514 = {.cps = (lxb_codepoint_t[]) {0x0515}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0516 = {.cps = (lxb_codepoint_t[]) {0x0517}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0518 = {.cps = (lxb_codepoint_t[]) {0x0519}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_051A = {.cps = (lxb_codepoint_t[]) {0x051B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_051C = {.cps = (lxb_codepoint_t[]) {0x051D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_051E = {.cps = (lxb_codepoint_t[]) {0x051F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0520 = {.cps = (lxb_codepoint_t[]) {0x0521}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0522 = {.cps = (lxb_codepoint_t[]) {0x0523}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0524 = {.cps = (lxb_codepoint_t[]) {0x0525}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0526 = {.cps = (lxb_codepoint_t[]) {0x0527}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0528 = {.cps = (lxb_codepoint_t[]) {0x0529}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_052A = {.cps = (lxb_codepoint_t[]) {0x052B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_052C = {.cps = (lxb_codepoint_t[]) {0x052D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_052E = {.cps = (lxb_codepoint_t[]) {0x052F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0531 = {.cps = (lxb_codepoint_t[]) {0x0561}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0532 = {.cps = (lxb_codepoint_t[]) {0x0562}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0533 = {.cps = (lxb_codepoint_t[]) {0x0563}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0534 = {.cps = (lxb_codepoint_t[]) {0x0564}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0535 = {.cps = (lxb_codepoint_t[]) {0x0565}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0536 = {.cps = (lxb_codepoint_t[]) {0x0566}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0537 = {.cps = (lxb_codepoint_t[]) {0x0567}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0538 = {.cps = (lxb_codepoint_t[]) {0x0568}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0539 = {.cps = (lxb_codepoint_t[]) {0x0569}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_053A = {.cps = (lxb_codepoint_t[]) {0x056A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_053B = {.cps = (lxb_codepoint_t[]) {0x056B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_053C = {.cps = (lxb_codepoint_t[]) {0x056C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_053D = {.cps = (lxb_codepoint_t[]) {0x056D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_053E = {.cps = (lxb_codepoint_t[]) {0x056E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_053F = {.cps = (lxb_codepoint_t[]) {0x056F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0540 = {.cps = (lxb_codepoint_t[]) {0x0570}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0541 = {.cps = (lxb_codepoint_t[]) {0x0571}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0542 = {.cps = (lxb_codepoint_t[]) {0x0572}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0543 = {.cps = (lxb_codepoint_t[]) {0x0573}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0544 = {.cps = (lxb_codepoint_t[]) {0x0574}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0545 = {.cps = (lxb_codepoint_t[]) {0x0575}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0546 = {.cps = (lxb_codepoint_t[]) {0x0576}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0547 = {.cps = (lxb_codepoint_t[]) {0x0577}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0548 = {.cps = (lxb_codepoint_t[]) {0x0578}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0549 = {.cps = (lxb_codepoint_t[]) {0x0579}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_054A = {.cps = (lxb_codepoint_t[]) {0x057A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_054B = {.cps = (lxb_codepoint_t[]) {0x057B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_054C = {.cps = (lxb_codepoint_t[]) {0x057C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_054D = {.cps = (lxb_codepoint_t[]) {0x057D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_054E = {.cps = (lxb_codepoint_t[]) {0x057E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_054F = {.cps = (lxb_codepoint_t[]) {0x057F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0550 = {.cps = (lxb_codepoint_t[]) {0x0580}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0551 = {.cps = (lxb_codepoint_t[]) {0x0581}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0552 = {.cps = (lxb_codepoint_t[]) {0x0582}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0553 = {.cps = (lxb_codepoint_t[]) {0x0583}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0554 = {.cps = (lxb_codepoint_t[]) {0x0584}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0555 = {.cps = (lxb_codepoint_t[]) {0x0585}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0556 = {.cps = (lxb_codepoint_t[]) {0x0586}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0587 = {.cps = (lxb_codepoint_t[]) {0x0565, 0x0582}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0675 = {.cps = (lxb_codepoint_t[]) {0x0627, 0x0674}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0676 = {.cps = (lxb_codepoint_t[]) {0x0648, 0x0674}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0677 = {.cps = (lxb_codepoint_t[]) {0x06C7, 0x0674}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0678 = {.cps = (lxb_codepoint_t[]) {0x064A, 0x0674}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0958 = {.cps = (lxb_codepoint_t[]) {0x0915, 0x093C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0959 = {.cps = (lxb_codepoint_t[]) {0x0916, 0x093C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_095A = {.cps = (lxb_codepoint_t[]) {0x0917, 0x093C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_095B = {.cps = (lxb_codepoint_t[]) {0x091C, 0x093C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_095C = {.cps = (lxb_codepoint_t[]) {0x0921, 0x093C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_095D = {.cps = (lxb_codepoint_t[]) {0x0922, 0x093C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_095E = {.cps = (lxb_codepoint_t[]) {0x092B, 0x093C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_095F = {.cps = (lxb_codepoint_t[]) {0x092F, 0x093C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_09DC = {.cps = (lxb_codepoint_t[]) {0x09A1, 0x09BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_09DD = {.cps = (lxb_codepoint_t[]) {0x09A2, 0x09BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_09DF = {.cps = (lxb_codepoint_t[]) {0x09AF, 0x09BC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0A33 = {.cps = (lxb_codepoint_t[]) {0x0A32, 0x0A3C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0A36 = {.cps = (lxb_codepoint_t[]) {0x0A38, 0x0A3C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0A59 = {.cps = (lxb_codepoint_t[]) {0x0A16, 0x0A3C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0A5A = {.cps = (lxb_codepoint_t[]) {0x0A17, 0x0A3C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0A5B = {.cps = (lxb_codepoint_t[]) {0x0A1C, 0x0A3C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0A5E = {.cps = (lxb_codepoint_t[]) {0x0A2B, 0x0A3C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0B5C = {.cps = (lxb_codepoint_t[]) {0x0B21, 0x0B3C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0B5D = {.cps = (lxb_codepoint_t[]) {0x0B22, 0x0B3C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0E33 = {.cps = (lxb_codepoint_t[]) {0x0E4D, 0x0E32}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0EB3 = {.cps = (lxb_codepoint_t[]) {0x0ECD, 0x0EB2}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0EDC = {.cps = (lxb_codepoint_t[]) {0x0EAB, 0x0E99}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0EDD = {.cps = (lxb_codepoint_t[]) {0x0EAB, 0x0EA1}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F0C = {.cps = (lxb_codepoint_t[]) {0x0F0B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F43 = {.cps = (lxb_codepoint_t[]) {0x0F42, 0x0FB7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F4D = {.cps = (lxb_codepoint_t[]) {0x0F4C, 0x0FB7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F52 = {.cps = (lxb_codepoint_t[]) {0x0F51, 0x0FB7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F57 = {.cps = (lxb_codepoint_t[]) {0x0F56, 0x0FB7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F5C = {.cps = (lxb_codepoint_t[]) {0x0F5B, 0x0FB7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F69 = {.cps = (lxb_codepoint_t[]) {0x0F40, 0x0FB5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F73 = {.cps = (lxb_codepoint_t[]) {0x0F71, 0x0F72}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F75 = {.cps = (lxb_codepoint_t[]) {0x0F71, 0x0F74}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F76 = {.cps = (lxb_codepoint_t[]) {0x0FB2, 0x0F80}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F77 = {.cps = (lxb_codepoint_t[]) {0x0FB2, 0x0F71, 0x0F80}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F78 = {.cps = (lxb_codepoint_t[]) {0x0FB3, 0x0F80}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F79 = {.cps = (lxb_codepoint_t[]) {0x0FB3, 0x0F71, 0x0F80}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F81 = {.cps = (lxb_codepoint_t[]) {0x0F71, 0x0F80}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F93 = {.cps = (lxb_codepoint_t[]) {0x0F92, 0x0FB7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0F9D = {.cps = (lxb_codepoint_t[]) {0x0F9C, 0x0FB7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0FA2 = {.cps = (lxb_codepoint_t[]) {0x0FA1, 0x0FB7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0FA7 = {.cps = (lxb_codepoint_t[]) {0x0FA6, 0x0FB7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0FAC = {.cps = (lxb_codepoint_t[]) {0x0FAB, 0x0FB7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_0FB9 = {.cps = (lxb_codepoint_t[]) {0x0F90, 0x0FB5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10C7 = {.cps = (lxb_codepoint_t[]) {0x2D27}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10CD = {.cps = (lxb_codepoint_t[]) {0x2D2D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_10FC = {.cps = (lxb_codepoint_t[]) {0x10DC}, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00A0[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp_c_00A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00A0[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp_k_00A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00A0[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp__00A0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_00A0 = {.cp = 0x00A0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00A0, .cde = &lxb_unicode_decomposition_c_00A0, .kde = &lxb_unicode_decomposition_k_00A0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00A8[2] = {0x0020, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_00A8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00A8[2] = {0x0020, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_00A8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00A8[2] = {0x0020, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__00A8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00A8 = {.cp = 0x00A8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00A8, .cde = &lxb_unicode_decomposition_c_00A8, .kde = &lxb_unicode_decomposition_k_00A8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00AA[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_00AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00AA[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_00AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00AA[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__00AA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_00AA = {.cp = 0x00AA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00AA, .cde = &lxb_unicode_decomposition_c_00AA, .kde = &lxb_unicode_decomposition_k_00AA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00AF[2] = {0x0020, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_00AF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00AF[2] = {0x0020, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_00AF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00AF[2] = {0x0020, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__00AF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00AF = {.cp = 0x00AF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00AF, .cde = &lxb_unicode_decomposition_c_00AF, .kde = &lxb_unicode_decomposition_k_00AF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00B2[1] = {0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_00B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00B2[1] = {0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_00B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00B2[1] = {0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__00B2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_00B2 = {.cp = 0x00B2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00B2, .cde = &lxb_unicode_decomposition_c_00B2, .kde = &lxb_unicode_decomposition_k_00B2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00B3[1] = {0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_00B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00B3[1] = {0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_00B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00B3[1] = {0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__00B3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_00B3 = {.cp = 0x00B3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00B3, .cde = &lxb_unicode_decomposition_c_00B3, .kde = &lxb_unicode_decomposition_k_00B3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00B4[2] = {0x0020, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_00B4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00B4[2] = {0x0020, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_00B4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00B4[2] = {0x0020, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__00B4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00B4 = {.cp = 0x00B4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00B4, .cde = &lxb_unicode_decomposition_c_00B4, .kde = &lxb_unicode_decomposition_k_00B4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00B5[1] = {0x03BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_00B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00B5[1] = {0x03BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_00B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00B5[1] = {0x03BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__00B5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_00B5 = {.cp = 0x00B5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00B5, .cde = &lxb_unicode_decomposition_c_00B5, .kde = &lxb_unicode_decomposition_k_00B5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00B8[2] = {0x0020, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_00B8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00B8[2] = {0x0020, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_00B8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00B8[2] = {0x0020, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__00B8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00B8 = {.cp = 0x00B8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00B8, .cde = &lxb_unicode_decomposition_c_00B8, .kde = &lxb_unicode_decomposition_k_00B8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00B9[1] = {0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_00B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00B9[1] = {0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_00B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00B9[1] = {0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__00B9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_00B9 = {.cp = 0x00B9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00B9, .cde = &lxb_unicode_decomposition_c_00B9, .kde = &lxb_unicode_decomposition_k_00B9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00BA[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_00BA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00BA[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_00BA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00BA[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__00BA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_00BA = {.cp = 0x00BA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00BA, .cde = &lxb_unicode_decomposition_c_00BA, .kde = &lxb_unicode_decomposition_k_00BA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00BC[3] = {0x0031, 0x2044, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_00BC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00BC[3] = {0x0031, 0x2044, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_00BC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00BC[3] = {0x0031, 0x2044, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__00BC, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_00BC = {.cp = 0x00BC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00BC, .cde = &lxb_unicode_decomposition_c_00BC, .kde = &lxb_unicode_decomposition_k_00BC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00BD[3] = {0x0031, 0x2044, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_00BD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00BD[3] = {0x0031, 0x2044, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_00BD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00BD[3] = {0x0031, 0x2044, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__00BD, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_00BD = {.cp = 0x00BD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00BD, .cde = &lxb_unicode_decomposition_c_00BD, .kde = &lxb_unicode_decomposition_k_00BD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00BE[3] = {0x0033, 0x2044, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_c_00BE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00BE[3] = {0x0033, 0x2044, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp_k_00BE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00BE[3] = {0x0033, 0x2044, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FRACTION, .mapping = lxb_unicode_decomposition_cp__00BE, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_00BE = {.cp = 0x00BE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00BE, .cde = &lxb_unicode_decomposition_c_00BE, .kde = &lxb_unicode_decomposition_k_00BE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00C0[2] = {0x0041, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00C0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00C0[2] = {0x0041, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00C0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00C0[2] = {0x0041, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00C0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00C0 = {.cp = 0x00C0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00C0, .cde = &lxb_unicode_decomposition_c_00C0, .kde = &lxb_unicode_decomposition_k_00C0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00C1[2] = {0x0041, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00C1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00C1[2] = {0x0041, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00C1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00C1[2] = {0x0041, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00C1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00C1 = {.cp = 0x00C1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00C1, .cde = &lxb_unicode_decomposition_c_00C1, .kde = &lxb_unicode_decomposition_k_00C1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00C2[2] = {0x0041, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00C2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00C2[2] = {0x0041, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00C2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00C2[2] = {0x0041, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00C2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00C2 = {.cp = 0x00C2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00C2, .cde = &lxb_unicode_decomposition_c_00C2, .kde = &lxb_unicode_decomposition_k_00C2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00C3[2] = {0x0041, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00C3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00C3[2] = {0x0041, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00C3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00C3[2] = {0x0041, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00C3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00C3 = {.cp = 0x00C3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00C3, .cde = &lxb_unicode_decomposition_c_00C3, .kde = &lxb_unicode_decomposition_k_00C3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00C4[2] = {0x0041, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00C4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00C4[2] = {0x0041, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00C4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00C4[2] = {0x0041, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00C4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00C4 = {.cp = 0x00C4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00C4, .cde = &lxb_unicode_decomposition_c_00C4, .kde = &lxb_unicode_decomposition_k_00C4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00C5[2] = {0x0041, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00C5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00C5[2] = {0x0041, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00C5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00C5[2] = {0x0041, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00C5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00C5 = {.cp = 0x00C5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00C5, .cde = &lxb_unicode_decomposition_c_00C5, .kde = &lxb_unicode_decomposition_k_00C5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00C7[2] = {0x0043, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00C7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00C7[2] = {0x0043, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00C7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00C7[2] = {0x0043, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00C7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00C7 = {.cp = 0x00C7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00C7, .cde = &lxb_unicode_decomposition_c_00C7, .kde = &lxb_unicode_decomposition_k_00C7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00C8[2] = {0x0045, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00C8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00C8[2] = {0x0045, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00C8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00C8[2] = {0x0045, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00C8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00C8 = {.cp = 0x00C8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00C8, .cde = &lxb_unicode_decomposition_c_00C8, .kde = &lxb_unicode_decomposition_k_00C8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00C9[2] = {0x0045, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00C9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00C9[2] = {0x0045, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00C9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00C9[2] = {0x0045, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00C9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00C9 = {.cp = 0x00C9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00C9, .cde = &lxb_unicode_decomposition_c_00C9, .kde = &lxb_unicode_decomposition_k_00C9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00CA[2] = {0x0045, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00CA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00CA[2] = {0x0045, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00CA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00CA[2] = {0x0045, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00CA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00CA = {.cp = 0x00CA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00CA, .cde = &lxb_unicode_decomposition_c_00CA, .kde = &lxb_unicode_decomposition_k_00CA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00CB[2] = {0x0045, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00CB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00CB[2] = {0x0045, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00CB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00CB[2] = {0x0045, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00CB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00CB = {.cp = 0x00CB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00CB, .cde = &lxb_unicode_decomposition_c_00CB, .kde = &lxb_unicode_decomposition_k_00CB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00CC[2] = {0x0049, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00CC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00CC[2] = {0x0049, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00CC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00CC[2] = {0x0049, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00CC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00CC = {.cp = 0x00CC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00CC, .cde = &lxb_unicode_decomposition_c_00CC, .kde = &lxb_unicode_decomposition_k_00CC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00CD[2] = {0x0049, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00CD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00CD[2] = {0x0049, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00CD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00CD[2] = {0x0049, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00CD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00CD = {.cp = 0x00CD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00CD, .cde = &lxb_unicode_decomposition_c_00CD, .kde = &lxb_unicode_decomposition_k_00CD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00CE[2] = {0x0049, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00CE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00CE[2] = {0x0049, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00CE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00CE[2] = {0x0049, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00CE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00CE = {.cp = 0x00CE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00CE, .cde = &lxb_unicode_decomposition_c_00CE, .kde = &lxb_unicode_decomposition_k_00CE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00CF[2] = {0x0049, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00CF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00CF[2] = {0x0049, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00CF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00CF[2] = {0x0049, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00CF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00CF = {.cp = 0x00CF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00CF, .cde = &lxb_unicode_decomposition_c_00CF, .kde = &lxb_unicode_decomposition_k_00CF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00D1[2] = {0x004E, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00D1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00D1[2] = {0x004E, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00D1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00D1[2] = {0x004E, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00D1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00D1 = {.cp = 0x00D1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00D1, .cde = &lxb_unicode_decomposition_c_00D1, .kde = &lxb_unicode_decomposition_k_00D1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00D2[2] = {0x004F, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00D2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00D2[2] = {0x004F, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00D2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00D2[2] = {0x004F, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00D2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00D2 = {.cp = 0x00D2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00D2, .cde = &lxb_unicode_decomposition_c_00D2, .kde = &lxb_unicode_decomposition_k_00D2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00D3[2] = {0x004F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00D3[2] = {0x004F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00D3[2] = {0x004F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00D3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00D3 = {.cp = 0x00D3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00D3, .cde = &lxb_unicode_decomposition_c_00D3, .kde = &lxb_unicode_decomposition_k_00D3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00D4[2] = {0x004F, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00D4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00D4[2] = {0x004F, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00D4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00D4[2] = {0x004F, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00D4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00D4 = {.cp = 0x00D4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00D4, .cde = &lxb_unicode_decomposition_c_00D4, .kde = &lxb_unicode_decomposition_k_00D4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00D5[2] = {0x004F, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00D5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00D5[2] = {0x004F, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00D5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00D5[2] = {0x004F, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00D5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00D5 = {.cp = 0x00D5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00D5, .cde = &lxb_unicode_decomposition_c_00D5, .kde = &lxb_unicode_decomposition_k_00D5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00D6[2] = {0x004F, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00D6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00D6[2] = {0x004F, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00D6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00D6[2] = {0x004F, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00D6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00D6 = {.cp = 0x00D6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00D6, .cde = &lxb_unicode_decomposition_c_00D6, .kde = &lxb_unicode_decomposition_k_00D6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00D9[2] = {0x0055, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00D9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00D9[2] = {0x0055, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00D9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00D9[2] = {0x0055, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00D9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00D9 = {.cp = 0x00D9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00D9, .cde = &lxb_unicode_decomposition_c_00D9, .kde = &lxb_unicode_decomposition_k_00D9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00DA[2] = {0x0055, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00DA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00DA[2] = {0x0055, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00DA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00DA[2] = {0x0055, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00DA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00DA = {.cp = 0x00DA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00DA, .cde = &lxb_unicode_decomposition_c_00DA, .kde = &lxb_unicode_decomposition_k_00DA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00DB[2] = {0x0055, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00DB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00DB[2] = {0x0055, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00DB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00DB[2] = {0x0055, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00DB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00DB = {.cp = 0x00DB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00DB, .cde = &lxb_unicode_decomposition_c_00DB, .kde = &lxb_unicode_decomposition_k_00DB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00DC[2] = {0x0055, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00DC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00DC[2] = {0x0055, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00DC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00DC[2] = {0x0055, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00DC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00DC = {.cp = 0x00DC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00DC, .cde = &lxb_unicode_decomposition_c_00DC, .kde = &lxb_unicode_decomposition_k_00DC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00DD[2] = {0x0059, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00DD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00DD[2] = {0x0059, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00DD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00DD[2] = {0x0059, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00DD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00DD = {.cp = 0x00DD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00DD, .cde = &lxb_unicode_decomposition_c_00DD, .kde = &lxb_unicode_decomposition_k_00DD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00E0[2] = {0x0061, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00E0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00E0[2] = {0x0061, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00E0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00E0[2] = {0x0061, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00E0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00E0 = {.cp = 0x00E0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00E0, .cde = &lxb_unicode_decomposition_c_00E0, .kde = &lxb_unicode_decomposition_k_00E0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00E1[2] = {0x0061, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00E1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00E1[2] = {0x0061, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00E1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00E1[2] = {0x0061, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00E1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00E1 = {.cp = 0x00E1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00E1, .cde = &lxb_unicode_decomposition_c_00E1, .kde = &lxb_unicode_decomposition_k_00E1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00E2[2] = {0x0061, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00E2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00E2[2] = {0x0061, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00E2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00E2[2] = {0x0061, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00E2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00E2 = {.cp = 0x00E2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00E2, .cde = &lxb_unicode_decomposition_c_00E2, .kde = &lxb_unicode_decomposition_k_00E2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00E3[2] = {0x0061, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00E3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00E3[2] = {0x0061, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00E3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00E3[2] = {0x0061, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00E3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00E3 = {.cp = 0x00E3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00E3, .cde = &lxb_unicode_decomposition_c_00E3, .kde = &lxb_unicode_decomposition_k_00E3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00E4[2] = {0x0061, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00E4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00E4[2] = {0x0061, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00E4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00E4[2] = {0x0061, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00E4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00E4 = {.cp = 0x00E4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00E4, .cde = &lxb_unicode_decomposition_c_00E4, .kde = &lxb_unicode_decomposition_k_00E4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00E5[2] = {0x0061, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00E5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00E5[2] = {0x0061, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00E5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00E5[2] = {0x0061, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00E5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00E5 = {.cp = 0x00E5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00E5, .cde = &lxb_unicode_decomposition_c_00E5, .kde = &lxb_unicode_decomposition_k_00E5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00E7[2] = {0x0063, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00E7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00E7[2] = {0x0063, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00E7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00E7[2] = {0x0063, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00E7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00E7 = {.cp = 0x00E7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00E7, .cde = &lxb_unicode_decomposition_c_00E7, .kde = &lxb_unicode_decomposition_k_00E7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00E8[2] = {0x0065, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00E8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00E8[2] = {0x0065, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00E8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00E8[2] = {0x0065, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00E8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00E8 = {.cp = 0x00E8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00E8, .cde = &lxb_unicode_decomposition_c_00E8, .kde = &lxb_unicode_decomposition_k_00E8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00E9[2] = {0x0065, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00E9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00E9[2] = {0x0065, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00E9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00E9[2] = {0x0065, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00E9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00E9 = {.cp = 0x00E9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00E9, .cde = &lxb_unicode_decomposition_c_00E9, .kde = &lxb_unicode_decomposition_k_00E9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00EA[2] = {0x0065, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00EA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00EA[2] = {0x0065, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00EA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00EA[2] = {0x0065, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00EA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00EA = {.cp = 0x00EA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00EA, .cde = &lxb_unicode_decomposition_c_00EA, .kde = &lxb_unicode_decomposition_k_00EA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00EB[2] = {0x0065, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00EB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00EB[2] = {0x0065, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00EB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00EB[2] = {0x0065, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00EB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00EB = {.cp = 0x00EB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00EB, .cde = &lxb_unicode_decomposition_c_00EB, .kde = &lxb_unicode_decomposition_k_00EB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00EC[2] = {0x0069, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00EC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00EC[2] = {0x0069, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00EC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00EC[2] = {0x0069, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00EC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00EC = {.cp = 0x00EC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00EC, .cde = &lxb_unicode_decomposition_c_00EC, .kde = &lxb_unicode_decomposition_k_00EC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00ED[2] = {0x0069, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00ED, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00ED[2] = {0x0069, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00ED, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00ED[2] = {0x0069, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00ED, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00ED = {.cp = 0x00ED, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00ED, .cde = &lxb_unicode_decomposition_c_00ED, .kde = &lxb_unicode_decomposition_k_00ED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00EE[2] = {0x0069, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00EE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00EE[2] = {0x0069, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00EE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00EE[2] = {0x0069, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00EE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00EE = {.cp = 0x00EE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00EE, .cde = &lxb_unicode_decomposition_c_00EE, .kde = &lxb_unicode_decomposition_k_00EE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00EF[2] = {0x0069, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00EF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00EF[2] = {0x0069, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00EF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00EF[2] = {0x0069, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00EF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00EF = {.cp = 0x00EF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00EF, .cde = &lxb_unicode_decomposition_c_00EF, .kde = &lxb_unicode_decomposition_k_00EF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00F1[2] = {0x006E, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00F1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00F1[2] = {0x006E, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00F1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00F1[2] = {0x006E, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00F1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00F1 = {.cp = 0x00F1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00F1, .cde = &lxb_unicode_decomposition_c_00F1, .kde = &lxb_unicode_decomposition_k_00F1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00F2[2] = {0x006F, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00F2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00F2[2] = {0x006F, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00F2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00F2[2] = {0x006F, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00F2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00F2 = {.cp = 0x00F2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00F2, .cde = &lxb_unicode_decomposition_c_00F2, .kde = &lxb_unicode_decomposition_k_00F2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00F3[2] = {0x006F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00F3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00F3[2] = {0x006F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00F3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00F3[2] = {0x006F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00F3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00F3 = {.cp = 0x00F3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00F3, .cde = &lxb_unicode_decomposition_c_00F3, .kde = &lxb_unicode_decomposition_k_00F3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00F4[2] = {0x006F, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00F4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00F4[2] = {0x006F, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00F4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00F4[2] = {0x006F, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00F4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00F4 = {.cp = 0x00F4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00F4, .cde = &lxb_unicode_decomposition_c_00F4, .kde = &lxb_unicode_decomposition_k_00F4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00F5[2] = {0x006F, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00F5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00F5[2] = {0x006F, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00F5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00F5[2] = {0x006F, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00F5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00F5 = {.cp = 0x00F5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00F5, .cde = &lxb_unicode_decomposition_c_00F5, .kde = &lxb_unicode_decomposition_k_00F5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00F6[2] = {0x006F, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00F6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00F6[2] = {0x006F, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00F6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00F6[2] = {0x006F, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00F6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00F6 = {.cp = 0x00F6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00F6, .cde = &lxb_unicode_decomposition_c_00F6, .kde = &lxb_unicode_decomposition_k_00F6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00F9[2] = {0x0075, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00F9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00F9[2] = {0x0075, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00F9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00F9[2] = {0x0075, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00F9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00F9 = {.cp = 0x00F9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00F9, .cde = &lxb_unicode_decomposition_c_00F9, .kde = &lxb_unicode_decomposition_k_00F9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00FA[2] = {0x0075, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00FA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00FA[2] = {0x0075, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00FA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00FA[2] = {0x0075, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00FA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00FA = {.cp = 0x00FA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00FA, .cde = &lxb_unicode_decomposition_c_00FA, .kde = &lxb_unicode_decomposition_k_00FA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00FB[2] = {0x0075, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00FB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00FB[2] = {0x0075, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00FB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00FB[2] = {0x0075, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00FB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00FB = {.cp = 0x00FB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00FB, .cde = &lxb_unicode_decomposition_c_00FB, .kde = &lxb_unicode_decomposition_k_00FB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00FC[2] = {0x0075, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00FC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00FC[2] = {0x0075, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00FC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00FC[2] = {0x0075, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00FC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00FC = {.cp = 0x00FC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00FC, .cde = &lxb_unicode_decomposition_c_00FC, .kde = &lxb_unicode_decomposition_k_00FC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00FD[2] = {0x0079, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00FD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00FD[2] = {0x0079, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00FD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00FD[2] = {0x0079, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00FD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00FD = {.cp = 0x00FD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00FD, .cde = &lxb_unicode_decomposition_c_00FD, .kde = &lxb_unicode_decomposition_k_00FD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_00FF[2] = {0x0079, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_00FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_00FF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_00FF[2] = {0x0079, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_00FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_00FF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__00FF[2] = {0x0079, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__00FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__00FF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_00FF = {.cp = 0x00FF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__00FF, .cde = &lxb_unicode_decomposition_c_00FF, .kde = &lxb_unicode_decomposition_k_00FF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0100[2] = {0x0041, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0100 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0100, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0100[2] = {0x0041, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0100 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0100, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0100[2] = {0x0041, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0100 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0100, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0100 = {.cp = 0x0100, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0100, .cde = &lxb_unicode_decomposition_c_0100, .kde = &lxb_unicode_decomposition_k_0100};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0101[2] = {0x0061, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0101 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0101, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0101[2] = {0x0061, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0101 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0101, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0101[2] = {0x0061, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0101 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0101, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0101 = {.cp = 0x0101, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0101, .cde = &lxb_unicode_decomposition_c_0101, .kde = &lxb_unicode_decomposition_k_0101};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0102[2] = {0x0041, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0102 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0102, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0102[2] = {0x0041, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0102 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0102, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0102[2] = {0x0041, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0102 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0102, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0102 = {.cp = 0x0102, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0102, .cde = &lxb_unicode_decomposition_c_0102, .kde = &lxb_unicode_decomposition_k_0102};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0103[2] = {0x0061, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0103 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0103, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0103[2] = {0x0061, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0103 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0103, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0103[2] = {0x0061, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0103 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0103, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0103 = {.cp = 0x0103, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0103, .cde = &lxb_unicode_decomposition_c_0103, .kde = &lxb_unicode_decomposition_k_0103};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0104[2] = {0x0041, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0104 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0104, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0104[2] = {0x0041, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0104 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0104, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0104[2] = {0x0041, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0104 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0104, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0104 = {.cp = 0x0104, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0104, .cde = &lxb_unicode_decomposition_c_0104, .kde = &lxb_unicode_decomposition_k_0104};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0105[2] = {0x0061, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0105 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0105, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0105[2] = {0x0061, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0105 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0105, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0105[2] = {0x0061, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0105 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0105, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0105 = {.cp = 0x0105, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0105, .cde = &lxb_unicode_decomposition_c_0105, .kde = &lxb_unicode_decomposition_k_0105};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0106[2] = {0x0043, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0106 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0106, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0106[2] = {0x0043, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0106 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0106, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0106[2] = {0x0043, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0106 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0106, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0106 = {.cp = 0x0106, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0106, .cde = &lxb_unicode_decomposition_c_0106, .kde = &lxb_unicode_decomposition_k_0106};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0107[2] = {0x0063, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0107 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0107, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0107[2] = {0x0063, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0107 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0107, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0107[2] = {0x0063, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0107 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0107, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0107 = {.cp = 0x0107, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0107, .cde = &lxb_unicode_decomposition_c_0107, .kde = &lxb_unicode_decomposition_k_0107};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0108[2] = {0x0043, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0108 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0108, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0108[2] = {0x0043, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0108 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0108, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0108[2] = {0x0043, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0108 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0108, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0108 = {.cp = 0x0108, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0108, .cde = &lxb_unicode_decomposition_c_0108, .kde = &lxb_unicode_decomposition_k_0108};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0109[2] = {0x0063, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0109 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0109, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0109[2] = {0x0063, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0109 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0109, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0109[2] = {0x0063, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0109 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0109, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0109 = {.cp = 0x0109, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0109, .cde = &lxb_unicode_decomposition_c_0109, .kde = &lxb_unicode_decomposition_k_0109};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_010A[2] = {0x0043, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_010A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_010A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_010A[2] = {0x0043, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_010A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_010A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__010A[2] = {0x0043, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__010A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__010A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_010A = {.cp = 0x010A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__010A, .cde = &lxb_unicode_decomposition_c_010A, .kde = &lxb_unicode_decomposition_k_010A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_010B[2] = {0x0063, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_010B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_010B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_010B[2] = {0x0063, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_010B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_010B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__010B[2] = {0x0063, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__010B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__010B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_010B = {.cp = 0x010B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__010B, .cde = &lxb_unicode_decomposition_c_010B, .kde = &lxb_unicode_decomposition_k_010B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_010C[2] = {0x0043, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_010C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_010C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_010C[2] = {0x0043, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_010C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_010C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__010C[2] = {0x0043, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__010C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__010C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_010C = {.cp = 0x010C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__010C, .cde = &lxb_unicode_decomposition_c_010C, .kde = &lxb_unicode_decomposition_k_010C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_010D[2] = {0x0063, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_010D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_010D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_010D[2] = {0x0063, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_010D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_010D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__010D[2] = {0x0063, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__010D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__010D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_010D = {.cp = 0x010D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__010D, .cde = &lxb_unicode_decomposition_c_010D, .kde = &lxb_unicode_decomposition_k_010D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_010E[2] = {0x0044, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_010E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_010E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_010E[2] = {0x0044, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_010E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_010E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__010E[2] = {0x0044, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__010E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__010E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_010E = {.cp = 0x010E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__010E, .cde = &lxb_unicode_decomposition_c_010E, .kde = &lxb_unicode_decomposition_k_010E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_010F[2] = {0x0064, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_010F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_010F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_010F[2] = {0x0064, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_010F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_010F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__010F[2] = {0x0064, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__010F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__010F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_010F = {.cp = 0x010F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__010F, .cde = &lxb_unicode_decomposition_c_010F, .kde = &lxb_unicode_decomposition_k_010F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0112[2] = {0x0045, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0112 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0112, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0112[2] = {0x0045, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0112 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0112, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0112[2] = {0x0045, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0112 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0112, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0112 = {.cp = 0x0112, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0112, .cde = &lxb_unicode_decomposition_c_0112, .kde = &lxb_unicode_decomposition_k_0112};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0113[2] = {0x0065, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0113 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0113, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0113[2] = {0x0065, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0113 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0113, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0113[2] = {0x0065, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0113 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0113, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0113 = {.cp = 0x0113, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0113, .cde = &lxb_unicode_decomposition_c_0113, .kde = &lxb_unicode_decomposition_k_0113};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0114[2] = {0x0045, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0114 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0114, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0114[2] = {0x0045, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0114 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0114, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0114[2] = {0x0045, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0114 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0114, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0114 = {.cp = 0x0114, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0114, .cde = &lxb_unicode_decomposition_c_0114, .kde = &lxb_unicode_decomposition_k_0114};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0115[2] = {0x0065, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0115 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0115, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0115[2] = {0x0065, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0115 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0115, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0115[2] = {0x0065, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0115 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0115, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0115 = {.cp = 0x0115, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0115, .cde = &lxb_unicode_decomposition_c_0115, .kde = &lxb_unicode_decomposition_k_0115};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0116[2] = {0x0045, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0116 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0116, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0116[2] = {0x0045, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0116 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0116, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0116[2] = {0x0045, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0116 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0116, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0116 = {.cp = 0x0116, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0116, .cde = &lxb_unicode_decomposition_c_0116, .kde = &lxb_unicode_decomposition_k_0116};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0117[2] = {0x0065, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0117 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0117, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0117[2] = {0x0065, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0117 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0117, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0117[2] = {0x0065, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0117 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0117, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0117 = {.cp = 0x0117, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0117, .cde = &lxb_unicode_decomposition_c_0117, .kde = &lxb_unicode_decomposition_k_0117};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0118[2] = {0x0045, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0118 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0118, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0118[2] = {0x0045, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0118 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0118, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0118[2] = {0x0045, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0118 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0118, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0118 = {.cp = 0x0118, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0118, .cde = &lxb_unicode_decomposition_c_0118, .kde = &lxb_unicode_decomposition_k_0118};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0119[2] = {0x0065, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0119 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0119, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0119[2] = {0x0065, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0119 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0119, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0119[2] = {0x0065, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0119 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0119, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0119 = {.cp = 0x0119, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0119, .cde = &lxb_unicode_decomposition_c_0119, .kde = &lxb_unicode_decomposition_k_0119};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_011A[2] = {0x0045, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_011A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_011A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_011A[2] = {0x0045, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_011A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_011A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__011A[2] = {0x0045, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__011A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__011A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_011A = {.cp = 0x011A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__011A, .cde = &lxb_unicode_decomposition_c_011A, .kde = &lxb_unicode_decomposition_k_011A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_011B[2] = {0x0065, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_011B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_011B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_011B[2] = {0x0065, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_011B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_011B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__011B[2] = {0x0065, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__011B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__011B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_011B = {.cp = 0x011B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__011B, .cde = &lxb_unicode_decomposition_c_011B, .kde = &lxb_unicode_decomposition_k_011B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_011C[2] = {0x0047, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_011C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_011C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_011C[2] = {0x0047, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_011C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_011C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__011C[2] = {0x0047, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__011C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__011C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_011C = {.cp = 0x011C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__011C, .cde = &lxb_unicode_decomposition_c_011C, .kde = &lxb_unicode_decomposition_k_011C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_011D[2] = {0x0067, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_011D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_011D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_011D[2] = {0x0067, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_011D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_011D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__011D[2] = {0x0067, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__011D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__011D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_011D = {.cp = 0x011D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__011D, .cde = &lxb_unicode_decomposition_c_011D, .kde = &lxb_unicode_decomposition_k_011D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_011E[2] = {0x0047, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_011E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_011E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_011E[2] = {0x0047, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_011E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_011E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__011E[2] = {0x0047, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__011E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__011E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_011E = {.cp = 0x011E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__011E, .cde = &lxb_unicode_decomposition_c_011E, .kde = &lxb_unicode_decomposition_k_011E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_011F[2] = {0x0067, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_011F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_011F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_011F[2] = {0x0067, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_011F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_011F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__011F[2] = {0x0067, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__011F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__011F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_011F = {.cp = 0x011F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__011F, .cde = &lxb_unicode_decomposition_c_011F, .kde = &lxb_unicode_decomposition_k_011F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0120[2] = {0x0047, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0120 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0120, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0120[2] = {0x0047, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0120 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0120, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0120[2] = {0x0047, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0120 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0120, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0120 = {.cp = 0x0120, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0120, .cde = &lxb_unicode_decomposition_c_0120, .kde = &lxb_unicode_decomposition_k_0120};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0121[2] = {0x0067, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0121 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0121, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0121[2] = {0x0067, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0121 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0121, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0121[2] = {0x0067, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0121 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0121, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0121 = {.cp = 0x0121, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0121, .cde = &lxb_unicode_decomposition_c_0121, .kde = &lxb_unicode_decomposition_k_0121};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0122[2] = {0x0047, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0122 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0122, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0122[2] = {0x0047, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0122 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0122, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0122[2] = {0x0047, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0122 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0122, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0122 = {.cp = 0x0122, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0122, .cde = &lxb_unicode_decomposition_c_0122, .kde = &lxb_unicode_decomposition_k_0122};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0123[2] = {0x0067, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0123 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0123, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0123[2] = {0x0067, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0123 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0123, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0123[2] = {0x0067, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0123 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0123, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0123 = {.cp = 0x0123, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0123, .cde = &lxb_unicode_decomposition_c_0123, .kde = &lxb_unicode_decomposition_k_0123};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0124[2] = {0x0048, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0124 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0124, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0124[2] = {0x0048, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0124 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0124, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0124[2] = {0x0048, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0124 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0124, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0124 = {.cp = 0x0124, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0124, .cde = &lxb_unicode_decomposition_c_0124, .kde = &lxb_unicode_decomposition_k_0124};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0125[2] = {0x0068, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0125 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0125, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0125[2] = {0x0068, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0125 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0125, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0125[2] = {0x0068, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0125 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0125, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0125 = {.cp = 0x0125, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0125, .cde = &lxb_unicode_decomposition_c_0125, .kde = &lxb_unicode_decomposition_k_0125};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0128[2] = {0x0049, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0128 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0128, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0128[2] = {0x0049, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0128 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0128, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0128[2] = {0x0049, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0128 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0128, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0128 = {.cp = 0x0128, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0128, .cde = &lxb_unicode_decomposition_c_0128, .kde = &lxb_unicode_decomposition_k_0128};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0129[2] = {0x0069, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0129 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0129, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0129[2] = {0x0069, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0129 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0129, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0129[2] = {0x0069, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0129 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0129, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0129 = {.cp = 0x0129, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0129, .cde = &lxb_unicode_decomposition_c_0129, .kde = &lxb_unicode_decomposition_k_0129};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_012A[2] = {0x0049, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_012A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_012A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_012A[2] = {0x0049, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_012A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_012A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__012A[2] = {0x0049, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__012A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__012A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_012A = {.cp = 0x012A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__012A, .cde = &lxb_unicode_decomposition_c_012A, .kde = &lxb_unicode_decomposition_k_012A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_012B[2] = {0x0069, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_012B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_012B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_012B[2] = {0x0069, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_012B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_012B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__012B[2] = {0x0069, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__012B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__012B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_012B = {.cp = 0x012B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__012B, .cde = &lxb_unicode_decomposition_c_012B, .kde = &lxb_unicode_decomposition_k_012B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_012C[2] = {0x0049, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_012C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_012C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_012C[2] = {0x0049, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_012C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_012C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__012C[2] = {0x0049, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__012C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__012C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_012C = {.cp = 0x012C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__012C, .cde = &lxb_unicode_decomposition_c_012C, .kde = &lxb_unicode_decomposition_k_012C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_012D[2] = {0x0069, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_012D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_012D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_012D[2] = {0x0069, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_012D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_012D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__012D[2] = {0x0069, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__012D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__012D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_012D = {.cp = 0x012D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__012D, .cde = &lxb_unicode_decomposition_c_012D, .kde = &lxb_unicode_decomposition_k_012D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_012E[2] = {0x0049, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_012E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_012E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_012E[2] = {0x0049, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_012E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_012E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__012E[2] = {0x0049, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__012E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__012E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_012E = {.cp = 0x012E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__012E, .cde = &lxb_unicode_decomposition_c_012E, .kde = &lxb_unicode_decomposition_k_012E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_012F[2] = {0x0069, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_012F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_012F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_012F[2] = {0x0069, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_012F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_012F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__012F[2] = {0x0069, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__012F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__012F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_012F = {.cp = 0x012F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__012F, .cde = &lxb_unicode_decomposition_c_012F, .kde = &lxb_unicode_decomposition_k_012F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0130[2] = {0x0049, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0130 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0130, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0130[2] = {0x0049, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0130 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0130, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0130[2] = {0x0049, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0130 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0130, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0130 = {.cp = 0x0130, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0130, .cde = &lxb_unicode_decomposition_c_0130, .kde = &lxb_unicode_decomposition_k_0130};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0132[2] = {0x0049, 0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0132 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0132, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0132[2] = {0x0049, 0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0132 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0132, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0132[2] = {0x0049, 0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0132 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0132, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0132 = {.cp = 0x0132, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0132, .cde = &lxb_unicode_decomposition_c_0132, .kde = &lxb_unicode_decomposition_k_0132};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0133[2] = {0x0069, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0133 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0133, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0133[2] = {0x0069, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0133 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0133, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0133[2] = {0x0069, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0133 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0133, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0133 = {.cp = 0x0133, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0133, .cde = &lxb_unicode_decomposition_c_0133, .kde = &lxb_unicode_decomposition_k_0133};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0134[2] = {0x004A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0134 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0134, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0134[2] = {0x004A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0134 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0134, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0134[2] = {0x004A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0134 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0134, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0134 = {.cp = 0x0134, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0134, .cde = &lxb_unicode_decomposition_c_0134, .kde = &lxb_unicode_decomposition_k_0134};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0135[2] = {0x006A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0135 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0135, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0135[2] = {0x006A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0135 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0135, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0135[2] = {0x006A, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0135 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0135, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0135 = {.cp = 0x0135, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0135, .cde = &lxb_unicode_decomposition_c_0135, .kde = &lxb_unicode_decomposition_k_0135};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0136[2] = {0x004B, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0136 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0136, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0136[2] = {0x004B, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0136 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0136, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0136[2] = {0x004B, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0136 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0136, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0136 = {.cp = 0x0136, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0136, .cde = &lxb_unicode_decomposition_c_0136, .kde = &lxb_unicode_decomposition_k_0136};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0137[2] = {0x006B, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0137 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0137, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0137[2] = {0x006B, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0137 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0137, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0137[2] = {0x006B, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0137 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0137, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0137 = {.cp = 0x0137, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0137, .cde = &lxb_unicode_decomposition_c_0137, .kde = &lxb_unicode_decomposition_k_0137};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0139[2] = {0x004C, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0139 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0139, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0139[2] = {0x004C, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0139 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0139, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0139[2] = {0x004C, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0139 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0139, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0139 = {.cp = 0x0139, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0139, .cde = &lxb_unicode_decomposition_c_0139, .kde = &lxb_unicode_decomposition_k_0139};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_013A[2] = {0x006C, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_013A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_013A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_013A[2] = {0x006C, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_013A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_013A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__013A[2] = {0x006C, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__013A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__013A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_013A = {.cp = 0x013A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__013A, .cde = &lxb_unicode_decomposition_c_013A, .kde = &lxb_unicode_decomposition_k_013A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_013B[2] = {0x004C, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_013B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_013B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_013B[2] = {0x004C, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_013B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_013B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__013B[2] = {0x004C, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__013B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__013B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_013B = {.cp = 0x013B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__013B, .cde = &lxb_unicode_decomposition_c_013B, .kde = &lxb_unicode_decomposition_k_013B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_013C[2] = {0x006C, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_013C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_013C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_013C[2] = {0x006C, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_013C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_013C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__013C[2] = {0x006C, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__013C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__013C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_013C = {.cp = 0x013C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__013C, .cde = &lxb_unicode_decomposition_c_013C, .kde = &lxb_unicode_decomposition_k_013C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_013D[2] = {0x004C, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_013D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_013D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_013D[2] = {0x004C, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_013D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_013D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__013D[2] = {0x004C, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__013D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__013D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_013D = {.cp = 0x013D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__013D, .cde = &lxb_unicode_decomposition_c_013D, .kde = &lxb_unicode_decomposition_k_013D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_013E[2] = {0x006C, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_013E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_013E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_013E[2] = {0x006C, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_013E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_013E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__013E[2] = {0x006C, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__013E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__013E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_013E = {.cp = 0x013E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__013E, .cde = &lxb_unicode_decomposition_c_013E, .kde = &lxb_unicode_decomposition_k_013E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_013F[2] = {0x004C, 0x00B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_013F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_013F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_013F[2] = {0x004C, 0x00B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_013F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_013F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__013F[2] = {0x004C, 0x00B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__013F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__013F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_013F = {.cp = 0x013F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__013F, .cde = &lxb_unicode_decomposition_c_013F, .kde = &lxb_unicode_decomposition_k_013F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0140[2] = {0x006C, 0x00B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0140 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0140, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0140[2] = {0x006C, 0x00B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0140 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0140, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0140[2] = {0x006C, 0x00B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0140 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0140, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0140 = {.cp = 0x0140, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0140, .cde = &lxb_unicode_decomposition_c_0140, .kde = &lxb_unicode_decomposition_k_0140};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0143[2] = {0x004E, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0143 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0143, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0143[2] = {0x004E, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0143 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0143, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0143[2] = {0x004E, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0143 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0143, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0143 = {.cp = 0x0143, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0143, .cde = &lxb_unicode_decomposition_c_0143, .kde = &lxb_unicode_decomposition_k_0143};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0144[2] = {0x006E, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0144 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0144, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0144[2] = {0x006E, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0144 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0144, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0144[2] = {0x006E, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0144 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0144, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0144 = {.cp = 0x0144, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0144, .cde = &lxb_unicode_decomposition_c_0144, .kde = &lxb_unicode_decomposition_k_0144};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0145[2] = {0x004E, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0145 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0145, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0145[2] = {0x004E, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0145 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0145, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0145[2] = {0x004E, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0145 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0145, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0145 = {.cp = 0x0145, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0145, .cde = &lxb_unicode_decomposition_c_0145, .kde = &lxb_unicode_decomposition_k_0145};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0146[2] = {0x006E, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0146 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0146, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0146[2] = {0x006E, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0146 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0146, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0146[2] = {0x006E, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0146 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0146, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0146 = {.cp = 0x0146, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0146, .cde = &lxb_unicode_decomposition_c_0146, .kde = &lxb_unicode_decomposition_k_0146};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0147[2] = {0x004E, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0147 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0147, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0147[2] = {0x004E, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0147 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0147, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0147[2] = {0x004E, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0147 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0147, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0147 = {.cp = 0x0147, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0147, .cde = &lxb_unicode_decomposition_c_0147, .kde = &lxb_unicode_decomposition_k_0147};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0148[2] = {0x006E, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0148 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0148, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0148[2] = {0x006E, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0148 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0148, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0148[2] = {0x006E, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0148 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0148, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0148 = {.cp = 0x0148, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0148, .cde = &lxb_unicode_decomposition_c_0148, .kde = &lxb_unicode_decomposition_k_0148};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0149[2] = {0x02BC, 0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0149 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0149, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0149[2] = {0x02BC, 0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0149 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0149, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0149[2] = {0x02BC, 0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0149 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0149, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0149 = {.cp = 0x0149, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0149, .cde = &lxb_unicode_decomposition_c_0149, .kde = &lxb_unicode_decomposition_k_0149};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_014C[2] = {0x004F, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_014C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_014C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_014C[2] = {0x004F, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_014C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_014C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__014C[2] = {0x004F, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__014C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__014C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_014C = {.cp = 0x014C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__014C, .cde = &lxb_unicode_decomposition_c_014C, .kde = &lxb_unicode_decomposition_k_014C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_014D[2] = {0x006F, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_014D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_014D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_014D[2] = {0x006F, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_014D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_014D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__014D[2] = {0x006F, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__014D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__014D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_014D = {.cp = 0x014D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__014D, .cde = &lxb_unicode_decomposition_c_014D, .kde = &lxb_unicode_decomposition_k_014D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_014E[2] = {0x004F, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_014E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_014E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_014E[2] = {0x004F, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_014E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_014E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__014E[2] = {0x004F, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__014E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__014E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_014E = {.cp = 0x014E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__014E, .cde = &lxb_unicode_decomposition_c_014E, .kde = &lxb_unicode_decomposition_k_014E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_014F[2] = {0x006F, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_014F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_014F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_014F[2] = {0x006F, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_014F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_014F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__014F[2] = {0x006F, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__014F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__014F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_014F = {.cp = 0x014F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__014F, .cde = &lxb_unicode_decomposition_c_014F, .kde = &lxb_unicode_decomposition_k_014F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0150[2] = {0x004F, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0150 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0150, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0150[2] = {0x004F, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0150 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0150, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0150[2] = {0x004F, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0150 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0150, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0150 = {.cp = 0x0150, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0150, .cde = &lxb_unicode_decomposition_c_0150, .kde = &lxb_unicode_decomposition_k_0150};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0151[2] = {0x006F, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0151 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0151, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0151[2] = {0x006F, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0151 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0151, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0151[2] = {0x006F, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0151 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0151, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0151 = {.cp = 0x0151, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0151, .cde = &lxb_unicode_decomposition_c_0151, .kde = &lxb_unicode_decomposition_k_0151};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0154[2] = {0x0052, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0154 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0154, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0154[2] = {0x0052, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0154 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0154, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0154[2] = {0x0052, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0154 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0154, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0154 = {.cp = 0x0154, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0154, .cde = &lxb_unicode_decomposition_c_0154, .kde = &lxb_unicode_decomposition_k_0154};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0155[2] = {0x0072, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0155 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0155, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0155[2] = {0x0072, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0155 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0155, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0155[2] = {0x0072, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0155 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0155, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0155 = {.cp = 0x0155, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0155, .cde = &lxb_unicode_decomposition_c_0155, .kde = &lxb_unicode_decomposition_k_0155};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0156[2] = {0x0052, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0156 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0156, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0156[2] = {0x0052, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0156 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0156, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0156[2] = {0x0052, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0156 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0156, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0156 = {.cp = 0x0156, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0156, .cde = &lxb_unicode_decomposition_c_0156, .kde = &lxb_unicode_decomposition_k_0156};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0157[2] = {0x0072, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0157 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0157, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0157[2] = {0x0072, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0157 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0157, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0157[2] = {0x0072, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0157 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0157, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0157 = {.cp = 0x0157, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0157, .cde = &lxb_unicode_decomposition_c_0157, .kde = &lxb_unicode_decomposition_k_0157};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0158[2] = {0x0052, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0158 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0158, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0158[2] = {0x0052, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0158 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0158, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0158[2] = {0x0052, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0158 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0158, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0158 = {.cp = 0x0158, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0158, .cde = &lxb_unicode_decomposition_c_0158, .kde = &lxb_unicode_decomposition_k_0158};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0159[2] = {0x0072, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0159 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0159, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0159[2] = {0x0072, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0159 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0159, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0159[2] = {0x0072, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0159 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0159, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0159 = {.cp = 0x0159, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0159, .cde = &lxb_unicode_decomposition_c_0159, .kde = &lxb_unicode_decomposition_k_0159};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_015A[2] = {0x0053, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_015A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_015A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_015A[2] = {0x0053, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_015A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_015A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__015A[2] = {0x0053, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__015A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__015A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_015A = {.cp = 0x015A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__015A, .cde = &lxb_unicode_decomposition_c_015A, .kde = &lxb_unicode_decomposition_k_015A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_015B[2] = {0x0073, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_015B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_015B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_015B[2] = {0x0073, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_015B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_015B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__015B[2] = {0x0073, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__015B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__015B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_015B = {.cp = 0x015B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__015B, .cde = &lxb_unicode_decomposition_c_015B, .kde = &lxb_unicode_decomposition_k_015B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_015C[2] = {0x0053, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_015C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_015C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_015C[2] = {0x0053, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_015C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_015C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__015C[2] = {0x0053, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__015C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__015C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_015C = {.cp = 0x015C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__015C, .cde = &lxb_unicode_decomposition_c_015C, .kde = &lxb_unicode_decomposition_k_015C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_015D[2] = {0x0073, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_015D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_015D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_015D[2] = {0x0073, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_015D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_015D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__015D[2] = {0x0073, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__015D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__015D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_015D = {.cp = 0x015D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__015D, .cde = &lxb_unicode_decomposition_c_015D, .kde = &lxb_unicode_decomposition_k_015D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_015E[2] = {0x0053, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_015E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_015E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_015E[2] = {0x0053, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_015E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_015E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__015E[2] = {0x0053, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__015E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__015E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_015E = {.cp = 0x015E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__015E, .cde = &lxb_unicode_decomposition_c_015E, .kde = &lxb_unicode_decomposition_k_015E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_015F[2] = {0x0073, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_015F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_015F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_015F[2] = {0x0073, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_015F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_015F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__015F[2] = {0x0073, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__015F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__015F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_015F = {.cp = 0x015F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__015F, .cde = &lxb_unicode_decomposition_c_015F, .kde = &lxb_unicode_decomposition_k_015F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0160[2] = {0x0053, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0160, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0160[2] = {0x0053, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0160, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0160[2] = {0x0053, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0160, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0160 = {.cp = 0x0160, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0160, .cde = &lxb_unicode_decomposition_c_0160, .kde = &lxb_unicode_decomposition_k_0160};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0161[2] = {0x0073, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0161, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0161[2] = {0x0073, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0161, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0161[2] = {0x0073, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0161, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0161 = {.cp = 0x0161, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0161, .cde = &lxb_unicode_decomposition_c_0161, .kde = &lxb_unicode_decomposition_k_0161};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0162[2] = {0x0054, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0162, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0162[2] = {0x0054, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0162, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0162[2] = {0x0054, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0162, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0162 = {.cp = 0x0162, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0162, .cde = &lxb_unicode_decomposition_c_0162, .kde = &lxb_unicode_decomposition_k_0162};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0163[2] = {0x0074, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0163, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0163[2] = {0x0074, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0163, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0163[2] = {0x0074, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0163, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0163 = {.cp = 0x0163, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0163, .cde = &lxb_unicode_decomposition_c_0163, .kde = &lxb_unicode_decomposition_k_0163};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0164[2] = {0x0054, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0164, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0164[2] = {0x0054, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0164, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0164[2] = {0x0054, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0164, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0164 = {.cp = 0x0164, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0164, .cde = &lxb_unicode_decomposition_c_0164, .kde = &lxb_unicode_decomposition_k_0164};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0165[2] = {0x0074, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0165 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0165, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0165[2] = {0x0074, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0165 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0165, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0165[2] = {0x0074, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0165 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0165, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0165 = {.cp = 0x0165, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0165, .cde = &lxb_unicode_decomposition_c_0165, .kde = &lxb_unicode_decomposition_k_0165};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0168[2] = {0x0055, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0168 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0168, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0168[2] = {0x0055, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0168 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0168, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0168[2] = {0x0055, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0168 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0168, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0168 = {.cp = 0x0168, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0168, .cde = &lxb_unicode_decomposition_c_0168, .kde = &lxb_unicode_decomposition_k_0168};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0169[2] = {0x0075, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0169 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0169, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0169[2] = {0x0075, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0169 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0169, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0169[2] = {0x0075, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0169 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0169, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0169 = {.cp = 0x0169, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0169, .cde = &lxb_unicode_decomposition_c_0169, .kde = &lxb_unicode_decomposition_k_0169};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_016A[2] = {0x0055, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_016A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_016A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_016A[2] = {0x0055, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_016A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_016A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__016A[2] = {0x0055, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__016A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__016A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_016A = {.cp = 0x016A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__016A, .cde = &lxb_unicode_decomposition_c_016A, .kde = &lxb_unicode_decomposition_k_016A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_016B[2] = {0x0075, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_016B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_016B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_016B[2] = {0x0075, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_016B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_016B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__016B[2] = {0x0075, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__016B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__016B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_016B = {.cp = 0x016B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__016B, .cde = &lxb_unicode_decomposition_c_016B, .kde = &lxb_unicode_decomposition_k_016B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_016C[2] = {0x0055, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_016C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_016C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_016C[2] = {0x0055, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_016C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_016C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__016C[2] = {0x0055, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__016C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__016C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_016C = {.cp = 0x016C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__016C, .cde = &lxb_unicode_decomposition_c_016C, .kde = &lxb_unicode_decomposition_k_016C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_016D[2] = {0x0075, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_016D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_016D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_016D[2] = {0x0075, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_016D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_016D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__016D[2] = {0x0075, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__016D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__016D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_016D = {.cp = 0x016D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__016D, .cde = &lxb_unicode_decomposition_c_016D, .kde = &lxb_unicode_decomposition_k_016D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_016E[2] = {0x0055, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_016E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_016E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_016E[2] = {0x0055, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_016E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_016E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__016E[2] = {0x0055, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__016E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__016E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_016E = {.cp = 0x016E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__016E, .cde = &lxb_unicode_decomposition_c_016E, .kde = &lxb_unicode_decomposition_k_016E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_016F[2] = {0x0075, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_016F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_016F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_016F[2] = {0x0075, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_016F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_016F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__016F[2] = {0x0075, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__016F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__016F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_016F = {.cp = 0x016F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__016F, .cde = &lxb_unicode_decomposition_c_016F, .kde = &lxb_unicode_decomposition_k_016F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0170[2] = {0x0055, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0170 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0170, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0170[2] = {0x0055, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0170 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0170, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0170[2] = {0x0055, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0170 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0170, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0170 = {.cp = 0x0170, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0170, .cde = &lxb_unicode_decomposition_c_0170, .kde = &lxb_unicode_decomposition_k_0170};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0171[2] = {0x0075, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0171 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0171, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0171[2] = {0x0075, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0171 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0171, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0171[2] = {0x0075, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0171 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0171, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0171 = {.cp = 0x0171, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0171, .cde = &lxb_unicode_decomposition_c_0171, .kde = &lxb_unicode_decomposition_k_0171};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0172[2] = {0x0055, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0172 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0172, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0172[2] = {0x0055, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0172 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0172, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0172[2] = {0x0055, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0172 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0172, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0172 = {.cp = 0x0172, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0172, .cde = &lxb_unicode_decomposition_c_0172, .kde = &lxb_unicode_decomposition_k_0172};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0173[2] = {0x0075, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0173 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0173, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0173[2] = {0x0075, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0173 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0173, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0173[2] = {0x0075, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0173 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0173, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0173 = {.cp = 0x0173, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0173, .cde = &lxb_unicode_decomposition_c_0173, .kde = &lxb_unicode_decomposition_k_0173};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0174[2] = {0x0057, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0174 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0174, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0174[2] = {0x0057, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0174 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0174, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0174[2] = {0x0057, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0174 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0174, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0174 = {.cp = 0x0174, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0174, .cde = &lxb_unicode_decomposition_c_0174, .kde = &lxb_unicode_decomposition_k_0174};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0175[2] = {0x0077, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0175 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0175, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0175[2] = {0x0077, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0175 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0175, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0175[2] = {0x0077, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0175 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0175, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0175 = {.cp = 0x0175, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0175, .cde = &lxb_unicode_decomposition_c_0175, .kde = &lxb_unicode_decomposition_k_0175};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0176[2] = {0x0059, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0176 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0176, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0176[2] = {0x0059, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0176 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0176, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0176[2] = {0x0059, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0176 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0176, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0176 = {.cp = 0x0176, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0176, .cde = &lxb_unicode_decomposition_c_0176, .kde = &lxb_unicode_decomposition_k_0176};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0177[2] = {0x0079, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0177 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0177, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0177[2] = {0x0079, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0177 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0177, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0177[2] = {0x0079, 0x0302};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0177 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0177, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0177 = {.cp = 0x0177, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0177, .cde = &lxb_unicode_decomposition_c_0177, .kde = &lxb_unicode_decomposition_k_0177};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0178[2] = {0x0059, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0178 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0178, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0178[2] = {0x0059, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0178 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0178, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0178[2] = {0x0059, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0178 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0178, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0178 = {.cp = 0x0178, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0178, .cde = &lxb_unicode_decomposition_c_0178, .kde = &lxb_unicode_decomposition_k_0178};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0179[2] = {0x005A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0179 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0179, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0179[2] = {0x005A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0179 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0179, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0179[2] = {0x005A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0179 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0179, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0179 = {.cp = 0x0179, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0179, .cde = &lxb_unicode_decomposition_c_0179, .kde = &lxb_unicode_decomposition_k_0179};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_017A[2] = {0x007A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_017A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_017A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_017A[2] = {0x007A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_017A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_017A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__017A[2] = {0x007A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__017A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__017A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_017A = {.cp = 0x017A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__017A, .cde = &lxb_unicode_decomposition_c_017A, .kde = &lxb_unicode_decomposition_k_017A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_017B[2] = {0x005A, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_017B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_017B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_017B[2] = {0x005A, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_017B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_017B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__017B[2] = {0x005A, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__017B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__017B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_017B = {.cp = 0x017B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__017B, .cde = &lxb_unicode_decomposition_c_017B, .kde = &lxb_unicode_decomposition_k_017B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_017C[2] = {0x007A, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_017C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_017C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_017C[2] = {0x007A, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_017C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_017C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__017C[2] = {0x007A, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__017C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__017C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_017C = {.cp = 0x017C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__017C, .cde = &lxb_unicode_decomposition_c_017C, .kde = &lxb_unicode_decomposition_k_017C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_017D[2] = {0x005A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_017D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_017D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_017D[2] = {0x005A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_017D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_017D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__017D[2] = {0x005A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__017D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__017D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_017D = {.cp = 0x017D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__017D, .cde = &lxb_unicode_decomposition_c_017D, .kde = &lxb_unicode_decomposition_k_017D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_017E[2] = {0x007A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_017E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_017E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_017E[2] = {0x007A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_017E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_017E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__017E[2] = {0x007A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__017E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__017E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_017E = {.cp = 0x017E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__017E, .cde = &lxb_unicode_decomposition_c_017E, .kde = &lxb_unicode_decomposition_k_017E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_017F[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_017F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_017F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_017F[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_017F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_017F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__017F[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__017F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__017F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_017F = {.cp = 0x017F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__017F, .cde = &lxb_unicode_decomposition_c_017F, .kde = &lxb_unicode_decomposition_k_017F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01A0[2] = {0x004F, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01A0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01A0[2] = {0x004F, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01A0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01A0[2] = {0x004F, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01A0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01A0 = {.cp = 0x01A0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01A0, .cde = &lxb_unicode_decomposition_c_01A0, .kde = &lxb_unicode_decomposition_k_01A0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01A1[2] = {0x006F, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01A1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01A1[2] = {0x006F, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01A1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01A1[2] = {0x006F, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01A1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01A1 = {.cp = 0x01A1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01A1, .cde = &lxb_unicode_decomposition_c_01A1, .kde = &lxb_unicode_decomposition_k_01A1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01AF[2] = {0x0055, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01AF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01AF[2] = {0x0055, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01AF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01AF[2] = {0x0055, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01AF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01AF = {.cp = 0x01AF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01AF, .cde = &lxb_unicode_decomposition_c_01AF, .kde = &lxb_unicode_decomposition_k_01AF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01B0[2] = {0x0075, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01B0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01B0[2] = {0x0075, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01B0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01B0[2] = {0x0075, 0x031B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01B0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01B0 = {.cp = 0x01B0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01B0, .cde = &lxb_unicode_decomposition_c_01B0, .kde = &lxb_unicode_decomposition_k_01B0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01C4[3] = {0x0044, 0x005A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01C4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01C4[3] = {0x0044, 0x005A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01C4, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01C4[2] = {0x0044, 0x017D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01C4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01C4 = {.cp = 0x01C4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01C4, .cde = &lxb_unicode_decomposition_c_01C4, .kde = &lxb_unicode_decomposition_k_01C4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01C5[3] = {0x0044, 0x007A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01C5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01C5[3] = {0x0044, 0x007A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01C5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01C5[2] = {0x0044, 0x017E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01C5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01C5 = {.cp = 0x01C5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01C5, .cde = &lxb_unicode_decomposition_c_01C5, .kde = &lxb_unicode_decomposition_k_01C5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01C6[3] = {0x0064, 0x007A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01C6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01C6[3] = {0x0064, 0x007A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01C6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01C6[2] = {0x0064, 0x017E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01C6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01C6 = {.cp = 0x01C6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01C6, .cde = &lxb_unicode_decomposition_c_01C6, .kde = &lxb_unicode_decomposition_k_01C6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01C7[2] = {0x004C, 0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01C7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01C7[2] = {0x004C, 0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01C7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01C7[2] = {0x004C, 0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01C7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01C7 = {.cp = 0x01C7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01C7, .cde = &lxb_unicode_decomposition_c_01C7, .kde = &lxb_unicode_decomposition_k_01C7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01C8[2] = {0x004C, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01C8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01C8[2] = {0x004C, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01C8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01C8[2] = {0x004C, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01C8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01C8 = {.cp = 0x01C8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01C8, .cde = &lxb_unicode_decomposition_c_01C8, .kde = &lxb_unicode_decomposition_k_01C8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01C9[2] = {0x006C, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01C9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01C9[2] = {0x006C, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01C9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01C9[2] = {0x006C, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01C9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01C9 = {.cp = 0x01C9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01C9, .cde = &lxb_unicode_decomposition_c_01C9, .kde = &lxb_unicode_decomposition_k_01C9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01CA[2] = {0x004E, 0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01CA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01CA[2] = {0x004E, 0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01CA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01CA[2] = {0x004E, 0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01CA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01CA = {.cp = 0x01CA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01CA, .cde = &lxb_unicode_decomposition_c_01CA, .kde = &lxb_unicode_decomposition_k_01CA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01CB[2] = {0x004E, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01CB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01CB[2] = {0x004E, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01CB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01CB[2] = {0x004E, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01CB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01CB = {.cp = 0x01CB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01CB, .cde = &lxb_unicode_decomposition_c_01CB, .kde = &lxb_unicode_decomposition_k_01CB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01CC[2] = {0x006E, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01CC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01CC[2] = {0x006E, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01CC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01CC[2] = {0x006E, 0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01CC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01CC = {.cp = 0x01CC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01CC, .cde = &lxb_unicode_decomposition_c_01CC, .kde = &lxb_unicode_decomposition_k_01CC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01CD[2] = {0x0041, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01CD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01CD[2] = {0x0041, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01CD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01CD[2] = {0x0041, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01CD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01CD = {.cp = 0x01CD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01CD, .cde = &lxb_unicode_decomposition_c_01CD, .kde = &lxb_unicode_decomposition_k_01CD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01CE[2] = {0x0061, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01CE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01CE[2] = {0x0061, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01CE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01CE[2] = {0x0061, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01CE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01CE = {.cp = 0x01CE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01CE, .cde = &lxb_unicode_decomposition_c_01CE, .kde = &lxb_unicode_decomposition_k_01CE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01CF[2] = {0x0049, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01CF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01CF[2] = {0x0049, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01CF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01CF[2] = {0x0049, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01CF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01CF = {.cp = 0x01CF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01CF, .cde = &lxb_unicode_decomposition_c_01CF, .kde = &lxb_unicode_decomposition_k_01CF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01D0[2] = {0x0069, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01D0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01D0[2] = {0x0069, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01D0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01D0[2] = {0x0069, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01D0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01D0 = {.cp = 0x01D0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01D0, .cde = &lxb_unicode_decomposition_c_01D0, .kde = &lxb_unicode_decomposition_k_01D0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01D1[2] = {0x004F, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01D1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01D1[2] = {0x004F, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01D1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01D1[2] = {0x004F, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01D1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01D1 = {.cp = 0x01D1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01D1, .cde = &lxb_unicode_decomposition_c_01D1, .kde = &lxb_unicode_decomposition_k_01D1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01D2[2] = {0x006F, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01D2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01D2[2] = {0x006F, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01D2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01D2[2] = {0x006F, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01D2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01D2 = {.cp = 0x01D2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01D2, .cde = &lxb_unicode_decomposition_c_01D2, .kde = &lxb_unicode_decomposition_k_01D2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01D3[2] = {0x0055, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01D3[2] = {0x0055, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01D3[2] = {0x0055, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01D3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01D3 = {.cp = 0x01D3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01D3, .cde = &lxb_unicode_decomposition_c_01D3, .kde = &lxb_unicode_decomposition_k_01D3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01D4[2] = {0x0075, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01D4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01D4[2] = {0x0075, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01D4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01D4[2] = {0x0075, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01D4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01D4 = {.cp = 0x01D4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01D4, .cde = &lxb_unicode_decomposition_c_01D4, .kde = &lxb_unicode_decomposition_k_01D4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01D5[3] = {0x0055, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01D5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01D5[3] = {0x0055, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01D5, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01D5[2] = {0x00DC, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01D5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01D5 = {.cp = 0x01D5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01D5, .cde = &lxb_unicode_decomposition_c_01D5, .kde = &lxb_unicode_decomposition_k_01D5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01D6[3] = {0x0075, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01D6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01D6[3] = {0x0075, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01D6, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01D6[2] = {0x00FC, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01D6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01D6 = {.cp = 0x01D6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01D6, .cde = &lxb_unicode_decomposition_c_01D6, .kde = &lxb_unicode_decomposition_k_01D6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01D7[3] = {0x0055, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01D7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01D7[3] = {0x0055, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01D7, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01D7[2] = {0x00DC, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01D7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01D7 = {.cp = 0x01D7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01D7, .cde = &lxb_unicode_decomposition_c_01D7, .kde = &lxb_unicode_decomposition_k_01D7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01D8[3] = {0x0075, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01D8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01D8[3] = {0x0075, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01D8, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01D8[2] = {0x00FC, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01D8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01D8 = {.cp = 0x01D8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01D8, .cde = &lxb_unicode_decomposition_c_01D8, .kde = &lxb_unicode_decomposition_k_01D8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01D9[3] = {0x0055, 0x0308, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01D9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01D9[3] = {0x0055, 0x0308, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01D9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01D9[2] = {0x00DC, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01D9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01D9 = {.cp = 0x01D9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01D9, .cde = &lxb_unicode_decomposition_c_01D9, .kde = &lxb_unicode_decomposition_k_01D9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01DA[3] = {0x0075, 0x0308, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01DA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01DA[3] = {0x0075, 0x0308, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01DA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01DA[2] = {0x00FC, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01DA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01DA = {.cp = 0x01DA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01DA, .cde = &lxb_unicode_decomposition_c_01DA, .kde = &lxb_unicode_decomposition_k_01DA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01DB[3] = {0x0055, 0x0308, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01DB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01DB[3] = {0x0055, 0x0308, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01DB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01DB[2] = {0x00DC, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01DB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01DB = {.cp = 0x01DB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01DB, .cde = &lxb_unicode_decomposition_c_01DB, .kde = &lxb_unicode_decomposition_k_01DB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01DC[3] = {0x0075, 0x0308, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01DC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01DC[3] = {0x0075, 0x0308, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01DC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01DC[2] = {0x00FC, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01DC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01DC = {.cp = 0x01DC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01DC, .cde = &lxb_unicode_decomposition_c_01DC, .kde = &lxb_unicode_decomposition_k_01DC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01DE[3] = {0x0041, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01DE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01DE[3] = {0x0041, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01DE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01DE[2] = {0x00C4, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01DE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01DE = {.cp = 0x01DE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01DE, .cde = &lxb_unicode_decomposition_c_01DE, .kde = &lxb_unicode_decomposition_k_01DE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01DF[3] = {0x0061, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01DF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01DF[3] = {0x0061, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01DF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01DF[2] = {0x00E4, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01DF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01DF = {.cp = 0x01DF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01DF, .cde = &lxb_unicode_decomposition_c_01DF, .kde = &lxb_unicode_decomposition_k_01DF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01E0[3] = {0x0041, 0x0307, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01E0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01E0[3] = {0x0041, 0x0307, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01E0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01E0[2] = {0x0226, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01E0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01E0 = {.cp = 0x01E0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01E0, .cde = &lxb_unicode_decomposition_c_01E0, .kde = &lxb_unicode_decomposition_k_01E0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01E1[3] = {0x0061, 0x0307, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01E1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01E1[3] = {0x0061, 0x0307, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01E1, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01E1[2] = {0x0227, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01E1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01E1 = {.cp = 0x01E1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01E1, .cde = &lxb_unicode_decomposition_c_01E1, .kde = &lxb_unicode_decomposition_k_01E1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01E2[2] = {0x00C6, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01E2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01E2[2] = {0x00C6, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01E2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01E2[2] = {0x00C6, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01E2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01E2 = {.cp = 0x01E2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01E2, .cde = &lxb_unicode_decomposition_c_01E2, .kde = &lxb_unicode_decomposition_k_01E2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01E3[2] = {0x00E6, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01E3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01E3[2] = {0x00E6, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01E3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01E3[2] = {0x00E6, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01E3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01E3 = {.cp = 0x01E3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01E3, .cde = &lxb_unicode_decomposition_c_01E3, .kde = &lxb_unicode_decomposition_k_01E3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01E6[2] = {0x0047, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01E6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01E6[2] = {0x0047, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01E6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01E6[2] = {0x0047, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01E6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01E6 = {.cp = 0x01E6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01E6, .cde = &lxb_unicode_decomposition_c_01E6, .kde = &lxb_unicode_decomposition_k_01E6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01E7[2] = {0x0067, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01E7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01E7[2] = {0x0067, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01E7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01E7[2] = {0x0067, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01E7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01E7 = {.cp = 0x01E7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01E7, .cde = &lxb_unicode_decomposition_c_01E7, .kde = &lxb_unicode_decomposition_k_01E7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01E8[2] = {0x004B, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01E8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01E8[2] = {0x004B, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01E8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01E8[2] = {0x004B, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01E8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01E8 = {.cp = 0x01E8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01E8, .cde = &lxb_unicode_decomposition_c_01E8, .kde = &lxb_unicode_decomposition_k_01E8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01E9[2] = {0x006B, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01E9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01E9[2] = {0x006B, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01E9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01E9[2] = {0x006B, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01E9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01E9 = {.cp = 0x01E9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01E9, .cde = &lxb_unicode_decomposition_c_01E9, .kde = &lxb_unicode_decomposition_k_01E9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01EA[2] = {0x004F, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01EA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01EA[2] = {0x004F, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01EA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01EA[2] = {0x004F, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01EA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01EA = {.cp = 0x01EA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01EA, .cde = &lxb_unicode_decomposition_c_01EA, .kde = &lxb_unicode_decomposition_k_01EA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01EB[2] = {0x006F, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01EB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01EB[2] = {0x006F, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01EB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01EB[2] = {0x006F, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01EB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01EB = {.cp = 0x01EB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01EB, .cde = &lxb_unicode_decomposition_c_01EB, .kde = &lxb_unicode_decomposition_k_01EB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01EC[3] = {0x004F, 0x0328, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01EC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01EC[3] = {0x004F, 0x0328, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01EC, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01EC[2] = {0x01EA, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01EC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01EC = {.cp = 0x01EC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01EC, .cde = &lxb_unicode_decomposition_c_01EC, .kde = &lxb_unicode_decomposition_k_01EC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01ED[3] = {0x006F, 0x0328, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01ED, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01ED[3] = {0x006F, 0x0328, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01ED, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01ED[2] = {0x01EB, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01ED, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01ED = {.cp = 0x01ED, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01ED, .cde = &lxb_unicode_decomposition_c_01ED, .kde = &lxb_unicode_decomposition_k_01ED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01EE[2] = {0x01B7, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01EE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01EE[2] = {0x01B7, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01EE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01EE[2] = {0x01B7, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01EE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01EE = {.cp = 0x01EE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01EE, .cde = &lxb_unicode_decomposition_c_01EE, .kde = &lxb_unicode_decomposition_k_01EE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01EF[2] = {0x0292, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01EF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01EF[2] = {0x0292, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01EF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01EF[2] = {0x0292, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01EF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01EF = {.cp = 0x01EF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01EF, .cde = &lxb_unicode_decomposition_c_01EF, .kde = &lxb_unicode_decomposition_k_01EF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01F0[2] = {0x006A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01F0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01F0[2] = {0x006A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01F0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01F0[2] = {0x006A, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01F0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01F0 = {.cp = 0x01F0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01F0, .cde = &lxb_unicode_decomposition_c_01F0, .kde = &lxb_unicode_decomposition_k_01F0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01F1[2] = {0x0044, 0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01F1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01F1[2] = {0x0044, 0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01F1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01F1[2] = {0x0044, 0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01F1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01F1 = {.cp = 0x01F1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01F1, .cde = &lxb_unicode_decomposition_c_01F1, .kde = &lxb_unicode_decomposition_k_01F1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01F2[2] = {0x0044, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01F2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01F2[2] = {0x0044, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01F2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01F2[2] = {0x0044, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01F2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01F2 = {.cp = 0x01F2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01F2, .cde = &lxb_unicode_decomposition_c_01F2, .kde = &lxb_unicode_decomposition_k_01F2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01F3[2] = {0x0064, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_01F3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01F3[2] = {0x0064, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_01F3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01F3[2] = {0x0064, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__01F3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01F3 = {.cp = 0x01F3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01F3, .cde = &lxb_unicode_decomposition_c_01F3, .kde = &lxb_unicode_decomposition_k_01F3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01F4[2] = {0x0047, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01F4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01F4[2] = {0x0047, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01F4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01F4[2] = {0x0047, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01F4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01F4 = {.cp = 0x01F4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01F4, .cde = &lxb_unicode_decomposition_c_01F4, .kde = &lxb_unicode_decomposition_k_01F4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01F5[2] = {0x0067, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01F5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01F5[2] = {0x0067, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01F5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01F5[2] = {0x0067, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01F5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01F5 = {.cp = 0x01F5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01F5, .cde = &lxb_unicode_decomposition_c_01F5, .kde = &lxb_unicode_decomposition_k_01F5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01F8[2] = {0x004E, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01F8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01F8[2] = {0x004E, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01F8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01F8[2] = {0x004E, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01F8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01F8 = {.cp = 0x01F8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01F8, .cde = &lxb_unicode_decomposition_c_01F8, .kde = &lxb_unicode_decomposition_k_01F8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01F9[2] = {0x006E, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01F9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01F9[2] = {0x006E, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01F9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01F9[2] = {0x006E, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01F9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01F9 = {.cp = 0x01F9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01F9, .cde = &lxb_unicode_decomposition_c_01F9, .kde = &lxb_unicode_decomposition_k_01F9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01FA[3] = {0x0041, 0x030A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01FA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01FA[3] = {0x0041, 0x030A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01FA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01FA[2] = {0x00C5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01FA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01FA = {.cp = 0x01FA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01FA, .cde = &lxb_unicode_decomposition_c_01FA, .kde = &lxb_unicode_decomposition_k_01FA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01FB[3] = {0x0061, 0x030A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01FB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01FB[3] = {0x0061, 0x030A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01FB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01FB[2] = {0x00E5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01FB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01FB = {.cp = 0x01FB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01FB, .cde = &lxb_unicode_decomposition_c_01FB, .kde = &lxb_unicode_decomposition_k_01FB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01FC[2] = {0x00C6, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01FC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01FC[2] = {0x00C6, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01FC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01FC[2] = {0x00C6, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01FC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01FC = {.cp = 0x01FC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01FC, .cde = &lxb_unicode_decomposition_c_01FC, .kde = &lxb_unicode_decomposition_k_01FC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01FD[2] = {0x00E6, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01FD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01FD[2] = {0x00E6, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01FD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01FD[2] = {0x00E6, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01FD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01FD = {.cp = 0x01FD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01FD, .cde = &lxb_unicode_decomposition_c_01FD, .kde = &lxb_unicode_decomposition_k_01FD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01FE[2] = {0x00D8, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01FE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01FE[2] = {0x00D8, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01FE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01FE[2] = {0x00D8, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01FE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01FE = {.cp = 0x01FE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01FE, .cde = &lxb_unicode_decomposition_c_01FE, .kde = &lxb_unicode_decomposition_k_01FE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_01FF[2] = {0x00F8, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_01FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_01FF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_01FF[2] = {0x00F8, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_01FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_01FF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__01FF[2] = {0x00F8, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__01FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__01FF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_01FF = {.cp = 0x01FF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__01FF, .cde = &lxb_unicode_decomposition_c_01FF, .kde = &lxb_unicode_decomposition_k_01FF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0200[2] = {0x0041, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0200 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0200, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0200[2] = {0x0041, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0200 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0200, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0200[2] = {0x0041, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0200 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0200, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0200 = {.cp = 0x0200, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0200, .cde = &lxb_unicode_decomposition_c_0200, .kde = &lxb_unicode_decomposition_k_0200};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0201[2] = {0x0061, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0201 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0201, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0201[2] = {0x0061, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0201 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0201, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0201[2] = {0x0061, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0201 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0201, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0201 = {.cp = 0x0201, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0201, .cde = &lxb_unicode_decomposition_c_0201, .kde = &lxb_unicode_decomposition_k_0201};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0202[2] = {0x0041, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0202 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0202, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0202[2] = {0x0041, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0202 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0202, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0202[2] = {0x0041, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0202 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0202, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0202 = {.cp = 0x0202, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0202, .cde = &lxb_unicode_decomposition_c_0202, .kde = &lxb_unicode_decomposition_k_0202};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0203[2] = {0x0061, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0203 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0203, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0203[2] = {0x0061, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0203 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0203, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0203[2] = {0x0061, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0203 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0203, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0203 = {.cp = 0x0203, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0203, .cde = &lxb_unicode_decomposition_c_0203, .kde = &lxb_unicode_decomposition_k_0203};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0204[2] = {0x0045, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0204 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0204, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0204[2] = {0x0045, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0204 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0204, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0204[2] = {0x0045, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0204 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0204, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0204 = {.cp = 0x0204, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0204, .cde = &lxb_unicode_decomposition_c_0204, .kde = &lxb_unicode_decomposition_k_0204};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0205[2] = {0x0065, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0205 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0205, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0205[2] = {0x0065, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0205 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0205, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0205[2] = {0x0065, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0205 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0205, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0205 = {.cp = 0x0205, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0205, .cde = &lxb_unicode_decomposition_c_0205, .kde = &lxb_unicode_decomposition_k_0205};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0206[2] = {0x0045, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0206 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0206, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0206[2] = {0x0045, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0206 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0206, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0206[2] = {0x0045, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0206 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0206, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0206 = {.cp = 0x0206, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0206, .cde = &lxb_unicode_decomposition_c_0206, .kde = &lxb_unicode_decomposition_k_0206};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0207[2] = {0x0065, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0207 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0207, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0207[2] = {0x0065, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0207 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0207, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0207[2] = {0x0065, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0207 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0207, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0207 = {.cp = 0x0207, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0207, .cde = &lxb_unicode_decomposition_c_0207, .kde = &lxb_unicode_decomposition_k_0207};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0208[2] = {0x0049, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0208 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0208, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0208[2] = {0x0049, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0208 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0208, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0208[2] = {0x0049, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0208 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0208, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0208 = {.cp = 0x0208, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0208, .cde = &lxb_unicode_decomposition_c_0208, .kde = &lxb_unicode_decomposition_k_0208};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0209[2] = {0x0069, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0209 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0209, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0209[2] = {0x0069, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0209 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0209, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0209[2] = {0x0069, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0209 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0209, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0209 = {.cp = 0x0209, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0209, .cde = &lxb_unicode_decomposition_c_0209, .kde = &lxb_unicode_decomposition_k_0209};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_020A[2] = {0x0049, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_020A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_020A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_020A[2] = {0x0049, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_020A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_020A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__020A[2] = {0x0049, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__020A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__020A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_020A = {.cp = 0x020A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__020A, .cde = &lxb_unicode_decomposition_c_020A, .kde = &lxb_unicode_decomposition_k_020A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_020B[2] = {0x0069, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_020B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_020B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_020B[2] = {0x0069, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_020B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_020B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__020B[2] = {0x0069, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__020B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__020B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_020B = {.cp = 0x020B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__020B, .cde = &lxb_unicode_decomposition_c_020B, .kde = &lxb_unicode_decomposition_k_020B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_020C[2] = {0x004F, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_020C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_020C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_020C[2] = {0x004F, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_020C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_020C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__020C[2] = {0x004F, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__020C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__020C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_020C = {.cp = 0x020C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__020C, .cde = &lxb_unicode_decomposition_c_020C, .kde = &lxb_unicode_decomposition_k_020C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_020D[2] = {0x006F, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_020D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_020D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_020D[2] = {0x006F, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_020D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_020D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__020D[2] = {0x006F, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__020D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__020D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_020D = {.cp = 0x020D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__020D, .cde = &lxb_unicode_decomposition_c_020D, .kde = &lxb_unicode_decomposition_k_020D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_020E[2] = {0x004F, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_020E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_020E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_020E[2] = {0x004F, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_020E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_020E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__020E[2] = {0x004F, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__020E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__020E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_020E = {.cp = 0x020E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__020E, .cde = &lxb_unicode_decomposition_c_020E, .kde = &lxb_unicode_decomposition_k_020E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_020F[2] = {0x006F, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_020F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_020F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_020F[2] = {0x006F, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_020F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_020F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__020F[2] = {0x006F, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__020F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__020F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_020F = {.cp = 0x020F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__020F, .cde = &lxb_unicode_decomposition_c_020F, .kde = &lxb_unicode_decomposition_k_020F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0210[2] = {0x0052, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0210 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0210, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0210[2] = {0x0052, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0210 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0210, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0210[2] = {0x0052, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0210 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0210, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0210 = {.cp = 0x0210, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0210, .cde = &lxb_unicode_decomposition_c_0210, .kde = &lxb_unicode_decomposition_k_0210};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0211[2] = {0x0072, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0211 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0211, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0211[2] = {0x0072, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0211 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0211, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0211[2] = {0x0072, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0211 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0211, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0211 = {.cp = 0x0211, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0211, .cde = &lxb_unicode_decomposition_c_0211, .kde = &lxb_unicode_decomposition_k_0211};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0212[2] = {0x0052, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0212 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0212, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0212[2] = {0x0052, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0212 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0212, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0212[2] = {0x0052, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0212 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0212, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0212 = {.cp = 0x0212, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0212, .cde = &lxb_unicode_decomposition_c_0212, .kde = &lxb_unicode_decomposition_k_0212};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0213[2] = {0x0072, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0213 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0213, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0213[2] = {0x0072, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0213 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0213, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0213[2] = {0x0072, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0213 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0213, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0213 = {.cp = 0x0213, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0213, .cde = &lxb_unicode_decomposition_c_0213, .kde = &lxb_unicode_decomposition_k_0213};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0214[2] = {0x0055, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0214 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0214, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0214[2] = {0x0055, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0214 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0214, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0214[2] = {0x0055, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0214 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0214, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0214 = {.cp = 0x0214, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0214, .cde = &lxb_unicode_decomposition_c_0214, .kde = &lxb_unicode_decomposition_k_0214};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0215[2] = {0x0075, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0215 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0215, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0215[2] = {0x0075, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0215 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0215, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0215[2] = {0x0075, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0215 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0215, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0215 = {.cp = 0x0215, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0215, .cde = &lxb_unicode_decomposition_c_0215, .kde = &lxb_unicode_decomposition_k_0215};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0216[2] = {0x0055, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0216 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0216, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0216[2] = {0x0055, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0216 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0216, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0216[2] = {0x0055, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0216 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0216, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0216 = {.cp = 0x0216, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0216, .cde = &lxb_unicode_decomposition_c_0216, .kde = &lxb_unicode_decomposition_k_0216};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0217[2] = {0x0075, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0217 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0217, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0217[2] = {0x0075, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0217 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0217, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0217[2] = {0x0075, 0x0311};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0217 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0217, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0217 = {.cp = 0x0217, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0217, .cde = &lxb_unicode_decomposition_c_0217, .kde = &lxb_unicode_decomposition_k_0217};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0218[2] = {0x0053, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0218 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0218, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0218[2] = {0x0053, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0218 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0218, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0218[2] = {0x0053, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0218 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0218, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0218 = {.cp = 0x0218, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0218, .cde = &lxb_unicode_decomposition_c_0218, .kde = &lxb_unicode_decomposition_k_0218};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0219[2] = {0x0073, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0219 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0219, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0219[2] = {0x0073, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0219 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0219, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0219[2] = {0x0073, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0219 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0219, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0219 = {.cp = 0x0219, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0219, .cde = &lxb_unicode_decomposition_c_0219, .kde = &lxb_unicode_decomposition_k_0219};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_021A[2] = {0x0054, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_021A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_021A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_021A[2] = {0x0054, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_021A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_021A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__021A[2] = {0x0054, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__021A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__021A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_021A = {.cp = 0x021A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__021A, .cde = &lxb_unicode_decomposition_c_021A, .kde = &lxb_unicode_decomposition_k_021A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_021B[2] = {0x0074, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_021B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_021B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_021B[2] = {0x0074, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_021B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_021B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__021B[2] = {0x0074, 0x0326};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__021B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__021B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_021B = {.cp = 0x021B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__021B, .cde = &lxb_unicode_decomposition_c_021B, .kde = &lxb_unicode_decomposition_k_021B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_021E[2] = {0x0048, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_021E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_021E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_021E[2] = {0x0048, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_021E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_021E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__021E[2] = {0x0048, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__021E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__021E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_021E = {.cp = 0x021E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__021E, .cde = &lxb_unicode_decomposition_c_021E, .kde = &lxb_unicode_decomposition_k_021E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_021F[2] = {0x0068, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_021F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_021F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_021F[2] = {0x0068, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_021F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_021F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__021F[2] = {0x0068, 0x030C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__021F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__021F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_021F = {.cp = 0x021F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__021F, .cde = &lxb_unicode_decomposition_c_021F, .kde = &lxb_unicode_decomposition_k_021F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0226[2] = {0x0041, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0226 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0226, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0226[2] = {0x0041, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0226 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0226, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0226[2] = {0x0041, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0226 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0226, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0226 = {.cp = 0x0226, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0226, .cde = &lxb_unicode_decomposition_c_0226, .kde = &lxb_unicode_decomposition_k_0226};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0227[2] = {0x0061, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0227 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0227, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0227[2] = {0x0061, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0227 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0227, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0227[2] = {0x0061, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0227 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0227, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0227 = {.cp = 0x0227, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0227, .cde = &lxb_unicode_decomposition_c_0227, .kde = &lxb_unicode_decomposition_k_0227};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0228[2] = {0x0045, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0228 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0228, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0228[2] = {0x0045, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0228 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0228, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0228[2] = {0x0045, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0228 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0228, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0228 = {.cp = 0x0228, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0228, .cde = &lxb_unicode_decomposition_c_0228, .kde = &lxb_unicode_decomposition_k_0228};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0229[2] = {0x0065, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0229 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0229, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0229[2] = {0x0065, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0229 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0229, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0229[2] = {0x0065, 0x0327};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0229 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0229, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0229 = {.cp = 0x0229, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0229, .cde = &lxb_unicode_decomposition_c_0229, .kde = &lxb_unicode_decomposition_k_0229};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_022A[3] = {0x004F, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_022A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_022A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_022A[3] = {0x004F, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_022A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_022A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__022A[2] = {0x00D6, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__022A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__022A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_022A = {.cp = 0x022A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__022A, .cde = &lxb_unicode_decomposition_c_022A, .kde = &lxb_unicode_decomposition_k_022A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_022B[3] = {0x006F, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_022B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_022B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_022B[3] = {0x006F, 0x0308, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_022B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_022B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__022B[2] = {0x00F6, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__022B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__022B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_022B = {.cp = 0x022B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__022B, .cde = &lxb_unicode_decomposition_c_022B, .kde = &lxb_unicode_decomposition_k_022B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_022C[3] = {0x004F, 0x0303, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_022C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_022C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_022C[3] = {0x004F, 0x0303, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_022C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_022C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__022C[2] = {0x00D5, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__022C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__022C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_022C = {.cp = 0x022C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__022C, .cde = &lxb_unicode_decomposition_c_022C, .kde = &lxb_unicode_decomposition_k_022C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_022D[3] = {0x006F, 0x0303, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_022D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_022D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_022D[3] = {0x006F, 0x0303, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_022D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_022D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__022D[2] = {0x00F5, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__022D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__022D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_022D = {.cp = 0x022D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__022D, .cde = &lxb_unicode_decomposition_c_022D, .kde = &lxb_unicode_decomposition_k_022D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_022E[2] = {0x004F, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_022E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_022E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_022E[2] = {0x004F, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_022E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_022E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__022E[2] = {0x004F, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__022E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__022E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_022E = {.cp = 0x022E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__022E, .cde = &lxb_unicode_decomposition_c_022E, .kde = &lxb_unicode_decomposition_k_022E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_022F[2] = {0x006F, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_022F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_022F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_022F[2] = {0x006F, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_022F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_022F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__022F[2] = {0x006F, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__022F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__022F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_022F = {.cp = 0x022F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__022F, .cde = &lxb_unicode_decomposition_c_022F, .kde = &lxb_unicode_decomposition_k_022F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0230[3] = {0x004F, 0x0307, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0230 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0230, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0230[3] = {0x004F, 0x0307, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0230 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0230, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0230[2] = {0x022E, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0230 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0230, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0230 = {.cp = 0x0230, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0230, .cde = &lxb_unicode_decomposition_c_0230, .kde = &lxb_unicode_decomposition_k_0230};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0231[3] = {0x006F, 0x0307, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0231 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0231, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0231[3] = {0x006F, 0x0307, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0231 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0231, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0231[2] = {0x022F, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0231 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0231, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0231 = {.cp = 0x0231, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0231, .cde = &lxb_unicode_decomposition_c_0231, .kde = &lxb_unicode_decomposition_k_0231};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0232[2] = {0x0059, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0232 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0232, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0232[2] = {0x0059, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0232 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0232, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0232[2] = {0x0059, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0232 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0232, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0232 = {.cp = 0x0232, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0232, .cde = &lxb_unicode_decomposition_c_0232, .kde = &lxb_unicode_decomposition_k_0232};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0233[2] = {0x0079, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0233 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0233, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0233[2] = {0x0079, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0233 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0233, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0233[2] = {0x0079, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0233 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0233, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0233 = {.cp = 0x0233, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0233, .cde = &lxb_unicode_decomposition_c_0233, .kde = &lxb_unicode_decomposition_k_0233};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02B0[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02B0[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02B0[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02B0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02B0 = {.cp = 0x02B0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02B0, .cde = &lxb_unicode_decomposition_c_02B0, .kde = &lxb_unicode_decomposition_k_02B0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02B1[1] = {0x0266};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02B1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02B1[1] = {0x0266};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02B1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02B1[1] = {0x0266};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02B1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02B1 = {.cp = 0x02B1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02B1, .cde = &lxb_unicode_decomposition_c_02B1, .kde = &lxb_unicode_decomposition_k_02B1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02B2[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02B2[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02B2[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02B2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02B2 = {.cp = 0x02B2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02B2, .cde = &lxb_unicode_decomposition_c_02B2, .kde = &lxb_unicode_decomposition_k_02B2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02B3[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02B3[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02B3[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02B3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02B3 = {.cp = 0x02B3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02B3, .cde = &lxb_unicode_decomposition_c_02B3, .kde = &lxb_unicode_decomposition_k_02B3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02B4[1] = {0x0279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02B4[1] = {0x0279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02B4[1] = {0x0279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02B4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02B4 = {.cp = 0x02B4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02B4, .cde = &lxb_unicode_decomposition_c_02B4, .kde = &lxb_unicode_decomposition_k_02B4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02B5[1] = {0x027B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02B5[1] = {0x027B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02B5[1] = {0x027B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02B5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02B5 = {.cp = 0x02B5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02B5, .cde = &lxb_unicode_decomposition_c_02B5, .kde = &lxb_unicode_decomposition_k_02B5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02B6[1] = {0x0281};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02B6[1] = {0x0281};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02B6[1] = {0x0281};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02B6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02B6 = {.cp = 0x02B6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02B6, .cde = &lxb_unicode_decomposition_c_02B6, .kde = &lxb_unicode_decomposition_k_02B6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02B7[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02B7[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02B7[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02B7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02B7 = {.cp = 0x02B7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02B7, .cde = &lxb_unicode_decomposition_c_02B7, .kde = &lxb_unicode_decomposition_k_02B7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02B8[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02B8[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02B8[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02B8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02B8 = {.cp = 0x02B8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02B8, .cde = &lxb_unicode_decomposition_c_02B8, .kde = &lxb_unicode_decomposition_k_02B8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02D8[2] = {0x0020, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_02D8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02D8[2] = {0x0020, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_02D8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02D8[2] = {0x0020, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__02D8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_02D8 = {.cp = 0x02D8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02D8, .cde = &lxb_unicode_decomposition_c_02D8, .kde = &lxb_unicode_decomposition_k_02D8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02D9[2] = {0x0020, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_02D9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02D9[2] = {0x0020, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_02D9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02D9[2] = {0x0020, 0x0307};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__02D9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_02D9 = {.cp = 0x02D9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02D9, .cde = &lxb_unicode_decomposition_c_02D9, .kde = &lxb_unicode_decomposition_k_02D9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02DA[2] = {0x0020, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_02DA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02DA[2] = {0x0020, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_02DA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02DA[2] = {0x0020, 0x030A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__02DA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_02DA = {.cp = 0x02DA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02DA, .cde = &lxb_unicode_decomposition_c_02DA, .kde = &lxb_unicode_decomposition_k_02DA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02DB[2] = {0x0020, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_02DB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02DB[2] = {0x0020, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_02DB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02DB[2] = {0x0020, 0x0328};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__02DB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_02DB = {.cp = 0x02DB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02DB, .cde = &lxb_unicode_decomposition_c_02DB, .kde = &lxb_unicode_decomposition_k_02DB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02DC[2] = {0x0020, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_02DC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02DC[2] = {0x0020, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_02DC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02DC[2] = {0x0020, 0x0303};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__02DC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_02DC = {.cp = 0x02DC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02DC, .cde = &lxb_unicode_decomposition_c_02DC, .kde = &lxb_unicode_decomposition_k_02DC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02DD[2] = {0x0020, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_02DD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02DD[2] = {0x0020, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_02DD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02DD[2] = {0x0020, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__02DD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_02DD = {.cp = 0x02DD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02DD, .cde = &lxb_unicode_decomposition_c_02DD, .kde = &lxb_unicode_decomposition_k_02DD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02E0[1] = {0x0263};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02E0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02E0[1] = {0x0263};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02E0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02E0[1] = {0x0263};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02E0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02E0 = {.cp = 0x02E0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02E0, .cde = &lxb_unicode_decomposition_c_02E0, .kde = &lxb_unicode_decomposition_k_02E0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02E1[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02E1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02E1[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02E1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02E1[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02E1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02E1 = {.cp = 0x02E1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02E1, .cde = &lxb_unicode_decomposition_c_02E1, .kde = &lxb_unicode_decomposition_k_02E1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02E2[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02E2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02E2[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02E2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02E2[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02E2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02E2 = {.cp = 0x02E2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02E2, .cde = &lxb_unicode_decomposition_c_02E2, .kde = &lxb_unicode_decomposition_k_02E2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02E3[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02E3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02E3[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02E3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02E3[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02E3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02E3 = {.cp = 0x02E3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02E3, .cde = &lxb_unicode_decomposition_c_02E3, .kde = &lxb_unicode_decomposition_k_02E3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_02E4[1] = {0x0295};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_02E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_02E4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_02E4[1] = {0x0295};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_02E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_02E4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__02E4[1] = {0x0295};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__02E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__02E4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_02E4 = {.cp = 0x02E4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__02E4, .cde = &lxb_unicode_decomposition_c_02E4, .kde = &lxb_unicode_decomposition_k_02E4};

static const lxb_unicode_entry_t lxb_unicode_entry_0300 = {.cp = 0x0300, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0301 = {.cp = 0x0301, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0302 = {.cp = 0x0302, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0303 = {.cp = 0x0303, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0304 = {.cp = 0x0304, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0305 = {.cp = 0x0305, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0306 = {.cp = 0x0306, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0307 = {.cp = 0x0307, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0308 = {.cp = 0x0308, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0309 = {.cp = 0x0309, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_030A = {.cp = 0x030A, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_030B = {.cp = 0x030B, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_030C = {.cp = 0x030C, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_030D = {.cp = 0x030D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_030E = {.cp = 0x030E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_030F = {.cp = 0x030F, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0310 = {.cp = 0x0310, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0311 = {.cp = 0x0311, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0312 = {.cp = 0x0312, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0313 = {.cp = 0x0313, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0314 = {.cp = 0x0314, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0315 = {.cp = 0x0315, .ccc = 232, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0316 = {.cp = 0x0316, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0317 = {.cp = 0x0317, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0318 = {.cp = 0x0318, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0319 = {.cp = 0x0319, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_031A = {.cp = 0x031A, .ccc = 232, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_031B = {.cp = 0x031B, .ccc = 216, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_031C = {.cp = 0x031C, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_031D = {.cp = 0x031D, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_031E = {.cp = 0x031E, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_031F = {.cp = 0x031F, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0320 = {.cp = 0x0320, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0321 = {.cp = 0x0321, .ccc = 202, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0322 = {.cp = 0x0322, .ccc = 202, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0323 = {.cp = 0x0323, .ccc = 220, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0324 = {.cp = 0x0324, .ccc = 220, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0325 = {.cp = 0x0325, .ccc = 220, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0326 = {.cp = 0x0326, .ccc = 220, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0327 = {.cp = 0x0327, .ccc = 202, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0328 = {.cp = 0x0328, .ccc = 202, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0329 = {.cp = 0x0329, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_032A = {.cp = 0x032A, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_032B = {.cp = 0x032B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_032C = {.cp = 0x032C, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_032D = {.cp = 0x032D, .ccc = 220, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_032E = {.cp = 0x032E, .ccc = 220, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_032F = {.cp = 0x032F, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0330 = {.cp = 0x0330, .ccc = 220, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0331 = {.cp = 0x0331, .ccc = 220, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0332 = {.cp = 0x0332, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0333 = {.cp = 0x0333, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0334 = {.cp = 0x0334, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0335 = {.cp = 0x0335, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0336 = {.cp = 0x0336, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0337 = {.cp = 0x0337, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0338 = {.cp = 0x0338, .ccc = 1, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0339 = {.cp = 0x0339, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_033A = {.cp = 0x033A, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_033B = {.cp = 0x033B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_033C = {.cp = 0x033C, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_033D = {.cp = 0x033D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_033E = {.cp = 0x033E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_033F = {.cp = 0x033F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0340[1] = {0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0340 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0340, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0340[1] = {0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0340 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0340, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0340[1] = {0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0340 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0340, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_0340 = {.cp = 0x0340, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0340, .cde = &lxb_unicode_decomposition_c_0340, .kde = &lxb_unicode_decomposition_k_0340};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0341[1] = {0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0341 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0341, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0341[1] = {0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0341 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0341, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0341[1] = {0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0341 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0341, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_0341 = {.cp = 0x0341, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0341, .cde = &lxb_unicode_decomposition_c_0341, .kde = &lxb_unicode_decomposition_k_0341};

static const lxb_unicode_entry_t lxb_unicode_entry_0342 = {.cp = 0x0342, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0343[1] = {0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0343 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0343, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0343[1] = {0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0343 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0343, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0343[1] = {0x0313};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0343 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0343, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_0343 = {.cp = 0x0343, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0343, .cde = &lxb_unicode_decomposition_c_0343, .kde = &lxb_unicode_decomposition_k_0343};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0344[2] = {0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0344 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0344, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0344[2] = {0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0344 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0344, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0344[2] = {0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0344 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0344, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0344 = {.cp = 0x0344, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0344, .cde = &lxb_unicode_decomposition_c_0344, .kde = &lxb_unicode_decomposition_k_0344};

static const lxb_unicode_entry_t lxb_unicode_entry_0345 = {.cp = 0x0345, .ccc = 240, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0346 = {.cp = 0x0346, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0347 = {.cp = 0x0347, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0348 = {.cp = 0x0348, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0349 = {.cp = 0x0349, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_034A = {.cp = 0x034A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_034B = {.cp = 0x034B, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_034C = {.cp = 0x034C, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_034D = {.cp = 0x034D, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_034E = {.cp = 0x034E, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0350 = {.cp = 0x0350, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0351 = {.cp = 0x0351, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0352 = {.cp = 0x0352, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0353 = {.cp = 0x0353, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0354 = {.cp = 0x0354, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0355 = {.cp = 0x0355, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0356 = {.cp = 0x0356, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0357 = {.cp = 0x0357, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0358 = {.cp = 0x0358, .ccc = 232, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0359 = {.cp = 0x0359, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_035A = {.cp = 0x035A, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_035B = {.cp = 0x035B, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_035C = {.cp = 0x035C, .ccc = 233, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_035D = {.cp = 0x035D, .ccc = 234, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_035E = {.cp = 0x035E, .ccc = 234, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_035F = {.cp = 0x035F, .ccc = 233, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0360 = {.cp = 0x0360, .ccc = 234, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0361 = {.cp = 0x0361, .ccc = 234, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0362 = {.cp = 0x0362, .ccc = 233, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0363 = {.cp = 0x0363, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0364 = {.cp = 0x0364, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0365 = {.cp = 0x0365, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0366 = {.cp = 0x0366, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0367 = {.cp = 0x0367, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0368 = {.cp = 0x0368, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0369 = {.cp = 0x0369, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_036A = {.cp = 0x036A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_036B = {.cp = 0x036B, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_036C = {.cp = 0x036C, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_036D = {.cp = 0x036D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_036E = {.cp = 0x036E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_036F = {.cp = 0x036F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0374[1] = {0x02B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0374 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0374, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0374[1] = {0x02B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0374 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0374, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0374[1] = {0x02B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0374 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0374, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_0374 = {.cp = 0x0374, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0374, .cde = &lxb_unicode_decomposition_c_0374, .kde = &lxb_unicode_decomposition_k_0374};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_037A[2] = {0x0020, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_037A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_037A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_037A[2] = {0x0020, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_037A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_037A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__037A[2] = {0x0020, 0x0345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__037A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__037A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_037A = {.cp = 0x037A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__037A, .cde = &lxb_unicode_decomposition_c_037A, .kde = &lxb_unicode_decomposition_k_037A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_037E[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_037E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_037E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_037E[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_037E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_037E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__037E[1] = {0x003B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__037E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__037E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_037E = {.cp = 0x037E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__037E, .cde = &lxb_unicode_decomposition_c_037E, .kde = &lxb_unicode_decomposition_k_037E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0384[2] = {0x0020, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0384 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0384, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0384[2] = {0x0020, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0384 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0384, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0384[2] = {0x0020, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0384 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0384, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0384 = {.cp = 0x0384, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0384, .cde = &lxb_unicode_decomposition_c_0384, .kde = &lxb_unicode_decomposition_k_0384};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0385[2] = {0x00A8, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0385 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0385, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0385[3] = {0x0020, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0385 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0385, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0385[2] = {0x00A8, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0385 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0385, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0385 = {.cp = 0x0385, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0385, .cde = &lxb_unicode_decomposition_c_0385, .kde = &lxb_unicode_decomposition_k_0385};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0386[2] = {0x0391, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0386 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0386, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0386[2] = {0x0391, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0386 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0386, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0386[2] = {0x0391, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0386 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0386, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0386 = {.cp = 0x0386, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0386, .cde = &lxb_unicode_decomposition_c_0386, .kde = &lxb_unicode_decomposition_k_0386};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0387[1] = {0x00B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0387 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0387, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0387[1] = {0x00B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0387 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0387, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0387[1] = {0x00B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0387 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0387, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_0387 = {.cp = 0x0387, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0387, .cde = &lxb_unicode_decomposition_c_0387, .kde = &lxb_unicode_decomposition_k_0387};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0388[2] = {0x0395, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0388 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0388, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0388[2] = {0x0395, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0388 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0388, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0388[2] = {0x0395, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0388 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0388, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0388 = {.cp = 0x0388, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0388, .cde = &lxb_unicode_decomposition_c_0388, .kde = &lxb_unicode_decomposition_k_0388};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0389[2] = {0x0397, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0389 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0389, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0389[2] = {0x0397, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0389 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0389, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0389[2] = {0x0397, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0389 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0389, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0389 = {.cp = 0x0389, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0389, .cde = &lxb_unicode_decomposition_c_0389, .kde = &lxb_unicode_decomposition_k_0389};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_038A[2] = {0x0399, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_038A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_038A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_038A[2] = {0x0399, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_038A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_038A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__038A[2] = {0x0399, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__038A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__038A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_038A = {.cp = 0x038A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__038A, .cde = &lxb_unicode_decomposition_c_038A, .kde = &lxb_unicode_decomposition_k_038A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_038C[2] = {0x039F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_038C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_038C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_038C[2] = {0x039F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_038C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_038C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__038C[2] = {0x039F, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__038C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__038C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_038C = {.cp = 0x038C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__038C, .cde = &lxb_unicode_decomposition_c_038C, .kde = &lxb_unicode_decomposition_k_038C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_038E[2] = {0x03A5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_038E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_038E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_038E[2] = {0x03A5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_038E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_038E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__038E[2] = {0x03A5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__038E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__038E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_038E = {.cp = 0x038E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__038E, .cde = &lxb_unicode_decomposition_c_038E, .kde = &lxb_unicode_decomposition_k_038E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_038F[2] = {0x03A9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_038F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_038F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_038F[2] = {0x03A9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_038F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_038F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__038F[2] = {0x03A9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__038F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__038F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_038F = {.cp = 0x038F, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__038F, .cde = &lxb_unicode_decomposition_c_038F, .kde = &lxb_unicode_decomposition_k_038F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0390[3] = {0x03B9, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0390 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0390, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0390[3] = {0x03B9, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0390 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0390, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0390[2] = {0x03CA, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0390 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0390, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0390 = {.cp = 0x0390, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0390, .cde = &lxb_unicode_decomposition_c_0390, .kde = &lxb_unicode_decomposition_k_0390};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03AA[2] = {0x0399, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03AA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03AA[2] = {0x0399, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03AA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03AA[2] = {0x0399, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03AA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03AA = {.cp = 0x03AA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03AA, .cde = &lxb_unicode_decomposition_c_03AA, .kde = &lxb_unicode_decomposition_k_03AA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03AB[2] = {0x03A5, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03AB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03AB[2] = {0x03A5, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03AB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03AB[2] = {0x03A5, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03AB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03AB = {.cp = 0x03AB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03AB, .cde = &lxb_unicode_decomposition_c_03AB, .kde = &lxb_unicode_decomposition_k_03AB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03AC[2] = {0x03B1, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03AC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03AC[2] = {0x03B1, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03AC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03AC[2] = {0x03B1, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03AC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03AC = {.cp = 0x03AC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03AC, .cde = &lxb_unicode_decomposition_c_03AC, .kde = &lxb_unicode_decomposition_k_03AC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03AD[2] = {0x03B5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03AD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03AD[2] = {0x03B5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03AD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03AD[2] = {0x03B5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03AD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03AD = {.cp = 0x03AD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03AD, .cde = &lxb_unicode_decomposition_c_03AD, .kde = &lxb_unicode_decomposition_k_03AD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03AE[2] = {0x03B7, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03AE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03AE[2] = {0x03B7, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03AE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03AE[2] = {0x03B7, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03AE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03AE = {.cp = 0x03AE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03AE, .cde = &lxb_unicode_decomposition_c_03AE, .kde = &lxb_unicode_decomposition_k_03AE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03AF[2] = {0x03B9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03AF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03AF[2] = {0x03B9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03AF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03AF[2] = {0x03B9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03AF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03AF = {.cp = 0x03AF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03AF, .cde = &lxb_unicode_decomposition_c_03AF, .kde = &lxb_unicode_decomposition_k_03AF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03B0[3] = {0x03C5, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03B0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03B0[3] = {0x03C5, 0x0308, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03B0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03B0[2] = {0x03CB, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03B0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03B0 = {.cp = 0x03B0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03B0, .cde = &lxb_unicode_decomposition_c_03B0, .kde = &lxb_unicode_decomposition_k_03B0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03CA[2] = {0x03B9, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03CA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03CA[2] = {0x03B9, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03CA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03CA[2] = {0x03B9, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03CA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03CA = {.cp = 0x03CA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03CA, .cde = &lxb_unicode_decomposition_c_03CA, .kde = &lxb_unicode_decomposition_k_03CA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03CB[2] = {0x03C5, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03CB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03CB[2] = {0x03C5, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03CB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03CB[2] = {0x03C5, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03CB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03CB = {.cp = 0x03CB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03CB, .cde = &lxb_unicode_decomposition_c_03CB, .kde = &lxb_unicode_decomposition_k_03CB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03CC[2] = {0x03BF, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03CC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03CC[2] = {0x03BF, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03CC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03CC[2] = {0x03BF, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03CC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03CC = {.cp = 0x03CC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03CC, .cde = &lxb_unicode_decomposition_c_03CC, .kde = &lxb_unicode_decomposition_k_03CC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03CD[2] = {0x03C5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03CD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03CD[2] = {0x03C5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03CD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03CD[2] = {0x03C5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03CD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03CD = {.cp = 0x03CD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03CD, .cde = &lxb_unicode_decomposition_c_03CD, .kde = &lxb_unicode_decomposition_k_03CD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03CE[2] = {0x03C9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03CE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03CE[2] = {0x03C9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03CE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03CE[2] = {0x03C9, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03CE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03CE = {.cp = 0x03CE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03CE, .cde = &lxb_unicode_decomposition_c_03CE, .kde = &lxb_unicode_decomposition_k_03CE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03D0[1] = {0x03B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03D0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03D0[1] = {0x03B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03D0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03D0[1] = {0x03B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03D0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03D0 = {.cp = 0x03D0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03D0, .cde = &lxb_unicode_decomposition_c_03D0, .kde = &lxb_unicode_decomposition_k_03D0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03D1[1] = {0x03B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03D1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03D1[1] = {0x03B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03D1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03D1[1] = {0x03B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03D1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03D1 = {.cp = 0x03D1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03D1, .cde = &lxb_unicode_decomposition_c_03D1, .kde = &lxb_unicode_decomposition_k_03D1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03D2[1] = {0x03A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03D2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03D2[1] = {0x03A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03D2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03D2[1] = {0x03A5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03D2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03D2 = {.cp = 0x03D2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03D2, .cde = &lxb_unicode_decomposition_c_03D2, .kde = &lxb_unicode_decomposition_k_03D2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03D3[2] = {0x03D2, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03D3[2] = {0x03A5, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03D3[2] = {0x03D2, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03D3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03D3 = {.cp = 0x03D3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03D3, .cde = &lxb_unicode_decomposition_c_03D3, .kde = &lxb_unicode_decomposition_k_03D3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03D4[2] = {0x03D2, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_03D4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03D4[2] = {0x03A5, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_03D4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03D4[2] = {0x03D2, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__03D4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_03D4 = {.cp = 0x03D4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03D4, .cde = &lxb_unicode_decomposition_c_03D4, .kde = &lxb_unicode_decomposition_k_03D4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03D5[1] = {0x03C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03D5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03D5[1] = {0x03C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03D5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03D5[1] = {0x03C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03D5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03D5 = {.cp = 0x03D5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03D5, .cde = &lxb_unicode_decomposition_c_03D5, .kde = &lxb_unicode_decomposition_k_03D5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03D6[1] = {0x03C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03D6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03D6[1] = {0x03C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03D6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03D6[1] = {0x03C0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03D6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03D6 = {.cp = 0x03D6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03D6, .cde = &lxb_unicode_decomposition_c_03D6, .kde = &lxb_unicode_decomposition_k_03D6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03F0[1] = {0x03BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03F0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03F0[1] = {0x03BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03F0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03F0[1] = {0x03BA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03F0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03F0 = {.cp = 0x03F0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03F0, .cde = &lxb_unicode_decomposition_c_03F0, .kde = &lxb_unicode_decomposition_k_03F0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03F1[1] = {0x03C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03F1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03F1[1] = {0x03C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03F1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03F1[1] = {0x03C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03F1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03F1 = {.cp = 0x03F1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03F1, .cde = &lxb_unicode_decomposition_c_03F1, .kde = &lxb_unicode_decomposition_k_03F1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03F2[1] = {0x03C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03F2[1] = {0x03C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03F2[1] = {0x03C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03F2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03F2 = {.cp = 0x03F2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03F2, .cde = &lxb_unicode_decomposition_c_03F2, .kde = &lxb_unicode_decomposition_k_03F2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03F4[1] = {0x0398};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03F4[1] = {0x0398};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03F4[1] = {0x0398};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03F4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03F4 = {.cp = 0x03F4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03F4, .cde = &lxb_unicode_decomposition_c_03F4, .kde = &lxb_unicode_decomposition_k_03F4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03F5[1] = {0x03B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03F5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03F5[1] = {0x03B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03F5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03F5[1] = {0x03B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03F5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03F5 = {.cp = 0x03F5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03F5, .cde = &lxb_unicode_decomposition_c_03F5, .kde = &lxb_unicode_decomposition_k_03F5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_03F9[1] = {0x03A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_03F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_03F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_03F9[1] = {0x03A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_03F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_03F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__03F9[1] = {0x03A3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__03F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__03F9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_03F9 = {.cp = 0x03F9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__03F9, .cde = &lxb_unicode_decomposition_c_03F9, .kde = &lxb_unicode_decomposition_k_03F9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0400[2] = {0x0415, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0400 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0400, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0400[2] = {0x0415, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0400 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0400, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0400[2] = {0x0415, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0400 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0400, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0400 = {.cp = 0x0400, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0400, .cde = &lxb_unicode_decomposition_c_0400, .kde = &lxb_unicode_decomposition_k_0400};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0401[2] = {0x0415, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0401 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0401, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0401[2] = {0x0415, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0401 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0401, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0401[2] = {0x0415, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0401 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0401, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0401 = {.cp = 0x0401, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0401, .cde = &lxb_unicode_decomposition_c_0401, .kde = &lxb_unicode_decomposition_k_0401};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0403[2] = {0x0413, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0403 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0403, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0403[2] = {0x0413, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0403 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0403, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0403[2] = {0x0413, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0403 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0403, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0403 = {.cp = 0x0403, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0403, .cde = &lxb_unicode_decomposition_c_0403, .kde = &lxb_unicode_decomposition_k_0403};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0407[2] = {0x0406, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0407 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0407, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0407[2] = {0x0406, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0407 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0407, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0407[2] = {0x0406, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0407 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0407, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0407 = {.cp = 0x0407, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0407, .cde = &lxb_unicode_decomposition_c_0407, .kde = &lxb_unicode_decomposition_k_0407};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_040C[2] = {0x041A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_040C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_040C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_040C[2] = {0x041A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_040C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_040C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__040C[2] = {0x041A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__040C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__040C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_040C = {.cp = 0x040C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__040C, .cde = &lxb_unicode_decomposition_c_040C, .kde = &lxb_unicode_decomposition_k_040C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_040D[2] = {0x0418, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_040D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_040D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_040D[2] = {0x0418, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_040D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_040D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__040D[2] = {0x0418, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__040D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__040D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_040D = {.cp = 0x040D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__040D, .cde = &lxb_unicode_decomposition_c_040D, .kde = &lxb_unicode_decomposition_k_040D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_040E[2] = {0x0423, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_040E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_040E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_040E[2] = {0x0423, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_040E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_040E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__040E[2] = {0x0423, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__040E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__040E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_040E = {.cp = 0x040E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__040E, .cde = &lxb_unicode_decomposition_c_040E, .kde = &lxb_unicode_decomposition_k_040E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0419[2] = {0x0418, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0419 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0419, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0419[2] = {0x0418, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0419 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0419, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0419[2] = {0x0418, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0419 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0419, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0419 = {.cp = 0x0419, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0419, .cde = &lxb_unicode_decomposition_c_0419, .kde = &lxb_unicode_decomposition_k_0419};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0439[2] = {0x0438, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0439 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0439, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0439[2] = {0x0438, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0439 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0439, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0439[2] = {0x0438, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0439 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0439, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0439 = {.cp = 0x0439, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0439, .cde = &lxb_unicode_decomposition_c_0439, .kde = &lxb_unicode_decomposition_k_0439};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0450[2] = {0x0435, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0450 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0450, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0450[2] = {0x0435, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0450 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0450, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0450[2] = {0x0435, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0450 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0450, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0450 = {.cp = 0x0450, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0450, .cde = &lxb_unicode_decomposition_c_0450, .kde = &lxb_unicode_decomposition_k_0450};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0451[2] = {0x0435, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0451 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0451, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0451[2] = {0x0435, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0451 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0451, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0451[2] = {0x0435, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0451 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0451, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0451 = {.cp = 0x0451, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0451, .cde = &lxb_unicode_decomposition_c_0451, .kde = &lxb_unicode_decomposition_k_0451};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0453[2] = {0x0433, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0453 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0453, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0453[2] = {0x0433, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0453 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0453, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0453[2] = {0x0433, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0453 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0453, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0453 = {.cp = 0x0453, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0453, .cde = &lxb_unicode_decomposition_c_0453, .kde = &lxb_unicode_decomposition_k_0453};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0457[2] = {0x0456, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0457 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0457, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0457[2] = {0x0456, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0457 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0457, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0457[2] = {0x0456, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0457 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0457, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0457 = {.cp = 0x0457, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0457, .cde = &lxb_unicode_decomposition_c_0457, .kde = &lxb_unicode_decomposition_k_0457};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_045C[2] = {0x043A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_045C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_045C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_045C[2] = {0x043A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_045C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_045C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__045C[2] = {0x043A, 0x0301};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__045C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__045C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_045C = {.cp = 0x045C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__045C, .cde = &lxb_unicode_decomposition_c_045C, .kde = &lxb_unicode_decomposition_k_045C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_045D[2] = {0x0438, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_045D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_045D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_045D[2] = {0x0438, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_045D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_045D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__045D[2] = {0x0438, 0x0300};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__045D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__045D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_045D = {.cp = 0x045D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__045D, .cde = &lxb_unicode_decomposition_c_045D, .kde = &lxb_unicode_decomposition_k_045D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_045E[2] = {0x0443, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_045E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_045E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_045E[2] = {0x0443, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_045E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_045E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__045E[2] = {0x0443, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__045E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__045E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_045E = {.cp = 0x045E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__045E, .cde = &lxb_unicode_decomposition_c_045E, .kde = &lxb_unicode_decomposition_k_045E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0476[2] = {0x0474, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0476 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0476, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0476[2] = {0x0474, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0476 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0476, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0476[2] = {0x0474, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0476 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0476, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0476 = {.cp = 0x0476, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0476, .cde = &lxb_unicode_decomposition_c_0476, .kde = &lxb_unicode_decomposition_k_0476};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0477[2] = {0x0475, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0477 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0477, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0477[2] = {0x0475, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0477 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0477, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0477[2] = {0x0475, 0x030F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0477 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0477, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0477 = {.cp = 0x0477, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0477, .cde = &lxb_unicode_decomposition_c_0477, .kde = &lxb_unicode_decomposition_k_0477};

static const lxb_unicode_entry_t lxb_unicode_entry_0483 = {.cp = 0x0483, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0484 = {.cp = 0x0484, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0485 = {.cp = 0x0485, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0486 = {.cp = 0x0486, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0487 = {.cp = 0x0487, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04C1[2] = {0x0416, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04C1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04C1[2] = {0x0416, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04C1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04C1[2] = {0x0416, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04C1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04C1 = {.cp = 0x04C1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04C1, .cde = &lxb_unicode_decomposition_c_04C1, .kde = &lxb_unicode_decomposition_k_04C1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04C2[2] = {0x0436, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04C2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04C2[2] = {0x0436, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04C2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04C2[2] = {0x0436, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04C2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04C2 = {.cp = 0x04C2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04C2, .cde = &lxb_unicode_decomposition_c_04C2, .kde = &lxb_unicode_decomposition_k_04C2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04D0[2] = {0x0410, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04D0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04D0[2] = {0x0410, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04D0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04D0[2] = {0x0410, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04D0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04D0 = {.cp = 0x04D0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04D0, .cde = &lxb_unicode_decomposition_c_04D0, .kde = &lxb_unicode_decomposition_k_04D0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04D1[2] = {0x0430, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04D1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04D1[2] = {0x0430, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04D1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04D1[2] = {0x0430, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04D1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04D1 = {.cp = 0x04D1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04D1, .cde = &lxb_unicode_decomposition_c_04D1, .kde = &lxb_unicode_decomposition_k_04D1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04D2[2] = {0x0410, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04D2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04D2[2] = {0x0410, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04D2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04D2[2] = {0x0410, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04D2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04D2 = {.cp = 0x04D2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04D2, .cde = &lxb_unicode_decomposition_c_04D2, .kde = &lxb_unicode_decomposition_k_04D2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04D3[2] = {0x0430, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04D3[2] = {0x0430, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04D3[2] = {0x0430, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04D3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04D3 = {.cp = 0x04D3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04D3, .cde = &lxb_unicode_decomposition_c_04D3, .kde = &lxb_unicode_decomposition_k_04D3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04D6[2] = {0x0415, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04D6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04D6[2] = {0x0415, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04D6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04D6[2] = {0x0415, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04D6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04D6 = {.cp = 0x04D6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04D6, .cde = &lxb_unicode_decomposition_c_04D6, .kde = &lxb_unicode_decomposition_k_04D6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04D7[2] = {0x0435, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04D7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04D7[2] = {0x0435, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04D7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04D7[2] = {0x0435, 0x0306};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04D7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04D7 = {.cp = 0x04D7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04D7, .cde = &lxb_unicode_decomposition_c_04D7, .kde = &lxb_unicode_decomposition_k_04D7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04DA[2] = {0x04D8, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04DA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04DA[2] = {0x04D8, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04DA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04DA[2] = {0x04D8, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04DA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04DA = {.cp = 0x04DA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04DA, .cde = &lxb_unicode_decomposition_c_04DA, .kde = &lxb_unicode_decomposition_k_04DA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04DB[2] = {0x04D9, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04DB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04DB[2] = {0x04D9, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04DB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04DB[2] = {0x04D9, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04DB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04DB = {.cp = 0x04DB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04DB, .cde = &lxb_unicode_decomposition_c_04DB, .kde = &lxb_unicode_decomposition_k_04DB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04DC[2] = {0x0416, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04DC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04DC[2] = {0x0416, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04DC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04DC[2] = {0x0416, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04DC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04DC = {.cp = 0x04DC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04DC, .cde = &lxb_unicode_decomposition_c_04DC, .kde = &lxb_unicode_decomposition_k_04DC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04DD[2] = {0x0436, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04DD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04DD[2] = {0x0436, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04DD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04DD[2] = {0x0436, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04DD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04DD = {.cp = 0x04DD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04DD, .cde = &lxb_unicode_decomposition_c_04DD, .kde = &lxb_unicode_decomposition_k_04DD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04DE[2] = {0x0417, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04DE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04DE[2] = {0x0417, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04DE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04DE[2] = {0x0417, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04DE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04DE = {.cp = 0x04DE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04DE, .cde = &lxb_unicode_decomposition_c_04DE, .kde = &lxb_unicode_decomposition_k_04DE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04DF[2] = {0x0437, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04DF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04DF[2] = {0x0437, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04DF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04DF[2] = {0x0437, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04DF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04DF = {.cp = 0x04DF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04DF, .cde = &lxb_unicode_decomposition_c_04DF, .kde = &lxb_unicode_decomposition_k_04DF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04E2[2] = {0x0418, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04E2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04E2[2] = {0x0418, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04E2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04E2[2] = {0x0418, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04E2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04E2 = {.cp = 0x04E2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04E2, .cde = &lxb_unicode_decomposition_c_04E2, .kde = &lxb_unicode_decomposition_k_04E2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04E3[2] = {0x0438, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04E3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04E3[2] = {0x0438, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04E3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04E3[2] = {0x0438, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04E3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04E3 = {.cp = 0x04E3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04E3, .cde = &lxb_unicode_decomposition_c_04E3, .kde = &lxb_unicode_decomposition_k_04E3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04E4[2] = {0x0418, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04E4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04E4[2] = {0x0418, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04E4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04E4[2] = {0x0418, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04E4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04E4 = {.cp = 0x04E4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04E4, .cde = &lxb_unicode_decomposition_c_04E4, .kde = &lxb_unicode_decomposition_k_04E4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04E5[2] = {0x0438, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04E5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04E5[2] = {0x0438, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04E5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04E5[2] = {0x0438, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04E5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04E5 = {.cp = 0x04E5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04E5, .cde = &lxb_unicode_decomposition_c_04E5, .kde = &lxb_unicode_decomposition_k_04E5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04E6[2] = {0x041E, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04E6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04E6[2] = {0x041E, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04E6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04E6[2] = {0x041E, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04E6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04E6 = {.cp = 0x04E6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04E6, .cde = &lxb_unicode_decomposition_c_04E6, .kde = &lxb_unicode_decomposition_k_04E6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04E7[2] = {0x043E, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04E7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04E7[2] = {0x043E, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04E7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04E7[2] = {0x043E, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04E7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04E7 = {.cp = 0x04E7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04E7, .cde = &lxb_unicode_decomposition_c_04E7, .kde = &lxb_unicode_decomposition_k_04E7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04EA[2] = {0x04E8, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04EA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04EA[2] = {0x04E8, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04EA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04EA[2] = {0x04E8, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04EA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04EA = {.cp = 0x04EA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04EA, .cde = &lxb_unicode_decomposition_c_04EA, .kde = &lxb_unicode_decomposition_k_04EA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04EB[2] = {0x04E9, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04EB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04EB[2] = {0x04E9, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04EB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04EB[2] = {0x04E9, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04EB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04EB = {.cp = 0x04EB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04EB, .cde = &lxb_unicode_decomposition_c_04EB, .kde = &lxb_unicode_decomposition_k_04EB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04EC[2] = {0x042D, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04EC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04EC[2] = {0x042D, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04EC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04EC[2] = {0x042D, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04EC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04EC = {.cp = 0x04EC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04EC, .cde = &lxb_unicode_decomposition_c_04EC, .kde = &lxb_unicode_decomposition_k_04EC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04ED[2] = {0x044D, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04ED, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04ED[2] = {0x044D, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04ED, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04ED[2] = {0x044D, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04ED, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04ED = {.cp = 0x04ED, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04ED, .cde = &lxb_unicode_decomposition_c_04ED, .kde = &lxb_unicode_decomposition_k_04ED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04EE[2] = {0x0423, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04EE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04EE[2] = {0x0423, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04EE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04EE[2] = {0x0423, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04EE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04EE = {.cp = 0x04EE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04EE, .cde = &lxb_unicode_decomposition_c_04EE, .kde = &lxb_unicode_decomposition_k_04EE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04EF[2] = {0x0443, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04EF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04EF[2] = {0x0443, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04EF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04EF[2] = {0x0443, 0x0304};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04EF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04EF = {.cp = 0x04EF, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04EF, .cde = &lxb_unicode_decomposition_c_04EF, .kde = &lxb_unicode_decomposition_k_04EF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04F0[2] = {0x0423, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04F0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04F0[2] = {0x0423, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04F0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04F0[2] = {0x0423, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04F0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04F0 = {.cp = 0x04F0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04F0, .cde = &lxb_unicode_decomposition_c_04F0, .kde = &lxb_unicode_decomposition_k_04F0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04F1[2] = {0x0443, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04F1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04F1[2] = {0x0443, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04F1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04F1[2] = {0x0443, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04F1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04F1 = {.cp = 0x04F1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04F1, .cde = &lxb_unicode_decomposition_c_04F1, .kde = &lxb_unicode_decomposition_k_04F1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04F2[2] = {0x0423, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04F2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04F2[2] = {0x0423, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04F2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04F2[2] = {0x0423, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04F2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04F2 = {.cp = 0x04F2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04F2, .cde = &lxb_unicode_decomposition_c_04F2, .kde = &lxb_unicode_decomposition_k_04F2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04F3[2] = {0x0443, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04F3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04F3[2] = {0x0443, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04F3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04F3[2] = {0x0443, 0x030B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04F3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04F3 = {.cp = 0x04F3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04F3, .cde = &lxb_unicode_decomposition_c_04F3, .kde = &lxb_unicode_decomposition_k_04F3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04F4[2] = {0x0427, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04F4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04F4[2] = {0x0427, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04F4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04F4[2] = {0x0427, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04F4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04F4 = {.cp = 0x04F4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04F4, .cde = &lxb_unicode_decomposition_c_04F4, .kde = &lxb_unicode_decomposition_k_04F4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04F5[2] = {0x0447, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04F5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04F5[2] = {0x0447, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04F5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04F5[2] = {0x0447, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04F5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04F5 = {.cp = 0x04F5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04F5, .cde = &lxb_unicode_decomposition_c_04F5, .kde = &lxb_unicode_decomposition_k_04F5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04F8[2] = {0x042B, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04F8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04F8[2] = {0x042B, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04F8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04F8[2] = {0x042B, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04F8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04F8 = {.cp = 0x04F8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04F8, .cde = &lxb_unicode_decomposition_c_04F8, .kde = &lxb_unicode_decomposition_k_04F8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_04F9[2] = {0x044B, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_04F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_04F9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_04F9[2] = {0x044B, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_04F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_04F9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__04F9[2] = {0x044B, 0x0308};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__04F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__04F9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_04F9 = {.cp = 0x04F9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__04F9, .cde = &lxb_unicode_decomposition_c_04F9, .kde = &lxb_unicode_decomposition_k_04F9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0587[2] = {0x0565, 0x0582};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0587 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0587, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0587[2] = {0x0565, 0x0582};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0587 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0587, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0587[2] = {0x0565, 0x0582};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0587 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0587, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0587 = {.cp = 0x0587, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0587, .cde = &lxb_unicode_decomposition_c_0587, .kde = &lxb_unicode_decomposition_k_0587};

static const lxb_unicode_entry_t lxb_unicode_entry_0591 = {.cp = 0x0591, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0592 = {.cp = 0x0592, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0593 = {.cp = 0x0593, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0594 = {.cp = 0x0594, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0595 = {.cp = 0x0595, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0596 = {.cp = 0x0596, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0597 = {.cp = 0x0597, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0598 = {.cp = 0x0598, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0599 = {.cp = 0x0599, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_059A = {.cp = 0x059A, .ccc = 222, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_059B = {.cp = 0x059B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_059C = {.cp = 0x059C, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_059D = {.cp = 0x059D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_059E = {.cp = 0x059E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_059F = {.cp = 0x059F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05A0 = {.cp = 0x05A0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05A1 = {.cp = 0x05A1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05A2 = {.cp = 0x05A2, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05A3 = {.cp = 0x05A3, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05A4 = {.cp = 0x05A4, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05A5 = {.cp = 0x05A5, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05A6 = {.cp = 0x05A6, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05A7 = {.cp = 0x05A7, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05A8 = {.cp = 0x05A8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05A9 = {.cp = 0x05A9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05AA = {.cp = 0x05AA, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05AB = {.cp = 0x05AB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05AC = {.cp = 0x05AC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05AD = {.cp = 0x05AD, .ccc = 222, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05AE = {.cp = 0x05AE, .ccc = 228, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05AF = {.cp = 0x05AF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05B0 = {.cp = 0x05B0, .ccc = 10, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05B1 = {.cp = 0x05B1, .ccc = 11, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05B2 = {.cp = 0x05B2, .ccc = 12, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05B3 = {.cp = 0x05B3, .ccc = 13, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05B4 = {.cp = 0x05B4, .ccc = 14, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05B5 = {.cp = 0x05B5, .ccc = 15, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05B6 = {.cp = 0x05B6, .ccc = 16, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05B7 = {.cp = 0x05B7, .ccc = 17, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05B8 = {.cp = 0x05B8, .ccc = 18, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05B9 = {.cp = 0x05B9, .ccc = 19, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05BA = {.cp = 0x05BA, .ccc = 19, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05BB = {.cp = 0x05BB, .ccc = 20, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05BC = {.cp = 0x05BC, .ccc = 21, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05BD = {.cp = 0x05BD, .ccc = 22, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05BF = {.cp = 0x05BF, .ccc = 23, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05C1 = {.cp = 0x05C1, .ccc = 24, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05C2 = {.cp = 0x05C2, .ccc = 25, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05C4 = {.cp = 0x05C4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05C5 = {.cp = 0x05C5, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_05C7 = {.cp = 0x05C7, .ccc = 18, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0610 = {.cp = 0x0610, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0611 = {.cp = 0x0611, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0612 = {.cp = 0x0612, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0613 = {.cp = 0x0613, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0614 = {.cp = 0x0614, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0615 = {.cp = 0x0615, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0616 = {.cp = 0x0616, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0617 = {.cp = 0x0617, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0618 = {.cp = 0x0618, .ccc = 30, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0619 = {.cp = 0x0619, .ccc = 31, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_061A = {.cp = 0x061A, .ccc = 32, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0622[2] = {0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0622 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0622, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0622[2] = {0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0622 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0622, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0622[2] = {0x0627, 0x0653};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0622 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0622, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0622 = {.cp = 0x0622, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0622, .cde = &lxb_unicode_decomposition_c_0622, .kde = &lxb_unicode_decomposition_k_0622};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0623[2] = {0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0623 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0623, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0623[2] = {0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0623 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0623, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0623[2] = {0x0627, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0623 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0623, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0623 = {.cp = 0x0623, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0623, .cde = &lxb_unicode_decomposition_c_0623, .kde = &lxb_unicode_decomposition_k_0623};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0624[2] = {0x0648, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0624 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0624, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0624[2] = {0x0648, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0624 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0624, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0624[2] = {0x0648, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0624 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0624, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0624 = {.cp = 0x0624, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0624, .cde = &lxb_unicode_decomposition_c_0624, .kde = &lxb_unicode_decomposition_k_0624};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0625[2] = {0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0625 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0625, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0625[2] = {0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0625 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0625, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0625[2] = {0x0627, 0x0655};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0625 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0625, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0625 = {.cp = 0x0625, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0625, .cde = &lxb_unicode_decomposition_c_0625, .kde = &lxb_unicode_decomposition_k_0625};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0626[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0626 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0626, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0626[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0626 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0626, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0626[2] = {0x064A, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0626 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0626, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0626 = {.cp = 0x0626, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0626, .cde = &lxb_unicode_decomposition_c_0626, .kde = &lxb_unicode_decomposition_k_0626};

static const lxb_unicode_entry_t lxb_unicode_entry_064B = {.cp = 0x064B, .ccc = 27, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_064C = {.cp = 0x064C, .ccc = 28, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_064D = {.cp = 0x064D, .ccc = 29, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_064E = {.cp = 0x064E, .ccc = 30, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_064F = {.cp = 0x064F, .ccc = 31, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0650 = {.cp = 0x0650, .ccc = 32, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0651 = {.cp = 0x0651, .ccc = 33, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0652 = {.cp = 0x0652, .ccc = 34, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0653 = {.cp = 0x0653, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0654 = {.cp = 0x0654, .ccc = 230, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0655 = {.cp = 0x0655, .ccc = 220, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0656 = {.cp = 0x0656, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0657 = {.cp = 0x0657, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0658 = {.cp = 0x0658, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0659 = {.cp = 0x0659, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_065A = {.cp = 0x065A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_065B = {.cp = 0x065B, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_065C = {.cp = 0x065C, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_065D = {.cp = 0x065D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_065E = {.cp = 0x065E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_065F = {.cp = 0x065F, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0670 = {.cp = 0x0670, .ccc = 35, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0675[2] = {0x0627, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0675 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0675, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0675[2] = {0x0627, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0675 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0675, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0675[2] = {0x0627, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0675 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0675, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0675 = {.cp = 0x0675, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0675, .cde = &lxb_unicode_decomposition_c_0675, .kde = &lxb_unicode_decomposition_k_0675};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0676[2] = {0x0648, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0676 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0676, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0676[2] = {0x0648, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0676 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0676, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0676[2] = {0x0648, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0676 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0676, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0676 = {.cp = 0x0676, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0676, .cde = &lxb_unicode_decomposition_c_0676, .kde = &lxb_unicode_decomposition_k_0676};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0677[2] = {0x06C7, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0677 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0677, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0677[2] = {0x06C7, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0677 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0677, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0677[2] = {0x06C7, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0677 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0677, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0677 = {.cp = 0x0677, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0677, .cde = &lxb_unicode_decomposition_c_0677, .kde = &lxb_unicode_decomposition_k_0677};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0678[2] = {0x064A, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0678 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0678, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0678[2] = {0x064A, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0678 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0678, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0678[2] = {0x064A, 0x0674};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0678 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0678, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0678 = {.cp = 0x0678, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0678, .cde = &lxb_unicode_decomposition_c_0678, .kde = &lxb_unicode_decomposition_k_0678};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_06C0[2] = {0x06D5, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_06C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_06C0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_06C0[2] = {0x06D5, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_06C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_06C0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__06C0[2] = {0x06D5, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__06C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__06C0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_06C0 = {.cp = 0x06C0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__06C0, .cde = &lxb_unicode_decomposition_c_06C0, .kde = &lxb_unicode_decomposition_k_06C0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_06C2[2] = {0x06C1, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_06C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_06C2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_06C2[2] = {0x06C1, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_06C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_06C2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__06C2[2] = {0x06C1, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__06C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__06C2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_06C2 = {.cp = 0x06C2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__06C2, .cde = &lxb_unicode_decomposition_c_06C2, .kde = &lxb_unicode_decomposition_k_06C2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_06D3[2] = {0x06D2, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_06D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_06D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_06D3[2] = {0x06D2, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_06D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_06D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__06D3[2] = {0x06D2, 0x0654};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__06D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__06D3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_06D3 = {.cp = 0x06D3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__06D3, .cde = &lxb_unicode_decomposition_c_06D3, .kde = &lxb_unicode_decomposition_k_06D3};

static const lxb_unicode_entry_t lxb_unicode_entry_06D6 = {.cp = 0x06D6, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06D7 = {.cp = 0x06D7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06D8 = {.cp = 0x06D8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06D9 = {.cp = 0x06D9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06DA = {.cp = 0x06DA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06DB = {.cp = 0x06DB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06DC = {.cp = 0x06DC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06DF = {.cp = 0x06DF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06E0 = {.cp = 0x06E0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06E1 = {.cp = 0x06E1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06E2 = {.cp = 0x06E2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06E3 = {.cp = 0x06E3, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06E4 = {.cp = 0x06E4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06E7 = {.cp = 0x06E7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06E8 = {.cp = 0x06E8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06EA = {.cp = 0x06EA, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06EB = {.cp = 0x06EB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06EC = {.cp = 0x06EC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_06ED = {.cp = 0x06ED, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0711 = {.cp = 0x0711, .ccc = 36, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0730 = {.cp = 0x0730, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0731 = {.cp = 0x0731, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0732 = {.cp = 0x0732, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0733 = {.cp = 0x0733, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0734 = {.cp = 0x0734, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0735 = {.cp = 0x0735, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0736 = {.cp = 0x0736, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0737 = {.cp = 0x0737, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0738 = {.cp = 0x0738, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0739 = {.cp = 0x0739, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_073A = {.cp = 0x073A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_073B = {.cp = 0x073B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_073C = {.cp = 0x073C, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_073D = {.cp = 0x073D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_073E = {.cp = 0x073E, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_073F = {.cp = 0x073F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0740 = {.cp = 0x0740, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0741 = {.cp = 0x0741, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0742 = {.cp = 0x0742, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0743 = {.cp = 0x0743, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0744 = {.cp = 0x0744, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0745 = {.cp = 0x0745, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0746 = {.cp = 0x0746, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0747 = {.cp = 0x0747, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0748 = {.cp = 0x0748, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0749 = {.cp = 0x0749, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_074A = {.cp = 0x074A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_07EB = {.cp = 0x07EB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_07EC = {.cp = 0x07EC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_07ED = {.cp = 0x07ED, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_07EE = {.cp = 0x07EE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_07EF = {.cp = 0x07EF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_07F0 = {.cp = 0x07F0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_07F1 = {.cp = 0x07F1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_07F2 = {.cp = 0x07F2, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_07F3 = {.cp = 0x07F3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_07FD = {.cp = 0x07FD, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0816 = {.cp = 0x0816, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0817 = {.cp = 0x0817, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0818 = {.cp = 0x0818, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0819 = {.cp = 0x0819, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_081B = {.cp = 0x081B, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_081C = {.cp = 0x081C, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_081D = {.cp = 0x081D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_081E = {.cp = 0x081E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_081F = {.cp = 0x081F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0820 = {.cp = 0x0820, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0821 = {.cp = 0x0821, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0822 = {.cp = 0x0822, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0823 = {.cp = 0x0823, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0825 = {.cp = 0x0825, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0826 = {.cp = 0x0826, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0827 = {.cp = 0x0827, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0829 = {.cp = 0x0829, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_082A = {.cp = 0x082A, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_082B = {.cp = 0x082B, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_082C = {.cp = 0x082C, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_082D = {.cp = 0x082D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0859 = {.cp = 0x0859, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_085A = {.cp = 0x085A, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_085B = {.cp = 0x085B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0898 = {.cp = 0x0898, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0899 = {.cp = 0x0899, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_089A = {.cp = 0x089A, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_089B = {.cp = 0x089B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_089C = {.cp = 0x089C, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_089D = {.cp = 0x089D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_089E = {.cp = 0x089E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_089F = {.cp = 0x089F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08CA = {.cp = 0x08CA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08CB = {.cp = 0x08CB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08CC = {.cp = 0x08CC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08CD = {.cp = 0x08CD, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08CE = {.cp = 0x08CE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08CF = {.cp = 0x08CF, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08D0 = {.cp = 0x08D0, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08D1 = {.cp = 0x08D1, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08D2 = {.cp = 0x08D2, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08D3 = {.cp = 0x08D3, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08D4 = {.cp = 0x08D4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08D5 = {.cp = 0x08D5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08D6 = {.cp = 0x08D6, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08D7 = {.cp = 0x08D7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08D8 = {.cp = 0x08D8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08D9 = {.cp = 0x08D9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08DA = {.cp = 0x08DA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08DB = {.cp = 0x08DB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08DC = {.cp = 0x08DC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08DD = {.cp = 0x08DD, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08DE = {.cp = 0x08DE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08DF = {.cp = 0x08DF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08E0 = {.cp = 0x08E0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08E1 = {.cp = 0x08E1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08E3 = {.cp = 0x08E3, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08E4 = {.cp = 0x08E4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08E5 = {.cp = 0x08E5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08E6 = {.cp = 0x08E6, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08E7 = {.cp = 0x08E7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08E8 = {.cp = 0x08E8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08E9 = {.cp = 0x08E9, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08EA = {.cp = 0x08EA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08EB = {.cp = 0x08EB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08EC = {.cp = 0x08EC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08ED = {.cp = 0x08ED, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08EE = {.cp = 0x08EE, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08EF = {.cp = 0x08EF, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08F0 = {.cp = 0x08F0, .ccc = 27, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08F1 = {.cp = 0x08F1, .ccc = 28, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08F2 = {.cp = 0x08F2, .ccc = 29, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08F3 = {.cp = 0x08F3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08F4 = {.cp = 0x08F4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08F5 = {.cp = 0x08F5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08F6 = {.cp = 0x08F6, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08F7 = {.cp = 0x08F7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08F8 = {.cp = 0x08F8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08F9 = {.cp = 0x08F9, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08FA = {.cp = 0x08FA, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08FB = {.cp = 0x08FB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08FC = {.cp = 0x08FC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08FD = {.cp = 0x08FD, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08FE = {.cp = 0x08FE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_08FF = {.cp = 0x08FF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0929[2] = {0x0928, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0929 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0929, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0929[2] = {0x0928, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0929 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0929, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0929[2] = {0x0928, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0929 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0929, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0929 = {.cp = 0x0929, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0929, .cde = &lxb_unicode_decomposition_c_0929, .kde = &lxb_unicode_decomposition_k_0929};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0931[2] = {0x0930, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0931 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0931, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0931[2] = {0x0930, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0931 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0931, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0931[2] = {0x0930, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0931 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0931, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0931 = {.cp = 0x0931, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0931, .cde = &lxb_unicode_decomposition_c_0931, .kde = &lxb_unicode_decomposition_k_0931};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0934[2] = {0x0933, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0934 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0934, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0934[2] = {0x0933, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0934 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0934, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0934[2] = {0x0933, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0934 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0934, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0934 = {.cp = 0x0934, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0934, .cde = &lxb_unicode_decomposition_c_0934, .kde = &lxb_unicode_decomposition_k_0934};

static const lxb_unicode_entry_t lxb_unicode_entry_093C = {.cp = 0x093C, .ccc = 7, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_094D = {.cp = 0x094D, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0951 = {.cp = 0x0951, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0952 = {.cp = 0x0952, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0953 = {.cp = 0x0953, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0954 = {.cp = 0x0954, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0958[2] = {0x0915, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0958 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0958, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0958[2] = {0x0915, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0958 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0958, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0958[2] = {0x0915, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0958 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0958, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0958 = {.cp = 0x0958, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0958, .cde = &lxb_unicode_decomposition_c_0958, .kde = &lxb_unicode_decomposition_k_0958};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0959[2] = {0x0916, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0959 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0959, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0959[2] = {0x0916, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0959 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0959, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0959[2] = {0x0916, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0959 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0959, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0959 = {.cp = 0x0959, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0959, .cde = &lxb_unicode_decomposition_c_0959, .kde = &lxb_unicode_decomposition_k_0959};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_095A[2] = {0x0917, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_095A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_095A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_095A[2] = {0x0917, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_095A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_095A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__095A[2] = {0x0917, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__095A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__095A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_095A = {.cp = 0x095A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__095A, .cde = &lxb_unicode_decomposition_c_095A, .kde = &lxb_unicode_decomposition_k_095A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_095B[2] = {0x091C, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_095B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_095B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_095B[2] = {0x091C, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_095B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_095B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__095B[2] = {0x091C, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__095B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__095B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_095B = {.cp = 0x095B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__095B, .cde = &lxb_unicode_decomposition_c_095B, .kde = &lxb_unicode_decomposition_k_095B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_095C[2] = {0x0921, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_095C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_095C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_095C[2] = {0x0921, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_095C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_095C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__095C[2] = {0x0921, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__095C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__095C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_095C = {.cp = 0x095C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__095C, .cde = &lxb_unicode_decomposition_c_095C, .kde = &lxb_unicode_decomposition_k_095C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_095D[2] = {0x0922, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_095D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_095D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_095D[2] = {0x0922, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_095D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_095D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__095D[2] = {0x0922, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__095D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__095D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_095D = {.cp = 0x095D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__095D, .cde = &lxb_unicode_decomposition_c_095D, .kde = &lxb_unicode_decomposition_k_095D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_095E[2] = {0x092B, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_095E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_095E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_095E[2] = {0x092B, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_095E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_095E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__095E[2] = {0x092B, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__095E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__095E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_095E = {.cp = 0x095E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__095E, .cde = &lxb_unicode_decomposition_c_095E, .kde = &lxb_unicode_decomposition_k_095E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_095F[2] = {0x092F, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_095F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_095F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_095F[2] = {0x092F, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_095F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_095F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__095F[2] = {0x092F, 0x093C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__095F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__095F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_095F = {.cp = 0x095F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__095F, .cde = &lxb_unicode_decomposition_c_095F, .kde = &lxb_unicode_decomposition_k_095F};

static const lxb_unicode_entry_t lxb_unicode_entry_09BC = {.cp = 0x09BC, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_09BE = {.cp = 0x09BE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_09CB[2] = {0x09C7, 0x09BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_09CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_09CB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_09CB[2] = {0x09C7, 0x09BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_09CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_09CB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__09CB[2] = {0x09C7, 0x09BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__09CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__09CB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_09CB = {.cp = 0x09CB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__09CB, .cde = &lxb_unicode_decomposition_c_09CB, .kde = &lxb_unicode_decomposition_k_09CB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_09CC[2] = {0x09C7, 0x09D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_09CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_09CC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_09CC[2] = {0x09C7, 0x09D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_09CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_09CC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__09CC[2] = {0x09C7, 0x09D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__09CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__09CC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_09CC = {.cp = 0x09CC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__09CC, .cde = &lxb_unicode_decomposition_c_09CC, .kde = &lxb_unicode_decomposition_k_09CC};

static const lxb_unicode_entry_t lxb_unicode_entry_09CD = {.cp = 0x09CD, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_09D7 = {.cp = 0x09D7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_09DC[2] = {0x09A1, 0x09BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_09DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_09DC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_09DC[2] = {0x09A1, 0x09BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_09DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_09DC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__09DC[2] = {0x09A1, 0x09BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__09DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__09DC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_09DC = {.cp = 0x09DC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__09DC, .cde = &lxb_unicode_decomposition_c_09DC, .kde = &lxb_unicode_decomposition_k_09DC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_09DD[2] = {0x09A2, 0x09BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_09DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_09DD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_09DD[2] = {0x09A2, 0x09BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_09DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_09DD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__09DD[2] = {0x09A2, 0x09BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__09DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__09DD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_09DD = {.cp = 0x09DD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__09DD, .cde = &lxb_unicode_decomposition_c_09DD, .kde = &lxb_unicode_decomposition_k_09DD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_09DF[2] = {0x09AF, 0x09BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_09DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_09DF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_09DF[2] = {0x09AF, 0x09BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_09DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_09DF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__09DF[2] = {0x09AF, 0x09BC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__09DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__09DF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_09DF = {.cp = 0x09DF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__09DF, .cde = &lxb_unicode_decomposition_c_09DF, .kde = &lxb_unicode_decomposition_k_09DF};

static const lxb_unicode_entry_t lxb_unicode_entry_09FE = {.cp = 0x09FE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0A33[2] = {0x0A32, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0A33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0A33, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0A33[2] = {0x0A32, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0A33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0A33, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0A33[2] = {0x0A32, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0A33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0A33, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0A33 = {.cp = 0x0A33, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0A33, .cde = &lxb_unicode_decomposition_c_0A33, .kde = &lxb_unicode_decomposition_k_0A33};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0A36[2] = {0x0A38, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0A36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0A36, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0A36[2] = {0x0A38, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0A36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0A36, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0A36[2] = {0x0A38, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0A36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0A36, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0A36 = {.cp = 0x0A36, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0A36, .cde = &lxb_unicode_decomposition_c_0A36, .kde = &lxb_unicode_decomposition_k_0A36};

static const lxb_unicode_entry_t lxb_unicode_entry_0A3C = {.cp = 0x0A3C, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0A4D = {.cp = 0x0A4D, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0A59[2] = {0x0A16, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0A59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0A59, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0A59[2] = {0x0A16, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0A59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0A59, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0A59[2] = {0x0A16, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0A59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0A59, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0A59 = {.cp = 0x0A59, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0A59, .cde = &lxb_unicode_decomposition_c_0A59, .kde = &lxb_unicode_decomposition_k_0A59};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0A5A[2] = {0x0A17, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0A5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0A5A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0A5A[2] = {0x0A17, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0A5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0A5A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0A5A[2] = {0x0A17, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0A5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0A5A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0A5A = {.cp = 0x0A5A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0A5A, .cde = &lxb_unicode_decomposition_c_0A5A, .kde = &lxb_unicode_decomposition_k_0A5A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0A5B[2] = {0x0A1C, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0A5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0A5B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0A5B[2] = {0x0A1C, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0A5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0A5B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0A5B[2] = {0x0A1C, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0A5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0A5B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0A5B = {.cp = 0x0A5B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0A5B, .cde = &lxb_unicode_decomposition_c_0A5B, .kde = &lxb_unicode_decomposition_k_0A5B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0A5E[2] = {0x0A2B, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0A5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0A5E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0A5E[2] = {0x0A2B, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0A5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0A5E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0A5E[2] = {0x0A2B, 0x0A3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0A5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0A5E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0A5E = {.cp = 0x0A5E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0A5E, .cde = &lxb_unicode_decomposition_c_0A5E, .kde = &lxb_unicode_decomposition_k_0A5E};

static const lxb_unicode_entry_t lxb_unicode_entry_0ABC = {.cp = 0x0ABC, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0ACD = {.cp = 0x0ACD, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0B3C = {.cp = 0x0B3C, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0B3E = {.cp = 0x0B3E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0B48[2] = {0x0B47, 0x0B56};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0B48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0B48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0B48[2] = {0x0B47, 0x0B56};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0B48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0B48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0B48[2] = {0x0B47, 0x0B56};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0B48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0B48, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0B48 = {.cp = 0x0B48, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0B48, .cde = &lxb_unicode_decomposition_c_0B48, .kde = &lxb_unicode_decomposition_k_0B48};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0B4B[2] = {0x0B47, 0x0B3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0B4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0B4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0B4B[2] = {0x0B47, 0x0B3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0B4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0B4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0B4B[2] = {0x0B47, 0x0B3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0B4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0B4B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0B4B = {.cp = 0x0B4B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0B4B, .cde = &lxb_unicode_decomposition_c_0B4B, .kde = &lxb_unicode_decomposition_k_0B4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0B4C[2] = {0x0B47, 0x0B57};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0B4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0B4C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0B4C[2] = {0x0B47, 0x0B57};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0B4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0B4C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0B4C[2] = {0x0B47, 0x0B57};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0B4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0B4C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0B4C = {.cp = 0x0B4C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0B4C, .cde = &lxb_unicode_decomposition_c_0B4C, .kde = &lxb_unicode_decomposition_k_0B4C};

static const lxb_unicode_entry_t lxb_unicode_entry_0B4D = {.cp = 0x0B4D, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0B56 = {.cp = 0x0B56, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0B57 = {.cp = 0x0B57, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0B5C[2] = {0x0B21, 0x0B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0B5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0B5C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0B5C[2] = {0x0B21, 0x0B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0B5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0B5C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0B5C[2] = {0x0B21, 0x0B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0B5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0B5C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0B5C = {.cp = 0x0B5C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0B5C, .cde = &lxb_unicode_decomposition_c_0B5C, .kde = &lxb_unicode_decomposition_k_0B5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0B5D[2] = {0x0B22, 0x0B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0B5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0B5D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0B5D[2] = {0x0B22, 0x0B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0B5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0B5D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0B5D[2] = {0x0B22, 0x0B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0B5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0B5D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0B5D = {.cp = 0x0B5D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0B5D, .cde = &lxb_unicode_decomposition_c_0B5D, .kde = &lxb_unicode_decomposition_k_0B5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0B94[2] = {0x0B92, 0x0BD7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0B94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0B94, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0B94[2] = {0x0B92, 0x0BD7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0B94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0B94, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0B94[2] = {0x0B92, 0x0BD7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0B94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0B94, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0B94 = {.cp = 0x0B94, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0B94, .cde = &lxb_unicode_decomposition_c_0B94, .kde = &lxb_unicode_decomposition_k_0B94};

static const lxb_unicode_entry_t lxb_unicode_entry_0BBE = {.cp = 0x0BBE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0BCA[2] = {0x0BC6, 0x0BBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0BCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0BCA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0BCA[2] = {0x0BC6, 0x0BBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0BCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0BCA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0BCA[2] = {0x0BC6, 0x0BBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0BCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0BCA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0BCA = {.cp = 0x0BCA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0BCA, .cde = &lxb_unicode_decomposition_c_0BCA, .kde = &lxb_unicode_decomposition_k_0BCA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0BCB[2] = {0x0BC7, 0x0BBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0BCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0BCB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0BCB[2] = {0x0BC7, 0x0BBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0BCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0BCB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0BCB[2] = {0x0BC7, 0x0BBE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0BCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0BCB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0BCB = {.cp = 0x0BCB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0BCB, .cde = &lxb_unicode_decomposition_c_0BCB, .kde = &lxb_unicode_decomposition_k_0BCB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0BCC[2] = {0x0BC6, 0x0BD7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0BCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0BCC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0BCC[2] = {0x0BC6, 0x0BD7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0BCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0BCC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0BCC[2] = {0x0BC6, 0x0BD7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0BCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0BCC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0BCC = {.cp = 0x0BCC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0BCC, .cde = &lxb_unicode_decomposition_c_0BCC, .kde = &lxb_unicode_decomposition_k_0BCC};

static const lxb_unicode_entry_t lxb_unicode_entry_0BCD = {.cp = 0x0BCD, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0BD7 = {.cp = 0x0BD7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0C3C = {.cp = 0x0C3C, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0C48[2] = {0x0C46, 0x0C56};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0C48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0C48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0C48[2] = {0x0C46, 0x0C56};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0C48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0C48, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0C48[2] = {0x0C46, 0x0C56};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0C48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0C48, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0C48 = {.cp = 0x0C48, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0C48, .cde = &lxb_unicode_decomposition_c_0C48, .kde = &lxb_unicode_decomposition_k_0C48};

static const lxb_unicode_entry_t lxb_unicode_entry_0C4D = {.cp = 0x0C4D, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0C55 = {.cp = 0x0C55, .ccc = 84, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0C56 = {.cp = 0x0C56, .ccc = 91, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0CBC = {.cp = 0x0CBC, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0CC0[2] = {0x0CBF, 0x0CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0CC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0CC0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0CC0[2] = {0x0CBF, 0x0CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0CC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0CC0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0CC0[2] = {0x0CBF, 0x0CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0CC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0CC0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0CC0 = {.cp = 0x0CC0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0CC0, .cde = &lxb_unicode_decomposition_c_0CC0, .kde = &lxb_unicode_decomposition_k_0CC0};

static const lxb_unicode_entry_t lxb_unicode_entry_0CC2 = {.cp = 0x0CC2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0CC7[2] = {0x0CC6, 0x0CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0CC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0CC7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0CC7[2] = {0x0CC6, 0x0CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0CC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0CC7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0CC7[2] = {0x0CC6, 0x0CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0CC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0CC7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0CC7 = {.cp = 0x0CC7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0CC7, .cde = &lxb_unicode_decomposition_c_0CC7, .kde = &lxb_unicode_decomposition_k_0CC7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0CC8[2] = {0x0CC6, 0x0CD6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0CC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0CC8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0CC8[2] = {0x0CC6, 0x0CD6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0CC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0CC8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0CC8[2] = {0x0CC6, 0x0CD6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0CC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0CC8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0CC8 = {.cp = 0x0CC8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0CC8, .cde = &lxb_unicode_decomposition_c_0CC8, .kde = &lxb_unicode_decomposition_k_0CC8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0CCA[2] = {0x0CC6, 0x0CC2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0CCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0CCA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0CCA[2] = {0x0CC6, 0x0CC2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0CCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0CCA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0CCA[2] = {0x0CC6, 0x0CC2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0CCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0CCA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0CCA = {.cp = 0x0CCA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0CCA, .cde = &lxb_unicode_decomposition_c_0CCA, .kde = &lxb_unicode_decomposition_k_0CCA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0CCB[3] = {0x0CC6, 0x0CC2, 0x0CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0CCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0CCB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0CCB[3] = {0x0CC6, 0x0CC2, 0x0CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0CCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0CCB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0CCB[2] = {0x0CCA, 0x0CD5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0CCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0CCB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0CCB = {.cp = 0x0CCB, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0CCB, .cde = &lxb_unicode_decomposition_c_0CCB, .kde = &lxb_unicode_decomposition_k_0CCB};

static const lxb_unicode_entry_t lxb_unicode_entry_0CCD = {.cp = 0x0CCD, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0CD5 = {.cp = 0x0CD5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0CD6 = {.cp = 0x0CD6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0D3B = {.cp = 0x0D3B, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0D3C = {.cp = 0x0D3C, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0D3E = {.cp = 0x0D3E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0D4A[2] = {0x0D46, 0x0D3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0D4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0D4A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0D4A[2] = {0x0D46, 0x0D3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0D4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0D4A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0D4A[2] = {0x0D46, 0x0D3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0D4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0D4A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0D4A = {.cp = 0x0D4A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0D4A, .cde = &lxb_unicode_decomposition_c_0D4A, .kde = &lxb_unicode_decomposition_k_0D4A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0D4B[2] = {0x0D47, 0x0D3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0D4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0D4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0D4B[2] = {0x0D47, 0x0D3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0D4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0D4B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0D4B[2] = {0x0D47, 0x0D3E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0D4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0D4B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0D4B = {.cp = 0x0D4B, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0D4B, .cde = &lxb_unicode_decomposition_c_0D4B, .kde = &lxb_unicode_decomposition_k_0D4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0D4C[2] = {0x0D46, 0x0D57};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0D4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0D4C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0D4C[2] = {0x0D46, 0x0D57};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0D4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0D4C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0D4C[2] = {0x0D46, 0x0D57};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0D4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0D4C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0D4C = {.cp = 0x0D4C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0D4C, .cde = &lxb_unicode_decomposition_c_0D4C, .kde = &lxb_unicode_decomposition_k_0D4C};

static const lxb_unicode_entry_t lxb_unicode_entry_0D4D = {.cp = 0x0D4D, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0D57 = {.cp = 0x0D57, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0DCA = {.cp = 0x0DCA, .ccc = 9, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0DCF = {.cp = 0x0DCF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0DDA[2] = {0x0DD9, 0x0DCA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0DDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0DDA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0DDA[2] = {0x0DD9, 0x0DCA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0DDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0DDA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0DDA[2] = {0x0DD9, 0x0DCA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0DDA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0DDA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0DDA = {.cp = 0x0DDA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0DDA, .cde = &lxb_unicode_decomposition_c_0DDA, .kde = &lxb_unicode_decomposition_k_0DDA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0DDC[2] = {0x0DD9, 0x0DCF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0DDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0DDC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0DDC[2] = {0x0DD9, 0x0DCF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0DDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0DDC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0DDC[2] = {0x0DD9, 0x0DCF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0DDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0DDC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0DDC = {.cp = 0x0DDC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0DDC, .cde = &lxb_unicode_decomposition_c_0DDC, .kde = &lxb_unicode_decomposition_k_0DDC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0DDD[3] = {0x0DD9, 0x0DCF, 0x0DCA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0DDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0DDD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0DDD[3] = {0x0DD9, 0x0DCF, 0x0DCA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0DDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0DDD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0DDD[2] = {0x0DDC, 0x0DCA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0DDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0DDD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0DDD = {.cp = 0x0DDD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0DDD, .cde = &lxb_unicode_decomposition_c_0DDD, .kde = &lxb_unicode_decomposition_k_0DDD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0DDE[2] = {0x0DD9, 0x0DDF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0DDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0DDE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0DDE[2] = {0x0DD9, 0x0DDF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0DDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0DDE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0DDE[2] = {0x0DD9, 0x0DDF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0DDE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0DDE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0DDE = {.cp = 0x0DDE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0DDE, .cde = &lxb_unicode_decomposition_c_0DDE, .kde = &lxb_unicode_decomposition_k_0DDE};

static const lxb_unicode_entry_t lxb_unicode_entry_0DDF = {.cp = 0x0DDF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0E33[2] = {0x0E4D, 0x0E32};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0E33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0E33, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0E33[2] = {0x0E4D, 0x0E32};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0E33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0E33, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0E33[2] = {0x0E4D, 0x0E32};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0E33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0E33, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0E33 = {.cp = 0x0E33, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0E33, .cde = &lxb_unicode_decomposition_c_0E33, .kde = &lxb_unicode_decomposition_k_0E33};

static const lxb_unicode_entry_t lxb_unicode_entry_0E38 = {.cp = 0x0E38, .ccc = 103, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0E39 = {.cp = 0x0E39, .ccc = 103, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0E3A = {.cp = 0x0E3A, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0E48 = {.cp = 0x0E48, .ccc = 107, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0E49 = {.cp = 0x0E49, .ccc = 107, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0E4A = {.cp = 0x0E4A, .ccc = 107, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0E4B = {.cp = 0x0E4B, .ccc = 107, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0EB3[2] = {0x0ECD, 0x0EB2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0EB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0EB3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0EB3[2] = {0x0ECD, 0x0EB2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0EB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0EB3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0EB3[2] = {0x0ECD, 0x0EB2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0EB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0EB3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0EB3 = {.cp = 0x0EB3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0EB3, .cde = &lxb_unicode_decomposition_c_0EB3, .kde = &lxb_unicode_decomposition_k_0EB3};

static const lxb_unicode_entry_t lxb_unicode_entry_0EB8 = {.cp = 0x0EB8, .ccc = 118, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0EB9 = {.cp = 0x0EB9, .ccc = 118, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0EBA = {.cp = 0x0EBA, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0EC8 = {.cp = 0x0EC8, .ccc = 122, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0EC9 = {.cp = 0x0EC9, .ccc = 122, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0ECA = {.cp = 0x0ECA, .ccc = 122, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0ECB = {.cp = 0x0ECB, .ccc = 122, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0EDC[2] = {0x0EAB, 0x0E99};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0EDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0EDC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0EDC[2] = {0x0EAB, 0x0E99};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0EDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0EDC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0EDC[2] = {0x0EAB, 0x0E99};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0EDC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0EDC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0EDC = {.cp = 0x0EDC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0EDC, .cde = &lxb_unicode_decomposition_c_0EDC, .kde = &lxb_unicode_decomposition_k_0EDC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0EDD[2] = {0x0EAB, 0x0EA1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0EDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0EDD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0EDD[2] = {0x0EAB, 0x0EA1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0EDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0EDD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0EDD[2] = {0x0EAB, 0x0EA1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0EDD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0EDD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0EDD = {.cp = 0x0EDD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0EDD, .cde = &lxb_unicode_decomposition_c_0EDD, .kde = &lxb_unicode_decomposition_k_0EDD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F0C[1] = {0x0F0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp_c_0F0C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F0C[1] = {0x0F0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp_k_0F0C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F0C[1] = {0x0F0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_NOBREAK, .mapping = lxb_unicode_decomposition_cp__0F0C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_0F0C = {.cp = 0x0F0C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F0C, .cde = &lxb_unicode_decomposition_c_0F0C, .kde = &lxb_unicode_decomposition_k_0F0C};

static const lxb_unicode_entry_t lxb_unicode_entry_0F18 = {.cp = 0x0F18, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F19 = {.cp = 0x0F19, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F35 = {.cp = 0x0F35, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F37 = {.cp = 0x0F37, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F39 = {.cp = 0x0F39, .ccc = 216, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F43[2] = {0x0F42, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F43, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F43[2] = {0x0F42, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F43, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F43[2] = {0x0F42, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F43, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F43 = {.cp = 0x0F43, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F43, .cde = &lxb_unicode_decomposition_c_0F43, .kde = &lxb_unicode_decomposition_k_0F43};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F4D[2] = {0x0F4C, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F4D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F4D[2] = {0x0F4C, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F4D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F4D[2] = {0x0F4C, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F4D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F4D = {.cp = 0x0F4D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F4D, .cde = &lxb_unicode_decomposition_c_0F4D, .kde = &lxb_unicode_decomposition_k_0F4D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F52[2] = {0x0F51, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F52, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F52[2] = {0x0F51, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F52, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F52[2] = {0x0F51, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F52, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F52 = {.cp = 0x0F52, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F52, .cde = &lxb_unicode_decomposition_c_0F52, .kde = &lxb_unicode_decomposition_k_0F52};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F57[2] = {0x0F56, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F57, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F57[2] = {0x0F56, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F57, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F57[2] = {0x0F56, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F57, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F57 = {.cp = 0x0F57, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F57, .cde = &lxb_unicode_decomposition_c_0F57, .kde = &lxb_unicode_decomposition_k_0F57};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F5C[2] = {0x0F5B, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F5C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F5C[2] = {0x0F5B, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F5C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F5C[2] = {0x0F5B, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F5C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F5C = {.cp = 0x0F5C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F5C, .cde = &lxb_unicode_decomposition_c_0F5C, .kde = &lxb_unicode_decomposition_k_0F5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F69[2] = {0x0F40, 0x0FB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F69, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F69[2] = {0x0F40, 0x0FB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F69, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F69[2] = {0x0F40, 0x0FB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F69, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F69 = {.cp = 0x0F69, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F69, .cde = &lxb_unicode_decomposition_c_0F69, .kde = &lxb_unicode_decomposition_k_0F69};

static const lxb_unicode_entry_t lxb_unicode_entry_0F71 = {.cp = 0x0F71, .ccc = 129, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F72 = {.cp = 0x0F72, .ccc = 130, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F73[2] = {0x0F71, 0x0F72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F73, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F73[2] = {0x0F71, 0x0F72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F73, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F73[2] = {0x0F71, 0x0F72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F73, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F73 = {.cp = 0x0F73, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F73, .cde = &lxb_unicode_decomposition_c_0F73, .kde = &lxb_unicode_decomposition_k_0F73};

static const lxb_unicode_entry_t lxb_unicode_entry_0F74 = {.cp = 0x0F74, .ccc = 132, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F75[2] = {0x0F71, 0x0F74};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F75, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F75[2] = {0x0F71, 0x0F74};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F75, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F75[2] = {0x0F71, 0x0F74};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F75, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F75 = {.cp = 0x0F75, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F75, .cde = &lxb_unicode_decomposition_c_0F75, .kde = &lxb_unicode_decomposition_k_0F75};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F76[2] = {0x0FB2, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F76, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F76[2] = {0x0FB2, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F76, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F76[2] = {0x0FB2, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F76, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F76 = {.cp = 0x0F76, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F76, .cde = &lxb_unicode_decomposition_c_0F76, .kde = &lxb_unicode_decomposition_k_0F76};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F77[3] = {0x0FB2, 0x0F71, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0F77, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F77[3] = {0x0FB2, 0x0F71, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0F77, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F77[2] = {0x0FB2, 0x0F81};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0F77, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F77 = {.cp = 0x0F77, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F77, .cde = &lxb_unicode_decomposition_c_0F77, .kde = &lxb_unicode_decomposition_k_0F77};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F78[2] = {0x0FB3, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F78, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F78[2] = {0x0FB3, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F78, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F78[2] = {0x0FB3, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F78, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F78 = {.cp = 0x0F78, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F78, .cde = &lxb_unicode_decomposition_c_0F78, .kde = &lxb_unicode_decomposition_k_0F78};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F79[3] = {0x0FB3, 0x0F71, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_0F79, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F79[3] = {0x0FB3, 0x0F71, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_0F79, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F79[2] = {0x0FB3, 0x0F81};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__0F79, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F79 = {.cp = 0x0F79, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F79, .cde = &lxb_unicode_decomposition_c_0F79, .kde = &lxb_unicode_decomposition_k_0F79};

static const lxb_unicode_entry_t lxb_unicode_entry_0F7A = {.cp = 0x0F7A, .ccc = 130, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F7B = {.cp = 0x0F7B, .ccc = 130, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F7C = {.cp = 0x0F7C, .ccc = 130, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F7D = {.cp = 0x0F7D, .ccc = 130, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F80 = {.cp = 0x0F80, .ccc = 130, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F81[2] = {0x0F71, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F81, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F81[2] = {0x0F71, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F81, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F81[2] = {0x0F71, 0x0F80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F81, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F81 = {.cp = 0x0F81, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F81, .cde = &lxb_unicode_decomposition_c_0F81, .kde = &lxb_unicode_decomposition_k_0F81};

static const lxb_unicode_entry_t lxb_unicode_entry_0F82 = {.cp = 0x0F82, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F83 = {.cp = 0x0F83, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F84 = {.cp = 0x0F84, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F86 = {.cp = 0x0F86, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_0F87 = {.cp = 0x0F87, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F93[2] = {0x0F92, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F93, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F93[2] = {0x0F92, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F93, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F93[2] = {0x0F92, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F93, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F93 = {.cp = 0x0F93, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F93, .cde = &lxb_unicode_decomposition_c_0F93, .kde = &lxb_unicode_decomposition_k_0F93};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0F9D[2] = {0x0F9C, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0F9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0F9D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0F9D[2] = {0x0F9C, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0F9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0F9D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0F9D[2] = {0x0F9C, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0F9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0F9D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0F9D = {.cp = 0x0F9D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0F9D, .cde = &lxb_unicode_decomposition_c_0F9D, .kde = &lxb_unicode_decomposition_k_0F9D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0FA2[2] = {0x0FA1, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0FA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0FA2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0FA2[2] = {0x0FA1, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0FA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0FA2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0FA2[2] = {0x0FA1, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0FA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0FA2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0FA2 = {.cp = 0x0FA2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0FA2, .cde = &lxb_unicode_decomposition_c_0FA2, .kde = &lxb_unicode_decomposition_k_0FA2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0FA7[2] = {0x0FA6, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0FA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0FA7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0FA7[2] = {0x0FA6, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0FA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0FA7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0FA7[2] = {0x0FA6, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0FA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0FA7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0FA7 = {.cp = 0x0FA7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0FA7, .cde = &lxb_unicode_decomposition_c_0FA7, .kde = &lxb_unicode_decomposition_k_0FA7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0FAC[2] = {0x0FAB, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0FAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0FAC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0FAC[2] = {0x0FAB, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0FAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0FAC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0FAC[2] = {0x0FAB, 0x0FB7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0FAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0FAC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0FAC = {.cp = 0x0FAC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0FAC, .cde = &lxb_unicode_decomposition_c_0FAC, .kde = &lxb_unicode_decomposition_k_0FAC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_0FB9[2] = {0x0F90, 0x0FB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_0FB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_0FB9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_0FB9[2] = {0x0F90, 0x0FB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_0FB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_0FB9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__0FB9[2] = {0x0F90, 0x0FB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__0FB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__0FB9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_0FB9 = {.cp = 0x0FB9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__0FB9, .cde = &lxb_unicode_decomposition_c_0FB9, .kde = &lxb_unicode_decomposition_k_0FB9};

static const lxb_unicode_entry_t lxb_unicode_entry_0FC6 = {.cp = 0x0FC6, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1026[2] = {0x1025, 0x102E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1026 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1026, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1026[2] = {0x1025, 0x102E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1026 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1026, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1026[2] = {0x1025, 0x102E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1026 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1026, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1026 = {.cp = 0x1026, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1026, .cde = &lxb_unicode_decomposition_c_1026, .kde = &lxb_unicode_decomposition_k_1026};

static const lxb_unicode_entry_t lxb_unicode_entry_102E = {.cp = 0x102E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1037 = {.cp = 0x1037, .ccc = 7, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1039 = {.cp = 0x1039, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_103A = {.cp = 0x103A, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_108D = {.cp = 0x108D, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_10FC[1] = {0x10DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_10FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_10FC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_10FC[1] = {0x10DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_10FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_10FC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__10FC[1] = {0x10DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__10FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__10FC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_10FC = {.cp = 0x10FC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__10FC, .cde = &lxb_unicode_decomposition_c_10FC, .kde = &lxb_unicode_decomposition_k_10FC};

static const lxb_unicode_entry_t lxb_unicode_entry_1161 = {.cp = 0x1161, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1162 = {.cp = 0x1162, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1163 = {.cp = 0x1163, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1164 = {.cp = 0x1164, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1165 = {.cp = 0x1165, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1166 = {.cp = 0x1166, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1167 = {.cp = 0x1167, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1168 = {.cp = 0x1168, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1169 = {.cp = 0x1169, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_116A = {.cp = 0x116A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_116B = {.cp = 0x116B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_116C = {.cp = 0x116C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_116D = {.cp = 0x116D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_116E = {.cp = 0x116E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_116F = {.cp = 0x116F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1170 = {.cp = 0x1170, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1171 = {.cp = 0x1171, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1172 = {.cp = 0x1172, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1173 = {.cp = 0x1173, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1174 = {.cp = 0x1174, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1175 = {.cp = 0x1175, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11A8 = {.cp = 0x11A8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11A9 = {.cp = 0x11A9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11AA = {.cp = 0x11AA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11AB = {.cp = 0x11AB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11AC = {.cp = 0x11AC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11AD = {.cp = 0x11AD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11AE = {.cp = 0x11AE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11AF = {.cp = 0x11AF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11B0 = {.cp = 0x11B0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11B1 = {.cp = 0x11B1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11B2 = {.cp = 0x11B2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11B3 = {.cp = 0x11B3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11B4 = {.cp = 0x11B4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11B5 = {.cp = 0x11B5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11B6 = {.cp = 0x11B6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11B7 = {.cp = 0x11B7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11B8 = {.cp = 0x11B8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11B9 = {.cp = 0x11B9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11BA = {.cp = 0x11BA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11BB = {.cp = 0x11BB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11BC = {.cp = 0x11BC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11BD = {.cp = 0x11BD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11BE = {.cp = 0x11BE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11BF = {.cp = 0x11BF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11C0 = {.cp = 0x11C0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11C1 = {.cp = 0x11C1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_11C2 = {.cp = 0x11C2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_135D = {.cp = 0x135D, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_135E = {.cp = 0x135E, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_135F = {.cp = 0x135F, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_unicode_data_t lxb_unicode_data_0041 = {NULL, &lxb_unicode_idna_map_0041};
static const lxb_unicode_data_t lxb_unicode_data_0042 = {NULL, &lxb_unicode_idna_map_0042};
static const lxb_unicode_data_t lxb_unicode_data_0043 = {NULL, &lxb_unicode_idna_map_0043};
static const lxb_unicode_data_t lxb_unicode_data_0044 = {NULL, &lxb_unicode_idna_map_0044};
static const lxb_unicode_data_t lxb_unicode_data_0045 = {NULL, &lxb_unicode_idna_map_0045};
static const lxb_unicode_data_t lxb_unicode_data_0046 = {NULL, &lxb_unicode_idna_map_0046};
static const lxb_unicode_data_t lxb_unicode_data_0047 = {NULL, &lxb_unicode_idna_map_0047};
static const lxb_unicode_data_t lxb_unicode_data_0048 = {NULL, &lxb_unicode_idna_map_0048};
static const lxb_unicode_data_t lxb_unicode_data_0049 = {NULL, &lxb_unicode_idna_map_0049};
static const lxb_unicode_data_t lxb_unicode_data_004A = {NULL, &lxb_unicode_idna_map_004A};
static const lxb_unicode_data_t lxb_unicode_data_004B = {NULL, &lxb_unicode_idna_map_004B};
static const lxb_unicode_data_t lxb_unicode_data_004C = {NULL, &lxb_unicode_idna_map_004C};
static const lxb_unicode_data_t lxb_unicode_data_004D = {NULL, &lxb_unicode_idna_map_004D};
static const lxb_unicode_data_t lxb_unicode_data_004E = {NULL, &lxb_unicode_idna_map_004E};
static const lxb_unicode_data_t lxb_unicode_data_004F = {NULL, &lxb_unicode_idna_map_004F};
static const lxb_unicode_data_t lxb_unicode_data_0050 = {NULL, &lxb_unicode_idna_map_0050};
static const lxb_unicode_data_t lxb_unicode_data_0051 = {NULL, &lxb_unicode_idna_map_0051};
static const lxb_unicode_data_t lxb_unicode_data_0052 = {NULL, &lxb_unicode_idna_map_0052};
static const lxb_unicode_data_t lxb_unicode_data_0053 = {NULL, &lxb_unicode_idna_map_0053};
static const lxb_unicode_data_t lxb_unicode_data_0054 = {NULL, &lxb_unicode_idna_map_0054};
static const lxb_unicode_data_t lxb_unicode_data_0055 = {NULL, &lxb_unicode_idna_map_0055};
static const lxb_unicode_data_t lxb_unicode_data_0056 = {NULL, &lxb_unicode_idna_map_0056};
static const lxb_unicode_data_t lxb_unicode_data_0057 = {NULL, &lxb_unicode_idna_map_0057};
static const lxb_unicode_data_t lxb_unicode_data_0058 = {NULL, &lxb_unicode_idna_map_0058};
static const lxb_unicode_data_t lxb_unicode_data_0059 = {NULL, &lxb_unicode_idna_map_0059};
static const lxb_unicode_data_t lxb_unicode_data_005A = {NULL, &lxb_unicode_idna_map_005A};
static const lxb_unicode_data_t lxb_unicode_data_00A0 = {&lxb_unicode_entry_00A0, &lxb_unicode_idna_map_00A0};
static const lxb_unicode_data_t lxb_unicode_data_00A8 = {&lxb_unicode_entry_00A8, &lxb_unicode_idna_map_00A8};
static const lxb_unicode_data_t lxb_unicode_data_00AA = {&lxb_unicode_entry_00AA, &lxb_unicode_idna_map_00AA};
static const lxb_unicode_data_t lxb_unicode_data_00AF = {&lxb_unicode_entry_00AF, &lxb_unicode_idna_map_00AF};
static const lxb_unicode_data_t lxb_unicode_data_00B2 = {&lxb_unicode_entry_00B2, &lxb_unicode_idna_map_00B2};
static const lxb_unicode_data_t lxb_unicode_data_00B3 = {&lxb_unicode_entry_00B3, &lxb_unicode_idna_map_00B3};
static const lxb_unicode_data_t lxb_unicode_data_00B4 = {&lxb_unicode_entry_00B4, &lxb_unicode_idna_map_00B4};
static const lxb_unicode_data_t lxb_unicode_data_00B5 = {&lxb_unicode_entry_00B5, &lxb_unicode_idna_map_00B5};
static const lxb_unicode_data_t lxb_unicode_data_00B8 = {&lxb_unicode_entry_00B8, &lxb_unicode_idna_map_00B8};
static const lxb_unicode_data_t lxb_unicode_data_00B9 = {&lxb_unicode_entry_00B9, &lxb_unicode_idna_map_00B9};
static const lxb_unicode_data_t lxb_unicode_data_00BA = {&lxb_unicode_entry_00BA, &lxb_unicode_idna_map_00BA};
static const lxb_unicode_data_t lxb_unicode_data_00BC = {&lxb_unicode_entry_00BC, &lxb_unicode_idna_map_00BC};
static const lxb_unicode_data_t lxb_unicode_data_00BD = {&lxb_unicode_entry_00BD, &lxb_unicode_idna_map_00BD};
static const lxb_unicode_data_t lxb_unicode_data_00BE = {&lxb_unicode_entry_00BE, &lxb_unicode_idna_map_00BE};
static const lxb_unicode_data_t lxb_unicode_data_00C0 = {&lxb_unicode_entry_00C0, &lxb_unicode_idna_map_00C0};
static const lxb_unicode_data_t lxb_unicode_data_00C1 = {&lxb_unicode_entry_00C1, &lxb_unicode_idna_map_00C1};
static const lxb_unicode_data_t lxb_unicode_data_00C2 = {&lxb_unicode_entry_00C2, &lxb_unicode_idna_map_00C2};
static const lxb_unicode_data_t lxb_unicode_data_00C3 = {&lxb_unicode_entry_00C3, &lxb_unicode_idna_map_00C3};
static const lxb_unicode_data_t lxb_unicode_data_00C4 = {&lxb_unicode_entry_00C4, &lxb_unicode_idna_map_00C4};
static const lxb_unicode_data_t lxb_unicode_data_00C5 = {&lxb_unicode_entry_00C5, &lxb_unicode_idna_map_00C5};
static const lxb_unicode_data_t lxb_unicode_data_00C6 = {NULL, &lxb_unicode_idna_map_00C6};
static const lxb_unicode_data_t lxb_unicode_data_00C7 = {&lxb_unicode_entry_00C7, &lxb_unicode_idna_map_00C7};
static const lxb_unicode_data_t lxb_unicode_data_00C8 = {&lxb_unicode_entry_00C8, &lxb_unicode_idna_map_00C8};
static const lxb_unicode_data_t lxb_unicode_data_00C9 = {&lxb_unicode_entry_00C9, &lxb_unicode_idna_map_00C9};
static const lxb_unicode_data_t lxb_unicode_data_00CA = {&lxb_unicode_entry_00CA, &lxb_unicode_idna_map_00CA};
static const lxb_unicode_data_t lxb_unicode_data_00CB = {&lxb_unicode_entry_00CB, &lxb_unicode_idna_map_00CB};
static const lxb_unicode_data_t lxb_unicode_data_00CC = {&lxb_unicode_entry_00CC, &lxb_unicode_idna_map_00CC};
static const lxb_unicode_data_t lxb_unicode_data_00CD = {&lxb_unicode_entry_00CD, &lxb_unicode_idna_map_00CD};
static const lxb_unicode_data_t lxb_unicode_data_00CE = {&lxb_unicode_entry_00CE, &lxb_unicode_idna_map_00CE};
static const lxb_unicode_data_t lxb_unicode_data_00CF = {&lxb_unicode_entry_00CF, &lxb_unicode_idna_map_00CF};
static const lxb_unicode_data_t lxb_unicode_data_00D0 = {NULL, &lxb_unicode_idna_map_00D0};
static const lxb_unicode_data_t lxb_unicode_data_00D1 = {&lxb_unicode_entry_00D1, &lxb_unicode_idna_map_00D1};
static const lxb_unicode_data_t lxb_unicode_data_00D2 = {&lxb_unicode_entry_00D2, &lxb_unicode_idna_map_00D2};
static const lxb_unicode_data_t lxb_unicode_data_00D3 = {&lxb_unicode_entry_00D3, &lxb_unicode_idna_map_00D3};
static const lxb_unicode_data_t lxb_unicode_data_00D4 = {&lxb_unicode_entry_00D4, &lxb_unicode_idna_map_00D4};
static const lxb_unicode_data_t lxb_unicode_data_00D5 = {&lxb_unicode_entry_00D5, &lxb_unicode_idna_map_00D5};
static const lxb_unicode_data_t lxb_unicode_data_00D6 = {&lxb_unicode_entry_00D6, &lxb_unicode_idna_map_00D6};
static const lxb_unicode_data_t lxb_unicode_data_00D8 = {NULL, &lxb_unicode_idna_map_00D8};
static const lxb_unicode_data_t lxb_unicode_data_00D9 = {&lxb_unicode_entry_00D9, &lxb_unicode_idna_map_00D9};
static const lxb_unicode_data_t lxb_unicode_data_00DA = {&lxb_unicode_entry_00DA, &lxb_unicode_idna_map_00DA};
static const lxb_unicode_data_t lxb_unicode_data_00DB = {&lxb_unicode_entry_00DB, &lxb_unicode_idna_map_00DB};
static const lxb_unicode_data_t lxb_unicode_data_00DC = {&lxb_unicode_entry_00DC, &lxb_unicode_idna_map_00DC};
static const lxb_unicode_data_t lxb_unicode_data_00DD = {&lxb_unicode_entry_00DD, &lxb_unicode_idna_map_00DD};
static const lxb_unicode_data_t lxb_unicode_data_00DE = {NULL, &lxb_unicode_idna_map_00DE};
static const lxb_unicode_data_t lxb_unicode_data_00DF = {NULL, &lxb_unicode_idna_map_00DF};
static const lxb_unicode_data_t lxb_unicode_data_00E0 = {&lxb_unicode_entry_00E0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00E1 = {&lxb_unicode_entry_00E1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00E2 = {&lxb_unicode_entry_00E2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00E3 = {&lxb_unicode_entry_00E3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00E4 = {&lxb_unicode_entry_00E4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00E5 = {&lxb_unicode_entry_00E5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00E7 = {&lxb_unicode_entry_00E7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00E8 = {&lxb_unicode_entry_00E8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00E9 = {&lxb_unicode_entry_00E9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00EA = {&lxb_unicode_entry_00EA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00EB = {&lxb_unicode_entry_00EB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00EC = {&lxb_unicode_entry_00EC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00ED = {&lxb_unicode_entry_00ED, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00EE = {&lxb_unicode_entry_00EE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00EF = {&lxb_unicode_entry_00EF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00F1 = {&lxb_unicode_entry_00F1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00F2 = {&lxb_unicode_entry_00F2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00F3 = {&lxb_unicode_entry_00F3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00F4 = {&lxb_unicode_entry_00F4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00F5 = {&lxb_unicode_entry_00F5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00F6 = {&lxb_unicode_entry_00F6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00F9 = {&lxb_unicode_entry_00F9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00FA = {&lxb_unicode_entry_00FA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00FB = {&lxb_unicode_entry_00FB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00FC = {&lxb_unicode_entry_00FC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00FD = {&lxb_unicode_entry_00FD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_00FF = {&lxb_unicode_entry_00FF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0100 = {&lxb_unicode_entry_0100, &lxb_unicode_idna_map_0100};
static const lxb_unicode_data_t lxb_unicode_data_0101 = {&lxb_unicode_entry_0101, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0102 = {&lxb_unicode_entry_0102, &lxb_unicode_idna_map_0102};
static const lxb_unicode_data_t lxb_unicode_data_0103 = {&lxb_unicode_entry_0103, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0104 = {&lxb_unicode_entry_0104, &lxb_unicode_idna_map_0104};
static const lxb_unicode_data_t lxb_unicode_data_0105 = {&lxb_unicode_entry_0105, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0106 = {&lxb_unicode_entry_0106, &lxb_unicode_idna_map_0106};
static const lxb_unicode_data_t lxb_unicode_data_0107 = {&lxb_unicode_entry_0107, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0108 = {&lxb_unicode_entry_0108, &lxb_unicode_idna_map_0108};
static const lxb_unicode_data_t lxb_unicode_data_0109 = {&lxb_unicode_entry_0109, NULL};
static const lxb_unicode_data_t lxb_unicode_data_010A = {&lxb_unicode_entry_010A, &lxb_unicode_idna_map_010A};
static const lxb_unicode_data_t lxb_unicode_data_010B = {&lxb_unicode_entry_010B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_010C = {&lxb_unicode_entry_010C, &lxb_unicode_idna_map_010C};
static const lxb_unicode_data_t lxb_unicode_data_010D = {&lxb_unicode_entry_010D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_010E = {&lxb_unicode_entry_010E, &lxb_unicode_idna_map_010E};
static const lxb_unicode_data_t lxb_unicode_data_010F = {&lxb_unicode_entry_010F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0110 = {NULL, &lxb_unicode_idna_map_0110};
static const lxb_unicode_data_t lxb_unicode_data_0112 = {&lxb_unicode_entry_0112, &lxb_unicode_idna_map_0112};
static const lxb_unicode_data_t lxb_unicode_data_0113 = {&lxb_unicode_entry_0113, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0114 = {&lxb_unicode_entry_0114, &lxb_unicode_idna_map_0114};
static const lxb_unicode_data_t lxb_unicode_data_0115 = {&lxb_unicode_entry_0115, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0116 = {&lxb_unicode_entry_0116, &lxb_unicode_idna_map_0116};
static const lxb_unicode_data_t lxb_unicode_data_0117 = {&lxb_unicode_entry_0117, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0118 = {&lxb_unicode_entry_0118, &lxb_unicode_idna_map_0118};
static const lxb_unicode_data_t lxb_unicode_data_0119 = {&lxb_unicode_entry_0119, NULL};
static const lxb_unicode_data_t lxb_unicode_data_011A = {&lxb_unicode_entry_011A, &lxb_unicode_idna_map_011A};
static const lxb_unicode_data_t lxb_unicode_data_011B = {&lxb_unicode_entry_011B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_011C = {&lxb_unicode_entry_011C, &lxb_unicode_idna_map_011C};
static const lxb_unicode_data_t lxb_unicode_data_011D = {&lxb_unicode_entry_011D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_011E = {&lxb_unicode_entry_011E, &lxb_unicode_idna_map_011E};
static const lxb_unicode_data_t lxb_unicode_data_011F = {&lxb_unicode_entry_011F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0120 = {&lxb_unicode_entry_0120, &lxb_unicode_idna_map_0120};
static const lxb_unicode_data_t lxb_unicode_data_0121 = {&lxb_unicode_entry_0121, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0122 = {&lxb_unicode_entry_0122, &lxb_unicode_idna_map_0122};
static const lxb_unicode_data_t lxb_unicode_data_0123 = {&lxb_unicode_entry_0123, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0124 = {&lxb_unicode_entry_0124, &lxb_unicode_idna_map_0124};
static const lxb_unicode_data_t lxb_unicode_data_0125 = {&lxb_unicode_entry_0125, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0126 = {NULL, &lxb_unicode_idna_map_0126};
static const lxb_unicode_data_t lxb_unicode_data_0128 = {&lxb_unicode_entry_0128, &lxb_unicode_idna_map_0128};
static const lxb_unicode_data_t lxb_unicode_data_0129 = {&lxb_unicode_entry_0129, NULL};
static const lxb_unicode_data_t lxb_unicode_data_012A = {&lxb_unicode_entry_012A, &lxb_unicode_idna_map_012A};
static const lxb_unicode_data_t lxb_unicode_data_012B = {&lxb_unicode_entry_012B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_012C = {&lxb_unicode_entry_012C, &lxb_unicode_idna_map_012C};
static const lxb_unicode_data_t lxb_unicode_data_012D = {&lxb_unicode_entry_012D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_012E = {&lxb_unicode_entry_012E, &lxb_unicode_idna_map_012E};
static const lxb_unicode_data_t lxb_unicode_data_012F = {&lxb_unicode_entry_012F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0130 = {&lxb_unicode_entry_0130, &lxb_unicode_idna_map_0130};
static const lxb_unicode_data_t lxb_unicode_data_0132 = {&lxb_unicode_entry_0132, &lxb_unicode_idna_map_0132};
static const lxb_unicode_data_t lxb_unicode_data_0133 = {&lxb_unicode_entry_0133, &lxb_unicode_idna_map_0133};
static const lxb_unicode_data_t lxb_unicode_data_0134 = {&lxb_unicode_entry_0134, &lxb_unicode_idna_map_0134};
static const lxb_unicode_data_t lxb_unicode_data_0135 = {&lxb_unicode_entry_0135, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0136 = {&lxb_unicode_entry_0136, &lxb_unicode_idna_map_0136};
static const lxb_unicode_data_t lxb_unicode_data_0137 = {&lxb_unicode_entry_0137, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0139 = {&lxb_unicode_entry_0139, &lxb_unicode_idna_map_0139};
static const lxb_unicode_data_t lxb_unicode_data_013A = {&lxb_unicode_entry_013A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_013B = {&lxb_unicode_entry_013B, &lxb_unicode_idna_map_013B};
static const lxb_unicode_data_t lxb_unicode_data_013C = {&lxb_unicode_entry_013C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_013D = {&lxb_unicode_entry_013D, &lxb_unicode_idna_map_013D};
static const lxb_unicode_data_t lxb_unicode_data_013E = {&lxb_unicode_entry_013E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_013F = {&lxb_unicode_entry_013F, &lxb_unicode_idna_map_013F};
static const lxb_unicode_data_t lxb_unicode_data_0140 = {&lxb_unicode_entry_0140, &lxb_unicode_idna_map_0140};
static const lxb_unicode_data_t lxb_unicode_data_0141 = {NULL, &lxb_unicode_idna_map_0141};
static const lxb_unicode_data_t lxb_unicode_data_0143 = {&lxb_unicode_entry_0143, &lxb_unicode_idna_map_0143};
static const lxb_unicode_data_t lxb_unicode_data_0144 = {&lxb_unicode_entry_0144, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0145 = {&lxb_unicode_entry_0145, &lxb_unicode_idna_map_0145};
static const lxb_unicode_data_t lxb_unicode_data_0146 = {&lxb_unicode_entry_0146, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0147 = {&lxb_unicode_entry_0147, &lxb_unicode_idna_map_0147};
static const lxb_unicode_data_t lxb_unicode_data_0148 = {&lxb_unicode_entry_0148, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0149 = {&lxb_unicode_entry_0149, &lxb_unicode_idna_map_0149};
static const lxb_unicode_data_t lxb_unicode_data_014A = {NULL, &lxb_unicode_idna_map_014A};
static const lxb_unicode_data_t lxb_unicode_data_014C = {&lxb_unicode_entry_014C, &lxb_unicode_idna_map_014C};
static const lxb_unicode_data_t lxb_unicode_data_014D = {&lxb_unicode_entry_014D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_014E = {&lxb_unicode_entry_014E, &lxb_unicode_idna_map_014E};
static const lxb_unicode_data_t lxb_unicode_data_014F = {&lxb_unicode_entry_014F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0150 = {&lxb_unicode_entry_0150, &lxb_unicode_idna_map_0150};
static const lxb_unicode_data_t lxb_unicode_data_0151 = {&lxb_unicode_entry_0151, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0152 = {NULL, &lxb_unicode_idna_map_0152};
static const lxb_unicode_data_t lxb_unicode_data_0154 = {&lxb_unicode_entry_0154, &lxb_unicode_idna_map_0154};
static const lxb_unicode_data_t lxb_unicode_data_0155 = {&lxb_unicode_entry_0155, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0156 = {&lxb_unicode_entry_0156, &lxb_unicode_idna_map_0156};
static const lxb_unicode_data_t lxb_unicode_data_0157 = {&lxb_unicode_entry_0157, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0158 = {&lxb_unicode_entry_0158, &lxb_unicode_idna_map_0158};
static const lxb_unicode_data_t lxb_unicode_data_0159 = {&lxb_unicode_entry_0159, NULL};
static const lxb_unicode_data_t lxb_unicode_data_015A = {&lxb_unicode_entry_015A, &lxb_unicode_idna_map_015A};
static const lxb_unicode_data_t lxb_unicode_data_015B = {&lxb_unicode_entry_015B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_015C = {&lxb_unicode_entry_015C, &lxb_unicode_idna_map_015C};
static const lxb_unicode_data_t lxb_unicode_data_015D = {&lxb_unicode_entry_015D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_015E = {&lxb_unicode_entry_015E, &lxb_unicode_idna_map_015E};
static const lxb_unicode_data_t lxb_unicode_data_015F = {&lxb_unicode_entry_015F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0160 = {&lxb_unicode_entry_0160, &lxb_unicode_idna_map_0160};
static const lxb_unicode_data_t lxb_unicode_data_0161 = {&lxb_unicode_entry_0161, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0162 = {&lxb_unicode_entry_0162, &lxb_unicode_idna_map_0162};
static const lxb_unicode_data_t lxb_unicode_data_0163 = {&lxb_unicode_entry_0163, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0164 = {&lxb_unicode_entry_0164, &lxb_unicode_idna_map_0164};
static const lxb_unicode_data_t lxb_unicode_data_0165 = {&lxb_unicode_entry_0165, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0166 = {NULL, &lxb_unicode_idna_map_0166};
static const lxb_unicode_data_t lxb_unicode_data_0168 = {&lxb_unicode_entry_0168, &lxb_unicode_idna_map_0168};
static const lxb_unicode_data_t lxb_unicode_data_0169 = {&lxb_unicode_entry_0169, NULL};
static const lxb_unicode_data_t lxb_unicode_data_016A = {&lxb_unicode_entry_016A, &lxb_unicode_idna_map_016A};
static const lxb_unicode_data_t lxb_unicode_data_016B = {&lxb_unicode_entry_016B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_016C = {&lxb_unicode_entry_016C, &lxb_unicode_idna_map_016C};
static const lxb_unicode_data_t lxb_unicode_data_016D = {&lxb_unicode_entry_016D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_016E = {&lxb_unicode_entry_016E, &lxb_unicode_idna_map_016E};
static const lxb_unicode_data_t lxb_unicode_data_016F = {&lxb_unicode_entry_016F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0170 = {&lxb_unicode_entry_0170, &lxb_unicode_idna_map_0170};
static const lxb_unicode_data_t lxb_unicode_data_0171 = {&lxb_unicode_entry_0171, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0172 = {&lxb_unicode_entry_0172, &lxb_unicode_idna_map_0172};
static const lxb_unicode_data_t lxb_unicode_data_0173 = {&lxb_unicode_entry_0173, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0174 = {&lxb_unicode_entry_0174, &lxb_unicode_idna_map_0174};
static const lxb_unicode_data_t lxb_unicode_data_0175 = {&lxb_unicode_entry_0175, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0176 = {&lxb_unicode_entry_0176, &lxb_unicode_idna_map_0176};
static const lxb_unicode_data_t lxb_unicode_data_0177 = {&lxb_unicode_entry_0177, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0178 = {&lxb_unicode_entry_0178, &lxb_unicode_idna_map_0178};
static const lxb_unicode_data_t lxb_unicode_data_0179 = {&lxb_unicode_entry_0179, &lxb_unicode_idna_map_0179};
static const lxb_unicode_data_t lxb_unicode_data_017A = {&lxb_unicode_entry_017A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_017B = {&lxb_unicode_entry_017B, &lxb_unicode_idna_map_017B};
static const lxb_unicode_data_t lxb_unicode_data_017C = {&lxb_unicode_entry_017C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_017D = {&lxb_unicode_entry_017D, &lxb_unicode_idna_map_017D};
static const lxb_unicode_data_t lxb_unicode_data_017E = {&lxb_unicode_entry_017E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_017F = {&lxb_unicode_entry_017F, &lxb_unicode_idna_map_017F};
static const lxb_unicode_data_t lxb_unicode_data_0181 = {NULL, &lxb_unicode_idna_map_0181};
static const lxb_unicode_data_t lxb_unicode_data_0182 = {NULL, &lxb_unicode_idna_map_0182};
static const lxb_unicode_data_t lxb_unicode_data_0184 = {NULL, &lxb_unicode_idna_map_0184};
static const lxb_unicode_data_t lxb_unicode_data_0186 = {NULL, &lxb_unicode_idna_map_0186};
static const lxb_unicode_data_t lxb_unicode_data_0187 = {NULL, &lxb_unicode_idna_map_0187};
static const lxb_unicode_data_t lxb_unicode_data_0189 = {NULL, &lxb_unicode_idna_map_0189};
static const lxb_unicode_data_t lxb_unicode_data_018A = {NULL, &lxb_unicode_idna_map_018A};
static const lxb_unicode_data_t lxb_unicode_data_018B = {NULL, &lxb_unicode_idna_map_018B};
static const lxb_unicode_data_t lxb_unicode_data_018E = {NULL, &lxb_unicode_idna_map_018E};
static const lxb_unicode_data_t lxb_unicode_data_018F = {NULL, &lxb_unicode_idna_map_018F};
static const lxb_unicode_data_t lxb_unicode_data_0190 = {NULL, &lxb_unicode_idna_map_0190};
static const lxb_unicode_data_t lxb_unicode_data_0191 = {NULL, &lxb_unicode_idna_map_0191};
static const lxb_unicode_data_t lxb_unicode_data_0193 = {NULL, &lxb_unicode_idna_map_0193};
static const lxb_unicode_data_t lxb_unicode_data_0194 = {NULL, &lxb_unicode_idna_map_0194};
static const lxb_unicode_data_t lxb_unicode_data_0196 = {NULL, &lxb_unicode_idna_map_0196};
static const lxb_unicode_data_t lxb_unicode_data_0197 = {NULL, &lxb_unicode_idna_map_0197};
static const lxb_unicode_data_t lxb_unicode_data_0198 = {NULL, &lxb_unicode_idna_map_0198};
static const lxb_unicode_data_t lxb_unicode_data_019C = {NULL, &lxb_unicode_idna_map_019C};
static const lxb_unicode_data_t lxb_unicode_data_019D = {NULL, &lxb_unicode_idna_map_019D};
static const lxb_unicode_data_t lxb_unicode_data_019F = {NULL, &lxb_unicode_idna_map_019F};
static const lxb_unicode_data_t lxb_unicode_data_01A0 = {&lxb_unicode_entry_01A0, &lxb_unicode_idna_map_01A0};
static const lxb_unicode_data_t lxb_unicode_data_01A1 = {&lxb_unicode_entry_01A1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01A2 = {NULL, &lxb_unicode_idna_map_01A2};
static const lxb_unicode_data_t lxb_unicode_data_01A4 = {NULL, &lxb_unicode_idna_map_01A4};
static const lxb_unicode_data_t lxb_unicode_data_01A6 = {NULL, &lxb_unicode_idna_map_01A6};
static const lxb_unicode_data_t lxb_unicode_data_01A7 = {NULL, &lxb_unicode_idna_map_01A7};
static const lxb_unicode_data_t lxb_unicode_data_01A9 = {NULL, &lxb_unicode_idna_map_01A9};
static const lxb_unicode_data_t lxb_unicode_data_01AC = {NULL, &lxb_unicode_idna_map_01AC};
static const lxb_unicode_data_t lxb_unicode_data_01AE = {NULL, &lxb_unicode_idna_map_01AE};
static const lxb_unicode_data_t lxb_unicode_data_01AF = {&lxb_unicode_entry_01AF, &lxb_unicode_idna_map_01AF};
static const lxb_unicode_data_t lxb_unicode_data_01B0 = {&lxb_unicode_entry_01B0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01B1 = {NULL, &lxb_unicode_idna_map_01B1};
static const lxb_unicode_data_t lxb_unicode_data_01B2 = {NULL, &lxb_unicode_idna_map_01B2};
static const lxb_unicode_data_t lxb_unicode_data_01B3 = {NULL, &lxb_unicode_idna_map_01B3};
static const lxb_unicode_data_t lxb_unicode_data_01B5 = {NULL, &lxb_unicode_idna_map_01B5};
static const lxb_unicode_data_t lxb_unicode_data_01B7 = {NULL, &lxb_unicode_idna_map_01B7};
static const lxb_unicode_data_t lxb_unicode_data_01B8 = {NULL, &lxb_unicode_idna_map_01B8};
static const lxb_unicode_data_t lxb_unicode_data_01BC = {NULL, &lxb_unicode_idna_map_01BC};
static const lxb_unicode_data_t lxb_unicode_data_01C4 = {&lxb_unicode_entry_01C4, &lxb_unicode_idna_map_01C4};
static const lxb_unicode_data_t lxb_unicode_data_01C5 = {&lxb_unicode_entry_01C5, &lxb_unicode_idna_map_01C5};
static const lxb_unicode_data_t lxb_unicode_data_01C6 = {&lxb_unicode_entry_01C6, &lxb_unicode_idna_map_01C6};
static const lxb_unicode_data_t lxb_unicode_data_01C7 = {&lxb_unicode_entry_01C7, &lxb_unicode_idna_map_01C7};
static const lxb_unicode_data_t lxb_unicode_data_01C8 = {&lxb_unicode_entry_01C8, &lxb_unicode_idna_map_01C8};
static const lxb_unicode_data_t lxb_unicode_data_01C9 = {&lxb_unicode_entry_01C9, &lxb_unicode_idna_map_01C9};
static const lxb_unicode_data_t lxb_unicode_data_01CA = {&lxb_unicode_entry_01CA, &lxb_unicode_idna_map_01CA};
static const lxb_unicode_data_t lxb_unicode_data_01CB = {&lxb_unicode_entry_01CB, &lxb_unicode_idna_map_01CB};
static const lxb_unicode_data_t lxb_unicode_data_01CC = {&lxb_unicode_entry_01CC, &lxb_unicode_idna_map_01CC};
static const lxb_unicode_data_t lxb_unicode_data_01CD = {&lxb_unicode_entry_01CD, &lxb_unicode_idna_map_01CD};
static const lxb_unicode_data_t lxb_unicode_data_01CE = {&lxb_unicode_entry_01CE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01CF = {&lxb_unicode_entry_01CF, &lxb_unicode_idna_map_01CF};
static const lxb_unicode_data_t lxb_unicode_data_01D0 = {&lxb_unicode_entry_01D0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01D1 = {&lxb_unicode_entry_01D1, &lxb_unicode_idna_map_01D1};
static const lxb_unicode_data_t lxb_unicode_data_01D2 = {&lxb_unicode_entry_01D2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01D3 = {&lxb_unicode_entry_01D3, &lxb_unicode_idna_map_01D3};
static const lxb_unicode_data_t lxb_unicode_data_01D4 = {&lxb_unicode_entry_01D4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01D5 = {&lxb_unicode_entry_01D5, &lxb_unicode_idna_map_01D5};
static const lxb_unicode_data_t lxb_unicode_data_01D6 = {&lxb_unicode_entry_01D6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01D7 = {&lxb_unicode_entry_01D7, &lxb_unicode_idna_map_01D7};
static const lxb_unicode_data_t lxb_unicode_data_01D8 = {&lxb_unicode_entry_01D8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01D9 = {&lxb_unicode_entry_01D9, &lxb_unicode_idna_map_01D9};
static const lxb_unicode_data_t lxb_unicode_data_01DA = {&lxb_unicode_entry_01DA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01DB = {&lxb_unicode_entry_01DB, &lxb_unicode_idna_map_01DB};
static const lxb_unicode_data_t lxb_unicode_data_01DC = {&lxb_unicode_entry_01DC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01DE = {&lxb_unicode_entry_01DE, &lxb_unicode_idna_map_01DE};
static const lxb_unicode_data_t lxb_unicode_data_01DF = {&lxb_unicode_entry_01DF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01E0 = {&lxb_unicode_entry_01E0, &lxb_unicode_idna_map_01E0};
static const lxb_unicode_data_t lxb_unicode_data_01E1 = {&lxb_unicode_entry_01E1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01E2 = {&lxb_unicode_entry_01E2, &lxb_unicode_idna_map_01E2};
static const lxb_unicode_data_t lxb_unicode_data_01E3 = {&lxb_unicode_entry_01E3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01E4 = {NULL, &lxb_unicode_idna_map_01E4};
static const lxb_unicode_data_t lxb_unicode_data_01E6 = {&lxb_unicode_entry_01E6, &lxb_unicode_idna_map_01E6};
static const lxb_unicode_data_t lxb_unicode_data_01E7 = {&lxb_unicode_entry_01E7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01E8 = {&lxb_unicode_entry_01E8, &lxb_unicode_idna_map_01E8};
static const lxb_unicode_data_t lxb_unicode_data_01E9 = {&lxb_unicode_entry_01E9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01EA = {&lxb_unicode_entry_01EA, &lxb_unicode_idna_map_01EA};
static const lxb_unicode_data_t lxb_unicode_data_01EB = {&lxb_unicode_entry_01EB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01EC = {&lxb_unicode_entry_01EC, &lxb_unicode_idna_map_01EC};
static const lxb_unicode_data_t lxb_unicode_data_01ED = {&lxb_unicode_entry_01ED, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01EE = {&lxb_unicode_entry_01EE, &lxb_unicode_idna_map_01EE};
static const lxb_unicode_data_t lxb_unicode_data_01EF = {&lxb_unicode_entry_01EF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01F0 = {&lxb_unicode_entry_01F0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01F1 = {&lxb_unicode_entry_01F1, &lxb_unicode_idna_map_01F1};
static const lxb_unicode_data_t lxb_unicode_data_01F2 = {&lxb_unicode_entry_01F2, &lxb_unicode_idna_map_01F2};
static const lxb_unicode_data_t lxb_unicode_data_01F3 = {&lxb_unicode_entry_01F3, &lxb_unicode_idna_map_01F3};
static const lxb_unicode_data_t lxb_unicode_data_01F4 = {&lxb_unicode_entry_01F4, &lxb_unicode_idna_map_01F4};
static const lxb_unicode_data_t lxb_unicode_data_01F5 = {&lxb_unicode_entry_01F5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01F6 = {NULL, &lxb_unicode_idna_map_01F6};
static const lxb_unicode_data_t lxb_unicode_data_01F7 = {NULL, &lxb_unicode_idna_map_01F7};
static const lxb_unicode_data_t lxb_unicode_data_01F8 = {&lxb_unicode_entry_01F8, &lxb_unicode_idna_map_01F8};
static const lxb_unicode_data_t lxb_unicode_data_01F9 = {&lxb_unicode_entry_01F9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01FA = {&lxb_unicode_entry_01FA, &lxb_unicode_idna_map_01FA};
static const lxb_unicode_data_t lxb_unicode_data_01FB = {&lxb_unicode_entry_01FB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01FC = {&lxb_unicode_entry_01FC, &lxb_unicode_idna_map_01FC};
static const lxb_unicode_data_t lxb_unicode_data_01FD = {&lxb_unicode_entry_01FD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_01FE = {&lxb_unicode_entry_01FE, &lxb_unicode_idna_map_01FE};
static const lxb_unicode_data_t lxb_unicode_data_01FF = {&lxb_unicode_entry_01FF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0200 = {&lxb_unicode_entry_0200, &lxb_unicode_idna_map_0200};
static const lxb_unicode_data_t lxb_unicode_data_0201 = {&lxb_unicode_entry_0201, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0202 = {&lxb_unicode_entry_0202, &lxb_unicode_idna_map_0202};
static const lxb_unicode_data_t lxb_unicode_data_0203 = {&lxb_unicode_entry_0203, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0204 = {&lxb_unicode_entry_0204, &lxb_unicode_idna_map_0204};
static const lxb_unicode_data_t lxb_unicode_data_0205 = {&lxb_unicode_entry_0205, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0206 = {&lxb_unicode_entry_0206, &lxb_unicode_idna_map_0206};
static const lxb_unicode_data_t lxb_unicode_data_0207 = {&lxb_unicode_entry_0207, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0208 = {&lxb_unicode_entry_0208, &lxb_unicode_idna_map_0208};
static const lxb_unicode_data_t lxb_unicode_data_0209 = {&lxb_unicode_entry_0209, NULL};
static const lxb_unicode_data_t lxb_unicode_data_020A = {&lxb_unicode_entry_020A, &lxb_unicode_idna_map_020A};
static const lxb_unicode_data_t lxb_unicode_data_020B = {&lxb_unicode_entry_020B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_020C = {&lxb_unicode_entry_020C, &lxb_unicode_idna_map_020C};
static const lxb_unicode_data_t lxb_unicode_data_020D = {&lxb_unicode_entry_020D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_020E = {&lxb_unicode_entry_020E, &lxb_unicode_idna_map_020E};
static const lxb_unicode_data_t lxb_unicode_data_020F = {&lxb_unicode_entry_020F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0210 = {&lxb_unicode_entry_0210, &lxb_unicode_idna_map_0210};
static const lxb_unicode_data_t lxb_unicode_data_0211 = {&lxb_unicode_entry_0211, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0212 = {&lxb_unicode_entry_0212, &lxb_unicode_idna_map_0212};
static const lxb_unicode_data_t lxb_unicode_data_0213 = {&lxb_unicode_entry_0213, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0214 = {&lxb_unicode_entry_0214, &lxb_unicode_idna_map_0214};
static const lxb_unicode_data_t lxb_unicode_data_0215 = {&lxb_unicode_entry_0215, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0216 = {&lxb_unicode_entry_0216, &lxb_unicode_idna_map_0216};
static const lxb_unicode_data_t lxb_unicode_data_0217 = {&lxb_unicode_entry_0217, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0218 = {&lxb_unicode_entry_0218, &lxb_unicode_idna_map_0218};
static const lxb_unicode_data_t lxb_unicode_data_0219 = {&lxb_unicode_entry_0219, NULL};
static const lxb_unicode_data_t lxb_unicode_data_021A = {&lxb_unicode_entry_021A, &lxb_unicode_idna_map_021A};
static const lxb_unicode_data_t lxb_unicode_data_021B = {&lxb_unicode_entry_021B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_021C = {NULL, &lxb_unicode_idna_map_021C};
static const lxb_unicode_data_t lxb_unicode_data_021E = {&lxb_unicode_entry_021E, &lxb_unicode_idna_map_021E};
static const lxb_unicode_data_t lxb_unicode_data_021F = {&lxb_unicode_entry_021F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0220 = {NULL, &lxb_unicode_idna_map_0220};
static const lxb_unicode_data_t lxb_unicode_data_0222 = {NULL, &lxb_unicode_idna_map_0222};
static const lxb_unicode_data_t lxb_unicode_data_0224 = {NULL, &lxb_unicode_idna_map_0224};
static const lxb_unicode_data_t lxb_unicode_data_0226 = {&lxb_unicode_entry_0226, &lxb_unicode_idna_map_0226};
static const lxb_unicode_data_t lxb_unicode_data_0227 = {&lxb_unicode_entry_0227, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0228 = {&lxb_unicode_entry_0228, &lxb_unicode_idna_map_0228};
static const lxb_unicode_data_t lxb_unicode_data_0229 = {&lxb_unicode_entry_0229, NULL};
static const lxb_unicode_data_t lxb_unicode_data_022A = {&lxb_unicode_entry_022A, &lxb_unicode_idna_map_022A};
static const lxb_unicode_data_t lxb_unicode_data_022B = {&lxb_unicode_entry_022B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_022C = {&lxb_unicode_entry_022C, &lxb_unicode_idna_map_022C};
static const lxb_unicode_data_t lxb_unicode_data_022D = {&lxb_unicode_entry_022D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_022E = {&lxb_unicode_entry_022E, &lxb_unicode_idna_map_022E};
static const lxb_unicode_data_t lxb_unicode_data_022F = {&lxb_unicode_entry_022F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0230 = {&lxb_unicode_entry_0230, &lxb_unicode_idna_map_0230};
static const lxb_unicode_data_t lxb_unicode_data_0231 = {&lxb_unicode_entry_0231, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0232 = {&lxb_unicode_entry_0232, &lxb_unicode_idna_map_0232};
static const lxb_unicode_data_t lxb_unicode_data_0233 = {&lxb_unicode_entry_0233, NULL};
static const lxb_unicode_data_t lxb_unicode_data_023A = {NULL, &lxb_unicode_idna_map_023A};
static const lxb_unicode_data_t lxb_unicode_data_023B = {NULL, &lxb_unicode_idna_map_023B};
static const lxb_unicode_data_t lxb_unicode_data_023D = {NULL, &lxb_unicode_idna_map_023D};
static const lxb_unicode_data_t lxb_unicode_data_023E = {NULL, &lxb_unicode_idna_map_023E};
static const lxb_unicode_data_t lxb_unicode_data_0241 = {NULL, &lxb_unicode_idna_map_0241};
static const lxb_unicode_data_t lxb_unicode_data_0243 = {NULL, &lxb_unicode_idna_map_0243};
static const lxb_unicode_data_t lxb_unicode_data_0244 = {NULL, &lxb_unicode_idna_map_0244};
static const lxb_unicode_data_t lxb_unicode_data_0245 = {NULL, &lxb_unicode_idna_map_0245};
static const lxb_unicode_data_t lxb_unicode_data_0246 = {NULL, &lxb_unicode_idna_map_0246};
static const lxb_unicode_data_t lxb_unicode_data_0248 = {NULL, &lxb_unicode_idna_map_0248};
static const lxb_unicode_data_t lxb_unicode_data_024A = {NULL, &lxb_unicode_idna_map_024A};
static const lxb_unicode_data_t lxb_unicode_data_024C = {NULL, &lxb_unicode_idna_map_024C};
static const lxb_unicode_data_t lxb_unicode_data_024E = {NULL, &lxb_unicode_idna_map_024E};
static const lxb_unicode_data_t lxb_unicode_data_02B0 = {&lxb_unicode_entry_02B0, &lxb_unicode_idna_map_02B0};
static const lxb_unicode_data_t lxb_unicode_data_02B1 = {&lxb_unicode_entry_02B1, &lxb_unicode_idna_map_02B1};
static const lxb_unicode_data_t lxb_unicode_data_02B2 = {&lxb_unicode_entry_02B2, &lxb_unicode_idna_map_02B2};
static const lxb_unicode_data_t lxb_unicode_data_02B3 = {&lxb_unicode_entry_02B3, &lxb_unicode_idna_map_02B3};
static const lxb_unicode_data_t lxb_unicode_data_02B4 = {&lxb_unicode_entry_02B4, &lxb_unicode_idna_map_02B4};
static const lxb_unicode_data_t lxb_unicode_data_02B5 = {&lxb_unicode_entry_02B5, &lxb_unicode_idna_map_02B5};
static const lxb_unicode_data_t lxb_unicode_data_02B6 = {&lxb_unicode_entry_02B6, &lxb_unicode_idna_map_02B6};
static const lxb_unicode_data_t lxb_unicode_data_02B7 = {&lxb_unicode_entry_02B7, &lxb_unicode_idna_map_02B7};
static const lxb_unicode_data_t lxb_unicode_data_02B8 = {&lxb_unicode_entry_02B8, &lxb_unicode_idna_map_02B8};
static const lxb_unicode_data_t lxb_unicode_data_02D8 = {&lxb_unicode_entry_02D8, &lxb_unicode_idna_map_02D8};
static const lxb_unicode_data_t lxb_unicode_data_02D9 = {&lxb_unicode_entry_02D9, &lxb_unicode_idna_map_02D9};
static const lxb_unicode_data_t lxb_unicode_data_02DA = {&lxb_unicode_entry_02DA, &lxb_unicode_idna_map_02DA};
static const lxb_unicode_data_t lxb_unicode_data_02DB = {&lxb_unicode_entry_02DB, &lxb_unicode_idna_map_02DB};
static const lxb_unicode_data_t lxb_unicode_data_02DC = {&lxb_unicode_entry_02DC, &lxb_unicode_idna_map_02DC};
static const lxb_unicode_data_t lxb_unicode_data_02DD = {&lxb_unicode_entry_02DD, &lxb_unicode_idna_map_02DD};
static const lxb_unicode_data_t lxb_unicode_data_02E0 = {&lxb_unicode_entry_02E0, &lxb_unicode_idna_map_02E0};
static const lxb_unicode_data_t lxb_unicode_data_02E1 = {&lxb_unicode_entry_02E1, &lxb_unicode_idna_map_02E1};
static const lxb_unicode_data_t lxb_unicode_data_02E2 = {&lxb_unicode_entry_02E2, &lxb_unicode_idna_map_02E2};
static const lxb_unicode_data_t lxb_unicode_data_02E3 = {&lxb_unicode_entry_02E3, &lxb_unicode_idna_map_02E3};
static const lxb_unicode_data_t lxb_unicode_data_02E4 = {&lxb_unicode_entry_02E4, &lxb_unicode_idna_map_02E4};
static const lxb_unicode_data_t lxb_unicode_data_0300 = {&lxb_unicode_entry_0300, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0301 = {&lxb_unicode_entry_0301, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0302 = {&lxb_unicode_entry_0302, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0303 = {&lxb_unicode_entry_0303, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0304 = {&lxb_unicode_entry_0304, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0305 = {&lxb_unicode_entry_0305, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0306 = {&lxb_unicode_entry_0306, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0307 = {&lxb_unicode_entry_0307, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0308 = {&lxb_unicode_entry_0308, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0309 = {&lxb_unicode_entry_0309, NULL};
static const lxb_unicode_data_t lxb_unicode_data_030A = {&lxb_unicode_entry_030A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_030B = {&lxb_unicode_entry_030B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_030C = {&lxb_unicode_entry_030C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_030D = {&lxb_unicode_entry_030D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_030E = {&lxb_unicode_entry_030E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_030F = {&lxb_unicode_entry_030F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0310 = {&lxb_unicode_entry_0310, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0311 = {&lxb_unicode_entry_0311, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0312 = {&lxb_unicode_entry_0312, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0313 = {&lxb_unicode_entry_0313, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0314 = {&lxb_unicode_entry_0314, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0315 = {&lxb_unicode_entry_0315, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0316 = {&lxb_unicode_entry_0316, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0317 = {&lxb_unicode_entry_0317, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0318 = {&lxb_unicode_entry_0318, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0319 = {&lxb_unicode_entry_0319, NULL};
static const lxb_unicode_data_t lxb_unicode_data_031A = {&lxb_unicode_entry_031A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_031B = {&lxb_unicode_entry_031B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_031C = {&lxb_unicode_entry_031C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_031D = {&lxb_unicode_entry_031D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_031E = {&lxb_unicode_entry_031E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_031F = {&lxb_unicode_entry_031F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0320 = {&lxb_unicode_entry_0320, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0321 = {&lxb_unicode_entry_0321, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0322 = {&lxb_unicode_entry_0322, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0323 = {&lxb_unicode_entry_0323, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0324 = {&lxb_unicode_entry_0324, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0325 = {&lxb_unicode_entry_0325, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0326 = {&lxb_unicode_entry_0326, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0327 = {&lxb_unicode_entry_0327, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0328 = {&lxb_unicode_entry_0328, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0329 = {&lxb_unicode_entry_0329, NULL};
static const lxb_unicode_data_t lxb_unicode_data_032A = {&lxb_unicode_entry_032A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_032B = {&lxb_unicode_entry_032B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_032C = {&lxb_unicode_entry_032C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_032D = {&lxb_unicode_entry_032D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_032E = {&lxb_unicode_entry_032E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_032F = {&lxb_unicode_entry_032F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0330 = {&lxb_unicode_entry_0330, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0331 = {&lxb_unicode_entry_0331, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0332 = {&lxb_unicode_entry_0332, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0333 = {&lxb_unicode_entry_0333, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0334 = {&lxb_unicode_entry_0334, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0335 = {&lxb_unicode_entry_0335, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0336 = {&lxb_unicode_entry_0336, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0337 = {&lxb_unicode_entry_0337, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0338 = {&lxb_unicode_entry_0338, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0339 = {&lxb_unicode_entry_0339, NULL};
static const lxb_unicode_data_t lxb_unicode_data_033A = {&lxb_unicode_entry_033A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_033B = {&lxb_unicode_entry_033B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_033C = {&lxb_unicode_entry_033C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_033D = {&lxb_unicode_entry_033D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_033E = {&lxb_unicode_entry_033E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_033F = {&lxb_unicode_entry_033F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0340 = {&lxb_unicode_entry_0340, &lxb_unicode_idna_map_0340};
static const lxb_unicode_data_t lxb_unicode_data_0341 = {&lxb_unicode_entry_0341, &lxb_unicode_idna_map_0341};
static const lxb_unicode_data_t lxb_unicode_data_0342 = {&lxb_unicode_entry_0342, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0343 = {&lxb_unicode_entry_0343, &lxb_unicode_idna_map_0343};
static const lxb_unicode_data_t lxb_unicode_data_0344 = {&lxb_unicode_entry_0344, &lxb_unicode_idna_map_0344};
static const lxb_unicode_data_t lxb_unicode_data_0345 = {&lxb_unicode_entry_0345, &lxb_unicode_idna_map_0345};
static const lxb_unicode_data_t lxb_unicode_data_0346 = {&lxb_unicode_entry_0346, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0347 = {&lxb_unicode_entry_0347, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0348 = {&lxb_unicode_entry_0348, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0349 = {&lxb_unicode_entry_0349, NULL};
static const lxb_unicode_data_t lxb_unicode_data_034A = {&lxb_unicode_entry_034A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_034B = {&lxb_unicode_entry_034B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_034C = {&lxb_unicode_entry_034C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_034D = {&lxb_unicode_entry_034D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_034E = {&lxb_unicode_entry_034E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0350 = {&lxb_unicode_entry_0350, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0351 = {&lxb_unicode_entry_0351, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0352 = {&lxb_unicode_entry_0352, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0353 = {&lxb_unicode_entry_0353, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0354 = {&lxb_unicode_entry_0354, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0355 = {&lxb_unicode_entry_0355, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0356 = {&lxb_unicode_entry_0356, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0357 = {&lxb_unicode_entry_0357, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0358 = {&lxb_unicode_entry_0358, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0359 = {&lxb_unicode_entry_0359, NULL};
static const lxb_unicode_data_t lxb_unicode_data_035A = {&lxb_unicode_entry_035A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_035B = {&lxb_unicode_entry_035B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_035C = {&lxb_unicode_entry_035C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_035D = {&lxb_unicode_entry_035D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_035E = {&lxb_unicode_entry_035E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_035F = {&lxb_unicode_entry_035F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0360 = {&lxb_unicode_entry_0360, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0361 = {&lxb_unicode_entry_0361, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0362 = {&lxb_unicode_entry_0362, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0363 = {&lxb_unicode_entry_0363, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0364 = {&lxb_unicode_entry_0364, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0365 = {&lxb_unicode_entry_0365, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0366 = {&lxb_unicode_entry_0366, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0367 = {&lxb_unicode_entry_0367, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0368 = {&lxb_unicode_entry_0368, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0369 = {&lxb_unicode_entry_0369, NULL};
static const lxb_unicode_data_t lxb_unicode_data_036A = {&lxb_unicode_entry_036A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_036B = {&lxb_unicode_entry_036B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_036C = {&lxb_unicode_entry_036C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_036D = {&lxb_unicode_entry_036D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_036E = {&lxb_unicode_entry_036E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_036F = {&lxb_unicode_entry_036F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0370 = {NULL, &lxb_unicode_idna_map_0370};
static const lxb_unicode_data_t lxb_unicode_data_0372 = {NULL, &lxb_unicode_idna_map_0372};
static const lxb_unicode_data_t lxb_unicode_data_0374 = {&lxb_unicode_entry_0374, &lxb_unicode_idna_map_0374};
static const lxb_unicode_data_t lxb_unicode_data_0376 = {NULL, &lxb_unicode_idna_map_0376};
static const lxb_unicode_data_t lxb_unicode_data_037A = {&lxb_unicode_entry_037A, &lxb_unicode_idna_map_037A};
static const lxb_unicode_data_t lxb_unicode_data_037E = {&lxb_unicode_entry_037E, &lxb_unicode_idna_map_037E};
static const lxb_unicode_data_t lxb_unicode_data_037F = {NULL, &lxb_unicode_idna_map_037F};
static const lxb_unicode_data_t lxb_unicode_data_0384 = {&lxb_unicode_entry_0384, &lxb_unicode_idna_map_0384};
static const lxb_unicode_data_t lxb_unicode_data_0385 = {&lxb_unicode_entry_0385, &lxb_unicode_idna_map_0385};
static const lxb_unicode_data_t lxb_unicode_data_0386 = {&lxb_unicode_entry_0386, &lxb_unicode_idna_map_0386};
static const lxb_unicode_data_t lxb_unicode_data_0387 = {&lxb_unicode_entry_0387, &lxb_unicode_idna_map_0387};
static const lxb_unicode_data_t lxb_unicode_data_0388 = {&lxb_unicode_entry_0388, &lxb_unicode_idna_map_0388};
static const lxb_unicode_data_t lxb_unicode_data_0389 = {&lxb_unicode_entry_0389, &lxb_unicode_idna_map_0389};
static const lxb_unicode_data_t lxb_unicode_data_038A = {&lxb_unicode_entry_038A, &lxb_unicode_idna_map_038A};
static const lxb_unicode_data_t lxb_unicode_data_038C = {&lxb_unicode_entry_038C, &lxb_unicode_idna_map_038C};
static const lxb_unicode_data_t lxb_unicode_data_038E = {&lxb_unicode_entry_038E, &lxb_unicode_idna_map_038E};
static const lxb_unicode_data_t lxb_unicode_data_038F = {&lxb_unicode_entry_038F, &lxb_unicode_idna_map_038F};
static const lxb_unicode_data_t lxb_unicode_data_0390 = {&lxb_unicode_entry_0390, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0391 = {NULL, &lxb_unicode_idna_map_0391};
static const lxb_unicode_data_t lxb_unicode_data_0392 = {NULL, &lxb_unicode_idna_map_0392};
static const lxb_unicode_data_t lxb_unicode_data_0393 = {NULL, &lxb_unicode_idna_map_0393};
static const lxb_unicode_data_t lxb_unicode_data_0394 = {NULL, &lxb_unicode_idna_map_0394};
static const lxb_unicode_data_t lxb_unicode_data_0395 = {NULL, &lxb_unicode_idna_map_0395};
static const lxb_unicode_data_t lxb_unicode_data_0396 = {NULL, &lxb_unicode_idna_map_0396};
static const lxb_unicode_data_t lxb_unicode_data_0397 = {NULL, &lxb_unicode_idna_map_0397};
static const lxb_unicode_data_t lxb_unicode_data_0398 = {NULL, &lxb_unicode_idna_map_0398};
static const lxb_unicode_data_t lxb_unicode_data_0399 = {NULL, &lxb_unicode_idna_map_0399};
static const lxb_unicode_data_t lxb_unicode_data_039A = {NULL, &lxb_unicode_idna_map_039A};
static const lxb_unicode_data_t lxb_unicode_data_039B = {NULL, &lxb_unicode_idna_map_039B};
static const lxb_unicode_data_t lxb_unicode_data_039C = {NULL, &lxb_unicode_idna_map_039C};
static const lxb_unicode_data_t lxb_unicode_data_039D = {NULL, &lxb_unicode_idna_map_039D};
static const lxb_unicode_data_t lxb_unicode_data_039E = {NULL, &lxb_unicode_idna_map_039E};
static const lxb_unicode_data_t lxb_unicode_data_039F = {NULL, &lxb_unicode_idna_map_039F};
static const lxb_unicode_data_t lxb_unicode_data_03A0 = {NULL, &lxb_unicode_idna_map_03A0};
static const lxb_unicode_data_t lxb_unicode_data_03A1 = {NULL, &lxb_unicode_idna_map_03A1};
static const lxb_unicode_data_t lxb_unicode_data_03A3 = {NULL, &lxb_unicode_idna_map_03A3};
static const lxb_unicode_data_t lxb_unicode_data_03A4 = {NULL, &lxb_unicode_idna_map_03A4};
static const lxb_unicode_data_t lxb_unicode_data_03A5 = {NULL, &lxb_unicode_idna_map_03A5};
static const lxb_unicode_data_t lxb_unicode_data_03A6 = {NULL, &lxb_unicode_idna_map_03A6};
static const lxb_unicode_data_t lxb_unicode_data_03A7 = {NULL, &lxb_unicode_idna_map_03A7};
static const lxb_unicode_data_t lxb_unicode_data_03A8 = {NULL, &lxb_unicode_idna_map_03A8};
static const lxb_unicode_data_t lxb_unicode_data_03A9 = {NULL, &lxb_unicode_idna_map_03A9};
static const lxb_unicode_data_t lxb_unicode_data_03AA = {&lxb_unicode_entry_03AA, &lxb_unicode_idna_map_03AA};
static const lxb_unicode_data_t lxb_unicode_data_03AB = {&lxb_unicode_entry_03AB, &lxb_unicode_idna_map_03AB};
static const lxb_unicode_data_t lxb_unicode_data_03AC = {&lxb_unicode_entry_03AC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_03AD = {&lxb_unicode_entry_03AD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_03AE = {&lxb_unicode_entry_03AE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_03AF = {&lxb_unicode_entry_03AF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_03B0 = {&lxb_unicode_entry_03B0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_03C2 = {NULL, &lxb_unicode_idna_map_03C2};
static const lxb_unicode_data_t lxb_unicode_data_03CA = {&lxb_unicode_entry_03CA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_03CB = {&lxb_unicode_entry_03CB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_03CC = {&lxb_unicode_entry_03CC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_03CD = {&lxb_unicode_entry_03CD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_03CE = {&lxb_unicode_entry_03CE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_03CF = {NULL, &lxb_unicode_idna_map_03CF};
static const lxb_unicode_data_t lxb_unicode_data_03D0 = {&lxb_unicode_entry_03D0, &lxb_unicode_idna_map_03D0};
static const lxb_unicode_data_t lxb_unicode_data_03D1 = {&lxb_unicode_entry_03D1, &lxb_unicode_idna_map_03D1};
static const lxb_unicode_data_t lxb_unicode_data_03D2 = {&lxb_unicode_entry_03D2, &lxb_unicode_idna_map_03D2};
static const lxb_unicode_data_t lxb_unicode_data_03D3 = {&lxb_unicode_entry_03D3, &lxb_unicode_idna_map_03D3};
static const lxb_unicode_data_t lxb_unicode_data_03D4 = {&lxb_unicode_entry_03D4, &lxb_unicode_idna_map_03D4};
static const lxb_unicode_data_t lxb_unicode_data_03D5 = {&lxb_unicode_entry_03D5, &lxb_unicode_idna_map_03D5};
static const lxb_unicode_data_t lxb_unicode_data_03D6 = {&lxb_unicode_entry_03D6, &lxb_unicode_idna_map_03D6};
static const lxb_unicode_data_t lxb_unicode_data_03D8 = {NULL, &lxb_unicode_idna_map_03D8};
static const lxb_unicode_data_t lxb_unicode_data_03DA = {NULL, &lxb_unicode_idna_map_03DA};
static const lxb_unicode_data_t lxb_unicode_data_03DC = {NULL, &lxb_unicode_idna_map_03DC};
static const lxb_unicode_data_t lxb_unicode_data_03DE = {NULL, &lxb_unicode_idna_map_03DE};
static const lxb_unicode_data_t lxb_unicode_data_03E0 = {NULL, &lxb_unicode_idna_map_03E0};
static const lxb_unicode_data_t lxb_unicode_data_03E2 = {NULL, &lxb_unicode_idna_map_03E2};
static const lxb_unicode_data_t lxb_unicode_data_03E4 = {NULL, &lxb_unicode_idna_map_03E4};
static const lxb_unicode_data_t lxb_unicode_data_03E6 = {NULL, &lxb_unicode_idna_map_03E6};
static const lxb_unicode_data_t lxb_unicode_data_03E8 = {NULL, &lxb_unicode_idna_map_03E8};
static const lxb_unicode_data_t lxb_unicode_data_03EA = {NULL, &lxb_unicode_idna_map_03EA};
static const lxb_unicode_data_t lxb_unicode_data_03EC = {NULL, &lxb_unicode_idna_map_03EC};
static const lxb_unicode_data_t lxb_unicode_data_03EE = {NULL, &lxb_unicode_idna_map_03EE};
static const lxb_unicode_data_t lxb_unicode_data_03F0 = {&lxb_unicode_entry_03F0, &lxb_unicode_idna_map_03F0};
static const lxb_unicode_data_t lxb_unicode_data_03F1 = {&lxb_unicode_entry_03F1, &lxb_unicode_idna_map_03F1};
static const lxb_unicode_data_t lxb_unicode_data_03F2 = {&lxb_unicode_entry_03F2, &lxb_unicode_idna_map_03F2};
static const lxb_unicode_data_t lxb_unicode_data_03F4 = {&lxb_unicode_entry_03F4, &lxb_unicode_idna_map_03F4};
static const lxb_unicode_data_t lxb_unicode_data_03F5 = {&lxb_unicode_entry_03F5, &lxb_unicode_idna_map_03F5};
static const lxb_unicode_data_t lxb_unicode_data_03F7 = {NULL, &lxb_unicode_idna_map_03F7};
static const lxb_unicode_data_t lxb_unicode_data_03F9 = {&lxb_unicode_entry_03F9, &lxb_unicode_idna_map_03F9};
static const lxb_unicode_data_t lxb_unicode_data_03FA = {NULL, &lxb_unicode_idna_map_03FA};
static const lxb_unicode_data_t lxb_unicode_data_03FD = {NULL, &lxb_unicode_idna_map_03FD};
static const lxb_unicode_data_t lxb_unicode_data_03FE = {NULL, &lxb_unicode_idna_map_03FE};
static const lxb_unicode_data_t lxb_unicode_data_03FF = {NULL, &lxb_unicode_idna_map_03FF};
static const lxb_unicode_data_t lxb_unicode_data_0400 = {&lxb_unicode_entry_0400, &lxb_unicode_idna_map_0400};
static const lxb_unicode_data_t lxb_unicode_data_0401 = {&lxb_unicode_entry_0401, &lxb_unicode_idna_map_0401};
static const lxb_unicode_data_t lxb_unicode_data_0402 = {NULL, &lxb_unicode_idna_map_0402};
static const lxb_unicode_data_t lxb_unicode_data_0403 = {&lxb_unicode_entry_0403, &lxb_unicode_idna_map_0403};
static const lxb_unicode_data_t lxb_unicode_data_0404 = {NULL, &lxb_unicode_idna_map_0404};
static const lxb_unicode_data_t lxb_unicode_data_0405 = {NULL, &lxb_unicode_idna_map_0405};
static const lxb_unicode_data_t lxb_unicode_data_0406 = {NULL, &lxb_unicode_idna_map_0406};
static const lxb_unicode_data_t lxb_unicode_data_0407 = {&lxb_unicode_entry_0407, &lxb_unicode_idna_map_0407};
static const lxb_unicode_data_t lxb_unicode_data_0408 = {NULL, &lxb_unicode_idna_map_0408};
static const lxb_unicode_data_t lxb_unicode_data_0409 = {NULL, &lxb_unicode_idna_map_0409};
static const lxb_unicode_data_t lxb_unicode_data_040A = {NULL, &lxb_unicode_idna_map_040A};
static const lxb_unicode_data_t lxb_unicode_data_040B = {NULL, &lxb_unicode_idna_map_040B};
static const lxb_unicode_data_t lxb_unicode_data_040C = {&lxb_unicode_entry_040C, &lxb_unicode_idna_map_040C};
static const lxb_unicode_data_t lxb_unicode_data_040D = {&lxb_unicode_entry_040D, &lxb_unicode_idna_map_040D};
static const lxb_unicode_data_t lxb_unicode_data_040E = {&lxb_unicode_entry_040E, &lxb_unicode_idna_map_040E};
static const lxb_unicode_data_t lxb_unicode_data_040F = {NULL, &lxb_unicode_idna_map_040F};
static const lxb_unicode_data_t lxb_unicode_data_0410 = {NULL, &lxb_unicode_idna_map_0410};
static const lxb_unicode_data_t lxb_unicode_data_0411 = {NULL, &lxb_unicode_idna_map_0411};
static const lxb_unicode_data_t lxb_unicode_data_0412 = {NULL, &lxb_unicode_idna_map_0412};
static const lxb_unicode_data_t lxb_unicode_data_0413 = {NULL, &lxb_unicode_idna_map_0413};
static const lxb_unicode_data_t lxb_unicode_data_0414 = {NULL, &lxb_unicode_idna_map_0414};
static const lxb_unicode_data_t lxb_unicode_data_0415 = {NULL, &lxb_unicode_idna_map_0415};
static const lxb_unicode_data_t lxb_unicode_data_0416 = {NULL, &lxb_unicode_idna_map_0416};
static const lxb_unicode_data_t lxb_unicode_data_0417 = {NULL, &lxb_unicode_idna_map_0417};
static const lxb_unicode_data_t lxb_unicode_data_0418 = {NULL, &lxb_unicode_idna_map_0418};
static const lxb_unicode_data_t lxb_unicode_data_0419 = {&lxb_unicode_entry_0419, &lxb_unicode_idna_map_0419};
static const lxb_unicode_data_t lxb_unicode_data_041A = {NULL, &lxb_unicode_idna_map_041A};
static const lxb_unicode_data_t lxb_unicode_data_041B = {NULL, &lxb_unicode_idna_map_041B};
static const lxb_unicode_data_t lxb_unicode_data_041C = {NULL, &lxb_unicode_idna_map_041C};
static const lxb_unicode_data_t lxb_unicode_data_041D = {NULL, &lxb_unicode_idna_map_041D};
static const lxb_unicode_data_t lxb_unicode_data_041E = {NULL, &lxb_unicode_idna_map_041E};
static const lxb_unicode_data_t lxb_unicode_data_041F = {NULL, &lxb_unicode_idna_map_041F};
static const lxb_unicode_data_t lxb_unicode_data_0420 = {NULL, &lxb_unicode_idna_map_0420};
static const lxb_unicode_data_t lxb_unicode_data_0421 = {NULL, &lxb_unicode_idna_map_0421};
static const lxb_unicode_data_t lxb_unicode_data_0422 = {NULL, &lxb_unicode_idna_map_0422};
static const lxb_unicode_data_t lxb_unicode_data_0423 = {NULL, &lxb_unicode_idna_map_0423};
static const lxb_unicode_data_t lxb_unicode_data_0424 = {NULL, &lxb_unicode_idna_map_0424};
static const lxb_unicode_data_t lxb_unicode_data_0425 = {NULL, &lxb_unicode_idna_map_0425};
static const lxb_unicode_data_t lxb_unicode_data_0426 = {NULL, &lxb_unicode_idna_map_0426};
static const lxb_unicode_data_t lxb_unicode_data_0427 = {NULL, &lxb_unicode_idna_map_0427};
static const lxb_unicode_data_t lxb_unicode_data_0428 = {NULL, &lxb_unicode_idna_map_0428};
static const lxb_unicode_data_t lxb_unicode_data_0429 = {NULL, &lxb_unicode_idna_map_0429};
static const lxb_unicode_data_t lxb_unicode_data_042A = {NULL, &lxb_unicode_idna_map_042A};
static const lxb_unicode_data_t lxb_unicode_data_042B = {NULL, &lxb_unicode_idna_map_042B};
static const lxb_unicode_data_t lxb_unicode_data_042C = {NULL, &lxb_unicode_idna_map_042C};
static const lxb_unicode_data_t lxb_unicode_data_042D = {NULL, &lxb_unicode_idna_map_042D};
static const lxb_unicode_data_t lxb_unicode_data_042E = {NULL, &lxb_unicode_idna_map_042E};
static const lxb_unicode_data_t lxb_unicode_data_042F = {NULL, &lxb_unicode_idna_map_042F};
static const lxb_unicode_data_t lxb_unicode_data_0439 = {&lxb_unicode_entry_0439, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0450 = {&lxb_unicode_entry_0450, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0451 = {&lxb_unicode_entry_0451, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0453 = {&lxb_unicode_entry_0453, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0457 = {&lxb_unicode_entry_0457, NULL};
static const lxb_unicode_data_t lxb_unicode_data_045C = {&lxb_unicode_entry_045C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_045D = {&lxb_unicode_entry_045D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_045E = {&lxb_unicode_entry_045E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0460 = {NULL, &lxb_unicode_idna_map_0460};
static const lxb_unicode_data_t lxb_unicode_data_0462 = {NULL, &lxb_unicode_idna_map_0462};
static const lxb_unicode_data_t lxb_unicode_data_0464 = {NULL, &lxb_unicode_idna_map_0464};
static const lxb_unicode_data_t lxb_unicode_data_0466 = {NULL, &lxb_unicode_idna_map_0466};
static const lxb_unicode_data_t lxb_unicode_data_0468 = {NULL, &lxb_unicode_idna_map_0468};
static const lxb_unicode_data_t lxb_unicode_data_046A = {NULL, &lxb_unicode_idna_map_046A};
static const lxb_unicode_data_t lxb_unicode_data_046C = {NULL, &lxb_unicode_idna_map_046C};
static const lxb_unicode_data_t lxb_unicode_data_046E = {NULL, &lxb_unicode_idna_map_046E};
static const lxb_unicode_data_t lxb_unicode_data_0470 = {NULL, &lxb_unicode_idna_map_0470};
static const lxb_unicode_data_t lxb_unicode_data_0472 = {NULL, &lxb_unicode_idna_map_0472};
static const lxb_unicode_data_t lxb_unicode_data_0474 = {NULL, &lxb_unicode_idna_map_0474};
static const lxb_unicode_data_t lxb_unicode_data_0476 = {&lxb_unicode_entry_0476, &lxb_unicode_idna_map_0476};
static const lxb_unicode_data_t lxb_unicode_data_0477 = {&lxb_unicode_entry_0477, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0478 = {NULL, &lxb_unicode_idna_map_0478};
static const lxb_unicode_data_t lxb_unicode_data_047A = {NULL, &lxb_unicode_idna_map_047A};
static const lxb_unicode_data_t lxb_unicode_data_047C = {NULL, &lxb_unicode_idna_map_047C};
static const lxb_unicode_data_t lxb_unicode_data_047E = {NULL, &lxb_unicode_idna_map_047E};
static const lxb_unicode_data_t lxb_unicode_data_0480 = {NULL, &lxb_unicode_idna_map_0480};
static const lxb_unicode_data_t lxb_unicode_data_0483 = {&lxb_unicode_entry_0483, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0484 = {&lxb_unicode_entry_0484, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0485 = {&lxb_unicode_entry_0485, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0486 = {&lxb_unicode_entry_0486, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0487 = {&lxb_unicode_entry_0487, NULL};
static const lxb_unicode_data_t lxb_unicode_data_048A = {NULL, &lxb_unicode_idna_map_048A};
static const lxb_unicode_data_t lxb_unicode_data_048C = {NULL, &lxb_unicode_idna_map_048C};
static const lxb_unicode_data_t lxb_unicode_data_048E = {NULL, &lxb_unicode_idna_map_048E};
static const lxb_unicode_data_t lxb_unicode_data_0490 = {NULL, &lxb_unicode_idna_map_0490};
static const lxb_unicode_data_t lxb_unicode_data_0492 = {NULL, &lxb_unicode_idna_map_0492};
static const lxb_unicode_data_t lxb_unicode_data_0494 = {NULL, &lxb_unicode_idna_map_0494};
static const lxb_unicode_data_t lxb_unicode_data_0496 = {NULL, &lxb_unicode_idna_map_0496};
static const lxb_unicode_data_t lxb_unicode_data_0498 = {NULL, &lxb_unicode_idna_map_0498};
static const lxb_unicode_data_t lxb_unicode_data_049A = {NULL, &lxb_unicode_idna_map_049A};
static const lxb_unicode_data_t lxb_unicode_data_049C = {NULL, &lxb_unicode_idna_map_049C};
static const lxb_unicode_data_t lxb_unicode_data_049E = {NULL, &lxb_unicode_idna_map_049E};
static const lxb_unicode_data_t lxb_unicode_data_04A0 = {NULL, &lxb_unicode_idna_map_04A0};
static const lxb_unicode_data_t lxb_unicode_data_04A2 = {NULL, &lxb_unicode_idna_map_04A2};
static const lxb_unicode_data_t lxb_unicode_data_04A4 = {NULL, &lxb_unicode_idna_map_04A4};
static const lxb_unicode_data_t lxb_unicode_data_04A6 = {NULL, &lxb_unicode_idna_map_04A6};
static const lxb_unicode_data_t lxb_unicode_data_04A8 = {NULL, &lxb_unicode_idna_map_04A8};
static const lxb_unicode_data_t lxb_unicode_data_04AA = {NULL, &lxb_unicode_idna_map_04AA};
static const lxb_unicode_data_t lxb_unicode_data_04AC = {NULL, &lxb_unicode_idna_map_04AC};
static const lxb_unicode_data_t lxb_unicode_data_04AE = {NULL, &lxb_unicode_idna_map_04AE};
static const lxb_unicode_data_t lxb_unicode_data_04B0 = {NULL, &lxb_unicode_idna_map_04B0};
static const lxb_unicode_data_t lxb_unicode_data_04B2 = {NULL, &lxb_unicode_idna_map_04B2};
static const lxb_unicode_data_t lxb_unicode_data_04B4 = {NULL, &lxb_unicode_idna_map_04B4};
static const lxb_unicode_data_t lxb_unicode_data_04B6 = {NULL, &lxb_unicode_idna_map_04B6};
static const lxb_unicode_data_t lxb_unicode_data_04B8 = {NULL, &lxb_unicode_idna_map_04B8};
static const lxb_unicode_data_t lxb_unicode_data_04BA = {NULL, &lxb_unicode_idna_map_04BA};
static const lxb_unicode_data_t lxb_unicode_data_04BC = {NULL, &lxb_unicode_idna_map_04BC};
static const lxb_unicode_data_t lxb_unicode_data_04BE = {NULL, &lxb_unicode_idna_map_04BE};
static const lxb_unicode_data_t lxb_unicode_data_04C1 = {&lxb_unicode_entry_04C1, &lxb_unicode_idna_map_04C1};
static const lxb_unicode_data_t lxb_unicode_data_04C2 = {&lxb_unicode_entry_04C2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04C3 = {NULL, &lxb_unicode_idna_map_04C3};
static const lxb_unicode_data_t lxb_unicode_data_04C5 = {NULL, &lxb_unicode_idna_map_04C5};
static const lxb_unicode_data_t lxb_unicode_data_04C7 = {NULL, &lxb_unicode_idna_map_04C7};
static const lxb_unicode_data_t lxb_unicode_data_04C9 = {NULL, &lxb_unicode_idna_map_04C9};
static const lxb_unicode_data_t lxb_unicode_data_04CB = {NULL, &lxb_unicode_idna_map_04CB};
static const lxb_unicode_data_t lxb_unicode_data_04CD = {NULL, &lxb_unicode_idna_map_04CD};
static const lxb_unicode_data_t lxb_unicode_data_04D0 = {&lxb_unicode_entry_04D0, &lxb_unicode_idna_map_04D0};
static const lxb_unicode_data_t lxb_unicode_data_04D1 = {&lxb_unicode_entry_04D1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04D2 = {&lxb_unicode_entry_04D2, &lxb_unicode_idna_map_04D2};
static const lxb_unicode_data_t lxb_unicode_data_04D3 = {&lxb_unicode_entry_04D3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04D4 = {NULL, &lxb_unicode_idna_map_04D4};
static const lxb_unicode_data_t lxb_unicode_data_04D6 = {&lxb_unicode_entry_04D6, &lxb_unicode_idna_map_04D6};
static const lxb_unicode_data_t lxb_unicode_data_04D7 = {&lxb_unicode_entry_04D7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04D8 = {NULL, &lxb_unicode_idna_map_04D8};
static const lxb_unicode_data_t lxb_unicode_data_04DA = {&lxb_unicode_entry_04DA, &lxb_unicode_idna_map_04DA};
static const lxb_unicode_data_t lxb_unicode_data_04DB = {&lxb_unicode_entry_04DB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04DC = {&lxb_unicode_entry_04DC, &lxb_unicode_idna_map_04DC};
static const lxb_unicode_data_t lxb_unicode_data_04DD = {&lxb_unicode_entry_04DD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04DE = {&lxb_unicode_entry_04DE, &lxb_unicode_idna_map_04DE};
static const lxb_unicode_data_t lxb_unicode_data_04DF = {&lxb_unicode_entry_04DF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04E0 = {NULL, &lxb_unicode_idna_map_04E0};
static const lxb_unicode_data_t lxb_unicode_data_04E2 = {&lxb_unicode_entry_04E2, &lxb_unicode_idna_map_04E2};
static const lxb_unicode_data_t lxb_unicode_data_04E3 = {&lxb_unicode_entry_04E3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04E4 = {&lxb_unicode_entry_04E4, &lxb_unicode_idna_map_04E4};
static const lxb_unicode_data_t lxb_unicode_data_04E5 = {&lxb_unicode_entry_04E5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04E6 = {&lxb_unicode_entry_04E6, &lxb_unicode_idna_map_04E6};
static const lxb_unicode_data_t lxb_unicode_data_04E7 = {&lxb_unicode_entry_04E7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04E8 = {NULL, &lxb_unicode_idna_map_04E8};
static const lxb_unicode_data_t lxb_unicode_data_04EA = {&lxb_unicode_entry_04EA, &lxb_unicode_idna_map_04EA};
static const lxb_unicode_data_t lxb_unicode_data_04EB = {&lxb_unicode_entry_04EB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04EC = {&lxb_unicode_entry_04EC, &lxb_unicode_idna_map_04EC};
static const lxb_unicode_data_t lxb_unicode_data_04ED = {&lxb_unicode_entry_04ED, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04EE = {&lxb_unicode_entry_04EE, &lxb_unicode_idna_map_04EE};
static const lxb_unicode_data_t lxb_unicode_data_04EF = {&lxb_unicode_entry_04EF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04F0 = {&lxb_unicode_entry_04F0, &lxb_unicode_idna_map_04F0};
static const lxb_unicode_data_t lxb_unicode_data_04F1 = {&lxb_unicode_entry_04F1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04F2 = {&lxb_unicode_entry_04F2, &lxb_unicode_idna_map_04F2};
static const lxb_unicode_data_t lxb_unicode_data_04F3 = {&lxb_unicode_entry_04F3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04F4 = {&lxb_unicode_entry_04F4, &lxb_unicode_idna_map_04F4};
static const lxb_unicode_data_t lxb_unicode_data_04F5 = {&lxb_unicode_entry_04F5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04F6 = {NULL, &lxb_unicode_idna_map_04F6};
static const lxb_unicode_data_t lxb_unicode_data_04F8 = {&lxb_unicode_entry_04F8, &lxb_unicode_idna_map_04F8};
static const lxb_unicode_data_t lxb_unicode_data_04F9 = {&lxb_unicode_entry_04F9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_04FA = {NULL, &lxb_unicode_idna_map_04FA};
static const lxb_unicode_data_t lxb_unicode_data_04FC = {NULL, &lxb_unicode_idna_map_04FC};
static const lxb_unicode_data_t lxb_unicode_data_04FE = {NULL, &lxb_unicode_idna_map_04FE};
static const lxb_unicode_data_t lxb_unicode_data_0500 = {NULL, &lxb_unicode_idna_map_0500};
static const lxb_unicode_data_t lxb_unicode_data_0502 = {NULL, &lxb_unicode_idna_map_0502};
static const lxb_unicode_data_t lxb_unicode_data_0504 = {NULL, &lxb_unicode_idna_map_0504};
static const lxb_unicode_data_t lxb_unicode_data_0506 = {NULL, &lxb_unicode_idna_map_0506};
static const lxb_unicode_data_t lxb_unicode_data_0508 = {NULL, &lxb_unicode_idna_map_0508};
static const lxb_unicode_data_t lxb_unicode_data_050A = {NULL, &lxb_unicode_idna_map_050A};
static const lxb_unicode_data_t lxb_unicode_data_050C = {NULL, &lxb_unicode_idna_map_050C};
static const lxb_unicode_data_t lxb_unicode_data_050E = {NULL, &lxb_unicode_idna_map_050E};
static const lxb_unicode_data_t lxb_unicode_data_0510 = {NULL, &lxb_unicode_idna_map_0510};
static const lxb_unicode_data_t lxb_unicode_data_0512 = {NULL, &lxb_unicode_idna_map_0512};
static const lxb_unicode_data_t lxb_unicode_data_0514 = {NULL, &lxb_unicode_idna_map_0514};
static const lxb_unicode_data_t lxb_unicode_data_0516 = {NULL, &lxb_unicode_idna_map_0516};
static const lxb_unicode_data_t lxb_unicode_data_0518 = {NULL, &lxb_unicode_idna_map_0518};
static const lxb_unicode_data_t lxb_unicode_data_051A = {NULL, &lxb_unicode_idna_map_051A};
static const lxb_unicode_data_t lxb_unicode_data_051C = {NULL, &lxb_unicode_idna_map_051C};
static const lxb_unicode_data_t lxb_unicode_data_051E = {NULL, &lxb_unicode_idna_map_051E};
static const lxb_unicode_data_t lxb_unicode_data_0520 = {NULL, &lxb_unicode_idna_map_0520};
static const lxb_unicode_data_t lxb_unicode_data_0522 = {NULL, &lxb_unicode_idna_map_0522};
static const lxb_unicode_data_t lxb_unicode_data_0524 = {NULL, &lxb_unicode_idna_map_0524};
static const lxb_unicode_data_t lxb_unicode_data_0526 = {NULL, &lxb_unicode_idna_map_0526};
static const lxb_unicode_data_t lxb_unicode_data_0528 = {NULL, &lxb_unicode_idna_map_0528};
static const lxb_unicode_data_t lxb_unicode_data_052A = {NULL, &lxb_unicode_idna_map_052A};
static const lxb_unicode_data_t lxb_unicode_data_052C = {NULL, &lxb_unicode_idna_map_052C};
static const lxb_unicode_data_t lxb_unicode_data_052E = {NULL, &lxb_unicode_idna_map_052E};
static const lxb_unicode_data_t lxb_unicode_data_0531 = {NULL, &lxb_unicode_idna_map_0531};
static const lxb_unicode_data_t lxb_unicode_data_0532 = {NULL, &lxb_unicode_idna_map_0532};
static const lxb_unicode_data_t lxb_unicode_data_0533 = {NULL, &lxb_unicode_idna_map_0533};
static const lxb_unicode_data_t lxb_unicode_data_0534 = {NULL, &lxb_unicode_idna_map_0534};
static const lxb_unicode_data_t lxb_unicode_data_0535 = {NULL, &lxb_unicode_idna_map_0535};
static const lxb_unicode_data_t lxb_unicode_data_0536 = {NULL, &lxb_unicode_idna_map_0536};
static const lxb_unicode_data_t lxb_unicode_data_0537 = {NULL, &lxb_unicode_idna_map_0537};
static const lxb_unicode_data_t lxb_unicode_data_0538 = {NULL, &lxb_unicode_idna_map_0538};
static const lxb_unicode_data_t lxb_unicode_data_0539 = {NULL, &lxb_unicode_idna_map_0539};
static const lxb_unicode_data_t lxb_unicode_data_053A = {NULL, &lxb_unicode_idna_map_053A};
static const lxb_unicode_data_t lxb_unicode_data_053B = {NULL, &lxb_unicode_idna_map_053B};
static const lxb_unicode_data_t lxb_unicode_data_053C = {NULL, &lxb_unicode_idna_map_053C};
static const lxb_unicode_data_t lxb_unicode_data_053D = {NULL, &lxb_unicode_idna_map_053D};
static const lxb_unicode_data_t lxb_unicode_data_053E = {NULL, &lxb_unicode_idna_map_053E};
static const lxb_unicode_data_t lxb_unicode_data_053F = {NULL, &lxb_unicode_idna_map_053F};
static const lxb_unicode_data_t lxb_unicode_data_0540 = {NULL, &lxb_unicode_idna_map_0540};
static const lxb_unicode_data_t lxb_unicode_data_0541 = {NULL, &lxb_unicode_idna_map_0541};
static const lxb_unicode_data_t lxb_unicode_data_0542 = {NULL, &lxb_unicode_idna_map_0542};
static const lxb_unicode_data_t lxb_unicode_data_0543 = {NULL, &lxb_unicode_idna_map_0543};
static const lxb_unicode_data_t lxb_unicode_data_0544 = {NULL, &lxb_unicode_idna_map_0544};
static const lxb_unicode_data_t lxb_unicode_data_0545 = {NULL, &lxb_unicode_idna_map_0545};
static const lxb_unicode_data_t lxb_unicode_data_0546 = {NULL, &lxb_unicode_idna_map_0546};
static const lxb_unicode_data_t lxb_unicode_data_0547 = {NULL, &lxb_unicode_idna_map_0547};
static const lxb_unicode_data_t lxb_unicode_data_0548 = {NULL, &lxb_unicode_idna_map_0548};
static const lxb_unicode_data_t lxb_unicode_data_0549 = {NULL, &lxb_unicode_idna_map_0549};
static const lxb_unicode_data_t lxb_unicode_data_054A = {NULL, &lxb_unicode_idna_map_054A};
static const lxb_unicode_data_t lxb_unicode_data_054B = {NULL, &lxb_unicode_idna_map_054B};
static const lxb_unicode_data_t lxb_unicode_data_054C = {NULL, &lxb_unicode_idna_map_054C};
static const lxb_unicode_data_t lxb_unicode_data_054D = {NULL, &lxb_unicode_idna_map_054D};
static const lxb_unicode_data_t lxb_unicode_data_054E = {NULL, &lxb_unicode_idna_map_054E};
static const lxb_unicode_data_t lxb_unicode_data_054F = {NULL, &lxb_unicode_idna_map_054F};
static const lxb_unicode_data_t lxb_unicode_data_0550 = {NULL, &lxb_unicode_idna_map_0550};
static const lxb_unicode_data_t lxb_unicode_data_0551 = {NULL, &lxb_unicode_idna_map_0551};
static const lxb_unicode_data_t lxb_unicode_data_0552 = {NULL, &lxb_unicode_idna_map_0552};
static const lxb_unicode_data_t lxb_unicode_data_0553 = {NULL, &lxb_unicode_idna_map_0553};
static const lxb_unicode_data_t lxb_unicode_data_0554 = {NULL, &lxb_unicode_idna_map_0554};
static const lxb_unicode_data_t lxb_unicode_data_0555 = {NULL, &lxb_unicode_idna_map_0555};
static const lxb_unicode_data_t lxb_unicode_data_0556 = {NULL, &lxb_unicode_idna_map_0556};
static const lxb_unicode_data_t lxb_unicode_data_0587 = {&lxb_unicode_entry_0587, &lxb_unicode_idna_map_0587};
static const lxb_unicode_data_t lxb_unicode_data_0591 = {&lxb_unicode_entry_0591, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0592 = {&lxb_unicode_entry_0592, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0593 = {&lxb_unicode_entry_0593, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0594 = {&lxb_unicode_entry_0594, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0595 = {&lxb_unicode_entry_0595, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0596 = {&lxb_unicode_entry_0596, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0597 = {&lxb_unicode_entry_0597, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0598 = {&lxb_unicode_entry_0598, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0599 = {&lxb_unicode_entry_0599, NULL};
static const lxb_unicode_data_t lxb_unicode_data_059A = {&lxb_unicode_entry_059A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_059B = {&lxb_unicode_entry_059B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_059C = {&lxb_unicode_entry_059C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_059D = {&lxb_unicode_entry_059D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_059E = {&lxb_unicode_entry_059E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_059F = {&lxb_unicode_entry_059F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05A0 = {&lxb_unicode_entry_05A0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05A1 = {&lxb_unicode_entry_05A1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05A2 = {&lxb_unicode_entry_05A2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05A3 = {&lxb_unicode_entry_05A3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05A4 = {&lxb_unicode_entry_05A4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05A5 = {&lxb_unicode_entry_05A5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05A6 = {&lxb_unicode_entry_05A6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05A7 = {&lxb_unicode_entry_05A7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05A8 = {&lxb_unicode_entry_05A8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05A9 = {&lxb_unicode_entry_05A9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05AA = {&lxb_unicode_entry_05AA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05AB = {&lxb_unicode_entry_05AB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05AC = {&lxb_unicode_entry_05AC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05AD = {&lxb_unicode_entry_05AD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05AE = {&lxb_unicode_entry_05AE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05AF = {&lxb_unicode_entry_05AF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05B0 = {&lxb_unicode_entry_05B0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05B1 = {&lxb_unicode_entry_05B1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05B2 = {&lxb_unicode_entry_05B2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05B3 = {&lxb_unicode_entry_05B3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05B4 = {&lxb_unicode_entry_05B4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05B5 = {&lxb_unicode_entry_05B5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05B6 = {&lxb_unicode_entry_05B6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05B7 = {&lxb_unicode_entry_05B7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05B8 = {&lxb_unicode_entry_05B8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05B9 = {&lxb_unicode_entry_05B9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05BA = {&lxb_unicode_entry_05BA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05BB = {&lxb_unicode_entry_05BB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05BC = {&lxb_unicode_entry_05BC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05BD = {&lxb_unicode_entry_05BD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05BF = {&lxb_unicode_entry_05BF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05C1 = {&lxb_unicode_entry_05C1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05C2 = {&lxb_unicode_entry_05C2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05C4 = {&lxb_unicode_entry_05C4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05C5 = {&lxb_unicode_entry_05C5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_05C7 = {&lxb_unicode_entry_05C7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0610 = {&lxb_unicode_entry_0610, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0611 = {&lxb_unicode_entry_0611, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0612 = {&lxb_unicode_entry_0612, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0613 = {&lxb_unicode_entry_0613, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0614 = {&lxb_unicode_entry_0614, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0615 = {&lxb_unicode_entry_0615, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0616 = {&lxb_unicode_entry_0616, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0617 = {&lxb_unicode_entry_0617, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0618 = {&lxb_unicode_entry_0618, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0619 = {&lxb_unicode_entry_0619, NULL};
static const lxb_unicode_data_t lxb_unicode_data_061A = {&lxb_unicode_entry_061A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0622 = {&lxb_unicode_entry_0622, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0623 = {&lxb_unicode_entry_0623, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0624 = {&lxb_unicode_entry_0624, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0625 = {&lxb_unicode_entry_0625, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0626 = {&lxb_unicode_entry_0626, NULL};
static const lxb_unicode_data_t lxb_unicode_data_064B = {&lxb_unicode_entry_064B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_064C = {&lxb_unicode_entry_064C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_064D = {&lxb_unicode_entry_064D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_064E = {&lxb_unicode_entry_064E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_064F = {&lxb_unicode_entry_064F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0650 = {&lxb_unicode_entry_0650, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0651 = {&lxb_unicode_entry_0651, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0652 = {&lxb_unicode_entry_0652, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0653 = {&lxb_unicode_entry_0653, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0654 = {&lxb_unicode_entry_0654, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0655 = {&lxb_unicode_entry_0655, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0656 = {&lxb_unicode_entry_0656, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0657 = {&lxb_unicode_entry_0657, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0658 = {&lxb_unicode_entry_0658, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0659 = {&lxb_unicode_entry_0659, NULL};
static const lxb_unicode_data_t lxb_unicode_data_065A = {&lxb_unicode_entry_065A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_065B = {&lxb_unicode_entry_065B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_065C = {&lxb_unicode_entry_065C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_065D = {&lxb_unicode_entry_065D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_065E = {&lxb_unicode_entry_065E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_065F = {&lxb_unicode_entry_065F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0670 = {&lxb_unicode_entry_0670, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0675 = {&lxb_unicode_entry_0675, &lxb_unicode_idna_map_0675};
static const lxb_unicode_data_t lxb_unicode_data_0676 = {&lxb_unicode_entry_0676, &lxb_unicode_idna_map_0676};
static const lxb_unicode_data_t lxb_unicode_data_0677 = {&lxb_unicode_entry_0677, &lxb_unicode_idna_map_0677};
static const lxb_unicode_data_t lxb_unicode_data_0678 = {&lxb_unicode_entry_0678, &lxb_unicode_idna_map_0678};
static const lxb_unicode_data_t lxb_unicode_data_06C0 = {&lxb_unicode_entry_06C0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06C2 = {&lxb_unicode_entry_06C2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06D3 = {&lxb_unicode_entry_06D3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06D6 = {&lxb_unicode_entry_06D6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06D7 = {&lxb_unicode_entry_06D7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06D8 = {&lxb_unicode_entry_06D8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06D9 = {&lxb_unicode_entry_06D9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06DA = {&lxb_unicode_entry_06DA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06DB = {&lxb_unicode_entry_06DB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06DC = {&lxb_unicode_entry_06DC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06DF = {&lxb_unicode_entry_06DF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06E0 = {&lxb_unicode_entry_06E0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06E1 = {&lxb_unicode_entry_06E1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06E2 = {&lxb_unicode_entry_06E2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06E3 = {&lxb_unicode_entry_06E3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06E4 = {&lxb_unicode_entry_06E4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06E7 = {&lxb_unicode_entry_06E7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06E8 = {&lxb_unicode_entry_06E8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06EA = {&lxb_unicode_entry_06EA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06EB = {&lxb_unicode_entry_06EB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06EC = {&lxb_unicode_entry_06EC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_06ED = {&lxb_unicode_entry_06ED, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0711 = {&lxb_unicode_entry_0711, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0730 = {&lxb_unicode_entry_0730, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0731 = {&lxb_unicode_entry_0731, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0732 = {&lxb_unicode_entry_0732, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0733 = {&lxb_unicode_entry_0733, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0734 = {&lxb_unicode_entry_0734, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0735 = {&lxb_unicode_entry_0735, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0736 = {&lxb_unicode_entry_0736, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0737 = {&lxb_unicode_entry_0737, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0738 = {&lxb_unicode_entry_0738, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0739 = {&lxb_unicode_entry_0739, NULL};
static const lxb_unicode_data_t lxb_unicode_data_073A = {&lxb_unicode_entry_073A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_073B = {&lxb_unicode_entry_073B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_073C = {&lxb_unicode_entry_073C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_073D = {&lxb_unicode_entry_073D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_073E = {&lxb_unicode_entry_073E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_073F = {&lxb_unicode_entry_073F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0740 = {&lxb_unicode_entry_0740, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0741 = {&lxb_unicode_entry_0741, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0742 = {&lxb_unicode_entry_0742, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0743 = {&lxb_unicode_entry_0743, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0744 = {&lxb_unicode_entry_0744, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0745 = {&lxb_unicode_entry_0745, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0746 = {&lxb_unicode_entry_0746, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0747 = {&lxb_unicode_entry_0747, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0748 = {&lxb_unicode_entry_0748, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0749 = {&lxb_unicode_entry_0749, NULL};
static const lxb_unicode_data_t lxb_unicode_data_074A = {&lxb_unicode_entry_074A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_07EB = {&lxb_unicode_entry_07EB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_07EC = {&lxb_unicode_entry_07EC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_07ED = {&lxb_unicode_entry_07ED, NULL};
static const lxb_unicode_data_t lxb_unicode_data_07EE = {&lxb_unicode_entry_07EE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_07EF = {&lxb_unicode_entry_07EF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_07F0 = {&lxb_unicode_entry_07F0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_07F1 = {&lxb_unicode_entry_07F1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_07F2 = {&lxb_unicode_entry_07F2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_07F3 = {&lxb_unicode_entry_07F3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_07FD = {&lxb_unicode_entry_07FD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0816 = {&lxb_unicode_entry_0816, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0817 = {&lxb_unicode_entry_0817, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0818 = {&lxb_unicode_entry_0818, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0819 = {&lxb_unicode_entry_0819, NULL};
static const lxb_unicode_data_t lxb_unicode_data_081B = {&lxb_unicode_entry_081B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_081C = {&lxb_unicode_entry_081C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_081D = {&lxb_unicode_entry_081D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_081E = {&lxb_unicode_entry_081E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_081F = {&lxb_unicode_entry_081F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0820 = {&lxb_unicode_entry_0820, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0821 = {&lxb_unicode_entry_0821, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0822 = {&lxb_unicode_entry_0822, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0823 = {&lxb_unicode_entry_0823, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0825 = {&lxb_unicode_entry_0825, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0826 = {&lxb_unicode_entry_0826, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0827 = {&lxb_unicode_entry_0827, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0829 = {&lxb_unicode_entry_0829, NULL};
static const lxb_unicode_data_t lxb_unicode_data_082A = {&lxb_unicode_entry_082A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_082B = {&lxb_unicode_entry_082B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_082C = {&lxb_unicode_entry_082C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_082D = {&lxb_unicode_entry_082D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0859 = {&lxb_unicode_entry_0859, NULL};
static const lxb_unicode_data_t lxb_unicode_data_085A = {&lxb_unicode_entry_085A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_085B = {&lxb_unicode_entry_085B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0898 = {&lxb_unicode_entry_0898, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0899 = {&lxb_unicode_entry_0899, NULL};
static const lxb_unicode_data_t lxb_unicode_data_089A = {&lxb_unicode_entry_089A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_089B = {&lxb_unicode_entry_089B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_089C = {&lxb_unicode_entry_089C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_089D = {&lxb_unicode_entry_089D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_089E = {&lxb_unicode_entry_089E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_089F = {&lxb_unicode_entry_089F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08CA = {&lxb_unicode_entry_08CA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08CB = {&lxb_unicode_entry_08CB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08CC = {&lxb_unicode_entry_08CC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08CD = {&lxb_unicode_entry_08CD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08CE = {&lxb_unicode_entry_08CE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08CF = {&lxb_unicode_entry_08CF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08D0 = {&lxb_unicode_entry_08D0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08D1 = {&lxb_unicode_entry_08D1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08D2 = {&lxb_unicode_entry_08D2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08D3 = {&lxb_unicode_entry_08D3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08D4 = {&lxb_unicode_entry_08D4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08D5 = {&lxb_unicode_entry_08D5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08D6 = {&lxb_unicode_entry_08D6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08D7 = {&lxb_unicode_entry_08D7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08D8 = {&lxb_unicode_entry_08D8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08D9 = {&lxb_unicode_entry_08D9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08DA = {&lxb_unicode_entry_08DA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08DB = {&lxb_unicode_entry_08DB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08DC = {&lxb_unicode_entry_08DC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08DD = {&lxb_unicode_entry_08DD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08DE = {&lxb_unicode_entry_08DE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08DF = {&lxb_unicode_entry_08DF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08E0 = {&lxb_unicode_entry_08E0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08E1 = {&lxb_unicode_entry_08E1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08E3 = {&lxb_unicode_entry_08E3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08E4 = {&lxb_unicode_entry_08E4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08E5 = {&lxb_unicode_entry_08E5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08E6 = {&lxb_unicode_entry_08E6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08E7 = {&lxb_unicode_entry_08E7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08E8 = {&lxb_unicode_entry_08E8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08E9 = {&lxb_unicode_entry_08E9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08EA = {&lxb_unicode_entry_08EA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08EB = {&lxb_unicode_entry_08EB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08EC = {&lxb_unicode_entry_08EC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08ED = {&lxb_unicode_entry_08ED, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08EE = {&lxb_unicode_entry_08EE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08EF = {&lxb_unicode_entry_08EF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08F0 = {&lxb_unicode_entry_08F0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08F1 = {&lxb_unicode_entry_08F1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08F2 = {&lxb_unicode_entry_08F2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08F3 = {&lxb_unicode_entry_08F3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08F4 = {&lxb_unicode_entry_08F4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08F5 = {&lxb_unicode_entry_08F5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08F6 = {&lxb_unicode_entry_08F6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08F7 = {&lxb_unicode_entry_08F7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08F8 = {&lxb_unicode_entry_08F8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08F9 = {&lxb_unicode_entry_08F9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08FA = {&lxb_unicode_entry_08FA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08FB = {&lxb_unicode_entry_08FB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08FC = {&lxb_unicode_entry_08FC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08FD = {&lxb_unicode_entry_08FD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08FE = {&lxb_unicode_entry_08FE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_08FF = {&lxb_unicode_entry_08FF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0929 = {&lxb_unicode_entry_0929, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0931 = {&lxb_unicode_entry_0931, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0934 = {&lxb_unicode_entry_0934, NULL};
static const lxb_unicode_data_t lxb_unicode_data_093C = {&lxb_unicode_entry_093C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_094D = {&lxb_unicode_entry_094D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0951 = {&lxb_unicode_entry_0951, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0952 = {&lxb_unicode_entry_0952, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0953 = {&lxb_unicode_entry_0953, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0954 = {&lxb_unicode_entry_0954, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0958 = {&lxb_unicode_entry_0958, &lxb_unicode_idna_map_0958};
static const lxb_unicode_data_t lxb_unicode_data_0959 = {&lxb_unicode_entry_0959, &lxb_unicode_idna_map_0959};
static const lxb_unicode_data_t lxb_unicode_data_095A = {&lxb_unicode_entry_095A, &lxb_unicode_idna_map_095A};
static const lxb_unicode_data_t lxb_unicode_data_095B = {&lxb_unicode_entry_095B, &lxb_unicode_idna_map_095B};
static const lxb_unicode_data_t lxb_unicode_data_095C = {&lxb_unicode_entry_095C, &lxb_unicode_idna_map_095C};
static const lxb_unicode_data_t lxb_unicode_data_095D = {&lxb_unicode_entry_095D, &lxb_unicode_idna_map_095D};
static const lxb_unicode_data_t lxb_unicode_data_095E = {&lxb_unicode_entry_095E, &lxb_unicode_idna_map_095E};
static const lxb_unicode_data_t lxb_unicode_data_095F = {&lxb_unicode_entry_095F, &lxb_unicode_idna_map_095F};
static const lxb_unicode_data_t lxb_unicode_data_09BC = {&lxb_unicode_entry_09BC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_09BE = {&lxb_unicode_entry_09BE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_09CB = {&lxb_unicode_entry_09CB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_09CC = {&lxb_unicode_entry_09CC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_09CD = {&lxb_unicode_entry_09CD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_09D7 = {&lxb_unicode_entry_09D7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_09DC = {&lxb_unicode_entry_09DC, &lxb_unicode_idna_map_09DC};
static const lxb_unicode_data_t lxb_unicode_data_09DD = {&lxb_unicode_entry_09DD, &lxb_unicode_idna_map_09DD};
static const lxb_unicode_data_t lxb_unicode_data_09DF = {&lxb_unicode_entry_09DF, &lxb_unicode_idna_map_09DF};
static const lxb_unicode_data_t lxb_unicode_data_09FE = {&lxb_unicode_entry_09FE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0A33 = {&lxb_unicode_entry_0A33, &lxb_unicode_idna_map_0A33};
static const lxb_unicode_data_t lxb_unicode_data_0A36 = {&lxb_unicode_entry_0A36, &lxb_unicode_idna_map_0A36};
static const lxb_unicode_data_t lxb_unicode_data_0A3C = {&lxb_unicode_entry_0A3C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0A4D = {&lxb_unicode_entry_0A4D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0A59 = {&lxb_unicode_entry_0A59, &lxb_unicode_idna_map_0A59};
static const lxb_unicode_data_t lxb_unicode_data_0A5A = {&lxb_unicode_entry_0A5A, &lxb_unicode_idna_map_0A5A};
static const lxb_unicode_data_t lxb_unicode_data_0A5B = {&lxb_unicode_entry_0A5B, &lxb_unicode_idna_map_0A5B};
static const lxb_unicode_data_t lxb_unicode_data_0A5E = {&lxb_unicode_entry_0A5E, &lxb_unicode_idna_map_0A5E};
static const lxb_unicode_data_t lxb_unicode_data_0ABC = {&lxb_unicode_entry_0ABC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0ACD = {&lxb_unicode_entry_0ACD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0B3C = {&lxb_unicode_entry_0B3C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0B3E = {&lxb_unicode_entry_0B3E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0B48 = {&lxb_unicode_entry_0B48, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0B4B = {&lxb_unicode_entry_0B4B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0B4C = {&lxb_unicode_entry_0B4C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0B4D = {&lxb_unicode_entry_0B4D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0B56 = {&lxb_unicode_entry_0B56, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0B57 = {&lxb_unicode_entry_0B57, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0B5C = {&lxb_unicode_entry_0B5C, &lxb_unicode_idna_map_0B5C};
static const lxb_unicode_data_t lxb_unicode_data_0B5D = {&lxb_unicode_entry_0B5D, &lxb_unicode_idna_map_0B5D};
static const lxb_unicode_data_t lxb_unicode_data_0B94 = {&lxb_unicode_entry_0B94, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0BBE = {&lxb_unicode_entry_0BBE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0BCA = {&lxb_unicode_entry_0BCA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0BCB = {&lxb_unicode_entry_0BCB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0BCC = {&lxb_unicode_entry_0BCC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0BCD = {&lxb_unicode_entry_0BCD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0BD7 = {&lxb_unicode_entry_0BD7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0C3C = {&lxb_unicode_entry_0C3C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0C48 = {&lxb_unicode_entry_0C48, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0C4D = {&lxb_unicode_entry_0C4D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0C55 = {&lxb_unicode_entry_0C55, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0C56 = {&lxb_unicode_entry_0C56, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0CBC = {&lxb_unicode_entry_0CBC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0CC0 = {&lxb_unicode_entry_0CC0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0CC2 = {&lxb_unicode_entry_0CC2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0CC7 = {&lxb_unicode_entry_0CC7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0CC8 = {&lxb_unicode_entry_0CC8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0CCA = {&lxb_unicode_entry_0CCA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0CCB = {&lxb_unicode_entry_0CCB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0CCD = {&lxb_unicode_entry_0CCD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0CD5 = {&lxb_unicode_entry_0CD5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0CD6 = {&lxb_unicode_entry_0CD6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0D3B = {&lxb_unicode_entry_0D3B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0D3C = {&lxb_unicode_entry_0D3C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0D3E = {&lxb_unicode_entry_0D3E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0D4A = {&lxb_unicode_entry_0D4A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0D4B = {&lxb_unicode_entry_0D4B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0D4C = {&lxb_unicode_entry_0D4C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0D4D = {&lxb_unicode_entry_0D4D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0D57 = {&lxb_unicode_entry_0D57, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0DCA = {&lxb_unicode_entry_0DCA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0DCF = {&lxb_unicode_entry_0DCF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0DDA = {&lxb_unicode_entry_0DDA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0DDC = {&lxb_unicode_entry_0DDC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0DDD = {&lxb_unicode_entry_0DDD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0DDE = {&lxb_unicode_entry_0DDE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0DDF = {&lxb_unicode_entry_0DDF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0E33 = {&lxb_unicode_entry_0E33, &lxb_unicode_idna_map_0E33};
static const lxb_unicode_data_t lxb_unicode_data_0E38 = {&lxb_unicode_entry_0E38, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0E39 = {&lxb_unicode_entry_0E39, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0E3A = {&lxb_unicode_entry_0E3A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0E48 = {&lxb_unicode_entry_0E48, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0E49 = {&lxb_unicode_entry_0E49, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0E4A = {&lxb_unicode_entry_0E4A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0E4B = {&lxb_unicode_entry_0E4B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0EB3 = {&lxb_unicode_entry_0EB3, &lxb_unicode_idna_map_0EB3};
static const lxb_unicode_data_t lxb_unicode_data_0EB8 = {&lxb_unicode_entry_0EB8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0EB9 = {&lxb_unicode_entry_0EB9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0EBA = {&lxb_unicode_entry_0EBA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0EC8 = {&lxb_unicode_entry_0EC8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0EC9 = {&lxb_unicode_entry_0EC9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0ECA = {&lxb_unicode_entry_0ECA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0ECB = {&lxb_unicode_entry_0ECB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0EDC = {&lxb_unicode_entry_0EDC, &lxb_unicode_idna_map_0EDC};
static const lxb_unicode_data_t lxb_unicode_data_0EDD = {&lxb_unicode_entry_0EDD, &lxb_unicode_idna_map_0EDD};
static const lxb_unicode_data_t lxb_unicode_data_0F0C = {&lxb_unicode_entry_0F0C, &lxb_unicode_idna_map_0F0C};
static const lxb_unicode_data_t lxb_unicode_data_0F18 = {&lxb_unicode_entry_0F18, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F19 = {&lxb_unicode_entry_0F19, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F35 = {&lxb_unicode_entry_0F35, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F37 = {&lxb_unicode_entry_0F37, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F39 = {&lxb_unicode_entry_0F39, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F43 = {&lxb_unicode_entry_0F43, &lxb_unicode_idna_map_0F43};
static const lxb_unicode_data_t lxb_unicode_data_0F4D = {&lxb_unicode_entry_0F4D, &lxb_unicode_idna_map_0F4D};
static const lxb_unicode_data_t lxb_unicode_data_0F52 = {&lxb_unicode_entry_0F52, &lxb_unicode_idna_map_0F52};
static const lxb_unicode_data_t lxb_unicode_data_0F57 = {&lxb_unicode_entry_0F57, &lxb_unicode_idna_map_0F57};
static const lxb_unicode_data_t lxb_unicode_data_0F5C = {&lxb_unicode_entry_0F5C, &lxb_unicode_idna_map_0F5C};
static const lxb_unicode_data_t lxb_unicode_data_0F69 = {&lxb_unicode_entry_0F69, &lxb_unicode_idna_map_0F69};
static const lxb_unicode_data_t lxb_unicode_data_0F71 = {&lxb_unicode_entry_0F71, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F72 = {&lxb_unicode_entry_0F72, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F73 = {&lxb_unicode_entry_0F73, &lxb_unicode_idna_map_0F73};
static const lxb_unicode_data_t lxb_unicode_data_0F74 = {&lxb_unicode_entry_0F74, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F75 = {&lxb_unicode_entry_0F75, &lxb_unicode_idna_map_0F75};
static const lxb_unicode_data_t lxb_unicode_data_0F76 = {&lxb_unicode_entry_0F76, &lxb_unicode_idna_map_0F76};
static const lxb_unicode_data_t lxb_unicode_data_0F77 = {&lxb_unicode_entry_0F77, &lxb_unicode_idna_map_0F77};
static const lxb_unicode_data_t lxb_unicode_data_0F78 = {&lxb_unicode_entry_0F78, &lxb_unicode_idna_map_0F78};
static const lxb_unicode_data_t lxb_unicode_data_0F79 = {&lxb_unicode_entry_0F79, &lxb_unicode_idna_map_0F79};
static const lxb_unicode_data_t lxb_unicode_data_0F7A = {&lxb_unicode_entry_0F7A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F7B = {&lxb_unicode_entry_0F7B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F7C = {&lxb_unicode_entry_0F7C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F7D = {&lxb_unicode_entry_0F7D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F80 = {&lxb_unicode_entry_0F80, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F81 = {&lxb_unicode_entry_0F81, &lxb_unicode_idna_map_0F81};
static const lxb_unicode_data_t lxb_unicode_data_0F82 = {&lxb_unicode_entry_0F82, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F83 = {&lxb_unicode_entry_0F83, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F84 = {&lxb_unicode_entry_0F84, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F86 = {&lxb_unicode_entry_0F86, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F87 = {&lxb_unicode_entry_0F87, NULL};
static const lxb_unicode_data_t lxb_unicode_data_0F93 = {&lxb_unicode_entry_0F93, &lxb_unicode_idna_map_0F93};
static const lxb_unicode_data_t lxb_unicode_data_0F9D = {&lxb_unicode_entry_0F9D, &lxb_unicode_idna_map_0F9D};
static const lxb_unicode_data_t lxb_unicode_data_0FA2 = {&lxb_unicode_entry_0FA2, &lxb_unicode_idna_map_0FA2};
static const lxb_unicode_data_t lxb_unicode_data_0FA7 = {&lxb_unicode_entry_0FA7, &lxb_unicode_idna_map_0FA7};
static const lxb_unicode_data_t lxb_unicode_data_0FAC = {&lxb_unicode_entry_0FAC, &lxb_unicode_idna_map_0FAC};
static const lxb_unicode_data_t lxb_unicode_data_0FB9 = {&lxb_unicode_entry_0FB9, &lxb_unicode_idna_map_0FB9};
static const lxb_unicode_data_t lxb_unicode_data_0FC6 = {&lxb_unicode_entry_0FC6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1026 = {&lxb_unicode_entry_1026, NULL};
static const lxb_unicode_data_t lxb_unicode_data_102E = {&lxb_unicode_entry_102E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1037 = {&lxb_unicode_entry_1037, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1039 = {&lxb_unicode_entry_1039, NULL};
static const lxb_unicode_data_t lxb_unicode_data_103A = {&lxb_unicode_entry_103A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_108D = {&lxb_unicode_entry_108D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_10C7 = {NULL, &lxb_unicode_idna_map_10C7};
static const lxb_unicode_data_t lxb_unicode_data_10CD = {NULL, &lxb_unicode_idna_map_10CD};
static const lxb_unicode_data_t lxb_unicode_data_10FC = {&lxb_unicode_entry_10FC, &lxb_unicode_idna_map_10FC};
static const lxb_unicode_data_t lxb_unicode_data_1161 = {&lxb_unicode_entry_1161, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1162 = {&lxb_unicode_entry_1162, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1163 = {&lxb_unicode_entry_1163, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1164 = {&lxb_unicode_entry_1164, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1165 = {&lxb_unicode_entry_1165, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1166 = {&lxb_unicode_entry_1166, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1167 = {&lxb_unicode_entry_1167, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1168 = {&lxb_unicode_entry_1168, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1169 = {&lxb_unicode_entry_1169, NULL};
static const lxb_unicode_data_t lxb_unicode_data_116A = {&lxb_unicode_entry_116A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_116B = {&lxb_unicode_entry_116B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_116C = {&lxb_unicode_entry_116C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_116D = {&lxb_unicode_entry_116D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_116E = {&lxb_unicode_entry_116E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_116F = {&lxb_unicode_entry_116F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1170 = {&lxb_unicode_entry_1170, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1171 = {&lxb_unicode_entry_1171, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1172 = {&lxb_unicode_entry_1172, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1173 = {&lxb_unicode_entry_1173, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1174 = {&lxb_unicode_entry_1174, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1175 = {&lxb_unicode_entry_1175, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11A8 = {&lxb_unicode_entry_11A8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11A9 = {&lxb_unicode_entry_11A9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11AA = {&lxb_unicode_entry_11AA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11AB = {&lxb_unicode_entry_11AB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11AC = {&lxb_unicode_entry_11AC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11AD = {&lxb_unicode_entry_11AD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11AE = {&lxb_unicode_entry_11AE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11AF = {&lxb_unicode_entry_11AF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11B0 = {&lxb_unicode_entry_11B0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11B1 = {&lxb_unicode_entry_11B1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11B2 = {&lxb_unicode_entry_11B2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11B3 = {&lxb_unicode_entry_11B3, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11B4 = {&lxb_unicode_entry_11B4, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11B5 = {&lxb_unicode_entry_11B5, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11B6 = {&lxb_unicode_entry_11B6, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11B7 = {&lxb_unicode_entry_11B7, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11B8 = {&lxb_unicode_entry_11B8, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11B9 = {&lxb_unicode_entry_11B9, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11BA = {&lxb_unicode_entry_11BA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11BB = {&lxb_unicode_entry_11BB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11BC = {&lxb_unicode_entry_11BC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11BD = {&lxb_unicode_entry_11BD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11BE = {&lxb_unicode_entry_11BE, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11BF = {&lxb_unicode_entry_11BF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11C0 = {&lxb_unicode_entry_11C0, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11C1 = {&lxb_unicode_entry_11C1, NULL};
static const lxb_unicode_data_t lxb_unicode_data_11C2 = {&lxb_unicode_entry_11C2, NULL};
static const lxb_unicode_data_t lxb_unicode_data_135D = {&lxb_unicode_entry_135D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_135E = {&lxb_unicode_entry_135E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_135F = {&lxb_unicode_entry_135F, NULL};
static const lxb_unicode_data_t *lxb_unicode_table_0[5000] = {
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0041,
    &lxb_unicode_data_0042,
    &lxb_unicode_data_0043,
    &lxb_unicode_data_0044,
    &lxb_unicode_data_0045,
    &lxb_unicode_data_0046,
    &lxb_unicode_data_0047,
    &lxb_unicode_data_0048,
    &lxb_unicode_data_0049,
    &lxb_unicode_data_004A,
    &lxb_unicode_data_004B,
    &lxb_unicode_data_004C,
    &lxb_unicode_data_004D,
    &lxb_unicode_data_004E,
    &lxb_unicode_data_004F,
    &lxb_unicode_data_0050,
    &lxb_unicode_data_0051,
    &lxb_unicode_data_0052,
    &lxb_unicode_data_0053,
    &lxb_unicode_data_0054,
    &lxb_unicode_data_0055,
    &lxb_unicode_data_0056,
    &lxb_unicode_data_0057,
    &lxb_unicode_data_0058,
    &lxb_unicode_data_0059,
    &lxb_unicode_data_005A,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_00A0,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_00A8,
    NULL,
    &lxb_unicode_data_00AA,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_00AF,
    NULL,
    NULL,
    &lxb_unicode_data_00B2,
    &lxb_unicode_data_00B3,
    &lxb_unicode_data_00B4,
    &lxb_unicode_data_00B5,
    NULL,
    NULL,
    &lxb_unicode_data_00B8,
    &lxb_unicode_data_00B9,
    &lxb_unicode_data_00BA,
    NULL,
    &lxb_unicode_data_00BC,
    &lxb_unicode_data_00BD,
    &lxb_unicode_data_00BE,
    NULL,
    &lxb_unicode_data_00C0,
    &lxb_unicode_data_00C1,
    &lxb_unicode_data_00C2,
    &lxb_unicode_data_00C3,
    &lxb_unicode_data_00C4,
    &lxb_unicode_data_00C5,
    &lxb_unicode_data_00C6,
    &lxb_unicode_data_00C7,
    &lxb_unicode_data_00C8,
    &lxb_unicode_data_00C9,
    &lxb_unicode_data_00CA,
    &lxb_unicode_data_00CB,
    &lxb_unicode_data_00CC,
    &lxb_unicode_data_00CD,
    &lxb_unicode_data_00CE,
    &lxb_unicode_data_00CF,
    &lxb_unicode_data_00D0,
    &lxb_unicode_data_00D1,
    &lxb_unicode_data_00D2,
    &lxb_unicode_data_00D3,
    &lxb_unicode_data_00D4,
    &lxb_unicode_data_00D5,
    &lxb_unicode_data_00D6,
    NULL,
    &lxb_unicode_data_00D8,
    &lxb_unicode_data_00D9,
    &lxb_unicode_data_00DA,
    &lxb_unicode_data_00DB,
    &lxb_unicode_data_00DC,
    &lxb_unicode_data_00DD,
    &lxb_unicode_data_00DE,
    &lxb_unicode_data_00DF,
    &lxb_unicode_data_00E0,
    &lxb_unicode_data_00E1,
    &lxb_unicode_data_00E2,
    &lxb_unicode_data_00E3,
    &lxb_unicode_data_00E4,
    &lxb_unicode_data_00E5,
    NULL,
    &lxb_unicode_data_00E7,
    &lxb_unicode_data_00E8,
    &lxb_unicode_data_00E9,
    &lxb_unicode_data_00EA,
    &lxb_unicode_data_00EB,
    &lxb_unicode_data_00EC,
    &lxb_unicode_data_00ED,
    &lxb_unicode_data_00EE,
    &lxb_unicode_data_00EF,
    NULL,
    &lxb_unicode_data_00F1,
    &lxb_unicode_data_00F2,
    &lxb_unicode_data_00F3,
    &lxb_unicode_data_00F4,
    &lxb_unicode_data_00F5,
    &lxb_unicode_data_00F6,
    NULL,
    NULL,
    &lxb_unicode_data_00F9,
    &lxb_unicode_data_00FA,
    &lxb_unicode_data_00FB,
    &lxb_unicode_data_00FC,
    &lxb_unicode_data_00FD,
    NULL,
    &lxb_unicode_data_00FF,
    &lxb_unicode_data_0100,
    &lxb_unicode_data_0101,
    &lxb_unicode_data_0102,
    &lxb_unicode_data_0103,
    &lxb_unicode_data_0104,
    &lxb_unicode_data_0105,
    &lxb_unicode_data_0106,
    &lxb_unicode_data_0107,
    &lxb_unicode_data_0108,
    &lxb_unicode_data_0109,
    &lxb_unicode_data_010A,
    &lxb_unicode_data_010B,
    &lxb_unicode_data_010C,
    &lxb_unicode_data_010D,
    &lxb_unicode_data_010E,
    &lxb_unicode_data_010F,
    &lxb_unicode_data_0110,
    NULL,
    &lxb_unicode_data_0112,
    &lxb_unicode_data_0113,
    &lxb_unicode_data_0114,
    &lxb_unicode_data_0115,
    &lxb_unicode_data_0116,
    &lxb_unicode_data_0117,
    &lxb_unicode_data_0118,
    &lxb_unicode_data_0119,
    &lxb_unicode_data_011A,
    &lxb_unicode_data_011B,
    &lxb_unicode_data_011C,
    &lxb_unicode_data_011D,
    &lxb_unicode_data_011E,
    &lxb_unicode_data_011F,
    &lxb_unicode_data_0120,
    &lxb_unicode_data_0121,
    &lxb_unicode_data_0122,
    &lxb_unicode_data_0123,
    &lxb_unicode_data_0124,
    &lxb_unicode_data_0125,
    &lxb_unicode_data_0126,
    NULL,
    &lxb_unicode_data_0128,
    &lxb_unicode_data_0129,
    &lxb_unicode_data_012A,
    &lxb_unicode_data_012B,
    &lxb_unicode_data_012C,
    &lxb_unicode_data_012D,
    &lxb_unicode_data_012E,
    &lxb_unicode_data_012F,
    &lxb_unicode_data_0130,
    NULL,
    &lxb_unicode_data_0132,
    &lxb_unicode_data_0133,
    &lxb_unicode_data_0134,
    &lxb_unicode_data_0135,
    &lxb_unicode_data_0136,
    &lxb_unicode_data_0137,
    NULL,
    &lxb_unicode_data_0139,
    &lxb_unicode_data_013A,
    &lxb_unicode_data_013B,
    &lxb_unicode_data_013C,
    &lxb_unicode_data_013D,
    &lxb_unicode_data_013E,
    &lxb_unicode_data_013F,
    &lxb_unicode_data_0140,
    &lxb_unicode_data_0141,
    NULL,
    &lxb_unicode_data_0143,
    &lxb_unicode_data_0144,
    &lxb_unicode_data_0145,
    &lxb_unicode_data_0146,
    &lxb_unicode_data_0147,
    &lxb_unicode_data_0148,
    &lxb_unicode_data_0149,
    &lxb_unicode_data_014A,
    NULL,
    &lxb_unicode_data_014C,
    &lxb_unicode_data_014D,
    &lxb_unicode_data_014E,
    &lxb_unicode_data_014F,
    &lxb_unicode_data_0150,
    &lxb_unicode_data_0151,
    &lxb_unicode_data_0152,
    NULL,
    &lxb_unicode_data_0154,
    &lxb_unicode_data_0155,
    &lxb_unicode_data_0156,
    &lxb_unicode_data_0157,
    &lxb_unicode_data_0158,
    &lxb_unicode_data_0159,
    &lxb_unicode_data_015A,
    &lxb_unicode_data_015B,
    &lxb_unicode_data_015C,
    &lxb_unicode_data_015D,
    &lxb_unicode_data_015E,
    &lxb_unicode_data_015F,
    &lxb_unicode_data_0160,
    &lxb_unicode_data_0161,
    &lxb_unicode_data_0162,
    &lxb_unicode_data_0163,
    &lxb_unicode_data_0164,
    &lxb_unicode_data_0165,
    &lxb_unicode_data_0166,
    NULL,
    &lxb_unicode_data_0168,
    &lxb_unicode_data_0169,
    &lxb_unicode_data_016A,
    &lxb_unicode_data_016B,
    &lxb_unicode_data_016C,
    &lxb_unicode_data_016D,
    &lxb_unicode_data_016E,
    &lxb_unicode_data_016F,
    &lxb_unicode_data_0170,
    &lxb_unicode_data_0171,
    &lxb_unicode_data_0172,
    &lxb_unicode_data_0173,
    &lxb_unicode_data_0174,
    &lxb_unicode_data_0175,
    &lxb_unicode_data_0176,
    &lxb_unicode_data_0177,
    &lxb_unicode_data_0178,
    &lxb_unicode_data_0179,
    &lxb_unicode_data_017A,
    &lxb_unicode_data_017B,
    &lxb_unicode_data_017C,
    &lxb_unicode_data_017D,
    &lxb_unicode_data_017E,
    &lxb_unicode_data_017F,
    NULL,
    &lxb_unicode_data_0181,
    &lxb_unicode_data_0182,
    NULL,
    &lxb_unicode_data_0184,
    NULL,
    &lxb_unicode_data_0186,
    &lxb_unicode_data_0187,
    NULL,
    &lxb_unicode_data_0189,
    &lxb_unicode_data_018A,
    &lxb_unicode_data_018B,
    NULL,
    NULL,
    &lxb_unicode_data_018E,
    &lxb_unicode_data_018F,
    &lxb_unicode_data_0190,
    &lxb_unicode_data_0191,
    NULL,
    &lxb_unicode_data_0193,
    &lxb_unicode_data_0194,
    NULL,
    &lxb_unicode_data_0196,
    &lxb_unicode_data_0197,
    &lxb_unicode_data_0198,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_019C,
    &lxb_unicode_data_019D,
    NULL,
    &lxb_unicode_data_019F,
    &lxb_unicode_data_01A0,
    &lxb_unicode_data_01A1,
    &lxb_unicode_data_01A2,
    NULL,
    &lxb_unicode_data_01A4,
    NULL,
    &lxb_unicode_data_01A6,
    &lxb_unicode_data_01A7,
    NULL,
    &lxb_unicode_data_01A9,
    NULL,
    NULL,
    &lxb_unicode_data_01AC,
    NULL,
    &lxb_unicode_data_01AE,
    &lxb_unicode_data_01AF,
    &lxb_unicode_data_01B0,
    &lxb_unicode_data_01B1,
    &lxb_unicode_data_01B2,
    &lxb_unicode_data_01B3,
    NULL,
    &lxb_unicode_data_01B5,
    NULL,
    &lxb_unicode_data_01B7,
    &lxb_unicode_data_01B8,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_01BC,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_01C4,
    &lxb_unicode_data_01C5,
    &lxb_unicode_data_01C6,
    &lxb_unicode_data_01C7,
    &lxb_unicode_data_01C8,
    &lxb_unicode_data_01C9,
    &lxb_unicode_data_01CA,
    &lxb_unicode_data_01CB,
    &lxb_unicode_data_01CC,
    &lxb_unicode_data_01CD,
    &lxb_unicode_data_01CE,
    &lxb_unicode_data_01CF,
    &lxb_unicode_data_01D0,
    &lxb_unicode_data_01D1,
    &lxb_unicode_data_01D2,
    &lxb_unicode_data_01D3,
    &lxb_unicode_data_01D4,
    &lxb_unicode_data_01D5,
    &lxb_unicode_data_01D6,
    &lxb_unicode_data_01D7,
    &lxb_unicode_data_01D8,
    &lxb_unicode_data_01D9,
    &lxb_unicode_data_01DA,
    &lxb_unicode_data_01DB,
    &lxb_unicode_data_01DC,
    NULL,
    &lxb_unicode_data_01DE,
    &lxb_unicode_data_01DF,
    &lxb_unicode_data_01E0,
    &lxb_unicode_data_01E1,
    &lxb_unicode_data_01E2,
    &lxb_unicode_data_01E3,
    &lxb_unicode_data_01E4,
    NULL,
    &lxb_unicode_data_01E6,
    &lxb_unicode_data_01E7,
    &lxb_unicode_data_01E8,
    &lxb_unicode_data_01E9,
    &lxb_unicode_data_01EA,
    &lxb_unicode_data_01EB,
    &lxb_unicode_data_01EC,
    &lxb_unicode_data_01ED,
    &lxb_unicode_data_01EE,
    &lxb_unicode_data_01EF,
    &lxb_unicode_data_01F0,
    &lxb_unicode_data_01F1,
    &lxb_unicode_data_01F2,
    &lxb_unicode_data_01F3,
    &lxb_unicode_data_01F4,
    &lxb_unicode_data_01F5,
    &lxb_unicode_data_01F6,
    &lxb_unicode_data_01F7,
    &lxb_unicode_data_01F8,
    &lxb_unicode_data_01F9,
    &lxb_unicode_data_01FA,
    &lxb_unicode_data_01FB,
    &lxb_unicode_data_01FC,
    &lxb_unicode_data_01FD,
    &lxb_unicode_data_01FE,
    &lxb_unicode_data_01FF,
    &lxb_unicode_data_0200,
    &lxb_unicode_data_0201,
    &lxb_unicode_data_0202,
    &lxb_unicode_data_0203,
    &lxb_unicode_data_0204,
    &lxb_unicode_data_0205,
    &lxb_unicode_data_0206,
    &lxb_unicode_data_0207,
    &lxb_unicode_data_0208,
    &lxb_unicode_data_0209,
    &lxb_unicode_data_020A,
    &lxb_unicode_data_020B,
    &lxb_unicode_data_020C,
    &lxb_unicode_data_020D,
    &lxb_unicode_data_020E,
    &lxb_unicode_data_020F,
    &lxb_unicode_data_0210,
    &lxb_unicode_data_0211,
    &lxb_unicode_data_0212,
    &lxb_unicode_data_0213,
    &lxb_unicode_data_0214,
    &lxb_unicode_data_0215,
    &lxb_unicode_data_0216,
    &lxb_unicode_data_0217,
    &lxb_unicode_data_0218,
    &lxb_unicode_data_0219,
    &lxb_unicode_data_021A,
    &lxb_unicode_data_021B,
    &lxb_unicode_data_021C,
    NULL,
    &lxb_unicode_data_021E,
    &lxb_unicode_data_021F,
    &lxb_unicode_data_0220,
    NULL,
    &lxb_unicode_data_0222,
    NULL,
    &lxb_unicode_data_0224,
    NULL,
    &lxb_unicode_data_0226,
    &lxb_unicode_data_0227,
    &lxb_unicode_data_0228,
    &lxb_unicode_data_0229,
    &lxb_unicode_data_022A,
    &lxb_unicode_data_022B,
    &lxb_unicode_data_022C,
    &lxb_unicode_data_022D,
    &lxb_unicode_data_022E,
    &lxb_unicode_data_022F,
    &lxb_unicode_data_0230,
    &lxb_unicode_data_0231,
    &lxb_unicode_data_0232,
    &lxb_unicode_data_0233,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_023A,
    &lxb_unicode_data_023B,
    NULL,
    &lxb_unicode_data_023D,
    &lxb_unicode_data_023E,
    NULL,
    NULL,
    &lxb_unicode_data_0241,
    NULL,
    &lxb_unicode_data_0243,
    &lxb_unicode_data_0244,
    &lxb_unicode_data_0245,
    &lxb_unicode_data_0246,
    NULL,
    &lxb_unicode_data_0248,
    NULL,
    &lxb_unicode_data_024A,
    NULL,
    &lxb_unicode_data_024C,
    NULL,
    &lxb_unicode_data_024E,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_02B0,
    &lxb_unicode_data_02B1,
    &lxb_unicode_data_02B2,
    &lxb_unicode_data_02B3,
    &lxb_unicode_data_02B4,
    &lxb_unicode_data_02B5,
    &lxb_unicode_data_02B6,
    &lxb_unicode_data_02B7,
    &lxb_unicode_data_02B8,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_02D8,
    &lxb_unicode_data_02D9,
    &lxb_unicode_data_02DA,
    &lxb_unicode_data_02DB,
    &lxb_unicode_data_02DC,
    &lxb_unicode_data_02DD,
    NULL,
    NULL,
    &lxb_unicode_data_02E0,
    &lxb_unicode_data_02E1,
    &lxb_unicode_data_02E2,
    &lxb_unicode_data_02E3,
    &lxb_unicode_data_02E4,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0300,
    &lxb_unicode_data_0301,
    &lxb_unicode_data_0302,
    &lxb_unicode_data_0303,
    &lxb_unicode_data_0304,
    &lxb_unicode_data_0305,
    &lxb_unicode_data_0306,
    &lxb_unicode_data_0307,
    &lxb_unicode_data_0308,
    &lxb_unicode_data_0309,
    &lxb_unicode_data_030A,
    &lxb_unicode_data_030B,
    &lxb_unicode_data_030C,
    &lxb_unicode_data_030D,
    &lxb_unicode_data_030E,
    &lxb_unicode_data_030F,
    &lxb_unicode_data_0310,
    &lxb_unicode_data_0311,
    &lxb_unicode_data_0312,
    &lxb_unicode_data_0313,
    &lxb_unicode_data_0314,
    &lxb_unicode_data_0315,
    &lxb_unicode_data_0316,
    &lxb_unicode_data_0317,
    &lxb_unicode_data_0318,
    &lxb_unicode_data_0319,
    &lxb_unicode_data_031A,
    &lxb_unicode_data_031B,
    &lxb_unicode_data_031C,
    &lxb_unicode_data_031D,
    &lxb_unicode_data_031E,
    &lxb_unicode_data_031F,
    &lxb_unicode_data_0320,
    &lxb_unicode_data_0321,
    &lxb_unicode_data_0322,
    &lxb_unicode_data_0323,
    &lxb_unicode_data_0324,
    &lxb_unicode_data_0325,
    &lxb_unicode_data_0326,
    &lxb_unicode_data_0327,
    &lxb_unicode_data_0328,
    &lxb_unicode_data_0329,
    &lxb_unicode_data_032A,
    &lxb_unicode_data_032B,
    &lxb_unicode_data_032C,
    &lxb_unicode_data_032D,
    &lxb_unicode_data_032E,
    &lxb_unicode_data_032F,
    &lxb_unicode_data_0330,
    &lxb_unicode_data_0331,
    &lxb_unicode_data_0332,
    &lxb_unicode_data_0333,
    &lxb_unicode_data_0334,
    &lxb_unicode_data_0335,
    &lxb_unicode_data_0336,
    &lxb_unicode_data_0337,
    &lxb_unicode_data_0338,
    &lxb_unicode_data_0339,
    &lxb_unicode_data_033A,
    &lxb_unicode_data_033B,
    &lxb_unicode_data_033C,
    &lxb_unicode_data_033D,
    &lxb_unicode_data_033E,
    &lxb_unicode_data_033F,
    &lxb_unicode_data_0340,
    &lxb_unicode_data_0341,
    &lxb_unicode_data_0342,
    &lxb_unicode_data_0343,
    &lxb_unicode_data_0344,
    &lxb_unicode_data_0345,
    &lxb_unicode_data_0346,
    &lxb_unicode_data_0347,
    &lxb_unicode_data_0348,
    &lxb_unicode_data_0349,
    &lxb_unicode_data_034A,
    &lxb_unicode_data_034B,
    &lxb_unicode_data_034C,
    &lxb_unicode_data_034D,
    &lxb_unicode_data_034E,
    NULL,
    &lxb_unicode_data_0350,
    &lxb_unicode_data_0351,
    &lxb_unicode_data_0352,
    &lxb_unicode_data_0353,
    &lxb_unicode_data_0354,
    &lxb_unicode_data_0355,
    &lxb_unicode_data_0356,
    &lxb_unicode_data_0357,
    &lxb_unicode_data_0358,
    &lxb_unicode_data_0359,
    &lxb_unicode_data_035A,
    &lxb_unicode_data_035B,
    &lxb_unicode_data_035C,
    &lxb_unicode_data_035D,
    &lxb_unicode_data_035E,
    &lxb_unicode_data_035F,
    &lxb_unicode_data_0360,
    &lxb_unicode_data_0361,
    &lxb_unicode_data_0362,
    &lxb_unicode_data_0363,
    &lxb_unicode_data_0364,
    &lxb_unicode_data_0365,
    &lxb_unicode_data_0366,
    &lxb_unicode_data_0367,
    &lxb_unicode_data_0368,
    &lxb_unicode_data_0369,
    &lxb_unicode_data_036A,
    &lxb_unicode_data_036B,
    &lxb_unicode_data_036C,
    &lxb_unicode_data_036D,
    &lxb_unicode_data_036E,
    &lxb_unicode_data_036F,
    &lxb_unicode_data_0370,
    NULL,
    &lxb_unicode_data_0372,
    NULL,
    &lxb_unicode_data_0374,
    NULL,
    &lxb_unicode_data_0376,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_037A,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_037E,
    &lxb_unicode_data_037F,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0384,
    &lxb_unicode_data_0385,
    &lxb_unicode_data_0386,
    &lxb_unicode_data_0387,
    &lxb_unicode_data_0388,
    &lxb_unicode_data_0389,
    &lxb_unicode_data_038A,
    NULL,
    &lxb_unicode_data_038C,
    NULL,
    &lxb_unicode_data_038E,
    &lxb_unicode_data_038F,
    &lxb_unicode_data_0390,
    &lxb_unicode_data_0391,
    &lxb_unicode_data_0392,
    &lxb_unicode_data_0393,
    &lxb_unicode_data_0394,
    &lxb_unicode_data_0395,
    &lxb_unicode_data_0396,
    &lxb_unicode_data_0397,
    &lxb_unicode_data_0398,
    &lxb_unicode_data_0399,
    &lxb_unicode_data_039A,
    &lxb_unicode_data_039B,
    &lxb_unicode_data_039C,
    &lxb_unicode_data_039D,
    &lxb_unicode_data_039E,
    &lxb_unicode_data_039F,
    &lxb_unicode_data_03A0,
    &lxb_unicode_data_03A1,
    NULL,
    &lxb_unicode_data_03A3,
    &lxb_unicode_data_03A4,
    &lxb_unicode_data_03A5,
    &lxb_unicode_data_03A6,
    &lxb_unicode_data_03A7,
    &lxb_unicode_data_03A8,
    &lxb_unicode_data_03A9,
    &lxb_unicode_data_03AA,
    &lxb_unicode_data_03AB,
    &lxb_unicode_data_03AC,
    &lxb_unicode_data_03AD,
    &lxb_unicode_data_03AE,
    &lxb_unicode_data_03AF,
    &lxb_unicode_data_03B0,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_03C2,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_03CA,
    &lxb_unicode_data_03CB,
    &lxb_unicode_data_03CC,
    &lxb_unicode_data_03CD,
    &lxb_unicode_data_03CE,
    &lxb_unicode_data_03CF,
    &lxb_unicode_data_03D0,
    &lxb_unicode_data_03D1,
    &lxb_unicode_data_03D2,
    &lxb_unicode_data_03D3,
    &lxb_unicode_data_03D4,
    &lxb_unicode_data_03D5,
    &lxb_unicode_data_03D6,
    NULL,
    &lxb_unicode_data_03D8,
    NULL,
    &lxb_unicode_data_03DA,
    NULL,
    &lxb_unicode_data_03DC,
    NULL,
    &lxb_unicode_data_03DE,
    NULL,
    &lxb_unicode_data_03E0,
    NULL,
    &lxb_unicode_data_03E2,
    NULL,
    &lxb_unicode_data_03E4,
    NULL,
    &lxb_unicode_data_03E6,
    NULL,
    &lxb_unicode_data_03E8,
    NULL,
    &lxb_unicode_data_03EA,
    NULL,
    &lxb_unicode_data_03EC,
    NULL,
    &lxb_unicode_data_03EE,
    NULL,
    &lxb_unicode_data_03F0,
    &lxb_unicode_data_03F1,
    &lxb_unicode_data_03F2,
    NULL,
    &lxb_unicode_data_03F4,
    &lxb_unicode_data_03F5,
    NULL,
    &lxb_unicode_data_03F7,
    NULL,
    &lxb_unicode_data_03F9,
    &lxb_unicode_data_03FA,
    NULL,
    NULL,
    &lxb_unicode_data_03FD,
    &lxb_unicode_data_03FE,
    &lxb_unicode_data_03FF,
    &lxb_unicode_data_0400,
    &lxb_unicode_data_0401,
    &lxb_unicode_data_0402,
    &lxb_unicode_data_0403,
    &lxb_unicode_data_0404,
    &lxb_unicode_data_0405,
    &lxb_unicode_data_0406,
    &lxb_unicode_data_0407,
    &lxb_unicode_data_0408,
    &lxb_unicode_data_0409,
    &lxb_unicode_data_040A,
    &lxb_unicode_data_040B,
    &lxb_unicode_data_040C,
    &lxb_unicode_data_040D,
    &lxb_unicode_data_040E,
    &lxb_unicode_data_040F,
    &lxb_unicode_data_0410,
    &lxb_unicode_data_0411,
    &lxb_unicode_data_0412,
    &lxb_unicode_data_0413,
    &lxb_unicode_data_0414,
    &lxb_unicode_data_0415,
    &lxb_unicode_data_0416,
    &lxb_unicode_data_0417,
    &lxb_unicode_data_0418,
    &lxb_unicode_data_0419,
    &lxb_unicode_data_041A,
    &lxb_unicode_data_041B,
    &lxb_unicode_data_041C,
    &lxb_unicode_data_041D,
    &lxb_unicode_data_041E,
    &lxb_unicode_data_041F,
    &lxb_unicode_data_0420,
    &lxb_unicode_data_0421,
    &lxb_unicode_data_0422,
    &lxb_unicode_data_0423,
    &lxb_unicode_data_0424,
    &lxb_unicode_data_0425,
    &lxb_unicode_data_0426,
    &lxb_unicode_data_0427,
    &lxb_unicode_data_0428,
    &lxb_unicode_data_0429,
    &lxb_unicode_data_042A,
    &lxb_unicode_data_042B,
    &lxb_unicode_data_042C,
    &lxb_unicode_data_042D,
    &lxb_unicode_data_042E,
    &lxb_unicode_data_042F,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0439,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0450,
    &lxb_unicode_data_0451,
    NULL,
    &lxb_unicode_data_0453,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0457,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_045C,
    &lxb_unicode_data_045D,
    &lxb_unicode_data_045E,
    NULL,
    &lxb_unicode_data_0460,
    NULL,
    &lxb_unicode_data_0462,
    NULL,
    &lxb_unicode_data_0464,
    NULL,
    &lxb_unicode_data_0466,
    NULL,
    &lxb_unicode_data_0468,
    NULL,
    &lxb_unicode_data_046A,
    NULL,
    &lxb_unicode_data_046C,
    NULL,
    &lxb_unicode_data_046E,
    NULL,
    &lxb_unicode_data_0470,
    NULL,
    &lxb_unicode_data_0472,
    NULL,
    &lxb_unicode_data_0474,
    NULL,
    &lxb_unicode_data_0476,
    &lxb_unicode_data_0477,
    &lxb_unicode_data_0478,
    NULL,
    &lxb_unicode_data_047A,
    NULL,
    &lxb_unicode_data_047C,
    NULL,
    &lxb_unicode_data_047E,
    NULL,
    &lxb_unicode_data_0480,
    NULL,
    NULL,
    &lxb_unicode_data_0483,
    &lxb_unicode_data_0484,
    &lxb_unicode_data_0485,
    &lxb_unicode_data_0486,
    &lxb_unicode_data_0487,
    NULL,
    NULL,
    &lxb_unicode_data_048A,
    NULL,
    &lxb_unicode_data_048C,
    NULL,
    &lxb_unicode_data_048E,
    NULL,
    &lxb_unicode_data_0490,
    NULL,
    &lxb_unicode_data_0492,
    NULL,
    &lxb_unicode_data_0494,
    NULL,
    &lxb_unicode_data_0496,
    NULL,
    &lxb_unicode_data_0498,
    NULL,
    &lxb_unicode_data_049A,
    NULL,
    &lxb_unicode_data_049C,
    NULL,
    &lxb_unicode_data_049E,
    NULL,
    &lxb_unicode_data_04A0,
    NULL,
    &lxb_unicode_data_04A2,
    NULL,
    &lxb_unicode_data_04A4,
    NULL,
    &lxb_unicode_data_04A6,
    NULL,
    &lxb_unicode_data_04A8,
    NULL,
    &lxb_unicode_data_04AA,
    NULL,
    &lxb_unicode_data_04AC,
    NULL,
    &lxb_unicode_data_04AE,
    NULL,
    &lxb_unicode_data_04B0,
    NULL,
    &lxb_unicode_data_04B2,
    NULL,
    &lxb_unicode_data_04B4,
    NULL,
    &lxb_unicode_data_04B6,
    NULL,
    &lxb_unicode_data_04B8,
    NULL,
    &lxb_unicode_data_04BA,
    NULL,
    &lxb_unicode_data_04BC,
    NULL,
    &lxb_unicode_data_04BE,
    NULL,
    NULL,
    &lxb_unicode_data_04C1,
    &lxb_unicode_data_04C2,
    &lxb_unicode_data_04C3,
    NULL,
    &lxb_unicode_data_04C5,
    NULL,
    &lxb_unicode_data_04C7,
    NULL,
    &lxb_unicode_data_04C9,
    NULL,
    &lxb_unicode_data_04CB,
    NULL,
    &lxb_unicode_data_04CD,
    NULL,
    NULL,
    &lxb_unicode_data_04D0,
    &lxb_unicode_data_04D1,
    &lxb_unicode_data_04D2,
    &lxb_unicode_data_04D3,
    &lxb_unicode_data_04D4,
    NULL,
    &lxb_unicode_data_04D6,
    &lxb_unicode_data_04D7,
    &lxb_unicode_data_04D8,
    NULL,
    &lxb_unicode_data_04DA,
    &lxb_unicode_data_04DB,
    &lxb_unicode_data_04DC,
    &lxb_unicode_data_04DD,
    &lxb_unicode_data_04DE,
    &lxb_unicode_data_04DF,
    &lxb_unicode_data_04E0,
    NULL,
    &lxb_unicode_data_04E2,
    &lxb_unicode_data_04E3,
    &lxb_unicode_data_04E4,
    &lxb_unicode_data_04E5,
    &lxb_unicode_data_04E6,
    &lxb_unicode_data_04E7,
    &lxb_unicode_data_04E8,
    NULL,
    &lxb_unicode_data_04EA,
    &lxb_unicode_data_04EB,
    &lxb_unicode_data_04EC,
    &lxb_unicode_data_04ED,
    &lxb_unicode_data_04EE,
    &lxb_unicode_data_04EF,
    &lxb_unicode_data_04F0,
    &lxb_unicode_data_04F1,
    &lxb_unicode_data_04F2,
    &lxb_unicode_data_04F3,
    &lxb_unicode_data_04F4,
    &lxb_unicode_data_04F5,
    &lxb_unicode_data_04F6,
    NULL,
    &lxb_unicode_data_04F8,
    &lxb_unicode_data_04F9,
    &lxb_unicode_data_04FA,
    NULL,
    &lxb_unicode_data_04FC,
    NULL,
    &lxb_unicode_data_04FE,
    NULL,
    &lxb_unicode_data_0500,
    NULL,
    &lxb_unicode_data_0502,
    NULL,
    &lxb_unicode_data_0504,
    NULL,
    &lxb_unicode_data_0506,
    NULL,
    &lxb_unicode_data_0508,
    NULL,
    &lxb_unicode_data_050A,
    NULL,
    &lxb_unicode_data_050C,
    NULL,
    &lxb_unicode_data_050E,
    NULL,
    &lxb_unicode_data_0510,
    NULL,
    &lxb_unicode_data_0512,
    NULL,
    &lxb_unicode_data_0514,
    NULL,
    &lxb_unicode_data_0516,
    NULL,
    &lxb_unicode_data_0518,
    NULL,
    &lxb_unicode_data_051A,
    NULL,
    &lxb_unicode_data_051C,
    NULL,
    &lxb_unicode_data_051E,
    NULL,
    &lxb_unicode_data_0520,
    NULL,
    &lxb_unicode_data_0522,
    NULL,
    &lxb_unicode_data_0524,
    NULL,
    &lxb_unicode_data_0526,
    NULL,
    &lxb_unicode_data_0528,
    NULL,
    &lxb_unicode_data_052A,
    NULL,
    &lxb_unicode_data_052C,
    NULL,
    &lxb_unicode_data_052E,
    NULL,
    NULL,
    &lxb_unicode_data_0531,
    &lxb_unicode_data_0532,
    &lxb_unicode_data_0533,
    &lxb_unicode_data_0534,
    &lxb_unicode_data_0535,
    &lxb_unicode_data_0536,
    &lxb_unicode_data_0537,
    &lxb_unicode_data_0538,
    &lxb_unicode_data_0539,
    &lxb_unicode_data_053A,
    &lxb_unicode_data_053B,
    &lxb_unicode_data_053C,
    &lxb_unicode_data_053D,
    &lxb_unicode_data_053E,
    &lxb_unicode_data_053F,
    &lxb_unicode_data_0540,
    &lxb_unicode_data_0541,
    &lxb_unicode_data_0542,
    &lxb_unicode_data_0543,
    &lxb_unicode_data_0544,
    &lxb_unicode_data_0545,
    &lxb_unicode_data_0546,
    &lxb_unicode_data_0547,
    &lxb_unicode_data_0548,
    &lxb_unicode_data_0549,
    &lxb_unicode_data_054A,
    &lxb_unicode_data_054B,
    &lxb_unicode_data_054C,
    &lxb_unicode_data_054D,
    &lxb_unicode_data_054E,
    &lxb_unicode_data_054F,
    &lxb_unicode_data_0550,
    &lxb_unicode_data_0551,
    &lxb_unicode_data_0552,
    &lxb_unicode_data_0553,
    &lxb_unicode_data_0554,
    &lxb_unicode_data_0555,
    &lxb_unicode_data_0556,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0587,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0591,
    &lxb_unicode_data_0592,
    &lxb_unicode_data_0593,
    &lxb_unicode_data_0594,
    &lxb_unicode_data_0595,
    &lxb_unicode_data_0596,
    &lxb_unicode_data_0597,
    &lxb_unicode_data_0598,
    &lxb_unicode_data_0599,
    &lxb_unicode_data_059A,
    &lxb_unicode_data_059B,
    &lxb_unicode_data_059C,
    &lxb_unicode_data_059D,
    &lxb_unicode_data_059E,
    &lxb_unicode_data_059F,
    &lxb_unicode_data_05A0,
    &lxb_unicode_data_05A1,
    &lxb_unicode_data_05A2,
    &lxb_unicode_data_05A3,
    &lxb_unicode_data_05A4,
    &lxb_unicode_data_05A5,
    &lxb_unicode_data_05A6,
    &lxb_unicode_data_05A7,
    &lxb_unicode_data_05A8,
    &lxb_unicode_data_05A9,
    &lxb_unicode_data_05AA,
    &lxb_unicode_data_05AB,
    &lxb_unicode_data_05AC,
    &lxb_unicode_data_05AD,
    &lxb_unicode_data_05AE,
    &lxb_unicode_data_05AF,
    &lxb_unicode_data_05B0,
    &lxb_unicode_data_05B1,
    &lxb_unicode_data_05B2,
    &lxb_unicode_data_05B3,
    &lxb_unicode_data_05B4,
    &lxb_unicode_data_05B5,
    &lxb_unicode_data_05B6,
    &lxb_unicode_data_05B7,
    &lxb_unicode_data_05B8,
    &lxb_unicode_data_05B9,
    &lxb_unicode_data_05BA,
    &lxb_unicode_data_05BB,
    &lxb_unicode_data_05BC,
    &lxb_unicode_data_05BD,
    NULL,
    &lxb_unicode_data_05BF,
    NULL,
    &lxb_unicode_data_05C1,
    &lxb_unicode_data_05C2,
    NULL,
    &lxb_unicode_data_05C4,
    &lxb_unicode_data_05C5,
    NULL,
    &lxb_unicode_data_05C7,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0610,
    &lxb_unicode_data_0611,
    &lxb_unicode_data_0612,
    &lxb_unicode_data_0613,
    &lxb_unicode_data_0614,
    &lxb_unicode_data_0615,
    &lxb_unicode_data_0616,
    &lxb_unicode_data_0617,
    &lxb_unicode_data_0618,
    &lxb_unicode_data_0619,
    &lxb_unicode_data_061A,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0622,
    &lxb_unicode_data_0623,
    &lxb_unicode_data_0624,
    &lxb_unicode_data_0625,
    &lxb_unicode_data_0626,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_064B,
    &lxb_unicode_data_064C,
    &lxb_unicode_data_064D,
    &lxb_unicode_data_064E,
    &lxb_unicode_data_064F,
    &lxb_unicode_data_0650,
    &lxb_unicode_data_0651,
    &lxb_unicode_data_0652,
    &lxb_unicode_data_0653,
    &lxb_unicode_data_0654,
    &lxb_unicode_data_0655,
    &lxb_unicode_data_0656,
    &lxb_unicode_data_0657,
    &lxb_unicode_data_0658,
    &lxb_unicode_data_0659,
    &lxb_unicode_data_065A,
    &lxb_unicode_data_065B,
    &lxb_unicode_data_065C,
    &lxb_unicode_data_065D,
    &lxb_unicode_data_065E,
    &lxb_unicode_data_065F,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0670,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0675,
    &lxb_unicode_data_0676,
    &lxb_unicode_data_0677,
    &lxb_unicode_data_0678,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_06C0,
    NULL,
    &lxb_unicode_data_06C2,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_06D3,
    NULL,
    NULL,
    &lxb_unicode_data_06D6,
    &lxb_unicode_data_06D7,
    &lxb_unicode_data_06D8,
    &lxb_unicode_data_06D9,
    &lxb_unicode_data_06DA,
    &lxb_unicode_data_06DB,
    &lxb_unicode_data_06DC,
    NULL,
    NULL,
    &lxb_unicode_data_06DF,
    &lxb_unicode_data_06E0,
    &lxb_unicode_data_06E1,
    &lxb_unicode_data_06E2,
    &lxb_unicode_data_06E3,
    &lxb_unicode_data_06E4,
    NULL,
    NULL,
    &lxb_unicode_data_06E7,
    &lxb_unicode_data_06E8,
    NULL,
    &lxb_unicode_data_06EA,
    &lxb_unicode_data_06EB,
    &lxb_unicode_data_06EC,
    &lxb_unicode_data_06ED,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0711,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0730,
    &lxb_unicode_data_0731,
    &lxb_unicode_data_0732,
    &lxb_unicode_data_0733,
    &lxb_unicode_data_0734,
    &lxb_unicode_data_0735,
    &lxb_unicode_data_0736,
    &lxb_unicode_data_0737,
    &lxb_unicode_data_0738,
    &lxb_unicode_data_0739,
    &lxb_unicode_data_073A,
    &lxb_unicode_data_073B,
    &lxb_unicode_data_073C,
    &lxb_unicode_data_073D,
    &lxb_unicode_data_073E,
    &lxb_unicode_data_073F,
    &lxb_unicode_data_0740,
    &lxb_unicode_data_0741,
    &lxb_unicode_data_0742,
    &lxb_unicode_data_0743,
    &lxb_unicode_data_0744,
    &lxb_unicode_data_0745,
    &lxb_unicode_data_0746,
    &lxb_unicode_data_0747,
    &lxb_unicode_data_0748,
    &lxb_unicode_data_0749,
    &lxb_unicode_data_074A,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_07EB,
    &lxb_unicode_data_07EC,
    &lxb_unicode_data_07ED,
    &lxb_unicode_data_07EE,
    &lxb_unicode_data_07EF,
    &lxb_unicode_data_07F0,
    &lxb_unicode_data_07F1,
    &lxb_unicode_data_07F2,
    &lxb_unicode_data_07F3,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_07FD,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0816,
    &lxb_unicode_data_0817,
    &lxb_unicode_data_0818,
    &lxb_unicode_data_0819,
    NULL,
    &lxb_unicode_data_081B,
    &lxb_unicode_data_081C,
    &lxb_unicode_data_081D,
    &lxb_unicode_data_081E,
    &lxb_unicode_data_081F,
    &lxb_unicode_data_0820,
    &lxb_unicode_data_0821,
    &lxb_unicode_data_0822,
    &lxb_unicode_data_0823,
    NULL,
    &lxb_unicode_data_0825,
    &lxb_unicode_data_0826,
    &lxb_unicode_data_0827,
    NULL,
    &lxb_unicode_data_0829,
    &lxb_unicode_data_082A,
    &lxb_unicode_data_082B,
    &lxb_unicode_data_082C,
    &lxb_unicode_data_082D,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0859,
    &lxb_unicode_data_085A,
    &lxb_unicode_data_085B,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0898,
    &lxb_unicode_data_0899,
    &lxb_unicode_data_089A,
    &lxb_unicode_data_089B,
    &lxb_unicode_data_089C,
    &lxb_unicode_data_089D,
    &lxb_unicode_data_089E,
    &lxb_unicode_data_089F,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_08CA,
    &lxb_unicode_data_08CB,
    &lxb_unicode_data_08CC,
    &lxb_unicode_data_08CD,
    &lxb_unicode_data_08CE,
    &lxb_unicode_data_08CF,
    &lxb_unicode_data_08D0,
    &lxb_unicode_data_08D1,
    &lxb_unicode_data_08D2,
    &lxb_unicode_data_08D3,
    &lxb_unicode_data_08D4,
    &lxb_unicode_data_08D5,
    &lxb_unicode_data_08D6,
    &lxb_unicode_data_08D7,
    &lxb_unicode_data_08D8,
    &lxb_unicode_data_08D9,
    &lxb_unicode_data_08DA,
    &lxb_unicode_data_08DB,
    &lxb_unicode_data_08DC,
    &lxb_unicode_data_08DD,
    &lxb_unicode_data_08DE,
    &lxb_unicode_data_08DF,
    &lxb_unicode_data_08E0,
    &lxb_unicode_data_08E1,
    NULL,
    &lxb_unicode_data_08E3,
    &lxb_unicode_data_08E4,
    &lxb_unicode_data_08E5,
    &lxb_unicode_data_08E6,
    &lxb_unicode_data_08E7,
    &lxb_unicode_data_08E8,
    &lxb_unicode_data_08E9,
    &lxb_unicode_data_08EA,
    &lxb_unicode_data_08EB,
    &lxb_unicode_data_08EC,
    &lxb_unicode_data_08ED,
    &lxb_unicode_data_08EE,
    &lxb_unicode_data_08EF,
    &lxb_unicode_data_08F0,
    &lxb_unicode_data_08F1,
    &lxb_unicode_data_08F2,
    &lxb_unicode_data_08F3,
    &lxb_unicode_data_08F4,
    &lxb_unicode_data_08F5,
    &lxb_unicode_data_08F6,
    &lxb_unicode_data_08F7,
    &lxb_unicode_data_08F8,
    &lxb_unicode_data_08F9,
    &lxb_unicode_data_08FA,
    &lxb_unicode_data_08FB,
    &lxb_unicode_data_08FC,
    &lxb_unicode_data_08FD,
    &lxb_unicode_data_08FE,
    &lxb_unicode_data_08FF,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0929,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0931,
    NULL,
    NULL,
    &lxb_unicode_data_0934,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_093C,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_094D,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0951,
    &lxb_unicode_data_0952,
    &lxb_unicode_data_0953,
    &lxb_unicode_data_0954,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0958,
    &lxb_unicode_data_0959,
    &lxb_unicode_data_095A,
    &lxb_unicode_data_095B,
    &lxb_unicode_data_095C,
    &lxb_unicode_data_095D,
    &lxb_unicode_data_095E,
    &lxb_unicode_data_095F,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_09BC,
    NULL,
    &lxb_unicode_data_09BE,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_09CB,
    &lxb_unicode_data_09CC,
    &lxb_unicode_data_09CD,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_09D7,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_09DC,
    &lxb_unicode_data_09DD,
    NULL,
    &lxb_unicode_data_09DF,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_09FE,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0A33,
    NULL,
    NULL,
    &lxb_unicode_data_0A36,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0A3C,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0A4D,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0A59,
    &lxb_unicode_data_0A5A,
    &lxb_unicode_data_0A5B,
    NULL,
    NULL,
    &lxb_unicode_data_0A5E,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0ABC,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0ACD,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0B3C,
    NULL,
    &lxb_unicode_data_0B3E,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0B48,
    NULL,
    NULL,
    &lxb_unicode_data_0B4B,
    &lxb_unicode_data_0B4C,
    &lxb_unicode_data_0B4D,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0B56,
    &lxb_unicode_data_0B57,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0B5C,
    &lxb_unicode_data_0B5D,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0B94,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0BBE,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0BCA,
    &lxb_unicode_data_0BCB,
    &lxb_unicode_data_0BCC,
    &lxb_unicode_data_0BCD,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0BD7,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0C3C,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0C48,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0C4D,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0C55,
    &lxb_unicode_data_0C56,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0CBC,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0CC0,
    NULL,
    &lxb_unicode_data_0CC2,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0CC7,
    &lxb_unicode_data_0CC8,
    NULL,
    &lxb_unicode_data_0CCA,
    &lxb_unicode_data_0CCB,
    NULL,
    &lxb_unicode_data_0CCD,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0CD5,
    &lxb_unicode_data_0CD6,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0D3B,
    &lxb_unicode_data_0D3C,
    NULL,
    &lxb_unicode_data_0D3E,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0D4A,
    &lxb_unicode_data_0D4B,
    &lxb_unicode_data_0D4C,
    &lxb_unicode_data_0D4D,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0D57,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0DCA,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0DCF,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0DDA,
    NULL,
    &lxb_unicode_data_0DDC,
    &lxb_unicode_data_0DDD,
    &lxb_unicode_data_0DDE,
    &lxb_unicode_data_0DDF,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0E33,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0E38,
    &lxb_unicode_data_0E39,
    &lxb_unicode_data_0E3A,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0E48,
    &lxb_unicode_data_0E49,
    &lxb_unicode_data_0E4A,
    &lxb_unicode_data_0E4B,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0EB3,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0EB8,
    &lxb_unicode_data_0EB9,
    &lxb_unicode_data_0EBA,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0EC8,
    &lxb_unicode_data_0EC9,
    &lxb_unicode_data_0ECA,
    &lxb_unicode_data_0ECB,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0EDC,
    &lxb_unicode_data_0EDD,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F0C,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F18,
    &lxb_unicode_data_0F19,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F35,
    NULL,
    &lxb_unicode_data_0F37,
    NULL,
    &lxb_unicode_data_0F39,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F43,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F4D,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F52,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F57,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F5C,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F69,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F71,
    &lxb_unicode_data_0F72,
    &lxb_unicode_data_0F73,
    &lxb_unicode_data_0F74,
    &lxb_unicode_data_0F75,
    &lxb_unicode_data_0F76,
    &lxb_unicode_data_0F77,
    &lxb_unicode_data_0F78,
    &lxb_unicode_data_0F79,
    &lxb_unicode_data_0F7A,
    &lxb_unicode_data_0F7B,
    &lxb_unicode_data_0F7C,
    &lxb_unicode_data_0F7D,
    NULL,
    NULL,
    &lxb_unicode_data_0F80,
    &lxb_unicode_data_0F81,
    &lxb_unicode_data_0F82,
    &lxb_unicode_data_0F83,
    &lxb_unicode_data_0F84,
    NULL,
    &lxb_unicode_data_0F86,
    &lxb_unicode_data_0F87,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F93,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0F9D,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0FA2,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0FA7,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0FAC,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0FB9,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_0FC6,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1026,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_102E,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1037,
    NULL,
    &lxb_unicode_data_1039,
    &lxb_unicode_data_103A,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_108D,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10C7,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10CD,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_10FC,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1161,
    &lxb_unicode_data_1162,
    &lxb_unicode_data_1163,
    &lxb_unicode_data_1164,
    &lxb_unicode_data_1165,
    &lxb_unicode_data_1166,
    &lxb_unicode_data_1167,
    &lxb_unicode_data_1168,
    &lxb_unicode_data_1169,
    &lxb_unicode_data_116A,
    &lxb_unicode_data_116B,
    &lxb_unicode_data_116C,
    &lxb_unicode_data_116D,
    &lxb_unicode_data_116E,
    &lxb_unicode_data_116F,
    &lxb_unicode_data_1170,
    &lxb_unicode_data_1171,
    &lxb_unicode_data_1172,
    &lxb_unicode_data_1173,
    &lxb_unicode_data_1174,
    &lxb_unicode_data_1175,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_11A8,
    &lxb_unicode_data_11A9,
    &lxb_unicode_data_11AA,
    &lxb_unicode_data_11AB,
    &lxb_unicode_data_11AC,
    &lxb_unicode_data_11AD,
    &lxb_unicode_data_11AE,
    &lxb_unicode_data_11AF,
    &lxb_unicode_data_11B0,
    &lxb_unicode_data_11B1,
    &lxb_unicode_data_11B2,
    &lxb_unicode_data_11B3,
    &lxb_unicode_data_11B4,
    &lxb_unicode_data_11B5,
    &lxb_unicode_data_11B6,
    &lxb_unicode_data_11B7,
    &lxb_unicode_data_11B8,
    &lxb_unicode_data_11B9,
    &lxb_unicode_data_11BA,
    &lxb_unicode_data_11BB,
    &lxb_unicode_data_11BC,
    &lxb_unicode_data_11BD,
    &lxb_unicode_data_11BE,
    &lxb_unicode_data_11BF,
    &lxb_unicode_data_11C0,
    &lxb_unicode_data_11C1,
    &lxb_unicode_data_11C2,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_135D,
    &lxb_unicode_data_135E,
    &lxb_unicode_data_135F,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL
};


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* LEXBOR_UNICODE_TABLES_0_H */
