










package com.adacore.libadalang;

import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.Objects;
import java.util.Optional;

import java.lang.StringBuilder;
import java.lang.Iterable;
import java.lang.reflect.Method;

import java.math.BigInteger;

import java.io.File;
import java.nio.ByteOrder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;

import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.*;
import org.graalvm.nativeimage.c.type.*;
import org.graalvm.word.PointerBase;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;


/*
====================

This is the Java bindings of the libadalang API.
You can use all functionalities of the library in a Java environment.
Those bindings call the native library using JNI and Native-Image C API.

====================
*/
public final class Libadalang {

    // ==========
    // Native entry points
    // ==========

    /**
     * This method is the only valid callback to pass to a native event
     * handler for unit requests events.
     * This method will dispatch the execution according to the passed
     * analysis context.
     */
    @CEntryPoint
    static void unitRequested(
        final IsolateThread thread,
        final AnalysisContextNative contextNative,
        final TextNative nameNative,
        final AnalysisUnitNative fromNative,
        final byte foundNative,
        final byte isNotFoundErrorNative
    ) {
        try(
            final AnalysisContext context = AnalysisContext.wrap(
                contextNative
            );
            final Text text = Text.wrap(nameNative)
        ) {
            // Get the callback from the context event handler
            final EventHandler.UnitRequestedCallback callback = context
                .getEventHandler()
                .getUnitRequestCallback();

            // Call the callback
            if(callback != null) {
                callback.invoke(
                    context,
                    text.getContent(),
                    AnalysisUnit.wrap(fromNative),
                    foundNative != 0,
                    isNotFoundErrorNative != 0
                );
            }
        }
    }

    /**
     * This method is the only valid callback to pass to a native event
     * handler for unit parsing events.
     * This method will dispatch the execution according to the passed
     * analysis context.
     */
    @CEntryPoint
    static void unitParsed(
        final IsolateThread thread,
        final AnalysisContextNative contextNative,
        final AnalysisUnitNative unitNative,
        final byte reparsedNative
    ) {
        try(
            final AnalysisContext context = AnalysisContext.wrap(
                contextNative
            )
        ) {
            // Get the callback from the context event handler
            final EventHandler.UnitParsedCallback callback = context
                .getEventHandler()
                .getUnitParsedCallback();

            // Call the callback
            if(callback != null) {
                callback.invoke(
                    context,
                    AnalysisUnit.wrap(unitNative),
                    reparsedNative != 0
                );
            }
        }
    }

    // ==========
    // Static values
    // ==========

    /** The default grammar rule to parse the inputs. */
    private static final GrammarRule DEFAULT_GRAMMAR_RULE =
        GrammarRule.COMPILATION_RULE;

    /** The os name in lower case. */
    private static final String OS =
            System.getProperty("os.name").toLowerCase();

    /** The byte order of the system. */
    private static final ByteOrder BYTE_ORDER = ByteOrder.nativeOrder();

    /** The node to convert a Java string to a truffle string */
    private static final TruffleString.FromJavaStringNode fromJavaStringNode =
        TruffleString.FromJavaStringNode.create();

    /** The node to convert a truffle string to a Java string. */
    private static final TruffleString.ToJavaStringNode toJavaStringNode =
        TruffleString.ToJavaStringNode.create();

    /** The node to convert a byte array to a truffle string. */
    private static final TruffleString.FromByteArrayNode fromByteArrayNode =
        TruffleString.FromByteArrayNode.create();

    /** The node to convert a truffle string to a byte array. */
    private static final TruffleString.CopyToByteArrayNode toByteArrayNode =
        TruffleString.CopyToByteArrayNode.create();

    /** A map to store node descriptions associated to their camel name. */
    public static final Map<String, Reflection.Node>
        NODE_DESCRIPTION_MAP = new HashMap<>();

    static {
        // Fill the node description map and set the node kind descriptions
        NODE_DESCRIPTION_MAP.put(
            "AdaNode",
            AdaNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbortNode",
            AbortNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbortAbsent",
            AbortAbsent.description
        );
        NodeKind.ABORT_ABSENT.setDescription(
            AbortAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbortPresent",
            AbortPresent.description
        );
        NodeKind.ABORT_PRESENT.setDescription(
            AbortPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbstractNode",
            AbstractNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbstractAbsent",
            AbstractAbsent.description
        );
        NodeKind.ABSTRACT_ABSENT.setDescription(
            AbstractAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbstractPresent",
            AbstractPresent.description
        );
        NodeKind.ABSTRACT_PRESENT.setDescription(
            AbstractPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AdaList",
            AdaList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AdaNodeList",
            AdaNodeList.description
        );
        NodeKind.ADA_NODE_LIST.setDescription(
            AdaNodeList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbstractStateDeclList",
            AbstractStateDeclList.description
        );
        NodeKind.ABSTRACT_STATE_DECL_LIST.setDescription(
            AbstractStateDeclList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AlternativesList",
            AlternativesList.description
        );
        NodeKind.ALTERNATIVES_LIST.setDescription(
            AlternativesList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConstraintList",
            ConstraintList.description
        );
        NodeKind.CONSTRAINT_LIST.setDescription(
            ConstraintList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DeclList",
            DeclList.description
        );
        NodeKind.DECL_LIST.setDescription(
            DeclList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "StmtList",
            StmtList.description
        );
        NodeKind.STMT_LIST.setDescription(
            StmtList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AspectAssocList",
            AspectAssocList.description
        );
        NodeKind.ASPECT_ASSOC_LIST.setDescription(
            AspectAssocList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseAssocList",
            BaseAssocList.description
        );
        NodeKind.BASE_ASSOC_LIST.setDescription(
            BaseAssocList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BasicAssocList",
            BasicAssocList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AssocList",
            AssocList.description
        );
        NodeKind.ASSOC_LIST.setDescription(
            AssocList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CaseExprAlternativeList",
            CaseExprAlternativeList.description
        );
        NodeKind.CASE_EXPR_ALTERNATIVE_LIST.setDescription(
            CaseExprAlternativeList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CaseStmtAlternativeList",
            CaseStmtAlternativeList.description
        );
        NodeKind.CASE_STMT_ALTERNATIVE_LIST.setDescription(
            CaseStmtAlternativeList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CompilationUnitList",
            CompilationUnitList.description
        );
        NodeKind.COMPILATION_UNIT_LIST.setDescription(
            CompilationUnitList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConcatOperandList",
            ConcatOperandList.description
        );
        NodeKind.CONCAT_OPERAND_LIST.setDescription(
            ConcatOperandList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ContractCaseAssocList",
            ContractCaseAssocList.description
        );
        NodeKind.CONTRACT_CASE_ASSOC_LIST.setDescription(
            ContractCaseAssocList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DefiningNameList",
            DefiningNameList.description
        );
        NodeKind.DEFINING_NAME_LIST.setDescription(
            DefiningNameList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DiscriminantSpecList",
            DiscriminantSpecList.description
        );
        NodeKind.DISCRIMINANT_SPEC_LIST.setDescription(
            DiscriminantSpecList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ElsifExprPartList",
            ElsifExprPartList.description
        );
        NodeKind.ELSIF_EXPR_PART_LIST.setDescription(
            ElsifExprPartList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ElsifStmtPartList",
            ElsifStmtPartList.description
        );
        NodeKind.ELSIF_STMT_PART_LIST.setDescription(
            ElsifStmtPartList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EnumLiteralDeclList",
            EnumLiteralDeclList.description
        );
        NodeKind.ENUM_LITERAL_DECL_LIST.setDescription(
            EnumLiteralDeclList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ExprList",
            ExprList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ExprAlternativesList",
            ExprAlternativesList.description
        );
        NodeKind.EXPR_ALTERNATIVES_LIST.setDescription(
            ExprAlternativesList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormatStringChunkList",
            FormatStringChunkList.description
        );
        NodeKind.FORMAT_STRING_CHUNK_LIST.setDescription(
            FormatStringChunkList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IdentifierList",
            IdentifierList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DiscriminantChoiceList",
            DiscriminantChoiceList.description
        );
        NodeKind.DISCRIMINANT_CHOICE_LIST.setDescription(
            DiscriminantChoiceList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NameList",
            NameList.description
        );
        NodeKind.NAME_LIST.setDescription(
            NameList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ParentList",
            ParentList.description
        );
        NodeKind.PARENT_LIST.setDescription(
            ParentList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ParamSpecList",
            ParamSpecList.description
        );
        NodeKind.PARAM_SPEC_LIST.setDescription(
            ParamSpecList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PragmaNodeList",
            PragmaNodeList.description
        );
        NodeKind.PRAGMA_NODE_LIST.setDescription(
            PragmaNodeList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SelectWhenPartList",
            SelectWhenPartList.description
        );
        NodeKind.SELECT_WHEN_PART_LIST.setDescription(
            SelectWhenPartList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UnconstrainedArrayIndexList",
            UnconstrainedArrayIndexList.description
        );
        NodeKind.UNCONSTRAINED_ARRAY_INDEX_LIST.setDescription(
            UnconstrainedArrayIndexList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "VariantList",
            VariantList.description
        );
        NodeKind.VARIANT_LIST.setDescription(
            VariantList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AliasedNode",
            AliasedNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AliasedAbsent",
            AliasedAbsent.description
        );
        NodeKind.ALIASED_ABSENT.setDescription(
            AliasedAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AliasedPresent",
            AliasedPresent.description
        );
        NodeKind.ALIASED_PRESENT.setDescription(
            AliasedPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AllNode",
            AllNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AllAbsent",
            AllAbsent.description
        );
        NodeKind.ALL_ABSENT.setDescription(
            AllAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AllPresent",
            AllPresent.description
        );
        NodeKind.ALL_PRESENT.setDescription(
            AllPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ArrayIndices",
            ArrayIndices.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConstrainedArrayIndices",
            ConstrainedArrayIndices.description
        );
        NodeKind.CONSTRAINED_ARRAY_INDICES.setDescription(
            ConstrainedArrayIndices.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UnconstrainedArrayIndices",
            UnconstrainedArrayIndices.description
        );
        NodeKind.UNCONSTRAINED_ARRAY_INDICES.setDescription(
            UnconstrainedArrayIndices.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AspectAssoc",
            AspectAssoc.description
        );
        NodeKind.ASPECT_ASSOC.setDescription(
            AspectAssoc.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AspectClause",
            AspectClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AtClause",
            AtClause.description
        );
        NodeKind.AT_CLAUSE.setDescription(
            AtClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AttributeDefClause",
            AttributeDefClause.description
        );
        NodeKind.ATTRIBUTE_DEF_CLAUSE.setDescription(
            AttributeDefClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EnumRepClause",
            EnumRepClause.description
        );
        NodeKind.ENUM_REP_CLAUSE.setDescription(
            EnumRepClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RecordRepClause",
            RecordRepClause.description
        );
        NodeKind.RECORD_REP_CLAUSE.setDescription(
            RecordRepClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AspectSpec",
            AspectSpec.description
        );
        NodeKind.ASPECT_SPEC.setDescription(
            AspectSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseAssoc",
            BaseAssoc.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ContractCaseAssoc",
            ContractCaseAssoc.description
        );
        NodeKind.CONTRACT_CASE_ASSOC.setDescription(
            ContractCaseAssoc.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PragmaArgumentAssoc",
            PragmaArgumentAssoc.description
        );
        NodeKind.PRAGMA_ARGUMENT_ASSOC.setDescription(
            PragmaArgumentAssoc.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseFormalParamHolder",
            BaseFormalParamHolder.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseSubpSpec",
            BaseSubpSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EntrySpec",
            EntrySpec.description
        );
        NodeKind.ENTRY_SPEC.setDescription(
            EntrySpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EnumSubpSpec",
            EnumSubpSpec.description
        );
        NodeKind.ENUM_SUBP_SPEC.setDescription(
            EnumSubpSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SubpSpec",
            SubpSpec.description
        );
        NodeKind.SUBP_SPEC.setDescription(
            SubpSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SyntheticBinarySpec",
            SyntheticBinarySpec.description
        );
        NodeKind.SYNTHETIC_BINARY_SPEC.setDescription(
            SyntheticBinarySpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SyntheticUnarySpec",
            SyntheticUnarySpec.description
        );
        NodeKind.SYNTHETIC_UNARY_SPEC.setDescription(
            SyntheticUnarySpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ComponentList",
            ComponentList.description
        );
        NodeKind.COMPONENT_LIST.setDescription(
            ComponentList.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DiscriminantPart",
            DiscriminantPart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "KnownDiscriminantPart",
            KnownDiscriminantPart.description
        );
        NodeKind.KNOWN_DISCRIMINANT_PART.setDescription(
            KnownDiscriminantPart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UnknownDiscriminantPart",
            UnknownDiscriminantPart.description
        );
        NodeKind.UNKNOWN_DISCRIMINANT_PART.setDescription(
            UnknownDiscriminantPart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EntryCompletionFormalParams",
            EntryCompletionFormalParams.description
        );
        NodeKind.ENTRY_COMPLETION_FORMAL_PARAMS.setDescription(
            EntryCompletionFormalParams.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericFormalPart",
            GenericFormalPart.description
        );
        NodeKind.GENERIC_FORMAL_PART.setDescription(
            GenericFormalPart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseRecordDef",
            BaseRecordDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NullRecordDef",
            NullRecordDef.description
        );
        NodeKind.NULL_RECORD_DEF.setDescription(
            NullRecordDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RecordDef",
            RecordDef.description
        );
        NodeKind.RECORD_DEF.setDescription(
            RecordDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BasicAssoc",
            BasicAssoc.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AggregateAssoc",
            AggregateAssoc.description
        );
        NodeKind.AGGREGATE_ASSOC.setDescription(
            AggregateAssoc.description
        );
        NODE_DESCRIPTION_MAP.put(
            "MultiDimArrayAssoc",
            MultiDimArrayAssoc.description
        );
        NodeKind.MULTI_DIM_ARRAY_ASSOC.setDescription(
            MultiDimArrayAssoc.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CompositeConstraintAssoc",
            CompositeConstraintAssoc.description
        );
        NodeKind.COMPOSITE_CONSTRAINT_ASSOC.setDescription(
            CompositeConstraintAssoc.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IteratedAssoc",
            IteratedAssoc.description
        );
        NodeKind.ITERATED_ASSOC.setDescription(
            IteratedAssoc.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ParamAssoc",
            ParamAssoc.description
        );
        NodeKind.PARAM_ASSOC.setDescription(
            ParamAssoc.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BasicDecl",
            BasicDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbstractStateDecl",
            AbstractStateDecl.description
        );
        NodeKind.ABSTRACT_STATE_DECL.setDescription(
            AbstractStateDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AnonymousExprDecl",
            AnonymousExprDecl.description
        );
        NodeKind.ANONYMOUS_EXPR_DECL.setDescription(
            AnonymousExprDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseFormalParamDecl",
            BaseFormalParamDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ComponentDecl",
            ComponentDecl.description
        );
        NodeKind.COMPONENT_DECL.setDescription(
            ComponentDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DiscriminantSpec",
            DiscriminantSpec.description
        );
        NodeKind.DISCRIMINANT_SPEC.setDescription(
            DiscriminantSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericFormal",
            GenericFormal.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericFormalObjDecl",
            GenericFormalObjDecl.description
        );
        NodeKind.GENERIC_FORMAL_OBJ_DECL.setDescription(
            GenericFormalObjDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericFormalPackage",
            GenericFormalPackage.description
        );
        NodeKind.GENERIC_FORMAL_PACKAGE.setDescription(
            GenericFormalPackage.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericFormalSubpDecl",
            GenericFormalSubpDecl.description
        );
        NodeKind.GENERIC_FORMAL_SUBP_DECL.setDescription(
            GenericFormalSubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericFormalTypeDecl",
            GenericFormalTypeDecl.description
        );
        NodeKind.GENERIC_FORMAL_TYPE_DECL.setDescription(
            GenericFormalTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ParamSpec",
            ParamSpec.description
        );
        NodeKind.PARAM_SPEC.setDescription(
            ParamSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SyntheticFormalParamDecl",
            SyntheticFormalParamDecl.description
        );
        NodeKind.SYNTHETIC_FORMAL_PARAM_DECL.setDescription(
            SyntheticFormalParamDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BasePackageDecl",
            BasePackageDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericPackageInternal",
            GenericPackageInternal.description
        );
        NodeKind.GENERIC_PACKAGE_INTERNAL.setDescription(
            GenericPackageInternal.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PackageDecl",
            PackageDecl.description
        );
        NodeKind.PACKAGE_DECL.setDescription(
            PackageDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseTypeDecl",
            BaseTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseSubtypeDecl",
            BaseSubtypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DiscreteBaseSubtypeDecl",
            DiscreteBaseSubtypeDecl.description
        );
        NodeKind.DISCRETE_BASE_SUBTYPE_DECL.setDescription(
            DiscreteBaseSubtypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SubtypeDecl",
            SubtypeDecl.description
        );
        NodeKind.SUBTYPE_DECL.setDescription(
            SubtypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ClasswideTypeDecl",
            ClasswideTypeDecl.description
        );
        NodeKind.CLASSWIDE_TYPE_DECL.setDescription(
            ClasswideTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IncompleteTypeDecl",
            IncompleteTypeDecl.description
        );
        NodeKind.INCOMPLETE_TYPE_DECL.setDescription(
            IncompleteTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IncompleteFormalTypeDecl",
            IncompleteFormalTypeDecl.description
        );
        NodeKind.INCOMPLETE_FORMAL_TYPE_DECL.setDescription(
            IncompleteFormalTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IncompleteTaggedTypeDecl",
            IncompleteTaggedTypeDecl.description
        );
        NodeKind.INCOMPLETE_TAGGED_TYPE_DECL.setDescription(
            IncompleteTaggedTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ProtectedTypeDecl",
            ProtectedTypeDecl.description
        );
        NodeKind.PROTECTED_TYPE_DECL.setDescription(
            ProtectedTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TaskTypeDecl",
            TaskTypeDecl.description
        );
        NodeKind.TASK_TYPE_DECL.setDescription(
            TaskTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SingleTaskTypeDecl",
            SingleTaskTypeDecl.description
        );
        NodeKind.SINGLE_TASK_TYPE_DECL.setDescription(
            SingleTaskTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TypeDecl",
            TypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AnonymousTypeDecl",
            AnonymousTypeDecl.description
        );
        NodeKind.ANONYMOUS_TYPE_DECL.setDescription(
            AnonymousTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SynthAnonymousTypeDecl",
            SynthAnonymousTypeDecl.description
        );
        NodeKind.SYNTH_ANONYMOUS_TYPE_DECL.setDescription(
            SynthAnonymousTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConcreteTypeDecl",
            ConcreteTypeDecl.description
        );
        NodeKind.CONCRETE_TYPE_DECL.setDescription(
            ConcreteTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormalTypeDecl",
            FormalTypeDecl.description
        );
        NodeKind.FORMAL_TYPE_DECL.setDescription(
            FormalTypeDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BasicSubpDecl",
            BasicSubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ClassicSubpDecl",
            ClassicSubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbstractSubpDecl",
            AbstractSubpDecl.description
        );
        NodeKind.ABSTRACT_SUBP_DECL.setDescription(
            AbstractSubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormalSubpDecl",
            FormalSubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbstractFormalSubpDecl",
            AbstractFormalSubpDecl.description
        );
        NodeKind.ABSTRACT_FORMAL_SUBP_DECL.setDescription(
            AbstractFormalSubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConcreteFormalSubpDecl",
            ConcreteFormalSubpDecl.description
        );
        NodeKind.CONCRETE_FORMAL_SUBP_DECL.setDescription(
            ConcreteFormalSubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SubpDecl",
            SubpDecl.description
        );
        NodeKind.SUBP_DECL.setDescription(
            SubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EntryDecl",
            EntryDecl.description
        );
        NodeKind.ENTRY_DECL.setDescription(
            EntryDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EnumLiteralDecl",
            EnumLiteralDecl.description
        );
        NodeKind.ENUM_LITERAL_DECL.setDescription(
            EnumLiteralDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SyntheticCharEnumLit",
            SyntheticCharEnumLit.description
        );
        NodeKind.SYNTHETIC_CHAR_ENUM_LIT.setDescription(
            SyntheticCharEnumLit.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericSubpInternal",
            GenericSubpInternal.description
        );
        NodeKind.GENERIC_SUBP_INTERNAL.setDescription(
            GenericSubpInternal.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SyntheticSubpDecl",
            SyntheticSubpDecl.description
        );
        NodeKind.SYNTHETIC_SUBP_DECL.setDescription(
            SyntheticSubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BodyNode",
            BodyNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AcceptStmtBody",
            AcceptStmtBody.description
        );
        NodeKind.ACCEPT_STMT_BODY.setDescription(
            AcceptStmtBody.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseSubpBody",
            BaseSubpBody.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ExprFunction",
            ExprFunction.description
        );
        NodeKind.EXPR_FUNCTION.setDescription(
            ExprFunction.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NullSubpDecl",
            NullSubpDecl.description
        );
        NodeKind.NULL_SUBP_DECL.setDescription(
            NullSubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SubpBody",
            SubpBody.description
        );
        NodeKind.SUBP_BODY.setDescription(
            SubpBody.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SubpRenamingDecl",
            SubpRenamingDecl.description
        );
        NodeKind.SUBP_RENAMING_DECL.setDescription(
            SubpRenamingDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BodyStub",
            BodyStub.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PackageBodyStub",
            PackageBodyStub.description
        );
        NodeKind.PACKAGE_BODY_STUB.setDescription(
            PackageBodyStub.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ProtectedBodyStub",
            ProtectedBodyStub.description
        );
        NodeKind.PROTECTED_BODY_STUB.setDescription(
            ProtectedBodyStub.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SubpBodyStub",
            SubpBodyStub.description
        );
        NodeKind.SUBP_BODY_STUB.setDescription(
            SubpBodyStub.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TaskBodyStub",
            TaskBodyStub.description
        );
        NodeKind.TASK_BODY_STUB.setDescription(
            TaskBodyStub.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EntryBody",
            EntryBody.description
        );
        NodeKind.ENTRY_BODY.setDescription(
            EntryBody.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PackageBody",
            PackageBody.description
        );
        NodeKind.PACKAGE_BODY.setDescription(
            PackageBody.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ProtectedBody",
            ProtectedBody.description
        );
        NodeKind.PROTECTED_BODY.setDescription(
            ProtectedBody.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TaskBody",
            TaskBody.description
        );
        NodeKind.TASK_BODY.setDescription(
            TaskBody.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EntryIndexSpec",
            EntryIndexSpec.description
        );
        NodeKind.ENTRY_INDEX_SPEC.setDescription(
            EntryIndexSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ErrorDecl",
            ErrorDecl.description
        );
        NodeKind.ERROR_DECL.setDescription(
            ErrorDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ExceptionDecl",
            ExceptionDecl.description
        );
        NodeKind.EXCEPTION_DECL.setDescription(
            ExceptionDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ExceptionHandler",
            ExceptionHandler.description
        );
        NodeKind.EXCEPTION_HANDLER.setDescription(
            ExceptionHandler.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ForLoopVarDecl",
            ForLoopVarDecl.description
        );
        NodeKind.FOR_LOOP_VAR_DECL.setDescription(
            ForLoopVarDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericDecl",
            GenericDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericPackageDecl",
            GenericPackageDecl.description
        );
        NodeKind.GENERIC_PACKAGE_DECL.setDescription(
            GenericPackageDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericSubpDecl",
            GenericSubpDecl.description
        );
        NodeKind.GENERIC_SUBP_DECL.setDescription(
            GenericSubpDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericInstantiation",
            GenericInstantiation.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericPackageInstantiation",
            GenericPackageInstantiation.description
        );
        NodeKind.GENERIC_PACKAGE_INSTANTIATION.setDescription(
            GenericPackageInstantiation.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericSubpInstantiation",
            GenericSubpInstantiation.description
        );
        NodeKind.GENERIC_SUBP_INSTANTIATION.setDescription(
            GenericSubpInstantiation.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericRenamingDecl",
            GenericRenamingDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericPackageRenamingDecl",
            GenericPackageRenamingDecl.description
        );
        NodeKind.GENERIC_PACKAGE_RENAMING_DECL.setDescription(
            GenericPackageRenamingDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GenericSubpRenamingDecl",
            GenericSubpRenamingDecl.description
        );
        NodeKind.GENERIC_SUBP_RENAMING_DECL.setDescription(
            GenericSubpRenamingDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "LabelDecl",
            LabelDecl.description
        );
        NodeKind.LABEL_DECL.setDescription(
            LabelDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NamedStmtDecl",
            NamedStmtDecl.description
        );
        NodeKind.NAMED_STMT_DECL.setDescription(
            NamedStmtDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NumberDecl",
            NumberDecl.description
        );
        NodeKind.NUMBER_DECL.setDescription(
            NumberDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ObjectDecl",
            ObjectDecl.description
        );
        NodeKind.OBJECT_DECL.setDescription(
            ObjectDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ExtendedReturnStmtObjectDecl",
            ExtendedReturnStmtObjectDecl.description
        );
        NodeKind.EXTENDED_RETURN_STMT_OBJECT_DECL.setDescription(
            ExtendedReturnStmtObjectDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NoTypeObjectRenamingDecl",
            NoTypeObjectRenamingDecl.description
        );
        NodeKind.NO_TYPE_OBJECT_RENAMING_DECL.setDescription(
            NoTypeObjectRenamingDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PackageRenamingDecl",
            PackageRenamingDecl.description
        );
        NodeKind.PACKAGE_RENAMING_DECL.setDescription(
            PackageRenamingDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SingleProtectedDecl",
            SingleProtectedDecl.description
        );
        NodeKind.SINGLE_PROTECTED_DECL.setDescription(
            SingleProtectedDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SingleTaskDecl",
            SingleTaskDecl.description
        );
        NodeKind.SINGLE_TASK_DECL.setDescription(
            SingleTaskDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SyntheticObjectDecl",
            SyntheticObjectDecl.description
        );
        NodeKind.SYNTHETIC_OBJECT_DECL.setDescription(
            SyntheticObjectDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CaseStmtAlternative",
            CaseStmtAlternative.description
        );
        NodeKind.CASE_STMT_ALTERNATIVE.setDescription(
            CaseStmtAlternative.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CompilationUnit",
            CompilationUnit.description
        );
        NodeKind.COMPILATION_UNIT.setDescription(
            CompilationUnit.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ComponentClause",
            ComponentClause.description
        );
        NodeKind.COMPONENT_CLAUSE.setDescription(
            ComponentClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ComponentDef",
            ComponentDef.description
        );
        NodeKind.COMPONENT_DEF.setDescription(
            ComponentDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConstantNode",
            ConstantNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConstantAbsent",
            ConstantAbsent.description
        );
        NodeKind.CONSTANT_ABSENT.setDescription(
            ConstantAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConstantPresent",
            ConstantPresent.description
        );
        NodeKind.CONSTANT_PRESENT.setDescription(
            ConstantPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Constraint",
            Constraint.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CompositeConstraint",
            CompositeConstraint.description
        );
        NodeKind.COMPOSITE_CONSTRAINT.setDescription(
            CompositeConstraint.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DeltaConstraint",
            DeltaConstraint.description
        );
        NodeKind.DELTA_CONSTRAINT.setDescription(
            DeltaConstraint.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DigitsConstraint",
            DigitsConstraint.description
        );
        NodeKind.DIGITS_CONSTRAINT.setDescription(
            DigitsConstraint.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RangeConstraint",
            RangeConstraint.description
        );
        NodeKind.RANGE_CONSTRAINT.setDescription(
            RangeConstraint.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DeclarativePart",
            DeclarativePart.description
        );
        NodeKind.DECLARATIVE_PART.setDescription(
            DeclarativePart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PrivatePart",
            PrivatePart.description
        );
        NodeKind.PRIVATE_PART.setDescription(
            PrivatePart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PublicPart",
            PublicPart.description
        );
        NodeKind.PUBLIC_PART.setDescription(
            PublicPart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ElsifExprPart",
            ElsifExprPart.description
        );
        NodeKind.ELSIF_EXPR_PART.setDescription(
            ElsifExprPart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ElsifStmtPart",
            ElsifStmtPart.description
        );
        NodeKind.ELSIF_STMT_PART.setDescription(
            ElsifStmtPart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Expr",
            Expr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbstractStateDeclExpr",
            AbstractStateDeclExpr.description
        );
        NodeKind.ABSTRACT_STATE_DECL_EXPR.setDescription(
            AbstractStateDeclExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Allocator",
            Allocator.description
        );
        NodeKind.ALLOCATOR.setDescription(
            Allocator.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseAggregate",
            BaseAggregate.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Aggregate",
            Aggregate.description
        );
        NodeKind.AGGREGATE.setDescription(
            Aggregate.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BracketAggregate",
            BracketAggregate.description
        );
        NodeKind.BRACKET_AGGREGATE.setDescription(
            BracketAggregate.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DeltaAggregate",
            DeltaAggregate.description
        );
        NodeKind.DELTA_AGGREGATE.setDescription(
            DeltaAggregate.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BracketDeltaAggregate",
            BracketDeltaAggregate.description
        );
        NodeKind.BRACKET_DELTA_AGGREGATE.setDescription(
            BracketDeltaAggregate.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NullRecordAggregate",
            NullRecordAggregate.description
        );
        NodeKind.NULL_RECORD_AGGREGATE.setDescription(
            NullRecordAggregate.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BinOp",
            BinOp.description
        );
        NodeKind.BIN_OP.setDescription(
            BinOp.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RelationOp",
            RelationOp.description
        );
        NodeKind.RELATION_OP.setDescription(
            RelationOp.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BoxExpr",
            BoxExpr.description
        );
        NodeKind.BOX_EXPR.setDescription(
            BoxExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CaseExprAlternative",
            CaseExprAlternative.description
        );
        NodeKind.CASE_EXPR_ALTERNATIVE.setDescription(
            CaseExprAlternative.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConcatOp",
            ConcatOp.description
        );
        NodeKind.CONCAT_OP.setDescription(
            ConcatOp.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConcatOperand",
            ConcatOperand.description
        );
        NodeKind.CONCAT_OPERAND.setDescription(
            ConcatOperand.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CondExpr",
            CondExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CaseExpr",
            CaseExpr.description
        );
        NodeKind.CASE_EXPR.setDescription(
            CaseExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IfExpr",
            IfExpr.description
        );
        NodeKind.IF_EXPR.setDescription(
            IfExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ContractCases",
            ContractCases.description
        );
        NodeKind.CONTRACT_CASES.setDescription(
            ContractCases.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DeclExpr",
            DeclExpr.description
        );
        NodeKind.DECL_EXPR.setDescription(
            DeclExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormatStringLiteral",
            FormatStringLiteral.description
        );
        NodeKind.FORMAT_STRING_LITERAL.setDescription(
            FormatStringLiteral.description
        );
        NODE_DESCRIPTION_MAP.put(
            "MembershipExpr",
            MembershipExpr.description
        );
        NodeKind.MEMBERSHIP_EXPR.setDescription(
            MembershipExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Name",
            Name.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ArraySubcomponentChoiceName",
            ArraySubcomponentChoiceName.description
        );
        NodeKind.ARRAY_SUBCOMPONENT_CHOICE_NAME.setDescription(
            ArraySubcomponentChoiceName.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AttributeRef",
            AttributeRef.description
        );
        NodeKind.ATTRIBUTE_REF.setDescription(
            AttributeRef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CallExpr",
            CallExpr.description
        );
        NodeKind.CALL_EXPR.setDescription(
            CallExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DefiningName",
            DefiningName.description
        );
        NodeKind.DEFINING_NAME.setDescription(
            DefiningName.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SyntheticDefiningName",
            SyntheticDefiningName.description
        );
        NodeKind.SYNTHETIC_DEFINING_NAME.setDescription(
            SyntheticDefiningName.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DiscreteSubtypeName",
            DiscreteSubtypeName.description
        );
        NodeKind.DISCRETE_SUBTYPE_NAME.setDescription(
            DiscreteSubtypeName.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DottedName",
            DottedName.description
        );
        NodeKind.DOTTED_NAME.setDescription(
            DottedName.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EndName",
            EndName.description
        );
        NodeKind.END_NAME.setDescription(
            EndName.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ExplicitDeref",
            ExplicitDeref.description
        );
        NodeKind.EXPLICIT_DEREF.setDescription(
            ExplicitDeref.description
        );
        NODE_DESCRIPTION_MAP.put(
            "QualExpr",
            QualExpr.description
        );
        NodeKind.QUAL_EXPR.setDescription(
            QualExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ReduceAttributeRef",
            ReduceAttributeRef.description
        );
        NodeKind.REDUCE_ATTRIBUTE_REF.setDescription(
            ReduceAttributeRef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SingleTokNode",
            SingleTokNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseId",
            BaseId.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CharLiteral",
            CharLiteral.description
        );
        NodeKind.CHAR_LITERAL.setDescription(
            CharLiteral.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Identifier",
            Identifier.description
        );
        NodeKind.IDENTIFIER.setDescription(
            Identifier.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Op",
            Op.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpAbs",
            OpAbs.description
        );
        NodeKind.OP_ABS.setDescription(
            OpAbs.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpAnd",
            OpAnd.description
        );
        NodeKind.OP_AND.setDescription(
            OpAnd.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpAndThen",
            OpAndThen.description
        );
        NodeKind.OP_AND_THEN.setDescription(
            OpAndThen.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpConcat",
            OpConcat.description
        );
        NodeKind.OP_CONCAT.setDescription(
            OpConcat.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpDiv",
            OpDiv.description
        );
        NodeKind.OP_DIV.setDescription(
            OpDiv.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpDoubleDot",
            OpDoubleDot.description
        );
        NodeKind.OP_DOUBLE_DOT.setDescription(
            OpDoubleDot.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpEq",
            OpEq.description
        );
        NodeKind.OP_EQ.setDescription(
            OpEq.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpGt",
            OpGt.description
        );
        NodeKind.OP_GT.setDescription(
            OpGt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpGte",
            OpGte.description
        );
        NodeKind.OP_GTE.setDescription(
            OpGte.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpIn",
            OpIn.description
        );
        NodeKind.OP_IN.setDescription(
            OpIn.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpLt",
            OpLt.description
        );
        NodeKind.OP_LT.setDescription(
            OpLt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpLte",
            OpLte.description
        );
        NodeKind.OP_LTE.setDescription(
            OpLte.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpMinus",
            OpMinus.description
        );
        NodeKind.OP_MINUS.setDescription(
            OpMinus.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpMod",
            OpMod.description
        );
        NodeKind.OP_MOD.setDescription(
            OpMod.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpMult",
            OpMult.description
        );
        NodeKind.OP_MULT.setDescription(
            OpMult.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpNeq",
            OpNeq.description
        );
        NodeKind.OP_NEQ.setDescription(
            OpNeq.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpNot",
            OpNot.description
        );
        NodeKind.OP_NOT.setDescription(
            OpNot.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpNotIn",
            OpNotIn.description
        );
        NodeKind.OP_NOT_IN.setDescription(
            OpNotIn.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpOr",
            OpOr.description
        );
        NodeKind.OP_OR.setDescription(
            OpOr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpOrElse",
            OpOrElse.description
        );
        NodeKind.OP_OR_ELSE.setDescription(
            OpOrElse.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpPlus",
            OpPlus.description
        );
        NodeKind.OP_PLUS.setDescription(
            OpPlus.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpPow",
            OpPow.description
        );
        NodeKind.OP_POW.setDescription(
            OpPow.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpRem",
            OpRem.description
        );
        NodeKind.OP_REM.setDescription(
            OpRem.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OpXor",
            OpXor.description
        );
        NodeKind.OP_XOR.setDescription(
            OpXor.description
        );
        NODE_DESCRIPTION_MAP.put(
            "StringLiteral",
            StringLiteral.description
        );
        NodeKind.STRING_LITERAL.setDescription(
            StringLiteral.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NullLiteral",
            NullLiteral.description
        );
        NodeKind.NULL_LITERAL.setDescription(
            NullLiteral.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NumLiteral",
            NumLiteral.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IntLiteral",
            IntLiteral.description
        );
        NodeKind.INT_LITERAL.setDescription(
            IntLiteral.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RealLiteral",
            RealLiteral.description
        );
        NodeKind.REAL_LITERAL.setDescription(
            RealLiteral.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SyntheticIdentifier",
            SyntheticIdentifier.description
        );
        NodeKind.SYNTHETIC_IDENTIFIER.setDescription(
            SyntheticIdentifier.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TargetName",
            TargetName.description
        );
        NodeKind.TARGET_NAME.setDescription(
            TargetName.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UpdateAttributeRef",
            UpdateAttributeRef.description
        );
        NodeKind.UPDATE_ATTRIBUTE_REF.setDescription(
            UpdateAttributeRef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ParenExpr",
            ParenExpr.description
        );
        NodeKind.PAREN_EXPR.setDescription(
            ParenExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "QuantifiedExpr",
            QuantifiedExpr.description
        );
        NodeKind.QUANTIFIED_EXPR.setDescription(
            QuantifiedExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RaiseExpr",
            RaiseExpr.description
        );
        NodeKind.RAISE_EXPR.setDescription(
            RaiseExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UnOp",
            UnOp.description
        );
        NodeKind.UN_OP.setDescription(
            UnOp.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ForLoopIterFilter",
            ForLoopIterFilter.description
        );
        NodeKind.FOR_LOOP_ITER_FILTER.setDescription(
            ForLoopIterFilter.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormatStringChunk",
            FormatStringChunk.description
        );
        NodeKind.FORMAT_STRING_CHUNK.setDescription(
            FormatStringChunk.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormatStringTokNode",
            FormatStringTokNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormatStringTokEnd",
            FormatStringTokEnd.description
        );
        NodeKind.FORMAT_STRING_TOK_END.setDescription(
            FormatStringTokEnd.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormatStringTokMid",
            FormatStringTokMid.description
        );
        NodeKind.FORMAT_STRING_TOK_MID.setDescription(
            FormatStringTokMid.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormatStringTokStart",
            FormatStringTokStart.description
        );
        NodeKind.FORMAT_STRING_TOK_START.setDescription(
            FormatStringTokStart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormatStringTokString",
            FormatStringTokString.description
        );
        NodeKind.FORMAT_STRING_TOK_STRING.setDescription(
            FormatStringTokString.description
        );
        NODE_DESCRIPTION_MAP.put(
            "HandledStmts",
            HandledStmts.description
        );
        NodeKind.HANDLED_STMTS.setDescription(
            HandledStmts.description
        );
        NODE_DESCRIPTION_MAP.put(
            "InterfaceKind",
            InterfaceKind.description
        );
        NODE_DESCRIPTION_MAP.put(
            "InterfaceKindLimited",
            InterfaceKindLimited.description
        );
        NodeKind.INTERFACE_KIND_LIMITED.setDescription(
            InterfaceKindLimited.description
        );
        NODE_DESCRIPTION_MAP.put(
            "InterfaceKindProtected",
            InterfaceKindProtected.description
        );
        NodeKind.INTERFACE_KIND_PROTECTED.setDescription(
            InterfaceKindProtected.description
        );
        NODE_DESCRIPTION_MAP.put(
            "InterfaceKindSynchronized",
            InterfaceKindSynchronized.description
        );
        NodeKind.INTERFACE_KIND_SYNCHRONIZED.setDescription(
            InterfaceKindSynchronized.description
        );
        NODE_DESCRIPTION_MAP.put(
            "InterfaceKindTask",
            InterfaceKindTask.description
        );
        NodeKind.INTERFACE_KIND_TASK.setDescription(
            InterfaceKindTask.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IterType",
            IterType.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IterTypeIn",
            IterTypeIn.description
        );
        NodeKind.ITER_TYPE_IN.setDescription(
            IterTypeIn.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IterTypeOf",
            IterTypeOf.description
        );
        NodeKind.ITER_TYPE_OF.setDescription(
            IterTypeOf.description
        );
        NODE_DESCRIPTION_MAP.put(
            "LibraryItem",
            LibraryItem.description
        );
        NodeKind.LIBRARY_ITEM.setDescription(
            LibraryItem.description
        );
        NODE_DESCRIPTION_MAP.put(
            "LimitedNode",
            LimitedNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "LimitedAbsent",
            LimitedAbsent.description
        );
        NodeKind.LIMITED_ABSENT.setDescription(
            LimitedAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "LimitedPresent",
            LimitedPresent.description
        );
        NodeKind.LIMITED_PRESENT.setDescription(
            LimitedPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "LoopSpec",
            LoopSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ForLoopSpec",
            ForLoopSpec.description
        );
        NodeKind.FOR_LOOP_SPEC.setDescription(
            ForLoopSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "WhileLoopSpec",
            WhileLoopSpec.description
        );
        NodeKind.WHILE_LOOP_SPEC.setDescription(
            WhileLoopSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Mode",
            Mode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ModeDefault",
            ModeDefault.description
        );
        NodeKind.MODE_DEFAULT.setDescription(
            ModeDefault.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ModeIn",
            ModeIn.description
        );
        NodeKind.MODE_IN.setDescription(
            ModeIn.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ModeInOut",
            ModeInOut.description
        );
        NodeKind.MODE_IN_OUT.setDescription(
            ModeInOut.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ModeOut",
            ModeOut.description
        );
        NodeKind.MODE_OUT.setDescription(
            ModeOut.description
        );
        NODE_DESCRIPTION_MAP.put(
            "MultiAbstractStateDecl",
            MultiAbstractStateDecl.description
        );
        NodeKind.MULTI_ABSTRACT_STATE_DECL.setDescription(
            MultiAbstractStateDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NotNull",
            NotNull.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NotNullAbsent",
            NotNullAbsent.description
        );
        NodeKind.NOT_NULL_ABSENT.setDescription(
            NotNullAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NotNullPresent",
            NotNullPresent.description
        );
        NodeKind.NOT_NULL_PRESENT.setDescription(
            NotNullPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NullComponentDecl",
            NullComponentDecl.description
        );
        NodeKind.NULL_COMPONENT_DECL.setDescription(
            NullComponentDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OthersDesignator",
            OthersDesignator.description
        );
        NodeKind.OTHERS_DESIGNATOR.setDescription(
            OthersDesignator.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OverridingNode",
            OverridingNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OverridingNotOverriding",
            OverridingNotOverriding.description
        );
        NodeKind.OVERRIDING_NOT_OVERRIDING.setDescription(
            OverridingNotOverriding.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OverridingOverriding",
            OverridingOverriding.description
        );
        NodeKind.OVERRIDING_OVERRIDING.setDescription(
            OverridingOverriding.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OverridingUnspecified",
            OverridingUnspecified.description
        );
        NodeKind.OVERRIDING_UNSPECIFIED.setDescription(
            OverridingUnspecified.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Params",
            Params.description
        );
        NodeKind.PARAMS.setDescription(
            Params.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ParenAbstractStateDecl",
            ParenAbstractStateDecl.description
        );
        NodeKind.PAREN_ABSTRACT_STATE_DECL.setDescription(
            ParenAbstractStateDecl.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PpDirective",
            PpDirective.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PpElseDirective",
            PpElseDirective.description
        );
        NodeKind.PP_ELSE_DIRECTIVE.setDescription(
            PpElseDirective.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PpElsifDirective",
            PpElsifDirective.description
        );
        NodeKind.PP_ELSIF_DIRECTIVE.setDescription(
            PpElsifDirective.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PpEndIfDirective",
            PpEndIfDirective.description
        );
        NodeKind.PP_END_IF_DIRECTIVE.setDescription(
            PpEndIfDirective.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PpIfDirective",
            PpIfDirective.description
        );
        NodeKind.PP_IF_DIRECTIVE.setDescription(
            PpIfDirective.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PpThenKw",
            PpThenKw.description
        );
        NodeKind.PP_THEN_KW.setDescription(
            PpThenKw.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PragmaNode",
            PragmaNode.description
        );
        NodeKind.PRAGMA_NODE.setDescription(
            PragmaNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PrivateNode",
            PrivateNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PrivateAbsent",
            PrivateAbsent.description
        );
        NodeKind.PRIVATE_ABSENT.setDescription(
            PrivateAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PrivatePresent",
            PrivatePresent.description
        );
        NodeKind.PRIVATE_PRESENT.setDescription(
            PrivatePresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ProtectedDef",
            ProtectedDef.description
        );
        NodeKind.PROTECTED_DEF.setDescription(
            ProtectedDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ProtectedNode",
            ProtectedNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ProtectedAbsent",
            ProtectedAbsent.description
        );
        NodeKind.PROTECTED_ABSENT.setDescription(
            ProtectedAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ProtectedPresent",
            ProtectedPresent.description
        );
        NodeKind.PROTECTED_PRESENT.setDescription(
            ProtectedPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Quantifier",
            Quantifier.description
        );
        NODE_DESCRIPTION_MAP.put(
            "QuantifierAll",
            QuantifierAll.description
        );
        NodeKind.QUANTIFIER_ALL.setDescription(
            QuantifierAll.description
        );
        NODE_DESCRIPTION_MAP.put(
            "QuantifierSome",
            QuantifierSome.description
        );
        NodeKind.QUANTIFIER_SOME.setDescription(
            QuantifierSome.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RangeSpec",
            RangeSpec.description
        );
        NodeKind.RANGE_SPEC.setDescription(
            RangeSpec.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RenamingClause",
            RenamingClause.description
        );
        NodeKind.RENAMING_CLAUSE.setDescription(
            RenamingClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SyntheticRenamingClause",
            SyntheticRenamingClause.description
        );
        NodeKind.SYNTHETIC_RENAMING_CLAUSE.setDescription(
            SyntheticRenamingClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ReverseNode",
            ReverseNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ReverseAbsent",
            ReverseAbsent.description
        );
        NodeKind.REVERSE_ABSENT.setDescription(
            ReverseAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ReversePresent",
            ReversePresent.description
        );
        NodeKind.REVERSE_PRESENT.setDescription(
            ReversePresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SelectWhenPart",
            SelectWhenPart.description
        );
        NodeKind.SELECT_WHEN_PART.setDescription(
            SelectWhenPart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Stmt",
            Stmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CompositeStmt",
            CompositeStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AcceptStmt",
            AcceptStmt.description
        );
        NodeKind.ACCEPT_STMT.setDescription(
            AcceptStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AcceptStmtWithStmts",
            AcceptStmtWithStmts.description
        );
        NodeKind.ACCEPT_STMT_WITH_STMTS.setDescription(
            AcceptStmtWithStmts.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseLoopStmt",
            BaseLoopStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ForLoopStmt",
            ForLoopStmt.description
        );
        NodeKind.FOR_LOOP_STMT.setDescription(
            ForLoopStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "LoopStmt",
            LoopStmt.description
        );
        NodeKind.LOOP_STMT.setDescription(
            LoopStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "WhileLoopStmt",
            WhileLoopStmt.description
        );
        NodeKind.WHILE_LOOP_STMT.setDescription(
            WhileLoopStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BlockStmt",
            BlockStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BeginBlock",
            BeginBlock.description
        );
        NodeKind.BEGIN_BLOCK.setDescription(
            BeginBlock.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DeclBlock",
            DeclBlock.description
        );
        NodeKind.DECL_BLOCK.setDescription(
            DeclBlock.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CaseStmt",
            CaseStmt.description
        );
        NodeKind.CASE_STMT.setDescription(
            CaseStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ExtendedReturnStmt",
            ExtendedReturnStmt.description
        );
        NodeKind.EXTENDED_RETURN_STMT.setDescription(
            ExtendedReturnStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "IfStmt",
            IfStmt.description
        );
        NodeKind.IF_STMT.setDescription(
            IfStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NamedStmt",
            NamedStmt.description
        );
        NodeKind.NAMED_STMT.setDescription(
            NamedStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SelectStmt",
            SelectStmt.description
        );
        NodeKind.SELECT_STMT.setDescription(
            SelectStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ErrorStmt",
            ErrorStmt.description
        );
        NodeKind.ERROR_STMT.setDescription(
            ErrorStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SimpleStmt",
            SimpleStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AbortStmt",
            AbortStmt.description
        );
        NodeKind.ABORT_STMT.setDescription(
            AbortStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AssignStmt",
            AssignStmt.description
        );
        NodeKind.ASSIGN_STMT.setDescription(
            AssignStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "CallStmt",
            CallStmt.description
        );
        NodeKind.CALL_STMT.setDescription(
            CallStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DelayStmt",
            DelayStmt.description
        );
        NodeKind.DELAY_STMT.setDescription(
            DelayStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ExitStmt",
            ExitStmt.description
        );
        NodeKind.EXIT_STMT.setDescription(
            ExitStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "GotoStmt",
            GotoStmt.description
        );
        NodeKind.GOTO_STMT.setDescription(
            GotoStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Label",
            Label.description
        );
        NodeKind.LABEL.setDescription(
            Label.description
        );
        NODE_DESCRIPTION_MAP.put(
            "NullStmt",
            NullStmt.description
        );
        NodeKind.NULL_STMT.setDescription(
            NullStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RaiseStmt",
            RaiseStmt.description
        );
        NodeKind.RAISE_STMT.setDescription(
            RaiseStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RequeueStmt",
            RequeueStmt.description
        );
        NodeKind.REQUEUE_STMT.setDescription(
            RequeueStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ReturnStmt",
            ReturnStmt.description
        );
        NodeKind.RETURN_STMT.setDescription(
            ReturnStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SimpleDeclStmt",
            SimpleDeclStmt.description
        );
        NodeKind.SIMPLE_DECL_STMT.setDescription(
            SimpleDeclStmt.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TerminateAlternative",
            TerminateAlternative.description
        );
        NodeKind.TERMINATE_ALTERNATIVE.setDescription(
            TerminateAlternative.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SubpKind",
            SubpKind.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SubpKindFunction",
            SubpKindFunction.description
        );
        NodeKind.SUBP_KIND_FUNCTION.setDescription(
            SubpKindFunction.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SubpKindProcedure",
            SubpKindProcedure.description
        );
        NodeKind.SUBP_KIND_PROCEDURE.setDescription(
            SubpKindProcedure.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Subunit",
            Subunit.description
        );
        NodeKind.SUBUNIT.setDescription(
            Subunit.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SynchronizedNode",
            SynchronizedNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SynchronizedAbsent",
            SynchronizedAbsent.description
        );
        NodeKind.SYNCHRONIZED_ABSENT.setDescription(
            SynchronizedAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SynchronizedPresent",
            SynchronizedPresent.description
        );
        NodeKind.SYNCHRONIZED_PRESENT.setDescription(
            SynchronizedPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TaggedNode",
            TaggedNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TaggedAbsent",
            TaggedAbsent.description
        );
        NodeKind.TAGGED_ABSENT.setDescription(
            TaggedAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TaggedPresent",
            TaggedPresent.description
        );
        NodeKind.TAGGED_PRESENT.setDescription(
            TaggedPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TaskDef",
            TaskDef.description
        );
        NodeKind.TASK_DEF.setDescription(
            TaskDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TypeAttributesRepository",
            TypeAttributesRepository.description
        );
        NodeKind.TYPE_ATTRIBUTES_REPOSITORY.setDescription(
            TypeAttributesRepository.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TypeDef",
            TypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AccessDef",
            AccessDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AccessToSubpDef",
            AccessToSubpDef.description
        );
        NodeKind.ACCESS_TO_SUBP_DEF.setDescription(
            AccessToSubpDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "BaseTypeAccessDef",
            BaseTypeAccessDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AnonymousTypeAccessDef",
            AnonymousTypeAccessDef.description
        );
        NodeKind.ANONYMOUS_TYPE_ACCESS_DEF.setDescription(
            AnonymousTypeAccessDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TypeAccessDef",
            TypeAccessDef.description
        );
        NodeKind.TYPE_ACCESS_DEF.setDescription(
            TypeAccessDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ArrayTypeDef",
            ArrayTypeDef.description
        );
        NodeKind.ARRAY_TYPE_DEF.setDescription(
            ArrayTypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DerivedTypeDef",
            DerivedTypeDef.description
        );
        NodeKind.DERIVED_TYPE_DEF.setDescription(
            DerivedTypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EnumTypeDef",
            EnumTypeDef.description
        );
        NodeKind.ENUM_TYPE_DEF.setDescription(
            EnumTypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FormalDiscreteTypeDef",
            FormalDiscreteTypeDef.description
        );
        NodeKind.FORMAL_DISCRETE_TYPE_DEF.setDescription(
            FormalDiscreteTypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "InterfaceTypeDef",
            InterfaceTypeDef.description
        );
        NodeKind.INTERFACE_TYPE_DEF.setDescription(
            InterfaceTypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ModIntTypeDef",
            ModIntTypeDef.description
        );
        NodeKind.MOD_INT_TYPE_DEF.setDescription(
            ModIntTypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "PrivateTypeDef",
            PrivateTypeDef.description
        );
        NodeKind.PRIVATE_TYPE_DEF.setDescription(
            PrivateTypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RealTypeDef",
            RealTypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DecimalFixedPointDef",
            DecimalFixedPointDef.description
        );
        NodeKind.DECIMAL_FIXED_POINT_DEF.setDescription(
            DecimalFixedPointDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "FloatingPointDef",
            FloatingPointDef.description
        );
        NodeKind.FLOATING_POINT_DEF.setDescription(
            FloatingPointDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "OrdinaryFixedPointDef",
            OrdinaryFixedPointDef.description
        );
        NodeKind.ORDINARY_FIXED_POINT_DEF.setDescription(
            OrdinaryFixedPointDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "RecordTypeDef",
            RecordTypeDef.description
        );
        NodeKind.RECORD_TYPE_DEF.setDescription(
            RecordTypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SignedIntTypeDef",
            SignedIntTypeDef.description
        );
        NodeKind.SIGNED_INT_TYPE_DEF.setDescription(
            SignedIntTypeDef.description
        );
        NODE_DESCRIPTION_MAP.put(
            "TypeExpr",
            TypeExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "AnonymousType",
            AnonymousType.description
        );
        NodeKind.ANONYMOUS_TYPE.setDescription(
            AnonymousType.description
        );
        NODE_DESCRIPTION_MAP.put(
            "EnumLitSynthTypeExpr",
            EnumLitSynthTypeExpr.description
        );
        NodeKind.ENUM_LIT_SYNTH_TYPE_EXPR.setDescription(
            EnumLitSynthTypeExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SubtypeIndication",
            SubtypeIndication.description
        );
        NodeKind.SUBTYPE_INDICATION.setDescription(
            SubtypeIndication.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ConstrainedSubtypeIndication",
            ConstrainedSubtypeIndication.description
        );
        NodeKind.CONSTRAINED_SUBTYPE_INDICATION.setDescription(
            ConstrainedSubtypeIndication.description
        );
        NODE_DESCRIPTION_MAP.put(
            "DiscreteSubtypeIndication",
            DiscreteSubtypeIndication.description
        );
        NodeKind.DISCRETE_SUBTYPE_INDICATION.setDescription(
            DiscreteSubtypeIndication.description
        );
        NODE_DESCRIPTION_MAP.put(
            "SyntheticTypeExpr",
            SyntheticTypeExpr.description
        );
        NodeKind.SYNTHETIC_TYPE_EXPR.setDescription(
            SyntheticTypeExpr.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UnconstrainedArrayIndex",
            UnconstrainedArrayIndex.description
        );
        NodeKind.UNCONSTRAINED_ARRAY_INDEX.setDescription(
            UnconstrainedArrayIndex.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UntilNode",
            UntilNode.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UntilAbsent",
            UntilAbsent.description
        );
        NodeKind.UNTIL_ABSENT.setDescription(
            UntilAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UntilPresent",
            UntilPresent.description
        );
        NodeKind.UNTIL_PRESENT.setDescription(
            UntilPresent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UseClause",
            UseClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UsePackageClause",
            UsePackageClause.description
        );
        NodeKind.USE_PACKAGE_CLAUSE.setDescription(
            UsePackageClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "UseTypeClause",
            UseTypeClause.description
        );
        NodeKind.USE_TYPE_CLAUSE.setDescription(
            UseTypeClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "ValueSequence",
            ValueSequence.description
        );
        NodeKind.VALUE_SEQUENCE.setDescription(
            ValueSequence.description
        );
        NODE_DESCRIPTION_MAP.put(
            "Variant",
            Variant.description
        );
        NodeKind.VARIANT.setDescription(
            Variant.description
        );
        NODE_DESCRIPTION_MAP.put(
            "VariantPart",
            VariantPart.description
        );
        NodeKind.VARIANT_PART.setDescription(
            VariantPart.description
        );
        NODE_DESCRIPTION_MAP.put(
            "WithClause",
            WithClause.description
        );
        NodeKind.WITH_CLAUSE.setDescription(
            WithClause.description
        );
        NODE_DESCRIPTION_MAP.put(
            "WithPrivate",
            WithPrivate.description
        );
        NODE_DESCRIPTION_MAP.put(
            "WithPrivateAbsent",
            WithPrivateAbsent.description
        );
        NodeKind.WITH_PRIVATE_ABSENT.setDescription(
            WithPrivateAbsent.description
        );
        NODE_DESCRIPTION_MAP.put(
            "WithPrivatePresent",
            WithPrivatePresent.description
        );
        NodeKind.WITH_PRIVATE_PRESENT.setDescription(
            WithPrivatePresent.description
        );
    }

    // ==========
    // Util functions
    // ==========

    /**
     * Get the string representing the memory.
     *
     * @param pointer The pointer to start displaying the memory from.
     * @param count The number of bytes to display from the pointer.
     * @return The string representing the memory as hex bytes.
     */
    private static String dumpMemory(
        final Pointer pointer,
        final long count
    ) {
        final StringBuilder res = new StringBuilder();
        for(int i = 0 ; i < count ; i++) {
            final byte toDump = pointer.readByte(i);
            res.append(String.format("%02x ", toDump));
        }
        return res.toString();
    }

    /**
     * Convert a Java string to a C string by allocating memory.
     *
     * @param jString The Java string to convert.
     * @return The native C char pointer. This pointer MUST be freed.
     */
    @CompilerDirectives.TruffleBoundary
    private static CCharPointer toCString(
        final String jString
    ) {
        final UnsignedWord size = WordFactory.unsigned(jString.length() + 1);
        final CCharPointer res = UnmanagedMemory.calloc(size);
        if(jString.length() > 0) {
            CTypeConversion.toCString(
                jString,
                StandardCharsets.UTF_8,
                res,
                size
            );
        }

        return res;
    }

    /**
     * Convert a Java byte array in a native byte array.
     *
     * @param bytes The Java bytes.
     * @return The native C char pointer. This pointer MUST be freed.
     */
    private static CCharPointer toCBytes(
        final byte[] bytes
    ) {
        final UnsignedWord size = WordFactory.unsigned(bytes.length);
        final CCharPointer res = UnmanagedMemory.malloc(size);
        for(int i = 0 ; i < bytes.length ; i++) {
            res.write(i, bytes[i]);
        }
        return res;
    }

    /**
     * Convert a native-image C string to a Java string.
     *
     * @param pointer The char pointer to convert to a Java string.
     * @return The Java string.
     */
    @CompilerDirectives.TruffleBoundary
    private static String toJString(
        final CCharPointer pointer
    ) {
        return CTypeConversion.toJavaString(pointer);
    }

    /**
     * This function decode a utf 32 int array in a
     * string without calling Java charset.
     *
     * @param chars The int array to decode.
     * @return The resulting string.
     */
    @CompilerDirectives.TruffleBoundary
    private static String decodeUTF32(
        final byte[] toDecode
    ) {
        return toJavaStringNode.execute(
            fromByteArrayNode.execute(toDecode, TruffleString.Encoding.UTF_32)
        );
    }

    /**
     * This function encode a given string to a int array
     * according to the utf 32 standard.
     *
     * @param toEncode The string to encode.
     * @return The encoded string in an int array.
     */
    @CompilerDirectives.TruffleBoundary
    private static byte[] encodeUTF32(
        final String toEncode
    ) {
        return toByteArrayNode.execute(
            fromJavaStringNode.execute(
                toEncode,
                TruffleString.Encoding.UTF_32
            ),
            TruffleString.Encoding.UTF_32
        );
    }

    /**
     * Get the string representation of the given string.
     * This function escaped needed chars and format the string.
     *
     * @param source The source string to get the representation for.
     * @return The representation of the string.
     */
    private static String stringRepresentation(
        final String source
    ) {
        return source
            .replace("\"", "\\\"")
            .replace("\n", "\\x0a");
    }

    /**
     * Convert a C Langkit exception to the LangkitException class.
     */
    private static LangkitException wrapException(
        final LangkitExceptionNative exc
    ) {
        return new LangkitException(
            exc.get_kind(),
            toJString(exc.get_information())
        );
    }

    /**
      * Return the exception raised by the last C API call, or null if the last
      * call was successful.
      */
    private static LangkitException getLastException() {
        LangkitException result = null;

        if(ImageInfo.inImageCode()) {
            final LangkitExceptionNative exceptionNative =
                NI_LIB.ada_get_last_exception();
            if(exceptionNative.isNonNull()) {
                result = wrapException(exceptionNative);
            }
        } else {
            result = JNI_LIB.ada_get_last_exception();
        }
        return result;
    }

    /**
     * Check the last exception raised by langkit and throw it.
     *
     * @throws The last langkit exception if there is one.
     */
    @CompilerDirectives.TruffleBoundary
    private static void checkException() throws LangkitException {
        LangkitException exc = getLastException();
        if(exc != null)
            throw exc;
    }

    /**
     * Create a native array from the given rewriting nodes array.
     * The returned pointer must be freed using UnmanagedMemory#free methods.
     */
    private static WordPointer rewritingNodesToNative(
        final RewritingNode[] rewritingNodes
    ) {
        final WordPointer res = UnmanagedMemory.malloc(
            rewritingNodes.length * SizeOf.get(WordPointer.class)
        );
        for(int i = 0; i < rewritingNodes.length; i++) {
            res.write(i, rewritingNodes[i].unwrap());
        }
        return res;
    }

    // ==========
    // Util interfaces
    // ==========

    /**
     * Interface to visit the parse tree.
     */
    public static interface BasicVisitor<T> {
        T visit(AdaNode node);
        T visit(AbortAbsent node);
        T visit(AbortPresent node);
        T visit(AbstractAbsent node);
        T visit(AbstractPresent node);
        T visit(AdaNodeList node);
        T visit(AbstractStateDeclList node);
        T visit(AlternativesList node);
        T visit(ConstraintList node);
        T visit(DeclList node);
        T visit(StmtList node);
        T visit(AspectAssocList node);
        T visit(BaseAssocList node);
        T visit(AssocList node);
        T visit(CaseExprAlternativeList node);
        T visit(CaseStmtAlternativeList node);
        T visit(CompilationUnitList node);
        T visit(ConcatOperandList node);
        T visit(ContractCaseAssocList node);
        T visit(DefiningNameList node);
        T visit(DiscriminantSpecList node);
        T visit(ElsifExprPartList node);
        T visit(ElsifStmtPartList node);
        T visit(EnumLiteralDeclList node);
        T visit(ExprAlternativesList node);
        T visit(FormatStringChunkList node);
        T visit(DiscriminantChoiceList node);
        T visit(NameList node);
        T visit(ParentList node);
        T visit(ParamSpecList node);
        T visit(PragmaNodeList node);
        T visit(SelectWhenPartList node);
        T visit(UnconstrainedArrayIndexList node);
        T visit(VariantList node);
        T visit(AliasedAbsent node);
        T visit(AliasedPresent node);
        T visit(AllAbsent node);
        T visit(AllPresent node);
        T visit(ConstrainedArrayIndices node);
        T visit(UnconstrainedArrayIndices node);
        T visit(AspectAssoc node);
        T visit(AtClause node);
        T visit(AttributeDefClause node);
        T visit(EnumRepClause node);
        T visit(RecordRepClause node);
        T visit(AspectSpec node);
        T visit(ContractCaseAssoc node);
        T visit(PragmaArgumentAssoc node);
        T visit(EntrySpec node);
        T visit(EnumSubpSpec node);
        T visit(SubpSpec node);
        T visit(SyntheticBinarySpec node);
        T visit(SyntheticUnarySpec node);
        T visit(ComponentList node);
        T visit(KnownDiscriminantPart node);
        T visit(UnknownDiscriminantPart node);
        T visit(EntryCompletionFormalParams node);
        T visit(GenericFormalPart node);
        T visit(NullRecordDef node);
        T visit(RecordDef node);
        T visit(AggregateAssoc node);
        T visit(MultiDimArrayAssoc node);
        T visit(CompositeConstraintAssoc node);
        T visit(IteratedAssoc node);
        T visit(ParamAssoc node);
        T visit(AbstractStateDecl node);
        T visit(AnonymousExprDecl node);
        T visit(ComponentDecl node);
        T visit(DiscriminantSpec node);
        T visit(GenericFormalObjDecl node);
        T visit(GenericFormalPackage node);
        T visit(GenericFormalSubpDecl node);
        T visit(GenericFormalTypeDecl node);
        T visit(ParamSpec node);
        T visit(SyntheticFormalParamDecl node);
        T visit(GenericPackageInternal node);
        T visit(PackageDecl node);
        T visit(DiscreteBaseSubtypeDecl node);
        T visit(SubtypeDecl node);
        T visit(ClasswideTypeDecl node);
        T visit(IncompleteTypeDecl node);
        T visit(IncompleteFormalTypeDecl node);
        T visit(IncompleteTaggedTypeDecl node);
        T visit(ProtectedTypeDecl node);
        T visit(TaskTypeDecl node);
        T visit(SingleTaskTypeDecl node);
        T visit(AnonymousTypeDecl node);
        T visit(SynthAnonymousTypeDecl node);
        T visit(ConcreteTypeDecl node);
        T visit(FormalTypeDecl node);
        T visit(AbstractSubpDecl node);
        T visit(AbstractFormalSubpDecl node);
        T visit(ConcreteFormalSubpDecl node);
        T visit(SubpDecl node);
        T visit(EntryDecl node);
        T visit(EnumLiteralDecl node);
        T visit(SyntheticCharEnumLit node);
        T visit(GenericSubpInternal node);
        T visit(SyntheticSubpDecl node);
        T visit(AcceptStmtBody node);
        T visit(ExprFunction node);
        T visit(NullSubpDecl node);
        T visit(SubpBody node);
        T visit(SubpRenamingDecl node);
        T visit(PackageBodyStub node);
        T visit(ProtectedBodyStub node);
        T visit(SubpBodyStub node);
        T visit(TaskBodyStub node);
        T visit(EntryBody node);
        T visit(PackageBody node);
        T visit(ProtectedBody node);
        T visit(TaskBody node);
        T visit(EntryIndexSpec node);
        T visit(ErrorDecl node);
        T visit(ExceptionDecl node);
        T visit(ExceptionHandler node);
        T visit(ForLoopVarDecl node);
        T visit(GenericPackageDecl node);
        T visit(GenericSubpDecl node);
        T visit(GenericPackageInstantiation node);
        T visit(GenericSubpInstantiation node);
        T visit(GenericPackageRenamingDecl node);
        T visit(GenericSubpRenamingDecl node);
        T visit(LabelDecl node);
        T visit(NamedStmtDecl node);
        T visit(NumberDecl node);
        T visit(ObjectDecl node);
        T visit(ExtendedReturnStmtObjectDecl node);
        T visit(NoTypeObjectRenamingDecl node);
        T visit(PackageRenamingDecl node);
        T visit(SingleProtectedDecl node);
        T visit(SingleTaskDecl node);
        T visit(SyntheticObjectDecl node);
        T visit(CaseStmtAlternative node);
        T visit(CompilationUnit node);
        T visit(ComponentClause node);
        T visit(ComponentDef node);
        T visit(ConstantAbsent node);
        T visit(ConstantPresent node);
        T visit(CompositeConstraint node);
        T visit(DeltaConstraint node);
        T visit(DigitsConstraint node);
        T visit(RangeConstraint node);
        T visit(DeclarativePart node);
        T visit(PrivatePart node);
        T visit(PublicPart node);
        T visit(ElsifExprPart node);
        T visit(ElsifStmtPart node);
        T visit(AbstractStateDeclExpr node);
        T visit(Allocator node);
        T visit(Aggregate node);
        T visit(BracketAggregate node);
        T visit(DeltaAggregate node);
        T visit(BracketDeltaAggregate node);
        T visit(NullRecordAggregate node);
        T visit(BinOp node);
        T visit(RelationOp node);
        T visit(BoxExpr node);
        T visit(CaseExprAlternative node);
        T visit(ConcatOp node);
        T visit(ConcatOperand node);
        T visit(CaseExpr node);
        T visit(IfExpr node);
        T visit(ContractCases node);
        T visit(DeclExpr node);
        T visit(FormatStringLiteral node);
        T visit(MembershipExpr node);
        T visit(ArraySubcomponentChoiceName node);
        T visit(AttributeRef node);
        T visit(CallExpr node);
        T visit(DefiningName node);
        T visit(SyntheticDefiningName node);
        T visit(DiscreteSubtypeName node);
        T visit(DottedName node);
        T visit(EndName node);
        T visit(ExplicitDeref node);
        T visit(QualExpr node);
        T visit(ReduceAttributeRef node);
        T visit(CharLiteral node);
        T visit(Identifier node);
        T visit(OpAbs node);
        T visit(OpAnd node);
        T visit(OpAndThen node);
        T visit(OpConcat node);
        T visit(OpDiv node);
        T visit(OpDoubleDot node);
        T visit(OpEq node);
        T visit(OpGt node);
        T visit(OpGte node);
        T visit(OpIn node);
        T visit(OpLt node);
        T visit(OpLte node);
        T visit(OpMinus node);
        T visit(OpMod node);
        T visit(OpMult node);
        T visit(OpNeq node);
        T visit(OpNot node);
        T visit(OpNotIn node);
        T visit(OpOr node);
        T visit(OpOrElse node);
        T visit(OpPlus node);
        T visit(OpPow node);
        T visit(OpRem node);
        T visit(OpXor node);
        T visit(StringLiteral node);
        T visit(NullLiteral node);
        T visit(IntLiteral node);
        T visit(RealLiteral node);
        T visit(SyntheticIdentifier node);
        T visit(TargetName node);
        T visit(UpdateAttributeRef node);
        T visit(ParenExpr node);
        T visit(QuantifiedExpr node);
        T visit(RaiseExpr node);
        T visit(UnOp node);
        T visit(ForLoopIterFilter node);
        T visit(FormatStringChunk node);
        T visit(FormatStringTokEnd node);
        T visit(FormatStringTokMid node);
        T visit(FormatStringTokStart node);
        T visit(FormatStringTokString node);
        T visit(HandledStmts node);
        T visit(InterfaceKindLimited node);
        T visit(InterfaceKindProtected node);
        T visit(InterfaceKindSynchronized node);
        T visit(InterfaceKindTask node);
        T visit(IterTypeIn node);
        T visit(IterTypeOf node);
        T visit(LibraryItem node);
        T visit(LimitedAbsent node);
        T visit(LimitedPresent node);
        T visit(ForLoopSpec node);
        T visit(WhileLoopSpec node);
        T visit(ModeDefault node);
        T visit(ModeIn node);
        T visit(ModeInOut node);
        T visit(ModeOut node);
        T visit(MultiAbstractStateDecl node);
        T visit(NotNullAbsent node);
        T visit(NotNullPresent node);
        T visit(NullComponentDecl node);
        T visit(OthersDesignator node);
        T visit(OverridingNotOverriding node);
        T visit(OverridingOverriding node);
        T visit(OverridingUnspecified node);
        T visit(Params node);
        T visit(ParenAbstractStateDecl node);
        T visit(PpElseDirective node);
        T visit(PpElsifDirective node);
        T visit(PpEndIfDirective node);
        T visit(PpIfDirective node);
        T visit(PpThenKw node);
        T visit(PragmaNode node);
        T visit(PrivateAbsent node);
        T visit(PrivatePresent node);
        T visit(ProtectedDef node);
        T visit(ProtectedAbsent node);
        T visit(ProtectedPresent node);
        T visit(QuantifierAll node);
        T visit(QuantifierSome node);
        T visit(RangeSpec node);
        T visit(RenamingClause node);
        T visit(SyntheticRenamingClause node);
        T visit(ReverseAbsent node);
        T visit(ReversePresent node);
        T visit(SelectWhenPart node);
        T visit(AcceptStmt node);
        T visit(AcceptStmtWithStmts node);
        T visit(ForLoopStmt node);
        T visit(LoopStmt node);
        T visit(WhileLoopStmt node);
        T visit(BeginBlock node);
        T visit(DeclBlock node);
        T visit(CaseStmt node);
        T visit(ExtendedReturnStmt node);
        T visit(IfStmt node);
        T visit(NamedStmt node);
        T visit(SelectStmt node);
        T visit(ErrorStmt node);
        T visit(AbortStmt node);
        T visit(AssignStmt node);
        T visit(CallStmt node);
        T visit(DelayStmt node);
        T visit(ExitStmt node);
        T visit(GotoStmt node);
        T visit(Label node);
        T visit(NullStmt node);
        T visit(RaiseStmt node);
        T visit(RequeueStmt node);
        T visit(ReturnStmt node);
        T visit(SimpleDeclStmt node);
        T visit(TerminateAlternative node);
        T visit(SubpKindFunction node);
        T visit(SubpKindProcedure node);
        T visit(Subunit node);
        T visit(SynchronizedAbsent node);
        T visit(SynchronizedPresent node);
        T visit(TaggedAbsent node);
        T visit(TaggedPresent node);
        T visit(TaskDef node);
        T visit(TypeAttributesRepository node);
        T visit(AccessToSubpDef node);
        T visit(AnonymousTypeAccessDef node);
        T visit(TypeAccessDef node);
        T visit(ArrayTypeDef node);
        T visit(DerivedTypeDef node);
        T visit(EnumTypeDef node);
        T visit(FormalDiscreteTypeDef node);
        T visit(InterfaceTypeDef node);
        T visit(ModIntTypeDef node);
        T visit(PrivateTypeDef node);
        T visit(DecimalFixedPointDef node);
        T visit(FloatingPointDef node);
        T visit(OrdinaryFixedPointDef node);
        T visit(RecordTypeDef node);
        T visit(SignedIntTypeDef node);
        T visit(AnonymousType node);
        T visit(EnumLitSynthTypeExpr node);
        T visit(SubtypeIndication node);
        T visit(ConstrainedSubtypeIndication node);
        T visit(DiscreteSubtypeIndication node);
        T visit(SyntheticTypeExpr node);
        T visit(UnconstrainedArrayIndex node);
        T visit(UntilAbsent node);
        T visit(UntilPresent node);
        T visit(UsePackageClause node);
        T visit(UseTypeClause node);
        T visit(ValueSequence node);
        T visit(Variant node);
        T visit(VariantPart node);
        T visit(WithClause node);
        T visit(WithPrivateAbsent node);
        T visit(WithPrivatePresent node);
    }

    /**
     * Interface to visit the parse tree with a parameter.
     */
    public static interface ParamVisitor<T, P> {
        T visit(AdaNode node, P param);
        T visit(AbortAbsent node, P param);
        T visit(AbortPresent node, P param);
        T visit(AbstractAbsent node, P param);
        T visit(AbstractPresent node, P param);
        T visit(AdaNodeList node, P param);
        T visit(AbstractStateDeclList node, P param);
        T visit(AlternativesList node, P param);
        T visit(ConstraintList node, P param);
        T visit(DeclList node, P param);
        T visit(StmtList node, P param);
        T visit(AspectAssocList node, P param);
        T visit(BaseAssocList node, P param);
        T visit(AssocList node, P param);
        T visit(CaseExprAlternativeList node, P param);
        T visit(CaseStmtAlternativeList node, P param);
        T visit(CompilationUnitList node, P param);
        T visit(ConcatOperandList node, P param);
        T visit(ContractCaseAssocList node, P param);
        T visit(DefiningNameList node, P param);
        T visit(DiscriminantSpecList node, P param);
        T visit(ElsifExprPartList node, P param);
        T visit(ElsifStmtPartList node, P param);
        T visit(EnumLiteralDeclList node, P param);
        T visit(ExprAlternativesList node, P param);
        T visit(FormatStringChunkList node, P param);
        T visit(DiscriminantChoiceList node, P param);
        T visit(NameList node, P param);
        T visit(ParentList node, P param);
        T visit(ParamSpecList node, P param);
        T visit(PragmaNodeList node, P param);
        T visit(SelectWhenPartList node, P param);
        T visit(UnconstrainedArrayIndexList node, P param);
        T visit(VariantList node, P param);
        T visit(AliasedAbsent node, P param);
        T visit(AliasedPresent node, P param);
        T visit(AllAbsent node, P param);
        T visit(AllPresent node, P param);
        T visit(ConstrainedArrayIndices node, P param);
        T visit(UnconstrainedArrayIndices node, P param);
        T visit(AspectAssoc node, P param);
        T visit(AtClause node, P param);
        T visit(AttributeDefClause node, P param);
        T visit(EnumRepClause node, P param);
        T visit(RecordRepClause node, P param);
        T visit(AspectSpec node, P param);
        T visit(ContractCaseAssoc node, P param);
        T visit(PragmaArgumentAssoc node, P param);
        T visit(EntrySpec node, P param);
        T visit(EnumSubpSpec node, P param);
        T visit(SubpSpec node, P param);
        T visit(SyntheticBinarySpec node, P param);
        T visit(SyntheticUnarySpec node, P param);
        T visit(ComponentList node, P param);
        T visit(KnownDiscriminantPart node, P param);
        T visit(UnknownDiscriminantPart node, P param);
        T visit(EntryCompletionFormalParams node, P param);
        T visit(GenericFormalPart node, P param);
        T visit(NullRecordDef node, P param);
        T visit(RecordDef node, P param);
        T visit(AggregateAssoc node, P param);
        T visit(MultiDimArrayAssoc node, P param);
        T visit(CompositeConstraintAssoc node, P param);
        T visit(IteratedAssoc node, P param);
        T visit(ParamAssoc node, P param);
        T visit(AbstractStateDecl node, P param);
        T visit(AnonymousExprDecl node, P param);
        T visit(ComponentDecl node, P param);
        T visit(DiscriminantSpec node, P param);
        T visit(GenericFormalObjDecl node, P param);
        T visit(GenericFormalPackage node, P param);
        T visit(GenericFormalSubpDecl node, P param);
        T visit(GenericFormalTypeDecl node, P param);
        T visit(ParamSpec node, P param);
        T visit(SyntheticFormalParamDecl node, P param);
        T visit(GenericPackageInternal node, P param);
        T visit(PackageDecl node, P param);
        T visit(DiscreteBaseSubtypeDecl node, P param);
        T visit(SubtypeDecl node, P param);
        T visit(ClasswideTypeDecl node, P param);
        T visit(IncompleteTypeDecl node, P param);
        T visit(IncompleteFormalTypeDecl node, P param);
        T visit(IncompleteTaggedTypeDecl node, P param);
        T visit(ProtectedTypeDecl node, P param);
        T visit(TaskTypeDecl node, P param);
        T visit(SingleTaskTypeDecl node, P param);
        T visit(AnonymousTypeDecl node, P param);
        T visit(SynthAnonymousTypeDecl node, P param);
        T visit(ConcreteTypeDecl node, P param);
        T visit(FormalTypeDecl node, P param);
        T visit(AbstractSubpDecl node, P param);
        T visit(AbstractFormalSubpDecl node, P param);
        T visit(ConcreteFormalSubpDecl node, P param);
        T visit(SubpDecl node, P param);
        T visit(EntryDecl node, P param);
        T visit(EnumLiteralDecl node, P param);
        T visit(SyntheticCharEnumLit node, P param);
        T visit(GenericSubpInternal node, P param);
        T visit(SyntheticSubpDecl node, P param);
        T visit(AcceptStmtBody node, P param);
        T visit(ExprFunction node, P param);
        T visit(NullSubpDecl node, P param);
        T visit(SubpBody node, P param);
        T visit(SubpRenamingDecl node, P param);
        T visit(PackageBodyStub node, P param);
        T visit(ProtectedBodyStub node, P param);
        T visit(SubpBodyStub node, P param);
        T visit(TaskBodyStub node, P param);
        T visit(EntryBody node, P param);
        T visit(PackageBody node, P param);
        T visit(ProtectedBody node, P param);
        T visit(TaskBody node, P param);
        T visit(EntryIndexSpec node, P param);
        T visit(ErrorDecl node, P param);
        T visit(ExceptionDecl node, P param);
        T visit(ExceptionHandler node, P param);
        T visit(ForLoopVarDecl node, P param);
        T visit(GenericPackageDecl node, P param);
        T visit(GenericSubpDecl node, P param);
        T visit(GenericPackageInstantiation node, P param);
        T visit(GenericSubpInstantiation node, P param);
        T visit(GenericPackageRenamingDecl node, P param);
        T visit(GenericSubpRenamingDecl node, P param);
        T visit(LabelDecl node, P param);
        T visit(NamedStmtDecl node, P param);
        T visit(NumberDecl node, P param);
        T visit(ObjectDecl node, P param);
        T visit(ExtendedReturnStmtObjectDecl node, P param);
        T visit(NoTypeObjectRenamingDecl node, P param);
        T visit(PackageRenamingDecl node, P param);
        T visit(SingleProtectedDecl node, P param);
        T visit(SingleTaskDecl node, P param);
        T visit(SyntheticObjectDecl node, P param);
        T visit(CaseStmtAlternative node, P param);
        T visit(CompilationUnit node, P param);
        T visit(ComponentClause node, P param);
        T visit(ComponentDef node, P param);
        T visit(ConstantAbsent node, P param);
        T visit(ConstantPresent node, P param);
        T visit(CompositeConstraint node, P param);
        T visit(DeltaConstraint node, P param);
        T visit(DigitsConstraint node, P param);
        T visit(RangeConstraint node, P param);
        T visit(DeclarativePart node, P param);
        T visit(PrivatePart node, P param);
        T visit(PublicPart node, P param);
        T visit(ElsifExprPart node, P param);
        T visit(ElsifStmtPart node, P param);
        T visit(AbstractStateDeclExpr node, P param);
        T visit(Allocator node, P param);
        T visit(Aggregate node, P param);
        T visit(BracketAggregate node, P param);
        T visit(DeltaAggregate node, P param);
        T visit(BracketDeltaAggregate node, P param);
        T visit(NullRecordAggregate node, P param);
        T visit(BinOp node, P param);
        T visit(RelationOp node, P param);
        T visit(BoxExpr node, P param);
        T visit(CaseExprAlternative node, P param);
        T visit(ConcatOp node, P param);
        T visit(ConcatOperand node, P param);
        T visit(CaseExpr node, P param);
        T visit(IfExpr node, P param);
        T visit(ContractCases node, P param);
        T visit(DeclExpr node, P param);
        T visit(FormatStringLiteral node, P param);
        T visit(MembershipExpr node, P param);
        T visit(ArraySubcomponentChoiceName node, P param);
        T visit(AttributeRef node, P param);
        T visit(CallExpr node, P param);
        T visit(DefiningName node, P param);
        T visit(SyntheticDefiningName node, P param);
        T visit(DiscreteSubtypeName node, P param);
        T visit(DottedName node, P param);
        T visit(EndName node, P param);
        T visit(ExplicitDeref node, P param);
        T visit(QualExpr node, P param);
        T visit(ReduceAttributeRef node, P param);
        T visit(CharLiteral node, P param);
        T visit(Identifier node, P param);
        T visit(OpAbs node, P param);
        T visit(OpAnd node, P param);
        T visit(OpAndThen node, P param);
        T visit(OpConcat node, P param);
        T visit(OpDiv node, P param);
        T visit(OpDoubleDot node, P param);
        T visit(OpEq node, P param);
        T visit(OpGt node, P param);
        T visit(OpGte node, P param);
        T visit(OpIn node, P param);
        T visit(OpLt node, P param);
        T visit(OpLte node, P param);
        T visit(OpMinus node, P param);
        T visit(OpMod node, P param);
        T visit(OpMult node, P param);
        T visit(OpNeq node, P param);
        T visit(OpNot node, P param);
        T visit(OpNotIn node, P param);
        T visit(OpOr node, P param);
        T visit(OpOrElse node, P param);
        T visit(OpPlus node, P param);
        T visit(OpPow node, P param);
        T visit(OpRem node, P param);
        T visit(OpXor node, P param);
        T visit(StringLiteral node, P param);
        T visit(NullLiteral node, P param);
        T visit(IntLiteral node, P param);
        T visit(RealLiteral node, P param);
        T visit(SyntheticIdentifier node, P param);
        T visit(TargetName node, P param);
        T visit(UpdateAttributeRef node, P param);
        T visit(ParenExpr node, P param);
        T visit(QuantifiedExpr node, P param);
        T visit(RaiseExpr node, P param);
        T visit(UnOp node, P param);
        T visit(ForLoopIterFilter node, P param);
        T visit(FormatStringChunk node, P param);
        T visit(FormatStringTokEnd node, P param);
        T visit(FormatStringTokMid node, P param);
        T visit(FormatStringTokStart node, P param);
        T visit(FormatStringTokString node, P param);
        T visit(HandledStmts node, P param);
        T visit(InterfaceKindLimited node, P param);
        T visit(InterfaceKindProtected node, P param);
        T visit(InterfaceKindSynchronized node, P param);
        T visit(InterfaceKindTask node, P param);
        T visit(IterTypeIn node, P param);
        T visit(IterTypeOf node, P param);
        T visit(LibraryItem node, P param);
        T visit(LimitedAbsent node, P param);
        T visit(LimitedPresent node, P param);
        T visit(ForLoopSpec node, P param);
        T visit(WhileLoopSpec node, P param);
        T visit(ModeDefault node, P param);
        T visit(ModeIn node, P param);
        T visit(ModeInOut node, P param);
        T visit(ModeOut node, P param);
        T visit(MultiAbstractStateDecl node, P param);
        T visit(NotNullAbsent node, P param);
        T visit(NotNullPresent node, P param);
        T visit(NullComponentDecl node, P param);
        T visit(OthersDesignator node, P param);
        T visit(OverridingNotOverriding node, P param);
        T visit(OverridingOverriding node, P param);
        T visit(OverridingUnspecified node, P param);
        T visit(Params node, P param);
        T visit(ParenAbstractStateDecl node, P param);
        T visit(PpElseDirective node, P param);
        T visit(PpElsifDirective node, P param);
        T visit(PpEndIfDirective node, P param);
        T visit(PpIfDirective node, P param);
        T visit(PpThenKw node, P param);
        T visit(PragmaNode node, P param);
        T visit(PrivateAbsent node, P param);
        T visit(PrivatePresent node, P param);
        T visit(ProtectedDef node, P param);
        T visit(ProtectedAbsent node, P param);
        T visit(ProtectedPresent node, P param);
        T visit(QuantifierAll node, P param);
        T visit(QuantifierSome node, P param);
        T visit(RangeSpec node, P param);
        T visit(RenamingClause node, P param);
        T visit(SyntheticRenamingClause node, P param);
        T visit(ReverseAbsent node, P param);
        T visit(ReversePresent node, P param);
        T visit(SelectWhenPart node, P param);
        T visit(AcceptStmt node, P param);
        T visit(AcceptStmtWithStmts node, P param);
        T visit(ForLoopStmt node, P param);
        T visit(LoopStmt node, P param);
        T visit(WhileLoopStmt node, P param);
        T visit(BeginBlock node, P param);
        T visit(DeclBlock node, P param);
        T visit(CaseStmt node, P param);
        T visit(ExtendedReturnStmt node, P param);
        T visit(IfStmt node, P param);
        T visit(NamedStmt node, P param);
        T visit(SelectStmt node, P param);
        T visit(ErrorStmt node, P param);
        T visit(AbortStmt node, P param);
        T visit(AssignStmt node, P param);
        T visit(CallStmt node, P param);
        T visit(DelayStmt node, P param);
        T visit(ExitStmt node, P param);
        T visit(GotoStmt node, P param);
        T visit(Label node, P param);
        T visit(NullStmt node, P param);
        T visit(RaiseStmt node, P param);
        T visit(RequeueStmt node, P param);
        T visit(ReturnStmt node, P param);
        T visit(SimpleDeclStmt node, P param);
        T visit(TerminateAlternative node, P param);
        T visit(SubpKindFunction node, P param);
        T visit(SubpKindProcedure node, P param);
        T visit(Subunit node, P param);
        T visit(SynchronizedAbsent node, P param);
        T visit(SynchronizedPresent node, P param);
        T visit(TaggedAbsent node, P param);
        T visit(TaggedPresent node, P param);
        T visit(TaskDef node, P param);
        T visit(TypeAttributesRepository node, P param);
        T visit(AccessToSubpDef node, P param);
        T visit(AnonymousTypeAccessDef node, P param);
        T visit(TypeAccessDef node, P param);
        T visit(ArrayTypeDef node, P param);
        T visit(DerivedTypeDef node, P param);
        T visit(EnumTypeDef node, P param);
        T visit(FormalDiscreteTypeDef node, P param);
        T visit(InterfaceTypeDef node, P param);
        T visit(ModIntTypeDef node, P param);
        T visit(PrivateTypeDef node, P param);
        T visit(DecimalFixedPointDef node, P param);
        T visit(FloatingPointDef node, P param);
        T visit(OrdinaryFixedPointDef node, P param);
        T visit(RecordTypeDef node, P param);
        T visit(SignedIntTypeDef node, P param);
        T visit(AnonymousType node, P param);
        T visit(EnumLitSynthTypeExpr node, P param);
        T visit(SubtypeIndication node, P param);
        T visit(ConstrainedSubtypeIndication node, P param);
        T visit(DiscreteSubtypeIndication node, P param);
        T visit(SyntheticTypeExpr node, P param);
        T visit(UnconstrainedArrayIndex node, P param);
        T visit(UntilAbsent node, P param);
        T visit(UntilPresent node, P param);
        T visit(UsePackageClause node, P param);
        T visit(UseTypeClause node, P param);
        T visit(ValueSequence node, P param);
        T visit(Variant node, P param);
        T visit(VariantPart node, P param);
        T visit(WithClause node, P param);
        T visit(WithPrivateAbsent node, P param);
        T visit(WithPrivatePresent node, P param);
    }

    // ==========
    // Util classes
    // ==========

    /**
     * This class represents a pointer and can hold NI and JNI addresses.
     */
    public static final class PointerWrapper {

        // ----- Instance attributes -----

        /** The pointer NI value. */
        private PointerBase ni;

        /** The pointer JNI value. */
        private final long jni;

        // ----- Constructors -----

        /**
         * Create a new custom pointer from a NI pointer based value.
         *
         * @param niPointer The pointer based value.
         */
        PointerWrapper(
            final PointerBase niPointer
        ) {
            this.ni = niPointer;
            this.jni = -1;
        }

        /**
         * Create a new custom pointer from a long value.
         *
         * @param jniPointer The pointer in a long value.
         */
        PointerWrapper(
            final long jniPointer
        ) {
            this.jni = jniPointer;
        }

        /**
         * Wrap the given NI pointer in the Java class.
         *
         * @param niPointer The NI pointer to wrap.
         * @return The wrapped pointer.
         */
        static PointerWrapper wrap(
            final PointerBase niPointer
        ) {
            return new PointerWrapper(niPointer);
        }

        /**
         * Get the null pointer according to the execution mode.
         *
         * @return The null custom pointer.
         */
        public static PointerWrapper nullPointer() {

            if(ImageInfo.inImageCode()) {
                return new PointerWrapper(WordFactory.nullPointer());
            } else {
                return new PointerWrapper(0L);
            }

        }

        // ----- Instance methods -----

        /**
         * Get the pointer as an NI pointer based value.
         *
         * @return The pointer based value for NI.
         */
        public <T extends PointerBase> T ni() {
            return (T) this.ni;
        }

        /**
         * Get the pointer as a long Java value.
         *
         * @return The pointer as a long value for JNI.
         */
        public long jni() {
            return this.jni;
        }

        /**
         * Get if the pointer is null.
         *
         * @return True if the pointer is null, false else.
         */
        public boolean isNull() {

            if(ImageInfo.inImageCode()) {
                return this.ni.isNull();
            } else {
                return this.jni == 0;
            }

        }

        // ----- Override methods -----

        @Override
        public String toString() {

            if(ImageInfo.inImageCode()) {
                return "PointerWrapper{"
                    + this.ni.rawValue()
                    + "}";
            } else {
                return "PointerWrapper{"
                    + this.jni
                    + "}";
            }

        }

        @Override
        public boolean equals(Object o) {
            if(o == this) return true;
            if(!(o instanceof PointerWrapper)) return false;
            final PointerWrapper other = (PointerWrapper) o;
            if(ImageInfo.inImageCode()) {
                return this.ni.equal(other.ni);
            } else {
                return this.jni == other.jni;
            }
        }

        @Override
        public int hashCode() {

            if(ImageInfo.inImageCode()) {
                return (int) this.ni.rawValue();
            } else {
                return (int) this.jni;
            }

        }

    }

    // ==========
    // Reflection utils
    // ==========

    public static final class Reflection {
        /**
        * This class represents the description of a node.
        */
        public static final class Node {

            // ----- Instance attributes -----

            /** Kind of the node. This kind is null if the node is abstract */
            public final NodeKind kind;

            /** Whether the node is a token node */
            public final boolean isTokenNode;

            /** Whether the node is a list node */
            public final boolean isListNode;

            /** Java class of the node */
            public final Class<? extends AdaNode> clazz;

            /** Simple name of the Java class of the node */
            public final String className;

            /** Fields of the node, sorted by parsing order */
            public final String[] fields;

            /** Map containing description for all fields of the node */
            public final Map<String, Field> fieldDescriptions;

            // ----- Constructors -----

            /** Create a new node description with its kind and class */
            public Node (
                NodeKind kind,
                final boolean isTokenNode,
                final boolean isListNode,
                final Class<? extends AdaNode> clazz,
                final String className,
                final String[] fields,
                final Map<String, Field> fieldDescriptions
            ) {
                this.kind = kind;
                this.isTokenNode = isTokenNode;
                this.isListNode = isListNode;
                this.clazz = clazz;
                this.className = className;
                this.fieldDescriptions = fieldDescriptions;
                this.fields = fields;
            }

        }

        /**
        * This class represents the description of a node field.
        */
        public static final class Field {

            // ----- Instance attributes -----

            /** The Java method for the field */
            public final Method javaMethod;

            /** The parameters of the method */
            public final List<Param> params;

            /** The generic member reference of this field */
            public final MemberReference memberRef;

            // ----- Constructors -----

            /**
            * Create a new field description.
            *
            * @param method The Java method to access the field.
            * @param params The parameters of the field call.
            */
            public Field(
                final Method javaMethod,
                final List<Param> params,
                final MemberReference memberRef
            ) {
                this.javaMethod = javaMethod;
                this.params = params;
                this.memberRef = memberRef;
            }

        }

        /**
        * This class represents a parameter description.
        */
        public static class Param {

            // ----- Instance attributes -----

            /** The type of the argument */
            public final Class<?> type;

            /** The name of the parameter */
            public final String name;

            /** The optional default value of the parameter */
            public final Optional<Object> defaultValue;

            // ----- Constructors -----

            /**
            * Create a new langkit parameter.
            *
            * @param type The type of the parameter.
            * @param name The name of the parameter.
            */
            public Param(
                final Class<?> type,
                final String name
            ) {
                this.type = type;
                this.name = name;
                this.defaultValue = Optional.empty();
            }

            /** Create a new parameter description with a default value. */
            public Param(
                final Class<?> type,
                final String name,
                final Object defaultValue
            ) {
                this.type = type;
                this.name = name;
                this.defaultValue = Optional.ofNullable(defaultValue);
            }

        }
    }

    // ==========
    // Language specific extensions
    // ==========

    
      


    // ==========
    // Define classes to handle project loading
    // ==========

    /**
     * Exception to represent errors during project manipulation
     */
    public static final class ProjectManagerException extends RuntimeException {
        ProjectManagerException(
            final String message
        ) {
            super(message);
        }
    }

    /**
     * Enum to represent the source file mode for a GPR project
     */
    public static enum SourceFileMode {

        // ----- Enum values -----

        DEFAULT(0),
        ROOT_PROJECT(1),
        WHOLE_PROJECT(2),
        WHOLE_PROJECT_WITH_RUNTIME(3),
        ;

        // ----- Class attributes -----

        /** Singleton that represents the none source file mode */
        public static final SourceFileMode NONE = DEFAULT;

        /** The map from int to enum values */
        private static final Map<Integer, SourceFileMode> map = new HashMap<>();

        // ----- Instance attributes -----

        /** The value of the instance */
        private final int value;

        // ----- Constructors -----

        /**
         * The private constructor
         */
        private SourceFileMode(
            final int value
        ) {
            this.value = value;
        }

        static {
            for(SourceFileMode elem : SourceFileMode.values()) {
                map.put(elem.value, elem);
            }
        }

        // ----- Enum methods -----

        /**
         * Get a source file mode from a native integer value.
         *
         * @param cValue The native value of the enum.
         * @return The Java source file mode.
         * @throws EnumException If the given native value doesn't correspond
         * to an actual enum value.
         */
        public static SourceFileMode fromC(
            final int cValue
        ) throws EnumException {
            if(!map.containsKey(cValue))
                throw new EnumException(
                    "Cannot get SourceFileMode from " + cValue
                );
            return (SourceFileMode) map.get(cValue);
        }

        /**
         * Get the native integer value of the enum instance.
         *
         * @return The native C value.
         */
        public int toC() {
            return this.value;
        }

    }

    /**
     * This class represents a scenario variable for a GPR project file.
     */
    public static final class ScenarioVariable {

        // ----- Class attributes -----

        /** Singleton that represents the none scenario variable. */
        public static final ScenarioVariable NONE =
            new ScenarioVariable(null, null);

        // ----- Instance attributes -----

        /** The name of the variable. */
        public final String name;

        /** The value of the variable. */
        public final String value;

        // ----- Constructors -----

        /**
         * Create a new scenario variable with its name and value.
         *
         * @param name Name of the variable.
         * @param value Value of the variable.
         */
        ScenarioVariable(
            final String name,
            final String value
        ) {
            this.name = name;
            this.value = value;
        }

        /**
         * Public method to create scenario variable.
         * This method raise a runtime exception if name or value is null.
         *
         * @param name Name of the variable.
         * @param value Value of the variable.
         */
        public static ScenarioVariable create(
            final String name,
            final String value
        ) {
            if(name == null) throw new RuntimeException("Scenario variable name cannot be null");
            if(value == null) throw new RuntimeException("Scenario variable value cannot be null");
            return new ScenarioVariable(name, value);
        }

        // ----- Graal C API methods -----

        /**
         * Wrap the given pointer to a native scenario variable.
         *
         * @param pointer The pointer to the native scenario variable.
         * @return The wrapped scenario variable.
         */
        public static ScenarioVariable wrap(
            final Pointer pointer
        ) {
            return wrap((ScenarioVariableNative) pointer.readWord(0));
        }

        /**
         * Wrap the given native scenario variable.
         *
         * @param scenarioVariableNative The native scenario variable.
         * @return The wrapped scenario variable.
         */
        public static ScenarioVariable wrap(
            final ScenarioVariableNative scenarioVariableNative
        ) {
            final CCharPointer nameNative = scenarioVariableNative.get_name();
            final CCharPointer valueNative = scenarioVariableNative.get_value();
            return new ScenarioVariable(
                nameNative.isNull() ?
                    null :
                    toJString(nameNative),
                valueNative.isNull() ?
                    null :
                    toJString(valueNative)
            );
        }

        /**
         * Unwrap the scenario variable in the given native value.
         *
         * @param scenarioVariableNative The native value to fill.
         */
        public void unwrap(
            final ScenarioVariableNative scenarioVariableNative
        ) {
            final CCharPointer nameNative = this.name == null ?
                WordFactory.nullPointer() :
                toCString(this.name);
            final CCharPointer valueNative = this.value == null ?
                WordFactory.nullPointer() :
                toCString(this.value);
            scenarioVariableNative.set_name(nameNative);
            scenarioVariableNative.set_value(valueNative);
        }

        /**
         * Release the given native scenario variable allocated strings.
         *
         * @param scenarioVariableNative The native scenario variable to release.
         */
        public static void release(
            final ScenarioVariableNative scenarioVariableNative
        ) {
            if(scenarioVariableNative.get_name().isNonNull()) {
                UnmanagedMemory.free(scenarioVariableNative.get_name());
            }
            if(scenarioVariableNative.get_value().isNonNull()) {
                UnmanagedMemory.free(scenarioVariableNative.get_value());
            }
        }

        // ----- Override methods -----

        /** @see java.lang.Object#toString() */
        public String toString() {
            return "ScenarioVariable(" +
                this.name + " = " + this.value +
                ")";
        }

    }

    /**
     * This class is used for the GPR project loading.
     */
    public static final class ProjectManager implements AutoCloseable {

        // ----- Class attributes -----

        /** Singleton that represents the none project manager. */
        public static final ProjectManager NONE =
            new ProjectManager(PointerWrapper.nullPointer());

        // ----- Instance attributes -----

        /** Reference to the native value. */
        private final PointerWrapper reference;

        /**
         * List of diagnostics emitted by the native API during the project
         * opening.
         */
        private final List<String> diagnostics;

        // ----- Constructors -----

        /**
         * Create a new project manager from its native reference.
         *
         * @param reference The reference to the native project manager.
         */
        ProjectManager(
            final PointerWrapper reference
        ) {
            this.reference = reference;
            this.diagnostics = new ArrayList<>();
        }

        /**
         * Create a project manager for the given project file.
         *
         * @param projectFile The GPR project file to load.
         */
        public static ProjectManager create(
            final String projectFile
        ) {
            return internalCreate(
                projectFile,
                null,
                null,
                null,
                null
            );
        }

        /**
         * Create a project manager from a project file, target and runtime. If the
         * project file is null, then an implicit project is loaded.
         *
         * @param projectFile The GPR project file to use, if any. If null, an
         *     implicit project will be loaded.
         * @param scenarioVariables Scenario variables to use during the
         *     project loading. This can be null.
         * @param target Ada target to use. This can be null.
         * @param runtime Ada runtime to use. This can be null.
         * @param configFile The absolute path to a .cgpr file to use during
         *     the project loading. This can be null.
         */
        public static ProjectManager create(
            final String projectFile,
            final ScenarioVariable[] scenarioVariables,
            final String target,
            final String runtime,
            final String configFile
        ) {
            return internalCreate(
                projectFile,
                scenarioVariables,
                target,
                runtime,
                configFile
            );
        }

        /**
         * Create a project manager for an implicit project. The current directory
         * is used as project source directory.
         *
         * @param target Ada target to use. This can be null.
         * @param runtime Ada runtime to use. This can be null.
         * @param configFile The absolute path to a .cgpr file to use during
         *     the project loading. This can be null.
         */
        public static ProjectManager createImplicit(
            final String target,
            final String runtime,
            final String configFile
        ) {
            return internalCreate(
                null,
                null,
                target,
                runtime,
                configFile
            );
        }

        /**
         * Internal creation method to generalize project creation while
         * presenting different API endpoints to the user.
         *
         * @param projectFile The GPR project file to use, if any. If null, an
         *     implicit project will be loaded.
         * @param scenarioVariables Scenario variables to use during the
         *     project loading. This can be null.
         * @param target Ada target to use. This can be null.
         * @param runtime Ada runtime to use. This can be null.
         * @param configFile The absolute path to a .cgpr file to use during
         *     the project loading. This can be null.
         */
        private static ProjectManager internalCreate(
            final String projectFile,
            final ScenarioVariable[] scenarioVariables,
            final String target,
            final String runtime,
            final String configFile
        ) {

            if(ImageInfo.inImageCode()) {
                // Declare native values
                final Pointer scenarioVariablesNative;
                final CCharPointer targetNative;
                final CCharPointer runtimeNative;
                final CCharPointer configFileNative;
                final Pointer errorsPointer;

                // Create the scenario variable array
                final int scenarioVariableNativeSize = SizeOf.get(ScenarioVariableNative.class);
                if(scenarioVariables != null && scenarioVariables.length > 0) {
                    final int size = scenarioVariables.length + 1;
                    scenarioVariablesNative = UnmanagedMemory.calloc(
                        size * scenarioVariableNativeSize
                    );
                    for(int i = 0 ; i < scenarioVariables.length ; i++) {
                        final ScenarioVariableNative scenarioVariableNative = (ScenarioVariableNative)
                            scenarioVariablesNative.add(i * scenarioVariableNativeSize);
                        scenarioVariables[i].unwrap(scenarioVariableNative);
                    }
                } else {
                    scenarioVariablesNative = WordFactory.nullPointer();
                }

                // Prepare the result pointer
                final Pointer projectPointer = StackValue.get(SizeOf.get(VoidPointer.class));
                projectPointer.writeWord(0, WordFactory.nullPointer());

                // Fill the native arguments
                targetNative = target == null ? WordFactory.nullPointer() : toCString(target);
                runtimeNative = runtime == null ? WordFactory.nullPointer() : toCString(runtime);
                configFileNative = configFile == null ? WordFactory.nullPointer() : toCString(configFile);
                errorsPointer = StackValue.get(SizeOf.get(WordPointer.class));
                errorsPointer.writeWord(0, WordFactory.nullPointer());

                // If the provided project file is null, call the implicit project loading.
                // Otherwise, call the standard project loading.
                if (projectFile == null) {
                    NI_LIB.ada_gpr_project_load_implicit(
                        targetNative,
                        runtimeNative,
                        configFileNative,
                        projectPointer,
                        errorsPointer
                    );
                } else {
                    final CCharPointer projectFileNative = toCString(projectFile);
                    NI_LIB.ada_gpr_project_load(
                        projectFileNative,
                        scenarioVariablesNative,
                        targetNative,
                        runtimeNative,
                        configFileNative,
                        0,
                        projectPointer,
                        errorsPointer
                    );
                    UnmanagedMemory.free(projectFileNative);
                }

                // Free the allocated strings
                if (target != null) UnmanagedMemory.free(targetNative);
                if (runtime != null) UnmanagedMemory.free(runtimeNative);
                if (configFile != null) UnmanagedMemory.free(configFileNative);

                // Check the langkit exception and cast it into a project manager error
                try {
                    checkException();
                } catch (LangkitException e) {
                    throw new ProjectManagerException(e.getMessage());
                }

                // Get the result of modified values
                final ProjectManagerNative projectManagerNative = (ProjectManagerNative) projectPointer.readWord(0);
                final StringArrayNative errorArrayNative = (StringArrayNative) errorsPointer.readWord(0);

                // Free the scenario variables
                if(scenarioVariablesNative.isNonNull()) {
                    for(int i = 0 ; i < scenarioVariables.length ; i++) {
                        final ScenarioVariableNative scenarioVariableNative = (ScenarioVariableNative)
                            scenarioVariablesNative.add(i * scenarioVariableNativeSize);
                        ScenarioVariable.release(scenarioVariableNative);
                    }
                    UnmanagedMemory.free(scenarioVariablesNative);
                }

                // `errorsPointer` is not allocated if an exception was raised during project file loading
                String[] errors = new String[0];
                if (errorArrayNative.isNonNull()) {
                    // Translate the error native array into a Java array
                    errors = toJStringArray(errorArrayNative);

                    // Free the error array
                    NI_LIB.ada_free_string_array(errorArrayNative);
                }

                // Check the langkit exception and cast it into a project manager error
                try {
                    checkException();
                } catch (LangkitException e) {
                    throw new ProjectManagerException(e.getMessage());
                }

                // Create the result project manager and add diagnostics if any
                final ProjectManager res = wrap(projectManagerNative);
                if (errors.length > 0) {
                    res.diagnostics.addAll(List.of(errors));
                }
                return res;
            } else {
                // Call the native function from the stubs
                final List<String> diagnostics = new ArrayList<>();
                final PointerWrapper reference;
                reference = JNI_LIB.ada_gpr_project_load(
                    projectFile,
                    scenarioVariables,
                    target,
                    runtime,
                    configFile,
                    diagnostics
                );

                // Check the langkit exceptions
                try {
                    checkException();
                } catch (LangkitException e) {
                    throw new ProjectManagerException(e.getMessage());
                }

                // Return the project manager
                final ProjectManager res = new ProjectManager(reference);
                res.diagnostics.addAll(diagnostics);
                return res;
            }

        }

        // ----- Graal C API methods -----

        /**
         * Wrap a native project manager in the Java class.
         *
         * @param pointer The pointer to the native project manager.
         * @return The newly wrapped project manager.
         */
        static ProjectManager wrap(
            final Pointer pointer
        ) {
            return wrap((ProjectManagerNative) pointer.readWord(0));
        }

        /**
         * Wrap a native project manager in the Java class.
         *
         * @param projectManagerNative The native project manager to wrap.
         * @return The newly wrapped project manager.
         */
        static ProjectManager wrap(
            final ProjectManagerNative projectManagerNative
        ) {
            return new ProjectManager(new PointerWrapper(projectManagerNative));
        }

        /**
         * Unwrap the project manager inside the given pointer.
         *
         * @param pointer The pointer to write in.
         */
        public void unwrap(
            final Pointer pointer
        ) {
            pointer.writeWord(0, this.unwrap());
        }

        /**
         * Get the native value of the project manager.
         *
         * @return The native project manager.
         */
        public ProjectManagerNative unwrap() {
            return (ProjectManagerNative) this.reference.ni();
        }

        // ----- Class methods -----

        /**
         * Translate a native string array structure into a Java string
         * array.
         *
         * @param stringArrayNative The native string array structure.
         * @return The Java string array.
         */
        private static String[] toJStringArray(
            final StringArrayNative stringArrayNative
        ) {
            final String[] res = new String[stringArrayNative.get_length()];
            final CCharPointerPointer nativeFilesPointer = stringArrayNative.get_c_ptr();
            for(int i = 0 ; i < res.length ; i++) {
                final CCharPointer nativeFile = nativeFilesPointer.read(i);
                res[i] = toJString(nativeFile);
            }
            return res;
        }

        // -----  Instance methods -----

        public List<String> getDiagnostics() {
            return this.diagnostics;
        }

        /**
         * Create a unit provider for the given subproject.
         *
         * @param subproject The subproject for which to create a unit provider.
         * @return The unit provider for the project manager.
         */
        public UnitProvider getProvider(final String subproject) {
            final UnitProvider result;
            if(ImageInfo.inImageCode()) {
                final CCharPointer subprojectNative =
                    subproject == null ?
                    WordFactory.nullPointer() :
                    toCString(subproject);

                UnitProviderNative unitProviderNative = NI_LIB.ada_gpr_project_create_unit_provider(
                    this.reference.ni(),
                    subprojectNative
                );
                result = UnitProvider.wrap(unitProviderNative);
                if (subproject != null) {
                    UnmanagedMemory.free(subprojectNative);
                }
            } else {
                result = JNI_LIB.ada_gpr_project_create_unit_provider(
                    this,
                    subproject
                );
            }
            return result;
        }

        /**
         * Create a unit provider for root project.
         */
        public UnitProvider getProvider() {
            return this.getProvider(null);
        }

        /**
         * Create a new analysis context from a GPR project.
         *
         * The unit provider, file reader, config pragmas and default charset
         * are inferred from the designated project: see the ``getProvider``
         * method for the semantics of the ``project`` argument.
         *
         * See the ``AnalysisContext`` class constructor for the semantics of
         * the other arguments.
         *
         * .. TODO: For now, the returned ``AnalysisContext`` instance has a
         *    weak reference to the project manager: make sure the
         *    ``ProjectManager`` instance lives at least as long as the
         *    ``AnalysisContext`` one.
         */
        public AnalysisContext createContext(
            String subproject,
            EventHandler eventHandler,
            boolean withTrivia,
            int tabStop
        ) {
            if(ImageInfo.inImageCode()) {
                // Prepare C values for native calls
                final CCharPointer subproject_c =
                  subproject == null
                  ? WordFactory.nullPointer()
                  : toCString(subproject);
                EventHandlerNative eventHandler_c =
                  eventHandler == null
                  ? WordFactory.nullPointer()
                  : eventHandler.reference.ni();

                // Manually allocate a C-level analysis context so that we can
                // initialize it ourselves.
                final PointerWrapper context = new PointerWrapper(
                    NI_LIB.ada_allocate_analysis_context()
                );

                // Create the Java wrapper, so that we have one ready for
                // event handler callbacks triggered during context
                // initialization.
                AnalysisContext result =
                    AnalysisContext.fromReference(context, eventHandler, true);

                // "result" has its own ownership share: release ours
                NI_LIB.ada_context_decref(context.ni());

                // TODO: attach "this" to "result" so that the former lives at
                // least as long as the former.

                // Finally, initialize the analysis context. Note that this
                // step may raise an exception: in that case, the analysis
                // context is considered not initialized: release it.
                NI_LIB.ada_gpr_project_initialize_context(
                    this.reference.ni(),
                    context.ni(),
                    subproject_c,
                    eventHandler_c,
                    withTrivia ? 1 : 0,
                    tabStop
                );
                UnmanagedMemory.free(subproject_c);
                final LangkitExceptionNative exc_c =
                    NI_LIB.ada_get_last_exception();
                if (exc_c.isNonNull()) {
                    LangkitException exc = wrapException(exc_c);
                    NI_LIB.ada_context_decref(context.ni());
                    throw exc;
                }

                return result;
            } else {
                return JNI_LIB.ada_gpr_project_create_context(
                    this,
                    subproject,
                    eventHandler,
                    withTrivia,
                    tabStop
                );
            }
        }

        /**
         * Get the files for the given subprojects in a string array.
         *
         * @param mode The file getting mode.
         * @param subprojects The subprojects to consider.
         * @return The array that contains the project files.
         */
        public String[] getFiles(
            final SourceFileMode mode,
            final String[] subprojects
        ) {
            // Verify if the project is null
            if(this.reference.isNull())
                return new String[0];

            String[] result = null;
            LangkitException exc;

            if(ImageInfo.inImageCode()) {
                // Convert the Java array of subprojects ("subprojects"
                // argument) into the required C array
                // (subprojectCount/subprojectsNative).
                final int subprojectCount;
                final CCharPointerPointer subprojectsNative;

                if (subprojects != null && subprojects.length > 0) {
                    subprojectCount = subprojects.length;
                    subprojectsNative =
                        UnmanagedMemory.calloc(
                            subprojectCount * SizeOf.get(CCharPointerPointer.class)
                        );
                } else {
                    subprojectCount = 0;
                    subprojectsNative = WordFactory.nullPointer();
                }

                for (int i = 0; i < subprojectCount; ++i) {
                    subprojectsNative.write(i, toCString(subprojects[i]));
                }

                // Call the C API. Keep track of a potential native exception.
                StringArrayNative sourceFileArray =
                    NI_LIB.ada_gpr_project_source_files(
                        this.reference.ni(),
                        mode.toC(),
                        subprojectsNative,
                        subprojectCount
                    );
                exc = getLastException();

                // If the call was successful, create the Java array result and
                // initialize it, and free the C array result.
                if(exc == null) {
                    result = toJStringArray(sourceFileArray);
                    NI_LIB.ada_free_string_array(sourceFileArray);
                }

                // Release subprojectsNative
                for (int i = 0; i < subprojectCount; ++i) {
                    UnmanagedMemory.free(subprojectsNative.read(i));
                }
                if (subprojectCount > 0) {
                    UnmanagedMemory.free(subprojectsNative);
                }
            } else {
                result = JNI_LIB.ada_gpr_project_source_files(
                    this,
                    mode.toC(),
                    subprojects
                );
                exc = getLastException();
            }

            // If we got an exception, turn it into a ProjectManagerException
            // one.
            if(exc != null) {
                throw new ProjectManagerException(exc.getMessage());
            }

            return result;

        }

        /**
         * Get the files of the root project in a string array.
         *
         * @param mode The file getting mode.
         * @return The array that contains the project files.
         */
        public String[] getFiles(final SourceFileMode mode) {
            return this.getFiles(mode, null);
        }

        /** @see java.lang.AutoCloseable#close() */
        @Override
        public void close() {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_gpr_project_free(this.reference.ni());
            } else {
                JNI_LIB.ada_gpr_project_free(this);
            }

        }

    }

    /**
     * Return a unit provider that knows which compilation units are to be
     * found in the given list of source files.
     *
     * This knowledge is built trying to parse all given input files as Ada
     * source files and listing the compilation units found there. Files that
     * cannot be parsed properly are discarded. If two compilation units are
     * found for the same unit, the first that is found in the given input
     * files is taken and the other ones are discarded.
     *
     * Source files are decoded using the given charset. If it is ``null``, the
     * default charset (ISO-8859-1) is used.
     *
     * .. TODO: Find a way to report discarded source files/compilation units.
     */
    public static UnitProvider createAutoProvider(
        final String[] sourceFiles,
        final String charset
    ) {
        if (ImageInfo.inImageCode()) {
            final CCharPointer charsetNative =
                charset == null ?
                WordFactory.nullPointer() :
                toCString(charset);

            // Allocate the C array of C strings that will contain decoded
            // source file names. Make room for one additional null pointer
            // to mark the end of the array.
            final CCharPointerPointer sourceFilesNative =
                UnmanagedMemory.calloc(
                    (sourceFiles.length + 1) * SizeOf.get(CCharPointerPointer.class)
                );

            for (int i = 0; i < sourceFiles.length; ++i) {
                sourceFilesNative.write(i, toCString(sourceFiles[i]));
            }

            // Create the auto provider
            final UnitProviderNative unitProviderNative =
                NI_LIB.ada_create_auto_provider(
                    sourceFilesNative,
                    charsetNative
                );

            // Release all temporarily allocated memory
            for (int i = 0; i < sourceFiles.length; ++i) {
                UnmanagedMemory.free(sourceFilesNative.read(i));
            }

            UnmanagedMemory.free(sourceFilesNative);

            if (charset != null) {
                UnmanagedMemory.free(charsetNative);
            }

            return UnitProvider.wrap(unitProviderNative);
        } else {
            return JNI_LIB.ada_create_auto_provider(
                sourceFiles,
                charset
            );
        }
    }



    // ==========
    // Defining the JNI bindings library
    // ==========

    
    
    
    
    
    
    

    /** This class contains all native function definitions for JNI */
    public static final class JNI_LIB {

        // ----- Static initializer -----

        static {
            if(!ImageInfo.inImageCode()) {
                // Load the needed libraries
                if(OS.indexOf("win") < 0) {
                    System.loadLibrary("langkit_sigsegv_handler");
                }
                System.loadLibrary("adalang_jni");

                // Initialize the JNI library
                ada_initialize();

                // Register the library finalizer
                Runtime.getRuntime().addShutdownHook(
                    new Thread(JNI_LIB::ada_finalize)
                );
            }
        }

        // ----- Language specific functions -----

        
      


    // --- Project manager functions

    /**
     * Function to load a GPR project.
     *
     * @param diagnostics The list of diagnostics emitted during the project
     *     opening. Will be filled by this function call.
     */
    @CompilerDirectives.TruffleBoundary
    public static native PointerWrapper ada_gpr_project_load(
        String projectFile,
        ScenarioVariable[] scenarioVariables,
        String target,
        String runtime,
        String configFile,
        List<String> diagnostics
    );

    /** Free the given project */
    @CompilerDirectives.TruffleBoundary
    public static native void ada_gpr_project_free(
        ProjectManager project
    );

    /** Get the unit provider for the given project */
    @CompilerDirectives.TruffleBoundary
    public static native UnitProvider ada_gpr_project_create_unit_provider(
        ProjectManager project,
        String subproject
    );

    /** Get the source file array for the given project */
    @CompilerDirectives.TruffleBoundary
    public static native String[] ada_gpr_project_source_files(
        ProjectManager project,
        int mode,
        String[] subprojects
    );

    /**
     * Create a new analysis context from a GPR project.
     *
     * The unit provider, file reader, config pragmas and default charset are
     * inferred from the designated project: see the ``getProvider`` method for
     * the semantics of the ``project`` argument.
     *
     * See the ``AnalysisContext`` class constructor for the semantics of the
     * other arguments.
     *
     * .. TODO: For now, the returned ``AnalysisContext`` instance has a weak
     *    reference to the project manager: make sure the ``ProjectManager``
     *    instance lives at least as long as the ``AnalysisContext`` one.
     */
    public static native AnalysisContext ada_gpr_project_create_context(
        ProjectManager project,
        String subproject,
        EventHandler eventHandler,
        boolean withTrivia,
        int tabStop
    );

    /** Create an auto provider reference */
    @CompilerDirectives.TruffleBoundary
    public static native UnitProvider ada_create_auto_provider(
        String[] sourceFiles,
        String charset
    );

    // --- Config pragmas

    @CompilerDirectives.TruffleBoundary
    public static native void ada_set_config_pragmas_mapping(
        AnalysisContext context,
        AnalysisUnit globalPragmas,
        AnalysisUnit[] localPragmas
    );



        // ----- Lifecycle functions ------

        /** Function to initialize the JNI library */
        public static native void ada_initialize();

        /** Function to finalize the JNI library */
        public static native void ada_finalize();

        // ----- Exception functions ------

        /** Get the last langkit exception */
        @CompilerDirectives.TruffleBoundary
        public static native LangkitException ada_get_last_exception();

        // ----- Text functions -----

        /** Create a new text from its content */
        @CompilerDirectives.TruffleBoundary
        public static native Text ada_create_text(
            byte[] utf32Content
        );

        /** Destroy the given text */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_destroy_text(
            Text text
        );

        // ----- Rewriting apply result functions -----

        /** Get the diagnostics from the rewriting apply result */
        @CompilerDirectives.TruffleBoundary
        public static native Diagnostic[]
        ada_rewriting_get_result_diagnostics(
            int diagnosticsCount,
            long diagnosticsReference
        );

        /** Free the rewriting apply result structure */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_rewriting_free_apply_result(
            RewritingApplyResult applyResult
        );

        // ----- File reader functions -----

        /** Decrease the reference counter of the given file reader */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_dec_ref_file_reader(
            FileReader fileReader
        );

        // ----- Unit provider functions -----

        /** Decrease the ref counter of the unit provider */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_dec_ref_unit_provider(
            UnitProvider unitProvider
        );

        // ----- Event handler functions -----

        /** Create a new event handler */
        @CompilerDirectives.TruffleBoundary
        public static native PointerWrapper ada_create_event_handler(
            EventHandler.UnitRequestedCallback unitRequestedCallback,
            EventHandler.UnitParsedCallback unitParsedCallback
        );

        /** Decrease the ref counter of the event handler */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_dec_ref_event_handler(
            EventHandler eventHandler
        );

        // ----- Token functions -----

        /** Get the next token */
        @CompilerDirectives.TruffleBoundary
        public static native Token ada_token_next(
            Token token
        );

        /** Get the previous token */
        @CompilerDirectives.TruffleBoundary
        public static native Token ada_token_previous(
            Token token
        );

        /** Get if the tokens are equivalent */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_token_is_equivalent(
            Token left,
            Token right
        );

        /** Get text between the two tokens */
        @CompilerDirectives.TruffleBoundary
        public static native Text ada_token_range_text(
            Token start,
            Token end
        );

        // ----- Analysis context functions -----

        /** Create a new analysis context */
        @CompilerDirectives.TruffleBoundary
        public static native PointerWrapper ada_create_analysis_context(
            String charset,
            FileReader fileReader,
            UnitProvider unitProvider,
            EventHandler eventHandler,
            boolean withTrivia,
            int tabstop
        );

        /** Increase the reference counter of a context */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_context_incref(
            long context
        );

        /** Decrease the reference counter of a context */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_context_decref(
            long context
        );

        // ----- Analysis unit functions -----

        /** Get the analysis unit from a file */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisUnit
        ada_get_analysis_unit_from_file(
            AnalysisContext context,
            String fileName,
            String charset,
            boolean reparse,
            int grammarRule
        );

        /** Get the analysis unit from a buffer */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisUnit
        ada_get_analysis_unit_from_buffer(
            AnalysisContext context,
            String fileName,
            String charset,
            String buffer,
            long bufferSize,
            int grammarRule
        );

        /** Get the analysis unit from the unit provider. */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisUnit
        ada_get_analysis_unit_from_provider(
            AnalysisContext context,
            Text name,
            int kind,
            String charset,
            boolean reparse
        );

        /** Get the root of the analysis unit */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_unit_root(
            AnalysisUnit unit
        );

        /** Get the file name of the analysis unit */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_unit_filename(
            AnalysisUnit unit
        );

        /** Get the token count of the analysis unit */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_unit_token_count(
            AnalysisUnit unit
        );

        /** Get the trivia count of the analysis unit */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_unit_trivia_count(
            AnalysisUnit unit
        );

        /** Get the first token of the analysis unit */
        @CompilerDirectives.TruffleBoundary
        public static native Token ada_unit_first_token(
            AnalysisUnit unit
        );

        /** Get the last token of the analysis unit */
        @CompilerDirectives.TruffleBoundary
        public static native Token ada_unit_last_token(
            AnalysisUnit unit
        );

        /** Get the context of the analysis unit */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisContext ada_unit_context(
            AnalysisUnit unit
        );

        /** Get the number of diagnostic in the analysis unit */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_unit_diagnostic_count(
            AnalysisUnit unit
        );

        /** Get the nth diagnostic of the analysis unit */
        @CompilerDirectives.TruffleBoundary
        public static native Diagnostic ada_unit_diagnostic(
            AnalysisUnit unit,
            int n
        );

        // ----- Rewriting context functions -----

        /** Start a rewriting session and return the new context */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingContext
        ada_rewriting_start_rewriting(
            AnalysisContext analysisContext
        );

        /** Get the analysis context from the given rewriting context */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisContext
        ada_rewriting_handle_to_context(
            RewritingContext rewritingContext
        );

        /** Get a pointer to the rewriting units owned by the context */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingUnit[] ada_rewriting_unit_handles(
            RewritingContext rewritingContext
        );

        /** Create a node in the rewriting context and return it */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode ada_rewriting_create_node(
            RewritingContext rewritingContext,
            int nodeKind
        );

        /** Create a node in the rewriting context with the given children */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode
        ada_rewriting_create_regular_node(
            RewritingContext rewritingContext,
            int nodeKind,
            RewritingNode[] children
        );

        /** Create a token node in the rewriting context and return it */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode
        ada_rewriting_create_token_node(
            RewritingContext rewritingContext,
            int nodeKind,
            Text nodeText
        );

        /** Create a new node tree from the given template */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode
        ada_rewriting_create_from_template(
            RewritingContext rewriting_context,
            Text template_text,
            RewritingNode[] arguments,
            int rule
        );

        /** Apply the rewriting session and close it fi success */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingApplyResult ada_rewriting_apply(
            RewritingContext rewritingContext
        );

        /** Abort the rewriting session */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_rewriting_abort_rewriting(
            RewritingContext rewritingContext
        );

        // ----- Rewriting unit functions -----

        /** Get the rewriting unit associated */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingUnit ada_rewriting_unit_to_handle(
            AnalysisUnit analysisUnit
        );

        /** Get the analysis unit corresponding to the given rewriting unit */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisUnit ada_rewriting_handle_to_unit(
            RewritingUnit rewritingUnit
        );

        /** Get the root of the given rewriting unit */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode ada_rewriting_unit_root(
            RewritingUnit rewritingUnit
        );

        /** Set the root of the rewriting unit to the rewriting node */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_rewriting_unit_set_root(
            RewritingUnit rewritingUnit,
            RewritingNode rewritingNode
        );

        /** Unparse the given rewriting unit and return its textual value */
        @CompilerDirectives.TruffleBoundary
        public static native Text ada_rewriting_unit_unparse(
            RewritingUnit rewritingUnit
        );

        // ----- Rewriting node functions -----

        /** Get the rewriting node from the given parsed node */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode ada_rewriting_node_to_handle(
            Entity entity
        );

        /** Get the parsed node from the given rewriting node */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_rewriting_handle_to_node(
            RewritingNode rewritingNode
        );

        /** Get the rewriting context from the given rewriting node */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingContext
        ada_rewriting_node_to_context(
            RewritingNode rewriting_node
        );

        /** Clone the given rewriting node and return the copy */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode ada_rewriting_clone(
            RewritingNode toClone
        );

        /** Unparse the given rewriting node in the given text */
        @CompilerDirectives.TruffleBoundary
        public static native Text ada_rewriting_node_unparse(
            RewritingNode rewritingNode
        );

        /** Get the kind of the rewriting node */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_rewriting_kind(
            RewritingNode rewritingNode
        );

        /** Get the rewriting node image */
        @CompilerDirectives.TruffleBoundary
        public static native Text ada_rewriting_node_image(
            RewritingNode rewritingNode
        );

        /** Return whether the node is tied to a rewriting unit */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_rewriting_tied(
            RewritingNode rewritingNode
        );

        /** Return the parent of the given rewriting node */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode ada_rewriting_parent(
            RewritingNode rewritingNode
        );

        /** Get the rewriting node children */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode[] ada_rewriting_children(
            RewritingNode rewritingNode
        );

        /** Get the child at the given member reference */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode ada_rewriting_child(
            RewritingNode parent,
            int childMemberReference
        );

        /** Set the given child at the given member reference */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_rewriting_set_child(
            RewritingNode parent,
            int childMemberReference,
            RewritingNode newChild
        );

        /** Replace the rewriting node by the new one */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_rewriting_replace(
            RewritingNode rewritingNode,
            RewritingNode newNode
        );

        /** Get the first child of the rewriting node */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode ada_rewriting_first_child(
            RewritingNode parent
        );

        /** Get the last child of the rewriting node */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode ada_rewriting_last_child(
            RewritingNode parent
        );

        /** Get the next child from the given rewriting node */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode ada_rewriting_next_child(
            RewritingNode rewritingNode
        );

        /** Get the previous child from the given rewriting node */
        @CompilerDirectives.TruffleBoundary
        public static native RewritingNode ada_rewriting_previous_child(
            RewritingNode rewritingNode
        );

        /** Insert the provided rewriting node before the other node */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_rewriting_insert_before(
            RewritingNode rewritingNode,
            RewritingNode toInsert
        );

        /** Insert the provided rewriting node after the other node */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_rewriting_insert_after(
            RewritingNode rewritingNode,
            RewritingNode toInsert
        );

        /**
         * Insert the provided rewriting node at the beginning of the
         * children
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_insert_first(
            RewritingNode rewritingNode,
            RewritingNode toInsert
        );

        /** Insert the provided rewriting node at the end of the children */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_insert_last(
            RewritingNode rewritingNode,
            RewritingNode toInsert
        );

        /** Remove the given rewriting node from its list parent */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_rewriting_remove_child(
            RewritingNode toRemove
        );

        /** Get the text of the rewriting token node */
        @CompilerDirectives.TruffleBoundary
        public static native Text ada_rewriting_text(
            RewritingNode rewritingNode
        );

        /** Set the text of the rewriting token node */
        @CompilerDirectives.TruffleBoundary
        public static native void ada_rewriting_set_text(
            RewritingNode rewritingNode,
            Text text
        );

        // ----- Node functions -----

        /** Return whether the two given entities are equal */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_node_is_equivalent(
            Entity entity_left,
            Entity entity_right
        );

        /** Get the hash of a node */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_node_hash(
            Entity entity
        );

        /** Get the node kind */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_node_kind(
            Entity entity
        );

        /** Get the node text */
        @CompilerDirectives.TruffleBoundary
        public static native Text ada_node_text(
            Entity entity
        );

        /** Get the node source location range */
        @CompilerDirectives.TruffleBoundary
        public static native SourceLocationRange ada_node_sloc_range(
            Entity entity
        );

        /** Get the node children count */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_node_children_count(
            Entity entity
        );

        /** Get the node nth child */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_node_child(
            Entity entity,
            int n
        );

        /** Get if the node is a token node */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_node_is_token_node(
            Entity entity
        );

        /** Get the unit of the node */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisUnit ada_node_unit(
            Entity entity
        );

        /** Get the entity image of the node */
        @CompilerDirectives.TruffleBoundary
        public static native Text ada_node_image(
            Entity entity
        );

        // ----- Node fields accessors and properties -----

        
    

            

        /** Isomethod of ada_ada_node_p_declarative_scope langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_declarative_scope(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_enclosing_compilation_unit langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_enclosing_compilation_unit(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_get_uninstantiated_node langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_get_uninstantiated_node(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_complete langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native CompletionItemIterator ada_ada_node_p_complete(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_valid_keywords langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Symbol[] ada_ada_node_p_valid_keywords(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_generic_instantiations langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native GenericInstantiation[] ada_ada_node_p_generic_instantiations(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_semantic_parent langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_semantic_parent(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_parent_basic_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_parent_basic_decl(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_has_spark_mode_on langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_ada_node_p_has_spark_mode_on(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_is_subject_to_proof langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_ada_node_p_is_subject_to_proof(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_filter_is_imported_by langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisUnit[] ada_ada_node_p_filter_is_imported_by(
            AnalysisUnit[]
            units,
            boolean
            transitive,
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_resolve_names langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_ada_node_p_resolve_names(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_nameres_diagnostics langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native SolverDiagnostic[] ada_ada_node_p_nameres_diagnostics(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_standard_unit langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisUnit ada_ada_node_p_standard_unit(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_is_keyword langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_ada_node_p_is_keyword(
            Token
            token,
            Symbol
            language_version,
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_std_entity langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_std_entity(
            Symbol
            sym,
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_bool_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_bool_type(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_int_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_int_type(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_universal_int_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_universal_int_type(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_universal_real_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_universal_real_type(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_std_char_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_std_char_type(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_std_wide_char_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_std_wide_char_type(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_std_wide_wide_char_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_std_wide_wide_char_type(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_std_string_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_std_string_type(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_std_wide_string_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_std_wide_string_type(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_std_wide_wide_string_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_std_wide_wide_string_type(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_top_level_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_top_level_decl(
            AnalysisUnit
            unit,
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_choice_match langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_ada_node_p_choice_match(
            BigInteger
            value,
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_gnat_xref langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_p_gnat_xref(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_spark_mode_aspect langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Aspect ada_ada_node_p_spark_mode_aspect(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_xref_entry_point langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_ada_node_p_xref_entry_point(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_p_matching_with_use_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_ada_node_p_matching_with_use_clause(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_parent langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_parent(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_parents langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native AdaNode[] ada_ada_node_parents(
            boolean
            with_self,
            Entity node
        );
            

        /** Isomethod of ada_ada_node_children langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native AdaNode[] ada_ada_node_children(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_token_start langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Token ada_ada_node_token_start(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_token_end langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Token ada_ada_node_token_end(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_child_index langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_ada_node_child_index(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_previous_sibling langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_previous_sibling(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_next_sibling langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ada_node_next_sibling(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_unit langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisUnit ada_ada_node_unit(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_is_ghost langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_ada_node_is_ghost(
            Entity node
        );
            

        /** Isomethod of ada_ada_node_full_sloc_image langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_ada_node_full_sloc_image(
            Entity node
        );

        
    

            

        /** Isomethod of ada_abort_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_abort_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_abstract_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_abstract_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_assoc_list_p_zip_with_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native ParamActual[] ada_assoc_list_p_zip_with_params(
            boolean
            imprecise_fallback,
            Entity node
        );

        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_aliased_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_aliased_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_all_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_all_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_constrained_array_indices_f_list langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_constrained_array_indices_f_list(
            Entity node
        );

        
    

            

        /** Isomethod of ada_unconstrained_array_indices_f_types langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_unconstrained_array_indices_f_types(
            Entity node
        );

        
    

            

        /** Isomethod of ada_aspect_assoc_f_id langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_aspect_assoc_f_id(
            Entity node
        );
            

        /** Isomethod of ada_aspect_assoc_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_aspect_assoc_f_expr(
            Entity node
        );
            

        /** Isomethod of ada_aspect_assoc_p_is_ghost_code langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_aspect_assoc_p_is_ghost_code(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_at_clause_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_at_clause_f_name(
            Entity node
        );
            

        /** Isomethod of ada_at_clause_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_at_clause_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_attribute_def_clause_f_attribute_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_attribute_def_clause_f_attribute_expr(
            Entity node
        );
            

        /** Isomethod of ada_attribute_def_clause_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_attribute_def_clause_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_enum_rep_clause_f_type_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_enum_rep_clause_f_type_name(
            Entity node
        );
            

        /** Isomethod of ada_enum_rep_clause_f_aggregate langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_enum_rep_clause_f_aggregate(
            Entity node
        );
            

        /** Isomethod of ada_enum_rep_clause_p_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native ParamActual[] ada_enum_rep_clause_p_params(
            Entity node
        );

        
    

            

        /** Isomethod of ada_record_rep_clause_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_record_rep_clause_f_name(
            Entity node
        );
            

        /** Isomethod of ada_record_rep_clause_f_at_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_record_rep_clause_f_at_expr(
            Entity node
        );
            

        /** Isomethod of ada_record_rep_clause_f_components langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_record_rep_clause_f_components(
            Entity node
        );

        
    

            

        /** Isomethod of ada_aspect_spec_f_aspect_assocs langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_aspect_spec_f_aspect_assocs(
            Entity node
        );

        
    

            

        /** Isomethod of ada_base_assoc_p_assoc_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_assoc_p_assoc_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_contract_case_assoc_f_guard langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_contract_case_assoc_f_guard(
            Entity node
        );
            

        /** Isomethod of ada_contract_case_assoc_f_consequence langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_contract_case_assoc_f_consequence(
            Entity node
        );

        
    

            

        /** Isomethod of ada_pragma_argument_assoc_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_pragma_argument_assoc_f_name(
            Entity node
        );
            

        /** Isomethod of ada_pragma_argument_assoc_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_pragma_argument_assoc_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_base_formal_param_holder_p_abstract_formal_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BaseFormalParamDecl[] ada_base_formal_param_holder_p_abstract_formal_params(
            Entity node
        );
            

        /** Isomethod of ada_base_formal_param_holder_p_formal_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native DefiningName[] ada_base_formal_param_holder_p_formal_params(
            Entity node
        );
            

        /** Isomethod of ada_base_formal_param_holder_p_nb_min_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_base_formal_param_holder_p_nb_min_params(
            Entity node
        );
            

        /** Isomethod of ada_base_formal_param_holder_p_nb_max_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native int ada_base_formal_param_holder_p_nb_max_params(
            Entity node
        );
            

        /** Isomethod of ada_base_formal_param_holder_p_param_types langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BaseTypeDecl[] ada_base_formal_param_holder_p_param_types(
            Entity
            origin,
            Entity node
        );

        
    

            

        /** Isomethod of ada_base_subp_spec_p_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_subp_spec_p_name(
            Entity node
        );
            

        /** Isomethod of ada_base_subp_spec_p_returns langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_subp_spec_p_returns(
            Entity node
        );
            

        /** Isomethod of ada_base_subp_spec_p_primitive_subp_types langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BaseTypeDecl[] ada_base_subp_spec_p_primitive_subp_types(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_base_subp_spec_p_primitive_subp_first_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_subp_spec_p_primitive_subp_first_type(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_base_subp_spec_p_primitive_subp_tagged_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_subp_spec_p_primitive_subp_tagged_type(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_base_subp_spec_p_return_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_subp_spec_p_return_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_subp_spec_p_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native ParamSpec[] ada_base_subp_spec_p_params(
            Entity node
        );

        
    

            

        /** Isomethod of ada_entry_spec_f_entry_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_spec_f_entry_name(
            Entity node
        );
            

        /** Isomethod of ada_entry_spec_f_family_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_spec_f_family_type(
            Entity node
        );
            

        /** Isomethod of ada_entry_spec_f_entry_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_spec_f_entry_params(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_subp_spec_f_subp_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subp_spec_f_subp_kind(
            Entity node
        );
            

        /** Isomethod of ada_subp_spec_f_subp_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subp_spec_f_subp_name(
            Entity node
        );
            

        /** Isomethod of ada_subp_spec_f_subp_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subp_spec_f_subp_params(
            Entity node
        );
            

        /** Isomethod of ada_subp_spec_f_subp_returns langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subp_spec_f_subp_returns(
            Entity node
        );

        
    

            

        /** Isomethod of ada_synthetic_binary_spec_f_left_param langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_synthetic_binary_spec_f_left_param(
            Entity node
        );
            

        /** Isomethod of ada_synthetic_binary_spec_f_right_param langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_synthetic_binary_spec_f_right_param(
            Entity node
        );
            

        /** Isomethod of ada_synthetic_binary_spec_f_return_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_synthetic_binary_spec_f_return_type_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_synthetic_unary_spec_f_right_param langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_synthetic_unary_spec_f_right_param(
            Entity node
        );
            

        /** Isomethod of ada_synthetic_unary_spec_f_return_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_synthetic_unary_spec_f_return_type_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_component_list_f_components langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_list_f_components(
            Entity node
        );
            

        /** Isomethod of ada_component_list_f_variant_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_list_f_variant_part(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_known_discriminant_part_f_discr_specs langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_known_discriminant_part_f_discr_specs(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_entry_completion_formal_params_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_completion_formal_params_f_params(
            Entity node
        );

        
    

            

        /** Isomethod of ada_generic_formal_part_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_formal_part_f_decls(
            Entity node
        );

        
    

            

        /** Isomethod of ada_base_record_def_f_components langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_record_def_f_components(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_basic_assoc_p_get_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native DefiningName[] ada_basic_assoc_p_get_params(
            boolean
            imprecise_fallback,
            Entity node
        );

        
    

            

        /** Isomethod of ada_aggregate_assoc_f_designators langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_aggregate_assoc_f_designators(
            Entity node
        );
            

        /** Isomethod of ada_aggregate_assoc_f_r_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_aggregate_assoc_f_r_expr(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_composite_constraint_assoc_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_composite_constraint_assoc_f_ids(
            Entity node
        );
            

        /** Isomethod of ada_composite_constraint_assoc_f_constraint_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_composite_constraint_assoc_f_constraint_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_iterated_assoc_f_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_iterated_assoc_f_spec(
            Entity node
        );
            

        /** Isomethod of ada_iterated_assoc_f_key_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_iterated_assoc_f_key_expr(
            Entity node
        );
            

        /** Isomethod of ada_iterated_assoc_f_r_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_iterated_assoc_f_r_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_param_assoc_f_designator langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_param_assoc_f_designator(
            Entity node
        );
            

        /** Isomethod of ada_param_assoc_f_r_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_param_assoc_f_r_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_basic_decl_f_aspects langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_f_aspects(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_is_formal langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_basic_decl_p_is_formal(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_doc_annotations langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native DocAnnotation[] ada_basic_decl_p_doc_annotations(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_doc langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_basic_decl_p_doc(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_canonical_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_canonical_part(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_all_parts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BasicDecl[] ada_basic_decl_p_all_parts(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_get_aspect_assoc langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_get_aspect_assoc(
            Symbol
            name,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_get_aspect_spec_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_get_aspect_spec_expr(
            Symbol
            name,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_get_aspect langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Aspect ada_basic_decl_p_get_aspect(
            Symbol
            name,
            boolean
            previous_parts_only,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_has_aspect langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_basic_decl_p_has_aspect(
            Symbol
            name,
            boolean
            previous_parts_only,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_get_pragma langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_get_pragma(
            Symbol
            name,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_get_representation_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_get_representation_clause(
            Symbol
            name,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_get_at_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_get_at_clause(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_get_annotations langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Aspect[] ada_basic_decl_p_get_annotations(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_is_ghost_code langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_basic_decl_p_is_ghost_code(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_is_compilation_unit_root langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_basic_decl_p_is_compilation_unit_root(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_is_visible langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_basic_decl_p_is_visible(
            Entity
            from_node,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_base_subp_declarations langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BasicDecl[] ada_basic_decl_p_base_subp_declarations(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_root_subp_declarations langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BasicDecl[] ada_basic_decl_p_root_subp_declarations(
            Entity
            origin,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_find_all_overrides langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BasicDecl[] ada_basic_decl_p_find_all_overrides(
            AnalysisUnit[]
            units,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_defining_names langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native DefiningName[] ada_basic_decl_p_defining_names(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_defining_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_defining_name(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_subp_spec_or_null langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_subp_spec_or_null(
            boolean
            follow_generic,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_is_subprogram langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_basic_decl_p_is_subprogram(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_relative_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_relative_name(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_relative_name_text langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Symbol ada_basic_decl_p_relative_name_text(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_body_part_for_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_body_part_for_decl(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_most_visible_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_most_visible_part(
            Entity
            origin,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_fully_qualified_name_array langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Symbol[] ada_basic_decl_p_fully_qualified_name_array(
            boolean
            include_profile,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_basic_decl_p_fully_qualified_name(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_canonical_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_basic_decl_p_canonical_fully_qualified_name(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_unique_identifying_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_basic_decl_p_unique_identifying_name(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_previous_part_for_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_previous_part_for_decl(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_is_static_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_basic_decl_p_is_static_decl(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_is_imported langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_basic_decl_p_is_imported(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_type_expression langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_type_expression(
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_next_part_for_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_decl_p_next_part_for_decl(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_basic_decl_p_is_constant_object langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_basic_decl_p_is_constant_object(
            Entity node
        );

        
    

            

        /** Isomethod of ada_abstract_state_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_abstract_state_decl_f_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_anonymous_expr_decl_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_anonymous_expr_decl_f_expr(
            Entity node
        );
            

        /** Isomethod of ada_anonymous_expr_decl_p_get_formal langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_anonymous_expr_decl_p_get_formal(
            boolean
            imprecise_fallback,
            Entity node
        );

        
    

            

        /** Isomethod of ada_base_formal_param_decl_p_formal_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_formal_param_decl_p_formal_type(
            Entity
            origin,
            Entity node
        );

        
    

            

        /** Isomethod of ada_component_decl_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_decl_f_ids(
            Entity node
        );
            

        /** Isomethod of ada_component_decl_f_component_def langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_decl_f_component_def(
            Entity node
        );
            

        /** Isomethod of ada_component_decl_f_default_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_decl_f_default_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_discriminant_spec_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_discriminant_spec_f_ids(
            Entity node
        );
            

        /** Isomethod of ada_discriminant_spec_f_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_discriminant_spec_f_type_expr(
            Entity node
        );
            

        /** Isomethod of ada_discriminant_spec_f_default_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_discriminant_spec_f_default_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_generic_formal_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_formal_f_decl(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_param_spec_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_param_spec_f_ids(
            Entity node
        );
            

        /** Isomethod of ada_param_spec_f_has_aliased langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_param_spec_f_has_aliased(
            Entity node
        );
            

        /** Isomethod of ada_param_spec_f_mode langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_param_spec_f_mode(
            Entity node
        );
            

        /** Isomethod of ada_param_spec_f_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_param_spec_f_type_expr(
            Entity node
        );
            

        /** Isomethod of ada_param_spec_f_default_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_param_spec_f_default_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_synthetic_formal_param_decl_f_param_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_synthetic_formal_param_decl_f_param_type(
            Entity node
        );

        
    

            

        /** Isomethod of ada_base_package_decl_f_package_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_package_decl_f_package_name(
            Entity node
        );
            

        /** Isomethod of ada_base_package_decl_f_public_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_package_decl_f_public_part(
            Entity node
        );
            

        /** Isomethod of ada_base_package_decl_f_private_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_package_decl_f_private_part(
            Entity node
        );
            

        /** Isomethod of ada_base_package_decl_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_package_decl_f_end_name(
            Entity node
        );
            

        /** Isomethod of ada_base_package_decl_p_body_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_package_decl_p_body_part(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_base_type_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_f_name(
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_base_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_base_subtype(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_attribute_subprogram langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_attribute_subprogram(
            Symbol
            attr_name,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_private_completion langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_private_completion(
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_inherited_primitive langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_inherited_primitive(
            Entity
            p,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_get_record_representation_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_get_record_representation_clause(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_get_enum_representation_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_get_enum_representation_clause(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_get_primitives langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BasicDecl[] ada_base_type_decl_p_get_primitives(
            boolean
            only_inherited,
            boolean
            include_predefined_operators,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_array_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_array_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_find_derived_types langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native TypeDecl[] ada_base_type_decl_p_find_derived_types(
            Entity
            root,
            Entity
            origin,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_scalar_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_scalar_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_specific_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_specific_type(
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_find_all_derived_types langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native TypeDecl[] ada_base_type_decl_p_find_all_derived_types(
            AnalysisUnit[]
            units,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_comp_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_comp_type(
            boolean
            is_subscript,
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_index_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_index_type(
            int
            dim,
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_derived_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_derived_type(
            Entity
            other_type,
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_limited_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_limited_type(
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_matching_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_matching_type(
            Entity
            expected_type,
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_previous_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_previous_part(
            boolean
            go_to_incomplete,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_next_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_next_part(
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_full_view langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_full_view(
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_definite_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_definite_subtype(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_discriminants_list langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BaseFormalParamDecl[] ada_base_type_decl_p_discriminants_list(
            Entity
            stop_recurse_at,
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_shapes langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Shape[] ada_base_type_decl_p_shapes(
            boolean
            include_discriminants,
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_record_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_record_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_real_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_real_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_float_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_float_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_fixed_point langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_fixed_point(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_enum_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_enum_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_access_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_access_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_char_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_char_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_classwide_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_classwide_type(
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_discrete_range langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native DiscreteRange ada_base_type_decl_p_discrete_range(
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_discrete_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_discrete_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_int_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_int_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_accessed_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_accessed_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_tagged_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_tagged_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_base_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_base_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_base_types langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BaseTypeDecl[] ada_base_type_decl_p_base_types(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_interface_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_interface_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_canonical_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_canonical_type(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_is_private langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_type_decl_p_is_private(
            Entity node
        );
            

        /** Isomethod of ada_base_type_decl_p_root_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_type_decl_p_root_type(
            Entity
            origin,
            Entity node
        );

        
    

            

        /** Isomethod of ada_base_subtype_decl_p_get_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_subtype_decl_p_get_type(
            Entity
            origin,
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_subtype_decl_f_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subtype_decl_f_subtype(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_incomplete_type_decl_f_discriminants langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_incomplete_type_decl_f_discriminants(
            Entity node
        );

        
    

            

        /** Isomethod of ada_incomplete_formal_type_decl_f_is_tagged langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_incomplete_formal_type_decl_f_is_tagged(
            Entity node
        );
            

        /** Isomethod of ada_incomplete_formal_type_decl_f_default_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_incomplete_formal_type_decl_f_default_type(
            Entity node
        );

        
    

            

        /** Isomethod of ada_incomplete_tagged_type_decl_f_has_abstract langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_incomplete_tagged_type_decl_f_has_abstract(
            Entity node
        );

        
    

            

        /** Isomethod of ada_protected_type_decl_f_discriminants langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_protected_type_decl_f_discriminants(
            Entity node
        );
            

        /** Isomethod of ada_protected_type_decl_f_interfaces langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_protected_type_decl_f_interfaces(
            Entity node
        );
            

        /** Isomethod of ada_protected_type_decl_f_definition langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_protected_type_decl_f_definition(
            Entity node
        );

        
    

            

        /** Isomethod of ada_task_type_decl_f_discriminants langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_type_decl_f_discriminants(
            Entity node
        );
            

        /** Isomethod of ada_task_type_decl_f_definition langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_type_decl_f_definition(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_type_decl_f_discriminants langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_type_decl_f_discriminants(
            Entity node
        );
            

        /** Isomethod of ada_type_decl_f_type_def langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_type_decl_f_type_def(
            Entity node
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_formal_type_decl_f_default_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_formal_type_decl_f_default_type(
            Entity node
        );

        
    

            

        /** Isomethod of ada_basic_subp_decl_p_subp_decl_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_basic_subp_decl_p_subp_decl_spec(
            Entity node
        );

        
    

            

        /** Isomethod of ada_classic_subp_decl_f_overriding langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_classic_subp_decl_f_overriding(
            Entity node
        );
            

        /** Isomethod of ada_classic_subp_decl_f_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_classic_subp_decl_f_subp_spec(
            Entity node
        );
            

        /** Isomethod of ada_classic_subp_decl_p_body_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_classic_subp_decl_p_body_part(
            boolean
            imprecise_fallback,
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_formal_subp_decl_f_default_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_formal_subp_decl_f_default_expr(
            Entity node
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_entry_decl_f_overriding langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_decl_f_overriding(
            Entity node
        );
            

        /** Isomethod of ada_entry_decl_f_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_decl_f_spec(
            Entity node
        );
            

        /** Isomethod of ada_entry_decl_p_body_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_decl_p_body_part(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_entry_decl_p_accept_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native AcceptStmt[] ada_entry_decl_p_accept_stmts(
            Entity node
        );

        
    

            

        /** Isomethod of ada_enum_literal_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_enum_literal_decl_f_name(
            Entity node
        );
            

        /** Isomethod of ada_enum_literal_decl_p_enum_rep langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BigInteger ada_enum_literal_decl_p_enum_rep(
            Entity node
        );
            

        /** Isomethod of ada_enum_literal_decl_p_enum_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_enum_literal_decl_p_enum_type(
            Entity node
        );

        
    

            

        /** Isomethod of ada_synthetic_char_enum_lit_p_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_synthetic_char_enum_lit_p_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_generic_subp_internal_f_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_internal_f_subp_spec(
            Entity node
        );

        
    

            

        /** Isomethod of ada_synthetic_subp_decl_f_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_synthetic_subp_decl_f_spec(
            Entity node
        );

        
    

            

        /** Isomethod of ada_body_node_p_previous_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_body_node_p_previous_part(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_body_node_p_decl_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_body_node_p_decl_part(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_body_node_p_subunit_root langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_body_node_p_subunit_root(
            Entity node
        );

        
    

            

        /** Isomethod of ada_accept_stmt_body_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_accept_stmt_body_f_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_base_subp_body_f_overriding langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_subp_body_f_overriding(
            Entity node
        );
            

        /** Isomethod of ada_base_subp_body_f_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_subp_body_f_subp_spec(
            Entity node
        );

        
    

            

        /** Isomethod of ada_expr_function_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_expr_function_f_expr(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_subp_body_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subp_body_f_decls(
            Entity node
        );
            

        /** Isomethod of ada_subp_body_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subp_body_f_stmts(
            Entity node
        );
            

        /** Isomethod of ada_subp_body_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subp_body_f_end_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_subp_renaming_decl_f_renames langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subp_renaming_decl_f_renames(
            Entity node
        );

        
    

            

        /** Isomethod of ada_body_stub_p_syntactic_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Symbol[] ada_body_stub_p_syntactic_fully_qualified_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_package_body_stub_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_package_body_stub_f_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_protected_body_stub_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_protected_body_stub_f_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_subp_body_stub_f_overriding langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subp_body_stub_f_overriding(
            Entity node
        );
            

        /** Isomethod of ada_subp_body_stub_f_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subp_body_stub_f_subp_spec(
            Entity node
        );

        
    

            

        /** Isomethod of ada_task_body_stub_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_body_stub_f_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_entry_body_f_entry_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_body_f_entry_name(
            Entity node
        );
            

        /** Isomethod of ada_entry_body_f_index_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_body_f_index_spec(
            Entity node
        );
            

        /** Isomethod of ada_entry_body_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_body_f_params(
            Entity node
        );
            

        /** Isomethod of ada_entry_body_f_barrier langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_body_f_barrier(
            Entity node
        );
            

        /** Isomethod of ada_entry_body_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_body_f_decls(
            Entity node
        );
            

        /** Isomethod of ada_entry_body_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_body_f_stmts(
            Entity node
        );
            

        /** Isomethod of ada_entry_body_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_body_f_end_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_package_body_f_package_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_package_body_f_package_name(
            Entity node
        );
            

        /** Isomethod of ada_package_body_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_package_body_f_decls(
            Entity node
        );
            

        /** Isomethod of ada_package_body_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_package_body_f_stmts(
            Entity node
        );
            

        /** Isomethod of ada_package_body_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_package_body_f_end_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_protected_body_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_protected_body_f_name(
            Entity node
        );
            

        /** Isomethod of ada_protected_body_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_protected_body_f_decls(
            Entity node
        );
            

        /** Isomethod of ada_protected_body_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_protected_body_f_end_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_task_body_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_body_f_name(
            Entity node
        );
            

        /** Isomethod of ada_task_body_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_body_f_decls(
            Entity node
        );
            

        /** Isomethod of ada_task_body_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_body_f_stmts(
            Entity node
        );
            

        /** Isomethod of ada_task_body_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_body_f_end_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_entry_index_spec_f_id langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_index_spec_f_id(
            Entity node
        );
            

        /** Isomethod of ada_entry_index_spec_f_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_entry_index_spec_f_subtype(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_exception_decl_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_exception_decl_f_ids(
            Entity node
        );
            

        /** Isomethod of ada_exception_decl_f_renames langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_exception_decl_f_renames(
            Entity node
        );

        
    

            

        /** Isomethod of ada_exception_handler_f_exception_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_exception_handler_f_exception_name(
            Entity node
        );
            

        /** Isomethod of ada_exception_handler_f_handled_exceptions langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_exception_handler_f_handled_exceptions(
            Entity node
        );
            

        /** Isomethod of ada_exception_handler_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_exception_handler_f_stmts(
            Entity node
        );

        
    

            

        /** Isomethod of ada_for_loop_var_decl_f_id langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_for_loop_var_decl_f_id(
            Entity node
        );
            

        /** Isomethod of ada_for_loop_var_decl_f_id_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_for_loop_var_decl_f_id_type(
            Entity node
        );

        
    

            

        /** Isomethod of ada_generic_decl_f_formal_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_decl_f_formal_part(
            Entity node
        );

        
    

            

        /** Isomethod of ada_generic_package_decl_f_package_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_package_decl_f_package_decl(
            Entity node
        );
            

        /** Isomethod of ada_generic_package_decl_p_body_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_package_decl_p_body_part(
            Entity node
        );

        
    

            

        /** Isomethod of ada_generic_subp_decl_f_subp_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_decl_f_subp_decl(
            Entity node
        );
            

        /** Isomethod of ada_generic_subp_decl_p_body_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_decl_p_body_part(
            boolean
            imprecise_fallback,
            Entity node
        );

        
    

            

        /** Isomethod of ada_generic_instantiation_p_designated_generic_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_instantiation_p_designated_generic_decl(
            Entity node
        );
            

        /** Isomethod of ada_generic_instantiation_p_inst_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native ParamActual[] ada_generic_instantiation_p_inst_params(
            Entity node
        );

        
    

            

        /** Isomethod of ada_generic_package_instantiation_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_package_instantiation_f_name(
            Entity node
        );
            

        /** Isomethod of ada_generic_package_instantiation_f_generic_pkg_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_package_instantiation_f_generic_pkg_name(
            Entity node
        );
            

        /** Isomethod of ada_generic_package_instantiation_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_package_instantiation_f_params(
            Entity node
        );

        
    

            

        /** Isomethod of ada_generic_subp_instantiation_f_overriding langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_instantiation_f_overriding(
            Entity node
        );
            

        /** Isomethod of ada_generic_subp_instantiation_f_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_instantiation_f_kind(
            Entity node
        );
            

        /** Isomethod of ada_generic_subp_instantiation_f_subp_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_instantiation_f_subp_name(
            Entity node
        );
            

        /** Isomethod of ada_generic_subp_instantiation_f_generic_subp_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_instantiation_f_generic_subp_name(
            Entity node
        );
            

        /** Isomethod of ada_generic_subp_instantiation_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_instantiation_f_params(
            Entity node
        );
            

        /** Isomethod of ada_generic_subp_instantiation_p_designated_subp langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_instantiation_p_designated_subp(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_generic_package_renaming_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_package_renaming_decl_f_name(
            Entity node
        );
            

        /** Isomethod of ada_generic_package_renaming_decl_f_renames langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_package_renaming_decl_f_renames(
            Entity node
        );

        
    

            

        /** Isomethod of ada_generic_subp_renaming_decl_f_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_renaming_decl_f_kind(
            Entity node
        );
            

        /** Isomethod of ada_generic_subp_renaming_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_renaming_decl_f_name(
            Entity node
        );
            

        /** Isomethod of ada_generic_subp_renaming_decl_f_renames langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_generic_subp_renaming_decl_f_renames(
            Entity node
        );

        
    

            

        /** Isomethod of ada_label_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_label_decl_f_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_named_stmt_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_named_stmt_decl_f_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_number_decl_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_number_decl_f_ids(
            Entity node
        );
            

        /** Isomethod of ada_number_decl_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_number_decl_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_object_decl_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_object_decl_f_ids(
            Entity node
        );
            

        /** Isomethod of ada_object_decl_f_has_aliased langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_object_decl_f_has_aliased(
            Entity node
        );
            

        /** Isomethod of ada_object_decl_f_has_constant langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_object_decl_f_has_constant(
            Entity node
        );
            

        /** Isomethod of ada_object_decl_f_mode langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_object_decl_f_mode(
            Entity node
        );
            

        /** Isomethod of ada_object_decl_f_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_object_decl_f_type_expr(
            Entity node
        );
            

        /** Isomethod of ada_object_decl_f_default_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_object_decl_f_default_expr(
            Entity node
        );
            

        /** Isomethod of ada_object_decl_f_renaming_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_object_decl_f_renaming_clause(
            Entity node
        );
            

        /** Isomethod of ada_object_decl_p_private_part_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_object_decl_p_private_part_decl(
            Entity node
        );
            

        /** Isomethod of ada_object_decl_p_public_part_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_object_decl_p_public_part_decl(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_package_renaming_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_package_renaming_decl_f_name(
            Entity node
        );
            

        /** Isomethod of ada_package_renaming_decl_f_renames langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_package_renaming_decl_f_renames(
            Entity node
        );
            

        /** Isomethod of ada_package_renaming_decl_p_renamed_package langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_package_renaming_decl_p_renamed_package(
            Entity node
        );
            

        /** Isomethod of ada_package_renaming_decl_p_final_renamed_package langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_package_renaming_decl_p_final_renamed_package(
            Entity node
        );

        
    

            

        /** Isomethod of ada_single_protected_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_single_protected_decl_f_name(
            Entity node
        );
            

        /** Isomethod of ada_single_protected_decl_f_interfaces langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_single_protected_decl_f_interfaces(
            Entity node
        );
            

        /** Isomethod of ada_single_protected_decl_f_definition langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_single_protected_decl_f_definition(
            Entity node
        );

        
    

            

        /** Isomethod of ada_single_task_decl_f_task_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_single_task_decl_f_task_type(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_case_stmt_alternative_f_choices langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_case_stmt_alternative_f_choices(
            Entity node
        );
            

        /** Isomethod of ada_case_stmt_alternative_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_case_stmt_alternative_f_stmts(
            Entity node
        );

        
    

            

        /** Isomethod of ada_compilation_unit_f_prelude langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_compilation_unit_f_prelude(
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_f_body langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_compilation_unit_f_body(
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_f_pragmas langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_compilation_unit_f_pragmas(
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_syntactic_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Symbol[] ada_compilation_unit_p_syntactic_fully_qualified_name(
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_unit_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native AnalysisUnitKind ada_compilation_unit_p_unit_kind(
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_withed_units langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native CompilationUnit[] ada_compilation_unit_p_withed_units(
            boolean
            include_privates,
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_imported_units langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native CompilationUnit[] ada_compilation_unit_p_imported_units(
            boolean
            include_privates,
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_unit_dependencies langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native CompilationUnit[] ada_compilation_unit_p_unit_dependencies(
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_compilation_unit_p_decl(
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_is_preelaborable langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_compilation_unit_p_is_preelaborable(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_other_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_compilation_unit_p_other_part(
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_has_restriction langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_compilation_unit_p_has_restriction(
            Symbol
            name,
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_all_config_pragmas langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native PragmaNode[] ada_compilation_unit_p_all_config_pragmas(
            Entity node
        );
            

        /** Isomethod of ada_compilation_unit_p_config_pragmas langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native PragmaNode[] ada_compilation_unit_p_config_pragmas(
            Symbol
            name,
            Entity node
        );

        
    

            

        /** Isomethod of ada_component_clause_f_id langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_clause_f_id(
            Entity node
        );
            

        /** Isomethod of ada_component_clause_f_position langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_clause_f_position(
            Entity node
        );
            

        /** Isomethod of ada_component_clause_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_clause_f_range(
            Entity node
        );

        
    

            

        /** Isomethod of ada_component_def_f_has_aliased langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_def_f_has_aliased(
            Entity node
        );
            

        /** Isomethod of ada_component_def_f_has_constant langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_def_f_has_constant(
            Entity node
        );
            

        /** Isomethod of ada_component_def_f_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_component_def_f_type_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_constant_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_constant_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_composite_constraint_f_constraints langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_composite_constraint_f_constraints(
            Entity node
        );
            

        /** Isomethod of ada_composite_constraint_p_is_index_constraint langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_composite_constraint_p_is_index_constraint(
            Entity node
        );
            

        /** Isomethod of ada_composite_constraint_p_is_discriminant_constraint langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_composite_constraint_p_is_discriminant_constraint(
            Entity node
        );
            

        /** Isomethod of ada_composite_constraint_p_discriminant_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native ParamActual[] ada_composite_constraint_p_discriminant_params(
            Entity node
        );

        
    

            

        /** Isomethod of ada_delta_constraint_f_delta langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_delta_constraint_f_delta(
            Entity node
        );
            

        /** Isomethod of ada_delta_constraint_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_delta_constraint_f_range(
            Entity node
        );

        
    

            

        /** Isomethod of ada_digits_constraint_f_digits langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_digits_constraint_f_digits(
            Entity node
        );
            

        /** Isomethod of ada_digits_constraint_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_digits_constraint_f_range(
            Entity node
        );

        
    

            

        /** Isomethod of ada_range_constraint_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_range_constraint_f_range(
            Entity node
        );

        
    

            

        /** Isomethod of ada_declarative_part_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_declarative_part_f_decls(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_elsif_expr_part_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_elsif_expr_part_f_cond_expr(
            Entity node
        );
            

        /** Isomethod of ada_elsif_expr_part_f_then_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_elsif_expr_part_f_then_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_elsif_stmt_part_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_elsif_stmt_part_f_cond_expr(
            Entity node
        );
            

        /** Isomethod of ada_elsif_stmt_part_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_elsif_stmt_part_f_stmts(
            Entity node
        );

        
    

            

        /** Isomethod of ada_expr_p_expression_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_expr_p_expression_type(
            Entity node
        );
            

        /** Isomethod of ada_expr_p_expected_expression_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_expr_p_expected_expression_type(
            Entity node
        );
            

        /** Isomethod of ada_expr_p_is_dynamically_tagged langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_expr_p_is_dynamically_tagged(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_expr_p_is_static_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_expr_p_is_static_expr(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_expr_p_eval_as_int langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BigInteger ada_expr_p_eval_as_int(
            Entity node
        );
            

        /** Isomethod of ada_expr_p_eval_as_int_in_env langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BigInteger ada_expr_p_eval_as_int_in_env(
            Substitution[]
            env,
            Entity node
        );
            

        /** Isomethod of ada_expr_p_eval_as_string langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_expr_p_eval_as_string(
            Entity node
        );
            

        /** Isomethod of ada_expr_p_eval_as_string_in_env langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_expr_p_eval_as_string_in_env(
            Substitution[]
            env,
            Entity node
        );
            

        /** Isomethod of ada_expr_p_matching_nodes langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native AdaNode[] ada_expr_p_matching_nodes(
            Entity node
        );
            

        /** Isomethod of ada_expr_p_is_dispatching_call langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_expr_p_is_dispatching_call(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_expr_p_first_corresponding_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_expr_p_first_corresponding_decl(
            Entity node
        );

        
    

            

        /** Isomethod of ada_abstract_state_decl_expr_f_state_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_abstract_state_decl_expr_f_state_decl(
            Entity node
        );

        
    

            

        /** Isomethod of ada_allocator_f_subpool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_allocator_f_subpool(
            Entity node
        );
            

        /** Isomethod of ada_allocator_f_type_or_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_allocator_f_type_or_expr(
            Entity node
        );
            

        /** Isomethod of ada_allocator_p_get_allocated_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_allocator_p_get_allocated_type(
            Entity node
        );

        
    

            

        /** Isomethod of ada_base_aggregate_f_ancestor_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_aggregate_f_ancestor_expr(
            Entity node
        );
            

        /** Isomethod of ada_base_aggregate_f_assocs langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_aggregate_f_assocs(
            Entity node
        );
            

        /** Isomethod of ada_base_aggregate_p_aggregate_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native ParamActual[] ada_base_aggregate_p_aggregate_params(
            Entity node
        );
            

        /** Isomethod of ada_base_aggregate_p_is_subaggregate langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_base_aggregate_p_is_subaggregate(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_bin_op_f_left langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_bin_op_f_left(
            Entity node
        );
            

        /** Isomethod of ada_bin_op_f_op langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_bin_op_f_op(
            Entity node
        );
            

        /** Isomethod of ada_bin_op_f_right langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_bin_op_f_right(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_case_expr_alternative_f_choices langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_case_expr_alternative_f_choices(
            Entity node
        );
            

        /** Isomethod of ada_case_expr_alternative_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_case_expr_alternative_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_concat_op_f_first_operand langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_concat_op_f_first_operand(
            Entity node
        );
            

        /** Isomethod of ada_concat_op_f_other_operands langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_concat_op_f_other_operands(
            Entity node
        );
            

        /** Isomethod of ada_concat_op_p_operands langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Expr[] ada_concat_op_p_operands(
            Entity node
        );

        
    

            

        /** Isomethod of ada_concat_operand_f_operator langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_concat_operand_f_operator(
            Entity node
        );
            

        /** Isomethod of ada_concat_operand_f_operand langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_concat_operand_f_operand(
            Entity node
        );

        
    

            

        /** Isomethod of ada_cond_expr_p_dependent_exprs langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Expr[] ada_cond_expr_p_dependent_exprs(
            Entity node
        );

        
    

            

        /** Isomethod of ada_case_expr_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_case_expr_f_expr(
            Entity node
        );
            

        /** Isomethod of ada_case_expr_f_cases langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_case_expr_f_cases(
            Entity node
        );

        
    

            

        /** Isomethod of ada_if_expr_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_if_expr_f_cond_expr(
            Entity node
        );
            

        /** Isomethod of ada_if_expr_f_then_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_if_expr_f_then_expr(
            Entity node
        );
            

        /** Isomethod of ada_if_expr_f_alternatives langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_if_expr_f_alternatives(
            Entity node
        );
            

        /** Isomethod of ada_if_expr_f_else_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_if_expr_f_else_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_contract_cases_f_contract_cases langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_contract_cases_f_contract_cases(
            Entity node
        );

        
    

            

        /** Isomethod of ada_decl_expr_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_decl_expr_f_decls(
            Entity node
        );
            

        /** Isomethod of ada_decl_expr_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_decl_expr_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_format_string_literal_f_opening_chunk langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_format_string_literal_f_opening_chunk(
            Entity node
        );
            

        /** Isomethod of ada_format_string_literal_f_mid_exprs langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_format_string_literal_f_mid_exprs(
            Entity node
        );
            

        /** Isomethod of ada_format_string_literal_f_trailing_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_format_string_literal_f_trailing_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_membership_expr_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_membership_expr_f_expr(
            Entity node
        );
            

        /** Isomethod of ada_membership_expr_f_op langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_membership_expr_f_op(
            Entity node
        );
            

        /** Isomethod of ada_membership_expr_f_membership_exprs langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_membership_expr_f_membership_exprs(
            Entity node
        );

        
    

            

        /** Isomethod of ada_name_p_enclosing_defining_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_name_p_enclosing_defining_name(
            Entity node
        );
            

        /** Isomethod of ada_name_p_is_defining langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_is_defining(
            Entity node
        );
            

        /** Isomethod of ada_name_p_name_is langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_name_is(
            Symbol
            sym,
            Entity node
        );
            

        /** Isomethod of ada_name_p_is_direct_call langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_is_direct_call(
            Entity node
        );
            

        /** Isomethod of ada_name_p_is_access_call langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_is_access_call(
            Entity node
        );
            

        /** Isomethod of ada_name_p_is_call langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_is_call(
            Entity node
        );
            

        /** Isomethod of ada_name_p_is_dot_call langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_is_dot_call(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_name_p_failsafe_referenced_def_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native RefdDef ada_name_p_failsafe_referenced_def_name(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_name_p_referenced_defining_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_name_p_referenced_defining_name(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_name_p_all_env_elements langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native AdaNode[] ada_name_p_all_env_elements(
            boolean
            seq,
            Entity
            seq_from,
            Entity node
        );
            

        /** Isomethod of ada_name_p_called_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_name_p_called_subp_spec(
            Entity node
        );
            

        /** Isomethod of ada_name_p_referenced_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_name_p_referenced_decl(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_name_p_failsafe_referenced_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native RefdDecl ada_name_p_failsafe_referenced_decl(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_name_p_name_designated_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_name_p_name_designated_type(
            Entity node
        );
            

        /** Isomethod of ada_name_p_is_static_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_is_static_subtype(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_name_p_name_matches langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_name_matches(
            Entity
            n,
            Entity node
        );
            

        /** Isomethod of ada_name_p_is_operator_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_is_operator_name(
            Entity node
        );
            

        /** Isomethod of ada_name_p_is_write_reference langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_is_write_reference(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_name_p_is_static_call langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_is_static_call(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_name_p_call_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native ParamActual[] ada_name_p_call_params(
            Entity node
        );
            

        /** Isomethod of ada_name_p_relative_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_name_p_relative_name(
            Entity node
        );
            

        /** Isomethod of ada_name_p_as_symbol_array langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Symbol[] ada_name_p_as_symbol_array(
            Entity node
        );
            

        /** Isomethod of ada_name_p_canonical_text langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Symbol ada_name_p_canonical_text(
            Entity node
        );
            

        /** Isomethod of ada_name_p_is_constant langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_name_p_is_constant(
            Entity node
        );

        
    

            

        /** Isomethod of ada_array_subcomponent_choice_name_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_array_subcomponent_choice_name_f_name(
            Entity node
        );
            

        /** Isomethod of ada_array_subcomponent_choice_name_f_suffix langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_array_subcomponent_choice_name_f_suffix(
            Entity node
        );

        
    

            

        /** Isomethod of ada_attribute_ref_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_attribute_ref_f_prefix(
            Entity node
        );
            

        /** Isomethod of ada_attribute_ref_f_attribute langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_attribute_ref_f_attribute(
            Entity node
        );
            

        /** Isomethod of ada_attribute_ref_f_args langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_attribute_ref_f_args(
            Entity node
        );

        
    

            

        /** Isomethod of ada_call_expr_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_call_expr_f_name(
            Entity node
        );
            

        /** Isomethod of ada_call_expr_f_suffix langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_call_expr_f_suffix(
            Entity node
        );
            

        /** Isomethod of ada_call_expr_p_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native CallExprKind ada_call_expr_p_kind(
            Entity node
        );
            

        /** Isomethod of ada_call_expr_p_is_array_slice langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_call_expr_p_is_array_slice(
            Entity node
        );

        
    

            

        /** Isomethod of ada_defining_name_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_defining_name_f_name(
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_canonical_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_defining_name_p_canonical_fully_qualified_name(
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_unique_identifying_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_defining_name_p_unique_identifying_name(
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_fully_qualified_name_array langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Symbol[] ada_defining_name_p_fully_qualified_name_array(
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_defining_name_p_fully_qualified_name(
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_basic_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_defining_name_p_basic_decl(
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_find_refs langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native RefResult[] ada_defining_name_p_find_refs(
            Entity
            root,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_find_all_references langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native RefResult[] ada_defining_name_p_find_all_references(
            AnalysisUnit[]
            units,
            boolean
            follow_renamings,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_find_all_calls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native RefResult[] ada_defining_name_p_find_all_calls(
            AnalysisUnit[]
            units,
            boolean
            follow_renamings,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_next_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_defining_name_p_next_part(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_previous_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_defining_name_p_previous_part(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_canonical_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_defining_name_p_canonical_part(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_most_visible_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_defining_name_p_most_visible_part(
            Entity
            origin,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_all_parts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native DefiningName[] ada_defining_name_p_all_parts(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_get_aspect langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Aspect ada_defining_name_p_get_aspect(
            Symbol
            name,
            boolean
            previous_parts_only,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_has_aspect langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_defining_name_p_has_aspect(
            Symbol
            name,
            boolean
            previous_parts_only,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_get_pragma langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_defining_name_p_get_pragma(
            Symbol
            name,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_get_representation_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_defining_name_p_get_representation_clause(
            Symbol
            name,
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_get_at_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_defining_name_p_get_at_clause(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_get_annotations langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Aspect[] ada_defining_name_p_get_annotations(
            boolean
            imprecise_fallback,
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_is_imported langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_defining_name_p_is_imported(
            Entity node
        );
            

        /** Isomethod of ada_defining_name_p_is_ghost_code langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_defining_name_p_is_ghost_code(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_discrete_subtype_name_f_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_discrete_subtype_name_f_subtype(
            Entity node
        );

        
    

            

        /** Isomethod of ada_dotted_name_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_dotted_name_f_prefix(
            Entity node
        );
            

        /** Isomethod of ada_dotted_name_f_suffix langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_dotted_name_f_suffix(
            Entity node
        );

        
    

            

        /** Isomethod of ada_end_name_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_end_name_f_name(
            Entity node
        );
            

        /** Isomethod of ada_end_name_p_basic_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_end_name_p_basic_decl(
            Entity node
        );

        
    

            

        /** Isomethod of ada_explicit_deref_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_explicit_deref_f_prefix(
            Entity node
        );

        
    

            

        /** Isomethod of ada_qual_expr_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_qual_expr_f_prefix(
            Entity node
        );
            

        /** Isomethod of ada_qual_expr_f_suffix langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_qual_expr_f_suffix(
            Entity node
        );

        
    

            

        /** Isomethod of ada_reduce_attribute_ref_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_reduce_attribute_ref_f_prefix(
            Entity node
        );
            

        /** Isomethod of ada_reduce_attribute_ref_f_attribute langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_reduce_attribute_ref_f_attribute(
            Entity node
        );
            

        /** Isomethod of ada_reduce_attribute_ref_f_args langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_reduce_attribute_ref_f_args(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_char_literal_p_denoted_value langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Char ada_char_literal_p_denoted_value(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_string_literal_p_denoted_value langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native String ada_string_literal_p_denoted_value(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_int_literal_p_denoted_value langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native BigInteger ada_int_literal_p_denoted_value(
            Entity node
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_update_attribute_ref_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_update_attribute_ref_f_prefix(
            Entity node
        );
            

        /** Isomethod of ada_update_attribute_ref_f_attribute langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_update_attribute_ref_f_attribute(
            Entity node
        );
            

        /** Isomethod of ada_update_attribute_ref_f_values langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_update_attribute_ref_f_values(
            Entity node
        );

        
    

            

        /** Isomethod of ada_paren_expr_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_paren_expr_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_quantified_expr_f_quantifier langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_quantified_expr_f_quantifier(
            Entity node
        );
            

        /** Isomethod of ada_quantified_expr_f_loop_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_quantified_expr_f_loop_spec(
            Entity node
        );
            

        /** Isomethod of ada_quantified_expr_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_quantified_expr_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_raise_expr_f_exception_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_raise_expr_f_exception_name(
            Entity node
        );
            

        /** Isomethod of ada_raise_expr_f_error_message langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_raise_expr_f_error_message(
            Entity node
        );

        
    

            

        /** Isomethod of ada_un_op_f_op langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_un_op_f_op(
            Entity node
        );
            

        /** Isomethod of ada_un_op_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_un_op_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_for_loop_iter_filter_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_for_loop_iter_filter_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_format_string_chunk_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_format_string_chunk_f_expr(
            Entity node
        );
            

        /** Isomethod of ada_format_string_chunk_f_string_tok langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_format_string_chunk_f_string_tok(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_handled_stmts_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_handled_stmts_f_stmts(
            Entity node
        );
            

        /** Isomethod of ada_handled_stmts_f_exceptions langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_handled_stmts_f_exceptions(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_library_item_f_has_private langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_library_item_f_has_private(
            Entity node
        );
            

        /** Isomethod of ada_library_item_f_item langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_library_item_f_item(
            Entity node
        );

        
    

            

        /** Isomethod of ada_limited_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_limited_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_for_loop_spec_f_var_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_for_loop_spec_f_var_decl(
            Entity node
        );
            

        /** Isomethod of ada_for_loop_spec_f_loop_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_for_loop_spec_f_loop_type(
            Entity node
        );
            

        /** Isomethod of ada_for_loop_spec_f_has_reverse langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_for_loop_spec_f_has_reverse(
            Entity node
        );
            

        /** Isomethod of ada_for_loop_spec_f_iter_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_for_loop_spec_f_iter_expr(
            Entity node
        );
            

        /** Isomethod of ada_for_loop_spec_f_iter_filter langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_for_loop_spec_f_iter_filter(
            Entity node
        );

        
    

            

        /** Isomethod of ada_while_loop_spec_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_while_loop_spec_f_expr(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_multi_abstract_state_decl_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_multi_abstract_state_decl_f_decls(
            Entity node
        );

        
    

            

        /** Isomethod of ada_not_null_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_not_null_p_as_bool(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_params_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_params_f_params(
            Entity node
        );

        
    

            

        /** Isomethod of ada_paren_abstract_state_decl_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_paren_abstract_state_decl_f_decl(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_pp_elsif_directive_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_pp_elsif_directive_f_expr(
            Entity node
        );
            

        /** Isomethod of ada_pp_elsif_directive_f_then_kw langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_pp_elsif_directive_f_then_kw(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_pp_if_directive_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_pp_if_directive_f_expr(
            Entity node
        );
            

        /** Isomethod of ada_pp_if_directive_f_then_kw langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_pp_if_directive_f_then_kw(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_pragma_node_f_id langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_pragma_node_f_id(
            Entity node
        );
            

        /** Isomethod of ada_pragma_node_f_args langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_pragma_node_f_args(
            Entity node
        );
            

        /** Isomethod of ada_pragma_node_p_is_ghost_code langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_pragma_node_p_is_ghost_code(
            Entity node
        );
            

        /** Isomethod of ada_pragma_node_p_associated_entities langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native DefiningName[] ada_pragma_node_p_associated_entities(
            Entity node
        );

        
    

            

        /** Isomethod of ada_private_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_private_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_protected_def_f_public_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_protected_def_f_public_part(
            Entity node
        );
            

        /** Isomethod of ada_protected_def_f_private_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_protected_def_f_private_part(
            Entity node
        );
            

        /** Isomethod of ada_protected_def_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_protected_def_f_end_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_protected_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_protected_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_range_spec_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_range_spec_f_range(
            Entity node
        );

        
    

            

        /** Isomethod of ada_renaming_clause_f_renamed_object langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_renaming_clause_f_renamed_object(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_reverse_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_reverse_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_select_when_part_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_select_when_part_f_cond_expr(
            Entity node
        );
            

        /** Isomethod of ada_select_when_part_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_select_when_part_f_stmts(
            Entity node
        );

        
    

            

        /** Isomethod of ada_stmt_p_is_ghost_code langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_stmt_p_is_ghost_code(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_accept_stmt_f_body_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_accept_stmt_f_body_decl(
            Entity node
        );
            

        /** Isomethod of ada_accept_stmt_f_entry_index_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_accept_stmt_f_entry_index_expr(
            Entity node
        );
            

        /** Isomethod of ada_accept_stmt_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_accept_stmt_f_params(
            Entity node
        );
            

        /** Isomethod of ada_accept_stmt_p_corresponding_entry langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_accept_stmt_p_corresponding_entry(
            Entity
            origin,
            Entity node
        );

        
    

            

        /** Isomethod of ada_accept_stmt_with_stmts_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_accept_stmt_with_stmts_f_stmts(
            Entity node
        );
            

        /** Isomethod of ada_accept_stmt_with_stmts_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_accept_stmt_with_stmts_f_end_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_base_loop_stmt_f_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_loop_stmt_f_spec(
            Entity node
        );
            

        /** Isomethod of ada_base_loop_stmt_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_loop_stmt_f_stmts(
            Entity node
        );
            

        /** Isomethod of ada_base_loop_stmt_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_base_loop_stmt_f_end_name(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_begin_block_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_begin_block_f_stmts(
            Entity node
        );
            

        /** Isomethod of ada_begin_block_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_begin_block_f_end_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_decl_block_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_decl_block_f_decls(
            Entity node
        );
            

        /** Isomethod of ada_decl_block_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_decl_block_f_stmts(
            Entity node
        );
            

        /** Isomethod of ada_decl_block_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_decl_block_f_end_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_case_stmt_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_case_stmt_f_expr(
            Entity node
        );
            

        /** Isomethod of ada_case_stmt_f_pragmas langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_case_stmt_f_pragmas(
            Entity node
        );
            

        /** Isomethod of ada_case_stmt_f_alternatives langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_case_stmt_f_alternatives(
            Entity node
        );

        
    

            

        /** Isomethod of ada_extended_return_stmt_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_extended_return_stmt_f_decl(
            Entity node
        );
            

        /** Isomethod of ada_extended_return_stmt_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_extended_return_stmt_f_stmts(
            Entity node
        );

        
    

            

        /** Isomethod of ada_if_stmt_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_if_stmt_f_cond_expr(
            Entity node
        );
            

        /** Isomethod of ada_if_stmt_f_then_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_if_stmt_f_then_stmts(
            Entity node
        );
            

        /** Isomethod of ada_if_stmt_f_alternatives langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_if_stmt_f_alternatives(
            Entity node
        );
            

        /** Isomethod of ada_if_stmt_f_else_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_if_stmt_f_else_stmts(
            Entity node
        );

        
    

            

        /** Isomethod of ada_named_stmt_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_named_stmt_f_decl(
            Entity node
        );
            

        /** Isomethod of ada_named_stmt_f_stmt langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_named_stmt_f_stmt(
            Entity node
        );

        
    

            

        /** Isomethod of ada_select_stmt_f_guards langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_select_stmt_f_guards(
            Entity node
        );
            

        /** Isomethod of ada_select_stmt_f_else_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_select_stmt_f_else_stmts(
            Entity node
        );
            

        /** Isomethod of ada_select_stmt_f_abort_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_select_stmt_f_abort_stmts(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_abort_stmt_f_names langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_abort_stmt_f_names(
            Entity node
        );

        
    

            

        /** Isomethod of ada_assign_stmt_f_dest langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_assign_stmt_f_dest(
            Entity node
        );
            

        /** Isomethod of ada_assign_stmt_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_assign_stmt_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_call_stmt_f_call langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_call_stmt_f_call(
            Entity node
        );

        
    

            

        /** Isomethod of ada_delay_stmt_f_has_until langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_delay_stmt_f_has_until(
            Entity node
        );
            

        /** Isomethod of ada_delay_stmt_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_delay_stmt_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_exit_stmt_f_loop_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_exit_stmt_f_loop_name(
            Entity node
        );
            

        /** Isomethod of ada_exit_stmt_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_exit_stmt_f_cond_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_goto_stmt_f_label_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_goto_stmt_f_label_name(
            Entity node
        );

        
    

            

        /** Isomethod of ada_label_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_label_f_decl(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_raise_stmt_f_exception_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_raise_stmt_f_exception_name(
            Entity node
        );
            

        /** Isomethod of ada_raise_stmt_f_error_message langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_raise_stmt_f_error_message(
            Entity node
        );

        
    

            

        /** Isomethod of ada_requeue_stmt_f_call_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_requeue_stmt_f_call_name(
            Entity node
        );
            

        /** Isomethod of ada_requeue_stmt_f_has_abort langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_requeue_stmt_f_has_abort(
            Entity node
        );

        
    

            

        /** Isomethod of ada_return_stmt_f_return_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_return_stmt_f_return_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_simple_decl_stmt_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_simple_decl_stmt_f_decl(
            Entity node
        );

        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_subunit_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subunit_f_name(
            Entity node
        );
            

        /** Isomethod of ada_subunit_f_body langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subunit_f_body(
            Entity node
        );
            

        /** Isomethod of ada_subunit_p_body_root langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subunit_p_body_root(
            Entity node
        );

        
    

            

        /** Isomethod of ada_synchronized_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_synchronized_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_tagged_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_tagged_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_task_def_f_interfaces langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_def_f_interfaces(
            Entity node
        );
            

        /** Isomethod of ada_task_def_f_public_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_def_f_public_part(
            Entity node
        );
            

        /** Isomethod of ada_task_def_f_private_part langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_def_f_private_part(
            Entity node
        );
            

        /** Isomethod of ada_task_def_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_task_def_f_end_name(
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_access_def_f_has_not_null langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_access_def_f_has_not_null(
            Entity node
        );

        
    

            

        /** Isomethod of ada_access_to_subp_def_f_has_protected langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_access_to_subp_def_f_has_protected(
            Entity node
        );
            

        /** Isomethod of ada_access_to_subp_def_f_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_access_to_subp_def_f_subp_spec(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_anonymous_type_access_def_f_type_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_anonymous_type_access_def_f_type_decl(
            Entity node
        );

        
    

            

        /** Isomethod of ada_type_access_def_f_has_all langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_type_access_def_f_has_all(
            Entity node
        );
            

        /** Isomethod of ada_type_access_def_f_has_constant langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_type_access_def_f_has_constant(
            Entity node
        );
            

        /** Isomethod of ada_type_access_def_f_subtype_indication langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_type_access_def_f_subtype_indication(
            Entity node
        );

        
    

            

        /** Isomethod of ada_array_type_def_f_indices langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_array_type_def_f_indices(
            Entity node
        );
            

        /** Isomethod of ada_array_type_def_f_component_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_array_type_def_f_component_type(
            Entity node
        );

        
    

            

        /** Isomethod of ada_derived_type_def_f_has_abstract langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_derived_type_def_f_has_abstract(
            Entity node
        );
            

        /** Isomethod of ada_derived_type_def_f_has_limited langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_derived_type_def_f_has_limited(
            Entity node
        );
            

        /** Isomethod of ada_derived_type_def_f_has_synchronized langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_derived_type_def_f_has_synchronized(
            Entity node
        );
            

        /** Isomethod of ada_derived_type_def_f_subtype_indication langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_derived_type_def_f_subtype_indication(
            Entity node
        );
            

        /** Isomethod of ada_derived_type_def_f_interfaces langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_derived_type_def_f_interfaces(
            Entity node
        );
            

        /** Isomethod of ada_derived_type_def_f_record_extension langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_derived_type_def_f_record_extension(
            Entity node
        );
            

        /** Isomethod of ada_derived_type_def_f_has_with_private langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_derived_type_def_f_has_with_private(
            Entity node
        );

        
    

            

        /** Isomethod of ada_enum_type_def_f_enum_literals langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_enum_type_def_f_enum_literals(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_interface_type_def_f_interface_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_interface_type_def_f_interface_kind(
            Entity node
        );
            

        /** Isomethod of ada_interface_type_def_f_interfaces langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_interface_type_def_f_interfaces(
            Entity node
        );

        
    

            

        /** Isomethod of ada_mod_int_type_def_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_mod_int_type_def_f_expr(
            Entity node
        );

        
    

            

        /** Isomethod of ada_private_type_def_f_has_abstract langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_private_type_def_f_has_abstract(
            Entity node
        );
            

        /** Isomethod of ada_private_type_def_f_has_tagged langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_private_type_def_f_has_tagged(
            Entity node
        );
            

        /** Isomethod of ada_private_type_def_f_has_limited langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_private_type_def_f_has_limited(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_decimal_fixed_point_def_f_delta langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_decimal_fixed_point_def_f_delta(
            Entity node
        );
            

        /** Isomethod of ada_decimal_fixed_point_def_f_digits langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_decimal_fixed_point_def_f_digits(
            Entity node
        );
            

        /** Isomethod of ada_decimal_fixed_point_def_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_decimal_fixed_point_def_f_range(
            Entity node
        );

        
    

            

        /** Isomethod of ada_floating_point_def_f_num_digits langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_floating_point_def_f_num_digits(
            Entity node
        );
            

        /** Isomethod of ada_floating_point_def_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_floating_point_def_f_range(
            Entity node
        );

        
    

            

        /** Isomethod of ada_ordinary_fixed_point_def_f_delta langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ordinary_fixed_point_def_f_delta(
            Entity node
        );
            

        /** Isomethod of ada_ordinary_fixed_point_def_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_ordinary_fixed_point_def_f_range(
            Entity node
        );

        
    

            

        /** Isomethod of ada_record_type_def_f_has_abstract langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_record_type_def_f_has_abstract(
            Entity node
        );
            

        /** Isomethod of ada_record_type_def_f_has_tagged langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_record_type_def_f_has_tagged(
            Entity node
        );
            

        /** Isomethod of ada_record_type_def_f_has_limited langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_record_type_def_f_has_limited(
            Entity node
        );
            

        /** Isomethod of ada_record_type_def_f_record_def langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_record_type_def_f_record_def(
            Entity node
        );

        
    

            

        /** Isomethod of ada_signed_int_type_def_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_signed_int_type_def_f_range(
            Entity node
        );

        
    

            

        /** Isomethod of ada_type_expr_p_type_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_type_expr_p_type_name(
            Entity node
        );
            

        /** Isomethod of ada_type_expr_p_designated_type_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_type_expr_p_designated_type_decl(
            Entity node
        );
            

        /** Isomethod of ada_type_expr_p_designated_type_decl_from langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_type_expr_p_designated_type_decl_from(
            Entity
            origin_node,
            Entity node
        );
            

        /** Isomethod of ada_type_expr_p_subtype_constraint langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_type_expr_p_subtype_constraint(
            Entity
            origin,
            Entity node
        );
            

        /** Isomethod of ada_type_expr_p_discriminant_constraints langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native ParamActual[] ada_type_expr_p_discriminant_constraints(
            Entity node
        );
            

        /** Isomethod of ada_type_expr_p_is_definite_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_type_expr_p_is_definite_subtype(
            Entity node
        );

        
    

            

        /** Isomethod of ada_anonymous_type_f_type_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_anonymous_type_f_type_decl(
            Entity node
        );

        
    


        
    

            

        /** Isomethod of ada_subtype_indication_f_has_not_null langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subtype_indication_f_has_not_null(
            Entity node
        );
            

        /** Isomethod of ada_subtype_indication_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subtype_indication_f_name(
            Entity node
        );
            

        /** Isomethod of ada_subtype_indication_f_constraint langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_subtype_indication_f_constraint(
            Entity node
        );
            

        /** Isomethod of ada_subtype_indication_p_is_static_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_subtype_indication_p_is_static_subtype(
            boolean
            imprecise_fallback,
            Entity node
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_synthetic_type_expr_f_target_type langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_synthetic_type_expr_f_target_type(
            Entity node
        );

        
    

            

        /** Isomethod of ada_unconstrained_array_index_f_subtype_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_unconstrained_array_index_f_subtype_name(
            Entity node
        );
            

        /** Isomethod of ada_unconstrained_array_index_f_lower_bound langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_unconstrained_array_index_f_lower_bound(
            Entity node
        );

        
    

            

        /** Isomethod of ada_until_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_until_node_p_as_bool(
            Entity node
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_use_package_clause_f_packages langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_use_package_clause_f_packages(
            Entity node
        );

        
    

            

        /** Isomethod of ada_use_type_clause_f_has_all langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_use_type_clause_f_has_all(
            Entity node
        );
            

        /** Isomethod of ada_use_type_clause_f_types langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_use_type_clause_f_types(
            Entity node
        );

        
    

            

        /** Isomethod of ada_value_sequence_f_iter_assoc langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_value_sequence_f_iter_assoc(
            Entity node
        );

        
    

            

        /** Isomethod of ada_variant_f_choices langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_variant_f_choices(
            Entity node
        );
            

        /** Isomethod of ada_variant_f_components langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_variant_f_components(
            Entity node
        );

        
    

            

        /** Isomethod of ada_variant_part_f_discr_name langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_variant_part_f_discr_name(
            Entity node
        );
            

        /** Isomethod of ada_variant_part_f_variant langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_variant_part_f_variant(
            Entity node
        );

        
    

            

        /** Isomethod of ada_with_clause_f_has_limited langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_with_clause_f_has_limited(
            Entity node
        );
            

        /** Isomethod of ada_with_clause_f_has_private langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_with_clause_f_has_private(
            Entity node
        );
            

        /** Isomethod of ada_with_clause_f_packages langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native Entity ada_with_clause_f_packages(
            Entity node
        );

        
    

            

        /** Isomethod of ada_with_private_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        public static native boolean ada_with_private_p_as_bool(
            Entity node
        );

        
    


        
    



    }


    // ==========
    // Defining the Native-Image bindings library
    // ==========

    
    
    
    
    
    
    

    /** This class contains the directives for the shared lib loading */
    public static final class LibDirectives implements CContext.Directives {
        @Override
        public List<String> getHeaderFiles() {
            List<String> res = new ArrayList<>();
            res.add("<libadalang.h>");
            res.add("<stdlib.h>");
            return res;
        }

        @Override
        public List<String> getLibraries() {
            List<String> res = new ArrayList<>();
            res.add("adalang");
            return res;
        }
    }

    // ===== Language specific structures =====

    
      


    // ===== Native structures =====

    /** Project manager native is just a pointer. */
    public interface ProjectManagerNative extends Pointer {}

    /** Structure for a string array. */
    @CContext(LibDirectives.class)
    @CStruct("ada_string_array_ptr_struct")
    public interface StringArrayNative extends PointerBase {
        @CField("length") public int get_length();
        @CField("length") public void set_length(int length);

        @CField("c_ptr") public CCharPointerPointer get_c_ptr();
        @CField("c_ptr") public void set_c_ptr(CCharPointerPointer c_ptr);
    }

    /** Structure for a scenrio variable. */
    @CContext(LibDirectives.class)
    @CStruct("ada_gpr_project_scenario_variable")
    public interface ScenarioVariableNative extends PointerBase {
        @CField("name") public CCharPointer get_name();
        @CField("name") public void set_name(CCharPointer name);

        @CField("value") public CCharPointer get_value();
        @CField("value") public void set_value(CCharPointer value);
    }



    // ===== Constant structures =====

    /** The structure for the langkit exceptions */
    @CContext(LibDirectives.class)
    @CStruct("ada_exception")
    public interface LangkitExceptionNative extends PointerBase {
        @CField("kind") public int get_kind();
        @CField("kind") public void set_kind(
            int kind
        );

        @CField("information") public CCharPointer get_information();
        @CField("information") public void set_information(
            CCharPointer information
        );
    }

    /** The big integers are just pointers */
    public interface BigIntegerNative extends Pointer {}

    /** The structure for the symbols */
    @CContext(LibDirectives.class)
    @CStruct("ada_symbol_type")
    public interface SymbolNative extends PointerBase {
        @CField("thin_sym") public int get_thin_sym();
        @CField("thin_sym") public void set_thin_sym(
            int data
        );

        @CField("table") public VoidPointer get_table();
        @CField("table") public void set_table(
            VoidPointer bounds
        );
    }

    /** The string wrappers are just pointers */
    public interface StringNative extends Pointer {}

    /** The structure for the text */
    @CContext(LibDirectives.class)
    @CStruct("ada_text")
    public interface TextNative extends PointerBase {
        @CField("chars") public CIntPointer get_chars();
        @CField("chars") public void set_chars(
            CIntPointer chars
        );

        @CField("length") public long get_length();
        @CField("length") public void set_length(
            long length
        );

        @CField("is_allocated") public int get_is_allocated();
        @CField("is_allocated") public void set_is_allocated(
            int is_allocated
        );
    }

    /** The structure for the source locations */
    @CContext(LibDirectives.class)
    @CStruct("ada_source_location")
    public interface SourceLocationNative extends PointerBase {
        @CField("line") public int get_line();
        @CField("line") public void set_line(
            int line
        );

        @CField("column") public short get_column();
        @CField("column") public void set_column(
            short column
        );
    }

    /** The structure for the source location ranges */
    @CContext(LibDirectives.class)
    @CStruct("ada_source_location_range")
    public interface SourceLocationRangeNative extends PointerBase {
        @CField("start.line") public int get_start_line();
        @CField("start.line") public void set_start_line(
            int start_line
        );

        @CField("start.column") public short get_start_column();
        @CField("start.column") public void set_start_column(
            short start_column
        );

        @CField("end.line") public int get_end_line();
        @CField("end.line") public void set_end_line(
            int end_line
        );

        @CField("end.column") public short get_end_column();
        @CField("end.column") public void set_end_column(
            short end_column
        );
    }

    /** The structure for the diagnostic */
    @CContext(LibDirectives.class)
    @CStruct("ada_diagnostic")
    public interface DiagnosticNative extends PointerBase {
        @CField("sloc_range.start.line") public int get_start_line();
        @CField("sloc_range.start.line") public void set_start_line(
            int start_line
        );

        @CField("sloc_range.start.column") public short get_start_column();
        @CField("sloc_range.start.column") public void set_start_column(
            short start_column
        );

        @CField("sloc_range.end.line") public int get_end_line();
        @CField("sloc_range.end.line") public void set_end_line(
            int end_line
        );

        @CField("sloc_range.end.column") public short get_end_column();
        @CField("sloc_range.end.column") public void set_end_column(
            short end_column
        );

        @CField("message.chars") public CIntPointer get_message_chars();
        @CField("message.chars") public void set_message_chars(
            CIntPointer chars
        );

        @CField("message.length") public long get_message_length();
        @CField("message.length") public void set_message_length(
            long length
        );

        @CField("message.is_allocated") public int get_message_is_allocated();
        @CField("message.is_allocated") public void set_message_is_allocated(
            int is_allocated
        );
    }

    /** The file reader is just a pointer */
    public interface FileReaderNative extends Pointer {}

    /** The unit provider is just a pointer */
    public interface UnitProviderNative extends Pointer {}

    /** The event handler is just a pointer */
    public interface EventHandlerNative extends Pointer {}

    /** The event handler unit requested callback type */
    public interface UnitRequestedFunctionPointer extends CFunctionPointer {
        @InvokeCFunctionPointer
        void invoke(
            VoidPointer data,
            AnalysisContextNative context,
            TextNative name,
            AnalysisUnitNative from,
            boolean found,
            boolean is_not_found_error
        );
    }

    /** The event handler unit parsed callback type */
    public interface UnitParsedFunctionPointer extends CFunctionPointer {
        @InvokeCFunctionPointer
        void invoke(
            VoidPointer data,
            AnalysisContextNative context,
            AnalysisUnitNative unit,
            boolean reparsed
        );
    }

    /** Anonymous structure for the token data handler */
    @RawStructure
    public interface TokenDataHandlerNative extends PointerBase {
        @RawField public long version();
    }

    /** The structure representing a token */
    @CContext(LibDirectives.class)
    @CStruct("ada_token")
    public interface TokenNative extends PointerBase {
        @CField("context") public AnalysisContextNative get_context();
        @CField("context") public void set_context(
            AnalysisContextNative context
        );

        @CField("token_data") public TokenDataHandlerNative get_data();
        @CField("token_data") public void set_data(
            TokenDataHandlerNative data
        );

        @CField("token_index") public int get_token_index();
        @CField("token_index") public void set_token_index(
            int token_index
        );

        @CField("trivia_index") public int get_trivia_index();
        @CField("trivia_index") public void set_trivia_index(
            int trivia_index
        );
    }

    /** Anonymous strucutre for analysis context */
    @RawStructure
    public interface AnalysisContextNative extends PointerBase {
        @RawField public long serial_number();
    }

    /** Anonymous strucutre for analysis unit */
    @RawStructure
    public interface AnalysisUnitNative extends PointerBase {
        @RawField public long version_number();
    }

    /** The structure for reswriting apply results */
    @CContext(LibDirectives.class)
    @CStruct("ada_rewriting_apply_result")
    public interface RewritingApplyResultNative extends PointerBase {
        @CField("success") public int get_success();
        @CField("success") public void set_success(int success);

        @CField("unit") public AnalysisUnitNative get_unit();
        @CField("unit") public void set_unit(AnalysisUnitNative unit);

        @CField("diagnostics_count") public int get_diagnostics_count();
        @CField("diagnostics_count") public void set_diagnostics_count(
            int diagnostics_count
        );

        @CField("diagnostics") public DiagnosticNative get_diagnostics();
        @CField("diagnostics") public void set_diagnostics(
            DiagnosticNative diagnostics
        );
    }

    /** The rewriting context type is just a pointer */
    public interface RewritingContextNative extends Pointer {}

    /** The rewriting unit native type is just a pointer */
    public interface RewritingUnitNative extends Pointer {}

    /** The rewriting node native type is just a pointer */
    public interface RewritingNodeNative extends Pointer {}

    // ===== Generated structures =====

        
    
    

    /** The structure for the langkit ada_internal_metadata */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_metadata")
    public interface MetadataNative extends PointerBase {
        @CField("dottable_subp")
        public byte
        get_dottable_subp();

        @CField("dottable_subp")
        public void
        set_dottable_subp(
            byte val
        );

        @CFieldAddress("dottable_subp")
        public <T extends PointerBase> T address_dottable_subp();

        @CField("primitive")
        public Pointer
        get_primitive();

        @CField("primitive")
        public void
        set_primitive(
            Pointer val
        );

        @CFieldAddress("primitive")
        public <T extends PointerBase> T address_primitive();

        @CField("primitive_real_type")
        public Pointer
        get_primitive_real_type();

        @CField("primitive_real_type")
        public void
        set_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("primitive_real_type")
        public <T extends PointerBase> T address_primitive_real_type();


    }

        
    
    

    /** The structure for the langkit ada_internal_entity_info */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_entity_info")
    public interface EntityInfoNative extends PointerBase {
        @CField("md.dottable_subp")
        public byte
        get_md_dottable_subp();

        @CField("md.dottable_subp")
        public void
        set_md_dottable_subp(
            byte val
        );

        @CFieldAddress("md.dottable_subp")
        public <T extends PointerBase> T address_md_dottable_subp();

        @CField("md.primitive")
        public Pointer
        get_md_primitive();

        @CField("md.primitive")
        public void
        set_md_primitive(
            Pointer val
        );

        @CFieldAddress("md.primitive")
        public <T extends PointerBase> T address_md_primitive();

        @CField("md.primitive_real_type")
        public Pointer
        get_md_primitive_real_type();

        @CField("md.primitive_real_type")
        public void
        set_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("md.primitive_real_type")
        public <T extends PointerBase> T address_md_primitive_real_type();

        @CField("rebindings")
        public Pointer
        get_rebindings();

        @CField("rebindings")
        public void
        set_rebindings(
            Pointer val
        );

        @CFieldAddress("rebindings")
        public <T extends PointerBase> T address_rebindings();

        @CField("from_rebound")
        public byte
        get_from_rebound();

        @CField("from_rebound")
        public void
        set_from_rebound(
            byte val
        );

        @CFieldAddress("from_rebound")
        public <T extends PointerBase> T address_from_rebound();


            
        @CFieldAddress("md.dottable_subp")
        public MetadataNative
        address_md();

    }

    
    

    /** The structure for the langkit ada_node */
    @CContext(LibDirectives.class)
    @CStruct("ada_node")
    public interface EntityNative extends PointerBase {
        @CField("node")
        public Pointer
        get_node();

        @CField("node")
        public void
        set_node(
            Pointer val
        );

        @CFieldAddress("node")
        public <T extends PointerBase> T address_node();

        @CField("info.md.dottable_subp")
        public byte
        get_info_md_dottable_subp();

        @CField("info.md.dottable_subp")
        public void
        set_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("info.md.dottable_subp")
        public <T extends PointerBase> T address_info_md_dottable_subp();

        @CField("info.md.primitive")
        public Pointer
        get_info_md_primitive();

        @CField("info.md.primitive")
        public void
        set_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("info.md.primitive")
        public <T extends PointerBase> T address_info_md_primitive();

        @CField("info.md.primitive_real_type")
        public Pointer
        get_info_md_primitive_real_type();

        @CField("info.md.primitive_real_type")
        public void
        set_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("info.md.primitive_real_type")
        public <T extends PointerBase> T address_info_md_primitive_real_type();

        @CField("info.rebindings")
        public Pointer
        get_info_rebindings();

        @CField("info.rebindings")
        public void
        set_info_rebindings(
            Pointer val
        );

        @CFieldAddress("info.rebindings")
        public <T extends PointerBase> T address_info_rebindings();

        @CField("info.from_rebound")
        public byte
        get_info_from_rebound();

        @CField("info.from_rebound")
        public void
        set_info_from_rebound(
            byte val
        );

        @CFieldAddress("info.from_rebound")
        public <T extends PointerBase> T address_info_from_rebound();


            
        @CFieldAddress("info.md.dottable_subp")
        public EntityInfoNative
        address_info();

    }

        
    
    

    /** The structure for the langkit ada_internal_aspect */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_aspect")
    public interface AspectNative extends PointerBase {
        @CField("exists")
        public byte
        get_exists();

        @CField("exists")
        public void
        set_exists(
            byte val
        );

        @CFieldAddress("exists")
        public <T extends PointerBase> T address_exists();

        @CField("node.node")
        public Pointer
        get_node_node();

        @CField("node.node")
        public void
        set_node_node(
            Pointer val
        );

        @CFieldAddress("node.node")
        public <T extends PointerBase> T address_node_node();

        @CField("node.info.md.dottable_subp")
        public byte
        get_node_info_md_dottable_subp();

        @CField("node.info.md.dottable_subp")
        public void
        set_node_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("node.info.md.dottable_subp")
        public <T extends PointerBase> T address_node_info_md_dottable_subp();

        @CField("node.info.md.primitive")
        public Pointer
        get_node_info_md_primitive();

        @CField("node.info.md.primitive")
        public void
        set_node_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("node.info.md.primitive")
        public <T extends PointerBase> T address_node_info_md_primitive();

        @CField("node.info.md.primitive_real_type")
        public Pointer
        get_node_info_md_primitive_real_type();

        @CField("node.info.md.primitive_real_type")
        public void
        set_node_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("node.info.md.primitive_real_type")
        public <T extends PointerBase> T address_node_info_md_primitive_real_type();

        @CField("node.info.rebindings")
        public Pointer
        get_node_info_rebindings();

        @CField("node.info.rebindings")
        public void
        set_node_info_rebindings(
            Pointer val
        );

        @CFieldAddress("node.info.rebindings")
        public <T extends PointerBase> T address_node_info_rebindings();

        @CField("node.info.from_rebound")
        public byte
        get_node_info_from_rebound();

        @CField("node.info.from_rebound")
        public void
        set_node_info_from_rebound(
            byte val
        );

        @CFieldAddress("node.info.from_rebound")
        public <T extends PointerBase> T address_node_info_from_rebound();

        @CField("value.node")
        public Pointer
        get_value_node();

        @CField("value.node")
        public void
        set_value_node(
            Pointer val
        );

        @CFieldAddress("value.node")
        public <T extends PointerBase> T address_value_node();

        @CField("value.info.md.dottable_subp")
        public byte
        get_value_info_md_dottable_subp();

        @CField("value.info.md.dottable_subp")
        public void
        set_value_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("value.info.md.dottable_subp")
        public <T extends PointerBase> T address_value_info_md_dottable_subp();

        @CField("value.info.md.primitive")
        public Pointer
        get_value_info_md_primitive();

        @CField("value.info.md.primitive")
        public void
        set_value_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("value.info.md.primitive")
        public <T extends PointerBase> T address_value_info_md_primitive();

        @CField("value.info.md.primitive_real_type")
        public Pointer
        get_value_info_md_primitive_real_type();

        @CField("value.info.md.primitive_real_type")
        public void
        set_value_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("value.info.md.primitive_real_type")
        public <T extends PointerBase> T address_value_info_md_primitive_real_type();

        @CField("value.info.rebindings")
        public Pointer
        get_value_info_rebindings();

        @CField("value.info.rebindings")
        public void
        set_value_info_rebindings(
            Pointer val
        );

        @CFieldAddress("value.info.rebindings")
        public <T extends PointerBase> T address_value_info_rebindings();

        @CField("value.info.from_rebound")
        public byte
        get_value_info_from_rebound();

        @CField("value.info.from_rebound")
        public void
        set_value_info_from_rebound(
            byte val
        );

        @CFieldAddress("value.info.from_rebound")
        public <T extends PointerBase> T address_value_info_from_rebound();

        @CField("inherited")
        public byte
        get_inherited();

        @CField("inherited")
        public void
        set_inherited(
            byte val
        );

        @CFieldAddress("inherited")
        public <T extends PointerBase> T address_inherited();


            
        @CFieldAddress("node.node")
        public EntityNative
        address_node();

            
        @CFieldAddress("value.node")
        public EntityNative
        address_value();

    }

        
    
    

    /** The structure for the langkit ada_internal_completion_item */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_completion_item")
    public interface CompletionItemNative extends PointerBase {
        @CField("decl.node")
        public Pointer
        get_decl_node();

        @CField("decl.node")
        public void
        set_decl_node(
            Pointer val
        );

        @CFieldAddress("decl.node")
        public <T extends PointerBase> T address_decl_node();

        @CField("decl.info.md.dottable_subp")
        public byte
        get_decl_info_md_dottable_subp();

        @CField("decl.info.md.dottable_subp")
        public void
        set_decl_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("decl.info.md.dottable_subp")
        public <T extends PointerBase> T address_decl_info_md_dottable_subp();

        @CField("decl.info.md.primitive")
        public Pointer
        get_decl_info_md_primitive();

        @CField("decl.info.md.primitive")
        public void
        set_decl_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("decl.info.md.primitive")
        public <T extends PointerBase> T address_decl_info_md_primitive();

        @CField("decl.info.md.primitive_real_type")
        public Pointer
        get_decl_info_md_primitive_real_type();

        @CField("decl.info.md.primitive_real_type")
        public void
        set_decl_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("decl.info.md.primitive_real_type")
        public <T extends PointerBase> T address_decl_info_md_primitive_real_type();

        @CField("decl.info.rebindings")
        public Pointer
        get_decl_info_rebindings();

        @CField("decl.info.rebindings")
        public void
        set_decl_info_rebindings(
            Pointer val
        );

        @CFieldAddress("decl.info.rebindings")
        public <T extends PointerBase> T address_decl_info_rebindings();

        @CField("decl.info.from_rebound")
        public byte
        get_decl_info_from_rebound();

        @CField("decl.info.from_rebound")
        public void
        set_decl_info_from_rebound(
            byte val
        );

        @CFieldAddress("decl.info.from_rebound")
        public <T extends PointerBase> T address_decl_info_from_rebound();

        @CField("is_dot_call")
        public byte
        get_is_dot_call();

        @CField("is_dot_call")
        public void
        set_is_dot_call(
            byte val
        );

        @CFieldAddress("is_dot_call")
        public <T extends PointerBase> T address_is_dot_call();

        @CField("is_visible")
        public byte
        get_is_visible();

        @CField("is_visible")
        public void
        set_is_visible(
            byte val
        );

        @CFieldAddress("is_visible")
        public <T extends PointerBase> T address_is_visible();

        @CField("weight")
        public int
        get_weight();

        @CField("weight")
        public void
        set_weight(
            int val
        );

        @CFieldAddress("weight")
        public <T extends PointerBase> T address_weight();


            
        @CFieldAddress("decl.node")
        public EntityNative
        address_decl();

    }

        
        
    
    

    /** The structure for the langkit ada_internal_discrete_range */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_discrete_range")
    public interface DiscreteRangeNative extends PointerBase {
        @CField("low_bound.node")
        public Pointer
        get_low_bound_node();

        @CField("low_bound.node")
        public void
        set_low_bound_node(
            Pointer val
        );

        @CFieldAddress("low_bound.node")
        public <T extends PointerBase> T address_low_bound_node();

        @CField("low_bound.info.md.dottable_subp")
        public byte
        get_low_bound_info_md_dottable_subp();

        @CField("low_bound.info.md.dottable_subp")
        public void
        set_low_bound_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("low_bound.info.md.dottable_subp")
        public <T extends PointerBase> T address_low_bound_info_md_dottable_subp();

        @CField("low_bound.info.md.primitive")
        public Pointer
        get_low_bound_info_md_primitive();

        @CField("low_bound.info.md.primitive")
        public void
        set_low_bound_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("low_bound.info.md.primitive")
        public <T extends PointerBase> T address_low_bound_info_md_primitive();

        @CField("low_bound.info.md.primitive_real_type")
        public Pointer
        get_low_bound_info_md_primitive_real_type();

        @CField("low_bound.info.md.primitive_real_type")
        public void
        set_low_bound_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("low_bound.info.md.primitive_real_type")
        public <T extends PointerBase> T address_low_bound_info_md_primitive_real_type();

        @CField("low_bound.info.rebindings")
        public Pointer
        get_low_bound_info_rebindings();

        @CField("low_bound.info.rebindings")
        public void
        set_low_bound_info_rebindings(
            Pointer val
        );

        @CFieldAddress("low_bound.info.rebindings")
        public <T extends PointerBase> T address_low_bound_info_rebindings();

        @CField("low_bound.info.from_rebound")
        public byte
        get_low_bound_info_from_rebound();

        @CField("low_bound.info.from_rebound")
        public void
        set_low_bound_info_from_rebound(
            byte val
        );

        @CFieldAddress("low_bound.info.from_rebound")
        public <T extends PointerBase> T address_low_bound_info_from_rebound();

        @CField("high_bound.node")
        public Pointer
        get_high_bound_node();

        @CField("high_bound.node")
        public void
        set_high_bound_node(
            Pointer val
        );

        @CFieldAddress("high_bound.node")
        public <T extends PointerBase> T address_high_bound_node();

        @CField("high_bound.info.md.dottable_subp")
        public byte
        get_high_bound_info_md_dottable_subp();

        @CField("high_bound.info.md.dottable_subp")
        public void
        set_high_bound_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("high_bound.info.md.dottable_subp")
        public <T extends PointerBase> T address_high_bound_info_md_dottable_subp();

        @CField("high_bound.info.md.primitive")
        public Pointer
        get_high_bound_info_md_primitive();

        @CField("high_bound.info.md.primitive")
        public void
        set_high_bound_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("high_bound.info.md.primitive")
        public <T extends PointerBase> T address_high_bound_info_md_primitive();

        @CField("high_bound.info.md.primitive_real_type")
        public Pointer
        get_high_bound_info_md_primitive_real_type();

        @CField("high_bound.info.md.primitive_real_type")
        public void
        set_high_bound_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("high_bound.info.md.primitive_real_type")
        public <T extends PointerBase> T address_high_bound_info_md_primitive_real_type();

        @CField("high_bound.info.rebindings")
        public Pointer
        get_high_bound_info_rebindings();

        @CField("high_bound.info.rebindings")
        public void
        set_high_bound_info_rebindings(
            Pointer val
        );

        @CFieldAddress("high_bound.info.rebindings")
        public <T extends PointerBase> T address_high_bound_info_rebindings();

        @CField("high_bound.info.from_rebound")
        public byte
        get_high_bound_info_from_rebound();

        @CField("high_bound.info.from_rebound")
        public void
        set_high_bound_info_from_rebound(
            byte val
        );

        @CFieldAddress("high_bound.info.from_rebound")
        public <T extends PointerBase> T address_high_bound_info_from_rebound();


            
        @CFieldAddress("low_bound.node")
        public EntityNative
        address_low_bound();

            
        @CFieldAddress("high_bound.node")
        public EntityNative
        address_high_bound();

    }

        
    
    

    /** The structure for the langkit ada_internal_discriminant_values */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_discriminant_values")
    public interface DiscriminantValuesNative extends PointerBase {
        @CField("discriminant.node")
        public Pointer
        get_discriminant_node();

        @CField("discriminant.node")
        public void
        set_discriminant_node(
            Pointer val
        );

        @CFieldAddress("discriminant.node")
        public <T extends PointerBase> T address_discriminant_node();

        @CField("discriminant.info.md.dottable_subp")
        public byte
        get_discriminant_info_md_dottable_subp();

        @CField("discriminant.info.md.dottable_subp")
        public void
        set_discriminant_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("discriminant.info.md.dottable_subp")
        public <T extends PointerBase> T address_discriminant_info_md_dottable_subp();

        @CField("discriminant.info.md.primitive")
        public Pointer
        get_discriminant_info_md_primitive();

        @CField("discriminant.info.md.primitive")
        public void
        set_discriminant_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("discriminant.info.md.primitive")
        public <T extends PointerBase> T address_discriminant_info_md_primitive();

        @CField("discriminant.info.md.primitive_real_type")
        public Pointer
        get_discriminant_info_md_primitive_real_type();

        @CField("discriminant.info.md.primitive_real_type")
        public void
        set_discriminant_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("discriminant.info.md.primitive_real_type")
        public <T extends PointerBase> T address_discriminant_info_md_primitive_real_type();

        @CField("discriminant.info.rebindings")
        public Pointer
        get_discriminant_info_rebindings();

        @CField("discriminant.info.rebindings")
        public void
        set_discriminant_info_rebindings(
            Pointer val
        );

        @CFieldAddress("discriminant.info.rebindings")
        public <T extends PointerBase> T address_discriminant_info_rebindings();

        @CField("discriminant.info.from_rebound")
        public byte
        get_discriminant_info_from_rebound();

        @CField("discriminant.info.from_rebound")
        public void
        set_discriminant_info_from_rebound(
            byte val
        );

        @CFieldAddress("discriminant.info.from_rebound")
        public <T extends PointerBase> T address_discriminant_info_from_rebound();

        @CField("values.node")
        public Pointer
        get_values_node();

        @CField("values.node")
        public void
        set_values_node(
            Pointer val
        );

        @CFieldAddress("values.node")
        public <T extends PointerBase> T address_values_node();

        @CField("values.info.md.dottable_subp")
        public byte
        get_values_info_md_dottable_subp();

        @CField("values.info.md.dottable_subp")
        public void
        set_values_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("values.info.md.dottable_subp")
        public <T extends PointerBase> T address_values_info_md_dottable_subp();

        @CField("values.info.md.primitive")
        public Pointer
        get_values_info_md_primitive();

        @CField("values.info.md.primitive")
        public void
        set_values_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("values.info.md.primitive")
        public <T extends PointerBase> T address_values_info_md_primitive();

        @CField("values.info.md.primitive_real_type")
        public Pointer
        get_values_info_md_primitive_real_type();

        @CField("values.info.md.primitive_real_type")
        public void
        set_values_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("values.info.md.primitive_real_type")
        public <T extends PointerBase> T address_values_info_md_primitive_real_type();

        @CField("values.info.rebindings")
        public Pointer
        get_values_info_rebindings();

        @CField("values.info.rebindings")
        public void
        set_values_info_rebindings(
            Pointer val
        );

        @CFieldAddress("values.info.rebindings")
        public <T extends PointerBase> T address_values_info_rebindings();

        @CField("values.info.from_rebound")
        public byte
        get_values_info_from_rebound();

        @CField("values.info.from_rebound")
        public void
        set_values_info_from_rebound(
            byte val
        );

        @CFieldAddress("values.info.from_rebound")
        public <T extends PointerBase> T address_values_info_from_rebound();


            
        @CFieldAddress("discriminant.node")
        public EntityNative
        address_discriminant();

            
        @CFieldAddress("values.node")
        public EntityNative
        address_values();

    }

        
    
    

    /** The structure for the langkit ada_internal_doc_annotation */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_doc_annotation")
    public interface DocAnnotationNative extends PointerBase {
        @CField("key")
        public StringNative
        get_key();

        @CField("key")
        public void
        set_key(
            StringNative val
        );

        @CFieldAddress("key")
        public <T extends PointerBase> T address_key();

        @CField("value")
        public StringNative
        get_value();

        @CField("value")
        public void
        set_value(
            StringNative val
        );

        @CFieldAddress("value")
        public <T extends PointerBase> T address_value();


    }

        
        
        
        
        
    
    

    /** The structure for the langkit ada_internal_logic_context */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_logic_context")
    public interface LogicContextNative extends PointerBase {
        @CField("ref_node.node")
        public Pointer
        get_ref_node_node();

        @CField("ref_node.node")
        public void
        set_ref_node_node(
            Pointer val
        );

        @CFieldAddress("ref_node.node")
        public <T extends PointerBase> T address_ref_node_node();

        @CField("ref_node.info.md.dottable_subp")
        public byte
        get_ref_node_info_md_dottable_subp();

        @CField("ref_node.info.md.dottable_subp")
        public void
        set_ref_node_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("ref_node.info.md.dottable_subp")
        public <T extends PointerBase> T address_ref_node_info_md_dottable_subp();

        @CField("ref_node.info.md.primitive")
        public Pointer
        get_ref_node_info_md_primitive();

        @CField("ref_node.info.md.primitive")
        public void
        set_ref_node_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("ref_node.info.md.primitive")
        public <T extends PointerBase> T address_ref_node_info_md_primitive();

        @CField("ref_node.info.md.primitive_real_type")
        public Pointer
        get_ref_node_info_md_primitive_real_type();

        @CField("ref_node.info.md.primitive_real_type")
        public void
        set_ref_node_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("ref_node.info.md.primitive_real_type")
        public <T extends PointerBase> T address_ref_node_info_md_primitive_real_type();

        @CField("ref_node.info.rebindings")
        public Pointer
        get_ref_node_info_rebindings();

        @CField("ref_node.info.rebindings")
        public void
        set_ref_node_info_rebindings(
            Pointer val
        );

        @CFieldAddress("ref_node.info.rebindings")
        public <T extends PointerBase> T address_ref_node_info_rebindings();

        @CField("ref_node.info.from_rebound")
        public byte
        get_ref_node_info_from_rebound();

        @CField("ref_node.info.from_rebound")
        public void
        set_ref_node_info_from_rebound(
            byte val
        );

        @CFieldAddress("ref_node.info.from_rebound")
        public <T extends PointerBase> T address_ref_node_info_from_rebound();

        @CField("decl_node.node")
        public Pointer
        get_decl_node_node();

        @CField("decl_node.node")
        public void
        set_decl_node_node(
            Pointer val
        );

        @CFieldAddress("decl_node.node")
        public <T extends PointerBase> T address_decl_node_node();

        @CField("decl_node.info.md.dottable_subp")
        public byte
        get_decl_node_info_md_dottable_subp();

        @CField("decl_node.info.md.dottable_subp")
        public void
        set_decl_node_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("decl_node.info.md.dottable_subp")
        public <T extends PointerBase> T address_decl_node_info_md_dottable_subp();

        @CField("decl_node.info.md.primitive")
        public Pointer
        get_decl_node_info_md_primitive();

        @CField("decl_node.info.md.primitive")
        public void
        set_decl_node_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("decl_node.info.md.primitive")
        public <T extends PointerBase> T address_decl_node_info_md_primitive();

        @CField("decl_node.info.md.primitive_real_type")
        public Pointer
        get_decl_node_info_md_primitive_real_type();

        @CField("decl_node.info.md.primitive_real_type")
        public void
        set_decl_node_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("decl_node.info.md.primitive_real_type")
        public <T extends PointerBase> T address_decl_node_info_md_primitive_real_type();

        @CField("decl_node.info.rebindings")
        public Pointer
        get_decl_node_info_rebindings();

        @CField("decl_node.info.rebindings")
        public void
        set_decl_node_info_rebindings(
            Pointer val
        );

        @CFieldAddress("decl_node.info.rebindings")
        public <T extends PointerBase> T address_decl_node_info_rebindings();

        @CField("decl_node.info.from_rebound")
        public byte
        get_decl_node_info_from_rebound();

        @CField("decl_node.info.from_rebound")
        public void
        set_decl_node_info_from_rebound(
            byte val
        );

        @CFieldAddress("decl_node.info.from_rebound")
        public <T extends PointerBase> T address_decl_node_info_from_rebound();


            
        @CFieldAddress("ref_node.node")
        public EntityNative
        address_ref_node();

            
        @CFieldAddress("decl_node.node")
        public EntityNative
        address_decl_node();

    }

        
        
        
    
    

    /** The structure for the langkit ada_internal_param_actual */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_param_actual")
    public interface ParamActualNative extends PointerBase {
        @CField("param.node")
        public Pointer
        get_param_node();

        @CField("param.node")
        public void
        set_param_node(
            Pointer val
        );

        @CFieldAddress("param.node")
        public <T extends PointerBase> T address_param_node();

        @CField("param.info.md.dottable_subp")
        public byte
        get_param_info_md_dottable_subp();

        @CField("param.info.md.dottable_subp")
        public void
        set_param_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("param.info.md.dottable_subp")
        public <T extends PointerBase> T address_param_info_md_dottable_subp();

        @CField("param.info.md.primitive")
        public Pointer
        get_param_info_md_primitive();

        @CField("param.info.md.primitive")
        public void
        set_param_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("param.info.md.primitive")
        public <T extends PointerBase> T address_param_info_md_primitive();

        @CField("param.info.md.primitive_real_type")
        public Pointer
        get_param_info_md_primitive_real_type();

        @CField("param.info.md.primitive_real_type")
        public void
        set_param_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("param.info.md.primitive_real_type")
        public <T extends PointerBase> T address_param_info_md_primitive_real_type();

        @CField("param.info.rebindings")
        public Pointer
        get_param_info_rebindings();

        @CField("param.info.rebindings")
        public void
        set_param_info_rebindings(
            Pointer val
        );

        @CFieldAddress("param.info.rebindings")
        public <T extends PointerBase> T address_param_info_rebindings();

        @CField("param.info.from_rebound")
        public byte
        get_param_info_from_rebound();

        @CField("param.info.from_rebound")
        public void
        set_param_info_from_rebound(
            byte val
        );

        @CFieldAddress("param.info.from_rebound")
        public <T extends PointerBase> T address_param_info_from_rebound();

        @CField("actual.node")
        public Pointer
        get_actual_node();

        @CField("actual.node")
        public void
        set_actual_node(
            Pointer val
        );

        @CFieldAddress("actual.node")
        public <T extends PointerBase> T address_actual_node();

        @CField("actual.info.md.dottable_subp")
        public byte
        get_actual_info_md_dottable_subp();

        @CField("actual.info.md.dottable_subp")
        public void
        set_actual_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("actual.info.md.dottable_subp")
        public <T extends PointerBase> T address_actual_info_md_dottable_subp();

        @CField("actual.info.md.primitive")
        public Pointer
        get_actual_info_md_primitive();

        @CField("actual.info.md.primitive")
        public void
        set_actual_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("actual.info.md.primitive")
        public <T extends PointerBase> T address_actual_info_md_primitive();

        @CField("actual.info.md.primitive_real_type")
        public Pointer
        get_actual_info_md_primitive_real_type();

        @CField("actual.info.md.primitive_real_type")
        public void
        set_actual_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("actual.info.md.primitive_real_type")
        public <T extends PointerBase> T address_actual_info_md_primitive_real_type();

        @CField("actual.info.rebindings")
        public Pointer
        get_actual_info_rebindings();

        @CField("actual.info.rebindings")
        public void
        set_actual_info_rebindings(
            Pointer val
        );

        @CFieldAddress("actual.info.rebindings")
        public <T extends PointerBase> T address_actual_info_rebindings();

        @CField("actual.info.from_rebound")
        public byte
        get_actual_info_from_rebound();

        @CField("actual.info.from_rebound")
        public void
        set_actual_info_from_rebound(
            byte val
        );

        @CFieldAddress("actual.info.from_rebound")
        public <T extends PointerBase> T address_actual_info_from_rebound();


            
        @CFieldAddress("param.node")
        public EntityNative
        address_param();

            
        @CFieldAddress("actual.node")
        public EntityNative
        address_actual();

    }

        
        
        
    
    

    /** The structure for the langkit ada_internal_ref_result */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_ref_result")
    public interface RefResultNative extends PointerBase {
        @CField("ref.node")
        public Pointer
        get_ref_node();

        @CField("ref.node")
        public void
        set_ref_node(
            Pointer val
        );

        @CFieldAddress("ref.node")
        public <T extends PointerBase> T address_ref_node();

        @CField("ref.info.md.dottable_subp")
        public byte
        get_ref_info_md_dottable_subp();

        @CField("ref.info.md.dottable_subp")
        public void
        set_ref_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("ref.info.md.dottable_subp")
        public <T extends PointerBase> T address_ref_info_md_dottable_subp();

        @CField("ref.info.md.primitive")
        public Pointer
        get_ref_info_md_primitive();

        @CField("ref.info.md.primitive")
        public void
        set_ref_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("ref.info.md.primitive")
        public <T extends PointerBase> T address_ref_info_md_primitive();

        @CField("ref.info.md.primitive_real_type")
        public Pointer
        get_ref_info_md_primitive_real_type();

        @CField("ref.info.md.primitive_real_type")
        public void
        set_ref_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("ref.info.md.primitive_real_type")
        public <T extends PointerBase> T address_ref_info_md_primitive_real_type();

        @CField("ref.info.rebindings")
        public Pointer
        get_ref_info_rebindings();

        @CField("ref.info.rebindings")
        public void
        set_ref_info_rebindings(
            Pointer val
        );

        @CFieldAddress("ref.info.rebindings")
        public <T extends PointerBase> T address_ref_info_rebindings();

        @CField("ref.info.from_rebound")
        public byte
        get_ref_info_from_rebound();

        @CField("ref.info.from_rebound")
        public void
        set_ref_info_from_rebound(
            byte val
        );

        @CFieldAddress("ref.info.from_rebound")
        public <T extends PointerBase> T address_ref_info_from_rebound();

        @CField("kind")
        public int
        get_kind();

        @CField("kind")
        public void
        set_kind(
            int val
        );

        @CFieldAddress("kind")
        public <T extends PointerBase> T address_kind();


            
        @CFieldAddress("ref.node")
        public EntityNative
        address_ref();

    }

        
    
    

    /** The structure for the langkit ada_internal_refd_decl */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_refd_decl")
    public interface RefdDeclNative extends PointerBase {
        @CField("decl.node")
        public Pointer
        get_decl_node();

        @CField("decl.node")
        public void
        set_decl_node(
            Pointer val
        );

        @CFieldAddress("decl.node")
        public <T extends PointerBase> T address_decl_node();

        @CField("decl.info.md.dottable_subp")
        public byte
        get_decl_info_md_dottable_subp();

        @CField("decl.info.md.dottable_subp")
        public void
        set_decl_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("decl.info.md.dottable_subp")
        public <T extends PointerBase> T address_decl_info_md_dottable_subp();

        @CField("decl.info.md.primitive")
        public Pointer
        get_decl_info_md_primitive();

        @CField("decl.info.md.primitive")
        public void
        set_decl_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("decl.info.md.primitive")
        public <T extends PointerBase> T address_decl_info_md_primitive();

        @CField("decl.info.md.primitive_real_type")
        public Pointer
        get_decl_info_md_primitive_real_type();

        @CField("decl.info.md.primitive_real_type")
        public void
        set_decl_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("decl.info.md.primitive_real_type")
        public <T extends PointerBase> T address_decl_info_md_primitive_real_type();

        @CField("decl.info.rebindings")
        public Pointer
        get_decl_info_rebindings();

        @CField("decl.info.rebindings")
        public void
        set_decl_info_rebindings(
            Pointer val
        );

        @CFieldAddress("decl.info.rebindings")
        public <T extends PointerBase> T address_decl_info_rebindings();

        @CField("decl.info.from_rebound")
        public byte
        get_decl_info_from_rebound();

        @CField("decl.info.from_rebound")
        public void
        set_decl_info_from_rebound(
            byte val
        );

        @CFieldAddress("decl.info.from_rebound")
        public <T extends PointerBase> T address_decl_info_from_rebound();

        @CField("kind")
        public int
        get_kind();

        @CField("kind")
        public void
        set_kind(
            int val
        );

        @CFieldAddress("kind")
        public <T extends PointerBase> T address_kind();


            
        @CFieldAddress("decl.node")
        public EntityNative
        address_decl();

    }

        
    
    

    /** The structure for the langkit ada_internal_refd_def */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_refd_def")
    public interface RefdDefNative extends PointerBase {
        @CField("def_name.node")
        public Pointer
        get_def_name_node();

        @CField("def_name.node")
        public void
        set_def_name_node(
            Pointer val
        );

        @CFieldAddress("def_name.node")
        public <T extends PointerBase> T address_def_name_node();

        @CField("def_name.info.md.dottable_subp")
        public byte
        get_def_name_info_md_dottable_subp();

        @CField("def_name.info.md.dottable_subp")
        public void
        set_def_name_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("def_name.info.md.dottable_subp")
        public <T extends PointerBase> T address_def_name_info_md_dottable_subp();

        @CField("def_name.info.md.primitive")
        public Pointer
        get_def_name_info_md_primitive();

        @CField("def_name.info.md.primitive")
        public void
        set_def_name_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("def_name.info.md.primitive")
        public <T extends PointerBase> T address_def_name_info_md_primitive();

        @CField("def_name.info.md.primitive_real_type")
        public Pointer
        get_def_name_info_md_primitive_real_type();

        @CField("def_name.info.md.primitive_real_type")
        public void
        set_def_name_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("def_name.info.md.primitive_real_type")
        public <T extends PointerBase> T address_def_name_info_md_primitive_real_type();

        @CField("def_name.info.rebindings")
        public Pointer
        get_def_name_info_rebindings();

        @CField("def_name.info.rebindings")
        public void
        set_def_name_info_rebindings(
            Pointer val
        );

        @CFieldAddress("def_name.info.rebindings")
        public <T extends PointerBase> T address_def_name_info_rebindings();

        @CField("def_name.info.from_rebound")
        public byte
        get_def_name_info_from_rebound();

        @CField("def_name.info.from_rebound")
        public void
        set_def_name_info_from_rebound(
            byte val
        );

        @CFieldAddress("def_name.info.from_rebound")
        public <T extends PointerBase> T address_def_name_info_from_rebound();

        @CField("kind")
        public int
        get_kind();

        @CField("kind")
        public void
        set_kind(
            int val
        );

        @CFieldAddress("kind")
        public <T extends PointerBase> T address_kind();


            
        @CFieldAddress("def_name.node")
        public EntityNative
        address_def_name();

    }

        
    
    

    /** The structure for the langkit ada_internal_shape */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_shape")
    public interface ShapeNative extends PointerBase {
        @CField("components")
        public AdaNodeArrayNative
        get_components();

        @CField("components")
        public void
        set_components(
            BaseFormalParamDeclArrayNative val
        );

        @CFieldAddress("components")
        public <T extends PointerBase> T address_components();

        @CField("discriminants_values")
        public DiscriminantValuesArrayNative
        get_discriminants_values();

        @CField("discriminants_values")
        public void
        set_discriminants_values(
            DiscriminantValuesArrayNative val
        );

        @CFieldAddress("discriminants_values")
        public <T extends PointerBase> T address_discriminants_values();


    }

        
    
    

    /** The structure for the langkit ada_internal_solver_diagnostic */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_solver_diagnostic")
    public interface SolverDiagnosticNative extends PointerBase {
        @CField("message_template")
        public StringNative
        get_message_template();

        @CField("message_template")
        public void
        set_message_template(
            StringNative val
        );

        @CFieldAddress("message_template")
        public <T extends PointerBase> T address_message_template();

        @CField("args")
        public AdaNodeArrayNative
        get_args();

        @CField("args")
        public void
        set_args(
            AdaNodeArrayNative val
        );

        @CFieldAddress("args")
        public <T extends PointerBase> T address_args();

        @CField("location")
        public Pointer
        get_location();

        @CField("location")
        public void
        set_location(
            Pointer val
        );

        @CFieldAddress("location")
        public <T extends PointerBase> T address_location();

        @CField("contexts")
        public LogicContextArrayNative
        get_contexts();

        @CField("contexts")
        public void
        set_contexts(
            LogicContextArrayNative val
        );

        @CFieldAddress("contexts")
        public <T extends PointerBase> T address_contexts();

        @CField("round")
        public int
        get_round();

        @CField("round")
        public void
        set_round(
            int val
        );

        @CFieldAddress("round")
        public <T extends PointerBase> T address_round();


    }

        
        
    
    

    /** The structure for the langkit ada_internal_substitution */
    @CContext(LibDirectives.class)
    @CStruct("ada_internal_substitution")
    public interface SubstitutionNative extends PointerBase {
        @CField("from_decl.node")
        public Pointer
        get_from_decl_node();

        @CField("from_decl.node")
        public void
        set_from_decl_node(
            Pointer val
        );

        @CFieldAddress("from_decl.node")
        public <T extends PointerBase> T address_from_decl_node();

        @CField("from_decl.info.md.dottable_subp")
        public byte
        get_from_decl_info_md_dottable_subp();

        @CField("from_decl.info.md.dottable_subp")
        public void
        set_from_decl_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("from_decl.info.md.dottable_subp")
        public <T extends PointerBase> T address_from_decl_info_md_dottable_subp();

        @CField("from_decl.info.md.primitive")
        public Pointer
        get_from_decl_info_md_primitive();

        @CField("from_decl.info.md.primitive")
        public void
        set_from_decl_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("from_decl.info.md.primitive")
        public <T extends PointerBase> T address_from_decl_info_md_primitive();

        @CField("from_decl.info.md.primitive_real_type")
        public Pointer
        get_from_decl_info_md_primitive_real_type();

        @CField("from_decl.info.md.primitive_real_type")
        public void
        set_from_decl_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("from_decl.info.md.primitive_real_type")
        public <T extends PointerBase> T address_from_decl_info_md_primitive_real_type();

        @CField("from_decl.info.rebindings")
        public Pointer
        get_from_decl_info_rebindings();

        @CField("from_decl.info.rebindings")
        public void
        set_from_decl_info_rebindings(
            Pointer val
        );

        @CFieldAddress("from_decl.info.rebindings")
        public <T extends PointerBase> T address_from_decl_info_rebindings();

        @CField("from_decl.info.from_rebound")
        public byte
        get_from_decl_info_from_rebound();

        @CField("from_decl.info.from_rebound")
        public void
        set_from_decl_info_from_rebound(
            byte val
        );

        @CFieldAddress("from_decl.info.from_rebound")
        public <T extends PointerBase> T address_from_decl_info_from_rebound();

        @CField("to_value")
        public BigIntegerNative
        get_to_value();

        @CField("to_value")
        public void
        set_to_value(
            BigIntegerNative val
        );

        @CFieldAddress("to_value")
        public <T extends PointerBase> T address_to_value();

        @CField("value_type.node")
        public Pointer
        get_value_type_node();

        @CField("value_type.node")
        public void
        set_value_type_node(
            Pointer val
        );

        @CFieldAddress("value_type.node")
        public <T extends PointerBase> T address_value_type_node();

        @CField("value_type.info.md.dottable_subp")
        public byte
        get_value_type_info_md_dottable_subp();

        @CField("value_type.info.md.dottable_subp")
        public void
        set_value_type_info_md_dottable_subp(
            byte val
        );

        @CFieldAddress("value_type.info.md.dottable_subp")
        public <T extends PointerBase> T address_value_type_info_md_dottable_subp();

        @CField("value_type.info.md.primitive")
        public Pointer
        get_value_type_info_md_primitive();

        @CField("value_type.info.md.primitive")
        public void
        set_value_type_info_md_primitive(
            Pointer val
        );

        @CFieldAddress("value_type.info.md.primitive")
        public <T extends PointerBase> T address_value_type_info_md_primitive();

        @CField("value_type.info.md.primitive_real_type")
        public Pointer
        get_value_type_info_md_primitive_real_type();

        @CField("value_type.info.md.primitive_real_type")
        public void
        set_value_type_info_md_primitive_real_type(
            Pointer val
        );

        @CFieldAddress("value_type.info.md.primitive_real_type")
        public <T extends PointerBase> T address_value_type_info_md_primitive_real_type();

        @CField("value_type.info.rebindings")
        public Pointer
        get_value_type_info_rebindings();

        @CField("value_type.info.rebindings")
        public void
        set_value_type_info_rebindings(
            Pointer val
        );

        @CFieldAddress("value_type.info.rebindings")
        public <T extends PointerBase> T address_value_type_info_rebindings();

        @CField("value_type.info.from_rebound")
        public byte
        get_value_type_info_from_rebound();

        @CField("value_type.info.from_rebound")
        public void
        set_value_type_info_from_rebound(
            byte val
        );

        @CFieldAddress("value_type.info.from_rebound")
        public <T extends PointerBase> T address_value_type_info_from_rebound();


            
        @CFieldAddress("from_decl.node")
        public EntityNative
        address_from_decl();

            
        @CFieldAddress("value_type.node")
        public EntityNative
        address_value_type();

    }

        

    // ===== Generated arrays =====

    
    

    /**
     * The native structure of the ada_internal_aspect_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_internal_aspect_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface AspectArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_internal_discriminant_values_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_internal_discriminant_values_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface DiscriminantValuesArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_internal_doc_annotation_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_internal_doc_annotation_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface DocAnnotationArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface AcceptStmtArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface AdaNodeArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface BaseFormalParamDeclArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface BaseTypeDeclArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface BasicDeclArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface CompilationUnitArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface DefiningNameArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface ExprArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface GenericInstantiationArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface ParamSpecArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface PragmaNodeArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_node_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_node_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface TypeDeclArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_internal_logic_context_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_internal_logic_context_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface LogicContextArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_internal_param_actual_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_internal_param_actual_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface ParamActualArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_internal_ref_result_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_internal_ref_result_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface RefResultArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_internal_shape_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_internal_shape_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface ShapeArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_internal_solver_diagnostic_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_internal_solver_diagnostic_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface SolverDiagnosticArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_internal_substitution_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_internal_substitution_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface SubstitutionArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_analysis_unit_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_analysis_unit_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface AnalysisUnitArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }

    
    

    /**
     * The native structure of the ada_symbol_type_array langkit array.
     */
    @CContext(LibDirectives.class)
    @CStruct(
        value = "ada_symbol_type_array_record",
        addStructKeyword = true,
        isIncomplete = true
    )
    public interface UnboundedTextTypeArrayNative extends PointerBase {
        @CField("n") public int get_n();
        @CField("ref_count") public int get_ref_count();
        @CFieldAddress("items")
        public <T extends PointerBase> T address_items();
    }


    // ===== Generated iterators =====

    
    

    /** This interface represents the langkit ada_internal_completion_item_iterator iterator */
    public interface CompletionItemIteratorNative extends Pointer {}


    // ===== Native function definitions =====

    /** This class contains all native function definitions for NI */
    @CContext(LibDirectives.class)
    public static final class NI_LIB {

        // ----- Language specific functions -----

        
      


    // --- Project manager functions

    /** Function to load a GPR project */
    @CompilerDirectives.TruffleBoundary
    @CFunction
    public static native void ada_gpr_project_load(
        CCharPointer projectFile,
        Pointer scenarioVariable,
        CCharPointer target,
        CCharPointer runtime,
        CCharPointer configFile,
        int adaOnly,
        Pointer project,
        Pointer errors
    );

    /** Function to load an implicit GPR project */
    @CompilerDirectives.TruffleBoundary
    @CFunction
    public static native void ada_gpr_project_load_implicit(
        CCharPointer target,
        CCharPointer runtime,
        CCharPointer configFile,
        Pointer project,
        Pointer errors
    );

    /** Free the given project */
    @CompilerDirectives.TruffleBoundary
    @CFunction
    public static native void ada_gpr_project_free(
        ProjectManagerNative project
    );

    /** Get the unit provider for the given project */
    @CompilerDirectives.TruffleBoundary
    @CFunction
    public static native UnitProviderNative ada_gpr_project_create_unit_provider(
        ProjectManagerNative project,
        CCharPointer subProject
    );

    /** Get the source file array for the given project */
    @CompilerDirectives.TruffleBoundary
    @CFunction
    public static native StringArrayNative ada_gpr_project_source_files(
        ProjectManagerNative project,
        int mode,
        CCharPointerPointer projectsData,
        int projectsLength
    );

    /**
     * Wrapper around ``Initialize_Context_From_Project`` to initialize
     * ``Context`` (an already allocated but not yet initialized analysis
     * context) from ``Self``.
     */
    @CompilerDirectives.TruffleBoundary
    @CFunction
    public static native void ada_gpr_project_initialize_context(
        ProjectManagerNative project,
        AnalysisContextNative context,
        CCharPointer subproject,
        EventHandlerNative eventHandler,
        int withTrivia,
        int tabStop
    );

    /** Free the given source file array */
    @CompilerDirectives.TruffleBoundary
    @CFunction
    public static native void ada_free_string_array(
        StringArrayNative sourceFileArray
    );

    /** Create an auto provider reference */
    @CompilerDirectives.TruffleBoundary
    @CFunction
    public static native UnitProviderNative ada_create_auto_provider(
        CCharPointerPointer sourceFiles,
        CCharPointer charset
    );


    // --- Config pragmas

    @CompilerDirectives.TruffleBoundary
    @CFunction
    public static native void ada_set_config_pragmas_mapping(
        AnalysisContextNative context,
        AnalysisUnitNative globalPragmas,
        Pointer localPragmas
    );



        // ----- Entry point literals -----

        /**
         * This entry point literal provide a pointer to the unit requested
         * callback.
         */
        public static final CEntryPointLiteral<UnitRequestedFunctionPointer>
            unitRequestedFunction = CEntryPointLiteral.create(
                Libadalang.class,
                "unitRequested",
                IsolateThread.class,
                AnalysisContextNative.class,
                TextNative.class,
                AnalysisUnitNative.class,
                byte.class,
                byte.class
            );

        /**
         * This entry point literal provide a pointer to the unit parsed
         * callback.
         */
        public static final CEntryPointLiteral<UnitParsedFunctionPointer>
            unitParsedFunction = CEntryPointLiteral.create(
                Libadalang.class,
                "unitParsed",
                IsolateThread.class,
                AnalysisContextNative.class,
                AnalysisUnitNative.class,
                byte.class
            );

        // ----- Util functions -----

        /** Util function to free langkit side allocated memory */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_free(
            PointerBase pointer
        );

        // ----- Exception functions -----

        /** Get the last exception raised by langkit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native LangkitExceptionNative
        ada_get_last_exception();

        // ----- Big integer functions -----

        /** Create a big integer from a text */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native BigIntegerNative ada_create_big_integer(
            TextNative text
        );

        /** Get the text representation of a big integer */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_big_integer_text(
            BigIntegerNative big_integer,
            TextNative text
        );

        /** Decrease the reference counter of the big integer */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_big_integer_decref(
            BigIntegerNative big_integer
        );

        // ----- Symbol functions -----

        /** Create a new symbol in the given context */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_context_symbol(
            AnalysisContextNative context,
            TextNative text,
            SymbolNative res
        );

        /** Get the text of a given symbol */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_symbol_text(
            SymbolNative symbol,
            TextNative text
        );

        // ----- String functions -----

        /** Create a new string wrapper in langkit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native StringNative ada_create_string(
            CIntPointer content,
            int length
        );

        /** Decrease the reference counter of a string */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_string_dec_ref(
            StringNative string
        );

        // ----- Text functions -----

        /** Destroy a text in the memory */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_destroy_text(
            TextNative text
        );

        // ----- Rewriting result functions -----

        /** Free a rewriting apply result */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_free_apply_result(
            RewritingApplyResultNative apply_result
        );

        // ----- File reader functions -----

        /** Decrease the reference counter of the given file reader */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_dec_ref_file_reader(
            FileReaderNative fileReader
        );

        // ----- Unit provider functions -----

        /** Decrease the ref counter of the unit provider */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_dec_ref_unit_provider(
            UnitProviderNative unitProvider
        );

        // ----- Event handler functions -----

        /** Create a new event handler */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native EventHandlerNative ada_create_event_handler(
            VoidPointer data,
            VoidPointer destroy_callback,
            UnitRequestedFunctionPointer unit_requested_func,
            UnitParsedFunctionPointer unit_parsed_func
        );

        /** Decrease the ref counter of the event handler */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_dec_ref_event_handler(
            EventHandlerNative eventHandler
        );

        // ----- Token functions -----

        /**
         * Kind for this token.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_token_get_kind(
            TokenNative token
        );

        /**
         * Return the source location range of the given token.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_token_sloc_range(
            TokenNative token,
            SourceLocationRangeNative result
        );

        /** Get the next token */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_token_next(
            TokenNative token,
            TokenNative res
        );

        /** Get the previous token */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_token_previous(
            TokenNative token,
            TokenNative res
        );

        /** Get if two tokens are equivalent */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native byte ada_token_is_equivalent(
            TokenNative left,
            TokenNative right
        );

        /** Get the text in a token range */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_token_range_text(
            TokenNative start,
            TokenNative end,
            TextNative res
        );

        // ----- Analysis context functions -----

        /** Allocate a new analysis context */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AnalysisContextNative
        ada_allocate_analysis_context();

        /** Create a new analysis context */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void
        ada_initialize_analysis_context(
            AnalysisContextNative context,
            CCharPointer charset,
            FileReaderNative file_reader,
            UnitProviderNative unit_provider,
            EventHandlerNative event_handler,
            int with_trivia,
            int tab_stop
        );

        /** Increase the reference counter of a context */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_context_incref(
            AnalysisContextNative context
        );

        /** Decrease the reference counter of a context */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_context_decref(
            AnalysisContextNative context
        );

        // ----- Analysis unit functions -----

        /** Get a unit from a file */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AnalysisUnitNative
        ada_get_analysis_unit_from_file(
            AnalysisContextNative context,
            CCharPointer file_name,
            CCharPointer charset,
            int reparse,
            int rule
        );

        /** Get a unit from a buffer */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AnalysisUnitNative
        ada_get_analysis_unit_from_buffer(
            AnalysisContextNative context,
            CCharPointer file_name,
            CCharPointer charset,
            CCharPointer buffer,
            long buffer_size,
            int rule
        );

        /** Get a unit from the unit provider. */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AnalysisUnitNative
        ada_get_analysis_unit_from_provider(
            AnalysisContextNative context,
            TextNative name,
            int kind,
            CCharPointer charset,
            int reparse
        );

        /** Get the root of an analysis unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_unit_root(
            AnalysisUnitNative unit,
            EntityNative res
        );

        /** Get the file name for a given unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native CCharPointer ada_unit_filename(
            AnalysisUnitNative unit
        );

        /** Get the token count of the analysis unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_unit_token_count(
            AnalysisUnitNative unit
        );

        /** Get the trivia count of the analysis unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_unit_trivia_count(
            AnalysisUnitNative unit
        );

        /** Get the first token of an analysis unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_unit_first_token(
            AnalysisUnitNative unit,
            TokenNative res
        );

        /** Get the last token of an analysis unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_unit_last_token (
            AnalysisUnitNative unit,
            TokenNative res
        );

        /** Get the context for a given unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AnalysisContextNative ada_unit_context(
            AnalysisUnitNative unit
        );

        /** Get the diagnostic count of the unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_unit_diagnostic_count(
            AnalysisUnitNative unit
        );

        /** Get the nth diagnostic for the unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_unit_diagnostic(
            AnalysisUnitNative unit,
            int n,
            DiagnosticNative diagnostic
        );

        // ----- Rewriting context functions -----

        /** Start a new rewriting session on the given analysis context */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingContextNative
        ada_rewriting_start_rewriting(
            AnalysisContextNative analysis_context
        );

        /** Get the analysis context from the given rewriting context */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AnalysisContextNative
        ada_rewriting_handle_to_context(
            RewritingContextNative rewriting_context
        );

        /** Get a pointer to the rewriting units owned by the context */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native WordPointer ada_rewriting_unit_handles(
            RewritingContextNative rewriting_context
        );

        /** Create a node in the rewriting context and return it */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative
        ada_rewriting_create_node(
            RewritingContextNative rewriting_context,
            int node_kind
        );

        /** Create a node in the rewriting context with the given children */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative
        ada_rewriting_create_regular_node(
            RewritingContextNative rewriting_context,
            int node_kind,
            WordPointer children,
            int count
        );

        /** Create a token node in the rewriting context and return it */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative
        ada_rewriting_create_token_node(
            RewritingContextNative rewriting_context,
            int node_kind,
            TextNative node_text
        );

        /** Create a new node tree from the given template */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative
        ada_rewriting_create_from_template(
            RewritingContextNative rewriting_context,
            TextNative template_text,
            WordPointer arguments,
            int count,
            int rule
        );

        /** Apply the rewriting session and close it if success */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_apply(
            RewritingContextNative rewriting_context,
            RewritingApplyResultNative apply_result
        );

        /** Abort the rewriting session */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_abort_rewriting(
            RewritingContextNative rewriting_context
        );

        // ----- Rewriting unit functions -----

        /** Get the rewriting unit corresponding to the given analysis unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingUnitNative
        ada_rewriting_unit_to_handle(
            AnalysisUnitNative unit
        );

        /** Get the analysis unit corresponding to the given rewriting unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AnalysisUnitNative
        ada_rewriting_handle_to_unit(
            RewritingUnitNative rewriting_unit
        );

        /** Get the root of the given rewriting unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative ada_rewriting_unit_root(
            RewritingUnitNative rewriting_unit
        );

        /** Set the root of the rewriting unit to the rewriting node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_unit_set_root(
            RewritingUnitNative rewriting_unit,
            RewritingNodeNative rewriting_node
        );

        /** Unparse the rewriting unit to get its textual content */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_unit_unparse(
            RewritingUnitNative rewriting_unit,
            TextNative result
        );

        // ----- Rewriting node functions -----

        /** Get the rewriting node from the given parsed node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative
        ada_rewriting_node_to_handle(
            Pointer node
        );

        /** Get the parsed node from the given rewriting node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native Pointer ada_rewriting_handle_to_node(
            RewritingNodeNative rewriting_node
        );

        /** Get the rewriting context from the given rewriting node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingContextNative
        ada_rewriting_node_to_context(
            RewritingNodeNative rewriting_node
        );

        /** Clone the given rewriting node and return the copy */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative ada_rewriting_clone(
            RewritingNodeNative to_clone
        );

        /** Unparse the given rewriting node in the given text */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_node_unparse(
            RewritingNodeNative rewriting_node,
            TextNative result
        );

        /** Get the kind of the rewriting node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_rewriting_kind(
            RewritingNodeNative rewriting_node
        );

        /** Get the rewriting node image */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_node_image(
            RewritingNodeNative rewriting_node,
            TextNative result
        );

        /** Return whether the node is tied to a rewriting unit */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_rewriting_tied(
            RewritingNodeNative rewriting_node
        );

        /** Return the parent of the given rewriting node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative ada_rewriting_parent(
            RewritingNodeNative rewriting_node
        );

        /** Get the rewriting node children */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_children(
            RewritingNodeNative rewriting_node,
            WordPointer result_reference,
            CIntPointer result_count
        );

        /** Get the child at the given member reference */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative ada_rewriting_child(
            RewritingNodeNative parent,
            int child_member_reference
        );

        /** Set the given child at the given member reference */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_set_child(
            RewritingNodeNative parent,
            int child_member_reference,
            RewritingNodeNative new_child
        );

        /** Replace the rewriting node by the new one */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_replace(
            RewritingNodeNative rewriting_node,
            RewritingNodeNative new_node
        );

        /** Get the first child of the rewriting node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative
        ada_rewriting_first_child(
            RewritingNodeNative parent
        );

        /** Get the last child of the rewriting node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative
        ada_rewriting_last_child(
            RewritingNodeNative parent
        );

        /** Get the next child from the given rewriting node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative
        ada_rewriting_next_child(
            RewritingNodeNative rewriting_node
        );

        /** Get the previous child from the given rewriting node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RewritingNodeNative
        ada_rewriting_previous_child(
            RewritingNodeNative rewriting_node
        );

        /** Insert the provided rewriting node before the other node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_insert_before(
            RewritingNodeNative rewriting_node,
            RewritingNodeNative to_insert
        );

        /** Insert the provided rewriting node after the other node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_insert_after(
            RewritingNodeNative rewriting_node,
            RewritingNodeNative to_insert
        );

        /**
         * Insert the provided rewriting node at the beginning of the
         * children
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_insert_first(
            RewritingNodeNative rewriting_node,
            RewritingNodeNative to_insert
        );

        /** Insert the provided rewriting node at the end of the children */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_insert_last(
            RewritingNodeNative rewriting_node,
            RewritingNodeNative to_insert
        );

        /** Remove the given rewriting node from its list parent */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_remove_child(
            RewritingNodeNative to_remove
        );

        /** Get the text of the rewriting token node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_text(
            RewritingNodeNative rewriting_node,
            TextNative result
        );

        /** Set the text of the rewriting token node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_rewriting_set_text(
            RewritingNodeNative rewriting_node,
            TextNative text
        );

        // ----- Array functions -----

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AspectArrayNative ada_internal_aspect_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_aspect_array_dec_ref(AspectArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native DiscriminantValuesArrayNative ada_internal_discriminant_values_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_discriminant_values_array_dec_ref(DiscriminantValuesArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native DocAnnotationArrayNative ada_internal_doc_annotation_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_doc_annotation_array_dec_ref(DocAnnotationArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AdaNodeArrayNative ada_node_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_node_array_dec_ref(AdaNodeArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native LogicContextArrayNative ada_internal_logic_context_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_logic_context_array_dec_ref(LogicContextArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native ParamActualArrayNative ada_internal_param_actual_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_param_actual_array_dec_ref(ParamActualArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native RefResultArrayNative ada_internal_ref_result_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_ref_result_array_dec_ref(RefResultArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native ShapeArrayNative ada_internal_shape_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_shape_array_dec_ref(ShapeArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native SolverDiagnosticArrayNative ada_internal_solver_diagnostic_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_solver_diagnostic_array_dec_ref(SolverDiagnosticArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native SubstitutionArrayNative ada_internal_substitution_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_substitution_array_dec_ref(SubstitutionArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AnalysisUnitArrayNative ada_analysis_unit_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_analysis_unit_array_dec_ref(AnalysisUnitArrayNative array);

        
    

        /**
         * Create a new sized array.
         *
         * @param size The size of the array to create.
         * @return The native pointer to the created array.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native UnboundedTextTypeArrayNative ada_symbol_type_array_create(int size);

        /**
         * Decrease reference counter of the given array
         *
         * @param array The array to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_symbol_type_array_dec_ref(UnboundedTextTypeArrayNative array);


        // ----- Structure functions -----

            
        
    


            
        
    


        
    


            
        
    


            
        
    


            
            
        
    


            
        
    


            
        
    

        /**
         * Decreate the reference counter of the given struct.
         *
         * @param structNative The structure to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_doc_annotation_dec_ref(
            DocAnnotationNative structNative
        );

            
            
            
            
            
        
    


            
            
            
        
    


            
            
            
        
    


            
        
    


            
        
    


            
        
    

        /**
         * Decreate the reference counter of the given struct.
         *
         * @param structNative The structure to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_shape_dec_ref(
            ShapeNative structNative
        );

            
        
    

        /**
         * Decreate the reference counter of the given struct.
         *
         * @param structNative The structure to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_solver_diagnostic_dec_ref(
            SolverDiagnosticNative structNative
        );

            
            
        
    

        /**
         * Decreate the reference counter of the given struct.
         *
         * @param structNative The structure to decrease the reference counter.
         */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_internal_substitution_dec_ref(
            SubstitutionNative structNative
        );

            

        // ----- Node functions -----

        /** Create a bare entity from a node pointer */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_create_bare_entity(
            Pointer node,
            EntityNative result
        );

        /** Return whether the two given entities are equal */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_node_is_equivalent(
            EntityNative entity_left,
            EntityNative entity_right
        );

        /** Get the hash of a node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_node_hash(
            EntityNative entity
        );

        /** Get the type of a node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_node_kind(
            EntityNative entity
        );

        /** Get the text from a node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_node_text(
            EntityNative entity,
            TextNative text
        );

        /** Get the source location range for a node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_node_sloc_range(
            EntityNative entity,
            SourceLocationRangeNative slocr
        );

        /** Get the number of children for a node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_node_children_count(
            EntityNative entity
        );

        /** Get the nth child for the node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_node_child(
            EntityNative entity,
            int n,
            EntityNative res
        );

        /** Get if the node is a token node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_node_is_token_node(
            EntityNative entity
        );

        /** Get the unit of the node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native AnalysisUnitNative ada_node_unit(
            EntityNative entity
        );

        /** Get the image of a node */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native void ada_node_image(
            EntityNative entity,
            TextNative text
        );

        // ----- Node fields accessors and properties -----

        
    

            

        /** Isomethod of ada_ada_node_p_declarative_scope langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_declarative_scope(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_enclosing_compilation_unit langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_enclosing_compilation_unit(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_get_uninstantiated_node langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_get_uninstantiated_node(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_complete langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_complete(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_ada_node_p_valid_keywords langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_valid_keywords(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_ada_node_p_generic_instantiations langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_generic_instantiations(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_ada_node_p_semantic_parent langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_semantic_parent(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_parent_basic_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_parent_basic_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_has_spark_mode_on langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_has_spark_mode_on(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_ada_node_p_is_subject_to_proof langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_is_subject_to_proof(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_ada_node_p_filter_is_imported_by langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_filter_is_imported_by(
            EntityNative node,
            AnalysisUnitArrayNative units,
            byte transitive,
            WordPointer result
        );
            

        /** Isomethod of ada_ada_node_p_resolve_names langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_resolve_names(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_ada_node_p_nameres_diagnostics langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_nameres_diagnostics(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_ada_node_p_standard_unit langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_standard_unit(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_ada_node_p_is_keyword langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_is_keyword(
            EntityNative node,
            TokenNative token,
            SymbolNative language_version,
            CCharPointer result
        );
            

        /** Isomethod of ada_ada_node_p_std_entity langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_std_entity(
            EntityNative node,
            SymbolNative sym,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_bool_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_bool_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_int_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_int_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_universal_int_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_universal_int_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_universal_real_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_universal_real_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_std_char_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_std_char_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_std_wide_char_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_std_wide_char_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_std_wide_wide_char_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_std_wide_wide_char_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_std_string_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_std_string_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_std_wide_string_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_std_wide_string_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_std_wide_wide_string_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_std_wide_wide_string_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_top_level_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_top_level_decl(
            EntityNative node,
            AnalysisUnitNative unit,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_choice_match langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_choice_match(
            EntityNative node,
            BigIntegerNative value,
            CCharPointer result
        );
            

        /** Isomethod of ada_ada_node_p_gnat_xref langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_gnat_xref(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_p_spark_mode_aspect langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_spark_mode_aspect(
            EntityNative node,
            AspectNative result
        );
            

        /** Isomethod of ada_ada_node_p_xref_entry_point langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_xref_entry_point(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_ada_node_p_matching_with_use_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_p_matching_with_use_clause(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_ada_node_parent langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_parent(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_parents langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_parents(
            EntityNative node,
            byte with_self,
            WordPointer result
        );
            

        /** Isomethod of ada_ada_node_children langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_children(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_ada_node_token_start langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_token_start(
            EntityNative node,
            TokenNative result
        );
            

        /** Isomethod of ada_ada_node_token_end langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_token_end(
            EntityNative node,
            TokenNative result
        );
            

        /** Isomethod of ada_ada_node_child_index langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_child_index(
            EntityNative node,
            CIntPointer result
        );
            

        /** Isomethod of ada_ada_node_previous_sibling langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_previous_sibling(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_next_sibling langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_next_sibling(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ada_node_unit langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_unit(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_ada_node_is_ghost langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_is_ghost(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_ada_node_full_sloc_image langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ada_node_full_sloc_image(
            EntityNative node,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_abort_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_abort_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_abstract_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_abstract_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_assoc_list_p_zip_with_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_assoc_list_p_zip_with_params(
            EntityNative node,
            byte imprecise_fallback,
            WordPointer result
        );

        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_aliased_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_aliased_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_all_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_all_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_constrained_array_indices_f_list langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_constrained_array_indices_f_list(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_unconstrained_array_indices_f_types langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_unconstrained_array_indices_f_types(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_aspect_assoc_f_id langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_aspect_assoc_f_id(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_aspect_assoc_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_aspect_assoc_f_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_aspect_assoc_p_is_ghost_code langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_aspect_assoc_p_is_ghost_code(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    

            

        /** Isomethod of ada_at_clause_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_at_clause_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_at_clause_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_at_clause_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_attribute_def_clause_f_attribute_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_attribute_def_clause_f_attribute_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_attribute_def_clause_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_attribute_def_clause_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_enum_rep_clause_f_type_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_enum_rep_clause_f_type_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_enum_rep_clause_f_aggregate langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_enum_rep_clause_f_aggregate(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_enum_rep_clause_p_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_enum_rep_clause_p_params(
            EntityNative node,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_record_rep_clause_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_record_rep_clause_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_record_rep_clause_f_at_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_record_rep_clause_f_at_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_record_rep_clause_f_components langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_record_rep_clause_f_components(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_aspect_spec_f_aspect_assocs langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_aspect_spec_f_aspect_assocs(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_base_assoc_p_assoc_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_assoc_p_assoc_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_contract_case_assoc_f_guard langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_contract_case_assoc_f_guard(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_contract_case_assoc_f_consequence langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_contract_case_assoc_f_consequence(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_pragma_argument_assoc_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_pragma_argument_assoc_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_pragma_argument_assoc_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_pragma_argument_assoc_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_base_formal_param_holder_p_abstract_formal_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_formal_param_holder_p_abstract_formal_params(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_base_formal_param_holder_p_formal_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_formal_param_holder_p_formal_params(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_base_formal_param_holder_p_nb_min_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_formal_param_holder_p_nb_min_params(
            EntityNative node,
            CIntPointer result
        );
            

        /** Isomethod of ada_base_formal_param_holder_p_nb_max_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_formal_param_holder_p_nb_max_params(
            EntityNative node,
            CIntPointer result
        );
            

        /** Isomethod of ada_base_formal_param_holder_p_param_types langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_formal_param_holder_p_param_types(
            EntityNative node,
            EntityNative origin,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_base_subp_spec_p_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_subp_spec_p_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_subp_spec_p_returns langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_subp_spec_p_returns(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_subp_spec_p_primitive_subp_types langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_subp_spec_p_primitive_subp_types(
            EntityNative node,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_base_subp_spec_p_primitive_subp_first_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_subp_spec_p_primitive_subp_first_type(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_base_subp_spec_p_primitive_subp_tagged_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_subp_spec_p_primitive_subp_tagged_type(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_base_subp_spec_p_return_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_subp_spec_p_return_type(
            EntityNative node,
            EntityNative origin,
            EntityNative result
        );
            

        /** Isomethod of ada_base_subp_spec_p_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_subp_spec_p_params(
            EntityNative node,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_entry_spec_f_entry_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_spec_f_entry_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_spec_f_family_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_spec_f_family_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_spec_f_entry_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_spec_f_entry_params(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_subp_spec_f_subp_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subp_spec_f_subp_kind(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subp_spec_f_subp_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subp_spec_f_subp_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subp_spec_f_subp_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subp_spec_f_subp_params(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subp_spec_f_subp_returns langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subp_spec_f_subp_returns(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_synthetic_binary_spec_f_left_param langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_synthetic_binary_spec_f_left_param(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_synthetic_binary_spec_f_right_param langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_synthetic_binary_spec_f_right_param(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_synthetic_binary_spec_f_return_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_synthetic_binary_spec_f_return_type_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_synthetic_unary_spec_f_right_param langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_synthetic_unary_spec_f_right_param(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_synthetic_unary_spec_f_return_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_synthetic_unary_spec_f_return_type_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_component_list_f_components langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_list_f_components(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_component_list_f_variant_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_list_f_variant_part(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_known_discriminant_part_f_discr_specs langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_known_discriminant_part_f_discr_specs(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_entry_completion_formal_params_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_completion_formal_params_f_params(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_generic_formal_part_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_formal_part_f_decls(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_base_record_def_f_components langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_record_def_f_components(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_basic_assoc_p_get_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_assoc_p_get_params(
            EntityNative node,
            byte imprecise_fallback,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_aggregate_assoc_f_designators langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_aggregate_assoc_f_designators(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_aggregate_assoc_f_r_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_aggregate_assoc_f_r_expr(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_composite_constraint_assoc_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_composite_constraint_assoc_f_ids(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_composite_constraint_assoc_f_constraint_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_composite_constraint_assoc_f_constraint_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_iterated_assoc_f_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_iterated_assoc_f_spec(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_iterated_assoc_f_key_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_iterated_assoc_f_key_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_iterated_assoc_f_r_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_iterated_assoc_f_r_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_param_assoc_f_designator langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_param_assoc_f_designator(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_param_assoc_f_r_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_param_assoc_f_r_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_basic_decl_f_aspects langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_f_aspects(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_is_formal langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_is_formal(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_doc_annotations langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_doc_annotations(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_doc langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_doc(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_canonical_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_canonical_part(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_all_parts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_all_parts(
            EntityNative node,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_get_aspect_assoc langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_get_aspect_assoc(
            EntityNative node,
            SymbolNative name,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_get_aspect_spec_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_get_aspect_spec_expr(
            EntityNative node,
            SymbolNative name,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_get_aspect langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_get_aspect(
            EntityNative node,
            SymbolNative name,
            byte previous_parts_only,
            byte imprecise_fallback,
            AspectNative result
        );
            

        /** Isomethod of ada_basic_decl_p_has_aspect langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_has_aspect(
            EntityNative node,
            SymbolNative name,
            byte previous_parts_only,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_get_pragma langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_get_pragma(
            EntityNative node,
            SymbolNative name,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_get_representation_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_get_representation_clause(
            EntityNative node,
            SymbolNative name,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_get_at_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_get_at_clause(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_get_annotations langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_get_annotations(
            EntityNative node,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_is_ghost_code langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_is_ghost_code(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_is_compilation_unit_root langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_is_compilation_unit_root(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_is_visible langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_is_visible(
            EntityNative node,
            EntityNative from_node,
            CCharPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_base_subp_declarations langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_base_subp_declarations(
            EntityNative node,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_root_subp_declarations langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_root_subp_declarations(
            EntityNative node,
            EntityNative origin,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_find_all_overrides langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_find_all_overrides(
            EntityNative node,
            AnalysisUnitArrayNative units,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_defining_names langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_defining_names(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_defining_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_defining_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_subp_spec_or_null langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_subp_spec_or_null(
            EntityNative node,
            byte follow_generic,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_is_subprogram langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_is_subprogram(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_relative_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_relative_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_relative_name_text langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_relative_name_text(
            EntityNative node,
            SymbolNative result
        );
            

        /** Isomethod of ada_basic_decl_p_body_part_for_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_body_part_for_decl(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_most_visible_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_most_visible_part(
            EntityNative node,
            EntityNative origin,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_fully_qualified_name_array langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_fully_qualified_name_array(
            EntityNative node,
            byte include_profile,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_fully_qualified_name(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_canonical_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_canonical_fully_qualified_name(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_unique_identifying_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_unique_identifying_name(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_previous_part_for_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_previous_part_for_decl(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_is_static_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_is_static_decl(
            EntityNative node,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_is_imported langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_is_imported(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_basic_decl_p_type_expression langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_type_expression(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_next_part_for_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_next_part_for_decl(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_basic_decl_p_is_constant_object langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_decl_p_is_constant_object(
            EntityNative node,
            CCharPointer result
        );

        
    

            

        /** Isomethod of ada_abstract_state_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_abstract_state_decl_f_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_anonymous_expr_decl_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_anonymous_expr_decl_f_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_anonymous_expr_decl_p_get_formal langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_anonymous_expr_decl_p_get_formal(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_base_formal_param_decl_p_formal_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_formal_param_decl_p_formal_type(
            EntityNative node,
            EntityNative origin,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_component_decl_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_decl_f_ids(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_component_decl_f_component_def langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_decl_f_component_def(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_component_decl_f_default_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_decl_f_default_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_discriminant_spec_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_discriminant_spec_f_ids(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_discriminant_spec_f_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_discriminant_spec_f_type_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_discriminant_spec_f_default_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_discriminant_spec_f_default_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_generic_formal_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_formal_f_decl(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_param_spec_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_param_spec_f_ids(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_param_spec_f_has_aliased langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_param_spec_f_has_aliased(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_param_spec_f_mode langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_param_spec_f_mode(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_param_spec_f_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_param_spec_f_type_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_param_spec_f_default_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_param_spec_f_default_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_synthetic_formal_param_decl_f_param_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_synthetic_formal_param_decl_f_param_type(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_base_package_decl_f_package_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_package_decl_f_package_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_package_decl_f_public_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_package_decl_f_public_part(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_package_decl_f_private_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_package_decl_f_private_part(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_package_decl_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_package_decl_f_end_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_package_decl_p_body_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_package_decl_p_body_part(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_base_type_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_base_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_base_subtype(
            EntityNative node,
            EntityNative origin,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_attribute_subprogram langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_attribute_subprogram(
            EntityNative node,
            SymbolNative attr_name,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_private_completion langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_private_completion(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_inherited_primitive langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_inherited_primitive(
            EntityNative node,
            EntityNative p,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_get_record_representation_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_get_record_representation_clause(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_get_enum_representation_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_get_enum_representation_clause(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_get_primitives langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_get_primitives(
            EntityNative node,
            byte only_inherited,
            byte include_predefined_operators,
            WordPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_array_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_array_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_find_derived_types langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_find_derived_types(
            EntityNative node,
            EntityNative root,
            EntityNative origin,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_scalar_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_scalar_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_specific_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_specific_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_find_all_derived_types langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_find_all_derived_types(
            EntityNative node,
            AnalysisUnitArrayNative units,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_comp_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_comp_type(
            EntityNative node,
            byte is_subscript,
            EntityNative origin,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_index_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_index_type(
            EntityNative node,
            int dim,
            EntityNative origin,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_derived_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_derived_type(
            EntityNative node,
            EntityNative other_type,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_limited_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_limited_type(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_matching_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_matching_type(
            EntityNative node,
            EntityNative expected_type,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_previous_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_previous_part(
            EntityNative node,
            byte go_to_incomplete,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_next_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_next_part(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_full_view langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_full_view(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_definite_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_definite_subtype(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_discriminants_list langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_discriminants_list(
            EntityNative node,
            EntityNative stop_recurse_at,
            EntityNative origin,
            WordPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_shapes langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_shapes(
            EntityNative node,
            byte include_discriminants,
            EntityNative origin,
            WordPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_record_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_record_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_real_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_real_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_float_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_float_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_fixed_point langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_fixed_point(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_enum_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_enum_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_access_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_access_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_char_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_char_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_classwide_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_classwide_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_discrete_range langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_discrete_range(
            EntityNative node,
            DiscreteRangeNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_discrete_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_discrete_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_int_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_int_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_accessed_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_accessed_type(
            EntityNative node,
            EntityNative origin,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_tagged_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_tagged_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_base_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_base_type(
            EntityNative node,
            EntityNative origin,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_base_types langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_base_types(
            EntityNative node,
            EntityNative origin,
            WordPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_interface_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_interface_type(
            EntityNative node,
            EntityNative origin,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_canonical_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_canonical_type(
            EntityNative node,
            EntityNative origin,
            EntityNative result
        );
            

        /** Isomethod of ada_base_type_decl_p_is_private langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_is_private(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_base_type_decl_p_root_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_type_decl_p_root_type(
            EntityNative node,
            EntityNative origin,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_base_subtype_decl_p_get_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_subtype_decl_p_get_type(
            EntityNative node,
            EntityNative origin,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_subtype_decl_f_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subtype_decl_f_subtype(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_incomplete_type_decl_f_discriminants langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_incomplete_type_decl_f_discriminants(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_incomplete_formal_type_decl_f_is_tagged langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_incomplete_formal_type_decl_f_is_tagged(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_incomplete_formal_type_decl_f_default_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_incomplete_formal_type_decl_f_default_type(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_incomplete_tagged_type_decl_f_has_abstract langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_incomplete_tagged_type_decl_f_has_abstract(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_protected_type_decl_f_discriminants langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_type_decl_f_discriminants(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_protected_type_decl_f_interfaces langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_type_decl_f_interfaces(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_protected_type_decl_f_definition langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_type_decl_f_definition(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_task_type_decl_f_discriminants langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_type_decl_f_discriminants(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_task_type_decl_f_definition langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_type_decl_f_definition(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_type_decl_f_discriminants langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_decl_f_discriminants(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_type_decl_f_type_def langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_decl_f_type_def(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_formal_type_decl_f_default_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_formal_type_decl_f_default_type(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_basic_subp_decl_p_subp_decl_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_basic_subp_decl_p_subp_decl_spec(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_classic_subp_decl_f_overriding langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_classic_subp_decl_f_overriding(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_classic_subp_decl_f_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_classic_subp_decl_f_subp_spec(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_classic_subp_decl_p_body_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_classic_subp_decl_p_body_part(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_formal_subp_decl_f_default_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_formal_subp_decl_f_default_expr(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_entry_decl_f_overriding langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_decl_f_overriding(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_decl_f_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_decl_f_spec(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_decl_p_body_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_decl_p_body_part(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_decl_p_accept_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_decl_p_accept_stmts(
            EntityNative node,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_enum_literal_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_enum_literal_decl_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_enum_literal_decl_p_enum_rep langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_enum_literal_decl_p_enum_rep(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_enum_literal_decl_p_enum_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_enum_literal_decl_p_enum_type(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_synthetic_char_enum_lit_p_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_synthetic_char_enum_lit_p_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_generic_subp_internal_f_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_internal_f_subp_spec(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_synthetic_subp_decl_f_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_synthetic_subp_decl_f_spec(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_body_node_p_previous_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_body_node_p_previous_part(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_body_node_p_decl_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_body_node_p_decl_part(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_body_node_p_subunit_root langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_body_node_p_subunit_root(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_accept_stmt_body_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_accept_stmt_body_f_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_base_subp_body_f_overriding langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_subp_body_f_overriding(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_subp_body_f_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_subp_body_f_subp_spec(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_expr_function_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_function_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_subp_body_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subp_body_f_decls(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subp_body_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subp_body_f_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subp_body_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subp_body_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_subp_renaming_decl_f_renames langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subp_renaming_decl_f_renames(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_body_stub_p_syntactic_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_body_stub_p_syntactic_fully_qualified_name(
            EntityNative node,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_package_body_stub_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_package_body_stub_f_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_protected_body_stub_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_body_stub_f_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_subp_body_stub_f_overriding langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subp_body_stub_f_overriding(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subp_body_stub_f_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subp_body_stub_f_subp_spec(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_task_body_stub_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_body_stub_f_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_entry_body_f_entry_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_body_f_entry_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_body_f_index_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_body_f_index_spec(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_body_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_body_f_params(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_body_f_barrier langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_body_f_barrier(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_body_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_body_f_decls(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_body_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_body_f_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_body_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_body_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_package_body_f_package_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_package_body_f_package_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_package_body_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_package_body_f_decls(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_package_body_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_package_body_f_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_package_body_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_package_body_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_protected_body_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_body_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_protected_body_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_body_f_decls(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_protected_body_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_body_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_task_body_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_body_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_task_body_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_body_f_decls(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_task_body_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_body_f_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_task_body_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_body_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_entry_index_spec_f_id langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_index_spec_f_id(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_entry_index_spec_f_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_entry_index_spec_f_subtype(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_exception_decl_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_exception_decl_f_ids(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_exception_decl_f_renames langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_exception_decl_f_renames(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_exception_handler_f_exception_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_exception_handler_f_exception_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_exception_handler_f_handled_exceptions langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_exception_handler_f_handled_exceptions(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_exception_handler_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_exception_handler_f_stmts(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_for_loop_var_decl_f_id langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_for_loop_var_decl_f_id(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_for_loop_var_decl_f_id_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_for_loop_var_decl_f_id_type(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_generic_decl_f_formal_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_decl_f_formal_part(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_generic_package_decl_f_package_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_package_decl_f_package_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_package_decl_p_body_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_package_decl_p_body_part(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_generic_subp_decl_f_subp_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_decl_f_subp_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_subp_decl_p_body_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_decl_p_body_part(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_generic_instantiation_p_designated_generic_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_instantiation_p_designated_generic_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_instantiation_p_inst_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_instantiation_p_inst_params(
            EntityNative node,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_generic_package_instantiation_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_package_instantiation_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_package_instantiation_f_generic_pkg_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_package_instantiation_f_generic_pkg_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_package_instantiation_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_package_instantiation_f_params(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_generic_subp_instantiation_f_overriding langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_instantiation_f_overriding(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_subp_instantiation_f_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_instantiation_f_kind(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_subp_instantiation_f_subp_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_instantiation_f_subp_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_subp_instantiation_f_generic_subp_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_instantiation_f_generic_subp_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_subp_instantiation_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_instantiation_f_params(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_subp_instantiation_p_designated_subp langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_instantiation_p_designated_subp(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_generic_package_renaming_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_package_renaming_decl_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_package_renaming_decl_f_renames langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_package_renaming_decl_f_renames(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_generic_subp_renaming_decl_f_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_renaming_decl_f_kind(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_subp_renaming_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_renaming_decl_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_generic_subp_renaming_decl_f_renames langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_generic_subp_renaming_decl_f_renames(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_label_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_label_decl_f_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_named_stmt_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_named_stmt_decl_f_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_number_decl_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_number_decl_f_ids(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_number_decl_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_number_decl_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_object_decl_f_ids langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_object_decl_f_ids(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_object_decl_f_has_aliased langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_object_decl_f_has_aliased(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_object_decl_f_has_constant langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_object_decl_f_has_constant(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_object_decl_f_mode langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_object_decl_f_mode(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_object_decl_f_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_object_decl_f_type_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_object_decl_f_default_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_object_decl_f_default_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_object_decl_f_renaming_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_object_decl_f_renaming_clause(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_object_decl_p_private_part_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_object_decl_p_private_part_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_object_decl_p_public_part_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_object_decl_p_public_part_decl(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_package_renaming_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_package_renaming_decl_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_package_renaming_decl_f_renames langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_package_renaming_decl_f_renames(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_package_renaming_decl_p_renamed_package langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_package_renaming_decl_p_renamed_package(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_package_renaming_decl_p_final_renamed_package langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_package_renaming_decl_p_final_renamed_package(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_single_protected_decl_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_single_protected_decl_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_single_protected_decl_f_interfaces langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_single_protected_decl_f_interfaces(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_single_protected_decl_f_definition langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_single_protected_decl_f_definition(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_single_task_decl_f_task_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_single_task_decl_f_task_type(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_case_stmt_alternative_f_choices langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_case_stmt_alternative_f_choices(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_case_stmt_alternative_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_case_stmt_alternative_f_stmts(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_compilation_unit_f_prelude langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_f_prelude(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_compilation_unit_f_body langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_f_body(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_compilation_unit_f_pragmas langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_f_pragmas(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_compilation_unit_p_syntactic_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_syntactic_fully_qualified_name(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_compilation_unit_p_unit_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_unit_kind(
            EntityNative node,
            CIntPointer result
        );
            

        /** Isomethod of ada_compilation_unit_p_withed_units langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_withed_units(
            EntityNative node,
            byte include_privates,
            WordPointer result
        );
            

        /** Isomethod of ada_compilation_unit_p_imported_units langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_imported_units(
            EntityNative node,
            byte include_privates,
            WordPointer result
        );
            

        /** Isomethod of ada_compilation_unit_p_unit_dependencies langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_unit_dependencies(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_compilation_unit_p_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_compilation_unit_p_is_preelaborable langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_is_preelaborable(
            EntityNative node,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_compilation_unit_p_other_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_other_part(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_compilation_unit_p_has_restriction langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_has_restriction(
            EntityNative node,
            SymbolNative name,
            CCharPointer result
        );
            

        /** Isomethod of ada_compilation_unit_p_all_config_pragmas langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_all_config_pragmas(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_compilation_unit_p_config_pragmas langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_compilation_unit_p_config_pragmas(
            EntityNative node,
            SymbolNative name,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_component_clause_f_id langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_clause_f_id(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_component_clause_f_position langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_clause_f_position(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_component_clause_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_clause_f_range(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_component_def_f_has_aliased langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_def_f_has_aliased(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_component_def_f_has_constant langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_def_f_has_constant(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_component_def_f_type_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_component_def_f_type_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_constant_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_constant_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_composite_constraint_f_constraints langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_composite_constraint_f_constraints(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_composite_constraint_p_is_index_constraint langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_composite_constraint_p_is_index_constraint(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_composite_constraint_p_is_discriminant_constraint langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_composite_constraint_p_is_discriminant_constraint(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_composite_constraint_p_discriminant_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_composite_constraint_p_discriminant_params(
            EntityNative node,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_delta_constraint_f_delta langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_delta_constraint_f_delta(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_delta_constraint_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_delta_constraint_f_range(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_digits_constraint_f_digits langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_digits_constraint_f_digits(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_digits_constraint_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_digits_constraint_f_range(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_range_constraint_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_range_constraint_f_range(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_declarative_part_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_declarative_part_f_decls(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_elsif_expr_part_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_elsif_expr_part_f_cond_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_elsif_expr_part_f_then_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_elsif_expr_part_f_then_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_elsif_stmt_part_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_elsif_stmt_part_f_cond_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_elsif_stmt_part_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_elsif_stmt_part_f_stmts(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_expr_p_expression_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_expression_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_expr_p_expected_expression_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_expected_expression_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_expr_p_is_dynamically_tagged langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_is_dynamically_tagged(
            EntityNative node,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_expr_p_is_static_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_is_static_expr(
            EntityNative node,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_expr_p_eval_as_int langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_eval_as_int(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_expr_p_eval_as_int_in_env langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_eval_as_int_in_env(
            EntityNative node,
            SubstitutionArrayNative env,
            WordPointer result
        );
            

        /** Isomethod of ada_expr_p_eval_as_string langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_eval_as_string(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_expr_p_eval_as_string_in_env langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_eval_as_string_in_env(
            EntityNative node,
            SubstitutionArrayNative env,
            WordPointer result
        );
            

        /** Isomethod of ada_expr_p_matching_nodes langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_matching_nodes(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_expr_p_is_dispatching_call langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_is_dispatching_call(
            EntityNative node,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_expr_p_first_corresponding_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_expr_p_first_corresponding_decl(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_abstract_state_decl_expr_f_state_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_abstract_state_decl_expr_f_state_decl(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_allocator_f_subpool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_allocator_f_subpool(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_allocator_f_type_or_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_allocator_f_type_or_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_allocator_p_get_allocated_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_allocator_p_get_allocated_type(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_base_aggregate_f_ancestor_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_aggregate_f_ancestor_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_aggregate_f_assocs langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_aggregate_f_assocs(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_aggregate_p_aggregate_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_aggregate_p_aggregate_params(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_base_aggregate_p_is_subaggregate langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_aggregate_p_is_subaggregate(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_bin_op_f_left langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_bin_op_f_left(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_bin_op_f_op langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_bin_op_f_op(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_bin_op_f_right langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_bin_op_f_right(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_case_expr_alternative_f_choices langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_case_expr_alternative_f_choices(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_case_expr_alternative_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_case_expr_alternative_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_concat_op_f_first_operand langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_concat_op_f_first_operand(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_concat_op_f_other_operands langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_concat_op_f_other_operands(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_concat_op_p_operands langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_concat_op_p_operands(
            EntityNative node,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_concat_operand_f_operator langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_concat_operand_f_operator(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_concat_operand_f_operand langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_concat_operand_f_operand(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_cond_expr_p_dependent_exprs langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_cond_expr_p_dependent_exprs(
            EntityNative node,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_case_expr_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_case_expr_f_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_case_expr_f_cases langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_case_expr_f_cases(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_if_expr_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_if_expr_f_cond_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_if_expr_f_then_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_if_expr_f_then_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_if_expr_f_alternatives langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_if_expr_f_alternatives(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_if_expr_f_else_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_if_expr_f_else_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_contract_cases_f_contract_cases langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_contract_cases_f_contract_cases(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_decl_expr_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_decl_expr_f_decls(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_decl_expr_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_decl_expr_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_format_string_literal_f_opening_chunk langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_format_string_literal_f_opening_chunk(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_format_string_literal_f_mid_exprs langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_format_string_literal_f_mid_exprs(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_format_string_literal_f_trailing_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_format_string_literal_f_trailing_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_membership_expr_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_membership_expr_f_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_membership_expr_f_op langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_membership_expr_f_op(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_membership_expr_f_membership_exprs langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_membership_expr_f_membership_exprs(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_name_p_enclosing_defining_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_enclosing_defining_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_name_p_is_defining langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_is_defining(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_name_is langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_name_is(
            EntityNative node,
            SymbolNative sym,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_is_direct_call langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_is_direct_call(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_is_access_call langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_is_access_call(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_is_call langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_is_call(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_is_dot_call langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_is_dot_call(
            EntityNative node,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_failsafe_referenced_def_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_failsafe_referenced_def_name(
            EntityNative node,
            byte imprecise_fallback,
            RefdDefNative result
        );
            

        /** Isomethod of ada_name_p_referenced_defining_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_referenced_defining_name(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_name_p_all_env_elements langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_all_env_elements(
            EntityNative node,
            byte seq,
            EntityNative seq_from,
            WordPointer result
        );
            

        /** Isomethod of ada_name_p_called_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_called_subp_spec(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_name_p_referenced_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_referenced_decl(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_name_p_failsafe_referenced_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_failsafe_referenced_decl(
            EntityNative node,
            byte imprecise_fallback,
            RefdDeclNative result
        );
            

        /** Isomethod of ada_name_p_name_designated_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_name_designated_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_name_p_is_static_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_is_static_subtype(
            EntityNative node,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_name_matches langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_name_matches(
            EntityNative node,
            EntityNative n,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_is_operator_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_is_operator_name(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_is_write_reference langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_is_write_reference(
            EntityNative node,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_is_static_call langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_is_static_call(
            EntityNative node,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_name_p_call_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_call_params(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_name_p_relative_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_relative_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_name_p_as_symbol_array langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_as_symbol_array(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_name_p_canonical_text langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_canonical_text(
            EntityNative node,
            SymbolNative result
        );
            

        /** Isomethod of ada_name_p_is_constant langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_name_p_is_constant(
            EntityNative node,
            CCharPointer result
        );

        
    

            

        /** Isomethod of ada_array_subcomponent_choice_name_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_array_subcomponent_choice_name_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_array_subcomponent_choice_name_f_suffix langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_array_subcomponent_choice_name_f_suffix(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_attribute_ref_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_attribute_ref_f_prefix(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_attribute_ref_f_attribute langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_attribute_ref_f_attribute(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_attribute_ref_f_args langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_attribute_ref_f_args(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_call_expr_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_call_expr_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_call_expr_f_suffix langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_call_expr_f_suffix(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_call_expr_p_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_call_expr_p_kind(
            EntityNative node,
            CIntPointer result
        );
            

        /** Isomethod of ada_call_expr_p_is_array_slice langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_call_expr_p_is_array_slice(
            EntityNative node,
            CCharPointer result
        );

        
    

            

        /** Isomethod of ada_defining_name_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_defining_name_p_canonical_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_canonical_fully_qualified_name(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_defining_name_p_unique_identifying_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_unique_identifying_name(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_defining_name_p_fully_qualified_name_array langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_fully_qualified_name_array(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_defining_name_p_fully_qualified_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_fully_qualified_name(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_defining_name_p_basic_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_basic_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_defining_name_p_find_refs langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_find_refs(
            EntityNative node,
            EntityNative root,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_defining_name_p_find_all_references langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_find_all_references(
            EntityNative node,
            AnalysisUnitArrayNative units,
            byte follow_renamings,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_defining_name_p_find_all_calls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_find_all_calls(
            EntityNative node,
            AnalysisUnitArrayNative units,
            byte follow_renamings,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_defining_name_p_next_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_next_part(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_defining_name_p_previous_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_previous_part(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_defining_name_p_canonical_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_canonical_part(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_defining_name_p_most_visible_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_most_visible_part(
            EntityNative node,
            EntityNative origin,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_defining_name_p_all_parts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_all_parts(
            EntityNative node,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_defining_name_p_get_aspect langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_get_aspect(
            EntityNative node,
            SymbolNative name,
            byte previous_parts_only,
            byte imprecise_fallback,
            AspectNative result
        );
            

        /** Isomethod of ada_defining_name_p_has_aspect langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_has_aspect(
            EntityNative node,
            SymbolNative name,
            byte previous_parts_only,
            byte imprecise_fallback,
            CCharPointer result
        );
            

        /** Isomethod of ada_defining_name_p_get_pragma langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_get_pragma(
            EntityNative node,
            SymbolNative name,
            EntityNative result
        );
            

        /** Isomethod of ada_defining_name_p_get_representation_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_get_representation_clause(
            EntityNative node,
            SymbolNative name,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_defining_name_p_get_at_clause langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_get_at_clause(
            EntityNative node,
            byte imprecise_fallback,
            EntityNative result
        );
            

        /** Isomethod of ada_defining_name_p_get_annotations langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_get_annotations(
            EntityNative node,
            byte imprecise_fallback,
            WordPointer result
        );
            

        /** Isomethod of ada_defining_name_p_is_imported langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_is_imported(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_defining_name_p_is_ghost_code langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_defining_name_p_is_ghost_code(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    

            

        /** Isomethod of ada_discrete_subtype_name_f_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_discrete_subtype_name_f_subtype(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_dotted_name_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_dotted_name_f_prefix(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_dotted_name_f_suffix langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_dotted_name_f_suffix(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_end_name_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_end_name_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_end_name_p_basic_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_end_name_p_basic_decl(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_explicit_deref_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_explicit_deref_f_prefix(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_qual_expr_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_qual_expr_f_prefix(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_qual_expr_f_suffix langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_qual_expr_f_suffix(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_reduce_attribute_ref_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_reduce_attribute_ref_f_prefix(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_reduce_attribute_ref_f_attribute langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_reduce_attribute_ref_f_attribute(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_reduce_attribute_ref_f_args langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_reduce_attribute_ref_f_args(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_char_literal_p_denoted_value langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_char_literal_p_denoted_value(
            EntityNative node,
            CIntPointer result
        );

        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_string_literal_p_denoted_value langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_string_literal_p_denoted_value(
            EntityNative node,
            WordPointer result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_int_literal_p_denoted_value langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_int_literal_p_denoted_value(
            EntityNative node,
            WordPointer result
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_update_attribute_ref_f_prefix langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_update_attribute_ref_f_prefix(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_update_attribute_ref_f_attribute langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_update_attribute_ref_f_attribute(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_update_attribute_ref_f_values langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_update_attribute_ref_f_values(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_paren_expr_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_paren_expr_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_quantified_expr_f_quantifier langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_quantified_expr_f_quantifier(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_quantified_expr_f_loop_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_quantified_expr_f_loop_spec(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_quantified_expr_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_quantified_expr_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_raise_expr_f_exception_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_raise_expr_f_exception_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_raise_expr_f_error_message langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_raise_expr_f_error_message(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_un_op_f_op langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_un_op_f_op(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_un_op_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_un_op_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_for_loop_iter_filter_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_for_loop_iter_filter_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_format_string_chunk_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_format_string_chunk_f_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_format_string_chunk_f_string_tok langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_format_string_chunk_f_string_tok(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_handled_stmts_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_handled_stmts_f_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_handled_stmts_f_exceptions langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_handled_stmts_f_exceptions(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_library_item_f_has_private langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_library_item_f_has_private(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_library_item_f_item langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_library_item_f_item(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_limited_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_limited_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_for_loop_spec_f_var_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_for_loop_spec_f_var_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_for_loop_spec_f_loop_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_for_loop_spec_f_loop_type(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_for_loop_spec_f_has_reverse langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_for_loop_spec_f_has_reverse(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_for_loop_spec_f_iter_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_for_loop_spec_f_iter_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_for_loop_spec_f_iter_filter langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_for_loop_spec_f_iter_filter(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_while_loop_spec_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_while_loop_spec_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_multi_abstract_state_decl_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_multi_abstract_state_decl_f_decls(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_not_null_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_not_null_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_params_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_params_f_params(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_paren_abstract_state_decl_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_paren_abstract_state_decl_f_decl(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_pp_elsif_directive_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_pp_elsif_directive_f_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_pp_elsif_directive_f_then_kw langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_pp_elsif_directive_f_then_kw(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_pp_if_directive_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_pp_if_directive_f_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_pp_if_directive_f_then_kw langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_pp_if_directive_f_then_kw(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_pragma_node_f_id langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_pragma_node_f_id(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_pragma_node_f_args langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_pragma_node_f_args(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_pragma_node_p_is_ghost_code langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_pragma_node_p_is_ghost_code(
            EntityNative node,
            CCharPointer result
        );
            

        /** Isomethod of ada_pragma_node_p_associated_entities langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_pragma_node_p_associated_entities(
            EntityNative node,
            WordPointer result
        );

        
    

            

        /** Isomethod of ada_private_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_private_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_protected_def_f_public_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_def_f_public_part(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_protected_def_f_private_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_def_f_private_part(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_protected_def_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_def_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_protected_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_protected_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_range_spec_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_range_spec_f_range(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_renaming_clause_f_renamed_object langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_renaming_clause_f_renamed_object(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_reverse_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_reverse_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_select_when_part_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_select_when_part_f_cond_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_select_when_part_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_select_when_part_f_stmts(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_stmt_p_is_ghost_code langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_stmt_p_is_ghost_code(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    

            

        /** Isomethod of ada_accept_stmt_f_body_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_accept_stmt_f_body_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_accept_stmt_f_entry_index_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_accept_stmt_f_entry_index_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_accept_stmt_f_params langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_accept_stmt_f_params(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_accept_stmt_p_corresponding_entry langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_accept_stmt_p_corresponding_entry(
            EntityNative node,
            EntityNative origin,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_accept_stmt_with_stmts_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_accept_stmt_with_stmts_f_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_accept_stmt_with_stmts_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_accept_stmt_with_stmts_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_base_loop_stmt_f_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_loop_stmt_f_spec(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_loop_stmt_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_loop_stmt_f_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_base_loop_stmt_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_base_loop_stmt_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_begin_block_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_begin_block_f_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_begin_block_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_begin_block_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_decl_block_f_decls langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_decl_block_f_decls(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_decl_block_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_decl_block_f_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_decl_block_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_decl_block_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_case_stmt_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_case_stmt_f_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_case_stmt_f_pragmas langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_case_stmt_f_pragmas(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_case_stmt_f_alternatives langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_case_stmt_f_alternatives(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_extended_return_stmt_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_extended_return_stmt_f_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_extended_return_stmt_f_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_extended_return_stmt_f_stmts(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_if_stmt_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_if_stmt_f_cond_expr(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_if_stmt_f_then_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_if_stmt_f_then_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_if_stmt_f_alternatives langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_if_stmt_f_alternatives(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_if_stmt_f_else_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_if_stmt_f_else_stmts(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_named_stmt_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_named_stmt_f_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_named_stmt_f_stmt langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_named_stmt_f_stmt(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_select_stmt_f_guards langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_select_stmt_f_guards(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_select_stmt_f_else_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_select_stmt_f_else_stmts(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_select_stmt_f_abort_stmts langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_select_stmt_f_abort_stmts(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_abort_stmt_f_names langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_abort_stmt_f_names(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_assign_stmt_f_dest langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_assign_stmt_f_dest(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_assign_stmt_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_assign_stmt_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_call_stmt_f_call langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_call_stmt_f_call(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_delay_stmt_f_has_until langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_delay_stmt_f_has_until(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_delay_stmt_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_delay_stmt_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_exit_stmt_f_loop_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_exit_stmt_f_loop_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_exit_stmt_f_cond_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_exit_stmt_f_cond_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_goto_stmt_f_label_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_goto_stmt_f_label_name(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_label_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_label_f_decl(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_raise_stmt_f_exception_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_raise_stmt_f_exception_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_raise_stmt_f_error_message langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_raise_stmt_f_error_message(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_requeue_stmt_f_call_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_requeue_stmt_f_call_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_requeue_stmt_f_has_abort langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_requeue_stmt_f_has_abort(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_return_stmt_f_return_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_return_stmt_f_return_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_simple_decl_stmt_f_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_simple_decl_stmt_f_decl(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_subunit_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subunit_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subunit_f_body langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subunit_f_body(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subunit_p_body_root langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subunit_p_body_root(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_synchronized_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_synchronized_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_tagged_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_tagged_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_task_def_f_interfaces langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_def_f_interfaces(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_task_def_f_public_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_def_f_public_part(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_task_def_f_private_part langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_def_f_private_part(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_task_def_f_end_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_task_def_f_end_name(
            EntityNative node,
            EntityNative result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_access_def_f_has_not_null langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_access_def_f_has_not_null(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_access_to_subp_def_f_has_protected langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_access_to_subp_def_f_has_protected(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_access_to_subp_def_f_subp_spec langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_access_to_subp_def_f_subp_spec(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_anonymous_type_access_def_f_type_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_anonymous_type_access_def_f_type_decl(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_type_access_def_f_has_all langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_access_def_f_has_all(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_type_access_def_f_has_constant langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_access_def_f_has_constant(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_type_access_def_f_subtype_indication langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_access_def_f_subtype_indication(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_array_type_def_f_indices langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_array_type_def_f_indices(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_array_type_def_f_component_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_array_type_def_f_component_type(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_derived_type_def_f_has_abstract langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_derived_type_def_f_has_abstract(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_derived_type_def_f_has_limited langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_derived_type_def_f_has_limited(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_derived_type_def_f_has_synchronized langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_derived_type_def_f_has_synchronized(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_derived_type_def_f_subtype_indication langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_derived_type_def_f_subtype_indication(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_derived_type_def_f_interfaces langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_derived_type_def_f_interfaces(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_derived_type_def_f_record_extension langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_derived_type_def_f_record_extension(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_derived_type_def_f_has_with_private langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_derived_type_def_f_has_with_private(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_enum_type_def_f_enum_literals langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_enum_type_def_f_enum_literals(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_interface_type_def_f_interface_kind langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_interface_type_def_f_interface_kind(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_interface_type_def_f_interfaces langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_interface_type_def_f_interfaces(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_mod_int_type_def_f_expr langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_mod_int_type_def_f_expr(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_private_type_def_f_has_abstract langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_private_type_def_f_has_abstract(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_private_type_def_f_has_tagged langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_private_type_def_f_has_tagged(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_private_type_def_f_has_limited langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_private_type_def_f_has_limited(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_decimal_fixed_point_def_f_delta langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_decimal_fixed_point_def_f_delta(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_decimal_fixed_point_def_f_digits langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_decimal_fixed_point_def_f_digits(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_decimal_fixed_point_def_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_decimal_fixed_point_def_f_range(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_floating_point_def_f_num_digits langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_floating_point_def_f_num_digits(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_floating_point_def_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_floating_point_def_f_range(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_ordinary_fixed_point_def_f_delta langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ordinary_fixed_point_def_f_delta(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_ordinary_fixed_point_def_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_ordinary_fixed_point_def_f_range(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_record_type_def_f_has_abstract langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_record_type_def_f_has_abstract(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_record_type_def_f_has_tagged langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_record_type_def_f_has_tagged(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_record_type_def_f_has_limited langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_record_type_def_f_has_limited(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_record_type_def_f_record_def langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_record_type_def_f_record_def(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_signed_int_type_def_f_range langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_signed_int_type_def_f_range(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_type_expr_p_type_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_expr_p_type_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_type_expr_p_designated_type_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_expr_p_designated_type_decl(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_type_expr_p_designated_type_decl_from langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_expr_p_designated_type_decl_from(
            EntityNative node,
            EntityNative origin_node,
            EntityNative result
        );
            

        /** Isomethod of ada_type_expr_p_subtype_constraint langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_expr_p_subtype_constraint(
            EntityNative node,
            EntityNative origin,
            EntityNative result
        );
            

        /** Isomethod of ada_type_expr_p_discriminant_constraints langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_expr_p_discriminant_constraints(
            EntityNative node,
            WordPointer result
        );
            

        /** Isomethod of ada_type_expr_p_is_definite_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_type_expr_p_is_definite_subtype(
            EntityNative node,
            CCharPointer result
        );

        
    

            

        /** Isomethod of ada_anonymous_type_f_type_decl langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_anonymous_type_f_type_decl(
            EntityNative node,
            EntityNative result
        );

        
    


        
    

            

        /** Isomethod of ada_subtype_indication_f_has_not_null langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subtype_indication_f_has_not_null(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subtype_indication_f_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subtype_indication_f_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subtype_indication_f_constraint langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subtype_indication_f_constraint(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_subtype_indication_p_is_static_subtype langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_subtype_indication_p_is_static_subtype(
            EntityNative node,
            byte imprecise_fallback,
            CCharPointer result
        );

        
    


        
    


        
    

            

        /** Isomethod of ada_synthetic_type_expr_f_target_type langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_synthetic_type_expr_f_target_type(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_unconstrained_array_index_f_subtype_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_unconstrained_array_index_f_subtype_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_unconstrained_array_index_f_lower_bound langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_unconstrained_array_index_f_lower_bound(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_until_node_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_until_node_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    


        
    


        
    

            

        /** Isomethod of ada_use_package_clause_f_packages langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_use_package_clause_f_packages(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_use_type_clause_f_has_all langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_use_type_clause_f_has_all(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_use_type_clause_f_types langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_use_type_clause_f_types(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_value_sequence_f_iter_assoc langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_value_sequence_f_iter_assoc(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_variant_f_choices langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_variant_f_choices(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_variant_f_components langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_variant_f_components(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_variant_part_f_discr_name langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_variant_part_f_discr_name(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_variant_part_f_variant langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_variant_part_f_variant(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_with_clause_f_has_limited langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_with_clause_f_has_limited(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_with_clause_f_has_private langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_with_clause_f_has_private(
            EntityNative node,
            EntityNative result
        );
            

        /** Isomethod of ada_with_clause_f_packages langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_with_clause_f_packages(
            EntityNative node,
            EntityNative result
        );

        
    

            

        /** Isomethod of ada_with_private_p_as_bool langkit function */
        @CompilerDirectives.TruffleBoundary
        @CFunction
        public static native int ada_with_private_p_as_bool(
            EntityNative node,
            CCharPointer result
        );

        
    


        
    



    }


    // ==========
    // Exceptions
    // ==========

    /**
     * This class represents exception during symbol manipulation.
     */
    public static final class SymbolException extends RuntimeException {
        public SymbolException(
            final String symbol
        ) {
            super("Invalid symbol : '" + symbol + "'");
        }
    }

    /**
     * This class reprsents exception during enum manipulation.
     */
    public static final class EnumException extends RuntimeException {
        public EnumException(
            final String msg
        ) {
            super(msg);
        }
    }

    /**
     * This class represents an exception in the references manipulation.
     */
    public static final class ReferenceException extends RuntimeException {
        public ReferenceException(
            final String msg
        ) {
            super(msg);
        }
    }

    /**
     * This class wraps the exceptions from the langkit native library.
     */
    public static class LangkitException extends RuntimeException {

        // ----- Instance attributes -----

        /** The kind of the langkit exception. */
        public final ExceptionKind kind;

        // ----- Constructors -----

        /**
         * Create a new langkit exception.
         *
         * @param kind The kind of the exception represented by an integer
         * which will be mapped to an enum value.
         * @param message The message of the exception.
         */
        public LangkitException(
            final int kind,
            final String message
        ) {
            super(message);
            this.kind = ExceptionKind.fromC(kind);
        }

    }

    // ==========
    // Enum definitions
    // ==========

    // ===== Constants enumeration =====

    /**
     * Kind for this token.
     */
    public enum TokenKind {

        // ----- Enum values -----

        NO_TOKEN(-1, "No_Token"),
        ADA_ABORT(0, "Abort"),
        ADA_ABS(1, "Abs"),
        ADA_ACCEPT(2, "Accept"),
        ADA_ACCESS(3, "Access"),
        ADA_ALL(4, "All"),
        ADA_AMP(5, "Amp"),
        ADA_AND(6, "And"),
        ADA_ARRAY(7, "Array"),
        ADA_ARROW(8, "Arrow"),
        ADA_ASSIGN(9, "Assign"),
        ADA_AT(10, "At"),
        ADA_BEGIN(11, "Begin"),
        ADA_BODY(12, "Body"),
        ADA_BRACK_CLOSE(13, "Brack_Close"),
        ADA_BRACK_OPEN(14, "Brack_Open"),
        ADA_CASE(15, "Case"),
        ADA_CHAR(16, "Char"),
        ADA_COLON(17, "Colon"),
        ADA_COMMA(18, "Comma"),
        ADA_COMMENT(19, "Comment"),
        ADA_CONSTANT(20, "Constant"),
        ADA_DECIMAL(21, "Decimal"),
        ADA_DECLARE(22, "Declare"),
        ADA_DELAY(23, "Delay"),
        ADA_DELTA(24, "Delta"),
        ADA_DIAMOND(25, "Diamond"),
        ADA_DIGITS(26, "Digits"),
        ADA_DIVIDE(27, "Divide"),
        ADA_DO(28, "Do"),
        ADA_DOT(29, "Dot"),
        ADA_DOUBLEDOT(30, "Doubledot"),
        ADA_ELSE(31, "Else"),
        ADA_ELSIF(32, "Elsif"),
        ADA_END(33, "End"),
        ADA_ENTRY(34, "Entry"),
        ADA_EQUAL(35, "Equal"),
        ADA_EXCEPTION(36, "Exception"),
        ADA_EXIT(37, "Exit"),
        ADA_FOR(38, "For"),
        ADA_FORMAT_STRING_END(39, "Format_String_End"),
        ADA_FORMAT_STRING_MID(40, "Format_String_Mid"),
        ADA_FORMAT_STRING_START(41, "Format_String_Start"),
        ADA_FORMAT_STRING_STRING(42, "Format_String_String"),
        ADA_FUNCTION(43, "Function"),
        ADA_GENERIC(44, "Generic"),
        ADA_GOTO(45, "Goto"),
        ADA_GT(46, "Gt"),
        ADA_GTE(47, "Gte"),
        ADA_IDENTIFIER(48, "Identifier"),
        ADA_IF(49, "If"),
        ADA_IN(50, "In"),
        ADA_INTEGER(51, "Integer"),
        ADA_IS(52, "Is"),
        ADA_LABEL_END(53, "Label_End"),
        ADA_LABEL_START(54, "Label_Start"),
        ADA_LEXING_FAILURE(55, "Lexing_Failure"),
        ADA_LIMITED(56, "Limited"),
        ADA_LOOP(57, "Loop"),
        ADA_LT(58, "Lt"),
        ADA_LTE(59, "Lte"),
        ADA_MINUS(60, "Minus"),
        ADA_MOD(61, "Mod"),
        ADA_MULT(62, "Mult"),
        ADA_NEW(63, "New"),
        ADA_NOT(64, "Not"),
        ADA_NOTEQUAL(65, "Notequal"),
        ADA_NULL(66, "Null"),
        ADA_OF(67, "Of"),
        ADA_OR(68, "Or"),
        ADA_OTHERS(69, "Others"),
        ADA_OUT(70, "Out"),
        ADA_PACKAGE(71, "Package"),
        ADA_PAR_CLOSE(72, "Par_Close"),
        ADA_PAR_OPEN(73, "Par_Open"),
        ADA_PIPE(74, "Pipe"),
        ADA_PLUS(75, "Plus"),
        ADA_POWER(76, "Power"),
        ADA_PRAGMA(77, "Pragma"),
        ADA_PREP_LINE(78, "Prep_Line"),
        ADA_PRIVATE(79, "Private"),
        ADA_PROCEDURE(80, "Procedure"),
        ADA_RAISE(81, "Raise"),
        ADA_RANGE(82, "Range"),
        ADA_RECORD(83, "Record"),
        ADA_REM(84, "Rem"),
        ADA_RENAMES(85, "Renames"),
        ADA_RETURN(86, "Return"),
        ADA_REVERSE(87, "Reverse"),
        ADA_SELECT(88, "Select"),
        ADA_SEMICOLON(89, "Semicolon"),
        ADA_SEPARATE(90, "Separate"),
        ADA_STRING(91, "String"),
        ADA_SUBTYPE(92, "Subtype"),
        ADA_TARGET(93, "Target"),
        ADA_TASK(94, "Task"),
        ADA_TERMINATE(95, "Terminate"),
        ADA_TERMINATION(96, "Termination"),
        ADA_THEN(97, "Then"),
        ADA_TICK(98, "Tick"),
        ADA_TYPE(99, "Type"),
        ADA_USE(100, "Use"),
        ADA_WHEN(101, "When"),
        ADA_WHILE(102, "While"),
        ADA_WHITESPACE(103, "Whitespace"),
        ADA_WITH(104, "With"),
        ADA_XOR(105, "Xor"),
        ;

        // ----- Class attributes -----

        /** Singleton that represents the none token kind. */
        public static final TokenKind NONE = NO_TOKEN;

        /** The map from int to enum values. */
        private static final Map<Integer, TokenKind> map = new HashMap<>();

        // ----- Instance attributes -----

        /** The value of the enum instance. */
        private final int value;

        /** The name of the enum instance in the Langkit DSL. */
        public final String name;

        // ----- Constructors -----

        static {
            // Initialise the lookup map
            for(TokenKind elem : TokenKind.values()) {
                map.put(elem.value, elem);
            }
        }

        /** Private constructor. */
        private TokenKind(
            final int value,
            final String name
        ) {
            this.value = value;
            this.name = name;
        }

        // ----- Graal C API methods -----

        /**
         * Internal method to wrap a Native Image C pointer to a token kind
         * value.
         */
        static TokenKind fromC(
            final CIntPointer pointer
        ) throws EnumException {
            return fromC(pointer.read());
        }

        // ----- Enum methods -----

        /**
         * Get the enum instance for the given C value.
         *
         * @param cValue The C int value to get the enum instance from.
         * @return The enum instance which correspond to the int value.
         * @throws EnumException When the int value doesn't map to any enum
         * instance.
         */
        public static TokenKind fromC(
            final int cValue
        ) throws EnumException {
            if(!map.containsKey(cValue))
                throw new EnumException(
                    "Cannot get TokenKind from " + cValue
                );
            return (TokenKind) map.get(cValue);
        }

        /**
         * Get the C value from the enum instance.
         *
         * @return The int C value of the enum instance.
         */
        public int toC() {
            return this.value;
        }

    }

    /**
     * Enumerated type describing all possible exceptions that need to be
     * handled in the C bindings.
     */
    public enum ExceptionKind {

        // ----- Enum values -----

        FILE_READ_ERROR(0),
        BAD_TYPE_ERROR(1),
        OUT_OF_BOUNDS_ERROR(2),
        INVALID_INPUT(3),
        INVALID_SYMBOL_ERROR(4),
        INVALID_UNIT_NAME_ERROR(5),
        NATIVE_EXCEPTION(6),
        PRECONDITION_FAILURE(7),
        PROPERTY_ERROR(8),
        TEMPLATE_ARGS_ERROR(9),
        TEMPLATE_FORMAT_ERROR(10),
        TEMPLATE_INSTANTIATION_ERROR(11),
        STALE_REFERENCE_ERROR(12),
        SYNTAX_ERROR(13),
        UNKNOWN_CHARSET(14),
        MALFORMED_TREE_ERROR(15),
        PROJECT_ERROR(16),
        UNSUPPORTED_VIEW_ERROR(17),
        ;

        // ----- Class attributes -----

        /** Singleton that represents the none expcetion kind. */
        public static final ExceptionKind NONE =
            FILE_READ_ERROR;

        /** The map from int to enum values. */
        private static final Map<Integer, ExceptionKind> map =
            new HashMap<>();

        // ----- Instance ttributes -----

        /** The value of the enum instance. */
        private final int value;

        // ----- Constructors -----

        static {
            // Initialise the lookup map
            for(ExceptionKind elem : ExceptionKind.values()) {
                map.put(elem.value, elem);
            }
        }

        /** Private constructor. */
        private ExceptionKind(
            final int value
        ) {
            this.value = value;
        }

        // ----- Graal C API methods -----

        /**
         * Internal method to wrap a Native Image C pointer to a exception
         * kind value.
         */
        static ExceptionKind fromC(
            final CIntPointer pointer
        ) throws EnumException {
            return fromC(pointer.read());
        }

        // ----- Enum methods -----

        /**
         * Get the enum instance for the given C value.
         *
         * @param cValue The C int value to get the enum instance from.
         * @return The enum instance which correspond to the int value.
         * @throws EnumException When the int value doesn't map to any enum
         * instance.
         */
        public static ExceptionKind fromC(
            final int cValue
        ) throws EnumException {
            if(!map.containsKey(cValue))
                throw new EnumException(
                    "Cannot get ExceptionKind from " + cValue
                );
            return (ExceptionKind) map.get(cValue);
        }

        /**
         * Get the C value from the enum instance.
         *
         * @return The int C value of the enum instance.
         */
        public int toC() {
            return this.value;
        }

    }

    /**
     * Kind of AST nodes in parse trees.
     */
    public enum NodeKind {

        // ----- Enum values -----

            
        // ADA_NODE is abstract
            
        // ABORT_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        ABORT_ABSENT(1),
            
        /**
         * This node type has no derivation.
         */
        ABORT_PRESENT(2),
            
        // ABSTRACT_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        ABSTRACT_ABSENT(3),
            
        /**
         * This node type has no derivation.
         */
        ABSTRACT_PRESENT(4),
            
        // ADA_LIST is abstract
            
        /**
         * List of AdaNode.
         *
         * This list node can contain one of the following nodes:
         * ``AbstractStateDecl``, ``AbstractSubpDecl``, ``Allocator``,
         * ``ArraySubcomponentChoiceName``, ``AspectClause``, ``AttributeRef``,
         * ``BaseAggregate``, ``BaseSubpBody``, ``BinOp``, ``BodyStub``,
         * ``CallExpr``, ``CharLiteral``, ``ComponentClause``,
         * ``ComponentDecl``, ``ConcatOp``, ``ConcreteTypeDecl``, ``CondExpr``,
         * ``DeclExpr``, ``DottedName``, ``EntryBody``, ``EntryDecl``,
         * ``ErrorDecl``, ``ExceptionDecl``, ``ExceptionHandler``,
         * ``ExplicitDeref``, ``FormatStringLiteral``, ``GenericDecl``,
         * ``GenericFormal``, ``GenericInstantiation``,
         * ``GenericRenamingDecl``, ``Identifier``, ``IncompleteTypeDecl``,
         * ``MembershipExpr``, ``NullComponentDecl``, ``NullLiteral``,
         * ``NumLiteral``, ``NumberDecl``, ``ObjectDecl``,
         * ``OthersDesignator``, ``PackageBody``, ``PackageDecl``,
         * ``PackageRenamingDecl``, ``ParenAbstractStateDecl``, ``ParenExpr``,
         * ``PragmaNode``, ``ProtectedBody``, ``ProtectedTypeDecl``,
         * ``QualExpr``, ``QuantifiedExpr``, ``RaiseExpr``,
         * ``ReduceAttributeRef``, ``SingleProtectedDecl``, ``SingleTaskDecl``,
         * ``Stmt``, ``StringLiteral``, ``SubpDecl``, ``SubtypeDecl``,
         * ``SubtypeIndication``, ``TargetName``, ``TaskBody``,
         * ``TaskTypeDecl``, ``UnOp``, ``UpdateAttributeRef``, ``UseClause``,
         * ``WithClause``
         *
         * Derived nodes: ``AbstractStateDeclList``, ``AlternativesList``,
         * ``ConstraintList``, ``DeclList``, ``StmtList``
         */
        ADA_NODE_LIST(5),
            
        /**
         * List of AbstractStateDecls.
         *
         * This list node can contain one of the following nodes:
         * ``AbstractStateDecl``, ``ParenAbstractStateDecl``
         *
         * This node type has no derivation.
         */
        ABSTRACT_STATE_DECL_LIST(6),
            
        /**
         * List of alternatives in a ``when ...`` clause.
         *
         * This list node can contain one of the following nodes:
         * ``Allocator``, ``ArraySubcomponentChoiceName``, ``AttributeRef``,
         * ``BaseAggregate``, ``BinOp``, ``CallExpr``, ``CharLiteral``,
         * ``ConcatOp``, ``CondExpr``, ``DeclExpr``,
         * ``DiscreteSubtypeIndication``, ``DottedName``, ``ExplicitDeref``,
         * ``FormatStringLiteral``, ``Identifier``, ``MembershipExpr``,
         * ``NullLiteral``, ``NumLiteral``, ``OthersDesignator``,
         * ``ParenExpr``, ``QualExpr``, ``QuantifiedExpr``, ``RaiseExpr``,
         * ``ReduceAttributeRef``, ``StringLiteral``, ``TargetName``, ``UnOp``,
         * ``UpdateAttributeRef``
         *
         * This node type has no derivation.
         */
        ALTERNATIVES_LIST(7),
            
        /**
         * List of constraints.
         *
         * This list node can contain one of the following nodes:
         * ``AttributeRef``, ``BinOp``, ``CallExpr``, ``CharLiteral``,
         * ``DottedName``, ``ExplicitDeref``, ``Identifier``, ``QualExpr``,
         * ``ReduceAttributeRef``, ``StringLiteral``, ``SubtypeIndication``,
         * ``TargetName``, ``UpdateAttributeRef``
         *
         * This node type has no derivation.
         */
        CONSTRAINT_LIST(8),
            
        /**
         * List of declarations.
         *
         * This list node can contain one of the following nodes:
         * ``AbstractSubpDecl``, ``AspectClause``, ``ComponentDecl``,
         * ``EntryDecl``, ``ExprFunction``, ``NullSubpDecl``, ``PragmaNode``,
         * ``SubpDecl``, ``SubpRenamingDecl``
         *
         * This node type has no derivation.
         */
        DECL_LIST(9),
            
        /**
         * List of statements.
         *
         * This list node can contain one of the following nodes:
         * ``PragmaNode``, ``Stmt``
         *
         * This node type has no derivation.
         */
        STMT_LIST(10),
            
        /**
         * List of AspectAssoc.
         *
         * This node type has no derivation.
         */
        ASPECT_ASSOC_LIST(11),
            
        /**
         * List of BaseAssoc.
         *
         * This node type has no derivation.
         */
        BASE_ASSOC_LIST(12),
            
        // BASIC_ASSOC_LIST is abstract
            
        /**
         * List of associations.
         *
         * This node type has no derivation.
         */
        ASSOC_LIST(13),
            
        /**
         * List of CaseExprAlternative.
         *
         * This node type has no derivation.
         */
        CASE_EXPR_ALTERNATIVE_LIST(14),
            
        /**
         * List of CaseStmtAlternative.
         *
         * This node type has no derivation.
         */
        CASE_STMT_ALTERNATIVE_LIST(15),
            
        /**
         * List of CompilationUnit.
         *
         * This node type has no derivation.
         */
        COMPILATION_UNIT_LIST(16),
            
        /**
         * List of ConcatOperand.
         *
         * This node type has no derivation.
         */
        CONCAT_OPERAND_LIST(17),
            
        /**
         * List of ContractCaseAssoc.
         *
         * This node type has no derivation.
         */
        CONTRACT_CASE_ASSOC_LIST(18),
            
        /**
         * List of DefiningName.
         *
         * This node type has no derivation.
         */
        DEFINING_NAME_LIST(19),
            
        /**
         * List of DiscriminantSpec.
         *
         * This node type has no derivation.
         */
        DISCRIMINANT_SPEC_LIST(20),
            
        /**
         * List of ElsifExprPart.
         *
         * This node type has no derivation.
         */
        ELSIF_EXPR_PART_LIST(21),
            
        /**
         * List of ElsifStmtPart.
         *
         * This node type has no derivation.
         */
        ELSIF_STMT_PART_LIST(22),
            
        /**
         * List of EnumLiteralDecl.
         *
         * This node type has no derivation.
         */
        ENUM_LITERAL_DECL_LIST(23),
            
        // EXPR_LIST is abstract
            
        /**
         * List of alternatives in a membership test expression.
         *
         * This list node can contain one of the following nodes:
         * ``Allocator``, ``AttributeRef``, ``BaseAggregate``, ``BinOp``,
         * ``CallExpr``, ``CharLiteral``, ``ConcatOp``, ``CondExpr``,
         * ``DeclExpr``, ``DiscreteSubtypeName``, ``DottedName``,
         * ``ExplicitDeref``, ``FormatStringLiteral``, ``Identifier``,
         * ``NullLiteral``, ``NumLiteral``, ``ParenExpr``, ``QualExpr``,
         * ``QuantifiedExpr``, ``RaiseExpr``, ``ReduceAttributeRef``,
         * ``StringLiteral``, ``TargetName``, ``UnOp``, ``UpdateAttributeRef``
         *
         * This node type has no derivation.
         */
        EXPR_ALTERNATIVES_LIST(24),
            
        /**
         * List of FormatStringChunk.
         *
         * This node type has no derivation.
         */
        FORMAT_STRING_CHUNK_LIST(25),
            
        // IDENTIFIER_LIST is abstract
            
        /**
         * List of discriminant associations.
         *
         * This node type has no derivation.
         */
        DISCRIMINANT_CHOICE_LIST(26),
            
        /**
         * List of Name.
         *
         * This list node can contain one of the following nodes:
         * ``AttributeRef``, ``CallExpr``, ``CharLiteral``, ``DottedName``,
         * ``ExplicitDeref``, ``Identifier``, ``QualExpr``,
         * ``ReduceAttributeRef``, ``StringLiteral``, ``TargetName``,
         * ``UpdateAttributeRef``
         *
         * Derived nodes: ``ParentList``
         */
        NAME_LIST(27),
            
        /**
         * List of parents in a type declaration.
         *
         * This list node can contain one of the following nodes:
         * ``CharLiteral``, ``DottedName``, ``Identifier``, ``StringLiteral``
         *
         * This node type has no derivation.
         */
        PARENT_LIST(28),
            
        /**
         * List of ParamSpec.
         *
         * This node type has no derivation.
         */
        PARAM_SPEC_LIST(29),
            
        /**
         * List of Pragma.
         *
         * This node type has no derivation.
         */
        PRAGMA_NODE_LIST(30),
            
        /**
         * List of SelectWhenPart.
         *
         * This node type has no derivation.
         */
        SELECT_WHEN_PART_LIST(31),
            
        /**
         * List of UnconstrainedArrayIndex.
         *
         * This node type has no derivation.
         */
        UNCONSTRAINED_ARRAY_INDEX_LIST(32),
            
        /**
         * List of Variant.
         *
         * This node type has no derivation.
         */
        VARIANT_LIST(33),
            
        // ALIASED_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        ALIASED_ABSENT(34),
            
        /**
         * This node type has no derivation.
         */
        ALIASED_PRESENT(35),
            
        // ALL_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        ALL_ABSENT(36),
            
        /**
         * This node type has no derivation.
         */
        ALL_PRESENT(37),
            
        // ARRAY_INDICES is abstract
            
        /**
         * Constrained specification for array indexes (:rmlink:`3.6`).
         *
         * This node type has no derivation.
         */
        CONSTRAINED_ARRAY_INDICES(38),
            
        /**
         * Unconstrained specification for array indexes (:rmlink:`3.6`).
         *
         * This node type has no derivation.
         */
        UNCONSTRAINED_ARRAY_INDICES(39),
            
        /**
         * Name/expression association in an aspect.
         *
         * This node type has no derivation.
         */
        ASPECT_ASSOC(40),
            
        // ASPECT_CLAUSE is abstract
            
        /**
         * Representation clause (``for .. use at ...;``) (:rmlink:`13.5.1`).
         *
         * This node type has no derivation.
         */
        AT_CLAUSE(41),
            
        /**
         * Clause for an attribute definition (``for ...'Attribute use ...;``)
         * (:rmlink:`13.3`).
         *
         * This node type has no derivation.
         */
        ATTRIBUTE_DEF_CLAUSE(42),
            
        /**
         * Representation clause for enumeration types (:rmlink:`13.4`).
         *
         * This node type has no derivation.
         */
        ENUM_REP_CLAUSE(43),
            
        /**
         * Representation clause for a record type (:rmlink:`13.5.1`).
         *
         * This node type has no derivation.
         */
        RECORD_REP_CLAUSE(44),
            
        /**
         * List of aspects in a declaration (:rmlink:`13.1.1`).
         *
         * This node type has no derivation.
         */
        ASPECT_SPEC(45),
            
        // BASE_ASSOC is abstract
            
        /**
         * Single association for the ``Contract_Case`` aspect.
         *
         * This node type has no derivation.
         */
        CONTRACT_CASE_ASSOC(46),
            
        /**
         * Argument association in a pragma.
         *
         * This node type has no derivation.
         */
        PRAGMA_ARGUMENT_ASSOC(47),
            
        // BASE_FORMAL_PARAM_HOLDER is abstract
            
        // BASE_SUBP_SPEC is abstract
            
        /**
         * Entry specification.
         *
         * This node does not have ARM existence, because in the RM subprogram
         * specifications don't encompass the ad-hoc specifications that happen
         * in entry declarations. Entry declarations are described in
         * :rmlink:`9.5.2`.
         *
         * This node type has no derivation.
         */
        ENTRY_SPEC(48),
            
        /**
         * Synthetic node for the abstract subprogram spec of an enum literal.
         *
         * NOTE: This has no existence in the ARM. While enum literals are
         * functions semantically, they're not such syntactically.
         *
         * This node type has no derivation.
         */
        ENUM_SUBP_SPEC(49),
            
        /**
         * Subprogram specification (:rmlink:`6.1`).
         *
         * This node type has no derivation.
         */
        SUBP_SPEC(50),
            
        /**
         * Synthetic subprogram specification for binary operators.
         *
         * This node type has no derivation.
         */
        SYNTHETIC_BINARY_SPEC(51),
            
        /**
         * Synthetic subprogram specification for unary operators.
         *
         * This node type has no derivation.
         */
        SYNTHETIC_UNARY_SPEC(52),
            
        /**
         * List of component declarations (:rmlink:`3.8`).
         *
         * This node type has no derivation.
         */
        COMPONENT_LIST(53),
            
        // DISCRIMINANT_PART is abstract
            
        /**
         * Known list of discriminants in type declarations (:rmlink:`3.7`).
         *
         * This node type has no derivation.
         */
        KNOWN_DISCRIMINANT_PART(54),
            
        /**
         * Unknown list of discriminants in type declarations (:rmlink:`3.7`).
         *
         * This node type has no derivation.
         */
        UNKNOWN_DISCRIMINANT_PART(55),
            
        /**
         * Formal parameters for the completion of an ``EntryDecl`` (either an
         * ``EntryBody`` or an ``AcceptStmt``).
         *
         * This node type has no derivation.
         */
        ENTRY_COMPLETION_FORMAL_PARAMS(56),
            
        /**
         * List of declaration for generic formals (:rmlink:`12.1`).
         *
         * This node type has no derivation.
         */
        GENERIC_FORMAL_PART(57),
            
        // BASE_RECORD_DEF is abstract
            
        /**
         * Record definition for ``null record``.
         *
         * This node type has no derivation.
         */
        NULL_RECORD_DEF(58),
            
        /**
         * Record definition that contains components (``record ... end
         * record``).
         *
         * This node type has no derivation.
         */
        RECORD_DEF(59),
            
        // BASIC_ASSOC is abstract
            
        /**
         * Association (X => Y) used for aggregates associations
         * (:rmlink:`4.3`).
         *
         * Derived nodes: ``MultiDimArrayAssoc``
         */
        AGGREGATE_ASSOC(60),
            
        /**
         * Association used for multi-dimension array aggregates.
         *
         * This node type has no derivation.
         */
        MULTI_DIM_ARRAY_ASSOC(61),
            
        /**
         * Association of discriminant names to an expression
         * (:rmlink:`3.7.1`).
         *
         * This node type has no derivation.
         */
        COMPOSITE_CONSTRAINT_ASSOC(62),
            
        /**
         * Iterated association (Ada 2020, :rmlink:`4.3.3`).
         *
         * This node type has no derivation.
         */
        ITERATED_ASSOC(63),
            
        /**
         * Association (X => Y) used for parameter associations
         * (:rmlink:`6.4`).
         *
         * This node type has no derivation.
         */
        PARAM_ASSOC(64),
            
        // BASIC_DECL is abstract
            
        /**
         * Contained (directly or indirectly) in an AbstractStateDeclExpr, and
         * is used to represent the BasicDecl associated with the abstract
         * state introduced by the Abstract_State aspect. This node is
         * necessary because all of our name resolution routines expect
         * BasicDecls as environments' values.
         *
         * The only purpose of this node is to populate the env with the
         * abstract state declared through this node, so it can be referred in
         * SPARK aspects such as Global, Depends, Refined_State, etc.
         *
         * This node type has no derivation.
         */
        ABSTRACT_STATE_DECL(65),
            
        /**
         * Represents a anonymous declaration that holds an expression.
         *
         * This is used to store the results of queries such as
         * ``referenced_decl`` called on references to object formals from
         * inside a instantiated generic in order to return the relevant
         * actual.
         *
         * Indeed, ``referenced_decl`` must return a ``BasicDecl``, but actuals
         * of generic instantiations are ``Expr``. This wrapper node is
         * therefore a way to both satisfy the ``BasicDecl`` interface, and
         * provide to the user the expression of the actual through the
         * ``expr`` field.
         *
         * This node type has no derivation.
         */
        ANONYMOUS_EXPR_DECL(66),
            
        // BASE_FORMAL_PARAM_DECL is abstract
            
        /**
         * Declaration for a component (:rmlink:`3.8`).
         *
         * This node type has no derivation.
         */
        COMPONENT_DECL(67),
            
        /**
         * Known list of discriminants in type declarations (:rmlink:`3.7`).
         *
         * This node type has no derivation.
         */
        DISCRIMINANT_SPEC(68),
            
        // GENERIC_FORMAL is abstract
            
        /**
         * Formal declaration for an object.
         *
         * This node type has no derivation.
         */
        GENERIC_FORMAL_OBJ_DECL(69),
            
        /**
         * Formal declaration for a package (:rmlink:`12.1`).
         *
         * This node type has no derivation.
         */
        GENERIC_FORMAL_PACKAGE(70),
            
        /**
         * Formal declaration for a subprogram (:rmlink:`12.1`).
         *
         * This node type has no derivation.
         */
        GENERIC_FORMAL_SUBP_DECL(71),
            
        /**
         * Formal declaration for a type (:rmlink:`12.1`).
         *
         * This node type has no derivation.
         */
        GENERIC_FORMAL_TYPE_DECL(72),
            
        /**
         * Specification for a parameter (:rmlink:`6.1`).
         *
         * This node type has no derivation.
         */
        PARAM_SPEC(73),
            
        /**
         * Synthetic parameter declaration.
         *
         * This node type has no derivation.
         */
        SYNTHETIC_FORMAL_PARAM_DECL(74),
            
        // BASE_PACKAGE_DECL is abstract
            
        /**
         * This class denotes the internal package contained by a
         * GenericPackageDecl.
         *
         * This node type has no derivation.
         */
        GENERIC_PACKAGE_INTERNAL(75),
            
        /**
         * Non-generic package declarations (:rmlink:`7.1`).
         *
         * This node type has no derivation.
         */
        PACKAGE_DECL(76),
            
        // BASE_TYPE_DECL is abstract
            
        // BASE_SUBTYPE_DECL is abstract
            
        /**
         * Specific ``BaseSubtypeDecl`` synthetic subclass for the base type of
         * scalar types.
         *
         * This node type has no derivation.
         */
        DISCRETE_BASE_SUBTYPE_DECL(77),
            
        /**
         * Subtype declaration (:rmlink:`3.2.2`).
         *
         * This node type has no derivation.
         */
        SUBTYPE_DECL(78),
            
        /**
         * Synthetic node (not parsed, generated from a property call). Refers
         * to the classwide type for a given tagged type (:rmlink:`3.4.1`).
         *
         * This node type has no derivation.
         */
        CLASSWIDE_TYPE_DECL(79),
            
        /**
         * Incomplete declaration for a type (:rmlink:`12.5`).
         *
         * Derived nodes: ``IncompleteFormalTypeDecl``,
         * ``IncompleteTaggedTypeDecl``
         */
        INCOMPLETE_TYPE_DECL(80),
            
        /**
         * A formal incomplete type declaration.
         *
         * This node type has no derivation.
         */
        INCOMPLETE_FORMAL_TYPE_DECL(81),
            
        /**
         * Incomplete declaration for a tagged type.
         *
         * This node type has no derivation.
         */
        INCOMPLETE_TAGGED_TYPE_DECL(82),
            
        /**
         * Declaration for a protected type (:rmlink:`9.4`).
         *
         * This node type has no derivation.
         */
        PROTECTED_TYPE_DECL(83),
            
        /**
         * Declaration for a task type (:rmlink:`9.1`).
         *
         * Derived nodes: ``SingleTaskTypeDecl``
         */
        TASK_TYPE_DECL(84),
            
        /**
         * Type declaration for a single task (:rmlink:`9.1`).
         *
         * This node type has no derivation.
         */
        SINGLE_TASK_TYPE_DECL(85),
            
        // TYPE_DECL is abstract
            
        /**
         * Anonymous type declaration (for anonymous array or access types).
         * This class has no RM existence, and anonymous (sub)types are
         * referred to implicitly in the RM.
         *
         * Derived nodes: ``SynthAnonymousTypeDecl``
         */
        ANONYMOUS_TYPE_DECL(86),
            
        /**
         * Synthetic anonymous type decl. Used to generate anonymous access
         * types.
         *
         * This node type has no derivation.
         */
        SYNTH_ANONYMOUS_TYPE_DECL(87),
            
        /**
         * A concrete type declaration.
         *
         * This node type has no derivation.
         */
        CONCRETE_TYPE_DECL(88),
            
        /**
         * A formal type declaration.
         *
         * This node type has no derivation.
         */
        FORMAL_TYPE_DECL(89),
            
        // BASIC_SUBP_DECL is abstract
            
        // CLASSIC_SUBP_DECL is abstract
            
        /**
         * Declaration for an abstract subprogram (:rmlink:`3.9.3`).
         *
         * This node type has no derivation.
         */
        ABSTRACT_SUBP_DECL(90),
            
        // FORMAL_SUBP_DECL is abstract
            
        /**
         * Formal declaration for an abstract subprogram (:rmlink:`12.6`).
         *
         * This node type has no derivation.
         */
        ABSTRACT_FORMAL_SUBP_DECL(91),
            
        /**
         * Formal declaration for a concrete subprogram (:rmlink:`12.6`).
         *
         * This node type has no derivation.
         */
        CONCRETE_FORMAL_SUBP_DECL(92),
            
        /**
         * Regular subprogram declaration (:rmlink:`6.1`).
         *
         * This node type has no derivation.
         */
        SUBP_DECL(93),
            
        /**
         * Entry declaration (:rmlink:`9.4`).
         *
         * This node type has no derivation.
         */
        ENTRY_DECL(94),
            
        /**
         * Declaration for an enumeration literal (:rmlink:`3.5.1`).
         *
         * Derived nodes: ``SyntheticCharEnumLit``
         */
        ENUM_LITERAL_DECL(95),
            
        /**
         * Synthetic character enum literal declaration.
         *
         * This node type has no derivation.
         */
        SYNTHETIC_CHAR_ENUM_LIT(96),
            
        /**
         * Internal node for generic subprograms.
         *
         * This node type has no derivation.
         */
        GENERIC_SUBP_INTERNAL(97),
            
        /**
         * Synthetic subprogram declaration.
         *
         * Is used to represent predefined operators. This should also be
         * usable for synthesizing function attributes.
         *
         * This node type has no derivation.
         */
        SYNTHETIC_SUBP_DECL(98),
            
        // BODY_NODE is abstract
            
        /**
         * BasicDecl that is always the declaration of an AcceptStmt. This is
         * nested *inside* of the accept statement.
         *
         * This node type has no derivation.
         */
        ACCEPT_STMT_BODY(99),
            
        // BASE_SUBP_BODY is abstract
            
        /**
         * Expression function (:rmlink:`6.8`).
         *
         * This node type has no derivation.
         */
        EXPR_FUNCTION(100),
            
        /**
         * Declaration for a null subprogram (:rmlink:`6.1`).
         *
         * This node type has no derivation.
         */
        NULL_SUBP_DECL(101),
            
        /**
         * Subprogram body(:rmlink:`6.3`) .
         *
         * This node type has no derivation.
         */
        SUBP_BODY(102),
            
        /**
         * Declaration for a subprogram renaming (:rmlink:`8.5.4`).
         *
         * This node type has no derivation.
         */
        SUBP_RENAMING_DECL(103),
            
        // BODY_STUB is abstract
            
        /**
         * Stub for a package body (``is separate``) (:rmlink:`10.1.3`).
         *
         * This node type has no derivation.
         */
        PACKAGE_BODY_STUB(104),
            
        /**
         * Stub for a protected object body (``is separate``)
         * (:rmlink:`10.1.3`).
         *
         * This node type has no derivation.
         */
        PROTECTED_BODY_STUB(105),
            
        /**
         * Stub for a subprogram body (``is separate``) (:rmlink:`10.1.3`).
         *
         * This node type has no derivation.
         */
        SUBP_BODY_STUB(106),
            
        /**
         * Stub for a task body (``is separate``) (:rmlink:`10.1.3`).
         *
         * This node type has no derivation.
         */
        TASK_BODY_STUB(107),
            
        /**
         * Entry body (:rmlink:`9.5.2`).
         *
         * This node type has no derivation.
         */
        ENTRY_BODY(108),
            
        /**
         * Package body (:rmlink:`7.2`).
         *
         * This node type has no derivation.
         */
        PACKAGE_BODY(109),
            
        /**
         * Protected object body (:rmlink:`9.4`).
         *
         * This node type has no derivation.
         */
        PROTECTED_BODY(110),
            
        /**
         * Task body (:rmlink:`9.1`).
         *
         * This node type has no derivation.
         */
        TASK_BODY(111),
            
        /**
         * Index specification for an entry body (:rmlink:`9.5.2`).
         *
         * This node type has no derivation.
         */
        ENTRY_INDEX_SPEC(112),
            
        /**
         * Placeholder node for syntax errors in lists of declarations.
         *
         * This node type has no derivation.
         */
        ERROR_DECL(113),
            
        /**
         * Exception declarations (:rmlink:`11.1`).
         *
         * This node type has no derivation.
         */
        EXCEPTION_DECL(114),
            
        /**
         * Exception handler (:rmlink:`11.2`).
         *
         * This node type has no derivation.
         */
        EXCEPTION_HANDLER(115),
            
        /**
         * Declaration for the controlling variable in a ``for`` loop
         * (:rmlink:`5.5`).
         *
         * This node type has no derivation.
         */
        FOR_LOOP_VAR_DECL(116),
            
        // GENERIC_DECL is abstract
            
        /**
         * Generic package declaration (:rmlink:`12.1`).
         *
         * This node type has no derivation.
         */
        GENERIC_PACKAGE_DECL(117),
            
        /**
         * Generic subprogram declaration (:rmlink:`12.1`).
         *
         * This node type has no derivation.
         */
        GENERIC_SUBP_DECL(118),
            
        // GENERIC_INSTANTIATION is abstract
            
        /**
         * Instantiations of a generic package.
         *
         * This node type has no derivation.
         */
        GENERIC_PACKAGE_INSTANTIATION(119),
            
        /**
         * Instantiations of a generic subprogram .
         *
         * This node type has no derivation.
         */
        GENERIC_SUBP_INSTANTIATION(120),
            
        // GENERIC_RENAMING_DECL is abstract
            
        /**
         * Declaration for a generic package renaming (:rmlink:`8.5.5`).
         *
         * This node type has no derivation.
         */
        GENERIC_PACKAGE_RENAMING_DECL(121),
            
        /**
         * Declaration for a generic subprogram renaming.
         *
         * This node type has no derivation.
         */
        GENERIC_SUBP_RENAMING_DECL(122),
            
        /**
         * Declaration for a code label (:rmlink:`5.1`).
         *
         * This node type has no derivation.
         */
        LABEL_DECL(123),
            
        /**
         * BasicDecl that is always the declaration inside a named statement.
         *
         * This node type has no derivation.
         */
        NAMED_STMT_DECL(124),
            
        /**
         * Declaration for a static constant number (:rmlink:`3.3.2`).
         *
         * This node type has no derivation.
         */
        NUMBER_DECL(125),
            
        /**
         * Base class for Ada object declarations (:rmlink:`3.3.1`). Ada object
         * declarations are variables/constants declarations that can be
         * declared in any declarative scope.
         *
         * Derived nodes: ``ExtendedReturnStmtObjectDecl``,
         * ``NoTypeObjectRenamingDecl``
         */
        OBJECT_DECL(126),
            
        /**
         * Object declaration that is part of an extended return statement
         * (:rmlink:`6.5`).
         *
         * This node type has no derivation.
         */
        EXTENDED_RETURN_STMT_OBJECT_DECL(127),
            
        /**
         * Object declaration without subtype indication. This node has been
         * introduced to cover a special case for ``ObjectDecl``, where
         * ``type_expr`` is made optional (AI12-0275), and therefore cannot fit
         * in an ``ObjectDecl``.
         *
         * This node type has no derivation.
         */
        NO_TYPE_OBJECT_RENAMING_DECL(128),
            
        /**
         * Declaration for a package renaming (:rmlink:`8.5.3`).
         *
         * This node type has no derivation.
         */
        PACKAGE_RENAMING_DECL(129),
            
        /**
         * Declaration for a single protected object (:rmlink:`9.4`).
         *
         * This node type has no derivation.
         */
        SINGLE_PROTECTED_DECL(130),
            
        /**
         * Declaration for a single task (:rmlink:`9.1`).
         *
         * This node type has no derivation.
         */
        SINGLE_TASK_DECL(131),
            
        /**
         * SyntheticObjectDecl is a declaration that holds a virtual object.
         * This is for example used in type predicates to refer to an object of
         * the enclosing type, as in:
         *
         * .. code::
         *
         *    subtype Odd is Natural with
         *       Dynamic_Predicate => Odd mod 2 = 1;
         *
         * where we have to create an object named ``Odd``, and of type ``Odd``
         * so that the name in the aspect expression refers to it and can be
         * properly resolved to the type identifier.
         *
         * This node has no existance in the Ada RM, it's only used for
         * internal name resolution purposes.
         *
         * This node type has no derivation.
         */
        SYNTHETIC_OBJECT_DECL(132),
            
        /**
         * Alternative in a ``case`` statement (``when ... => ...``).
         *
         * This node type has no derivation.
         */
        CASE_STMT_ALTERNATIVE(133),
            
        /**
         * Root node for all Ada analysis units (:rmlink:`10.1.1`).
         *
         * This node type has no derivation.
         */
        COMPILATION_UNIT(134),
            
        /**
         * Representation clause for a single component (:rmlink:`13.5.1`).
         *
         * This node type has no derivation.
         */
        COMPONENT_CLAUSE(135),
            
        /**
         * Definition for a component (:rmlink:`3.6`).
         *
         * This node type has no derivation.
         */
        COMPONENT_DEF(136),
            
        // CONSTANT_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        CONSTANT_ABSENT(137),
            
        /**
         * This node type has no derivation.
         */
        CONSTANT_PRESENT(138),
            
        // CONSTRAINT is abstract
            
        /**
         * Constraint for a composite type (:rmlink:`3.6.1`). Due to
         * ambiguities in the Ada grammar, this could be either a list of index
         * constraints, if the owning type is an array type, or a list of
         * discriminant constraints, if the owning type is a discriminated
         * record type.
         *
         * This node type has no derivation.
         */
        COMPOSITE_CONSTRAINT(139),
            
        /**
         * Delta and range type constraint (:rmlink:`J.3`).
         *
         * This node type has no derivation.
         */
        DELTA_CONSTRAINT(140),
            
        /**
         * Digits and range type constraint (:rmlink:`3.5.9`).
         *
         * This node type has no derivation.
         */
        DIGITS_CONSTRAINT(141),
            
        /**
         * Range-based type constraint (:rmlink:`3.5`).
         *
         * This node type has no derivation.
         */
        RANGE_CONSTRAINT(142),
            
        /**
         * List of declarations (:rmlink:`3.11`).
         *
         * Derived nodes: ``PrivatePart``, ``PublicPart``
         */
        DECLARATIVE_PART(143),
            
        /**
         * List of declarations in a private part.
         *
         * This node type has no derivation.
         */
        PRIVATE_PART(144),
            
        /**
         * List of declarations in a public part.
         *
         * This node type has no derivation.
         */
        PUBLIC_PART(145),
            
        /**
         * ``elsif`` block, part of an ``if`` expression.
         *
         * This node type has no derivation.
         */
        ELSIF_EXPR_PART(146),
            
        /**
         * ``elsif`` part in an ``if`` statement block.
         *
         * This node type has no derivation.
         */
        ELSIF_STMT_PART(147),
            
        // EXPR is abstract
            
        /**
         * Directly corresponds to the right-hand side of the Abstract_State
         * aspect. Only exists because the RHS of an AspectAssoc must be an
         * expression: the actual logic is in AbstractStateDecl.
         *
         * This node type has no derivation.
         */
        ABSTRACT_STATE_DECL_EXPR(148),
            
        /**
         * Allocator expression (``new ...``) (:rmlink:`4.8`).
         *
         * This node type has no derivation.
         */
        ALLOCATOR(149),
            
        // BASE_AGGREGATE is abstract
            
        /**
         * Aggregate that is not a ``null record`` aggregate (:rmlink:`4.3`).
         *
         * Derived nodes: ``BracketAggregate``
         */
        AGGREGATE(150),
            
        /**
         * Bracket array or container aggregate (Ada 2020, :rmlink:`4.3`).
         *
         * This node type has no derivation.
         */
        BRACKET_AGGREGATE(151),
            
        /**
         * Aggregate for delta aggregate (Ada 2022, :rmlink:`4.3`).
         *
         * Derived nodes: ``BracketDeltaAggregate``
         */
        DELTA_AGGREGATE(152),
            
        /**
         * Bracket delta aggregate (Ada 2020, :rmlink:`4.3`).
         *
         * This node type has no derivation.
         */
        BRACKET_DELTA_AGGREGATE(153),
            
        /**
         * Aggregate for ``null record`` (:rmlink:`4.3`).
         *
         * This node type has no derivation.
         */
        NULL_RECORD_AGGREGATE(154),
            
        /**
         * Binary expression.
         *
         * This encompasses several ARM expressions, because it is used for
         * every binary expression in Ada, all documented in ::rmlink:`4.4`.
         *
         * Derived nodes: ``RelationOp``
         */
        BIN_OP(155),
            
        /**
         * Binary operation that compares two value, producing a boolean
         * (:rmlink:`4.4`).
         *
         * This node type has no derivation.
         */
        RELATION_OP(156),
            
        /**
         * Box expression (``<>``).
         *
         * This is not an expression per-se in Ada, but treating it as one
         * helps us keep coherent types in some cases, like aggregates
         * expressions.
         *
         * This node type has no derivation.
         */
        BOX_EXPR(157),
            
        /**
         * Alternative in a ``case`` expression (``when ... => ...``).
         *
         * This node type has no derivation.
         */
        CASE_EXPR_ALTERNATIVE(158),
            
        /**
         * Concatenation expression.
         *
         * Since concatenation expression can be huge in practice, this node
         * handles them as a list of operands rather than a deep tree of binary
         * operators, in order to avoid crashes while parsing of running name
         * resolution on such huge expression.
         *
         * The purpose of this node is to replace the arbitrarily too deep tree
         * of binary operators (which can lead to a stack overflow), as for
         * example with ``"A & B & C & D & E"``:
         *
         * .. code::
         *
         *    BinOp(
         *      Binop(
         *        BinOp(
         *          BinOp(A, &, B), & , C), &, D), &, E)
         *
         * by a single operator, handling a list of operands that can be
         * processed without having to perform deep recursions:
         *
         * .. code::
         *
         *    ConcatOp(A,
         *      ConcatOperand(&, B),
         *      ConcatOperand(&, C),
         *      ConcatOperand(&, D),
         *      ConcatOperand(&, E))
         *
         * This node type has no derivation.
         */
        CONCAT_OP(159),
            
        /**
         * A concatenation operator and its RHS operand.
         *
         * This node is used to represent the tuple ("&", operand) used by the
         * ``ConcatOp`` node to store its ``other_operands`` list.
         *
         * This node type has no derivation.
         */
        CONCAT_OPERAND(160),
            
        // COND_EXPR is abstract
            
        /**
         * ``case`` expression (:rmlink:`4.5.7`).
         *
         * This node type has no derivation.
         */
        CASE_EXPR(161),
            
        /**
         * ``if`` expression (:rmlink`4.5.7`).
         *
         * This node type has no derivation.
         */
        IF_EXPR(162),
            
        /**
         * List of associations for the ``Contract_Case`` aspect.
         *
         * Contract cases is a non standard Ada extension that's mainly useful
         * in SPARK. See the SPARK RM for more details.
         *
         * This node type has no derivation.
         */
        CONTRACT_CASES(163),
            
        /**
         * Declare expression (Ada 2022, :rmlink:`4.5.9`).
         *
         * This node type has no derivation.
         */
        DECL_EXPR(164),
            
        /**
         * Interpolated string expression.
         *
         * See :gnat_rm:`string-interpolation` for more details.
         *
         * This node type has no derivation.
         */
        FORMAT_STRING_LITERAL(165),
            
        /**
         * Represent a membership test (in/not in operators) (:rmlink:`4.4`).
         *
         * Note that we don't consider them as binary operators since multiple
         * expressions on the right hand side are allowed.
         *
         * This node type has no derivation.
         */
        MEMBERSHIP_EXPR(166),
            
        // NAME is abstract
            
        /**
         * Name for an array subcomponent choice of a deep delta aggregate.
         *
         * This node type has no derivation.
         */
        ARRAY_SUBCOMPONENT_CHOICE_NAME(167),
            
        /**
         * Expression to reference an attribute (:rmlink:`4.1.4`).
         *
         * This node type has no derivation.
         */
        ATTRIBUTE_REF(168),
            
        /**
         * Represent a syntactic call expression.
         *
         * At the semantic level, this can be either a subprogram call, an
         * array subcomponent access expression, an array slice or a type
         * conversion, all described in :rmlink:`4.1`, except for subprogram
         * call statements, described in :rmlink:`6.4`.
         *
         * This node type has no derivation.
         */
        CALL_EXPR(169),
            
        /**
         * Name that defines an entity (:rmlink:`3.1`).
         *
         * Derived nodes: ``SyntheticDefiningName``
         */
        DEFINING_NAME(170),
            
        /**
         * Synthetic DefiningName.
         *
         * This node type has no derivation.
         */
        SYNTHETIC_DEFINING_NAME(171),
            
        /**
         * Subtype name for membership test expressions (:rmlink:`3.6`).
         *
         * This node type has no derivation.
         */
        DISCRETE_SUBTYPE_NAME(172),
            
        /**
         * Name to select a suffix in a prefix (:rmlink:`4.1.3`).
         *
         * This node type has no derivation.
         */
        DOTTED_NAME(173),
            
        /**
         * self name in ``end ...;`` syntactic constructs.
         *
         * This node type has no derivation.
         */
        END_NAME(174),
            
        /**
         * Explicit dereference expression (``.all``) (:rmlink:`4.1`).
         *
         * This node type has no derivation.
         */
        EXPLICIT_DEREF(175),
            
        /**
         * Qualified expression (``...'(...)``) .(:rmlink:`4.7`).
         *
         * This node type has no derivation.
         */
        QUAL_EXPR(176),
            
        /**
         * Reduction expression (``Reduce`` attribute). Ada 2022, RM 4.5.10.
         *
         * This node type has no derivation.
         */
        REDUCE_ATTRIBUTE_REF(177),
            
        // SINGLE_TOK_NODE is abstract
            
        // BASE_ID is abstract
            
        /**
         * Character literal (:rmlink:`4.1`).
         *
         * This node type has no derivation.
         */
        CHAR_LITERAL(178),
            
        /**
         * Regular identifier (:rmlink:`2.3`).
         *
         * This node type has no derivation.
         */
        IDENTIFIER(179),
            
        // OP is abstract
            
        /**
         * This node type has no derivation.
         */
        OP_ABS(180),
            
        /**
         * This node type has no derivation.
         */
        OP_AND(181),
            
        /**
         * This node type has no derivation.
         */
        OP_AND_THEN(182),
            
        /**
         * This node type has no derivation.
         */
        OP_CONCAT(183),
            
        /**
         * This node type has no derivation.
         */
        OP_DIV(184),
            
        /**
         * This node type has no derivation.
         */
        OP_DOUBLE_DOT(185),
            
        /**
         * This node type has no derivation.
         */
        OP_EQ(186),
            
        /**
         * This node type has no derivation.
         */
        OP_GT(187),
            
        /**
         * This node type has no derivation.
         */
        OP_GTE(188),
            
        /**
         * This node type has no derivation.
         */
        OP_IN(189),
            
        /**
         * This node type has no derivation.
         */
        OP_LT(190),
            
        /**
         * This node type has no derivation.
         */
        OP_LTE(191),
            
        /**
         * This node type has no derivation.
         */
        OP_MINUS(192),
            
        /**
         * This node type has no derivation.
         */
        OP_MOD(193),
            
        /**
         * This node type has no derivation.
         */
        OP_MULT(194),
            
        /**
         * This node type has no derivation.
         */
        OP_NEQ(195),
            
        /**
         * This node type has no derivation.
         */
        OP_NOT(196),
            
        /**
         * This node type has no derivation.
         */
        OP_NOT_IN(197),
            
        /**
         * This node type has no derivation.
         */
        OP_OR(198),
            
        /**
         * This node type has no derivation.
         */
        OP_OR_ELSE(199),
            
        /**
         * This node type has no derivation.
         */
        OP_PLUS(200),
            
        /**
         * This node type has no derivation.
         */
        OP_POW(201),
            
        /**
         * This node type has no derivation.
         */
        OP_REM(202),
            
        /**
         * This node type has no derivation.
         */
        OP_XOR(203),
            
        /**
         * String literal (:rmlink:`2.6`).
         *
         * This node type has no derivation.
         */
        STRING_LITERAL(204),
            
        /**
         * The ``null`` literal (:rmlink:`4.4`).
         *
         * This node type has no derivation.
         */
        NULL_LITERAL(205),
            
        // NUM_LITERAL is abstract
            
        /**
         * Literal for an integer (:rmlink:`2.4`).
         *
         * This node type has no derivation.
         */
        INT_LITERAL(206),
            
        /**
         * Literal for a real number (:rmlink:`2.4`).
         *
         * This node type has no derivation.
         */
        REAL_LITERAL(207),
            
        /**
         * Synthetic identifier.
         *
         * This node type has no derivation.
         */
        SYNTHETIC_IDENTIFIER(208),
            
        /**
         * Name for Ada 2020 ``@`` (:rmlink:`5.2.1`).
         *
         * This node type has no derivation.
         */
        TARGET_NAME(209),
            
        /**
         * Reference to the ``Update`` attribute, which is a non standard GNAT
         * attribute.
         *
         * This node type has no derivation.
         */
        UPDATE_ATTRIBUTE_REF(210),
            
        /**
         * Parenthesized expression.
         *
         * This node type has no derivation.
         */
        PAREN_EXPR(211),
            
        /**
         * Quantified expression (:rmlink:`4.5.8`).
         *
         * This node type has no derivation.
         */
        QUANTIFIED_EXPR(212),
            
        /**
         * Expression to raise an exception (:rmlink:`4.4`).
         *
         * This node type has no derivation.
         */
        RAISE_EXPR(213),
            
        /**
         * Unary expression.
         *
         * This encompasses several ARM expressions, because it is used for
         * every unary operator in Ada. Those expressions are all documented in
         * :rmlink:`4.4`.
         *
         * This node type has no derivation.
         */
        UN_OP(214),
            
        /**
         * Represent the ``when ...`` filter after a for loop specification.
         * This class has no RM existence, it is used internally to wrap the
         * filtering expression, so as to have a dedicated name resolution
         * entry point for it and make sure it is resolved separatly from the
         * ``ForLoopSpec`` itself (which it cannot influence anyway).
         *
         * This node type has no derivation.
         */
        FOR_LOOP_ITER_FILTER(215),
            
        /**
         * Chunk of a format string literal.
         *
         * This node type has no derivation.
         */
        FORMAT_STRING_CHUNK(216),
            
        // FORMAT_STRING_TOK_NODE is abstract
            
        /**
         * Node holding a formatting "end" token.
         *
         * This node type has no derivation.
         */
        FORMAT_STRING_TOK_END(217),
            
        /**
         * Node holding a formatting "middle" token.
         *
         * This node type has no derivation.
         */
        FORMAT_STRING_TOK_MID(218),
            
        /**
         * Node holding a formatting "start" token.
         *
         * Derived nodes: ``FormatStringTokString``
         */
        FORMAT_STRING_TOK_START(219),
            
        /**
         * Node holding a formatting "string" token. This token is used when
         * the corresponding interpolated string doesn't have any expression to
         * expand.
         *
         * This node type has no derivation.
         */
        FORMAT_STRING_TOK_STRING(220),
            
        /**
         * List of statements, with optional exception handlers
         * (:rmlink:`11.2`).
         *
         * This node type has no derivation.
         */
        HANDLED_STMTS(221),
            
        // INTERFACE_KIND is abstract
            
        /**
         * This node type has no derivation.
         */
        INTERFACE_KIND_LIMITED(222),
            
        /**
         * This node type has no derivation.
         */
        INTERFACE_KIND_PROTECTED(223),
            
        /**
         * This node type has no derivation.
         */
        INTERFACE_KIND_SYNCHRONIZED(224),
            
        /**
         * This node type has no derivation.
         */
        INTERFACE_KIND_TASK(225),
            
        // ITER_TYPE is abstract
            
        /**
         * This node type has no derivation.
         */
        ITER_TYPE_IN(226),
            
        /**
         * This node type has no derivation.
         */
        ITER_TYPE_OF(227),
            
        /**
         * Library item in a compilation unit (:rmlink:`10.1.1`).
         *
         * This node type has no derivation.
         */
        LIBRARY_ITEM(228),
            
        // LIMITED_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        LIMITED_ABSENT(229),
            
        /**
         * This node type has no derivation.
         */
        LIMITED_PRESENT(230),
            
        // LOOP_SPEC is abstract
            
        /**
         * Specification for a ``for`` loop (:rmlink:`5.5`).
         *
         * This node type has no derivation.
         */
        FOR_LOOP_SPEC(231),
            
        /**
         * Specification for a ``while`` loop (:rmlink:`5.5`).
         *
         * This node type has no derivation.
         */
        WHILE_LOOP_SPEC(232),
            
        // MODE is abstract
            
        /**
         * This node type has no derivation.
         */
        MODE_DEFAULT(233),
            
        /**
         * This node type has no derivation.
         */
        MODE_IN(234),
            
        /**
         * This node type has no derivation.
         */
        MODE_IN_OUT(235),
            
        /**
         * This node type has no derivation.
         */
        MODE_OUT(236),
            
        /**
         * Node that holds several AbstractStateDecl nodes, which is necessary
         * when the Abstract_State aspect is associated with an aggregate in
         * order to declare a list of abstract states.
         *
         * This node type has no derivation.
         */
        MULTI_ABSTRACT_STATE_DECL(237),
            
        // NOT_NULL is abstract
            
        /**
         * This node type has no derivation.
         */
        NOT_NULL_ABSENT(238),
            
        /**
         * This node type has no derivation.
         */
        NOT_NULL_PRESENT(239),
            
        /**
         * Placeholder for the ``null`` in lists of components (:rmlink:`3.8`).
         *
         * This node type has no derivation.
         */
        NULL_COMPONENT_DECL(240),
            
        /**
         * ``other`` designator.
         *
         * This node type has no derivation.
         */
        OTHERS_DESIGNATOR(241),
            
        // OVERRIDING_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        OVERRIDING_NOT_OVERRIDING(242),
            
        /**
         * This node type has no derivation.
         */
        OVERRIDING_OVERRIDING(243),
            
        /**
         * This node type has no derivation.
         */
        OVERRIDING_UNSPECIFIED(244),
            
        /**
         * List of parameter specifications.
         *
         * This node type has no derivation.
         */
        PARAMS(245),
            
        /**
         * Holds an AbstractStateDecl between parentheses. Needed to support
         * the syntax:
         *
         * .. code:: ada
         *
         *    package Pkg
         *        with Abstract_State => (A, (B with Some_Aspect))
         *
         * This node type has no derivation.
         */
        PAREN_ABSTRACT_STATE_DECL(246),
            
        // PP_DIRECTIVE is abstract
            
        /**
         * ``else`` preprocessor directive.
         *
         * This node type has no derivation.
         */
        PP_ELSE_DIRECTIVE(247),
            
        /**
         * ``elsif ... [then]`` preprocessor directive.
         *
         * This node type has no derivation.
         */
        PP_ELSIF_DIRECTIVE(248),
            
        /**
         * ``end if;`` preprocessor directive.
         *
         * This node type has no derivation.
         */
        PP_END_IF_DIRECTIVE(249),
            
        /**
         * ``if ... [then]`` preprocessor directive.
         *
         * This node type has no derivation.
         */
        PP_IF_DIRECTIVE(250),
            
        /**
         * ``then`` keyword in preprocessor directives.
         *
         * This node type has no derivation.
         */
        PP_THEN_KW(251),
            
        /**
         * Class for pragmas (:rmlink:`2.8`). Pragmas are compiler directives,
         * that can be language or compiler defined.
         *
         * This node type has no derivation.
         */
        PRAGMA_NODE(252),
            
        // PRIVATE_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        PRIVATE_ABSENT(253),
            
        /**
         * This node type has no derivation.
         */
        PRIVATE_PRESENT(254),
            
        /**
         * Type definition for a protected object (:rmlink:`9.4`).
         *
         * This node type has no derivation.
         */
        PROTECTED_DEF(255),
            
        // PROTECTED_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        PROTECTED_ABSENT(256),
            
        /**
         * This node type has no derivation.
         */
        PROTECTED_PRESENT(257),
            
        // QUANTIFIER is abstract
            
        /**
         * This node type has no derivation.
         */
        QUANTIFIER_ALL(258),
            
        /**
         * This node type has no derivation.
         */
        QUANTIFIER_SOME(259),
            
        /**
         * Range specification (:rmlink:`3.5.7`).
         *
         * This node type has no derivation.
         */
        RANGE_SPEC(260),
            
        /**
         * Renaming clause, used everywhere renamings are valid.
         *
         * Derived nodes: ``SyntheticRenamingClause``
         */
        RENAMING_CLAUSE(261),
            
        /**
         * Synthetic renaming clause. Used to synthesize object decls with
         * renamings. (See to_anonymous_object_decl).
         *
         * This node type has no derivation.
         */
        SYNTHETIC_RENAMING_CLAUSE(262),
            
        // REVERSE_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        REVERSE_ABSENT(263),
            
        /**
         * This node type has no derivation.
         */
        REVERSE_PRESENT(264),
            
        /**
         * Alternative part in a ``select`` statements block (:rmlink:`9.7`).
         *
         * This node type has no derivation.
         */
        SELECT_WHEN_PART(265),
            
        // STMT is abstract
            
        // COMPOSITE_STMT is abstract
            
        /**
         * ``accept`` statement (:rmlink:`9.5.2`).
         *
         * Derived nodes: ``AcceptStmtWithStmts``
         */
        ACCEPT_STMT(266),
            
        /**
         * Extended ``accept`` statement (:rmlink:`9.5.2`).
         *
         * This node type has no derivation.
         */
        ACCEPT_STMT_WITH_STMTS(267),
            
        // BASE_LOOP_STMT is abstract
            
        /**
         * Statement for ``for`` loops (``for ... loop ... end loop;``)
         * (:rmlink:`5.5`).
         *
         * This node type has no derivation.
         */
        FOR_LOOP_STMT(268),
            
        /**
         * Statement for simple loops (``loop ... end loop;``) (:rmlink:`5.5`).
         *
         * This node type has no derivation.
         */
        LOOP_STMT(269),
            
        /**
         * Statement for ``while`` loops (``while ... loop ... end loop;``)
         * (:rmlink:`5.5`).
         *
         * This node type has no derivation.
         */
        WHILE_LOOP_STMT(270),
            
        // BLOCK_STMT is abstract
            
        /**
         * Statement block with no declarative part (:rmlink:`5.6`).
         *
         * This node type has no derivation.
         */
        BEGIN_BLOCK(271),
            
        /**
         * Statement block with a declarative part (:rmlink:`5.6`).
         *
         * This node type has no derivation.
         */
        DECL_BLOCK(272),
            
        /**
         * ``case`` statement (:rmlink:`5.4`).
         *
         * This node type has no derivation.
         */
        CASE_STMT(273),
            
        /**
         * Extended ``return`` statement (:rmlink:`6.5`).
         *
         * This node type has no derivation.
         */
        EXTENDED_RETURN_STMT(274),
            
        /**
         * ``if`` statement block (:rmlink:`5.3`).
         *
         * This node type has no derivation.
         */
        IF_STMT(275),
            
        /**
         * Wrapper class, used for composite statements that can be named
         * (declare blocks, loops). This allows to both have a BasicDecl for
         * the named entity declared, and a CompositeStmt for the statement
         * hierarchy.
         *
         * This node type has no derivation.
         */
        NAMED_STMT(276),
            
        /**
         * ``select`` statements block (:rmlink:`9.7`).
         *
         * This node type has no derivation.
         */
        SELECT_STMT(277),
            
        /**
         * Placeholder node for syntax errors in lists of statements.
         *
         * This node type has no derivation.
         */
        ERROR_STMT(278),
            
        // SIMPLE_STMT is abstract
            
        /**
         * ``abort`` statement (:rmlink:`9.8`).
         *
         * This node type has no derivation.
         */
        ABORT_STMT(279),
            
        /**
         * Statement for assignments (:rmlink:`5.2`).
         *
         * This node type has no derivation.
         */
        ASSIGN_STMT(280),
            
        /**
         * Statement for entry or procedure calls (:rmlink:`6.4`).
         *
         * This node type has no derivation.
         */
        CALL_STMT(281),
            
        /**
         * ``delay`` statement (:rmlink:`9.6`).
         *
         * This node type has no derivation.
         */
        DELAY_STMT(282),
            
        /**
         * ``exit`` statement (:rmlink:`5.7`).
         *
         * This node type has no derivation.
         */
        EXIT_STMT(283),
            
        /**
         * ``goto`` statement (:rmlink:`5.8`).
         *
         * This node type has no derivation.
         */
        GOTO_STMT(284),
            
        /**
         * Statement to declare a code label (:rmlink:`5.1`).
         *
         * This node type has no derivation.
         */
        LABEL(285),
            
        /**
         * ``null;`` statement (:rmlink:`5.1`).
         *
         * This node type has no derivation.
         */
        NULL_STMT(286),
            
        /**
         * ``raise`` statement (:rmlink:`11.3`).
         *
         * This node type has no derivation.
         */
        RAISE_STMT(287),
            
        /**
         * ``requeue`` statement (:rmlink:`9.5.4`).
         *
         * This node type has no derivation.
         */
        REQUEUE_STMT(288),
            
        /**
         * ``return`` statement (:rmlink:`6.5`).
         *
         * This node type has no derivation.
         */
        RETURN_STMT(289),
            
        /**
         * Statement wrapping a simple object declaration.
         *
         * This node type has no derivation.
         */
        SIMPLE_DECL_STMT(290),
            
        /**
         * ``terminate`` alternative in a ``select`` statement (:rmlink:`9.7`).
         *
         * This node type has no derivation.
         */
        TERMINATE_ALTERNATIVE(291),
            
        // SUBP_KIND is abstract
            
        /**
         * This node type has no derivation.
         */
        SUBP_KIND_FUNCTION(292),
            
        /**
         * This node type has no derivation.
         */
        SUBP_KIND_PROCEDURE(293),
            
        /**
         * Subunit (``separate``) (:rmlink:`10.1.3`).
         *
         * This node type has no derivation.
         */
        SUBUNIT(294),
            
        // SYNCHRONIZED_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        SYNCHRONIZED_ABSENT(295),
            
        /**
         * This node type has no derivation.
         */
        SYNCHRONIZED_PRESENT(296),
            
        // TAGGED_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        TAGGED_ABSENT(297),
            
        /**
         * This node type has no derivation.
         */
        TAGGED_PRESENT(298),
            
        /**
         * Type definition for a task type (:rmlink:`9.1`).
         *
         * This node type has no derivation.
         */
        TASK_DEF(299),
            
        /**
         * Synthetic node that contains the lazy fields for the attribute
         * subprograms of a given type. The lazy fields are not directly on the
         * BaseTypeDecl node itself to minimize its size in memory: with this
         * indirection, a type for which no function attribute is ever
         * synthesized will not waste any memory.
         *
         * This node type has no derivation.
         */
        TYPE_ATTRIBUTES_REPOSITORY(300),
            
        // TYPE_DEF is abstract
            
        // ACCESS_DEF is abstract
            
        /**
         * Type definition for accesses to subprograms (:rmlink:`3.10`).
         *
         * This node type has no derivation.
         */
        ACCESS_TO_SUBP_DEF(301),
            
        // BASE_TYPE_ACCESS_DEF is abstract
            
        /**
         * Synthetic type access, that will directly reference a type decl. It
         * is used to generate synthetic anonymous access types.
         *
         * This node type has no derivation.
         */
        ANONYMOUS_TYPE_ACCESS_DEF(302),
            
        /**
         * Syntactic type definition for accesses.
         *
         * This node type has no derivation.
         */
        TYPE_ACCESS_DEF(303),
            
        /**
         * Type definition for an array (:rmlink:`3.6`).
         *
         * This node type has no derivation.
         */
        ARRAY_TYPE_DEF(304),
            
        /**
         * Type definition for a derived type (:rmlink:`3.4`).
         *
         * This node type has no derivation.
         */
        DERIVED_TYPE_DEF(305),
            
        /**
         * Type definition for enumerations (:rmlink:`3.5.1`).
         *
         * This node type has no derivation.
         */
        ENUM_TYPE_DEF(306),
            
        /**
         * Type definition for discrete types in generic formals
         * (:rmlink:`12.5.2`).
         *
         * This node type has no derivation.
         */
        FORMAL_DISCRETE_TYPE_DEF(307),
            
        /**
         * Type definition for an interface (:rmlink:`3.9.4`).
         *
         * This node type has no derivation.
         */
        INTERFACE_TYPE_DEF(308),
            
        /**
         * Type definition for a modular integer type (:rmlink:`3.5.4`).
         *
         * This node type has no derivation.
         */
        MOD_INT_TYPE_DEF(309),
            
        /**
         * Type definition for a private type.
         *
         * Libadalang diverges from the ARM here, treating private types like
         * regular type declarations that have an embedded type definition.
         * This type definition hence corresponds to :rmlink:`7.3`.
         *
         * This node type has no derivation.
         */
        PRIVATE_TYPE_DEF(310),
            
        // REAL_TYPE_DEF is abstract
            
        /**
         * Type definition for decimal fixed-point numbers (:rmlink:`3.5.9`).
         *
         * This node type has no derivation.
         */
        DECIMAL_FIXED_POINT_DEF(311),
            
        /**
         * Type definition for floating-point numbers (:rmlink:`3.5.7`).
         *
         * This node type has no derivation.
         */
        FLOATING_POINT_DEF(312),
            
        /**
         * Type definition for ordinary fixed-point numbers (:rmlink:`3.5.9`).
         *
         * This node type has no derivation.
         */
        ORDINARY_FIXED_POINT_DEF(313),
            
        /**
         * Type definition for a record (:rmlink:`3.8`).
         *
         * This node type has no derivation.
         */
        RECORD_TYPE_DEF(314),
            
        /**
         * Type definition for a signed integer type (:rmlink:`3.5.4`).
         *
         * This node type has no derivation.
         */
        SIGNED_INT_TYPE_DEF(315),
            
        // TYPE_EXPR is abstract
            
        /**
         * Container for inline anonymous array and access types declarations.
         *
         * This node type has no derivation.
         */
        ANONYMOUS_TYPE(316),
            
        /**
         * Synthetic node. Represents the type expression for an enum literal.
         *
         * This node type has no derivation.
         */
        ENUM_LIT_SYNTH_TYPE_EXPR(317),
            
        /**
         * Reference to a type by name (:rmlink:`3.2.2`).
         *
         * Derived nodes: ``ConstrainedSubtypeIndication``,
         * ``DiscreteSubtypeIndication``
         */
        SUBTYPE_INDICATION(318),
            
        /**
         * Reference to a type with a range constraint.
         *
         * This node type has no derivation.
         */
        CONSTRAINED_SUBTYPE_INDICATION(319),
            
        /**
         * Reference to a type with a general constraint.
         *
         * This node type has no derivation.
         */
        DISCRETE_SUBTYPE_INDICATION(320),
            
        /**
         * Synthetic type expression. The designated type is already known at
         * instantiation time and is to be given in the ``target_type`` field.
         *
         * This node type has no derivation.
         */
        SYNTHETIC_TYPE_EXPR(321),
            
        /**
         * List of unconstrained array indexes.
         *
         * This node type has no derivation.
         */
        UNCONSTRAINED_ARRAY_INDEX(322),
            
        // UNTIL_NODE is abstract
            
        /**
         * This node type has no derivation.
         */
        UNTIL_ABSENT(323),
            
        /**
         * This node type has no derivation.
         */
        UNTIL_PRESENT(324),
            
        // USE_CLAUSE is abstract
            
        /**
         * Use clause for packages (:rmlink:`8.4`).
         *
         * This node type has no derivation.
         */
        USE_PACKAGE_CLAUSE(325),
            
        /**
         * Use clause for types (:rmlink:`8.4`).
         *
         * This node type has no derivation.
         */
        USE_TYPE_CLAUSE(326),
            
        /**
         * The value sequence of a reduction expression (see
         * ``ReduceAttributeRef``). Ada 2022, RM 4.5.10.
         *
         * This node type has no derivation.
         */
        VALUE_SEQUENCE(327),
            
        /**
         * Single variant in a discriminated type record declaration.
         *
         * This corresponds to a ``when ... => ...`` section in a variant part.
         *
         * This node type has no derivation.
         */
        VARIANT(328),
            
        /**
         * Variant part in a discriminated type record declaration
         * (:rmlink:`3.8.1`).
         *
         * This corresponds to the whole ``case ... is ... end case;`` block.
         *
         * This node type has no derivation.
         */
        VARIANT_PART(329),
            
        /**
         * With clause (:rmlink:`10.1.2`).
         *
         * This node type has no derivation.
         */
        WITH_CLAUSE(330),
            
        // WITH_PRIVATE is abstract
            
        /**
         * This node type has no derivation.
         */
        WITH_PRIVATE_ABSENT(331),
            
        /**
         * This node type has no derivation.
         */
        WITH_PRIVATE_PRESENT(332),
        ;

        // ----- Class attributes -----

        /** Map containing relation from node kind value and enum instance. */
        private static final Map<Integer, NodeKind> map = new HashMap<>();

        // ----- Instance attributes -----

        /** Integer value of the node kind. */
        public final int value;

        /** Description associated to the node kind. */
        private Reflection.Node description;

        // ----- Constructors -----

        static {
            // Initialize the lookup map
            for(NodeKind elem : NodeKind.values()) {
                map.put(elem.value, elem);
            }
        }

        /** Private constructor. */
        private NodeKind(
            final int value
        ) {
            this.value = value;

            // The "description" field is intiialized with null to avoid
            // static code execution order issues.
            this.description = null;
        }

        // ----- Class methods -----

        /**
         * Get the enum instance from the given C integer value.
         *
         * @throws EnumException If the given C value is not a valid enum
         *                       value.
         */
        public static NodeKind fromC(
            final int cValue
        ) {
            if(!map.containsKey(cValue))
                throw new EnumException("Cannot get NodeKind from " + cValue);
            return (NodeKind) map.get(cValue);
        }

        // ----- Instance methods -----

        /** Get the C integer value of the enum instance. */
        public int toC() {
            return this.value;
        }

        public Reflection.Node getDescription() {
            return this.description;
        }

        void setDescription(Reflection.Node description) {
            this.description = description;
        }

    }

    /** This enum contains all language nodes' member references */
    public enum MemberReference {

        // ----- Enum values -----

            
        ADA_ASPECT_EXISTS(1),
            
        ADA_ASPECT_NODE(2),
            
        ADA_ASPECT_VALUE(3),
            
        ADA_ASPECT_INHERITED(4),
            
        ADA_COMPLETION_ITEM_DECL(5),
            
        ADA_COMPLETION_ITEM_IS_DOT_CALL(6),
            
        ADA_COMPLETION_ITEM_IS_VISIBLE(7),
            
        ADA_COMPLETION_ITEM_WEIGHT(8),
            
        ADA_DISCRETE_RANGE_LOW_BOUND(9),
            
        ADA_DISCRETE_RANGE_HIGH_BOUND(10),
            
        ADA_DISCRIMINANT_VALUES_DISCRIMINANT(11),
            
        ADA_DISCRIMINANT_VALUES_VALUES(12),
            
        ADA_DOC_ANNOTATION_KEY(13),
            
        ADA_DOC_ANNOTATION_VALUE(14),
            
        ADA_LOGIC_CONTEXT_REF_NODE(15),
            
        ADA_LOGIC_CONTEXT_DECL_NODE(16),
            
        ADA_PARAM_ACTUAL_PARAM(17),
            
        ADA_PARAM_ACTUAL_ACTUAL(18),
            
        ADA_REF_RESULT_REF(19),
            
        ADA_REF_RESULT_KIND(20),
            
        ADA_REFD_DECL_DECL(21),
            
        ADA_REFD_DECL_KIND(22),
            
        ADA_REFD_DEF_DEF_NAME(23),
            
        ADA_REFD_DEF_KIND(24),
            
        ADA_SHAPE_COMPONENTS(25),
            
        ADA_SHAPE_DISCRIMINANTS_VALUES(26),
            
        ADA_SOLVER_DIAGNOSTIC_MESSAGE_TEMPLATE(27),
            
        ADA_SOLVER_DIAGNOSTIC_ARGS(28),
            
        ADA_SOLVER_DIAGNOSTIC_LOCATION(29),
            
        ADA_SOLVER_DIAGNOSTIC_CONTEXTS(30),
            
        ADA_SOLVER_DIAGNOSTIC_ROUND(31),
            
        ADA_SUBSTITUTION_FROM_DECL(32),
            
        ADA_SUBSTITUTION_TO_VALUE(33),
            
        ADA_SUBSTITUTION_VALUE_TYPE(34),
            
        ADA_CONSTRAINED_ARRAY_INDICES_F_LIST(35),
            
        ADA_UNCONSTRAINED_ARRAY_INDICES_F_TYPES(36),
            
        ADA_ASPECT_ASSOC_F_ID(37),
            
        ADA_ASPECT_ASSOC_F_EXPR(38),
            
        ADA_AT_CLAUSE_F_NAME(39),
            
        ADA_AT_CLAUSE_F_EXPR(40),
            
        ADA_ATTRIBUTE_DEF_CLAUSE_F_ATTRIBUTE_EXPR(41),
            
        ADA_ATTRIBUTE_DEF_CLAUSE_F_EXPR(42),
            
        ADA_ENUM_REP_CLAUSE_F_TYPE_NAME(43),
            
        ADA_ENUM_REP_CLAUSE_F_AGGREGATE(44),
            
        ADA_RECORD_REP_CLAUSE_F_NAME(45),
            
        ADA_RECORD_REP_CLAUSE_F_AT_EXPR(46),
            
        ADA_RECORD_REP_CLAUSE_F_COMPONENTS(47),
            
        ADA_ASPECT_SPEC_F_ASPECT_ASSOCS(48),
            
        ADA_CONTRACT_CASE_ASSOC_F_GUARD(49),
            
        ADA_CONTRACT_CASE_ASSOC_F_CONSEQUENCE(50),
            
        ADA_PRAGMA_ARGUMENT_ASSOC_F_NAME(51),
            
        ADA_PRAGMA_ARGUMENT_ASSOC_F_EXPR(52),
            
        ADA_ENTRY_SPEC_F_ENTRY_NAME(53),
            
        ADA_ENTRY_SPEC_F_FAMILY_TYPE(54),
            
        ADA_ENTRY_SPEC_F_ENTRY_PARAMS(55),
            
        ADA_SUBP_SPEC_F_SUBP_KIND(56),
            
        ADA_SUBP_SPEC_F_SUBP_NAME(57),
            
        ADA_SUBP_SPEC_F_SUBP_PARAMS(58),
            
        ADA_SUBP_SPEC_F_SUBP_RETURNS(59),
            
        ADA_SYNTHETIC_BINARY_SPEC_F_LEFT_PARAM(60),
            
        ADA_SYNTHETIC_BINARY_SPEC_F_RIGHT_PARAM(61),
            
        ADA_SYNTHETIC_BINARY_SPEC_F_RETURN_TYPE_EXPR(62),
            
        ADA_SYNTHETIC_UNARY_SPEC_F_RIGHT_PARAM(63),
            
        ADA_SYNTHETIC_UNARY_SPEC_F_RETURN_TYPE_EXPR(64),
            
        ADA_COMPONENT_LIST_F_COMPONENTS(65),
            
        ADA_COMPONENT_LIST_F_VARIANT_PART(66),
            
        ADA_KNOWN_DISCRIMINANT_PART_F_DISCR_SPECS(67),
            
        ADA_ENTRY_COMPLETION_FORMAL_PARAMS_F_PARAMS(68),
            
        ADA_GENERIC_FORMAL_PART_F_DECLS(69),
            
        ADA_BASE_RECORD_DEF_F_COMPONENTS(70),
            
        ADA_AGGREGATE_ASSOC_F_DESIGNATORS(71),
            
        ADA_AGGREGATE_ASSOC_F_R_EXPR(72),
            
        ADA_COMPOSITE_CONSTRAINT_ASSOC_F_IDS(73),
            
        ADA_COMPOSITE_CONSTRAINT_ASSOC_F_CONSTRAINT_EXPR(74),
            
        ADA_ITERATED_ASSOC_F_SPEC(75),
            
        ADA_ITERATED_ASSOC_F_KEY_EXPR(76),
            
        ADA_ITERATED_ASSOC_F_R_EXPR(77),
            
        ADA_PARAM_ASSOC_F_DESIGNATOR(78),
            
        ADA_PARAM_ASSOC_F_R_EXPR(79),
            
        ADA_BASIC_DECL_F_ASPECTS(80),
            
        ADA_ABSTRACT_STATE_DECL_F_NAME(81),
            
        ADA_ANONYMOUS_EXPR_DECL_F_EXPR(82),
            
        ADA_COMPONENT_DECL_F_IDS(83),
            
        ADA_COMPONENT_DECL_F_COMPONENT_DEF(84),
            
        ADA_COMPONENT_DECL_F_DEFAULT_EXPR(85),
            
        ADA_DISCRIMINANT_SPEC_F_IDS(86),
            
        ADA_DISCRIMINANT_SPEC_F_TYPE_EXPR(87),
            
        ADA_DISCRIMINANT_SPEC_F_DEFAULT_EXPR(88),
            
        ADA_GENERIC_FORMAL_F_DECL(89),
            
        ADA_PARAM_SPEC_F_IDS(90),
            
        ADA_PARAM_SPEC_F_HAS_ALIASED(91),
            
        ADA_PARAM_SPEC_F_MODE(92),
            
        ADA_PARAM_SPEC_F_TYPE_EXPR(93),
            
        ADA_PARAM_SPEC_F_DEFAULT_EXPR(94),
            
        ADA_SYNTHETIC_FORMAL_PARAM_DECL_F_PARAM_TYPE(95),
            
        ADA_BASE_PACKAGE_DECL_F_PACKAGE_NAME(96),
            
        ADA_BASE_PACKAGE_DECL_F_PUBLIC_PART(97),
            
        ADA_BASE_PACKAGE_DECL_F_PRIVATE_PART(98),
            
        ADA_BASE_PACKAGE_DECL_F_END_NAME(99),
            
        ADA_BASE_TYPE_DECL_F_NAME(100),
            
        ADA_SUBTYPE_DECL_F_SUBTYPE(101),
            
        ADA_INCOMPLETE_TYPE_DECL_F_DISCRIMINANTS(102),
            
        ADA_INCOMPLETE_FORMAL_TYPE_DECL_F_IS_TAGGED(103),
            
        ADA_INCOMPLETE_FORMAL_TYPE_DECL_F_DEFAULT_TYPE(104),
            
        ADA_INCOMPLETE_TAGGED_TYPE_DECL_F_HAS_ABSTRACT(105),
            
        ADA_PROTECTED_TYPE_DECL_F_DISCRIMINANTS(106),
            
        ADA_PROTECTED_TYPE_DECL_F_INTERFACES(107),
            
        ADA_PROTECTED_TYPE_DECL_F_DEFINITION(108),
            
        ADA_TASK_TYPE_DECL_F_DISCRIMINANTS(109),
            
        ADA_TASK_TYPE_DECL_F_DEFINITION(110),
            
        ADA_TYPE_DECL_F_DISCRIMINANTS(111),
            
        ADA_TYPE_DECL_F_TYPE_DEF(112),
            
        ADA_FORMAL_TYPE_DECL_F_DEFAULT_TYPE(113),
            
        ADA_CLASSIC_SUBP_DECL_F_OVERRIDING(114),
            
        ADA_CLASSIC_SUBP_DECL_F_SUBP_SPEC(115),
            
        ADA_FORMAL_SUBP_DECL_F_DEFAULT_EXPR(116),
            
        ADA_ENTRY_DECL_F_OVERRIDING(117),
            
        ADA_ENTRY_DECL_F_SPEC(118),
            
        ADA_ENUM_LITERAL_DECL_F_NAME(119),
            
        ADA_GENERIC_SUBP_INTERNAL_F_SUBP_SPEC(120),
            
        ADA_SYNTHETIC_SUBP_DECL_F_SPEC(121),
            
        ADA_ACCEPT_STMT_BODY_F_NAME(122),
            
        ADA_BASE_SUBP_BODY_F_OVERRIDING(123),
            
        ADA_BASE_SUBP_BODY_F_SUBP_SPEC(124),
            
        ADA_EXPR_FUNCTION_F_EXPR(125),
            
        ADA_SUBP_BODY_F_DECLS(126),
            
        ADA_SUBP_BODY_F_STMTS(127),
            
        ADA_SUBP_BODY_F_END_NAME(128),
            
        ADA_SUBP_RENAMING_DECL_F_RENAMES(129),
            
        ADA_PACKAGE_BODY_STUB_F_NAME(130),
            
        ADA_PROTECTED_BODY_STUB_F_NAME(131),
            
        ADA_SUBP_BODY_STUB_F_OVERRIDING(132),
            
        ADA_SUBP_BODY_STUB_F_SUBP_SPEC(133),
            
        ADA_TASK_BODY_STUB_F_NAME(134),
            
        ADA_ENTRY_BODY_F_ENTRY_NAME(135),
            
        ADA_ENTRY_BODY_F_INDEX_SPEC(136),
            
        ADA_ENTRY_BODY_F_PARAMS(137),
            
        ADA_ENTRY_BODY_F_BARRIER(138),
            
        ADA_ENTRY_BODY_F_DECLS(139),
            
        ADA_ENTRY_BODY_F_STMTS(140),
            
        ADA_ENTRY_BODY_F_END_NAME(141),
            
        ADA_PACKAGE_BODY_F_PACKAGE_NAME(142),
            
        ADA_PACKAGE_BODY_F_DECLS(143),
            
        ADA_PACKAGE_BODY_F_STMTS(144),
            
        ADA_PACKAGE_BODY_F_END_NAME(145),
            
        ADA_PROTECTED_BODY_F_NAME(146),
            
        ADA_PROTECTED_BODY_F_DECLS(147),
            
        ADA_PROTECTED_BODY_F_END_NAME(148),
            
        ADA_TASK_BODY_F_NAME(149),
            
        ADA_TASK_BODY_F_DECLS(150),
            
        ADA_TASK_BODY_F_STMTS(151),
            
        ADA_TASK_BODY_F_END_NAME(152),
            
        ADA_ENTRY_INDEX_SPEC_F_ID(153),
            
        ADA_ENTRY_INDEX_SPEC_F_SUBTYPE(154),
            
        ADA_EXCEPTION_DECL_F_IDS(155),
            
        ADA_EXCEPTION_DECL_F_RENAMES(156),
            
        ADA_EXCEPTION_HANDLER_F_EXCEPTION_NAME(157),
            
        ADA_EXCEPTION_HANDLER_F_HANDLED_EXCEPTIONS(158),
            
        ADA_EXCEPTION_HANDLER_F_STMTS(159),
            
        ADA_FOR_LOOP_VAR_DECL_F_ID(160),
            
        ADA_FOR_LOOP_VAR_DECL_F_ID_TYPE(161),
            
        ADA_GENERIC_DECL_F_FORMAL_PART(162),
            
        ADA_GENERIC_PACKAGE_DECL_F_PACKAGE_DECL(163),
            
        ADA_GENERIC_SUBP_DECL_F_SUBP_DECL(164),
            
        ADA_GENERIC_PACKAGE_INSTANTIATION_F_NAME(165),
            
        ADA_GENERIC_PACKAGE_INSTANTIATION_F_GENERIC_PKG_NAME(166),
            
        ADA_GENERIC_PACKAGE_INSTANTIATION_F_PARAMS(167),
            
        ADA_GENERIC_SUBP_INSTANTIATION_F_OVERRIDING(168),
            
        ADA_GENERIC_SUBP_INSTANTIATION_F_KIND(169),
            
        ADA_GENERIC_SUBP_INSTANTIATION_F_SUBP_NAME(170),
            
        ADA_GENERIC_SUBP_INSTANTIATION_F_GENERIC_SUBP_NAME(171),
            
        ADA_GENERIC_SUBP_INSTANTIATION_F_PARAMS(172),
            
        ADA_GENERIC_PACKAGE_RENAMING_DECL_F_NAME(173),
            
        ADA_GENERIC_PACKAGE_RENAMING_DECL_F_RENAMES(174),
            
        ADA_GENERIC_SUBP_RENAMING_DECL_F_KIND(175),
            
        ADA_GENERIC_SUBP_RENAMING_DECL_F_NAME(176),
            
        ADA_GENERIC_SUBP_RENAMING_DECL_F_RENAMES(177),
            
        ADA_LABEL_DECL_F_NAME(178),
            
        ADA_NAMED_STMT_DECL_F_NAME(179),
            
        ADA_NUMBER_DECL_F_IDS(180),
            
        ADA_NUMBER_DECL_F_EXPR(181),
            
        ADA_OBJECT_DECL_F_IDS(182),
            
        ADA_OBJECT_DECL_F_HAS_ALIASED(183),
            
        ADA_OBJECT_DECL_F_HAS_CONSTANT(184),
            
        ADA_OBJECT_DECL_F_MODE(185),
            
        ADA_OBJECT_DECL_F_TYPE_EXPR(186),
            
        ADA_OBJECT_DECL_F_DEFAULT_EXPR(187),
            
        ADA_OBJECT_DECL_F_RENAMING_CLAUSE(188),
            
        ADA_PACKAGE_RENAMING_DECL_F_NAME(189),
            
        ADA_PACKAGE_RENAMING_DECL_F_RENAMES(190),
            
        ADA_SINGLE_PROTECTED_DECL_F_NAME(191),
            
        ADA_SINGLE_PROTECTED_DECL_F_INTERFACES(192),
            
        ADA_SINGLE_PROTECTED_DECL_F_DEFINITION(193),
            
        ADA_SINGLE_TASK_DECL_F_TASK_TYPE(194),
            
        ADA_CASE_STMT_ALTERNATIVE_F_CHOICES(195),
            
        ADA_CASE_STMT_ALTERNATIVE_F_STMTS(196),
            
        ADA_COMPILATION_UNIT_F_PRELUDE(197),
            
        ADA_COMPILATION_UNIT_F_BODY(198),
            
        ADA_COMPILATION_UNIT_F_PRAGMAS(199),
            
        ADA_COMPONENT_CLAUSE_F_ID(200),
            
        ADA_COMPONENT_CLAUSE_F_POSITION(201),
            
        ADA_COMPONENT_CLAUSE_F_RANGE(202),
            
        ADA_COMPONENT_DEF_F_HAS_ALIASED(203),
            
        ADA_COMPONENT_DEF_F_HAS_CONSTANT(204),
            
        ADA_COMPONENT_DEF_F_TYPE_EXPR(205),
            
        ADA_COMPOSITE_CONSTRAINT_F_CONSTRAINTS(206),
            
        ADA_DELTA_CONSTRAINT_F_DELTA(207),
            
        ADA_DELTA_CONSTRAINT_F_RANGE(208),
            
        ADA_DIGITS_CONSTRAINT_F_DIGITS(209),
            
        ADA_DIGITS_CONSTRAINT_F_RANGE(210),
            
        ADA_RANGE_CONSTRAINT_F_RANGE(211),
            
        ADA_DECLARATIVE_PART_F_DECLS(212),
            
        ADA_ELSIF_EXPR_PART_F_COND_EXPR(213),
            
        ADA_ELSIF_EXPR_PART_F_THEN_EXPR(214),
            
        ADA_ELSIF_STMT_PART_F_COND_EXPR(215),
            
        ADA_ELSIF_STMT_PART_F_STMTS(216),
            
        ADA_ABSTRACT_STATE_DECL_EXPR_F_STATE_DECL(217),
            
        ADA_ALLOCATOR_F_SUBPOOL(218),
            
        ADA_ALLOCATOR_F_TYPE_OR_EXPR(219),
            
        ADA_BASE_AGGREGATE_F_ANCESTOR_EXPR(220),
            
        ADA_BASE_AGGREGATE_F_ASSOCS(221),
            
        ADA_BIN_OP_F_LEFT(222),
            
        ADA_BIN_OP_F_OP(223),
            
        ADA_BIN_OP_F_RIGHT(224),
            
        ADA_CASE_EXPR_ALTERNATIVE_F_CHOICES(225),
            
        ADA_CASE_EXPR_ALTERNATIVE_F_EXPR(226),
            
        ADA_CONCAT_OP_F_FIRST_OPERAND(227),
            
        ADA_CONCAT_OP_F_OTHER_OPERANDS(228),
            
        ADA_CONCAT_OPERAND_F_OPERATOR(229),
            
        ADA_CONCAT_OPERAND_F_OPERAND(230),
            
        ADA_CASE_EXPR_F_EXPR(231),
            
        ADA_CASE_EXPR_F_CASES(232),
            
        ADA_IF_EXPR_F_COND_EXPR(233),
            
        ADA_IF_EXPR_F_THEN_EXPR(234),
            
        ADA_IF_EXPR_F_ALTERNATIVES(235),
            
        ADA_IF_EXPR_F_ELSE_EXPR(236),
            
        ADA_CONTRACT_CASES_F_CONTRACT_CASES(237),
            
        ADA_DECL_EXPR_F_DECLS(238),
            
        ADA_DECL_EXPR_F_EXPR(239),
            
        ADA_FORMAT_STRING_LITERAL_F_OPENING_CHUNK(240),
            
        ADA_FORMAT_STRING_LITERAL_F_MID_EXPRS(241),
            
        ADA_FORMAT_STRING_LITERAL_F_TRAILING_EXPR(242),
            
        ADA_MEMBERSHIP_EXPR_F_EXPR(243),
            
        ADA_MEMBERSHIP_EXPR_F_OP(244),
            
        ADA_MEMBERSHIP_EXPR_F_MEMBERSHIP_EXPRS(245),
            
        ADA_ARRAY_SUBCOMPONENT_CHOICE_NAME_F_NAME(246),
            
        ADA_ARRAY_SUBCOMPONENT_CHOICE_NAME_F_SUFFIX(247),
            
        ADA_ATTRIBUTE_REF_F_PREFIX(248),
            
        ADA_ATTRIBUTE_REF_F_ATTRIBUTE(249),
            
        ADA_ATTRIBUTE_REF_F_ARGS(250),
            
        ADA_CALL_EXPR_F_NAME(251),
            
        ADA_CALL_EXPR_F_SUFFIX(252),
            
        ADA_DEFINING_NAME_F_NAME(253),
            
        ADA_DISCRETE_SUBTYPE_NAME_F_SUBTYPE(254),
            
        ADA_DOTTED_NAME_F_PREFIX(255),
            
        ADA_DOTTED_NAME_F_SUFFIX(256),
            
        ADA_END_NAME_F_NAME(257),
            
        ADA_EXPLICIT_DEREF_F_PREFIX(258),
            
        ADA_QUAL_EXPR_F_PREFIX(259),
            
        ADA_QUAL_EXPR_F_SUFFIX(260),
            
        ADA_REDUCE_ATTRIBUTE_REF_F_PREFIX(261),
            
        ADA_REDUCE_ATTRIBUTE_REF_F_ATTRIBUTE(262),
            
        ADA_REDUCE_ATTRIBUTE_REF_F_ARGS(263),
            
        ADA_UPDATE_ATTRIBUTE_REF_F_PREFIX(264),
            
        ADA_UPDATE_ATTRIBUTE_REF_F_ATTRIBUTE(265),
            
        ADA_UPDATE_ATTRIBUTE_REF_F_VALUES(266),
            
        ADA_PAREN_EXPR_F_EXPR(267),
            
        ADA_QUANTIFIED_EXPR_F_QUANTIFIER(268),
            
        ADA_QUANTIFIED_EXPR_F_LOOP_SPEC(269),
            
        ADA_QUANTIFIED_EXPR_F_EXPR(270),
            
        ADA_RAISE_EXPR_F_EXCEPTION_NAME(271),
            
        ADA_RAISE_EXPR_F_ERROR_MESSAGE(272),
            
        ADA_UN_OP_F_OP(273),
            
        ADA_UN_OP_F_EXPR(274),
            
        ADA_FOR_LOOP_ITER_FILTER_F_EXPR(275),
            
        ADA_FORMAT_STRING_CHUNK_F_EXPR(276),
            
        ADA_FORMAT_STRING_CHUNK_F_STRING_TOK(277),
            
        ADA_HANDLED_STMTS_F_STMTS(278),
            
        ADA_HANDLED_STMTS_F_EXCEPTIONS(279),
            
        ADA_LIBRARY_ITEM_F_HAS_PRIVATE(280),
            
        ADA_LIBRARY_ITEM_F_ITEM(281),
            
        ADA_FOR_LOOP_SPEC_F_VAR_DECL(282),
            
        ADA_FOR_LOOP_SPEC_F_LOOP_TYPE(283),
            
        ADA_FOR_LOOP_SPEC_F_HAS_REVERSE(284),
            
        ADA_FOR_LOOP_SPEC_F_ITER_EXPR(285),
            
        ADA_FOR_LOOP_SPEC_F_ITER_FILTER(286),
            
        ADA_WHILE_LOOP_SPEC_F_EXPR(287),
            
        ADA_MULTI_ABSTRACT_STATE_DECL_F_DECLS(288),
            
        ADA_PARAMS_F_PARAMS(289),
            
        ADA_PAREN_ABSTRACT_STATE_DECL_F_DECL(290),
            
        ADA_PP_ELSIF_DIRECTIVE_F_EXPR(291),
            
        ADA_PP_ELSIF_DIRECTIVE_F_THEN_KW(292),
            
        ADA_PP_IF_DIRECTIVE_F_EXPR(293),
            
        ADA_PP_IF_DIRECTIVE_F_THEN_KW(294),
            
        ADA_PRAGMA_NODE_F_ID(295),
            
        ADA_PRAGMA_NODE_F_ARGS(296),
            
        ADA_PROTECTED_DEF_F_PUBLIC_PART(297),
            
        ADA_PROTECTED_DEF_F_PRIVATE_PART(298),
            
        ADA_PROTECTED_DEF_F_END_NAME(299),
            
        ADA_RANGE_SPEC_F_RANGE(300),
            
        ADA_RENAMING_CLAUSE_F_RENAMED_OBJECT(301),
            
        ADA_SELECT_WHEN_PART_F_COND_EXPR(302),
            
        ADA_SELECT_WHEN_PART_F_STMTS(303),
            
        ADA_ACCEPT_STMT_F_BODY_DECL(304),
            
        ADA_ACCEPT_STMT_F_ENTRY_INDEX_EXPR(305),
            
        ADA_ACCEPT_STMT_F_PARAMS(306),
            
        ADA_ACCEPT_STMT_WITH_STMTS_F_STMTS(307),
            
        ADA_ACCEPT_STMT_WITH_STMTS_F_END_NAME(308),
            
        ADA_BASE_LOOP_STMT_F_SPEC(309),
            
        ADA_BASE_LOOP_STMT_F_STMTS(310),
            
        ADA_BASE_LOOP_STMT_F_END_NAME(311),
            
        ADA_BEGIN_BLOCK_F_STMTS(312),
            
        ADA_BEGIN_BLOCK_F_END_NAME(313),
            
        ADA_DECL_BLOCK_F_DECLS(314),
            
        ADA_DECL_BLOCK_F_STMTS(315),
            
        ADA_DECL_BLOCK_F_END_NAME(316),
            
        ADA_CASE_STMT_F_EXPR(317),
            
        ADA_CASE_STMT_F_PRAGMAS(318),
            
        ADA_CASE_STMT_F_ALTERNATIVES(319),
            
        ADA_EXTENDED_RETURN_STMT_F_DECL(320),
            
        ADA_EXTENDED_RETURN_STMT_F_STMTS(321),
            
        ADA_IF_STMT_F_COND_EXPR(322),
            
        ADA_IF_STMT_F_THEN_STMTS(323),
            
        ADA_IF_STMT_F_ALTERNATIVES(324),
            
        ADA_IF_STMT_F_ELSE_STMTS(325),
            
        ADA_NAMED_STMT_F_DECL(326),
            
        ADA_NAMED_STMT_F_STMT(327),
            
        ADA_SELECT_STMT_F_GUARDS(328),
            
        ADA_SELECT_STMT_F_ELSE_STMTS(329),
            
        ADA_SELECT_STMT_F_ABORT_STMTS(330),
            
        ADA_ABORT_STMT_F_NAMES(331),
            
        ADA_ASSIGN_STMT_F_DEST(332),
            
        ADA_ASSIGN_STMT_F_EXPR(333),
            
        ADA_CALL_STMT_F_CALL(334),
            
        ADA_DELAY_STMT_F_HAS_UNTIL(335),
            
        ADA_DELAY_STMT_F_EXPR(336),
            
        ADA_EXIT_STMT_F_LOOP_NAME(337),
            
        ADA_EXIT_STMT_F_COND_EXPR(338),
            
        ADA_GOTO_STMT_F_LABEL_NAME(339),
            
        ADA_LABEL_F_DECL(340),
            
        ADA_RAISE_STMT_F_EXCEPTION_NAME(341),
            
        ADA_RAISE_STMT_F_ERROR_MESSAGE(342),
            
        ADA_REQUEUE_STMT_F_CALL_NAME(343),
            
        ADA_REQUEUE_STMT_F_HAS_ABORT(344),
            
        ADA_RETURN_STMT_F_RETURN_EXPR(345),
            
        ADA_SIMPLE_DECL_STMT_F_DECL(346),
            
        ADA_SUBUNIT_F_NAME(347),
            
        ADA_SUBUNIT_F_BODY(348),
            
        ADA_TASK_DEF_F_INTERFACES(349),
            
        ADA_TASK_DEF_F_PUBLIC_PART(350),
            
        ADA_TASK_DEF_F_PRIVATE_PART(351),
            
        ADA_TASK_DEF_F_END_NAME(352),
            
        ADA_ACCESS_DEF_F_HAS_NOT_NULL(353),
            
        ADA_ACCESS_TO_SUBP_DEF_F_HAS_PROTECTED(354),
            
        ADA_ACCESS_TO_SUBP_DEF_F_SUBP_SPEC(355),
            
        ADA_ANONYMOUS_TYPE_ACCESS_DEF_F_TYPE_DECL(356),
            
        ADA_TYPE_ACCESS_DEF_F_HAS_ALL(357),
            
        ADA_TYPE_ACCESS_DEF_F_HAS_CONSTANT(358),
            
        ADA_TYPE_ACCESS_DEF_F_SUBTYPE_INDICATION(359),
            
        ADA_ARRAY_TYPE_DEF_F_INDICES(360),
            
        ADA_ARRAY_TYPE_DEF_F_COMPONENT_TYPE(361),
            
        ADA_DERIVED_TYPE_DEF_F_HAS_ABSTRACT(362),
            
        ADA_DERIVED_TYPE_DEF_F_HAS_LIMITED(363),
            
        ADA_DERIVED_TYPE_DEF_F_HAS_SYNCHRONIZED(364),
            
        ADA_DERIVED_TYPE_DEF_F_SUBTYPE_INDICATION(365),
            
        ADA_DERIVED_TYPE_DEF_F_INTERFACES(366),
            
        ADA_DERIVED_TYPE_DEF_F_RECORD_EXTENSION(367),
            
        ADA_DERIVED_TYPE_DEF_F_HAS_WITH_PRIVATE(368),
            
        ADA_ENUM_TYPE_DEF_F_ENUM_LITERALS(369),
            
        ADA_INTERFACE_TYPE_DEF_F_INTERFACE_KIND(370),
            
        ADA_INTERFACE_TYPE_DEF_F_INTERFACES(371),
            
        ADA_MOD_INT_TYPE_DEF_F_EXPR(372),
            
        ADA_PRIVATE_TYPE_DEF_F_HAS_ABSTRACT(373),
            
        ADA_PRIVATE_TYPE_DEF_F_HAS_TAGGED(374),
            
        ADA_PRIVATE_TYPE_DEF_F_HAS_LIMITED(375),
            
        ADA_DECIMAL_FIXED_POINT_DEF_F_DELTA(376),
            
        ADA_DECIMAL_FIXED_POINT_DEF_F_DIGITS(377),
            
        ADA_DECIMAL_FIXED_POINT_DEF_F_RANGE(378),
            
        ADA_FLOATING_POINT_DEF_F_NUM_DIGITS(379),
            
        ADA_FLOATING_POINT_DEF_F_RANGE(380),
            
        ADA_ORDINARY_FIXED_POINT_DEF_F_DELTA(381),
            
        ADA_ORDINARY_FIXED_POINT_DEF_F_RANGE(382),
            
        ADA_RECORD_TYPE_DEF_F_HAS_ABSTRACT(383),
            
        ADA_RECORD_TYPE_DEF_F_HAS_TAGGED(384),
            
        ADA_RECORD_TYPE_DEF_F_HAS_LIMITED(385),
            
        ADA_RECORD_TYPE_DEF_F_RECORD_DEF(386),
            
        ADA_SIGNED_INT_TYPE_DEF_F_RANGE(387),
            
        ADA_ANONYMOUS_TYPE_F_TYPE_DECL(388),
            
        ADA_SUBTYPE_INDICATION_F_HAS_NOT_NULL(389),
            
        ADA_SUBTYPE_INDICATION_F_NAME(390),
            
        ADA_SUBTYPE_INDICATION_F_CONSTRAINT(391),
            
        ADA_SYNTHETIC_TYPE_EXPR_F_TARGET_TYPE(392),
            
        ADA_UNCONSTRAINED_ARRAY_INDEX_F_SUBTYPE_NAME(393),
            
        ADA_UNCONSTRAINED_ARRAY_INDEX_F_LOWER_BOUND(394),
            
        ADA_USE_PACKAGE_CLAUSE_F_PACKAGES(395),
            
        ADA_USE_TYPE_CLAUSE_F_HAS_ALL(396),
            
        ADA_USE_TYPE_CLAUSE_F_TYPES(397),
            
        ADA_VALUE_SEQUENCE_F_ITER_ASSOC(398),
            
        ADA_VARIANT_F_CHOICES(399),
            
        ADA_VARIANT_F_COMPONENTS(400),
            
        ADA_VARIANT_PART_F_DISCR_NAME(401),
            
        ADA_VARIANT_PART_F_VARIANT(402),
            
        ADA_WITH_CLAUSE_F_HAS_LIMITED(403),
            
        ADA_WITH_CLAUSE_F_HAS_PRIVATE(404),
            
        ADA_WITH_CLAUSE_F_PACKAGES(405),
            
        ADA_ADA_NODE_P_DECLARATIVE_SCOPE(406),
            
        ADA_ADA_NODE_P_ENCLOSING_COMPILATION_UNIT(407),
            
        ADA_ADA_NODE_P_GET_UNINSTANTIATED_NODE(408),
            
        ADA_ADA_NODE_P_COMPLETE(409),
            
        ADA_ADA_NODE_P_VALID_KEYWORDS(410),
            
        ADA_ADA_NODE_P_GENERIC_INSTANTIATIONS(411),
            
        ADA_ADA_NODE_P_SEMANTIC_PARENT(412),
            
        ADA_ADA_NODE_P_PARENT_BASIC_DECL(413),
            
        ADA_ADA_NODE_P_HAS_SPARK_MODE_ON(414),
            
        ADA_ADA_NODE_P_IS_SUBJECT_TO_PROOF(415),
            
        ADA_ADA_NODE_P_FILTER_IS_IMPORTED_BY(416),
            
        ADA_ADA_NODE_P_RESOLVE_NAMES(417),
            
        ADA_ADA_NODE_P_NAMERES_DIAGNOSTICS(418),
            
        ADA_ADA_NODE_P_STANDARD_UNIT(419),
            
        ADA_ADA_NODE_P_IS_KEYWORD(420),
            
        ADA_ADA_NODE_P_STD_ENTITY(421),
            
        ADA_ADA_NODE_P_BOOL_TYPE(422),
            
        ADA_ADA_NODE_P_INT_TYPE(423),
            
        ADA_ADA_NODE_P_UNIVERSAL_INT_TYPE(424),
            
        ADA_ADA_NODE_P_UNIVERSAL_REAL_TYPE(425),
            
        ADA_ADA_NODE_P_STD_CHAR_TYPE(426),
            
        ADA_ADA_NODE_P_STD_WIDE_CHAR_TYPE(427),
            
        ADA_ADA_NODE_P_STD_WIDE_WIDE_CHAR_TYPE(428),
            
        ADA_ADA_NODE_P_STD_STRING_TYPE(429),
            
        ADA_ADA_NODE_P_STD_WIDE_STRING_TYPE(430),
            
        ADA_ADA_NODE_P_STD_WIDE_WIDE_STRING_TYPE(431),
            
        ADA_ADA_NODE_P_TOP_LEVEL_DECL(432),
            
        ADA_ADA_NODE_P_CHOICE_MATCH(433),
            
        ADA_ADA_NODE_P_GNAT_XREF(434),
            
        ADA_ADA_NODE_P_SPARK_MODE_ASPECT(435),
            
        ADA_ADA_NODE_P_XREF_ENTRY_POINT(436),
            
        ADA_ADA_NODE_P_MATCHING_WITH_USE_CLAUSE(437),
            
        ADA_PARENT(438),
            
        ADA_PARENTS(439),
            
        ADA_CHILDREN(440),
            
        ADA_TOKEN_START(441),
            
        ADA_TOKEN_END(442),
            
        ADA_CHILD_INDEX(443),
            
        ADA_PREVIOUS_SIBLING(444),
            
        ADA_NEXT_SIBLING(445),
            
        ADA_UNIT(446),
            
        ADA_IS_GHOST(447),
            
        ADA_FULL_SLOC_IMAGE(448),
            
        ADA_ABORT_NODE_P_AS_BOOL(449),
            
        ADA_ABSTRACT_NODE_P_AS_BOOL(450),
            
        ADA_ASSOC_LIST_P_ZIP_WITH_PARAMS(451),
            
        ADA_ALIASED_NODE_P_AS_BOOL(452),
            
        ADA_ALL_NODE_P_AS_BOOL(453),
            
        ADA_ASPECT_ASSOC_P_IS_GHOST_CODE(454),
            
        ADA_ENUM_REP_CLAUSE_P_PARAMS(455),
            
        ADA_BASE_ASSOC_P_ASSOC_EXPR(456),
            
        ADA_BASE_FORMAL_PARAM_HOLDER_P_ABSTRACT_FORMAL_PARAMS(457),
            
        ADA_BASE_FORMAL_PARAM_HOLDER_P_FORMAL_PARAMS(458),
            
        ADA_BASE_FORMAL_PARAM_HOLDER_P_NB_MIN_PARAMS(459),
            
        ADA_BASE_FORMAL_PARAM_HOLDER_P_NB_MAX_PARAMS(460),
            
        ADA_BASE_FORMAL_PARAM_HOLDER_P_PARAM_TYPES(461),
            
        ADA_BASE_SUBP_SPEC_P_NAME(462),
            
        ADA_BASE_SUBP_SPEC_P_RETURNS(463),
            
        ADA_BASE_SUBP_SPEC_P_PRIMITIVE_SUBP_TYPES(464),
            
        ADA_BASE_SUBP_SPEC_P_PRIMITIVE_SUBP_FIRST_TYPE(465),
            
        ADA_BASE_SUBP_SPEC_P_PRIMITIVE_SUBP_TAGGED_TYPE(466),
            
        ADA_BASE_SUBP_SPEC_P_RETURN_TYPE(467),
            
        ADA_BASE_SUBP_SPEC_P_PARAMS(468),
            
        ADA_BASIC_ASSOC_P_GET_PARAMS(469),
            
        ADA_BASIC_DECL_P_IS_FORMAL(470),
            
        ADA_BASIC_DECL_P_DOC_ANNOTATIONS(471),
            
        ADA_BASIC_DECL_P_DOC(472),
            
        ADA_BASIC_DECL_P_CANONICAL_PART(473),
            
        ADA_BASIC_DECL_P_ALL_PARTS(474),
            
        ADA_BASIC_DECL_P_GET_ASPECT_ASSOC(475),
            
        ADA_BASIC_DECL_P_GET_ASPECT_SPEC_EXPR(476),
            
        ADA_BASIC_DECL_P_GET_ASPECT(477),
            
        ADA_BASIC_DECL_P_HAS_ASPECT(478),
            
        ADA_BASIC_DECL_P_GET_PRAGMA(479),
            
        ADA_BASIC_DECL_P_GET_REPRESENTATION_CLAUSE(480),
            
        ADA_BASIC_DECL_P_GET_AT_CLAUSE(481),
            
        ADA_BASIC_DECL_P_GET_ANNOTATIONS(482),
            
        ADA_BASIC_DECL_P_IS_GHOST_CODE(483),
            
        ADA_BASIC_DECL_P_IS_COMPILATION_UNIT_ROOT(484),
            
        ADA_BASIC_DECL_P_IS_VISIBLE(485),
            
        ADA_BASIC_DECL_P_BASE_SUBP_DECLARATIONS(486),
            
        ADA_BASIC_DECL_P_ROOT_SUBP_DECLARATIONS(487),
            
        ADA_BASIC_DECL_P_FIND_ALL_OVERRIDES(488),
            
        ADA_BASIC_DECL_P_DEFINING_NAMES(489),
            
        ADA_BASIC_DECL_P_DEFINING_NAME(490),
            
        ADA_BASIC_DECL_P_SUBP_SPEC_OR_NULL(491),
            
        ADA_BASIC_DECL_P_IS_SUBPROGRAM(492),
            
        ADA_BASIC_DECL_P_RELATIVE_NAME(493),
            
        ADA_BASIC_DECL_P_RELATIVE_NAME_TEXT(494),
            
        ADA_BASIC_DECL_P_BODY_PART_FOR_DECL(495),
            
        ADA_BASIC_DECL_P_MOST_VISIBLE_PART(496),
            
        ADA_BASIC_DECL_P_FULLY_QUALIFIED_NAME_ARRAY(497),
            
        ADA_BASIC_DECL_P_FULLY_QUALIFIED_NAME(498),
            
        ADA_BASIC_DECL_P_CANONICAL_FULLY_QUALIFIED_NAME(499),
            
        ADA_BASIC_DECL_P_UNIQUE_IDENTIFYING_NAME(500),
            
        ADA_BASIC_DECL_P_PREVIOUS_PART_FOR_DECL(501),
            
        ADA_BASIC_DECL_P_IS_STATIC_DECL(502),
            
        ADA_BASIC_DECL_P_IS_IMPORTED(503),
            
        ADA_BASIC_DECL_P_TYPE_EXPRESSION(504),
            
        ADA_BASIC_DECL_P_NEXT_PART_FOR_DECL(505),
            
        ADA_BASIC_DECL_P_IS_CONSTANT_OBJECT(506),
            
        ADA_ANONYMOUS_EXPR_DECL_P_GET_FORMAL(507),
            
        ADA_BASE_FORMAL_PARAM_DECL_P_FORMAL_TYPE(508),
            
        ADA_BASE_PACKAGE_DECL_P_BODY_PART(509),
            
        ADA_BASE_TYPE_DECL_P_BASE_SUBTYPE(510),
            
        ADA_BASE_TYPE_DECL_P_ATTRIBUTE_SUBPROGRAM(511),
            
        ADA_BASE_TYPE_DECL_P_PRIVATE_COMPLETION(512),
            
        ADA_BASE_TYPE_DECL_P_IS_INHERITED_PRIMITIVE(513),
            
        ADA_BASE_TYPE_DECL_P_GET_RECORD_REPRESENTATION_CLAUSE(514),
            
        ADA_BASE_TYPE_DECL_P_GET_ENUM_REPRESENTATION_CLAUSE(515),
            
        ADA_BASE_TYPE_DECL_P_GET_PRIMITIVES(516),
            
        ADA_BASE_TYPE_DECL_P_IS_ARRAY_TYPE(517),
            
        ADA_BASE_TYPE_DECL_P_FIND_DERIVED_TYPES(518),
            
        ADA_BASE_TYPE_DECL_P_IS_SCALAR_TYPE(519),
            
        ADA_BASE_TYPE_DECL_P_SPECIFIC_TYPE(520),
            
        ADA_BASE_TYPE_DECL_P_FIND_ALL_DERIVED_TYPES(521),
            
        ADA_BASE_TYPE_DECL_P_COMP_TYPE(522),
            
        ADA_BASE_TYPE_DECL_P_INDEX_TYPE(523),
            
        ADA_BASE_TYPE_DECL_P_IS_DERIVED_TYPE(524),
            
        ADA_BASE_TYPE_DECL_P_IS_LIMITED_TYPE(525),
            
        ADA_BASE_TYPE_DECL_P_MATCHING_TYPE(526),
            
        ADA_BASE_TYPE_DECL_P_PREVIOUS_PART(527),
            
        ADA_BASE_TYPE_DECL_P_NEXT_PART(528),
            
        ADA_BASE_TYPE_DECL_P_FULL_VIEW(529),
            
        ADA_BASE_TYPE_DECL_P_IS_DEFINITE_SUBTYPE(530),
            
        ADA_BASE_TYPE_DECL_P_DISCRIMINANTS_LIST(531),
            
        ADA_BASE_TYPE_DECL_P_SHAPES(532),
            
        ADA_BASE_TYPE_DECL_P_IS_RECORD_TYPE(533),
            
        ADA_BASE_TYPE_DECL_P_IS_REAL_TYPE(534),
            
        ADA_BASE_TYPE_DECL_P_IS_FLOAT_TYPE(535),
            
        ADA_BASE_TYPE_DECL_P_IS_FIXED_POINT(536),
            
        ADA_BASE_TYPE_DECL_P_IS_ENUM_TYPE(537),
            
        ADA_BASE_TYPE_DECL_P_IS_ACCESS_TYPE(538),
            
        ADA_BASE_TYPE_DECL_P_IS_CHAR_TYPE(539),
            
        ADA_BASE_TYPE_DECL_P_CLASSWIDE_TYPE(540),
            
        ADA_BASE_TYPE_DECL_P_DISCRETE_RANGE(541),
            
        ADA_BASE_TYPE_DECL_P_IS_DISCRETE_TYPE(542),
            
        ADA_BASE_TYPE_DECL_P_IS_INT_TYPE(543),
            
        ADA_BASE_TYPE_DECL_P_ACCESSED_TYPE(544),
            
        ADA_BASE_TYPE_DECL_P_IS_TAGGED_TYPE(545),
            
        ADA_BASE_TYPE_DECL_P_BASE_TYPE(546),
            
        ADA_BASE_TYPE_DECL_P_BASE_TYPES(547),
            
        ADA_BASE_TYPE_DECL_P_IS_INTERFACE_TYPE(548),
            
        ADA_BASE_TYPE_DECL_P_CANONICAL_TYPE(549),
            
        ADA_BASE_TYPE_DECL_P_IS_PRIVATE(550),
            
        ADA_BASE_TYPE_DECL_P_ROOT_TYPE(551),
            
        ADA_BASE_SUBTYPE_DECL_P_GET_TYPE(552),
            
        ADA_BASIC_SUBP_DECL_P_SUBP_DECL_SPEC(553),
            
        ADA_CLASSIC_SUBP_DECL_P_BODY_PART(554),
            
        ADA_ENTRY_DECL_P_BODY_PART(555),
            
        ADA_ENTRY_DECL_P_ACCEPT_STMTS(556),
            
        ADA_ENUM_LITERAL_DECL_P_ENUM_REP(557),
            
        ADA_ENUM_LITERAL_DECL_P_ENUM_TYPE(558),
            
        ADA_SYNTHETIC_CHAR_ENUM_LIT_P_EXPR(559),
            
        ADA_BODY_NODE_P_PREVIOUS_PART(560),
            
        ADA_BODY_NODE_P_DECL_PART(561),
            
        ADA_BODY_NODE_P_SUBUNIT_ROOT(562),
            
        ADA_BODY_STUB_P_SYNTACTIC_FULLY_QUALIFIED_NAME(563),
            
        ADA_GENERIC_PACKAGE_DECL_P_BODY_PART(564),
            
        ADA_GENERIC_SUBP_DECL_P_BODY_PART(565),
            
        ADA_GENERIC_INSTANTIATION_P_DESIGNATED_GENERIC_DECL(566),
            
        ADA_GENERIC_INSTANTIATION_P_INST_PARAMS(567),
            
        ADA_GENERIC_SUBP_INSTANTIATION_P_DESIGNATED_SUBP(568),
            
        ADA_OBJECT_DECL_P_PRIVATE_PART_DECL(569),
            
        ADA_OBJECT_DECL_P_PUBLIC_PART_DECL(570),
            
        ADA_PACKAGE_RENAMING_DECL_P_RENAMED_PACKAGE(571),
            
        ADA_PACKAGE_RENAMING_DECL_P_FINAL_RENAMED_PACKAGE(572),
            
        ADA_COMPILATION_UNIT_P_SYNTACTIC_FULLY_QUALIFIED_NAME(573),
            
        ADA_COMPILATION_UNIT_P_UNIT_KIND(574),
            
        ADA_COMPILATION_UNIT_P_WITHED_UNITS(575),
            
        ADA_COMPILATION_UNIT_P_IMPORTED_UNITS(576),
            
        ADA_COMPILATION_UNIT_P_UNIT_DEPENDENCIES(577),
            
        ADA_COMPILATION_UNIT_P_DECL(578),
            
        ADA_COMPILATION_UNIT_P_IS_PREELABORABLE(579),
            
        ADA_COMPILATION_UNIT_P_OTHER_PART(580),
            
        ADA_COMPILATION_UNIT_P_HAS_RESTRICTION(581),
            
        ADA_COMPILATION_UNIT_P_ALL_CONFIG_PRAGMAS(582),
            
        ADA_COMPILATION_UNIT_P_CONFIG_PRAGMAS(583),
            
        ADA_CONSTANT_NODE_P_AS_BOOL(584),
            
        ADA_COMPOSITE_CONSTRAINT_P_IS_INDEX_CONSTRAINT(585),
            
        ADA_COMPOSITE_CONSTRAINT_P_IS_DISCRIMINANT_CONSTRAINT(586),
            
        ADA_COMPOSITE_CONSTRAINT_P_DISCRIMINANT_PARAMS(587),
            
        ADA_EXPR_P_EXPRESSION_TYPE(588),
            
        ADA_EXPR_P_EXPECTED_EXPRESSION_TYPE(589),
            
        ADA_EXPR_P_IS_DYNAMICALLY_TAGGED(590),
            
        ADA_EXPR_P_IS_STATIC_EXPR(591),
            
        ADA_EXPR_P_EVAL_AS_INT(592),
            
        ADA_EXPR_P_EVAL_AS_INT_IN_ENV(593),
            
        ADA_EXPR_P_EVAL_AS_STRING(594),
            
        ADA_EXPR_P_EVAL_AS_STRING_IN_ENV(595),
            
        ADA_EXPR_P_MATCHING_NODES(596),
            
        ADA_EXPR_P_IS_DISPATCHING_CALL(597),
            
        ADA_EXPR_P_FIRST_CORRESPONDING_DECL(598),
            
        ADA_ALLOCATOR_P_GET_ALLOCATED_TYPE(599),
            
        ADA_BASE_AGGREGATE_P_AGGREGATE_PARAMS(600),
            
        ADA_BASE_AGGREGATE_P_IS_SUBAGGREGATE(601),
            
        ADA_CONCAT_OP_P_OPERANDS(602),
            
        ADA_COND_EXPR_P_DEPENDENT_EXPRS(603),
            
        ADA_NAME_P_ENCLOSING_DEFINING_NAME(604),
            
        ADA_NAME_P_IS_DEFINING(605),
            
        ADA_NAME_P_NAME_IS(606),
            
        ADA_NAME_P_IS_DIRECT_CALL(607),
            
        ADA_NAME_P_IS_ACCESS_CALL(608),
            
        ADA_NAME_P_IS_CALL(609),
            
        ADA_NAME_P_IS_DOT_CALL(610),
            
        ADA_NAME_P_FAILSAFE_REFERENCED_DEF_NAME(611),
            
        ADA_NAME_P_REFERENCED_DEFINING_NAME(612),
            
        ADA_NAME_P_ALL_ENV_ELEMENTS(613),
            
        ADA_NAME_P_CALLED_SUBP_SPEC(614),
            
        ADA_NAME_P_REFERENCED_DECL(615),
            
        ADA_NAME_P_FAILSAFE_REFERENCED_DECL(616),
            
        ADA_NAME_P_NAME_DESIGNATED_TYPE(617),
            
        ADA_NAME_P_IS_STATIC_SUBTYPE(618),
            
        ADA_NAME_P_NAME_MATCHES(619),
            
        ADA_NAME_P_IS_OPERATOR_NAME(620),
            
        ADA_NAME_P_IS_WRITE_REFERENCE(621),
            
        ADA_NAME_P_IS_STATIC_CALL(622),
            
        ADA_NAME_P_CALL_PARAMS(623),
            
        ADA_NAME_P_RELATIVE_NAME(624),
            
        ADA_NAME_P_AS_SYMBOL_ARRAY(625),
            
        ADA_NAME_P_CANONICAL_TEXT(626),
            
        ADA_NAME_P_IS_CONSTANT(627),
            
        ADA_CALL_EXPR_P_KIND(628),
            
        ADA_CALL_EXPR_P_IS_ARRAY_SLICE(629),
            
        ADA_DEFINING_NAME_P_CANONICAL_FULLY_QUALIFIED_NAME(630),
            
        ADA_DEFINING_NAME_P_UNIQUE_IDENTIFYING_NAME(631),
            
        ADA_DEFINING_NAME_P_FULLY_QUALIFIED_NAME_ARRAY(632),
            
        ADA_DEFINING_NAME_P_FULLY_QUALIFIED_NAME(633),
            
        ADA_DEFINING_NAME_P_BASIC_DECL(634),
            
        ADA_DEFINING_NAME_P_FIND_REFS(635),
            
        ADA_DEFINING_NAME_P_FIND_ALL_REFERENCES(636),
            
        ADA_DEFINING_NAME_P_FIND_ALL_CALLS(637),
            
        ADA_DEFINING_NAME_P_NEXT_PART(638),
            
        ADA_DEFINING_NAME_P_PREVIOUS_PART(639),
            
        ADA_DEFINING_NAME_P_CANONICAL_PART(640),
            
        ADA_DEFINING_NAME_P_MOST_VISIBLE_PART(641),
            
        ADA_DEFINING_NAME_P_ALL_PARTS(642),
            
        ADA_DEFINING_NAME_P_GET_ASPECT(643),
            
        ADA_DEFINING_NAME_P_HAS_ASPECT(644),
            
        ADA_DEFINING_NAME_P_GET_PRAGMA(645),
            
        ADA_DEFINING_NAME_P_GET_REPRESENTATION_CLAUSE(646),
            
        ADA_DEFINING_NAME_P_GET_AT_CLAUSE(647),
            
        ADA_DEFINING_NAME_P_GET_ANNOTATIONS(648),
            
        ADA_DEFINING_NAME_P_IS_IMPORTED(649),
            
        ADA_DEFINING_NAME_P_IS_GHOST_CODE(650),
            
        ADA_END_NAME_P_BASIC_DECL(651),
            
        ADA_CHAR_LITERAL_P_DENOTED_VALUE(652),
            
        ADA_STRING_LITERAL_P_DENOTED_VALUE(653),
            
        ADA_INT_LITERAL_P_DENOTED_VALUE(654),
            
        ADA_LIMITED_NODE_P_AS_BOOL(655),
            
        ADA_NOT_NULL_P_AS_BOOL(656),
            
        ADA_PRAGMA_NODE_P_IS_GHOST_CODE(657),
            
        ADA_PRAGMA_NODE_P_ASSOCIATED_ENTITIES(658),
            
        ADA_PRIVATE_NODE_P_AS_BOOL(659),
            
        ADA_PROTECTED_NODE_P_AS_BOOL(660),
            
        ADA_REVERSE_NODE_P_AS_BOOL(661),
            
        ADA_STMT_P_IS_GHOST_CODE(662),
            
        ADA_ACCEPT_STMT_P_CORRESPONDING_ENTRY(663),
            
        ADA_SUBUNIT_P_BODY_ROOT(664),
            
        ADA_SYNCHRONIZED_NODE_P_AS_BOOL(665),
            
        ADA_TAGGED_NODE_P_AS_BOOL(666),
            
        ADA_TYPE_EXPR_P_TYPE_NAME(667),
            
        ADA_TYPE_EXPR_P_DESIGNATED_TYPE_DECL(668),
            
        ADA_TYPE_EXPR_P_DESIGNATED_TYPE_DECL_FROM(669),
            
        ADA_TYPE_EXPR_P_SUBTYPE_CONSTRAINT(670),
            
        ADA_TYPE_EXPR_P_DISCRIMINANT_CONSTRAINTS(671),
            
        ADA_TYPE_EXPR_P_IS_DEFINITE_SUBTYPE(672),
            
        ADA_SUBTYPE_INDICATION_P_IS_STATIC_SUBTYPE(673),
            
        ADA_UNTIL_NODE_P_AS_BOOL(674),
            
        ADA_WITH_PRIVATE_P_AS_BOOL(675),
        ;

        // ----- Class attributes -----

        /** Map containing relation from native value to Jave instance. */
        private static Map<Integer, MemberReference> map = new HashMap<>();

        // ----- Instance attribtues -----

        /** Native value if the member reference. */
        private final int value;

        // ----- Constructors -----

        /** Private constructor. */
        private MemberReference (
            final int value
        ) {
            this.value = value;
        }

        static {
            // Initialize the lookup map
            for(MemberReference elem : MemberReference.values()) {
                map.put(elem.value, elem);
            }
        }

        // ----- Class methods -----

        /**
         * Get the enum instance from the given C integer value.
         *
         * @throws EnumException If the given C value is not a valid enum
         *                       value.
         */
        public static MemberReference fromC(
            final int cValue
        ) {
            if(!map.containsKey(cValue))
                throw new EnumException(
                    "Cannot get MemberReference from " + cValue
                );
            return (MemberReference) map.get(cValue);
        }

        // ----- Instance methods -----

        /** Get the native value of the enum instance. */
        public int toC() {
            return this.value;
        }

    }

    // ===== Generated enums =====

    
    

    /**
     * Specify a kind of analysis unit. Specification units provide an
     * interface to the outer world while body units provide an implementation
     * for the corresponding interface.
     */
    public enum AnalysisUnitKind {

        // ----- Enum values -----

        UNIT_SPECIFICATION(0),
        UNIT_BODY(1),
        ;

        // ----- Attributes -----

        /** Singleton that represents the none enum value. */
        public static final AnalysisUnitKind NONE =
            UNIT_SPECIFICATION;

        /** The value of the enum instance. */
        private final int value;

        /** The map from int to enum values. */
        private static final Map<Integer, AnalysisUnitKind> map = new HashMap<>();

        // ----- Constructors -----

        static {
            // Initialise the lookup map
            for(AnalysisUnitKind elem : AnalysisUnitKind.values()) {
                map.put(elem.value, elem);
            }
        }

        /** Private constructor. */
        private AnalysisUnitKind(
            final int value
        ) {
            this.value = value;
        }

        // ----- Graal C API methods -----

        /**
         * Internal method to wrap a Native Image C pointer to an enum value.
         */
        static AnalysisUnitKind fromC(
            final CIntPointer pointer
        ) throws EnumException {
            return fromC(pointer.read());
        }

        // ----- Enum methods -----

        /**
         * Get the enum instance for the given C value.
         *
         * @param cValue The C int value to get the enum instance from.
         * @return The enum instance which correspond to the int value.
         * @throws EnumException When the int value doesn't map to any enum
         * instance.
         */
        public static AnalysisUnitKind fromC(
            final int cValue
        ) throws EnumException {
            if(!map.containsKey(cValue))
                throw new EnumException(
                    "Cannot get AnalysisUnitKind from " + cValue
                );
            return (AnalysisUnitKind) map.get(cValue);
        }

        /**
         * Get the C value from the enum instance.
         *
         * @return The int C value of the enum instance.
         */
        public int toC() {
            return this.value;
        }

    }

    
    

    /**

     */
    public enum LookupKind {

        // ----- Enum values -----

        RECURSIVE(0),
        FLAT(1),
        MINIMAL(2),
        ;

        // ----- Attributes -----

        /** Singleton that represents the none enum value. */
        public static final LookupKind NONE =
            RECURSIVE;

        /** The value of the enum instance. */
        private final int value;

        /** The map from int to enum values. */
        private static final Map<Integer, LookupKind> map = new HashMap<>();

        // ----- Constructors -----

        static {
            // Initialise the lookup map
            for(LookupKind elem : LookupKind.values()) {
                map.put(elem.value, elem);
            }
        }

        /** Private constructor. */
        private LookupKind(
            final int value
        ) {
            this.value = value;
        }

        // ----- Graal C API methods -----

        /**
         * Internal method to wrap a Native Image C pointer to an enum value.
         */
        static LookupKind fromC(
            final CIntPointer pointer
        ) throws EnumException {
            return fromC(pointer.read());
        }

        // ----- Enum methods -----

        /**
         * Get the enum instance for the given C value.
         *
         * @param cValue The C int value to get the enum instance from.
         * @return The enum instance which correspond to the int value.
         * @throws EnumException When the int value doesn't map to any enum
         * instance.
         */
        public static LookupKind fromC(
            final int cValue
        ) throws EnumException {
            if(!map.containsKey(cValue))
                throw new EnumException(
                    "Cannot get LookupKind from " + cValue
                );
            return (LookupKind) map.get(cValue);
        }

        /**
         * Get the C value from the enum instance.
         *
         * @return The int C value of the enum instance.
         */
        public int toC() {
            return this.value;
        }

    }

    
    

    /**
     * Discriminant for DesignatedEnv structures.
     */
    public enum DesignatedEnvKind {

        // ----- Enum values -----

        NONE_ENUM(0),
        CURRENT_ENV(1),
        NAMED_ENV(2),
        DIRECT_ENV(3),
        ;

        // ----- Attributes -----

        /** Singleton that represents the none enum value. */
        public static final DesignatedEnvKind NONE =
            NONE_ENUM;

        /** The value of the enum instance. */
        private final int value;

        /** The map from int to enum values. */
        private static final Map<Integer, DesignatedEnvKind> map = new HashMap<>();

        // ----- Constructors -----

        static {
            // Initialise the lookup map
            for(DesignatedEnvKind elem : DesignatedEnvKind.values()) {
                map.put(elem.value, elem);
            }
        }

        /** Private constructor. */
        private DesignatedEnvKind(
            final int value
        ) {
            this.value = value;
        }

        // ----- Graal C API methods -----

        /**
         * Internal method to wrap a Native Image C pointer to an enum value.
         */
        static DesignatedEnvKind fromC(
            final CIntPointer pointer
        ) throws EnumException {
            return fromC(pointer.read());
        }

        // ----- Enum methods -----

        /**
         * Get the enum instance for the given C value.
         *
         * @param cValue The C int value to get the enum instance from.
         * @return The enum instance which correspond to the int value.
         * @throws EnumException When the int value doesn't map to any enum
         * instance.
         */
        public static DesignatedEnvKind fromC(
            final int cValue
        ) throws EnumException {
            if(!map.containsKey(cValue))
                throw new EnumException(
                    "Cannot get DesignatedEnvKind from " + cValue
                );
            return (DesignatedEnvKind) map.get(cValue);
        }

        /**
         * Get the C value from the enum instance.
         *
         * @return The int C value of the enum instance.
         */
        public int toC() {
            return this.value;
        }

    }

    
    

    /**
     * Kind for the result of a cross reference operation.
     *
     * * ``no_ref`` is for no reference, it is the null value for this enum.
     *
     * * ``precise`` is when the reference result is precise.
     *
     * * ``imprecise`` is when there was an error computing the precise result,
     *   and a result was gotten in an imprecise fashion.
     *
     * * ``error`` is for unrecoverable errors (either there is no imprecise
     *   path for the request you made, or the imprecise path errored out too).
     */
    public enum RefResultKind {

        // ----- Enum values -----

        NO_REF(0),
        PRECISE(1),
        IMPRECISE(2),
        ERROR(3),
        ;

        // ----- Attributes -----

        /** Singleton that represents the none enum value. */
        public static final RefResultKind NONE =
            NO_REF;

        /** The value of the enum instance. */
        private final int value;

        /** The map from int to enum values. */
        private static final Map<Integer, RefResultKind> map = new HashMap<>();

        // ----- Constructors -----

        static {
            // Initialise the lookup map
            for(RefResultKind elem : RefResultKind.values()) {
                map.put(elem.value, elem);
            }
        }

        /** Private constructor. */
        private RefResultKind(
            final int value
        ) {
            this.value = value;
        }

        // ----- Graal C API methods -----

        /**
         * Internal method to wrap a Native Image C pointer to an enum value.
         */
        static RefResultKind fromC(
            final CIntPointer pointer
        ) throws EnumException {
            return fromC(pointer.read());
        }

        // ----- Enum methods -----

        /**
         * Get the enum instance for the given C value.
         *
         * @param cValue The C int value to get the enum instance from.
         * @return The enum instance which correspond to the int value.
         * @throws EnumException When the int value doesn't map to any enum
         * instance.
         */
        public static RefResultKind fromC(
            final int cValue
        ) throws EnumException {
            if(!map.containsKey(cValue))
                throw new EnumException(
                    "Cannot get RefResultKind from " + cValue
                );
            return (RefResultKind) map.get(cValue);
        }

        /**
         * Get the C value from the enum instance.
         *
         * @return The int C value of the enum instance.
         */
        public int toC() {
            return this.value;
        }

    }

    
    

    /**
     * Kind of CallExpr type.
     *
     * * ``call`` is when the CallExpr is a procedure or function call.
     *
     * * ``array_slice``, ``array_index`` is when the CallExpr is in fact an
     *   array slice or an array subcomponent access expression, respectively.
     *
     * * ``type_conversion`` is when the CallExpr is a type conversion.
     *
     * * ``family_index`` is for entry calls using a family index.
     */
    public enum CallExprKind {

        // ----- Enum values -----

        CALL(0),
        ARRAY_SLICE(1),
        ARRAY_INDEX(2),
        TYPE_CONVERSION(3),
        FAMILY_INDEX(4),
        ;

        // ----- Attributes -----

        /** Singleton that represents the none enum value. */
        public static final CallExprKind NONE =
            CALL;

        /** The value of the enum instance. */
        private final int value;

        /** The map from int to enum values. */
        private static final Map<Integer, CallExprKind> map = new HashMap<>();

        // ----- Constructors -----

        static {
            // Initialise the lookup map
            for(CallExprKind elem : CallExprKind.values()) {
                map.put(elem.value, elem);
            }
        }

        /** Private constructor. */
        private CallExprKind(
            final int value
        ) {
            this.value = value;
        }

        // ----- Graal C API methods -----

        /**
         * Internal method to wrap a Native Image C pointer to an enum value.
         */
        static CallExprKind fromC(
            final CIntPointer pointer
        ) throws EnumException {
            return fromC(pointer.read());
        }

        // ----- Enum methods -----

        /**
         * Get the enum instance for the given C value.
         *
         * @param cValue The C int value to get the enum instance from.
         * @return The enum instance which correspond to the int value.
         * @throws EnumException When the int value doesn't map to any enum
         * instance.
         */
        public static CallExprKind fromC(
            final int cValue
        ) throws EnumException {
            if(!map.containsKey(cValue))
                throw new EnumException(
                    "Cannot get CallExprKind from " + cValue
                );
            return (CallExprKind) map.get(cValue);
        }

        /**
         * Get the C value from the enum instance.
         *
         * @return The int C value of the enum instance.
         */
        public int toC() {
            return this.value;
        }

    }

    
    

    /**
     * Gramar rule to use for parsing.
     */
    public enum GrammarRule {

        // ----- Enum values -----

        PARENT_LIST_RULE(0),
        PROTECTED_TYPE_DECL_RULE(1),
        PROTECTED_OP_RULE(2),
        PROTECTED_EL_RULE(3),
        PROTECTED_DEF_RULE(4),
        PROTECTED_DECL_RULE(5),
        TASK_ITEM_RULE(6),
        TASK_DEF_RULE(7),
        TASK_TYPE_DECL_RULE(8),
        SUBTYPE_DECL_RULE(9),
        INTERFACE_TYPE_DEF_RULE(10),
        UNCONSTRAINED_INDEX_RULE(11),
        ARRAY_TYPE_DEF_RULE(12),
        DISCRETE_SUBTYPE_DEFINITION_RULE(13),
        CONSTRAINT_LIST_RULE(14),
        SIGNED_INT_TYPE_DEF_RULE(15),
        MOD_INT_TYPE_DEF_RULE(16),
        DERIVED_TYPE_DEF_RULE(17),
        COMPOSITE_CONSTRAINT_ASSOC_RULE(18),
        COMPOSITE_CONSTRAINT_RULE(19),
        DIGITS_CONSTRAINT_RULE(20),
        DELTA_CONSTRAINT_RULE(21),
        RANGE_CONSTRAINT_RULE(22),
        CONSTRAINT_RULE(23),
        DISCRIMINANT_SPEC_RULE(24),
        DISCR_SPEC_LIST_RULE(25),
        DISCRIMINANT_PART_RULE(26),
        ENUM_LITERAL_DECL_RULE(27),
        FORMAL_DISCRETE_TYPE_DEF_RULE(28),
        RECORD_DEF_RULE(29),
        RANGE_SPEC_RULE(30),
        REAL_TYPE_DEF_RULE(31),
        SEXPR_OR_BOX_RULE(32),
        ORDINARY_FIXED_POINT_DEF_RULE(33),
        DECIMAL_FIXED_POINT_DEF_RULE(34),
        FLOATING_POINT_DEF_RULE(35),
        RECORD_TYPE_DEF_RULE(36),
        ACCESS_DEF_RULE(37),
        ENUM_TYPE_DEF_RULE(38),
        TYPE_DEF_RULE(39),
        VARIANT_RULE(40),
        ANONYMOUS_TYPE_DECL_RULE(41),
        INCOMPLETE_TYPE_DECL_RULE(42),
        TYPE_DECL_RULE(43),
        VARIANT_PART_RULE(44),
        COMPONENT_DEF_RULE(45),
        COMPONENT_ITEM_RULE(46),
        COMPONENT_DECL_RULE(47),
        COMPONENT_LIST_RULE(48),
        GENERIC_DECL_RULE(49),
        GENERIC_FORMAL_PART_RULE(50),
        GENERIC_FORMAL_DECL_RULE(51),
        FORMAL_TYPE_DECL_RULE(52),
        FORMAL_SUBP_DECL_RULE(53),
        RENAMING_CLAUSE_RULE(54),
        GENERIC_RENAMING_DECL_RULE(55),
        GENERIC_INSTANTIATION_RULE(56),
        EXCEPTION_DECL_RULE(57),
        BASIC_DECLS_RULE(58),
        PACKAGE_RENAMING_DECL_RULE(59),
        PACKAGE_DECL_RULE(60),
        BASIC_DECL_RULE(61),
        OBJECT_DECL_RULE(62),
        SUB_OBJECT_DECL_RULE(63),
        NO_TYPE_OBJECT_RENAMING_DECL_RULE(64),
        EXT_RET_STMT_OBJECT_DECL_RULE(65),
        DEFINING_ID_LIST_RULE(66),
        NUMBER_DECL_RULE(67),
        CONTRACT_CASE_ASSOC_RULE(68),
        CONTRACT_CASES_EXPR_RULE(69),
        ABSTRACT_STATE_DECL_RULE(70),
        MULTI_ABSTRACT_STATE_DECL_RULE(71),
        ASPECT_ASSOC_RULE(72),
        ASPECT_SPEC_RULE(73),
        SINGLE_TASK_DECL_RULE(74),
        OVERRIDING_INDICATOR_RULE(75),
        ENTRY_DECL_RULE(76),
        COMPONENT_CLAUSE_RULE(77),
        ASPECT_CLAUSE_RULE(78),
        PARAM_SPEC_RULE(79),
        PARAM_SPECS_RULE(80),
        SUBP_SPEC_RULE(81),
        EXPR_FN_RULE(82),
        NULL_SUBP_DECL_RULE(83),
        ABSTRACT_SUBP_DECL_RULE(84),
        SUBP_RENAMING_DECL_RULE(85),
        SIMPLE_SUBP_DECL_RULE(86),
        SUBP_DECL_RULE(87),
        WITH_CLAUSE_RULE(88),
        CONTEXT_ITEM_RULE(89),
        USE_CLAUSE_RULE(90),
        USE_PACKAGE_CLAUSE_RULE(91),
        USE_TYPE_CLAUSE_RULE(92),
        SUBTYPE_INDICATION_RULE(93),
        DISCRETE_SUBTYPE_INDICATION_RULE(94),
        CONSTRAINED_SUBTYPE_INDICATION_RULE(95),
        TYPE_EXPR_RULE(96),
        ANONYMOUS_TYPE_RULE(97),
        MODE_RULE(98),
        PRAGMA_ARGUMENT_RULE(99),
        PRAGMA_RULE(100),
        SUBUNIT_RULE(101),
        LIBRARY_UNIT_BODY_RULE(102),
        LIBRARY_UNIT_RENAMING_DECL_RULE(103),
        LIBRARY_ITEM_RULE(104),
        COMPILATION_UNIT_RULE(105),
        COMPILATION_RULE(106),
        DECL_PART_RULE(107),
        ENTRY_BODY_RULE(108),
        PROTECTED_BODY_RULE(109),
        PROTECTED_BODY_STUB_RULE(110),
        TASK_BODY_RULE(111),
        TASK_BODY_STUB_RULE(112),
        PACKAGE_BODY_STUB_RULE(113),
        PACKAGE_BODY_RULE(114),
        TERMINATE_ALTERNATIVE_RULE(115),
        SELECT_STMT_RULE(116),
        ACCEPT_STMT_RULE(117),
        CASE_ALT_RULE(118),
        CASE_STMT_RULE(119),
        EXT_RETURN_STMT_RULE(120),
        IBLOCK_STMT_RULE(121),
        BLOCK_STMT_RULE(122),
        WHILE_LOOP_SPEC_RULE(123),
        ILOOP_STMT_RULE(124),
        LOOP_STMT_RULE(125),
        COMPOUND_STMT_RULE(126),
        ELSIF_PART_RULE(127),
        IF_STMT_RULE(128),
        RAISE_STMT_RULE(129),
        DELAY_STMT_RULE(130),
        ABORT_STMT_RULE(131),
        BODY_RULE(132),
        BODY_STUB_RULE(133),
        SUBP_BODY_STUB_RULE(134),
        RECOV_DECL_PART_RULE(135),
        SUBP_BODY_RULE(136),
        HANDLED_STMTS_RULE(137),
        EXCEPTION_HANDLER_RULE(138),
        STMTS_RULE(139),
        LABEL_RULE(140),
        STMT_RULE(141),
        CALL_STMT_RULE(142),
        SIMPLE_STMT_RULE(143),
        SIMPLE_DECL_STMT_RULE(144),
        NULL_STMT_RULE(145),
        ASSIGNMENT_STMT_RULE(146),
        GOTO_STMT_RULE(147),
        EXIT_STMT_RULE(148),
        RETURN_STMT_RULE(149),
        REQUEUE_STMT_RULE(150),
        IDENTIFIER_RULE(151),
        CHAR_LITERAL_RULE(152),
        STRING_LITERAL_RULE(153),
        FORMAT_STRING_LITERAL_RULE(154),
        DEFINING_ID_RULE(155),
        DEC_LITERAL_RULE(156),
        INT_LITERAL_RULE(157),
        NUM_LITERAL_RULE(158),
        NULL_LITERAL_RULE(159),
        ALLOCATOR_RULE(160),
        FOR_LOOP_PARAM_SPEC_RULE(161),
        QUANTIFIED_EXPR_RULE(162),
        CASE_EXPR_RULE(163),
        CASE_EXPR_ALT_RULE(164),
        RAISE_EXPR_RULE(165),
        IF_EXPR_RULE(166),
        CONDITIONAL_EXPR_RULE(167),
        BOX_EXPR_RULE(168),
        OTHERS_DESIGNATOR_RULE(169),
        ITERATED_ASSOC_RULE(170),
        AGGREGATE_ASSOC_RULE(171),
        REGULAR_AGGREGATE_RULE(172),
        BRACKET_AGGREGATE_RULE(173),
        AGGREGATE_RULE(174),
        DIRECT_NAME_RULE(175),
        PARAM_ASSOC_RULE(176),
        CALL_SUFFIX_RULE(177),
        ATTR_SUFFIX_RULE(178),
        QUALIFIED_NAME_RULE(179),
        QUAL_NAME_INTERNAL_RULE(180),
        VALUE_SEQUENCE_RULE(181),
        NAME_RULE(182),
        DEFINING_NAME_RULE(183),
        DIRECT_NAME_OR_TARGET_NAME_RULE(184),
        TARGET_NAME_RULE(185),
        UPDATE_ATTR_AGGREGATE_RULE(186),
        UPDATE_ATTR_CONTENT_RULE(187),
        MULTIDIM_ARRAY_ASSOC_RULE(188),
        SUBTYPE_NAME_RULE(189),
        STATIC_NAME_RULE(190),
        PRIMARY_RULE(191),
        PAREN_EXPR_RULE(192),
        DECLARE_EXPR_RULE(193),
        FACTOR_RULE(194),
        TERM_RULE(195),
        UNOP_TERM_RULE(196),
        ADD_TERM_RULE(197),
        SIMPLE_EXPR_RULE(198),
        BOOLEAN_OP_RULE(199),
        DISCRETE_RANGE_RULE(200),
        ARRAY_SUBCOMPONENT_CHOICE_RULE(201),
        CHOICE_RULE(202),
        CHOICE_LIST_RULE(203),
        DELTA_CHOICE_LIST_RULE(204),
        REL_OP_RULE(205),
        MEMBERSHIP_CHOICE_RULE(206),
        MEMBERSHIP_CHOICE_LIST_RULE(207),
        RELATION_RULE(208),
        EXPR_RULE(209),
        PP_DIRECTIVE_RULE(210),
        PP_THEN_RULE(211),
        PP_EXPR_RULE(212),
        PP_TERM_RULE(213),
        ;

        // ----- Attributes -----

        /** Singleton that represents the none enum value. */
        public static final GrammarRule NONE =
            PARENT_LIST_RULE;

        /** The value of the enum instance. */
        private final int value;

        /** The map from int to enum values. */
        private static final Map<Integer, GrammarRule> map = new HashMap<>();

        // ----- Constructors -----

        static {
            // Initialise the lookup map
            for(GrammarRule elem : GrammarRule.values()) {
                map.put(elem.value, elem);
            }
        }

        /** Private constructor. */
        private GrammarRule(
            final int value
        ) {
            this.value = value;
        }

        // ----- Graal C API methods -----

        /**
         * Internal method to wrap a Native Image C pointer to an enum value.
         */
        static GrammarRule fromC(
            final CIntPointer pointer
        ) throws EnumException {
            return fromC(pointer.read());
        }

        // ----- Enum methods -----

        /**
         * Get the enum instance for the given C value.
         *
         * @param cValue The C int value to get the enum instance from.
         * @return The enum instance which correspond to the int value.
         * @throws EnumException When the int value doesn't map to any enum
         * instance.
         */
        public static GrammarRule fromC(
            final int cValue
        ) throws EnumException {
            if(!map.containsKey(cValue))
                throw new EnumException(
                    "Cannot get GrammarRule from " + cValue
                );
            return (GrammarRule) map.get(cValue);
        }

        /**
         * Get the C value from the enum instance.
         *
         * @return The int C value of the enum instance.
         */
        public int toC() {
            return this.value;
        }

    }


    // ==========
    // Java wrapping classes
    // ==========

    // ===== Constant structure wrapping classes =====

    /**
     * This class provides static methods to help wrapping and unwrapping
     * native boolean values.
     */
    public static final class BooleanWrapper {

        // ----- Graal C API methods -----

        static boolean wrap(
            final CCharPointer pointer
        ) {
            return pointer.read() != 0;
        }

        static boolean wrap(
            final byte nativeValue
        ) {
            return nativeValue != 0;
        }

    }

    /**
     * This class provides static methods to help wrapping and unwrapping
     * native integer values.
     */
    public static final class IntegerWrapper {

        // ----- Graal C API methods -----

        static int wrap(
            final CIntPointer pointer
        ) {
            return pointer.read();
        }

        static int wrap(
            final int nativeValue
        ) {
            return nativeValue;
        }

    }

    /**
     * This class wraps the langkit characters which are 32 bit wide.
     */
    public static final class Char {

        // ----- Class attributes -----

        /** Singleton that represents the none char. */
        public static final Char NONE = new Char(0);

        // ----- Instance attributes -----

        /** The value of the character. */
        public final int value;

        // ----- Constructors -----

        /**
         * Create a new character from its value. In langkit characters are
         * 32 bit wide so represented by Java integer.
         *
         * @param value The value of the character.
         */
        Char(
            final int value
        ) {
            this.value = value;
        }

        /**
         * Create a character from its integer value.
         *
         * @param value The character value.
         * @return The newly created character.
         */
        public static Char create(
            final int value
        ) {
            return new Char(value);
        }

        /**
         * Create a character from a Java character.
         *
         * @param value The source value of the character.
         * @return The newly created character.
         */
        public static Char create(
            final char value
        ) {
            return new Char((int) value);
        }

        // ----- Graal C API methods -----

        /**
         * Wrap the given NI pointer in a Java class.
         *
         * @param pointer The NI pointer to wrap.
         * @return The wrapped character.
         */
        static Char wrap(
            final CIntPointer pointer
        ) {
            return wrap(pointer.read());
        }

        /**
         * Wrap an integer to a character.
         *
         * @param value The value of the character in an integer.
         * @return The newly created character.
         */
        static Char wrap(
            final int value
        ) {
            return new Char(value);
        }

        /**
         * Unwrap the character in the given int pointer.
         *
         * @param pointer The pointer to unwrap the character in.
         */
        void unwrap(
            final CIntPointer pointer
        ) {
            pointer.write(this.value);
        }

        /**
         * Unwrap the character in a Java integer.
         *
         * @return The character value in a Java integer.
         */
        int unwrap() {
            return this.value;
        }

        // ----- Override methods -----

        @Override
        public String toString() {
            final ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.order(BYTE_ORDER);
            buffer.putInt(this.value);
            return decodeUTF32(buffer.array());
        }

        @Override
        public boolean equals(Object o) {
            if(o == this) return true;
            if(!(o instanceof Char)) return false;
            Char other = (Char) o;
            return this.value == other.value;
        }

    }

    /**
     * Arbitrarily large integer.
     */
    static final class BigIntegerWrapper {

        // ----- Class attributes -----

        /** Singleton that represents the none big integer. */
        public static final BigInteger NONE = BigInteger.ZERO;

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer which points to a native big integer.
         *
         * @param pointer The pointer to the native big integer.
         * @return The Java big integer.
         */
        static BigInteger wrap(
            final WordPointer pointer
        ) {
            return wrap((BigIntegerNative) pointer.read());
        }

        /**
         * Wrap the given native big integer in a Java big integer.
         *
         * @param bigIntegerNative The big integer native value.
         * @return The Java big integer.
         */
        static BigInteger wrap(
            final BigIntegerNative bigIntegerNative
        ) {
            final String representation = getRepresentation(bigIntegerNative);
            return new BigInteger(representation);
        }

        /**
         * Unwrap the given Java big integer in the given word pointer.
         *
         * @param bigInteger The big integer to unwrap.
         * @param pointer The word pointer to place the big integer in.
         */
        static void unwrap(
            final BigInteger bigInteger,
            final WordPointer pointer
        ) {
            pointer.write(unwrap(bigInteger));
        }

        /**
         * Unwrap the given big integer.
         *
         * @param bigInteger The big integer to unwrap.
         * @return The native big integer newly allocated.
         */
        static BigIntegerNative unwrap(
            final BigInteger bigInteger
        ) {
            // Create the representation of the big integer
            final String representation = bigInteger.toString();
            try(final Text bigIntegerText = Text.create(representation)) {
                TextNative bigIntegerTextNative = StackValue.get(
                    TextNative.class
                );
                bigIntegerText.unwrap(bigIntegerTextNative);

                // Create the big intger by calling the native function
                return NI_LIB.ada_create_big_integer(
                    bigIntegerTextNative
                );
            }
        }

        /**
         * Release the big integer pointed by the given pointer.
         *
         * @param pointer The pointer to the big integer to release.
         */
        static void release(
            final WordPointer pointer
        ) {
            release((BigIntegerNative) pointer.read());
        }

        /**
         * Release the given native big integer.
         *
         * @param bigIntegerNative The native big integer to release.
         */
        static void release(
            final BigIntegerNative bigIntegerNative
        ) {
            NI_LIB.ada_big_integer_decref(bigIntegerNative);
        }

        // ----- Class methods -----

        /**
         * Get the string representation of the given native big integer.
         *
         * @param bigIntegerNative The native big integer to get the
         * representation from.
         */
        private static String getRepresentation(
            final BigIntegerNative bigIntegerNative
        ) {
            // Allocate the stack value for the text
            final TextNative bigIntegerTextNative = StackValue.get(
                TextNative.class
            );
            Text.NONE.unwrap(bigIntegerTextNative);

            // Call the native function
            NI_LIB.ada_big_integer_text(
                bigIntegerNative,
                bigIntegerTextNative
            );

            // Wrap the text and return the result
            try(final Text bigIntegerText = Text.wrap(bigIntegerTextNative)) {
                return bigIntegerText.getContent();
            }
        }

    }

    /**
     * Reference to a symbol. Symbols are owned by analysis contexts, so they
     * must not outlive them. This type exists only in the C API, and roughly
     * wraps the corresponding Ada type (an array fat pointer).
     */
    public static final class Symbol {

        // ----- Class attributes -----

        /** Singleton that represents the none symbol. */
        public static final Symbol NONE = new Symbol("");

        // ----- Instance attributes

        /** The text of the symbol. */
        public final String text;

        // ----- Constructors -----

        /**
         * Create a new symbol from its text.
         *
         * @param text The symbol text.
         */
        Symbol(
            final String text
        ) {
            this.text = text;
        }

        /**
         * Public access to the symbol creation.
         *
         * @param text The text of the symbol.
         */
        public static Symbol create(
            final String text
        ) {
            return new Symbol(text);
        }

        // ----- Graal C API methods -----

        /**
         * Wrap the given pointer to a native symbol.
         *
         * @param pointer The pointer to the native symbol.
         * @return The wrapped symbol.
         */
        static Symbol wrap(
            final WordPointer pointer
        ) {
            return wrap((SymbolNative) pointer.read());
        }

        /**
         * Wrap the given symbol native value in a Java value.
         *
         * @param symbolNative The symbol native value.
         * @return The wrapped symbol.
         */
        static Symbol wrap(
            final SymbolNative symbolNative
        ) {
            // Get the symbol text
            final TextNative textNative = StackValue.get(TextNative.class);
            Text.NONE.unwrap(textNative);
            NI_LIB.ada_symbol_text(
                symbolNative,
                textNative
            );

            // Return the new symbol
            try(final Text text = Text.wrap(textNative)) {
                return new Symbol(text.getContent());
            }
        }

        /**
         * Unwrap the symbol in the given native structure.
         *
         * @param symbolNative The native structure to unwrap in.
         */
        void unwrap(
            final SymbolNative symbolNative,
            final AnalysisContext context
        ) {
            // Unwrap the symbol text
            try(Text text = Text.create(this.text)) {
                final TextNative textNative = StackValue.get(
                    TextNative.class
                );
                text.unwrap(textNative);

                // Call the symbol creation
                final int resCode = NI_LIB.ada_context_symbol(
                    context.reference.ni(),
                    textNative,
                    symbolNative
                );

                // Check the symbol creation success
                if(resCode == 0) {
                    throw new SymbolException(this.text);
                }
            }
        }

        // ----- Override methods -----

        @Override
        public String toString() {
            return this.text;
        }

    }

    /**
     * Type to contain Unicode text data.
     */
    static final class StringWrapper {

        // ----- Class attributes -----

        /** Singleton that represents the none string. */
        public static final String NONE = "";

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer that points to a native string.
         *
         * @param pointer The pointer to the native string.
         * @return The Java string wrapped from the native string.
         */
        static String wrap(
            final WordPointer pointer
        ) {
            return wrap((StringNative) pointer.read());
        }

        /**
         * Wrap a native string wrapper in a Java string.
         *
         * @param stringNative The native string to wrap.
         * @return The Java string created from the native one.
         */
        static String wrap(
            final StringNative stringNative
        ) {
            return getNativeStringContent(stringNative);
        }

        /**
         * Unwrap the string in the given word pointer.
         *
         * @param string The string to unwrap.
         * @param pointer The word pointer to place the native string in.
         */
        static void unwrap(
            final String string,
            final WordPointer pointer
        ) {
            pointer.write(unwrap(string));
        }

        /**
         * Unwrap the given string in a native one.
         *
         * @param string The string to unwrap.
         * @return The native string unwrapped.
         */
        static StringNative unwrap(
            final String string
        ) {
            return nativeStringFromContent(string);
        }

        /**
         * Release the native string at the given pointer.
         *
         * @param pointer The pointer to the native string.
         */
        static void release(
            final WordPointer pointer
        ) {
            release((StringNative) pointer.read());
        }

        /**
         * Release the given native string.
         *
         * @param stringNative The native string to release.
         */
        static void release(
            final StringNative stringNative
        ) {
            NI_LIB.ada_string_dec_ref(stringNative);
        }

        // ----- Class methods -----

        /**
         * Get the content of the given native string in a Java one.
         *
         * @param stringNative The native string to get the content from.
         * @return The Java string.
         */
        private static String getNativeStringContent(
            final StringNative stringNative
        ) {
            // Prepare the working variable
            final Pointer pointer = (Pointer) stringNative;
            final int length = pointer.readInt(0);
            final byte[] contentArray = new byte[length * 4];

            // Get the content from the native string
            for(int i = 0 ; i < contentArray.length ; i++) {
                contentArray[i] = pointer.readByte(i + 8);
            }

            // Return the decoded string
            return decodeUTF32(contentArray);
        }

        /**
         * Create a native string from a Java string.
         *
         * @param string The Java string to create the native string from.
         * @return The native string.
         */
        private static StringNative nativeStringFromContent(
            final String string
        ) {
            // Encode the string in UTF-32
            final byte[] contentArray = encodeUTF32(string);
            final int length = string.length();

            // Create the native array
            final Pointer contentArrayNative = UnmanagedMemory.malloc(
                contentArray.length
            );
            for(int i = 0 ; i < contentArray.length ; i++) {
                contentArrayNative.writeByte(i, contentArray[i]);
            }

            // Create the native string
            final StringNative res = NI_LIB.ada_create_string(
                (CIntPointer) contentArrayNative,
                length
            );

            // Free the memory
            UnmanagedMemory.free(contentArrayNative);

            // Return the result
            return res;
        }

    }

    /**
     * String encoded in UTF-32 (native endianness).
     */
    public static final class Text implements AutoCloseable {

        // ----- Class attributes -----

        /** Singleton that represents the none text. */
        public static final Text NONE = new Text(
            PointerWrapper.nullPointer(),
            0,
            false
        );

        // ----- Instance attributes -----

        /** The pointer to the characters. */
        private final PointerWrapper charPointer;

        /** The size of the text. */
        private final long length;

        /** If the text is allocated. */
        private final boolean isAllocated;

        /** If the text object is the owner of its buffer. */
        private final boolean isOwner;

        /** The content of the text in a Java string. */
        private String content;

        // ----- Constructors -----

        /**
         * Create a new text from its content.
         *
         * @param charPointer The pointer to the characters of the text.
         * @param length The length of the text in character.
         * @param isAllocated If the text is allocated in the memory.
         */
        Text(
            final PointerWrapper charPointer,
            final long length,
            final boolean isAllocated
        ) {
            this(
                charPointer,
                length,
                isAllocated,
                false,
                null
            );
        }

        /**
         * Create a new text from its content and buffer.
         *
         * @param charPointer The pointer to the characters of the text.
         * @param length The length of the text in character.
         * @param isAllocated If the text is allocated in the memory.
         * @param contentArray The characters of the text (for JNI)
         */
        Text(
            final PointerWrapper charPointer,
            final long length,
            final boolean isAllocated,
            final byte[] contentArray
        ) {
            this(
                charPointer,
                length,
                isAllocated,
                false,
                contentArray
            );
        }

        /**
         * Create a new text from its content and buffer.
         *
         * @param charPointer The pointer to the characters of the text.
         * @param length The length of the text in character.
         * @param isAllocated If the text is allocated in the memory.
         * @param isOwner If the Java object owns the text buffer.
         * @param contentArray The characters of the text
         * (as strings, this is only used in JNI mode).
         */
        private Text(
            final PointerWrapper charPointer,
            final long length,
            final boolean isAllocated,
            final boolean isOwner,
            final byte[] contentArray
        ) {
            this.charPointer = charPointer;
            this.length = length;
            this.isAllocated = isAllocated;
            this.isOwner = isOwner;

            if(contentArray != null) {
                this.content = decodeUTF32(contentArray);
            } else {
                this.content = null;
            }
        }

        /**
         * Create a new langkit text from its string content.
         *
         * @param content The content of the text in a Java string.
         * @return The newly created text.
         */
        public static Text create(
            final String content
        ) {
            final byte[] contentArray = encodeUTF32(content);

            if(ImageInfo.inImageCode()) {
                final PointerWrapper charPointer = new PointerWrapper(
                    toCBytes(contentArray)
                );
                return new Text(
                    charPointer,
                    (long) content.length(),
                    false,
                    true,
                    contentArray
                );
            } else {
                return JNI_LIB.ada_create_text(contentArray);
            }
        }

        // ----- Graal C API methods -----

        /**
         * Wrap the native text pointed by the given pointer.
         *
         * @param pointer The pointer to the native text to wrap.
         * @return The wrapped text.
         */
        static Text wrap(
            final WordPointer pointer
        ) {
            return wrap((TextNative) pointer.read());
        }

        /**
         * Wrap a text native value in the Java class.
         *
         * @param textNative The text native NI value.
         * @return The newly wrapped text.
         */
        static Text wrap(
            final TextNative textNative
        ) {
            return new Text(
                new PointerWrapper(textNative.get_chars()),
                textNative.get_length(),
                textNative.get_is_allocated() != 0
            );
        }

        /**
         * Unwrap the text in the given NI pointer.
         *
         * @param textNative The NI pointer to the native text structure.
         */
        void unwrap(
            final TextNative textNative
        ) {
            textNative.set_chars(this.charPointer.ni());
            textNative.set_length(this.length);
            textNative.set_is_allocated(this.isAllocated ? 1 : 0);
        }

        // ----- Instance methods -----

        /**
         * Get the content of the text in a Java string.
         *
         * @return the content of the text.
         */
        public String getContent() {
            // Content is null only when using the Graal C API.
            if(this.content == null) {
                final byte[] contentArray = new byte[(int) this.length * 4];
                for(int i = 0 ; i < contentArray.length ; i++) {
                    contentArray[i] = (
                        (CCharPointer) this.charPointer.ni()
                    ).read(i);
                }
                this.content = decodeUTF32(contentArray);
            }

            return this.content;
        }

        /** @see java.lang.AutoCloseable#close() */
        @Override
        public void close() {

            if(ImageInfo.inImageCode()) {
                if(this.isOwner) {
                    UnmanagedMemory.free(this.charPointer.ni());
                } else {
                    final TextNative textNative = StackValue.get(
                        TextNative.class
                    );
                    this.unwrap(textNative);
                    NI_LIB.ada_destroy_text(textNative);
                }
            } else {
                JNI_LIB.ada_destroy_text(this);
            }
            checkException();

        }

        // ----- Override methods -----

        @Override
        public String toString() {
            return this.getContent();
        }

    }

    /**
     * Location in a source file. Line and column numbers are one-based.
     */
    public static final class SourceLocation {

        // ----- Class attributes -----

        /** Singleton that represents the none source location. */
        public static final SourceLocation NONE = new SourceLocation(
            0,
            (short) 0
        );

        // ----- Instance attributes -----

        /** The line of the source location. */
        public final int line;

        /** The column of the source location. */
        public final short column;

        // ----- Constructors -----

        /**
         * Create a new source location from a line and a column.
         *
         * @param line The line of the source location.
         * @param column The column of the source location.
         */
        SourceLocation(
            final int line,
            final short column
        ) {
            this.line = line;
            this.column = column;
        }

        /**
         * Create a source location from its line and column.
         *
         * @param line The line.
         * @param column The column.
         * @return The newly create source location.
         */
        public static SourceLocation create(
            final int line,
            final short column
        ) {
            return new SourceLocation(
                line,
                column
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap the given source location in the Java class.
         *
         * @param pointer Pointer to the native source location.
         * @return The newly wrapper source location.
         */
        static SourceLocation wrap(
            final WordPointer pointer
        ) {
            return wrap((SourceLocationNative) pointer.read());
        }

        /**
         * Wrap a source location native value in the Java class.
         *
         * @param sourceLocationNative The source location NI native value.
         * @return The newly wrapped source location.
         */
        static SourceLocation wrap(
            final SourceLocationNative sourceLocationNative
        ) {
            return new SourceLocation(
                sourceLocationNative.get_line(),
                sourceLocationNative.get_column()
            );
        }

        /**
         * Uwrap the source location in the given NI pointer.
         *
         * @param sourceLocationNative The NI pointer to the native structure
         *  to fill.
         */
        public void unwrap(
            final SourceLocationNative sourceLocationNative
        ) {
            sourceLocationNative.set_line(this.line);
            sourceLocationNative.set_column(this.column);
        }

        // ----- Override methods -----

        @Override
        public String toString() {
            return this.line + ":" + this.column;
        }

    }

    /**
     * Location of a span of text in a source file.
     */
    public static final class SourceLocationRange {

        // ----- Class attributes -----

        /** Singleton that represents the none source location range. */
        public static final SourceLocationRange NONE =
            new SourceLocationRange(
                SourceLocation.NONE,
                SourceLocation.NONE
            );

        // ----- Instance attributes -----

        /** The start of the range. */
        public final SourceLocation start;

        /** The end of the range. */
        public final SourceLocation end;

        // ----- Constructors -----

        /**
         * Create a source location range from its bounds.
         *
         * @param start The start of the range.
         * @param end The end of the range.
         */
        SourceLocationRange(
            final SourceLocation start,
            final SourceLocation end
        ) {
            this.start = start;
            this.end = end;
        }

        /**
         * Create a new source location range from its bounds.
         *
         * @param start The starting bound.
         * @param end The ending bound.
         * @return The newly created source location range.
         */
        public static SourceLocationRange create(
            final SourceLocation start,
            final SourceLocation end
        ) {
            return new SourceLocationRange(
                start,
                end
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap the given source location range in the Java class.*
         *
         * @param pointer The pointer to the native source location range.
         * @return The newly wrapped source location range.
         */
        static SourceLocationRange wrap(
            final WordPointer pointer
        ) {
            return wrap((SourceLocationRangeNative) pointer.read());
        }

        /**
         * Wrap a source location range native value in the Java class.
         *
         * @param sourceLocationRangeNative The source location range NI
         * native value.
         * @return The newly wrapped source location range.
         */
        static SourceLocationRange wrap(
            final SourceLocationRangeNative sourceLocationRangeNative
        ) {
            return new SourceLocationRange(
                new SourceLocation(
                    sourceLocationRangeNative.get_start_line(),
                    sourceLocationRangeNative.get_start_column()
                ),
                new SourceLocation(
                    sourceLocationRangeNative.get_end_line(),
                    sourceLocationRangeNative.get_end_column()
                )
            );
        }

        /**
         * Uwrap the source location range in the given NI pointer.
         *
         * @param sourceLocationRangeNative The NI pointer to the native
         * structure to fill.
         */
        void unwrap(
            final SourceLocationRangeNative sourceLocationRangeNative
        ) {
            sourceLocationRangeNative.set_start_line(this.start.line);
            sourceLocationRangeNative.set_start_column(this.start.column);
            sourceLocationRangeNative.set_end_line(this.end.line);
            sourceLocationRangeNative.set_end_column(this.end.column);
        }

        // ----- Override methods -----

        @Override
        public String toString() {
            return this.start.toString() + "-" + this.end.toString();
        }

    }

    /**
     * Diagnostic for an analysis unit: cannot open the source file, parsing
     * error, ...
     */
    public static final class Diagnostic {

        // ----- Class attributes -----

        /** Singleton that represents the none diagnostic. */
        public static final Diagnostic NONE = new Diagnostic(
            SourceLocationRange.NONE,
            Text.NONE
        );

        // ----- Instance attributes -----

        /** The source location range of the diagnostic. */
        public final SourceLocationRange sourceLocationRange;

        /** The message of the diagnostic. */
        public final Text message;

        // ----- Constructors -----

        /**
         * Create a diagnostic from its content.
         *
         * @param sourceLocationRange The range of the diagnostic.
         * @param message The message of the diagnostic.
         */
        Diagnostic(
            final SourceLocationRange sourceLocationRange,
            final Text message
        ) {
            this.sourceLocationRange = sourceLocationRange;
            this.message = message;
        }

        /**
         * Create a new diagnostic from its content.
         *
         * @param sourceLocationRange The source location range concerned by
         * this diagnostic.
         * @param message The message of the diagnostic.
         * @return The newly created diagnostic
         */
        public static Diagnostic create(
            final SourceLocationRange sourceLocationRange,
            final Text message
        ) {
            return new Diagnostic(
                sourceLocationRange,
                message
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to a native diagnostic.
         *
         * @param pointer The pointer to the native diagnostic.
         * @return The wrapped diagnostic.
         */
        static Diagnostic wrap(
            final WordPointer pointer
        ) {
            return wrap((DiagnosticNative) pointer.read());
        }

        /**
         * Wrap a diagnostic native value in the Java class.
         *
         * @param diagnosticNative The diagnostic NI native value.
         * @return The newly wrapped diagnostic.
         */
        static Diagnostic wrap(
            final DiagnosticNative diagnosticNative
        ) {
            return new Diagnostic(
                new SourceLocationRange(
                    new SourceLocation(
                        diagnosticNative.get_start_line(),
                        diagnosticNative.get_start_column()
                    ),
                    new SourceLocation(
                        diagnosticNative.get_end_line(),
                        diagnosticNative.get_end_column()
                    )
                ),
                new Text(
                    new PointerWrapper(diagnosticNative.get_message_chars()),
                    diagnosticNative.get_message_length(),
                    diagnosticNative.get_message_is_allocated() != 0
                )
            );
        }

        /**
         * Unwrap the diagnostic in the given NI pointer.
         *
         * @param diagnosticNative The pointer to the native structure to
         * fill.
         */
        public void unwrap(
            final DiagnosticNative diagnosticNative
        ) {
            diagnosticNative.set_start_line(
                this.sourceLocationRange.start.line
            );
            diagnosticNative.set_start_column(
                this.sourceLocationRange.start.column
            );
            diagnosticNative.set_end_line(
                this.sourceLocationRange.end.line
            );
            diagnosticNative.set_end_column(
                this.sourceLocationRange.end.column
            );
            diagnosticNative.set_message_chars(
                this.message.charPointer.ni()
            );
            diagnosticNative.set_message_length(
                this.message.length
            );
            diagnosticNative.set_message_is_allocated(
                this.message.isAllocated ? 1 : 0
            );
        }

        // ----- Override methods -----

        @Override
        public String toString() {
            return this.message.toString()
                + " at <"
                + this.sourceLocationRange.toString()
                + ">";
        }

    }

    /**
     * Result of applying a rewriting session.
     *
     * On success, ``Success`` is true.
     *
     * On failure, ``Success`` is false, ``Unit`` is set to the unit on which
     * rewriting failed, and ``Diagnostics`` is set to related rewriting
     * errors.
     */
    public static final class RewritingApplyResult implements AutoCloseable {

        // ----- Instance attributes -----

        /** Whether the rewriting application was successful. */
        public final boolean success;

        /**
         * If the rewriting failed, this is the unit on which the rewriting
         * failed. Otherwise it is the None unit.
         */
        public final AnalysisUnit unit;

        /**
         * Number of diagnostics in the result. 0 if the apply has been a
         * success.
         */
        private final int diagnosticsCount;

        /** Pointer to the diagnostic array, null if successful. */
        private final PointerWrapper diagnosticsReference;

        /** Cache for the unwrapped diagnostics. */
        private Diagnostic[] diagnostics;

        // ----- Constructors ------

        /** Create a new rewriting result with its content. */
        RewritingApplyResult(
            final boolean success,
            final AnalysisUnit unit,
            final int diagnosticsCount,
            final PointerWrapper diagnosticsReference
        ) {
            this.success = success;
            this.unit = unit;
            this.diagnosticsCount = diagnosticsCount;
            this.diagnosticsReference = diagnosticsReference;
            this.diagnostics = null;
        }

        /** Shortcut creation method for success. */
        static RewritingApplyResult success() {
            return new RewritingApplyResult(
                true,
                AnalysisUnit.NONE,
                0,
                PointerWrapper.nullPointer()
            );
        }

        // ----- Graal C API methods -----

        /** Wrap a pointer to a native rewriting apply result. */
        static RewritingApplyResult wrap(
            final Pointer pointer
        ) {
            return wrap((RewritingApplyResultNative) pointer.readWord(0));
        }

        /** Wrap a native rewriting apply result to the Java class. */
        static RewritingApplyResult wrap(
            final RewritingApplyResultNative rewritingApplyResultNative
        ) {
            if(rewritingApplyResultNative.get_success() > 0) {
                return RewritingApplyResult.success();
            }
            return new RewritingApplyResult(
                false,
                AnalysisUnit.wrap(rewritingApplyResultNative.get_unit()),
                rewritingApplyResultNative.get_diagnostics_count(),
                new PointerWrapper(
                    rewritingApplyResultNative.get_diagnostics()
                )
            );
        }

        /** Unwrap the rewriting apply result to the provided native value. */
        void unwrap(
            final RewritingApplyResultNative rewritingApplyResultNative
        ) {
            rewritingApplyResultNative.set_success(this.success ? 1 : 0);
            rewritingApplyResultNative.set_unit(this.unit.unwrap());
            rewritingApplyResultNative.set_diagnostics_count(
                this.diagnosticsCount
            );
            rewritingApplyResultNative.set_diagnostics(
                (DiagnosticNative) this.diagnosticsReference.ni()
            );
        }

        // ----- Instance methods -----

        /** Unwrap all diagnostics, cache the result and return it */
        public Diagnostic[] getDiagnostics() {
            if(this.diagnostics == null) {
                if(this.success) {
                    this.diagnostics = new Diagnostic[0];
                } else {

                    if(ImageInfo.inImageCode()) {
                        this.diagnostics =
                            new Diagnostic[this.diagnosticsCount];
                        final Pointer diagnostics =
                            (Pointer) this.diagnosticsReference.ni();
                        DiagnosticNative diagnosticNative;
                        final int diagnosticNativeSize = SizeOf.get(
                            DiagnosticNative.class
                        );
                        for(int i = 0; i < this.diagnosticsCount; i++) {
                            diagnosticNative = WordFactory.unsigned(
                                diagnostics.add(i * diagnosticNativeSize)
                                        .rawValue()
                            );
                            this.diagnostics[i] = Diagnostic.wrap(
                                diagnosticNative
                            );
                        }
                    } else {
                        this.diagnostics =
                            JNI_LIB
                                .ada_rewriting_get_result_diagnostics(
                                    this.diagnosticsCount,
                                    this.diagnosticsReference.jni()
                                );
                    }

                }
            }
            return this.diagnostics;
        }

        /**
         * Free the result of the ``Apply`` operation.
         */
        @Override
        public void close() {

            if(ImageInfo.inImageCode()) {
                final RewritingApplyResultNative resultNative =
                    StackValue.get(RewritingApplyResultNative.class);
                unwrap(resultNative);
                NI_LIB.ada_rewriting_free_apply_result(resultNative);
            } else {
                JNI_LIB.ada_rewriting_free_apply_result(this);
            }

        }

    }

    /**
     * Interface to override how source files are fetched and decoded.
     */
    public static final class FileReader implements AutoCloseable {

        // ----- Class attributes -----

        /** Singleton that represents the none file reader. */
        public static final FileReader NONE = new FileReader(
            PointerWrapper.nullPointer()
        );

        // ----- Instance attributes -----

        /** The reference to the file reader */
        private final PointerWrapper reference;

        // ----- Constructors -----

        /**
         * Create a new file reader from its native reference.
         *
         * @param reference The reference to the native file reader.
         */
        FileReader(
            final PointerWrapper reference
        ) {
            this.reference = reference;
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to a native file reader.
         *
         * @param pointer The pointer to the native file reader.
         * @return The newly wrapped file reader.
         */
        static FileReader wrap(
            final WordPointer pointer
        ) {
            return wrap((FileReaderNative) pointer.read());
        }

        /**
         * Wrap the given file reader in the Java class.
         *
         * @param fileReaderNative The native file reader to wrap.
         * @return The wrapped file reader.
         */
        static FileReader wrap(
            final FileReaderNative fileReaderNative
        ) {
            return new FileReader(
                new PointerWrapper(fileReaderNative)
            );
        }

        /**
         * Unwrap the file reader in the given pointer.
         *
         * @param pointer The pointer to unwrap the file reader in.
         */
        void unwrap(
            final WordPointer pointer
        ) {
            pointer.write(0, this.unwrap());
        }

        /**
         * Get the unwrapped file reader.
         *
         * @return The unwrapped native file reader.
         */
        FileReaderNative unwrap() {
            return (FileReaderNative) this.reference.ni();
        }

        // ----- Instance methods -----

        /** @see java.lang.AutoCloseable#close() */
        @Override
        public void close() {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_dec_ref_file_reader(
                    this.reference.ni()
                );
            } else {
                JNI_LIB.ada_dec_ref_file_reader(this);
            }
            checkException();

        }

    }

    /**
     * Interface to fetch analysis units from a name and a unit kind.
     *
     * The unit provider mechanism provides an abstraction which assumes that
     * to any couple (unit name, unit kind) we can associate at most one source
     * file. This means that several couples can be associated to the same
     * source file, but on the other hand, only one one source file can be
     * associated to a couple.
     *
     * This is used to make the semantic analysis able to switch from one
     * analysis units to another.
     *
     * See the documentation of each unit provider for the exact semantics of
     * the unit name/kind information.
     */
    public static final class UnitProvider implements AutoCloseable {

        // ----- Class attributes -----

        /** Singleton that represents the none unit provider. */
        public static final UnitProvider NONE = new UnitProvider(
            PointerWrapper.nullPointer()
        );

        // ----- Instance attributes -----

        /** The reference to the unit provider */
        private final PointerWrapper reference;

        // ----- Constructors -----

        /**
         * Create a new unit provider with the reference to the native one.
         *
         * @param reference The reference to the native unit provider.
         */
        UnitProvider(
            final PointerWrapper reference
        ) {
            this.reference = reference;
        }

        // ----- Graal C API methods -----

        /**
         * Wrap the given pointer to a native unit provider.
         *
         * @param pointer The pointer to the native unit provider.
         * @return The wrapped unit provider.
         */
        static UnitProvider wrap(
            final WordPointer pointer
        ) {
            return wrap((UnitProviderNative) pointer.read());
        }

        /**
         * Wrap the given native unit provider.
         *
         * @param unitProviderNative The native unit provider.
         * @return The wrapped unit provider.
         */
        static UnitProvider wrap(
            final UnitProviderNative unitProviderNative
        ) {
            return new UnitProvider(
                new PointerWrapper(unitProviderNative)
            );
        }

        /**
         * Unwrap the unit provider in the given native pointer.
         *
         * @param pointer The pointer to place the native unit provider in.
         */
        void unwrap(
            final WordPointer pointer
        ) {
            pointer.write(this.unwrap());
        }

        /**
         * Get the native unit provider.
         *
         * @return The native unit provider.
         */
        UnitProviderNative unwrap() {
            return (UnitProviderNative) this.reference.ni();
        }

        // ----- Instance methods -----

        /** @see java.lang.AutoCloseable#close() */
        public void close() {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_dec_ref_unit_provider(this.reference.ni());
            } else {
                JNI_LIB.ada_dec_ref_unit_provider(this);
            }
            checkException();

        }

    }

    /**
     * Interface to handle events sent by the analysis context.
     */
    public static final class EventHandler implements AutoCloseable {

        // ----- Class attributes -----

        /** Singleton that represents the none event handler. */
        public static final EventHandler NONE = new EventHandler(
            PointerWrapper.nullPointer(),
            null,
            null
        );

        /** This map contains all created event handlers. */
        private static final Map<PointerWrapper, EventHandler>
            eventHandlerCache = new ConcurrentHashMap<>();

        // ----- Instance attributes -----

        /** The reference to the native event handler. */
        private final PointerWrapper reference;

        /**
         * The Java callback when an analysis unit is requested in the
         * associated context.
         */
        private final UnitRequestedCallback unitRequestedCallback;

        /**
         * The Java callback when an analysis unit is parsed in the
         * associated context.
         */
        private final UnitParsedCallback unitParsedCallback;

        // ----- Constructors -----

        /**
         * Create a new event handler from its native reference.
         *
         * @param reference The reference to the native event handler.
         * @param unitRequestedCallback The callback for unit requests.
         * @param unitParsedCallback The callback for unit parsing.
         */
        EventHandler(
            final PointerWrapper reference,
            final UnitRequestedCallback unitRequestedCallback,
            final UnitParsedCallback unitParsedCallback
        ) {
            this.reference = reference;
            this.unitRequestedCallback = unitRequestedCallback;
            this.unitParsedCallback = unitParsedCallback;
        }

        /**
         * Create a new even handler with its callbacks. Callbacks can be null.
         *
         * @param unitRequestedCallback The callback for analysis unit requests.
         * @param unitParsedCallback The callback for analysis unit parsing.
         */
        public static EventHandler create(
            final UnitRequestedCallback unitRequestedCallback,
            final UnitParsedCallback unitParsedCallback
        ) {
            // Prepare the reference to the native event handler
            final PointerWrapper reference;

            if(ImageInfo.inImageCode()) {
                // Get the current thread
                final IsolateThread thread = CurrentIsolate.getCurrentThread();

                // Create the native event handler
                final EventHandlerNative resNative =
                    NI_LIB.ada_create_event_handler(
                        (VoidPointer) thread,
                        WordFactory.nullPointer(),
                        NI_LIB.unitRequestedFunction.getFunctionPointer(),
                        NI_LIB.unitParsedFunction.getFunctionPointer()
                    );

                // Set the result to the created event handler
                reference = new PointerWrapper(resNative);
            } else {
                reference = JNI_LIB.ada_create_event_handler(
                    unitRequestedCallback,
                    unitParsedCallback
                );
            }

            // Return the new event handler wrapped object
            return new EventHandler(
                reference,
                unitRequestedCallback,
                unitParsedCallback
            );
        }

        /**
         * Get event handler Java object from its native pointer.
         *
         * @param reference The pointer to the native event handler.
         * @return The associated Java event handler.
         */
        static EventHandler fromReference(
            final PointerWrapper reference
        ) {
            if(eventHandlerCache.containsKey(reference)) {
                return eventHandlerCache.get(reference);
            } else {
                throw new ReferenceException(
                    "Cannot get event handler from this reference: " +
                    reference.toString()
                );
            }
        }

        // ----- Graal C API methods -----

        /**
         * Wrap the given pointer to an event handler.
         *
         * @param pointer The pointer to the native event handler.
         * @return The wrapped event handler.
         */
        EventHandler wrap(
            final WordPointer pointer
        ) {
            return wrap((EventHandlerNative) pointer.read());
        }

        /**
         * Wrap the given native event handler.
         *
         * @param eventHandlerNative The native value of the event handler.
         * @return The wrapped event handler.
         */
        EventHandler wrap(
            final EventHandlerNative eventHandlerNative
        ) {
            return fromReference(new PointerWrapper(eventHandlerNative));
        }

        /**
         * Unwrap the event handler in the given native pointer.
         *
         * @param pointer The pointer to place the native event handler.
         */
        void unwrap(
            final WordPointer pointer
        ) {
            pointer.write(this.unwrap());
        }

        /**
         * Unwrap the event handler to a native value.
         *
         * @return The native value of the event handler.
         */
        EventHandlerNative unwrap() {
            return (EventHandlerNative) this.reference.ni();
        }

        // ----- Getters -----

        public UnitRequestedCallback getUnitRequestCallback() {
            return this.unitRequestedCallback;
        }

        public UnitParsedCallback getUnitParsedCallback() {
            return this.unitParsedCallback;
        }

        // ----- Instance methods -----

        /** @see java.lang.AutoCloseable#close() */
        public void close() {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_dec_ref_event_handler(this.reference.ni());
            } else {
                JNI_LIB.ada_dec_ref_event_handler(this);
            }
            checkException();

        }

        // ----- Inner classes -----

        /**
         * Callback that will be called when a unit is requested from the
         * context ``Context``.
         *
         * ``Name`` is the name of the requested unit.
         *
         * ``From`` is the unit from which the unit was requested.
         *
         * ``Found`` indicates whether the requested unit was found or not.
         *
         * ``Is_Not_Found_Error`` indicates whether the fact that the unit was
         * not found is an error or not.
         *
         * .. warning:: The interface of this callback is probably subject to
         *    change, so should be treated as experimental.
         */
        @FunctionalInterface
        public interface UnitRequestedCallback {
            void invoke(
                AnalysisContext context,
                String name,
                AnalysisUnit from,
                boolean found,
                boolean isNotFoundError
            );
        }

        /**
         * Callback that will be called when any unit is parsed from the
         * context ``Context``.
         *
         * ``Unit`` is the resulting unit.
         *
         * ``Reparsed`` indicates whether the unit was reparsed, or whether it
         * was the first parse.
         */
        @FunctionalInterface
        public interface UnitParsedCallback {
            void invoke(
                AnalysisContext context,
                AnalysisUnit unit,
                boolean reparsed
            );
        }

    }

    /**
     * Reference to a token in an analysis unit.
     */
    public static class Token {

        // ----- Instance attributes -----

        /**
         * We only store the reference to the context to avoid ref-count
         * problems. To access the token context go throught the
         * analysis unit.
         */
        protected final PointerWrapper contextRef;

        /** The unit of the token. */
        public final AnalysisUnit unit;

        /** The pointer to the token data handler. */
        protected final PointerWrapper tokenDataHandler;

        /** The index of the token. */
        public final int tokenIndex;

        /** The trivia index. */
        public final int triviaIndex;

        /** The kind of the token. */
        public final TokenKind kind;

        /** The text of the token. */
        protected final String text;

        /** The source location range of the token. */
        public final SourceLocationRange sourceLocationRange;

        // ----- Constructors -----

        /**
         * Create a new token from its content.
         *
         * @param contextRef The context of the token.
         * @param unit The unit which owns the token.
         * @param tokenDataHandler The pointer to the token data.
         * @param tokenIndex The index of the token.
         * @param triviaIndex The trivia index of the token.
         * @param kind The kind of the token in an integer.
         * @param text The text of the token.
         * @param sourceLocationRange The location of the token.
         */
        Token(
            final PointerWrapper contextRef,
            final AnalysisUnit unit,
            final PointerWrapper tokenDataHandler,
            final int tokenIndex,
            final int triviaIndex,
            final TokenKind kind,
            final String text,
            final SourceLocationRange sourceLocationRange
        ) {
            this.contextRef = contextRef;
            this.unit = unit;
            this.tokenDataHandler = tokenDataHandler;
            this.tokenIndex = tokenIndex;
            this.triviaIndex = triviaIndex;
            this.kind = kind;
            this.text = text;
            this.sourceLocationRange = sourceLocationRange;
        }

        // ----- Graal C API methods -----

        /**
         * Wrap the pointer to a native token.
         *
         * @param pointer The pointer to the native token.
         * @param unit The analysis unit which owns the token.
         * @return The wrapped token or a none value if the token is a none
         * one.
         */
        static Token wrap(
            final WordPointer pointer,
            final AnalysisUnit unit
        ) {
            return wrap(
                (TokenNative) pointer.read(),
                unit
            );
        }

        /**
         * Wrap a native token value in the Java class.
         *
         * @param tokenNative The native NI token value.
         * @param unit The analysis unit that owns the token.
         * @return The wrapped token or a none value if the token data
         * handler is null.
         */
        static Token wrap(
            final TokenNative tokenNative,
            final AnalysisUnit unit
        ) {
            if(tokenNative.get_data().isNull())
                return NONE(unit);

            // Fetch the token kind, source location range and text from the
            // tokenNative reference.
            final TokenKind kind = TokenKind.fromC(
                NI_LIB.ada_token_get_kind(tokenNative)
            );

            final SourceLocationRangeNative slocRangeNative =
                StackValue.get(SourceLocationRangeNative.class);
            NI_LIB.ada_token_sloc_range(
                tokenNative,
                slocRangeNative
            );
            final SourceLocationRange slocRange =
                SourceLocationRange.wrap(slocRangeNative);

            final TextNative textNative = StackValue.get(TextNative.class);
            NI_LIB.ada_token_range_text(
                tokenNative,
                tokenNative,
                textNative
            );
            final String text = Text.wrap(textNative).getContent();
            NI_LIB.ada_destroy_text(textNative);

            // Wrap them in a high-level Token instance
            return new Token(
                new PointerWrapper(tokenNative.get_context()),
                unit,
                new PointerWrapper(tokenNative.get_data()),
                tokenNative.get_token_index(),
                tokenNative.get_trivia_index(),
                kind,
                text,
                slocRange
            );
        }

        /**
         * Unwrap the token in the given NI pointer.
         *
         * @param tokenNative The NI pointer to the native structure to
         * fill.
         */
        public void unwrap(
            final TokenNative tokenNative
        ) {
            tokenNative.set_context(this.contextRef.ni());
            tokenNative.set_data(this.tokenDataHandler.ni());
            tokenNative.set_token_index(this.tokenIndex);
            tokenNative.set_trivia_index(this.triviaIndex);
        }

        // ----- Getters -----

        public String getText() {
            return this.text;
        }

        public boolean isTrivia() {
            return this.triviaIndex != 0;
        }

        public boolean isNone() {
            return false;
        }

        // ----- Class methods -----

        /**
         * Get a none token for the given unit.
         *
         * @param unit The unit to get a none token for.
         * @return The none token for the given unit.
         */
        public static Token NONE(
            final AnalysisUnit unit
        ) {
            return NoToken.getInstance(unit);
        }

        /**
         * Get the text from the start token to the end token.
         *
         * @param start The start token.
         * @param end The end token.
         * @return The text between the two tokens.
         */
        @CompilerDirectives.TruffleBoundary
        public static String textRange(
            final Token start,
            final Token end
        ) {

            if(ImageInfo.inImageCode()) {
                final TokenNative startNative = StackValue.get(
                    TokenNative.class
                );
                start.unwrap(startNative);

                final TokenNative endNative = StackValue.get(
                    TokenNative.class
                );
                end.unwrap(endNative);

                final TextNative textNative = StackValue.get(
                    TextNative.class
                );
                Text.NONE.unwrap(textNative);
                NI_LIB.ada_token_range_text(
                    startNative,
                    endNative,
                    textNative
                );
                try(final Text resText = Text.wrap(textNative)) {
                    return resText.getContent();
                }
            } else {
                try(
                    final Text resText = JNI_LIB.ada_token_range_text(
                        start,
                        end
                    )
                ) {
                    return resText.getContent();
                }
            }

        }

        // ----- Instance methods -----

        /**
         * Get the next token.
         *
         * @return The next token in the source.
         */
        public Token next() {

            if(ImageInfo.inImageCode()) {
                final TokenNative tokenNative = StackValue.get(
                    TokenNative.class
                );
                this.unwrap(tokenNative);

                final TokenNative nextNative = StackValue.get(
                    TokenNative.class
                );
                NI_LIB.ada_token_next(
                    tokenNative,
                    nextNative
                );
                return wrap(nextNative, this.unit);
            } else {
                return JNI_LIB.ada_token_next(this);
            }

        }

        /**
         * Get the previous token.
         *
         * @return The previous token in the source.
         */
        public Token previous() {

            if(ImageInfo.inImageCode()) {
                final TokenNative tokenNative = StackValue.get(
                    TokenNative.class
                );
                this.unwrap(tokenNative);

                final TokenNative previousNative = StackValue.get(
                    TokenNative.class
                );
                NI_LIB.ada_token_previous(
                    tokenNative,
                    previousNative
                );
                return wrap(previousNative, this.unit);
            } else {
                return JNI_LIB.ada_token_previous(this);
            }

        }

        /**
         * Check of the token is equivalent to the other one.
         *
         * @param other The other token to compare with.
         */
        public boolean isEquivalent(
            final Token other
        ) {

            if(ImageInfo.inImageCode()) {
                final TokenNative leftNative = StackValue.get(
                    TokenNative.class
                );
                this.unwrap(leftNative);

                final TokenNative rightNative = StackValue.get(
                    TokenNative.class
                );
                other.unwrap(rightNative);

                return NI_LIB.ada_token_is_equivalent(
                    leftNative,
                    rightNative
                ) != 0;
            } else {
                return JNI_LIB.ada_token_is_equivalent(this, other);
            }

        }

        // ----- Override methods -----

        @Override
        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "<Token Kind="
                + this.kind.name
                + " Text=\""
                + stringRepresentation(this.getText())
                + "\">";
        }

        @Override
        public boolean equals(
            Object o
        ) {
            if(o == this) return true;
            if(!(o instanceof Token)) return false;
            final Token other = (Token) o;
            return this.tokenDataHandler.equals(other.tokenDataHandler) &&
                    this.tokenIndex == other.tokenIndex &&
                    this.triviaIndex == other.triviaIndex;
        }

        // ----- Inner classes -----

        /**
        * This class represents the absence of token.
        */
        private static final class NoToken extends Token {

            // ----- Class attributes -----

            /** The map of the no token instances */
            private static final Map<AnalysisUnit, NoToken> instances
                = new HashMap<>();

            // ----- Constructors -----

            /**
            * Create a new no token for the given analysis unit.
            * The constructor is private to avoid too many instances.
            *
            * @param unit The analysis unit to create the no token for.
            */
            private NoToken(
                final PointerWrapper contextRef,
                final AnalysisUnit unit
            ) {
                super(
                    contextRef,
                    unit,
                    PointerWrapper.nullPointer(),
                    0,
                    0,
                    TokenKind.fromC(-1),
                    null,
                    SourceLocationRange.NONE
                );
            }

            /**
            * Get the no token instance for the given analysis unit.
            *
            * @param unit The unit to get the no token instance for.
            * @return The no token instance.
            */
            static NoToken getInstance(
                final AnalysisUnit unit
            ) {
                if(!instances.containsKey(unit)) {
                    try(AnalysisContext context = unit.getContext()) {
                        instances.put(
                            unit,
                            new NoToken(context.reference, unit)
                        );
                    }
                }
                return instances.get(unit);
            }

            // ----- Getters -----

            @Override
            public String getText() {
                return "";
            }

            // ----- Instance methods -----

            @Override
            public Token next() {
                return this;
            }

            @Override
            public Token previous() {
                return this;
            }

            @Override
            public boolean isEquivalent(
                final Token other
            ) {
                return other instanceof NoToken;
            }

            @Override
            public boolean isNone() {
                return true;
            }

            @Override
            public void unwrap(
                final TokenNative tokenNative
            ) {
                tokenNative.set_context(this.contextRef.ni());
                tokenNative.set_data(this.tokenDataHandler.ni());
                tokenNative.set_token_index(this.tokenIndex);
                tokenNative.set_trivia_index(this.triviaIndex);
            }

            // ----- Override methods -----

            @Override
            @CompilerDirectives.TruffleBoundary
            public String toString() {
                return "<Token Kind="
                    + this.kind.name
                    + " Text=\"\">";
            }

            @Override
            public boolean equals(
                Object o
            ) {
                return o == this;
            }

        }

    }

    /**
     * This type represents a context for all source analysis. This is the
     * first type you need to create to use Libadalang. It will contain the
     * results of all analysis, and is the main holder for all the data.
     *
     * You can create several analysis contexts if you need to, which enables
     * you, for example to:
     *
     * * analyze several different projects at the same time;
     *
     * * analyze different parts of the same projects in parallel.
     *
     * In the current design, contexts always keep all of their analysis units
     * allocated. If you need to get this memory released, the only option at
     * your disposal is to destroy your analysis context instance.
     */
    public static final class AnalysisContext implements AutoCloseable {

        // ----- Class attributes -----

        /** Singleton that represents the none analysis context. */
        public static final AnalysisContext NONE = new AnalysisContext(
            PointerWrapper.nullPointer(),
            null
        );

        /** This map contains all created analysis contexts. */
        private static final Map<PointerWrapper, AnalysisContext> contextCache
            = new ConcurrentHashMap<>();

        // ----- Instance attributes -----

        /** The reference to the native analysis context. */
        private final PointerWrapper reference;

        /** The event handler associated with the context. */
        private EventHandler eventHandler;

        /**
         * The rewriting context associated with this analysis context.
         * It can be the none value.
         */
        RewritingContext rewritingContext = RewritingContext.NONE;

        // ----- Constructors -----

        /**
         * Create a new analysis unit from its reference.
         *
         * @param reference The native analysis context.
         * @param eventHandler The associated event handler.
         */
        private AnalysisContext(
            final PointerWrapper reference,
            final EventHandler eventHandler
        ) {
            this.reference = reference;
            this.eventHandler = eventHandler;

            increaseRefCounter(this);
        }

        /**
         * Create a new analysis context from scratch with its configuration.
         *
         * @param charset The charset for the analysis context, it can be null.
         * @param fileReader The file reader for the analysis context, it
         * can be null.
         * @param unitProvider The unit provider for the analysis context,
         * it can be null.
         * @param eventHandler The event handler for the analysis context,
         * it can be null.
         * @param withTrivia If the analysis context should include trivias.
         * @param tabStop The effect of the tabulations on the column number.
         */
        private AnalysisContext(
            final String charset,
            final FileReader fileReader,
            final UnitProvider unitProvider,
            final EventHandler eventHandler,
            final boolean withTrivia,
            final int tabStop
        ) {
            // Call the function to allocate the native analysis context
            final PointerWrapper reference;
            if(ImageInfo.inImageCode()) {
                reference = new PointerWrapper(
                    NI_LIB.ada_allocate_analysis_context()
                );
            } else {
                reference = JNI_LIB.ada_create_analysis_context(
                    charset,
                    (fileReader == null ?
                        FileReader.NONE :
                        fileReader),
                    (unitProvider == null ?
                        UnitProvider.NONE :
                        unitProvider),
                    (eventHandler == null ?
                        EventHandler.NONE :
                        eventHandler),
                    withTrivia,
                    tabStop
                );
            }

            // Place the context in the cache for potention callbacks during
            // context initialization.
            this.reference = reference;
            this.eventHandler = eventHandler;
            contextCache.put(this.reference, this);

            // Perform the context initialization
            if(ImageInfo.inImageCode()) {
                final CCharPointer charsetNative =
                    charset == null ?
                    WordFactory.nullPointer() :
                    toCString(charset);

                NI_LIB.ada_initialize_analysis_context(
                    (AnalysisContextNative) reference.ni(),
                    charsetNative,
                    (fileReader == null ?
                        WordFactory.nullPointer() :
                        fileReader.reference.ni()),
                    (unitProvider == null ?
                        WordFactory.nullPointer() :
                        unitProvider.reference.ni()),
                    (eventHandler == null ?
                        WordFactory.nullPointer() :
                        eventHandler.reference.ni()),
                    (withTrivia ? 1 : 0),
                    tabStop
                );
                if(charset != null) UnmanagedMemory.free(charsetNative);
            }
        }

        /**
         * Create a new analysis context with the default parameters.
         *
         * @return The newly create analysis unit.
         */
        public static AnalysisContext create() {
            return new AnalysisContext(
                null,
                null,
                null,
                null,
                true,
                8
            );
        }

        /**
         * Create an analysis context with its parameters.
         *
         * @param charset The charset for the analysis context, it can be null.
         * @param fileReader The file reader for the analysis context, it
         * can be null.
         * @param unitProvider The unit provider for the analysis context,
         * it can be null.
         * @param eventHandler The event handler for the analysis context,
         * it can be null.
         * @param withTrivia If the analysis context should include trivias.
         * @param tabStop The effect of the tabulations on the column number.
         * @return The newly create analysis unit.
         */
        public static AnalysisContext create(
            final String charset,
            final FileReader fileReader,
            final UnitProvider unitProvider,
            final EventHandler eventHandler,
            final boolean withTrivia,
            final int tabStop
        ) {
            return new AnalysisContext(
                charset,
                fileReader,
                unitProvider,
                eventHandler,
                withTrivia,
                tabStop
            );
        }

        /**
         * Get the analysis context object from its reference.
         *
         * @param reference The native reference to the analysis context.
         * @param eventHandler The corresponding event handler.
         * @param setEventHandler Whether to set the result's eventHandler
         * field to eventHandler when there is already a cached
         * AnalysisContext.
         * @return The Java analysis unit associated with the reference.
         */
        static AnalysisContext fromReference(
            final PointerWrapper reference,
            final EventHandler eventHandler,
            final boolean setEventHandler
        ) {
            if(contextCache.containsKey(reference)) {
                final AnalysisContext res = contextCache.get(reference);
                increaseRefCounter(res);
                if(setEventHandler)
                    res.eventHandler = eventHandler;
                return res;
            } else {
                final AnalysisContext result =
                    new AnalysisContext(reference, eventHandler);
                contextCache.put(reference, result);
                return result;
            }
        }

        /**
         * Get the analysis context object from its reference.
         *
         * @param reference The native reference to the analysis context.
         * @return The Java analysis unit associated with the reference.
         */
        static AnalysisContext fromReference(
            final PointerWrapper reference
        ) {
            return fromReference(reference, null, false);
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a native pointer to the native analysis context in the
         * Java class.
         *
         * @param pointer The pointer to the NI analysis context
         * native value.
         * @return The newly wrapped analysis context.
         */
        static AnalysisContext wrap(
            final WordPointer pointer
        ) {
            return wrap((AnalysisContextNative) pointer.read());
        }

        /**
         * Wrap an analysis context native value in the Java class.
         *
         * @param analysisContextNative The NI analysis context native value.
         * @return The newly wrapped analysis context.
         */
        static AnalysisContext wrap(
            final AnalysisContextNative analysisContextNative
        ) {
            return fromReference(new PointerWrapper(analysisContextNative));
        }

        /**
         * Unwrap the analysis context in the given native pointer.
         *
         * @param pointer The pointer to place the native analysis unit.
         */
        void unwrap(
            final WordPointer pointer
        ) {
            pointer.write(this.unwrap());
        }

        /**
         * Get the native value of the analysis context.
         *
         * @return The native analysis context.
         */
        AnalysisContextNative unwrap() {
            return (AnalysisContextNative) this.reference.ni();
        }

        // ----- Getters -----

        public EventHandler getEventHandler() {
            return this.eventHandler;
        }

        /**
         * Get the currently open rewriting context associated to this
         * analysis context. The None rewriting context is returned if the
         * current context hasn't started a rewriting session.
         * @see AnalysisContext#startRewriting()
         */
        public RewritingContext getRewritingContext() {
            return this.rewritingContext;
        }

        // ----- Class methods -----

        /**
         * Increase the reference counter of the given context.
         *
         * @param context The context to increase the reference counter of.
         */
        private static void increaseRefCounter(
            final AnalysisContext context
        ) {
            // Increase the context reference counter of the context if not null
            if(!context.reference.isNull()) {
                if(ImageInfo.inImageCode()) {
                    NI_LIB.ada_context_incref(context.reference.ni());
                } else {
                    JNI_LIB.ada_context_incref(context.reference.jni());
                }
            }
        }

        // ----- Instance methods -----

        /**
         * Get an analysis unit from the given file in the current context.
         *
         * @param fileName The file to get the analysis unit from.
         * @return The new analysis unit.
         */
        public AnalysisUnit getUnitFromFile(
            final String fileName
        ) {
            return this.getUnitFromFile(
                fileName,
                null,
                false,
                DEFAULT_GRAMMAR_RULE
            );
        }

        /**
         * Get an analysis unit from the given file in the current context
         * with additional parameters.
         *
         * @param fileName The file to get the analysis unit from.
         * @param charset The charset of the given file.
         * @param reparse If the file should be reparsed.
         * @param rule The grammar rule to parse the source with.
         * @return The new analysis unit.
         */
        public AnalysisUnit getUnitFromFile(
            final String fileName,
            final String charset,
            final boolean reparse,
            final GrammarRule rule
        ) {

            if(ImageInfo.inImageCode()) {
                final CCharPointer fileNameNative = toCString(fileName);
                final CCharPointer charsetNative =
                    charset == null ?
                    WordFactory.nullPointer() :
                    toCString(charset);

                final AnalysisUnitNative resNative =
                    NI_LIB.ada_get_analysis_unit_from_file(
                    this.reference.ni(),
                    fileNameNative,
                    charsetNative,
                    (reparse ? 1 : 0),
                    rule.toC()
                );
                UnmanagedMemory.free(fileNameNative);
                if(charset != null) UnmanagedMemory.free(charsetNative);
                return AnalysisUnit.wrap(resNative);
            } else {
                return JNI_LIB.ada_get_analysis_unit_from_file(
                    this,
                    fileName,
                    charset,
                    reparse,
                    rule.toC()
                );
            }

        }

        /**
         * Get an analysis unit from the given buffer in the current context.
         *
         * @param buffer The buffer to parse.
         * @param name The name of the buffer.
         * @return The new analysis unit.
         */
        public AnalysisUnit getUnitFromBuffer(
            final String buffer,
            final String name
        ) {
            return this.getUnitFromBuffer(
                buffer,
                name,
                null,
                DEFAULT_GRAMMAR_RULE
            );
        }

        /**
         * Get an analysis unit from the given buffer in the current context
         * with additional parameters.
         *
         * @param buffer The buffer to parse.
         * @param name The name of the buffer.
         * @param charset The charset of the buffer.
         * @param rule The rule to parse the buffer with.
         * @return The new analysis unit.
         */
        public AnalysisUnit getUnitFromBuffer(
            final String buffer,
            final String name,
            final String charset,
            final GrammarRule rule
        ) {

            if(ImageInfo.inImageCode()) {
                final CCharPointer bufferNative = toCString(buffer);
                final CCharPointer nameNative = toCString(name);
                final CCharPointer charsetNative =
                    charset == null ?
                    WordFactory.nullPointer() :
                    toCString(charset);

                final AnalysisUnitNative resNative =
                    NI_LIB.ada_get_analysis_unit_from_buffer(
                    this.reference.ni(),
                    nameNative,
                    charsetNative,
                    bufferNative,
                    buffer.length(),
                    rule.toC()
                );
                UnmanagedMemory.free(bufferNative);
                UnmanagedMemory.free(nameNative);
                if(charset != null) UnmanagedMemory.free(charsetNative);
                return AnalysisUnit.wrap(resNative);
            } else {
                return JNI_LIB.ada_get_analysis_unit_from_buffer(
                    this,
                    name,
                    charset,
                    buffer,
                    buffer.length(),
                    rule.toC()
                );
            }

        }

        /**
         * Get an analysis unit from the given unit name and unit kind in the
         * current context with additional parameters.
         *
         * @param name Name of the unit.
         * @param kind Kind of the unit.
         * @param charset The charset of the buffer.
         * @param rule The rule to parse the buffer with.
         * @return The new analysis unit.
         */
        public AnalysisUnit getUnitFromProvider(
            final Text name,
            final AnalysisUnitKind kind,
            final String charset,
            final boolean reparse
        ) {
            if(ImageInfo.inImageCode()) {
                TextNative nameNative = StackValue.get(TextNative.class);
                name.unwrap(nameNative);
                final CCharPointer charsetNative =
                    charset == null ?
                    WordFactory.nullPointer() :
                    toCString(charset);
                final AnalysisUnitNative resNative =
                    NI_LIB.ada_get_analysis_unit_from_provider(
                    this.reference.ni(),
                    nameNative,
                    kind.toC(),
                    charsetNative,
                    (reparse ? 1 : 0)
                );
                if(charset != null) UnmanagedMemory.free(charsetNative);
                return AnalysisUnit.wrap(resNative);
            } else {
                return JNI_LIB.ada_get_analysis_unit_from_provider(
                    this,
                    name,
                    kind.toC(),
                    charset,
                    reparse
                );
            }
        }

        public AnalysisUnit getUnitFromProvider(
            final Text name,
            final AnalysisUnitKind kind
        ) {
            return this.getUnitFromProvider(name, kind, "", false);
        }

        /**
         * Start a rewriting session for Context.
         *
         * This handle will keep track of all changes to do on Context's
         * analysis units. Once the set of changes is complete, call the Apply
         * procedure to actually update Context. This makes it possible to
         * inspect the "old" Context state while creating the list of changes.
         *
         * There can be only one rewriting session per analysis context, so
         * this will raise an Existing_Rewriting_Handle_Error exception if
         * Context already has a living rewriting session.
         */
        public RewritingContext startRewriting() {
            final RewritingContext res;

            if(ImageInfo.inImageCode()) {
                final RewritingContextNative resNative =
                    NI_LIB.ada_rewriting_start_rewriting(
                        this.reference.ni()
                    );
                res = RewritingContext.wrap(resNative);
            } else {
                res = JNI_LIB.ada_rewriting_start_rewriting(this);
            }

            checkException();
            this.rewritingContext = res;
            return this.rewritingContext;
        }

        /** @see java.lang.AutoCloseable#close() */
        @Override
        public void close() {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_context_decref(this.reference.ni());
            } else {
                JNI_LIB.ada_context_decref(this.reference.jni());
            }
            checkException();

        }

        
      

        /**
         * Assign in ``Context`` configuration pragmas files to analysis units
         * as described in ``Global_Pragmas`` (configuration pragmas file that
         * applies to all analysis units, or null) and ``Local_Pragmas``
         * (mapping that associates an analysis unit to the local configuration
         * pragmas file that applies to it).
         *
         * This raises a ``Precondition_Failure`` exception if any analysis
         * unit in ``Mapping`` does not belong to ``Context`` or if an analysis
         * unit appears twice as a key in ``Mapping``.
         */
        public void setConfigPragmasMapping(
            AnalysisUnit globalPragmas,
            Map<AnalysisUnit, AnalysisUnit> localPragmas
        ) {
            // Create the flat array for local pragmas that the C API expects
            AnalysisUnit[] locals;
            int i = 0;
            int localCount;
            if (localPragmas == null) {
                localCount = 1;
                locals = new AnalysisUnit[localCount];
            } else {
                localCount = 2 * localPragmas.size() + 1;
                locals = new AnalysisUnit[localCount];
                for (Map.Entry<AnalysisUnit, AnalysisUnit> entry :
                     localPragmas.entrySet()) {
                    AnalysisUnit key = entry.getKey();
                    AnalysisUnit value = entry.getValue();

                    if (key == null)
                        throw new RuntimeException("localPragmas: null key");
                    if (value == null)
                        throw new RuntimeException("localPragmas: null value");

                    locals[i] = key;
                    locals[i + 1] = value;
                    i += 2;
                }
            }
            locals[i] = null;

            if(ImageInfo.inImageCode()) {
                final int unitSize = SizeOf.get(AnalysisUnitNative.class);
                final Pointer localPragmasNative = UnmanagedMemory.calloc(
                    localCount * unitSize
                );
                for (i = 0; i < localCount; ++i) {
                    final AnalysisUnitNative u =
                        locals[i] == null
                        ? WordFactory.nullPointer()
                        : locals[i].unwrap();
                    localPragmasNative.writeWord(unitSize * i, u);
                }

                final AnalysisUnitNative globalPragmasNative =
                    globalPragmas == null
                    ? WordFactory.nullPointer()
                    : globalPragmas.unwrap();

                NI_LIB.ada_set_config_pragmas_mapping(
                    this.reference.ni(),
                    globalPragmasNative,
                    localPragmasNative
                );
            } else {
                JNI_LIB.ada_set_config_pragmas_mapping(
                    this,
                    globalPragmas,
                    locals
                );
            }
            checkException();
        }



    }

    /**
     * This type represents the analysis of a single file.
     *
     * This type has strong-reference semantics and is ref-counted.
     * Furthermore, a reference to a unit contains an implicit reference to the
     * context that owns it. This means that keeping a reference to a unit will
     * keep the context and all the unit it contains allocated.
     */
    public static final class AnalysisUnit {

        // ----- Class attributes -----

        /** Singleton that represents the none analysis unit. */
        public static final AnalysisUnit NONE = new AnalysisUnit(
            PointerWrapper.nullPointer()
        );

        // ----- Instance attributes -----

        /** The reference to the native analysis unit. */
        private final PointerWrapper reference;

        /** The cache for the unit root. */
        private AdaNode root;

        // ----- Constructors -----

        /**
         * Create a new analysis unit from its value.
         *
         * @param reference The native analysis unit native value in
         * a pointer wrapper.
         */
        AnalysisUnit(
            final PointerWrapper reference
        ) {
            this.reference = reference;
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native analysis unit in the Java class.
         *
         * @param pointer The pointer the native analysis unit value.
         * @return The newly wrapped analysis unit.
         */
        static AnalysisUnit wrap(
            final WordPointer pointer
        ) {
            return wrap((AnalysisUnitNative) pointer.read());
        }

        /**
         * Wrap a NI analysis unit native value in the Java class.
         *
         * @param analysisUnitNative The NI analysis unit native value.
         * @return The newly wrapped analysis unit.
         */
        static AnalysisUnit wrap(
            final AnalysisUnitNative analysisUnitNative
        ) {
            return new AnalysisUnit(new PointerWrapper(analysisUnitNative));
        }

        /**
         * Unwrap the analysis unit in the given pointer.
         *
         * @param pointer The pointer to place the native analysis unit in.
         */
        void unwrap(
            final WordPointer pointer
        ) {
            pointer.write(this.unwrap());
        }

        /**
         * Unwrap the analysis unit as a native value.
         *
         * @return The native analysis unit.
         */
        AnalysisUnitNative unwrap() {
            return (AnalysisUnitNative) this.reference.ni();
        }

        // ----- Instance methods -----

        /**
         * Get the root node of the analysis unit.
         *
         * @return The root node.
         */
        public AdaNode getRoot() {
            if(this.root == null) {

                if(ImageInfo.inImageCode()) {
                    final EntityNative entityNative = StackValue.get(
                        EntityNative.class
                    );
                    NI_LIB.ada_unit_root(
                        this.reference.ni(),
                        entityNative
                    );
                    this.root = AdaNode.fromEntity(
                        Entity.wrap(entityNative)
                    );
                } else {
                    this.root = AdaNode.fromEntity(
                        JNI_LIB.ada_unit_root(this)
                    );
                }

            }
            return this.root;
        }

        /**
         * Get the analysis unit file name with its full path.
         *
         * @return The unit file name.
         */
        public String getFileName() {
            return this.getFileName(true);
        }

        /**
         * Get the unit's file name.
         *
         * @param fullPath If the method should return the
         * file full absolute path.
         * @return The file name.
         */
        @CompilerDirectives.TruffleBoundary
        public String getFileName(
            final boolean fullPath
        ) {
            final String absoluteFile;

            if(ImageInfo.inImageCode()) {
                final CCharPointer resNative = NI_LIB.ada_unit_filename(
                    this.reference.ni()
                );
                absoluteFile = toJString(resNative);
                NI_LIB.ada_free(resNative);
            } else {
                absoluteFile = JNI_LIB.ada_unit_filename(this);
            }

            if(fullPath) {
                return absoluteFile;
            } else {
                return new File(absoluteFile).getName();
            }
        }

        /**
         * Get the number of tokens in the analysis unit.
         *
         * @return The number of token.
         */
        public int getTokenCount() {

            if(ImageInfo.inImageCode()) {
                return NI_LIB.ada_unit_token_count(this.reference.ni());
            } else {
                return JNI_LIB.ada_unit_token_count(this);
            }

        }

        /**
         * Get the number of trivia in the analysis unit.
         *
         * @return The number of trivia.
         */
        public int getTriviaCount() {

            if(ImageInfo.inImageCode()) {
                return NI_LIB.ada_unit_trivia_count(
                    this.reference.ni()
                );
            } else {
                return JNI_LIB.ada_unit_trivia_count(this);
            }

        }

        /**
         * Return the first token of the analysis unit.
         *
         * @return The first token.
         */
        public Token getFirstToken() {

            if(ImageInfo.inImageCode()) {
                final TokenNative tokenNative = StackValue.get(
                    TokenNative.class
                );
                NI_LIB.ada_unit_first_token(
                    this.reference.ni(),
                    tokenNative
                );
                return Token.wrap(tokenNative, this);
            } else {
                return JNI_LIB.ada_unit_first_token(this);
            }

        }

        /**
         * Return the last token of the analysis unit.
         *
         * @return The last token.
         */
        public Token getLastToken() {

            if(ImageInfo.inImageCode()) {
                final TokenNative tokenNative = StackValue.get(
                    TokenNative.class
                );
                NI_LIB.ada_unit_last_token(
                    this.reference.ni(),
                    tokenNative
                );
                return Token.wrap(tokenNative, this);
            } else {
                return JNI_LIB.ada_unit_last_token(this);
            }

        }

        /**
         * Get the text of the analysis unit in a string.
         *
         * @return The text of the analysis unit source.
         */
        public String getText() {
            return Token.textRange(
                this.getFirstToken(),
                this.getLastToken()
            );
        }

        /**
         * Get the analysis context that owns the unit.
         *
         * @return The owning analysis context.
         */
        public AnalysisContext getContext() {

            if(ImageInfo.inImageCode()) {
                final AnalysisContextNative contextNative =
                    NI_LIB.ada_unit_context(this.reference.ni());
                return AnalysisContext.wrap(contextNative);
            } else {
                return JNI_LIB.ada_unit_context(this);
            }

        }

        /**
         * Get the list of associated diagnostics. Those are parsing errors.
         *
         * @return The diagnostics of the unit.
         */
        public Diagnostic[] getDiagnostics() {
            final int diagnosticCount;

            if(ImageInfo.inImageCode()) {
                diagnosticCount = NI_LIB.ada_unit_diagnostic_count(
                    this.reference.ni()
                );
            } else {
                diagnosticCount = JNI_LIB.ada_unit_diagnostic_count(
                    this
                );
            }

            Diagnostic[] res = new Diagnostic[diagnosticCount];

            if(ImageInfo.inImageCode()) {
                final DiagnosticNative diagnosticNative = StackValue.get(
                    DiagnosticNative.class
                );
                for(int i = 0 ; i < diagnosticCount ; i++) {
                    NI_LIB.ada_unit_diagnostic(
                        this.reference.ni(),
                        i,
                        diagnosticNative
                    );
                    res[i] = Diagnostic.wrap(diagnosticNative);
                }
            } else {
                for(int i = 0 ; i < diagnosticCount ; i++) {
                    res[i] = JNI_LIB.ada_unit_diagnostic(this, i);
                }
            }

            return res;
        }

        /**
         * Return the rewriting handle corresponding to Unit
         */
        public RewritingUnit getRewritingUnit() {
            final RewritingUnit res;

            if(ImageInfo.inImageCode()) {
                RewritingUnitNative rewritingUnitNative =
                    NI_LIB.ada_rewriting_unit_to_handle(
                        this.unwrap()
                    );
                res = RewritingUnit.wrap(rewritingUnitNative);
            } else {
                res = JNI_LIB.ada_rewriting_unit_to_handle(this);
            }

            checkException();
            return res;
        }

        // ----- Override methods -----

        @Override
        public String toString() {
            return "<AnalysisUnit \"" + this.getFileName(false) + "\">";
        }

        @Override
        public boolean equals(Object o) {
            if(this == o) return true;
            if(!(o instanceof AnalysisUnit)) return false;
            final AnalysisUnit other = (AnalysisUnit) o;
            return this.reference.equals(other.reference);
        }

    }

    /**
     * Handle for an analysis context rewriting session
     */
    public static final class RewritingContext implements AutoCloseable {

        // ----- Class attributes -----

        /** Singleton representing the none rewriting context */
        public static final RewritingContext NONE = new RewritingContext(
            PointerWrapper.nullPointer()
        );

        /**
         * This map contains all wrapped rewriting context associated to their
         * address.
         */
        private static final Map<PointerWrapper, RewritingContext> contextCache
            = new ConcurrentHashMap<>();

        // ----- Instance attributes -----

        /** The reference to the native rewriting context handle. */
        private final PointerWrapper reference;

        /**
         * Cache for the analysis context associated with this rewriting
         * context.
         */
        private AnalysisContext analysisContext;

        /** Whether the rewriting context has already been closed. */
        private boolean closed;

        // ----- Constructors -----

        /** Create a new rewriting context with its native reference. */
        private RewritingContext(
            final PointerWrapper reference
        ) {
            this.reference = reference;
            this.closed = false;
        }

        /**
         * From the given native reference, get the associate rewriting
         * context Java object. A native reference can only have one
         * associated Java instance.
         */
        @CompilerDirectives.TruffleBoundary
        static RewritingContext fromReference(
            final PointerWrapper reference
        ) {
            if(!contextCache.containsKey(reference)) {
                contextCache.put(
                    reference,
                    new RewritingContext(reference)
                );
            }
            final RewritingContext res = contextCache.get(reference);
            res.closed = false;
            return res;
        }

        // ----- Graal C API methods -----

        /** Wrap a native pointer to a native rewriting context. */
        static RewritingContext wrap(
            final Pointer pointer
        ) {
            return wrap((RewritingContextNative) pointer.readWord(0));
        }

        /** Wrap a native rewriting context. */
        static RewritingContext wrap(
            final RewritingContextNative rewritingContextNative
        ) {
            return fromReference(new PointerWrapper(rewritingContextNative));
        }

        /** Unwrap the analysis context in the given native pointer. */
        void unwrap(
            final Pointer pointer
        ) {
            pointer.writeWord(0, this.unwrap());
        }

        /** Unwrap the rewriting context as a native value. */
        RewritingContextNative unwrap() {
            return (RewritingContextNative) this.reference.ni();
        }

        // ----- Getters -----

        public boolean isClosed() {
            return this.closed;
        }


        /**
         * Return the analysis context associated to Handle
         */
        public AnalysisContext getAnalysisContext() {
            if(this.analysisContext == null) {

                if(ImageInfo.inImageCode()) {
                    this.analysisContext = AnalysisContext.wrap(
                        NI_LIB.ada_rewriting_handle_to_context(
                            this.unwrap()
                        )
                    );
                } else {
                    this.analysisContext =
                        JNI_LIB.ada_rewriting_handle_to_context(this);
                }

            }
            return this.analysisContext;
        }

        // ----- Instance methods -----

        /**
         * Return the list of unit rewriting handles in the given context
         * handle for units that the Apply primitive will modify.
         */
        public RewritingUnit[] rewritingUnits() {

            if(ImageInfo.inImageCode()) {
                // Get the native array
                final WordPointer unitArrayNative =
                    NI_LIB.ada_rewriting_unit_handles(this.unwrap());

                // Fill the Java result list
                final List<RewritingUnit> resList = new ArrayList<>();
                int cursor = 0;
                while(((Pointer) unitArrayNative.read(cursor)).isNonNull()) {
                    resList.add(RewritingUnit.wrap(
                        (RewritingUnitNative) unitArrayNative.read(cursor)
                    ));
                    cursor++;
                }

                // Free the native array
                NI_LIB.ada_free(unitArrayNative);

                // Return the Java list as an array
                return resList.toArray(new RewritingUnit[0]);
            } else {
                return JNI_LIB.ada_rewriting_unit_handles(this);
            }

        }

        /**
         * Create a new node of the given Kind, with empty text (for token
         * nodes) or children (for regular nodes).
         */
        public RewritingNode createNode(
            final NodeKind kind
        ) {
            final RewritingNode res;

            if(ImageInfo.inImageCode()) {
                res = RewritingNode.wrap(
                    NI_LIB.ada_rewriting_create_node(
                        this.unwrap(),
                        kind.toC()
                    )
                );
            } else {
                res = JNI_LIB.ada_rewriting_create_node(
                    this,
                    kind.toC()
                );
            }

            checkException();
            return res;
        }

        /**
         * Create a new regular node of the given Kind and assign it the given
         * Children.
         *
         * Except for lists, which can have any number of children, the size of
         * Children must match the number of children associated to the given
         * Kind. Besides, all given children must not be tied.
         */
        public RewritingNode createNode(
            final NodeKind kind,
            final RewritingNode... children
        ) {
            final RewritingNode res;

            if(ImageInfo.inImageCode()) {
                final WordPointer childrenNative =
                    rewritingNodesToNative(children);
                res = RewritingNode.wrap(
                    NI_LIB.ada_rewriting_create_regular_node(
                        this.unwrap(),
                        kind.toC(),
                        childrenNative,
                        children.length
                    )
                );
                UnmanagedMemory.free(childrenNative);
            } else {
                res = JNI_LIB.ada_rewriting_create_regular_node(
                    this,
                    kind.toC(),
                    children
                );
            }

            checkException();
            return res;
        }

        /**
         * Create a new token node with the given Kind and Text
         */
        public RewritingNode createTokenNode(
            final NodeKind kind,
            final String text
        ) {
            try (
                final Text nodeText = Text.create(text);
            ) {
                final RewritingNode res;

                if(ImageInfo.inImageCode()) {
                    final TextNative nodeTextNative = StackValue.get(
                        TextNative.class
                    );
                    nodeText.unwrap(nodeTextNative);
                    res = RewritingNode.wrap(
                        NI_LIB.ada_rewriting_create_token_node(
                            this.unwrap(),
                            kind.toC(),
                            nodeTextNative
                        )
                    );
                } else {
                    res = JNI_LIB.ada_rewriting_create_token_node(
                        this,
                        kind.toC(),
                        nodeText
                    );
                }

                checkException();
                return res;
            }
        }

        /**
         * Create a tree of new nodes from the given Template string, replacing
         * placeholders with nodes in Arguments and parsed according to the
         * given grammar Rule.
         */
        public RewritingNode createFromTemplate(
            final String template,
            final GrammarRule rule,
            final RewritingNode... arguments
        ) {
            try (
                final Text templateText = Text.create(template);
            ) {
                final RewritingNode res;

                if(ImageInfo.inImageCode()) {
                    final WordPointer argumentsNative =
                        rewritingNodesToNative(arguments);
                    TextNative templateTextNative =
                        StackValue.get(TextNative.class);
                    templateText.unwrap(templateTextNative);
                    res = RewritingNode.wrap(
                        NI_LIB.ada_rewriting_create_from_template(
                            this.unwrap(),
                            templateTextNative,
                            argumentsNative,
                            arguments.length,
                            rule.toC()
                        )
                    );
                    UnmanagedMemory.free(argumentsNative);
                } else {
                    res = JNI_LIB.ada_rewriting_create_from_template(
                        this,
                        templateText,
                        arguments,
                        rule.toC()
                    );
                }

                checkException();
                return res;
            }
        }

        /**
         * Apply all modifications to Handle's analysis context. If that
         * worked, close Handle and return (Success => True). Otherwise,
         * reparsing did not work, so keep Handle and its Context unchanged and
         * return details about the error that happened.
         *
         * Note that on success, this invalidates all related unit/node
         * handles.
         */
        public RewritingApplyResult apply() {
            final RewritingApplyResult res;

            if(ImageInfo.inImageCode()) {
                RewritingApplyResultNative resNative = StackValue.get(
                    RewritingApplyResultNative.class
                );
                NI_LIB.ada_rewriting_apply(
                    this.unwrap(),
                    resNative
                );
                res = RewritingApplyResult.wrap(resNative);
            } else {
                res = JNI_LIB.ada_rewriting_apply(this);
            }

            this.closed = res.success;
            return res;
        }

        /**
         * Discard all modifications registered in Handle and close Handle.
         * This invalidates all related unit/node handles.
         */
        public void close() {
            if(!this.closed) {
                if(this.analysisContext != null) {
                    this.analysisContext.close();
                    this.analysisContext = null;
                }

                if(ImageInfo.inImageCode()) {
                    NI_LIB.ada_rewriting_abort_rewriting(this.unwrap());
                } else {
                    JNI_LIB.ada_rewriting_abort_rewriting(this);
                }

                checkException();
                this.closed = true;
            }
        }

    }

    /**
     * Handle for the process of rewriting an analysis unit. Such handles are
     * owned by a Rewriting_Handle instance.
     */
    public static final class RewritingUnit {

        // ----- Class methods -----

        /** Singleton representing the none value for the rewriting unit. */
        public static final RewritingUnit NONE = new RewritingUnit(
            PointerWrapper.nullPointer()
        );

        // ----- Instance methods -----

        /** Reference to the native rewriting unit. */
        private final PointerWrapper reference;

        /** Cache for the analysis unit associated to the rewriting unit. */
        private AnalysisUnit analysisUnit;

        /** Cache for the unit root rewriting node. */
        private RewritingNode root;

        // ----- Constructors -----

        /** Create a new rewriting unit with its native reference. */
        RewritingUnit(
            final PointerWrapper reference
        ) {
            this.reference = reference;
        }

        // ----- Graal C API methods -----

        /** Wrap the given pointer to the native rewriting unit. */
        static RewritingUnit wrap(
            final Pointer pointer
        ) {
            return wrap((RewritingUnitNative) pointer.readWord(0));
        }

        /** Wrap the native rewriting unit. */
        static RewritingUnit wrap(
            final RewritingUnitNative rewritingUnitNative
        ) {
            return new RewritingUnit(new PointerWrapper(rewritingUnitNative));
        }

        /** Unwrap the rewriting unit in the given pointer. */
        void unwrap(
            final Pointer pointer
        ) {
            pointer.writeWord(0, this.unwrap());
        }

        /** Unwrap the rewriting unit and return its native value. */
        RewritingUnitNative unwrap() {
            return (RewritingUnitNative) this.reference.ni();
        }

        // ----- Getters -----

        /**
         * Return the unit corresponding to Handle
         */
        public AnalysisUnit getAnalysisUnit() {
            if(this.analysisUnit == null) {

                if(ImageInfo.inImageCode()) {
                    this.analysisUnit = AnalysisUnit.wrap(
                        NI_LIB.ada_rewriting_handle_to_unit(
                            this.unwrap()
                        )
                    );
                } else {
                    this.analysisUnit =
                        JNI_LIB.ada_rewriting_handle_to_unit(this);
                }

            }
            return this.analysisUnit;
        }

        /**
         * Return the node handle corresponding to the root of the unit which
         * Handle designates.
         */
        public RewritingNode getRoot() {
            if(this.root == null) {

                if(ImageInfo.inImageCode()) {
                    this.root = RewritingNode.wrap(
                        NI_LIB.ada_rewriting_unit_root(this.unwrap())
                    );
                } else {
                    this.root = JNI_LIB.ada_rewriting_unit_root(this);
                }

            }
            return this.root;
        }

        // ----- Setters -----

        /**
         * Set the root node for the unit Handle to Root. This unties the
         * previous root handle. If Root is not No_Node_Rewriting_Handle, this
         * also ties Root to Handle.
         *
         * Root must not already be tied to another analysis unit handle.
         */
        public void setRoot(
            final RewritingNode root
        ) {
            this.root = root;

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_rewriting_unit_set_root(
                    this.unwrap(),
                    root.unwrap()
                );
            } else {
                JNI_LIB.ada_rewriting_unit_set_root(this, root);
            }
        }

        // ----- Instance methods -----

        /**
         * Return the text associated to the given unit.
         */
        public String unparse() {
            final Text unparseText;

            if(ImageInfo.inImageCode()) {
                final TextNative textNative = StackValue.get(
                    TextNative.class
                );
                NI_LIB.ada_rewriting_unit_unparse(
                    this.unwrap(),
                    textNative
                );
                unparseText = Text.wrap(textNative);
            } else {
                unparseText = JNI_LIB.ada_rewriting_unit_unparse(this);
            }

            String res = unparseText.getContent();
            unparseText.close();
            return res;
        }

        // ----- Override methods -----

        @Override
        public boolean equals(Object o) {
            if(this == o) return true;
            if(!(o instanceof RewritingUnit)) return false;
            final RewritingUnit other = (RewritingUnit) o;
            return this.reference.equals(other.reference);
        }

    }

    /**
     * Handle for the process of rewriting an AST node. Such handles are owned
     * by a Rewriting_Handle instance.
     */
    public static final class RewritingNode {

        // ----- Class attributes -----

        /** Singleton representing the none value for rewriting node. */
        public static final RewritingNode NONE = new RewritingNode(
            PointerWrapper.nullPointer()
        );

        // ----- Instance attributes -----

        /** The reference to the native rewriting node. */
        private final PointerWrapper reference;

        /** Kind of the rewriting node. */
        private NodeKind kind;

        /** Cache for the associated parsed node. */
        private AdaNode parsedNode;

        /** Cache for the rewriting context containing this node. */
        private RewritingContext rewritingContext;

        // ----- Constructors -----

        /** Create a new rewriting node with its native reference. */
        RewritingNode(
            final PointerWrapper reference
        ) {
            this.reference = reference;
        }

        // ----- Graal C API -----

        /** Wrap a pointer to a native rewriting node. */
        static RewritingNode wrap(
            final Pointer pointer
        ) {
            return wrap((RewritingNodeNative) pointer.readWord(0));
        }

        /** Wrap the native rewriting node. */
        static RewritingNode wrap(
            final RewritingNodeNative rewritingNodeNative
        ) {
            return new RewritingNode(new PointerWrapper(rewritingNodeNative));
        }

        /** Unwrap the rewriting node in the given pointer. */
        void unwrap(
            final Pointer pointer
        ) {
            pointer.writeWord(0, this.unwrap());
        }

        /** Unwrap the rewriting node and return its native value. */
        RewritingNodeNative unwrap() {
            return (RewritingNodeNative) this.reference.ni();
        }

        // ----- Getters -----

        /**
         * Return the kind corresponding to Handle's node
         */
        public NodeKind getKind() {
            if(this.kind == null) {
                final int kindNative;

                if(ImageInfo.inImageCode()) {
                    kindNative = NI_LIB.ada_rewriting_kind(
                        this.unwrap()
                    );
                } else {
                    kindNative = JNI_LIB.ada_rewriting_kind(this);
                }

                this.kind = NodeKind.fromC(kindNative);
            }
            return this.kind;
        }

        /**
         * Return the node which the given rewriting Handle relates to. This
         * can be the null entity if this handle designates a new node.
         */
        public AdaNode getParsedNode() {
            if(this.parsedNode == null) {
                final Entity nodeEntity;

                if(ImageInfo.inImageCode()) {
                    final Pointer nodeNative =
                        NI_LIB.ada_rewriting_handle_to_node(
                            this.unwrap()
                        );
                    final EntityNative entityNative = StackValue.get(
                        EntityNative.class
                    );
                    NI_LIB.ada_create_bare_entity(
                        nodeNative,
                        entityNative
                    );
                    nodeEntity = Entity.wrap(entityNative);
                } else {
                    nodeEntity = JNI_LIB.ada_rewriting_handle_to_node(
                        this
                    );
                }

                this.parsedNode = AdaNode.fromEntity(nodeEntity);
            }
            return this.parsedNode;
        }

        /**
         * Return a handle for the rewriting context to which Handle belongs
         */
        public RewritingContext getRewritingContext() {
            if(this.rewritingContext == null) {

                if(ImageInfo.inImageCode()) {
                    this.rewritingContext = RewritingContext.wrap(
                        NI_LIB.ada_rewriting_node_to_context(
                            this.unwrap()
                        )
                    );
                } else {
                    this.rewritingContext =
                        JNI_LIB.ada_rewriting_node_to_context(this);
                }

            }
            return this.rewritingContext;
        }

        /** Get whether the rewriting node is a none node. */
        public boolean isNone() {
            return this.reference.isNull();
        }

        // ----- Instance methods -----

        /**
         * Create a clone of the Handle node tree. The result is not tied to
         * any analysis unit tree.
         */
        public RewritingNode clone() {

            if(ImageInfo.inImageCode()) {
                return RewritingNode.wrap(
                    NI_LIB.ada_rewriting_clone(this.unwrap())
                );
            } else {
                return JNI_LIB.ada_rewriting_clone(this);
            }

        }

        /**
         * Turn the given rewritten node Handles designates into text. This is
         * the text that is used in Apply in order to re-create an analysis
         * unit.
         */
        public String unparse() {
            final Text text;

            if(ImageInfo.inImageCode()) {
                TextNative textNative = StackValue.get(TextNative.class);
                NI_LIB.ada_rewriting_node_unparse(
                    this.unwrap(),
                    textNative
                );
                text = Text.wrap(textNative);
            } else {
                text = JNI_LIB.ada_rewriting_node_unparse(this);
            }

            final String res = text.getContent();
            text.close();
            return res;
        }

        /**
         * Return a representation of ``Handle`` as a string.
         */
        public String image() {
            final Text text;

            if(ImageInfo.inImageCode()) {
                TextNative textNative = StackValue.get(TextNative.class);
                NI_LIB.ada_rewriting_node_image(
                    this.unwrap(),
                    textNative
                );
                text = Text.wrap(textNative);
            } else {
                text = JNI_LIB.ada_rewriting_node_image(this);
            }

            final String res = text.getContent();
            text.close();
            return res;
        }

        /**
         * Return whether this node handle is tied to an analysis unit. If it
         * is not, it can be passed as the Child parameter to Set_Child.
         */
        public boolean isTied() {

            if(ImageInfo.inImageCode()) {
                return NI_LIB.ada_rewriting_tied(
                    this.unwrap()
                ) > 0;
            } else {
                return JNI_LIB.ada_rewriting_tied(this);
            }

        }

        /**
         * Return a handle for the node that is the parent of Handle's node.
         * This is ``No_Rewriting_Handle`` for a node that is not tied to any
         * tree yet.
         */
        public RewritingNode parent() {

            if(ImageInfo.inImageCode()) {
                return RewritingNode.wrap(
                    NI_LIB.ada_rewriting_parent(
                        this.unwrap()
                    )
                );
            } else {
                return JNI_LIB.ada_rewriting_parent(this);
            }

        }

        /**
         * Return the list of children for ``Handle``.
         */
        public RewritingNode[] children() {

            if(ImageInfo.inImageCode()) {
                // Call the native function
                final WordPointer childrenPointer =
                    StackValue.get(WordPointer.class);
                final CIntPointer countPointer =
                    StackValue.get(CIntPointer.class);
                NI_LIB.ada_rewriting_children(
                    this.unwrap(),
                    childrenPointer,
                    countPointer
                );
                final WordPointer children = childrenPointer.read();
                final int count = countPointer.read();

                // Create the Java array and fill it
                final RewritingNode[] res = new RewritingNode[count];
                for(int i = 0; i < res.length; i++) {
                    res[i] = RewritingNode.wrap(
                        (RewritingNodeNative) children.read(i)
                    );
                }

                // Free the native children
                NI_LIB.ada_free(children);

                // Return the result
                return res;
            } else {
                return JNI_LIB.ada_rewriting_children(this);
            }

        }

        /**
         * Return the node that is in the syntax ``Field`` for ``Handle``
         */
        public RewritingNode getChild(
            final MemberReference childMember
        ) {
            final RewritingNode res;

            if(ImageInfo.inImageCode()) {
                res = RewritingNode.wrap(
                    NI_LIB.ada_rewriting_child(
                        this.unwrap(),
                        childMember.toC()
                    )
                );
            } else {
                res = JNI_LIB.ada_rewriting_child(
                    this,
                    childMember.toC()
                );
            }

            checkException();
            return res;
        }

        /**
         * If ``Child`` is ``No_Rewriting_Node``, untie the syntax field in
         * ``Handle`` corresponding to ``Field``, so it can be attached to
         * another one. Otherwise, ``Child`` must have no parent as it will be
         * tied to ``Handle``'s tree.
         */
        public void setChild(
            MemberReference childMember,
            RewritingNode child
        ) {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_rewriting_set_child(
                    this.unwrap(),
                    childMember.toC(),
                    child.unwrap()
                );
            } else {
                JNI_LIB.ada_rewriting_set_child(
                    this,
                    childMember.toC(),
                    child
                );
            }
            checkException();

        }

        /**
         * If Handle is the root of an analysis unit, untie it and set New_Node
         * as its new root. Otherwise, replace Handle with New_Node in Handle's
         * parent node.
         *
         * Note that: * Handle must be tied to an existing analysis unit
         * handle. * New_Node must not already be tied to another analysis unit
         * handle.
         */
        public void replace(
            final RewritingNode newNode
        ) {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_rewriting_replace(
                    this.unwrap(),
                    newNode.unwrap()
                );
            } else {
                JNI_LIB.ada_rewriting_replace(this, newNode);
            }
            checkException();

        }

        /**
         * Assuming ``Handle`` refers to a list node, return a handle to its
         * first child, or ``No_Node_Rewriting_Handle``` if it has no child
         * node.
         */
        public RewritingNode firstChild() {

            if(ImageInfo.inImageCode()) {
                return RewritingNode.wrap(
                    NI_LIB.ada_rewriting_first_child(
                        this.unwrap()
                    )
                );
            } else {
                return JNI_LIB.ada_rewriting_first_child(this);
            }

        }

        /**
         * Assuming ``Handle`` refers to a list node, return a handle to its
         * last child, or ``No_Node_Rewriting_Handle``` if it has no child
         * node.
         */
        public RewritingNode lastChild() {

            if(ImageInfo.inImageCode()) {
                return RewritingNode.wrap(
                    NI_LIB.ada_rewriting_last_child(
                        this.unwrap()
                    )
                );
            } else {
                return JNI_LIB.ada_rewriting_last_child(this);
            }

        }

        /**
         * Assuming ``Handle`` refers to the child of a list node, return a
         * handle to its next sibling, or ``No_Node_Rewriting_Handle``` if it
         * is the last sibling.
         */
        public RewritingNode nextChild() {

            if(ImageInfo.inImageCode()) {
                return RewritingNode.wrap(
                    NI_LIB.ada_rewriting_next_child(
                        this.unwrap()
                    )
                );
            } else {
                return JNI_LIB.ada_rewriting_next_child(this);
            }

        }

        /**
         * Assuming ``Handle`` refers to the child of a list node, return a
         * handle to its previous sibling, or ``No_Node_Rewriting_Handle``` if
         * it is the first sibling.
         */
        public RewritingNode previousChild() {

            if(ImageInfo.inImageCode()) {
                return RewritingNode.wrap(
                    NI_LIB.ada_rewriting_previous_child(
                        this.unwrap()
                    )
                );
            } else {
                return JNI_LIB.ada_rewriting_previous_child(this);
            }

        }

        /**
         * Assuming ``Handle`` refers to the child of a list node, insert
         * ``New_Sibling`` as a new child in this list, right before
         * ``Handle``.
         */
        public void insertBefore(
            final RewritingNode toInsert
        ) {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_rewriting_insert_before(
                    this.unwrap(),
                    toInsert.unwrap()
                );
            } else {
                JNI_LIB.ada_rewriting_insert_before(this, toInsert);
            }
            checkException();

        }

        /**
         * Assuming ``Handle`` refers to the child of a list node, insert
         * ``New_Sibling`` as a new child in this list, right before
         * ``Handle``.
         */
        public void insertAfter(
            final RewritingNode toInsert
        ) {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_rewriting_insert_after(
                    this.unwrap(),
                    toInsert.unwrap()
                );
            } else {
                JNI_LIB.ada_rewriting_insert_after(this, toInsert);
            }
            checkException();

        }

        /**
         * Assuming ``Handle`` refers to a list node, insert ``New_Child`` to
         * be the first child in this list.
         */
        public void insertFirst(
            final RewritingNode toInsert
        ) {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_rewriting_insert_first(
                    this.unwrap(),
                    toInsert.unwrap()
                );
            } else {
                JNI_LIB.ada_rewriting_insert_first(this, toInsert);
            }
            checkException();

        }

        /**
         * Assuming ``Handle`` refers to a list node, insert ``New_Child`` to
         * be the last child in this list.
         */
        public void insertLast(
            final RewritingNode toInsert
        ) {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_rewriting_insert_last(
                    this.unwrap(),
                    toInsert.unwrap()
                );
            } else {
                JNI_LIB.ada_rewriting_insert_last(this, toInsert);
            }
            checkException();

        }

        /**
         * Assuming Handle refers to the child of a list node, remove it from
         * that list.
         */
        public void removeFromParent() {

            if(ImageInfo.inImageCode()) {
                NI_LIB.ada_rewriting_remove_child(this.unwrap());
            } else {
                JNI_LIB.ada_rewriting_remove_child(this);
            }
            checkException();

        }

        /** Get the text of the token node. */
        public String getText() {
            final Text resultText;

            if(ImageInfo.inImageCode()) {
                final TextNative textNative = StackValue.get(
                    TextNative.class
                );
                NI_LIB.ada_rewriting_text(
                    this.unwrap(),
                    textNative
                );
                resultText = Text.wrap(textNative);
            } else {
                resultText = JNI_LIB.ada_rewriting_text(this);
            }

            final String res = resultText.getContent();
            resultText.close();
            return res;
        }

        /**
         * Override text associated to the given token node.
         */
        public void setText(
            final String text
        ) {
            try (
                final Text nodeText = Text.create(text);
            ) {

                if(ImageInfo.inImageCode()) {
                    final TextNative textNative = StackValue.get(
                        TextNative.class
                    );
                    nodeText.unwrap(textNative);
                    NI_LIB.ada_rewriting_set_text(
                        this.unwrap(),
                        textNative
                    );
                } else {
                    JNI_LIB.ada_rewriting_set_text(this, nodeText);
                }
                checkException();

            }
        }

        // ----- Override methods -----

        @Override
        public String toString() {
            return this.image();
        }

        @Override
        public boolean equals(Object o) {
            if(o == this) return true;
            if(!(o instanceof RewritingNode)) return false;
            final RewritingNode other = (RewritingNode) o;
            return this.reference.equals(other.reference);
        }

    }

    // ===== Generated structure wrapping classes =====

        
    
    

    /**

     */
    public static final class Metadata {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final Metadata NONE = new Metadata(
            false,PointerWrapper.nullPointer(),PointerWrapper.nullPointer()
        );

        // ----- Instance attributes -----

        public final
        boolean
        dottableSubp;
        public final
        PointerWrapper
        primitive;
        public final
        PointerWrapper
        primitiveRealType;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        Metadata(
            final boolean dottableSubp,final PointerWrapper primitive,final PointerWrapper primitiveRealType
        ) {
            this.dottableSubp = dottableSubp;
            this.primitive = primitive;
            this.primitiveRealType = primitiveRealType;
        }

        /**
         * Create a new structure with the field values.
         */
        public static Metadata create(
            final boolean dottableSubp,final PointerWrapper primitive,final PointerWrapper primitiveRealType
        ) {
            return new Metadata(
                dottableSubp,primitive,primitiveRealType
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static Metadata wrap(
            final WordPointer pointer
        ) {
            return wrap((MetadataNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static Metadata wrap(
            final MetadataNative structNative
        ) {
            return new Metadata(
                BooleanWrapper.wrap(structNative.get_dottable_subp()),PointerWrapper.wrap(structNative.get_primitive()),PointerWrapper.wrap(structNative.get_primitive_real_type())
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final MetadataNative structNative
        ) {
            CCharPointer dottableSubpNative = structNative.address_dottable_subp();dottableSubpNative.write(this.dottableSubp ? (byte) 1 : (byte) 0);
            Pointer primitiveNative = structNative.address_primitive();primitiveNative.writeWord(0, this.primitive.ni());
            Pointer primitiveRealTypeNative = structNative.address_primitive_real_type();primitiveRealTypeNative.writeWord(0, this.primitiveRealType.ni());
        }


    }

        
    
    

    /**

     */
    public static final class EntityInfo {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final EntityInfo NONE = new EntityInfo(
            Metadata.NONE,PointerWrapper.nullPointer(),false
        );

        // ----- Instance attributes -----

        public final
        Metadata
        md;
        public final
        PointerWrapper
        rebindings;
        public final
        boolean
        fromRebound;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        EntityInfo(
            final Metadata md,final PointerWrapper rebindings,final boolean fromRebound
        ) {
            this.md = md;
            this.rebindings = rebindings;
            this.fromRebound = fromRebound;
        }

        /**
         * Create a new structure with the field values.
         */
        public static EntityInfo create(
            final Metadata md,final PointerWrapper rebindings,final boolean fromRebound
        ) {
            return new EntityInfo(
                md,rebindings,fromRebound
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static EntityInfo wrap(
            final WordPointer pointer
        ) {
            return wrap((EntityInfoNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static EntityInfo wrap(
            final EntityInfoNative structNative
        ) {
            return new EntityInfo(
                Metadata.wrap(structNative.address_md()),PointerWrapper.wrap(structNative.get_rebindings()),BooleanWrapper.wrap(structNative.get_from_rebound())
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final EntityInfoNative structNative
        ) {
            MetadataNative mdNative = structNative.address_md();this.md.unwrap(mdNative);
            Pointer rebindingsNative = structNative.address_rebindings();rebindingsNative.writeWord(0, this.rebindings.ni());
            CCharPointer fromReboundNative = structNative.address_from_rebound();fromReboundNative.write(this.fromRebound ? (byte) 1 : (byte) 0);
        }


    }

    
    

    /**

     */
    public static final class Entity {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final Entity NONE = new Entity(
            PointerWrapper.nullPointer(),EntityInfo.NONE
        );

        // ----- Instance attributes -----

        public final
        PointerWrapper
        node;
        public final
        EntityInfo
        info;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        Entity(
            final PointerWrapper node,final EntityInfo info
        ) {
            this.node = node;
            this.info = info;
        }

        /**
         * Create a new structure with the field values.
         */
        public static Entity create(
            final PointerWrapper node,final EntityInfo info
        ) {
            return new Entity(
                node,info
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static Entity wrap(
            final WordPointer pointer
        ) {
            return wrap((EntityNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static Entity wrap(
            final EntityNative structNative
        ) {
            return new Entity(
                PointerWrapper.wrap(structNative.get_node()),EntityInfo.wrap(structNative.address_info())
            );
        }

        /**
         * Special wrapping method to construct a new entity structure
         * from a native bare node pointer.
         */
        static Entity wrapBareNode(
            final Pointer bareNode
        ) {
            return new Entity(
                PointerWrapper.wrap(bareNode),EntityInfo.NONE
            );
        }

        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final EntityNative structNative
        ) {
            Pointer nodeNative = structNative.address_node();nodeNative.writeWord(0, this.node.ni());
            EntityInfoNative infoNative = structNative.address_info();this.info.unwrap(infoNative);
        }


    }

        
    
    

    /**
     * Composite field representing the aspect of an entity (:rmlink:`13`).
     */
    public static final class Aspect {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final Aspect NONE = new Aspect(
            false,AdaNode.NONE,Expr.NONE,false
        );

        // ----- Instance attributes -----

        public final
        boolean
        exists;
        public final
        AdaNode
        node;
        public final
        Expr
        value;
        public final
        boolean
        inherited;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        Aspect(
            final boolean exists,final AdaNode node,final Expr value,final boolean inherited
        ) {
            this.exists = exists;
            this.node = node;
            this.value = value;
            this.inherited = inherited;
        }

        /**
         * Create a new structure with the field values.
         */
        public static Aspect create(
            final boolean exists,final AdaNode node,final Expr value,final boolean inherited
        ) {
            return new Aspect(
                exists,node,value,inherited
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static Aspect wrap(
            final WordPointer pointer
        ) {
            return wrap((AspectNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static Aspect wrap(
            final AspectNative structNative
        ) {
            return new Aspect(
                BooleanWrapper.wrap(structNative.get_exists()),AdaNode.fromEntity(Entity.wrap(structNative.address_node())),Expr.fromEntity(Entity.wrap(structNative.address_value())),BooleanWrapper.wrap(structNative.get_inherited())
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final AspectNative structNative
        ) {
            CCharPointer existsNative = structNative.address_exists();existsNative.write(this.exists ? (byte) 1 : (byte) 0);
            EntityNative nodeNative = structNative.address_node();this.node.unwrap(nodeNative);
            EntityNative valueNative = structNative.address_value();this.value.unwrap(valueNative);
            CCharPointer inheritedNative = structNative.address_inherited();inheritedNative.write(this.inherited ? (byte) 1 : (byte) 0);
        }


    }

        
    
    

    /**

     */
    public static final class CompletionItem {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final CompletionItem NONE = new CompletionItem(
            BasicDecl.NONE,false,false,0
        );

        // ----- Instance attributes -----

        public final
        BasicDecl
        decl;
        public final
        boolean
        isDotCall;
        public final
        boolean
        isVisible;
        public final
        int
        weight;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        CompletionItem(
            final BasicDecl decl,final boolean isDotCall,final boolean isVisible,final int weight
        ) {
            this.decl = decl;
            this.isDotCall = isDotCall;
            this.isVisible = isVisible;
            this.weight = weight;
        }

        /**
         * Create a new structure with the field values.
         */
        public static CompletionItem create(
            final BasicDecl decl,final boolean isDotCall,final boolean isVisible,final int weight
        ) {
            return new CompletionItem(
                decl,isDotCall,isVisible,weight
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static CompletionItem wrap(
            final WordPointer pointer
        ) {
            return wrap((CompletionItemNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static CompletionItem wrap(
            final CompletionItemNative structNative
        ) {
            return new CompletionItem(
                BasicDecl.fromEntity(Entity.wrap(structNative.address_decl())),BooleanWrapper.wrap(structNative.get_is_dot_call()),BooleanWrapper.wrap(structNative.get_is_visible()),IntegerWrapper.wrap(structNative.get_weight())
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final CompletionItemNative structNative
        ) {
            EntityNative declNative = structNative.address_decl();this.decl.unwrap(declNative);
            CCharPointer isDotCallNative = structNative.address_is_dot_call();isDotCallNative.write(this.isDotCall ? (byte) 1 : (byte) 0);
            CCharPointer isVisibleNative = structNative.address_is_visible();isVisibleNative.write(this.isVisible ? (byte) 1 : (byte) 0);
            CIntPointer weightNative = structNative.address_weight();weightNative.write(this.weight);
        }


    }

        
        
    
    

    /**
     * Represent the range of a discrete type or subtype. The bounds are not
     * evaluated, you need to call ``eval_as_int`` on them, if they're static,
     * to get their value.
     */
    public static final class DiscreteRange {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final DiscreteRange NONE = new DiscreteRange(
            Expr.NONE,Expr.NONE
        );

        // ----- Instance attributes -----

        public final
        Expr
        lowBound;
        public final
        Expr
        highBound;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        DiscreteRange(
            final Expr lowBound,final Expr highBound
        ) {
            this.lowBound = lowBound;
            this.highBound = highBound;
        }

        /**
         * Create a new structure with the field values.
         */
        public static DiscreteRange create(
            final Expr lowBound,final Expr highBound
        ) {
            return new DiscreteRange(
                lowBound,highBound
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static DiscreteRange wrap(
            final WordPointer pointer
        ) {
            return wrap((DiscreteRangeNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static DiscreteRange wrap(
            final DiscreteRangeNative structNative
        ) {
            return new DiscreteRange(
                Expr.fromEntity(Entity.wrap(structNative.address_low_bound())),Expr.fromEntity(Entity.wrap(structNative.address_high_bound()))
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final DiscreteRangeNative structNative
        ) {
            EntityNative lowBoundNative = structNative.address_low_bound();this.lowBound.unwrap(lowBoundNative);
            EntityNative highBoundNative = structNative.address_high_bound();this.highBound.unwrap(highBoundNative);
        }


    }

        
    
    

    /**
     * Represent a set of values (as a list of choices) on a discriminant.
     */
    public static final class DiscriminantValues {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final DiscriminantValues NONE = new DiscriminantValues(
            Identifier.NONE,AlternativesList.NONE
        );

        // ----- Instance attributes -----

        public final
        Identifier
        discriminant;
        public final
        AlternativesList
        values;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        DiscriminantValues(
            final Identifier discriminant,final AlternativesList values
        ) {
            this.discriminant = discriminant;
            this.values = values;
        }

        /**
         * Create a new structure with the field values.
         */
        public static DiscriminantValues create(
            final Identifier discriminant,final AlternativesList values
        ) {
            return new DiscriminantValues(
                discriminant,values
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static DiscriminantValues wrap(
            final WordPointer pointer
        ) {
            return wrap((DiscriminantValuesNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static DiscriminantValues wrap(
            final DiscriminantValuesNative structNative
        ) {
            return new DiscriminantValues(
                Identifier.fromEntity(Entity.wrap(structNative.address_discriminant())),AlternativesList.fromEntity(Entity.wrap(structNative.address_values()))
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final DiscriminantValuesNative structNative
        ) {
            EntityNative discriminantNative = structNative.address_discriminant();this.discriminant.unwrap(discriminantNative);
            EntityNative valuesNative = structNative.address_values();this.values.unwrap(valuesNative);
        }


    }

        
    
    

    /**
     * Documentation annotation.
     */
    public static final class DocAnnotation {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final DocAnnotation NONE = new DocAnnotation(
            StringWrapper.NONE,StringWrapper.NONE
        );

        // ----- Instance attributes -----

        public final
        String
        key;
        public final
        String
        value;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        DocAnnotation(
            final String key,final String value
        ) {
            this.key = key;
            this.value = value;
        }

        /**
         * Create a new structure with the field values.
         */
        public static DocAnnotation create(
            final String key,final String value
        ) {
            return new DocAnnotation(
                key,value
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static DocAnnotation wrap(
            final WordPointer pointer
        ) {
            return wrap((DocAnnotationNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static DocAnnotation wrap(
            final DocAnnotationNative structNative
        ) {
            return new DocAnnotation(
                StringWrapper.wrap(structNative.get_key()),StringWrapper.wrap(structNative.get_value())
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final DocAnnotationNative structNative
        ) {
            WordPointer keyNative = structNative.address_key();StringWrapper.unwrap(this.key, keyNative);
            WordPointer valueNative = structNative.address_value();StringWrapper.unwrap(this.value, valueNative);
        }

        /**
         * Release the structure.
         *
         * @param structNative The native structure to release.
         */
        static void release(DocAnnotationNative structNative) {
            NI_LIB.ada_internal_doc_annotation_dec_ref(structNative);
        }

    }

        
        
        
        
        
    
    

    /**
     * Describes an interpretation of a reference. Can be attached to logic
     * atoms (e.g. Binds) to indicate under which interpretation this
     * particular atom was produced, which can in turn be used to produce
     * informative diagnostics for resolution failures.
     */
    public static final class LogicContext {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final LogicContext NONE = new LogicContext(
            AdaNode.NONE,AdaNode.NONE
        );

        // ----- Instance attributes -----

        public final
        AdaNode
        refNode;
        public final
        AdaNode
        declNode;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        LogicContext(
            final AdaNode refNode,final AdaNode declNode
        ) {
            this.refNode = refNode;
            this.declNode = declNode;
        }

        /**
         * Create a new structure with the field values.
         */
        public static LogicContext create(
            final AdaNode refNode,final AdaNode declNode
        ) {
            return new LogicContext(
                refNode,declNode
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static LogicContext wrap(
            final WordPointer pointer
        ) {
            return wrap((LogicContextNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static LogicContext wrap(
            final LogicContextNative structNative
        ) {
            return new LogicContext(
                AdaNode.fromEntity(Entity.wrap(structNative.address_ref_node())),AdaNode.fromEntity(Entity.wrap(structNative.address_decl_node()))
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final LogicContextNative structNative
        ) {
            EntityNative refNodeNative = structNative.address_ref_node();this.refNode.unwrap(refNodeNative);
            EntityNative declNodeNative = structNative.address_decl_node();this.declNode.unwrap(declNodeNative);
        }


    }

        
        
        
    
    

    /**
     * Data structure used by zip_with_params, Name.call_params,
     * GenericInstantiation.inst_params, BaseAggregate.aggregate_params,
     * SubtypeIndication.subtype_constraints, and EnumRepClause.params
     * properties. Associates an expression (the actual) to a formal param
     * declaration (the parameter).
     */
    public static final class ParamActual {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final ParamActual NONE = new ParamActual(
            DefiningName.NONE,Expr.NONE
        );

        // ----- Instance attributes -----

        public final
        DefiningName
        param;
        public final
        Expr
        actual;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        ParamActual(
            final DefiningName param,final Expr actual
        ) {
            this.param = param;
            this.actual = actual;
        }

        /**
         * Create a new structure with the field values.
         */
        public static ParamActual create(
            final DefiningName param,final Expr actual
        ) {
            return new ParamActual(
                param,actual
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static ParamActual wrap(
            final WordPointer pointer
        ) {
            return wrap((ParamActualNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static ParamActual wrap(
            final ParamActualNative structNative
        ) {
            return new ParamActual(
                DefiningName.fromEntity(Entity.wrap(structNative.address_param())),Expr.fromEntity(Entity.wrap(structNative.address_actual()))
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final ParamActualNative structNative
        ) {
            EntityNative paramNative = structNative.address_param();this.param.unwrap(paramNative);
            EntityNative actualNative = structNative.address_actual();this.actual.unwrap(actualNative);
        }


    }

        
        
        
    
    

    /**
     * Result for a cross reference query returning a reference.
     */
    public static final class RefResult {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final RefResult NONE = new RefResult(
            BaseId.NONE,RefResultKind.NONE
        );

        // ----- Instance attributes -----

        public final
        BaseId
        ref;
        public final
        RefResultKind
        kind;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        RefResult(
            final BaseId ref,final RefResultKind kind
        ) {
            this.ref = ref;
            this.kind = kind;
        }

        /**
         * Create a new structure with the field values.
         */
        public static RefResult create(
            final BaseId ref,final RefResultKind kind
        ) {
            return new RefResult(
                ref,kind
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static RefResult wrap(
            final WordPointer pointer
        ) {
            return wrap((RefResultNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static RefResult wrap(
            final RefResultNative structNative
        ) {
            return new RefResult(
                BaseId.fromEntity(Entity.wrap(structNative.address_ref())),RefResultKind.fromC(structNative.get_kind())
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final RefResultNative structNative
        ) {
            EntityNative refNative = structNative.address_ref();this.ref.unwrap(refNative);
            CIntPointer kindNative = structNative.address_kind();kindNative.write(this.kind.toC());
        }


    }

        
    
    

    /**
     * Result for a cross reference query returning a referenced decl.
     */
    public static final class RefdDecl {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final RefdDecl NONE = new RefdDecl(
            BasicDecl.NONE,RefResultKind.NONE
        );

        // ----- Instance attributes -----

        public final
        BasicDecl
        decl;
        public final
        RefResultKind
        kind;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        RefdDecl(
            final BasicDecl decl,final RefResultKind kind
        ) {
            this.decl = decl;
            this.kind = kind;
        }

        /**
         * Create a new structure with the field values.
         */
        public static RefdDecl create(
            final BasicDecl decl,final RefResultKind kind
        ) {
            return new RefdDecl(
                decl,kind
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static RefdDecl wrap(
            final WordPointer pointer
        ) {
            return wrap((RefdDeclNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static RefdDecl wrap(
            final RefdDeclNative structNative
        ) {
            return new RefdDecl(
                BasicDecl.fromEntity(Entity.wrap(structNative.address_decl())),RefResultKind.fromC(structNative.get_kind())
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final RefdDeclNative structNative
        ) {
            EntityNative declNative = structNative.address_decl();this.decl.unwrap(declNative);
            CIntPointer kindNative = structNative.address_kind();kindNative.write(this.kind.toC());
        }


    }

        
    
    

    /**
     * Result for a cross reference query returning a referenced defining name.
     */
    public static final class RefdDef {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final RefdDef NONE = new RefdDef(
            DefiningName.NONE,RefResultKind.NONE
        );

        // ----- Instance attributes -----

        public final
        DefiningName
        defName;
        public final
        RefResultKind
        kind;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        RefdDef(
            final DefiningName defName,final RefResultKind kind
        ) {
            this.defName = defName;
            this.kind = kind;
        }

        /**
         * Create a new structure with the field values.
         */
        public static RefdDef create(
            final DefiningName defName,final RefResultKind kind
        ) {
            return new RefdDef(
                defName,kind
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static RefdDef wrap(
            final WordPointer pointer
        ) {
            return wrap((RefdDefNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static RefdDef wrap(
            final RefdDefNative structNative
        ) {
            return new RefdDef(
                DefiningName.fromEntity(Entity.wrap(structNative.address_def_name())),RefResultKind.fromC(structNative.get_kind())
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final RefdDefNative structNative
        ) {
            EntityNative defNameNative = structNative.address_def_name();this.defName.unwrap(defNameNative);
            CIntPointer kindNative = structNative.address_kind();kindNative.write(this.kind.toC());
        }


    }

        
    
    

    /**
     * Represent one of the shapes that a variant record can have, as a list of
     * the available components.
     */
    public static final class Shape {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final Shape NONE = new Shape(
            BaseFormalParamDeclArrayWrapper.NONE,DiscriminantValuesArrayWrapper.NONE
        );

        // ----- Instance attributes -----

        public final
        BaseFormalParamDecl[]
        components;
        public final
        DiscriminantValues[]
        discriminantsValues;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        Shape(
            final BaseFormalParamDecl[] components,final DiscriminantValues[] discriminantsValues
        ) {
            this.components = components;
            this.discriminantsValues = discriminantsValues;
        }

        /**
         * Create a new structure with the field values.
         */
        public static Shape create(
            final BaseFormalParamDecl[] components,final DiscriminantValues[] discriminantsValues
        ) {
            return new Shape(
                components,discriminantsValues
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static Shape wrap(
            final WordPointer pointer
        ) {
            return wrap((ShapeNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static Shape wrap(
            final ShapeNative structNative
        ) {
            return new Shape(
                BaseFormalParamDeclArrayWrapper.wrap(structNative.get_components()),DiscriminantValuesArrayWrapper.wrap(structNative.get_discriminants_values())
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final ShapeNative structNative
        ) {
            WordPointer componentsNative = structNative.address_components();BaseFormalParamDeclArrayWrapper.unwrap(this.components, componentsNative);
            WordPointer discriminantsValuesNative = structNative.address_discriminants_values();DiscriminantValuesArrayWrapper.unwrap(this.discriminantsValues, discriminantsValuesNative);
        }

        /**
         * Release the structure.
         *
         * @param structNative The native structure to release.
         */
        static void release(ShapeNative structNative) {
            NI_LIB.ada_internal_shape_dec_ref(structNative);
        }

    }

        
    
    

    /**
     * A raw diagnostic produced by a solver resolution failure. This contains
     * as much information as possible to allow formatters down the chain to
     * filter/choose which diagnostics to show among a set of diagnostics
     * produced for a single equation.
     *
     * * ``Message_Template`` is a string explaining the error, which may
     *   contain holes represented by the ``{}`` characters.
     *
     * * ``Args`` is an array of nodes, which are to be plugged in the holes of
     *   the template in the same order (i.e. the first argument goes into the
     *   first hole of the template, etc.).
     *
     * * ``Location`` is a node which indicates the location of the error.
     *
     * * ``Contexts`` is the array of contexts that were deemed relevant for
     *   this error.
     *
     * * ``Round`` is the solver round during which this diagnostic was
     *   emitted.
     */
    public static final class SolverDiagnostic {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final SolverDiagnostic NONE = new SolverDiagnostic(
            StringWrapper.NONE,AdaNodeArrayWrapper.NONE,AdaNode.NONE,LogicContextArrayWrapper.NONE,0
        );

        // ----- Instance attributes -----

        public final
        String
        messageTemplate;
        public final
        AdaNode[]
        args;
        public final
        AdaNode
        location;
        public final
        LogicContext[]
        contexts;
        public final
        int
        round;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        SolverDiagnostic(
            final String messageTemplate,final AdaNode[] args,final AdaNode location,final LogicContext[] contexts,final int round
        ) {
            this.messageTemplate = messageTemplate;
            this.args = args;
            this.location = location;
            this.contexts = contexts;
            this.round = round;
        }

        /**
         * Create a new structure with the field values.
         */
        public static SolverDiagnostic create(
            final String messageTemplate,final AdaNode[] args,final AdaNode location,final LogicContext[] contexts,final int round
        ) {
            return new SolverDiagnostic(
                messageTemplate,args,location,contexts,round
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static SolverDiagnostic wrap(
            final WordPointer pointer
        ) {
            return wrap((SolverDiagnosticNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static SolverDiagnostic wrap(
            final SolverDiagnosticNative structNative
        ) {
            return new SolverDiagnostic(
                StringWrapper.wrap(structNative.get_message_template()),AdaNodeArrayWrapper.wrap(structNative.get_args()),AdaNode.fromEntity(Entity.wrapBareNode(structNative.get_location())),LogicContextArrayWrapper.wrap(structNative.get_contexts()),IntegerWrapper.wrap(structNative.get_round())
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final SolverDiagnosticNative structNative
        ) {
            WordPointer messageTemplateNative = structNative.address_message_template();StringWrapper.unwrap(this.messageTemplate, messageTemplateNative);
            WordPointer argsNative = structNative.address_args();AdaNodeArrayWrapper.unwrap(this.args, argsNative);
            Pointer locationNative = structNative.address_location();locationNative.writeWord(0, this.location.entity.node.ni());
            WordPointer contextsNative = structNative.address_contexts();LogicContextArrayWrapper.unwrap(this.contexts, contextsNative);
            CIntPointer roundNative = structNative.address_round();roundNative.write(this.round);
        }

        /**
         * Release the structure.
         *
         * @param structNative The native structure to release.
         */
        static void release(SolverDiagnosticNative structNative) {
            NI_LIB.ada_internal_solver_diagnostic_dec_ref(structNative);
        }

    }

        
        
    
    

    /**
     * Represent a substitution of a BasicDecl by a given value. This can then
     * be used as part of an environment in the eval_as_*_in_env property. See
     * the declaration of those properties for more details.
     */
    public static final class Substitution {

        // ----- Class attributes -----

        /** Singleton that represents the none value for the structure. */
        public static final Substitution NONE = new Substitution(
            BasicDecl.NONE,BigIntegerWrapper.NONE,BaseTypeDecl.NONE
        );

        // ----- Instance attributes -----

        public final
        BasicDecl
        fromDecl;
        public final
        BigInteger
        toValue;
        public final
        BaseTypeDecl
        valueType;

        // ----- Constructors -----

        /**
         * Create a new structure object from the value if its fields.
         */
        Substitution(
            final BasicDecl fromDecl,final BigInteger toValue,final BaseTypeDecl valueType
        ) {
            this.fromDecl = fromDecl;
            this.toValue = toValue;
            this.valueType = valueType;
        }

        /**
         * Create a new structure with the field values.
         */
        public static Substitution create(
            final BasicDecl fromDecl,final BigInteger toValue,final BaseTypeDecl valueType
        ) {
            return new Substitution(
                fromDecl,toValue,valueType
            );
        }

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to the native structure value in the Java class.
         *
         * @param niPointer The pointer to the NI structure native value.
         * @return The newly wrapped structure.
         */
        static Substitution wrap(
            final WordPointer pointer
        ) {
            return wrap((SubstitutionNative) pointer.read());
        }

        /**
         * Wrap the given structure native value in the Java class.
         *
         * @param structNative The NI structure native value.
         * @return The newly wrapped structure.
         */
        static Substitution wrap(
            final SubstitutionNative structNative
        ) {
            return new Substitution(
                BasicDecl.fromEntity(Entity.wrap(structNative.address_from_decl())),BigIntegerWrapper.wrap(structNative.get_to_value()),BaseTypeDecl.fromEntity(Entity.wrap(structNative.address_value_type()))
            );
        }


        /**
         * Unwrap the structure in the given native value.
         *
         * @param structNative The NI structure native value to fill.
         */
        void unwrap(
            final SubstitutionNative structNative
        ) {
            EntityNative fromDeclNative = structNative.address_from_decl();this.fromDecl.unwrap(fromDeclNative);
            WordPointer toValueNative = structNative.address_to_value();BigIntegerWrapper.unwrap(this.toValue, toValueNative);
            EntityNative valueTypeNative = structNative.address_value_type();this.valueType.unwrap(valueTypeNative);
        }

        /**
         * Release the structure.
         *
         * @param structNative The native structure to release.
         */
        static void release(SubstitutionNative structNative) {
            NI_LIB.ada_internal_substitution_dec_ref(structNative);
        }

    }

        

    // ===== Generated array utility classes =====

    
    

    /**
     * This class represents the ada_internal_aspect_array Java wrapping class
     */
    public static final class AspectArrayWrapper {

        // ----- Class attributes -----

        /** Singleton that represents the none array. */
        public static final Aspect[] NONE = new Aspect[0];

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to an array native value in the Java class.
         *
         * @param pointer The pointer to the array NI native value.
         * @return The newly wrapped array.
         */
        static Aspect[] wrap(
            final WordPointer pointer
        ) {
            return wrap((AspectArrayNative) pointer.read());
        }

        /**
         * Wrap an array native value in the Java class.
         *
         * @param nativeArray The NI array native value to wrap.
         * @return The newly wrapped array.
         */
        static Aspect[] wrap(
            final AspectArrayNative nativeArray
        ) {
            // Get the size and prepare the working variables
            final int size = nativeArray.get_n();
            final Aspect[] content = new Aspect[size];
            final Pointer nativeItems = nativeArray.address_items();
            Pointer nativeItem;
            AspectNative toRead;

            // Iterate over all array elements
            final int elemSize = SizeOf.get(AspectNative.class);
            for(int i = 0 ; i < size ; i++) {
                nativeItem = nativeItems.add(i * elemSize);
                toRead = WordFactory.unsigned(nativeItem.rawValue());
                content[i] = Aspect.wrap(toRead);
            }

            return content;
        }

        /**
         * Unwrap the array in the given pointer
         *
         * @param pointer The pointer to place the native array pointer
         * in.
         */
        static void unwrap(
            Aspect[] source,
            final WordPointer pointer
            
        ) {
            // Create a new native array with the size
            final AspectArrayNative resNative = unwrap(
                source
                
            );

            // Place the result in the pointer
            pointer.write(resNative);
        }

        /**
         * Allocate a new native array and unwrap inside.
         *
         * @return The newly allocated unwraped array.
         */
        static AspectArrayNative unwrap(
            Aspect[] source
            
        ) {
            // Create a new native array with the size
            final AspectArrayNative res = NI_LIB.ada_internal_aspect_array_create(
                source.length
            );

            // Prepare the working vars
            final Pointer nativeItems = res.address_items();
            Pointer nativeItem;
            AspectNative toWrite;

            // Place all elements in the native array
            final int elemSize = SizeOf.get(AspectNative.class);
            for(int i = 0 ; i < source.length ; i++) {
                nativeItem = nativeItems.add(i * elemSize);
                toWrite = WordFactory.unsigned(nativeItem.rawValue());
                source[i].unwrap(toWrite);
            }

            // Return the result
            return res;
        }

        /**
         * Release native array pointer by the given pointer.
         *
         * @param The pointer to the array to release.
         */
        static void release(
            final WordPointer pointer
        ) {
            release((AspectArrayNative) pointer.read());
        }

        /**
         * Release the given native array.
         *
         * @param arrayNative The native array to release.
         */
        static void release(
            final AspectArrayNative arrayNative
        ) {
            NI_LIB.ada_internal_aspect_array_dec_ref(arrayNative);
        }

        // ----- JNI methods -----

        /**
         * Create a new array from the JNI stub.
         *
         * @param content The unwrapped JNI content.
         */
        private static Aspect[] jniWrap(
            final Aspect[] jniContent
        ) {
            final Aspect[] content =
                new Aspect[jniContent.length];
            for(int i = 0 ; i < content.length ; i++) {
                content[i] =
                    jniContent[i];
            }
            return content;
        }

        /**
         * Get the content in an array unwrapped for the JNI stubs.
         *
         * @return The content unwrapped.
         */
        private static Aspect[] jniUnwrap(Aspect[] content) {
            final Aspect[] res =
                new Aspect[content.length];
            for(int i = 0 ; i < res.length ; i++) {
                res[i] = content[i];
            }
            return res;
        }

    }

    
    

    /**
     * This class represents the ada_internal_discriminant_values_array Java wrapping class
     */
    public static final class DiscriminantValuesArrayWrapper {

        // ----- Class attributes -----

        /** Singleton that represents the none array. */
        public static final DiscriminantValues[] NONE = new DiscriminantValues[0];

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to an array native value in the Java class.
         *
         * @param pointer The pointer to the array NI native value.
         * @return The newly wrapped array.
         */
        static DiscriminantValues[] wrap(
            final WordPointer pointer
        ) {
            return wrap((DiscriminantValuesArrayNative) pointer.read());
        }

        /**
         * Wrap an array native value in the Java class.
         *
         * @param nativeArray The NI array native value to wrap.
         * @return The newly wrapped array.
         */
        static DiscriminantValues[] wrap(
            final DiscriminantValuesArrayNative nativeArray
        ) {
            // Get the size and prepare the working variables
            final int size = nativeArray.get_n();
            final DiscriminantValues[] content = new DiscriminantValues[size];
            final Pointer nativeItems = nativeArray.address_items();
            Pointer nativeItem;
            DiscriminantValuesNative toRead;

            // Iterate over all array elements
            final int elemSize = SizeOf.get(DiscriminantValuesNative.class);
            for(int i = 0 ; i < size ; i++) {
                nativeItem = nativeItems.add(i * elemSize);
                toRead = WordFactory.unsigned(nativeItem.rawValue());
                content[i] = DiscriminantValues.wrap(toRead);
            }

            return content;
        }

        /**
         * Unwrap the array in the given pointer
         *
         * @param pointer The pointer to place the native array pointer
         * in.
         */
        static void unwrap(
            DiscriminantValues[] source,
            final WordPointer pointer
            
        ) {
            // Create a new native array with the size
            final DiscriminantValuesArrayNative resNative = unwrap(
                source
                
            );

            // Place the result in the pointer
            pointer.write(resNative);
        }

        /**
         * Allocate a new native array and unwrap inside.
         *
         * @return The newly allocated unwraped array.
         */
        static DiscriminantValuesArrayNative unwrap(
            DiscriminantValues[] source
            
        ) {
            // Create a new native array with the size
            final DiscriminantValuesArrayNative res = NI_LIB.ada_internal_discriminant_values_array_create(
                source.length
            );

            // Prepare the working vars
            final Pointer nativeItems = res.address_items();
            Pointer nativeItem;
            DiscriminantValuesNative toWrite;

            // Place all elements in the native array
            final int elemSize = SizeOf.get(DiscriminantValuesNative.class);
            for(int i = 0 ; i < source.length ; i++) {
                nativeItem = nativeItems.add(i * elemSize);
                toWrite = WordFactory.unsigned(nativeItem.rawValue());
                source[i].unwrap(toWrite);
            }

            // Return the result
            return res;
        }

        /**
         * Release native array pointer by the given pointer.
         *
         * @param The pointer to the array to release.
         */
        static void release(
            final WordPointer pointer
        ) {
            release((DiscriminantValuesArrayNative) pointer.read());
        }

        /**
         * Release the given native array.
         *
         * @param arrayNative The native array to release.
         */
        static void release(
            final DiscriminantValuesArrayNative arrayNative
        ) {
            NI_LIB.ada_internal_discriminant_values_array_dec_ref(arrayNative);
        }

        // ----- JNI methods -----

        /**
         * Create a new array from the JNI stub.
         *
         * @param content The unwrapped JNI content.
         */
        private static DiscriminantValues[] jniWrap(
            final DiscriminantValues[] jniContent
        ) {
            final DiscriminantValues[] content =
                new DiscriminantValues[jniContent.length];
            for(int i = 0 ; i < content.length ; i++) {
                content[i] =
                    jniContent[i];
            }
            return content;
        }

        /**
         * Get the content in an array unwrapped for the JNI stubs.
         *
         * @return The content unwrapped.
         */
        private static DiscriminantValues[] jniUnwrap(DiscriminantValues[] content) {
            final DiscriminantValues[] res =
                new DiscriminantValues[content.length];
            for(int i = 0 ; i < res.length ; i++) {
                res[i] = content[i];
            }
            return res;
        }

    }

    
    

    /**
     * This class represents the ada_internal_doc_annotation_array Java wrapping class
     */
    public static final class DocAnnotationArrayWrapper {

        // ----- Class attributes -----

        /** Singleton that represents the none array. */
        public static final DocAnnotation[] NONE = new DocAnnotation[0];

        // ----- Graal C API methods -----

        /**
         * Wrap a pointer to an array native value in the Java class.
         *
         * @param pointer The pointer to the array NI native value.
         * @return The newly wrapped array.
         */
        static DocAnnotation[] wrap(
            final WordPointer pointer
        ) {
            return wrap((DocAnnotationArrayNative) pointer.read());
        }

        /**
         * Wrap an array native value in the Java class.
         *
         * @param nativeArray The NI array native value to wrap.
         * @return The newly wrapped array.
         */
        static DocAnnotation[] wrap(
            final DocAnnotationArrayNative nativeArray
        ) {
            // Get the size and prepare the working variables
            final int size = nativeArray.get_n();
            final DocAnnotation[] content = new DocAnnotation[size];
            final Pointer nativeItems = nativeArray.address_items();
            Pointer nativeItem;
            DocAnnotationNative toRead;

            // Iterate over all array elements
            final int elemSize = SizeOf.get(DocAnnotationNative.class);
            for(int i = 0 ; i < size ; i++) {
                nativeItem = nativeItems.add(i * elemSize);
                toRead = WordFactory.unsigned(nativeItem.rawValue());
                content[i] = DocAnnotation.wrap(toRead);
            }

            return content;
        }

        /**
         * Unwrap the array in the given pointer
         *
         * @param pointer The pointer to place the native array pointer
         * in.
         */
        static void unwrap(
            DocAnnotation[] source,
            final WordPointer pointer
            
        ) {
            // Create a new native array with the size
            final DocAnnotationArrayNative resNative = unwrap(
                source
                
            );

            // Place the result in the pointer
            pointer.write(resNative);
        }

        /**
         * Allocate a new native array and unwrap inside.
         *
         * @return The newly allocated unwraped array.
         */
        static DocAnnotationArrayNative unwrap(
            DocAnnotation[] source
            
        ) {
            // Create a new native array with the size
            final DocAnnotationArrayNative res = NI_LIB.ada_internal_doc_annotation_array_create(
                source.length
            );

            // Prepare the working vars
            final Pointer nativeItems = res.address_items();
            Pointer nativeItem;
            DocAnnotationNative toWrite;

            // Place all elements in the native array
            final int elemSize = SizeOf.get(DocAnnotationNative.class);
            for(int i = 0 ; i < source.length ; i++) {
                nativeItem = nativeItems.add(i * elemSize);
                toWrite = WordFactory.unsigned(nativeItem.rawValue());
                source[i].unwrap(toWrite);
            }

            // Return the result
            return res;
        }

        /**
         * Release native array pointer by the given pointer.
         *
         * @param The pointer to the array to release.
         */
        static void release(
            final WordPointer pointer
        ) {
            release((DocAnnotationArrayNative) pointer.read());
        }

        /**
         * Release the given native array.
         *
         * @param arrayNative The native array to release.
         */
        static void release(
            final DocAnnotationArrayNative arrayNative
        ) {
            NI_LIB.ada_internal_doc_annotation_array_d