# The values below are for a copy of MOAB used directly
# from its build directory. These values will be overridden below
# for installed copies of MOAB.

# Feature list
MOAB_MPI_ENABLED = ON
MOAB_FORTRAN_ENABLED = ON
MOAB_HDF5_ENABLED = OFF
MOAB_NETCDF_ENABLED = OFF
MOAB_PNETCDF_ENABLED = OFF
MOAB_IGEOM_ENABLED = OFF
MOAB_IMESH_ENABLED = ON
MOAB_IREL_ENABLED = OFF
MOAB_FBIGEOM_ENABLED = OFF
MOAB_MESQUITE_ENABLED = OFF

# Library and Include paths
MOAB_LIBDIR = C:/M/B/src/build-MINGW64/src/.libs
MOAB_INCLUDES = -IC:/M/B/src/moab-5.3.1/src \
                -IC:/M/B/src/build-MINGW64/src \
                -IC:/M/B/src/moab-5.3.1/src/oldinc \
                -IC:/M/B/src/moab-5.3.1/src/verdict \
                -IC:/M/B/src/moab-5.3.1/src/parallel \
                -IC:/M/B/src/build-MINGW64/src/parallel \
                -IC:/M/B/src/moab-5.3.1/src/LocalDiscretization \
                -IC:/M/B/src/moab-5.3.1/src/RefineMesh

ifeq ($(MOAB_IGEOM_ENABLED),yes)
include 
MOAB_INCLUDES += $(IGEOM_INCLUDES)
endif

ifeq ($(MOAB_MESQUITE_ENABLED),yes)
MSQ_LIBDIR = C:/M/B/src/build-MINGW64/src/mesquite/.libs
MSQ_LIBS = -LC:/M/B/src/build-MINGW64/src/mesquite/.libs -lmbmesquite
MSQ_INCLUDES = -IC:/M/B/src/moab-5.3.1/src/mesquite/include \
	-IC:/M/B/src/build-MINGW64/src/mesquite/include \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/Mesh \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/Control \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/Wrappers \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/MappingFunction \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/MappingFunction/Lagrange \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/MappingFunction/Linear \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/Misc \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/ObjectiveFunction \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityAssessor \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityImprover \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityImprover/OptSolvers \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityImprover/Relaxation \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityMetric \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityMetric/Debug \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityMetric/Shape \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityMetric/Smoothness \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityMetric/TMP \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityMetric/Untangle \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/QualityMetric/Volume \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/TargetCalculator \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/TargetMetric \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/TargetMetric/Misc \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/TargetMetric/Shape \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/TargetMetric/ShapeOrient \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/TargetMetric/ShapeSize \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/TargetMetric/ShapeSizeOrient \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/TargetMetric/Size \
	-IC:/M/B/src/moab-5.3.1/src/mesquite/TargetMetric/Untangle

MOAB_INCLUDES += ${MSQ_INCLUDES}
endif

MOAB_INCLUDES += 

MOAB_CPPFLAGS = -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -pedantic -fpic -Wall -Wno-long-long -Wextra -Wno-cast-align -Wsign-compare -Wpointer-arith -Wformat -Wformat-security -Wunused-parameter -fstack-protector-all -mtune=native -fpermissive -Wno-ignored-attributes -Wno-variadic-macros -Wno-deprecated-declarations -Wno-unused-local-typedefs -ID:/a/msys64/mingw64/include/eigen3 -DUSE_MPI 
MOAB_CXXFLAGS = -O3 -DNDEBUG 
MOAB_CFLAGS = -O3 -DNDEBUG 
MOAB_FFLAGS = -funroll-all-loops -fno-f2c -O2
MOAB_FCFLAGS = 
MOAB_LDFLAGS =   

# missing support for DAMSEL, CCMIO
# PROBABLY FORMATTED INCORRECTLY
MOAB_EXT_LIBS =     \
                    \
                  D:/a/msys64/mingw64/lib/libopenblas.dll.a D:/a/msys64/mingw64/lib/libopenblas.dll.a  
MOAB_LIBS_LINK = ${MOAB_LDFLAGS} -L${MOAB_LIBDIR} -lMOAB ${MSQ_LIBS} $(MOAB_EXT_LIBS) 
DAGMC_LIBS_LINK = ${MOAB_LDFLAGS} -L${MOAB_LIBDIR}  -lMOAB ${MSQ_LIBS} $(MOAB_EXT_LIBS)

MOAB_CXX = D:/a/msys64/mingw64/bin/g++.exe
MOAB_CC  = D:/a/msys64/mingw64/bin/gcc.exe
MOAB_FC  = D:/a/msys64/mingw64/bin/gfortran.exe
MOAB_F77  = D:/a/msys64/mingw64/bin/gfortran.exe

# Override MOAB_LIBDIR and MOAB_INCLUDES from above with the correct
# values for the installed MOAB.

# NEED TO ADD SOMETHING TO MODIFY THIS FILE AT INSTALL TIME (OR FIX ISSUE #30)
