%define OT_SpectralModelFactory_doc
"Base class for spectral model factory.

Parameters
----------
mySpectralModelFactoryImplementation : :class:`~openturns.SpectralModelFactoryImplementation`
    One spectral factory algorithm.

    By default, the Welch factory algorithm :class:`~openturns.WelchFactory`.
   
Notes
-----
Let :math:`X: \\Omega \\times \\cD \\rightarrow \\Rset^d`  be a multivariate second order stationary process, with zero mean, where :math:`\\cD \\in \\Rset^n`. We only treat here the case where the domain is of dimension 1: :math:`\\cD \\in \\Rset` (*n=1*).

If we note :math:`C(\\vect{s}, \\vect{t})=\\Expect{(X_{\\vect{s}}-m(\\vect{s}))\\Tr{(X_{\\vect{t}}-m(\\vect{t}))}}` its covariance function, then for all :math:`(i,j), C^{stat}_{i,j} : \\Rset^n \\rightarrow \\Rset^n` is :math:`\\cL^1(\\Rset^n)` (ie :math:`\\int_{\\Rset^n} |C^{stat}_{i,j}(\\vect{\\tau})|\\di{\\vect{\\tau}}\\, < +\\infty`), with :math:`C^{stat}(\\vect{\\tau}) = C(\\vect{s}, \\vect{s}+\\vect{\\tau})` as this quantity does not depend on :math:`\\vect{s}`. 

The bilateral spectral density function :math:`S : \\Rset^n \\rightarrow \\mathcal{H}^+(d)` exists and is defined as the Fourier transform of the covariance function :math:`C^{stat}` :

.. math::

    \\forall \\vect{f} \\in \\Rset^n, \\,S(\\vect{f}) = \\int_{\\Rset^n}\\exp\\left\\{-2i\\pi <\\vect{f},\\vect{\\tau}> \\right\\} C^{stat}(\\vect{\\tau})\\di{\\vect{\\tau}}


where :math:`\\mathcal{H}^+(d) \\in \\mathcal{M}_d(\\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.

Depending on the available data, we proceed differently :

    -if the data correspond to  several independent  realizations of the  process, the estimation is done using the empirical estimator;

    - if the data correspond to one realization of the  process,  we suppose the process is ergodic to split the realization into several ones.
"

%enddef
%feature("docstring") OT::SpectralModelFactoryImplementation
OT_SpectralModelFactory_doc

// ---------------------------------------------------------------------

// ---------------------------------------------------------------------

%define OT_SpectralModelFactory_getFFTAlgorithm_doc
"Accessor to the FFT algorithm used for the Fourier transform.

Returns
-------
fftAlgo : :class:`~openturns.FFT` 
     The FFT algorithm used for the Fourier transform.
 "
%enddef
%feature("docstring") OT::SpectralModelFactoryImplementation::getFFTAlgorithm
OT_SpectralModelFactory_getFFTAlgorithm_doc

// ---------------------------------------------------------------------

%define OT_SpectralModelFactory_setFFTAlgorithm_doc
"Accessor to the FFT algorithm used for the Fourier transform.

Parameters
----------
fftAlgo : :class:`~openturns.FFT` 
     The FFT algorithm used for the Fourier transform.
 "
%enddef
%feature("docstring") OT::SpectralModelFactoryImplementation::setFFTAlgorithm
OT_SpectralModelFactory_setFFTAlgorithm_doc

// ---------------------------------------------------------------------

%define OT_SpectralModelFactory_build_doc
"Estimate the spectral model from data.

Available constructors:
    build(*myTimeSeries*)

    build(*myProcessSample*)

Parameters
----------
myTimeSeries : :class:`~openturns.TimeSeries` 
    The time series from which the spectral model is estimated.
myProcessSample : :class:`~openturns.ProcessSample` 
    The sample of time series from which the spectral model is estimated.

Returns
-------
mySpectralModel : :class:`~openturns.SpectralModel`
    The estimated spectral model.
 "
%enddef
%feature("docstring") OT::SpectralModelFactoryImplementation::build
OT_SpectralModelFactory_build_doc
