%feature("docstring") OT::DesignProxy
"Design matrix cache.

Available constructors:
    DesignProxy(*x, basis*)

    DesignProxy(*matrix*)

Parameters
----------
x : :class:`~openturns.Sample`
    Input sample
psi : sequence of :class:`~openturns.Function`
    Basis
matrix : 2-d sequence of float
The design matrix

Notes
-----
Helps to cache evaluations of the design matrix. Can be useful for an iterative
least squares problem resolution or in interaction with :class:`~openturns.LeastSquaresMethod`
to select the algorithm used for the resolution of linear least-squares problems.

Examples
--------
>>> import openturns as ot
>>> basisSize = 3
>>> sampleSize = 5
>>> X = ot.Sample(sampleSize, 1)
>>> X = ot.Sample.BuildFromPoint(range(1, 1 + sampleSize))
>>> phis = []
>>> for j in range(basisSize):
...     phis.append(ot.SymbolicFunction(['x'], ['x^' + str(j + 1)]))
>>> basis = ot.Basis(phis)
>>> proxy = ot.DesignProxy(X, phis)
"

// ---------------------------------------------------------------------

%feature("docstring") OT::DesignProxy::getInputSample
"Input sample accessor.

Returns
-------
inputSample : :class:`~openturns.Sample`
    Input sample."

// ---------------------------------------------------------------------

%feature("docstring") OT::DesignProxy::getBasis
"Accessor to the basis.

Parameters
----------
indices : sequence of int, optional
    Indices of the active functions in the basis

Returns
-------
activeBasis : Collection of :class:`~openturns.Function`
    Collection of functions of the basis associated to the given indices. By default, the whole basis."

// ---------------------------------------------------------------------

%feature("docstring") OT::DesignProxy::computeDesign
"Build the design matrix.

Parameters
----------
indices : sequence of int
    Indices of the current basis in the global basis

Returns
-------
psiAk : :class:`~openturns.Matrix`
    The design matrix"

// ---------------------------------------------------------------------

%feature("docstring") OT::DesignProxy::getRowFilter
"Row filter accessor.

Returns
-------
rowFilter : :class:`~openturns.Indices`
    Sub-indices in of the sample in the current indices"

// ---------------------------------------------------------------------

%feature("docstring") OT::DesignProxy::getSampleSize
"Sample size accessor.

Returns
-------
sampleSize : int
    Size of sample accounting for row filter"

// ---------------------------------------------------------------------

%feature("docstring") OT::DesignProxy::setRowFilter
"Row filter accessor.

Parameters
----------
rowFilter : sequence of int
    Sub-indices in of the sample in the current indices"

// ---------------------------------------------------------------------

%feature("docstring") OT::DesignProxy::hasRowFilter
"Row filter flag accessor.

Returns
-------
hasRowFilter : bool
    Whether sub-indices of the basis are set"
