/**
 *
 * @file d_spm.h
 *
 * SParse Matrix package precision dependent header.
 *
 * @copyright 2016-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 1.2.4
 * @author Pierre Ramet
 * @author Mathieu Faverge
 * @author Alban Bellot
 * @author Tony Delarue
 * @author Alycia Lisito
 * @date 2024-05-29
 *
 * @generated from C:/M/B/src/pastix/spm/include/spm/z_spm.h, normal z -> d, Tue Jul 16 06:40:11 2024
 *
 * @addtogroup spm_dev_integer
 * @{
 *
 **/
#ifndef _d_spm_h_
#define _d_spm_h_

/**
 * @brief Integer routines
 */
void d_spmIntFltSortAsc( void **const    pbase,
                         const spm_int_t n );
void d_spmIntIntFltSortAsc( void ** const   pbase,
                            const spm_int_t n );

/**
 * @}
 * @addtogroup spm_dev_convert
 * @{
 *
 * @brief Conversion routines
 */
int d_spmConvertCSC2CSR( spmatrix_t *spm );
int d_spmConvertCSC2IJV( spmatrix_t *spm );
int d_spmConvertCSR2CSC( spmatrix_t *spm );
int d_spmConvertCSR2IJV( spmatrix_t *spm );
int d_spmConvertIJV2CSC( spmatrix_t *spm );
int d_spmConvertIJV2CSR( spmatrix_t *spm );

void d_spm2dense( const spmatrix_t *spm, double *A );

/**
 * @}
 * @addtogroup spm_dev_matvec
 * @{
 *
 * @brief Matrix-Vector and matrix-matrix product routines
 */
int spm_dspmv( spm_trans_t            trans,
               double        alpha,
               const spmatrix_t      *A,
               const double *x,
               spm_int_t              incx,
               double        beta,
               double       *y,
               spm_int_t              incy );
int spm_dspmm( spm_side_t             side,
               spm_trans_t            transA,
               spm_trans_t            transB,
               spm_int_t              K,
               double        alpha,
               const spmatrix_t      *A,
               const double *B,
               spm_int_t              ldb,
               double        beta,
               double       *C,
               spm_int_t              ldc );

/**
 * @}
 * @addtogroup spm_dev_norm
 * @{
 *
 * @brief Norm computation routines
 */
double d_spmNorm( spm_normtype_t    ntype,
                  const spmatrix_t *spm );
double d_spmNormMat( spm_normtype_t         ntype,
                     const spmatrix_t      *spm,
                     spm_int_t              n,
                     const double *A,
                     spm_int_t              lda );

/**
 * @}
 * @addtogroup spm_dev_check
 * @{
 *
 * @brief Extra routines
 */
void d_spmSort( spmatrix_t *spm );
spm_int_t d_spmMergeDuplicate( spmatrix_t *spm );

/**
 * @}
 * @addtogroup spm_dev_rhs
 * @{
 *
 * @brief RHS routines
 */
int d_spmGenRHS( spm_rhstype_t     type,
                 int               nrhs,
                 const spmatrix_t *spm,
                 void             *x,
                 int               ldx,
                 void             *b,
                 int               ldb );
int d_spmGenMat( spm_rhstype_t           type,
                 int                     nrhs,
                 const spmatrix_t       *spm,
                 void                   *alpha,
                 unsigned long long int  seed,
                 void                   *A,
                 int                     lda );
int d_spmCheckAxb( spm_fixdbl_t      eps,
                   int               nrhs,
                   const spmatrix_t *spm,
                   void             *x0,
                   int               ldx0,
                   void             *b,
                   int               ldb,
                   const void       *x,
                   int               ldx );

void d_spmGatherRHS( int                    nrhs,
                     const spmatrix_t      *spm,
                     const double *x,
                     spm_int_t              ldx,
                     int                    root,
                     double       *gx,
                     spm_int_t              ldgx );

void d_spmReduceRHS( int               nrhs,
                     const spmatrix_t *spm,
                     double  *bglob,
                     spm_int_t         ldbg,
                     double  *bloc,
                     spm_int_t         ldbl );
void d_spmExtractLocalRHS( int                    nrhs,
                           const spmatrix_t      *spm,
                           const double *bglob,
                           spm_int_t              ldbg,
                           double       *bloc,
                           spm_int_t              ldbl );

/**
 * @}
 * @addtogroup spm_dev_print
 * @{
 *
 * @brief Output routines
 */
void d_spmPrint( FILE             *f,
                 const spmatrix_t *spm );
void d_spmPrintRHS( FILE             *f,
                    const spmatrix_t *spm,
                    int               nrhs,
                    const void       *x,
                    spm_int_t         ldx );
void d_spmDensePrint( FILE                  *f,
                      spm_int_t              m,
                      spm_int_t              n,
                      const double *A,
                      spm_int_t              lda );

/**
 * @}
 * @addtogroup spm_dev_dof
 * @{
 *
 * @brief DOF routines
 */
void d_spmExpand( const spmatrix_t *spm_in,
                  spmatrix_t       *spm_out );
void d_spmDofExtend( spmatrix_t *spm );

/**
 * @}
 * @addtogroup spm_dev_scal
 * @{
 *
 * @brief Scaling routines
 */
void d_spmScal( const double  alpha,
                spmatrix_t   *spm );

/**
 * @}
 * @addtogroup spm_dev_rhs
 * @{
 *
 * @brief Subroutines for random vector generation to be used in testings
 */
int d_spmRhsGenRndShm( const spmatrix_t      *spm,
                       double        scale,
                       spm_int_t              n,
                       double       *A,
                       spm_int_t              lda,
                       int                    shift,
                       unsigned long long int seed );
int d_spmRhsGenRndDist( const spmatrix_t      *spm,
                        double        scale,
                        spm_int_t              n,
                        double       *A,
                        spm_int_t              lda,
                        int                    shift,
                        unsigned long long int seed );

/**
 * @}
 */
#endif /* _d_spm_h_ */
