#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermathematicafinalizepackage_ PETSCVIEWERMATHEMATICAFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermathematicafinalizepackage_ petscviewermathematicafinalizepackage
#endif
PETSC_EXTERN void petscviewermathematicafinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = PetscViewerMathematicaFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermathematicainitializepackage_ PETSCVIEWERMATHEMATICAINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermathematicainitializepackage_ petscviewermathematicainitializepackage
#endif
PETSC_EXTERN void petscviewermathematicainitializepackage_(PetscErrorCode *ierr)
{
  *ierr = PetscViewerMathematicaInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermathematicaopen_ PETSCVIEWERMATHEMATICAOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermathematicaopen_ petscviewermathematicaopen
#endif
PETSC_EXTERN void petscviewermathematicaopen_(MPI_Fint *a, int *b, char c[], char d[], PetscViewer *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c, PETSC_FORTRAN_CHARLEN_T l_d)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscViewerMathematicaOpen(MPI_Comm_f2c(*(a)), *b, c_c, c_d, e);
  if (*ierr) return;
  FREECHAR(c, c_c);
  FREECHAR(d, c_d);
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermathematicaskippackets_ PETSCVIEWERMATHEMATICASKIPPACKETS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermathematicaskippackets_ petscviewermathematicaskippackets
#endif
PETSC_EXTERN void petscviewermathematicaskippackets_(PetscViewer *a, int *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerMathematicaSkipPackets(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermathematicasetname_ PETSCVIEWERMATHEMATICASETNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermathematicasetname_ petscviewermathematicasetname
#endif
PETSC_EXTERN void petscviewermathematicasetname_(PetscViewer *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerMathematicaSetName(v_a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermathematicaclearname_ PETSCVIEWERMATHEMATICACLEARNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermathematicaclearname_ petscviewermathematicaclearname
#endif
PETSC_EXTERN void petscviewermathematicaclearname_(PetscViewer *a, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerMathematicaClearName(v_a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermathematicaputmatrix_ PETSCVIEWERMATHEMATICAPUTMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermathematicaputmatrix_ petscviewermathematicaputmatrix
#endif
PETSC_EXTERN void petscviewermathematicaputmatrix_(PetscViewer *a, int *b, int *c, PetscReal *d, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLREAL(d);
  *ierr = PetscViewerMathematicaPutMatrix(v_a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewermathematicaputcsrmatrix_ PETSCVIEWERMATHEMATICAPUTCSRMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewermathematicaputcsrmatrix_ petscviewermathematicaputcsrmatrix
#endif
PETSC_EXTERN void petscviewermathematicaputcsrmatrix_(PetscViewer *a, int *b, int *c, int *d, int *e, PetscReal *f, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLREAL(f);
  *ierr = PetscViewerMathematicaPutCSRMatrix(v_a, *b, *c, d, e, f);
  if (*ierr) return;
}
