#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortedint_ PETSCSORTEDINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortedint_ petscsortedint
#endif
PETSC_EXTERN void petscsortedint_(PetscCount *a, const PetscInt b[], PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscSortedInt(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortedint64_ PETSCSORTEDINT64
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortedint64_ petscsortedint64
#endif
PETSC_EXTERN void petscsortedint64_(PetscCount *a, const PetscInt64 b[], PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscSortedInt64(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortint_ PETSCSORTINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortint_ petscsortint
#endif
PETSC_EXTERN void petscsortint_(PetscCount *a, PetscInt b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSortInt(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortint64_ PETSCSORTINT64
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortint64_ petscsortint64
#endif
PETSC_EXTERN void petscsortint64_(PetscCount *a, PetscInt64 b[], PetscErrorCode *ierr)
{
  *ierr = PetscSortInt64(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortcount_ PETSCSORTCOUNT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortcount_ petscsortcount
#endif
PETSC_EXTERN void petscsortcount_(PetscCount *a, PetscCount b[], PetscErrorCode *ierr)
{
  *ierr = PetscSortCount(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortreverseint_ PETSCSORTREVERSEINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortreverseint_ petscsortreverseint
#endif
PETSC_EXTERN void petscsortreverseint_(PetscCount *a, PetscInt b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSortReverseInt(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortedremovedupsint_ PETSCSORTEDREMOVEDUPSINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortedremovedupsint_ petscsortedremovedupsint
#endif
PETSC_EXTERN void petscsortedremovedupsint_(PetscInt *a, PetscInt b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(a);
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSortedRemoveDupsInt(a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortedcheckdupsint_ PETSCSORTEDCHECKDUPSINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortedcheckdupsint_ petscsortedcheckdupsint
#endif
PETSC_EXTERN void petscsortedcheckdupsint_(PetscCount *a, const PetscInt b[], PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscSortedCheckDupsInt(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortedcheckdupscount_ PETSCSORTEDCHECKDUPSCOUNT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortedcheckdupscount_ petscsortedcheckdupscount
#endif
PETSC_EXTERN void petscsortedcheckdupscount_(PetscCount *a, const PetscCount b[], PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscSortedCheckDupsCount(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortremovedupsint_ PETSCSORTREMOVEDUPSINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortremovedupsint_ petscsortremovedupsint
#endif
PETSC_EXTERN void petscsortremovedupsint_(PetscInt *a, PetscInt b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(a);
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSortRemoveDupsInt(a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfindint_ PETSCFINDINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfindint_ petscfindint
#endif
PETSC_EXTERN void petscfindint_(PetscInt *a, PetscCount *b, const PetscInt c[], PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscFindInt(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfindcount_ PETSCFINDCOUNT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfindcount_ petscfindcount
#endif
PETSC_EXTERN void petscfindcount_(PetscCount *a, PetscCount *b, const PetscCount c[], PetscCount *d, PetscErrorCode *ierr)
{
  *ierr = PetscFindCount(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccheckdupsint_ PETSCCHECKDUPSINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccheckdupsint_ petsccheckdupsint
#endif
PETSC_EXTERN void petsccheckdupsint_(PetscInt *a, const PetscInt b[], PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscCheckDupsInt(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfindmpiint_ PETSCFINDMPIINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfindmpiint_ petscfindmpiint
#endif
PETSC_EXTERN void petscfindmpiint_(PetscMPIInt *a, PetscCount *b, const PetscMPIInt c[], PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscFindMPIInt(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortintwitharray_ PETSCSORTINTWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortintwitharray_ petscsortintwitharray
#endif
PETSC_EXTERN void petscsortintwitharray_(PetscCount *a, PetscInt b[], PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSortIntWithArray(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortintwitharraypair_ PETSCSORTINTWITHARRAYPAIR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortintwitharraypair_ petscsortintwitharraypair
#endif
PETSC_EXTERN void petscsortintwitharraypair_(PetscCount *a, PetscInt b[], PetscInt c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscSortIntWithArrayPair(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortintwithmpiintarray_ PETSCSORTINTWITHMPIINTARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortintwithmpiintarray_ petscsortintwithmpiintarray
#endif
PETSC_EXTERN void petscsortintwithmpiintarray_(PetscCount *a, PetscInt b[], PetscMPIInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSortIntWithMPIIntArray(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortintwithcountarray_ PETSCSORTINTWITHCOUNTARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortintwithcountarray_ petscsortintwithcountarray
#endif
PETSC_EXTERN void petscsortintwithcountarray_(PetscCount *a, PetscInt b[], PetscCount c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSortIntWithCountArray(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortintwithintcountarraypair_ PETSCSORTINTWITHINTCOUNTARRAYPAIR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortintwithintcountarraypair_ petscsortintwithintcountarraypair
#endif
PETSC_EXTERN void petscsortintwithintcountarraypair_(PetscCount *a, PetscInt b[], PetscInt c[], PetscCount d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSortIntWithIntCountArrayPair(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortedmpiint_ PETSCSORTEDMPIINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortedmpiint_ petscsortedmpiint
#endif
PETSC_EXTERN void petscsortedmpiint_(PetscCount *a, const PetscMPIInt b[], PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscSortedMPIInt(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortmpiint_ PETSCSORTMPIINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortmpiint_ petscsortmpiint
#endif
PETSC_EXTERN void petscsortmpiint_(PetscCount *a, PetscMPIInt b[], PetscErrorCode *ierr)
{
  *ierr = PetscSortMPIInt(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortremovedupsmpiint_ PETSCSORTREMOVEDUPSMPIINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortremovedupsmpiint_ petscsortremovedupsmpiint
#endif
PETSC_EXTERN void petscsortremovedupsmpiint_(PetscInt *a, PetscMPIInt b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(a);
  *ierr = PetscSortRemoveDupsMPIInt(a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortmpiintwitharray_ PETSCSORTMPIINTWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortmpiintwitharray_ petscsortmpiintwitharray
#endif
PETSC_EXTERN void petscsortmpiintwitharray_(PetscCount *a, PetscMPIInt b[], PetscMPIInt c[], PetscErrorCode *ierr)
{
  *ierr = PetscSortMPIIntWithArray(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortmpiintwithintarray_ PETSCSORTMPIINTWITHINTARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortmpiintwithintarray_ petscsortmpiintwithintarray
#endif
PETSC_EXTERN void petscsortmpiintwithintarray_(PetscCount *a, PetscMPIInt b[], PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSortMPIIntWithIntArray(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortintwithscalararray_ PETSCSORTINTWITHSCALARARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortintwithscalararray_ petscsortintwithscalararray
#endif
PETSC_EXTERN void petscsortintwithscalararray_(PetscCount *a, PetscInt b[], PetscScalar c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLSCALAR(c);
  *ierr = PetscSortIntWithScalarArray(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortintwithdataarray_ PETSCSORTINTWITHDATAARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortintwithdataarray_ petscsortintwithdataarray
#endif
PETSC_EXTERN void petscsortintwithdataarray_(PetscCount *a, PetscInt b[], void *c, size_t *d, void *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSortIntWithDataArray(*a, b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscparallelsortedint_ PETSCPARALLELSORTEDINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscparallelsortedint_ petscparallelsortedint
#endif
PETSC_EXTERN void petscparallelsortedint_(MPI_Fint *a, PetscInt *b, const PetscInt c[], PetscBool *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLBOOL(d);
  *ierr = PetscParallelSortedInt(MPI_Comm_f2c(*(a)), *b, c, d);
  if (*ierr) return;
}
