#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatecentering_ MATCREATECENTERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatecentering_ matcreatecentering
#endif
PETSC_EXTERN void matcreatecentering_(MPI_Fint *a, PetscInt *b, PetscInt *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatCreateCentering(MPI_Comm_f2c(*(a)), *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
