#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdeflationsetinitonly_ PCDEFLATIONSETINITONLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdeflationsetinitonly_ pcdeflationsetinitonly
#endif
PETSC_EXTERN void pcdeflationsetinitonly_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCDeflationSetInitOnly(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdeflationsetlevels_ PCDEFLATIONSETLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdeflationsetlevels_ pcdeflationsetlevels
#endif
PETSC_EXTERN void pcdeflationsetlevels_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCDeflationSetLevels(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdeflationsetreductionfactor_ PCDEFLATIONSETREDUCTIONFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdeflationsetreductionfactor_ pcdeflationsetreductionfactor
#endif
PETSC_EXTERN void pcdeflationsetreductionfactor_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCDeflationSetReductionFactor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdeflationsetcorrectionfactor_ PCDEFLATIONSETCORRECTIONFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdeflationsetcorrectionfactor_ pcdeflationsetcorrectionfactor
#endif
PETSC_EXTERN void pcdeflationsetcorrectionfactor_(PC *a, PetscScalar *b, PetscErrorCode *ierr)
{
  *ierr = PCDeflationSetCorrectionFactor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdeflationsetspacetocompute_ PCDEFLATIONSETSPACETOCOMPUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdeflationsetspacetocompute_ pcdeflationsetspacetocompute
#endif
PETSC_EXTERN void pcdeflationsetspacetocompute_(PC *a, PCDeflationSpaceType *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PCDeflationSetSpaceToCompute(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdeflationsetspace_ PCDEFLATIONSETSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdeflationsetspace_ pcdeflationsetspace
#endif
PETSC_EXTERN void pcdeflationsetspace_(PC *a, Mat *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PCDeflationSetSpace(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdeflationsetprojectionnullspacemat_ PCDEFLATIONSETPROJECTIONNULLSPACEMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdeflationsetprojectionnullspacemat_ pcdeflationsetprojectionnullspacemat
#endif
PETSC_EXTERN void pcdeflationsetprojectionnullspacemat_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCDeflationSetProjectionNullSpaceMat(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdeflationsetcoarsemat_ PCDEFLATIONSETCOARSEMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdeflationsetcoarsemat_ pcdeflationsetcoarsemat
#endif
PETSC_EXTERN void pcdeflationsetcoarsemat_(PC *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = PCDeflationSetCoarseMat(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdeflationgetcoarseksp_ PCDEFLATIONGETCOARSEKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdeflationgetcoarseksp_ pcdeflationgetcoarseksp
#endif
PETSC_EXTERN void pcdeflationgetcoarseksp_(PC *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCDeflationGetCoarseKSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcdeflationgetpc_ PCDEFLATIONGETPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcdeflationgetpc_ pcdeflationgetpc
#endif
PETSC_EXTERN void pcdeflationgetpc_(PC *a, PC *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCDeflationGetPC(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
