#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacesumgetnumsubspaces_ PETSCSPACESUMGETNUMSUBSPACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacesumgetnumsubspaces_ petscspacesumgetnumsubspaces
#endif
PETSC_EXTERN void petscspacesumgetnumsubspaces_(PetscSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSpaceSumGetNumSubspaces(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacesumsetnumsubspaces_ PETSCSPACESUMSETNUMSUBSPACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacesumsetnumsubspaces_ petscspacesumsetnumsubspaces
#endif
PETSC_EXTERN void petscspacesumsetnumsubspaces_(PetscSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscSpaceSumSetNumSubspaces(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacesumgetconcatenate_ PETSCSPACESUMGETCONCATENATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacesumgetconcatenate_ petscspacesumgetconcatenate
#endif
PETSC_EXTERN void petscspacesumgetconcatenate_(PetscSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscSpaceSumGetConcatenate(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacesumsetconcatenate_ PETSCSPACESUMSETCONCATENATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacesumsetconcatenate_ petscspacesumsetconcatenate
#endif
PETSC_EXTERN void petscspacesumsetconcatenate_(PetscSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscSpaceSumSetConcatenate(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacesumgetsubspace_ PETSCSPACESUMGETSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacesumgetsubspace_ petscspacesumgetsubspace
#endif
PETSC_EXTERN void petscspacesumgetsubspace_(PetscSpace *a, PetscInt *b, PetscSpace *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSpaceSumGetSubspace(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacesumsetsubspace_ PETSCSPACESUMSETSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacesumsetsubspace_ petscspacesumsetsubspace
#endif
PETSC_EXTERN void petscspacesumsetsubspace_(PetscSpace *a, PetscInt *b, PetscSpace *c, PetscErrorCode *ierr)
{
  *ierr = PetscSpaceSumSetSubspace(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacesumsetinterleave_ PETSCSPACESUMSETINTERLEAVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacesumsetinterleave_ petscspacesumsetinterleave
#endif
PETSC_EXTERN void petscspacesumsetinterleave_(PetscSpace *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PetscSpaceSumSetInterleave(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacesumgetinterleave_ PETSCSPACESUMGETINTERLEAVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacesumgetinterleave_ petscspacesumgetinterleave
#endif
PETSC_EXTERN void petscspacesumgetinterleave_(PetscSpace *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscSpaceSumGetInterleave(*a, b, c);
  if (*ierr) return;
}
