#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreatempiwitharray_ VECCREATEMPIWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreatempiwitharray_ veccreatempiwitharray
#endif
PETSC_EXTERN void veccreatempiwitharray_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscScalar e[], Vec *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLSCALAR(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = VecCreateMPIWithArray(MPI_Comm_f2c(*(a)), *b, *c, *d, e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreateghostwitharray_ VECCREATEGHOSTWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreateghostwitharray_ veccreateghostwitharray
#endif
PETSC_EXTERN void veccreateghostwitharray_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscInt e[], const PetscScalar f[], Vec *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLSCALAR(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = VecCreateGhostWithArray(MPI_Comm_f2c(*(a)), *b, *c, *d, e, f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecghostgetghostis_ VECGHOSTGETGHOSTIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecghostgetghostis_ vecghostgetghostis
#endif
PETSC_EXTERN void vecghostgetghostis_(Vec *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = VecGhostGetGhostIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreateghost_ VECCREATEGHOST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreateghost_ veccreateghost
#endif
PETSC_EXTERN void veccreateghost_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscInt e[], Vec *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = VecCreateGhost(MPI_Comm_f2c(*(a)), *b, *c, *d, e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecmpisetghost_ VECMPISETGHOST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecmpisetghost_ vecmpisetghost
#endif
PETSC_EXTERN void vecmpisetghost_(Vec *a, PetscInt *b, const PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = VecMPISetGhost(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreateghostblockwitharray_ VECCREATEGHOSTBLOCKWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreateghostblockwitharray_ veccreateghostblockwitharray
#endif
PETSC_EXTERN void veccreateghostblockwitharray_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, const PetscInt f[], const PetscScalar g[], Vec *h, PetscErrorCode *ierr)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLSCALAR(g);
  CHKFORTRANNULLOBJECT(h);
  *ierr = VecCreateGhostBlockWithArray(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f, g, h);
  if (*ierr) return;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreateghostblock_ VECCREATEGHOSTBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreateghostblock_ veccreateghostblock
#endif
PETSC_EXTERN void veccreateghostblock_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, const PetscInt f[], Vec *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = VecCreateGhostBlock(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
