#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdacreate3d_ DMDACREATE3D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdacreate3d_ dmdacreate3d
#endif
PETSC_EXTERN void dmdacreate3d_(MPI_Fint *a, DMBoundaryType *b, DMBoundaryType *c, DMBoundaryType *d, DMDAStencilType *e, PetscInt *f, PetscInt *g, PetscInt *h, PetscInt *i, PetscInt *j, PetscInt *k, PetscInt *l, PetscInt *m, const PetscInt n[], const PetscInt o[], const PetscInt p[], DM *q, PetscErrorCode *ierr)
{
  PetscBool null_q = !*(void**) q ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(n);
  CHKFORTRANNULLINTEGER(o);
  CHKFORTRANNULLINTEGER(p);
  CHKFORTRANNULLOBJECT(q);
  *ierr = DMDACreate3d(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, *g, *h, *i, *j, *k, *l, *m, n, o, p, q);
  if (*ierr) return;
  if (! null_q && !*(void**) q) *(void **) q = (void *)-2;
}
