#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexinvertcell_ DMPLEXINVERTCELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexinvertcell_ dmplexinvertcell
#endif
PETSC_EXTERN void dmplexinvertcell_(DMPolytopeType *a, PetscInt b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexInvertCell(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexreordercell_ DMPLEXREORDERCELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexreordercell_ dmplexreordercell
#endif
PETSC_EXTERN void dmplexreordercell_(DM *a, PetscInt *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMPlexReorderCell(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextrianglesetoptions_ DMPLEXTRIANGLESETOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextrianglesetoptions_ dmplextrianglesetoptions
#endif
PETSC_EXTERN void dmplextrianglesetoptions_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMPlexTriangleSetOptions(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplextetgensetoptions_ DMPLEXTETGENSETOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplextetgensetoptions_ dmplextetgensetoptions
#endif
PETSC_EXTERN void dmplextetgensetoptions_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMPlexTetgenSetOptions(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgenerate_ DMPLEXGENERATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgenerate_ dmplexgenerate
#endif
PETSC_EXTERN void dmplexgenerate_(DM *a, char b[], PetscBool *c, DM *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexGenerate(*a, c_b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
