#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matisgetallowrepeated_ MATISGETALLOWREPEATED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matisgetallowrepeated_ matisgetallowrepeated
#endif
PETSC_EXTERN void matisgetallowrepeated_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatISGetAllowRepeated(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matissetallowrepeated_ MATISSETALLOWREPEATED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matissetallowrepeated_ matissetallowrepeated
#endif
PETSC_EXTERN void matissetallowrepeated_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatISSetAllowRepeated(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matisstorel2l_ MATISSTOREL2L
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matisstorel2l_ matisstorel2l
#endif
PETSC_EXTERN void matisstorel2l_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatISStoreL2L(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matisfixlocalempty_ MATISFIXLOCALEMPTY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matisfixlocalempty_ matisfixlocalempty
#endif
PETSC_EXTERN void matisfixlocalempty_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatISFixLocalEmpty(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matissetpreallocation_ MATISSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matissetpreallocation_ matissetpreallocation
#endif
PETSC_EXTERN void matissetpreallocation_(Mat *a, PetscInt *b, const PetscInt c[], PetscInt *d, const PetscInt e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(e);
  *ierr = MatISSetPreallocation(*a, *b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matisgetlocalmat_ MATISGETLOCALMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matisgetlocalmat_ matisgetlocalmat
#endif
PETSC_EXTERN void matisgetlocalmat_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatISGetLocalMat(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matisrestorelocalmat_ MATISRESTORELOCALMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matisrestorelocalmat_ matisrestorelocalmat
#endif
PETSC_EXTERN void matisrestorelocalmat_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatISRestoreLocalMat(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matissetlocalmattype_ MATISSETLOCALMATTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matissetlocalmattype_ matissetlocalmattype
#endif
PETSC_EXTERN void matissetlocalmattype_(Mat *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatISSetLocalMatType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matissetlocalmat_ MATISSETLOCALMAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matissetlocalmat_ matissetlocalmat
#endif
PETSC_EXTERN void matissetlocalmat_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = MatISSetLocalMat(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateis_ MATCREATEIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateis_ matcreateis
#endif
PETSC_EXTERN void matcreateis_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, ISLocalToGlobalMapping *g, ISLocalToGlobalMapping *h, Mat *i, PetscErrorCode *ierr)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(i);
  *ierr = MatCreateIS(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, *g, *h, i);
  if (*ierr) return;
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matisgetlocaltoglobalmapping_ MATISGETLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matisgetlocaltoglobalmapping_ matisgetlocaltoglobalmapping
#endif
PETSC_EXTERN void matisgetlocaltoglobalmapping_(Mat *a, ISLocalToGlobalMapping *b, ISLocalToGlobalMapping *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatISGetLocalToGlobalMapping(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
