#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacetensorsetnumsubspaces_ PETSCSPACETENSORSETNUMSUBSPACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacetensorsetnumsubspaces_ petscspacetensorsetnumsubspaces
#endif
PETSC_EXTERN void petscspacetensorsetnumsubspaces_(PetscSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscSpaceTensorSetNumSubspaces(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacetensorgetnumsubspaces_ PETSCSPACETENSORGETNUMSUBSPACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacetensorgetnumsubspaces_ petscspacetensorgetnumsubspaces
#endif
PETSC_EXTERN void petscspacetensorgetnumsubspaces_(PetscSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSpaceTensorGetNumSubspaces(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacetensorsetsubspace_ PETSCSPACETENSORSETSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacetensorsetsubspace_ petscspacetensorsetsubspace
#endif
PETSC_EXTERN void petscspacetensorsetsubspace_(PetscSpace *a, PetscInt *b, PetscSpace *c, PetscErrorCode *ierr)
{
  *ierr = PetscSpaceTensorSetSubspace(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacetensorgetsubspace_ PETSCSPACETENSORGETSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacetensorgetsubspace_ petscspacetensorgetsubspace
#endif
PETSC_EXTERN void petscspacetensorgetsubspace_(PetscSpace *a, PetscInt *b, PetscSpace *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSpaceTensorGetSubspace(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
