from collections import OrderedDict
from collections.abc import Generator
from typing import Final

from .dates import BaseDate, HebrewDate

PARSHIOS: Final[list[str]]
PARSHIOS_HEBREW: Final[list[str]]

def getparsha(date: BaseDate, israel: bool = False) -> list[int] | None: ...
def getparsha_string(date: BaseDate, israel: bool = False, hebrew: bool = False) -> str | None: ...
def iterparshios(year: int, israel: bool = False) -> Generator[list[int] | None]: ...
def parshatable(year: int, israel: bool = False) -> OrderedDict[HebrewDate, list[int] | None]: ...
def four_parshios(date: BaseDate, hebrew: bool = False) -> str: ...
