import enum
from typing import Iterator, Optional, Union

import lief.assembly


class OPCODE(enum.Enum):
    PHI = 0

    INLINEASM = 1

    INLINEASM_BR = 2

    CFI_INSTRUCTION = 3

    EH_LABEL = 4

    GC_LABEL = 5

    ANNOTATION_LABEL = 6

    KILL = 7

    EXTRACT_SUBREG = 8

    INSERT_SUBREG = 9

    IMPLICIT_DEF = 10

    INIT_UNDEF = 11

    SUBREG_TO_REG = 12

    COPY_TO_REGCLASS = 13

    DBG_VALUE = 14

    DBG_VALUE_LIST = 15

    DBG_INSTR_REF = 16

    DBG_PHI = 17

    DBG_LABEL = 18

    REG_SEQUENCE = 19

    COPY = 20

    BUNDLE = 21

    LIFETIME_START = 22

    LIFETIME_END = 23

    PSEUDO_PROBE = 24

    ARITH_FENCE = 25

    STACKMAP = 26

    FENTRY_CALL = 27

    PATCHPOINT = 28

    LOAD_STACK_GUARD = 29

    PREALLOCATED_SETUP = 30

    PREALLOCATED_ARG = 31

    STATEPOINT = 32

    LOCAL_ESCAPE = 33

    FAULTING_OP = 34

    PATCHABLE_OP = 35

    PATCHABLE_FUNCTION_ENTER = 36

    PATCHABLE_RET = 37

    PATCHABLE_FUNCTION_EXIT = 38

    PATCHABLE_TAIL_CALL = 39

    PATCHABLE_EVENT_CALL = 40

    PATCHABLE_TYPED_EVENT_CALL = 41

    ICALL_BRANCH_FUNNEL = 42

    FAKE_USE = 43

    MEMBARRIER = 44

    JUMP_TABLE_DEBUG_INFO = 45

    CONVERGENCECTRL_ENTRY = 46

    CONVERGENCECTRL_ANCHOR = 47

    CONVERGENCECTRL_LOOP = 48

    CONVERGENCECTRL_GLUE = 49

    G_ASSERT_SEXT = 50

    G_ASSERT_ZEXT = 51

    G_ASSERT_ALIGN = 52

    G_ADD = 53

    G_SUB = 54

    G_MUL = 55

    G_SDIV = 56

    G_UDIV = 57

    G_SREM = 58

    G_UREM = 59

    G_SDIVREM = 60

    G_UDIVREM = 61

    G_AND = 62

    G_OR = 63

    G_XOR = 64

    G_ABDS = 65

    G_ABDU = 66

    G_IMPLICIT_DEF = 67

    G_PHI = 68

    G_FRAME_INDEX = 69

    G_GLOBAL_VALUE = 70

    G_PTRAUTH_GLOBAL_VALUE = 71

    G_CONSTANT_POOL = 72

    G_EXTRACT = 73

    G_UNMERGE_VALUES = 74

    G_INSERT = 75

    G_MERGE_VALUES = 76

    G_BUILD_VECTOR = 77

    G_BUILD_VECTOR_TRUNC = 78

    G_CONCAT_VECTORS = 79

    G_PTRTOINT = 80

    G_INTTOPTR = 81

    G_BITCAST = 82

    G_FREEZE = 83

    G_CONSTANT_FOLD_BARRIER = 84

    G_INTRINSIC_FPTRUNC_ROUND = 85

    G_INTRINSIC_TRUNC = 86

    G_INTRINSIC_ROUND = 87

    G_INTRINSIC_LRINT = 88

    G_INTRINSIC_LLRINT = 89

    G_INTRINSIC_ROUNDEVEN = 90

    G_READCYCLECOUNTER = 91

    G_READSTEADYCOUNTER = 92

    G_LOAD = 93

    G_SEXTLOAD = 94

    G_ZEXTLOAD = 95

    G_INDEXED_LOAD = 96

    G_INDEXED_SEXTLOAD = 97

    G_INDEXED_ZEXTLOAD = 98

    G_STORE = 99

    G_INDEXED_STORE = 100

    G_ATOMIC_CMPXCHG_WITH_SUCCESS = 101

    G_ATOMIC_CMPXCHG = 102

    G_ATOMICRMW_XCHG = 103

    G_ATOMICRMW_ADD = 104

    G_ATOMICRMW_SUB = 105

    G_ATOMICRMW_AND = 106

    G_ATOMICRMW_NAND = 107

    G_ATOMICRMW_OR = 108

    G_ATOMICRMW_XOR = 109

    G_ATOMICRMW_MAX = 110

    G_ATOMICRMW_MIN = 111

    G_ATOMICRMW_UMAX = 112

    G_ATOMICRMW_UMIN = 113

    G_ATOMICRMW_FADD = 114

    G_ATOMICRMW_FSUB = 115

    G_ATOMICRMW_FMAX = 116

    G_ATOMICRMW_FMIN = 117

    G_ATOMICRMW_FMAXIMUM = 118

    G_ATOMICRMW_FMINIMUM = 119

    G_ATOMICRMW_UINC_WRAP = 120

    G_ATOMICRMW_UDEC_WRAP = 121

    G_ATOMICRMW_USUB_COND = 122

    G_ATOMICRMW_USUB_SAT = 123

    G_FENCE = 124

    G_PREFETCH = 125

    G_BRCOND = 126

    G_BRINDIRECT = 127

    G_INVOKE_REGION_START = 128

    G_INTRINSIC = 129

    G_INTRINSIC_W_SIDE_EFFECTS = 130

    G_INTRINSIC_CONVERGENT = 131

    G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS = 132

    G_ANYEXT = 133

    G_TRUNC = 134

    G_TRUNC_SSAT_S = 135

    G_TRUNC_SSAT_U = 136

    G_TRUNC_USAT_U = 137

    G_CONSTANT = 138

    G_FCONSTANT = 139

    G_VASTART = 140

    G_VAARG = 141

    G_SEXT = 142

    G_SEXT_INREG = 143

    G_ZEXT = 144

    G_SHL = 145

    G_LSHR = 146

    G_ASHR = 147

    G_FSHL = 148

    G_FSHR = 149

    G_ROTR = 150

    G_ROTL = 151

    G_ICMP = 152

    G_FCMP = 153

    G_SCMP = 154

    G_UCMP = 155

    G_SELECT = 156

    G_UADDO = 157

    G_UADDE = 158

    G_USUBO = 159

    G_USUBE = 160

    G_SADDO = 161

    G_SADDE = 162

    G_SSUBO = 163

    G_SSUBE = 164

    G_UMULO = 165

    G_SMULO = 166

    G_UMULH = 167

    G_SMULH = 168

    G_UADDSAT = 169

    G_SADDSAT = 170

    G_USUBSAT = 171

    G_SSUBSAT = 172

    G_USHLSAT = 173

    G_SSHLSAT = 174

    G_SMULFIX = 175

    G_UMULFIX = 176

    G_SMULFIXSAT = 177

    G_UMULFIXSAT = 178

    G_SDIVFIX = 179

    G_UDIVFIX = 180

    G_SDIVFIXSAT = 181

    G_UDIVFIXSAT = 182

    G_FADD = 183

    G_FSUB = 184

    G_FMUL = 185

    G_FMA = 186

    G_FMAD = 187

    G_FDIV = 188

    G_FREM = 189

    G_FPOW = 190

    G_FPOWI = 191

    G_FEXP = 192

    G_FEXP2 = 193

    G_FEXP10 = 194

    G_FLOG = 195

    G_FLOG2 = 196

    G_FLOG10 = 197

    G_FLDEXP = 198

    G_FFREXP = 199

    G_FNEG = 200

    G_FPEXT = 201

    G_FPTRUNC = 202

    G_FPTOSI = 203

    G_FPTOUI = 204

    G_SITOFP = 205

    G_UITOFP = 206

    G_FPTOSI_SAT = 207

    G_FPTOUI_SAT = 208

    G_FABS = 209

    G_FCOPYSIGN = 210

    G_IS_FPCLASS = 211

    G_FCANONICALIZE = 212

    G_FMINNUM = 213

    G_FMAXNUM = 214

    G_FMINNUM_IEEE = 215

    G_FMAXNUM_IEEE = 216

    G_FMINIMUM = 217

    G_FMAXIMUM = 218

    G_FMINIMUMNUM = 219

    G_FMAXIMUMNUM = 220

    G_GET_FPENV = 221

    G_SET_FPENV = 222

    G_RESET_FPENV = 223

    G_GET_FPMODE = 224

    G_SET_FPMODE = 225

    G_RESET_FPMODE = 226

    G_GET_ROUNDING = 227

    G_PTR_ADD = 228

    G_PTRMASK = 229

    G_SMIN = 230

    G_SMAX = 231

    G_UMIN = 232

    G_UMAX = 233

    G_ABS = 234

    G_LROUND = 235

    G_LLROUND = 236

    G_BR = 237

    G_BRJT = 238

    G_VSCALE = 239

    G_INSERT_SUBVECTOR = 240

    G_EXTRACT_SUBVECTOR = 241

    G_INSERT_VECTOR_ELT = 242

    G_EXTRACT_VECTOR_ELT = 243

    G_SHUFFLE_VECTOR = 244

    G_SPLAT_VECTOR = 245

    G_STEP_VECTOR = 246

    G_VECTOR_COMPRESS = 247

    G_CTTZ = 248

    G_CTTZ_ZERO_UNDEF = 249

    G_CTLZ = 250

    G_CTLZ_ZERO_UNDEF = 251

    G_CTPOP = 252

    G_BSWAP = 253

    G_BITREVERSE = 254

    G_FCEIL = 255

    G_FCOS = 256

    G_FSIN = 257

    G_FSINCOS = 258

    G_FTAN = 259

    G_FACOS = 260

    G_FASIN = 261

    G_FATAN = 262

    G_FATAN2 = 263

    G_FCOSH = 264

    G_FSINH = 265

    G_FTANH = 266

    G_FSQRT = 267

    G_FFLOOR = 268

    G_FRINT = 269

    G_FNEARBYINT = 270

    G_ADDRSPACE_CAST = 271

    G_BLOCK_ADDR = 272

    G_JUMP_TABLE = 273

    G_DYN_STACKALLOC = 274

    G_STACKSAVE = 275

    G_STACKRESTORE = 276

    G_STRICT_FADD = 277

    G_STRICT_FSUB = 278

    G_STRICT_FMUL = 279

    G_STRICT_FDIV = 280

    G_STRICT_FREM = 281

    G_STRICT_FMA = 282

    G_STRICT_FSQRT = 283

    G_STRICT_FLDEXP = 284

    G_READ_REGISTER = 285

    G_WRITE_REGISTER = 286

    G_MEMCPY = 287

    G_MEMCPY_INLINE = 288

    G_MEMMOVE = 289

    G_MEMSET = 290

    G_BZERO = 291

    G_TRAP = 292

    G_DEBUGTRAP = 293

    G_UBSANTRAP = 294

    G_VECREDUCE_SEQ_FADD = 295

    G_VECREDUCE_SEQ_FMUL = 296

    G_VECREDUCE_FADD = 297

    G_VECREDUCE_FMUL = 298

    G_VECREDUCE_FMAX = 299

    G_VECREDUCE_FMIN = 300

    G_VECREDUCE_FMAXIMUM = 301

    G_VECREDUCE_FMINIMUM = 302

    G_VECREDUCE_ADD = 303

    G_VECREDUCE_MUL = 304

    G_VECREDUCE_AND = 305

    G_VECREDUCE_OR = 306

    G_VECREDUCE_XOR = 307

    G_VECREDUCE_SMAX = 308

    G_VECREDUCE_SMIN = 309

    G_VECREDUCE_UMAX = 310

    G_VECREDUCE_UMIN = 311

    G_SBFX = 312

    G_UBFX = 313

    ATOMIC_CMP_SWAP_I128 = 314

    ATOMIC_LOAD_ADD_I128 = 315

    ATOMIC_LOAD_AND_I128 = 316

    ATOMIC_LOAD_NAND_I128 = 317

    ATOMIC_LOAD_OR_I128 = 318

    ATOMIC_LOAD_SUB_I128 = 319

    ATOMIC_LOAD_XOR_I128 = 320

    ATOMIC_SWAP_I128 = 321

    BUILD_QUADWORD = 322

    BUILD_UACC = 323

    CFENCE = 324

    CFENCE8 = 325

    CLRLSLDI = 326

    CLRLSLDI_rec = 327

    CLRLSLWI = 328

    CLRLSLWI_rec = 329

    CLRRDI = 330

    CLRRDI_rec = 331

    CLRRWI = 332

    CLRRWI_rec = 333

    DCBFL = 334

    DCBFLP = 335

    DCBFPS = 336

    DCBFx = 337

    DCBSTPS = 338

    DCBTCT = 339

    DCBTDS = 340

    DCBTSTCT = 341

    DCBTSTDS = 342

    DCBTSTT = 343

    DCBTSTx = 344

    DCBTT = 345

    DCBTx = 346

    DFLOADf32 = 347

    DFLOADf64 = 348

    DFSTOREf32 = 349

    DFSTOREf64 = 350

    EXTLDI = 351

    EXTLDI_rec = 352

    EXTLWI = 353

    EXTLWI_rec = 354

    EXTRDI = 355

    EXTRDI_rec = 356

    EXTRWI = 357

    EXTRWI_rec = 358

    INSLWI = 359

    INSLWI_rec = 360

    INSRDI = 361

    INSRDI_rec = 362

    INSRWI = 363

    INSRWI_rec = 364

    KILL_PAIR = 365

    LAx = 366

    LIWAX = 367

    LIWZX = 368

    PPCLdFixedAddr = 369

    PSUBI = 370

    RLWIMIbm = 371

    RLWIMIbm_rec = 372

    RLWINMbm = 373

    RLWINMbm_rec = 374

    RLWNMbm = 375

    RLWNMbm_rec = 376

    ROTRDI = 377

    ROTRDI_rec = 378

    ROTRWI = 379

    ROTRWI_rec = 380

    SLDI = 381

    SLDI_rec = 382

    SLWI = 383

    SLWI_rec = 384

    SPILLTOVSR_LD = 385

    SPILLTOVSR_LDX = 386

    SPILLTOVSR_ST = 387

    SPILLTOVSR_STX = 388

    SRDI = 389

    SRDI_rec = 390

    SRWI = 391

    SRWI_rec = 392

    STIWX = 393

    SUBI = 394

    SUBIC = 395

    SUBIC_rec = 396

    SUBIS = 397

    SUBPCIS = 398

    XFLOADf32 = 399

    XFLOADf64 = 400

    XFSTOREf32 = 401

    XFSTOREf64 = 402

    ADD4 = 403

    ADD4O = 404

    ADD4O_rec = 405

    ADD4TLS = 406

    ADD4_rec = 407

    ADD8 = 408

    ADD8O = 409

    ADD8O_rec = 410

    ADD8TLS = 411

    ADD8_rec = 413

    ADDC = 414

    ADDC8 = 415

    ADDC8O = 416

    ADDC8O_rec = 417

    ADDC8_rec = 418

    ADDCO = 419

    ADDCO_rec = 420

    ADDC_rec = 421

    ADDE = 422

    ADDE8 = 423

    ADDE8O = 424

    ADDE8O_rec = 425

    ADDE8_rec = 426

    ADDEO = 427

    ADDEO_rec = 428

    ADDEX = 429

    ADDEX8 = 430

    ADDE_rec = 431

    ADDG6S = 432

    ADDG6S8 = 433

    ADDI = 434

    ADDI8 = 435

    ADDIC = 436

    ADDIC8 = 437

    ADDIC_rec = 438

    ADDIS = 439

    ADDIS8 = 440

    ADDISdtprelHA = 441

    ADDISdtprelHA32 = 442

    ADDISgotTprelHA = 443

    ADDIStlsgdHA = 444

    ADDIStlsldHA = 445

    ADDIStocHA = 446

    ADDIStocHA8 = 447

    ADDIdtprelL = 448

    ADDIdtprelL32 = 449

    ADDItlsgdL = 450

    ADDItlsgdL32 = 451

    ADDItlsgdLADDR = 452

    ADDItlsgdLADDR32 = 453

    ADDItlsldL = 454

    ADDItlsldL32 = 455

    ADDItlsldLADDR = 456

    ADDItlsldLADDR32 = 457

    ADDItoc = 458

    ADDItoc8 = 459

    ADDItocL = 460

    ADDItocL8 = 461

    ADDME = 462

    ADDME8 = 463

    ADDME8O = 464

    ADDME8O_rec = 465

    ADDME8_rec = 466

    ADDMEO = 467

    ADDMEO_rec = 468

    ADDME_rec = 469

    ADDPCIS = 470

    ADDZE = 471

    ADDZE8 = 472

    ADDZE8O = 473

    ADDZE8O_rec = 474

    ADDZE8_rec = 475

    ADDZEO = 476

    ADDZEO_rec = 477

    ADDZE_rec = 478

    ADJCALLSTACKDOWN = 479

    ADJCALLSTACKUP = 480

    AND = 481

    AND8 = 482

    AND8_rec = 483

    ANDC = 484

    ANDC8 = 485

    ANDC8_rec = 486

    ANDC_rec = 487

    ANDI8_rec = 488

    ANDIS8_rec = 489

    ANDIS_rec = 490

    ANDI_rec = 491

    ANDI_rec_1_EQ_BIT = 492

    ANDI_rec_1_EQ_BIT8 = 493

    ANDI_rec_1_GT_BIT = 494

    ANDI_rec_1_GT_BIT8 = 495

    AND_rec = 496

    ATOMIC_CMP_SWAP_I16 = 497

    ATOMIC_CMP_SWAP_I32 = 498

    ATOMIC_CMP_SWAP_I64 = 499

    ATOMIC_CMP_SWAP_I8 = 500

    ATOMIC_LOAD_ADD_I16 = 501

    ATOMIC_LOAD_ADD_I32 = 502

    ATOMIC_LOAD_ADD_I64 = 503

    ATOMIC_LOAD_ADD_I8 = 504

    ATOMIC_LOAD_AND_I16 = 505

    ATOMIC_LOAD_AND_I32 = 506

    ATOMIC_LOAD_AND_I64 = 507

    ATOMIC_LOAD_AND_I8 = 508

    ATOMIC_LOAD_MAX_I16 = 509

    ATOMIC_LOAD_MAX_I32 = 510

    ATOMIC_LOAD_MAX_I64 = 511

    ATOMIC_LOAD_MAX_I8 = 512

    ATOMIC_LOAD_MIN_I16 = 513

    ATOMIC_LOAD_MIN_I32 = 514

    ATOMIC_LOAD_MIN_I64 = 515

    ATOMIC_LOAD_MIN_I8 = 516

    ATOMIC_LOAD_NAND_I16 = 517

    ATOMIC_LOAD_NAND_I32 = 518

    ATOMIC_LOAD_NAND_I64 = 519

    ATOMIC_LOAD_NAND_I8 = 520

    ATOMIC_LOAD_OR_I16 = 521

    ATOMIC_LOAD_OR_I32 = 522

    ATOMIC_LOAD_OR_I64 = 523

    ATOMIC_LOAD_OR_I8 = 524

    ATOMIC_LOAD_SUB_I16 = 525

    ATOMIC_LOAD_SUB_I32 = 526

    ATOMIC_LOAD_SUB_I64 = 527

    ATOMIC_LOAD_SUB_I8 = 528

    ATOMIC_LOAD_UMAX_I16 = 529

    ATOMIC_LOAD_UMAX_I32 = 530

    ATOMIC_LOAD_UMAX_I64 = 531

    ATOMIC_LOAD_UMAX_I8 = 532

    ATOMIC_LOAD_UMIN_I16 = 533

    ATOMIC_LOAD_UMIN_I32 = 534

    ATOMIC_LOAD_UMIN_I64 = 535

    ATOMIC_LOAD_UMIN_I8 = 536

    ATOMIC_LOAD_XOR_I16 = 537

    ATOMIC_LOAD_XOR_I32 = 538

    ATOMIC_LOAD_XOR_I64 = 539

    ATOMIC_LOAD_XOR_I8 = 540

    ATOMIC_SWAP_I16 = 541

    ATOMIC_SWAP_I32 = 542

    ATOMIC_SWAP_I64 = 543

    ATOMIC_SWAP_I8 = 544

    ATTN = 545

    B = 546

    BA = 547

    BC = 548

    BCC = 549

    BCCA = 550

    BCCCTR = 551

    BCCCTR8 = 552

    BCCCTRL = 553

    BCCCTRL8 = 554

    BCCL = 555

    BCCLA = 556

    BCCLR = 557

    BCCLRL = 558

    BCCTR = 559

    BCCTR8 = 560

    BCCTR8n = 561

    BCCTRL = 562

    BCCTRL8 = 563

    BCCTRL8n = 564

    BCCTRLn = 565

    BCCTRn = 566

    BCDADD_rec = 567

    BCDCFN_rec = 568

    BCDCFSQ_rec = 569

    BCDCFZ_rec = 570

    BCDCPSGN_rec = 571

    BCDCTN_rec = 572

    BCDCTSQ_rec = 573

    BCDCTZ_rec = 574

    BCDSETSGN_rec = 575

    BCDSR_rec = 576

    BCDSUB_rec = 577

    BCDS_rec = 578

    BCDTRUNC_rec = 579

    BCDUS_rec = 580

    BCDUTRUNC_rec = 581

    BCL = 582

    BCLR = 583

    BCLRL = 584

    BCLRLn = 585

    BCLRn = 586

    BCLalways = 587

    BCLn = 588

    BCTR = 589

    BCTR8 = 590

    BCTRL = 591

    BCTRL8 = 592

    BCTRL8_LDinto_toc = 593

    BCTRL8_LDinto_toc_RM = 594

    BCTRL8_RM = 595

    BCTRL_LWZinto_toc = 596

    BCTRL_LWZinto_toc_RM = 597

    BCTRL_RM = 598

    BCn = 599

    BDNZ = 600

    BDNZ8 = 601

    BDNZA = 602

    BDNZAm = 603

    BDNZAp = 604

    BDNZL = 605

    BDNZLA = 606

    BDNZLAm = 607

    BDNZLAp = 608

    BDNZLR = 609

    BDNZLR8 = 610

    BDNZLRL = 611

    BDNZLRLm = 612

    BDNZLRLp = 613

    BDNZLRm = 614

    BDNZLRp = 615

    BDNZLm = 616

    BDNZLp = 617

    BDNZm = 618

    BDNZp = 619

    BDZ = 620

    BDZ8 = 621

    BDZA = 622

    BDZAm = 623

    BDZAp = 624

    BDZL = 625

    BDZLA = 626

    BDZLAm = 627

    BDZLAp = 628

    BDZLR = 629

    BDZLR8 = 630

    BDZLRL = 631

    BDZLRLm = 632

    BDZLRLp = 633

    BDZLRm = 634

    BDZLRp = 635

    BDZLm = 636

    BDZLp = 637

    BDZm = 638

    BDZp = 639

    BL = 640

    BL8 = 641

    BL8_NOP = 642

    BL8_NOP_RM = 643

    BL8_NOP_TLS = 644

    BL8_NOTOC = 645

    BL8_NOTOC_RM = 646

    BL8_NOTOC_TLS = 647

    BL8_RM = 648

    BL8_TLS = 649

    BLA = 651

    BLA8 = 652

    BLA8_NOP = 653

    BLA8_NOP_RM = 654

    BLA8_RM = 655

    BLA_RM = 656

    BLR = 657

    BLR8 = 658

    BLRL = 659

    BL_NOP = 660

    BL_NOP_RM = 661

    BL_RM = 662

    BL_TLS = 663

    BPERMD = 664

    BRD = 665

    BRH = 666

    BRH8 = 667

    BRINC = 668

    BRW = 669

    BRW8 = 670

    CBCDTD = 671

    CBCDTD8 = 672

    CDTBCD = 673

    CDTBCD8 = 674

    CFUGED = 675

    CLRBHRB = 676

    CMPB = 677

    CMPB8 = 678

    CMPD = 679

    CMPDI = 680

    CMPEQB = 681

    CMPLD = 682

    CMPLDI = 683

    CMPLW = 684

    CMPLWI = 685

    CMPRB = 686

    CMPRB8 = 687

    CMPW = 688

    CMPWI = 689

    CNTLZD = 690

    CNTLZDM = 691

    CNTLZD_rec = 692

    CNTLZW = 693

    CNTLZW8 = 694

    CNTLZW8_rec = 695

    CNTLZW_rec = 696

    CNTTZD = 697

    CNTTZDM = 698

    CNTTZD_rec = 699

    CNTTZW = 700

    CNTTZW8 = 701

    CNTTZW8_rec = 702

    CNTTZW_rec = 703

    CP_ABORT = 704

    CP_COPY = 705

    CP_COPY8 = 706

    CP_PASTE8_rec = 707

    CP_PASTE_rec = 708

    CR6SET = 709

    CR6UNSET = 710

    CRAND = 711

    CRANDC = 712

    CREQV = 713

    CRNAND = 714

    CRNOR = 715

    CRNOT = 716

    CROR = 717

    CRORC = 718

    CRSET = 719

    CRUNSET = 720

    CRXOR = 721

    CTRL_DEP = 722

    DADD = 723

    DADDQ = 724

    DADDQ_rec = 725

    DADD_rec = 726

    DARN = 727

    DCBA = 728

    DCBF = 729

    DCBFEP = 730

    DCBI = 731

    DCBST = 732

    DCBSTEP = 733

    DCBT = 734

    DCBTEP = 735

    DCBTST = 736

    DCBTSTEP = 737

    DCBZ = 738

    DCBZEP = 739

    DCBZL = 740

    DCBZLEP = 741

    DCCCI = 742

    DCFFIX = 743

    DCFFIXQ = 744

    DCFFIXQQ = 745

    DCFFIXQ_rec = 746

    DCFFIX_rec = 747

    DCMPO = 748

    DCMPOQ = 749

    DCMPU = 750

    DCMPUQ = 751

    DCTDP = 752

    DCTDP_rec = 753

    DCTFIX = 754

    DCTFIXQ = 755

    DCTFIXQQ = 756

    DCTFIXQ_rec = 757

    DCTFIX_rec = 758

    DCTQPQ = 759

    DCTQPQ_rec = 760

    DDEDPD = 761

    DDEDPDQ = 762

    DDEDPDQ_rec = 763

    DDEDPD_rec = 764

    DDIV = 765

    DDIVQ = 766

    DDIVQ_rec = 767

    DDIV_rec = 768

    DENBCD = 769

    DENBCDQ = 770

    DENBCDQ_rec = 771

    DENBCD_rec = 772

    DIEX = 773

    DIEXQ = 774

    DIEXQ_rec = 775

    DIEX_rec = 776

    DIVD = 777

    DIVDE = 778

    DIVDEO = 779

    DIVDEO_rec = 780

    DIVDEU = 781

    DIVDEUO = 782

    DIVDEUO_rec = 783

    DIVDEU_rec = 784

    DIVDE_rec = 785

    DIVDO = 786

    DIVDO_rec = 787

    DIVDU = 788

    DIVDUO = 789

    DIVDUO_rec = 790

    DIVDU_rec = 791

    DIVD_rec = 792

    DIVW = 793

    DIVWE = 794

    DIVWEO = 795

    DIVWEO_rec = 796

    DIVWEU = 797

    DIVWEUO = 798

    DIVWEUO_rec = 799

    DIVWEU_rec = 800

    DIVWE_rec = 801

    DIVWO = 802

    DIVWO_rec = 803

    DIVWU = 804

    DIVWUO = 805

    DIVWUO_rec = 806

    DIVWU_rec = 807

    DIVW_rec = 808

    DMMR = 809

    DMSETDMRZ = 810

    DMSHA2HASH = 811

    DMSHA3HASH = 812

    DMUL = 813

    DMULQ = 814

    DMULQ_rec = 815

    DMUL_rec = 816

    DMXOR = 817

    DMXVBF16GERX2 = 818

    DMXVBF16GERX2NN = 819

    DMXVBF16GERX2NP = 820

    DMXVBF16GERX2PN = 821

    DMXVBF16GERX2PP = 822

    DMXVF16GERX2 = 823

    DMXVF16GERX2NN = 824

    DMXVF16GERX2NP = 825

    DMXVF16GERX2PN = 826

    DMXVF16GERX2PP = 827

    DMXVI8GERX4 = 828

    DMXVI8GERX4PP = 829

    DMXVI8GERX4SPP = 830

    DMXXEXTFDMR256 = 831

    DMXXEXTFDMR512 = 832

    DMXXEXTFDMR512_HI = 833

    DMXXINSTDMR256 = 834

    DMXXINSTDMR512 = 835

    DMXXINSTDMR512_HI = 836

    DMXXSETACCZ = 837

    DMXXSHAPAD = 838

    DQUA = 839

    DQUAI = 840

    DQUAIQ = 841

    DQUAIQ_rec = 842

    DQUAI_rec = 843

    DQUAQ = 844

    DQUAQ_rec = 845

    DQUA_rec = 846

    DRDPQ = 847

    DRDPQ_rec = 848

    DRINTN = 849

    DRINTNQ = 850

    DRINTNQ_rec = 851

    DRINTN_rec = 852

    DRINTX = 853

    DRINTXQ = 854

    DRINTXQ_rec = 855

    DRINTX_rec = 856

    DRRND = 857

    DRRNDQ = 858

    DRRNDQ_rec = 859

    DRRND_rec = 860

    DRSP = 861

    DRSP_rec = 862

    DSCLI = 863

    DSCLIQ = 864

    DSCLIQ_rec = 865

    DSCLI_rec = 866

    DSCRI = 867

    DSCRIQ = 868

    DSCRIQ_rec = 869

    DSCRI_rec = 870

    DSS = 871

    DSSALL = 872

    DST = 873

    DST64 = 874

    DSTST = 875

    DSTST64 = 876

    DSTSTT = 877

    DSTSTT64 = 878

    DSTT = 879

    DSTT64 = 880

    DSUB = 881

    DSUBQ = 882

    DSUBQ_rec = 883

    DSUB_rec = 884

    DTSTDC = 885

    DTSTDCQ = 886

    DTSTDG = 887

    DTSTDGQ = 888

    DTSTEX = 889

    DTSTEXQ = 890

    DTSTSF = 891

    DTSTSFI = 892

    DTSTSFIQ = 893

    DTSTSFQ = 894

    DXEX = 895

    DXEXQ = 896

    DXEXQ_rec = 897

    DXEX_rec = 898

    DYNALLOC = 899

    DYNALLOC8 = 900

    DYNAREAOFFSET = 901

    DYNAREAOFFSET8 = 902

    DecreaseCTR8loop = 903

    DecreaseCTRloop = 904

    EFDABS = 905

    EFDADD = 906

    EFDCFS = 907

    EFDCFSF = 908

    EFDCFSI = 909

    EFDCFSID = 910

    EFDCFUF = 911

    EFDCFUI = 912

    EFDCFUID = 913

    EFDCMPEQ = 914

    EFDCMPGT = 915

    EFDCMPLT = 916

    EFDCTSF = 917

    EFDCTSI = 918

    EFDCTSIDZ = 919

    EFDCTSIZ = 920

    EFDCTUF = 921

    EFDCTUI = 922

    EFDCTUIDZ = 923

    EFDCTUIZ = 924

    EFDDIV = 925

    EFDMUL = 926

    EFDNABS = 927

    EFDNEG = 928

    EFDSUB = 929

    EFDTSTEQ = 930

    EFDTSTGT = 931

    EFDTSTLT = 932

    EFSABS = 933

    EFSADD = 934

    EFSCFD = 935

    EFSCFSF = 936

    EFSCFSI = 937

    EFSCFUF = 938

    EFSCFUI = 939

    EFSCMPEQ = 940

    EFSCMPGT = 941

    EFSCMPLT = 942

    EFSCTSF = 943

    EFSCTSI = 944

    EFSCTSIZ = 945

    EFSCTUF = 946

    EFSCTUI = 947

    EFSCTUIZ = 948

    EFSDIV = 949

    EFSMUL = 950

    EFSNABS = 951

    EFSNEG = 952

    EFSSUB = 953

    EFSTSTEQ = 954

    EFSTSTGT = 955

    EFSTSTLT = 956

    EH_SjLj_LongJmp32 = 957

    EH_SjLj_LongJmp64 = 958

    EH_SjLj_SetJmp32 = 959

    EH_SjLj_SetJmp64 = 960

    EH_SjLj_Setup = 961

    EQV = 962

    EQV8 = 963

    EQV8_rec = 964

    EQV_rec = 965

    EVABS = 966

    EVADDIW = 967

    EVADDSMIAAW = 968

    EVADDSSIAAW = 969

    EVADDUMIAAW = 970

    EVADDUSIAAW = 971

    EVADDW = 972

    EVAND = 973

    EVANDC = 974

    EVCMPEQ = 975

    EVCMPGTS = 976

    EVCMPGTU = 977

    EVCMPLTS = 978

    EVCMPLTU = 979

    EVCNTLSW = 980

    EVCNTLZW = 981

    EVDIVWS = 982

    EVDIVWU = 983

    EVEQV = 984

    EVEXTSB = 985

    EVEXTSH = 986

    EVFSABS = 987

    EVFSADD = 988

    EVFSCFSF = 989

    EVFSCFSI = 990

    EVFSCFUF = 991

    EVFSCFUI = 992

    EVFSCMPEQ = 993

    EVFSCMPGT = 994

    EVFSCMPLT = 995

    EVFSCTSF = 996

    EVFSCTSI = 997

    EVFSCTSIZ = 998

    EVFSCTUF = 999

    EVFSCTUI = 1000

    EVFSCTUIZ = 1001

    EVFSDIV = 1002

    EVFSMUL = 1003

    EVFSNABS = 1004

    EVFSNEG = 1005

    EVFSSUB = 1006

    EVFSTSTEQ = 1007

    EVFSTSTGT = 1008

    EVFSTSTLT = 1009

    EVLDD = 1010

    EVLDDX = 1011

    EVLDH = 1012

    EVLDHX = 1013

    EVLDW = 1014

    EVLDWX = 1015

    EVLHHESPLAT = 1016

    EVLHHESPLATX = 1017

    EVLHHOSSPLAT = 1018

    EVLHHOSSPLATX = 1019

    EVLHHOUSPLAT = 1020

    EVLHHOUSPLATX = 1021

    EVLWHE = 1022

    EVLWHEX = 1023

    EVLWHOS = 1024

    EVLWHOSX = 1025

    EVLWHOU = 1026

    EVLWHOUX = 1027

    EVLWHSPLAT = 1028

    EVLWHSPLATX = 1029

    EVLWWSPLAT = 1030

    EVLWWSPLATX = 1031

    EVMERGEHI = 1032

    EVMERGEHILO = 1033

    EVMERGELO = 1034

    EVMERGELOHI = 1035

    EVMHEGSMFAA = 1036

    EVMHEGSMFAN = 1037

    EVMHEGSMIAA = 1038

    EVMHEGSMIAN = 1039

    EVMHEGUMIAA = 1040

    EVMHEGUMIAN = 1041

    EVMHESMF = 1042

    EVMHESMFA = 1043

    EVMHESMFAAW = 1044

    EVMHESMFANW = 1045

    EVMHESMI = 1046

    EVMHESMIA = 1047

    EVMHESMIAAW = 1048

    EVMHESMIANW = 1049

    EVMHESSF = 1050

    EVMHESSFA = 1051

    EVMHESSFAAW = 1052

    EVMHESSFANW = 1053

    EVMHESSIAAW = 1054

    EVMHESSIANW = 1055

    EVMHEUMI = 1056

    EVMHEUMIA = 1057

    EVMHEUMIAAW = 1058

    EVMHEUMIANW = 1059

    EVMHEUSIAAW = 1060

    EVMHEUSIANW = 1061

    EVMHOGSMFAA = 1062

    EVMHOGSMFAN = 1063

    EVMHOGSMIAA = 1064

    EVMHOGSMIAN = 1065

    EVMHOGUMIAA = 1066

    EVMHOGUMIAN = 1067

    EVMHOSMF = 1068

    EVMHOSMFA = 1069

    EVMHOSMFAAW = 1070

    EVMHOSMFANW = 1071

    EVMHOSMI = 1072

    EVMHOSMIA = 1073

    EVMHOSMIAAW = 1074

    EVMHOSMIANW = 1075

    EVMHOSSF = 1076

    EVMHOSSFA = 1077

    EVMHOSSFAAW = 1078

    EVMHOSSFANW = 1079

    EVMHOSSIAAW = 1080

    EVMHOSSIANW = 1081

    EVMHOUMI = 1082

    EVMHOUMIA = 1083

    EVMHOUMIAAW = 1084

    EVMHOUMIANW = 1085

    EVMHOUSIAAW = 1086

    EVMHOUSIANW = 1087

    EVMRA = 1088

    EVMWHSMF = 1089

    EVMWHSMFA = 1090

    EVMWHSMI = 1091

    EVMWHSMIA = 1092

    EVMWHSSF = 1093

    EVMWHSSFA = 1094

    EVMWHUMI = 1095

    EVMWHUMIA = 1096

    EVMWLSMIAAW = 1097

    EVMWLSMIANW = 1098

    EVMWLSSIAAW = 1099

    EVMWLSSIANW = 1100

    EVMWLUMI = 1101

    EVMWLUMIA = 1102

    EVMWLUMIAAW = 1103

    EVMWLUMIANW = 1104

    EVMWLUSIAAW = 1105

    EVMWLUSIANW = 1106

    EVMWSMF = 1107

    EVMWSMFA = 1108

    EVMWSMFAA = 1109

    EVMWSMFAN = 1110

    EVMWSMI = 1111

    EVMWSMIA = 1112

    EVMWSMIAA = 1113

    EVMWSMIAN = 1114

    EVMWSSF = 1115

    EVMWSSFA = 1116

    EVMWSSFAA = 1117

    EVMWSSFAN = 1118

    EVMWUMI = 1119

    EVMWUMIA = 1120

    EVMWUMIAA = 1121

    EVMWUMIAN = 1122

    EVNAND = 1123

    EVNEG = 1124

    EVNOR = 1125

    EVOR = 1126

    EVORC = 1127

    EVRLW = 1128

    EVRLWI = 1129

    EVRNDW = 1130

    EVSEL = 1131

    EVSLW = 1132

    EVSLWI = 1133

    EVSPLATFI = 1134

    EVSPLATI = 1135

    EVSRWIS = 1136

    EVSRWIU = 1137

    EVSRWS = 1138

    EVSRWU = 1139

    EVSTDD = 1140

    EVSTDDX = 1141

    EVSTDH = 1142

    EVSTDHX = 1143

    EVSTDW = 1144

    EVSTDWX = 1145

    EVSTWHE = 1146

    EVSTWHEX = 1147

    EVSTWHO = 1148

    EVSTWHOX = 1149

    EVSTWWE = 1150

    EVSTWWEX = 1151

    EVSTWWO = 1152

    EVSTWWOX = 1153

    EVSUBFSMIAAW = 1154

    EVSUBFSSIAAW = 1155

    EVSUBFUMIAAW = 1156

    EVSUBFUSIAAW = 1157

    EVSUBFW = 1158

    EVSUBIFW = 1159

    EVXOR = 1160

    EXTSB = 1161

    EXTSB8 = 1162

    EXTSB8_32_64 = 1163

    EXTSB8_rec = 1164

    EXTSB_rec = 1165

    EXTSH = 1166

    EXTSH8 = 1167

    EXTSH8_32_64 = 1168

    EXTSH8_rec = 1169

    EXTSH_rec = 1170

    EXTSW = 1171

    EXTSWSLI = 1172

    EXTSWSLI_32_64 = 1173

    EXTSWSLI_32_64_rec = 1174

    EXTSWSLI_rec = 1175

    EXTSW_32 = 1176

    EXTSW_32_64 = 1177

    EXTSW_32_64_rec = 1178

    EXTSW_rec = 1179

    EnforceIEIO = 1180

    FABSD = 1181

    FABSD_rec = 1182

    FABSS = 1183

    FABSS_rec = 1184

    FADD = 1185

    FADDS = 1186

    FADDS_rec = 1187

    FADD_rec = 1188

    FADDrtz = 1189

    FCFID = 1190

    FCFIDS = 1191

    FCFIDS_rec = 1192

    FCFIDU = 1193

    FCFIDUS = 1194

    FCFIDUS_rec = 1195

    FCFIDU_rec = 1196

    FCFID_rec = 1197

    FCMPOD = 1198

    FCMPOS = 1199

    FCMPUD = 1200

    FCMPUS = 1201

    FCPSGND = 1202

    FCPSGND_rec = 1203

    FCPSGNS = 1204

    FCPSGNS_rec = 1205

    FCTID = 1206

    FCTIDU = 1207

    FCTIDUZ = 1208

    FCTIDUZ_rec = 1209

    FCTIDU_rec = 1210

    FCTIDZ = 1211

    FCTIDZ_rec = 1212

    FCTID_rec = 1213

    FCTIW = 1214

    FCTIWU = 1215

    FCTIWUZ = 1216

    FCTIWUZ_rec = 1217

    FCTIWU_rec = 1218

    FCTIWZ = 1219

    FCTIWZ_rec = 1220

    FCTIW_rec = 1221

    FDIV = 1222

    FDIVS = 1223

    FDIVS_rec = 1224

    FDIV_rec = 1225

    FENCE = 1226

    FMADD = 1227

    FMADDS = 1228

    FMADDS_rec = 1229

    FMADD_rec = 1230

    FMR = 1231

    FMR_rec = 1232

    FMSUB = 1233

    FMSUBS = 1234

    FMSUBS_rec = 1235

    FMSUB_rec = 1236

    FMUL = 1237

    FMULS = 1238

    FMULS_rec = 1239

    FMUL_rec = 1240

    FNABSD = 1241

    FNABSD_rec = 1242

    FNABSS = 1243

    FNABSS_rec = 1244

    FNEGD = 1245

    FNEGD_rec = 1246

    FNEGS = 1247

    FNEGS_rec = 1248

    FNMADD = 1249

    FNMADDS = 1250

    FNMADDS_rec = 1251

    FNMADD_rec = 1252

    FNMSUB = 1253

    FNMSUBS = 1254

    FNMSUBS_rec = 1255

    FNMSUB_rec = 1256

    FRE = 1257

    FRES = 1258

    FRES_rec = 1259

    FRE_rec = 1260

    FRIMD = 1261

    FRIMD_rec = 1262

    FRIMS = 1263

    FRIMS_rec = 1264

    FRIND = 1265

    FRIND_rec = 1266

    FRINS = 1267

    FRINS_rec = 1268

    FRIPD = 1269

    FRIPD_rec = 1270

    FRIPS = 1271

    FRIPS_rec = 1272

    FRIZD = 1273

    FRIZD_rec = 1274

    FRIZS = 1275

    FRIZS_rec = 1276

    FRSP = 1277

    FRSP_rec = 1278

    FRSQRTE = 1279

    FRSQRTES = 1280

    FRSQRTES_rec = 1281

    FRSQRTE_rec = 1282

    FSELD = 1283

    FSELD_rec = 1284

    FSELS = 1285

    FSELS_rec = 1286

    FSQRT = 1287

    FSQRTS = 1288

    FSQRTS_rec = 1289

    FSQRT_rec = 1290

    FSUB = 1291

    FSUBS = 1292

    FSUBS_rec = 1293

    FSUB_rec = 1294

    FTDIV = 1295

    FTSQRT = 1296

    GETtlsADDR = 1297

    GETtlsADDR32 = 1298

    GETtlsADDR32AIX = 1299

    GETtlsADDR64AIX = 1300

    GETtlsADDRPCREL = 1301

    GETtlsMOD32AIX = 1302

    GETtlsMOD64AIX = 1303

    GETtlsTpointer32AIX = 1304

    GETtlsldADDR = 1305

    GETtlsldADDR32 = 1306

    GETtlsldADDRPCREL = 1307

    HASHCHK = 1308

    HASHCHK8 = 1309

    HASHCHKP = 1310

    HASHCHKP8 = 1311

    HASHST = 1312

    HASHST8 = 1313

    HASHSTP = 1314

    HASHSTP8 = 1315

    HRFID = 1316

    ICBI = 1317

    ICBIEP = 1318

    ICBLC = 1319

    ICBLQ = 1320

    ICBT = 1321

    ICBTLS = 1322

    ICCCI = 1323

    ISEL = 1324

    ISEL8 = 1325

    ISYNC = 1326

    LA = 1327

    LA8 = 1328

    LBARX = 1329

    LBARXL = 1330

    LBEPX = 1331

    LBZ = 1332

    LBZ8 = 1333

    LBZCIX = 1334

    LBZU = 1335

    LBZU8 = 1336

    LBZUX = 1337

    LBZUX8 = 1338

    LBZX = 1339

    LBZX8 = 1340

    LBZXTLS = 1341

    LBZXTLS_32 = 1343

    LD = 1344

    LDARX = 1345

    LDARXL = 1346

    LDAT = 1347

    LDBRX = 1348

    LDCIX = 1349

    LDU = 1350

    LDUX = 1351

    LDX = 1352

    LDXTLS = 1353

    LDgotTprelL = 1355

    LDgotTprelL32 = 1356

    LDtoc = 1357

    LDtocBA = 1358

    LDtocCPT = 1359

    LDtocJTI = 1360

    LDtocL = 1361

    LFD = 1362

    LFDEPX = 1363

    LFDU = 1364

    LFDUX = 1365

    LFDX = 1366

    LFDXTLS = 1367

    LFIWAX = 1369

    LFIWZX = 1370

    LFS = 1371

    LFSU = 1372

    LFSUX = 1373

    LFSX = 1374

    LFSXTLS = 1375

    LHA = 1377

    LHA8 = 1378

    LHARX = 1379

    LHARXL = 1380

    LHAU = 1381

    LHAU8 = 1382

    LHAUX = 1383

    LHAUX8 = 1384

    LHAX = 1385

    LHAX8 = 1386

    LHAXTLS = 1387

    LHAXTLS_32 = 1389

    LHBRX = 1390

    LHBRX8 = 1391

    LHEPX = 1392

    LHZ = 1393

    LHZ8 = 1394

    LHZCIX = 1395

    LHZU = 1396

    LHZU8 = 1397

    LHZUX = 1398

    LHZUX8 = 1399

    LHZX = 1400

    LHZX8 = 1401

    LHZXTLS = 1402

    LHZXTLS_32 = 1404

    LI = 1405

    LI8 = 1406

    LIS = 1407

    LIS8 = 1408

    LMW = 1409

    LQ = 1410

    LQARX = 1411

    LQARXL = 1412

    LQX_PSEUDO = 1413

    LSWI = 1414

    LVEBX = 1415

    LVEHX = 1416

    LVEWX = 1417

    LVSL = 1418

    LVSR = 1419

    LVX = 1420

    LVXL = 1421

    LWA = 1422

    LWARX = 1423

    LWARXL = 1424

    LWAT = 1425

    LWAUX = 1426

    LWAX = 1427

    LWAXTLS = 1428

    LWAXTLS_32 = 1430

    LWAX_32 = 1431

    LWA_32 = 1432

    LWBRX = 1433

    LWBRX8 = 1434

    LWEPX = 1435

    LWZ = 1436

    LWZ8 = 1437

    LWZCIX = 1438

    LWZU = 1439

    LWZU8 = 1440

    LWZUX = 1441

    LWZUX8 = 1442

    LWZX = 1443

    LWZX8 = 1444

    LWZXTLS = 1445

    LWZXTLS_32 = 1447

    LWZtoc = 1448

    LWZtocL = 1449

    LXSD = 1450

    LXSDX = 1451

    LXSIBZX = 1452

    LXSIHZX = 1453

    LXSIWAX = 1454

    LXSIWZX = 1455

    LXSSP = 1456

    LXSSPX = 1457

    LXV = 1458

    LXVB16X = 1459

    LXVD2X = 1460

    LXVDSX = 1461

    LXVH8X = 1462

    LXVKQ = 1463

    LXVL = 1464

    LXVLL = 1465

    LXVP = 1466

    LXVPRL = 1467

    LXVPRLL = 1468

    LXVPX = 1469

    LXVRBX = 1470

    LXVRDX = 1471

    LXVRHX = 1472

    LXVRL = 1473

    LXVRLL = 1474

    LXVRWX = 1475

    LXVW4X = 1476

    LXVWSX = 1477

    LXVX = 1478

    MADDHD = 1479

    MADDHDU = 1480

    MADDLD = 1481

    MADDLD8 = 1482

    MBAR = 1483

    MCRF = 1484

    MCRFS = 1485

    MCRXRX = 1486

    MFBHRBE = 1487

    MFCR = 1488

    MFCR8 = 1489

    MFCTR = 1490

    MFCTR8 = 1491

    MFDCR = 1492

    MFFS = 1493

    MFFSCDRN = 1494

    MFFSCDRNI = 1495

    MFFSCE = 1496

    MFFSCRN = 1497

    MFFSCRNI = 1498

    MFFSL = 1499

    MFFS_rec = 1500

    MFLR = 1501

    MFLR8 = 1502

    MFMSR = 1503

    MFOCRF = 1504

    MFOCRF8 = 1505

    MFPMR = 1506

    MFSPR = 1507

    MFSPR8 = 1508

    MFSR = 1509

    MFSRIN = 1510

    MFTB = 1511

    MFTB8 = 1512

    MFUDSCR = 1513

    MFVRD = 1514

    MFVRSAVE = 1515

    MFVRSAVEv = 1516

    MFVRWZ = 1517

    MFVSCR = 1518

    MFVSRD = 1519

    MFVSRLD = 1520

    MFVSRWZ = 1521

    MODSD = 1522

    MODSW = 1523

    MODUD = 1524

    MODUW = 1525

    MSGSYNC = 1526

    MSYNC = 1527

    MTCRF = 1528

    MTCRF8 = 1529

    MTCTR = 1530

    MTCTR8 = 1531

    MTCTR8loop = 1532

    MTCTRloop = 1533

    MTDCR = 1534

    MTFSB0 = 1535

    MTFSB1 = 1536

    MTFSF = 1537

    MTFSFI = 1538

    MTFSFI_rec = 1539

    MTFSFIb = 1540

    MTFSF_rec = 1541

    MTFSFb = 1542

    MTLR = 1543

    MTLR8 = 1544

    MTMSR = 1545

    MTMSRD = 1546

    MTOCRF = 1547

    MTOCRF8 = 1548

    MTPMR = 1549

    MTSPR = 1550

    MTSPR8 = 1551

    MTSR = 1552

    MTSRIN = 1553

    MTUDSCR = 1554

    MTVRD = 1555

    MTVRSAVE = 1556

    MTVRSAVEv = 1557

    MTVRWA = 1558

    MTVRWZ = 1559

    MTVSCR = 1560

    MTVSRBM = 1561

    MTVSRBMI = 1562

    MTVSRD = 1563

    MTVSRDD = 1564

    MTVSRDM = 1565

    MTVSRHM = 1566

    MTVSRQM = 1567

    MTVSRWA = 1568

    MTVSRWM = 1569

    MTVSRWS = 1570

    MTVSRWZ = 1571

    MULHD = 1572

    MULHDU = 1573

    MULHDU_rec = 1574

    MULHD_rec = 1575

    MULHW = 1576

    MULHWU = 1577

    MULHWU_rec = 1578

    MULHW_rec = 1579

    MULLD = 1580

    MULLDO = 1581

    MULLDO_rec = 1582

    MULLD_rec = 1583

    MULLI = 1584

    MULLI8 = 1585

    MULLW = 1586

    MULLWO = 1587

    MULLWO_rec = 1588

    MULLW_rec = 1589

    MoveGOTtoLR = 1590

    MovePCtoLR = 1591

    MovePCtoLR8 = 1592

    NAND = 1593

    NAND8 = 1594

    NAND8_rec = 1595

    NAND_rec = 1596

    NAP = 1597

    NEG = 1598

    NEG8 = 1599

    NEG8O = 1600

    NEG8O_rec = 1601

    NEG8_rec = 1602

    NEGO = 1603

    NEGO_rec = 1604

    NEG_rec = 1605

    NOP = 1606

    NOP_GT_PWR6 = 1607

    NOP_GT_PWR7 = 1608

    NOR = 1609

    NOR8 = 1610

    NOR8_rec = 1611

    NOR_rec = 1612

    OR = 1613

    OR8 = 1614

    OR8_rec = 1615

    ORC = 1616

    ORC8 = 1617

    ORC8_rec = 1618

    ORC_rec = 1619

    ORI = 1620

    ORI8 = 1621

    ORIS = 1622

    ORIS8 = 1623

    OR_rec = 1624

    PADDI = 1625

    PADDI8 = 1626

    PADDI8pc = 1627

    PADDIdtprel = 1628

    PADDIpc = 1629

    PDEPD = 1630

    PEXTD = 1631

    PLA = 1632

    PLA8 = 1633

    PLA8pc = 1634

    PLApc = 1635

    PLBZ = 1636

    PLBZ8 = 1637

    PLBZ8nopc = 1638

    PLBZ8onlypc = 1639

    PLBZ8pc = 1640

    PLBZnopc = 1641

    PLBZonlypc = 1642

    PLBZpc = 1643

    PLD = 1644

    PLDnopc = 1645

    PLDonlypc = 1646

    PLDpc = 1647

    PLFD = 1648

    PLFDnopc = 1649

    PLFDonlypc = 1650

    PLFDpc = 1651

    PLFS = 1652

    PLFSnopc = 1653

    PLFSonlypc = 1654

    PLFSpc = 1655

    PLHA = 1656

    PLHA8 = 1657

    PLHA8nopc = 1658

    PLHA8onlypc = 1659

    PLHA8pc = 1660

    PLHAnopc = 1661

    PLHAonlypc = 1662

    PLHApc = 1663

    PLHZ = 1664

    PLHZ8 = 1665

    PLHZ8nopc = 1666

    PLHZ8onlypc = 1667

    PLHZ8pc = 1668

    PLHZnopc = 1669

    PLHZonlypc = 1670

    PLHZpc = 1671

    PLI = 1672

    PLI8 = 1673

    PLWA = 1674

    PLWA8 = 1675

    PLWA8nopc = 1676

    PLWA8onlypc = 1677

    PLWA8pc = 1678

    PLWAnopc = 1679

    PLWAonlypc = 1680

    PLWApc = 1681

    PLWZ = 1682

    PLWZ8 = 1683

    PLWZ8nopc = 1684

    PLWZ8onlypc = 1685

    PLWZ8pc = 1686

    PLWZnopc = 1687

    PLWZonlypc = 1688

    PLWZpc = 1689

    PLXSD = 1690

    PLXSDnopc = 1691

    PLXSDonlypc = 1692

    PLXSDpc = 1693

    PLXSSP = 1694

    PLXSSPnopc = 1695

    PLXSSPonlypc = 1696

    PLXSSPpc = 1697

    PLXV = 1698

    PLXVP = 1699

    PLXVPnopc = 1700

    PLXVPonlypc = 1701

    PLXVPpc = 1702

    PLXVnopc = 1703

    PLXVonlypc = 1704

    PLXVpc = 1705

    PMDMXVBF16GERX2 = 1706

    PMDMXVBF16GERX2NN = 1707

    PMDMXVBF16GERX2NP = 1708

    PMDMXVBF16GERX2PN = 1709

    PMDMXVBF16GERX2PP = 1710

    PMDMXVF16GERX2 = 1711

    PMDMXVF16GERX2NN = 1712

    PMDMXVF16GERX2NP = 1713

    PMDMXVF16GERX2PN = 1714

    PMDMXVF16GERX2PP = 1715

    PMDMXVI8GERX4 = 1716

    PMDMXVI8GERX4PP = 1717

    PMDMXVI8GERX4SPP = 1718

    PMXVBF16GER2 = 1719

    PMXVBF16GER2NN = 1720

    PMXVBF16GER2NP = 1721

    PMXVBF16GER2PN = 1722

    PMXVBF16GER2PP = 1723

    PMXVBF16GER2W = 1724

    PMXVBF16GER2WNN = 1725

    PMXVBF16GER2WNP = 1726

    PMXVBF16GER2WPN = 1727

    PMXVBF16GER2WPP = 1728

    PMXVF16GER2 = 1729

    PMXVF16GER2NN = 1730

    PMXVF16GER2NP = 1731

    PMXVF16GER2PN = 1732

    PMXVF16GER2PP = 1733

    PMXVF16GER2W = 1734

    PMXVF16GER2WNN = 1735

    PMXVF16GER2WNP = 1736

    PMXVF16GER2WPN = 1737

    PMXVF16GER2WPP = 1738

    PMXVF32GER = 1739

    PMXVF32GERNN = 1740

    PMXVF32GERNP = 1741

    PMXVF32GERPN = 1742

    PMXVF32GERPP = 1743

    PMXVF32GERW = 1744

    PMXVF32GERWNN = 1745

    PMXVF32GERWNP = 1746

    PMXVF32GERWPN = 1747

    PMXVF32GERWPP = 1748

    PMXVF64GER = 1749

    PMXVF64GERNN = 1750

    PMXVF64GERNP = 1751

    PMXVF64GERPN = 1752

    PMXVF64GERPP = 1753

    PMXVF64GERW = 1754

    PMXVF64GERWNN = 1755

    PMXVF64GERWNP = 1756

    PMXVF64GERWPN = 1757

    PMXVF64GERWPP = 1758

    PMXVI16GER2 = 1759

    PMXVI16GER2PP = 1760

    PMXVI16GER2S = 1761

    PMXVI16GER2SPP = 1762

    PMXVI16GER2SW = 1763

    PMXVI16GER2SWPP = 1764

    PMXVI16GER2W = 1765

    PMXVI16GER2WPP = 1766

    PMXVI4GER8 = 1767

    PMXVI4GER8PP = 1768

    PMXVI4GER8W = 1769

    PMXVI4GER8WPP = 1770

    PMXVI8GER4 = 1771

    PMXVI8GER4PP = 1772

    PMXVI8GER4SPP = 1773

    PMXVI8GER4W = 1774

    PMXVI8GER4WPP = 1775

    PMXVI8GER4WSPP = 1776

    POPCNTB = 1777

    POPCNTB8 = 1778

    POPCNTD = 1779

    POPCNTW = 1780

    PPC32GOT = 1781

    PPC32PICGOT = 1782

    PREPARE_PROBED_ALLOCA_32 = 1783

    PREPARE_PROBED_ALLOCA_64 = 1784

    PREPARE_PROBED_ALLOCA_NEGSIZE_SAME_REG_32 = 1785

    PREPARE_PROBED_ALLOCA_NEGSIZE_SAME_REG_64 = 1786

    PROBED_ALLOCA_32 = 1787

    PROBED_ALLOCA_64 = 1788

    PROBED_STACKALLOC_32 = 1789

    PROBED_STACKALLOC_64 = 1790

    PSTB = 1791

    PSTB8 = 1792

    PSTB8nopc = 1793

    PSTB8onlypc = 1794

    PSTB8pc = 1795

    PSTBnopc = 1796

    PSTBonlypc = 1797

    PSTBpc = 1798

    PSTD = 1799

    PSTDnopc = 1800

    PSTDonlypc = 1801

    PSTDpc = 1802

    PSTFD = 1803

    PSTFDnopc = 1804

    PSTFDonlypc = 1805

    PSTFDpc = 1806

    PSTFS = 1807

    PSTFSnopc = 1808

    PSTFSonlypc = 1809

    PSTFSpc = 1810

    PSTH = 1811

    PSTH8 = 1812

    PSTH8nopc = 1813

    PSTH8onlypc = 1814

    PSTH8pc = 1815

    PSTHnopc = 1816

    PSTHonlypc = 1817

    PSTHpc = 1818

    PSTW = 1819

    PSTW8 = 1820

    PSTW8nopc = 1821

    PSTW8onlypc = 1822

    PSTW8pc = 1823

    PSTWnopc = 1824

    PSTWonlypc = 1825

    PSTWpc = 1826

    PSTXSD = 1827

    PSTXSDnopc = 1828

    PSTXSDonlypc = 1829

    PSTXSDpc = 1830

    PSTXSSP = 1831

    PSTXSSPnopc = 1832

    PSTXSSPonlypc = 1833

    PSTXSSPpc = 1834

    PSTXV = 1835

    PSTXVP = 1836

    PSTXVPnopc = 1837

    PSTXVPonlypc = 1838

    PSTXVPpc = 1839

    PSTXVnopc = 1840

    PSTXVonlypc = 1841

    PSTXVpc = 1842

    PseudoEIEIO = 1843

    RESTORE_ACC = 1844

    RESTORE_CR = 1845

    RESTORE_CRBIT = 1846

    RESTORE_DMR = 1847

    RESTORE_DMRP = 1848

    RESTORE_QUADWORD = 1849

    RESTORE_UACC = 1850

    RESTORE_WACC = 1851

    RFCI = 1852

    RFDI = 1853

    RFEBB = 1854

    RFI = 1855

    RFID = 1856

    RFMCI = 1857

    RLDCL = 1858

    RLDCL_rec = 1859

    RLDCR = 1860

    RLDCR_rec = 1861

    RLDIC = 1862

    RLDICL = 1863

    RLDICL_32 = 1864

    RLDICL_32_64 = 1865

    RLDICL_32_rec = 1866

    RLDICL_rec = 1867

    RLDICR = 1868

    RLDICR_32 = 1869

    RLDICR_rec = 1870

    RLDIC_rec = 1871

    RLDIMI = 1872

    RLDIMI_rec = 1873

    RLWIMI = 1874

    RLWIMI8 = 1875

    RLWIMI8_rec = 1876

    RLWIMI_rec = 1877

    RLWINM = 1878

    RLWINM8 = 1879

    RLWINM8_rec = 1880

    RLWINM_rec = 1881

    RLWNM = 1882

    RLWNM8 = 1883

    RLWNM8_rec = 1884

    RLWNM_rec = 1885

    ReadTB = 1886

    SC = 1887

    SCV = 1888

    SELECT_CC_F16 = 1889

    SELECT_CC_F4 = 1890

    SELECT_CC_F8 = 1891

    SELECT_CC_I4 = 1892

    SELECT_CC_I8 = 1893

    SELECT_CC_SPE = 1894

    SELECT_CC_SPE4 = 1895

    SELECT_CC_VRRC = 1896

    SELECT_CC_VSFRC = 1897

    SELECT_CC_VSRC = 1898

    SELECT_CC_VSSRC = 1899

    SELECT_F16 = 1900

    SELECT_F4 = 1901

    SELECT_F8 = 1902

    SELECT_I4 = 1903

    SELECT_I8 = 1904

    SELECT_SPE = 1905

    SELECT_SPE4 = 1906

    SELECT_VRRC = 1907

    SELECT_VSFRC = 1908

    SELECT_VSRC = 1909

    SELECT_VSSRC = 1910

    SETB = 1911

    SETB8 = 1912

    SETBC = 1913

    SETBC8 = 1914

    SETBCR = 1915

    SETBCR8 = 1916

    SETFLM = 1917

    SETNBC = 1918

    SETNBC8 = 1919

    SETNBCR = 1920

    SETNBCR8 = 1921

    SETRND = 1922

    SETRNDi = 1923

    SLBFEE_rec = 1924

    SLBIA = 1925

    SLBIE = 1926

    SLBIEG = 1927

    SLBMFEE = 1928

    SLBMFEV = 1929

    SLBMTE = 1930

    SLBSYNC = 1931

    SLD = 1932

    SLD_rec = 1933

    SLW = 1934

    SLW8 = 1935

    SLW8_rec = 1936

    SLW_rec = 1937

    SPELWZ = 1938

    SPELWZX = 1939

    SPESTW = 1940

    SPESTWX = 1941

    SPILL_ACC = 1942

    SPILL_CR = 1943

    SPILL_CRBIT = 1944

    SPILL_DMR = 1945

    SPILL_DMRP = 1946

    SPILL_QUADWORD = 1947

    SPILL_UACC = 1948

    SPILL_WACC = 1949

    SPLIT_QUADWORD = 1950

    SRAD = 1951

    SRADI = 1952

    SRADI_32 = 1953

    SRADI_rec = 1954

    SRAD_rec = 1955

    SRAW = 1956

    SRAW8 = 1957

    SRAW8_rec = 1958

    SRAWI = 1959

    SRAWI8 = 1960

    SRAWI8_rec = 1961

    SRAWI_rec = 1962

    SRAW_rec = 1963

    SRD = 1964

    SRD_rec = 1965

    SRW = 1966

    SRW8 = 1967

    SRW8_rec = 1968

    SRW_rec = 1969

    STB = 1970

    STB8 = 1971

    STBCIX = 1972

    STBCX = 1973

    STBEPX = 1974

    STBU = 1975

    STBU8 = 1976

    STBUX = 1977

    STBUX8 = 1978

    STBX = 1979

    STBX8 = 1980

    STBXTLS = 1981

    STBXTLS_32 = 1983

    STD = 1984

    STDAT = 1985

    STDBRX = 1986

    STDCIX = 1987

    STDCX = 1988

    STDU = 1989

    STDUX = 1990

    STDX = 1991

    STDXTLS = 1992

    STFD = 1994

    STFDEPX = 1995

    STFDU = 1996

    STFDUX = 1997

    STFDX = 1998

    STFDXTLS = 1999

    STFIWX = 2001

    STFS = 2002

    STFSU = 2003

    STFSUX = 2004

    STFSX = 2005

    STFSXTLS = 2006

    STH = 2008

    STH8 = 2009

    STHBRX = 2010

    STHCIX = 2011

    STHCX = 2012

    STHEPX = 2013

    STHU = 2014

    STHU8 = 2015

    STHUX = 2016

    STHUX8 = 2017

    STHX = 2018

    STHX8 = 2019

    STHXTLS = 2020

    STHXTLS_32 = 2022

    STMW = 2023

    STOP = 2024

    STQ = 2025

    STQCX = 2026

    STQX_PSEUDO = 2027

    STSWI = 2028

    STVEBX = 2029

    STVEHX = 2030

    STVEWX = 2031

    STVX = 2032

    STVXL = 2033

    STW = 2034

    STW8 = 2035

    STWAT = 2036

    STWBRX = 2037

    STWCIX = 2038

    STWCX = 2039

    STWEPX = 2040

    STWU = 2041

    STWU8 = 2042

    STWUX = 2043

    STWUX8 = 2044

    STWX = 2045

    STWX8 = 2046

    STWXTLS = 2047

    STWXTLS_32 = 2049

    STXSD = 2050

    STXSDX = 2051

    STXSIBX = 2052

    STXSIBXv = 2053

    STXSIHX = 2054

    STXSIHXv = 2055

    STXSIWX = 2056

    STXSSP = 2057

    STXSSPX = 2058

    STXV = 2059

    STXVB16X = 2060

    STXVD2X = 2061

    STXVH8X = 2062

    STXVL = 2063

    STXVLL = 2064

    STXVP = 2065

    STXVPRL = 2066

    STXVPRLL = 2067

    STXVPX = 2068

    STXVRBX = 2069

    STXVRDX = 2070

    STXVRHX = 2071

    STXVRL = 2072

    STXVRLL = 2073

    STXVRWX = 2074

    STXVW4X = 2075

    STXVX = 2076

    SUBF = 2077

    SUBF8 = 2078

    SUBF8O = 2079

    SUBF8O_rec = 2080

    SUBF8_rec = 2081

    SUBFC = 2082

    SUBFC8 = 2083

    SUBFC8O = 2084

    SUBFC8O_rec = 2085

    SUBFC8_rec = 2086

    SUBFCO = 2087

    SUBFCO_rec = 2088

    SUBFC_rec = 2089

    SUBFE = 2090

    SUBFE8 = 2091

    SUBFE8O = 2092

    SUBFE8O_rec = 2093

    SUBFE8_rec = 2094

    SUBFEO = 2095

    SUBFEO_rec = 2096

    SUBFE_rec = 2097

    SUBFIC = 2098

    SUBFIC8 = 2099

    SUBFME = 2100

    SUBFME8 = 2101

    SUBFME8O = 2102

    SUBFME8O_rec = 2103

    SUBFME8_rec = 2104

    SUBFMEO = 2105

    SUBFMEO_rec = 2106

    SUBFME_rec = 2107

    SUBFO = 2108

    SUBFO_rec = 2109

    SUBFUS = 2110

    SUBFUS_rec = 2111

    SUBFZE = 2112

    SUBFZE8 = 2113

    SUBFZE8O = 2114

    SUBFZE8O_rec = 2115

    SUBFZE8_rec = 2116

    SUBFZEO = 2117

    SUBFZEO_rec = 2118

    SUBFZE_rec = 2119

    SUBF_rec = 2120

    SYNC = 2121

    SYNCP10 = 2122

    TABORT = 2123

    TABORTDC = 2124

    TABORTDCI = 2125

    TABORTWC = 2126

    TABORTWCI = 2127

    TAILB = 2128

    TAILB8 = 2129

    TAILBA = 2130

    TAILBA8 = 2131

    TAILBCTR = 2132

    TAILBCTR8 = 2133

    TBEGIN = 2134

    TBEGIN_RET = 2135

    TCHECK = 2136

    TCHECK_RET = 2137

    TCRETURNai = 2138

    TCRETURNai8 = 2139

    TCRETURNdi = 2140

    TCRETURNdi8 = 2141

    TCRETURNri = 2142

    TCRETURNri8 = 2143

    TD = 2144

    TDI = 2145

    TEND = 2146

    TLBIA = 2147

    TLBIE = 2148

    TLBIEL = 2149

    TLBILX = 2150

    TLBIVAX = 2151

    TLBLD = 2152

    TLBLI = 2153

    TLBRE = 2154

    TLBRE2 = 2155

    TLBSX = 2156

    TLBSX2 = 2157

    TLBSX2D = 2158

    TLBSYNC = 2159

    TLBWE = 2160

    TLBWE2 = 2161

    TLSGDAIX = 2162

    TLSGDAIX8 = 2163

    TLSLDAIX = 2164

    TLSLDAIX8 = 2165

    TRAP = 2166

    TRECHKPT = 2167

    TRECLAIM = 2168

    TSR = 2169

    TW = 2170

    TWI = 2171

    UNENCODED_NOP = 2172

    UpdateGBR = 2173

    VABSDUB = 2174

    VABSDUH = 2175

    VABSDUW = 2176

    VADDCUQ = 2177

    VADDCUW = 2178

    VADDECUQ = 2179

    VADDEUQM = 2180

    VADDFP = 2181

    VADDSBS = 2182

    VADDSHS = 2183

    VADDSWS = 2184

    VADDUBM = 2185

    VADDUBS = 2186

    VADDUDM = 2187

    VADDUHM = 2188

    VADDUHS = 2189

    VADDUQM = 2190

    VADDUWM = 2191

    VADDUWS = 2192

    VAND = 2193

    VANDC = 2194

    VAVGSB = 2195

    VAVGSH = 2196

    VAVGSW = 2197

    VAVGUB = 2198

    VAVGUH = 2199

    VAVGUW = 2200

    VBPERMD = 2201

    VBPERMQ = 2202

    VCFSX = 2203

    VCFSX_0 = 2204

    VCFUGED = 2205

    VCFUX = 2206

    VCFUX_0 = 2207

    VCIPHER = 2208

    VCIPHERLAST = 2209

    VCLRLB = 2210

    VCLRRB = 2211

    VCLZB = 2212

    VCLZD = 2213

    VCLZDM = 2214

    VCLZH = 2215

    VCLZLSBB = 2216

    VCLZW = 2217

    VCMPBFP = 2218

    VCMPBFP_rec = 2219

    VCMPEQFP = 2220

    VCMPEQFP_rec = 2221

    VCMPEQUB = 2222

    VCMPEQUB_rec = 2223

    VCMPEQUD = 2224

    VCMPEQUD_rec = 2225

    VCMPEQUH = 2226

    VCMPEQUH_rec = 2227

    VCMPEQUQ = 2228

    VCMPEQUQ_rec = 2229

    VCMPEQUW = 2230

    VCMPEQUW_rec = 2231

    VCMPGEFP = 2232

    VCMPGEFP_rec = 2233

    VCMPGTFP = 2234

    VCMPGTFP_rec = 2235

    VCMPGTSB = 2236

    VCMPGTSB_rec = 2237

    VCMPGTSD = 2238

    VCMPGTSD_rec = 2239

    VCMPGTSH = 2240

    VCMPGTSH_rec = 2241

    VCMPGTSQ = 2242

    VCMPGTSQ_rec = 2243

    VCMPGTSW = 2244

    VCMPGTSW_rec = 2245

    VCMPGTUB = 2246

    VCMPGTUB_rec = 2247

    VCMPGTUD = 2248

    VCMPGTUD_rec = 2249

    VCMPGTUH = 2250

    VCMPGTUH_rec = 2251

    VCMPGTUQ = 2252

    VCMPGTUQ_rec = 2253

    VCMPGTUW = 2254

    VCMPGTUW_rec = 2255

    VCMPNEB = 2256

    VCMPNEB_rec = 2257

    VCMPNEH = 2258

    VCMPNEH_rec = 2259

    VCMPNEW = 2260

    VCMPNEW_rec = 2261

    VCMPNEZB = 2262

    VCMPNEZB_rec = 2263

    VCMPNEZH = 2264

    VCMPNEZH_rec = 2265

    VCMPNEZW = 2266

    VCMPNEZW_rec = 2267

    VCMPSQ = 2268

    VCMPUQ = 2269

    VCNTMBB = 2270

    VCNTMBD = 2271

    VCNTMBH = 2272

    VCNTMBW = 2273

    VCTSXS = 2274

    VCTSXS_0 = 2275

    VCTUXS = 2276

    VCTUXS_0 = 2277

    VCTZB = 2278

    VCTZD = 2279

    VCTZDM = 2280

    VCTZH = 2281

    VCTZLSBB = 2282

    VCTZW = 2283

    VDIVESD = 2284

    VDIVESQ = 2285

    VDIVESW = 2286

    VDIVEUD = 2287

    VDIVEUQ = 2288

    VDIVEUW = 2289

    VDIVSD = 2290

    VDIVSQ = 2291

    VDIVSW = 2292

    VDIVUD = 2293

    VDIVUQ = 2294

    VDIVUW = 2295

    VEQV = 2296

    VEXPANDBM = 2297

    VEXPANDDM = 2298

    VEXPANDHM = 2299

    VEXPANDQM = 2300

    VEXPANDWM = 2301

    VEXPTEFP = 2302

    VEXTDDVLX = 2303

    VEXTDDVRX = 2304

    VEXTDUBVLX = 2305

    VEXTDUBVRX = 2306

    VEXTDUHVLX = 2307

    VEXTDUHVRX = 2308

    VEXTDUWVLX = 2309

    VEXTDUWVRX = 2310

    VEXTRACTBM = 2311

    VEXTRACTD = 2312

    VEXTRACTDM = 2313

    VEXTRACTHM = 2314

    VEXTRACTQM = 2315

    VEXTRACTUB = 2316

    VEXTRACTUH = 2317

    VEXTRACTUW = 2318

    VEXTRACTWM = 2319

    VEXTSB2D = 2320

    VEXTSB2Ds = 2321

    VEXTSB2W = 2322

    VEXTSB2Ws = 2323

    VEXTSD2Q = 2324

    VEXTSH2D = 2325

    VEXTSH2Ds = 2326

    VEXTSH2W = 2327

    VEXTSH2Ws = 2328

    VEXTSW2D = 2329

    VEXTSW2Ds = 2330

    VEXTUBLX = 2331

    VEXTUBRX = 2332

    VEXTUHLX = 2333

    VEXTUHRX = 2334

    VEXTUWLX = 2335

    VEXTUWRX = 2336

    VGBBD = 2337

    VGNB = 2338

    VINSBLX = 2339

    VINSBRX = 2340

    VINSBVLX = 2341

    VINSBVRX = 2342

    VINSD = 2343

    VINSDLX = 2344

    VINSDRX = 2345

    VINSERTB = 2346

    VINSERTD = 2347

    VINSERTH = 2348

    VINSERTW = 2349

    VINSHLX = 2350

    VINSHRX = 2351

    VINSHVLX = 2352

    VINSHVRX = 2353

    VINSW = 2354

    VINSWLX = 2355

    VINSWRX = 2356

    VINSWVLX = 2357

    VINSWVRX = 2358

    VLOGEFP = 2359

    VMADDFP = 2360

    VMAXFP = 2361

    VMAXSB = 2362

    VMAXSD = 2363

    VMAXSH = 2364

    VMAXSW = 2365

    VMAXUB = 2366

    VMAXUD = 2367

    VMAXUH = 2368

    VMAXUW = 2369

    VMHADDSHS = 2370

    VMHRADDSHS = 2371

    VMINFP = 2372

    VMINSB = 2373

    VMINSD = 2374

    VMINSH = 2375

    VMINSW = 2376

    VMINUB = 2377

    VMINUD = 2378

    VMINUH = 2379

    VMINUW = 2380

    VMLADDUHM = 2381

    VMODSD = 2382

    VMODSQ = 2383

    VMODSW = 2384

    VMODUD = 2385

    VMODUQ = 2386

    VMODUW = 2387

    VMRGEW = 2388

    VMRGHB = 2389

    VMRGHH = 2390

    VMRGHW = 2391

    VMRGLB = 2392

    VMRGLH = 2393

    VMRGLW = 2394

    VMRGOW = 2395

    VMSUMCUD = 2396

    VMSUMMBM = 2397

    VMSUMSHM = 2398

    VMSUMSHS = 2399

    VMSUMUBM = 2400

    VMSUMUDM = 2401

    VMSUMUHM = 2402

    VMSUMUHS = 2403

    VMUL10CUQ = 2404

    VMUL10ECUQ = 2405

    VMUL10EUQ = 2406

    VMUL10UQ = 2407

    VMULESB = 2408

    VMULESD = 2409

    VMULESH = 2410

    VMULESW = 2411

    VMULEUB = 2412

    VMULEUD = 2413

    VMULEUH = 2414

    VMULEUW = 2415

    VMULHSD = 2416

    VMULHSW = 2417

    VMULHUD = 2418

    VMULHUW = 2419

    VMULLD = 2420

    VMULOSB = 2421

    VMULOSD = 2422

    VMULOSH = 2423

    VMULOSW = 2424

    VMULOUB = 2425

    VMULOUD = 2426

    VMULOUH = 2427

    VMULOUW = 2428

    VMULUWM = 2429

    VNAND = 2430

    VNCIPHER = 2431

    VNCIPHERLAST = 2432

    VNEGD = 2433

    VNEGW = 2434

    VNMSUBFP = 2435

    VNOR = 2436

    VOR = 2437

    VORC = 2438

    VPDEPD = 2439

    VPERM = 2440

    VPERMR = 2441

    VPERMXOR = 2442

    VPEXTD = 2443

    VPKPX = 2444

    VPKSDSS = 2445

    VPKSDUS = 2446

    VPKSHSS = 2447

    VPKSHUS = 2448

    VPKSWSS = 2449

    VPKSWUS = 2450

    VPKUDUM = 2451

    VPKUDUS = 2452

    VPKUHUM = 2453

    VPKUHUS = 2454

    VPKUWUM = 2455

    VPKUWUS = 2456

    VPMSUMB = 2457

    VPMSUMD = 2458

    VPMSUMH = 2459

    VPMSUMW = 2460

    VPOPCNTB = 2461

    VPOPCNTD = 2462

    VPOPCNTH = 2463

    VPOPCNTW = 2464

    VPRTYBD = 2465

    VPRTYBQ = 2466

    VPRTYBW = 2467

    VREFP = 2468

    VRFIM = 2469

    VRFIN = 2470

    VRFIP = 2471

    VRFIZ = 2472

    VRLB = 2473

    VRLD = 2474

    VRLDMI = 2475

    VRLDNM = 2476

    VRLH = 2477

    VRLQ = 2478

    VRLQMI = 2479

    VRLQNM = 2480

    VRLW = 2481

    VRLWMI = 2482

    VRLWNM = 2483

    VRSQRTEFP = 2484

    VSBOX = 2485

    VSEL = 2486

    VSHASIGMAD = 2487

    VSHASIGMAW = 2488

    VSL = 2489

    VSLB = 2490

    VSLD = 2491

    VSLDBI = 2492

    VSLDOI = 2493

    VSLH = 2494

    VSLO = 2495

    VSLQ = 2496

    VSLV = 2497

    VSLW = 2498

    VSPLTB = 2499

    VSPLTBs = 2500

    VSPLTH = 2501

    VSPLTHs = 2502

    VSPLTISB = 2503

    VSPLTISH = 2504

    VSPLTISW = 2505

    VSPLTW = 2506

    VSR = 2507

    VSRAB = 2508

    VSRAD = 2509

    VSRAH = 2510

    VSRAQ = 2511

    VSRAW = 2512

    VSRB = 2513

    VSRD = 2514

    VSRDBI = 2515

    VSRH = 2516

    VSRO = 2517

    VSRQ = 2518

    VSRV = 2519

    VSRW = 2520

    VSTRIBL = 2521

    VSTRIBL_rec = 2522

    VSTRIBR = 2523

    VSTRIBR_rec = 2524

    VSTRIHL = 2525

    VSTRIHL_rec = 2526

    VSTRIHR = 2527

    VSTRIHR_rec = 2528

    VSUBCUQ = 2529

    VSUBCUW = 2530

    VSUBECUQ = 2531

    VSUBEUQM = 2532

    VSUBFP = 2533

    VSUBSBS = 2534

    VSUBSHS = 2535

    VSUBSWS = 2536

    VSUBUBM = 2537

    VSUBUBS = 2538

    VSUBUDM = 2539

    VSUBUHM = 2540

    VSUBUHS = 2541

    VSUBUQM = 2542

    VSUBUWM = 2543

    VSUBUWS = 2544

    VSUM2SWS = 2545

    VSUM4SBS = 2546

    VSUM4SHS = 2547

    VSUM4UBS = 2548

    VSUMSWS = 2549

    VUPKHPX = 2550

    VUPKHSB = 2551

    VUPKHSH = 2552

    VUPKHSW = 2553

    VUPKLPX = 2554

    VUPKLSB = 2555

    VUPKLSH = 2556

    VUPKLSW = 2557

    VXOR = 2558

    V_SET0 = 2559

    V_SET0B = 2560

    V_SET0H = 2561

    V_SETALLONES = 2562

    V_SETALLONESB = 2563

    V_SETALLONESH = 2564

    WAIT = 2565

    WAITP10 = 2566

    WRTEE = 2567

    WRTEEI = 2568

    XOR = 2569

    XOR8 = 2570

    XOR8_rec = 2571

    XORI = 2572

    XORI8 = 2573

    XORIS = 2574

    XORIS8 = 2575

    XOR_rec = 2576

    XSABSDP = 2577

    XSABSQP = 2578

    XSADDDP = 2579

    XSADDQP = 2580

    XSADDQPO = 2581

    XSADDSP = 2582

    XSCMPEQDP = 2583

    XSCMPEQQP = 2584

    XSCMPEXPDP = 2585

    XSCMPEXPQP = 2586

    XSCMPGEDP = 2587

    XSCMPGEQP = 2588

    XSCMPGTDP = 2589

    XSCMPGTQP = 2590

    XSCMPODP = 2591

    XSCMPOQP = 2592

    XSCMPUDP = 2593

    XSCMPUQP = 2594

    XSCPSGNDP = 2595

    XSCPSGNQP = 2596

    XSCVDPHP = 2597

    XSCVDPQP = 2598

    XSCVDPSP = 2599

    XSCVDPSPN = 2600

    XSCVDPSXDS = 2601

    XSCVDPSXDSs = 2602

    XSCVDPSXWS = 2603

    XSCVDPSXWSs = 2604

    XSCVDPUXDS = 2605

    XSCVDPUXDSs = 2606

    XSCVDPUXWS = 2607

    XSCVDPUXWSs = 2608

    XSCVHPDP = 2609

    XSCVQPDP = 2610

    XSCVQPDPO = 2611

    XSCVQPSDZ = 2612

    XSCVQPSQZ = 2613

    XSCVQPSWZ = 2614

    XSCVQPUDZ = 2615

    XSCVQPUQZ = 2616

    XSCVQPUWZ = 2617

    XSCVSDQP = 2618

    XSCVSPDP = 2619

    XSCVSPDPN = 2620

    XSCVSQQP = 2621

    XSCVSXDDP = 2622

    XSCVSXDSP = 2623

    XSCVUDQP = 2624

    XSCVUQQP = 2625

    XSCVUXDDP = 2626

    XSCVUXDSP = 2627

    XSDIVDP = 2628

    XSDIVQP = 2629

    XSDIVQPO = 2630

    XSDIVSP = 2631

    XSIEXPDP = 2632

    XSIEXPQP = 2633

    XSMADDADP = 2634

    XSMADDASP = 2635

    XSMADDMDP = 2636

    XSMADDMSP = 2637

    XSMADDQP = 2638

    XSMADDQPO = 2639

    XSMAXCDP = 2640

    XSMAXCQP = 2641

    XSMAXDP = 2642

    XSMAXJDP = 2643

    XSMINCDP = 2644

    XSMINCQP = 2645

    XSMINDP = 2646

    XSMINJDP = 2647

    XSMSUBADP = 2648

    XSMSUBASP = 2649

    XSMSUBMDP = 2650

    XSMSUBMSP = 2651

    XSMSUBQP = 2652

    XSMSUBQPO = 2653

    XSMULDP = 2654

    XSMULQP = 2655

    XSMULQPO = 2656

    XSMULSP = 2657

    XSNABSDP = 2658

    XSNABSDPs = 2659

    XSNABSQP = 2660

    XSNEGDP = 2661

    XSNEGQP = 2662

    XSNMADDADP = 2663

    XSNMADDASP = 2664

    XSNMADDMDP = 2665

    XSNMADDMSP = 2666

    XSNMADDQP = 2667

    XSNMADDQPO = 2668

    XSNMSUBADP = 2669

    XSNMSUBASP = 2670

    XSNMSUBMDP = 2671

    XSNMSUBMSP = 2672

    XSNMSUBQP = 2673

    XSNMSUBQPO = 2674

    XSRDPI = 2675

    XSRDPIC = 2676

    XSRDPIM = 2677

    XSRDPIP = 2678

    XSRDPIZ = 2679

    XSREDP = 2680

    XSRESP = 2681

    XSRQPI = 2682

    XSRQPIX = 2683

    XSRQPXP = 2684

    XSRSP = 2685

    XSRSQRTEDP = 2686

    XSRSQRTESP = 2687

    XSSQRTDP = 2688

    XSSQRTQP = 2689

    XSSQRTQPO = 2690

    XSSQRTSP = 2691

    XSSUBDP = 2692

    XSSUBQP = 2693

    XSSUBQPO = 2694

    XSSUBSP = 2695

    XSTDIVDP = 2696

    XSTSQRTDP = 2697

    XSTSTDCDP = 2698

    XSTSTDCQP = 2699

    XSTSTDCSP = 2700

    XSXEXPDP = 2701

    XSXEXPQP = 2702

    XSXSIGDP = 2703

    XSXSIGQP = 2704

    XVABSDP = 2705

    XVABSSP = 2706

    XVADDDP = 2707

    XVADDSP = 2708

    XVBF16GER2 = 2709

    XVBF16GER2NN = 2710

    XVBF16GER2NP = 2711

    XVBF16GER2PN = 2712

    XVBF16GER2PP = 2713

    XVBF16GER2W = 2714

    XVBF16GER2WNN = 2715

    XVBF16GER2WNP = 2716

    XVBF16GER2WPN = 2717

    XVBF16GER2WPP = 2718

    XVCMPEQDP = 2719

    XVCMPEQDP_rec = 2720

    XVCMPEQSP = 2721

    XVCMPEQSP_rec = 2722

    XVCMPGEDP = 2723

    XVCMPGEDP_rec = 2724

    XVCMPGESP = 2725

    XVCMPGESP_rec = 2726

    XVCMPGTDP = 2727

    XVCMPGTDP_rec = 2728

    XVCMPGTSP = 2729

    XVCMPGTSP_rec = 2730

    XVCPSGNDP = 2731

    XVCPSGNSP = 2732

    XVCVBF16SPN = 2733

    XVCVDPSP = 2734

    XVCVDPSXDS = 2735

    XVCVDPSXWS = 2736

    XVCVDPUXDS = 2737

    XVCVDPUXWS = 2738

    XVCVHPSP = 2739

    XVCVSPBF16 = 2740

    XVCVSPDP = 2741

    XVCVSPHP = 2742

    XVCVSPSXDS = 2743

    XVCVSPSXWS = 2744

    XVCVSPUXDS = 2745

    XVCVSPUXWS = 2746

    XVCVSXDDP = 2747

    XVCVSXDSP = 2748

    XVCVSXWDP = 2749

    XVCVSXWSP = 2750

    XVCVUXDDP = 2751

    XVCVUXDSP = 2752

    XVCVUXWDP = 2753

    XVCVUXWSP = 2754

    XVDIVDP = 2755

    XVDIVSP = 2756

    XVF16GER2 = 2757

    XVF16GER2NN = 2758

    XVF16GER2NP = 2759

    XVF16GER2PN = 2760

    XVF16GER2PP = 2761

    XVF16GER2W = 2762

    XVF16GER2WNN = 2763

    XVF16GER2WNP = 2764

    XVF16GER2WPN = 2765

    XVF16GER2WPP = 2766

    XVF32GER = 2767

    XVF32GERNN = 2768

    XVF32GERNP = 2769

    XVF32GERPN = 2770

    XVF32GERPP = 2771

    XVF32GERW = 2772

    XVF32GERWNN = 2773

    XVF32GERWNP = 2774

    XVF32GERWPN = 2775

    XVF32GERWPP = 2776

    XVF64GER = 2777

    XVF64GERNN = 2778

    XVF64GERNP = 2779

    XVF64GERPN = 2780

    XVF64GERPP = 2781

    XVF64GERW = 2782

    XVF64GERWNN = 2783

    XVF64GERWNP = 2784

    XVF64GERWPN = 2785

    XVF64GERWPP = 2786

    XVI16GER2 = 2787

    XVI16GER2PP = 2788

    XVI16GER2S = 2789

    XVI16GER2SPP = 2790

    XVI16GER2SW = 2791

    XVI16GER2SWPP = 2792

    XVI16GER2W = 2793

    XVI16GER2WPP = 2794

    XVI4GER8 = 2795

    XVI4GER8PP = 2796

    XVI4GER8W = 2797

    XVI4GER8WPP = 2798

    XVI8GER4 = 2799

    XVI8GER4PP = 2800

    XVI8GER4SPP = 2801

    XVI8GER4W = 2802

    XVI8GER4WPP = 2803

    XVI8GER4WSPP = 2804

    XVIEXPDP = 2805

    XVIEXPSP = 2806

    XVMADDADP = 2807

    XVMADDASP = 2808

    XVMADDMDP = 2809

    XVMADDMSP = 2810

    XVMAXDP = 2811

    XVMAXSP = 2812

    XVMINDP = 2813

    XVMINSP = 2814

    XVMSUBADP = 2815

    XVMSUBASP = 2816

    XVMSUBMDP = 2817

    XVMSUBMSP = 2818

    XVMULDP = 2819

    XVMULSP = 2820

    XVNABSDP = 2821

    XVNABSSP = 2822

    XVNEGDP = 2823

    XVNEGSP = 2824

    XVNMADDADP = 2825

    XVNMADDASP = 2826

    XVNMADDMDP = 2827

    XVNMADDMSP = 2828

    XVNMSUBADP = 2829

    XVNMSUBASP = 2830

    XVNMSUBMDP = 2831

    XVNMSUBMSP = 2832

    XVRDPI = 2833

    XVRDPIC = 2834

    XVRDPIM = 2835

    XVRDPIP = 2836

    XVRDPIZ = 2837

    XVREDP = 2838

    XVRESP = 2839

    XVRSPI = 2840

    XVRSPIC = 2841

    XVRSPIM = 2842

    XVRSPIP = 2843

    XVRSPIZ = 2844

    XVRSQRTEDP = 2845

    XVRSQRTESP = 2846

    XVSQRTDP = 2847

    XVSQRTSP = 2848

    XVSUBDP = 2849

    XVSUBSP = 2850

    XVTDIVDP = 2851

    XVTDIVSP = 2852

    XVTLSBB = 2853

    XVTSQRTDP = 2854

    XVTSQRTSP = 2855

    XVTSTDCDP = 2856

    XVTSTDCSP = 2857

    XVXEXPDP = 2858

    XVXEXPSP = 2859

    XVXSIGDP = 2860

    XVXSIGSP = 2861

    XXBLENDVB = 2862

    XXBLENDVD = 2863

    XXBLENDVH = 2864

    XXBLENDVW = 2865

    XXBRD = 2866

    XXBRH = 2867

    XXBRQ = 2868

    XXBRW = 2869

    XXEVAL = 2870

    XXEXTRACTUW = 2871

    XXGENPCVBM = 2872

    XXGENPCVDM = 2873

    XXGENPCVHM = 2874

    XXGENPCVWM = 2875

    XXINSERTW = 2876

    XXLAND = 2877

    XXLANDC = 2878

    XXLEQV = 2879

    XXLEQVOnes = 2880

    XXLNAND = 2881

    XXLNOR = 2882

    XXLOR = 2883

    XXLORC = 2884

    XXLORf = 2885

    XXLXOR = 2886

    XXLXORdpz = 2887

    XXLXORspz = 2888

    XXLXORz = 2889

    XXMFACC = 2890

    XXMFACCW = 2891

    XXMRGHW = 2892

    XXMRGLW = 2893

    XXMTACC = 2894

    XXMTACCW = 2895

    XXPERM = 2896

    XXPERMDI = 2897

    XXPERMDIs = 2898

    XXPERMR = 2899

    XXPERMX = 2900

    XXSEL = 2901

    XXSETACCZ = 2902

    XXSLDWI = 2903

    XXSLDWIs = 2904

    XXSPLTI32DX = 2905

    XXSPLTIB = 2906

    XXSPLTIDP = 2907

    XXSPLTIW = 2908

    XXSPLTW = 2909

    XXSPLTWs = 2910

    gBC = 2911

    gBCA = 2912

    gBCAat = 2913

    gBCCTR = 2914

    gBCCTRL = 2915

    gBCL = 2916

    gBCLA = 2917

    gBCLAat = 2918

    gBCLR = 2919

    gBCLRL = 2920

    gBCLat = 2921

    gBCat = 2922

    INSTRUCTION_LIST_END = 2923

class Instruction(lief.assembly.Instruction):
    @property
    def opcode(self) -> OPCODE: ...
