/*
 * 86Box    A hypervisor and IBM PC system emulator that specializes in
 *          running old operating systems and software designed for IBM
 *          PC systems and compatibles from 1981 through fairly recent
 *          system designs based on the PCI bus.
 *
 *          This file is part of the 86Box distribution.
 *
 *          Definitions for the libSDL2 rendering module.
 *
 *
 *
 * Authors: Fred N. van Kempen, <decwiz@yahoo.com>
 *          Michael Drüing, <michael@drueing.de>
 *
 *          Copyright 2018-2019 Fred N. van Kempen.
 *          Copyright 2018-2019 Michael Drüing.
 *
 *          Redistribution and  use  in source  and binary forms, with
 *          or  without modification, are permitted  provided that the
 *          following conditions are met:
 *
 *         1. Redistributions of  source  code must retain the entire
 *            above notice, this list of conditions and the following
 *            disclaimer.
 *
 *         2. Redistributions in binary form must reproduce the above
 *            copyright  notice,  this list  of  conditions  and  the
 *            following disclaimer in  the documentation and/or other
 *            materials provided with the distribution.
 *
 *         3. Neither the  name of the copyright holder nor the names
 *            of  its  contributors may be used to endorse or promote
 *            products  derived from  this  software without specific
 *            prior written permission.
 *
 * THIS SOFTWARE  IS  PROVIDED BY THE  COPYRIGHT  HOLDERS AND CONTRIBUTORS
 * "AS IS" AND  ANY EXPRESS  OR  IMPLIED  WARRANTIES,  INCLUDING, BUT  NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE  ARE  DISCLAIMED. IN  NO  EVENT  SHALL THE COPYRIGHT
 * HOLDER OR  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL  DAMAGES  (INCLUDING,  BUT  NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE  GOODS OR SERVICES;  LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON  ANY
 * THEORY OF  LIABILITY, WHETHER IN  CONTRACT, STRICT  LIABILITY, OR  TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING  IN ANY  WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef WIN_SDL_H
#define WIN_SDL_H

extern void *sdl_win_handle;
extern void  sdl_close(void);
extern int   sdl_inits();
extern int   sdl_inith();
extern int   sdl_initho();
extern int   sdl_pause(void);
extern void  sdl_resize(int w, int h);
extern void  sdl_enable(int enable);
extern void  sdl_set_fs(int fs);
extern void  sdl_reload(void);

enum sdl_main_status {
    SdlMainOk,
    SdlMainQuit,
};

extern enum sdl_main_status sdl_main();

extern void sdl_mouse_capture(int on);

#endif /*WIN_SDL_H*/
