// Copyright 2024 The Khronos Group
// SPDX-License-Identifier: Apache-2.0

// This file was generated by generate_queries.py
// Don't make changes to this directly

#include <stdint.h>
#include <math.h>
#include <anari/anari.h>
namespace hecore {
static int subtype_hash(const char *str) {
   static const uint32_t table[] = {0x66650011u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x73720018u,0x67660012u,0x62610013u,0x76750014u,0x6d6c0015u,0x75740016u,0x1000017u,0x80000000u,0x62610019u,0x6f6e001au,0x7473001bu,0x6766001cu,0x706f001du,0x7372001eu,0x6e6d001fu,0x1000020u,0x80000001u};
   uint32_t cur = 0x75640000u;
   for(int i = 0;cur!=0;++i) {
      uint32_t idx = cur&0xFFFFu;
      uint32_t low = (cur>>16u)&0xFFu;
      uint32_t high = (cur>>24u)&0xFFu;
      uint32_t c = (uint32_t)str[i];
      if(c>=low && c<high) {
         cur = table[idx+c-low];
      } else {
         break;
      }
      if(cur&0x80000000u) {
         return cur&0xFFFFu;
      }
      if(str[i]==0) {
         break;
      }
   }
   return -1;
}
static int param_hash(const char *str) {
   static const uint32_t table[] = {0x6e6d0017u,0x62610026u,0x69610030u,0x0u,0x0u,0x0u,0x7365004fu,0x0u,0x6f6e0068u,0x0u,0x0u,0x6a690070u,0x62610075u,0x6261007du,0x0u,0x0u,0x0u,0x66650081u,0x76690089u,0x73720109u,0x0u,0x706f0112u,0x706f0118u,0x63620018u,0x6a690019u,0x6665001au,0x6f6e001bu,0x7574001cu,0x5352001du,0x6261001eu,0x6564001fu,0x6a690020u,0x62610021u,0x6f6e0022u,0x64630023u,0x66650024u,0x1000025u,0x80000000u,0x64630027u,0x6c6b0028u,0x68670029u,0x7372002au,0x706f002bu,0x7675002cu,0x6f6e002du,0x6564002eu,0x100002fu,0x80000001u,0x6e6d0038u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6261003du,0x66650039u,0x7372003au,0x6261003bu,0x100003cu,0x80000002u,0x6f6e003eu,0x6f6e003fu,0x66650040u,0x6d6c0041u,0x2f2e0042u,0x65630043u,0x706f0045u,0x6665004au,0x6d6c0046u,0x706f0047u,0x73720048u,0x1000049u,0x80000003u,0x7170004bu,0x7574004cu,0x6968004du,0x100004eu,0x80000004u,0x706f005du,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x706f0064u,0x6e6d005eu,0x6665005fu,0x75740060u,0x73720061u,0x7a790062u,0x1000063u,0x80000005u,0x76750065u,0x71700066u,0x1000067u,0x80000006u,0x74730069u,0x7574006au,0x6261006bu,0x6f6e006cu,0x6463006du,0x6665006eu,0x100006fu,0x80000007u,0x68670071u,0x69680072u,0x75740073u,0x1000074u,0x80000008u,0x75740076u,0x66650077u,0x73720078u,0x6a690079u,0x6261007au,0x6d6c007bu,0x100007cu,0x80000009u,0x6e6d007eu,0x6665007fu,0x1000080u,0x8000000au,0x6f6e0082u,0x65640083u,0x66650084u,0x73720085u,0x66650086u,0x73720087u,0x1000088u,0x8000000bu,0x7b7a0096u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x62610099u,0x73720103u,0x66650097u,0x1000098u,0x8000000cu,0x7574009au,0x7675009bu,0x7473009cu,0x4443009du,0x6261009eu,0x6d6c009fu,0x6d6c00a0u,0x636200a1u,0x626100a2u,0x646300a3u,0x6c6b00a4u,0x560000a5u,0x8000000du,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x747300fbu,0x666500fcu,0x737200fdu,0x454400feu,0x626100ffu,0x75740100u,0x62610101u,0x1000102u,0x8000000eu,0x67660104u,0x62610105u,0x64630106u,0x66650107u,0x1000108u,0x8000000fu,0x6261010au,0x6f6e010bu,0x7473010cu,0x6766010du,0x706f010eu,0x7372010fu,0x6e6d0110u,0x1000111u,0x80000010u,0x6d6c0113u,0x76750114u,0x6e6d0115u,0x66650116u,0x1000117u,0x80000011u,0x73720119u,0x6d6c011au,0x6564011bu,0x100011cu,0x80000012u};
   uint32_t cur = 0x78610000u;
   for(int i = 0;cur!=0;++i) {
      uint32_t idx = cur&0xFFFFu;
      uint32_t low = (cur>>16u)&0xFFu;
      uint32_t high = (cur>>24u)&0xFFu;
      uint32_t c = (uint32_t)str[i];
      if(c>=low && c<high) {
         cur = table[idx+c-low];
      } else {
         break;
      }
      if(cur&0x80000000u) {
         return cur&0xFFFFu;
      }
      if(str[i]==0) {
         break;
      }
   }
   return -1;
}
static int info_hash(const char *str) {
   static const uint32_t table[] = {0x69680014u,0x6665001bu,0x796c0038u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6a610057u,0x0u,0x0u,0x6261006cu,0x0u,0x66650075u,0x706f007du,0x0u,0x7473008cu,0x6261008fu,0x62610015u,0x6f6e0016u,0x6f6e0017u,0x66650018u,0x6d6c0019u,0x100001au,0x8000000au,0x7466001cu,0x6261002au,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6463002fu,0x7675002bu,0x6d6c002cu,0x7574002du,0x100002eu,0x80000001u,0x73720030u,0x6a690031u,0x71700032u,0x75740033u,0x6a690034u,0x706f0035u,0x6f6e0036u,0x1000037u,0x80000004u,0x66650045u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x7574004fu,0x6e6d0046u,0x66650047u,0x6f6e0048u,0x75740049u,0x5554004au,0x7a79004bu,0x7170004cu,0x6665004du,0x100004eu,0x80000005u,0x66650050u,0x6f6e0051u,0x74730052u,0x6a690053u,0x706f0054u,0x6f6e0055u,0x1000056u,0x80000008u,0x79780060u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x6f6e0066u,0x6a690061u,0x6e6d0062u,0x76750063u,0x6e6d0064u,0x1000065u,0x80000003u,0x6a690067u,0x6e6d0068u,0x76750069u,0x6e6d006au,0x100006bu,0x80000002u,0x7372006du,0x6261006eu,0x6e6d006fu,0x66650070u,0x75740071u,0x66650072u,0x73720073u,0x1000074u,0x80000009u,0x72710076u,0x76750077u,0x6a690078u,0x73720079u,0x6665007au,0x6564007bu,0x100007cu,0x80000000u,0x7675007eu,0x7372007fu,0x64630080u,0x66650081u,0x46450082u,0x79780083u,0x75740084u,0x66650085u,0x6f6e0086u,0x74730087u,0x6a690088u,0x706f0089u,0x6f6e008au,0x100008bu,0x80000007u,0x6665008du,0x100008eu,0x8000000bu,0x6d6c0090u,0x76750091u,0x66650092u,0x1000093u,0x80000006u};
   uint32_t cur = 0x77630000u;
   for(int i = 0;cur!=0;++i) {
      uint32_t idx = cur&0xFFFFu;
      uint32_t low = (cur>>16u)&0xFFu;
      uint32_t high = (cur>>24u)&0xFFu;
      uint32_t c = (uint32_t)str[i];
      if(c>=low && c<high) {
         cur = table[idx+c-low];
      } else {
         break;
      }
      if(cur&0x80000000u) {
         return cur&0xFFFFu;
      }
      if(str[i]==0) {
         break;
      }
   }
   return -1;
}
static const int32_t anari_true = 1;
static const int32_t anari_false = 0;
const char ** query_extensions() {
   static const char *extensions[] = {
      "ANARI_KHR_INSTANCE_TRANSFORM",
      0
   };
   return extensions;
}
const char ** query_object_types(ANARIDataType type) {
   switch(type) {
      case ANARI_RENDERER:
      {
         static const char *ANARI_RENDERER_subtypes[] = {"default", 0};
         return ANARI_RENDERER_subtypes;
      }
      case ANARI_INSTANCE:
      {
         static const char *ANARI_INSTANCE_subtypes[] = {"transform", 0};
         return ANARI_INSTANCE_subtypes;
      }
      default:
      {
         static const char *none_subtypes[] = {0};
         return none_subtypes;
      }
   }
}
static const void * ANARI_DEVICE_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_DEVICE_statusCallback_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "callback used to report information to the application";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_DEVICE_statusCallbackUserData_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional pointer passed as the first argument of the status callback";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_DEVICE_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 10:
         return ANARI_DEVICE_name_info(paramType, infoName, infoType);
      case 13:
         return ANARI_DEVICE_statusCallback_info(paramType, infoName, infoType);
      case 14:
         return ANARI_DEVICE_statusCallbackUserData_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_RENDERER_default_background_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_VEC4 && infoType == ANARI_FLOAT32_VEC4) {
            static const float default_value[4] = {0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "background color and alpha (RGBA)";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_ambientRadiance_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32 && infoType == ANARI_FLOAT32) {
            static const float default_value[1] = {1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "ambient light intensity";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 1:
         return ANARI_RENDERER_default_background_info(paramType, infoName, infoType);
      case 0:
         return ANARI_RENDERER_default_ambientRadiance_info(paramType, infoName, infoType);
      case 10:
         return ANARI_RENDERER_default_name_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_ARRAY1D_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY1D_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 10:
         return ANARI_ARRAY1D_name_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_ARRAY2D_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY2D_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 10:
         return ANARI_ARRAY2D_name_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_ARRAY3D_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY3D_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 10:
         return ANARI_ARRAY3D_name_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_FRAME_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_world_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "world to be rendererd";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_renderer_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "renderer which renders the frame";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_camera_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "camera used to render the world";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_size_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "size of the frame in pixels (width, height)";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_channel_color_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "enables mapping the color channel as the type specified";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_DATA_TYPE && infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_UFIXED8_VEC4, ANARI_UFIXED8_RGBA_SRGB, ANARI_FLOAT32_VEC4, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_channel_depth_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "enables mapping the color channel as the type specified";
            return description;
         }
      case 6: // value
         if(paramType == ANARI_DATA_TYPE && infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_FLOAT32, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 10:
         return ANARI_FRAME_name_info(paramType, infoName, infoType);
      case 18:
         return ANARI_FRAME_world_info(paramType, infoName, infoType);
      case 11:
         return ANARI_FRAME_renderer_info(paramType, infoName, infoType);
      case 2:
         return ANARI_FRAME_camera_info(paramType, infoName, infoType);
      case 12:
         return ANARI_FRAME_size_info(paramType, infoName, infoType);
      case 3:
         return ANARI_FRAME_channel_color_info(paramType, infoName, infoType);
      case 4:
         return ANARI_FRAME_channel_depth_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_GROUP_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GROUP_surface_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of surface objects";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_SURFACE, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GROUP_volume_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of volume objects";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_VOLUME, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GROUP_light_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of light objects";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_LIGHT, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GROUP_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 10:
         return ANARI_GROUP_name_info(paramType, infoName, infoType);
      case 15:
         return ANARI_GROUP_surface_info(paramType, infoName, infoType);
      case 17:
         return ANARI_GROUP_volume_info(paramType, infoName, infoType);
      case 8:
         return ANARI_GROUP_light_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_WORLD_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_instance_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of instance objects in the world";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_INSTANCE, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_surface_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of non-instanced surface objects in the world";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_SURFACE, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_volume_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of non-instanced volume objects in the world";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_LIGHT, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_light_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "array of non-instanced light objects in the world";
            return description;
         }
      case 5: // elementType
         if(infoType == ANARI_DATA_TYPE_LIST) {
            static const ANARIDataType values[] = {ANARI_LIGHT, ANARI_UNKNOWN};
            return values;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 10:
         return ANARI_WORLD_name_info(paramType, infoName, infoType);
      case 7:
         return ANARI_WORLD_instance_info(paramType, infoName, infoType);
      case 15:
         return ANARI_WORLD_surface_info(paramType, infoName, infoType);
      case 17:
         return ANARI_WORLD_volume_info(paramType, infoName, infoType);
      case 8:
         return ANARI_WORLD_light_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_SURFACE_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SURFACE_geometry_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "geometry object defining the surface geometry";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SURFACE_material_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "material object defining the surface appearance";
            return description;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SURFACE_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 10:
         return ANARI_SURFACE_name_info(paramType, infoName, infoType);
      case 5:
         return ANARI_SURFACE_geometry_info(paramType, infoName, infoType);
      case 9:
         return ANARI_SURFACE_material_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_name_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "optional object name";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_INSTANCE_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 0;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_transform_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_false;
         } else {
            return nullptr;
         }
      case 1: // default
         if(paramType == ANARI_FLOAT32_MAT4 && infoType == ANARI_FLOAT32_MAT4) {
            static const float default_value[16] = {1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 1.000000f};
            return default_value;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "transform applied to objects in the instance";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_INSTANCE_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 0;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_group_info(ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   (void)paramType;
   switch(infoName) {
      case 0: // required
         if(infoType == ANARI_BOOL) {
            return &anari_true;
         } else {
            return nullptr;
         }
      case 4: // description
         {
            static const char *description = "group object being instanced";
            return description;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_INSTANCE_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int32_t value = 0;
            return &value;
         }
      default: return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_param_info(const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(param_hash(paramName)) {
      case 10:
         return ANARI_INSTANCE_transform_name_info(paramType, infoName, infoType);
      case 16:
         return ANARI_INSTANCE_transform_transform_info(paramType, infoName, infoType);
      case 6:
         return ANARI_INSTANCE_transform_group_info(paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_INSTANCE_param_info(const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 1:
         return ANARI_INSTANCE_transform_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_RENDERER_param_info(const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 0:
         return ANARI_RENDERER_default_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
const void * query_param_info_enum(ANARIDataType type, const char *subtype, const char *paramName, ANARIDataType paramType, int infoName, ANARIDataType infoType) {
   switch(type) {
      case ANARI_INSTANCE:
         return ANARI_INSTANCE_param_info(subtype, paramName, paramType, infoName, infoType);
      case ANARI_RENDERER:
         return ANARI_RENDERER_param_info(subtype, paramName, paramType, infoName, infoType);
      case ANARI_DEVICE:
         return ANARI_DEVICE_param_info(paramName, paramType, infoName, infoType);
      case ANARI_ARRAY1D:
         return ANARI_ARRAY1D_param_info(paramName, paramType, infoName, infoType);
      case ANARI_ARRAY2D:
         return ANARI_ARRAY2D_param_info(paramName, paramType, infoName, infoType);
      case ANARI_ARRAY3D:
         return ANARI_ARRAY3D_param_info(paramName, paramType, infoName, infoType);
      case ANARI_FRAME:
         return ANARI_FRAME_param_info(paramName, paramType, infoName, infoType);
      case ANARI_GROUP:
         return ANARI_GROUP_param_info(paramName, paramType, infoName, infoType);
      case ANARI_WORLD:
         return ANARI_WORLD_param_info(paramName, paramType, infoName, infoType);
      case ANARI_SURFACE:
         return ANARI_SURFACE_param_info(paramName, paramType, infoName, infoType);
      default:
         return nullptr;
   }
}
const void * query_param_info(ANARIDataType type, const char *subtype, const char *paramName, ANARIDataType paramType, const char *infoNameString, ANARIDataType infoType) {
   int infoName = info_hash(infoNameString);
   return query_param_info_enum(type, subtype, paramName, paramType, infoName, infoType);
}
static const void * ANARI_DEVICE_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "device object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"statusCallback", ANARI_STATUS_CALLBACK},
               {"statusCallbackUserData", ANARI_VOID_POINTER},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 8: // extension
         if(infoType == ANARI_STRING_LIST) {
            static const char *extensions[] = {
               "ANARI_KHR_INSTANCE_TRANSFORM",
               0
            };
            return extensions;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_RENDERER_default_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "default renderer";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"background", ANARI_FLOAT32_VEC4},
               {"ambientRadiance", ANARI_FLOAT32},
               {"name", ANARI_STRING},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 8: // extension
         if(infoType == ANARI_STRING_LIST) {
            static const char *extensions[] = {
               "ANARI_KHR_INSTANCE_TRANSFORM",
               0
            };
            return extensions;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY1D_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "one dimensional array object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY2D_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "two dimensional array object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_ARRAY3D_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "three dimensional array object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_FRAME_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "frame object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"world", ANARI_WORLD},
               {"renderer", ANARI_RENDERER},
               {"camera", ANARI_CAMERA},
               {"size", ANARI_UINT32_VEC2},
               {"channel.color", ANARI_DATA_TYPE},
               {"channel.depth", ANARI_DATA_TYPE},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 10: // channel
         if(infoType == ANARI_STRING_LIST) {
            static const char *channel[] = {
               "channel.color",
               "channel.depth",
               0
            };
            return channel;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_GROUP_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "group object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"surface", ANARI_ARRAY1D},
               {"volume", ANARI_ARRAY1D},
               {"light", ANARI_ARRAY1D},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_WORLD_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "world object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"instance", ANARI_ARRAY1D},
               {"surface", ANARI_ARRAY1D},
               {"volume", ANARI_ARRAY1D},
               {"light", ANARI_ARRAY1D},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_SURFACE_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "surface object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"geometry", ANARI_GEOMETRY},
               {"material", ANARI_MATERIAL},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_INSTANCE_transform_info(int infoName, ANARIDataType infoType) {
   switch(infoName) {
      case 4: // description
         {
            static const char *description = "instance object";
            return description;
         }
      case 9: // parameter
         if(infoType == ANARI_PARAMETER_LIST) {
            static const ANARIParameter parameters[] = {
               {"name", ANARI_STRING},
               {"transform", ANARI_FLOAT32_MAT4},
               {"group", ANARI_GROUP},
               {0, ANARI_UNKNOWN}
            };
            return parameters;
         } else {
            return nullptr;
         }
      case 7: // sourceExtension
         if(infoType == ANARI_STRING) {
            static const char *extension = "KHR_INSTANCE_TRANSFORM";
            return extension;
         } else if(infoType == ANARI_INT32) {
            static const int value = 0;
            return &value;
         } else {
            return nullptr;
         }
      default: return nullptr;
   }
}
static const void * ANARI_INSTANCE_info(const char *subtype, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 1:
         return ANARI_INSTANCE_transform_info(infoName, infoType);
      default:
         return nullptr;
   }
}
static const void * ANARI_RENDERER_info(const char *subtype, int infoName, ANARIDataType infoType) {
   switch(subtype_hash(subtype)) {
      case 0:
         return ANARI_RENDERER_default_info(infoName, infoType);
      default:
         return nullptr;
   }
}
const void * query_object_info_enum(ANARIDataType type, const char *subtype, int infoName, ANARIDataType infoType) {
   switch(type) {
      case ANARI_INSTANCE:
         return ANARI_INSTANCE_info(subtype, infoName, infoType);
      case ANARI_RENDERER:
         return ANARI_RENDERER_info(subtype, infoName, infoType);
      case ANARI_DEVICE:
         return ANARI_DEVICE_info(infoName, infoType);
      case ANARI_ARRAY1D:
         return ANARI_ARRAY1D_info(infoName, infoType);
      case ANARI_ARRAY2D:
         return ANARI_ARRAY2D_info(infoName, infoType);
      case ANARI_ARRAY3D:
         return ANARI_ARRAY3D_info(infoName, infoType);
      case ANARI_FRAME:
         return ANARI_FRAME_info(infoName, infoType);
      case ANARI_GROUP:
         return ANARI_GROUP_info(infoName, infoType);
      case ANARI_WORLD:
         return ANARI_WORLD_info(infoName, infoType);
      case ANARI_SURFACE:
         return ANARI_SURFACE_info(infoName, infoType);
      default:
         return nullptr;
   }
}
const void * query_object_info(ANARIDataType type, const char *subtype, const char *infoNameString, ANARIDataType infoType) {
   int infoName = info_hash(infoNameString);   return query_object_info_enum(type, subtype, infoName, infoType);}
}
