package main

// Code generated by ./peg/peg delocate.peg DO NOT EDIT.

import (
	"fmt"
	"io"
	"os"
	"sort"
	"strconv"
	"strings"
)

const endSymbol rune = 1114112

/* The rule types inferred from the grammar are below. */
type pegRule uint8

const (
	ruleUnknown pegRule = iota
	ruleAsmFile
	ruleStatement
	ruleGlobalDirective
	ruleDirective
	ruleDirectiveName
	ruleLocationDirective
	ruleFileDirective
	ruleLocDirective
	ruleArgs
	ruleArg
	ruleQuotedArg
	ruleQuotedText
	ruleLabelContainingDirective
	ruleLabelContainingDirectiveName
	ruleSymbolArgs
	ruleSymbolArg
	ruleSymbolExpr
	ruleSymbolAtom
	ruleSymbolOperator
	ruleOpenParen
	ruleCloseParen
	ruleSymbolType
	ruleDot
	ruleTCMarker
	ruleEscapedChar
	ruleWS
	ruleComment
	ruleLabel
	ruleSymbolName
	ruleLocalSymbol
	ruleLocalLabel
	ruleLocalLabelRef
	ruleInstruction
	ruleInstructionName
	ruleInstructionArg
	ruleGOTLocation
	ruleGOTAddress
	ruleGOTSymbolOffset
	ruleAVX512Token
	ruleTOCRefHigh
	ruleTOCRefLow
	ruleIndirectionIndicator
	ruleRegisterOrConstant
	ruleARMConstantTweak
	ruleARMRegister
	ruleARMVectorRegister
	ruleMemoryRef
	ruleSymbolRef
	ruleLow12BitsSymbolRef
	ruleARMBaseIndexScale
	ruleARMGOTLow12
	ruleARMPostincrement
	ruleBaseIndexScale
	ruleOperator
	ruleOffset
	ruleSection
	ruleSegmentRegister
)

var rul3s = [...]string{
	"Unknown",
	"AsmFile",
	"Statement",
	"GlobalDirective",
	"Directive",
	"DirectiveName",
	"LocationDirective",
	"FileDirective",
	"LocDirective",
	"Args",
	"Arg",
	"QuotedArg",
	"QuotedText",
	"LabelContainingDirective",
	"LabelContainingDirectiveName",
	"SymbolArgs",
	"SymbolArg",
	"SymbolExpr",
	"SymbolAtom",
	"SymbolOperator",
	"OpenParen",
	"CloseParen",
	"SymbolType",
	"Dot",
	"TCMarker",
	"EscapedChar",
	"WS",
	"Comment",
	"Label",
	"SymbolName",
	"LocalSymbol",
	"LocalLabel",
	"LocalLabelRef",
	"Instruction",
	"InstructionName",
	"InstructionArg",
	"GOTLocation",
	"GOTAddress",
	"GOTSymbolOffset",
	"AVX512Token",
	"TOCRefHigh",
	"TOCRefLow",
	"IndirectionIndicator",
	"RegisterOrConstant",
	"ARMConstantTweak",
	"ARMRegister",
	"ARMVectorRegister",
	"MemoryRef",
	"SymbolRef",
	"Low12BitsSymbolRef",
	"ARMBaseIndexScale",
	"ARMGOTLow12",
	"ARMPostincrement",
	"BaseIndexScale",
	"Operator",
	"Offset",
	"Section",
	"SegmentRegister",
}

type token32 struct {
	pegRule
	begin, end uint32
}

func (t *token32) String() string {
	return fmt.Sprintf("\x1B[34m%v\x1B[m %v %v", rul3s[t.pegRule], t.begin, t.end)
}

type node32 struct {
	token32
	up, next *node32
}

func (node *node32) print(w io.Writer, pretty bool, buffer string) {
	var print func(node *node32, depth int)
	print = func(node *node32, depth int) {
		for node != nil {
			for c := 0; c < depth; c++ {
				fmt.Fprintf(w, " ")
			}
			rule := rul3s[node.pegRule]
			quote := strconv.Quote(string(([]rune(buffer)[node.begin:node.end])))
			if !pretty {
				fmt.Fprintf(w, "%v %v\n", rule, quote)
			} else {
				fmt.Fprintf(w, "\x1B[36m%v\x1B[m %v\n", rule, quote)
			}
			if node.up != nil {
				print(node.up, depth+1)
			}
			node = node.next
		}
	}
	print(node, 0)
}

func (node *node32) Print(w io.Writer, buffer string) {
	node.print(w, false, buffer)
}

func (node *node32) PrettyPrint(w io.Writer, buffer string) {
	node.print(w, true, buffer)
}

type tokens32 struct {
	tree []token32
}

func (t *tokens32) Trim(length uint32) {
	t.tree = t.tree[:length]
}

func (t *tokens32) Print() {
	for _, token := range t.tree {
		fmt.Println(token.String())
	}
}

func (t *tokens32) AST() *node32 {
	type element struct {
		node *node32
		down *element
	}
	tokens := t.Tokens()
	var stack *element
	for _, token := range tokens {
		if token.begin == token.end {
			continue
		}
		node := &node32{token32: token}
		for stack != nil && stack.node.begin >= token.begin && stack.node.end <= token.end {
			stack.node.next = node.up
			node.up = stack.node
			stack = stack.down
		}
		stack = &element{node: node, down: stack}
	}
	if stack != nil {
		return stack.node
	}
	return nil
}

func (t *tokens32) PrintSyntaxTree(buffer string) {
	t.AST().Print(os.Stdout, buffer)
}

func (t *tokens32) WriteSyntaxTree(w io.Writer, buffer string) {
	t.AST().Print(w, buffer)
}

func (t *tokens32) PrettyPrintSyntaxTree(buffer string) {
	t.AST().PrettyPrint(os.Stdout, buffer)
}

func (t *tokens32) Add(rule pegRule, begin, end, index uint32) {
	tree, i := t.tree, int(index)
	if i >= len(tree) {
		t.tree = append(tree, token32{pegRule: rule, begin: begin, end: end})
		return
	}
	tree[i] = token32{pegRule: rule, begin: begin, end: end}
}

func (t *tokens32) Tokens() []token32 {
	return t.tree
}

type Asm struct {
	Buffer string
	buffer []rune
	rules  [58]func() bool
	parse  func(rule ...int) error
	reset  func()
	Pretty bool
	tokens32
}

func (p *Asm) Parse(rule ...int) error {
	return p.parse(rule...)
}

func (p *Asm) Reset() {
	p.reset()
}

type textPosition struct {
	line, symbol int
}

type textPositionMap map[int]textPosition

func translatePositions(buffer []rune, positions []int) textPositionMap {
	length, translations, j, line, symbol := len(positions), make(textPositionMap, len(positions)), 0, 1, 0
	sort.Ints(positions)

search:
	for i, c := range buffer {
		if c == '\n' {
			line, symbol = line+1, 0
		} else {
			symbol++
		}
		if i == positions[j] {
			translations[positions[j]] = textPosition{line, symbol}
			for j++; j < length; j++ {
				if i != positions[j] {
					continue search
				}
			}
			break search
		}
	}

	return translations
}

type parseError struct {
	p   *Asm
	max token32
}

func (e *parseError) Error() string {
	tokens, err := []token32{e.max}, "\n"
	positions, p := make([]int, 2*len(tokens)), 0
	for _, token := range tokens {
		positions[p], p = int(token.begin), p+1
		positions[p], p = int(token.end), p+1
	}
	translations := translatePositions(e.p.buffer, positions)
	format := "parse error near %v (line %v symbol %v - line %v symbol %v):\n%v\n"
	if e.p.Pretty {
		format = "parse error near \x1B[34m%v\x1B[m (line %v symbol %v - line %v symbol %v):\n%v\n"
	}
	for _, token := range tokens {
		begin, end := int(token.begin), int(token.end)
		err += fmt.Sprintf(format,
			rul3s[token.pegRule],
			translations[begin].line, translations[begin].symbol,
			translations[end].line, translations[end].symbol,
			strconv.Quote(string(e.p.buffer[begin:end])))
	}

	return err
}

func (p *Asm) PrintSyntaxTree() {
	if p.Pretty {
		p.tokens32.PrettyPrintSyntaxTree(p.Buffer)
	} else {
		p.tokens32.PrintSyntaxTree(p.Buffer)
	}
}

func (p *Asm) WriteSyntaxTree(w io.Writer) {
	p.tokens32.WriteSyntaxTree(w, p.Buffer)
}

func (p *Asm) SprintSyntaxTree() string {
	var bldr strings.Builder
	p.WriteSyntaxTree(&bldr)
	return bldr.String()
}

func Pretty(pretty bool) func(*Asm) error {
	return func(p *Asm) error {
		p.Pretty = pretty
		return nil
	}
}

func Size(size int) func(*Asm) error {
	return func(p *Asm) error {
		p.tokens32 = tokens32{tree: make([]token32, 0, size)}
		return nil
	}
}
func (p *Asm) Init(options ...func(*Asm) error) error {
	var (
		max                  token32
		position, tokenIndex uint32
		buffer               []rune
	)
	for _, option := range options {
		err := option(p)
		if err != nil {
			return err
		}
	}
	p.reset = func() {
		max = token32{}
		position, tokenIndex = 0, 0

		p.buffer = []rune(p.Buffer)
		if len(p.buffer) == 0 || p.buffer[len(p.buffer)-1] != endSymbol {
			p.buffer = append(p.buffer, endSymbol)
		}
		buffer = p.buffer
	}
	p.reset()

	_rules := p.rules
	tree := p.tokens32
	p.parse = func(rule ...int) error {
		r := 1
		if len(rule) > 0 {
			r = rule[0]
		}
		matches := p.rules[r]()
		p.tokens32 = tree
		if matches {
			p.Trim(tokenIndex)
			return nil
		}
		return &parseError{p, max}
	}

	add := func(rule pegRule, begin uint32) {
		tree.Add(rule, begin, position, tokenIndex)
		tokenIndex++
		if begin != position && position > max.end {
			max = token32{rule, begin, position}
		}
	}

	matchDot := func() bool {
		if buffer[position] != endSymbol {
			position++
			return true
		}
		return false
	}

	/*matchChar := func(c byte) bool {
		if buffer[position] == c {
			position++
			return true
		}
		return false
	}*/

	/*matchRange := func(lower byte, upper byte) bool {
		if c := buffer[position]; c >= lower && c <= upper {
			position++
			return true
		}
		return false
	}*/

	_rules = [...]func() bool{
		nil,
		/* 0 AsmFile <- <(Statement* !.)> */
		func() bool {
			position0, tokenIndex0 := position, tokenIndex
			{
				position1 := position
			l2:
				{
					position3, tokenIndex3 := position, tokenIndex
					if !_rules[ruleStatement]() {
						goto l3
					}
					goto l2
				l3:
					position, tokenIndex = position3, tokenIndex3
				}
				{
					position4, tokenIndex4 := position, tokenIndex
					if !matchDot() {
						goto l4
					}
					goto l0
				l4:
					position, tokenIndex = position4, tokenIndex4
				}
				add(ruleAsmFile, position1)
			}
			return true
		l0:
			position, tokenIndex = position0, tokenIndex0
			return false
		},
		/* 1 Statement <- <(WS? (Label / ((GlobalDirective / LocationDirective / LabelContainingDirective / Instruction / Directive / Comment / ) WS? ((Comment? '\n') / ';'))))> */
		func() bool {
			position5, tokenIndex5 := position, tokenIndex
			{
				position6 := position
				{
					position7, tokenIndex7 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l7
					}
					goto l8
				l7:
					position, tokenIndex = position7, tokenIndex7
				}
			l8:
				{
					position9, tokenIndex9 := position, tokenIndex
					if !_rules[ruleLabel]() {
						goto l10
					}
					goto l9
				l10:
					position, tokenIndex = position9, tokenIndex9
					{
						position11, tokenIndex11 := position, tokenIndex
						if !_rules[ruleGlobalDirective]() {
							goto l12
						}
						goto l11
					l12:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleLocationDirective]() {
							goto l13
						}
						goto l11
					l13:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleLabelContainingDirective]() {
							goto l14
						}
						goto l11
					l14:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleInstruction]() {
							goto l15
						}
						goto l11
					l15:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleDirective]() {
							goto l16
						}
						goto l11
					l16:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleComment]() {
							goto l17
						}
						goto l11
					l17:
						position, tokenIndex = position11, tokenIndex11
					}
				l11:
					{
						position18, tokenIndex18 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l18
						}
						goto l19
					l18:
						position, tokenIndex = position18, tokenIndex18
					}
				l19:
					{
						position20, tokenIndex20 := position, tokenIndex
						{
							position22, tokenIndex22 := position, tokenIndex
							if !_rules[ruleComment]() {
								goto l22
							}
							goto l23
						l22:
							position, tokenIndex = position22, tokenIndex22
						}
					l23:
						if buffer[position] != rune('\n') {
							goto l21
						}
						position++
						goto l20
					l21:
						position, tokenIndex = position20, tokenIndex20
						if buffer[position] != rune(';') {
							goto l5
						}
						position++
					}
				l20:
				}
			l9:
				add(ruleStatement, position6)
			}
			return true
		l5:
			position, tokenIndex = position5, tokenIndex5
			return false
		},
		/* 2 GlobalDirective <- <((('.' ('g' / 'G') ('l' / 'L') ('o' / 'O') ('b' / 'B') ('a' / 'A') ('l' / 'L')) / ('.' ('g' / 'G') ('l' / 'L') ('o' / 'O') ('b' / 'B') ('l' / 'L'))) WS SymbolName)> */
		func() bool {
			position24, tokenIndex24 := position, tokenIndex
			{
				position25 := position
				{
					position26, tokenIndex26 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l27
					}
					position++
					{
						position28, tokenIndex28 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l29
						}
						position++
						goto l28
					l29:
						position, tokenIndex = position28, tokenIndex28
						if buffer[position] != rune('G') {
							goto l27
						}
						position++
					}
				l28:
					{
						position30, tokenIndex30 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l31
						}
						position++
						goto l30
					l31:
						position, tokenIndex = position30, tokenIndex30
						if buffer[position] != rune('L') {
							goto l27
						}
						position++
					}
				l30:
					{
						position32, tokenIndex32 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l33
						}
						position++
						goto l32
					l33:
						position, tokenIndex = position32, tokenIndex32
						if buffer[position] != rune('O') {
							goto l27
						}
						position++
					}
				l32:
					{
						position34, tokenIndex34 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l35
						}
						position++
						goto l34
					l35:
						position, tokenIndex = position34, tokenIndex34
						if buffer[position] != rune('B') {
							goto l27
						}
						position++
					}
				l34:
					{
						position36, tokenIndex36 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l37
						}
						position++
						goto l36
					l37:
						position, tokenIndex = position36, tokenIndex36
						if buffer[position] != rune('A') {
							goto l27
						}
						position++
					}
				l36:
					{
						position38, tokenIndex38 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l39
						}
						position++
						goto l38
					l39:
						position, tokenIndex = position38, tokenIndex38
						if buffer[position] != rune('L') {
							goto l27
						}
						position++
					}
				l38:
					goto l26
				l27:
					position, tokenIndex = position26, tokenIndex26
					if buffer[position] != rune('.') {
						goto l24
					}
					position++
					{
						position40, tokenIndex40 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l41
						}
						position++
						goto l40
					l41:
						position, tokenIndex = position40, tokenIndex40
						if buffer[position] != rune('G') {
							goto l24
						}
						position++
					}
				l40:
					{
						position42, tokenIndex42 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l43
						}
						position++
						goto l42
					l43:
						position, tokenIndex = position42, tokenIndex42
						if buffer[position] != rune('L') {
							goto l24
						}
						position++
					}
				l42:
					{
						position44, tokenIndex44 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l45
						}
						position++
						goto l44
					l45:
						position, tokenIndex = position44, tokenIndex44
						if buffer[position] != rune('O') {
							goto l24
						}
						position++
					}
				l44:
					{
						position46, tokenIndex46 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l47
						}
						position++
						goto l46
					l47:
						position, tokenIndex = position46, tokenIndex46
						if buffer[position] != rune('B') {
							goto l24
						}
						position++
					}
				l46:
					{
						position48, tokenIndex48 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l49
						}
						position++
						goto l48
					l49:
						position, tokenIndex = position48, tokenIndex48
						if buffer[position] != rune('L') {
							goto l24
						}
						position++
					}
				l48:
				}
			l26:
				if !_rules[ruleWS]() {
					goto l24
				}
				if !_rules[ruleSymbolName]() {
					goto l24
				}
				add(ruleGlobalDirective, position25)
			}
			return true
		l24:
			position, tokenIndex = position24, tokenIndex24
			return false
		},
		/* 3 Directive <- <('.' DirectiveName (WS Args)?)> */
		func() bool {
			position50, tokenIndex50 := position, tokenIndex
			{
				position51 := position
				if buffer[position] != rune('.') {
					goto l50
				}
				position++
				if !_rules[ruleDirectiveName]() {
					goto l50
				}
				{
					position52, tokenIndex52 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l52
					}
					if !_rules[ruleArgs]() {
						goto l52
					}
					goto l53
				l52:
					position, tokenIndex = position52, tokenIndex52
				}
			l53:
				add(ruleDirective, position51)
			}
			return true
		l50:
			position, tokenIndex = position50, tokenIndex50
			return false
		},
		/* 4 DirectiveName <- <([a-z] / [A-Z] / ([0-9] / [0-9]) / '_')+> */
		func() bool {
			position54, tokenIndex54 := position, tokenIndex
			{
				position55 := position
				{
					position58, tokenIndex58 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l59
					}
					position++
					goto l58
				l59:
					position, tokenIndex = position58, tokenIndex58
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l60
					}
					position++
					goto l58
				l60:
					position, tokenIndex = position58, tokenIndex58
					{
						position62, tokenIndex62 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l63
						}
						position++
						goto l62
					l63:
						position, tokenIndex = position62, tokenIndex62
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l61
						}
						position++
					}
				l62:
					goto l58
				l61:
					position, tokenIndex = position58, tokenIndex58
					if buffer[position] != rune('_') {
						goto l54
					}
					position++
				}
			l58:
			l56:
				{
					position57, tokenIndex57 := position, tokenIndex
					{
						position64, tokenIndex64 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l65
						}
						position++
						goto l64
					l65:
						position, tokenIndex = position64, tokenIndex64
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l66
						}
						position++
						goto l64
					l66:
						position, tokenIndex = position64, tokenIndex64
						{
							position68, tokenIndex68 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l69
							}
							position++
							goto l68
						l69:
							position, tokenIndex = position68, tokenIndex68
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l67
							}
							position++
						}
					l68:
						goto l64
					l67:
						position, tokenIndex = position64, tokenIndex64
						if buffer[position] != rune('_') {
							goto l57
						}
						position++
					}
				l64:
					goto l56
				l57:
					position, tokenIndex = position57, tokenIndex57
				}
				add(ruleDirectiveName, position55)
			}
			return true
		l54:
			position, tokenIndex = position54, tokenIndex54
			return false
		},
		/* 5 LocationDirective <- <(FileDirective / LocDirective)> */
		func() bool {
			position70, tokenIndex70 := position, tokenIndex
			{
				position71 := position
				{
					position72, tokenIndex72 := position, tokenIndex
					if !_rules[ruleFileDirective]() {
						goto l73
					}
					goto l72
				l73:
					position, tokenIndex = position72, tokenIndex72
					if !_rules[ruleLocDirective]() {
						goto l70
					}
				}
			l72:
				add(ruleLocationDirective, position71)
			}
			return true
		l70:
			position, tokenIndex = position70, tokenIndex70
			return false
		},
		/* 6 FileDirective <- <('.' ('f' / 'F') ('i' / 'I') ('l' / 'L') ('e' / 'E') WS (!('#' / '\n') .)+)> */
		func() bool {
			position74, tokenIndex74 := position, tokenIndex
			{
				position75 := position
				if buffer[position] != rune('.') {
					goto l74
				}
				position++
				{
					position76, tokenIndex76 := position, tokenIndex
					if buffer[position] != rune('f') {
						goto l77
					}
					position++
					goto l76
				l77:
					position, tokenIndex = position76, tokenIndex76
					if buffer[position] != rune('F') {
						goto l74
					}
					position++
				}
			l76:
				{
					position78, tokenIndex78 := position, tokenIndex
					if buffer[position] != rune('i') {
						goto l79
					}
					position++
					goto l78
				l79:
					position, tokenIndex = position78, tokenIndex78
					if buffer[position] != rune('I') {
						goto l74
					}
					position++
				}
			l78:
				{
					position80, tokenIndex80 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l81
					}
					position++
					goto l80
				l81:
					position, tokenIndex = position80, tokenIndex80
					if buffer[position] != rune('L') {
						goto l74
					}
					position++
				}
			l80:
				{
					position82, tokenIndex82 := position, tokenIndex
					if buffer[position] != rune('e') {
						goto l83
					}
					position++
					goto l82
				l83:
					position, tokenIndex = position82, tokenIndex82
					if buffer[position] != rune('E') {
						goto l74
					}
					position++
				}
			l82:
				if !_rules[ruleWS]() {
					goto l74
				}
				{
					position86, tokenIndex86 := position, tokenIndex
					{
						position87, tokenIndex87 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l88
						}
						position++
						goto l87
					l88:
						position, tokenIndex = position87, tokenIndex87
						if buffer[position] != rune('\n') {
							goto l86
						}
						position++
					}
				l87:
					goto l74
				l86:
					position, tokenIndex = position86, tokenIndex86
				}
				if !matchDot() {
					goto l74
				}
			l84:
				{
					position85, tokenIndex85 := position, tokenIndex
					{
						position89, tokenIndex89 := position, tokenIndex
						{
							position90, tokenIndex90 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l91
							}
							position++
							goto l90
						l91:
							position, tokenIndex = position90, tokenIndex90
							if buffer[position] != rune('\n') {
								goto l89
							}
							position++
						}
					l90:
						goto l85
					l89:
						position, tokenIndex = position89, tokenIndex89
					}
					if !matchDot() {
						goto l85
					}
					goto l84
				l85:
					position, tokenIndex = position85, tokenIndex85
				}
				add(ruleFileDirective, position75)
			}
			return true
		l74:
			position, tokenIndex = position74, tokenIndex74
			return false
		},
		/* 7 LocDirective <- <('.' ('l' / 'L') ('o' / 'O') ('c' / 'C') WS (!('#' / '/' / '\n') .)+)> */
		func() bool {
			position92, tokenIndex92 := position, tokenIndex
			{
				position93 := position
				if buffer[position] != rune('.') {
					goto l92
				}
				position++
				{
					position94, tokenIndex94 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l95
					}
					position++
					goto l94
				l95:
					position, tokenIndex = position94, tokenIndex94
					if buffer[position] != rune('L') {
						goto l92
					}
					position++
				}
			l94:
				{
					position96, tokenIndex96 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l97
					}
					position++
					goto l96
				l97:
					position, tokenIndex = position96, tokenIndex96
					if buffer[position] != rune('O') {
						goto l92
					}
					position++
				}
			l96:
				{
					position98, tokenIndex98 := position, tokenIndex
					if buffer[position] != rune('c') {
						goto l99
					}
					position++
					goto l98
				l99:
					position, tokenIndex = position98, tokenIndex98
					if buffer[position] != rune('C') {
						goto l92
					}
					position++
				}
			l98:
				if !_rules[ruleWS]() {
					goto l92
				}
				{
					position102, tokenIndex102 := position, tokenIndex
					{
						position103, tokenIndex103 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l104
						}
						position++
						goto l103
					l104:
						position, tokenIndex = position103, tokenIndex103
						if buffer[position] != rune('/') {
							goto l105
						}
						position++
						goto l103
					l105:
						position, tokenIndex = position103, tokenIndex103
						if buffer[position] != rune('\n') {
							goto l102
						}
						position++
					}
				l103:
					goto l92
				l102:
					position, tokenIndex = position102, tokenIndex102
				}
				if !matchDot() {
					goto l92
				}
			l100:
				{
					position101, tokenIndex101 := position, tokenIndex
					{
						position106, tokenIndex106 := position, tokenIndex
						{
							position107, tokenIndex107 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l108
							}
							position++
							goto l107
						l108:
							position, tokenIndex = position107, tokenIndex107
							if buffer[position] != rune('/') {
								goto l109
							}
							position++
							goto l107
						l109:
							position, tokenIndex = position107, tokenIndex107
							if buffer[position] != rune('\n') {
								goto l106
							}
							position++
						}
					l107:
						goto l101
					l106:
						position, tokenIndex = position106, tokenIndex106
					}
					if !matchDot() {
						goto l101
					}
					goto l100
				l101:
					position, tokenIndex = position101, tokenIndex101
				}
				add(ruleLocDirective, position93)
			}
			return true
		l92:
			position, tokenIndex = position92, tokenIndex92
			return false
		},
		/* 8 Args <- <(Arg (WS? ',' WS? Arg)*)> */
		func() bool {
			position110, tokenIndex110 := position, tokenIndex
			{
				position111 := position
				if !_rules[ruleArg]() {
					goto l110
				}
			l112:
				{
					position113, tokenIndex113 := position, tokenIndex
					{
						position114, tokenIndex114 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l114
						}
						goto l115
					l114:
						position, tokenIndex = position114, tokenIndex114
					}
				l115:
					if buffer[position] != rune(',') {
						goto l113
					}
					position++
					{
						position116, tokenIndex116 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l116
						}
						goto l117
					l116:
						position, tokenIndex = position116, tokenIndex116
					}
				l117:
					if !_rules[ruleArg]() {
						goto l113
					}
					goto l112
				l113:
					position, tokenIndex = position113, tokenIndex113
				}
				add(ruleArgs, position111)
			}
			return true
		l110:
			position, tokenIndex = position110, tokenIndex110
			return false
		},
		/* 9 Arg <- <(QuotedArg / ([0-9] / [0-9] / ([a-z] / [A-Z]) / '%' / '+' / '-' / '*' / '_' / '@' / '.')*)> */
		func() bool {
			{
				position119 := position
				{
					position120, tokenIndex120 := position, tokenIndex
					if !_rules[ruleQuotedArg]() {
						goto l121
					}
					goto l120
				l121:
					position, tokenIndex = position120, tokenIndex120
				l122:
					{
						position123, tokenIndex123 := position, tokenIndex
						{
							position124, tokenIndex124 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l125
							}
							position++
							goto l124
						l125:
							position, tokenIndex = position124, tokenIndex124
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l126
							}
							position++
							goto l124
						l126:
							position, tokenIndex = position124, tokenIndex124
							{
								position128, tokenIndex128 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l129
								}
								position++
								goto l128
							l129:
								position, tokenIndex = position128, tokenIndex128
								if c := buffer[position]; c < rune('A') || c > rune('Z') {
									goto l127
								}
								position++
							}
						l128:
							goto l124
						l127:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('%') {
								goto l130
							}
							position++
							goto l124
						l130:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('+') {
								goto l131
							}
							position++
							goto l124
						l131:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('-') {
								goto l132
							}
							position++
							goto l124
						l132:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('*') {
								goto l133
							}
							position++
							goto l124
						l133:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('_') {
								goto l134
							}
							position++
							goto l124
						l134:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('@') {
								goto l135
							}
							position++
							goto l124
						l135:
							position, tokenIndex = position124, tokenIndex124
							if buffer[position] != rune('.') {
								goto l123
							}
							position++
						}
					l124:
						goto l122
					l123:
						position, tokenIndex = position123, tokenIndex123
					}
				}
			l120:
				add(ruleArg, position119)
			}
			return true
		},
		/* 10 QuotedArg <- <('"' QuotedText '"')> */
		func() bool {
			position136, tokenIndex136 := position, tokenIndex
			{
				position137 := position
				if buffer[position] != rune('"') {
					goto l136
				}
				position++
				if !_rules[ruleQuotedText]() {
					goto l136
				}
				if buffer[position] != rune('"') {
					goto l136
				}
				position++
				add(ruleQuotedArg, position137)
			}
			return true
		l136:
			position, tokenIndex = position136, tokenIndex136
			return false
		},
		/* 11 QuotedText <- <(EscapedChar / (!'"' .))*> */
		func() bool {
			{
				position139 := position
			l140:
				{
					position141, tokenIndex141 := position, tokenIndex
					{
						position142, tokenIndex142 := position, tokenIndex
						if !_rules[ruleEscapedChar]() {
							goto l143
						}
						goto l142
					l143:
						position, tokenIndex = position142, tokenIndex142
						{
							position144, tokenIndex144 := position, tokenIndex
							if buffer[position] != rune('"') {
								goto l144
							}
							position++
							goto l141
						l144:
							position, tokenIndex = position144, tokenIndex144
						}
						if !matchDot() {
							goto l141
						}
					}
				l142:
					goto l140
				l141:
					position, tokenIndex = position141, tokenIndex141
				}
				add(ruleQuotedText, position139)
			}
			return true
		},
		/* 12 LabelContainingDirective <- <(LabelContainingDirectiveName WS SymbolArgs)> */
		func() bool {
			position145, tokenIndex145 := position, tokenIndex
			{
				position146 := position
				if !_rules[ruleLabelContainingDirectiveName]() {
					goto l145
				}
				if !_rules[ruleWS]() {
					goto l145
				}
				if !_rules[ruleSymbolArgs]() {
					goto l145
				}
				add(ruleLabelContainingDirective, position146)
			}
			return true
		l145:
			position, tokenIndex = position145, tokenIndex145
			return false
		},
		/* 13 LabelContainingDirectiveName <- <(('.' ('x' / 'X') ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('h' / 'H') ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('l' / 'L') ('o' / 'O') ('n' / 'N') ('g' / 'G')) / ('.' ('s' / 'S') ('e' / 'E') ('t' / 'T')) / ('.' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' '8' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' '4' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' ('q' / 'Q') ('u' / 'U') ('a' / 'A') ('d' / 'D')) / ('.' ('t' / 'T') ('c' / 'C')) / ('.' ('l' / 'L') ('o' / 'O') ('c' / 'C') ('a' / 'A') ('l' / 'L') ('e' / 'E') ('n' / 'N') ('t' / 'T') ('r' / 'R') ('y' / 'Y')) / ('.' ('s' / 'S') ('i' / 'I') ('z' / 'Z') ('e' / 'E')) / ('.' ('t' / 'T') ('y' / 'Y') ('p' / 'P') ('e' / 'E')) / ('.' ('u' / 'U') ('l' / 'L') ('e' / 'E') ('b' / 'B') '1' '2' '8') / ('.' ('s' / 'S') ('l' / 'L') ('e' / 'E') ('b' / 'B') '1' '2' '8'))> */
		func() bool {
			position147, tokenIndex147 := position, tokenIndex
			{
				position148 := position
				{
					position149, tokenIndex149 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l150
					}
					position++
					{
						position151, tokenIndex151 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l152
						}
						position++
						goto l151
					l152:
						position, tokenIndex = position151, tokenIndex151
						if buffer[position] != rune('X') {
							goto l150
						}
						position++
					}
				l151:
					{
						position153, tokenIndex153 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l154
						}
						position++
						goto l153
					l154:
						position, tokenIndex = position153, tokenIndex153
						if buffer[position] != rune('W') {
							goto l150
						}
						position++
					}
				l153:
					{
						position155, tokenIndex155 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l156
						}
						position++
						goto l155
					l156:
						position, tokenIndex = position155, tokenIndex155
						if buffer[position] != rune('O') {
							goto l150
						}
						position++
					}
				l155:
					{
						position157, tokenIndex157 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l158
						}
						position++
						goto l157
					l158:
						position, tokenIndex = position157, tokenIndex157
						if buffer[position] != rune('R') {
							goto l150
						}
						position++
					}
				l157:
					{
						position159, tokenIndex159 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l160
						}
						position++
						goto l159
					l160:
						position, tokenIndex = position159, tokenIndex159
						if buffer[position] != rune('D') {
							goto l150
						}
						position++
					}
				l159:
					goto l149
				l150:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l161
					}
					position++
					{
						position162, tokenIndex162 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l163
						}
						position++
						goto l162
					l163:
						position, tokenIndex = position162, tokenIndex162
						if buffer[position] != rune('W') {
							goto l161
						}
						position++
					}
				l162:
					{
						position164, tokenIndex164 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l165
						}
						position++
						goto l164
					l165:
						position, tokenIndex = position164, tokenIndex164
						if buffer[position] != rune('O') {
							goto l161
						}
						position++
					}
				l164:
					{
						position166, tokenIndex166 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l167
						}
						position++
						goto l166
					l167:
						position, tokenIndex = position166, tokenIndex166
						if buffer[position] != rune('R') {
							goto l161
						}
						position++
					}
				l166:
					{
						position168, tokenIndex168 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l169
						}
						position++
						goto l168
					l169:
						position, tokenIndex = position168, tokenIndex168
						if buffer[position] != rune('D') {
							goto l161
						}
						position++
					}
				l168:
					goto l149
				l161:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l170
					}
					position++
					{
						position171, tokenIndex171 := position, tokenIndex
						if buffer[position] != rune('h') {
							goto l172
						}
						position++
						goto l171
					l172:
						position, tokenIndex = position171, tokenIndex171
						if buffer[position] != rune('H') {
							goto l170
						}
						position++
					}
				l171:
					{
						position173, tokenIndex173 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l174
						}
						position++
						goto l173
					l174:
						position, tokenIndex = position173, tokenIndex173
						if buffer[position] != rune('W') {
							goto l170
						}
						position++
					}
				l173:
					{
						position175, tokenIndex175 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l176
						}
						position++
						goto l175
					l176:
						position, tokenIndex = position175, tokenIndex175
						if buffer[position] != rune('O') {
							goto l170
						}
						position++
					}
				l175:
					{
						position177, tokenIndex177 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l178
						}
						position++
						goto l177
					l178:
						position, tokenIndex = position177, tokenIndex177
						if buffer[position] != rune('R') {
							goto l170
						}
						position++
					}
				l177:
					{
						position179, tokenIndex179 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l180
						}
						position++
						goto l179
					l180:
						position, tokenIndex = position179, tokenIndex179
						if buffer[position] != rune('D') {
							goto l170
						}
						position++
					}
				l179:
					goto l149
				l170:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l181
					}
					position++
					{
						position182, tokenIndex182 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l183
						}
						position++
						goto l182
					l183:
						position, tokenIndex = position182, tokenIndex182
						if buffer[position] != rune('L') {
							goto l181
						}
						position++
					}
				l182:
					{
						position184, tokenIndex184 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l185
						}
						position++
						goto l184
					l185:
						position, tokenIndex = position184, tokenIndex184
						if buffer[position] != rune('O') {
							goto l181
						}
						position++
					}
				l184:
					{
						position186, tokenIndex186 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l187
						}
						position++
						goto l186
					l187:
						position, tokenIndex = position186, tokenIndex186
						if buffer[position] != rune('N') {
							goto l181
						}
						position++
					}
				l186:
					{
						position188, tokenIndex188 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l189
						}
						position++
						goto l188
					l189:
						position, tokenIndex = position188, tokenIndex188
						if buffer[position] != rune('G') {
							goto l181
						}
						position++
					}
				l188:
					goto l149
				l181:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l190
					}
					position++
					{
						position191, tokenIndex191 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l192
						}
						position++
						goto l191
					l192:
						position, tokenIndex = position191, tokenIndex191
						if buffer[position] != rune('S') {
							goto l190
						}
						position++
					}
				l191:
					{
						position193, tokenIndex193 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l194
						}
						position++
						goto l193
					l194:
						position, tokenIndex = position193, tokenIndex193
						if buffer[position] != rune('E') {
							goto l190
						}
						position++
					}
				l193:
					{
						position195, tokenIndex195 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l196
						}
						position++
						goto l195
					l196:
						position, tokenIndex = position195, tokenIndex195
						if buffer[position] != rune('T') {
							goto l190
						}
						position++
					}
				l195:
					goto l149
				l190:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l197
					}
					position++
					{
						position198, tokenIndex198 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l199
						}
						position++
						goto l198
					l199:
						position, tokenIndex = position198, tokenIndex198
						if buffer[position] != rune('B') {
							goto l197
						}
						position++
					}
				l198:
					{
						position200, tokenIndex200 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l201
						}
						position++
						goto l200
					l201:
						position, tokenIndex = position200, tokenIndex200
						if buffer[position] != rune('Y') {
							goto l197
						}
						position++
					}
				l200:
					{
						position202, tokenIndex202 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l203
						}
						position++
						goto l202
					l203:
						position, tokenIndex = position202, tokenIndex202
						if buffer[position] != rune('T') {
							goto l197
						}
						position++
					}
				l202:
					{
						position204, tokenIndex204 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l205
						}
						position++
						goto l204
					l205:
						position, tokenIndex = position204, tokenIndex204
						if buffer[position] != rune('E') {
							goto l197
						}
						position++
					}
				l204:
					goto l149
				l197:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l206
					}
					position++
					if buffer[position] != rune('8') {
						goto l206
					}
					position++
					{
						position207, tokenIndex207 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l208
						}
						position++
						goto l207
					l208:
						position, tokenIndex = position207, tokenIndex207
						if buffer[position] != rune('B') {
							goto l206
						}
						position++
					}
				l207:
					{
						position209, tokenIndex209 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l210
						}
						position++
						goto l209
					l210:
						position, tokenIndex = position209, tokenIndex209
						if buffer[position] != rune('Y') {
							goto l206
						}
						position++
					}
				l209:
					{
						position211, tokenIndex211 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l212
						}
						position++
						goto l211
					l212:
						position, tokenIndex = position211, tokenIndex211
						if buffer[position] != rune('T') {
							goto l206
						}
						position++
					}
				l211:
					{
						position213, tokenIndex213 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l214
						}
						position++
						goto l213
					l214:
						position, tokenIndex = position213, tokenIndex213
						if buffer[position] != rune('E') {
							goto l206
						}
						position++
					}
				l213:
					goto l149
				l206:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l215
					}
					position++
					if buffer[position] != rune('4') {
						goto l215
					}
					position++
					{
						position216, tokenIndex216 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l217
						}
						position++
						goto l216
					l217:
						position, tokenIndex = position216, tokenIndex216
						if buffer[position] != rune('B') {
							goto l215
						}
						position++
					}
				l216:
					{
						position218, tokenIndex218 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l219
						}
						position++
						goto l218
					l219:
						position, tokenIndex = position218, tokenIndex218
						if buffer[position] != rune('Y') {
							goto l215
						}
						position++
					}
				l218:
					{
						position220, tokenIndex220 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l221
						}
						position++
						goto l220
					l221:
						position, tokenIndex = position220, tokenIndex220
						if buffer[position] != rune('T') {
							goto l215
						}
						position++
					}
				l220:
					{
						position222, tokenIndex222 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l223
						}
						position++
						goto l222
					l223:
						position, tokenIndex = position222, tokenIndex222
						if buffer[position] != rune('E') {
							goto l215
						}
						position++
					}
				l222:
					goto l149
				l215:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l224
					}
					position++
					{
						position225, tokenIndex225 := position, tokenIndex
						if buffer[position] != rune('q') {
							goto l226
						}
						position++
						goto l225
					l226:
						position, tokenIndex = position225, tokenIndex225
						if buffer[position] != rune('Q') {
							goto l224
						}
						position++
					}
				l225:
					{
						position227, tokenIndex227 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l228
						}
						position++
						goto l227
					l228:
						position, tokenIndex = position227, tokenIndex227
						if buffer[position] != rune('U') {
							goto l224
						}
						position++
					}
				l227:
					{
						position229, tokenIndex229 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l230
						}
						position++
						goto l229
					l230:
						position, tokenIndex = position229, tokenIndex229
						if buffer[position] != rune('A') {
							goto l224
						}
						position++
					}
				l229:
					{
						position231, tokenIndex231 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l232
						}
						position++
						goto l231
					l232:
						position, tokenIndex = position231, tokenIndex231
						if buffer[position] != rune('D') {
							goto l224
						}
						position++
					}
				l231:
					goto l149
				l224:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l233
					}
					position++
					{
						position234, tokenIndex234 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l235
						}
						position++
						goto l234
					l235:
						position, tokenIndex = position234, tokenIndex234
						if buffer[position] != rune('T') {
							goto l233
						}
						position++
					}
				l234:
					{
						position236, tokenIndex236 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l237
						}
						position++
						goto l236
					l237:
						position, tokenIndex = position236, tokenIndex236
						if buffer[position] != rune('C') {
							goto l233
						}
						position++
					}
				l236:
					goto l149
				l233:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l238
					}
					position++
					{
						position239, tokenIndex239 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l240
						}
						position++
						goto l239
					l240:
						position, tokenIndex = position239, tokenIndex239
						if buffer[position] != rune('L') {
							goto l238
						}
						position++
					}
				l239:
					{
						position241, tokenIndex241 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l242
						}
						position++
						goto l241
					l242:
						position, tokenIndex = position241, tokenIndex241
						if buffer[position] != rune('O') {
							goto l238
						}
						position++
					}
				l241:
					{
						position243, tokenIndex243 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l244
						}
						position++
						goto l243
					l244:
						position, tokenIndex = position243, tokenIndex243
						if buffer[position] != rune('C') {
							goto l238
						}
						position++
					}
				l243:
					{
						position245, tokenIndex245 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l246
						}
						position++
						goto l245
					l246:
						position, tokenIndex = position245, tokenIndex245
						if buffer[position] != rune('A') {
							goto l238
						}
						position++
					}
				l245:
					{
						position247, tokenIndex247 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l248
						}
						position++
						goto l247
					l248:
						position, tokenIndex = position247, tokenIndex247
						if buffer[position] != rune('L') {
							goto l238
						}
						position++
					}
				l247:
					{
						position249, tokenIndex249 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l250
						}
						position++
						goto l249
					l250:
						position, tokenIndex = position249, tokenIndex249
						if buffer[position] != rune('E') {
							goto l238
						}
						position++
					}
				l249:
					{
						position251, tokenIndex251 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l252
						}
						position++
						goto l251
					l252:
						position, tokenIndex = position251, tokenIndex251
						if buffer[position] != rune('N') {
							goto l238
						}
						position++
					}
				l251:
					{
						position253, tokenIndex253 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l254
						}
						position++
						goto l253
					l254:
						position, tokenIndex = position253, tokenIndex253
						if buffer[position] != rune('T') {
							goto l238
						}
						position++
					}
				l253:
					{
						position255, tokenIndex255 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l256
						}
						position++
						goto l255
					l256:
						position, tokenIndex = position255, tokenIndex255
						if buffer[position] != rune('R') {
							goto l238
						}
						position++
					}
				l255:
					{
						position257, tokenIndex257 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l258
						}
						position++
						goto l257
					l258:
						position, tokenIndex = position257, tokenIndex257
						if buffer[position] != rune('Y') {
							goto l238
						}
						position++
					}
				l257:
					goto l149
				l238:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l259
					}
					position++
					{
						position260, tokenIndex260 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l261
						}
						position++
						goto l260
					l261:
						position, tokenIndex = position260, tokenIndex260
						if buffer[position] != rune('S') {
							goto l259
						}
						position++
					}
				l260:
					{
						position262, tokenIndex262 := position, tokenIndex
						if buffer[position] != rune('i') {
							goto l263
						}
						position++
						goto l262
					l263:
						position, tokenIndex = position262, tokenIndex262
						if buffer[position] != rune('I') {
							goto l259
						}
						position++
					}
				l262:
					{
						position264, tokenIndex264 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l265
						}
						position++
						goto l264
					l265:
						position, tokenIndex = position264, tokenIndex264
						if buffer[position] != rune('Z') {
							goto l259
						}
						position++
					}
				l264:
					{
						position266, tokenIndex266 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l267
						}
						position++
						goto l266
					l267:
						position, tokenIndex = position266, tokenIndex266
						if buffer[position] != rune('E') {
							goto l259
						}
						position++
					}
				l266:
					goto l149
				l259:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l268
					}
					position++
					{
						position269, tokenIndex269 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l270
						}
						position++
						goto l269
					l270:
						position, tokenIndex = position269, tokenIndex269
						if buffer[position] != rune('T') {
							goto l268
						}
						position++
					}
				l269:
					{
						position271, tokenIndex271 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l272
						}
						position++
						goto l271
					l272:
						position, tokenIndex = position271, tokenIndex271
						if buffer[position] != rune('Y') {
							goto l268
						}
						position++
					}
				l271:
					{
						position273, tokenIndex273 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l274
						}
						position++
						goto l273
					l274:
						position, tokenIndex = position273, tokenIndex273
						if buffer[position] != rune('P') {
							goto l268
						}
						position++
					}
				l273:
					{
						position275, tokenIndex275 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l276
						}
						position++
						goto l275
					l276:
						position, tokenIndex = position275, tokenIndex275
						if buffer[position] != rune('E') {
							goto l268
						}
						position++
					}
				l275:
					goto l149
				l268:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l277
					}
					position++
					{
						position278, tokenIndex278 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l279
						}
						position++
						goto l278
					l279:
						position, tokenIndex = position278, tokenIndex278
						if buffer[position] != rune('U') {
							goto l277
						}
						position++
					}
				l278:
					{
						position280, tokenIndex280 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l281
						}
						position++
						goto l280
					l281:
						position, tokenIndex = position280, tokenIndex280
						if buffer[position] != rune('L') {
							goto l277
						}
						position++
					}
				l280:
					{
						position282, tokenIndex282 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l283
						}
						position++
						goto l282
					l283:
						position, tokenIndex = position282, tokenIndex282
						if buffer[position] != rune('E') {
							goto l277
						}
						position++
					}
				l282:
					{
						position284, tokenIndex284 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l285
						}
						position++
						goto l284
					l285:
						position, tokenIndex = position284, tokenIndex284
						if buffer[position] != rune('B') {
							goto l277
						}
						position++
					}
				l284:
					if buffer[position] != rune('1') {
						goto l277
					}
					position++
					if buffer[position] != rune('2') {
						goto l277
					}
					position++
					if buffer[position] != rune('8') {
						goto l277
					}
					position++
					goto l149
				l277:
					position, tokenIndex = position149, tokenIndex149
					if buffer[position] != rune('.') {
						goto l147
					}
					position++
					{
						position286, tokenIndex286 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l287
						}
						position++
						goto l286
					l287:
						position, tokenIndex = position286, tokenIndex286
						if buffer[position] != rune('S') {
							goto l147
						}
						position++
					}
				l286:
					{
						position288, tokenIndex288 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l289
						}
						position++
						goto l288
					l289:
						position, tokenIndex = position288, tokenIndex288
						if buffer[position] != rune('L') {
							goto l147
						}
						position++
					}
				l288:
					{
						position290, tokenIndex290 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l291
						}
						position++
						goto l290
					l291:
						position, tokenIndex = position290, tokenIndex290
						if buffer[position] != rune('E') {
							goto l147
						}
						position++
					}
				l290:
					{
						position292, tokenIndex292 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l293
						}
						position++
						goto l292
					l293:
						position, tokenIndex = position292, tokenIndex292
						if buffer[position] != rune('B') {
							goto l147
						}
						position++
					}
				l292:
					if buffer[position] != rune('1') {
						goto l147
					}
					position++
					if buffer[position] != rune('2') {
						goto l147
					}
					position++
					if buffer[position] != rune('8') {
						goto l147
					}
					position++
				}
			l149:
				add(ruleLabelContainingDirectiveName, position148)
			}
			return true
		l147:
			position, tokenIndex = position147, tokenIndex147
			return false
		},
		/* 14 SymbolArgs <- <(SymbolArg (WS? ',' WS? SymbolArg)*)> */
		func() bool {
			position294, tokenIndex294 := position, tokenIndex
			{
				position295 := position
				if !_rules[ruleSymbolArg]() {
					goto l294
				}
			l296:
				{
					position297, tokenIndex297 := position, tokenIndex
					{
						position298, tokenIndex298 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l298
						}
						goto l299
					l298:
						position, tokenIndex = position298, tokenIndex298
					}
				l299:
					if buffer[position] != rune(',') {
						goto l297
					}
					position++
					{
						position300, tokenIndex300 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l300
						}
						goto l301
					l300:
						position, tokenIndex = position300, tokenIndex300
					}
				l301:
					if !_rules[ruleSymbolArg]() {
						goto l297
					}
					goto l296
				l297:
					position, tokenIndex = position297, tokenIndex297
				}
				add(ruleSymbolArgs, position295)
			}
			return true
		l294:
			position, tokenIndex = position294, tokenIndex294
			return false
		},
		/* 15 SymbolArg <- <SymbolExpr> */
		func() bool {
			position302, tokenIndex302 := position, tokenIndex
			{
				position303 := position
				if !_rules[ruleSymbolExpr]() {
					goto l302
				}
				add(ruleSymbolArg, position303)
			}
			return true
		l302:
			position, tokenIndex = position302, tokenIndex302
			return false
		},
		/* 16 SymbolExpr <- <(SymbolAtom (WS? SymbolOperator WS? SymbolExpr)?)> */
		func() bool {
			position304, tokenIndex304 := position, tokenIndex
			{
				position305 := position
				if !_rules[ruleSymbolAtom]() {
					goto l304
				}
				{
					position306, tokenIndex306 := position, tokenIndex
					{
						position308, tokenIndex308 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l308
						}
						goto l309
					l308:
						position, tokenIndex = position308, tokenIndex308
					}
				l309:
					if !_rules[ruleSymbolOperator]() {
						goto l306
					}
					{
						position310, tokenIndex310 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l310
						}
						goto l311
					l310:
						position, tokenIndex = position310, tokenIndex310
					}
				l311:
					if !_rules[ruleSymbolExpr]() {
						goto l306
					}
					goto l307
				l306:
					position, tokenIndex = position306, tokenIndex306
				}
			l307:
				add(ruleSymbolExpr, position305)
			}
			return true
		l304:
			position, tokenIndex = position304, tokenIndex304
			return false
		},
		/* 17 SymbolAtom <- <(Offset / SymbolType / (LocalSymbol TCMarker?) / (SymbolName Offset) / (SymbolName TCMarker?) / Dot / (OpenParen WS? SymbolExpr WS? CloseParen))> */
		func() bool {
			position312, tokenIndex312 := position, tokenIndex
			{
				position313 := position
				{
					position314, tokenIndex314 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l315
					}
					goto l314
				l315:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleSymbolType]() {
						goto l316
					}
					goto l314
				l316:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleLocalSymbol]() {
						goto l317
					}
					{
						position318, tokenIndex318 := position, tokenIndex
						if !_rules[ruleTCMarker]() {
							goto l318
						}
						goto l319
					l318:
						position, tokenIndex = position318, tokenIndex318
					}
				l319:
					goto l314
				l317:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleSymbolName]() {
						goto l320
					}
					if !_rules[ruleOffset]() {
						goto l320
					}
					goto l314
				l320:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleSymbolName]() {
						goto l321
					}
					{
						position322, tokenIndex322 := position, tokenIndex
						if !_rules[ruleTCMarker]() {
							goto l322
						}
						goto l323
					l322:
						position, tokenIndex = position322, tokenIndex322
					}
				l323:
					goto l314
				l321:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleDot]() {
						goto l324
					}
					goto l314
				l324:
					position, tokenIndex = position314, tokenIndex314
					if !_rules[ruleOpenParen]() {
						goto l312
					}
					{
						position325, tokenIndex325 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l325
						}
						goto l326
					l325:
						position, tokenIndex = position325, tokenIndex325
					}
				l326:
					if !_rules[ruleSymbolExpr]() {
						goto l312
					}
					{
						position327, tokenIndex327 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l327
						}
						goto l328
					l327:
						position, tokenIndex = position327, tokenIndex327
					}
				l328:
					if !_rules[ruleCloseParen]() {
						goto l312
					}
				}
			l314:
				add(ruleSymbolAtom, position313)
			}
			return true
		l312:
			position, tokenIndex = position312, tokenIndex312
			return false
		},
		/* 18 SymbolOperator <- <('+' / '-' / '|' / ('<' '<') / ('>' '>'))> */
		func() bool {
			position329, tokenIndex329 := position, tokenIndex
			{
				position330 := position
				{
					position331, tokenIndex331 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l332
					}
					position++
					goto l331
				l332:
					position, tokenIndex = position331, tokenIndex331
					if buffer[position] != rune('-') {
						goto l333
					}
					position++
					goto l331
				l333:
					position, tokenIndex = position331, tokenIndex331
					if buffer[position] != rune('|') {
						goto l334
					}
					position++
					goto l331
				l334:
					position, tokenIndex = position331, tokenIndex331
					if buffer[position] != rune('<') {
						goto l335
					}
					position++
					if buffer[position] != rune('<') {
						goto l335
					}
					position++
					goto l331
				l335:
					position, tokenIndex = position331, tokenIndex331
					if buffer[position] != rune('>') {
						goto l329
					}
					position++
					if buffer[position] != rune('>') {
						goto l329
					}
					position++
				}
			l331:
				add(ruleSymbolOperator, position330)
			}
			return true
		l329:
			position, tokenIndex = position329, tokenIndex329
			return false
		},
		/* 19 OpenParen <- <'('> */
		func() bool {
			position336, tokenIndex336 := position, tokenIndex
			{
				position337 := position
				if buffer[position] != rune('(') {
					goto l336
				}
				position++
				add(ruleOpenParen, position337)
			}
			return true
		l336:
			position, tokenIndex = position336, tokenIndex336
			return false
		},
		/* 20 CloseParen <- <')'> */
		func() bool {
			position338, tokenIndex338 := position, tokenIndex
			{
				position339 := position
				if buffer[position] != rune(')') {
					goto l338
				}
				position++
				add(ruleCloseParen, position339)
			}
			return true
		l338:
			position, tokenIndex = position338, tokenIndex338
			return false
		},
		/* 21 SymbolType <- <(('@' / '%') (('f' 'u' 'n' 'c' 't' 'i' 'o' 'n') / ('o' 'b' 'j' 'e' 'c' 't')))> */
		func() bool {
			position340, tokenIndex340 := position, tokenIndex
			{
				position341 := position
				{
					position342, tokenIndex342 := position, tokenIndex
					if buffer[position] != rune('@') {
						goto l343
					}
					position++
					goto l342
				l343:
					position, tokenIndex = position342, tokenIndex342
					if buffer[position] != rune('%') {
						goto l340
					}
					position++
				}
			l342:
				{
					position344, tokenIndex344 := position, tokenIndex
					if buffer[position] != rune('f') {
						goto l345
					}
					position++
					if buffer[position] != rune('u') {
						goto l345
					}
					position++
					if buffer[position] != rune('n') {
						goto l345
					}
					position++
					if buffer[position] != rune('c') {
						goto l345
					}
					position++
					if buffer[position] != rune('t') {
						goto l345
					}
					position++
					if buffer[position] != rune('i') {
						goto l345
					}
					position++
					if buffer[position] != rune('o') {
						goto l345
					}
					position++
					if buffer[position] != rune('n') {
						goto l345
					}
					position++
					goto l344
				l345:
					position, tokenIndex = position344, tokenIndex344
					if buffer[position] != rune('o') {
						goto l340
					}
					position++
					if buffer[position] != rune('b') {
						goto l340
					}
					position++
					if buffer[position] != rune('j') {
						goto l340
					}
					position++
					if buffer[position] != rune('e') {
						goto l340
					}
					position++
					if buffer[position] != rune('c') {
						goto l340
					}
					position++
					if buffer[position] != rune('t') {
						goto l340
					}
					position++
				}
			l344:
				add(ruleSymbolType, position341)
			}
			return true
		l340:
			position, tokenIndex = position340, tokenIndex340
			return false
		},
		/* 22 Dot <- <'.'> */
		func() bool {
			position346, tokenIndex346 := position, tokenIndex
			{
				position347 := position
				if buffer[position] != rune('.') {
					goto l346
				}
				position++
				add(ruleDot, position347)
			}
			return true
		l346:
			position, tokenIndex = position346, tokenIndex346
			return false
		},
		/* 23 TCMarker <- <('[' 'T' 'C' ']')> */
		func() bool {
			position348, tokenIndex348 := position, tokenIndex
			{
				position349 := position
				if buffer[position] != rune('[') {
					goto l348
				}
				position++
				if buffer[position] != rune('T') {
					goto l348
				}
				position++
				if buffer[position] != rune('C') {
					goto l348
				}
				position++
				if buffer[position] != rune(']') {
					goto l348
				}
				position++
				add(ruleTCMarker, position349)
			}
			return true
		l348:
			position, tokenIndex = position348, tokenIndex348
			return false
		},
		/* 24 EscapedChar <- <('\\' .)> */
		func() bool {
			position350, tokenIndex350 := position, tokenIndex
			{
				position351 := position
				if buffer[position] != rune('\\') {
					goto l350
				}
				position++
				if !matchDot() {
					goto l350
				}
				add(ruleEscapedChar, position351)
			}
			return true
		l350:
			position, tokenIndex = position350, tokenIndex350
			return false
		},
		/* 25 WS <- <(' ' / '\t')+> */
		func() bool {
			position352, tokenIndex352 := position, tokenIndex
			{
				position353 := position
				{
					position356, tokenIndex356 := position, tokenIndex
					if buffer[position] != rune(' ') {
						goto l357
					}
					position++
					goto l356
				l357:
					position, tokenIndex = position356, tokenIndex356
					if buffer[position] != rune('\t') {
						goto l352
					}
					position++
				}
			l356:
			l354:
				{
					position355, tokenIndex355 := position, tokenIndex
					{
						position358, tokenIndex358 := position, tokenIndex
						if buffer[position] != rune(' ') {
							goto l359
						}
						position++
						goto l358
					l359:
						position, tokenIndex = position358, tokenIndex358
						if buffer[position] != rune('\t') {
							goto l355
						}
						position++
					}
				l358:
					goto l354
				l355:
					position, tokenIndex = position355, tokenIndex355
				}
				add(ruleWS, position353)
			}
			return true
		l352:
			position, tokenIndex = position352, tokenIndex352
			return false
		},
		/* 26 Comment <- <((('/' '/') / '#') (!'\n' .)*)> */
		func() bool {
			position360, tokenIndex360 := position, tokenIndex
			{
				position361 := position
				{
					position362, tokenIndex362 := position, tokenIndex
					if buffer[position] != rune('/') {
						goto l363
					}
					position++
					if buffer[position] != rune('/') {
						goto l363
					}
					position++
					goto l362
				l363:
					position, tokenIndex = position362, tokenIndex362
					if buffer[position] != rune('#') {
						goto l360
					}
					position++
				}
			l362:
			l364:
				{
					position365, tokenIndex365 := position, tokenIndex
					{
						position366, tokenIndex366 := position, tokenIndex
						if buffer[position] != rune('\n') {
							goto l366
						}
						position++
						goto l365
					l366:
						position, tokenIndex = position366, tokenIndex366
					}
					if !matchDot() {
						goto l365
					}
					goto l364
				l365:
					position, tokenIndex = position365, tokenIndex365
				}
				add(ruleComment, position361)
			}
			return true
		l360:
			position, tokenIndex = position360, tokenIndex360
			return false
		},
		/* 27 Label <- <((LocalSymbol / LocalLabel / SymbolName) ':')> */
		func() bool {
			position367, tokenIndex367 := position, tokenIndex
			{
				position368 := position
				{
					position369, tokenIndex369 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l370
					}
					goto l369
				l370:
					position, tokenIndex = position369, tokenIndex369
					if !_rules[ruleLocalLabel]() {
						goto l371
					}
					goto l369
				l371:
					position, tokenIndex = position369, tokenIndex369
					if !_rules[ruleSymbolName]() {
						goto l367
					}
				}
			l369:
				if buffer[position] != rune(':') {
					goto l367
				}
				position++
				add(ruleLabel, position368)
			}
			return true
		l367:
			position, tokenIndex = position367, tokenIndex367
			return false
		},
		/* 28 SymbolName <- <(([a-z] / [A-Z] / '.' / '_') ([a-z] / [A-Z] / '.' / ([0-9] / [0-9]) / '$' / '_')*)> */
		func() bool {
			position372, tokenIndex372 := position, tokenIndex
			{
				position373 := position
				{
					position374, tokenIndex374 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l375
					}
					position++
					goto l374
				l375:
					position, tokenIndex = position374, tokenIndex374
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l376
					}
					position++
					goto l374
				l376:
					position, tokenIndex = position374, tokenIndex374
					if buffer[position] != rune('.') {
						goto l377
					}
					position++
					goto l374
				l377:
					position, tokenIndex = position374, tokenIndex374
					if buffer[position] != rune('_') {
						goto l372
					}
					position++
				}
			l374:
			l378:
				{
					position379, tokenIndex379 := position, tokenIndex
					{
						position380, tokenIndex380 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l381
						}
						position++
						goto l380
					l381:
						position, tokenIndex = position380, tokenIndex380
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l382
						}
						position++
						goto l380
					l382:
						position, tokenIndex = position380, tokenIndex380
						if buffer[position] != rune('.') {
							goto l383
						}
						position++
						goto l380
					l383:
						position, tokenIndex = position380, tokenIndex380
						{
							position385, tokenIndex385 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l386
							}
							position++
							goto l385
						l386:
							position, tokenIndex = position385, tokenIndex385
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l384
							}
							position++
						}
					l385:
						goto l380
					l384:
						position, tokenIndex = position380, tokenIndex380
						if buffer[position] != rune('$') {
							goto l387
						}
						position++
						goto l380
					l387:
						position, tokenIndex = position380, tokenIndex380
						if buffer[position] != rune('_') {
							goto l379
						}
						position++
					}
				l380:
					goto l378
				l379:
					position, tokenIndex = position379, tokenIndex379
				}
				add(ruleSymbolName, position373)
			}
			return true
		l372:
			position, tokenIndex = position372, tokenIndex372
			return false
		},
		/* 29 LocalSymbol <- <('.' 'L' ([a-z] / [A-Z] / ([a-z] / [A-Z]) / '.' / ([0-9] / [0-9]) / '$' / '_')+)> */
		func() bool {
			position388, tokenIndex388 := position, tokenIndex
			{
				position389 := position
				if buffer[position] != rune('.') {
					goto l388
				}
				position++
				if buffer[position] != rune('L') {
					goto l388
				}
				position++
				{
					position392, tokenIndex392 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l393
					}
					position++
					goto l392
				l393:
					position, tokenIndex = position392, tokenIndex392
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l394
					}
					position++
					goto l392
				l394:
					position, tokenIndex = position392, tokenIndex392
					{
						position396, tokenIndex396 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l397
						}
						position++
						goto l396
					l397:
						position, tokenIndex = position396, tokenIndex396
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l395
						}
						position++
					}
				l396:
					goto l392
				l395:
					position, tokenIndex = position392, tokenIndex392
					if buffer[position] != rune('.') {
						goto l398
					}
					position++
					goto l392
				l398:
					position, tokenIndex = position392, tokenIndex392
					{
						position400, tokenIndex400 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l401
						}
						position++
						goto l400
					l401:
						position, tokenIndex = position400, tokenIndex400
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l399
						}
						position++
					}
				l400:
					goto l392
				l399:
					position, tokenIndex = position392, tokenIndex392
					if buffer[position] != rune('$') {
						goto l402
					}
					position++
					goto l392
				l402:
					position, tokenIndex = position392, tokenIndex392
					if buffer[position] != rune('_') {
						goto l388
					}
					position++
				}
			l392:
			l390:
				{
					position391, tokenIndex391 := position, tokenIndex
					{
						position403, tokenIndex403 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l404
						}
						position++
						goto l403
					l404:
						position, tokenIndex = position403, tokenIndex403
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l405
						}
						position++
						goto l403
					l405:
						position, tokenIndex = position403, tokenIndex403
						{
							position407, tokenIndex407 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l408
							}
							position++
							goto l407
						l408:
							position, tokenIndex = position407, tokenIndex407
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l406
							}
							position++
						}
					l407:
						goto l403
					l406:
						position, tokenIndex = position403, tokenIndex403
						if buffer[position] != rune('.') {
							goto l409
						}
						position++
						goto l403
					l409:
						position, tokenIndex = position403, tokenIndex403
						{
							position411, tokenIndex411 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l412
							}
							position++
							goto l411
						l412:
							position, tokenIndex = position411, tokenIndex411
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l410
							}
							position++
						}
					l411:
						goto l403
					l410:
						position, tokenIndex = position403, tokenIndex403
						if buffer[position] != rune('$') {
							goto l413
						}
						position++
						goto l403
					l413:
						position, tokenIndex = position403, tokenIndex403
						if buffer[position] != rune('_') {
							goto l391
						}
						position++
					}
				l403:
					goto l390
				l391:
					position, tokenIndex = position391, tokenIndex391
				}
				add(ruleLocalSymbol, position389)
			}
			return true
		l388:
			position, tokenIndex = position388, tokenIndex388
			return false
		},
		/* 30 LocalLabel <- <([0-9] ([0-9] / '$')*)> */
		func() bool {
			position414, tokenIndex414 := position, tokenIndex
			{
				position415 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l414
				}
				position++
			l416:
				{
					position417, tokenIndex417 := position, tokenIndex
					{
						position418, tokenIndex418 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l419
						}
						position++
						goto l418
					l419:
						position, tokenIndex = position418, tokenIndex418
						if buffer[position] != rune('$') {
							goto l417
						}
						position++
					}
				l418:
					goto l416
				l417:
					position, tokenIndex = position417, tokenIndex417
				}
				add(ruleLocalLabel, position415)
			}
			return true
		l414:
			position, tokenIndex = position414, tokenIndex414
			return false
		},
		/* 31 LocalLabelRef <- <([0-9] ([0-9] / '$')* ('b' / 'f'))> */
		func() bool {
			position420, tokenIndex420 := position, tokenIndex
			{
				position421 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l420
				}
				position++
			l422:
				{
					position423, tokenIndex423 := position, tokenIndex
					{
						position424, tokenIndex424 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l425
						}
						position++
						goto l424
					l425:
						position, tokenIndex = position424, tokenIndex424
						if buffer[position] != rune('$') {
							goto l423
						}
						position++
					}
				l424:
					goto l422
				l423:
					position, tokenIndex = position423, tokenIndex423
				}
				{
					position426, tokenIndex426 := position, tokenIndex
					if buffer[position] != rune('b') {
						goto l427
					}
					position++
					goto l426
				l427:
					position, tokenIndex = position426, tokenIndex426
					if buffer[position] != rune('f') {
						goto l420
					}
					position++
				}
			l426:
				add(ruleLocalLabelRef, position421)
			}
			return true
		l420:
			position, tokenIndex = position420, tokenIndex420
			return false
		},
		/* 32 Instruction <- <(InstructionName (WS InstructionArg (WS? ',' WS? InstructionArg)*)?)> */
		func() bool {
			position428, tokenIndex428 := position, tokenIndex
			{
				position429 := position
				if !_rules[ruleInstructionName]() {
					goto l428
				}
				{
					position430, tokenIndex430 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l430
					}
					if !_rules[ruleInstructionArg]() {
						goto l430
					}
				l432:
					{
						position433, tokenIndex433 := position, tokenIndex
						{
							position434, tokenIndex434 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l434
							}
							goto l435
						l434:
							position, tokenIndex = position434, tokenIndex434
						}
					l435:
						if buffer[position] != rune(',') {
							goto l433
						}
						position++
						{
							position436, tokenIndex436 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l436
							}
							goto l437
						l436:
							position, tokenIndex = position436, tokenIndex436
						}
					l437:
						if !_rules[ruleInstructionArg]() {
							goto l433
						}
						goto l432
					l433:
						position, tokenIndex = position433, tokenIndex433
					}
					goto l431
				l430:
					position, tokenIndex = position430, tokenIndex430
				}
			l431:
				add(ruleInstruction, position429)
			}
			return true
		l428:
			position, tokenIndex = position428, tokenIndex428
			return false
		},
		/* 33 InstructionName <- <(([a-z] / [A-Z]) ([a-z] / [A-Z] / '.' / ([0-9] / [0-9]))* ('.' / '+' / '-')?)> */
		func() bool {
			position438, tokenIndex438 := position, tokenIndex
			{
				position439 := position
				{
					position440, tokenIndex440 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l441
					}
					position++
					goto l440
				l441:
					position, tokenIndex = position440, tokenIndex440
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l438
					}
					position++
				}
			l440:
			l442:
				{
					position443, tokenIndex443 := position, tokenIndex
					{
						position444, tokenIndex444 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l445
						}
						position++
						goto l444
					l445:
						position, tokenIndex = position444, tokenIndex444
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l446
						}
						position++
						goto l444
					l446:
						position, tokenIndex = position444, tokenIndex444
						if buffer[position] != rune('.') {
							goto l447
						}
						position++
						goto l444
					l447:
						position, tokenIndex = position444, tokenIndex444
						{
							position448, tokenIndex448 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l449
							}
							position++
							goto l448
						l449:
							position, tokenIndex = position448, tokenIndex448
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l443
							}
							position++
						}
					l448:
					}
				l444:
					goto l442
				l443:
					position, tokenIndex = position443, tokenIndex443
				}
				{
					position450, tokenIndex450 := position, tokenIndex
					{
						position452, tokenIndex452 := position, tokenIndex
						if buffer[position] != rune('.') {
							goto l453
						}
						position++
						goto l452
					l453:
						position, tokenIndex = position452, tokenIndex452
						if buffer[position] != rune('+') {
							goto l454
						}
						position++
						goto l452
					l454:
						position, tokenIndex = position452, tokenIndex452
						if buffer[position] != rune('-') {
							goto l450
						}
						position++
					}
				l452:
					goto l451
				l450:
					position, tokenIndex = position450, tokenIndex450
				}
			l451:
				add(ruleInstructionName, position439)
			}
			return true
		l438:
			position, tokenIndex = position438, tokenIndex438
			return false
		},
		/* 34 InstructionArg <- <(IndirectionIndicator? (ARMConstantTweak / RegisterOrConstant / LocalLabelRef / TOCRefHigh / TOCRefLow / GOTLocation / GOTAddress / GOTSymbolOffset / MemoryRef) AVX512Token*)> */
		func() bool {
			position455, tokenIndex455 := position, tokenIndex
			{
				position456 := position
				{
					position457, tokenIndex457 := position, tokenIndex
					if !_rules[ruleIndirectionIndicator]() {
						goto l457
					}
					goto l458
				l457:
					position, tokenIndex = position457, tokenIndex457
				}
			l458:
				{
					position459, tokenIndex459 := position, tokenIndex
					if !_rules[ruleARMConstantTweak]() {
						goto l460
					}
					goto l459
				l460:
					position, tokenIndex = position459, tokenIndex459
					if !_rules[ruleRegisterOrConstant]() {
						goto l461
					}
					goto l459
				l461:
					position, tokenIndex = position459, tokenIndex459
					if !_rules[ruleLocalLabelRef]() {
						goto l462
					}
					goto l459
				l462:
					position, tokenIndex = position459, tokenIndex459
					if !_rules[ruleTOCRefHigh]() {
						goto l463
					}
					goto l459
				l463:
					position, tokenIndex = position459, tokenIndex459
					if !_rules[ruleTOCRefLow]() {
						goto l464
					}
					goto l459
				l464:
					position, tokenIndex = position459, tokenIndex459
					if !_rules[ruleGOTLocation]() {
						goto l465
					}
					goto l459
				l465:
					position, tokenIndex = position459, tokenIndex459
					if !_rules[ruleGOTAddress]() {
						goto l466
					}
					goto l459
				l466:
					position, tokenIndex = position459, tokenIndex459
					if !_rules[ruleGOTSymbolOffset]() {
						goto l467
					}
					goto l459
				l467:
					position, tokenIndex = position459, tokenIndex459
					if !_rules[ruleMemoryRef]() {
						goto l455
					}
				}
			l459:
			l468:
				{
					position469, tokenIndex469 := position, tokenIndex
					if !_rules[ruleAVX512Token]() {
						goto l469
					}
					goto l468
				l469:
					position, tokenIndex = position469, tokenIndex469
				}
				add(ruleInstructionArg, position456)
			}
			return true
		l455:
			position, tokenIndex = position455, tokenIndex455
			return false
		},
		/* 35 GOTLocation <- <('$' '_' 'G' 'L' 'O' 'B' 'A' 'L' '_' 'O' 'F' 'F' 'S' 'E' 'T' '_' 'T' 'A' 'B' 'L' 'E' '_' '-' LocalSymbol)> */
		func() bool {
			position470, tokenIndex470 := position, tokenIndex
			{
				position471 := position
				if buffer[position] != rune('$') {
					goto l470
				}
				position++
				if buffer[position] != rune('_') {
					goto l470
				}
				position++
				if buffer[position] != rune('G') {
					goto l470
				}
				position++
				if buffer[position] != rune('L') {
					goto l470
				}
				position++
				if buffer[position] != rune('O') {
					goto l470
				}
				position++
				if buffer[position] != rune('B') {
					goto l470
				}
				position++
				if buffer[position] != rune('A') {
					goto l470
				}
				position++
				if buffer[position] != rune('L') {
					goto l470
				}
				position++
				if buffer[position] != rune('_') {
					goto l470
				}
				position++
				if buffer[position] != rune('O') {
					goto l470
				}
				position++
				if buffer[position] != rune('F') {
					goto l470
				}
				position++
				if buffer[position] != rune('F') {
					goto l470
				}
				position++
				if buffer[position] != rune('S') {
					goto l470
				}
				position++
				if buffer[position] != rune('E') {
					goto l470
				}
				position++
				if buffer[position] != rune('T') {
					goto l470
				}
				position++
				if buffer[position] != rune('_') {
					goto l470
				}
				position++
				if buffer[position] != rune('T') {
					goto l470
				}
				position++
				if buffer[position] != rune('A') {
					goto l470
				}
				position++
				if buffer[position] != rune('B') {
					goto l470
				}
				position++
				if buffer[position] != rune('L') {
					goto l470
				}
				position++
				if buffer[position] != rune('E') {
					goto l470
				}
				position++
				if buffer[position] != rune('_') {
					goto l470
				}
				position++
				if buffer[position] != rune('-') {
					goto l470
				}
				position++
				if !_rules[ruleLocalSymbol]() {
					goto l470
				}
				add(ruleGOTLocation, position471)
			}
			return true
		l470:
			position, tokenIndex = position470, tokenIndex470
			return false
		},
		/* 36 GOTAddress <- <('_' 'G' 'L' 'O' 'B' 'A' 'L' '_' 'O' 'F' 'F' 'S' 'E' 'T' '_' 'T' 'A' 'B' 'L' 'E' '_' '(' '%' 'r' 'i' 'p' ')')> */
		func() bool {
			position472, tokenIndex472 := position, tokenIndex
			{
				position473 := position
				if buffer[position] != rune('_') {
					goto l472
				}
				position++
				if buffer[position] != rune('G') {
					goto l472
				}
				position++
				if buffer[position] != rune('L') {
					goto l472
				}
				position++
				if buffer[position] != rune('O') {
					goto l472
				}
				position++
				if buffer[position] != rune('B') {
					goto l472
				}
				position++
				if buffer[position] != rune('A') {
					goto l472
				}
				position++
				if buffer[position] != rune('L') {
					goto l472
				}
				position++
				if buffer[position] != rune('_') {
					goto l472
				}
				position++
				if buffer[position] != rune('O') {
					goto l472
				}
				position++
				if buffer[position] != rune('F') {
					goto l472
				}
				position++
				if buffer[position] != rune('F') {
					goto l472
				}
				position++
				if buffer[position] != rune('S') {
					goto l472
				}
				position++
				if buffer[position] != rune('E') {
					goto l472
				}
				position++
				if buffer[position] != rune('T') {
					goto l472
				}
				position++
				if buffer[position] != rune('_') {
					goto l472
				}
				position++
				if buffer[position] != rune('T') {
					goto l472
				}
				position++
				if buffer[position] != rune('A') {
					goto l472
				}
				position++
				if buffer[position] != rune('B') {
					goto l472
				}
				position++
				if buffer[position] != rune('L') {
					goto l472
				}
				position++
				if buffer[position] != rune('E') {
					goto l472
				}
				position++
				if buffer[position] != rune('_') {
					goto l472
				}
				position++
				if buffer[position] != rune('(') {
					goto l472
				}
				position++
				if buffer[position] != rune('%') {
					goto l472
				}
				position++
				if buffer[position] != rune('r') {
					goto l472
				}
				position++
				if buffer[position] != rune('i') {
					goto l472
				}
				position++
				if buffer[position] != rune('p') {
					goto l472
				}
				position++
				if buffer[position] != rune(')') {
					goto l472
				}
				position++
				add(ruleGOTAddress, position473)
			}
			return true
		l472:
			position, tokenIndex = position472, tokenIndex472
			return false
		},
		/* 37 GOTSymbolOffset <- <(('$' SymbolName ('@' 'G' 'O' 'T') ('O' 'F' 'F')?) / (':' ('g' / 'G') ('o' / 'O') ('t' / 'T') ':' SymbolName))> */
		func() bool {
			position474, tokenIndex474 := position, tokenIndex
			{
				position475 := position
				{
					position476, tokenIndex476 := position, tokenIndex
					if buffer[position] != rune('$') {
						goto l477
					}
					position++
					if !_rules[ruleSymbolName]() {
						goto l477
					}
					if buffer[position] != rune('@') {
						goto l477
					}
					position++
					if buffer[position] != rune('G') {
						goto l477
					}
					position++
					if buffer[position] != rune('O') {
						goto l477
					}
					position++
					if buffer[position] != rune('T') {
						goto l477
					}
					position++
					{
						position478, tokenIndex478 := position, tokenIndex
						if buffer[position] != rune('O') {
							goto l478
						}
						position++
						if buffer[position] != rune('F') {
							goto l478
						}
						position++
						if buffer[position] != rune('F') {
							goto l478
						}
						position++
						goto l479
					l478:
						position, tokenIndex = position478, tokenIndex478
					}
				l479:
					goto l476
				l477:
					position, tokenIndex = position476, tokenIndex476
					if buffer[position] != rune(':') {
						goto l474
					}
					position++
					{
						position480, tokenIndex480 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l481
						}
						position++
						goto l480
					l481:
						position, tokenIndex = position480, tokenIndex480
						if buffer[position] != rune('G') {
							goto l474
						}
						position++
					}
				l480:
					{
						position482, tokenIndex482 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l483
						}
						position++
						goto l482
					l483:
						position, tokenIndex = position482, tokenIndex482
						if buffer[position] != rune('O') {
							goto l474
						}
						position++
					}
				l482:
					{
						position484, tokenIndex484 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l485
						}
						position++
						goto l484
					l485:
						position, tokenIndex = position484, tokenIndex484
						if buffer[position] != rune('T') {
							goto l474
						}
						position++
					}
				l484:
					if buffer[position] != rune(':') {
						goto l474
					}
					position++
					if !_rules[ruleSymbolName]() {
						goto l474
					}
				}
			l476:
				add(ruleGOTSymbolOffset, position475)
			}
			return true
		l474:
			position, tokenIndex = position474, tokenIndex474
			return false
		},
		/* 38 AVX512Token <- <(WS? '{' '%'? ([0-9] / [a-z])* '}')> */
		func() bool {
			position486, tokenIndex486 := position, tokenIndex
			{
				position487 := position
				{
					position488, tokenIndex488 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l488
					}
					goto l489
				l488:
					position, tokenIndex = position488, tokenIndex488
				}
			l489:
				if buffer[position] != rune('{') {
					goto l486
				}
				position++
				{
					position490, tokenIndex490 := position, tokenIndex
					if buffer[position] != rune('%') {
						goto l490
					}
					position++
					goto l491
				l490:
					position, tokenIndex = position490, tokenIndex490
				}
			l491:
			l492:
				{
					position493, tokenIndex493 := position, tokenIndex
					{
						position494, tokenIndex494 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l495
						}
						position++
						goto l494
					l495:
						position, tokenIndex = position494, tokenIndex494
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l493
						}
						position++
					}
				l494:
					goto l492
				l493:
					position, tokenIndex = position493, tokenIndex493
				}
				if buffer[position] != rune('}') {
					goto l486
				}
				position++
				add(ruleAVX512Token, position487)
			}
			return true
		l486:
			position, tokenIndex = position486, tokenIndex486
			return false
		},
		/* 39 TOCRefHigh <- <('.' 'T' 'O' 'C' '.' '-' (('0' 'b') / ('.' 'L' ([a-z] / [A-Z] / '_' / [0-9])+)) ('@' ('h' / 'H') ('a' / 'A')))> */
		func() bool {
			position496, tokenIndex496 := position, tokenIndex
			{
				position497 := position
				if buffer[position] != rune('.') {
					goto l496
				}
				position++
				if buffer[position] != rune('T') {
					goto l496
				}
				position++
				if buffer[position] != rune('O') {
					goto l496
				}
				position++
				if buffer[position] != rune('C') {
					goto l496
				}
				position++
				if buffer[position] != rune('.') {
					goto l496
				}
				position++
				if buffer[position] != rune('-') {
					goto l496
				}
				position++
				{
					position498, tokenIndex498 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l499
					}
					position++
					if buffer[position] != rune('b') {
						goto l499
					}
					position++
					goto l498
				l499:
					position, tokenIndex = position498, tokenIndex498
					if buffer[position] != rune('.') {
						goto l496
					}
					position++
					if buffer[position] != rune('L') {
						goto l496
					}
					position++
					{
						position502, tokenIndex502 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l503
						}
						position++
						goto l502
					l503:
						position, tokenIndex = position502, tokenIndex502
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l504
						}
						position++
						goto l502
					l504:
						position, tokenIndex = position502, tokenIndex502
						if buffer[position] != rune('_') {
							goto l505
						}
						position++
						goto l502
					l505:
						position, tokenIndex = position502, tokenIndex502
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l496
						}
						position++
					}
				l502:
				l500:
					{
						position501, tokenIndex501 := position, tokenIndex
						{
							position506, tokenIndex506 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l507
							}
							position++
							goto l506
						l507:
							position, tokenIndex = position506, tokenIndex506
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l508
							}
							position++
							goto l506
						l508:
							position, tokenIndex = position506, tokenIndex506
							if buffer[position] != rune('_') {
								goto l509
							}
							position++
							goto l506
						l509:
							position, tokenIndex = position506, tokenIndex506
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l501
							}
							position++
						}
					l506:
						goto l500
					l501:
						position, tokenIndex = position501, tokenIndex501
					}
				}
			l498:
				if buffer[position] != rune('@') {
					goto l496
				}
				position++
				{
					position510, tokenIndex510 := position, tokenIndex
					if buffer[position] != rune('h') {
						goto l511
					}
					position++
					goto l510
				l511:
					position, tokenIndex = position510, tokenIndex510
					if buffer[position] != rune('H') {
						goto l496
					}
					position++
				}
			l510:
				{
					position512, tokenIndex512 := position, tokenIndex
					if buffer[position] != rune('a') {
						goto l513
					}
					position++
					goto l512
				l513:
					position, tokenIndex = position512, tokenIndex512
					if buffer[position] != rune('A') {
						goto l496
					}
					position++
				}
			l512:
				add(ruleTOCRefHigh, position497)
			}
			return true
		l496:
			position, tokenIndex = position496, tokenIndex496
			return false
		},
		/* 40 TOCRefLow <- <('.' 'T' 'O' 'C' '.' '-' (('0' 'b') / ('.' 'L' ([a-z] / [A-Z] / '_' / [0-9])+)) ('@' ('l' / 'L')))> */
		func() bool {
			position514, tokenIndex514 := position, tokenIndex
			{
				position515 := position
				if buffer[position] != rune('.') {
					goto l514
				}
				position++
				if buffer[position] != rune('T') {
					goto l514
				}
				position++
				if buffer[position] != rune('O') {
					goto l514
				}
				position++
				if buffer[position] != rune('C') {
					goto l514
				}
				position++
				if buffer[position] != rune('.') {
					goto l514
				}
				position++
				if buffer[position] != rune('-') {
					goto l514
				}
				position++
				{
					position516, tokenIndex516 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l517
					}
					position++
					if buffer[position] != rune('b') {
						goto l517
					}
					position++
					goto l516
				l517:
					position, tokenIndex = position516, tokenIndex516
					if buffer[position] != rune('.') {
						goto l514
					}
					position++
					if buffer[position] != rune('L') {
						goto l514
					}
					position++
					{
						position520, tokenIndex520 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l521
						}
						position++
						goto l520
					l521:
						position, tokenIndex = position520, tokenIndex520
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l522
						}
						position++
						goto l520
					l522:
						position, tokenIndex = position520, tokenIndex520
						if buffer[position] != rune('_') {
							goto l523
						}
						position++
						goto l520
					l523:
						position, tokenIndex = position520, tokenIndex520
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l514
						}
						position++
					}
				l520:
				l518:
					{
						position519, tokenIndex519 := position, tokenIndex
						{
							position524, tokenIndex524 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l525
							}
							position++
							goto l524
						l525:
							position, tokenIndex = position524, tokenIndex524
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l526
							}
							position++
							goto l524
						l526:
							position, tokenIndex = position524, tokenIndex524
							if buffer[position] != rune('_') {
								goto l527
							}
							position++
							goto l524
						l527:
							position, tokenIndex = position524, tokenIndex524
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l519
							}
							position++
						}
					l524:
						goto l518
					l519:
						position, tokenIndex = position519, tokenIndex519
					}
				}
			l516:
				if buffer[position] != rune('@') {
					goto l514
				}
				position++
				{
					position528, tokenIndex528 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l529
					}
					position++
					goto l528
				l529:
					position, tokenIndex = position528, tokenIndex528
					if buffer[position] != rune('L') {
						goto l514
					}
					position++
				}
			l528:
				add(ruleTOCRefLow, position515)
			}
			return true
		l514:
			position, tokenIndex = position514, tokenIndex514
			return false
		},
		/* 41 IndirectionIndicator <- <'*'> */
		func() bool {
			position530, tokenIndex530 := position, tokenIndex
			{
				position531 := position
				if buffer[position] != rune('*') {
					goto l530
				}
				position++
				add(ruleIndirectionIndicator, position531)
			}
			return true
		l530:
			position, tokenIndex = position530, tokenIndex530
			return false
		},
		/* 42 RegisterOrConstant <- <((('%' ([a-z] / [A-Z]) ([a-z] / [A-Z] / ([0-9] / [0-9]))*) / ('$'? ((Offset Offset) / Offset)) / ('#' Offset ('*' [0-9]+ ('-' [0-9] [0-9]*)?)?) / ('#' '~'? '(' [0-9] WS? ('<' '<') WS? [0-9] ')') / ARMRegister) !('f' / 'b' / ':' / '(' / '+' / '-'))> */
		func() bool {
			position532, tokenIndex532 := position, tokenIndex
			{
				position533 := position
				{
					position534, tokenIndex534 := position, tokenIndex
					if buffer[position] != rune('%') {
						goto l535
					}
					position++
					{
						position536, tokenIndex536 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l537
						}
						position++
						goto l536
					l537:
						position, tokenIndex = position536, tokenIndex536
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l535
						}
						position++
					}
				l536:
				l538:
					{
						position539, tokenIndex539 := position, tokenIndex
						{
							position540, tokenIndex540 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l541
							}
							position++
							goto l540
						l541:
							position, tokenIndex = position540, tokenIndex540
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l542
							}
							position++
							goto l540
						l542:
							position, tokenIndex = position540, tokenIndex540
							{
								position543, tokenIndex543 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l544
								}
								position++
								goto l543
							l544:
								position, tokenIndex = position543, tokenIndex543
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l539
								}
								position++
							}
						l543:
						}
					l540:
						goto l538
					l539:
						position, tokenIndex = position539, tokenIndex539
					}
					goto l534
				l535:
					position, tokenIndex = position534, tokenIndex534
					{
						position546, tokenIndex546 := position, tokenIndex
						if buffer[position] != rune('$') {
							goto l546
						}
						position++
						goto l547
					l546:
						position, tokenIndex = position546, tokenIndex546
					}
				l547:
					{
						position548, tokenIndex548 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l549
						}
						if !_rules[ruleOffset]() {
							goto l549
						}
						goto l548
					l549:
						position, tokenIndex = position548, tokenIndex548
						if !_rules[ruleOffset]() {
							goto l545
						}
					}
				l548:
					goto l534
				l545:
					position, tokenIndex = position534, tokenIndex534
					if buffer[position] != rune('#') {
						goto l550
					}
					position++
					if !_rules[ruleOffset]() {
						goto l550
					}
					{
						position551, tokenIndex551 := position, tokenIndex
						if buffer[position] != rune('*') {
							goto l551
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l551
						}
						position++
					l553:
						{
							position554, tokenIndex554 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l554
							}
							position++
							goto l553
						l554:
							position, tokenIndex = position554, tokenIndex554
						}
						{
							position555, tokenIndex555 := position, tokenIndex
							if buffer[position] != rune('-') {
								goto l555
							}
							position++
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l555
							}
							position++
						l557:
							{
								position558, tokenIndex558 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l558
								}
								position++
								goto l557
							l558:
								position, tokenIndex = position558, tokenIndex558
							}
							goto l556
						l555:
							position, tokenIndex = position555, tokenIndex555
						}
					l556:
						goto l552
					l551:
						position, tokenIndex = position551, tokenIndex551
					}
				l552:
					goto l534
				l550:
					position, tokenIndex = position534, tokenIndex534
					if buffer[position] != rune('#') {
						goto l559
					}
					position++
					{
						position560, tokenIndex560 := position, tokenIndex
						if buffer[position] != rune('~') {
							goto l560
						}
						position++
						goto l561
					l560:
						position, tokenIndex = position560, tokenIndex560
					}
				l561:
					if buffer[position] != rune('(') {
						goto l559
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l559
					}
					position++
					{
						position562, tokenIndex562 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l562
						}
						goto l563
					l562:
						position, tokenIndex = position562, tokenIndex562
					}
				l563:
					if buffer[position] != rune('<') {
						goto l559
					}
					position++
					if buffer[position] != rune('<') {
						goto l559
					}
					position++
					{
						position564, tokenIndex564 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l564
						}
						goto l565
					l564:
						position, tokenIndex = position564, tokenIndex564
					}
				l565:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l559
					}
					position++
					if buffer[position] != rune(')') {
						goto l559
					}
					position++
					goto l534
				l559:
					position, tokenIndex = position534, tokenIndex534
					if !_rules[ruleARMRegister]() {
						goto l532
					}
				}
			l534:
				{
					position566, tokenIndex566 := position, tokenIndex
					{
						position567, tokenIndex567 := position, tokenIndex
						if buffer[position] != rune('f') {
							goto l568
						}
						position++
						goto l567
					l568:
						position, tokenIndex = position567, tokenIndex567
						if buffer[position] != rune('b') {
							goto l569
						}
						position++
						goto l567
					l569:
						position, tokenIndex = position567, tokenIndex567
						if buffer[position] != rune(':') {
							goto l570
						}
						position++
						goto l567
					l570:
						position, tokenIndex = position567, tokenIndex567
						if buffer[position] != rune('(') {
							goto l571
						}
						position++
						goto l567
					l571:
						position, tokenIndex = position567, tokenIndex567
						if buffer[position] != rune('+') {
							goto l572
						}
						position++
						goto l567
					l572:
						position, tokenIndex = position567, tokenIndex567
						if buffer[position] != rune('-') {
							goto l566
						}
						position++
					}
				l567:
					goto l532
				l566:
					position, tokenIndex = position566, tokenIndex566
				}
				add(ruleRegisterOrConstant, position533)
			}
			return true
		l532:
			position, tokenIndex = position532, tokenIndex532
			return false
		},
		/* 43 ARMConstantTweak <- <(((('u' / 's') (('x' / 'X') ('t' / 'T')) ('x' / 'w' / 'h' / 'b')) / (('l' / 'L') ('s' / 'S') ('l' / 'L')) / (('l' / 'L') ('s' / 'S') ('r' / 'R')) / (('r' / 'R') ('o' / 'O') ('r' / 'R')) / (('a' / 'A') ('s' / 'S') ('r' / 'R'))) (WS '#' Offset)?)> */
		func() bool {
			position573, tokenIndex573 := position, tokenIndex
			{
				position574 := position
				{
					position575, tokenIndex575 := position, tokenIndex
					{
						position577, tokenIndex577 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l578
						}
						position++
						goto l577
					l578:
						position, tokenIndex = position577, tokenIndex577
						if buffer[position] != rune('s') {
							goto l576
						}
						position++
					}
				l577:
					{
						position579, tokenIndex579 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l580
						}
						position++
						goto l579
					l580:
						position, tokenIndex = position579, tokenIndex579
						if buffer[position] != rune('X') {
							goto l576
						}
						position++
					}
				l579:
					{
						position581, tokenIndex581 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l582
						}
						position++
						goto l581
					l582:
						position, tokenIndex = position581, tokenIndex581
						if buffer[position] != rune('T') {
							goto l576
						}
						position++
					}
				l581:
					{
						position583, tokenIndex583 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l584
						}
						position++
						goto l583
					l584:
						position, tokenIndex = position583, tokenIndex583
						if buffer[position] != rune('w') {
							goto l585
						}
						position++
						goto l583
					l585:
						position, tokenIndex = position583, tokenIndex583
						if buffer[position] != rune('h') {
							goto l586
						}
						position++
						goto l583
					l586:
						position, tokenIndex = position583, tokenIndex583
						if buffer[position] != rune('b') {
							goto l576
						}
						position++
					}
				l583:
					goto l575
				l576:
					position, tokenIndex = position575, tokenIndex575
					{
						position588, tokenIndex588 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l589
						}
						position++
						goto l588
					l589:
						position, tokenIndex = position588, tokenIndex588
						if buffer[position] != rune('L') {
							goto l587
						}
						position++
					}
				l588:
					{
						position590, tokenIndex590 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l591
						}
						position++
						goto l590
					l591:
						position, tokenIndex = position590, tokenIndex590
						if buffer[position] != rune('S') {
							goto l587
						}
						position++
					}
				l590:
					{
						position592, tokenIndex592 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l593
						}
						position++
						goto l592
					l593:
						position, tokenIndex = position592, tokenIndex592
						if buffer[position] != rune('L') {
							goto l587
						}
						position++
					}
				l592:
					goto l575
				l587:
					position, tokenIndex = position575, tokenIndex575
					{
						position595, tokenIndex595 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l596
						}
						position++
						goto l595
					l596:
						position, tokenIndex = position595, tokenIndex595
						if buffer[position] != rune('L') {
							goto l594
						}
						position++
					}
				l595:
					{
						position597, tokenIndex597 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l598
						}
						position++
						goto l597
					l598:
						position, tokenIndex = position597, tokenIndex597
						if buffer[position] != rune('S') {
							goto l594
						}
						position++
					}
				l597:
					{
						position599, tokenIndex599 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l600
						}
						position++
						goto l599
					l600:
						position, tokenIndex = position599, tokenIndex599
						if buffer[position] != rune('R') {
							goto l594
						}
						position++
					}
				l599:
					goto l575
				l594:
					position, tokenIndex = position575, tokenIndex575
					{
						position602, tokenIndex602 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l603
						}
						position++
						goto l602
					l603:
						position, tokenIndex = position602, tokenIndex602
						if buffer[position] != rune('R') {
							goto l601
						}
						position++
					}
				l602:
					{
						position604, tokenIndex604 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l605
						}
						position++
						goto l604
					l605:
						position, tokenIndex = position604, tokenIndex604
						if buffer[position] != rune('O') {
							goto l601
						}
						position++
					}
				l604:
					{
						position606, tokenIndex606 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l607
						}
						position++
						goto l606
					l607:
						position, tokenIndex = position606, tokenIndex606
						if buffer[position] != rune('R') {
							goto l601
						}
						position++
					}
				l606:
					goto l575
				l601:
					position, tokenIndex = position575, tokenIndex575
					{
						position608, tokenIndex608 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l609
						}
						position++
						goto l608
					l609:
						position, tokenIndex = position608, tokenIndex608
						if buffer[position] != rune('A') {
							goto l573
						}
						position++
					}
				l608:
					{
						position610, tokenIndex610 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l611
						}
						position++
						goto l610
					l611:
						position, tokenIndex = position610, tokenIndex610
						if buffer[position] != rune('S') {
							goto l573
						}
						position++
					}
				l610:
					{
						position612, tokenIndex612 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l613
						}
						position++
						goto l612
					l613:
						position, tokenIndex = position612, tokenIndex612
						if buffer[position] != rune('R') {
							goto l573
						}
						position++
					}
				l612:
				}
			l575:
				{
					position614, tokenIndex614 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l614
					}
					if buffer[position] != rune('#') {
						goto l614
					}
					position++
					if !_rules[ruleOffset]() {
						goto l614
					}
					goto l615
				l614:
					position, tokenIndex = position614, tokenIndex614
				}
			l615:
				add(ruleARMConstantTweak, position574)
			}
			return true
		l573:
			position, tokenIndex = position573, tokenIndex573
			return false
		},
		/* 44 ARMRegister <- <((('s' / 'S') ('p' / 'P')) / (('x' / 'w' / 'd' / 'q' / 's' / 'h' / 'b') [0-9] [0-9]?) / (('x' / 'X') ('z' / 'Z') ('r' / 'R')) / (('w' / 'W') ('z' / 'Z') ('r' / 'R')) / (('n' / 'N') ('z' / 'Z') ('c' / 'C') ('v' / 'V')) / ARMVectorRegister / ('{' WS? ARMVectorRegister (',' WS? ARMVectorRegister)* WS? '}' ('[' [0-9] [0-9]? ']')?))> */
		func() bool {
			position616, tokenIndex616 := position, tokenIndex
			{
				position617 := position
				{
					position618, tokenIndex618 := position, tokenIndex
					{
						position620, tokenIndex620 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l621
						}
						position++
						goto l620
					l621:
						position, tokenIndex = position620, tokenIndex620
						if buffer[position] != rune('S') {
							goto l619
						}
						position++
					}
				l620:
					{
						position622, tokenIndex622 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l623
						}
						position++
						goto l622
					l623:
						position, tokenIndex = position622, tokenIndex622
						if buffer[position] != rune('P') {
							goto l619
						}
						position++
					}
				l622:
					goto l618
				l619:
					position, tokenIndex = position618, tokenIndex618
					{
						position625, tokenIndex625 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l626
						}
						position++
						goto l625
					l626:
						position, tokenIndex = position625, tokenIndex625
						if buffer[position] != rune('w') {
							goto l627
						}
						position++
						goto l625
					l627:
						position, tokenIndex = position625, tokenIndex625
						if buffer[position] != rune('d') {
							goto l628
						}
						position++
						goto l625
					l628:
						position, tokenIndex = position625, tokenIndex625
						if buffer[position] != rune('q') {
							goto l629
						}
						position++
						goto l625
					l629:
						position, tokenIndex = position625, tokenIndex625
						if buffer[position] != rune('s') {
							goto l630
						}
						position++
						goto l625
					l630:
						position, tokenIndex = position625, tokenIndex625
						if buffer[position] != rune('h') {
							goto l631
						}
						position++
						goto l625
					l631:
						position, tokenIndex = position625, tokenIndex625
						if buffer[position] != rune('b') {
							goto l624
						}
						position++
					}
				l625:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l624
					}
					position++
					{
						position632, tokenIndex632 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l632
						}
						position++
						goto l633
					l632:
						position, tokenIndex = position632, tokenIndex632
					}
				l633:
					goto l618
				l624:
					position, tokenIndex = position618, tokenIndex618
					{
						position635, tokenIndex635 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l636
						}
						position++
						goto l635
					l636:
						position, tokenIndex = position635, tokenIndex635
						if buffer[position] != rune('X') {
							goto l634
						}
						position++
					}
				l635:
					{
						position637, tokenIndex637 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l638
						}
						position++
						goto l637
					l638:
						position, tokenIndex = position637, tokenIndex637
						if buffer[position] != rune('Z') {
							goto l634
						}
						position++
					}
				l637:
					{
						position639, tokenIndex639 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l640
						}
						position++
						goto l639
					l640:
						position, tokenIndex = position639, tokenIndex639
						if buffer[position] != rune('R') {
							goto l634
						}
						position++
					}
				l639:
					goto l618
				l634:
					position, tokenIndex = position618, tokenIndex618
					{
						position642, tokenIndex642 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l643
						}
						position++
						goto l642
					l643:
						position, tokenIndex = position642, tokenIndex642
						if buffer[position] != rune('W') {
							goto l641
						}
						position++
					}
				l642:
					{
						position644, tokenIndex644 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l645
						}
						position++
						goto l644
					l645:
						position, tokenIndex = position644, tokenIndex644
						if buffer[position] != rune('Z') {
							goto l641
						}
						position++
					}
				l644:
					{
						position646, tokenIndex646 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l647
						}
						position++
						goto l646
					l647:
						position, tokenIndex = position646, tokenIndex646
						if buffer[position] != rune('R') {
							goto l641
						}
						position++
					}
				l646:
					goto l618
				l641:
					position, tokenIndex = position618, tokenIndex618
					{
						position649, tokenIndex649 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l650
						}
						position++
						goto l649
					l650:
						position, tokenIndex = position649, tokenIndex649
						if buffer[position] != rune('N') {
							goto l648
						}
						position++
					}
				l649:
					{
						position651, tokenIndex651 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l652
						}
						position++
						goto l651
					l652:
						position, tokenIndex = position651, tokenIndex651
						if buffer[position] != rune('Z') {
							goto l648
						}
						position++
					}
				l651:
					{
						position653, tokenIndex653 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l654
						}
						position++
						goto l653
					l654:
						position, tokenIndex = position653, tokenIndex653
						if buffer[position] != rune('C') {
							goto l648
						}
						position++
					}
				l653:
					{
						position655, tokenIndex655 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l656
						}
						position++
						goto l655
					l656:
						position, tokenIndex = position655, tokenIndex655
						if buffer[position] != rune('V') {
							goto l648
						}
						position++
					}
				l655:
					goto l618
				l648:
					position, tokenIndex = position618, tokenIndex618
					if !_rules[ruleARMVectorRegister]() {
						goto l657
					}
					goto l618
				l657:
					position, tokenIndex = position618, tokenIndex618
					if buffer[position] != rune('{') {
						goto l616
					}
					position++
					{
						position658, tokenIndex658 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l658
						}
						goto l659
					l658:
						position, tokenIndex = position658, tokenIndex658
					}
				l659:
					if !_rules[ruleARMVectorRegister]() {
						goto l616
					}
				l660:
					{
						position661, tokenIndex661 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l661
						}
						position++
						{
							position662, tokenIndex662 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l662
							}
							goto l663
						l662:
							position, tokenIndex = position662, tokenIndex662
						}
					l663:
						if !_rules[ruleARMVectorRegister]() {
							goto l661
						}
						goto l660
					l661:
						position, tokenIndex = position661, tokenIndex661
					}
					{
						position664, tokenIndex664 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l664
						}
						goto l665
					l664:
						position, tokenIndex = position664, tokenIndex664
					}
				l665:
					if buffer[position] != rune('}') {
						goto l616
					}
					position++
					{
						position666, tokenIndex666 := position, tokenIndex
						if buffer[position] != rune('[') {
							goto l666
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l666
						}
						position++
						{
							position668, tokenIndex668 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l668
							}
							position++
							goto l669
						l668:
							position, tokenIndex = position668, tokenIndex668
						}
					l669:
						if buffer[position] != rune(']') {
							goto l666
						}
						position++
						goto l667
					l666:
						position, tokenIndex = position666, tokenIndex666
					}
				l667:
				}
			l618:
				add(ruleARMRegister, position617)
			}
			return true
		l616:
			position, tokenIndex = position616, tokenIndex616
			return false
		},
		/* 45 ARMVectorRegister <- <(('v' / 'V') [0-9] [0-9]? ('.' [0-9]* ('b' / 's' / 'd' / 'h' / 'q') ('[' [0-9] [0-9]? ']')?)?)> */
		func() bool {
			position670, tokenIndex670 := position, tokenIndex
			{
				position671 := position
				{
					position672, tokenIndex672 := position, tokenIndex
					if buffer[position] != rune('v') {
						goto l673
					}
					position++
					goto l672
				l673:
					position, tokenIndex = position672, tokenIndex672
					if buffer[position] != rune('V') {
						goto l670
					}
					position++
				}
			l672:
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l670
				}
				position++
				{
					position674, tokenIndex674 := position, tokenIndex
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l674
					}
					position++
					goto l675
				l674:
					position, tokenIndex = position674, tokenIndex674
				}
			l675:
				{
					position676, tokenIndex676 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l676
					}
					position++
				l678:
					{
						position679, tokenIndex679 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l679
						}
						position++
						goto l678
					l679:
						position, tokenIndex = position679, tokenIndex679
					}
					{
						position680, tokenIndex680 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l681
						}
						position++
						goto l680
					l681:
						position, tokenIndex = position680, tokenIndex680
						if buffer[position] != rune('s') {
							goto l682
						}
						position++
						goto l680
					l682:
						position, tokenIndex = position680, tokenIndex680
						if buffer[position] != rune('d') {
							goto l683
						}
						position++
						goto l680
					l683:
						position, tokenIndex = position680, tokenIndex680
						if buffer[position] != rune('h') {
							goto l684
						}
						position++
						goto l680
					l684:
						position, tokenIndex = position680, tokenIndex680
						if buffer[position] != rune('q') {
							goto l676
						}
						position++
					}
				l680:
					{
						position685, tokenIndex685 := position, tokenIndex
						if buffer[position] != rune('[') {
							goto l685
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l685
						}
						position++
						{
							position687, tokenIndex687 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l687
							}
							position++
							goto l688
						l687:
							position, tokenIndex = position687, tokenIndex687
						}
					l688:
						if buffer[position] != rune(']') {
							goto l685
						}
						position++
						goto l686
					l685:
						position, tokenIndex = position685, tokenIndex685
					}
				l686:
					goto l677
				l676:
					position, tokenIndex = position676, tokenIndex676
				}
			l677:
				add(ruleARMVectorRegister, position671)
			}
			return true
		l670:
			position, tokenIndex = position670, tokenIndex670
			return false
		},
		/* 46 MemoryRef <- <((SymbolRef BaseIndexScale) / SymbolRef / Low12BitsSymbolRef / (Offset* BaseIndexScale) / (SegmentRegister Offset BaseIndexScale) / (SegmentRegister BaseIndexScale) / (SegmentRegister Offset) / ARMBaseIndexScale / BaseIndexScale)> */
		func() bool {
			position689, tokenIndex689 := position, tokenIndex
			{
				position690 := position
				{
					position691, tokenIndex691 := position, tokenIndex
					if !_rules[ruleSymbolRef]() {
						goto l692
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l692
					}
					goto l691
				l692:
					position, tokenIndex = position691, tokenIndex691
					if !_rules[ruleSymbolRef]() {
						goto l693
					}
					goto l691
				l693:
					position, tokenIndex = position691, tokenIndex691
					if !_rules[ruleLow12BitsSymbolRef]() {
						goto l694
					}
					goto l691
				l694:
					position, tokenIndex = position691, tokenIndex691
				l696:
					{
						position697, tokenIndex697 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l697
						}
						goto l696
					l697:
						position, tokenIndex = position697, tokenIndex697
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l695
					}
					goto l691
				l695:
					position, tokenIndex = position691, tokenIndex691
					if !_rules[ruleSegmentRegister]() {
						goto l698
					}
					if !_rules[ruleOffset]() {
						goto l698
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l698
					}
					goto l691
				l698:
					position, tokenIndex = position691, tokenIndex691
					if !_rules[ruleSegmentRegister]() {
						goto l699
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l699
					}
					goto l691
				l699:
					position, tokenIndex = position691, tokenIndex691
					if !_rules[ruleSegmentRegister]() {
						goto l700
					}
					if !_rules[ruleOffset]() {
						goto l700
					}
					goto l691
				l700:
					position, tokenIndex = position691, tokenIndex691
					if !_rules[ruleARMBaseIndexScale]() {
						goto l701
					}
					goto l691
				l701:
					position, tokenIndex = position691, tokenIndex691
					if !_rules[ruleBaseIndexScale]() {
						goto l689
					}
				}
			l691:
				add(ruleMemoryRef, position690)
			}
			return true
		l689:
			position, tokenIndex = position689, tokenIndex689
			return false
		},
		/* 47 SymbolRef <- <((Offset* '+')? (LocalSymbol / SymbolName) Offset* ('@' Section Offset*)?)> */
		func() bool {
			position702, tokenIndex702 := position, tokenIndex
			{
				position703 := position
				{
					position704, tokenIndex704 := position, tokenIndex
				l706:
					{
						position707, tokenIndex707 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l707
						}
						goto l706
					l707:
						position, tokenIndex = position707, tokenIndex707
					}
					if buffer[position] != rune('+') {
						goto l704
					}
					position++
					goto l705
				l704:
					position, tokenIndex = position704, tokenIndex704
				}
			l705:
				{
					position708, tokenIndex708 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l709
					}
					goto l708
				l709:
					position, tokenIndex = position708, tokenIndex708
					if !_rules[ruleSymbolName]() {
						goto l702
					}
				}
			l708:
			l710:
				{
					position711, tokenIndex711 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l711
					}
					goto l710
				l711:
					position, tokenIndex = position711, tokenIndex711
				}
				{
					position712, tokenIndex712 := position, tokenIndex
					if buffer[position] != rune('@') {
						goto l712
					}
					position++
					if !_rules[ruleSection]() {
						goto l712
					}
				l714:
					{
						position715, tokenIndex715 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l715
						}
						goto l714
					l715:
						position, tokenIndex = position715, tokenIndex715
					}
					goto l713
				l712:
					position, tokenIndex = position712, tokenIndex712
				}
			l713:
				add(ruleSymbolRef, position703)
			}
			return true
		l702:
			position, tokenIndex = position702, tokenIndex702
			return false
		},
		/* 48 Low12BitsSymbolRef <- <(':' ('l' / 'L') ('o' / 'O') '1' '2' ':' (LocalSymbol / SymbolName) Offset?)> */
		func() bool {
			position716, tokenIndex716 := position, tokenIndex
			{
				position717 := position
				if buffer[position] != rune(':') {
					goto l716
				}
				position++
				{
					position718, tokenIndex718 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l719
					}
					position++
					goto l718
				l719:
					position, tokenIndex = position718, tokenIndex718
					if buffer[position] != rune('L') {
						goto l716
					}
					position++
				}
			l718:
				{
					position720, tokenIndex720 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l721
					}
					position++
					goto l720
				l721:
					position, tokenIndex = position720, tokenIndex720
					if buffer[position] != rune('O') {
						goto l716
					}
					position++
				}
			l720:
				if buffer[position] != rune('1') {
					goto l716
				}
				position++
				if buffer[position] != rune('2') {
					goto l716
				}
				position++
				if buffer[position] != rune(':') {
					goto l716
				}
				position++
				{
					position722, tokenIndex722 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l723
					}
					goto l722
				l723:
					position, tokenIndex = position722, tokenIndex722
					if !_rules[ruleSymbolName]() {
						goto l716
					}
				}
			l722:
				{
					position724, tokenIndex724 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l724
					}
					goto l725
				l724:
					position, tokenIndex = position724, tokenIndex724
				}
			l725:
				add(ruleLow12BitsSymbolRef, position717)
			}
			return true
		l716:
			position, tokenIndex = position716, tokenIndex716
			return false
		},
		/* 49 ARMBaseIndexScale <- <('[' ARMRegister (',' WS? (('#' Offset (('*' [0-9]+) / ('*' '(' [0-9]+ Operator [0-9]+ ')') / ('+' [0-9]+)*)?) / ARMGOTLow12 / Low12BitsSymbolRef / ARMRegister) (',' WS? ARMConstantTweak)?)? ']' ARMPostincrement?)> */
		func() bool {
			position726, tokenIndex726 := position, tokenIndex
			{
				position727 := position
				if buffer[position] != rune('[') {
					goto l726
				}
				position++
				if !_rules[ruleARMRegister]() {
					goto l726
				}
				{
					position728, tokenIndex728 := position, tokenIndex
					if buffer[position] != rune(',') {
						goto l728
					}
					position++
					{
						position730, tokenIndex730 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l730
						}
						goto l731
					l730:
						position, tokenIndex = position730, tokenIndex730
					}
				l731:
					{
						position732, tokenIndex732 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l733
						}
						position++
						if !_rules[ruleOffset]() {
							goto l733
						}
						{
							position734, tokenIndex734 := position, tokenIndex
							{
								position736, tokenIndex736 := position, tokenIndex
								if buffer[position] != rune('*') {
									goto l737
								}
								position++
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l737
								}
								position++
							l738:
								{
									position739, tokenIndex739 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l739
									}
									position++
									goto l738
								l739:
									position, tokenIndex = position739, tokenIndex739
								}
								goto l736
							l737:
								position, tokenIndex = position736, tokenIndex736
								if buffer[position] != rune('*') {
									goto l740
								}
								position++
								if buffer[position] != rune('(') {
									goto l740
								}
								position++
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l740
								}
								position++
							l741:
								{
									position742, tokenIndex742 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l742
									}
									position++
									goto l741
								l742:
									position, tokenIndex = position742, tokenIndex742
								}
								if !_rules[ruleOperator]() {
									goto l740
								}
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l740
								}
								position++
							l743:
								{
									position744, tokenIndex744 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l744
									}
									position++
									goto l743
								l744:
									position, tokenIndex = position744, tokenIndex744
								}
								if buffer[position] != rune(')') {
									goto l740
								}
								position++
								goto l736
							l740:
								position, tokenIndex = position736, tokenIndex736
							l745:
								{
									position746, tokenIndex746 := position, tokenIndex
									if buffer[position] != rune('+') {
										goto l746
									}
									position++
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l746
									}
									position++
								l747:
									{
										position748, tokenIndex748 := position, tokenIndex
										if c := buffer[position]; c < rune('0') || c > rune('9') {
											goto l748
										}
										position++
										goto l747
									l748:
										position, tokenIndex = position748, tokenIndex748
									}
									goto l745
								l746:
									position, tokenIndex = position746, tokenIndex746
								}
							}
						l736:
							goto l735

							position, tokenIndex = position734, tokenIndex734
						}
					l735:
						goto l732
					l733:
						position, tokenIndex = position732, tokenIndex732
						if !_rules[ruleARMGOTLow12]() {
							goto l749
						}
						goto l732
					l749:
						position, tokenIndex = position732, tokenIndex732
						if !_rules[ruleLow12BitsSymbolRef]() {
							goto l750
						}
						goto l732
					l750:
						position, tokenIndex = position732, tokenIndex732
						if !_rules[ruleARMRegister]() {
							goto l728
						}
					}
				l732:
					{
						position751, tokenIndex751 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l751
						}
						position++
						{
							position753, tokenIndex753 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l753
							}
							goto l754
						l753:
							position, tokenIndex = position753, tokenIndex753
						}
					l754:
						if !_rules[ruleARMConstantTweak]() {
							goto l751
						}
						goto l752
					l751:
						position, tokenIndex = position751, tokenIndex751
					}
				l752:
					goto l729
				l728:
					position, tokenIndex = position728, tokenIndex728
				}
			l729:
				if buffer[position] != rune(']') {
					goto l726
				}
				position++
				{
					position755, tokenIndex755 := position, tokenIndex
					if !_rules[ruleARMPostincrement]() {
						goto l755
					}
					goto l756
				l755:
					position, tokenIndex = position755, tokenIndex755
				}
			l756:
				add(ruleARMBaseIndexScale, position727)
			}
			return true
		l726:
			position, tokenIndex = position726, tokenIndex726
			return false
		},
		/* 50 ARMGOTLow12 <- <(':' ('g' / 'G') ('o' / 'O') ('t' / 'T') '_' ('l' / 'L') ('o' / 'O') '1' '2' ':' SymbolName)> */
		func() bool {
			position757, tokenIndex757 := position, tokenIndex
			{
				position758 := position
				if buffer[position] != rune(':') {
					goto l757
				}
				position++
				{
					position759, tokenIndex759 := position, tokenIndex
					if buffer[position] != rune('g') {
						goto l760
					}
					position++
					goto l759
				l760:
					position, tokenIndex = position759, tokenIndex759
					if buffer[position] != rune('G') {
						goto l757
					}
					position++
				}
			l759:
				{
					position761, tokenIndex761 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l762
					}
					position++
					goto l761
				l762:
					position, tokenIndex = position761, tokenIndex761
					if buffer[position] != rune('O') {
						goto l757
					}
					position++
				}
			l761:
				{
					position763, tokenIndex763 := position, tokenIndex
					if buffer[position] != rune('t') {
						goto l764
					}
					position++
					goto l763
				l764:
					position, tokenIndex = position763, tokenIndex763
					if buffer[position] != rune('T') {
						goto l757
					}
					position++
				}
			l763:
				if buffer[position] != rune('_') {
					goto l757
				}
				position++
				{
					position765, tokenIndex765 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l766
					}
					position++
					goto l765
				l766:
					position, tokenIndex = position765, tokenIndex765
					if buffer[position] != rune('L') {
						goto l757
					}
					position++
				}
			l765:
				{
					position767, tokenIndex767 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l768
					}
					position++
					goto l767
				l768:
					position, tokenIndex = position767, tokenIndex767
					if buffer[position] != rune('O') {
						goto l757
					}
					position++
				}
			l767:
				if buffer[position] != rune('1') {
					goto l757
				}
				position++
				if buffer[position] != rune('2') {
					goto l757
				}
				position++
				if buffer[position] != rune(':') {
					goto l757
				}
				position++
				if !_rules[ruleSymbolName]() {
					goto l757
				}
				add(ruleARMGOTLow12, position758)
			}
			return true
		l757:
			position, tokenIndex = position757, tokenIndex757
			return false
		},
		/* 51 ARMPostincrement <- <'!'> */
		func() bool {
			position769, tokenIndex769 := position, tokenIndex
			{
				position770 := position
				if buffer[position] != rune('!') {
					goto l769
				}
				position++
				add(ruleARMPostincrement, position770)
			}
			return true
		l769:
			position, tokenIndex = position769, tokenIndex769
			return false
		},
		/* 52 BaseIndexScale <- <('(' RegisterOrConstant? WS? (',' WS? RegisterOrConstant WS? (',' [0-9]+)?)? ')')> */
		func() bool {
			position771, tokenIndex771 := position, tokenIndex
			{
				position772 := position
				if buffer[position] != rune('(') {
					goto l771
				}
				position++
				{
					position773, tokenIndex773 := position, tokenIndex
					if !_rules[ruleRegisterOrConstant]() {
						goto l773
					}
					goto l774
				l773:
					position, tokenIndex = position773, tokenIndex773
				}
			l774:
				{
					position775, tokenIndex775 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l775
					}
					goto l776
				l775:
					position, tokenIndex = position775, tokenIndex775
				}
			l776:
				{
					position777, tokenIndex777 := position, tokenIndex
					if buffer[position] != rune(',') {
						goto l777
					}
					position++
					{
						position779, tokenIndex779 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l779
						}
						goto l780
					l779:
						position, tokenIndex = position779, tokenIndex779
					}
				l780:
					if !_rules[ruleRegisterOrConstant]() {
						goto l777
					}
					{
						position781, tokenIndex781 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l781
						}
						goto l782
					l781:
						position, tokenIndex = position781, tokenIndex781
					}
				l782:
					{
						position783, tokenIndex783 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l783
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l783
						}
						position++
					l785:
						{
							position786, tokenIndex786 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l786
							}
							position++
							goto l785
						l786:
							position, tokenIndex = position786, tokenIndex786
						}
						goto l784
					l783:
						position, tokenIndex = position783, tokenIndex783
					}
				l784:
					goto l778
				l777:
					position, tokenIndex = position777, tokenIndex777
				}
			l778:
				if buffer[position] != rune(')') {
					goto l771
				}
				position++
				add(ruleBaseIndexScale, position772)
			}
			return true
		l771:
			position, tokenIndex = position771, tokenIndex771
			return false
		},
		/* 53 Operator <- <('+' / '-')> */
		func() bool {
			position787, tokenIndex787 := position, tokenIndex
			{
				position788 := position
				{
					position789, tokenIndex789 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l790
					}
					position++
					goto l789
				l790:
					position, tokenIndex = position789, tokenIndex789
					if buffer[position] != rune('-') {
						goto l787
					}
					position++
				}
			l789:
				add(ruleOperator, position788)
			}
			return true
		l787:
			position, tokenIndex = position787, tokenIndex787
			return false
		},
		/* 54 Offset <- <('+'? '-'? (('0' ('b' / 'B') ('0' / '1')+) / ('0' ('x' / 'X') ([0-9] / [0-9] / ([a-f] / [A-F]))+) / [0-9]+))> */
		func() bool {
			position791, tokenIndex791 := position, tokenIndex
			{
				position792 := position
				{
					position793, tokenIndex793 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l793
					}
					position++
					goto l794
				l793:
					position, tokenIndex = position793, tokenIndex793
				}
			l794:
				{
					position795, tokenIndex795 := position, tokenIndex
					if buffer[position] != rune('-') {
						goto l795
					}
					position++
					goto l796
				l795:
					position, tokenIndex = position795, tokenIndex795
				}
			l796:
				{
					position797, tokenIndex797 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l798
					}
					position++
					{
						position799, tokenIndex799 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l800
						}
						position++
						goto l799
					l800:
						position, tokenIndex = position799, tokenIndex799
						if buffer[position] != rune('B') {
							goto l798
						}
						position++
					}
				l799:
					{
						position803, tokenIndex803 := position, tokenIndex
						if buffer[position] != rune('0') {
							goto l804
						}
						position++
						goto l803
					l804:
						position, tokenIndex = position803, tokenIndex803
						if buffer[position] != rune('1') {
							goto l798
						}
						position++
					}
				l803:
				l801:
					{
						position802, tokenIndex802 := position, tokenIndex
						{
							position805, tokenIndex805 := position, tokenIndex
							if buffer[position] != rune('0') {
								goto l806
							}
							position++
							goto l805
						l806:
							position, tokenIndex = position805, tokenIndex805
							if buffer[position] != rune('1') {
								goto l802
							}
							position++
						}
					l805:
						goto l801
					l802:
						position, tokenIndex = position802, tokenIndex802
					}
					goto l797
				l798:
					position, tokenIndex = position797, tokenIndex797
					if buffer[position] != rune('0') {
						goto l807
					}
					position++
					{
						position808, tokenIndex808 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l809
						}
						position++
						goto l808
					l809:
						position, tokenIndex = position808, tokenIndex808
						if buffer[position] != rune('X') {
							goto l807
						}
						position++
					}
				l808:
					{
						position812, tokenIndex812 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l813
						}
						position++
						goto l812
					l813:
						position, tokenIndex = position812, tokenIndex812
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l814
						}
						position++
						goto l812
					l814:
						position, tokenIndex = position812, tokenIndex812
						{
							position815, tokenIndex815 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('f') {
								goto l816
							}
							position++
							goto l815
						l816:
							position, tokenIndex = position815, tokenIndex815
							if c := buffer[position]; c < rune('A') || c > rune('F') {
								goto l807
							}
							position++
						}
					l815:
					}
				l812:
				l810:
					{
						position811, tokenIndex811 := position, tokenIndex
						{
							position817, tokenIndex817 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l818
							}
							position++
							goto l817
						l818:
							position, tokenIndex = position817, tokenIndex817
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l819
							}
							position++
							goto l817
						l819:
							position, tokenIndex = position817, tokenIndex817
							{
								position820, tokenIndex820 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('f') {
									goto l821
								}
								position++
								goto l820
							l821:
								position, tokenIndex = position820, tokenIndex820
								if c := buffer[position]; c < rune('A') || c > rune('F') {
									goto l811
								}
								position++
							}
						l820:
						}
					l817:
						goto l810
					l811:
						position, tokenIndex = position811, tokenIndex811
					}
					goto l797
				l807:
					position, tokenIndex = position797, tokenIndex797
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l791
					}
					position++
				l822:
					{
						position823, tokenIndex823 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l823
						}
						position++
						goto l822
					l823:
						position, tokenIndex = position823, tokenIndex823
					}
				}
			l797:
				add(ruleOffset, position792)
			}
			return true
		l791:
			position, tokenIndex = position791, tokenIndex791
			return false
		},
		/* 55 Section <- <([a-z] / [A-Z] / '@')+> */
		func() bool {
			position824, tokenIndex824 := position, tokenIndex
			{
				position825 := position
				{
					position828, tokenIndex828 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l829
					}
					position++
					goto l828
				l829:
					position, tokenIndex = position828, tokenIndex828
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l830
					}
					position++
					goto l828
				l830:
					position, tokenIndex = position828, tokenIndex828
					if buffer[position] != rune('@') {
						goto l824
					}
					position++
				}
			l828:
			l826:
				{
					position827, tokenIndex827 := position, tokenIndex
					{
						position831, tokenIndex831 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l832
						}
						position++
						goto l831
					l832:
						position, tokenIndex = position831, tokenIndex831
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l833
						}
						position++
						goto l831
					l833:
						position, tokenIndex = position831, tokenIndex831
						if buffer[position] != rune('@') {
							goto l827
						}
						position++
					}
				l831:
					goto l826
				l827:
					position, tokenIndex = position827, tokenIndex827
				}
				add(ruleSection, position825)
			}
			return true
		l824:
			position, tokenIndex = position824, tokenIndex824
			return false
		},
		/* 56 SegmentRegister <- <('%' ([c-g] / 's') ('s' ':'))> */
		func() bool {
			position834, tokenIndex834 := position, tokenIndex
			{
				position835 := position
				if buffer[position] != rune('%') {
					goto l834
				}
				position++
				{
					position836, tokenIndex836 := position, tokenIndex
					if c := buffer[position]; c < rune('c') || c > rune('g') {
						goto l837
					}
					position++
					goto l836
				l837:
					position, tokenIndex = position836, tokenIndex836
					if buffer[position] != rune('s') {
						goto l834
					}
					position++
				}
			l836:
				if buffer[position] != rune('s') {
					goto l834
				}
				position++
				if buffer[position] != rune(':') {
					goto l834
				}
				position++
				add(ruleSegmentRegister, position835)
			}
			return true
		l834:
			position, tokenIndex = position834, tokenIndex834
			return false
		},
	}
	p.rules = _rules
	return nil
}
