﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ecs/model/ManagedScalingStatus.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace ECS
  {
    namespace Model
    {
      namespace ManagedScalingStatusMapper
      {

        static const int ENABLED_HASH = HashingUtils::HashString("ENABLED");
        static const int DISABLED_HASH = HashingUtils::HashString("DISABLED");


        ManagedScalingStatus GetManagedScalingStatusForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == ENABLED_HASH)
          {
            return ManagedScalingStatus::ENABLED;
          }
          else if (hashCode == DISABLED_HASH)
          {
            return ManagedScalingStatus::DISABLED;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<ManagedScalingStatus>(hashCode);
          }

          return ManagedScalingStatus::NOT_SET;
        }

        Aws::String GetNameForManagedScalingStatus(ManagedScalingStatus enumValue)
        {
          switch(enumValue)
          {
          case ManagedScalingStatus::NOT_SET:
            return {};
          case ManagedScalingStatus::ENABLED:
            return "ENABLED";
          case ManagedScalingStatus::DISABLED:
            return "DISABLED";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace ManagedScalingStatusMapper
    } // namespace Model
  } // namespace ECS
} // namespace Aws
