﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ecs/model/TaskDefinitionField.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace ECS
  {
    namespace Model
    {
      namespace TaskDefinitionFieldMapper
      {

        static const int TAGS_HASH = HashingUtils::HashString("TAGS");


        TaskDefinitionField GetTaskDefinitionFieldForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == TAGS_HASH)
          {
            return TaskDefinitionField::TAGS;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<TaskDefinitionField>(hashCode);
          }

          return TaskDefinitionField::NOT_SET;
        }

        Aws::String GetNameForTaskDefinitionField(TaskDefinitionField enumValue)
        {
          switch(enumValue)
          {
          case TaskDefinitionField::NOT_SET:
            return {};
          case TaskDefinitionField::TAGS:
            return "TAGS";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace TaskDefinitionFieldMapper
    } // namespace Model
  } // namespace ECS
} // namespace Aws
