﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/databrew/GlueDataBrew_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/databrew/model/DatabaseTableOutputOptions.h>
#include <aws/databrew/model/DatabaseOutputMode.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GlueDataBrew
{
namespace Model
{

  /**
   * <p>Represents a JDBC database output object which defines the output destination
   * for a DataBrew recipe job to write into.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DatabaseOutput">AWS
   * API Reference</a></p>
   */
  class DatabaseOutput
  {
  public:
    AWS_GLUEDATABREW_API DatabaseOutput();
    AWS_GLUEDATABREW_API DatabaseOutput(Aws::Utils::Json::JsonView jsonValue);
    AWS_GLUEDATABREW_API DatabaseOutput& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GLUEDATABREW_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The Glue connection that stores the connection information for the target
     * database.</p>
     */
    inline const Aws::String& GetGlueConnectionName() const{ return m_glueConnectionName; }
    inline bool GlueConnectionNameHasBeenSet() const { return m_glueConnectionNameHasBeenSet; }
    inline void SetGlueConnectionName(const Aws::String& value) { m_glueConnectionNameHasBeenSet = true; m_glueConnectionName = value; }
    inline void SetGlueConnectionName(Aws::String&& value) { m_glueConnectionNameHasBeenSet = true; m_glueConnectionName = std::move(value); }
    inline void SetGlueConnectionName(const char* value) { m_glueConnectionNameHasBeenSet = true; m_glueConnectionName.assign(value); }
    inline DatabaseOutput& WithGlueConnectionName(const Aws::String& value) { SetGlueConnectionName(value); return *this;}
    inline DatabaseOutput& WithGlueConnectionName(Aws::String&& value) { SetGlueConnectionName(std::move(value)); return *this;}
    inline DatabaseOutput& WithGlueConnectionName(const char* value) { SetGlueConnectionName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Represents options that specify how and where DataBrew writes the database
     * output generated by recipe jobs.</p>
     */
    inline const DatabaseTableOutputOptions& GetDatabaseOptions() const{ return m_databaseOptions; }
    inline bool DatabaseOptionsHasBeenSet() const { return m_databaseOptionsHasBeenSet; }
    inline void SetDatabaseOptions(const DatabaseTableOutputOptions& value) { m_databaseOptionsHasBeenSet = true; m_databaseOptions = value; }
    inline void SetDatabaseOptions(DatabaseTableOutputOptions&& value) { m_databaseOptionsHasBeenSet = true; m_databaseOptions = std::move(value); }
    inline DatabaseOutput& WithDatabaseOptions(const DatabaseTableOutputOptions& value) { SetDatabaseOptions(value); return *this;}
    inline DatabaseOutput& WithDatabaseOptions(DatabaseTableOutputOptions&& value) { SetDatabaseOptions(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The output mode to write into the database. Currently supported option:
     * NEW_TABLE.</p>
     */
    inline const DatabaseOutputMode& GetDatabaseOutputMode() const{ return m_databaseOutputMode; }
    inline bool DatabaseOutputModeHasBeenSet() const { return m_databaseOutputModeHasBeenSet; }
    inline void SetDatabaseOutputMode(const DatabaseOutputMode& value) { m_databaseOutputModeHasBeenSet = true; m_databaseOutputMode = value; }
    inline void SetDatabaseOutputMode(DatabaseOutputMode&& value) { m_databaseOutputModeHasBeenSet = true; m_databaseOutputMode = std::move(value); }
    inline DatabaseOutput& WithDatabaseOutputMode(const DatabaseOutputMode& value) { SetDatabaseOutputMode(value); return *this;}
    inline DatabaseOutput& WithDatabaseOutputMode(DatabaseOutputMode&& value) { SetDatabaseOutputMode(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_glueConnectionName;
    bool m_glueConnectionNameHasBeenSet = false;

    DatabaseTableOutputOptions m_databaseOptions;
    bool m_databaseOptionsHasBeenSet = false;

    DatabaseOutputMode m_databaseOutputMode;
    bool m_databaseOutputModeHasBeenSet = false;
  };

} // namespace Model
} // namespace GlueDataBrew
} // namespace Aws
