﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/deadline/model/ListQueuesRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::deadline::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

ListQueuesRequest::ListQueuesRequest() : 
    m_farmIdHasBeenSet(false),
    m_principalIdHasBeenSet(false),
    m_status(QueueStatus::NOT_SET),
    m_statusHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_maxResults(0),
    m_maxResultsHasBeenSet(false)
{
}

Aws::String ListQueuesRequest::SerializePayload() const
{
  return {};
}

void ListQueuesRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_principalIdHasBeenSet)
    {
      ss << m_principalId;
      uri.AddQueryStringParameter("principalId", ss.str());
      ss.str("");
    }

    if(m_statusHasBeenSet)
    {
      ss << QueueStatusMapper::GetNameForQueueStatus(m_status);
      uri.AddQueryStringParameter("status", ss.str());
      ss.str("");
    }

    if(m_nextTokenHasBeenSet)
    {
      ss << m_nextToken;
      uri.AddQueryStringParameter("nextToken", ss.str());
      ss.str("");
    }

    if(m_maxResultsHasBeenSet)
    {
      ss << m_maxResults;
      uri.AddQueryStringParameter("maxResults", ss.str());
      ss.str("");
    }

}



