﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connectcampaignsv2/model/RestrictedPeriod.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ConnectCampaignsV2
{
namespace Model
{

RestrictedPeriod::RestrictedPeriod() : 
    m_nameHasBeenSet(false),
    m_startDateHasBeenSet(false),
    m_endDateHasBeenSet(false)
{
}

RestrictedPeriod::RestrictedPeriod(JsonView jsonValue)
  : RestrictedPeriod()
{
  *this = jsonValue;
}

RestrictedPeriod& RestrictedPeriod::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("name"))
  {
    m_name = jsonValue.GetString("name");

    m_nameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("startDate"))
  {
    m_startDate = jsonValue.GetString("startDate");

    m_startDateHasBeenSet = true;
  }

  if(jsonValue.ValueExists("endDate"))
  {
    m_endDate = jsonValue.GetString("endDate");

    m_endDateHasBeenSet = true;
  }

  return *this;
}

JsonValue RestrictedPeriod::Jsonize() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("name", m_name);

  }

  if(m_startDateHasBeenSet)
  {
   payload.WithString("startDate", m_startDate);

  }

  if(m_endDateHasBeenSet)
  {
   payload.WithString("endDate", m_endDate);

  }

  return payload;
}

} // namespace Model
} // namespace ConnectCampaignsV2
} // namespace Aws
