﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ds/model/DescribeDirectoryDataAccessResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::DirectoryService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeDirectoryDataAccessResult::DescribeDirectoryDataAccessResult() : 
    m_dataAccessStatus(DataAccessStatus::NOT_SET)
{
}

DescribeDirectoryDataAccessResult::DescribeDirectoryDataAccessResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
  : DescribeDirectoryDataAccessResult()
{
  *this = result;
}

DescribeDirectoryDataAccessResult& DescribeDirectoryDataAccessResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("DataAccessStatus"))
  {
    m_dataAccessStatus = DataAccessStatusMapper::GetDataAccessStatusForName(jsonValue.GetString("DataAccessStatus"));

  }


  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if(requestIdIter != headers.end())
  {
    m_requestId = requestIdIter->second;
  }


  return *this;
}
