;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
  (rec
    ;; CHECK-TEXT:      (rec
    ;; CHECK-TEXT-NEXT:  (type $described (descriptor $middle (struct)))
    ;; CHECK-BIN:      (rec
    ;; CHECK-BIN-NEXT:  (type $described (descriptor $middle (struct)))
    (type $described (descriptor $middle (struct)))
    ;; CHECK-TEXT:       (type $middle (describes $described (descriptor $describing (struct))))
    ;; CHECK-BIN:       (type $middle (describes $described (descriptor $describing (struct))))
    (type $middle (describes $described (descriptor $describing (struct))))
    ;; CHECK-TEXT:       (type $describing (describes $middle (struct)))
    ;; CHECK-BIN:       (type $describing (describes $middle (struct)))
    (type $describing (describes $middle (struct)))
  )

  (rec
    ;; CHECK-TEXT:      (rec
    ;; CHECK-TEXT-NEXT:  (type $shared-described (shared (descriptor $shared-describing (struct))))
    ;; CHECK-BIN:      (rec
    ;; CHECK-BIN-NEXT:  (type $shared-described (shared (descriptor $shared-describing (struct))))
    (type $shared-described (shared (descriptor $shared-describing (struct))))
    ;; CHECK-TEXT:       (type $shared-describing (shared (describes $shared-described (struct))))
    ;; CHECK-BIN:       (type $shared-describing (shared (describes $shared-described (struct))))
    (type $shared-describing (shared (describes $shared-described (struct))))
  )


  ;; CHECK-TEXT:      (global $g (ref null $described) (ref.null none))
  ;; CHECK-BIN:      (global $g (ref null $described) (ref.null none))
  (global $g (ref null $described) (ref.null none))
  ;; CHECK-TEXT:      (global $shared (ref null $shared-describing) (ref.null (shared none)))
  ;; CHECK-BIN:      (global $shared (ref null $shared-describing) (ref.null (shared none)))
  (global $shared (ref null $shared-describing) (ref.null (shared none)))
)
;; CHECK-BIN-NODEBUG:      (rec
;; CHECK-BIN-NODEBUG-NEXT:  (type $0 (descriptor $1 (struct)))

;; CHECK-BIN-NODEBUG:       (type $1 (describes $0 (descriptor $2 (struct))))

;; CHECK-BIN-NODEBUG:       (type $2 (describes $1 (struct)))

;; CHECK-BIN-NODEBUG:      (rec
;; CHECK-BIN-NODEBUG-NEXT:  (type $3 (shared (descriptor $4 (struct))))

;; CHECK-BIN-NODEBUG:       (type $4 (shared (describes $3 (struct))))

;; CHECK-BIN-NODEBUG:      (global $global$0 (ref null $0) (ref.null none))

;; CHECK-BIN-NODEBUG:      (global $global$1 (ref null $4) (ref.null (shared none)))
