;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
  ;; CHECK-TEXT:      (type $0 (func (param f32) (result f32)))
  ;; CHECK-BIN:      (type $0 (func (param f32) (result f32)))
  ;; CHECK-BIN-NODEBUG:      (type $0 (func (param f32) (result f32)))
  (type $0 (func (param f32) (result f32)))
  ;; CHECK-TEXT:      (type $1 (func (param i32 i32) (result f32)))
  ;; CHECK-BIN:      (type $1 (func (param i32 i32) (result f32)))
  ;; CHECK-BIN-NODEBUG:      (type $1 (func (param i32 i32) (result f32)))
  (type $1 (func (param i32 i32) (result f32)))
  ;; CHECK-TEXT:      (type $2 (func (param i32) (result i32)))
  ;; CHECK-BIN:      (type $2 (func (param i32) (result i32)))
  ;; CHECK-BIN-NODEBUG:      (type $2 (func (param i32) (result i32)))
  (type $2 (func (param i32) (result i32)))
  ;; CHECK-TEXT:      (type $3 (func (param i32 i32 i32) (result i32)))
  ;; CHECK-BIN:      (type $3 (func (param i32 i32 i32) (result i32)))
  ;; CHECK-BIN-NODEBUG:      (type $3 (func (param i32 i32 i32) (result i32)))
  (type $3 (func (param i32 i32 i32) (result i32)))
  ;; CHECK-TEXT:      (memory $0 256 256)
  ;; CHECK-BIN:      (memory $0 256 256)
  ;; CHECK-BIN-NODEBUG:      (memory $0 256 256)
  (memory $0 256 256)
  ;; CHECK-TEXT:      (export "floats" (func $floats))
  ;; CHECK-BIN:      (export "floats" (func $floats))
  (export "floats" (func $floats))

  ;; CHECK-TEXT:      (func $floats (type $0) (param $f f32) (result f32)
  ;; CHECK-TEXT-NEXT:  (local $t f32)
  ;; CHECK-TEXT-NEXT:  (f32.add
  ;; CHECK-TEXT-NEXT:   (local.get $t)
  ;; CHECK-TEXT-NEXT:   (local.get $f)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $floats (type $0) (param $f f32) (result f32)
  ;; CHECK-BIN-NEXT:  (local $t f32)
  ;; CHECK-BIN-NEXT:  (f32.add
  ;; CHECK-BIN-NEXT:   (local.get $t)
  ;; CHECK-BIN-NEXT:   (local.get $f)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $floats (type $0) (param $f f32) (result f32)
    (local $t f32)
    (f32.add
      (local.get $t)
      (local.get $f)
    )
  )

  ;; CHECK-TEXT:      (func $neg (type $1) (param $k i32) (param $p i32) (result f32)
  ;; CHECK-TEXT-NEXT:  (local $n f32)
  ;; CHECK-TEXT-NEXT:  (local.tee $n
  ;; CHECK-TEXT-NEXT:   (f32.neg
  ;; CHECK-TEXT-NEXT:    (block $block0 (result f32)
  ;; CHECK-TEXT-NEXT:     (i32.store
  ;; CHECK-TEXT-NEXT:      (local.get $k)
  ;; CHECK-TEXT-NEXT:      (local.get $p)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (f32.load
  ;; CHECK-TEXT-NEXT:      (local.get $k)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $neg (type $1) (param $k i32) (param $p i32) (result f32)
  ;; CHECK-BIN-NEXT:  (local $n f32)
  ;; CHECK-BIN-NEXT:  (local.tee $n
  ;; CHECK-BIN-NEXT:   (f32.neg
  ;; CHECK-BIN-NEXT:    (block (result f32)
  ;; CHECK-BIN-NEXT:     (i32.store
  ;; CHECK-BIN-NEXT:      (local.get $k)
  ;; CHECK-BIN-NEXT:      (local.get $p)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (f32.load
  ;; CHECK-BIN-NEXT:      (local.get $k)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $neg (type $1) (param $k i32) (param $p i32) (result f32)
    (local $n f32)
    (local.tee $n
      (f32.neg
        (block $block0 (result f32)
          (i32.store
            (local.get $k)
            (local.get $p)
          )
          (f32.load
            (local.get $k)
          )
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $littleswitch (type $2) (param $x i32) (result i32)
  ;; CHECK-TEXT-NEXT:  (block $topmost (result i32)
  ;; CHECK-TEXT-NEXT:   (block $switch-case$2
  ;; CHECK-TEXT-NEXT:    (block $switch-case$1
  ;; CHECK-TEXT-NEXT:     (br_table $switch-case$1 $switch-case$2 $switch-case$1
  ;; CHECK-TEXT-NEXT:      (i32.sub
  ;; CHECK-TEXT-NEXT:       (local.get $x)
  ;; CHECK-TEXT-NEXT:       (i32.const 1)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (br $topmost
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (br $topmost
  ;; CHECK-TEXT-NEXT:    (i32.const 2)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (i32.const 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $littleswitch (type $2) (param $x i32) (result i32)
  ;; CHECK-BIN-NEXT:  (block $block2 (result i32)
  ;; CHECK-BIN-NEXT:   (block $block1
  ;; CHECK-BIN-NEXT:    (block $block
  ;; CHECK-BIN-NEXT:     (br_table $block $block1 $block
  ;; CHECK-BIN-NEXT:      (i32.sub
  ;; CHECK-BIN-NEXT:       (local.get $x)
  ;; CHECK-BIN-NEXT:       (i32.const 1)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (br $block2
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (br $block2
  ;; CHECK-BIN-NEXT:    (i32.const 2)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $littleswitch (type $2) (param $x i32) (result i32)
    (block $topmost (result i32)
      (block $switch-case$2
        (block $switch-case$1
          (br_table $switch-case$1 $switch-case$2 $switch-case$1
            (i32.sub
              (local.get $x)
              (i32.const 1)
            )
          )
        )
        (br $topmost
          (i32.const 1)
        )
      )
      (br $topmost
        (i32.const 2)
      )
      (i32.const 0)
    )
  )

  ;; CHECK-TEXT:      (func $f1 (type $3) (param $i1 i32) (param $i2 i32) (param $i3 i32) (result i32)
  ;; CHECK-TEXT-NEXT:  (block $topmost (result i32)
  ;; CHECK-TEXT-NEXT:   (local.get $i3)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $f1 (type $3) (param $i1 i32) (param $i2 i32) (param $i3 i32) (result i32)
  ;; CHECK-BIN-NEXT:  (local.get $i3)
  ;; CHECK-BIN-NEXT: )
  (func $f1 (type $3) (param $i1 i32) (param $i2 i32) (param $i3 i32) (result i32)
    (block $topmost (result i32)
      (local.get $i3)
    )
  )
)
;; CHECK-BIN-NODEBUG:      (export "floats" (func $0))

;; CHECK-BIN-NODEBUG:      (func $0 (type $0) (param $0 f32) (result f32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 f32)
;; CHECK-BIN-NODEBUG-NEXT:  (f32.add
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $1) (param $0 i32) (param $1 i32) (result f32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $2 f32)
;; CHECK-BIN-NODEBUG-NEXT:  (local.tee $2
;; CHECK-BIN-NODEBUG-NEXT:   (f32.neg
;; CHECK-BIN-NODEBUG-NEXT:    (block (result f32)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.store
;; CHECK-BIN-NODEBUG-NEXT:      (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:      (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (f32.load
;; CHECK-BIN-NODEBUG-NEXT:      (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $2) (param $0 i32) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block2 (result i32)
;; CHECK-BIN-NODEBUG-NEXT:   (block $block1
;; CHECK-BIN-NODEBUG-NEXT:    (block $block
;; CHECK-BIN-NODEBUG-NEXT:     (br_table $block $block1 $block
;; CHECK-BIN-NODEBUG-NEXT:      (i32.sub
;; CHECK-BIN-NODEBUG-NEXT:       (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:       (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (br $block2
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (br $block2
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $3 (type $3) (param $0 i32) (param $1 i32) (param $2 i32) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT: )
