;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wat -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wat
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wat
;; RUN: cat %t.text.wat | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wat | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wat | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
  ;; CHECK-TEXT:      (type $5 (func (result i32)))

  ;; CHECK-TEXT:      (type $FUNCSIG$v (func))

  ;; CHECK-TEXT:      (type $FUNCSIG$vf (func (param f32)))
  ;; CHECK-BIN:      (type $5 (func (result i32)))

  ;; CHECK-BIN:      (type $FUNCSIG$v (func))

  ;; CHECK-BIN:      (type $FUNCSIG$vf (func (param f32)))
  (type $FUNCSIG$vf (func (param f32)))
  (type $FUNCSIG$v (func))
  ;; CHECK-TEXT:      (type $4 (func (result f64)))

  ;; CHECK-TEXT:      (type $FUNCSIG$ddd (func (param f64 f64) (result f64)))

  ;; CHECK-TEXT:      (type $FUNCSIG$id (func (param f64) (result i32)))
  ;; CHECK-BIN:      (type $4 (func (result f64)))

  ;; CHECK-BIN:      (type $FUNCSIG$ddd (func (param f64 f64) (result f64)))

  ;; CHECK-BIN:      (type $FUNCSIG$id (func (param f64) (result i32)))
  (type $FUNCSIG$id (func (param f64) (result i32)))
  (type $FUNCSIG$ddd (func (param f64 f64) (result f64)))
  ;; CHECK-BIN-NODEBUG:      (type $0 (func (result i32)))

  ;; CHECK-BIN-NODEBUG:      (type $1 (func))

  ;; CHECK-BIN-NODEBUG:      (type $2 (func (param f32)))

  ;; CHECK-BIN-NODEBUG:      (type $3 (func (result f64)))

  ;; CHECK-BIN-NODEBUG:      (type $4 (func (param f64 f64) (result f64)))
  (type $4 (func (result f64)))
  ;; CHECK-BIN-NODEBUG:      (type $5 (func (param f64) (result i32)))
  (type $5 (func (result i32)))
  ;; CHECK-TEXT:      (type $6 (func (param i32) (result i32)))
  ;; CHECK-BIN:      (type $6 (func (param i32) (result i32)))
  ;; CHECK-BIN-NODEBUG:      (type $6 (func (param i32) (result i32)))
  (type $6 (func (param i32) (result i32)))
  ;; CHECK-TEXT:      (type $7 (func (param f64) (result f64)))
  ;; CHECK-BIN:      (type $7 (func (param f64) (result f64)))
  ;; CHECK-BIN-NODEBUG:      (type $7 (func (param f64) (result f64)))
  (type $7 (func (param f64) (result f64)))
  ;; CHECK-TEXT:      (type $8 (func (result i64)))
  ;; CHECK-BIN:      (type $8 (func (result i64)))
  ;; CHECK-BIN-NODEBUG:      (type $8 (func (result i64)))
  (type $8 (func (result i64)))
  ;; CHECK-TEXT:      (type $9 (func (param i32 i64)))
  ;; CHECK-BIN:      (type $9 (func (param i32 i64)))
  ;; CHECK-BIN-NODEBUG:      (type $9 (func (param i32 i64)))
  (type $9 (func (param i32 i64)))
  ;; CHECK-TEXT:      (import "env" "_emscripten_asm_const_vi" (func $_emscripten_asm_const_vi (type $FUNCSIG$v)))
  ;; CHECK-BIN:      (import "env" "_emscripten_asm_const_vi" (func $_emscripten_asm_const_vi (type $FUNCSIG$v)))
  (import "env" "_emscripten_asm_const_vi" (func $_emscripten_asm_const_vi))
  ;; CHECK-TEXT:      (import "asm2wasm" "f64-to-int" (func $f64-to-int (type $FUNCSIG$id) (param f64) (result i32)))
  ;; CHECK-BIN:      (import "asm2wasm" "f64-to-int" (func $f64-to-int (type $FUNCSIG$id) (param f64) (result i32)))
  (import "asm2wasm" "f64-to-int" (func $f64-to-int (param f64) (result i32)))
  ;; CHECK-TEXT:      (import "asm2wasm" "f64-rem" (func $f64-rem (type $FUNCSIG$ddd) (param f64 f64) (result f64)))
  ;; CHECK-BIN:      (import "asm2wasm" "f64-rem" (func $f64-rem (type $FUNCSIG$ddd) (param f64 f64) (result f64)))
  (import "asm2wasm" "f64-rem" (func $f64-rem (param f64 f64) (result f64)))
  (table 10 funcref)
  (elem (i32.const 0) $z $big_negative $z $z $w $w $importedDoubles $w $z $cneg)
  ;; CHECK-TEXT:      (memory $0 4096 4096)
  ;; CHECK-BIN:      (memory $0 4096 4096)
  ;; CHECK-BIN-NODEBUG:      (import "env" "_emscripten_asm_const_vi" (func $fimport$0 (type $1)))

  ;; CHECK-BIN-NODEBUG:      (import "asm2wasm" "f64-to-int" (func $fimport$1 (type $5) (param f64) (result i32)))

  ;; CHECK-BIN-NODEBUG:      (import "asm2wasm" "f64-rem" (func $fimport$2 (type $4) (param f64 f64) (result f64)))

  ;; CHECK-BIN-NODEBUG:      (memory $0 4096 4096)
  (memory $0 4096 4096)
  (data (i32.const 1026) "\14\00")
  ;; CHECK-TEXT:      (data $0 (i32.const 1026) "\14\00")

  ;; CHECK-TEXT:      (table $0 10 funcref)

  ;; CHECK-TEXT:      (elem $0 (i32.const 0) $z $big_negative $z $z $w $w $importedDoubles $w $z $cneg)

  ;; CHECK-TEXT:      (export "big_negative" (func $big_negative))
  ;; CHECK-BIN:      (data $0 (i32.const 1026) "\14\00")

  ;; CHECK-BIN:      (table $0 10 funcref)

  ;; CHECK-BIN:      (elem $0 (i32.const 0) $z $big_negative $z $z $w $w $importedDoubles $w $z $cneg)

  ;; CHECK-BIN:      (export "big_negative" (func $big_negative))
  (export "big_negative" (func $big_negative))
  ;; CHECK-TEXT:      (func $big_negative (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (local $temp f64)
  ;; CHECK-TEXT-NEXT:  (block $block0
  ;; CHECK-TEXT-NEXT:   (local.set $temp
  ;; CHECK-TEXT-NEXT:    (f64.const -2147483648)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.set $temp
  ;; CHECK-TEXT-NEXT:    (f64.const -2147483648)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.set $temp
  ;; CHECK-TEXT-NEXT:    (f64.const -21474836480)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.set $temp
  ;; CHECK-TEXT-NEXT:    (f64.const 0.039625)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.set $temp
  ;; CHECK-TEXT-NEXT:    (f64.const -0.039625)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $big_negative (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (local $temp f64)
  ;; CHECK-BIN-NEXT:  (local.set $temp
  ;; CHECK-BIN-NEXT:   (f64.const -2147483648)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $temp
  ;; CHECK-BIN-NEXT:   (f64.const -2147483648)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $temp
  ;; CHECK-BIN-NEXT:   (f64.const -21474836480)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $temp
  ;; CHECK-BIN-NEXT:   (f64.const 0.039625)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $temp
  ;; CHECK-BIN-NEXT:   (f64.const -0.039625)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $big_negative (type $FUNCSIG$v)
    (local $temp f64)
    (block $block0
      (local.set $temp
        (f64.const -2147483648)
      )
      (local.set $temp
        (f64.const -2147483648)
      )
      (local.set $temp
        (f64.const -21474836480)
      )
      (local.set $temp
        (f64.const 0.039625)
      )
      (local.set $temp
        (f64.const -0.039625)
      )
    )
  )
  ;; CHECK-TEXT:      (func $importedDoubles (type $4) (result f64)
  ;; CHECK-TEXT-NEXT:  (local $temp f64)
  ;; CHECK-TEXT-NEXT:  (block $topmost (result f64)
  ;; CHECK-TEXT-NEXT:   (local.set $temp
  ;; CHECK-TEXT-NEXT:    (f64.add
  ;; CHECK-TEXT-NEXT:     (f64.add
  ;; CHECK-TEXT-NEXT:      (f64.add
  ;; CHECK-TEXT-NEXT:       (f64.load
  ;; CHECK-TEXT-NEXT:        (i32.const 8)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:       (f64.load
  ;; CHECK-TEXT-NEXT:        (i32.const 16)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (f64.neg
  ;; CHECK-TEXT-NEXT:       (f64.load
  ;; CHECK-TEXT-NEXT:        (i32.const 16)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (f64.neg
  ;; CHECK-TEXT-NEXT:      (f64.load
  ;; CHECK-TEXT-NEXT:       (i32.const 8)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (if
  ;; CHECK-TEXT-NEXT:    (i32.gt_s
  ;; CHECK-TEXT-NEXT:     (i32.load
  ;; CHECK-TEXT-NEXT:      (i32.const 24)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (br $topmost
  ;; CHECK-TEXT-NEXT:      (f64.const -3.4)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (if
  ;; CHECK-TEXT-NEXT:    (f64.gt
  ;; CHECK-TEXT-NEXT:     (f64.load
  ;; CHECK-TEXT-NEXT:      (i32.const 32)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (f64.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (br $topmost
  ;; CHECK-TEXT-NEXT:      (f64.const 5.6)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (f64.const 1.2)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $importedDoubles (type $4) (result f64)
  ;; CHECK-BIN-NEXT:  (local $temp f64)
  ;; CHECK-BIN-NEXT:  (block $block (result f64)
  ;; CHECK-BIN-NEXT:   (local.set $temp
  ;; CHECK-BIN-NEXT:    (f64.add
  ;; CHECK-BIN-NEXT:     (f64.add
  ;; CHECK-BIN-NEXT:      (f64.add
  ;; CHECK-BIN-NEXT:       (f64.load
  ;; CHECK-BIN-NEXT:        (i32.const 8)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:       (f64.load
  ;; CHECK-BIN-NEXT:        (i32.const 16)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (f64.neg
  ;; CHECK-BIN-NEXT:       (f64.load
  ;; CHECK-BIN-NEXT:        (i32.const 16)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (f64.neg
  ;; CHECK-BIN-NEXT:      (f64.load
  ;; CHECK-BIN-NEXT:       (i32.const 8)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (if
  ;; CHECK-BIN-NEXT:    (i32.gt_s
  ;; CHECK-BIN-NEXT:     (i32.load
  ;; CHECK-BIN-NEXT:      (i32.const 24)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (br $block
  ;; CHECK-BIN-NEXT:      (f64.const -3.4)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (if
  ;; CHECK-BIN-NEXT:    (f64.gt
  ;; CHECK-BIN-NEXT:     (f64.load
  ;; CHECK-BIN-NEXT:      (i32.const 32)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (f64.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (br $block
  ;; CHECK-BIN-NEXT:      (f64.const 5.6)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (f64.const 1.2)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $importedDoubles (type $4) (result f64)
    (local $temp f64)
    (block $topmost (result f64)
      (local.set $temp
        (f64.add
          (f64.add
            (f64.add
              (f64.load
                (i32.const 8)
              )
              (f64.load
                (i32.const 16)
              )
            )
            (f64.neg
              (f64.load
                (i32.const 16)
              )
            )
          )
          (f64.neg
            (f64.load
              (i32.const 8)
            )
          )
        )
      )
      (if
        (i32.gt_s
          (i32.load
            (i32.const 24)
          )
          (i32.const 0)
        )
        (then
          (br $topmost
            (f64.const -3.4)
          )
        )
      )
      (if
        (f64.gt
          (f64.load
            (i32.const 32)
          )
          (f64.const 0)
        )
        (then
          (br $topmost
            (f64.const 5.6)
          )
        )
      )
      (f64.const 1.2)
    )
  )
  ;; CHECK-TEXT:      (func $doubleCompares (type $FUNCSIG$ddd) (param $x f64) (param $y f64) (result f64)
  ;; CHECK-TEXT-NEXT:  (local $t f64)
  ;; CHECK-TEXT-NEXT:  (local $Int f64)
  ;; CHECK-TEXT-NEXT:  (local $Double i32)
  ;; CHECK-TEXT-NEXT:  (block $topmost (result f64)
  ;; CHECK-TEXT-NEXT:   (if
  ;; CHECK-TEXT-NEXT:    (f64.gt
  ;; CHECK-TEXT-NEXT:     (local.get $x)
  ;; CHECK-TEXT-NEXT:     (f64.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (br $topmost
  ;; CHECK-TEXT-NEXT:      (f64.const 1.2)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (if
  ;; CHECK-TEXT-NEXT:    (f64.gt
  ;; CHECK-TEXT-NEXT:     (local.get $Int)
  ;; CHECK-TEXT-NEXT:     (f64.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (br $topmost
  ;; CHECK-TEXT-NEXT:      (f64.const -3.4)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (if
  ;; CHECK-TEXT-NEXT:    (i32.gt_s
  ;; CHECK-TEXT-NEXT:     (local.get $Double)
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (br $topmost
  ;; CHECK-TEXT-NEXT:      (f64.const 5.6)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (if
  ;; CHECK-TEXT-NEXT:    (f64.lt
  ;; CHECK-TEXT-NEXT:     (local.get $x)
  ;; CHECK-TEXT-NEXT:     (local.get $y)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (br $topmost
  ;; CHECK-TEXT-NEXT:      (local.get $x)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.get $y)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $doubleCompares (type $FUNCSIG$ddd) (param $x f64) (param $y f64) (result f64)
  ;; CHECK-BIN-NEXT:  (local $t f64)
  ;; CHECK-BIN-NEXT:  (local $Int f64)
  ;; CHECK-BIN-NEXT:  (local $Double i32)
  ;; CHECK-BIN-NEXT:  (block $block (result f64)
  ;; CHECK-BIN-NEXT:   (if
  ;; CHECK-BIN-NEXT:    (f64.gt
  ;; CHECK-BIN-NEXT:     (local.get $x)
  ;; CHECK-BIN-NEXT:     (f64.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (br $block
  ;; CHECK-BIN-NEXT:      (f64.const 1.2)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (if
  ;; CHECK-BIN-NEXT:    (f64.gt
  ;; CHECK-BIN-NEXT:     (local.get $Int)
  ;; CHECK-BIN-NEXT:     (f64.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (br $block
  ;; CHECK-BIN-NEXT:      (f64.const -3.4)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (if
  ;; CHECK-BIN-NEXT:    (i32.gt_s
  ;; CHECK-BIN-NEXT:     (local.get $Double)
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (br $block
  ;; CHECK-BIN-NEXT:      (f64.const 5.6)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (if
  ;; CHECK-BIN-NEXT:    (f64.lt
  ;; CHECK-BIN-NEXT:     (local.get $x)
  ;; CHECK-BIN-NEXT:     (local.get $y)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (then
  ;; CHECK-BIN-NEXT:     (br $block
  ;; CHECK-BIN-NEXT:      (local.get $x)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (local.get $y)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $doubleCompares (type $FUNCSIG$ddd) (param $x f64) (param $y f64) (result f64)
    (local $t f64)
    (local $Int f64)
    (local $Double i32)
    (block $topmost (result f64)
      (if
        (f64.gt
          (local.get $x)
          (f64.const 0)
        )
        (then
          (br $topmost
            (f64.const 1.2)
          )
        )
      )
      (if
        (f64.gt
          (local.get $Int)
          (f64.const 0)
        )
        (then
          (br $topmost
            (f64.const -3.4)
          )
        )
      )
      (if
        (i32.gt_s
          (local.get $Double)
          (i32.const 0)
        )
        (then
          (br $topmost
            (f64.const 5.6)
          )
        )
      )
      (if
        (f64.lt
          (local.get $x)
          (local.get $y)
        )
        (then
          (br $topmost
            (local.get $x)
          )
        )
      )
      (local.get $y)
    )
  )
  ;; CHECK-TEXT:      (func $intOps (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (local $x i32)
  ;; CHECK-TEXT-NEXT:  (i32.eq
  ;; CHECK-TEXT-NEXT:   (local.get $x)
  ;; CHECK-TEXT-NEXT:   (i32.const 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $intOps (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (local $x i32)
  ;; CHECK-BIN-NEXT:  (i32.eq
  ;; CHECK-BIN-NEXT:   (local.get $x)
  ;; CHECK-BIN-NEXT:   (i32.const 0)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $intOps (type $5) (result i32)
    (local $x i32)
    (i32.eq
      (local.get $x)
      (i32.const 0)
    )
  )
  ;; CHECK-TEXT:      (func $hexLiterals (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (i32.add
  ;; CHECK-TEXT-NEXT:    (i32.add
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:     (i32.const 313249263)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (i32.const -19088752)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $hexLiterals (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.add
  ;; CHECK-BIN-NEXT:    (i32.add
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:     (i32.const 313249263)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (i32.const -19088752)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $hexLiterals (type $FUNCSIG$v)
    (drop
      (i32.add
        (i32.add
          (i32.const 0)
          (i32.const 313249263)
        )
        (i32.const -19088752)
      )
    )
  )
  ;; CHECK-TEXT:      (func $conversions (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (local $i i32)
  ;; CHECK-TEXT-NEXT:  (local $d f64)
  ;; CHECK-TEXT-NEXT:  (block $block0
  ;; CHECK-TEXT-NEXT:   (local.set $i
  ;; CHECK-TEXT-NEXT:    (call $f64-to-int
  ;; CHECK-TEXT-NEXT:     (local.get $d)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.set $d
  ;; CHECK-TEXT-NEXT:    (f64.convert_i32_s
  ;; CHECK-TEXT-NEXT:     (local.get $i)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.set $d
  ;; CHECK-TEXT-NEXT:    (f64.convert_i32_u
  ;; CHECK-TEXT-NEXT:     (i32.shr_u
  ;; CHECK-TEXT-NEXT:      (local.get $i)
  ;; CHECK-TEXT-NEXT:      (i32.const 0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $conversions (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (local $i i32)
  ;; CHECK-BIN-NEXT:  (local $d f64)
  ;; CHECK-BIN-NEXT:  (local.set $i
  ;; CHECK-BIN-NEXT:   (call $f64-to-int
  ;; CHECK-BIN-NEXT:    (local.get $d)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $d
  ;; CHECK-BIN-NEXT:   (f64.convert_i32_s
  ;; CHECK-BIN-NEXT:    (local.get $i)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $d
  ;; CHECK-BIN-NEXT:   (f64.convert_i32_u
  ;; CHECK-BIN-NEXT:    (i32.shr_u
  ;; CHECK-BIN-NEXT:     (local.get $i)
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $conversions (type $FUNCSIG$v)
    (local $i i32)
    (local $d f64)
    (block $block0
      (local.set $i
        (call $f64-to-int
          (local.get $d)
        )
      )
      (local.set $d
        (f64.convert_i32_s
          (local.get $i)
        )
      )
      (local.set $d
        (f64.convert_i32_u
          (i32.shr_u
            (local.get $i)
            (i32.const 0)
          )
        )
      )
    )
  )
  ;; CHECK-TEXT:      (func $seq (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (local $J f64)
  ;; CHECK-TEXT-NEXT:  (local.set $J
  ;; CHECK-TEXT-NEXT:   (f64.sub
  ;; CHECK-TEXT-NEXT:    (block $block0 (result f64)
  ;; CHECK-TEXT-NEXT:     (drop
  ;; CHECK-TEXT-NEXT:      (f64.const 0.1)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (f64.const 5.1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (block $block1 (result f64)
  ;; CHECK-TEXT-NEXT:     (drop
  ;; CHECK-TEXT-NEXT:      (f64.const 3.2)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (f64.const 4.2)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $seq (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (local $J f64)
  ;; CHECK-BIN-NEXT:  (local.set $J
  ;; CHECK-BIN-NEXT:   (f64.sub
  ;; CHECK-BIN-NEXT:    (block (result f64)
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (f64.const 0.1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (f64.const 5.1)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (block (result f64)
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (f64.const 3.2)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (f64.const 4.2)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $seq (type $FUNCSIG$v)
    (local $J f64)
    (local.set $J
      (f64.sub
        (block $block0 (result f64)
          (drop
            (f64.const 0.1)
          )
          (f64.const 5.1)
        )
        (block $block1 (result f64)
          (drop
            (f64.const 3.2)
          )
          (f64.const 4.2)
        )
      )
    )
  )
  ;; CHECK-TEXT:      (func $switcher (type $6) (param $x i32) (result i32)
  ;; CHECK-TEXT-NEXT:  (block $topmost (result i32)
  ;; CHECK-TEXT-NEXT:   (block $switch$0
  ;; CHECK-TEXT-NEXT:    (block $switch-default$3
  ;; CHECK-TEXT-NEXT:     (block $switch-case$2
  ;; CHECK-TEXT-NEXT:      (block $switch-case$1
  ;; CHECK-TEXT-NEXT:       (br_table $switch-case$1 $switch-case$2 $switch-default$3
  ;; CHECK-TEXT-NEXT:        (i32.sub
  ;; CHECK-TEXT-NEXT:         (local.get $x)
  ;; CHECK-TEXT-NEXT:         (i32.const 1)
  ;; CHECK-TEXT-NEXT:        )
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (br $topmost
  ;; CHECK-TEXT-NEXT:       (i32.const 1)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (br $topmost
  ;; CHECK-TEXT-NEXT:      (i32.const 2)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (block $switch$4
  ;; CHECK-TEXT-NEXT:    (block $switch-default$7
  ;; CHECK-TEXT-NEXT:     (block $switch-case$6
  ;; CHECK-TEXT-NEXT:      (block $switch-case$5
  ;; CHECK-TEXT-NEXT:       (br_table $switch-case$6 $switch-default$7 $switch-default$7 $switch-default$7 $switch-default$7 $switch-default$7 $switch-default$7 $switch-case$5 $switch-default$7
  ;; CHECK-TEXT-NEXT:        (i32.sub
  ;; CHECK-TEXT-NEXT:         (local.get $x)
  ;; CHECK-TEXT-NEXT:         (i32.const 5)
  ;; CHECK-TEXT-NEXT:        )
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (br $topmost
  ;; CHECK-TEXT-NEXT:       (i32.const 121)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (br $topmost
  ;; CHECK-TEXT-NEXT:      (i32.const 51)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (block $label$break$Lout
  ;; CHECK-TEXT-NEXT:    (block $switch-default$16
  ;; CHECK-TEXT-NEXT:     (block $switch-case$15
  ;; CHECK-TEXT-NEXT:      (block $switch-case$12
  ;; CHECK-TEXT-NEXT:       (block $switch-case$9
  ;; CHECK-TEXT-NEXT:        (block $switch-case$8
  ;; CHECK-TEXT-NEXT:         (br_table $switch-case$15 $switch-default$16 $switch-default$16 $switch-case$12 $switch-default$16 $switch-default$16 $switch-default$16 $switch-default$16 $switch-case$9 $switch-default$16 $switch-case$8 $switch-default$16
  ;; CHECK-TEXT-NEXT:          (i32.sub
  ;; CHECK-TEXT-NEXT:           (local.get $x)
  ;; CHECK-TEXT-NEXT:           (i32.const 2)
  ;; CHECK-TEXT-NEXT:          )
  ;; CHECK-TEXT-NEXT:         )
  ;; CHECK-TEXT-NEXT:        )
  ;; CHECK-TEXT-NEXT:        (br $label$break$Lout)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:       (br $label$break$Lout)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (block $while-out$10
  ;; CHECK-TEXT-NEXT:       (loop $while-in$11
  ;; CHECK-TEXT-NEXT:        (block $block1
  ;; CHECK-TEXT-NEXT:         (br $while-out$10)
  ;; CHECK-TEXT-NEXT:         (br $while-in$11)
  ;; CHECK-TEXT-NEXT:        )
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:       (br $label$break$Lout)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (block $while-out$13
  ;; CHECK-TEXT-NEXT:      (loop $while-in$14
  ;; CHECK-TEXT-NEXT:       (block $block3
  ;; CHECK-TEXT-NEXT:        (br $label$break$Lout)
  ;; CHECK-TEXT-NEXT:        (br $while-in$14)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (br $label$break$Lout)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (i32.const 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $switcher (type $6) (param $x i32) (result i32)
  ;; CHECK-BIN-NEXT:  (block $block3 (result i32)
  ;; CHECK-BIN-NEXT:   (block
  ;; CHECK-BIN-NEXT:    (block $block2
  ;; CHECK-BIN-NEXT:     (block $block1
  ;; CHECK-BIN-NEXT:      (block $block
  ;; CHECK-BIN-NEXT:       (br_table $block $block1 $block2
  ;; CHECK-BIN-NEXT:        (i32.sub
  ;; CHECK-BIN-NEXT:         (local.get $x)
  ;; CHECK-BIN-NEXT:         (i32.const 1)
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (br $block3
  ;; CHECK-BIN-NEXT:       (i32.const 1)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (br $block3
  ;; CHECK-BIN-NEXT:      (i32.const 2)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (nop)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (block
  ;; CHECK-BIN-NEXT:    (block $block5
  ;; CHECK-BIN-NEXT:     (block $block4
  ;; CHECK-BIN-NEXT:      (block $block6
  ;; CHECK-BIN-NEXT:       (br_table $block4 $block5 $block5 $block5 $block5 $block5 $block5 $block6 $block5
  ;; CHECK-BIN-NEXT:        (i32.sub
  ;; CHECK-BIN-NEXT:         (local.get $x)
  ;; CHECK-BIN-NEXT:         (i32.const 5)
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (br $block3
  ;; CHECK-BIN-NEXT:       (i32.const 121)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (br $block3
  ;; CHECK-BIN-NEXT:      (i32.const 51)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (nop)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (block $block12
  ;; CHECK-BIN-NEXT:    (block $block8
  ;; CHECK-BIN-NEXT:     (block $block7
  ;; CHECK-BIN-NEXT:      (block $block9
  ;; CHECK-BIN-NEXT:       (block $block10
  ;; CHECK-BIN-NEXT:        (block $block11
  ;; CHECK-BIN-NEXT:         (br_table $block7 $block8 $block8 $block9 $block8 $block8 $block8 $block8 $block10 $block8 $block11 $block8
  ;; CHECK-BIN-NEXT:          (i32.sub
  ;; CHECK-BIN-NEXT:           (local.get $x)
  ;; CHECK-BIN-NEXT:           (i32.const 2)
  ;; CHECK-BIN-NEXT:          )
  ;; CHECK-BIN-NEXT:         )
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:        (br $block12)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:       (br $block12)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (block $block13
  ;; CHECK-BIN-NEXT:       (loop
  ;; CHECK-BIN-NEXT:        (br $block13)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:       (unreachable)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (block
  ;; CHECK-BIN-NEXT:      (loop
  ;; CHECK-BIN-NEXT:       (br $block12)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (unreachable)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (unreachable)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (nop)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (i32.const 0)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $switcher (type $6) (param $x i32) (result i32)
    (block $topmost (result i32)
      (block $switch$0
        (block $switch-default$3
          (block $switch-case$2
            (block $switch-case$1
              (br_table $switch-case$1 $switch-case$2 $switch-default$3
                (i32.sub
                  (local.get $x)
                  (i32.const 1)
                )
              )
            )
            (br $topmost
              (i32.const 1)
            )
          )
          (br $topmost
            (i32.const 2)
          )
        )
        (nop)
      )
      (block $switch$4
        (block $switch-default$7
          (block $switch-case$6
            (block $switch-case$5
              (br_table $switch-case$6 $switch-default$7 $switch-default$7 $switch-default$7 $switch-default$7 $switch-default$7 $switch-default$7 $switch-case$5 $switch-default$7
                (i32.sub
                  (local.get $x)
                  (i32.const 5)
                )
              )
            )
            (br $topmost
              (i32.const 121)
            )
          )
          (br $topmost
            (i32.const 51)
          )
        )
        (nop)
      )
      (block $label$break$Lout
        (block $switch-default$16
          (block $switch-case$15
            (block $switch-case$12
              (block $switch-case$9
                (block $switch-case$8
                  (br_table $switch-case$15 $switch-default$16 $switch-default$16 $switch-case$12 $switch-default$16 $switch-default$16 $switch-default$16 $switch-default$16 $switch-case$9 $switch-default$16 $switch-case$8 $switch-default$16
                    (i32.sub
                      (local.get $x)
                      (i32.const 2)
                    )
                  )
                )
                (br $label$break$Lout)
              )
              (br $label$break$Lout)
            )
            (block $while-out$10
              (loop $while-in$11
                (block $block1
                  (br $while-out$10)
                  (br $while-in$11)
                )
              )
              (br $label$break$Lout)
            )
          )
          (block $while-out$13
            (loop $while-in$14
              (block $block3
                (br $label$break$Lout)
                (br $while-in$14)
              )
            )
            (br $label$break$Lout)
          )
        )
        (nop)
      )
      (i32.const 0)
    )
  )
  ;; CHECK-TEXT:      (func $blocker (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (block $label$break$L
  ;; CHECK-TEXT-NEXT:   (br $label$break$L)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $blocker (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (block $block
  ;; CHECK-BIN-NEXT:   (br $block)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $blocker (type $FUNCSIG$v)
    (block $label$break$L
      (br $label$break$L)
    )
  )
  ;; CHECK-TEXT:      (func $frem (type $4) (result f64)
  ;; CHECK-TEXT-NEXT:  (call $f64-rem
  ;; CHECK-TEXT-NEXT:   (f64.const 5.5)
  ;; CHECK-TEXT-NEXT:   (f64.const 1.2)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $frem (type $4) (result f64)
  ;; CHECK-BIN-NEXT:  (call $f64-rem
  ;; CHECK-BIN-NEXT:   (f64.const 5.5)
  ;; CHECK-BIN-NEXT:   (f64.const 1.2)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $frem (type $4) (result f64)
    (call $f64-rem
      (f64.const 5.5)
      (f64.const 1.2)
    )
  )
  ;; CHECK-TEXT:      (func $big_uint_div_u (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (local $x i32)
  ;; CHECK-TEXT-NEXT:  (block $topmost (result i32)
  ;; CHECK-TEXT-NEXT:   (local.set $x
  ;; CHECK-TEXT-NEXT:    (i32.and
  ;; CHECK-TEXT-NEXT:     (i32.div_u
  ;; CHECK-TEXT-NEXT:      (i32.const -1)
  ;; CHECK-TEXT-NEXT:      (i32.const 2)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (i32.const -1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.get $x)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $big_uint_div_u (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (local $x i32)
  ;; CHECK-BIN-NEXT:  (local.set $x
  ;; CHECK-BIN-NEXT:   (i32.and
  ;; CHECK-BIN-NEXT:    (i32.div_u
  ;; CHECK-BIN-NEXT:     (i32.const -1)
  ;; CHECK-BIN-NEXT:     (i32.const 2)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (i32.const -1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.get $x)
  ;; CHECK-BIN-NEXT: )
  (func $big_uint_div_u (type $5) (result i32)
    (local $x i32)
    (block $topmost (result i32)
      (local.set $x
        (i32.and
          (i32.div_u
            (i32.const -1)
            (i32.const 2)
          )
          (i32.const -1)
        )
      )
      (local.get $x)
    )
  )
  ;; CHECK-TEXT:      (func $fr (type $FUNCSIG$vf) (param $x f32)
  ;; CHECK-TEXT-NEXT:  (local $y f32)
  ;; CHECK-TEXT-NEXT:  (local $z f64)
  ;; CHECK-TEXT-NEXT:  (block $block0
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.demote_f64
  ;; CHECK-TEXT-NEXT:     (local.get $z)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (local.get $y)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.const 5)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.const 0)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.const 5)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (f32.const 0)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $fr (type $FUNCSIG$vf) (param $x f32)
  ;; CHECK-BIN-NEXT:  (local $y f32)
  ;; CHECK-BIN-NEXT:  (local $z f64)
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.demote_f64
  ;; CHECK-BIN-NEXT:    (local.get $z)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (local.get $y)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.const 5)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.const 0)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.const 5)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (f32.const 0)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $fr (type $FUNCSIG$vf) (param $x f32)
    (local $y f32)
    (local $z f64)
    (block $block0
      (drop
        (f32.demote_f64
          (local.get $z)
        )
      )
      (drop
        (local.get $y)
      )
      (drop
        (f32.const 5)
      )
      (drop
        (f32.const 0)
      )
      (drop
        (f32.const 5)
      )
      (drop
        (f32.const 0)
      )
    )
  )
  ;; CHECK-TEXT:      (func $negZero (type $4) (result f64)
  ;; CHECK-TEXT-NEXT:  (f64.const -0)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $negZero (type $4) (result f64)
  ;; CHECK-BIN-NEXT:  (f64.const -0)
  ;; CHECK-BIN-NEXT: )
  (func $negZero (type $4) (result f64)
    (f64.const -0)
  )
  ;; CHECK-TEXT:      (func $abs (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (local $x i32)
  ;; CHECK-TEXT-NEXT:  (local $y f64)
  ;; CHECK-TEXT-NEXT:  (local $z f32)
  ;; CHECK-TEXT-NEXT:  (local $asm2wasm_i32_temp i32)
  ;; CHECK-TEXT-NEXT:  (block $block0
  ;; CHECK-TEXT-NEXT:   (local.set $x
  ;; CHECK-TEXT-NEXT:    (block $block1 (result i32)
  ;; CHECK-TEXT-NEXT:     (local.set $asm2wasm_i32_temp
  ;; CHECK-TEXT-NEXT:      (i32.const 0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (select
  ;; CHECK-TEXT-NEXT:      (i32.sub
  ;; CHECK-TEXT-NEXT:       (i32.const 0)
  ;; CHECK-TEXT-NEXT:       (local.get $asm2wasm_i32_temp)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (local.get $asm2wasm_i32_temp)
  ;; CHECK-TEXT-NEXT:      (i32.lt_s
  ;; CHECK-TEXT-NEXT:       (local.get $asm2wasm_i32_temp)
  ;; CHECK-TEXT-NEXT:       (i32.const 0)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.set $y
  ;; CHECK-TEXT-NEXT:    (f64.abs
  ;; CHECK-TEXT-NEXT:     (f64.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.set $z
  ;; CHECK-TEXT-NEXT:    (f32.abs
  ;; CHECK-TEXT-NEXT:     (f32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $abs (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (local $x i32)
  ;; CHECK-BIN-NEXT:  (local $asm2wasm_i32_temp i32)
  ;; CHECK-BIN-NEXT:  (local $y f64)
  ;; CHECK-BIN-NEXT:  (local $z f32)
  ;; CHECK-BIN-NEXT:  (local.set $x
  ;; CHECK-BIN-NEXT:   (block (result i32)
  ;; CHECK-BIN-NEXT:    (local.set $asm2wasm_i32_temp
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (select
  ;; CHECK-BIN-NEXT:     (i32.sub
  ;; CHECK-BIN-NEXT:      (i32.const 0)
  ;; CHECK-BIN-NEXT:      (local.get $asm2wasm_i32_temp)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (local.get $asm2wasm_i32_temp)
  ;; CHECK-BIN-NEXT:     (i32.lt_s
  ;; CHECK-BIN-NEXT:      (local.get $asm2wasm_i32_temp)
  ;; CHECK-BIN-NEXT:      (i32.const 0)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $y
  ;; CHECK-BIN-NEXT:   (f64.abs
  ;; CHECK-BIN-NEXT:    (f64.const 0)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (local.set $z
  ;; CHECK-BIN-NEXT:   (f32.abs
  ;; CHECK-BIN-NEXT:    (f32.const 0)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $abs (type $FUNCSIG$v)
    (local $x i32)
    (local $y f64)
    (local $z f32)
    (local $asm2wasm_i32_temp i32)
    (block $block0
      (local.set $x
        (block $block1 (result i32)
          (local.set $asm2wasm_i32_temp
            (i32.const 0)
          )
          (select
            (i32.sub
              (i32.const 0)
              (local.get $asm2wasm_i32_temp)
            )
            (local.get $asm2wasm_i32_temp)
            (i32.lt_s
              (local.get $asm2wasm_i32_temp)
              (i32.const 0)
            )
          )
        )
      )
      (local.set $y
        (f64.abs
          (f64.const 0)
        )
      )
      (local.set $z
        (f32.abs
          (f32.const 0)
        )
      )
    )
  )
  ;; CHECK-TEXT:      (func $neg (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (local $x f32)
  ;; CHECK-TEXT-NEXT:  (block $block0
  ;; CHECK-TEXT-NEXT:   (local.set $x
  ;; CHECK-TEXT-NEXT:    (f32.neg
  ;; CHECK-TEXT-NEXT:     (local.get $x)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (call_indirect $0 (type $FUNCSIG$vf)
  ;; CHECK-TEXT-NEXT:    (local.get $x)
  ;; CHECK-TEXT-NEXT:    (i32.add
  ;; CHECK-TEXT-NEXT:     (i32.and
  ;; CHECK-TEXT-NEXT:      (i32.const 1)
  ;; CHECK-TEXT-NEXT:      (i32.const 7)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (i32.const 8)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $neg (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (local $x f32)
  ;; CHECK-BIN-NEXT:  (local.set $x
  ;; CHECK-BIN-NEXT:   (f32.neg
  ;; CHECK-BIN-NEXT:    (local.get $x)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $FUNCSIG$vf)
  ;; CHECK-BIN-NEXT:   (local.get $x)
  ;; CHECK-BIN-NEXT:   (i32.add
  ;; CHECK-BIN-NEXT:    (i32.and
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:     (i32.const 7)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (i32.const 8)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $neg (type $FUNCSIG$v)
    (local $x f32)
    (block $block0
      (local.set $x
        (f32.neg
          (local.get $x)
        )
      )
      (call_indirect (type $FUNCSIG$vf)
        (local.get $x)
        (i32.add
          (i32.and
            (i32.const 1)
            (i32.const 7)
          )
          (i32.const 8)
        )
      )
    )
  )
  ;; CHECK-TEXT:      (func $cneg (type $FUNCSIG$vf) (param $x f32)
  ;; CHECK-TEXT-NEXT:  (call_indirect $0 (type $FUNCSIG$vf)
  ;; CHECK-TEXT-NEXT:   (local.get $x)
  ;; CHECK-TEXT-NEXT:   (i32.add
  ;; CHECK-TEXT-NEXT:    (i32.and
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:     (i32.const 7)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (i32.const 8)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $cneg (type $FUNCSIG$vf) (param $x f32)
  ;; CHECK-BIN-NEXT:  (call_indirect $0 (type $FUNCSIG$vf)
  ;; CHECK-BIN-NEXT:   (local.get $x)
  ;; CHECK-BIN-NEXT:   (i32.add
  ;; CHECK-BIN-NEXT:    (i32.and
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:     (i32.const 7)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (i32.const 8)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $cneg (type $FUNCSIG$vf) (param $x f32)
    (call_indirect (type $FUNCSIG$vf)
      (local.get $x)
      (i32.add
        (i32.and
          (i32.const 1)
          (i32.const 7)
        )
        (i32.const 8)
      )
    )
  )
  ;; CHECK-TEXT:      (func $___syscall_ret (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (local $$0 i32)
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (i32.gt_u
  ;; CHECK-TEXT-NEXT:    (i32.shr_u
  ;; CHECK-TEXT-NEXT:     (local.get $$0)
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (i32.const -4096)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $___syscall_ret (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (local $$0 i32)
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.gt_u
  ;; CHECK-BIN-NEXT:    (i32.shr_u
  ;; CHECK-BIN-NEXT:     (local.get $$0)
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (i32.const -4096)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $___syscall_ret (type $FUNCSIG$v)
    (local $$0 i32)
    (drop
      (i32.gt_u
        (i32.shr_u
          (local.get $$0)
          (i32.const 0)
        )
        (i32.const -4096)
      )
    )
  )
  ;; CHECK-TEXT:      (func $z (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (nop)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $z (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (nop)
  ;; CHECK-BIN-NEXT: )
  (func $z (type $FUNCSIG$v)
    (nop)
  )
  ;; CHECK-TEXT:      (func $w (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (nop)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $w (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (nop)
  ;; CHECK-BIN-NEXT: )
  (func $w (type $FUNCSIG$v)
    (nop)
  )
  ;; CHECK-TEXT:      (func $block_and_after (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (block $waka
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (br $waka)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (i32.const 0)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $block_and_after (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (block $block
  ;; CHECK-BIN-NEXT:   (drop
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (br $block)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (i32.const 0)
  ;; CHECK-BIN-NEXT: )
  (func $block_and_after (type $5) (result i32)
    (block $waka
      (drop
        (i32.const 1)
      )
      (br $waka)
    )
    (i32.const 0)
  )
  ;; CHECK-TEXT:      (func $loop-roundtrip (type $7) (param $0 f64) (result f64)
  ;; CHECK-TEXT-NEXT:  (loop $loop-in1 (result f64)
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (local.get $0)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (local.get $0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $loop-roundtrip (type $7) (param $0 f64) (result f64)
  ;; CHECK-BIN-NEXT:  (loop (result f64)
  ;; CHECK-BIN-NEXT:   (drop
  ;; CHECK-BIN-NEXT:    (local.get $0)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (local.get $0)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $loop-roundtrip (type $7) (param $0 f64) (result f64)
    (loop $loop-in1 (result f64)
      (drop
        (local.get $0)
      )
      (local.get $0)
    )
  )
  ;; CHECK-TEXT:      (func $big-i64 (type $8) (result i64)
  ;; CHECK-TEXT-NEXT:  (i64.const -9218868437227405313)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $big-i64 (type $8) (result i64)
  ;; CHECK-BIN-NEXT:  (i64.const -9218868437227405313)
  ;; CHECK-BIN-NEXT: )
  (func $big-i64 (type $8) (result i64)
    (i64.const -9218868437227405313)
  )
  ;; CHECK-TEXT:      (func $i64-store32 (type $9) (param $0 i32) (param $1 i64)
  ;; CHECK-TEXT-NEXT:  (i64.store32
  ;; CHECK-TEXT-NEXT:   (local.get $0)
  ;; CHECK-TEXT-NEXT:   (local.get $1)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $i64-store32 (type $9) (param $0 i32) (param $1 i64)
  ;; CHECK-BIN-NEXT:  (i64.store32
  ;; CHECK-BIN-NEXT:   (local.get $0)
  ;; CHECK-BIN-NEXT:   (local.get $1)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $i64-store32 (type $9) (param $0 i32) (param $1 i64)
    (i64.store32
      (local.get $0)
      (local.get $1)
    )
  )
  ;; CHECK-TEXT:      (func $return-unreachable (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $return-unreachable (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (return
  ;; CHECK-BIN-NEXT:   (i32.const 1)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $return-unreachable (result i32)
    (return (i32.const 1))
  )
  ;; CHECK-TEXT:      (func $unreachable-block (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (f64.abs
  ;; CHECK-TEXT-NEXT:   (block
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (return
  ;; CHECK-TEXT-NEXT:     (i32.const 2)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-block (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.const 1)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (return
  ;; CHECK-BIN-NEXT:   (i32.const 2)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-block (result i32)
    (f64.abs
      (block ;; note no type - valid in binaryen IR, in wasm must be i32
        (drop (i32.const 1))
        (return (i32.const 2))
      )
    )
  )
  ;; CHECK-TEXT:      (func $unreachable-block-toplevel (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (drop
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (i32.const 2)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-block-toplevel (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (drop
  ;; CHECK-BIN-NEXT:   (i32.const 1)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (return
  ;; CHECK-BIN-NEXT:   (i32.const 2)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-block-toplevel (result i32)
    (block ;; note no type - valid in binaryen IR, in wasm must be i32
      (drop (i32.const 1))
      (return (i32.const 2))
    )
  )
  ;; CHECK-TEXT:      (func $unreachable-block0 (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (f64.abs
  ;; CHECK-TEXT-NEXT:   (block
  ;; CHECK-TEXT-NEXT:    (return
  ;; CHECK-TEXT-NEXT:     (i32.const 2)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-block0 (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (return
  ;; CHECK-BIN-NEXT:   (i32.const 2)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-block0 (result i32)
    (f64.abs
      (block ;; note no type - valid in binaryen IR, in wasm must be i32
        (return (i32.const 2))
      )
    )
  )
  ;; CHECK-TEXT:      (func $unreachable-block0-toplevel (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (return
  ;; CHECK-TEXT-NEXT:   (i32.const 2)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-block0-toplevel (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (return
  ;; CHECK-BIN-NEXT:   (i32.const 2)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-block0-toplevel (result i32)
    (block ;; note no type - valid in binaryen IR, in wasm must be i32
      (return (i32.const 2))
    )
  )
  ;; CHECK-TEXT:      (func $unreachable-block-with-br (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (block $block
  ;; CHECK-TEXT-NEXT:   (drop
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (br $block)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (i32.const 1)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-block-with-br (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (block $block
  ;; CHECK-BIN-NEXT:   (drop
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (br $block)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (i32.const 1)
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-block-with-br (result i32)
    (block $block ;; unreachable type due to last element having that type, but the block is exitable
      (drop (i32.const 1))
      (br $block)
    )
    (i32.const 1)
  )
  ;; CHECK-TEXT:      (func $unreachable-if (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (f64.abs
  ;; CHECK-TEXT-NEXT:   (if
  ;; CHECK-TEXT-NEXT:    (i32.const 3)
  ;; CHECK-TEXT-NEXT:    (then
  ;; CHECK-TEXT-NEXT:     (return
  ;; CHECK-TEXT-NEXT:      (i32.const 2)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (else
  ;; CHECK-TEXT-NEXT:     (return
  ;; CHECK-TEXT-NEXT:      (i32.const 1)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-if (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (if
  ;; CHECK-BIN-NEXT:   (i32.const 3)
  ;; CHECK-BIN-NEXT:   (then
  ;; CHECK-BIN-NEXT:    (return
  ;; CHECK-BIN-NEXT:     (i32.const 2)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (else
  ;; CHECK-BIN-NEXT:    (return
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-if (result i32)
    (f64.abs
      (if ;; note no type - valid in binaryen IR, in wasm must be i32
        (i32.const 3)
        (then
          (return (i32.const 2))
        )
        (else
          (return (i32.const 1))
        )
      )
    )
  )
  ;; CHECK-TEXT:      (func $unreachable-if-toplevel (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (i32.const 3)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (return
  ;; CHECK-TEXT-NEXT:     (i32.const 2)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (else
  ;; CHECK-TEXT-NEXT:    (return
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-if-toplevel (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (if
  ;; CHECK-BIN-NEXT:   (i32.const 3)
  ;; CHECK-BIN-NEXT:   (then
  ;; CHECK-BIN-NEXT:    (return
  ;; CHECK-BIN-NEXT:     (i32.const 2)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (else
  ;; CHECK-BIN-NEXT:    (return
  ;; CHECK-BIN-NEXT:     (i32.const 1)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-if-toplevel (result i32)
    (if ;; note no type - valid in binaryen IR, in wasm must be i32
      (i32.const 3)
      (then
        (return (i32.const 2))
      )
      (else
        (return (i32.const 1))
      )
    )
  )
  ;; CHECK-TEXT:      (func $unreachable-loop (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (f64.abs
  ;; CHECK-TEXT-NEXT:   (loop
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:    (return
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-loop (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (loop
  ;; CHECK-BIN-NEXT:   (nop)
  ;; CHECK-BIN-NEXT:   (return
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-loop (result i32)
    (f64.abs
      (loop ;; note no type - valid in binaryen IR, in wasm must be i32
        (nop)
        (return (i32.const 1))
      )
    )
  )
  ;; CHECK-TEXT:      (func $unreachable-loop0 (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (f64.abs
  ;; CHECK-TEXT-NEXT:   (loop
  ;; CHECK-TEXT-NEXT:    (return
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-loop0 (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (loop
  ;; CHECK-BIN-NEXT:   (return
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-loop0 (result i32)
    (f64.abs
      (loop ;; note no type - valid in binaryen IR, in wasm must be i32
        (return (i32.const 1))
      )
    )
  )
  ;; CHECK-TEXT:      (func $unreachable-loop-toplevel (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (loop
  ;; CHECK-TEXT-NEXT:   (nop)
  ;; CHECK-TEXT-NEXT:   (return
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-loop-toplevel (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (loop
  ;; CHECK-BIN-NEXT:   (nop)
  ;; CHECK-BIN-NEXT:   (return
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-loop-toplevel (result i32)
    (loop ;; note no type - valid in binaryen IR, in wasm must be i32
      (nop)
      (return (i32.const 1))
    )
  )
  ;; CHECK-TEXT:      (func $unreachable-loop0-toplevel (type $5) (result i32)
  ;; CHECK-TEXT-NEXT:  (loop
  ;; CHECK-TEXT-NEXT:   (return
  ;; CHECK-TEXT-NEXT:    (i32.const 1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-loop0-toplevel (type $5) (result i32)
  ;; CHECK-BIN-NEXT:  (loop
  ;; CHECK-BIN-NEXT:   (return
  ;; CHECK-BIN-NEXT:    (i32.const 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-loop0-toplevel (result i32)
    (loop ;; note no type - valid in binaryen IR, in wasm must be i32
      (return (i32.const 1))
    )
  )
  ;; CHECK-TEXT:      (func $unreachable-ifs (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (else
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (else
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (else
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (unreachable)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (else
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (else
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (else
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (else
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-ifs (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-ifs
    (if (unreachable) (then (nop)))
    (if (unreachable) (then (unreachable)))
    (if (unreachable) (then (nop) )(else (nop)))
    (if (unreachable) (then (unreachable) )(else (nop)))
    (if (unreachable) (then (nop) )(else (unreachable)))
    (if (unreachable) (then (unreachable) )(else (unreachable)))
    ;;
    (if (i32.const 1) (then (unreachable) )(else (nop)))
    (if (i32.const 1) (then (nop) )(else (unreachable)))
    (if (i32.const 1) (then (unreachable) )(else (unreachable)))
  )
  ;; CHECK-TEXT:      (func $unreachable-if-arm (type $FUNCSIG$v)
  ;; CHECK-TEXT-NEXT:  (if
  ;; CHECK-TEXT-NEXT:   (i32.const 1)
  ;; CHECK-TEXT-NEXT:   (then
  ;; CHECK-TEXT-NEXT:    (nop)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (else
  ;; CHECK-TEXT-NEXT:    (unreachable)
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (i32.const 1)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $unreachable-if-arm (type $FUNCSIG$v)
  ;; CHECK-BIN-NEXT:  (if
  ;; CHECK-BIN-NEXT:   (i32.const 1)
  ;; CHECK-BIN-NEXT:   (then
  ;; CHECK-BIN-NEXT:    (nop)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (else
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $unreachable-if-arm
    (if
      (i32.const 1)
      (then
        (block
          (nop)
        )
      )
      (else
        (block
          (unreachable)
          (drop
            (i32.const 1)
          )
        )
      )
    )
  )
)
;; CHECK-BIN-NODEBUG:      (data $0 (i32.const 1026) "\14\00")

;; CHECK-BIN-NODEBUG:      (table $0 10 funcref)

;; CHECK-BIN-NODEBUG:      (elem $0 (i32.const 0) $17 $0 $17 $17 $18 $18 $1 $18 $17 $15)

;; CHECK-BIN-NODEBUG:      (export "big_negative" (func $0))

;; CHECK-BIN-NODEBUG:      (func $0 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 f64)
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (f64.const -2147483648)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (f64.const -2147483648)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (f64.const -21474836480)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (f64.const 0.039625)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (f64.const -0.039625)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $3) (result f64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 f64)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block (result f64)
;; CHECK-BIN-NODEBUG-NEXT:   (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:    (f64.add
;; CHECK-BIN-NODEBUG-NEXT:     (f64.add
;; CHECK-BIN-NODEBUG-NEXT:      (f64.add
;; CHECK-BIN-NODEBUG-NEXT:       (f64.load
;; CHECK-BIN-NODEBUG-NEXT:        (i32.const 8)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:       (f64.load
;; CHECK-BIN-NODEBUG-NEXT:        (i32.const 16)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (f64.neg
;; CHECK-BIN-NODEBUG-NEXT:       (f64.load
;; CHECK-BIN-NODEBUG-NEXT:        (i32.const 16)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (f64.neg
;; CHECK-BIN-NODEBUG-NEXT:      (f64.load
;; CHECK-BIN-NODEBUG-NEXT:       (i32.const 8)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (if
;; CHECK-BIN-NODEBUG-NEXT:    (i32.gt_s
;; CHECK-BIN-NODEBUG-NEXT:     (i32.load
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 24)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (br $block
;; CHECK-BIN-NODEBUG-NEXT:      (f64.const -3.4)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (if
;; CHECK-BIN-NODEBUG-NEXT:    (f64.gt
;; CHECK-BIN-NODEBUG-NEXT:     (f64.load
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 32)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (f64.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (br $block
;; CHECK-BIN-NODEBUG-NEXT:      (f64.const 5.6)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (f64.const 1.2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $4) (param $0 f64) (param $1 f64) (result f64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $2 f64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $3 f64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $4 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block (result f64)
;; CHECK-BIN-NODEBUG-NEXT:   (if
;; CHECK-BIN-NODEBUG-NEXT:    (f64.gt
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:     (f64.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (br $block
;; CHECK-BIN-NODEBUG-NEXT:      (f64.const 1.2)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (if
;; CHECK-BIN-NODEBUG-NEXT:    (f64.gt
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $3)
;; CHECK-BIN-NODEBUG-NEXT:     (f64.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (br $block
;; CHECK-BIN-NODEBUG-NEXT:      (f64.const -3.4)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (if
;; CHECK-BIN-NODEBUG-NEXT:    (i32.gt_s
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $4)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (br $block
;; CHECK-BIN-NODEBUG-NEXT:      (f64.const 5.6)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (if
;; CHECK-BIN-NODEBUG-NEXT:    (f64.lt
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (then
;; CHECK-BIN-NODEBUG-NEXT:     (br $block
;; CHECK-BIN-NODEBUG-NEXT:      (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $3 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (i32.eq
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $4 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.add
;; CHECK-BIN-NODEBUG-NEXT:    (i32.add
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 313249263)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const -19088752)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $5 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 f64)
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (call $fimport$1
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $1
;; CHECK-BIN-NODEBUG-NEXT:   (f64.convert_i32_s
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $1
;; CHECK-BIN-NODEBUG-NEXT:   (f64.convert_i32_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.shr_u
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $6 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 f64)
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (f64.sub
;; CHECK-BIN-NODEBUG-NEXT:    (block (result f64)
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (f64.const 0.1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (f64.const 5.1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (block (result f64)
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (f64.const 3.2)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (f64.const 4.2)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $7 (type $6) (param $0 i32) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block3 (result i32)
;; CHECK-BIN-NODEBUG-NEXT:   (block
;; CHECK-BIN-NODEBUG-NEXT:    (block $block2
;; CHECK-BIN-NODEBUG-NEXT:     (block $block1
;; CHECK-BIN-NODEBUG-NEXT:      (block $block
;; CHECK-BIN-NODEBUG-NEXT:       (br_table $block $block1 $block2
;; CHECK-BIN-NODEBUG-NEXT:        (i32.sub
;; CHECK-BIN-NODEBUG-NEXT:         (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:         (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (br $block3
;; CHECK-BIN-NODEBUG-NEXT:       (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (br $block3
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (nop)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (block
;; CHECK-BIN-NODEBUG-NEXT:    (block $block5
;; CHECK-BIN-NODEBUG-NEXT:     (block $block4
;; CHECK-BIN-NODEBUG-NEXT:      (block $block6
;; CHECK-BIN-NODEBUG-NEXT:       (br_table $block4 $block5 $block5 $block5 $block5 $block5 $block5 $block6 $block5
;; CHECK-BIN-NODEBUG-NEXT:        (i32.sub
;; CHECK-BIN-NODEBUG-NEXT:         (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:         (i32.const 5)
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (br $block3
;; CHECK-BIN-NODEBUG-NEXT:       (i32.const 121)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (br $block3
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 51)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (nop)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (block $block12
;; CHECK-BIN-NODEBUG-NEXT:    (block $block8
;; CHECK-BIN-NODEBUG-NEXT:     (block $block7
;; CHECK-BIN-NODEBUG-NEXT:      (block $block9
;; CHECK-BIN-NODEBUG-NEXT:       (block $block10
;; CHECK-BIN-NODEBUG-NEXT:        (block $block11
;; CHECK-BIN-NODEBUG-NEXT:         (br_table $block7 $block8 $block8 $block9 $block8 $block8 $block8 $block8 $block10 $block8 $block11 $block8
;; CHECK-BIN-NODEBUG-NEXT:          (i32.sub
;; CHECK-BIN-NODEBUG-NEXT:           (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:           (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:          )
;; CHECK-BIN-NODEBUG-NEXT:         )
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:        (br $block12)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:       (br $block12)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (block $block13
;; CHECK-BIN-NODEBUG-NEXT:       (loop
;; CHECK-BIN-NODEBUG-NEXT:        (br $block13)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:       (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (block
;; CHECK-BIN-NODEBUG-NEXT:      (loop
;; CHECK-BIN-NODEBUG-NEXT:       (br $block12)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (nop)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $8 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block
;; CHECK-BIN-NODEBUG-NEXT:   (br $block)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $9 (type $3) (result f64)
;; CHECK-BIN-NODEBUG-NEXT:  (call $fimport$2
;; CHECK-BIN-NODEBUG-NEXT:   (f64.const 5.5)
;; CHECK-BIN-NODEBUG-NEXT:   (f64.const 1.2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $10 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (i32.and
;; CHECK-BIN-NODEBUG-NEXT:    (i32.div_u
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const -1)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const -1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $11 (type $2) (param $0 f32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 f32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $2 f64)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.demote_f64
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $2)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.const 5)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.const 5)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (f32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $12 (type $3) (result f64)
;; CHECK-BIN-NODEBUG-NEXT:  (f64.const -0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $13 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $2 f64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $3 f32)
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:    (local.set $1
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (select
;; CHECK-BIN-NODEBUG-NEXT:     (i32.sub
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:      (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.lt_s
;; CHECK-BIN-NODEBUG-NEXT:      (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:      (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $2
;; CHECK-BIN-NODEBUG-NEXT:   (f64.abs
;; CHECK-BIN-NODEBUG-NEXT:    (f64.const 0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $3
;; CHECK-BIN-NODEBUG-NEXT:   (f32.abs
;; CHECK-BIN-NODEBUG-NEXT:    (f32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $14 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 f32)
;; CHECK-BIN-NODEBUG-NEXT:  (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:   (f32.neg
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $2)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.add
;; CHECK-BIN-NODEBUG-NEXT:    (i32.and
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 7)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 8)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $15 (type $2) (param $0 f32)
;; CHECK-BIN-NODEBUG-NEXT:  (call_indirect $0 (type $2)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (i32.add
;; CHECK-BIN-NODEBUG-NEXT:    (i32.and
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 7)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 8)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $16 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.gt_u
;; CHECK-BIN-NODEBUG-NEXT:    (i32.shr_u
;; CHECK-BIN-NODEBUG-NEXT:     (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const -4096)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $17 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (nop)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $18 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (nop)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $19 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block
;; CHECK-BIN-NODEBUG-NEXT:   (drop
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (br $block)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $20 (type $7) (param $0 f64) (result f64)
;; CHECK-BIN-NODEBUG-NEXT:  (loop (result f64)
;; CHECK-BIN-NODEBUG-NEXT:   (drop
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $21 (type $8) (result i64)
;; CHECK-BIN-NODEBUG-NEXT:  (i64.const -9218868437227405313)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $22 (type $9) (param $0 i32) (param $1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (i64.store32
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $23 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (return
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $24 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (return
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $25 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (return
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $26 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (return
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $27 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (return
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $28 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block
;; CHECK-BIN-NODEBUG-NEXT:   (drop
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (br $block)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $29 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (if
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 3)
;; CHECK-BIN-NODEBUG-NEXT:   (then
;; CHECK-BIN-NODEBUG-NEXT:    (return
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (else
;; CHECK-BIN-NODEBUG-NEXT:    (return
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $30 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (if
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 3)
;; CHECK-BIN-NODEBUG-NEXT:   (then
;; CHECK-BIN-NODEBUG-NEXT:    (return
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 2)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (else
;; CHECK-BIN-NODEBUG-NEXT:    (return
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $31 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (loop
;; CHECK-BIN-NODEBUG-NEXT:   (nop)
;; CHECK-BIN-NODEBUG-NEXT:   (return
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $32 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (loop
;; CHECK-BIN-NODEBUG-NEXT:   (return
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $33 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (loop
;; CHECK-BIN-NODEBUG-NEXT:   (nop)
;; CHECK-BIN-NODEBUG-NEXT:   (return
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $34 (type $0) (result i32)
;; CHECK-BIN-NODEBUG-NEXT:  (loop
;; CHECK-BIN-NODEBUG-NEXT:   (return
;; CHECK-BIN-NODEBUG-NEXT:    (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $35 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $36 (type $1)
;; CHECK-BIN-NODEBUG-NEXT:  (if
;; CHECK-BIN-NODEBUG-NEXT:   (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:   (then
;; CHECK-BIN-NODEBUG-NEXT:    (nop)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (else
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )
